
/*  @(#)ctl.h 1.2 94/01/20
 *
 *  Describes the structure that reve and reved pass back and forth.
 *
 *  Copyright (C) 1990 - 1994 - Rich Burridge & Yves Gallot.
 *  All rights reserved.
 *
 *  Permission is granted to copy this source, for redistribution
 *  in source form only, provided the news headers in "substantially
 *  unaltered format" are retained, the introductory messages are not
 *  removed, and no monies are exchanged.
 *
 *  Permission is also granted to copy this source, without the
 *  news headers, for the purposes of making an executable copy by
 *  means of compilation, provided that such copy will not be used
 *  for the purposes of competition in any othello tournaments, without
 *  prior permission from the authors.
 *
 *  No responsibility is taken for any errors on inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file), then an attempt will be made to fix them.
 */

#define  CTL_WAIT           2     /* The amount of time to wait for a
                                     response, in seconds. */
#define  MAX_LIFE           60    /* Maximum time an invitation is saved
                                     by the Reve daemons. */
#define  MSG_INTERVAL       4
#define  NAME_SIZE          9
#define  RING_WAIT          30    /* Time to wait before refreshing invitation
                                     should be 10's of seconds less than
                                     MAX_LIFE */
#define  TTY_SIZE           16
 
#define  LEAVE_INVITE       0     /* The values for type. */
#define  LOOK_UP            1
#define  DELETE             2
#define  ANNOUNCE           3     /* The values for type. */

#define  SUCCESS            0     /* The values for answer. */
#define  NOT_HERE           1
#define  FAILED             2
#define  MACHINE_UNKNOWN    3
#define  PERMISSION_DENIED  4
#define  UNKNOWN_REQUEST    5

typedef struct ctl_response CTL_RESPONSE ;
 
struct ctl_response {
  char type ;
  char answer ;
  int id_num ;
  enum disp_type dtype ;
  struct sockaddr_in addr ;
} ;
 
typedef struct ctl_msg CTL_MSG ;
 
struct ctl_msg {
  char type ;
  char l_name[NAME_SIZE] ;
  char r_name[NAME_SIZE] ;
  int id_num ;
  int pid ;
  enum disp_type dtype ;
  char r_tty[TTY_SIZE] ;
  struct sockaddr_in addr ;
  struct sockaddr_in ctl_addr ;
} ;
