P /*------------------------------------------------------------------------------K  *   PERF_METER.C - Performance Meter display for DECwindows Motif, OpenVMS   *
  *   History:   *'  *	V01-001		Robert Heller			08-Nov-1989 '  *		Created on Wed Nov  8 10:39:17 1989 (  *	V01-002		Mark Pizzolato			22-Nov-19891  *		mark@infopiz.uucp (uunet!lupine!infopiz!mark) '  *	V01-003		Robert Heller			27-Nov-1989   *		Fixed for invert displays ?  *		Modified to use set_label in place of certain set_something ,  *		calls and new version of init_cpu_times.  *0  *	V01-004		Phil Ottewell/Tony Davis	19-OCT-1992;  *		Modified to use UIL/Motif toolkit instead of DECwindows   *'  *	V02-000		Phil Ottewell			27-NOV-1992 4  *		Modified to use different colours for CPU modes,9  *		use a decent icon, and allow more user configuration.   *7  *	V02-001		Joe Kazimierczyk (kaz@bms.com)	14-FEB-1993  B  *		Plugged memory leak caused by calls to DwtLatin1String without  *		corresponding XtFree(). 5  *		Added 'top process' info to bottom of main window <  *		Added toggle button to create a 'show process/cont' type(  *		display for the current top process.>  *		Moved exit button to a popup menu instead of the menu bar,  *		to save display space.  *(  *	V02-000-A	Phil Ottewell			20-JAN-1993"  *		Modified V2.0 to work on Alpha  *'  *	V02-002		Phil Ottewell			01-MAY-1995 -  *		Modified to work with DEC C and Motif 1.2 ,  *		without having to specify /STANDARD=VAXC8  *		Merged Joe Kazimierczyk V2.1 changes in to V02-000-A  *C  *      v02-002-a       Dean Schamberger                20-may-1995 N  *              Modified to protect against setting update interval to 0 secs.A  *              Also updated .UIL to allow up to 4 devices again, I  *              and set the default to a blank line.  Added fix to device F  *              name string to keep columns aligned, and forced TOPcpuH  *              process to stay a fixed length.  This fixed some strangeI  *              redraws on some x-terminals.  Finally added the option to G  *              compile a non-priv version that can still see CPU users F  *              (ie.  does not need CMKRNL privs like in version 2.0).D  *              The default is not to need CMKRNL.  To return to the9  *		previous mode, comment out the define NON_PRIV_USERS. 5  *		(no longer quite true - see V02-003 below - P.O.) ;  *		This only effects CPU states and usage, one still needs   *		privs to see max cpu user.'  *	V02-003		Phil Ottewell			01-MAY-1995 A  *		Fix memory leak caused byXmStringLtoRCreate (Motif pre 1.2-3) C  *		by using XmStringCreateSimple instead. The NON_PRIV_USER option B  *		has been taken out, and the VAX version builds without callingA  *		sys$cmkrnl, whereas the Alpha version HAS to get the CPU info D  *		with kernel mode access. An informational message to this effect7  *		is now issued by the MAKE_PERF_METER.COM procedure. '  *	V02-004		Phil Ottewell			22-MAR-1997 @  *		Fix memory leak in TOPPROC.C, set icon properly, remove someB  *              redundant variables. Remove more global variables,6  *              add a free memory/tital memory display  *              P  *----------------------------------------------------------------------------*/   /* ANSI C headers */ #include <stdio.h> #include <stdlib.h>  #include <ctype.h>   /* VMS headers */  #include <descrip.h> #include <dvidef.h>  #include <jpidef.h>  #include <ssdef.h> #include <starlet.h> #include <syidef.h>    /* Local headers */  #ifdef __ALPHA #include "cpudef_alpha.h"  #else  #include "cpudef.h"  #endif #include "perf_meter_const.h"    /* X Toolkit header */ #include <X11/Intrinsic.h>9 /* Motif general header (includes most Xlib stuff too) */  #include <Xm/Xm.h> /* Other Motif headers */  #include <Xm/RowColumn.h>  /* Motif Resource Manager*/  #include <Xm/MrmAppl.h>    /* #defines go here */  5 #define PROGRAM_TITLE_FORMAT "%s, %s, VMS %s, %d Meg" ( #define PROGRAM_NAME         "PerfMeter"" #define PROGRAM_VERSION      "2.4"   #define MX_STATES 7    #define PARAM_STRING 0 #define PARAM_INTEGER 1  #ifdef __ALPHA #define K_TIME 0 #define E_TIME 2 #define S_TIME 4 #define U_TIME 6 #define I_TIME 8 #define C_TIME 0 #define SPIN_TIME 10 #define IDLE_TIME 12 #else  #define K_TIME 0 #define E_TIME 1 #define S_TIME 2 #define U_TIME 3 #define I_TIME 4 #define C_TIME 5 #define SPIN_TIME 6  #define IDLE_TIME 7  #endif   /* Global references */ 
 #ifdef __DECC  #  pragma message save% #  pragma message disable (GLOBALEXT)  #endif$ globalref long   EXE$GL_ABSTIM_TICS;$ globalref long   SMP$GL_ACTIVE_CPUS;$ globalref $CPU*  SMP$GL_CPU_DATA[1]; globalref long   PMS$GL_FAULTS;  globalref long   PMS$GL_PREADS;   globalref long   PMS$GL_PREADIO;  globalref long   PMS$GL_PWRITES;  globalref long   PMS$GL_PWRITIO;! globalref long   PMS$GL_DZROFLTS;   globalref long   SCH$GL_FREECNT; globalref long   SCH$GL_MFYCNT; - #if defined(__VAX) && (__VMS_VER < 60000000)   globalref long   MMG$GL_MAXMEM;  #endif
 #ifdef __DECC  #  pragma message restore  #endif* #define CURRENT_FAULTS     (PMS$GL_FAULTS)< #define CURRENT_PAGEIO     (PMS$GL_PREADIO + PMS$GL_PWRITIO)+ #define CURRENT_FREEPAGES  (SCH$GL_FREECNT) * #define CURRENT_MODPAGES   (SCH$GL_MFYCNT)   /* Function prototypes */ # void s_error(char* problem_string); = void get_something(Widget w, char* resource, XtArgVal value); = void set_something(Widget w, char* resource, XtArgVal value);   O void activate_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s); M void create_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s); M void cancel_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s); 0 void update( XtPointer data, XtIntervalId *id );  M void create_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s); O void exposure_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s); 9 void update_contproc( XtPointer data, XtIntervalId *id ); \ void toggle_contproc(Widget w, XtPointer client_data, XmToggleButtonCallbackStruct *toggle); void contproc_on(void);  void contproc_off(void);% void contproc_jpi_status(int status); 7 void doMainPopupMenu(Widget wdgt,XtPointer client_data, 8                      XEvent *event, Boolean *propogate);  3 void DrawStateGraph( Display *dpy, Window window ); 6 void DrawStateBar( Display *dpy, Window window, GC gc,+        int iWindowWidth, int iWindowHeight, I        int iLValue, int iLX, int iLBarWidth, int iLWidth, int iLHeight );    int initialize_topproc(void);  int get_topproc(void); char *format_topproc(int top); int topproc_getPID(int top);  % void format_cputime (int t, char *s);   " void get_initial_kernelly_stuff(); void get_new_kernelly_stuff();   void init_cpu_times();C void get_cpu_times(long* null, long* user, long* super, long* exec, @                    long* kernel, long* interrupt, long* compat);@ void get_disk_opcnt(register long devnum, register long* count);3 void update_disk_name_label(Widget w, long devnum);   T GC MakeGC(Display* disp, Window wind, long fun, Pixel background, Pixel foreground);   Window GetIconWindow( void ); 4 Window MakeIconWindow( Widget shell, Pixmap pxmap );H void SetIconPixmap( Widget shell, Pixmap pxmap, Bool want_icon_window );   /* Macros */* #define FAILED(status) (((status)&1) == 0) #define SIGNAL_ERROR(status)  \      {                         \        int ___status = status; \        if (FAILED(___status))  \        lib$signal(___status);  \      }   $ #define MAX_WIDGETS (MAX_WIDGET + 1)  K /* Macro to load up an element of a resource list for a resource enquiry */ @ #define PFM_LOAD_RESOURCE(res,rname,rclass,rtype,rsize,roffset,\.                           defrtype,defraddr) \ { \ K XtResource *_resptr = &(res); /* Only dereference actual resource once */ \ # _resptr->resource_name = (rname); \ % _resptr->resource_class = (rclass); \ # _resptr->resource_type = (rtype); \ # _resptr->resource_size = (rsize); \ ' _resptr->resource_offset = (roffset); \ % _resptr->default_type = (defrtype); \ % _resptr->default_addr = (defraddr); \  }    /* Global variables */  D typedef struct _vms_item_list {		/* Useful for creating item lists*/9     short	 buffer_length;		/* for system service calls */      short	 item_code;      void	*buffer;       int	*returned_buffer_length;     } VMS_ItemList;     static XtAppContext app_context;  ) static Pixel state_colour_pxl[MX_STATES]; 3 static char *state_colour_suggestion[MX_STATES] = {    "YellowGreen",/* Null */0   "Lightgrey",  /* Compatibility - never seen */   "Black",      /* User mode */ %   "Blue",       /* Supervisor mode */ $   "Yellow",     /* Executive mode */!   "Orange",     /* Kernel mode */ $   "Red"         /* Interrupt mode */ };6 static char *state_colour_resource_name[MX_STATES] = {   "nullColour",     /* Null */4   "compColour",     /* Compatibility - never seen */#   "userColour",     /* User mode */ )   "superColour",    /* Supervisor mode */ (   "execColour",     /* Executive mode */%   "kernelColour",   /* Kernel mode */ (   "intColour"       /* Interrupt mode */ };7 static char *state_colour_resource_class[MX_STATES] = {    "NullColour",     /* Null */4   "CompColour",     /* Compatibility - never seen */#   "UserColour",     /* User mode */ )   "SuperColour",    /* Supervisor mode */ (   "ExecColour",     /* Executive mode */%   "KernelColour",   /* Kernel mode */ (   "IntColour"       /* Interrupt mode */ };  5 static char  *good_colour_suggestion = "ForestGreen"; , static char  *bad_colour_suggestion = "Red";3 static char  *neutral_colour_suggestion = "Yellow"; A static Pixel good_colour_pxl, bad_colour_pxl, neutral_colour_pxl;   = static Widget main_popup_wdgt;       /* The popup exit box */ E static Widget contproc_wdgt;         /* The show proc/cont display */ B static Widget generic_message_wdgt;  /* generic message box     */B static Widget generic_caution_wdgt;  /* generic caution box     */B static Widget generic_wip_wdgt;      /* generic WIP box         */P static Widget widget_array[MAX_WIDGETS]; /* Place to keep all other widget IDs*/  ) static GC        cpu_graph_gc[MX_STATES]; + static GC        state_graph_gc[MX_STATES]; B static GC        good_colour_gc, bad_colour_gc, neutral_colour_gc;  P static XtIntervalId contproc_IntervalId;  /* timeout interval id for contproc */L static int topproc;                       /* index into top process array */F static int topPID;                        /* PID of the top process */L static unsigned int timelast;             /* sys time for contproc update */  @ static Position contproc_x =  50;    /* Initial location of.. */> static Position contproc_y =  50;    /*  ..cont proc window */N static int contproc_update_int;      /* Contproc updates every .. millisecs */  @ static Position main_xpos = 856;     /* Initial location of.. */= static Position main_ypos =  36;     /*  ..the main window */ I static int main_update_secs = 5;     /* Update secs from resource file */ Q static int main_update_int;          /* Main window updates every .. millisecs */   K static long  last_user, last_super, last_exec, last_kernel, last_interrupt; / static long  last_compat, last_spin, last_idle;    static long  new_null;F static long  new_user, new_super, new_exec, new_kernel, new_interrupt;, static long  new_compat, new_idle, new_spin;  D static long total_time,NullTime,UserTime,SupeTime,ExecTime,KernTime,&             InteTime,CompTime,DeltaIO;  $ /* Used for the contproc routines */8 static long NewDirIO, DirIO, DeltaDirIO, LastDeltaDirIO;8 static long NewBufIO, BufIO, DeltaBufIO, LastDeltaBufIO;< static long NewPpgcnt, Ppgcnt, DeltaPpgcnt, LastDeltaPpgcnt;< static long NewGpgcnt, Gpgcnt, DeltaGpgcnt, LastDeltaGpgcnt;D static long NewPageflts, Pageflts, DeltaPageflts, LastDeltaPageflts;< static long NewCputim, Cputim, DeltaCputim, LastDeltaCputim;< static long NewWSSize, WSSize, DeltaWSSize, LastDeltaWSSize;@ static long NewPgfluse, Pgfluse, DeltaPgfluse, LastDeltaPgfluse;  & static int CPUPercent[MX_STATES][101];# static int CPUbase[MX_STATES][101];   ? static long Device_0_IO, Device_1_IO, Device_2_IO, Device_3_IO;   @ static long PageFaults, PageIO, FreePages, ModPages, TotalPages;  J /* The names and addresses of things that MrM has to bind. The names do */* /* not have to be in alphabetical order */# static MrmRegisterArg reglist[] = { 0   {"activate_proc",  (XtPointer) activate_proc},.   {"create_proc",    (XtPointer) create_proc},.   {"cancel_proc",    (XtPointer) cancel_proc},0   {"exposure_proc",  (XtPointer) exposure_proc},1   {"toggle_contproc",(XtPointer) toggle_contproc}  };< static int reglist_num = (sizeof reglist/sizeof reglist[0]);  P /*----------------------------------------------------------------------------*/P /* Main Program                                                               */P /*----------------------------------------------------------------------------*/
 #ifdef VMS #  ifdef __DECC  #    pragma message save) #    pragma message disable (MAINPROGEXT)  #  endif  ! PerfMeter(int argc, char *argv[])  MAIN_PROGRAM   #  ifdef __DECC  #    pragma message restore  #  endif #else   9 int main(int argc, char *argv[]) /* Standard C version */    #endif { $     Bool IsColour, want_icon_window;     static char string[128];+     static unsigned short nlen, mlen, vlen;      XIconSize *icon_size_list;)     int i, icon_size_count, x_hot, y_hot; <     int update_delay = 2; /* Contproc updates every 2 sec */     GC gctemp;#     Pixel icon_fg_pxl, icon_bg_pxl; $     Pixmap icon_bitmap, icon_pixmap;(     unsigned int icon_width,icon_height;7     static char vmsversion[8], model[32], nodename[16];      static long PageSize;      long status, MegaBytes;      struct {       unsigned short bufLen;       unsigned short itemCode;       void *bufAddr;        unsigned short *returnLen;H     } syi_itmlst[] = { {sizeof(nodename)-1,SYI$_SCSNODE,nodename,&nlen},. #if defined(ALPHA) || (__VMS_VER >= 60000000) J                        {sizeof(TotalPages),SYI$_MEMSIZE,&TotalPages,NULL}, #endifL                        {sizeof(vmsversion)-1,SYI$_VERSION,vmsversion,&vlen},B                        {sizeof(model)-1,SYI$_HW_NAME,model,&mlen},H                        {sizeof(PageSize),SYI$_PAGE_SIZE,&PageSize,NULL},,                        {0, 0, NULL, NULL} };     union {        char *string_ptr;        Bool bool;
     } urs;!     XtResource ursl[MX_STATES+1]; C     MrmHierarchy  s_MrmHierarchy;   /* MrM database hierarchy ID */ =     MrmType dummy_class;            /* and class variable. */ G     char* db_filename_vec[] =             /* MrM heirachy file list. */ N                {"PFM$DATA:perf_meter.uid" /* There is only one UID file for */A                };                         /* this application. */ M     int db_filename_num = sizeof(db_filename_vec)/sizeof(db_filename_vec[0]);      Window root_win;     Display *dpy;      Screen  *screen;+     Widget toplevel_wdgt, main_window_wdgt;  /*  End of declarations ... */  * /*  Get nodename and Total System Memory*/1     status = sys$getsyiw(0,0,0,syi_itmlst,0,0,0); )     if ( FAILED(status) ) PageSize = 512; K     for (i = nlen; (i >= 0) && (nodename[i] == ' ' || !nodename[i] ); i--);      nodename[++i] = '\0'; E     for (i = mlen; (i >= 0) && (model[i] == ' ' || !model[i] ); i--);      model[++i] = '\0';O     for (i = vlen; (i >= 0) && (vmsversion[i] == ' ' || !vmsversion[i] ); i--);      vmsversion[++i] = '\0';      - #if defined(__VAX) && (__VMS_VER < 60000000)  J /*  Following is a kludge to avoid doing any hard work on 5.5-2 systems */3 /*  The MMG$GL_MAXMEM under reads a small amount */ O /*  but if we assume this is less than 1 Meg we can just add 1 to the answer */      TotalPages = MMG$GL_MAXMEM; ,     MegaBytes = (TotalPages*PageSize) >> 20;     MegaBytes += 1;  #else ,     MegaBytes = (TotalPages*PageSize) >> 20; #endif  7 /*  Initialize MrM before initializing the X Toolkit */      MrmInitialize();  K /*  If we had user-defined widgets, we would register them with MrM here */   E /*  Initialize the X Toolkit. We get back a top level shell widget */ >     toplevel_wdgt = XtAppInitialize(&app_context,PROGRAM_NAME,>                                     (XrmOptionDescList)NULL,0,P                                     &argc,(String*)argv,(String*)NULL,  NULL,0);   /*  Get the X server display */-#     dpy = XtDisplay(toplevel_wdgt);   L /*  Force synchronization of ALL X calls (use ONLY for DEBUG - very slow) */ /*    XSynchronize(dpy,TRUE);*/N  # /*  Find screen for this display */3%     screen = XtScreen(toplevel_wdgt);	  + /*  Find the root window for this screen */n+     root_win = XRootWindowOfScreen(screen);	  ? /*  Check if we are on a colour or grey-scale system, or B+w */eA     if ( ( (XDefaultVisualOfScreen(screen)->class != PseudoColor)oA         && (XDefaultVisualOfScreen(screen)->class != DirectColor)C?         && (XDefaultVisualOfScreen(screen)->class != TrueColor)wD         && (XDefaultVisualOfScreen(screen)->class != GrayScale) ) ||         (argc > 1) ) {       IsColour = FALSE;t     } else {       IsColour = TRUE;     }*       if (IsColour) {i@ /*    Create the colours for positive and negative increments */:       PFM_LOAD_RESOURCE(ursl[0],"goodColour","GoodColour",=                           XtRPixel,sizeof(Pixel),0,XtRString, 2                           good_colour_suggestion);N       XtGetApplicationResources(toplevel_wdgt,&good_colour_pxl,ursl,1,NULL,0);  8       PFM_LOAD_RESOURCE(ursl[0],"badColour","BadColour",=                           XtRPixel,sizeof(Pixel),0,XtRString,V1                           bad_colour_suggestion);	M       XtGetApplicationResources(toplevel_wdgt,&bad_colour_pxl,ursl,1,NULL,0);i@       PFM_LOAD_RESOURCE(ursl[0],"neutralColour","NeutralColour",=                           XtRPixel,sizeof(Pixel),0,XtRString,g5                           neutral_colour_suggestion);dQ       XtGetApplicationResources(toplevel_wdgt,&neutral_colour_pxl,ursl,1,NULL,0);d  . /*    Get colour for icon pixmap foreground */B       PFM_LOAD_RESOURCE(ursl[0],"iconForeground","IconForeground",=                           XtRPixel,sizeof(Pixel),0,XtRString,O'                           "LightGrey");iJ       XtGetApplicationResources(toplevel_wdgt,&icon_fg_pxl,ursl,1,NULL,0);B       PFM_LOAD_RESOURCE(ursl[0],"iconBackground","IconBackground",=                           XtRPixel,sizeof(Pixel),0,XtRString,.#                           "Linen");vJ       XtGetApplicationResources(toplevel_wdgt,&icon_bg_pxl,ursl,1,NULL,0);     } else {4       good_colour_pxl = XBlackPixelOfScreen(screen);3       bad_colour_pxl = XBlackPixelOfScreen(screen); 7       neutral_colour_pxl = XBlackPixelOfScreen(screen);e     }*  / /*  Find the colours for different CPU modes */w%     for (i = 0; i < MX_STATES; i++) {        if (IsColour) {e@         PFM_LOAD_RESOURCE(ursl[i],state_colour_resource_name[i],9                           state_colour_resource_class[i], M                           XtRPixel,sizeof(Pixel),(i*sizeof(Pixel)),XtRString,A6                           state_colour_suggestion[i]);       } else {:         state_colour_pxl[i] = XBlackPixelOfScreen(screen);       }o     } K     if (IsColour) XtGetApplicationResources(toplevel_wdgt,state_colour_pxl, C                                             ursl,MX_STATES,NULL,0);R   /*  Set title bar */M     sprintf(string,PROGRAM_TITLE_FORMAT,nodename,model,vmsversion,MegaBytes); ;     set_something(toplevel_wdgt,XmNtitle,(XtArgVal)string);-   /*  Set icon name */F     sprintf(string,"%s %s V%s",nodename,PROGRAM_NAME,PROGRAM_VERSION);>     set_something(toplevel_wdgt,XmNiconName,(XtArgVal)string);  N /*  Get preferred icon size and pick biggest of 48, 50 or 64 width pictures */N     if ( !XGetIconSizes( dpy, root_win, &icon_size_list, &icon_size_count) ) { /*    No preferred size */7       sprintf(string,"PFM$DATA:PERF_METER_ICON64.XBM");k     } else { /*    Use preferred size */*-       if ( icon_size_list->max_width < 64 ) { /         if ( icon_size_list->max_width < 50 ) {e;           sprintf(string,"PFM$DATA:PERF_METER_ICON48.XBM");*         } else {;           sprintf(string,"PFM$DATA:PERF_METER_ICON50.XBM");_	         }        } else {9         sprintf(string,"PFM$DATA:PERF_METER_ICON64.XBM");G       }O     }"$ /*  Create and set an icon bitmap */>     if ( BitmapSuccess == XReadBitmapFile(dpy,root_win,string,C                                           &icon_width,&icon_height,dI                                           &icon_bitmap,&x_hot,&y_hot) ) {2H       gctemp = MakeGC( dpy, root_win, GXcopy, icon_bg_pxl, icon_fg_pxl);I       icon_pixmap = XCreatePixmap( dpy, root_win, icon_width,icon_height,DC                                    XDefaultDepthOfScreen(screen) );a? /*    Now copy 1-plane pixmap (icon_bitmap) to normal pixmap */ =       XCopyPlane( dpy, icon_bitmap, icon_pixmap, gctemp, 0,0,C0                   icon_width,icon_height,0,0,1);#       XFreePixmap(dpy,icon_bitmap);b       XFreeGC(dpy,gctemp);  E /*    Create an icon, and if required create a dynamic icon window */b@       PFM_LOAD_RESOURCE(ursl[0],"useIconWindow","UseIconWindow",C                           XtRBool,sizeof(Bool),0,XtRString,"True");iO       XtGetApplicationResources(toplevel_wdgt,&want_icon_window,ursl,1,NULL,0);eD       SetIconPixmap( toplevel_wdgt, icon_pixmap, want_icon_window );     }L  K /*  Open the UID files (the output of the UIL compiler) in the hierarchy */IK     if (MrmOpenHierarchy(db_filename_num, /* Number of files.            */ K                          db_filename_vec, /* Array of file names.        */rK                          NULL,            /* Default OS extenstion.      */sK                          &s_MrmHierarchy) /* Pointer to returned MrM ID  */c         != MrmSUCCESS) {&       s_error("can't open hierarchy");     }t  ) /*  Initialize various data structures */C     init_cpu_times();      initialize_topproc();X  2 /*  Register the items MrM needs to bind for us */+     MrmRegisterNames(reglist, reglist_num);;  . /*  Go get the main part of the application */H     if (MrmFetchWidget(s_MrmHierarchy, "PERF_METER_MAIN", toplevel_wdgt,F                        &main_window_wdgt, &dummy_class) != MrmSUCCESS)+         s_error("can't fetch main window");t  # /*  Get the sho proc/cont widget */mI     if (MrmFetchWidget(s_MrmHierarchy, "CONTPROC_MAIN", main_window_wdgt,oC                        &contproc_wdgt, &dummy_class) != MrmSUCCESS)p-         s_error("can't fetch contproc_wdgt");   N /*  Manage main window,realize everything. Interface appears on the display */$     XtManageChild(main_window_wdgt);  A /*  Get the user specified resources from the default database */i   /*  Main window */#     sprintf(string,"%d",main_xpos);i,     PFM_LOAD_RESOURCE(ursl[0],"xpos","Xpos",I                         XtRPosition,sizeof(Position),0,XtRString,string);pF     XtGetApplicationResources(toplevel_wdgt,&main_xpos,ursl,1,NULL,0);#     sprintf(string,"%d",main_ypos);(,     PFM_LOAD_RESOURCE(ursl[0],"ypos","Ypos",I                         XtRPosition,sizeof(Position),0,XtRString,string);gF     XtGetApplicationResources(toplevel_wdgt,&main_ypos,ursl,1,NULL,0);0     set_something(toplevel_wdgt,XmNx,main_xpos);0     set_something(toplevel_wdgt,XmNy,main_ypos);  *     sprintf(string,"%d",main_update_secs);<     PFM_LOAD_RESOURCE(ursl[0],"UpdatePeriod","UpdatePeriod",=                       XtRInt,sizeof(int),0,XtRString,string);dM     XtGetApplicationResources(toplevel_wdgt,&main_update_secs,ursl,1,NULL,0);lE     main_update_secs = (main_update_secs > 1) ? main_update_secs : 1;&,     main_update_int = main_update_secs*1000;   /*  ContProc window */$     sprintf(string,"%d",contproc_x);8     PFM_LOAD_RESOURCE(ursl[0],"contproc_x","ContProc_x",I                         XtRPosition,sizeof(Position),0,XtRString,string);oG     XtGetApplicationResources(toplevel_wdgt,&contproc_x,ursl,1,NULL,0);F$     sprintf(string,"%d",contproc_y);8     PFM_LOAD_RESOURCE(ursl[0],"contproc_y","ContProc_y",I                         XtRPosition,sizeof(Position),0,XtRString,string);uG     XtGetApplicationResources(toplevel_wdgt,&contproc_y,ursl,1,NULL,0);l1     set_something(contproc_wdgt,XmNx,contproc_x);)1     set_something(contproc_wdgt,XmNy,contproc_y);-  &     sprintf(string,"%d",update_delay);L     PFM_LOAD_RESOURCE(ursl[0],"ContProcUpdatePeriod","ContProcUpdatePeriod",?                         XtRInt,sizeof(int),0,XtRString,string);fI     XtGetApplicationResources(toplevel_wdgt,&update_delay,ursl,1,NULL,0);i9     update_delay = (update_delay > 1) ? update_delay : 1; ,     contproc_update_int = update_delay*1000;  #     XtRealizeWidget(toplevel_wdgt);x  0 /*  Get windows and set up GCs for the graphs */%     for (i = 0; i < MX_STATES; i++) {TI       cpu_graph_gc[i] = MakeGC(dpy,XtWindow(widget_array[PFM_CPU_GRAPH]),nP                         GXcopy,XWhitePixelOfScreen(screen),state_colour_pxl[i]);     } %     for (i = 0; i < MX_STATES; i++) {OM       state_graph_gc[i] = MakeGC(dpy,XtWindow(widget_array[PFM_STATE_GRAPH]),cP                         GXcopy,XWhitePixelOfScreen(screen),state_colour_pxl[i]);     }C0     good_colour_gc = MakeGC(dpy,root_win,GXcopy,I                             XWhitePixelOfScreen(screen),good_colour_pxl); 0     XSetArcMode(dpy,good_colour_gc,ArcPieSlice);/     bad_colour_gc = MakeGC(dpy,root_win,GXcopy, G                            XWhitePixelOfScreen(screen),bad_colour_pxl);_/     XSetArcMode(dpy,bad_colour_gc,ArcPieSlice);C3     neutral_colour_gc = MakeGC(dpy,root_win,GXcopy,UK                            XWhitePixelOfScreen(screen),neutral_colour_pxl); 3     XSetArcMode(dpy,neutral_colour_gc,ArcPieSlice);l  # /*  Get the sho proc/cont widget */rF     if (MrmFetchWidget(s_MrmHierarchy, "MAIN_POPUP", main_window_wdgt,E                        &main_popup_wdgt, &dummy_class) != MrmSUCCESS)c/         s_error("can't fetch main_popup_wdgt");t  " /*  Hook up the main popup menu */;     XtAddEventHandler(main_window_wdgt, ButtonPressMask, 0, 8                       doMainPopupMenu, main_popup_wdgt);  N /*  Add timeout callback that will be called every main_update_secs seconds */:     XtAppAddTimeOut( app_context, main_update_int, update,N                      (XtPointer)widget_array[PFM_CPU_GRAPH]/* client data */);  ) /*  Enter the continous event loop ... */g     XtAppMainLoop(app_context);o }e lP /*----------------------------------------------------------------------------*/P /* Error reporter - All errors are fatal.                                     */P /*----------------------------------------------------------------------------*/" void s_error(char* problem_string) {  /*  End of declarations ... */#     printf("%s\n", problem_string);t     exit(EXIT_FAILURE);  }  PP /*----------------------------------------------------------------------------*/P /* Simplified SET VALUE routine to use only when changing a single attribute. */P /* If we need to change more than one, all new values should be put into one  */P /* arglist and we should make one XtSetValues call (MUCH more efficient).     */P /*----------------------------------------------------------------------------*/< void set_something(Widget w, char* resource, XtArgVal value) {      Arg al[1]; /*  End of declarations ... */  %     XtSetArg(al[0], resource, value);a     XtSetValues(w, al, 1); }i sP /*----------------------------------------------------------------------------*/P /* Simplified SET VALUE routine to use only when changing a label widget's    */P /* label string.  Does a Latin1 String and frees the compound string after    */P /* setting label value                                                        */P /*----------------------------------------------------------------------------*/% void set_label(Widget w, char* value)r {      Arg al[1];     XmString latin_label;l /*  End of declarations ... */  .     latin_label = XmStringCreateSimple(value);1     XtSetArg(al[0], XmNlabelString, latin_label);,     XtSetValues(w, al, 1);     XmStringFree(latin_label); },  3 /*  Set label widget using index in widget array */n+ void set_label_str (char *value, int w_idx)u {;     Arg al[1];     XmString CStr; /*  End of declarations ... */'     CStr = XmStringCreateSimple(value);,*     XtSetArg(al[0], XmNlabelString, CStr);,     XtSetValues(widget_array[w_idx], al, 1);     XmStringFree(CStr);e }e IP /*----------------------------------------------------------------------------*/P /* process_num() handles all of the repetitive stuff needed to track          */P /* what's changed from update to update.  We also update the widget           */P /* label if something has changed since the last time.                        */P /*----------------------------------------------------------------------------*/? void process_num(long *NewValue, long *Value, long *DeltaValue,g4 		 long *LastDeltaValue, int ValueIdx, int DeltaIdx," 		 char *ValueFmt, char *DeltaFmt) {o     char label_buffer[15];     int first_time;- /*  End of declarations ... */  %     *DeltaValue = *NewValue - *Value;      first_time = !(*Value);      if (*DeltaValue) {       *Value = *NewValue;-/       sprintf (label_buffer, ValueFmt, *Value);-.       set_label_str( label_buffer, ValueIdx );     }s+     if ( *DeltaValue != *LastDeltaValue ) {O,       if (*DeltaValue == 0 || first_time ) {         label_buffer[0] = ' ';         label_buffer[1] = '\0';e       } else {6         sprintf (label_buffer, DeltaFmt, *DeltaValue);       }n.       set_label_str( label_buffer, DeltaIdx );  $       *LastDeltaValue = *DeltaValue;     }t }u gP /*----------------------------------------------------------------------------*/P /* Simplified GET VALUE routine to use only when retrieving a SINGLE attribute*/P /*----------------------------------------------------------------------------*/< void get_something(Widget w, char* resource, XtArgVal value) {c     Arg al[1]; /*  End of declarations ... */  %     XtSetArg(al[0], resource, value);u     XtGetValues(w, al, 1); }   P /*----------------------------------------------------------------------------*/P /* All widgets that are created call back to this procedure. We just log the  */P /* ID in the global array.                                                    */P /*----------------------------------------------------------------------------*/L void create_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s) { )     int widget_num = *(int *)client_data;l /*  End of declarations ... */  !     widget_array[widget_num] = w;g       switch ( widget_num ) {        case PFM_CPU_GRAPH:          break;       case PFM_STATE_GRAPH:          break;%       case PFM_DEVICE_0_IOCOUNT_NAME:]%         update_disk_name_label(w, 0);          break;%       case PFM_DEVICE_1_IOCOUNT_NAME:s%         update_disk_name_label(w, 1);          break;%       case PFM_DEVICE_2_IOCOUNT_NAME:a%         update_disk_name_label(w, 2);M         break;%       case PFM_DEVICE_3_IOCOUNT_NAME: %         update_disk_name_label(w, 3);          break;         default:       break;     }  }i fP /*----------------------------------------------------------------------------*/P /* exposure_proc() handles exposure events for the cpu histogram and          */P /* state graph.  This is called whenever the window receives an               */P /* exposure event.   We need to redraw the graphics  ourselves.               */P /*----------------------------------------------------------------------------*/O void exposure_proc (Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s)o {[
     int i;     int ix;+     int index;     Display *dpy;=     Window window; /*  End of declarations ... */       dpy = XtDisplay(w);      window = XtWindow(w);_        index = *(int *)client_data;     switch ( index ) {       case PFM_CPU_GRAPH:k&         for (ix = 0; ix < 100; ix++) {+           for (i = 0; i < MX_STATES; i++) {f             if (i == 0) {n2               XClearArea(dpy,window,ix,0,1,100,0);             } else {&               if (CPUPercent[i][ix]) {:                 XFillRectangle(dpy,window,cpu_graph_gc[i],M                 ix,100-CPUPercent[i][ix]-CPUbase[i][ix],1,CPUPercent[i][ix]);X               } 
             };           } 	         }f         break;       case PFM_STATE_GRAPH: 4         DrawStateGraph( XtDisplay(w), XtWindow(w) );         break;     }t }   P /*----------------------------------------------------------------------------*/P /* All push buttons in this application call back to this routine.  We        */P /* use the client_data to tell us what widget it is, then react accordingly.  */P /*----------------------------------------------------------------------------*/N void activate_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s) {eI     int widget_num = *(int *)client_data; /* Convert to widget number. */t /*  End of declarations ... */       switch ( widget_num ) {f/       case PFM_EXIT_BUTTON: exit(EXIT_SUCCESS);u       default: break;      }* }   P /*----------------------------------------------------------------------------*/P /* Not used, apparently                                                       */P /*----------------------------------------------------------------------------*/L void cancel_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s) {eI     int widget_num = *(int *)client_data; /* Convert to widget number. */e /*  End of declarations ... */       switch ( widget_num ) {D       default: break;C     }" }d oP /*----------------------------------------------------------------------------*/P /* Update the performance meter main statistics - called as a timer callback  */P /*----------------------------------------------------------------------------*// void update( XtPointer wdgt, XtIntervalId *id )l {z     register int i,j;V@     static long NewNullTime,NewUserTime,NewSupeTime,NewExecTime,4                 NewKernTime,NewInteTime,NewCompTime,G                 NewDevice_0_IO, DeltaDevice_0_IO, LastDeltaDevice_0_IO,oG                 NewDevice_1_IO, DeltaDevice_1_IO, LastDeltaDevice_1_IO, G                 NewDevice_2_IO, DeltaDevice_2_IO, LastDeltaDevice_2_IO,nG                 NewDevice_3_IO, DeltaDevice_3_IO, LastDeltaDevice_3_IO, 5                 LastDeltaPageFaults, LastDeltaPageIO,S6                 LastDeltaFreePages, LastDeltaModPages;  =     long NewPageFaults,DeltaPageFaults,NewPageIO,DeltaPageIO, &          NewFreePages, DeltaFreePages,1          NewModPages, DeltaModPages, NewDispFlag;l     int ix;0     long CPUtime[MX_STATES];     char *label_topproc;!     static char label_buffer[32];      XmString cs;     Widget cpu_graph_wdgt;     Display *dpy;      Window window; /*  End of declarations ... */  4 /*  Convert client data back to a display pointer */"     cpu_graph_wdgt = (Widget)wdgt;$     dpy = XtDisplay(cpu_graph_wdgt);&     window = XtWindow(cpu_graph_wdgt);  F     get_cpu_times(&NewNullTime,&NewUserTime,&NewSupeTime,&NewExecTime,:                   &NewKernTime,&NewInteTime,&NewCompTime);#     NewPageFaults = CURRENT_FAULTS;e#     NewPageIO     = CURRENT_PAGEIO;t&     NewFreePages  = CURRENT_FREEPAGES;%     NewModPages   = CURRENT_MODPAGES;l  H     total_time = NewNullTime + NewUserTime + NewSupeTime + NewExecTime +1          NewKernTime + NewInteTime + NewCompTime;r     if (total_time > 0) {l2       NullTime = (NewNullTime * 100) / total_time;2       UserTime = (NewUserTime * 100) / total_time;2       SupeTime = (NewSupeTime * 100) / total_time;2       ExecTime = (NewExecTime * 100) / total_time;2       KernTime = (NewKernTime * 100) / total_time;2       InteTime = (NewInteTime * 100) / total_time;2       CompTime = (NewCompTime * 100) / total_time;     }t
     else {       NullTime = NewNullTime;m       UserTime = NewUserTime;        SupeTime = NewSupeTime;R       ExecTime = NewExecTime;(       KernTime = NewKernTime;g       InteTime = NewInteTime;e       CompTime = NewCompTime;      }o       CPUtime[0] = NullTime;     CPUtime[1] = CompTime;     CPUtime[2] = UserTime;     CPUtime[3] = SupeTime;     CPUtime[4] = ExecTime;     CPUtime[5] = KernTime;     CPUtime[6] = InteTime;  "     for (ix = 0; ix < 100; ix++) {'       for (i = 0; i < MX_STATES; i++) {          CPUbase[i][100] = 0;!         CPUPercent[i][100] = 100;p)         for (j = 0; j < MX_STATES; j++) {M7           if (j != i) CPUPercent[i][100] -= CPUtime[j];A	         }_         if (i == 0) { .           XClearArea(dpy,window,ix,0,1,100,0);         } else {F           if (i > 1) CPUbase[i][100] = CPUtime[i-1]+CPUbase[i-1][100];2           CPUPercent[i][ix] = CPUPercent[i][ix+1];,           CPUbase[i][ix] = CPUbase[i][ix+1];"           if (CPUPercent[i][ix]) {6             XFillRectangle(dpy,window,cpu_graph_gc[i],I             ix,100-CPUPercent[i][ix]-CPUbase[i][ix],1,CPUPercent[i][ix]);,           };	         }n       }      }P   /*  Get latest top process */i     topproc = get_topproc();,     label_topproc = format_topproc(topproc);7     set_label_str (label_topproc, PFM_CONTPROC_TOGGLE);r  ) /*  Draw state graph on display window */iC     DrawStateGraph( dpy, XtWindow(widget_array[PFM_STATE_GRAPH]) );e* /*  Draw state graph on icon window too */+     DrawStateGraph( dpy, GetIconWindow() );r  =     if ((widget_array[PFM_DEVICE_0_IOCOUNT_TOTAL] != NULL) && 6 	(widget_array[PFM_DEVICE_0_IOCOUNT_DELTA] != NULL)) {)       get_disk_opcnt(0, &NewDevice_0_IO);i[       process_num (&NewDevice_0_IO, &Device_0_IO, &DeltaDevice_0_IO, &LastDeltaDevice_0_IO,n]                    PFM_DEVICE_0_IOCOUNT_TOTAL, PFM_DEVICE_0_IOCOUNT_DELTA, " %10d", "  %4d");      }*    =     if ((widget_array[PFM_DEVICE_1_IOCOUNT_TOTAL] != NULL) &&c=         (widget_array[PFM_DEVICE_1_IOCOUNT_DELTA] != NULL)) {f)       get_disk_opcnt(1, &NewDevice_1_IO); [       process_num (&NewDevice_1_IO, &Device_1_IO, &DeltaDevice_1_IO, &LastDeltaDevice_1_IO, ]                    PFM_DEVICE_1_IOCOUNT_TOTAL, PFM_DEVICE_1_IOCOUNT_DELTA, " %10d", "  %4d");      }d  =     if ((widget_array[PFM_DEVICE_2_IOCOUNT_TOTAL] != NULL) && =         (widget_array[PFM_DEVICE_2_IOCOUNT_DELTA] != NULL)) {*)       get_disk_opcnt(2, &NewDevice_2_IO);t[       process_num (&NewDevice_2_IO, &Device_2_IO, &DeltaDevice_2_IO, &LastDeltaDevice_2_IO,t]                    PFM_DEVICE_2_IOCOUNT_TOTAL, PFM_DEVICE_2_IOCOUNT_DELTA, " %10d", "  %4d");m     }h  =     if ((widget_array[PFM_DEVICE_3_IOCOUNT_TOTAL] != NULL) &&n6 	(widget_array[PFM_DEVICE_3_IOCOUNT_DELTA] != NULL)) {)       get_disk_opcnt(3, &NewDevice_3_IO); [       process_num (&NewDevice_3_IO, &Device_3_IO, &DeltaDevice_3_IO, &LastDeltaDevice_3_IO,n]                    PFM_DEVICE_3_IOCOUNT_TOTAL, PFM_DEVICE_3_IOCOUNT_DELTA, " %10d", "  %4d");o     }t  U     process_num (&NewPageFaults, &PageFaults, &DeltaPageFaults, &LastDeltaPageFaults,oO                  PFM_PAGEFAULTS_TOTAL, PFM_PAGEFAULTS_DELTA, " %10d", "  %4d");iC     set_something(widget_array[PFM_PAGEFAULTS_DELTA],XmNforeground, M                   (DeltaPageFaults > 0) ? bad_colour_pxl : good_colour_pxl );   E     process_num (&NewPageIO, &PageIO, &DeltaPageIO, &LastDeltaPageIO,pG                  PFM_PAGEIO_TOTAL, PFM_PAGEIO_DELTA, " %10d", "  %4d"); ?     set_something(widget_array[PFM_PAGEIO_DELTA],XmNforeground,0I                   (DeltaPageIO > 0) ? bad_colour_pxl : good_colour_pxl );R  Q     process_num (&NewFreePages, &FreePages, &DeltaFreePages, &LastDeltaFreePages,0M                  PFM_FREEPAGES_TOTAL, PFM_FREEPAGES_DELTA, " %10d", "  %4d");lB     set_something(widget_array[PFM_FREEPAGES_DELTA],XmNforeground,L                   (DeltaFreePages < 0) ? bad_colour_pxl : good_colour_pxl );  M     process_num (&NewModPages, &ModPages, &DeltaModPages, &LastDeltaModPages,oK                  PFM_MODPAGES_TOTAL, PFM_MODPAGES_DELTA, " %10d", "  %4d");uA     set_something(widget_array[PFM_MODPAGES_DELTA],XmNforeground,nM                     (DeltaModPages > 0) ? bad_colour_pxl : good_colour_pxl );x  P     XtAppAddTimeOut(app_context, main_update_int, update, wdgt /*client data*/); }t sP /*----------------------------------------------------------------------------*/P /* Draw the cpu state graph                                                   */P /*----------------------------------------------------------------------------*/2 void DrawStateGraph( Display *dpy, Window window ) {A/     static const int iLBarOffset[MX_STATES] = {l       /* NullTimeX */ 12,h       /* CompTimeX */  2,p       /* UserTimeX */ 22,(       /* SupeTimeX */ 32,_       /* ExecTimeX */ 42,"       /* KernTimeX */ 52,_I       /* InteTimeX */ 62 }; /* Logical units for display and bar sizes */ B     static const int iLBarWidth = 7, iLHeight = 100, iLWidth = 70;5     int iArcDiameter, iFreeArcAngle, iModArcAngle, i;1     long CPUtime[MX_STATES];     XWindowAttributes xwa; /*  End of declarations ... */       if ( window ) {09       if ( XGetWindowAttributes( dpy,  window, &xwa ) ) {w< /*      Only bother drawing anything if window is visible */,         if ( IsViewable == xwa.map_state ) {            CPUtime[0] = NullTime;            CPUtime[1] = CompTime;            CPUtime[2] = UserTime;            CPUtime[3] = SupeTime;            CPUtime[4] = ExecTime;            CPUtime[5] = KernTime;            CPUtime[6] = InteTime;  , /*        Draw bar for time in each state */,           for ( i = 0; i < MX_STATES; ++i) {P             DrawStateBar( dpy, window, state_graph_gc[i], xwa.width, xwa.height,J               CPUtime[i], iLBarOffset[i], iLBarWidth, iLWidth, iLHeight );           }c  J /*        Draw arc showing memory use (save 64 factor for XFillArc call */E /*        to avoid integer overflow in xxxxArcAngle calculation on */r3 /*        large memory systems [lucky s*ds]  :-) */o)           iArcDiameter = 5*xwa.height/16; 3           if ( iArcDiameter % 2 ) iArcDiameter +=1;uI           XFillArc(dpy,window,bad_colour_gc, xwa.width-iArcDiameter-2, 1, 7                    iArcDiameter,iArcDiameter,0,360*64);g3           iFreeArcAngle = FreePages*360/TotalPages; J           XFillArc(dpy,window,good_colour_gc, xwa.width-iArcDiameter-2, 1,A                    iArcDiameter,iArcDiameter,0,iFreeArcAngle*64);p1           iModArcAngle = ModPages*360/TotalPages;tM           XFillArc(dpy,window,neutral_colour_gc, xwa.width-iArcDiameter-2, 1,;K                iArcDiameter,iArcDiameter,iFreeArcAngle*64,iModArcAngle*64);d	         }t       }e     }p }n tP /*----------------------------------------------------------------------------*/e /* Clear existing and draw new bar on the cpu state graph                                          */oP /*----------------------------------------------------------------------------*/6 void DrawStateBar( Display *dpy, Window window, GC gc,L        int iWindowWidth, int iWindowHeight,                 /* Pixel size */O        int iLValue, int iLX, int iLBarW, int iLW, int iLH ) /* Logical sizes */* {n'     int  iBarHeight, iBarWidth, iX, iY;n /*  End of declarations ... */       iX = iWindowWidth*iLX/iLW;)     iY = iWindowHeight*(iLH-iLValue)/iLH;-+     iBarHeight = iWindowHeight*iLValue/iLH; (     iBarWidth = iWindowWidth*iLBarW/iLW;7     XClearArea(dpy,window,iX,0,iLBarW,iWindowHeight,0);n=     XFillRectangle(dpy,window,gc,iX,iY,iBarWidth,iBarHeight);  }u mP /*----------------------------------------------------------------------------*/P /* Create a Graphics Context with appropriate function and foreground         */P /*----------------------------------------------------------------------------*/S GC MakeGC(Display* disp, Window wind, long fun, Pixel background, Pixel foreground)* {-     XGCValues gcvalues;- /*  End of declarations ... */  &     gcvalues.background = background;;&     gcvalues.foreground = foreground;;     gcvalues.function = fun;P     return(XCreateGC(disp,wind,GCFunction|GCForeground|GCBackground,&gcvalues)); }l lP /*----------------------------------------------------------------------------*/P /* Get first set of CPU stats by setting up a kernel mode routine             */P /*----------------------------------------------------------------------------*/ void init_cpu_times()  {i /*  End of declarations ... */  G     last_user = last_super = last_exec = last_kernel = last_interrupt =(,     last_compat = last_spin = last_idle = 0;   #ifdef __ALPHA2     sys$cmkrnl(&get_initial_kernelly_stuff, NULL); #else(!     get_initial_kernelly_stuff();r #endif        last_interrupt -= last_idle; }a nP /*----------------------------------------------------------------------------*/P /* This is called at Kernel mode to actually look up the information          */P /*----------------------------------------------------------------------------*/! void get_initial_kernelly_stuff()s {l     register i, j, k;f     long    *PMS$GL_KERNEL;  /*  End of declarations ... */  B     for (k = SMP$GL_ACTIVE_CPUS, j = 0; k != 0; j++, k = k >> 1) {"       if ((k & 01) == 0) continue; #ifdef __ALPHA9       PMS$GL_KERNEL = (SMP$GL_CPU_DATA[j])->cpu$q_kernel;-       last_compat = 0; #else 9       PMS$GL_KERNEL = (SMP$GL_CPU_DATA[j])->cpu$l_kernel;l+       last_compat += PMS$GL_KERNEL[C_TIME];i #endif+       last_kernel += PMS$GL_KERNEL[K_TIME]; )       last_exec += PMS$GL_KERNEL[E_TIME];i*       last_super += PMS$GL_KERNEL[S_TIME];)       last_user += PMS$GL_KERNEL[U_TIME];s.       last_interrupt += PMS$GL_KERNEL[I_TIME];,       last_spin += PMS$GL_KERNEL[SPIN_TIME];7 /*    here is where the null CPU time is collected.  */b,       last_idle += PMS$GL_KERNEL[IDLE_TIME];     }L }D aP /*----------------------------------------------------------------------------*/P /* Get next set of CPU stats by setting up a kernel mode routine              */P /*----------------------------------------------------------------------------*/C void get_cpu_times(long* null, long* user, long* super, long* exec,-F                           long* kernel, long* interrupt, long* compat) {       long new_abstime, totaltime; /*  End of declarations ... */  B     new_user = new_super = new_exec = new_kernel = new_interrupt =)     new_compat = new_spin = new_idle = 0;i   #ifdef __ALPHA.     sys$cmkrnl(&get_new_kernelly_stuff, NULL); #else      get_new_kernelly_stuff();t #endif       new_interrupt -= new_idle;  7     *user = new_user - last_user; last_user = new_user;-<     *super = new_super - last_super; last_super = new_super;7     *exec = new_exec - last_exec; last_exec = new_exec;lA     *kernel = new_kernel - last_kernel; last_kernel = new_kernel; P     *interrupt = new_interrupt - last_interrupt; last_interrupt = new_interrupt;A     *compat = new_compat - last_compat; last_compat = new_compat;n  7     *null = new_idle - last_idle; last_idle = new_idle;= }i *P /*----------------------------------------------------------------------------*/P /* This is called at Kernel mode to actually look up the information          */P /*----------------------------------------------------------------------------*/ void get_new_kernelly_stuff()l { 
     int j, k;r     long *PMS$GL_KERNEL; /*  End of declarations ... */  B     for (k = SMP$GL_ACTIVE_CPUS, j = 0; k != 0; j++, k = k >> 1) {"       if ((k & 01) == 0) continue; #ifdef __ALPHA;         PMS$GL_KERNEL = (SMP$GL_CPU_DATA[j])->cpu$q_kernel;          new_compat = 0;l #else ;         PMS$GL_KERNEL = (SMP$GL_CPU_DATA[j])->cpu$l_kernel; ,         new_compat += PMS$GL_KERNEL[C_TIME]; #endif,         new_kernel += PMS$GL_KERNEL[K_TIME];*         new_exec += PMS$GL_KERNEL[E_TIME];+         new_super += PMS$GL_KERNEL[S_TIME]; *         new_user += PMS$GL_KERNEL[U_TIME];/         new_interrupt += PMS$GL_KERNEL[I_TIME];e-         new_spin += PMS$GL_KERNEL[SPIN_TIME]; -         new_idle += PMS$GL_KERNEL[IDLE_TIME];-     }- }- -P /*----------------------------------------------------------------------------*/P /* Get disk IO operations                                                     */P /*----------------------------------------------------------------------------*/? void get_disk_opcnt(register long devnum, register long* count)  {w     static struct {        unsigned short  blen;        unsigned short  icode;       long*           buff;        unsigned short* rlen; =     } dvi_itmlst[] = { {sizeof(int), DVI$_OPCNT, NULL, NULL},0,                        {0, 0, NULL, NULL} };     static struct {        unsigned short  istat;       unsigned short  bytes;       long            fill;c     } iosb;U     static char devname[64];     $DESCRIPTOR(dev,devname);      long status; /*  End of declarations ... */  3     sprintf(devname, "PFM$DEVICE_%d_NAME", devnum);t     dvi_itmlst[0].buff = count;      *count = -1;'     dev.dsc$w_length = strlen(devname);-:     status = sys$getdviw(0,0,&dev,dvi_itmlst,&iosb,0,0,0);!     if (status == SS$_IVDEVNAM) {c       *count = 0;        if (devnum == 0) {.         $DESCRIPTOR(sysdev, "SYS$SYSDEVICE:");8         sys$getdviw(0,0,&sysdev,dvi_itmlst,&iosb,0,0,0);       }-     }- }- -P /*----------------------------------------------------------------------------*/P /* Set title for monitored disk IO                                            */P /*----------------------------------------------------------------------------*/2 void update_disk_name_label(Widget w, long devnum) {e     char  devname[64];     char *title; /*  End of declarations ... */  4     sprintf(devname, "PFM$DEVICE_%d_TITLE", devnum);     title = getenv(devname);     if (NULL == title) {5       sprintf(devname, "PFM$DEVICE_%d_NAME", devnum);-       title = getenv(devname);E       if ((NULL == title) && (0 == devnum)) title = "SYS$SYSDEVICE:";c     })*     if (title != NULL) set_label(w,title); }  CP /*----------------------------------------------------------------------------*/P /* This callback is invoked when user clicks on the `contproc' toggle         */P /*----------------------------------------------------------------------------*/\ void toggle_contproc (Widget w, XtPointer client_data, XmToggleButtonCallbackStruct *toggle) {- /*  End of declarations ... */H     contproc_off();                  /* Turn off any existing display */D     if (toggle->set) contproc_on (); /* Turn display on if needed */ }   P /*----------------------------------------------------------------------------*/P /* Procecures to turn 'show proc/cont' display off, unmanaging the dialog box */P /*----------------------------------------------------------------------------*/ void contproc_off(void)  {  /*  End of declarations ... */  %     if ( contproc_IntervalId != 0 ) { +       XtRemoveTimeOut(contproc_IntervalId);e       contproc_IntervalId = 0;     }s     if ( contproc_wdgt != 0 ) {NB       /* Save the window position so we can put it back exactly */B       /* where the use last moved it to, otherwise, it pops up  */       /* all over the place. */C)       if ( XtIsManaged(contproc_wdgt) ) {;N         get_something( XtParent(contproc_wdgt), XmNx, (XtArgVal)&contproc_x );N         get_something( XtParent(contproc_wdgt), XmNy, (XtArgVal)&contproc_y );)         XtUnmanageChild( contproc_wdgt );n       }      }r }_ tP /*----------------------------------------------------------------------------*/P /* contrproc_on()  initializes the 'show proc/cont' display.  That is,        */P /* it looks up the static information for this process, zeros our counters,   */P /* realizes the window, and makes the initial call to the contproc_update     */P /* procedure.                                                                 */P /*----------------------------------------------------------------------------*/ void contproc_on(void) {f     char text[100]; !     int userlen, prcstrt, status;)     unsigned int timequad[2];=       static int pid;t)     static char username[12], prcnam[15]; 2     static VMS_ItemList JPI_static_itemlist[4] = {1         sizeof(pid),      JPI$_PID,      &pid, 0, 6         sizeof(username), JPI$_USERNAME, &username, 0,4         sizeof(prcnam),   JPI$_PRCNAM,   &prcnam, 0,         0, 0, 0, 0}; /*  End of declarations ... */  J /*  Zero out `previous' values so process_num doesn't give silly deltas */O     DirIO = BufIO = Ppgcnt = Gpgcnt = Pageflts = Cputim = WSSize = Pgfluse = 0;w  9     sys$gettim( &timequad[0] );		/* To calc % cpu used */t     timelast = timequad[0];m  I     /* Remember the PID of the top user - we monitor this same process */ +     /* as long the this window is active */T&     topPID = topproc_getPID (topproc);  F     status = sys$getjpiw (0, &topPID, 0, &JPI_static_itemlist, 0,0,0);     if (status != SS$_NORMAL) { #       contproc_jpi_status (status); 
       return;      }A  ,     /* Trim trailing spaces from username */T     for (userlen=0; userlen<=sizeof(username) && username[userlen]!=' '; userlen++);  /     /* Trim leading spaces from process name */fP     for (prcstrt=0; prcstrt<=sizeof(prcnam) && prcnam[prcstrt]==' '; prcstrt++);  <     sprintf (text, "PID: %08X  User: %.*s  Process: %.*s\0",F 	pid, userlen, username,  (sizeof(prcnam)-prcstrt), (prcnam+prcstrt));&     set_label_str (text, PFM_HEADER1);  4     /* Put the window back where it was last time */"     XtManageChild (contproc_wdgt);>     set_something (XtParent(contproc_wdgt), XmNx, contproc_x);>     set_something (XtParent(contproc_wdgt), XmNy, contproc_y);$     XtRealizeWidget (contproc_wdgt);  >     DirIO = LastDeltaDirIO = BufIO = LastDeltaBufIO = Ppgcnt =5         LastDeltaPpgcnt = Gpgcnt = LastDeltaGpgcnt = AB         Pageflts = LastDeltaPageflts = Cputim = LastDeltaCputim = ; 	WSSize = LastDeltaWSSize = Pgfluse = LastDeltaPgfluse = 0;[  :     update_contproc(NULL, NULL);		/* get things rolling */ }C _P /*----------------------------------------------------------------------------*/P /* Timer callback to update stats for cont. monitored `top CPU' process       */P /*----------------------------------------------------------------------------*/8 void update_contproc( XtPointer data, XtIntervalId *id ) {1     int status, tmp;%     char CputimStr[12], CpupctStr[6];E.     static unsigned int timequad[2], timediff;  -     static int imaglen, pagfilcnt, pgflquota;e     static char imagname[80];l5     static VMS_ItemList JPI_contproc_itemlist[10] = { 9         sizeof(NewDirIO),    JPI$_DIRIO,    &NewDirIO, 0,"9         sizeof(NewBufIO),    JPI$_BUFIO,    &NewBufIO, 0,I:         sizeof(NewCputim),   JPI$_CPUTIM,   &NewCputim, 0,:         sizeof(NewPpgcnt),   JPI$_PPGCNT,   &NewPpgcnt, 0,:         sizeof(NewGpgcnt),   JPI$_GPGCNT,   &NewGpgcnt, 0,3 	sizeof(pagfilcnt),   JPI$_PAGFILCNT,&pagfilcnt, 0,t3 	sizeof(pgflquota),   JPI$_PGFLQUOTA,&pgflquota, 0,D<         sizeof(NewPageflts), JPI$_PAGEFLTS, &NewPageflts, 0,@         sizeof(imagname),    JPI$_IMAGNAME, &imagname, &imaglen,         0, 0, 0, 0}; /*  End of declarations ... */  B     /* We need the change in system time to calc the % cpu used */     sys$gettim (&timequad[0]);&     timediff = timequad[0] - timelast;     timelast = timequad[0];O  /     /* Now get the stats for the top process */oH     status = sys$getjpiw (0, &topPID, 0, &JPI_contproc_itemlist, 0,0,0);     if (status != SS$_NORMAL) 	         {P%         contproc_jpi_status (status);T         return;d	         }e  8     /* It makes more sense to me to see page file use *//     /* instead of page file quota remaining. */_'     NewPgfluse = pgflquota - pagfilcnt;r  E     /* We show process and group page counts, but it's also useful */ -     /* to see the totaled working set size */%&     NewWSSize = NewPpgcnt + NewGpgcnt;    H     process_num (&NewPpgcnt, &Ppgcnt, &DeltaPpgcnt, &LastDeltaPpgcnt,   6 		 PFM_PPGCNT_TOTAL, PFM_PPGCNT_DELTA,  "%8d", "%8d");H     process_num (&NewGpgcnt, &Gpgcnt, &DeltaGpgcnt, &LastDeltaGpgcnt,   6 		 PFM_GPGCNT_TOTAL, PFM_GPGCNT_DELTA,  "%8d", "%8d");H     process_num (&NewWSSize, &WSSize, &DeltaWSSize, &LastDeltaWSSize,   6 		 PFM_WSSIZE_TOTAL, PFM_WSSIZE_DELTA,  "%8d", "%8d");N     process_num (&NewPageflts, &Pageflts, &DeltaPageflts, &LastDeltaPageflts, 8 		 PFM_PGFAULTS_TOTAL, PFM_PGFAULTS_DELTA,"%8d", "%8d");J     process_num (&NewPgfluse, &Pgfluse, &DeltaPgfluse, &LastDeltaPgfluse, 6 		 PFM_PGFLUSE_TOTAL, PFM_PGFLUSE_DELTA,"%8d", "%8d");E     process_num (&NewDirIO, &DirIO, &DeltaDirIO, &LastDeltaDirIO,    )5 		 PFM_DIRIO_TOTAL, PFM_DIRIO_DELTA,   "%8d", "%8d"); A     process_num (&NewBufIO, &BufIO, &DeltaBufIO, &LastDeltaBufIO,-7     		 PFM_BUFIO_TOTAL, PFM_BUFIO_DELTA, "%8d", "%8d");D  *     format_cputime (NewCputim, CputimStr);1     set_label_str (CputimStr, PFM_CPUTIME_TOTAL);-       if ( Cputim ) {-'       DeltaCputim = NewCputim - Cputim;d     } else {       DeltaCputim = 0;     })     Cputim = NewCputim;t"     LastDeltaCputim = DeltaCputim;     tmp = timediff / 100000;M     sprintf (CpupctStr, " %3d%%\0", (DeltaCputim*100+50) / (tmp ? tmp : 1) ); 1     set_label_str (CpupctStr, PFM_CPUTIME_DELTA);        imagname[imaglen] = '\0';g*     set_label_str (imagname, PFM_HEADER2);
              i     contproc_IntervalId = L       XtAppAddTimeOut(app_context, contproc_update_int, update_contproc, 0); }  gP /*----------------------------------------------------------------------------*/P /* Find state of monitored process, adjust monitoring accordingly             */P /*----------------------------------------------------------------------------*/% void contproc_jpi_status (int status)P {m     static char text[35];  /*  End of declarations ... */       switch (status) {          case SS$_SUSPENDED:m7             set_label_str ("(Suspended)", PFM_HEADER2);]>             contproc_IntervalId = XtAppAddTimeOut(app_context,9               2*contproc_update_int, update_contproc, 0);M             break;         case SS$_NONEXPR:,?             set_label_str ("Nonexistant process", PFM_HEADER1); D             set_label_str ("(display update stopped)", PFM_HEADER2);$             contproc_IntervalId = 0;             break;         default:@             sprintf (text, "Error in $GETJPI, stat=%d", status);.             set_label_str (text, PFM_HEADER1);D             set_label_str ("(display update stopped)", PFM_HEADER2);$             contproc_IntervalId = 0;             break;     }c }y nP /*----------------------------------------------------------------------------*/P /* doMainPopupMenu() is the callback whenever a button is clicked in          */P /* one of the graph displays.   All we do here is display a popup menu        */P /* which contains the option to exit.                                         */P /*----------------------------------------------------------------------------*/7 void doMainPopupMenu(Widget wdgt,XtPointer client_data,A7                      XEvent *event, Boolean *propogate)t {      Widget popup;  /*  End of declarations ... */  ( /*  This makes our popup menu visible */      popup = (Widget)client_data;9     XmMenuPosition (popup, (XButtonPressedEvent *)event);      XtManageChild(popup);-     XtRealizeWidget(popup);- }- -P /*----------------------------------------------------------------------------*/P /* format_cputime() takes an integer (t) which represents a time value        */P /* in 10 millisecond ticks, and returns a string (*s) which contains          */P /* the time formatted as hh:mm:ss.hh                                          */P /*----------------------------------------------------------------------------*/$ void format_cputime (int t, char *s) { "     int hour, min, sec, hund, tmp; /*  End of declarations ... */       hour = t / 360000;     tmp = t - hour*360000;     min = tmp / 6000;W     tmp = tmp - min*6000;      sec = tmp / 100;     hund = tmp - sec*100;-  ?     sprintf (s, "%02d:%02d:%02d.%02d\0", hour, min, sec, hund);p }p  H void SetIconPixmap( Widget shell, Pixmap pxmap, Bool want_icon_window  ) {-     Window icon_window;-$     Display *dpy = XtDisplay(shell); /*  End of declarations ... */   /*  Set icon pixmap as usual */-5     XtVaSetValues(shell, XmNiconPixmap, pxmap, NULL); B /*  If we can make an icon window thsi will override the pixmap */N     if ( want_icon_window  &&  (icon_window = MakeIconWindow(shell,pxmap)) ) {I /*    Set windows background pixmap to be the image we want to display */-<       XSetWindowBackgroundPixmap( dpy, icon_window, pxmap );: /*    Cause redisplay of window so that update shows up */'       XClearWindow( dpy, icon_window );-     }- }- -P /*----------------------------------------------------------------------------*/P /* GetIconWindow return window created by a previous call to MakeIconWindow   */P /*----------------------------------------------------------------------------*/ static Window icon_window; Window GetIconWindow( void ) {      return( icon_window ); })  P /*----------------------------------------------------------------------------*/P /* Makes icon window for top level shell taking size from pixmap              */P /*----------------------------------------------------------------------------*/3 Window MakeIconWindow( Widget shell, Pixmap pxmap )o {g     Window root;
     int x, y; 4     unsigned int width, height, border_width, depth;     Display *dpy;i /*  End of declarations ... */       if ( !icon_window ) { 9 /*    Get the current window associated with the shell */d>       XtVaGetValues(shell, XmNiconWindow, &icon_window, NULL);         if ( !icon_window ) {          dpy = XtDisplay(shell);PR /*      If no window associated with the shell create one. Make it as big as the*/R /*      pixmap we're going to use.icon window only needs to be a simple window  */5         if ( !XGetGeometry(dpy, pxmap, &root, &x, &y, A                       &width, &height, &border_width, &depth)  ||M              !( icon_window = C                 XCreateSimpleWindow(dpy, root, 0, 0, width, height,tK                                     0, CopyFromParent, CopyFromParent)) ) {             return( icon_window );	         }-1 /*      Now that the window is created, set it */n@         XtVaSetValues( shell, XmNiconWindow, icon_window, NULL);       }*     }-     return( icon_window ); }-