I /***********************************************************************/ I /* TOPPROC.C                                                           */ I /*                                                                     */ I /* Set of routines to determine the current top cpu user on the system.*/ I /* These can be called from another application or linked as a         */ I /* standalone exe (see comments by main() routine).                    */ I /*                                                                     */ I /* Created by J.Kazimierczyk  14-FEB-1993                              */ I /***********************************************************************/    #include <stdio.h> #include <stdlib.h>    #include <jpidef.h>  #include <ssdef.h> #include <starlet.h> #include <syidef.h>    int initialize_topproc();  int get_topproc(); char *format_topproc(int); int topproc_getPID(int);  ( /* Struct for creating VMS item lists */ typedef struct _vms_item_list {  	short	 buffer_length; 	short	 item_code; 	void	*buffer; 	int	*returned_buffer_length;  	} VMS_ItemList;  B /* Struct to contain the info we need to track the top cpu user */ typedef struct _proclist {	 	int	pid; 
 	int	cputime;  	int	change;
 	} Proc_List;   5 /* Pointer to our array of processes on the system */  Proc_List *ProcList;  6 static int timelast;		/* last value from sys$gettim */6 static int timediff;		/* last change in system time */    H /**********************************************************************/H /* This main() routine demonstrates how these routines can be tested, */H /* or used for some other application.  To create a standalone        */H /* executable for testing, do:                                        */H /*           $ CC TOPPROC.C/DEFINE=TEST                               */H /*           $ LINK TOPPROC,SYS$INPUT/OPT                             */H /*                       SYS$LIBRARY:VAXCRTL.EXE/SHARE                */H /* This will print out some information about the current top process */H /* every 3 seconds.                                                   */H /**********************************************************************/   #ifdef TEST  main ()      {      int topprocIndex;      char *text;   3     initialize_topproc();			/* only do this once */ 
     while (1) 	         { A         topprocIndex = get_topproc();		/* ret index into array */ H         text = format_topproc(topprocIndex);	/* canned display format */         printf ("%s\n", text);4         lib$wait (&(float)3);			/* wait 3 seconds */	         }      }  #endif    H /**********************************************************************/H /* initialize_topproc is called to initialize the data structure that */H /* we need to track cpu utilization of each process.  This returns    */H /* the value of MAXPROCESSCNT or 0 if we fail.  This should only be   */H /* called once per application.                                       */H /*                                                                    */H /* The basic idea here is to create and init the array ProcList with  */H /* MAXPROCESSNCT elements.  This is what we need to track all         */H /* processes on the system.                                           */H /**********************************************************************/   int initialize_topproc()     {      int status, i;     unsigned int timequad[2];        static int maxproc; +     static VMS_ItemList SYI_itemlist[2] = { 9         sizeof(maxproc), SYI$_MAXPROCESSCNT, &maxproc, 0,          0, 0, 0, 0};    ;     status = sys$getsyiw (0, 0, 0, &SYI_itemlist, 0, 0, 0); '     if (status != SS$_NORMAL) return 0;   >     /* Create the array to hold all processes on the system */7     ProcList = malloc(sizeof(Proc_List) * (maxproc+1));      for (i=0; i<=maxproc; i++) 	ProcList[i].pid = 0;   8     sys$gettim (&timequad[0]);		/* To calc % cpu used */     timelast = timequad[0];        return maxproc;      }   H /**********************************************************************/H /* get_topproc scans through all processes on the system, and finds   */H /* which one is the top cpu user.  initialize_topproc must have been  */H /* called first to set up the ProcList array.  We return an index     */H /* into the ProcList array, pointing to our top user of the moment.   */H /* This index can then be used by the other routines to identify the  */H /* top process.                                                       */H /**********************************************************************/   int get_topproc()     {1     int status, idx, biggest_idx, biggest_change;      unsigned int timequad[2];   (     static int pid, cputime, proc_index;'     static VMS_ItemList itemlist[4] = { <         sizeof(pid),        JPI$_PID,        &pid,        0,<         sizeof(cputime),    JPI$_CPUTIM,     &cputime,    0,<         sizeof(proc_index), JPI$_PROC_INDEX, &proc_index, 0,         0, 0, 0, 0};         biggest_idx = 0;     biggest_change = -1;8     idx = -1;			/* wildcard for initial $getjpiw call */  
     while (1) 	         { >         status = sys$getjpiw (0, &idx, 0, &itemlist, 0, 0, 0);,         if (status == SS$_NOMOREPROC) break;  ,         if (ProcList[proc_index].pid == pid) 	    {A 	    /* We already saw this process, so we have enough info to */ I             /* calculate the change in cputime since the last interval */   O             ProcList[proc_index].change = cputime-ProcList[proc_index].cputime; , 	    ProcList[proc_index].cputime = cputime;  ; 	    /* Also keep track of the biggest change (top user) */ =             if (ProcList[proc_index].change > biggest_change)                  { )                 biggest_idx = proc_index; 6 	        biggest_change = ProcList[proc_index].change;
 	        } 	    } 	else  	    {> 	    /* There is a new process in this slot - initialize it */$ 	    ProcList[proc_index].pid = pid;, 	    ProcList[proc_index].cputime = cputime;% 	    ProcList[proc_index].change = 0;  	    }	         }   B     /* We need the change in system time to calc the % cpu used */B     /* Note: using half of the system datetime quadword is not  */H     /* 100% accurate, but it's easier and doesnt seem to be a problem */     sys$gettim (&timequad[0]);&     timediff = timequad[0] - timelast;     timelast = timequad[0];   :     return biggest_idx;		/* return our top user's index */     }     H /**********************************************************************/H /* format_topproc formats the top process information for display.    */H /* The integer top is the index into ProcList which tells us who we   */H /* need to format.  We return a pointer to a character string which   */H /* contains the formatted text.                                       */H /**********************************************************************/     char *format_topproc(int top)      { )     int i, status, userlen, prcstrt, tmp;      static char text[100];  7     static char imagname[80], username[12], prcnam[15];      static int imaglen; /     static VMS_ItemList JPI_dsp_itemlist[4] = { ?         sizeof(imagname),  JPI$_IMAGNAME,  &imagname, &imaglen, 9         sizeof(username),  JPI$_USERNAME,  &username,  0, 9         sizeof(prcnam),    JPI$_PRCNAM,    &prcnam,    0,          0, 0, 0, 0};    N     status = sys$getjpiw (0, &ProcList[top].pid, 0, &JPI_dsp_itemlist, 0,0,0);     if (status != SS$_NORMAL) 	         { (         userlen = 0;			/* no username */*         imaglen = 0;			/* no image name */7         prcstrt = sizeof(prcnam);	/* no process name */ 	         }      else	         { 4         /* Trim the trailing spaces from username */M         for (userlen=1; userlen<=sizeof(username) && username[userlen]!=' ';   		userlen++) 		    ; 3         /* Trim leading spaces from process name */ I         for (prcstrt=0; prcstrt<=sizeof(prcnam) && prcnam[prcstrt]==' ';   		prcstrt++) 	            ;4 	/* Trim off the dev:[dir] part of the image name */!         imagname[imaglen] = '\0'; 6         for (i=imaglen; i>=0 && imagname[i]!=']'; i--) 	    ;	         }                             tmp = timediff / 100000;0     sprintf (text, "%08X %.*s %.*s %s (%d%%)\0", 	ProcList[top].pid,  	userlen, username, , 	(sizeof(prcnam)-prcstrt), (prcnam+prcstrt), 	(imagname+i+1),2 	((ProcList[top].change)*100+50)/(tmp ? tmp : 1));  =     return text;	/* pointer to the formatted top proc info */      }   H /**********************************************************************/H /* topproc_getPID() simply takes the ProcList array index, and returns*/H /* the PID of the process pointed to.   The caller can then use this  */H /* PID for whatever it likes.                                         */H /**********************************************************************/   int topproc_getPID (int top)     {      return ProcList[top].pid;      }   