P /*------------------------------------------------------------------------------K  *   PERF_METER.C - Performance Meter display for DECwindows Motif, OpenVMS   *
  *   History:   *'  *	V01-001		Robert Heller			08-Nov-1989 '  *		Created on Wed Nov  8 10:39:17 1989 (  *	V01-002		Mark Pizzolato			22-Nov-19891  *		mark@infopiz.uucp (uunet!lupine!infopiz!mark) '  *	V01-003		Robert Heller			27-Nov-1989   *		Fixed for invert displays ?  *		Modified to use set_label in place of certain set_something ,  *		calls and new version of init_cpu_times.  *0  *	V01-004		Phil Ottewell/Tony Davis	19-OCT-1992;  *		Modified to use UIL/Motif toolkit instead of DECwindows   *'  *	V02-000		Phil Ottewell			27-NOV-1992 4  *		Modified to use different colours for CPU modes,9  *		use a decent icon, and allow more user configuration.   *7  *	V02-001		Joe Kazimierczyk (kaz@bms.com)	14-FEB-1993  B  *		Plugged memory leak caused by calls to DwtLatin1String without  *		corresponding XtFree(). 5  *		Added 'top process' info to bottom of main window <  *		Added toggle button to create a 'show process/cont' type(  *		display for the current top process.>  *		Moved exit button to a popup menu instead of the menu bar,  *		to save display space.  *(  *	V02-000-A	Phil Ottewell			20-JAN-1993"  *		Modified V2.0 to work on Alpha  *'  *	V02-002		Phil Ottewell			01-MAY-1995 -  *		Modified to work with DEC C and Motif 1.2 ,  *		without having to specify /STANDARD=VAXC8  *		Merged Joe Kazimierczyk V2.1 changes in to V02-000-A  *P  *----------------------------------------------------------------------------*/   /* ANSI C headers */ #include <stdio.h> #include <stdlib.h>  #include <ctype.h>   /* VMS headers */  #include <descrip.h> #include <dvidef.h>  #include <jpidef.h>  #include <ssdef.h> #include <starlet.h> #include <syidef.h>    /* Local headers */  #ifdef __ALPHA #include "cpudef_alpha.h"  #else  #include "cpudef.h"  #endif #include "perf_meter_const.h"    /* X Toolkit header */ #include <X11/Intrinsic.h>9 /* Motif general header (includes most Xlib stuff too) */  #include <Xm/Xm.h> /* Other Motif headers */  #include <Xm/RowColumn.h>  /* Motif Resource Manager*/  #include <Xm/MrmAppl.h>    /* #defines go here */  M #define PROGRAM_TITLE_FORMAT "System Performance Meters on %s" /* nodename */ ( #define PROGRAM_NAME         "PerfMeter"$ #define PROGRAM_CLASS        "Meter"" #define PROGRAM_VERSION      "2.2"   #define MX_STATES 7    #define PARAM_STRING 0 #define PARAM_INTEGER 1  #ifdef __ALPHA #define K_TIME 0 #define E_TIME 2 #define S_TIME 4 #define U_TIME 6 #define I_TIME 8 #define C_TIME 0 #define SPIN_TIME 10 #define IDLE_TIME 12 #else  #define K_TIME 0 #define E_TIME 1 #define S_TIME 2 #define U_TIME 3 #define I_TIME 4 #define C_TIME 5 #define SPIN_TIME 6  #define IDLE_TIME 7  #endif   #define CompTimeX  2 #define NullTimeX 12 #define UserTimeX 22 #define SupeTimeX 32 #define ExecTimeX 42 #define KernTimeX 52 #define InteTimeX 62   #define StateBarWidth 7    /* Global references */ $ globalref long   EXE$GL_ABSTIM_TICS;$ globalref long   SMP$GL_ACTIVE_CPUS;$ globalref $CPU*  SMP$GL_CPU_DATA[1]; globalref long   PMS$GL_FAULTS;  globalref long   PMS$GL_PREADS;   globalref long   PMS$GL_PREADIO;  globalref long   PMS$GL_PWRITES;  globalref long   PMS$GL_PWRITIO;! globalref long   PMS$GL_DZROFLTS;   globalref long   SCH$GL_FREECNT; globalref long   SCH$GL_MFYCNT; * #define CURRENT_FAULTS     (PMS$GL_FAULTS)< #define CURRENT_PAGEIO     (PMS$GL_PREADIO + PMS$GL_PWRITIO)+ #define CURRENT_FREEPAGES  (SCH$GL_FREECNT) * #define CURRENT_MODPAGES   (SCH$GL_MFYCNT)     /* Function prototypes */    void init_application(void);  # void s_error(char* problem_string); = void get_something(Widget w, char* resource, XtArgVal value); = void set_something(Widget w, char* resource, XtArgVal value);   O void activate_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s); M void create_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s); M void cancel_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s); 0 void update( XtPointer data, XtIntervalId *id );  M void create_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s); O void exposure_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s); 9 void update_contproc( XtPointer data, XtIntervalId *id ); \ void toggle_contproc(Widget w, XtPointer client_data, XmToggleButtonCallbackStruct *toggle); void contproc_on(void);  void contproc_off(void);% void contproc_jpi_status(int status); 7 void doMainPopupMenu(Widget wdgt,XtPointer client_data, 8                      XEvent *event, Boolean *propogate); void DrawStateGraph(void);   int initialize_topproc(void);  int get_topproc(void); char *format_topproc(int top); int topproc_getPID(int top);  % void format_cputime (int t, char *s);   " void get_initial_kernelly_stuff(); void get_new_kernelly_stuff();   void init_cpu_times();C void get_cpu_times(long* null, long* user, long* super, long* exec, @                    long* kernel, long* interrupt, long* compat);@ void get_disk_opcnt(register long devnum, register long* count);3 void update_disk_name_label(Widget w, long devnum);   B GC MakeGC(Display* disp, Window wind, long fun, Pixel foreground);   /* Macros */* #define FAILED(status) (((status)&1) == 0) #define SIGNAL_ERROR(status)  \      {                         \        int ___status = status; \        if (FAILED(___status))  \        lib$signal(___status);  \      }   $ #define MAX_WIDGETS (MAX_WIDGET + 1)  K /* Macro to load up an element of a resource list for a resource enquiry */ @ #define PFM_LOAD_RESOURCE(res,rname,rclass,rtype,rsize,roffset,\.                           defrtype,defraddr) \ { \ K XtResource *_resptr = &(res); /* Only dereference actual resource once */ \ # _resptr->resource_name = (rname); \ % _resptr->resource_class = (rclass); \ # _resptr->resource_type = (rtype); \ # _resptr->resource_size = (rsize); \ ' _resptr->resource_offset = (roffset); \ % _resptr->default_type = (defrtype); \ % _resptr->default_addr = (defraddr); \  }    /* Global variables */  D typedef struct _vms_item_list {		/* Useful for creating item lists*/9     short	 buffer_length;		/* for system service calls */      short	 item_code;      void	*buffer;       int	*returned_buffer_length;     } VMS_ItemList;     static XtAppContext app_context;   static Screen  *screen;  static Display *dpy; static Window root_win;    static Bool     IsColour;   ) static Pixel state_colour_pxl[MX_STATES]; 3 static char *state_colour_suggestion[MX_STATES] = {    "YellowGreen",/* Null */0   "Lightgrey",  /* Compatibility - never seen */   "Black",      /* User mode */ %   "Blue",       /* Supervisor mode */ $   "Yellow",     /* Executive mode */!   "Orange",     /* Kernel mode */ $   "Red"         /* Interrupt mode */ };6 static char *state_colour_resource_name[MX_STATES] = {   "nullColour",     /* Null */4   "compColour",     /* Compatibility - never seen */#   "userColour",     /* User mode */ )   "superColour",    /* Supervisor mode */ (   "execColour",     /* Executive mode */%   "kernelColour",   /* Kernel mode */ (   "intColour"       /* Interrupt mode */ };7 static char *state_colour_resource_class[MX_STATES] = {    "NullColour",     /* Null */4   "CompColour",     /* Compatibility - never seen */#   "UserColour",     /* User mode */ )   "SuperColour",    /* Supervisor mode */ (   "ExecColour",     /* Executive mode */%   "KernelColour",   /* Kernel mode */ (   "IntColour"       /* Interrupt mode */ };  5 static char  *good_colour_suggestion = "ForestGreen"; , static char  *bad_colour_suggestion = "Red"; static Pixel good_colour_pxl;  static Pixel bad_colour_pxl;  D static Widget toplevel_widget;         /* Root widget ID of our   */D                                        /* application.            */D static Widget main_window_widget;      /* Root widget ID of main  */D                                        /* MrM fetch               */? static Widget main_popup_widget;       /* The popup exit box */ G static Widget contproc_widget;         /* The show proc/cont display */ D static Widget generic_message_widget;  /* generic message box     */D static Widget generic_caution_widget;  /* generic caution box     */D static Widget generic_wip_widget;      /* generic WIP box         */P static Widget widget_array[MAX_WIDGETS]; /* Place to keep all other widget IDs*/    static Display*  cpu_graph_disp;" static Display*  state_graph_disp;  static Window    cpu_graph_wind;" static Window    state_graph_wind;) static GC        cpu_graph_gc[MX_STATES]; + static GC        state_graph_gc[MX_STATES];   2 static XmString latin_create;  /* Variables for */6 static XmString latin_dismiss; /* compound strings. */ static XmString latin_space; static XmString latin_zero; F static MrmHierarchy  s_MrmHierarchy;   /* MrM database hierarchy ID */@ static MrmType dummy_class;            /* and class variable. */G static char* db_filename_vec[] =          /* MrM heirachy file list. */ N                {"PFM$DATA:perf_meter.uid" /* There is only one UID file for */A                };                         /* this application. */  static int db_filename_num =F                 (sizeof db_filename_vec / sizeof db_filename_vec [0]);    P static XtIntervalId contproc_IntervalId;  /* timeout interval id for contproc */L static int topproc;                       /* index into top process array */F static int topPID;                        /* PID of the top process */L static unsigned int timelast;             /* sys time for contproc update */  @ static Position contproc_x =  50;    /* Initial location of.. */> static Position contproc_y =  50;    /*  ..cont proc window */G static int contproc_update_secs = 2; /* Contproc updates every 2 sec */ N static int contproc_update_int;      /* Contproc updates every .. millisecs */  @ static Position main_xpos = 856;     /* Initial location of.. */= static Position main_ypos =  36;     /*  ..the main window */ I static int main_update_secs = 5;     /* Update secs from resource file */ Q static int main_update_int;          /* Main window updates every .. millisecs */    static long  last_user;  static long  last_super; static long  last_exec;  static long  last_kernel;  static long  last_interrupt; static long  last_compat;  static long  last_spin;  static long  last_idle;    static long  new_null; static long  new_user; static long  new_super;  static long  new_exec; static long  new_kernel; static long  new_interrupt;  static long  new_compat; static long  new_idle; static long  new_spin;  D static long total_time,NullTime,UserTime,SupeTime,ExecTime,KernTime,'              InteTime,CompTime,DeltaIO;   $ /* Used for the contproc routines */8 static long NewDirIO, DirIO, DeltaDirIO, LastDeltaDirIO;8 static long NewBufIO, BufIO, DeltaBufIO, LastDeltaBufIO;< static long NewPpgcnt, Ppgcnt, DeltaPpgcnt, LastDeltaPpgcnt;< static long NewGpgcnt, Gpgcnt, DeltaGpgcnt, LastDeltaGpgcnt;D static long NewPageflts, Pageflts, DeltaPageflts, LastDeltaPageflts;< static long NewCputim, Cputim, DeltaCputim, LastDeltaCputim;< static long NewWSSize, WSSize, DeltaWSSize, LastDeltaWSSize;@ static long NewPgfluse, Pgfluse, DeltaPgfluse, LastDeltaPgfluse;  & static int CPUPercent[MX_STATES][101];# static int CPUbase[MX_STATES][101];    static long Device_0_IO; static long Device_1_IO; static long Device_2_IO; static long Device_3_IO;   static long PageFaults;  static long PageIO;  static long FreePages; static long ModPages;   J /* The names and addresses of things that MrM has to bind. The names do */* /* not have to be in alphabetical order */# static MrmRegisterArg reglist[] = { 0   {"activate_proc",  (XtPointer) activate_proc},.   {"create_proc",    (XtPointer) create_proc},.   {"cancel_proc",    (XtPointer) cancel_proc},0   {"exposure_proc",  (XtPointer) exposure_proc},1   {"toggle_contproc",(XtPointer) toggle_contproc}  };< static int reglist_num = (sizeof reglist/sizeof reglist[0]); static char nodename[16];   P /*----------------------------------------------------------------------------*/P /* Main Program                                                               */P /*----------------------------------------------------------------------------*/
 #ifdef VMS #  ifdef __DECC  #    pragma message save$ #    pragma message disable portable #  endif  O /* The main routine does all the one-time setup and then calls XtAppMainLoop */ ! PerfMeter(int argc, char *argv[])  MAIN_PROGRAM   #  ifdef __DECC  #    pragma message restore  #  endif #else   9 int main(int argc, char *argv[]) /* Standard C version */    #endif {      register long i;     long          timeup_p;      static char   string[128];     static unsigned short nlen;      Pixmap bitmap;     Pixmap icon_pixmap;      GC gctemp;     XGCValues gcvalues;      XColor exact_colour;     int x_hot,y_hot;(     unsigned int icon_width,icon_height;     int istatus;     struct {!       unsigned short blen, icode;        char *baddr;       unsigned short int *rlen; H     } syi_itmlst[] = { {sizeof(nodename)-1,SYI$_SCSNODE,nodename,&nlen},,                        {0, 0, NULL, NULL} };     union {        char *string_ptr;        Bool bool;
     } urs;!     XtResource ursl[MX_STATES+1];      int arg;     Arg argl[4];   /*  End of declarations ... */   /*  Get nodename */ (     sys$getsyiw(0,0,0,syi_itmlst,0,0,0);M     for (i = nlen; (i >= 0) && (nodename[i] == ' ' || nodename[i] == 0); i--)      nodename[i] = '\0';   7 /*  Initialize MrM before initializing the X Toolkit */      MrmInitialize();  K /*  If we had user-defined widgets, we would register them with MrM here */   E /*  Initialize the X Toolkit. We get back a top level shell widget */ @     toplevel_widget = XtAppInitialize(&app_context,PROGRAM_NAME,@                                       (XrmOptionDescList)NULL,0,:                                       &argc,(String*)argv,4                                       (String*)NULL,.                                       NULL,0);   /*  Get the X server display */ %     dpy = XtDisplay(toplevel_widget);   L /*  Force synchronization of ALL X calls (use ONLY for DEBUG - very slow) */ /*    XSynchronize(dpy,TRUE);*/   # /*  Find screen for this display */ '     screen = XtScreen(toplevel_widget);   + /*  Find the root window for this screen */ +     root_win = XRootWindowOfScreen(screen);   ? /*  Check if we are on a colour or grey-scale system, or B+w */ A     if ( ( (XDefaultVisualOfScreen(screen)->class != PseudoColor) A         && (XDefaultVisualOfScreen(screen)->class != DirectColor) ?         && (XDefaultVisualOfScreen(screen)->class != TrueColor) D         && (XDefaultVisualOfScreen(screen)->class != GrayScale) ) ||         (argc > 1) ) {       IsColour = FALSE;      } else {       IsColour = TRUE;     }        if (IsColour) { @ /*    Create the colours for positive and negative increments */:       PFM_LOAD_RESOURCE(ursl[0],"goodColour","GoodColour",=                           XtRPixel,sizeof(Pixel),0,XtRString, 2                           good_colour_suggestion);P       XtGetApplicationResources(toplevel_widget,&good_colour_pxl,ursl,1,NULL,0);  8       PFM_LOAD_RESOURCE(ursl[0],"badColour","badColour",=                           XtRPixel,sizeof(Pixel),0,XtRString, 1                           bad_colour_suggestion); O       XtGetApplicationResources(toplevel_widget,&bad_colour_pxl,ursl,1,NULL,0);      } else {3       bad_colour_pxl = XBlackPixelOfScreen(screen); 4       good_colour_pxl = XBlackPixelOfScreen(screen);     }   / /*  Find the colours for different CPU modes */ %     for (i = 0; i < MX_STATES; i++) {        if (IsColour) { @         PFM_LOAD_RESOURCE(ursl[i],state_colour_resource_name[i],;                             state_colour_resource_class[i], O                             XtRPixel,sizeof(Pixel),(i*sizeof(Pixel)),XtRString, 8                             state_colour_suggestion[i]);       } else {:         state_colour_pxl[i] = XBlackPixelOfScreen(screen);       }      } M     if (IsColour) XtGetApplicationResources(toplevel_widget,state_colour_pxl, C                                             ursl,MX_STATES,NULL,0);    /*  Set title bar */2     sprintf(string,PROGRAM_TITLE_FORMAT,nodename);=     set_something(toplevel_widget,XmNtitle,(XtArgVal)string);e /*  Set icon name */F     sprintf(string,"%s V%s %s",PROGRAM_NAME,PROGRAM_VERSION,nodename);@     set_something(toplevel_widget,XmNiconName,(XtArgVal)string);   /*  Set icon pixmap */2 /*  Create a pixmap from the bitmap format data */3     sprintf(string,"PFM$DATA:PERF_METER_icon.xbm");i2     istatus = XReadBitmapFile(dpy,root_win,string,>               &icon_width,&icon_height,&bitmap,&x_hot,&y_hot);#     if (istatus == BitmapSuccess) {	8       gcvalues.foreground = XWhitePixelOfScreen(screen);8       gcvalues.background = XBlackPixelOfScreen(screen);K       gctemp = XCreateGC(dpy,root_win,GCForeground|GCBackground,&gcvalues);o/       icon_pixmap = XCreatePixmap(dpy,root_win,c>         icon_width,icon_height,XDefaultDepthOfScreen(screen));: /*    Now copy 1-plane pixmap (bitmap) to normal pixmap */3       XCopyPlane(dpy,bitmap,icon_pixmap,gctemp,0,0,*/                  icon_width,icon_height,0,0,1);o       XFreePixmap(dpy,bitmap);       XFreeGC(dpy,gctemp);?       set_something(toplevel_widget,XmNiconPixmap,icon_pixmap);t     } else {       icon_pixmap = 0;     }   K /*  Open the UID files (the output of the UIL compiler) in the hierarchy */oK     if (MrmOpenHierarchy(db_filename_num, /* Number of files.            */*K                          db_filename_vec, /* Array of file names.        */SK                          NULL,            /* Default OS extenstion.      */*K                          &s_MrmHierarchy) /* Pointer to returned MrM ID  *//         != MrmSUCCESS) {&       s_error("can't open hierarchy");       exit(EXIT_FAILURE);V     }e  ) /*  Initialize various data structures */f     init_application();        initialize_topproc();e  2 /*  Register the items MrM needs to bind for us */+     MrmRegisterNames(reglist, reglist_num);h  . /*  Go get the main part of the application */J     if (MrmFetchWidget(s_MrmHierarchy, "PERF_METER_MAIN", toplevel_widget,H                        &main_window_widget, &dummy_class) != MrmSUCCESS)+         s_error("can't fetch main window");<  # /*  Get the sho proc/cont widget */aK     if (MrmFetchWidget(s_MrmHierarchy, "CONTPROC_MAIN", main_window_widget,_E                        &contproc_widget, &dummy_class) != MrmSUCCESS) /         s_error("can't fetch contproc_widget");_  N /*  Manage main window,realize everything. Interface appears on the display */&     XtManageChild(main_window_widget);  A /*  Get the user specified resources from the default database */n   /*  Main window */#     sprintf(string,"%d",main_xpos);I,     PFM_LOAD_RESOURCE(ursl[0],"xpos","Xpos",I                         XtRPosition,sizeof(Position),0,XtRString,string);_H     XtGetApplicationResources(toplevel_widget,&main_xpos,ursl,1,NULL,0);#     sprintf(string,"%d",main_ypos);i,     PFM_LOAD_RESOURCE(ursl[0],"ypos","Ypos",I                         XtRPosition,sizeof(Position),0,XtRString,string);fH     XtGetApplicationResources(toplevel_widget,&main_ypos,ursl,1,NULL,0);2     set_something(toplevel_widget,XmNx,main_xpos);2     set_something(toplevel_widget,XmNy,main_ypos);  *     sprintf(string,"%d",main_update_secs);<     PFM_LOAD_RESOURCE(ursl[0],"UpdatePeriod","UpdatePeriod",?                         XtRInt,sizeof(int),0,XtRString,string);IO     XtGetApplicationResources(toplevel_widget,&main_update_secs,ursl,1,NULL,0);l,     main_update_int = main_update_secs*1000;   /*  ContProc window */$     sprintf(string,"%d",contproc_x);8     PFM_LOAD_RESOURCE(ursl[0],"contproc_x","ContProc_x",I                         XtRPosition,sizeof(Position),0,XtRString,string);tI     XtGetApplicationResources(toplevel_widget,&contproc_x,ursl,1,NULL,0);r$     sprintf(string,"%d",contproc_y);8     PFM_LOAD_RESOURCE(ursl[0],"contproc_y","ContProc_y",I                         XtRPosition,sizeof(Position),0,XtRString,string);iI     XtGetApplicationResources(toplevel_widget,&contproc_y,ursl,1,NULL,0);X3     set_something(contproc_widget,XmNx,contproc_x);o3     set_something(contproc_widget,XmNy,contproc_y);C  .     sprintf(string,"%d",contproc_update_secs);L     PFM_LOAD_RESOURCE(ursl[0],"ContProcUpdatePeriod","ContProcUpdatePeriod",?                         XtRInt,sizeof(int),0,XtRString,string);rS     XtGetApplicationResources(toplevel_widget,&contproc_update_secs,ursl,1,NULL,0);n4     contproc_update_int = contproc_update_secs*1000;  %     XtRealizeWidget(toplevel_widget);t  0 /*  Get windows and set up GCs for the graphs */;     cpu_graph_wind = XtWindow(widget_array[PFM_CPU_GRAPH]);d%     for (i = 0; i < MX_STATES; i++) {i=       cpu_graph_gc[i] = MakeGC(cpu_graph_disp,cpu_graph_wind,a;                                GXcopy,state_colour_pxl[i]);i     }n?     state_graph_wind = XtWindow(widget_array[PFM_STATE_GRAPH]);_%     for (i = 0; i < MX_STATES; i++) { C       state_graph_gc[i] = MakeGC(state_graph_disp,state_graph_wind,w=                                  GXcopy,state_colour_pxl[i]);s     }n  # /*  Get the sho proc/cont widget */cH     if (MrmFetchWidget(s_MrmHierarchy, "MAIN_POPUP", main_window_widget,G                        &main_popup_widget, &dummy_class) != MrmSUCCESS)_1         s_error("can't fetch main_popup_widget");G  %     /* Hook up the main popup menu */i>     XtAddEventHandler (main_window_widget, ButtonPressMask, 0,' 			doMainPopupMenu, main_popup_widget);)  N /*  Add timeout callback that will be called every main_update_secs seconds */>     XtAppAddTimeOut( app_context, main_update_int, update, 0);  ) /*  Enter the continous event loop ... */      XtAppMainLoop(app_context);  }e rP /*----------------------------------------------------------------------------*/P /* One-time initialization of application data structures                     */P /*----------------------------------------------------------------------------*/ void init_application(void)s {-
     int k; /*  End of declarations ... */  =     for (k = 0; k < MAX_WIDGETS; k++) widget_array[k] = NULL;r     init_cpu_times();= }o eP /*----------------------------------------------------------------------------*/P /* Error reporter - All errors are fatal.                                     */P /*----------------------------------------------------------------------------*/" void s_error(char* problem_string) {u /*  End of declarations ... */#     printf("%s\n", problem_string);t     exit(EXIT_FAILURE);x }  tP /*----------------------------------------------------------------------------*/P /* Simplified SET VALUE routine to use only when changing a single attribute. */P /* If we need to change more than one, all new values should be put into one  */P /* arglist and we should make one XtSetValues call (MUCH more efficient).     */P /*----------------------------------------------------------------------------*/< void set_something(Widget w, char* resource, XtArgVal value) {c     Arg al[1]; /*  End of declarations ... */  %     XtSetArg(al[0], resource, value);C     XtSetValues(w, al, 1); }n rP /*----------------------------------------------------------------------------*/P /* Simplified SET VALUE routine to use only when changing a label widget's    */P /* label string.  Does a Latin1 String and frees the compound string after    */P /* setting label value                                                        */P /*----------------------------------------------------------------------------*/% void set_label(Widget w, char* value)E {C     Arg al[1];     XmString latin_label;C /*  End of declarations ... */  ?     latin_label = XmStringLtoRCreate(value,XmFALLBACK_CHARSET);l1     XtSetArg(al[0], XmNlabelString, latin_label);_     XtSetValues(w, al, 1);     XmStringFree(latin_label); }t    3 /*  Set label widget using index in widget array */;+ void set_label_str (char *value, int w_idx)  {      Arg al[1];     XmString CStr; /*  End of declarations ... */8     CStr = XmStringLtoRCreate(value,XmFALLBACK_CHARSET);*     XtSetArg(al[0], XmNlabelString, CStr);,     XtSetValues(widget_array[w_idx], al, 1);     XmStringFree(CStr);  }  uP /*----------------------------------------------------------------------------*/P /* process_num() handles all of the repetitive stuff needed to track          */P /* what's changed from update to update.  We also update the widget           */P /* label if something has changed since the last time.                        */P /*----------------------------------------------------------------------------*/? void process_num(long *NewValue, long *Value, long *DeltaValue,g4 		 long *LastDeltaValue, int ValueIdx, int DeltaIdx," 		 char *ValueFmt, char *DeltaFmt) {t     char label_buffer[15];     int first_time;t /*  End of declarations ... */  %     *DeltaValue = *NewValue - *Value;m     first_time = !(*Value);      if (*DeltaValue) {       *Value = *NewValue;_/       sprintf (label_buffer, ValueFmt, *Value); .       set_label_str( label_buffer, ValueIdx );     }s+     if ( *DeltaValue != *LastDeltaValue ) {c,       if (*DeltaValue == 0 || first_time ) {         label_buffer[0] = ' ';         label_buffer[1] = '\0';*       } else {6         sprintf (label_buffer, DeltaFmt, *DeltaValue);       }t.       set_label_str( label_buffer, DeltaIdx );  $       *LastDeltaValue = *DeltaValue;     }i }f _P /*----------------------------------------------------------------------------*/P /* Simplified GET VALUE routine to use only when retrieving a SINGLE attribute*/P /*----------------------------------------------------------------------------*/< void get_something(Widget w, char* resource, XtArgVal value) {o     Arg al[1]; /*  End of declarations ... */  %     XtSetArg(al[0], resource, value);      XtGetValues(w, al, 1); }0  P /*----------------------------------------------------------------------------*/P /* All widgets that are created call back to this procedure. We just log the  */P /* ID in the global array.                                                    */P /*----------------------------------------------------------------------------*/L void create_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s) {a)     int widget_num = *(int *)client_data;r /*  End of declarations ... */  !     widget_array[widget_num] = w;e       switch ( widget_num ) {t       case PFM_CPU_GRAPH:t&         cpu_graph_disp = XtDisplay(w);         break;       case PFM_STATE_GRAPH:t(         state_graph_disp = XtDisplay(w);         break;%       case PFM_DEVICE_0_IOCOUNT_NAME: %         update_disk_name_label(w, 0);w         break;%       case PFM_DEVICE_1_IOCOUNT_NAME:w%         update_disk_name_label(w, 1);c         break;%       case PFM_DEVICE_2_IOCOUNT_NAME:r%         update_disk_name_label(w, 2);          break;%       case PFM_DEVICE_3_IOCOUNT_NAME:o%         update_disk_name_label(w, 3);O         break;         default:       break;     }f   }u ,P /*----------------------------------------------------------------------------*/P /* exposure_proc() handles exposure events for the cpu histogram and          */P /* state graph.  This is called whenever the window receives an               */P /* exposure event.   We need to redraw the graphics  ourselves.               */P /*----------------------------------------------------------------------------*/O void exposure_proc (Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s)  { 
     int i;     int ix;      int index; /*  End of declarations ... */        index = *(int *)client_data;     switch ( index ) {       case PFM_CPU_GRAPH:l&         for (ix = 0; ix < 100; ix++) {+           for (i = 0; i < MX_STATES; i++) {r             if (i == 0) { E               XClearArea(cpu_graph_disp,cpu_graph_wind,ix,0,1,100,0);e             } else {&               if (CPUPercent[i][ix]) {M                 XFillRectangle(cpu_graph_disp,cpu_graph_wind,cpu_graph_gc[i],eM                 ix,100-CPUPercent[i][ix]-CPUbase[i][ix],1,CPUPercent[i][ix]);c               }e
             }r           }t	         }i         break;       case PFM_STATE_GRAPH:          DrawStateGraph();          break;     }- }- -P /*----------------------------------------------------------------------------*/P /* All push buttons in this application call back to this routine.  We        */P /* use the client_data to tell us what widget it is, then react accordingly.  */P /*----------------------------------------------------------------------------*/N void activate_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s) {eI     int widget_num = *(int *)client_data; /* Convert to widget number. */  /*  End of declarations ... */       switch ( widget_num ) {a/       case PFM_EXIT_BUTTON: exit(EXIT_SUCCESS);        default: break;      }  }  iP /*----------------------------------------------------------------------------*/P /* Not used, apparently                                                       */P /*----------------------------------------------------------------------------*/L void cancel_proc(Widget w, XtPointer client_data, XmAnyCallbackStruct *cb_s) { I     int widget_num = *(int *)client_data; /* Convert to widget number. */e /*  End of declarations ... */       switch ( widget_num ) {        default: break;      }  }o  P /*----------------------------------------------------------------------------*/P /* Update the performance meter main statistics - called as a timer callback  */P /*----------------------------------------------------------------------------*// void update( XtPointer data, XtIntervalId *id )0 {i     register int i,j; @     static long NewNullTime,NewUserTime,NewSupeTime,NewExecTime,4                 NewKernTime,NewInteTime,NewCompTime,G                 NewDevice_0_IO, DeltaDevice_0_IO, LastDeltaDevice_0_IO,TG                 NewDevice_1_IO, DeltaDevice_1_IO, LastDeltaDevice_1_IO,tG                 NewDevice_2_IO, DeltaDevice_2_IO, LastDeltaDevice_2_IO, G                 NewDevice_3_IO, DeltaDevice_3_IO, LastDeltaDevice_3_IO,a5                 LastDeltaPageFaults, LastDeltaPageIO, 6                 LastDeltaFreePages, LastDeltaModPages;  =     long NewPageFaults,DeltaPageFaults,NewPageIO,DeltaPageIO,(&          NewFreePages, DeltaFreePages,1          NewModPages, DeltaModPages, NewDispFlag;l     int ix;      long CPUtime[MX_STATES];     char *label_topproc;!     static char label_buffer[32];o     XmString cs; /*  End of declarations ... */  F     get_cpu_times(&NewNullTime,&NewUserTime,&NewSupeTime,&NewExecTime,:                   &NewKernTime,&NewInteTime,&NewCompTime);#     NewPageFaults = CURRENT_FAULTS;)#     NewPageIO     = CURRENT_PAGEIO;(&     NewFreePages  = CURRENT_FREEPAGES;%     NewModPages   = CURRENT_MODPAGES;u  H     total_time = NewNullTime + NewUserTime + NewSupeTime + NewExecTime +1          NewKernTime + NewInteTime + NewCompTime;      if (total_time > 0) {L2       NullTime = (NewNullTime * 100) / total_time;2       UserTime = (NewUserTime * 100) / total_time;2       SupeTime = (NewSupeTime * 100) / total_time;2       ExecTime = (NewExecTime * 100) / total_time;2       KernTime = (NewKernTime * 100) / total_time;2       InteTime = (NewInteTime * 100) / total_time;2       CompTime = (NewCompTime * 100) / total_time;     }_
     else {       NullTime = NewNullTime;D       UserTime = NewUserTime;b       SupeTime = NewSupeTime;        ExecTime = NewExecTime;X       KernTime = NewKernTime;        InteTime = NewInteTime;        CompTime = NewCompTime;(     }l       CPUtime[0] = NullTime;     CPUtime[1] = CompTime;     CPUtime[2] = UserTime;     CPUtime[3] = SupeTime;     CPUtime[4] = ExecTime;     CPUtime[5] = KernTime;     CPUtime[6] = InteTime;  "     for (ix = 0; ix < 100; ix++) {'       for (i = 0; i < MX_STATES; i++) {o         CPUbase[i][100] = 0;!         CPUPercent[i][100] = 100;_)         for (j = 0; j < MX_STATES; j++) {_7           if (j != i) CPUPercent[i][100] -= CPUtime[j];t	         }o         if (i == 0) {lA           XClearArea(cpu_graph_disp,cpu_graph_wind,ix,0,1,100,0);[         } else {F           if (i > 1) CPUbase[i][100] = CPUtime[i-1]+CPUbase[i-1][100];2           CPUPercent[i][ix] = CPUPercent[i][ix+1];,           CPUbase[i][ix] = CPUbase[i][ix+1];"           if (CPUPercent[i][ix]) {I             XFillRectangle(cpu_graph_disp,cpu_graph_wind,cpu_graph_gc[i],MI             ix,100-CPUPercent[i][ix]-CPUbase[i][ix],1,CPUPercent[i][ix]);V           } 	         }n       }      }i   /*  Get latest top process */M     topproc = get_topproc();,     label_topproc = format_topproc(topproc);7     set_label_str (label_topproc, PFM_CONTPROC_TOGGLE);a       DrawStateGraph();o  =     if ((widget_array[PFM_DEVICE_0_IOCOUNT_TOTAL] != NULL) &&i6 	(widget_array[PFM_DEVICE_0_IOCOUNT_DELTA] != NULL)) {)       get_disk_opcnt(0, &NewDevice_0_IO);p[       process_num (&NewDevice_0_IO, &Device_0_IO, &DeltaDevice_0_IO, &LastDeltaDevice_0_IO,e]                    PFM_DEVICE_0_IOCOUNT_TOTAL, PFM_DEVICE_0_IOCOUNT_DELTA, " %10d", "  %4d");r     }d    =     if ((widget_array[PFM_DEVICE_1_IOCOUNT_TOTAL] != NULL) &&a=         (widget_array[PFM_DEVICE_1_IOCOUNT_DELTA] != NULL)) {t)       get_disk_opcnt(1, &NewDevice_1_IO); [       process_num (&NewDevice_1_IO, &Device_1_IO, &DeltaDevice_1_IO, &LastDeltaDevice_1_IO,e]                    PFM_DEVICE_1_IOCOUNT_TOTAL, PFM_DEVICE_1_IOCOUNT_DELTA, " %10d", "  %4d");      }G  =     if ((widget_array[PFM_DEVICE_2_IOCOUNT_TOTAL] != NULL) &&,=         (widget_array[PFM_DEVICE_2_IOCOUNT_DELTA] != NULL)) { )       get_disk_opcnt(2, &NewDevice_2_IO);I[       process_num (&NewDevice_2_IO, &Device_2_IO, &DeltaDevice_2_IO, &LastDeltaDevice_2_IO,s]                    PFM_DEVICE_2_IOCOUNT_TOTAL, PFM_DEVICE_2_IOCOUNT_DELTA, " %10d", "  %4d");      }   =     if ((widget_array[PFM_DEVICE_3_IOCOUNT_TOTAL] != NULL) &&*6 	(widget_array[PFM_DEVICE_3_IOCOUNT_DELTA] != NULL)) {)       get_disk_opcnt(3, &NewDevice_3_IO);C[       process_num (&NewDevice_3_IO, &Device_3_IO, &DeltaDevice_3_IO, &LastDeltaDevice_3_IO,t]                    PFM_DEVICE_3_IOCOUNT_TOTAL, PFM_DEVICE_3_IOCOUNT_DELTA, " %10d", "  %4d");*     }t  U     process_num (&NewPageFaults, &PageFaults, &DeltaPageFaults, &LastDeltaPageFaults, O                  PFM_PAGEFAULTS_TOTAL, PFM_PAGEFAULTS_DELTA, " %10d", "  %4d");rC     set_something(widget_array[PFM_PAGEFAULTS_DELTA],XmNforeground,nM                   (DeltaPageFaults > 0) ? bad_colour_pxl : good_colour_pxl );   E     process_num (&NewPageIO, &PageIO, &DeltaPageIO, &LastDeltaPageIO,tG                  PFM_PAGEIO_TOTAL, PFM_PAGEIO_DELTA, " %10d", "  %4d"); ?     set_something(widget_array[PFM_PAGEIO_DELTA],XmNforeground,rI                   (DeltaPageIO > 0) ? bad_colour_pxl : good_colour_pxl );y  Q     process_num (&NewFreePages, &FreePages, &DeltaFreePages, &LastDeltaFreePages, M                  PFM_FREEPAGES_TOTAL, PFM_FREEPAGES_DELTA, " %10d", "  %4d");wB     set_something(widget_array[PFM_FREEPAGES_DELTA],XmNforeground,L                   (DeltaFreePages < 0) ? bad_colour_pxl : good_colour_pxl );  M     process_num (&NewModPages, &ModPages, &DeltaModPages, &LastDeltaModPages,uK                  PFM_MODPAGES_TOTAL, PFM_MODPAGES_DELTA, " %10d", "  %4d");rA     set_something(widget_array[PFM_MODPAGES_DELTA],XmNforeground,sM                     (DeltaModPages > 0) ? bad_colour_pxl : good_colour_pxl );i  >     XtAppAddTimeOut( app_context, main_update_int, update, 0); }p ;P /*----------------------------------------------------------------------------*/P /* Draw the cpu state graph                                                   */P /*----------------------------------------------------------------------------*/ void DrawStateGraph(void), {i
     int i; /*  End of declarations ... */  F     XClearArea(state_graph_disp,state_graph_wind,NullTimeX,0,7,100,0);G     XFillRectangle(state_graph_disp,state_graph_wind,state_graph_gc[0],r6                    NullTimeX,100-NullTime,7,NullTime);F     XClearArea(state_graph_disp,state_graph_wind,CompTimeX,0,7,100,0);G     XFillRectangle(state_graph_disp,state_graph_wind,state_graph_gc[1], 6                    CompTimeX,100-CompTime,7,CompTime);F     XClearArea(state_graph_disp,state_graph_wind,UserTimeX,0,7,100,0);G     XFillRectangle(state_graph_disp,state_graph_wind,state_graph_gc[2],)6                    UserTimeX,100-UserTime,7,UserTime);F     XClearArea(state_graph_disp,state_graph_wind,SupeTimeX,0,7,100,0);G     XFillRectangle(state_graph_disp,state_graph_wind,state_graph_gc[3],U6                    SupeTimeX,100-SupeTime,7,SupeTime);F     XClearArea(state_graph_disp,state_graph_wind,ExecTimeX,0,7,100,0);G     XFillRectangle(state_graph_disp,state_graph_wind,state_graph_gc[4],c6                    ExecTimeX,100-ExecTime,7,ExecTime);F     XClearArea(state_graph_disp,state_graph_wind,KernTimeX,0,7,100,0);G     XFillRectangle(state_graph_disp,state_graph_wind,state_graph_gc[5], 6                    KernTimeX,100-KernTime,7,KernTime);F     XClearArea(state_graph_disp,state_graph_wind,InteTimeX,0,7,100,0);G     XFillRectangle(state_graph_disp,state_graph_wind,state_graph_gc[6],(6                    InteTimeX,100-InteTime,7,InteTime); }A ;P /*----------------------------------------------------------------------------*/P /* Create a Graphics Context with appropriate function and foreground         */P /*----------------------------------------------------------------------------*/A GC MakeGC(Display* disp, Window wind, long fun, Pixel foreground)m {l     XColor colour,exact_colour;r     XGCValues gcvalues;u /*  End of declarations ... */  &     gcvalues.foreground = foreground;;     gcvalues.function = fun;C     return(XCreateGC(disp,wind,GCFunction|GCForeground,&gcvalues));i }u aP /*----------------------------------------------------------------------------*/P /* Get first set of CPU stats by setting up a kernel mode routine             */P /*----------------------------------------------------------------------------*/ void init_cpu_times()- {- /*  End of declarations ... */  G     last_user = last_super = last_exec = last_kernel = last_interrupt =-,     last_compat = last_spin = last_idle = 0;  2     sys$cmkrnl(&get_initial_kernelly_stuff, NULL);        last_interrupt -= last_idle; }a iP /*----------------------------------------------------------------------------*/P /* This is called at Kernel mode to actually look up the information          */P /*----------------------------------------------------------------------------*/! void get_initial_kernelly_stuff()- {-     register   i, j, k;-     long      *PMS$GL_KERNEL;- /*  End of declarations ... */  B     for (k = SMP$GL_ACTIVE_CPUS, j = 0; k != 0; j++, k = k >> 1) {"       if ((k & 01) == 0) continue; #ifdef __ALPHA9       PMS$GL_KERNEL = (SMP$GL_CPU_DATA[j])->cpu$q_kernel;-       last_compat = 0; #elsel9       PMS$GL_KERNEL = (SMP$GL_CPU_DATA[j])->cpu$l_kernel;a+       last_compat += PMS$GL_KERNEL[C_TIME];a #endif+       last_kernel += PMS$GL_KERNEL[K_TIME];a)       last_exec += PMS$GL_KERNEL[E_TIME];a*       last_super += PMS$GL_KERNEL[S_TIME];)       last_user += PMS$GL_KERNEL[U_TIME];-.       last_interrupt += PMS$GL_KERNEL[I_TIME];,       last_spin += PMS$GL_KERNEL[SPIN_TIME];7 /*    here is where the null CPU time is collected.  */e,       last_idle += PMS$GL_KERNEL[IDLE_TIME];     }, }; nP /*----------------------------------------------------------------------------*/P /* Get next set of CPU stats by setting up a kernel mode routine              */P /*----------------------------------------------------------------------------*/C void get_cpu_times(long* null, long* user, long* super, long* exec, F                           long* kernel, long* interrupt, long* compat) {-     register long  new_abstime;l     register long  totaltime;C /*  End of declarations ... */  B     new_user = new_super = new_exec = new_kernel = new_interrupt =)     new_compat = new_spin = new_idle = 0;   .     sys$cmkrnl(&get_new_kernelly_stuff, NULL);       new_interrupt -= new_idle;  7     *user = new_user - last_user; last_user = new_user;i<     *super = new_super - last_super; last_super = new_super;7     *exec = new_exec - last_exec; last_exec = new_exec; A     *kernel = new_kernel - last_kernel; last_kernel = new_kernel;AP     *interrupt = new_interrupt - last_interrupt; last_interrupt = new_interrupt;A     *compat = new_compat - last_compat; last_compat = new_compat;-  7     *null = new_idle - last_idle; last_idle = new_idle;- }- -P /*----------------------------------------------------------------------------*/P /* This is called at Kernel mode to actually look up the information          */P /*----------------------------------------------------------------------------*/ void get_new_kernelly_stuff()- {-     register   i, j, k;-     long      *PMS$GL_KERNEL;p   /*  End of declarations ... */  B     for (k = SMP$GL_ACTIVE_CPUS, j = 0; k != 0; j++, k = k >> 1) {"       if ((k & 01) == 0) continue; #ifdef __ALPHA;         PMS$GL_KERNEL = (SMP$GL_CPU_DATA[j])->cpu$q_kernel;c         new_compat = 0;D #elseu;         PMS$GL_KERNEL = (SMP$GL_CPU_DATA[j])->cpu$l_kernel;f,         new_compat += PMS$GL_KERNEL[C_TIME]; #endif,         new_kernel += PMS$GL_KERNEL[K_TIME];*         new_exec += PMS$GL_KERNEL[E_TIME];+         new_super += PMS$GL_KERNEL[S_TIME];u*         new_user += PMS$GL_KERNEL[U_TIME];/         new_interrupt += PMS$GL_KERNEL[I_TIME]; -         new_spin += PMS$GL_KERNEL[SPIN_TIME]; -         new_idle += PMS$GL_KERNEL[IDLE_TIME];;     }  }   P /*----------------------------------------------------------------------------*/P /* Get disk IO operations                                                     */P /*----------------------------------------------------------------------------*/? void get_disk_opcnt(register long devnum, register long* count)- {-     static struct {-       unsigned short  blen;d       unsigned short  icode;       long*           buff;        unsigned short* rlen;/=     } dvi_itmlst[] = { {sizeof(int), DVI$_OPCNT, NULL, NULL},a,                        {0, 0, NULL, NULL} };     static struct {-       unsigned short  istat;       unsigned short  bytes;       long            fill;.     } iosb;t     static char devname[64];     $DESCRIPTOR(dev,devname);      long   status; /*  End of declarations ... */  3     sprintf(devname, "PFM$DEVICE_%d_NAME", devnum);/     dvi_itmlst[0].buff = count;i     *count = -1;'     dev.dsc$w_length = strlen(devname);i:     status = sys$getdviw(0,0,&dev,dvi_itmlst,&iosb,0,0,0);4     if ((status == SS$_IVDEVNAM) && (devnum == 0)) {,       $DESCRIPTOR(sysdev, "SYS$SYSDEVICE:");6       sys$getdviw(0,0,&sysdev,dvi_itmlst,&iosb,0,0,0);     }  }a PP /*----------------------------------------------------------------------------*/P /* Set title for monitored disk IO                                            */P /*----------------------------------------------------------------------------*/2 void update_disk_name_label(Widget w, long devnum) {A     char   devname[64];_     char*  title;  /*  End of declarations ... */  4     sprintf(devname, "PFM$DEVICE_%d_TITLE", devnum);     title = getenv(devname);     if (NULL == title) {5       sprintf(devname, "PFM$DEVICE_%d_NAME", devnum);-       title = getenv(devname);E       if ((NULL == title) && (0 == devnum)) title = "SYS$SYSDEVICE:";o     }d*     if (title != NULL) set_label(w,title); }h vP /*----------------------------------------------------------------------------*/P /* This callback is invoked when user clicks on the `contproc' toggle         */P /*----------------------------------------------------------------------------*/\ void toggle_contproc (Widget w, XtPointer client_data, XmToggleButtonCallbackStruct *toggle) {  /*  End of declarations ... */H     contproc_off();                  /* Turn off any existing display */D     if (toggle->set) contproc_on (); /* Turn display on if needed */ }X AP /*----------------------------------------------------------------------------*/P /* Procecures to turn 'show proc/cont' display off, unmanaging the dialog box */P /*----------------------------------------------------------------------------*/ void contproc_off(void)  {1 /*  End of declarations ... */  $     if ( contproc_IntervalId != 0) {+       XtRemoveTimeOut(contproc_IntervalId);i       contproc_IntervalId = 0;     }G     if (contproc_widget!=0) {)B       /* Save the window position so we can put it back exactly */B       /* where the use last moved it to, otherwise, it pops up  */       /* all over the place. */o*       if (XtIsManaged (contproc_widget)) {O         get_something (XtParent(contproc_widget), XmNx, (XtArgVal)&contproc_x);-O         get_something (XtParent(contproc_widget), XmNy, (XtArgVal)&contproc_y);_*         XtUnmanageChild (contproc_widget);       }r     }_ }   P /*----------------------------------------------------------------------------*/P /* contrproc_on()  initializes the 'show proc/cont' display.  That is,        */P /* it looks up the static information for this process, zeros our counters,   */P /* realizes the window, and makes the initial call to the contproc_update     */P /* procedure.                                                                 */P /*----------------------------------------------------------------------------*/ void contproc_on(void) {_     char text[100];r!     int userlen, prcstrt, status;=     unsigned int timequad[2];t       static int pid; )     static char username[12], prcnam[15];h2     static VMS_ItemList JPI_static_itemlist[4] = {1         sizeof(pid),      JPI$_PID,      &pid, 0,-6         sizeof(username), JPI$_USERNAME, &username, 0,4         sizeof(prcnam),   JPI$_PRCNAM,   &prcnam, 0,         0, 0, 0, 0}; /*  End of declarations ... */  J /*  Zero out `previous' values so process_num doesn't give silly deltas */     DirIO = 0;     BufIO = 0;     Ppgcnt = 0;l     Gpgcnt = 0;e     Pageflts = 0;m     Cputim = 0;      WSSize = 0;K     Pgfluse = 0;  7     sys$gettim(&timequad[0]);		/* To calc % cpu used */_     timelast = timequad[0];   I     /* Remember the PID of the top user - we monitor this same process */ +     /* as long the this window is active */ &     topPID = topproc_getPID (topproc);  F     status = sys$getjpiw (0, &topPID, 0, &JPI_static_itemlist, 0,0,0);     if (status != SS$_NORMAL)a	         { %         contproc_jpi_status (status);t         return; 	         }e  ,     /* Trim trailing spaces from username */T     for (userlen=0; userlen<=sizeof(username) && username[userlen]!=' '; userlen++);  /     /* Trim leading spaces from process name */ P     for (prcstrt=0; prcstrt<=sizeof(prcnam) && prcnam[prcstrt]==' '; prcstrt++);  <     sprintf (text, "PID: %08X  User: %.*s  Process: %.*s\0",F 	pid, userlen, username,  (sizeof(prcnam)-prcstrt), (prcnam+prcstrt));&     set_label_str (text, PFM_HEADER1);  4     /* Put the window back where it was last time */$     XtManageChild (contproc_widget);@     set_something (XtParent(contproc_widget), XmNx, contproc_x);@     set_something (XtParent(contproc_widget), XmNy, contproc_y);&     XtRealizeWidget (contproc_widget);  >     DirIO = LastDeltaDirIO = BufIO = LastDeltaBufIO = Ppgcnt =5         LastDeltaPpgcnt = Gpgcnt = LastDeltaGpgcnt = /B         Pageflts = LastDeltaPageflts = Cputim = LastDeltaCputim = ; 	WSSize = LastDeltaWSSize = Pgfluse = LastDeltaPgfluse = 0;i  :     update_contproc(NULL, NULL);		/* get things rolling */ }T  P /*----------------------------------------------------------------------------*/P /* Timer callback to update stats for cont. monitored `top CPU' process       */P /*----------------------------------------------------------------------------*/8 void update_contproc( XtPointer data, XtIntervalId *id ) {o     int status, tmp;%     char CputimStr[12], CpupctStr[6];].     static unsigned int timequad[2], timediff;  -     static int imaglen, pagfilcnt, pgflquota;      static char imagname[80]; 5     static VMS_ItemList JPI_contproc_itemlist[10] = {+9         sizeof(NewDirIO),    JPI$_DIRIO,    &NewDirIO, 0,b9         sizeof(NewBufIO),    JPI$_BUFIO,    &NewBufIO, 0, :         sizeof(NewCputim),   JPI$_CPUTIM,   &NewCputim, 0,:         sizeof(NewPpgcnt),   JPI$_PPGCNT,   &NewPpgcnt, 0,:         sizeof(NewGpgcnt),   JPI$_GPGCNT,   &NewGpgcnt, 0,3 	sizeof(pagfilcnt),   JPI$_PAGFILCNT,&pagfilcnt, 0, 3 	sizeof(pgflquota),   JPI$_PGFLQUOTA,&pgflquota, 0,;<         sizeof(NewPageflts), JPI$_PAGEFLTS, &NewPageflts, 0,@         sizeof(imagname),    JPI$_IMAGNAME, &imagname, &imaglen,         0, 0, 0, 0}; /*  End of declarations ... */  B     /* We need the change in system time to calc the % cpu used */     sys$gettim (&timequad[0]);&     timediff = timequad[0] - timelast;     timelast = timequad[0];p  /     /* Now get the stats for the top process */_H     status = sys$getjpiw (0, &topPID, 0, &JPI_contproc_itemlist, 0,0,0);     if (status != SS$_NORMAL)t	         {o%         contproc_jpi_status (status);I         return;N	         }(  8     /* It makes more sense to me to see page file use *//     /* instead of page file quota remaining. */s'     NewPgfluse = pgflquota - pagfilcnt;l  E     /* We show process and group page counts, but it's also useful */O-     /* to see the totaled working set size */"&     NewWSSize = NewPpgcnt + NewGpgcnt;    H     process_num (&NewPpgcnt, &Ppgcnt, &DeltaPpgcnt, &LastDeltaPpgcnt,   6 		 PFM_PPGCNT_TOTAL, PFM_PPGCNT_DELTA,  "%8d", "%8d");H     process_num (&NewGpgcnt, &Gpgcnt, &DeltaGpgcnt, &LastDeltaGpgcnt,   6 		 PFM_GPGCNT_TOTAL, PFM_GPGCNT_DELTA,  "%8d", "%8d");H     process_num (&NewWSSize, &WSSize, &DeltaWSSize, &LastDeltaWSSize,   6 		 PFM_WSSIZE_TOTAL, PFM_WSSIZE_DELTA,  "%8d", "%8d");N     process_num (&NewPageflts, &Pageflts, &DeltaPageflts, &LastDeltaPageflts, 8 		 PFM_PGFAULTS_TOTAL, PFM_PGFAULTS_DELTA,"%8d", "%8d");J     process_num (&NewPgfluse, &Pgfluse, &DeltaPgfluse, &LastDeltaPgfluse, 6 		 PFM_PGFLUSE_TOTAL, PFM_PGFLUSE_DELTA,"%8d", "%8d");E     process_num (&NewDirIO, &DirIO, &DeltaDirIO, &LastDeltaDirIO,    f5 		 PFM_DIRIO_TOTAL, PFM_DIRIO_DELTA,   "%8d", "%8d");*A     process_num (&NewBufIO, &BufIO, &DeltaBufIO, &LastDeltaBufIO,_7     		 PFM_BUFIO_TOTAL, PFM_BUFIO_DELTA, "%8d", "%8d");D  *     format_cputime (NewCputim, CputimStr);1     set_label_str (CputimStr, PFM_CPUTIME_TOTAL);C       if ( Cputim ) {D'       DeltaCputim = NewCputim - Cputim;*     } else {       DeltaCputim = 0;     }&     Cputim = NewCputim;l"     LastDeltaCputim = DeltaCputim;     tmp = timediff / 100000;M     sprintf (CpupctStr, " %3d%%\0", (DeltaCputim*100+50) / (tmp ? tmp : 1) );P1     set_label_str (CpupctStr, PFM_CPUTIME_DELTA);        imagname[imaglen] = '\0';r*     set_label_str (imagname, PFM_HEADER2);
              &     contproc_IntervalId =DL       XtAppAddTimeOut(app_context, contproc_update_int, update_contproc, 0); }d  P /*----------------------------------------------------------------------------*/P /* Find state of monitored process, adjust monitoring accordingly             */P /*----------------------------------------------------------------------------*/% void contproc_jpi_status (int status)T {"     static char text[35];_ /*  End of declarations ... */       switch (status) {,         case SS$_SUSPENDED:e7             set_label_str ("(Suspended)", PFM_HEADER2);r>             contproc_IntervalId = XtAppAddTimeOut(app_context,9               2*contproc_update_int, update_contproc, 0);_             break;         case SS$_NONEXPR:i?             set_label_str ("Nonexistant process", PFM_HEADER1); D             set_label_str ("(display update stopped)", PFM_HEADER2);$             contproc_IntervalId = 0;             break;         default:@             sprintf (text, "Error in $GETJPI, stat=%d", status);.             set_label_str (text, PFM_HEADER1);D             set_label_str ("(display update stopped)", PFM_HEADER2);$             contproc_IntervalId = 0;             break;     }e }p oP /*----------------------------------------------------------------------------*/P /* doMainPopupMenu() is the callback whenever a button is clicked in          */P /* one of the graph displays.   All we do here is display a popup menu        */P /* which contains the option to exit.                                         */P /*----------------------------------------------------------------------------*/7 void doMainPopupMenu(Widget wdgt,XtPointer client_data,e7                      XEvent *event, Boolean *propogate)0 {;     Widget popup;e /*  End of declarations ... */  ( /*  This makes our popup menu visible */      popup = (Widget)client_data;9     XmMenuPosition (popup, (XButtonPressedEvent *)event);X     XtManageChild(popup);a     XtRealizeWidget(popup);r }_ dP /*----------------------------------------------------------------------------*/P /* format_cputime() takes an integer (t) which represents a time value        */P /* in 10 millisecond ticks, and returns a string (*s) which contains          */P /* the time formatted as hh:mm:ss.hh                                          */P /*----------------------------------------------------------------------------*/$ void format_cputime (int t, char *s) {m"     int hour, min, sec, hund, tmp; /*  End of declarations ... */       hour = t / 360000;     tmp = t - hour*360000;     min = tmp / 6000;r     tmp = tmp - min*6000;(     sec = tmp / 100;     hund = tmp - sec*100;e  ?     sprintf (s, "%02d:%02d:%02d.%02d\0", hour, min, sec, hund);- }-