///////////////////////////////////////////////////////////////////////////////
// $Id: Text.hxx,v 1.1 1995/01/08 06:52:06 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// Text.hxx - Simple text widget
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 14,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: Text.hxx,v $
// Revision 1.1  1995/01/08  06:52:06  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef TEXT_HXX
#define TEXT_HXX

#ifdef VMS
extern "C" char *index (const char *s, int c);
#endif
#include "BasicWidget.hxx"

class Text : public BasicWidget {
  private:
    const char* myText;

  protected:
    // Called whenever an event arrives for me (I need to override the default)
    virtual void handleEvent(XEvent* event);

    // Update the graphical view of myself
    void updateView();
 
  public:
    // Constructor
    Text(ContainerWidget *const parent, const char *const widgetName,
        int x, int y, int width, int height, const char* text);

    // Destructor
    virtual ~Text();

    // Answer my class
    virtual const char *const className() const { return("Text"); }
};
#endif

