///////////////////////////////////////////////////////////////////////////////
// $Id: Sound.cxx,v 1.2 1996/01/06 05:12:39 bwmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// Sound.cxx - Sound class
//
//
// Bradford W. Mott
// Copyright (C) 1995
// January 4,1995
//
///////////////////////////////////////////////////////////////////////////////
// $Log: Sound.cxx,v $
// Revision 1.2  1996/01/06 05:12:39  bwmott
// Changed all NULLs to 0 and added (char*) cast in the write system call
//
// Revision 1.1  1995/01/08 06:48:24  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "Sound.hxx"


///////////////////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////////////////
Sound::Sound(SampleCollection* sampleCollection)
    : mySampleCollection(sampleCollection)
{
  // Determine if there is a usable sound device
#ifndef VMS
  int soundDevice = open("/dev/audio", O_WRONLY, 0);
#else
  int soundDevice = -1;
#endif

  if(soundDevice == -1)
  {
    myState = Disabled;
  }
  else
  {
    myState = Enabled;
#ifndef VMS
    close(soundDevice);
#endif
  } 
}

///////////////////////////////////////////////////////////////////////////////
// Destructor 
///////////////////////////////////////////////////////////////////////////////
Sound::~Sound()
{
}

///////////////////////////////////////////////////////////////////////////////
// Play the named sample
///////////////////////////////////////////////////////////////////////////////
void Sound::playSample(char* sampleName)
{
  // Play the sample if I'm enabled
  if(myState == Enabled)
  {
    // Open the sound device
#ifndef VMS
    int audio = open("/dev/audio", O_WRONLY, 0);
#else
    int audio = -1;
#endif

    if(audio != -1)
    {
      // Get the sample from my sample collection
      Sample* sample = mySampleCollection->getByName(sampleName);

#ifndef VMS
      if(sample != 0)
        write(audio, (char*)sample->data(), sample->length());

      close(audio);
#endif
    }
  }
}

