/* brain.h
 *
 * Structures and constants for a vehicle brain state machine
 */
#ifndef brain_h
#define brain_h

struct link;		/* forward definition */

struct state {
	int num;		/* state number */
	long action;		/* what happens when state is entered */
	int lcount;		/* number of links from state */
	struct link *links;	/* array of links */
	};
/* Information about one state in a brain state machine. */

struct link {
	long cond;		/* t/f conditions for taking this link */
	long mask;		/* conditions link depend on */
	int st;
	};
/* A link from one state to the next */

#ifdef alternate_conditions
/* Condition codes.
 * The target is the last vehicle chosen by the 'newtarget' action.
 */
#define c_always	1<<0		/* always jump */
#define c_obleft	1<<1		/* object just to left */
#define c_obright	1<<2		/* object just to right */
#define c_obabove	1<<3		/* object just above */
#define c_obbelow	1<<4		/* object just below */
#define c_tarleft	1<<5		/* target to left */
#define c_tarright	1<<6		/* target to right */
#define c_tarabove	1<<7		/* target at higher altitude */
#define c_tarbelow	1<<8		/* target at lower altitude */
#define c_forward	1<<9		/* moving forward */
#define c_backward	1<<10		/* moving backwards */
#define c_tarahead	1<<11		/* target directly ahead */
#define c_threatahead	1<<12		/* threat ahead */
#define c_sceneryahead	1<<13		/* scenery/building ahead */
#define c_treeahead	1<<14		/* tree ahead */
#define c_underfire	1<<15		/* hit in the last second */

/* Action codes 
 */
#define a_left		(1<<0)		/* accellerate left */
#define a_right		(1<<1)		/* accelleration right */
#define a_climb		(1<<2)		/* accel upwards */
#define a_dive		(1<<3)		/* accel downwards */
#define a_accel		(1<<4)		/* accellarate */
#define a_decel		(1<<5)		/* decellarate */
#define a_fire		(1<<6)		/* fire one shot */
#define a_newtarget	(1<<7)		/* lock onto object ahead */
#define a_stop		(1<<8)		/* halt all movement */
#define a_threattarget	(1<<9)		/* lock onto last attacker */
#endif /* alternate conditions */

/* Conditions that a link depends on 
 */
#define c_hplow		(1<<0)		/* hp below 5 */
#define c_ammolow	(1<<1)		/* ammo below 5 */
#define c_threatfar	(1<<2)		/* threat far ahead */
#define c_treefar	(1<<3)		/* tree far ahead */
#define c_anyfar	(1<<4)		/* something far ahead */
#define c_threatclose	(1<<5)		/* threat close ahead */
#define c_treeclose	(1<<6)		/* tree close ahead */
#define c_anyclose	(1<<7)		/* something close ahead */
#define c_underfire	(1<<8)		/* been hit in last second */
#define c_reload	(1<<9)		/* currently reloading */
#define c_reslow	(1<<10)		/* resources below 5 */
#define c_moving	(1<<11)		/* moving forward/back */
#define c_stall		(1<<12)		/* below stall speed */
#define c_altlow	(1<<13)		/* altitude below 10 */
#define c_above		(1<<14)		/* thing ahead is at higher alt */
#define c_below		(1<<15)		/* thing ahead is at lower alt */
#define c_always	(1<<16)		/* always take this branch */
#define c_prizefar	(1<<17)		/* ammo/weapon bonus ahead */
#define c_prizeclose	(1<<18)		/* ammo/weapon bonus close ahead */
#define c_random	(1<<19)		/* 50% likely to be true */
#define c_counting	(1<<20)		/* frame count still > 0 */
#define c_collision	(1<<21)		/* just bumped into something */
#define CONDITIONCOUNT	22

/* actions taken when a state is entered */
#define a_noop		(1<<0)		/* do nothing */
#define a_shoot		(1<<1)		/* fire at thing ahead */
#define a_stop		(1<<2)		/* stop all motion */
#define a_accel		(1<<3)		/* speed up */
#define a_decel		(1<<4)		/* slow down */
#define a_left		(1<<5)		/* rotate left */
#define a_right		(1<<6)		/* rotate right */
#define a_climb		(1<<7)		/* climb up */
#define a_dive		(1<<8)		/* dive down */
#define a_detonate	(1<<9)		/* self destruct */
#define a_wall		(1<<10)		/* build a wall */
#define a_mine		(1<<11)		/* lay a mine */
#define a_gunsite	(1<<12)		/* build a gunsite */
#define a_starttimer	(1<<13)		/* add 5 seconds to timer */
#define ACTIONCOUNT	14

#endif /* brain_h */
