#ifndef _NO_PROTO
#ifndef _STRSPLIT_H_

#define _STRSPLIT_H_

/*-------------------------------------------------------------*/
/*                        strsplit.h                           */
/*-------------------------------------------------------------*/

/*
	Doug Hellmann
	June, 1992
*/

/*
 * A StringSplitter is a utility object that allows us to view a
 * string as being made up of several "fields" that are separated
 * by one or more "field separator" characters. For example, a line of
 * words can be viewed as a collection of fields, each word
 * corresponding to one field, and the field separators being spaces,
 * tabs and punctuation characters.
 */

#define MAX_FIELDS 100

struct StringSplitterStruct;
typedef struct StringSplitterStruct StringSplitter;


StringSplitter* StringSplitter_Create (char * strg, char field_sep[]);
    /* Create a new StringSplitter object that "remembers" the given */
    /* string strg and the given array of field separator characters. */

void StringSplitter_Destroy (StringSplitter* splitter);
    /* Destroy the specified splitter. */

int StringSplitter_NumFields (StringSplitter* splitter);
    /* Return the number of fields in the string remembered by */
    /* splitter. */

char* StringSplitter_Field (StringSplitter* splitter, int i);
    /* Return a pointer to a null-terminated character string that is */
    /* the content of the i-th field of the string remembered by the */
    /* specified splitter. Assume that field numbers begin with 0. */
    /* Return NULL if i is outside the range 0 through NumFields - 1. */

#endif

#else

#ifndef _STRSPLIT_H_

#define _STRSPLIT_H_

#define MAX_FIELDS 100

struct StringSplitterStruct;
typedef struct StringSplitterStruct StringSplitter;

StringSplitter* StringSplitter_Create ();
void StringSplitter_Destroy ();
int StringSplitter_NumFields ();
char* StringSplitter_Field ();

#endif

#endif
