/*
** 
**  $Header: /usr/home/hellmann/nedit_add_ons/RCS/opt_menu.c,v 1.3 96/02/21 17:39:39 hellmann Exp $
** 
**  FILENAME: opt_menu.c
** 
**   PURPOSE: Convinience function for working with Motif option menus.
** 
**    AUTHOR: Doug Hellmann
** 
**    RCSLOG:   $Log:	opt_menu.c,v $
** Revision 1.3  96/02/21  17:39:39  hellmann
** Added/updated header.
** 
** 
** 
*/
#include <Xm/Xm.h>
#include <stdio.h>

/*
 * Make the currently displayed option for an option menu correspond to
 * the index given, unless there is an error.
 *
*/
int OptionMenuSetValue(Widget option_menu, int idx)
{
  WidgetList children;
  Widget menu;
  Cardinal num_children;
  
  	/* get the sub menu */
  
  XtVaGetValues(option_menu, XmNsubMenuId, &menu, NULL);
  
  	/* get the children */
  
  XtVaGetValues(menu, XmNchildren, &children, 
  		      XmNnumChildren, &num_children, 
  		      NULL);

	/* bounds checking */
	     
  if (idx < 0)
  {
    fprintf(stderr, "Can't set option menu %s to %d\n", 
    XtName(option_menu), idx);
    return False;
  }
  if (idx >= num_children)
  {
    fprintf(stderr, "Can't set option menu %s to %d\n", 
    XtName(option_menu), idx);
    return False;
  }
    
  	/* set the new value */
    
  XtVaSetValues(menu, XmNmenuHistory, children[idx], NULL);
  XtVaSetValues(option_menu, XmNmenuHistory, children[idx], NULL);

/*
  fprintf(stderr, "*** Setting %s (of %s) to %d (%s)\n", 
  			XtName(menu), 
  			XtName(option_menu),
  			idx, 
  			XtName(children[idx]));
*/
  
  return True;
}

int OptionMenuGetValue(Widget option_menu)
{
  WidgetList children;
  Widget menu, history;
  Cardinal num_children;
  int i;
  
  XtVaGetValues(option_menu, XmNsubMenuId, &menu, NULL);
  
  if (!menu)
    return -1;
  
  XtVaGetValues(menu, XmNchildren, &children,
  			XmNnumChildren, &num_children,
  			XmNmenuHistory, &history, 
  			NULL);
  for (i = 0; i < num_children; i++)
    if (children[i] == history)
      return i;
      
  return -1;
}

