/*
** 
**  $Header: /net/flamingo/usr/home/hellmann/nedit_add_ons/RCS/mgrep_options.c,v 1.2 96/02/29 12:22:40 hellmann Exp $
** 
**  FILENAME: mgrep_options.c
** 
**   PURPOSE: Define platform specific commandline options for grep
** 
**    AUTHOR: Doug Hellmann
** 
**      DATE: 29 February 1996
** 
**  COMMENTS: 
** 
**    RCSLOG:   $Log:	mgrep_options.c,v $
** Revision 1.2  96/02/29  12:22:40  hellmann
** Started using CmdOptions system for defining command arguments.
** 
** Revision 1.1  96/02/29  10:33:09  hellmann
** Initial revision
** 
** 
** 
*/

#include "commandOptions.h"

#ifdef IBM

CmdOption outputOptions[] = {
	{ NULL,  NULL,  "count",    "Display count of matching lines.",  "-c", 
	  FALSE,  CMD_OPTION_BOOLEAN, FALSE },
	{ NULL,  NULL,  "files",    "List only file names.",  "-l", 
	  FALSE,  CMD_OPTION_BOOLEAN, FALSE },
	CMD_OPTION_END
};

CmdOption patternOptions[] = {
	{ NULL,  NULL,  "none",    "Treat pattern as regular expression.", 
	 "", TRUE,  CMD_OPTION_BOOLEAN, TRUE },
	{ NULL,  NULL,  "egrep",    "Treat pattern as extended regular expression.", 
	 "-E", TRUE,  CMD_OPTION_BOOLEAN, FALSE },
	{ NULL,  NULL,  "fgrep",    "Treat pattern as fixed string.", 
	 "-F", TRUE,  CMD_OPTION_BOOLEAN, FALSE },
	CMD_OPTION_END
};

CmdOption comparisonOptions[] = {
	{ NULL,  NULL,  "case",    "Ignore case",  "-i", 
	  FALSE,  CMD_OPTION_BOOLEAN, FALSE },
	{ NULL,  NULL,  "word",    "Word search",  "-w", 
	  FALSE,  CMD_OPTION_BOOLEAN, FALSE },
	{ NULL,  NULL,  "exact",    "Exact match with no additional characters.",  
	"-x", FALSE,  CMD_OPTION_BOOLEAN, FALSE },
	CMD_OPTION_END
};

#else

CmdOption outputOptions[] = {
	CMD_OPTION_END
};

CmdOption patternOptions[] = {
	CMD_OPTION_END
};

CmdOption comparisonOptions[] = {
	CMD_OPTION_END
};

#endif

CmdOption mgrepOptions[] = {

	{ outputOptions, 		/* sub_menu */
	  "Output", 			/* sub_menu_name */
	  NULL, 				/* option_name */
	  NULL, 				/* option_description */
	  NULL,					/* option_flag */
	  FALSE, 				/* ignore_siblings */
	  CMD_OPTION_SUBMENU,	/* option_type */
	  FALSE },				/* value */

	{ patternOptions, 		/* sub_menu */
	  "Pattern semantics", 	/* sub_menu_name */
	  NULL, 				/* option_name */
	  NULL, 				/* option_description */
	  NULL,					/* option_flag */
	  FALSE, 				/* ignore_siblings */
	  CMD_OPTION_SUBMENU,	/* option_type */
	  FALSE },				/* value */

	{ comparisonOptions, 	/* sub_menu */
	  "Comparisons", 		/* sub_menu_name */
	  NULL, 				/* option_name */
	  NULL, 				/* option_description */
	  NULL,					/* option_flag */
	  FALSE, 				/* ignore_siblings */
	  CMD_OPTION_SUBMENU,	/* option_type */
	  FALSE },				/* value */

	CMD_OPTION_END
};
