
 /* SList.c  M ***************************************************************************** M *                                                                           * M *  COPYRIGHT (c) 1989  BY                                                   * M *  DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                   * M *  ALL RIGHTS RESERVED.                                                     * M *                                                                           * M *  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    * M *  ONLY IN  ACCORDANCE WITH  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE    * M *  INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER    * M *  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    * M *  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE IS  HEREBY    * N *  TRANSFERRED.                                                             * M *                                                                           * M *  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    * M *  AND  SHOULD  NOT  BE  CONSTRUED AS  A COMMITMENT BY DIGITAL EQUIPMENT    * M *  CORPORATION.                                                             * M *                                                                           * M *  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS    * M *  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                  * M *                                                                           * M *****************************************************************************   0         This module implements the SList widget.  F The SList widget can be used to present a list of options to the user.G By using Button1 on the mouse, the user can select one or more options, @ and can scroll through the list using the scrollbar or keyboard.  A The widget has a callback that is used to ask the application for F the contents of the list items when it is necessary for refreshing the0 display (or when initially displaying the list).  J The SList widget can be created by calls to XtCreateWidget or in UIL.  ItsM interface with the application is simple and consists of the following calls:   E SListInitializeForDRM() - must be called before any SList widgets are 1     created, if you are using UIL to create them.                  F SListCreate(pW, nameP, argsP, argCnt) - is a convenience routine (alsoE     used by UIL/DRM) to create a SList widget.  You will probably not 3     call this routine directly from an application.   < SListLoad(w, sLineCnt) - may be called at any time to pass a*     new count to the SList widget.  If theH     SList widget is visible, it is repainted with the new list contents.  B SListSelectAll(w, select) - may be called at any time to select or)     unselect all the entries in the list.   H SListUnhighlight(w) - may be called to unhighlight the highlighted line,     if any. 0 SListHighlight(w) - Select the highlighted line.  - There are three callbacks made by the widget:   G (1) select_callback is made whenever the user upclicks MB1 in the list. G (2) double_click_callback is made whenever the user double-clicks on an      item in the list. F (3) get_data_callback is used to determine the contents of a list item     for display.   MODIFICATION HISTORY:    */ #include "config.h" 
 #define SLIST  #ifdef MOTIF #include <X11/Intrinsic.h> #include <X11/StringDefs.h>  #include <X11/IntrinsicP.h>  #include <X11/ShellP.h>  #include <X11/Xatom.h> #include <Xm/Xm.h> extern void _XmDrawShadow();) #if (XmVERSION == 1) && (XmREVISION == 0)  #define MOTIF_V10  #endif' #if (XmVERSION > 1) || (XmREVISION > 1)  /* For Motif 1.2 */  #include <Xm/PrimitiveP.h> #endif #include <Xm/XmP.h>  #include <Xm/ScrollBar.h>  #include <Xm/ScrolledW.h>  #ifdef USE_MRM #include <Mrm/MrmAppl.h> #endif #else  #ifdef unix " #include <X11/DECwDwtWidgetProg.h> #include <X11/Xatom.h> #else + #include <decw$include/DECwDwtWidgetProg.h>  #include <decw$include/Xatom.h>  #endif #endif /* MOTIF */ #include "slistP.h"  #ifndef MIN $ #define MIN(a,b) (((a)<(b))?(a):(b)) #endif   /*  * Forward declarations   */  static int ComputeMaxYAdjust();  static int YToLine();  static void SetYAdjust();  static void Flip();  static void Draw(); " static void CallSelectCallbacks();' static void CallDoubleClickCallbacks(); " static void CallGetDataCallback(); static void SetLineSelection();   static void NewScrollPosition();  static void NewSelectPosition();' static XtCallbackProc scrollCallback();  static void Mb1PressInList();  static void ClickTimer(); # static void ButtonReleaseHandler(); ! static void ButtonPressHandler(); # static void PointerMotionHandler();  static void DrawExposedLines();  static void SaveExposeRegion();  static void StartScrollGrop(); static void Repaint(); static void DoExpose(); ( static XtGeometryResult QueryGeometry(); static void DoInitialize();  static void DoRealize(); static void DoResize();  static void DoDestroy();  XtActionProc slistForwardPage();! XtActionProc slistBackwardPage();   XtActionProc slistForwardLine();! XtActionProc slistBackwardLine();  static void ClassInitialize();  $ static XtCallbackRec VSCallBack[] =  { 8     {(XtCallbackProc)   scrollCallback, (caddr_t) NULL},(     {NULL,              (caddr_t) NULL}, };+ #if defined (MOTIF) && !defined (MOTIF_V10)  static char slistBindings[] =      "#augment\n\:      Shift ~Meta ~Alt <Key>Tab: PrimitivePrevTabGroup()\n\:      ~Meta ~Alt <Key>Tab:       PrimitiveNextTabGroup()\n\5      <FocusIn>:                 PrimitiveFocusIn()\n\ 6      <FocusOut>:                PrimitiveFocusOut()\n\1      <Key>osfPageDown:          forward-page()\n\ 2      <Key>osfPageUp:            backward-page()\n\1      <Key>osfDown:              forward-line()\n\ 1      <Key>osfUp:                backward-line()";  #else  static char slistBindings[] = 7     "Ctrl ~Shift ~Meta ~Alt <Key>Next:forward-page()\n\ 9      Ctrl ~Shift ~Meta ~Alt <Key>Prior:backward-page()\n\ 7      Ctrl ~Shift ~Meta ~Alt <Key>Down:forward-line()\n\ 6      Ctrl ~Shift ~Meta ~Alt <Key>Up: backward-line()"; #endif  + static XtActionsRec slistActionsTable[] = { 9     {"forward-page",    (XtActionProc) slistForwardPage}, :     {"backward-page",   (XtActionProc) slistBackwardPage},9     {"forward-line",    (XtActionProc) slistForwardLine}, :     {"backward-line",   (XtActionProc) slistBackwardLine},+ #if defined (MOTIF) && !defined (MOTIF_V10) <     {"PrimitiveFocusIn",(XtActionProc) _XmPrimitiveFocusIn},>     {"PrimitiveFocusOut",(XtActionProc) _XmPrimitiveFocusOut}, #endif };   /*  * Widget resource tables   */  #ifndef XtCCallback  #define XtCCallback "Callback" #endif #ifndef XtRCallback  #define XtRCallback "Callback" #endif* #define Offset(x) XtOffset(SListWidget, x)   #ifdef MOTIF_V10( extern void _XmForegroundColorDefault(); #endif  ! static XtResource resources[] = {  #ifdef MOTIF;   {XmNfont, XmCFontList, XmRFontList, sizeof(XmFontList *), 2       Offset(slist.fontRecP), XmRString, "fixed"},/   {SListNcols, SListCCols, XtRInt, sizeof(int), 4       Offset(slist.cols), XtRImmediate, (caddr_t)1},/   {SListNrows, SListCRows, XmRInt, sizeof(int), 4       Offset(slist.rows), XmRImmediate, (caddr_t)1},J   {SListNselectCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),=       Offset(slist.selectCallback), XmRCallback, (caddr_t)0}, O   {SListNdoubleClickCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList), B       Offset(slist.doubleClickCallback), XmRCallback, (caddr_t)0},K   {SListNgetDataCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList), >       Offset(slist.getDataCallback), XmRCallback, (caddr_t)0}, #ifdef MOTIF #ifdef MOTIF_V10?   {SListNforeground, SListCForeground, XmRPixel, sizeof(Pixel), ,       Offset(slist.foreground), XmRCallProc,+       (caddr_t) _XmForegroundColorDefault},  #else ?   {SListNforeground, SListCForeground, XmRPixel, sizeof(Pixel), C       Offset(slist.foreground), XmRString, XtExtdefaultforeground},  #endif #endifE   {SListNtextMarginWidth, SListCTextMarginWidth, XmRInt, sizeof(int), ?       Offset(slist.textMarginWidth), XmRImmediate, (caddr_t)4}, G   {SListNdoubleClickDelay, SListCDoubleClickDelay, XmRInt, sizeof(int), ?       Offset(slist.ClickInterval), XmRImmediate, (caddr_t) 250}  #else >   {DwtNfont, DwtCFontList, DwtRFontList, sizeof(DwtFontRec *),2       Offset(slist.fontRecP), XtRString, "fixed"},/   {SListNcols, SListCCols, XtRInt, sizeof(int), 4       Offset(slist.cols), XtRImmediate, (caddr_t)1},/   {SListNrows, SListCRows, XtRInt, sizeof(int), 4       Offset(slist.rows), XtRImmediate, (caddr_t)1},J   {SListNselectCallback, XtCCallback, XtRCallback, sizeof(DwtCallbackPtr),=       Offset(slist.selectCallback), XtRCallback, (caddr_t)0}, O   {SListNdoubleClickCallback, XtCCallback, XtRCallback, sizeof(DwtCallbackPtr), B       Offset(slist.doubleClickCallback), XtRCallback, (caddr_t)0},K   {SListNgetDataCallback, XtCCallback, XtRCallback, sizeof(XtCallbackList), >       Offset(slist.getDataCallback), XtRCallback, (caddr_t)0},?   {SListNforeground, SListCForeground, XtRPixel, sizeof(Pixel), B       Offset(slist.foreground), XtRString, DwtSForegroundDefault},E   {SListNtextMarginWidth, SListCTextMarginWidth, XtRInt, sizeof(int), ?       Offset(slist.textMarginWidth), XtRImmediate, (caddr_t)4}, G   {SListNdoubleClickDelay, SListCDoubleClickDelay, XtRInt, sizeof(int), ?       Offset(slist.ClickInterval), XtRImmediate, (caddr_t) 250}  #endif };   /*  * The widget class record  */   externaldef(slistwidgetclassrec)% SListClassRec slistwidgetclassrec = { "     {/* core_class fields       */ #ifdef MOTIFK         /* superclass           */      (WidgetClass) &xmPrimitiveClassRec,  #else F         /* superclass           */      (WidgetClass) &widgetClassRec, #endif0         /* class_name           */      "SList",?         /* widget_size          */      sizeof(SListWidgetRec), 8         /* class_initialize     */      ClassInitialize,-         /* class_part_initialize */     NULL, .         /* class_inited         */      FALSE,B         /* initialize           */      (XtInitProc) DoInitialize,-         /* initialize_hook      */      NULL, B         /* realize              */      (XtRealizeProc) DoRealize,-         /* actions              */      NULL, *         /* num_actions          */      0,A         /* resources            */      (XtResource *) resources, B         /* num_resources        */      (int) XtNumber(resources),2         /* xrm_class            */      NULLQUARK,-         /* compress_motion      */      TRUE, -         /* compress_exposure    */      TRUE, .         /* compress_enterleave  */      FALSE,.         /* visible_interest     */      FALSE,A         /* destroy              */      (XtWidgetProc) DoDestroy, @         /* resize               */      (XtWidgetProc) DoResize,@         /* expose               */      (XtExposeProc) DoExpose,-         /* set_values           */      NULL, -         /* set_values_hook      */      NULL, B         /* set_values_almost    */      XtInheritSetValuesAlmost, -         /* get_values_hook      */      NULL, -         /* accept_focus         */      NULL, K         /* version              */      (XtVersionType) XtVersionDontCheck, -         /* callback_private     */      NULL, -         /* tm_table             */      NULL, 6         /* query_geometry       */      QueryGeometry,-         /* display_accelerator  */      NULL, ,         /* extension            */      NULL   }  #ifdef MOTIFB  ,{     /* border_highlight     */      (XtWidgetProc) _XtInherit,B         /* border_unhighlight   */      (XtWidgetProc) _XtInherit,-         /* translations         */      NULL, B         /* arm_and_activate     */      (XtActionProc) _XtInherit,-         /* syn_resources        */      NULL, *         /* num_syn_resources    */      0,-         /* extension            */      NULL,    }  #endif };   externaldef (slistwidgetclass)3 SListClass slistwidgetclass = &slistwidgetclassrec;    /*  * Widget private routines  */    static void CheckSize(w)     SListWidget w; { 
 #ifndef MOTIF !     if (!XtIsRealized(w)) return;  /*A  * Hacky: handle resizing of the parent widget by resizing myself   */ >     if (w->core.parent->core.width  != w->slist.parentWidth ||?         w->core.parent->core.height != w->slist.parentHeight) { . 	w->core.width = w->slist.vScroll->core.x - 2;I 	w->core.height = w->core.parent->core.height - 2 * w->core.border_width;  	w->slist.knownHeight = 0; 	DoResize(w);		 3 	w->slist.parentWidth = w->core.parent->core.width; 5 	w->slist.parentHeight = w->core.parent->core.height;      }  #endif }  static int ComputeMaxYAdjust(w)      SListWidget w; { P     int maxYAdjust = w->slist.LineCnt*w->slist.cellHeight - w->slist.textHeight;  '     if (maxYAdjust < 0) maxYAdjust = 0;        return (maxYAdjust); }  static int YToLine(w, y)     SListWidget w;
     int y; { 
     int line;        if (y < 0) line = -1; &     else if (y >= w->slist.textHeight)4         line = w->slist.topLine + w->slist.rows - 1;
     else {<         line = (y + w->slist.YAdjust) / w->slist.cellHeight;          if (line < 0) line = -1;5         else if (line >= w->slist.LineCnt) line = -1;      }        return (line); }   " static void SetYAdjust(w, yAdjust)     SListWidget w;     int yAdjust; { +     int maxYAdjust = ComputeMaxYAdjust (w);   3     if (yAdjust > maxYAdjust) yAdjust = maxYAdjust; !     if (yAdjust < 0) yAdjust = 0;        w->slist.YAdjust = yAdjust;  }    static void Flip(w, line)      SListWidget w;
     int line;  { /     if (line < 0 || line >= w->slist.LineCnt || D 	line < w->slist.topLine || line > w->slist.topLine + w->slist.rows) 	return;  E     if (XtIsRealized (w)) XFillRectangle (XtDisplay (w), XtWindow(w),          w->slist.flipgc,6         w->slist.leftMarginWidth + w->slist.textX + 1,M         (line - w->slist.topLine) * w->slist.cellHeight + w->slist.textY + 1, K         w->slist.textWidth - w->slist.leftMarginWidth - w->slist.textX - 2, !         w->slist.cellHeight - 2);  }    static void Draw(w, line)      SListWidget w;
     int line;  {      int select;      char *text;   :     int x = w->slist.leftMarginWidth + w->slist.textX + 1;=     int y = (line - w->slist.topLine) * w->slist.cellHeight +  	w->slist.textY + 1;     int maxCols, textWidth;   :     textWidth = w->core.width - w->slist.leftMarginWidth - #ifdef MOTIF)         2*w->primitive.shadow_thickness -  #endif 	2 * w->core.border_width + 6;3     maxCols = (textWidth / w->slist.cellWidth) - 1;   "     if (!XtIsRealized (w)) return;  9     if (line - w->slist.topLine >= w->slist.rows) return;   ?     if (line < 0 || y < 0 || y >= (int) w->core.height) return; #     if (line >= w->slist.LineCnt) { 7         XClearArea (XtDisplay (w), XtWindow (w), x, y,  '             w->slist.textWidth - x - 1, (             w->slist.cellHeight - 2, 0); 	return;     }   '     select = w->slist.selectMapP[line]; (     CallGetDataCallback(w, line, &text);%     if (text == NULL) text = "-----";      if (select) { 4         XFillRectangle (XtDisplay (w), XtWindow (w),"             w->slist.normgc, x, y,'             w->slist.textWidth - x - 1, %             w->slist.cellHeight - 2);      } else {7         XClearArea (XtDisplay (w), XtWindow (w), x, y,  '             w->slist.textWidth - x - 1, (             w->slist.cellHeight - 2, 0);     }      XDrawString ( $         XtDisplay (w), XtWindow (w),7         (select ? w->slist.invgc : w->slist.normtxtgc), %         x + w->slist.textMarginWidth, D         y + w->slist.yFontAdjust, text, MIN(strlen(text), maxCols)); }   * static void CallSelectCallbacks(w, eventP)     SListWidget w;     XEvent *eventP;  {      SListCallbackStruct cbData;   "     cbData.reason = SListCRSelect;     cbData.event = eventP;*     cbData.select = w->slist.selectParity;/     if (w->slist.upLine >= w->slist.downLine) { /         cbData.item_number = w->slist.downLine; D         cbData.item_count = w->slist.upLine - w->slist.downLine + 1;     } else {-         cbData.item_number = w->slist.upLine; D         cbData.item_count = w->slist.downLine - w->slist.upLine + 1;     }*@     XtCallCallbacks ((Widget) w, SListNselectCallback, &cbData); } / static void CallDoubleClickCallbacks(w, eventP)      SListWidget w;     XEvent *eventP;  {      SListCallbackStruct cbData;   '     cbData.reason = SListCRDoubleClick;N     cbData.event = eventP;+     cbData.item_number = w->slist.downLine;      cbData.item_count = 1;E     XtCallCallbacks ((Widget) w, SListNdoubleClickCallback, &cbData);  }   - static void CallGetDataCallback(w, line, ptr)S SListWidget w;	 int line;  char **ptr;O {D     SListCallbackStruct cbData;T  #     cbData.reason = SListCRGetData;I     cbData.event = NULL;     cbData.select = 0;     cbData.item_number = line;     cbData.item_count = 1;     cbData.data = ptr;     *ptr = NULL;A     XtCallCallbacks ((Widget) w, SListNgetDataCallback, &cbData);F }H  / static void SetLineSelection(w, line, selected)      SListWidget w;     int line, selected;  {      int select;   ;     if ((line == -1) || (line == w->slist.LineCnt)) return; '     select = w->slist.selectMapP[line];   #     if (select == selected) return;   )     w->slist.selectMapP[line] = selected;C     Flip (w, line);E }P T# static void NewScrollPosition(w, y)      SListWidget w;
     int y; {     3     int maxY = w->slist.rows * w->slist.cellHeight; 2     int maxTop = w->slist.LineCnt - w->slist.rows;     Arg vsbArg[1];          if (y < 0 || y >= maxY) {          if (y < 0) {#             if (w->slist.topLine) {I 		w->slist.topLine--; 8                 w->slist.YAdjust -= w->slist.cellHeight;?                 if (w->slist.YAdjust < 0) w->slist.YAdjust = 0;*#                 StartScrollGrop(w); * 		if (w->slist.vScroll != (Widget) NULL) { #ifdef MOTIF6 		    XtSetArg(vsbArg[0], XmNvalue, w->slist.topLine); #elsee7 		    XtSetArg(vsbArg[0], DwtNvalue, w->slist.topLine);e #endif/ 		    XtSetValues(w->slist.vScroll, vsbArg, 1);  		}c
             }o         } else {(             maxY = ComputeMaxYAdjust(w);% 	    if (w->slist.topLine < maxTop) {t 		w->slist.topLine++;s8                 w->slist.YAdjust += w->slist.cellHeight;E                 if (w->slist.YAdjust > maxY) w->slist.YAdjust = maxY;i#                 StartScrollGrop(w);t* 		if (w->slist.vScroll != (Widget) NULL) { #ifdef MOTIF6 		    XtSetArg(vsbArg[0], XmNvalue, w->slist.topLine); #elses7 		    XtSetArg(vsbArg[0], DwtNvalue, w->slist.topLine);t #endif/ 		    XtSetValues(w->slist.vScroll, vsbArg, 1);  		}t
             }i	         }e     }  }   # static void NewSelectPosition(w, y)e     SListWidget w;
     int y; {l
     int line;i       if (y < 0) y = 0;n:     if (y >= w->slist.textHeight) y = w->slist.textHeight;     line = YToLine (w, y);     if (line == -1) line = 0;s  (     while (line != w->slist.mouseLine) {&         if (w->slist.mouseLine < line)9             if (w->slist.mouseLine < w->slist.downLine) {eE                 int select = w->slist.selectMapP[w->slist.mouseLine];eE                 SetLineSelection (w, (w->slist.mouseLine)++, select); W             } else SetLineSelection (w, ++(w->slist.mouseLine), w->slist.selectParity);e         else9             if (w->slist.mouseLine > w->slist.downLine) {oE                 int select = w->slist.selectMapP[w->slist.mouseLine]; E                 SetLineSelection (w, (w->slist.mouseLine)--, select);eW             } else SetLineSelection (w, --(w->slist.mouseLine), w->slist.selectParity);      }n }     ; static XtCallbackProc scrollCallback(w, closure, call_data)g
     Widget w;u     caddr_t closure; #ifdef MOTIF)     XmScrollBarCallbackStruct *call_data;u #elseX*     DwtScrollBarCallbackStruct *call_data; #endif {)+     SListWidget sl = (SListWidget) closure;e        switch (call_data->reason) { #ifdef MOTIF         case XmCR_INCREMENT:         case XmCR_DECREMENT:!         case XmCR_PAGE_INCREMENT:l!         case XmCR_PAGE_DECREMENT:          case XmCR_DRAG:e #elser         case DwtCRUnitInc:         case DwtCRUnitDec:         case DwtCRPageInc:         case DwtCRPageDec:         case DwtCRDrag:t #endif4 	    if (call_data->value < 0) call_data->value = 0;/ 	    if (call_data->value >= sl->slist.LineCnt) + 		call_data->value = sl->slist.LineCnt - 1;f* 	    sl->slist.topLine = call_data->value;H             sl->slist.YAdjust = call_data->value * sl->slist.cellHeight;!             StartScrollGrop (sl);t             break;       } 
     return 0;a }(  % static void Mb1PressInList(w, eventP))     SListWidget w;     XButtonEvent *eventP;v { 
     int line;n     int needsRepaint = 0;P       CheckSize(w);iE     w->slist.mouseLine = w->slist.downLine = w->slist.upLine = line =c0         YToLine (w, eventP->y - w->slist.textY);     /*      * check for pending timer      */v%     if (w->slist.ClickTimerID != 0) { H         if (w->slist.downLine != w->slist.ClickLine) {  /* Same line? */T             XtRemoveTimeOut(w->slist.ClickTimerID);     /* No, not a double click */O             CallSelectCallbacks(w, NULL);       /* deliver initial selection */eI             w->slist.ClickTimerID = 0;          /* Zap the click timer */t         } else {L             w->slist.listIsGrabbed = 1;         /* grabbed (for up-click) */L             return;                             /* else wait for up-click */	         }t     }l     /*<      * On MB1 down, deselect all. No deselect for Shift-MB1.      */ '     if (!(eventP->state & ShiftMask)) { &         w->slist.highlightedLine = -1;5         for (line=0;line <w->slist.LineCnt; line++) {#1             if (w->slist.selectMapP[line] != 0) {v!                 needsRepaint = 1; 
             } *             w->slist.selectMapP[line] = 0;	         }      }m     if (needsRepaint)          Repaint (w);       w->slist.listIsGrabbed = 1;<  E     w->slist.mouseLine = w->slist.downLine = w->slist.upLine = line = 0         YToLine (w, eventP->y - w->slist.textY);  4     if ((line != -1) && (line < w->slist.LineCnt)) {A         w->slist.selectParity = (w->slist.selectMapP[line] == 0);C:         SetLineSelection (w, line, w->slist.selectParity);%     } else w->slist.selectParity = 1;- }e   static void ClickTimer(w, id)l     SListWidget w;     XtIntervalId id; {i /*  * Here when the timer expires  */   "     if (w->slist.downLine != -1) { 	if (w->slist.DownCount > 1) {F 	    CallDoubleClickCallbacks (w, NULL); /* call double click procs */	 	} else {)< 	    CallSelectCallbacks (w, NULL);  /* call select procs */ 	}     }L     w->slist.ClickTimerID = 0; }A4 static void ButtonReleaseHandler(w, closure, eventP)     SListWidget w;     Opaque closure;c     XButtonEvent *eventP;m {v!     if (w->slist.listIsGrabbed) {"+         int y = eventP->y - w->slist.textY;f  H         /* If we're still Scrolling, treat the upclick as though it wereG          * at the top or bottom edge of the list.  This prevents unseenc(          * lines from being selected. */           if (y < 0)  {  	    Flip(w, 0); 	    y = 0;X 	}G         else if (y >= w->slist.textHeight) y = w->slist.textHeight - 1;d(         w->slist.upLine = YToLine(w, y);"         if (w->slist.upLine == -1)7                 w->slist.upLine = w->slist.LineCnt - 1;lD         NewScrollPosition (w, 0);           /* shut off scrolling */  #         w->slist.listIsGrabbed = 0;iQ         if (w->slist.upLine != w->slist.downLine) {     /* same line? if not...*/,L             if (w->slist.ClickTimerID != 0) {           /* timer pending? */K                 XtRemoveTimeOut(w->slist.ClickTimerID);/* Then cancel it */l*                 w->slist.ClickTimerID = 0;
             }LG             CallSelectCallbacks (w, eventP);    /* call select procs */,         } else { /**  * same line - initiate double-click timer  */LH             if (w->slist.ClickTimerID == 0) {           /* first time */9                 w->slist.ClickTimerID = XtAppAddTimeOut (r- 				XtWidgetToApplicationContext((Widget) w),tG                                 (unsigned long) w->slist.ClickInterval,lA                                 (XtTimerCallbackProc) ClickTimer,o-                                 (caddr_t) w);S'                 w->slist.DownCount = 1; 1                 w->slist.DownTime = eventP->time;i5                 w->slist.ClickLine = w->slist.upLine;i             } else {P                 w->slist.DownCount++;                   /* count another down */
             }f	         }C     }  }l  2 static void ButtonPressHandler(w, closure, eventP)     SListWidget w;     Opaque closure;n     XButtonEvent *eventP;t {n  P     /* Handle chorded cancel by turning the ButtonPress into a ButtonRelease. */  !     if (w->slist.listIsGrabbed) {c2         ButtonReleaseHandler (w, closure, eventP);         return;f     }i  K     if (!w->slist.LineCnt) return;                      /* nothing to do */C  "     if (eventP->button == Button1)#         Mb1PressInList (w, eventP);l   },  4 static void PointerMotionHandler(w, closure, eventP)     SListWidget w;     Opaque closure;      XMotionEvent *eventP;i {a!     if (w->slist.listIsGrabbed) { :         NewSelectPosition (w, eventP->y - w->slist.textY);:         NewScrollPosition (w, eventP->y - w->slist.textY);     }  }d t static void DrawExposedLines(w)F     SListWidget w; {z     int line, LineCnt;     char *exposeMapP;t  C     if (!w->slist.anyAreExposed) return;        /* nothing to do */a       LineCnt = w->slist.LineCnt; T     for (line=0, exposeMapP=w->slist.exposeMapP; line<LineCnt; line++, exposeMapP++)         if (*exposeMapP) {             Draw (w, line);              *exposeMapP = 0;	         },       w->slist.anyAreExposed = 0;* }*  5 static void SaveExposeRegion(w, x, vY, width, height)a     SListWidget w;     int x, vY, width, height;  { "     int firstLine, lastLine, line;  <     firstLine = (vY - w->slist.textY) / w->slist.cellHeight;%     if (firstLine < 0) firstLine = 0;s.     if (firstLine >= w->slist.LineCnt) return;  H     lastLine = (vY - w->slist.textY + height - 1) / w->slist.cellHeight;F     if (lastLine >= w->slist.LineCnt) lastLine = w->slist.LineCnt - 1;     if (lastLine < 0) return;s  4     for (line=firstLine; line <= lastLine; line++) {&         w->slist.exposeMapP[line] = 1;#         w->slist.anyAreExposed = 1;      }  }    static void StartScrollGrop(w)     SListWidget w; {kA     SaveExposeRegion (w, 0, w->slist.YAdjust, w->slist.textWidth,a         w->slist.textHeight);*       DrawExposedLines (w);  }L   static void Repaint(w)     SListWidget w; { A     if (XtIsRealized (w)) XClearArea (XtDisplay (w), XtWindow(w), '         w->slist.textX, w->slist.textY, 4         w->slist.textWidth, w->slist.textHeight, 0);  A     SaveExposeRegion (w, 0, w->slist.YAdjust, w->slist.textWidth,          w->slist.textHeight);/       DrawExposedLines (w);r }_   static void DoExpose(w, eventP)      SListWidget w;     XEvent *eventP;  {      CheckSize(w); !     if (!XtIsRealized(w)) return;r  D /*    if (XtIsRealized (w)) XClearArea (XtDisplay (w), XtWindow (w),         eventP->xexpose.x,         eventP->xexpose.y, E<         eventP->xexpose.width, eventP->xexpose.height, 0);*/   #ifdef MOTIF,     _XmDrawShadow(XtDisplay(w), XtWindow(w),; 	w->primitive.top_shadow_GC, w->primitive.bottom_shadow_GC,tE 	w->primitive.shadow_thickness, 0, 0, w->core.width, w->core.height);  #endif     SaveExposeRegion (w,         eventP->xexpose.x,-         eventP->xexpose.y + w->slist.YAdjust,r         eventP->xexpose.width,          eventP->xexpose.height);  ?     /* If this is not a primary Expose event, simply return. */   &     if (eventP->xexpose.count) return;       DrawExposedLines (w);  } : static XtGeometryResult QueryGeometry(w, proposed, answer) SListWidget w;$ XtWidgetGeometry *proposed, *answer; {e/ #define Set(bit) (proposed->request_mode & bit),  )     /* Return preferred width + Height */L.     answer->request_mode = CWWidth | CWHeight;  8     answer->width = w->slist.cellWidth * w->slist.cols +#         w->slist.leftMarginWidth + c #ifdef MOTIF)         2*w->primitive.shadow_thickness +  #endif 	2 * w->core.border_width + 6;   #ifdef MOTIF:     answer->height = w->slist.rows * w->slist.cellHeight +(         4*w->primitive.shadow_thickness; #elsev=     answer->height = w->slist.rows * w->slist.cellHeight + 2;f #endif  ;     if (Set(CWWidth) && proposed->width == answer->width &&n>         Set(CWHeight) && proposed->height == answer->height) {         return XtGeometryYes;      } M     if (answer->width == w->core.width && answer->height == w->core.height) {w         return XtGeometryNo;     }e     return XtGeometryAlmost; }i
 #undef Set r$ static void DoInitialize(request, w)     SListWidget request, w;> {s     XFontStruct *fontP;a     XGCValues	values;>     short	fontIndex;     Arg         vsbArgs[50];     int         i;     int         requiredWidth;      unsigned long charWidth = 0;       w->slist.YAdjust = 0;*     w->slist.listIsGrabbed = 0;x*     w->slist.selectMapP =       (char*) 0;2     w->slist.LineCnt = w->slist.anyAreExposed = 0;$     w->slist.exposeMapP = (char*) 0;     w->slist.mapLen =   0;       w->slist.topLine = 0; #     w->slist.highlightedLine =  -1;h  H     w->slist.ClickTimerID = w->slist.DownCount = w->slist.ClickLine = 0;   #ifdef MOTIF$     if (w->slist.fontRecP == NULL) {6         fontP = XLoadQueryFont(XtDisplay(w), "fixed");     } else {C         _XmFontListSearch((XmFontList)w->slist.fontRecP, "default",i 		 &fontIndex, &fontP);      }s     if (!fontP)n6         fontP = XLoadQueryFont(XtDisplay(w), "fixed");     w->slist.fontP = fontP;Y #else 5     /* Simply use the first font in the font list. */0  $     if (w->slist.fontRecP == NULL) {G         fontP = w->slist.fontP = XLoadQueryFont(XtDisplay(w), "fixed");      } else {9         fontP = w->slist.fontP = w->slist.fontRecP->font;i     }i #endif(     /* Compute some useful constants. */  S     w->slist.cellHeight = fontP->max_bounds.descent + fontP->max_bounds.ascent + 2;i4     w->slist.yFontAdjust = fontP->max_bounds.ascent;  N     /* Make a reasonable initial size for the widget if none was specified. */  O     if ((!XGetFontProperty(fontP, XA_QUAD_WIDTH, &charWidth)) || charWidth==0){-A         if (fontP->per_char && fontP->min_char_or_byte2 <= '0' && ?                                fontP->max_char_or_byte2 >= '0') N             charWidth = fontP->per_char['0' - fontP->min_char_or_byte2].width;         else0             charWidth = fontP->max_bounds.width;     }s&     if (charWidth <= 0) charWidth = 1;/     requiredWidth = w->slist.cols * charWidth +f #ifdef MOTIF" 	2*w->primitive.shadow_thickness + #endif'         2 * (w->core.border_width + 6);e  .     if ((int) w->core.width < requiredWidth) {'         w->core.width =  requiredWidth;      }t#     w->slist.cellWidth = charWidth;n       if (!w->slist.rows) { C         w->slist.rows = (int) w->core.height / w->slist.cellHeight;      } else { #ifdef MOTIF>         w->core.height = w->slist.rows * w->slist.cellHeight +' 	    4 * w->primitive.shadow_thickness;  #else A         w->core.height = w->slist.rows * w->slist.cellHeight + 2;= #endif     }t  4     w->slist.leftMarginWidth = w->core.border_width;*     w->slist.knownHeight = w->core.height;(     w->slist.knownWidth = w->core.width; #ifdef MOTIFA     w->slist.textX = w->slist.textY = 2 * w->core.border_width + i 	w->primitive.shadow_thickness; B     w->slist.textWidth = w->core.width - 4*w->core.border_width - # 	2 * w->primitive.shadow_thickness;  #else (     w->slist.textX = w->slist.textY = 0;'     w->slist.textWidth = w->core.width;  #endif>     w->slist.textHeight = w->slist.rows * w->slist.cellHeight;  !     /* Load graphics contexts. */        values.font = fontP->fid;W,     values.foreground = w->slist.foreground;1     values.background = w->core.background_pixel;      values.function = GXcopy; *     w->slist.normgc = XtGetGC ((Widget) w,D         GCFont | GCForeground | GCBackground | GCFunction, &values);  -     w->slist.normtxtgc = XtGetGC ((Widget) w, D         GCFont | GCForeground | GCBackground | GCFunction, &values);       values.font = fontP->fid;=1     values.foreground = w->core.background_pixel;-,     values.background = w->slist.foreground;     values.function = GXcopy;b(     w->slist.invgc = XtGetGC((Widget) w,D         GCFont | GCForeground | GCBackground | GCFunction, &values);       values.function = GXinvert;CG     values.plane_mask = w->core.background_pixel ^ w->slist.foreground; *     w->slist.flipgc = XtGetGC ((Widget) w,+         GCFunction | GCPlaneMask, &values);a  
     i = 0;'     VSCallBack[0].closure = (caddr_t)w;e #ifdef MOTIFL     XtSetArg(vsbArgs[i], XmNorientation,      XmVERTICAL);              i++;L     XtSetArg(vsbArgs[i], XmNheight,           w->core.height);          i++;L     XtSetArg(vsbArgs[i], XmNvalue,            w->slist.YAdjust);        i++;+     if (w->slist.LineCnt > w->slist.rows) {bL         XtSetArg(vsbArgs[i], XmNminimum,      0);                       i++;L         XtSetArg(vsbArgs[i], XmNmaximum,      w->slist.LineCnt);        i++;L         XtSetArg(vsbArgs[i], XmNsliderSize,   w->slist.rows);           i++;     } else {L         XtSetArg(vsbArgs[i], XmNminimum,      0);                       i++;L         XtSetArg(vsbArgs[i], XmNmaximum,      5);                       i++;L         XtSetArg(vsbArgs[i], XmNsliderSize,   5);                       i++;     }fL     XtSetArg(vsbArgs[i], XmNincrement, 1);                              i++;L     XtSetArg(vsbArgs[i], XmNpageIncrement, w->slist.rows-1);            i++;L     XtSetArg(vsbArgs[i], XmNincrementCallback, VSCallBack);             i++;L     XtSetArg(vsbArgs[i], XmNdecrementCallback, VSCallBack);             i++;L     XtSetArg(vsbArgs[i], XmNpageIncrementCallback, VSCallBack);         i++;L     XtSetArg(vsbArgs[i], XmNpageDecrementCallback, VSCallBack);         i++;L     XtSetArg(vsbArgs[i], XmNdragCallback,    VSCallBack);               i++;;     w->slist.vScroll = XtCreateManagedWidget("vpaneScroll",i:         xmScrollBarWidgetClass, XtParent (w), vsbArgs, i);  J     XmScrolledWindowSetAreas(XtParent(w), (Widget) NULL, w->slist.vScroll, 		(Widget) w); #elsenL     XtSetArg(vsbArgs[i], DwtNorientation,     DwtOrientationVertical);  i++;L     XtSetArg(vsbArgs[i], DwtNheight,          w->core.height);          i++;L     XtSetArg(vsbArgs[i], DwtNvalue,           w->slist.YAdjust);        i++;+     if (w->slist.LineCnt > w->slist.rows) { L         XtSetArg(vsbArgs[i], DwtNminValue,    0);                       i++;L         XtSetArg(vsbArgs[i], DwtNmaxValue,    w->slist.LineCnt);        i++;L         XtSetArg(vsbArgs[i], DwtNshown,       w->slist.rows);           i++;> 	XtSetArg(vsbArgs[i], DwtNpageInc,     w->slist.rows-1);		i++;     } else {L         XtSetArg(vsbArgs[i], DwtNminValue,    0);                       i++;L         XtSetArg(vsbArgs[i], DwtNmaxValue,    1);                       i++;     } L     XtSetArg(vsbArgs[i], DwtNinc,             1);                       i++;L     XtSetArg(vsbArgs[i], DwtNunitIncCallback, VSCallBack);              i++;L     XtSetArg(vsbArgs[i], DwtNunitDecCallback, VSCallBack);              i++;L     XtSetArg(vsbArgs[i], DwtNpageIncCallback, VSCallBack);              i++;L     XtSetArg(vsbArgs[i], DwtNpageDecCallback, VSCallBack);              i++;L     XtSetArg(vsbArgs[i], DwtNdragCallback,    VSCallBack);              i++;;     w->slist.vScroll = XtCreateManagedWidget("vpaneScroll", 5         scrollwidgetclass, XtParent (w), vsbArgs, i);nD     DwtScrollWindowSetAreas(XtParent(w), NULL, w->slist.vScroll, w);5     w->slist.parentWidth = w->slist.parentHeight = 0;i #endif   }- s, static void DoRealize(w, maskP, attributesP)     SListWidget w;     Mask *maskP;&     XSetWindowAttributes *attributesP; {C  !     Boolean ResizeNeeded = False;,  /     if (w->core.width != w->slist.knownWidth || /         w->core.height != w->slist.knownHeight)_              ResizeNeeded = True;  O     /* Make sure the window is automatically cleared whenever it is resized. */        *maskP |= CWBitGravity;)-     attributesP->bit_gravity = ForgetGravity;   Q     XtCreateWindow ((Widget) w, InputOutput, CopyFromParent, *maskP,attributesP);A  D     /* Establish passive button grabs and declare event handlers. */       XGrabButton (tE         XtDisplay (w),                                  /* display */ I         1,                                              /* button_grab */uG         AnyModifier,                                    /* modifiers */lD         XtWindow (w),                                   /* window */J         0,                                              /* owner_events */B         (ButtonPressMask | ButtonReleaseMask | Button1MotionMask),H                                                         /* event_mask */J         GrabModeAsync,                                  /* pointer_mode */K         GrabModeAsync,                                  /* keyboard_mode */>H         None,                                           /* confine_to */D         None);                                          /* cursor */  :     XtAddRawEventHandler ((Widget) w, ButtonPressMask, 0, , 				(XtEventHandler) ButtonPressHandler, 0);;     XtAddRawEventHandler ((Widget) w, PointerMotionMask, 0, . 				(XtEventHandler) PointerMotionHandler, 0);<     XtAddRawEventHandler ((Widget) w, ButtonReleaseMask, 0, . 				(XtEventHandler) ButtonReleaseHandler, 0);  4     w->slist.leftMarginWidth = w->core.border_width;       if (ResizeNeeded)a         DoResize (w);  }    static void DoResize(w)      SListWidget w; {      Arg vsbArgs[30];
     int i;     Boolean resized = False;  1     if (w->core.height != w->slist.knownHeight) {*         resized = True;t.         w->slist.knownHeight = w->core.height;         SetYAdjust (w, 0); #ifdef MOTIF0         w->slist.rows =	(int) (w->core.height - 9 		2*w->primitive.shadow_thickness) / w->slist.cellHeight;1 #else =         w->slist.rows = w->core.height / w->slist.cellHeight;  #endif; 	w->slist.textHeight = w->slist.rows * w->slist.cellHeight;i0         if (w->slist.vScroll != (Widget) NULL) {             i = 0; #ifdef MOTIF2             XtSetArg(vsbArgs[i], XmNvalue, 0);i++;6             XtSetArg(vsbArgs[i], XmNincrement, 1);i++;H             XtSetArg(vsbArgs[i], XmNpageIncrement, w->slist.rows-1);i++;3             if (w->slist.LineCnt > w->slist.rows) {e7                 XtSetArg(vsbArgs[i], XmNminimum,0);i++; F                 XtSetArg(vsbArgs[i], XmNmaximum,w->slist.LineCnt);i++;G                 XtSetArg(vsbArgs[i], XmNsliderSize, w->slist.rows);i++;n             } else {7                 XtSetArg(vsbArgs[i], XmNminimum,0);i++;U7                 XtSetArg(vsbArgs[i], XmNmaximum,5);i++;S:                 XtSetArg(vsbArgs[i], XmNsliderSize,5);i++;
             }t6             XtSetValues(w->slist.vScroll, vsbArgs, i); #elses3             XtSetArg(vsbArgs[i], DwtNvalue, 0);i++;c3             if (w->slist.LineCnt > w->slist.rows) {s9                 XtSetArg(vsbArgs[i], DwtNminValue,0);i++;fH                 XtSetArg(vsbArgs[i], DwtNmaxValue,w->slist.LineCnt);i++;C                 XtSetArg(vsbArgs[i], DwtNshown, w->slist.rows);i++;u9 		XtSetArg(vsbArgs[i], DwtNpageInc, w->slist.rows-1);i++;              } else {9                 XtSetArg(vsbArgs[i], DwtNminValue,0);i++;t9                 XtSetArg(vsbArgs[i], DwtNmaxValue,1);i++;t
             }n6             XtSetValues(w->slist.vScroll, vsbArgs, i); #endif	         }n     }s/     if (w->core.width != w->slist.knownWidth) {          resized = True; B         w->slist.textWidth = w->core.width - 2 * (w->slist.textX);,         w->slist.knownWidth = w->core.width;     }e5     if (resized && w->core.window != (Window) NULL) {=4         XMoveResizeWindow(XtDisplay(w), XtWindow(w),E                 w->core.x, w->core.y, w->core.width, w->core.height);       } }i   static void DoDestroy(w)     SListWidget w; {a }e@ XtActionProc slistForwardPage(widget, event, params, num_params) Widget widget; XEvent *event; char **params; Cardinal *num_params;  {f)     SListWidget w = (SListWidget) widget;*#     int topLine = w->slist.topLine;i  "     if (topLine < 0) topLine = -1;D     else if (topLine > w->slist.LineCnt) topLine = w->slist.LineCnt;0     SListSetTop(w, topLine + w->slist.rows - 1);
     return 0;  } A XtActionProc slistBackwardPage(widget, event, params, num_params)  Widget widget; XEvent *event; char **params; Cardinal *num_params;  { )     SListWidget w = (SListWidget) widget;e     int topLine;       topLine = w->slist.topLine;i"     if (topLine < 0) topLine = -1;D     else if (topLine > w->slist.LineCnt) topLine = w->slist.LineCnt;0     SListSetTop(w, topLine - w->slist.rows + 1);
     return 0;r }H@ XtActionProc slistForwardLine(widget, event, params, num_params) Widget widget; XEvent *event; char **params; Cardinal *num_params;u {n)     SListWidget w = (SListWidget) widget; '     int topLine = SListGetHighlight(w);   0     if (topLine < 0) topLine = w->slist.topLine;"     if (topLine < 0) topLine = -1;     topLine++;?     if (topLine > w->slist.LineCnt) topLine = w->slist.LineCnt;P     SListHighlight(w, topLine);P
     return 0;e }tA XtActionProc slistBackwardLine(widget, event, params, num_params)  Widget widget; XEvent *event; char **params; Cardinal *num_params;a { )     SListWidget w = (SListWidget) widget;e'     int topLine = SListGetHighlight(w);t  0     if (topLine < 0) topLine = w->slist.topLine;!     if (topLine < 0) topLine = 0;t     topLine--;!     if (topLine < 0) topLine = 0;z     SListHighlight(w, topLine);r
     return 0;  }  f static void ClassInitialize()r { ?     slistwidgetclassrec.core_class.actions = slistActionsTable; M     slistwidgetclassrec.core_class.num_actions = XtNumber(slistActionsTable);+<     slistwidgetclassrec.core_class.tm_table = slistBindings; }    /*  * Public routines  */  void SListLoad(w, LineCnt)     SListWidget w;     int LineCnt; {e
     int line;w     char *exposeMapP;s     char *selectMapP;v     Arg vsbArgs[10];
     int i;       w->slist.LineCnt = LineCnt;s     w->slist.topLine = 0;Y  B     /* Reallocate the expose and select maps if not big enough. */  $     if (w->slist.mapLen < LineCnt) {(         w->slist.mapLen = LineCnt + 100;%         XtFree (w->slist.exposeMapP); :         w->slist.exposeMapP =  XtMalloc (w->slist.mapLen);%         XtFree (w->slist.selectMapP);s:         w->slist.selectMapP =  XtMalloc (w->slist.mapLen);     }-       /* Clear the maps. */   R     for (line=0, exposeMapP=w->slist.exposeMapP, selectMapP = w->slist.selectMapP;           line<LineCnt; line++) {         *(exposeMapP++) = 0;         *(selectMapP++) = 0;     }s  "     w->slist.highlightedLine = -1;2     w->slist.anyAreExposed = w->slist.YAdjust = 0;     SetYAdjust (w, 0);,     if (w->slist.vScroll != (Widget) NULL) {         i = 0; #ifdef MOTIF.         XtSetArg(vsbArgs[i], XmNvalue, 0);i++;2         XtSetArg(vsbArgs[i], XmNincrement, 1);i++;D         XtSetArg(vsbArgs[i], XmNpageIncrement, w->slist.rows-1);i++;/         if (w->slist.LineCnt > w->slist.rows) {t3             XtSetArg(vsbArgs[i], XmNminimum,0);i++; B             XtSetArg(vsbArgs[i], XmNmaximum,w->slist.LineCnt);i++;C             XtSetArg(vsbArgs[i], XmNsliderSize, w->slist.rows);i++;X         } else {3             XtSetArg(vsbArgs[i], XmNminimum,0);i++; 3             XtSetArg(vsbArgs[i], XmNmaximum,5);i++;,6             XtSetArg(vsbArgs[i], XmNsliderSize,5);i++;	         }, #elser/         XtSetArg(vsbArgs[i], DwtNvalue, 0);i++;_2         XtSetArg(vsbArgs[i], DwtNminValue, 0);i++;/         if (w->slist.LineCnt > w->slist.rows) {e6             XtSetArg(vsbArgs[i], DwtNminValue, 0);i++;E             XtSetArg(vsbArgs[i], DwtNmaxValue, w->slist.LineCnt);i++;v?             XtSetArg(vsbArgs[i], DwtNshown, w->slist.rows);i++;e< 	    XtSetArg(vsbArgs[i], DwtNpageInc, w->slist.rows-1);i++;         } else {6             XtSetArg(vsbArgs[i], DwtNminValue, 0);i++;6             XtSetArg(vsbArgs[i], DwtNmaxValue, 1);i++;	         }d #endif2         XtSetValues(w->slist.vScroll, vsbArgs, i);     }        Repaint (w); }    int SListGetTop(w)     SListWidget w; {=#     int topLine = w->slist.topLine;i  "     if (topLine < 0) topLine = -1;D     else if (topLine > w->slist.LineCnt) topLine = w->slist.LineCnt;     return topLine;c }s void SListSetTop(w, item)b     SListWidget w;
     int item;  {n     int topLine;     Arg vsbArg[1];       topLine = w->slist.topLine;i"     if (topLine < 0) topLine = -1;D     else if (topLine > w->slist.LineCnt) topLine = w->slist.LineCnt;0     if (item > w->slist.LineCnt - w->slist.rows)0         item = w->slist.LineCnt - w->slist.rows;     if (item < 0) item = 0;       if (item == topLine) return;2     w->slist.YAdjust = item * w->slist.cellHeight;     w->slist.topLine = item;,     if (w->slist.vScroll != (Widget) NULL) { #ifdef MOTIF,         XtSetArg(vsbArg[0], XmNvalue, item); #elseq-         XtSetArg(vsbArg[0], DwtNvalue, item);  #endif1         XtSetValues(w->slist.vScroll, vsbArg, 1);t     }      Repaint(w);s }g void SListUpdateLine(w, line)      SListWidget w;
     int line;i {d     Draw(w, line); }  void SListSelectAll(w, select)     SListWidget w;     int select;s {t
     int line;      int needsRepaint = 0;t  2     for (line=0; line <w->slist.LineCnt; line++) {/         if (line != w->slist.highlightedLine &&;2             w->slist.selectMapP[line] != select) {             needsRepaint = 1;t/             w->slist.selectMapP[line] = select;c	         }      }f     if (needsRepaint)t         Repaint (w); }    void SListUnhighlight(w)     SListWidget w; { /     if (w->slist.highlightedLine == -1) return;s  9     SetLineSelection(w, w->slist.highlightedLine, False); "     w->slist.highlightedLine = -1; }  void SListHighlight(w, line)     SListWidget w;
     int line;P { P     if (line == w->slist.highlightedLine) return;       /* don't set it again */)     if (w->slist.highlightedLine != -1) {i=         SetLineSelection(w, w->slist.highlightedLine, False);{	     }    o  $     w->slist.highlightedLine = line;$     SetLineSelection(w, line, True); }s int SListGetHighlight(w)     SListWidget w; {h$     return w->slist.highlightedLine; }x  , Widget SListCreate(pW, nameP, argsP, argCnt)     Widget pW;     char *nameP;     Arg *argsP;b     int argCnt;o {hF     return (XtCreateWidget (nameP, (WidgetClass) slistwidgetclass, pW, 		argsP, argCnt)); }t  ! Boolean SListIsSelected(sl, line)o     SListWidget sl;P
     int line;y { ,     if (line > sl->slist.mapLen || line < 0)         return False;=  &     return sl->slist.selectMapP[line]; }a
 #ifndef MOTIFm void SListInitializeForDRM() { H     DwtRegisterClass (DRMwcUnknown, "SList", "SListCreate", SListCreate,         slistwidgetclass); }  #elser #ifdef USE_MRM void SListInitializeForMRM() {TH     MrmRegisterClass (MrmwcUnknown, "SList", "SListCreate", SListCreate,         slistwidgetclass); }  #endif #endif