 #ifndef SERVER_H #define SERVER_H   /*f  * $Header: /net/objy27/wrld/mnt11/ricks/src/master/xrn/server.h,v 1.7 1993/02/04 18:22:30 ricks Exp $  */    /*$  * xrn - an X-based NNTP news reader  *G  * Copyright (c) 1988-1993, Ellen M. Sentovich and Rick L. Spickelmier.   *H  * Permission to use, copy, modify, and distribute this software and itsL  * documentation for any purpose and without fee is hereby granted, providedJ  * that the above copyright notice appear in all copies and that both thatC  * copyright notice and this permission notice appear in supporting G  * documentation, and that the name of the University of California not E  * be used in advertising or publicity pertaining to distribution of  K  * the software without specific, written prior permission.  The University G  * of California makes no representations about the suitability of this G  * software for any purpose.  It is provided "as is" without express or   * implied warranty.  *H  * THE UNIVERSITY OF CALIFORNIA DISCLAIMS ALL WARRANTIES WITH REGARD TO J  * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND H  * FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE FORK  * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER G  * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF G  * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN  ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   */    /*H  * server.h: routines for communicating with the NNTP remote news server  *  */    #include "codes.h"   /*A  * function definitions for the nntp server (in nntp/clientlib.c)   */     extern void close_server(); 0 extern int get_server _ARGUMENTS((char *, int));2 extern char *getserverbyfile _ARGUMENTS((char *));4 extern int put_server _ARGUMENTS((char *, Boolean));, extern int server_init _ARGUMENTS((char *)); extern void start_server();   = /* get the list of active news groups from the news server */  extern void getactive();  9 /* see if the subscribed to groups have 0 or 1 article */ # extern void fixLowArticleNumbers();   D /* get a single article in the current group from the news server */ #ifdef XLATED extern char *getarticle _ARGUMENTS((art_num, int *, int, int, int)); #else ? extern char *getarticle _ARGUMENTS((art_num, int *, int, int));  #endif #define FULL_HEADER   1  #define NORMAL_HEADER 2  #define NOT_ROTATED   1  #define ROTATED       2  #define NOT_XLATED    1  #define XLATED        2    /*O  * tell the server that the next set of article requests will be for this group   *  returns NO_GROUP on failure   */ X extern int getgroup _ARGUMENTS((struct newsgroup *, art_num *, art_num *, int *number));  ^ /* get a list of subject lines for a range of articles in the current group from the server */P extern void getsubjectlist _ARGUMENTS((struct newsgroup *,art_num,art_num,int));O extern void getauthorlist _ARGUMENTS((struct newsgroup *,art_num,art_num,int)); N extern void getlineslist _ARGUMENTS((struct newsgroup *,art_num,art_num,int));N extern void getmsgidlist _ARGUMENTS((struct newsgroup *,art_num,art_num,int));M extern void getrefslist _ARGUMENTS((struct newsgroup *,art_num,art_num,int)); P extern Boolean getoverview _ARGUMENTS((struct newsgroup *,art_num,art_num,int));   /* xhdr commands */ 8 extern void xhdr _ARGUMENTS((art_num, char *, char **));   /* post article */1 extern int postArticle _ARGUMENTS((char *, int));    /* wrap article text buffer */3 extern char** wrapText _ARGUMENTS((char *, int *)); . extern char*  wrapString _ARGUMENTS((char *));   /* in clientlib.c */< extern int handle_server_response _ARGUMENTS((int, char *));   #define XRN_MAIL	 0  #define XRN_NEWS	 1    #define POST_FAILED      0 #define POST_OKAY        1 #define POST_NOTALLOWED  2 #define POST_TRYAGAIN	 3   #endif /* SERVER_H */ 