  % #if !defined(lint) && !defined(SABER)  static char XRNrcsid[] = "$Header: /net/objy27/wrld/mnt11/ricks/src/master/xrn/server.c,v 1.10 1993/02/04 18:22:28 ricks Exp $"; #endif   /*$  * xrn - an X-based NNTP news reader  *G  * Copyright (c) 1988-1993, Ellen M. Sentovich and Rick L. Spickelmier.   *H  * Permission to use, copy, modify, and distribute this software and itsL  * documentation for any purpose and without fee is hereby granted, providedJ  * that the above copyright notice appear in all copies and that both thatC  * copyright notice and this permission notice appear in supporting G  * documentation, and that the name of the University of California not E  * be used in advertising or publicity pertaining to distribution of  K  * the software without specific, written prior permission.  The University G  * of California makes no representations about the suitability of this G  * software for any purpose.  It is provided "as is" without express or   * implied warranty.  *H  * THE UNIVERSITY OF CALIFORNIA DISCLAIMS ALL WARRANTIES WITH REGARD TO J  * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND H  * FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE FORK  * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER G  * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF G  * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN  ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   */    /*H  * server.c: routines for communicating with the NNTP remote news server  *  */    #include "copyright.h" #include <ctype.h> #include <stdio.h> #include <assert.h>  #ifndef VMS  #include <sys/param.h> #include <sys/wait.h>  #else  #define MAXPATHLEN 512 #define index strchr #endif /* VMS */ #include <errno.h> #include "config.h"  #include "utils.h" #include "xrn.h" #include "avl.h" #include "news.h"  #include "mesg.h"  #include "error_hnds.h"  #include "resources.h" #include "server.h"  #include "dialogs.h" #include "xthelper.h"  #include "xmisc.h"  7 #if defined(sun) && defined(sparc) && !defined(SOLARIS)  #include <vfork.h> #endif   #ifdef INEWS #include <sys/stat.h>  #endif   #define BUFFER_SIZE 1024 #define MESSAGE_SIZE 1024  #define MAXFIELDS 9  #define DEFREFS 20   #ifdef __STDC__  #include <stdlib.h>  #include <time.h>  #ifndef VMS  #include <unistd.h>  #else  extern void sleep(); extern int mailArticle();  #endif #ifdef VFORK_SUPPORTED #ifndef SVR4_0 extern int vfork();  #else  extern pid_t vfork(void);  #endif #endif #else 7 #if !defined(VMS) && !defined(SVR4) && !defined(ultrix)  #if defined(__convexc__) extern unsigned sleep(); #else  #if !defined(__osf__)  extern void sleep(); #endif #endif #endif #endif   extern Boolean allowErrors; ' extern struct article *currentArticles;   extern struct article *savedArt; extern int artCount;   int ServerDown = 0; & static char mybuf[MESSAGE_SIZE+100] = ; 	"The news server is not responding correctly, aborting\n";   . static struct newsgroup *currentNewsgroup = 0;P #define SETNEWSGROUP(n) (((n) == currentNewsgroup) ? 0 : getgroup((n), 0, 0, 0))   /*2  * get data from the server (active file, article)  *  *  on error, sets 'ServerDown'   *  *   returns: void  */  static void  get_data_from_server(str, size) 9 char *str;     /* string for message to be copied into */ 9 int size;      /* size of string                       */  {       xthHandleAllPendingEvents();     str[0] = '\0';     if (ServerDown) return; $     if (get_server(str, size) < 0) { 	ServerDown = 1;     } else { 	ServerDown = 0;     }      return;  }      static void . check_time_out(command, response, size, pause)1 char *command;  /* command to resend           */ 1 char *response; /* response from the command   */ 1 int size;       /* size of the response buffer */ 4 Boolean pause;	/* True if pause should be checked */ {      /*$      * try to recover from a timeout      *=      *   this assumes that the timeout message stays the same @      *   since the error number (503) is used for more than just      *   timeout      *      *   Message is:      *     503 Timeout ...      */         int old = ActiveGroupsCount;0     struct newsgroup *wanted = currentNewsgroup;     char message[512];     int status;   <     if (ServerDown || STREQN(response, "503 Timeout", 11)) {  %         if (XtIsRealized(TopLevel)) {   	    xmSetIconAndName(LostIcon);! 	    XFlush(XtDisplay(TopLevel));  	}V 	mesgPane(XRN_SERIOUS, "Lost connection to the NNTP server, attempting to reconnect"); 	start_server(NIL(char));   6 	mesgPane(XRN_INFO, "Reconnected to the NNTP server");%         if (XtIsRealized(TopLevel)) { " 	    xmSetIconAndName(UnreadIcon);! 	    XFlush(XtDisplay(TopLevel));  	}   	/* G 	 * if it was an ARTICLE or XHDR or HEAD command, then you must get the @ 	 * server into the right state (GROUP mode), so resend the last 	 * group command  	 */B 	if (STREQN(command, "ARTICLE", 7) || STREQN(command,"XHDR", 4) ||@ 	    STREQN(command, "HEAD", 4) || STREQN(command,"XOVER", 5)) { 	    if (wanted) { 		currentNewsgroup = 0; < 		if (getgroup(wanted, NIL(art_num), NIL(art_num), NIL(int)) 			== NO_GROUP) { 
 		    return;  		}		  		currentNewsgroup = wanted;C 		/* XXX should do some processing of changed first/last numbers */  	    } 	}   	 % 	if (put_server(command, True) == -1)  	    ServerDown = True; & 	get_data_from_server(response, size);     } /     if (pause && STREQN(response, "400 ", 4)) { %         if (XtIsRealized(TopLevel)) {   	    xmSetIconAndName(LostIcon);! 	    XFlush(XtDisplay(TopLevel));  	}C 	sprintf(message, "Error from news server: %s - retry?", response); - 	status = ConfirmationBox(TopLevel, message); 
 	if (!status)  	    ehCleanExitXRN(); 	 % 	if (put_server(command, True) == -1)  	    ServerDown = True; & 	get_data_from_server(response, size);     }           return;  }    /*M  * retrieve article number 'artnumber' in the current group, update structure   *G  *   returns:  article text or NIL(char) if the article is not avaiable   *  */  char * #ifdef XLATE9 getarticle(artnumber, position, header, rotation,xlation)  #else 1 getarticle(artnumber, position, header, rotation)  #endifK art_num artnumber; /* number of article in the current group to retrieve */ J int *position;	   /* byte position of header/body seperation            */ int header, rotation;  #ifdef XLATE int xlation; #endif { <     char command[MESSAGE_SIZE], message[MESSAGE_SIZE], *msg; #ifdef REALLY_USE_LOCALTIME      char temp[MESSAGE_SIZE]; #endif"     static char	*artstring = NULL;     char *newartstring = NULL;!     static int	artstringsize = 0;      char *ptr;     char *endPtr;      int  segSize;      char field[BUFFER_SIZE];%     int byteCount = 0, lineCount = 0;      int last_stripped = 0;       if (artstring == NULL) { 	artstring = XtMalloc(100000);         artstringsize = 100000;      }      *position = 0;     *artstring = '\0';          /* send ARTICLE */6     (void) sprintf(command, "ARTICLE %ld", artnumber);(     if (put_server(command, True) == -1) 	ServerDown = True; 3     get_data_from_server(message, sizeof(message));   <     check_time_out(command, message, sizeof(message), True);       if (*message != CHAR_OK) { 	/* can't get article */ 	return(NIL(char));      }        endPtr = artstring;      for (;;) {0 	if (byteCount + MESSAGE_SIZE > artstringsize) {5 	    newartstring = XtMalloc(artstringsize + 100000);  	    artstringsize += 100000; & 	    strcpy (newartstring, artstring); 	    XtFree(artstring);  	    artstring = newartstring;$ 	    endPtr = artstring + byteCount; 	}0 	get_data_from_server(message, sizeof(message)); 	if (ServerDown) {> 	    check_time_out(command, message, sizeof(message), False); 	    if (*message != CHAR_OK) {  		/* can't get article */  		return(NIL(char)); 	    } 	    byteCount = 0;  	    endPtr = artstring; 	    continue; 	}	       8 	/* the article is ended by a '.' on a line by itself */3 	if ((message[0] == '.') && (message[1] == '\0')) { $ 	    /* check for a bogus message */ 	    if (byteCount == 0) { 		return(NIL(char)); 	    } 	    break;  	}   	msg = &message[0];   " 	/* find header/body seperation */ 	if (*position == 0) { 	    if (*msg == '\0') { 		*position = byteCount; 	    } 	} 	        	if (*msg == '.') {  	    msg++;  	}   	if (*msg != '\0') { 	    /* strip leading ^H */  	    while (*msg == '\b') {  		msg++; 	    }  	    /* strip '<character>^H' */Q 	    for (ptr = index(msg + 1, '\b'); ptr != NIL(char); ptr = index(ptr, '\b')) {  		if (ptr - 1 < msg) {= 		    /* too many backspaces, kill all leading back spaces */  		    while (*ptr == '\b') {& 		        (void) strcpy(ptr, ptr + 1);	 			ptr++;  		    }  		    break; 		} " 		(void) strcpy(ptr - 1, ptr + 1); 		ptr--; 	    }   #ifdef REALLY_USE_LOCALTIME J   	    if (app_resources.displayLocalTime && !strncmp(msg, "Date: ", 6)) { 		  tconvert(temp, msg+6); 		  (void) strcpy(msg+6, temp);  	    } #endif 	    /* strip the headers */9 	    if ((*position == 0) && (header == NORMAL_HEADER)) { @ 		if ((*msg == ' ') || (*msg == '\t')) { /* continuation line */ 		    if (last_stripped) 			continue;
 		} else {1 		    if ((ptr = index(msg, ':')) == NIL(char)) { - 			continue;    /* weird header line, skip */  		    }  		    if (*(ptr+1) == '\0') { ' 			continue;    /* empty field, skip */  		    } 4 		    (void) strncpy(field, msg, (int) (ptr - msg));& 		    field[(int) (ptr - msg)] = '\0'; 		    utDowncase(field);> 		    if (avl_lookup(app_resources.headerTree, field, &ptr)) {3 			if (app_resources.headerMode == STRIP_HEADERS) {  			    last_stripped = 1;  			    continue; 			} else {  			    last_stripped = 0;  			} 		    } else {3 			if (app_resources.headerMode == LEAVE_HEADERS) {  			    last_stripped = 1;  			    continue; 			} else {  			    last_stripped = 0;  			} 		    }  		}  	    }  . 	    /* handle rotation of the article body */5 	    if ((rotation == ROTATED) && (*position != 0)) { ( 		for (ptr = msg; *ptr != '\0'; ptr++) { 		    if (isalpha(*ptr)) { 			if ((*ptr & 31) <= 13) {  			    *ptr = *ptr + 13; 			} else {  			    *ptr = *ptr - 13; 			} 		    }  		}  	    }   #ifdef XLATE1 	    /* handle translation of the article body */ 1 	    if ((xlation == XLATED) && (*position != 0))  		utXlate(msg);  #endif /* XLATE */   	    /* handle ^L (poorly?) */ 	    if (*msg == '\014') { 		int i, lines;  		lines = articleLines();  		lines -= lineCount % lines;  		for (i = 0; i < lines; i++) { " 		    (void) strcpy(endPtr, "\n"); 		    endPtr++;  		}  		byteCount += lines;  		lineCount += lines;  		msg++; 	    }  	    (void) strcpy(endPtr, msg); 	} 	segSize = utStrlen(msg);  	byteCount += segSize + 1; 	endPtr += segSize;  	*endPtr++ = '\n'; 	*endPtr = '\0';
 	lineCount++;      }   -     return( (char *) XtNewString(artstring));  }    /*F  * enter a new group and get its statistics (and update the structure)G  *   allocate an array for the articles and process the .newsrc article   *   info for this group  */  *   returns: NO_GROUP on failure, 0 on success   *  */  int ( getgroup(newsgroup, first, last, number)@ struct newsgroup *newsgroup;    /* group                      */2 art_num *first; 		/* first article in the group */2 art_num *last;  		/* last article in the group  */5 int *number;    		/* number of articles in the group, & 				 if 0, first and last are bogus */ { 6     char command[MESSAGE_SIZE], message[MESSAGE_SIZE];      char group[GROUP_NAME_SIZE];,     static long code, num, count, frst, lst;       if (!newsgroup) {  	newsgroup = currentNewsgroup;     }        if (!newsgroup) { 8 	/* this shouldn't ever happen, but let's be cautious */A 	ehErrorExitXRN("getgroup(NIL) called with no currentNewsgroup");      }   9     (void) sprintf(command, "GROUP %s", newsgroup->name); (     if (put_server(command, True) == -1) 	ServerDown = True;   3     get_data_from_server(message, sizeof(message));   <     check_time_out(command, message, sizeof(message), True);          if (*message != CHAR_OK) {$ 	if (atoi(message) != ERR_NOGROUP) {  , 	    (void) strcat(mybuf, "	Request was: ");# 	    (void) strcat(mybuf, command);   	    (void) strcat(mybuf, "\n");5 	    (void) strcat(mybuf, "	Failing response was: "); # 	    (void) strcat(mybuf, message);  	    ehErrorExitXRN(mybuf);  	} 	mesgPane(XRN_SERIOUS,K 	"Can't get the group \"%s\", looks like it was deleted out from under us",  			newsgroup->name); 	 + 	/* remove the group from active use ??? */  	  	return(NO_GROUP);     } !     currentNewsgroup = newsgroup;        /* break up the message */ #if GROUP_NAME_SIZE <= 127E 	"GROUP_NAME_SIZE is too small" /* this will produce a compilation */  	     /* error */  #endif4     count = sscanf(message, "%ld %ld %ld %ld %127s",& 		   &code, &num, &frst, &lst, group);     assert(count == 5);        if (number != NIL(int)) {  	*number = num;      }       if (first != NIL(art_num)) { 	*first = frst;      }      if (last != NIL(art_num)) { 
 	*last = lst;      }        return(0); }     # static Boolean error_retry = False;  /*J  * get a list of all active newsgroups and create a structure for each one  *  *   returns: void  */  void getactive()  { N     char command[MESSAGE_SIZE], message[MESSAGE_SIZE], group[GROUP_NAME_SIZE];     char type[MESSAGE_SIZE];      struct newsgroup *newsgroup;     art_num first, last;     char *ptr;     int error_count = 0; #ifdef SYSV_REGEX      extern char *regcmp();     extern char *regex();      static char **re_cache = 0;  #else      extern char *re_comp();  #endifB     char **re_list = app_resources.ignoreNewsgroupsList, **re_ptr;   #ifdef SYSV_REGEX      if (!re_cache && re_list) {  	int i = 0, re_num;  	while (re_list[i]) { 	 	    i++;  	}9 	re_cache = (char **) XtMalloc(sizeof(char *) * (i + 1));  	if (!re_cache) { % 	    ehErrorExitXRN("out of memory");  	}) 	for (re_num = 0; re_num < i; re_num++) { 4 	    if (re_cache[re_num] = regcmp(re_list[i], 0)) { 		re_num++;  	    } 	} 	re_cache[re_num] = 0;     }      re_list = re_cache;  #endif       /*F      * It *is* necessary to reset currentNewsgroup to 0 when getactiveF      * is called, even though the NNTP server does not forget its ideaB      * of the current newsgroup when a LIST command is issued.  ToC      * understand why this is so, imagine the following sequence of       * events:      *'      * 1) User reads newsgroup foo.bar. A      * 2) User exits from newsgroup, but currentNewsgroup remains       *    foo.bar.      * 3) User rescans. @      * 4) The active file that gets sent as a result of the LIST>      *    command says that there are new articles in foo.bar.B      * 5) HOWEVER, even though the active file says that, the NNTPE      *    server has not yet realized that, because it doesn't update D      *    its idea of what's in the current newsgroup unless a GROUPD      *    command is issued, i.e., it ignores the LIST data it sends      *    over the wire.*      * 6) User tries to reenter newsgroup.D      * 7) Since currentNewsgroup is set to foo.bar, xrn doesn't sendD      *    GROUP command.  Therefore, NNTP server does not update its:      *    idea of low and high articles for the newsgroup.E      * 8) Therefore, the XHDR commands to get header information from E      *    the new articles fail, because the server doesn't know that       *    those articles exist.       *E      * We solve this problem by always requiring a GROUP command when ?      * first accessing a group after a LIST command, by setting       * currentNewsgroup to 0.       */        currentNewsgroup = 0; #     (void) strcpy(command, "LIST"); (     if (put_server(command, True) == -1) 	ServerDown = True; 3     get_data_from_server(message, sizeof(message));   <     check_time_out(command, message, sizeof(message), True);          if (*message != CHAR_OK) {  ) 	(void) strcat(mybuf, "\tRequest was: ");  	(void) strcat(mybuf, command);  	(void) strcat(mybuf, "\n");2 	(void) strcat(mybuf, "\tFailing response was: "); 	(void) strcat(mybuf, message);  	ehErrorExitXRN(mybuf);      }        for (;;) {0 	get_data_from_server(message, sizeof(message)); 	if (ServerDown) {7 	    check_time_out(command, message, sizeof(message));, 	    continue; 	} 	:< 	/* the list is ended by a '.' at the beginning of a line */3 	if ((message[0] == '.') && (message[1] == '\0')) {o 	    break;  	}   	if (*message == '\0') { 	    continue; 	}9 	/* server returns: group last first y/m/x/=otherGroup */n #if GROUP_NAME_SIZE <= 127E 	"GROUP_NAME_SIZE is too small" /* this will produce a compilation */p 	     			       /* error */t #endifL 	if (sscanf(message, "%127s %ld %ld %s", group, &last, &first, type) != 4) {M 	    mesgPane(XRN_SERIOUS, "Bogus active file entry, skipping\n%s", message);  	    error_count++;iF 	    if (error_count++ > 20) {	/* More than 20 bad entries in a row */ 		if (!error_retry) { D 		    mesgPane(XRN_SERIOUS, "Too many errors.. attempting restart"); 		    error_retry = True;f 		    start_server(NIL(char)); 		    getactive();		
 		    return;*
 		} else {B 		    ehErrorExitXRN("Repeated errors from getactive(); exiting"); 		}  	    } 	    continue; 	}   	error_count = 0;E 	if (type[0] == 'x') {2 	    /* bogus newsgroup, pay no attention to it */ 	    continue; 	}   	if (type[0] == '=') {; 	    /* This newsgroup doesn't exist, it's just an alias */E 	    continue; 	}   #ifndef NO_BOGUS_GROUP_HACKSC 	/* determine if the group name is screwed up - check for jerks who B 	 * create group names like: alt.music.enya.puke.puke.pukeSender: = 	 * - note that there is a ':' in the name of the group... */   ! 	if (strpbrk(group, ":! \n\t")) {w3 	    /* bogus newsgroup - can't have a separator */e 	    continue; 	}  #endif /* NO_BOGUS_GROUP_HACK */  6 	for (re_ptr = re_list; re_ptr && *re_ptr; re_ptr++) { #ifdef SYSV_REGEX  	    if (regex(*re_ptr, group))c #elsed0 	    if ((! re_comp(*re_ptr)) && re_exec(group)) #endif 	    { #ifdef DEBUG+ 		fprintf(stderr, "Ignoring %s.\n", group);s #endif 		break; 	    } 	} 	if (re_ptr && *re_ptr) {u 	    continue; 	}    	if (first == 0) {c 	    first = 1;  	}  0 	if (!avl_lookup(NewsGroupTable, group, &ptr)) {  ' 	    /* no entry, create a new group */S) 	    newsgroup = ALLOC(struct newsgroup);E3 	    newsgroup->name = (char *) XtNewString(group);S' 	    newsgroup->newsrc = NOT_IN_NEWSRC;f$ 	    newsgroup->status = NG_NOENTRY; 	    newsgroup->first = first; 	    newsgroup->last = last;  	    newsgroup->initial = first; 	    newsgroup->nglist = 0;;! 	    newsgroup->artStatus = NULL;f 	    f 	    switch (type[0]) {  		case 'y':n# 		newsgroup->status |= NG_POSTABLE;v 		break;   		case 'm':d$ 		newsgroup->status |= NG_MODERATED; 		break;   		case 'n':r% 		newsgroup->status |= NG_UNPOSTABLE;u 		break;   #ifndef INN  		case '=':_  		newsgroup->status |= NG_ALIAS; #endif
 		default:   		/*< 		fprintf(stderr, "unexpected type (%s) for newsgroup %s\n", 			type, newsgroup->name); 		*/ 		break;   	    } 	t4 	    if (avl_insert(NewsGroupTable, newsgroup->name,  			   (char *) newsgroup) < 0) {# 		 ehErrorExitXRN("out of memory");o 	    }   	    ActiveGroupsCount++;  	    t	 	} else {  	    f 	    /*W7 	     * entry exists, use it; must be a rescanning call0 	     * < 	     * just update the first and last values and adjust the 	     * articles array 	     */ 	     * 	    newsgroup = (struct newsgroup *) ptr;   	    /*r4 	     * only allow last to increase or stay the same8 	     * - don't allow bogus last values to trash a group 	     */? 	    if (IS_SUBSCRIBED(newsgroup) && last >= newsgroup->last) {0H 		/* XXX really should save up the resync and use the GROUP info also */0 		articleArrayResync(newsgroup, first, last, 1); 	    } 	}     }        error_retry = False;     return;a }   F #if !defined(FIXED_C_NEWS_ACTIVE_FILE) && !defined (FIXED_ACTIVE_FILE) /*C  * check the case where the first article number information is nots  * being updated.   *I  * also check the case where the first and last article numbers are equal 4  * - unfortunately, this means two different things:*  *   1) there are no articles in the group)  *   2) there is one article in the group5  *:  * - so, to get rid of the ambiguity, we make a GROUP call<  *   and look at the 'number' of articles field to determine&  *   whether there are 0 or 1 articles  */o void fixLowArticleNumbers() {      avl_generator *gen;      char *key, *value;     art_num first, last;     int number;"  (     /* check out first == last groups */4     gen = avl_init_gen(NewsGroupTable, AVL_FORWARD);     if (! gen) {" 	 ehErrorExitXRN("out of memory");     }e  (     while (avl_gen(gen, &key, &value)) {: 	struct newsgroup *newsgroup = (struct newsgroup *) value;    	if (IS_SUBSCRIBED(newsgroup)) {D 	    if (getgroup(newsgroup, &first, &last, &number) != 0) continue;  	    if (newsgroup->artStatus) {5 		articleArrayResync(newsgroup, first, last, number); 
 	    } else {h 		newsgroup->first = first;v 		newsgroup->last = last;O 	    }/ 	    if (newsgroup->initial < newsgroup->first)i( 		newsgroup->initial = newsgroup->first; 	}     }H     avl_free_gen(gen);       return;, }  #endif static int popupCount = 0;E extern Boolean CBretVal;		/* Confirmation box value;set from timer */a! static XtIntervalId tryTimer = 0;	   static void popDown()e {n     CBretVal = True;     tryTimer = 0;  }*$ static Boolean AnotherTry(errorType) int errorType; {e
     int i;     Boolean status;t  5     if (popupCount < app_resources.retryPopupCount) { 1 	for (i = 0; i < app_resources.retryPause; i++) { ! 	    xthHandleAllPendingEvents();" 	    sleep(1); 	} 	popupCount++;
 	return True;      }t     allowErrors = True; .     if (app_resources.retryPopupTimeout > 0) {@ 	tryTimer = XtAddTimeOut(app_resources.retryPopupTimeout * 1000,& 				(XtTimerCallbackProc) popDown, 0);     }!     if (errorType == 0) {R$ 	status = ConfirmationBox (TopLevel,A 	"Failed to reconnect to the NNTP server (server_init), retry?");e     } else {$ 	status = ConfirmationBox (TopLevel,@ 	"Invalid response from the NNTP server (server_init), retry?");     }      if (tryTimer != 0) { 	XtRemoveTimeOut(tryTimer);r 	tryTimer = 0;     }      popupCount = 0;d     allowErrors = False;     return status; }    /*+  * initiate a connection to the news servero  *J  * nntpserver is the name of an alternate server (use the default if NULL)  *J  * the server eventually used is remembered, so if this function is called:  * again (for restarting after a timeout), it will use it.  *  *   returns: void  *  */  void start_server(nntpserver) char *nntpserver;E {*;     static char *server = NIL(char);   /* for restarting */E     int response, retryLimit;t       if (server == NIL(char)) { 	g 	if (nntpserver != NIL(char)) {g 	    server = nntpserver;  	 	 	} else {r 	     H 	    /* Note: INN's getserverbyfile will ignore the filename argument */; 	    if ((server = getserverbyfile(SERVER_FILE)) == NULL) {=M 		mesgPane(XRN_SERIOUS, "Can't get the name of the news server from `%s'.%s",  			 SERVER_FILE, #ifndef VMSt@ 		"Either fix this file, or put NNTPSERVER in your environment." #else 6 		"Either fix this file, or define logical NNTPSERVER" #endif 		); 		ehErrorExitXRN("");  	    } 	}     }v       for (retryLimit = 0;H 	 retryLimit < app_resources.retryLimit * app_resources.retryPopupCount; 	 retryLimit++) {R, 	if ((response = server_init(server)) < 0) {5 	    if (XtIsRealized(TopLevel) && retryLimit == 0) {; 		xmSetIconAndName(LostIcon);S 		XFlush(XtDisplay(TopLevel)); 	    } 	    close_server(); 	    if (!AnotherTry(0)) { 		ehCleanExitXRN(1); 	    } 	    continue; 	}4 	if (handle_server_response(response, server) < 0) { 	    close_server(); 	    if (!AnotherTry(1)) { 		ehCleanExitXRN();m 	    } 	    continue;	 	} else {  	    ServerDown = False; 	    popupCount = 0; 	    return; 	}     },          ehCleanExitXRN();=     ServerDown = True;     popupCount = 0;e     return;) }    /*5  * close an outstanding connection to the NNTP serverc  */u void stop_server() {      currentNewsgroup = 0;n     close_server();  }    /*A  * get a list of subject lines for the current group in the rangeu  *  'first' to 'last'b  *  *   returns: void  *H  * Note that XHDR is not part of the rfc977 standard, but is implemented  * by the Berkeley NNTP server  *  */= void8 getsubjectlist(newsgroup, artfirst, artlast, unreadonly) struct newsgroup *newsgroup; art_num artfirst;+ art_num artlast; int unreadonly;  { 6     char command[MESSAGE_SIZE], message[MESSAGE_SIZE];     char *subjectline;     art_num number;/     art_num first, last;  "     if (SETNEWSGROUP(newsgroup)) { 	return;     }        first = artfirst;{     while (first <= artlast) {: 	if (currentArticles[INDEX(first)].subject != NIL(char) ||C 	    (unreadonly && IS_READ(newsgroup->artStatus[INDEX(first)]))) {  	     first++; 	     continue;t 	}2 	for (last = first + 1; last <= artlast; last++) {= 	    if (currentArticles[INDEX(last)].subject != NIL(char) ||m? 		(unreadonly && IS_READ(newsgroup->artStatus[INDEX(last)]))) {r 		break; 	    } 	} 	last--;  > 	(void) sprintf(command, "XHDR subject %ld-%ld", first, last);% 	if (put_server(command, True) == -1)  	    ServerDown = True;)0 	get_data_from_server(message, sizeof(message));  9 	check_time_out(command, message, sizeof(message), True);)   	/* check for errors */i 	if (*message != CHAR_OK) {  	    mesgPane(XRN_SERIOUS,D "XRN: serious error, your NNTP server does not have XHDR support.\n\; Either you are running a pre-1.5 NNTP server or XHDR has\n\	+ not been defined in 'nntp/common/conf.h'\n\t$ XRN requires XHDR support to run."); 	    return; 	}  
 	for(;;) {  4 	    get_data_from_server(message, sizeof(message));   	    if (ServerDown) {; 		check_time_out(command, message, sizeof(message), False);p 		continue;} 	    } 	l7 	    if ((message[0] == '.') && (message[1] == '\0')) {  		break; 	    }   	    /*  	     * message is of the form:	 	     *_ 	     *    Number SubjectLine  	     * # 	     *    203 Re: Gnumacs Bindingsa 	     *dC 	     * must get the number since not all subjects will be returnedp 	     */   	    number = atol(message);' 	    subjectline = index(message, ' ');   . 	    if (number == 0 || subjectline == NULL) { 		mesgPane(XRN_SERIOUS,	> 		    "Bogus subject returned from server (%s), continuing..", 		     message); 		continue;  	    }I 	    currentArticles[INDEX(number)].subject = string_pool(++subjectline);T 	} 	first = last + 1;     }l     return;i }*   /*@  * get a list of author lines for the current group in the range  *  'first' to 'last'   *  *   returns: void  *H  * Note that XHDR is not part of the rfc977 standard, but is implemented  * by the Berkeley NNTP server  *  */	 void7 getauthorlist(newsgroup, artfirst, artlast, unreadonly)= struct newsgroup *newsgroup; art_num artfirst;d art_num artlast; int unreadonly;; {*6     char command[MESSAGE_SIZE], message[MESSAGE_SIZE];-     char *author, *end, *brackbeg, *brackend;e     art_num number;g     art_num first, last;  "     if (SETNEWSGROUP(newsgroup)) { 	return;     }c     first = artfirst;w     while (first <= artlast) {9 	if (currentArticles[INDEX(first)].author != NIL(char) || C 	    (unreadonly && IS_READ(newsgroup->artStatus[INDEX(first)]))) {w
 	    first++;u 	    continue; 	}  2 	for (last = first + 1; last <= artlast; last++) {< 	    if (currentArticles[INDEX(last)].author != NIL(char) ||? 		(unreadonly && IS_READ(newsgroup->artStatus[INDEX(last)]))) {	 		break; 	    } 	} 	last--;  ; 	(void) sprintf(command, "XHDR from %ld-%ld", first, last);;% 	if (put_server(command, True) == -1)  	    ServerDown = True;u0 	get_data_from_server(message, sizeof(message));  9 	check_time_out(command, message, sizeof(message), True);    	/* check for errors */  	if (*message != CHAR_OK) {E 	    mesgPane(XRN_SERIOUS,D "XRN: serious error, your NNTP server does not have XHDR support.\n\; Either you are running a pre-1.5 NNTP server or XHDR has\n\d+ not been defined in 'nntp/common/conf.h'\n\e$ XRN requires XHDR support to run."); 	    return; 	}     
 	for(;;) {  4 	    get_data_from_server(message, sizeof(message)); 	    if (ServerDown) {; 		check_time_out(command, message, sizeof(message), False);  		continue;: 	    } 	(7 	    if ((message[0] == '.') && (message[1] == '\0')) {  		break; 	    }   	    /*b 	     * message is of the form:  	     *d 	     *    Number Author 	     *E4 	     *    201 ricks@shambhala (Rick L. Spickelmier)/ 	     *    202 Jens Thommasen <jens@ifi.uio.no>e 	     *    203 <oea@ifi.uio.no>o0 	     *    302 "Rein Tollevik" <rein@ifi.uio.no> 	     * B 	     * must get the number since not all authors will be returned 	     */   	    number = atol(message);( 	    if (app_resources.authorFullName) {< 		/* Can be made fancyer at the expence of extra cpu time */ 		author = index(message, ' ');a 		if (author == NIL(char)) {" 		    strcat(message, " (None) ");# 		    author = index(message, ' ');  		}  		assert(author != NIL(char)); 		author++;   < 		/* First check for case 1, user@domain ("name") -> name */  ! 		brackbeg = index(message, '('); 1 		brackend = index(message, '\0') - sizeof(char);t= 		/* brackend now points at the last ')' if this is case 1 */t7 		if (brackbeg != NIL(char) && (brackend > brackbeg) &&* 		    (*brackend == ')')) { ' 		    author = brackbeg + sizeof(char);E  ' 		    /* Remove surrounding quotes ? */ND 		    if ((*author == '"') && (*(brackend - sizeof(char)) == '"')) { 			author++; 			brackend--; 		    }r  - 		    /* Rather strip trailing spaces here */E   		    *brackend = '\0';(
 		} else {: 		    /* Check for case 2, "name" <user@domain> -> name */% 		    brackbeg = index(message, '<'); F 		    if (brackbeg != NIL(char) && (index(brackbeg, '>') != NIL(char)) 			&& (brackbeg > message)) {a 			while (*--brackbeg == ' ')  			    ;  $ 			/* Remove surrounding quotes ? */1 			if ((*brackbeg == '"') && (*author ==  '"')) {+ 			    *brackbeg = '\0'; 			    author++;  . 			    /* Rather strip trailing spaces here */   			} else {+ 			    *++brackbeg = '\0'; 			} 		    } else {   			/* 3 			 * Check for case 3, <user@domain> -> usr@domain  			 * " 			 * Don't need to do this again:% 			 * brackbeg = index(message, '<');u 			 */  " 			brackend = index(message, '>');9 			if ((author == brackbeg) && (brackend != NIL(char))) {a 			    author++; 			    *brackend = '\0'; 			} else {i5 			    if ((end = index(author, ' ')) != NIL(char)) {h 				*end = '\0'; 			    } 			} 		    }  		} 
 	    } else {r4 		if ((author = index(message, '<')) == NIL(char)) { 		    /* first form */# 		    author = index(message, ' ');   		    if (author == NIL(char)) { 			strcat(message, " (None) ");   			author = index(message, ' '); 		    }s" 		    assert(author != NIL(char)); 		    author++;O4 		    if ((end = index(author, ' ')) != NIL(char)) { 			*end = '\0';r 		    }y
 		} else { 		    /* second form */u 		    author++; 4 		    if ((end = index(author, '>')) != NIL(char)) { 			*end = '\0';o 		    }i 		}, 	    } 	    /* @ 	     * do a final trimming - just in case the authors name ends* 	     * in spaces or tabs - it does happen 	     */' 	    end = author + strlen(author) - 1;dB 	    while ((end > author) && ((*end == ' ') || (*end == '\t'))) { 		*end = '\0'; 		end--; 	    }A 	    currentArticles[INDEX(number)].author = string_pool(author);s 	} 	first = last + 1;     }      return;h }e   /*I  * get a list of number of lines per message for the current group in thee  *  range 'first' to 'last'v  *  *   returns: void  *H  * Note that XHDR is not part of the rfc977 standard, but is implemented  * by the Berkeley NNTP server  *  */r void6 getlineslist(newsgroup, artfirst, artlast, unreadonly) struct newsgroup *newsgroup; art_num artfirst;m art_num artlast; int unreadonly;r { 6     char command[MESSAGE_SIZE], message[MESSAGE_SIZE];     char *numoflines, *end;      art_num number;g     int lcv;     art_num first, last;  O"     if (SETNEWSGROUP(newsgroup)) { 	return;     }(  *     if (!app_resources.displayLineCount) { 	return;     }(       first = artfirst;i     while (first <= artlast) {8 	if (currentArticles[INDEX(first)].lines != NIL(char) ||C 	    (unreadonly && IS_READ(newsgroup->artStatus[INDEX(first)]))) { 
 	    first++;) 	    continue; 	}  2 	for (last = first + 1; last <= artlast; last++) {; 	    if (currentArticles[INDEX(last)].lines != NIL(char) ||f? 		(unreadonly && IS_READ(newsgroup->artStatus[INDEX(last)]))) {  		break; 	    } 	} 	last--;  < 	(void) sprintf(command, "XHDR lines %ld-%ld", first, last);% 	if (put_server(command, True) == -1)_ 	    ServerDown = True;_0 	get_data_from_server(message, sizeof(message));  9 	check_time_out(command, message, sizeof(message), True);n   	/* check for errors */s 	if (*message != CHAR_OK) {) 	    mesgPane(XRN_SERIOUS,D "XRN: serious error, your NNTP server does not have XHDR support.\n\; Either you are running a pre-1.5 NNTP server or XHDR has\n\b+ not been defined in 'nntp/common/conf.h'\n\ $ XRN requires XHDR support to run."); 	    return; 	}  
 	for(;;) {  4 	    get_data_from_server(message, sizeof(message)); 	    if (ServerDown) {; 		check_time_out(command, message, sizeof(message), False);d 		continue;g 	    }  7 	    if ((message[0] == '.') && (message[1] == '\0')) {c 		break; 	    }   	    /*x 	     * message is of the form:y 	     *t 	     *    Number NumberOfLines  	     *p 	     *    203 ##  	     *nC 	     * must get the number since not all subjects will be returned  	     */   	    number = atol(message);& 	    numoflines = index(message, ' ');% 	    assert(numoflines != NIL(char));s 	    numoflines++;7 	    if ((end = index(numoflines, ' ')) != NIL(char)) {i 		*end = '\0'; 	    }  	    if (numoflines[0] != '(') {, 		numoflines[utStrlen(numoflines)+1] = '\0';) 		numoflines[utStrlen(numoflines)] = ']';d5 		for (lcv = utStrlen(numoflines); lcv >= 0; lcv--) { * 		    numoflines[lcv+1] = numoflines[lcv]; 		}  		numoflines[0] = '[';
 	    } else {s 		numoflines[0] = '[';+ 		numoflines[utStrlen(numoflines)-1] = ']';  	    }- 	    if (strcmp(numoflines, "[none]") == 0) {)# 		(void) strcpy(numoflines, "[?]");  	    }D 	    currentArticles[INDEX(number)].lines = string_pool(numoflines); 	} 	first = last + 1;     }N     return;, }o   /*?  * get a list of message IDs for the current group in the rangep  *  'first' to 'last'u  *  *   returns: void  *H  * Note that XHDR is not part of the rfc977 standard, but is implemented  * by the Berkeley NNTP server  *  */  void6 getmsgidlist(newsgroup, artfirst, artlast, unreadonly) struct newsgroup *newsgroup; art_num artfirst;i art_num artlast; int unreadonly;  {U6     char command[MESSAGE_SIZE], message[MESSAGE_SIZE];     char *messageid;     art_num number;;     art_num first, last;  "     if (SETNEWSGROUP(newsgroup)) { 	return;     }        first = artfirst;_     while (first <= artlast) {8 	if (currentArticles[INDEX(first)].msgid != NIL(char) ||C 	    (unreadonly && IS_READ(newsgroup->artStatus[INDEX(first)]))) {  	     first++; 	     continue;o 	}2 	for (last = first + 1; last <= artlast; last++) {; 	    if (currentArticles[INDEX(last)].msgid != NIL(char) ||o? 		(unreadonly && IS_READ(newsgroup->artStatus[INDEX(last)]))) {A 		break; 	    } 	} 	last--;  A 	(void) sprintf(command, "XHDR Message-ID %ld-%ld", first, last);e% 	if (put_server(command, True) == -1)u 	    ServerDown = True;v0 	get_data_from_server(message, sizeof(message));  9 	check_time_out(command, message, sizeof(message), True);    	/* check for errors */l 	if (*message != CHAR_OK) {a 	    mesgPane(XRN_SERIOUS,D "XRN: serious error, your NNTP server does not have XHDR support.\n\; Either you are running a pre-1.5 NNTP server or XHDR has\n\d+ not been defined in 'nntp/common/conf.h'\n\s$ XRN requires XHDR support to run."); 	    return; 	}  
 	for(;;) {  4 	    get_data_from_server(message, sizeof(message));   	    if (ServerDown) {; 		check_time_out(command, message, sizeof(message), False);c 		continue;  	    } 	l7 	    if ((message[0] == '.') && (message[1] == '\0')) {a 		break; 	    }   	    /*f 	     * message is of the form:  	     ** 	     *    Number MessageIDt 	     *e" 	     *    203 <12345@foo.bar.baz> 	     *t 	     */   	    number = atol(message);% 	    messageid = index(message, ' ');t  , 	    if (number == 0 || messageid == NULL) { 		mesgPane(XRN_SERIOUS,cA 		    "Bogus message ID returned from server (%s), continuing..",o 		     message); 		continue;  	    }E 	    currentArticles[INDEX(number)].msgid = string_pool(++messageid);  	} 	first = last + 1;     }k     return;  }t   /*8  * split - divide a string into fields, like awk split()0  * Copied from Geoffrey Collyer's `nov' package.  */ 7 static int			/* number of fields, including overflow */c# split(string, fields, nfields, sep)g
 char *string; 3 char *fields[];			/* list is not NULL-terminated */(< int nfields;			/* number of entries available in fields[] */8 char *sep;			/* "" white, "c" single char, "ab" [ab]+ */ {, 	register char *p = string; * 	register char c;			/* latest character */ 	register char sepc = sep[0];i 	register char sepc2;  	register int fn;  	register char **fp = fields;p 	register char *sepp;  	register int trimtrail;   	/* white space */ 	if (sepc == '\0') {( 		while ((c = *p++) == ' ' || c == '\t') 			continue; 		p--; 		trimtrail = 1;: 		sep = " \t";	/* note, code below knows this is 2 long */
 		sepc = ' ';l 	} else  		trimtrail = 0;6 	sepc2 = sep[1];		/* now we can safely pick this up */   	/* catch empties */ 	if (*p == '\0') 		return(0);   	/* single separator */y 	if (sepc2 == '\0') {  		fn = nfields;u 		for (;;) {
 			*fp++ = p;  			fn--; 			if (fn == 0))
 				break; 			while ((c = *p++) != sepc)t 				if (c == '\0') 					return(nfields - fn); 			*(p-1) = '\0';. 		}P? 		/* we have overflowed the fields vector -- just count them */o 		fn = nfields;, 		for (;;) { 			while ((c = *p++) != sepc)  				if (c == '\0') 					return(fn); 			fn++; 		}n 		/* not reached */l 	}   	/* two separators */e 	if (sep[2] == '\0') { 		fn = nfields;e 		for (;;) {
 			*fp++ = p;  			fn--;+ 			while ((c = *p++) != sepc && c != sepc2)r 				if (c == '\0') {' 					if (trimtrail && **(fp-1) == '\0')v 						fn++;i 					return(nfields - fn); 				}  			if (fn == 0) 
 				break; 			*(p-1) = '\0';e+ 			while ((c = *p++) == sepc || c == sepc2)i
 				continue;s 			p--;* 		}n? 		/* we have overflowed the fields vector -- just count them */N 		fn = nfields;s 		while (c != '\0') {s+ 			while ((c = *p++) == sepc || c == sepc2)*
 				continue;t 			p--;t 			fn++;8 			while ((c = *p++) != '\0' && c != sepc && c != sepc2)
 				continue;r 		}s/ 		/* might have to trim trailing white space */s 		if (trimtrail) { 			p--;e+ 			while ((c = *--p) == sepc || c == sepc2) 
 				continue;r 			p++;h 			if (*p != '\0') { 				if (fn == nfields+1) 					*p = '\0';e	 				fn--;  			} 		} 
 		return(fn);  	}   	/* n separators */  	fn = 0; 	for (;;) {e 		if (fn < nfields) 
 			*fp++ = p;e 		fn++;e 		for (;;) { 			c = *p++; 			if (c == '\0')O 				return(fn);e 			sepp = sep;0 			while ((sepc = *sepp++) != '\0' && sepc != c)
 				continue;e- 			if (sepc != '\0')	/* it was a separator */r
 				break; 		}  		if (fn < nfields)l 			*(p-1) = '\0';l 		for (;;) { 			c = *p++; 			sepp = sep;0 			while ((sepc = *sepp++) != '\0' && sepc != c)
 				continue;m0 			if (sepc == '\0')	/* it wasn't a separator */
 				break; 		}e 		p--; 	}   	/* not reached */ }e   /*C  * get a list of reference lines for the current group in the range   *  'first' to 'last'L  *  *   returns: void  *H  * Note that XHDR is not part of the rfc977 standard, but is implemented  * by the Berkeley NNTP server  *  */u void5 getrefslist(newsgroup, artfirst, artlast, unreadonly)  struct newsgroup *newsgroup; art_num artfirst;  art_num artlast; int unreadonly;c {i6     char command[MESSAGE_SIZE], message[MESSAGE_SIZE];     char *refstr;r     char *refs[DEFREFS];     int nrefs;
     int i, j;o     art_num number;C     art_num first, last;  "     if (SETNEWSGROUP(newsgroup)) { 	return;     }P       first = artfirst;_     while (first <= artlast) {: 	if (currentArticles[INDEX(first)].refs[0] != NIL(char) ||C 	    (unreadonly && IS_READ(newsgroup->artStatus[INDEX(first)]))) {t 	     first++; 	     continue;* 	}2 	for (last = first + 1; last <= artlast; last++) {= 	    if (currentArticles[INDEX(last)].refs[0] != NIL(char) || ? 		(unreadonly && IS_READ(newsgroup->artStatus[INDEX(last)]))) {n 		break; 	    } 	} 	last--;  A 	(void) sprintf(command, "XHDR references %ld-%ld", first, last);S% 	if (put_server(command, True) == -1)  	    ServerDown = True;r0 	get_data_from_server(message, sizeof(message));  9 	check_time_out(command, message, sizeof(message), True);    	/* check for errors */t 	if (*message != CHAR_OK) {r 	    mesgPane(XRN_SERIOUS,D "XRN: serious error, your NNTP server does not have XHDR support.\n\; Either you are running a pre-1.5 NNTP server or XHDR has\n\(+ not been defined in 'nntp/common/conf.h'\n\ $ XRN requires XHDR support to run."); 	    return; 	}  
 	for(;;) {  4 	    get_data_from_server(message, sizeof(message));   	    if (ServerDown) {; 		check_time_out(command, message, sizeof(message), False);f 		continue;  	    } 	r7 	    if ((message[0] == '.') && (message[1] == '\0')) {t 		break; 	    }   	    /*z 	     * message is of the form:( 	     *m 	     *    Number refs 	     * " 	     *    203 <12345@foo.bar.baz> 	     *C 	     */   	    number = atol(message);" 	    refstr = index(message, ' ');  ) 	    if (number == 0 || refstr == NULL) {e 		mesgPane(XRN_SERIOUS,eA 		    "Bogus message ID returned from server (%s), continuing..",  		     message); 		continue;n 	    }  > 	    currentArticles[INDEX(number)].refs[0] = string_pool("");> 	    currentArticles[INDEX(number)].refs[1] = string_pool("");> 	    currentArticles[INDEX(number)].refs[2] = string_pool("");2 	    nrefs = split(++refstr, refs, DEFREFS, " ,");= 	    for (i = 0, j = nrefs - 1; i <= 2 && j >= 0; j--, i++) { @ 		currentArticles[INDEX(number)].refs[i] = string_pool(refs[j]); 	    } 	} 	first = last + 1;     }      return;  }t     /*0  * get the overview data for a list of articles.  *  *   returns: status  *K  * This function requires a NNTP server that supports XOVER and an overview|
  * database. =  *  */  Booleane5 getoverview(newsgroup, artfirst, artlast, unreadonly)e struct newsgroup *newsgroup; art_num artfirst;n art_num artlast; int unreadonly;I {X6     char command[MESSAGE_SIZE], message[MESSAGE_SIZE];     char *subjectline;,     char *fields[MAXFIELDS], *refs[DEFREFS];"     char authorline[MESSAGE_SIZE];-     char *author, *end, *brackbeg, *brackend;r     char *numoflines;h     int nf, nrefs, len;e
     int i, j;d     int lcv;     art_num number;k     art_num first, last;  "     if (SETNEWSGROUP(newsgroup)) { 	return False;     }y       first = artfirst;s     while (first <= artlast) {: 	if (currentArticles[INDEX(first)].subject != NIL(char) ||C 	    (unreadonly && IS_READ(newsgroup->artStatus[INDEX(first)]))) {r 	     first++; 	     continue;  	}2 	for (last = first + 1; last <= artlast; last++) {= 	    if (currentArticles[INDEX(last)].subject != NIL(char) ||t? 		(unreadonly && IS_READ(newsgroup->artStatus[INDEX(last)]))) {c 		break; 	    } 	} 	last--;  7 	(void) sprintf(command, "XOVER %ld-%ld", first, last);+% 	if (put_server(command, True) == -1)f 	    ServerDown = True;;0 	get_data_from_server(message, sizeof(message));  9 	check_time_out(command, message, sizeof(message), True);r   	/* check for errors */  	if (*message != CHAR_OK) {; 	    return False; 	}  
 	for(;;) {4 	    get_data_from_server(message, sizeof(message));   	    if (ServerDown) {; 		check_time_out(command, message, sizeof(message), False);; 		continue;m 	    } 	n7 	    if ((message[0] == '.') && (message[1] == '\0')) {o 		break; 	    }   	    /*_ 	     * message is of the form:, 	     *eG 	     *    Number Subj(tab)Author(tab)date(tab)refs(tab)bytes(tab)linesa 	     *gC 	     * must get the number since not all subjects will be returnedm 	     */   	    len = strlen(message); + 	    if (len > 0 && message[len-1] == '\n'){? 		message[len-1] = '\0';	/* make field count straightforward */ 2 	    nf = split(message, fields, MAXFIELDS, "\t");D 	    if (nf < MAXFIELDS - 1)	/* only "others" fields are optional */! 		continue;		/* skip this line */  	    while (nf < MAXFIELDS)/. 		fields[nf++] = "";	/* fake missing fields */   	    number = atol(fields[0]); 	    subjectline = fields[1];a  / 	    if (number == 0 || *subjectline == '\0') {e 		mesgPane(XRN_SERIOUS, B 		    "Bogus overview data returned from server (%s), continuing", 		     message); 		continue;u 	    }  G 	    currentArticles[INDEX(number)].subject = string_pool(subjectline);   # 	    strcpy(authorline, fields[2]);a 	    author = authorline;b( 	    if (app_resources.authorFullName) {< 		/* Can be made fancyer at the expence of extra cpu time */ 		if (author[0] == '\0') {# 		    strcpy(authorline, "(None)");d 		}s  < 		/* First check for case 1, user@domain ("name") -> name */  $ 		brackbeg = index(authorline, '(');4 		brackend = index(authorline, '\0') - sizeof(char);= 		/* brackend now points at the last ')' if this is case 1 */	7 		if (brackbeg != NIL(char) && (brackend > brackbeg) &&* 		    (*brackend == ')')) {r' 		    author = brackbeg + sizeof(char);r  ' 		    /* Remove surrounding quotes ? */ D 		    if ((*author == '"') && (*(brackend - sizeof(char)) == '"')) { 			author++; 			brackend--; 		    }e  - 		    /* Rather strip trailing spaces here */;   		    *brackend = '\0';e
 		} else {: 		    /* Check for case 2, "name" <user@domain> -> name */( 		    brackbeg = index(authorline, '<');F 		    if (brackbeg != NIL(char) && (index(brackbeg, '>') != NIL(char))  			&& (brackbeg > authorline)) { 			while (*--brackbeg == ' ')  			    ;  $ 			/* Remove surrounding quotes ? */1 			if ((*brackbeg == '"') && (*author ==  '"')) {  			    *brackbeg = '\0'; 			    author++;  . 			    /* Rather strip trailing spaces here */   			} else {  			    *++brackbeg = '\0'; 			} 		    } else {   			/* 3 			 * Check for case 3, <user@domain> -> usr@domain/ 			 * " 			 * Don't need to do this again:( 			 * brackbeg = index(authorline, '<'); 			 */  % 			brackend = index(authorline, '>');<9 			if ((author == brackbeg) && (brackend != NIL(char))) {( 			    author++; 			    *brackend = '\0'; 			} else { 5 			    if ((end = index(author, ' ')) != NIL(char)) {  				*end = '\0'; 			    } 			} 		    }a 		}h
 	    } else {07 		if ((author = index(authorline, '<')) == NIL(char)) {( 		    /* first form */ 		    author = authorline; 		    if (*author == '\0') {  			strcpy(authorline, "(None)"); 			author = authorline;{ 		    }a4 		    if ((end = index(author, ' ')) != NIL(char)) { 			*end = '\0';	 		    }t
 		} else { 		    /* second form */+4 		    if ((end = index(author, '>')) != NIL(char)) { 			*end = '\0';' 		    }  		}	 	    } 	    /**@ 	     * do a final trimming - just in case the authors name ends* 	     * in spaces or tabs - it does happen 	     */' 	    end = author + strlen(author) - 1;tB 	    while ((end > author) && ((*end == ' ') || (*end == '\t'))) { 		*end = '\0'; 		end--; 	    }A 	    currentArticles[INDEX(number)].author = string_pool(author);&   	    numoflines = fields[7];8 	    if ((end = index(numoflines, '\t')) != NIL(char) ||1 		(end = index(numoflines,  ' ')) != NIL(char)) {  		*end = '\0'; 	    }  	    if (numoflines[0] != '(') {, 		numoflines[utStrlen(numoflines)+1] = '\0';) 		numoflines[utStrlen(numoflines)] = ']';t5 		for (lcv = utStrlen(numoflines); lcv >= 0; lcv--) {X* 		    numoflines[lcv+1] = numoflines[lcv]; 		}p 		numoflines[0] = '[';
 	    } else {r 		numoflines[0] = '[';+ 		numoflines[utStrlen(numoflines)-1] = ']';l 	    }- 	    if (strcmp(numoflines, "[none]") == 0) {r# 		(void) strcpy(numoflines, "[?]");  	    }D 	    currentArticles[INDEX(number)].lines = string_pool(numoflines);C 	    currentArticles[INDEX(number)].msgid = string_pool(fields[4]); . 	    currentArticles[INDEX(number)].refs[0] = . 	    currentArticles[INDEX(number)].refs[1] = > 	    currentArticles[INDEX(number)].refs[2] = string_pool("");3 	    nrefs = split(fields[5], refs, DEFREFS, " ,");]= 	    for (i = 0, j = nrefs - 1; i <= 2 && j >= 0; j--, i++) {a@ 		currentArticles[INDEX(number)].refs[i] = string_pool(refs[j]); 	    } 	} 	first = last + 1;     }s     return;  }   
 #ifndef INEWSl static void)
 sendLine(str)c
 char *str; {r     if (*str == '.') {G 	char *str2 = XtMalloc(utStrlen(str) + 2); /* one for the extra period,o" 						   * and one for the null at 						   * the end */i 	str2[0] = '.';m 	strcpy(str2 + 1, str);S" 	if (put_server(str, False) == -1) 	    ServerDown = True;s 	XtFree(str2);     } else {" 	if (put_server(str, False) == -1) 	    ServerDown = True;s     }i     return;= }A #endif  
 static char *R getLine(ptr) char **ptr;r {,     static char line[512];"     char *end = index(*ptr, '\n');       if (end) {( 	(void) strncpy(line, *ptr, end - *ptr); 	line[end - *ptr] = '\0';' 	*ptr = end + 1;     } else { 	(void) strcpy(line, *ptr); 
 	*ptr = 0;     }      return line; }(     /*@  * Takes a block of text, wraps the text based on lineLength andA  * breakLength resources, and returns a NULL-terminated allocated B  * array of allocated strings representing the wrapped lines.  TheF  * procedure which calls wrapText should use the wrapped Text and then'  * free each string and free the array.   */# char **  wrapText(ptr, lineCount)
 char *ptr; int *lineCount;w { +     long c = 0;			/* current line length */m     char **lines, *this_line;e     long num_lines = 0;s-     long breakAt = app_resources.breakLength;+  -     lines = (char **) XtMalloc((Cardinal) 0);L  @     if (app_resources.breakLength && app_resources.lineLength) { 	/*u 	 * Do text wrapping.l 	 */B 	this_line = XtMalloc((Cardinal) (app_resources.breakLength + 1));   	while (*ptr != '\0') {> 	    if (c >= breakAt) { 		/*3 		 * Everything after the first line in a paragraph[6 		 * should be wrapped at lineLength, not breakLength.4 		 * This prevents the last line of a paragraph from5 		 * ending up a little bit longer than all the othero9 		 * lines (and extending into the margin), but not quite)' 		 * breakLength characters lines long.f 		 */l% 		breakAt = app_resources.lineLength;*+ 		/* backoff to app_resources.lineLength */t 		ptr -= c - breakAt;* 		c = app_resources.lineLength;t7 		for (; c > 0 && *ptr != ' ' && *ptr != '\t'; ptr--) {7 		     c--;u 		}i   		if (c == 0) {h9 		    /* pathological, cut to app_resources.lineLength */o# 		    c = app_resources.lineLength;t* 		    ptr += app_resources.lineLength - 1; 		}r   		/* output */ 		this_line[c] = '\0';8 		lines = (char **) XtRealloc((char *) lines, (Cardinal)) 				     (sizeof(char *) * ++num_lines));r! 		lines[num_lines-1] = this_line;W! 		this_line = XtMalloc((Cardinal) + 				      (app_resources.breakLength + 1));t 		c = 0;! 		if (strncmp(lines[num_lines-1],r# 			    app_resources.includePrefix,e5 			    utStrlen(app_resources.includePrefix)) == 0) { 5 		    strcpy(this_line, app_resources.includePrefix);f1 		    c += utStrlen(app_resources.includePrefix);e 		}i   		/*: 		 * Delete any extra spaces, tabs or carriage returns at 7 		 * the beginning of the next line.  This is necessary 3 		 * because we may break a line in the middle of ae9 		 * multi-space word break (e.g. the end of a sentence),)2 		 * or right before the paragraph-ending carriage7 		 * return, which we've already printed as part of then 		 * line above. 		 */e= 		while ((*ptr == ' ') || (*ptr == '\t') || (*ptr == '\n')) {K 		    ptr++; 		    if (*(ptr-1) == '\n')i6 			/* We only one to get rid of one carriage return */	 			break;y 		}e 	        		continue;  	    }   	    if (*ptr == '\n') { 		this_line[c] = '\0';8 		lines = (char **) XtRealloc((char *) lines, (Cardinal)) 					    (sizeof(char *) * ++num_lines));s! 		lines[num_lines-1] = this_line; ! 		this_line = XtMalloc((Cardinal)e+ 				      (app_resources.breakLength + 1));)
 		if (c == 0) + 		     breakAt = app_resources.breakLength;  		c = 0, ptr++;0 		continue;a 	    }  
 #ifdef notdef  	    if (*ptr == '\t') {
 		c += c % 8;  		continue;m 	    } #endif 	    	    this_line[c++] = *ptr++;a 	}   	if (c != 0) { 	    this_line[c] = '\0';m; 	    lines = (char **) XtRealloc((char *) lines, (Cardinal)n& 					 (sizeof(char *) * ++num_lines));$ 	    lines[num_lines-1] = this_line; 	}     } else { 	/*e= 	 * Don't do text wrapping, just break the text at linefeeds.  	 */ 	while (*ptr) {s 	    c = 0;)1 	    for (; *ptr && (*ptr != '\n'); ptr++, c++) ;l 	    if (c || *ptr) {e+ 		this_line = XtMalloc((Cardinal) (c + 1));i- 		lines = (char **) XtRealloc((char *) lines,o& 					     (Cardinal) (sizeof(char *) * 							 ++num_lines));( 		strncpy(this_line, (char *) ptr-c, c); 		this_line[c] = '\0';! 		lines[num_lines-1] = this_line;	 		if (*ptr)n 		    ptr++; 	    } 	}     }d       /     lines = (char **) XtRealloc((char *) lines,*0 				 (Cardinal) (sizeof(char *) * ++num_lines));     lines[num_lines-1] = NULL;       *lineCount = num_lines;s     return(lines); }e   #ifdef MOTIF char* wrapString(ptr)s
 char *ptr; /*0  * Wrap a string and return the wrapped version.6  * only used on Motif to eliminate need for horizontal7  * scroll bar (enabling wrap in the widget is too slow)'  */  {'2     unsigned int c = 0;		/* current line length */     char *this_line;     char *wrappedText, *w;     int breakLength;*     int i, sizeNeeded, thisSize, sizeLeft;       sizeNeeded = 0;c  ,     breakLength = xthTextWidth(ArticleText);  $     sizeNeeded = strlen(ptr) + 1000;+     wrappedText = w = XtMalloc(sizeNeeded);l     sizeLeft = sizeNeeded;     *w = '\0';7     this_line = XtMalloc((Cardinal) (breakLength + 1));e       /*      * Do text wrapping.      */        while (*ptr != '\0') { 	if (c >= breakLength) {: 	    for (; c > 0 && *ptr != ' ' && *ptr != '\t'; ptr--) { 		c--; 	    }   	    if (c == 0) {( 		/* pathological, cut to breakLength */ 		c = breakLength; 		ptr += breakLength - 1;  	    }   	    /* output */  	    this_line[c] = '\0';n" 	    thisSize = strlen(this_line); 	    if (w != wrappedText) { 		*w++ = '\n';
 		sizeLeft--;	 	    }& 	    if (sizeLeft < breakLength * 2) { 		sizeNeeded += 1000;+ 		sizeLeft += 1000;d3 		wrappedText = XtRealloc(wrappedText, sizeNeeded);p( 		w = wrappedText + strlen(wrappedText); 	    } 	    strcpy(w, this_line); 	    w += thisSize;  	    sizeLeft -= thisSize; 	    this_line[0] = '\0';N 	    c = 0;l   	    /*l= 	     * Delete any extra spaces, tabs or carriage returns at  : 	     * the beginning of the next line.  This is necessary6 	     * because we may break a line in the middle of a< 	     * multi-space word break (e.g. the end of a sentence),5 	     * or right before the paragraph-ending carriages: 	     * return, which we've already printed as part of the 	     * line above.  	     */@ 	    while ((*ptr == ' ') || (*ptr == '\t') || (*ptr == '\n')) { 		ptr++; 		if (*(ptr-1) == '\n')	9 		    /* We only one to get rid of one carriage return */  		    break; 	    } 	        	    continue; 	}   	if (*ptr == '\n') { 	    this_line[c] = '\0';&" 	    thisSize = strlen(this_line); 	    if (w != wrappedText) { 		*w++ = '\n';
 		sizeLeft--;	 	    }& 	    if (sizeLeft < breakLength * 2) { 		sizeNeeded += 1000;s 		sizeLeft += 1000;(3 		wrappedText = XtRealloc(wrappedText, sizeNeeded);m( 		w = wrappedText + strlen(wrappedText); 	    } 	    strcpy(w, this_line); 	    w += thisSize;  	    sizeLeft -= thisSize; 	    this_line[0] = '\0';c   	    c = 0, ptr++; 	    continue; 	}   	this_line[c++] = *ptr++;o     }        if (c != 0) {n 	this_line[c] = '\0';t 	thisSize = strlen(this_line); 	if (w != wrappedText) { 	    *w++ = '\n';e 	    sizeLeft--; 	}" 	if (sizeLeft < breakLength * 2) { 	    sizeNeeded += 1000; 	    sizeLeft += 1000;6 	    wrappedText = XtRealloc(wrappedText, sizeNeeded);+ 	    w = wrappedText + strlen(wrappedText);* 	} 	strcpy(w, this_line); 	w += thisSize;r 	sizeLeft -= thisSize; 	this_line[0] = '\0';      }      *w++ = '\n';     *w++ = '\0';     FREE(this_line);     return(wrappedText); }f #endif /* MOTIF */ #ifndef VMSs   inti mailArticle(article) char *article; {! #ifdef sequentO      extern FILE *popen _ARGUMENTS((const char *, const char *)); /* sequent */+ #endif        FILE *fp;      char **lines_ptr, **lines;r      char *ptr;       int lineCount;l      XB      if ((fp = (FILE *) popen(app_resources.mailer, "w")) == NULL) 	  return POST_FAILED;  H      /* First, send everything up to the first blank line without any */       /* wrapping. 						      */      while (1) { 	  ptr = index(article, '\n');) 	  if ((ptr == article) || (ptr == NULL))g< 	       /* line has nothing but newline or end of article */ 	       break;L 	  (void) fwrite(article, sizeof(char), (unsigned) (ptr - article + 1), fp); 	  article = ptr + 1;i      }       7      lines_ptr = lines = wrapText(article, &lineCount);e      while (*lines) { = 	  (void) fwrite(*lines, sizeof(char), utStrlen(*lines), fp);'L 	  (void) fwrite("\n", sizeof(char), 1, fp); /* wrapText deletes newlines */ 	  FREE(*lines); 	  lines++;g      }      FREE(lines_ptr);   1      return pclose(fp) ? POST_FAILED : POST_OKAY;z }( #endif     intf postArticle(article, mode) char *article;& int mode;   /* XRN_NEWS or XRN_MAIL */ /*  * post an article  *)  *   returns 1 for success, 0 for failure   */  { 6     char command[MESSAGE_SIZE], message[MESSAGE_SIZE];     char *ptr, *saveptr;     char **lines, **lines_ptr;     int lineCount;   #ifdef INEWS     char *tempfile;=     int exitstatus;      char buffer[1024];     FILE *inews;     extern char * utTempnam(); #endif          if (mode == XRN_MAIL) {	 	return mailArticle(article);e     }l   #ifdef INEWSC     tempfile = XtNewString(utTempnam(app_resources.tmpDir, "xrn"));s>     (void) sprintf(buffer, "%s -h > %s 2>&1",INEWS, tempfile);8     if ((inews = (FILE *) popen(buffer, "w")) == NULL) {9         mesgPane(XRN_SERIOUS, "Failed to start inews\n");  	(void) unlink(tempfile);r 	FREE(tempfile);         return(POST_FAILED);     }] #else   #     (void) strcpy(command, "POST"); (     if (put_server(command, True) == -1) 	ServerDown = True;t3     get_data_from_server(message, sizeof(message));n  <     check_time_out(command, message, sizeof(message), True);        if (*message != CHAR_CONT) {: 	mesgPane(XRN_SERIOUS, "NNTP Serious Error: %s", message);# 	if (atoi(message) == ERR_NOPOST) {r 	    return(POST_NOTALLOWED);e	 	} else {X 	    return(POST_FAILED);S 	}     }g #endif       ptr = article;       while (1) {r 	char *line;   	saveptr = ptr;S   	line = getLine(&ptr);= 	if (index(line, ':') || (*line == ' ') || (*line == '\t')) {  #ifdef INEWS 	    fputs(line, inews); 	    fputc('\n', inews); #elsec 	    sendLine(line); #endif 	    continue; 	} 	break;f     }W       if (*saveptr != '\n') {a; 	 /* if the skipped line was not blank, point back to it */r 	 ptr = saveptr;     }i  2     lines_ptr = lines = wrapText(ptr, &lineCount); #ifdef INEWS-     sprintf(command,"Lines: %d\n",lineCount);      fputs(command, inews);     fputs("\n\n", inews);+ #elset-     sprintf(command,"Lines: %d\n",lineCount);s     sendLine(command);*     sendLine("");		/* send a blank line */ #endif       while (*lines) { #ifdef INEWS          fputs(*lines, inews); 	 fputc('\n', inews);E #elsel 	 sendLine(*lines);i #endif 	 XtFree(*lines);)
 	 lines++;     }e     FREE(lines_ptr);      #ifdef INEWS%     if (exitstatus = pclose(inews)) {u 	FILE *filefp;	 	char *p;m 	struct stat buf;  	char temp[1024];s@ 	(void) sprintf(temp, "\n\ninews exit value: %d\n", exitstatus);/ 	if ((filefp = fopen(tempfile, "r")) != NULL) {(- 	    if (fstat(fileno(filefp), &buf) != -1) {i2 		p = XtMalloc(buf.st_size + utStrlen(temp) + 10);5 		(void) fread(p, sizeof(char), buf.st_size, filefp);& 		p[buf.st_size] = '\0'; 		(void) strcat(p, temp);/ 		(void) fclose(filefp);6 		mesgPane(XRN_SERIOUS, "INEWS Serious Error: %s", p); 	    } 	} 	(void) unlink(tempfile);  	FREE(tempfile); 	return(POST_FAILED);c     }l #elsec$     if (put_server(".", True) == -1) 	ServerDown = True;)   #ifdef SERIALHACK&3     get_data_from_server(message, sizeof(message));/ #endif  3     get_data_from_server(message, sizeof(message));,     if (ServerDown) {"6 	mesgPane(XRN_SERIOUS, "NNTP Server connection lost");6 	check_time_out(".", message, sizeof(message), False); 	return(POST_FAILED);S     }	     if (*message != CHAR_OK) {: 	mesgPane(XRN_SERIOUS, "NNTP Serious Error: %s", message); 	return(POST_FAILED);      }m #endif       return(POST_OKAY); }     & #ifdef DONT_USE_XHDR_FOR_A_SINGLE_ITEM   void xhdr(article, field, string) art_num article; char *field; char **string; /*)  * get header information about 'article'c  *'  *   the results are stored in 'string'(  */r {eL     char buffer[BUFFER_SIZE], message[MESSAGE_SIZE], *ptr, *cmp, *found = 0;     #     if (currentNewsgroup == NULL) {e
 	*string = 0;u 	return;     }u       /*=      * In some implementations of NNTP, the XHDR request on arA      * single article can be *very* slow, so we do a HEAD request=9      * instead and just search for the appropriate field.0      */o  0     (void) sprintf(buffer, "HEAD %ld", article);'     if (put_server(buffer, True) == -1)I 	ServerDown = True;>3     get_data_from_server(message, sizeof(message));u     ;     check_time_out(buffer, message, sizeof(message), True);t          /* check for errors */     if (*message != CHAR_OK) { 	/* can't get header */; 	*string = NIL(char);  	return;     }t          for (;;) {0 	get_data_from_server(message, sizeof(message));8 	if (ServerDown || STREQN(message, "503 Timeout", 11)) {= 	    check_time_out(buffer, message, sizeof(message), False);b 	    continue; 	}  C 	/* the header information is ended by a '.' on a line by itself */	  3 	if ((message[0] == '.') && (message[1] == '\0')) {s 	    break;o 	}   	if (!found) {; 	    for (ptr = message, cmp = field; *ptr; ptr++, cmp++) {0 		/* used to be 'mklower' */% 		if (tolower(*cmp) != tolower(*ptr))/ 		    break; 	    }$ 	    if (*cmp == 0 && *ptr == ':') { 		while (*++ptr == ' ')h 		    ;a 		found = XtNewString(ptr);m 	    } 	}     }        if (found) 	*string = found;r     else 	*string = NIL(char);        return;a }n   #else(   void xhdr(article, field, string) art_num article; char *field; char **string; /*)  * get header information about 'article'   *'  *   the results are stored in 'string'N  */a { :     char buffer[BUFFER_SIZE], message[MESSAGE_SIZE], *ptr;     :     (void) sprintf(buffer, "XHDR %s %ld", field, article);'     if (put_server(buffer, True) == -1)a 	ServerDown = True;(3     get_data_from_server(message, sizeof(message));      ;     check_time_out(buffer, message, sizeof(message), True);'          /* check for errors */     if (*message != CHAR_OK) {. 	fprintf(stderr, "NNTP error: %s\n", message); 	*string = NIL(char);) 	mesgPane(XRN_SERIOUS,D "XRN: serious error, your NNTP server does not have XHDR support.\n\; Either you are running a pre-1.5 NNTP server or XHDR has\n\e+ not been defined in 'nntp/common/conf.h'\n\n$ XRN requires XHDR support to run."); 	return;     }      3     get_data_from_server(message, sizeof(message));}<     check_time_out(buffer, message, sizeof(message), False);       /* no information */     if (*message == '.') { 	*string = NIL(char);) 	return;     }        ptr = index(message, ' ');       /* malformed entry */0     if (ptr == NIL(char)) {e 	mesgPane(XRN_SERIOUS,0 "XRN debugging message: malformed XHDR return\n\ command: %s, return: %s",' 		       buffer, message);0 	get_data_from_server(message, sizeof(message)); 	return;     }s  
     ptr++;       /* no information */     if (STREQ(ptr, "(none)")) {; 	*string = NIL(char);( 	/* ending '.' */' 	do { 4 	    get_data_from_server(message, sizeof(message)); 	    if (ServerDown) {: 		check_time_out(buffer, message, sizeof(message), False); 		continue;o 	    } 	} while (*message != '.');I 	return;     }i  (     *string = (char *) XtNewString(ptr);       /* ending '.' */     do {0 	get_data_from_server(message, sizeof(message)); 	if (ServerDown) {= 	    check_time_out(buffer, message, sizeof(message), False);e 	    continue; 	}     } while (*message != '.');       return;= }& #endif   struct article * getarticles(newsgroup) struct newsgroup *newsgroup; {]K     register art_num first = newsgroup->first, last = newsgroup->last, art;l     int newsize;  %     if (last >= first && last != 0) {r 	register struct article	*ap;l   	newsize = last - first + 1; 	if (newsize > artCount) {- 	    newsize = artCount = MAX(newsize, 1000);dF 	    currentArticles = savedArt = ARRAYALLOC(struct article, newsize);	 	} else {)  	    currentArticles = savedArt; 	}  % 	ap = &currentArticles[INDEX(first)];F     ( 	for (art = first; art <= last; art++) { 	    ap->subject = NIL(char);t 	    ap->author = NIL(char); 	    ap->lines = NIL(char);  	    ap->msgid = NIL(char);n 	    ap->refs[0] = NIL(char);) 	    ap->refs[1] = NIL(char);  	    ap->refs[2] = NIL(char);  	    ap->parent = 0; 	    ap->child = 0;( 	    ap->text = NIL(char);
 	    ap++; 	}     }      return(currentArticles); }s   struct artStat * getartstatus(newsgroup)e struct newsgroup *newsgroup; {cK     register art_num first = newsgroup->first, last = newsgroup->last, art;e  %     if (last >= first && last != 0) {o 	register struct artStat *ap;uE 	newsgroup->artStatus = ARRAYALLOC(struct artStat, last - first + 1);y  * 	ap = &newsgroup->artStatus[INDEX(first)];     ( 	for (art = first; art <= last; art++) { 	    ap->status = ART_CLEAR;
 	    ap++; 	}     }i!     return(newsgroup->artStatus);  }    #ifdef VFORK_SUPPORTED# #ifndef POPEN_USES_INEXPENSIVE_FORK    static int popen_pid = 0;   ( #if defined(STDC) && !defined(_NO_PROTO)9 FILE  *	popen(const char *__command, const char *__type )  #elsei FILE * popen(__command, __type) char *__command;
 char *__type;e #endif {\     int pipes[2];>3     int itype = (strcmp(__type, "w") == 0 ? 1 : 0);i       if (pipe(pipes) == -1)
 	return NULL;   "     switch (popen_pid = vfork()) {     case -1: 	(void)close(pipes[0]);  	(void)close(pipes[1]);t
 	return NULL;t       case 0:e
 	if (itype) {(# 	    dup2(pipes[0], fileno(stdin));o 	    close(pipes[1]);g	 	} else {r$ 	    dup2(pipes[1], fileno(stdout)); 	    close(pipes[0]);* 	}1 	execl("/bin/sh", "/bin/sh", "-c", __command, 0);=1 	fprintf(stderr, "XRN Error: failed the execlp");	 	_exit(-1);& 	/* NOTREACHED */t       default: 	    if (itype) {  		close(pipes[0]); 		return fdopen(pipes[1], "w");t
 	    } else {. 		close(pipes[1]); 		return fdopen(pipes[0], "w");  	    }     }p }s  ( #if defined(STDC) && !defined(_NO_PROTO) int	 pclose( FILE *__stream ) #elsec int* pclose(__stream) FILE *__stream;a #endif {      int pd = 0;*& #if defined (ultrix) && defined (STDC)     union wait status; #elsea     int	status;  #endif     int	err;       err = fclose(__stream);;       do {" 	if ((pd = wait(&status)) == -1)	{ 	    err = EOF;e 	    break;  	}     } while (pd != popen_pid);       if (err == EOF)t 	return  -1; 	p$ #if defined(ultrix) && defined(STDC)     return WEXITSTATUS(status);P #elsee     if (status)	- 	status >>= 8;	/* exit status in high byte */t       return status; #endif }h #endif #endif