
 #ifdef VMS /*M  * Note: Using #module in Unix will get interpreted by the preprocessor as a  B  *	 control line and blow up. Do not uncomment the following line.  *  * module PANE "3.2"  */  #else  #ifndef lintO static char rcsid[] = "$Header: Pane.c,v 1.1 89/01/03 16:59:31 gringort Exp $";  #endif lint 
 #endif VMS /*Q  * Copyright 1988, 1989 by Digital Equipment Corporation, Maynard, Massachusetts.   *  .  *                         All Rights Reserved  *  I  * Permission to use, copy, modify, and distribute this software and its  D  * documentation for any purpose and without fee is hereby granted, I  * provided that the above copyright notice appear in all copies and that C  * both that copyright notice and this permission notice appear in  C  * supporting documentation, and that the name of Digital Equipment D  * Corporation not be used in advertising or publicity pertaining toM  * distribution of the software without specific, written prior permission.     *    *  K  * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING K  * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL J  * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES ORF  * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,I  * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, F  * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS  * SOFTWARE.  */  /*  * V1.0a    12-Jan-1988	MRR %  *	    Add our logicals to #includes.   * V1.0b    26-Feb-1988	RDB 5  *	    Fix bugs with allowresizing & geometry manager   * V1.0c    01-Mar-1988	PMB -  *	    Merge with latest copy of pane widget.   * V1.0d    17-Mar-1988	RDB &  *	    fix major bugs and enhancements  * V1.1	    1-Apr-1988	MR 8  *	    Make work with BL7.2 - add class_part_initialize,(  *	    add time argument to AcceptFocus.  * V1.2	    13-Apr-1988	JVE  *	    Make work with BL7.6 - changed DwtNcallback to DwtNmapCallback   * V1.3	    20-Apr-1988	MRR $  *	    Upward compatibility support.  * V1.4	    13-Jun-1988	MRR   *	    Add help support.  * V1.5	    30-Jun-1988	MRR   *	    Support for Help-MBx.  * V1.6	    19-Jul-1988	MRR &  *	    Help modifier changed to @Help.  * V1.7	    20-Jul-1988	RDB   *	    Initialization Bug   * V1.8	    01-Sep-1988	RDB $  *	    Resize on DwtPaneSetMax error  *	    Knob draging problem   * V1.9	    07-Sep-1988	RDB 0  *	    Color changes on 8 plane GPX on Knob drag  * V1.10    08-Sep-1988	RDB @  *	    Extra knob appearing when managing and unmanaging widgets  * V1.11    06-Oct-1988 RDB 9  *	    During Resize check if widget height also changed.   * V1.12    19-Oct-1988	RDB ;  *	    change cursor to vertical or horizontial cursor and    *	    MB2 & MB3 pushes fixed   * V1.13    31-Oct-1988 RDB    *	    Add DwtPaneAddChild calls  * V1.14    01-Nov-1988	RDB =  *	    Change resize to resizable and allowresizing to resize   * V1.15    07-Nov-1988	RDB   *	    Allow shared panes   * V1.16    29-Nov-1988 RDB   *	    Add Destory routine  *	    Add SetValues routine&  *	    Fix SetConstraintValues routine  *	    Add DeleteChild routine  *	    Add FocusCallbacks   *	    Add MapCallbacks (  *	    Fix FocusNext, FocusPrev routines  *	    Fix compiledtextbindings 4  *	    Add VMS routines for all the public routines.  * V1.17    06-Jan-1989	JG  *	    Make work on PMAX  * V2.0     15-Feb-1989 MRR C  *	    AcceptFocus should return what child's accept_focus returns.   * V2.1     22-Feb-1989 RDB 9  *	    Fix set min and max resize but when pane is shared   * V2.2	    1-Mar-1989	MRRC  *	    GC's gotten with XtGetGC should be removed with XtDestroyGC,   *	    not XFreeGC.   * V2.3	    7-Mar-1989	RDB*  *	    Orientation (w) defined incorrectly  * V2.4	    9-Mar-1989	MRR>  *	    CvtStringToOrientation and DwtPrivate no longer needed.  * V2.5	    9-Mar-1989	MRRC  *	    Copy DwtUpdateCallback here and rename as LclUpdateCallback.   * V2.6	    14-Mar-1989	RDB C  *	    Change the default width and height to be 200 instead of 100   * V2.7	    23-Mar-1989	RDB -  *	    change resource default for Foreground   * V2.8	    24-mar-1989	RDB   *	    Make knobs mullions  * V2.9	    30-Mar-1989	RDB I  *	    Redo definitions for panewidgetclass, panewidgetclassrec, mullions =  *	    Style guide compliancy on vertical & horizontal cursor   * V2.10    04-Apr-1989	RDB <  *	    Change MullionSize to be something like borderwidth &<  *	    add MullionLength to be the total height of a mullion  * V2.11    05-Apr-1989	RDb $  *	    Make LclUpdateCallback static  * V2.12    03-May-1989	RDB   *	    MB2 & MB3 cursor changes   * V2.13    12-May-1989	RDB 0  *	    make widget_size the PanePart not PaneRec  * V2.14    15-May-1989	RDB 7  *	    Geometry Manager doesn't allow widgets to resize =  *	    DwtPaneMakeViewable error in selecting right subwidget   * V3.0	    22-Aug-1989 MRR   *	    Copied to V3 library.  * V3.1	    29-Aug-1989	RDB C  *	    Fix DwtPaneMakeViewable error in setting the widget position   * V3.2	    30-AUG-1989 RDB   *	    Remove Const from Joel   * V3.3	    23-Oct-1989	RDB !  *	    New version of pane widget   */  #define PANE  
 #ifdef VMS# #include <decw$include/DwtWidget.h>  #include <DECW$CURSOR.h> #include "PaneP.h" #include "Pane.h"  #else M #define NOT_VMS_V1 /* required for part offsets to work before Ultrix 2.2 */   #include <X11/DwtWidget.h> #include <X11/Convert.h> #include <X11/decwcursor.h>  #include "PaneP.h" #include "Pane.h"  #endif   #ifdef __STDC__  #undef DwtField  #undef DwtPartOffset> #define DwtField(widget, offsetrecord, part, variable, type) \D 	(*(type *)(((char *) (widget)) + offsetrecord[Dwt##part##Index] + \$ 		XtOffset(part##Part *, variable)))' #define DwtPartOffset(part, variable) \ O         ((Dwt##part##Index) << HALFLONGBITS) + XtOffset(part##Part *, variable)  #endif  % #define NoMask                     0L     #ifndef VMS ( extern char *DwtDescToNull();  /* jmg */
 #endif VMS    /*M  * 'Length' is defined as height for vpanes, and width for hpanes.  'Breadth'   * is the other dimension.  */    - #define DwtPaneIndex (DwtConstraintIndex + 1)    " /* Macros to access pane fields */* #define PaneField(w,class,field,type)				\ 	DwtField((w),						\ + 		 ((PaneClass)(w)->core.widget_class)->		\ $ 		 	pane_class.paneoffsets,class,		\ 		 field,						\ 		 type)   * #define X(w)		PaneField(w,Core,x,Position)* #define Y(w)		PaneField(w,Core,y,Position)   3 #define Width(w)		PaneField(w,Core,width,Dimension) 5 #define Height(w)		PaneField(w,Core,height,Dimension) C #define BackgroundPixel(w)	PaneField(w,Core,background_pixel,Pixel)    ? #define Children(w)		PaneField(w,Composite,children,WidgetList) D #define NumChildren(w)		PaneField(w,Composite,num_children,Cardinal)   ? #define MullionSize(w)		PaneField(w,Pane,mullionsize,Dimension) B #define MullionLength(w)	PaneField(w,Pane,mullionlength,Dimension)= #define LeftMullion(w)		PaneField(w,Pane,leftmullion,Boolean) C #define Orientation(w)		PaneField(w,Pane,orientation,unsigned char) B #define PaneNumChildren(w)	PaneField(w,Pane,num_children,Cardinal)> #define PaneChildren(w)		PaneField(w,Pane,children,WidgetList)9 #define InterSub(w)		PaneField(w,Pane,intersub,Dimension) B #define ResizeMode(w)		PaneField(w,Pane,resize_mode,unsigned char)9 #define Foreground(w)		PaneField(w,Pane,foreground,Pixel) , #define InvGC(w)		PaneField(w,Pane,invgc,GC)< #define WhichAdjust(w)		PaneField(w,Pane,whichadjust,Widget)6 #define OrigLoc(w)		PaneField(w,Pane,origloc,Position)? #define OverrideText(w)		PaneField(w,Pane,overridetext,Boolean) > #define LastHadFocus(w)		PaneField(w,Pane,lasthadfocus,Widget)I #define HelpCallback(w)		PaneField(w,Pane,helpcallback,DwtCallbackStruct)    # #define FindLength(width, height) \ H     ((Orientation(pane) == DwtOrientationVertical) ? (height) : (width))$ #define FindBreadth(width, height) \H     ((Orientation(pane) == DwtOrientationVertical) ? (width) : (height))   $ #define FindWidth(length, breadth) \J     ((Orientation(pane) == DwtOrientationVertical) ? (breadth) : (length))% #define FindHeight(length, breadth) \ J     ((Orientation(pane) == DwtOrientationVertical) ? (length) : (breadth))    #define FindStartLoc(x, y) \?     ((Orientation(pane) == DwtOrientationVertical) ? (y) : (x))    D /* Use direct method for Length, safe because core fields guaranteed  * to be a same offset */ J #define Length(widget)	FindLength(widget->core.width, widget->core.height)L #define Breadth(widget)	FindBreadth(widget->core.width, widget->core.height)D #define StartLoc(widget)FindStartLoc(widget->core.x, widget->core.y)  + #define EventToTime(evtTime, event)					  \ %     switch ((event)->type) {						  \ !         case KeyPress: 							  \ "         case KeyRelease: 						  \. 		(evtTime) = (event)->xkey.time; break;			  \#         case ButtonPress: 						  \ %         case ButtonRelease: 						  \ 1  		(evtTime) = (event)->xbutton.time; break;		  \  	case MotionNotify: 						  \ 0 		(evtTime) = (event)->xmotion.time; break;		  \ 	case EnterNotify: 						  \ 	case LeaveNotify: 						  \2 		(evtTime) = (event)->xcrossing.time; break;		  \ 	case PropertyNotify:						  \2 		(evtTime) = (event)->xproperty.time; break;		  \ 	case SelectionClear: 						  \ 8 		(evtTime) = (event)->xselectionclear.time; break; 	  \! 	case SelectionRequest: 						  \ 9 		(evtTime) = (event)->xselectionrequest.time; break;	  \   	case SelectionNotify: 						  \3 		(evtTime) = (event)->xselection.time; break;		  \  	default: 							  \( 		(evtTime) = CurrentTime; break;				  \     }    & static Dimension	resource_min	    = 1;* static Dimension	resource_max	    = 10000;) static Dimension	resource_mullion    = 2; # static short		resource_spacing = 1; < static unsigned char	resource_vert = DwtOrientationVertical;* static Position 	resource_0_position 	= 0;   & static DwtPartResource resources[] = {   +     {	DwtNorientation, 			/* fixed -- jg */  	DwtCOrientation,  	XtROrientation,   	sizeof(unsigned char), " 	DwtPartOffset(Pane,orientation),  	DwtROrientation,  	(caddr_t) &resource_vert},    +     {	DwtNmullionSize, 			/* fixed -- jg */  	DwtCMullionSize,  	XtRDimension,   	sizeof(Dimension), " 	DwtPartOffset(Pane,mullionsize),  	XtRDimension,   	(caddr_t) &resource_mullion},   +     {	DwtNforeground,  			/* fixed -- jg */  	DwtCForeground,   	XtRPixel,   	sizeof(Pixel), ! 	DwtPartOffset(Pane,foreground),   	XtRString,  	DwtSForegroundDefault},   (     {	DwtNspacing,  			/* fixed -- jg */ 	DwtCSpacing,  	XtRShort,   	sizeof(short),  	DwtPartOffset(Pane,intersub),   	XtRShort,   	(caddr_t) &resource_spacing},   &     {	DwtNresize, 			/* fixed -- jg */
 	DwtCResize,  
 	DwtRResize,  
 	sizeof(int), ! 	DwtPartOffset(Pane,resize_mode),  	XtRImmediate,   	(caddr_t) DwtResizeGrowOnly},   *     {	DwtNoverrideText,		/* fixed -- jg */ 	DwtCOverrideText,  
 	XtRBoolean,   	sizeof(Boolean), # 	DwtPartOffset(Pane,overridetext),   	XtRImmediate,   	(caddr_t) FALSE},        {   DwtNmapCallback, 	XtCCallback,  	XtRCallback,  	sizeof(DwtCallbackPtr),# 	DwtPartOffset(Pane,map_callback),   	XtRCallback, # 	(caddr_t) NULL},	/* fixed -- jg */         {   DwtNunmapCallback, 	XtCCallback,  	XtRCallback,  	sizeof(DwtCallbackPtr),% 	DwtPartOffset(Pane,unmap_callback),   	XtRCallback,  	(caddr_t) NULL},    *     {	DwtNfocusCallback,	/* fixed -- jg */ 	XtCCallback,  	XtRCallback,  	sizeof(DwtCallbackPtr),% 	DwtPartOffset(Pane,focus_callback),   	XtRCallback,  	(caddr_t) NULL},    )     {	DwtNhelpCallback,	/* fixed -- jg */  	XtCCallback,  	XtRCallback,  	sizeof(DwtCallbackPtr),# 	DwtPartOffset(Pane,helpcallback),   	XtRCallback,  	(caddr_t) NULL},  };   # static XtResource constraints[] = {      {	DwtNmin,  	 	DwtCMin,  	XtRDimension,   	sizeof(Dimension),  	XtOffset(Constraints,min),  	XtRDimension,   	(caddr_t) &resource_min},        {	DwtNmax,  
 	DwtCMax,  	XtRDimension,   	sizeof(Dimension),  	XtOffset(Constraints,max),  	XtRDimension,   	(caddr_t) &resource_max},        {	DwtNposition,  	DwtCPosition, 	XtRPosition,  	sizeof(Position),! 	XtOffset(Constraints,position),  
 	XtRPosition, ! 	(caddr_t) &resource_0_position},         {	DwtNresizable,
 	XtCBoolean,  
 	XtRBoolean,   	sizeof(Boolean), " 	XtOffset(Constraints,resizable),  	XtRImmediate,   	(caddr_t) TRUE},         {	DwtNsharedFlag,  	DwtCSharedFlag,  	 	XtRInt,  
 	sizeof(int), # 	XtOffset(Constraints,sharedflag),   	XtRImmediate,   	(caddr_t) NoSharedPaneMask},     };    /*  0xff09 = Tab  */ static char *textbindings = +     "Shift<KeyPress>0xff09:	focus-prev()\n\ '      <KeyPress>0xff09: 		focus-next()";       2 static XtTranslations compiledtextbindings = NULL;       static void LclUpdateCallback(); static void Help(); " static void HandleMullionEvents();( static void HandleCancelMullionEvents(); static void GrabFocus(); static void FocusNext(); static void FocusPrev(); static Boolean AcceptFocus(); * static XtGeometryResult GeometryManager();% static Boolean SetConstraintValues();   static void MullionInitialize(); static void ChangeManaged(); static void InsertChild(); static void DeleteChild();   ) static char DefaultMullionTranslation[] = ;        "<EnterWindow>:			                mullion-enter()\n\ ,         <LeaveWindow>:					mullion-exit()\n\J         ~Shift ~Ctrl ~Mod1 ~@Help<Btn1Down>:            mullion-start()\n\K         ~Shift ~Ctrl ~Mod1 ~@Help Button1<PtrMoved>:    mullion-adjust()\n\ H         ~Shift ~Ctrl ~Mod1 ~@Help <Btn1Up>:             mullion-end()\n\K         ~Shift ~Ctrl ~Mod1 ~@Help<Btn2Down>:            mullion-cancel()\n\ K         ~Shift ~Ctrl ~Mod1 ~@Help<Btn3Down>:            mullion-cancel()\n\ #         @Help<Btn1Up>:					Help()";    " static char DefaultTranslation[] =$     "@Help<BtnDown>:    				Help()";   % static XtActionsRec ActionsTable[] =       { 8 	{"mullion-enter",		(XtActionProc) HandleMullionEvents},7 	{"mullion-exit",		(XtActionProc) HandleMullionEvents}, 8 	{"mullion-start",		(XtActionProc) HandleMullionEvents},9 	{"mullion-adjust",		(XtActionProc) HandleMullionEvents}, 6 	{"mullion-end",		(XtActionProc) HandleMullionEvents},? 	{"mullion-cancel",		(XtActionProc) HandleCancelMullionEvents}, + 	{"grab-focus",		(XtActionProc) GrabFocus}, + 	{"focus-next",		(XtActionProc) FocusNext}, + 	{"focus-prev",		(XtActionProc) FocusPrev}, 3     	{"Help",                	(XtActionProc) Help},          {NULL, NULL}     };   1 static Cursor VPaneCursor=NULL, HPaneCursor=NULL;   C externaldef(panewidgetclassrec) PaneClassRec panewidgetclassrec = {    {  /* core_class fields      */B     /* superclass         */    (WidgetClass) &constraintClassRec,'     /* class_name         */    "Pane", .     /* widget_size        */	sizeof(PanePart),0     /* class_initialize   */    ClassInitialize,"     /* class_part_initial */	NULL,#     /* class_inited       */	FALSE, +     /* initialize         */    Initialize, "     /* initialize_hook    */	NULL,(     /* realize            */    Realize,-     /* actions            */    ActionsTable, /     /* num_actions	  */	XtNumber(ActionsTable), 9     /* resources          */    (XtResource *) resources, 4     /* num_resources      */    XtNumber(resources),*     /* xrm_class          */    NULLQUARK,!     /* compress_motion	  */	TRUE, "     /* compress_exposure  */	TRUE,"     /* compress_enterleave*/	TRUE,&     /* visible_interest   */    FALSE,(     /* destroy            */    Destroy,'     /* resize             */    Resize, %     /* expose             */    NULL, *     /* set_values         */    SetValues,%     /* set_values_hook    */    NULL, %     /* set_values_almost  */    NULL, %     /* get_values_hook    */    NULL, ,     /* accept_focus       */    AcceptFocus,(     /* version		  */	XtVersionDontCheck,%     /* callbacks          */    NULL, 3     /* tm_table           */    DefaultTranslation, %     /* disp accelerator   */    NULL,      /* extension	  */	NULL   },{  /* composite_class fields */0     /* geometry_manager   */    GeometryManager,.     /* change_managed     */    ChangeManaged,%     /* insert_child	  */	InsertChild, %     /* delete_child	  */	DeleteChild,      /* extension	  */	NULL   },{  /* constraint_class fields */ K     /* constraint resource list            */ (XtResourceList) constraints, D     /* number of constraints in list       */ XtNumber(constraints),E     /* size of constraint record           */ sizeof(ConstraintsRec),e3     /* constraint initialization           */ NULL,83     /* constraint destroy proc             */ NULL,dB     /* constraint set_values proc          */ SetConstraintValues,     /* extension			   */ NULL    },{      /* offsets		  */	NULL,3     /* mumble		  */	0	/* Make C compiler happy   */y   }  };  uM externaldef(panewidgetclass) PaneClass panewidgetclass = &panewidgetclassrec;   e1 static struct _WidgetClassRec mullionClassRec = {n<     /* superclass         */  (WidgetClass) &widgetClassRec,)     /* class name         */   "Mullion", 2     /* size               */   sizeof(MullionRec),$     /* class initialize   */   NULL,$     /* class_part_initial */   NULL,%     /* class_inited       */   FALSE,f1     /* initialize         */   MullionInitialize, $     /* initialize_hook    */   NULL,0     /* realize            */   XtInheritRealize,,     /* actions            */   ActionsTable,6     /* num_actions        */   XtNumber(ActionsTable),     /* resources	  */   NULL,O!     /* num_resources      */   0,G)     /* xrm_class          */   NULLQUARK,A$     /* compress_motion    */   TRUE,$     /* compress_exposure  */   TRUE,$     /* compress enterleave*/   TRUE,%     /* visible_interest   */   FALSE,E$     /* destroy            */   NULL,$     /* resize             */   NULL,$     /* expose             */   NULL,$     /* set_values         */   NULL,$     /* set_values_hook    */   NULL,$     /* set_values_almost  */   NULL,$     /* get_values_hook    */   NULL,$     /* accept_focus       */   NULL,*     /* version		  */   XtVersionDontCheck,$     /* callbacks          */   NULL,9     /* tm_table           */   DefaultMullionTranslation,e4     /* query_geometry	  */   XtInheritQueryGeometry,$     /* display_accelerator*/   NULL,     /* extension	  */   NULL };   G static WidgetClass mullionWidgetClass = (WidgetClass) &mullionClassRec;J  1J #define DataFromWidget(subwidget) (Constraints)subwidget->core.constraints  t0 static void MullionInitialize(unused_request, w) Widget unused_request, w;  {l2     PaneWidget pane = (PaneWidget) w->core.parent;,     w->core.border_pixel = Foreground(pane);-     w->core.border_width = MullionSize(pane);g<     w->core.width = FindWidth(InterSub(pane),Breadth(pane));>     w->core.height = FindHeight(InterSub(pane),Breadth(pane));      w->core.x = w->core.y = -99; }n  n n /*L  * Figure out what length of the window we're actually using.  Ideally, thisJ  * will be the same as the window's length, but it will often be differentH  * (for example, when we don't have enough windows to take up the entire  * window's length.)  */   *! static Dimension LengthUsed(pane)V PaneWidget pane; {D     Dimension result;e     int i, cnt; %     Constraints subdata, nextsubdata;7     Boolean allfixed;A  -     if (PaneNumChildren(pane) == 0) return 0;      result = 0;y,     for (i=0 ; i<PaneNumChildren(pane); i++) 	{) 	result += Length(PaneChildren(pane)[i]);l1 	subdata = DataFromWidget(PaneChildren(pane)[i]); $ 	if (i < PaneNumChildren(pane) - 1)  	    { P# 	    result += MullionLength(pane);b 	    }   	}     return result; }        l /*M  * Set the dheight field of each subwidget to be the appropriate height if weFK  * want to move the border below the given subwidget by the given number ofr
  * pixels.  */   F. static void RefigureDlengths(pane, sub, delta) PaneWidget pane; Widget sub;.
 int delta; {9(     int cur_above, min_above, max_above;(     int cur_below, min_below, max_below;
     int used;*     Boolean currentlyabove;      Widget subwidget;n     Constraints subdata;"     int i, which, temp, newlength;          /*E      * if we allow resizing of the pane we will just reset the child  7      * between the min and the max if it isn't already.       */ -     if (ResizeMode(pane) != DwtResizeFixed) {i, 	for (i=0 ; i<PaneNumChildren(pane) ; i++) {' 	    subwidget = PaneChildren(pane)[i];e) 	    subdata = DataFromWidget(subwidget);  	    /*8F 	     * This only looks tough. If the ResizeMode(pane) == GrowOnly andG 	     * the length is less than 0 then DONT reset the dlength to be the = 	     * new length. Otherwise make the newlength the dlength.V 	     */1 	    if (ResizeMode(pane) != DwtResizeGrowOnly &&e+ 		    Length(subwidget) > subdata->dlength)e( 			subdata->dlength = Length(subwidget);A 	    /* if the subwidget cannot be resized set the min and max to ) 	     * the created length of the widget.M	 	     */ h 	    if (subdata->resizable) 		{ & 		if (subdata->dlength < subdata->min)& 		    subdata->dlength = subdata->min;% 		if (subdata->dlength >subdata->max) & 		    subdata->dlength = subdata->max; 		}e	 	    elsee 		{n1 		subdata->min = subdata->max = subdata->dlength;* 		}C 	}/* end for */r 	return;     }9G     /* Ok no resizing allowed so we have to be a little more particulart      */ *     cur_above = min_above = max_above = 0;*     cur_below = min_below = max_below = 0;     currentlyabove = TRUE;H     /* Find the length above & including the changed widget & the lengthF      * below this widget. Total above & below on current, maximium and      * minimiumf      */M/     for (i=0 ; i<PaneNumChildren(pane) ; i++) {U# 	subwidget = PaneChildren(pane)[i];e% 	subdata = DataFromWidget(subwidget);e 	if (currentlyabove) {$ 	    cur_above += Length(subwidget); 	    min_above += subdata->min;f 	    max_above += subdata->max; 	 	} else {F$ 	    cur_below += Length(subwidget); 	    min_below += subdata->min;* 	    max_below += subdata->max;a 	} 	if (subwidget == sub) { 	    which = i;l 	    currentlyabove = FALSE; 	}     } /* end for loop */     if (currentlyabove)N1 	XtWarning("Never found the subwidget in Pane.");      used = LengthUsed(pane);>     if (used < Length(pane)) min_below -= Length(pane) - used;*     else max_below += used - Length(pane);E     if (delta < min_above - cur_above) delta = min_above - cur_above;hE     if (delta < cur_below - max_below) delta = cur_below - max_below;+E     if (delta > max_above - cur_above) delta = max_above - cur_above;,E     if (delta > cur_below - min_below) delta = cur_below - min_below;e     temp = delta;	H     /* a for loop is easier to read here. Also why continue if temp = 0?>      * And further more there is no good reason to reset temp.      */t      for (i = which; i >= 0; i--) 	{# 	subwidget = PaneChildren(pane)[i];g% 	subdata = DataFromWidget(subwidget);n2 	/* only make changes if we can resize this widget 	 */ 	if (subdata->resizable) 	    {* 	    newlength = Length(subwidget) + temp;B 	    if (newlength < (int) subdata->min) newlength = subdata->min;B 	    if (newlength > (int) subdata->max) newlength = subdata->max;" 	    subdata->dlength = newlength; 	    } 	elsen 	    {H 	    subdata->min = subdata->max = subdata->dlength = Length(subwidget); 	    }0 	temp -= (subdata->dlength - Length(subwidget)); 	}D     /* take what ever was gained on the top and put it on the bottom      */i     temp = -delta;5     for (i = which+1; i < PaneNumChildren(pane); i++)n 	{# 	subwidget = PaneChildren(pane)[i];D% 	subdata = DataFromWidget(subwidget);F2 	/* only make changes if we can resize this widget 	 */ 	if (subdata->resizable) 	    {* 	    newlength = Length(subwidget) + temp;B 	    if (newlength < (int) subdata->min) newlength = subdata->min;B 	    if (newlength > (int) subdata->max) newlength = subdata->max;" 	    subdata->dlength = newlength; 	    } 	elsee 	    {H 	    subdata->min = subdata->max = subdata->dlength = Length(subwidget); 	    }0 	temp -= (subdata->dlength - Length(subwidget)); 	} }   d  n i static void TryToFillPane(pane)( PaneWidget pane; {D     int used, length;?     length = Length(pane);     used = LengthUsed(pane);"     if (PaneNumChildren(pane) > 0)D 	RefigureDlengths(pane, PaneChildren(pane)[PaneNumChildren(pane)-1], 			 length - used);e }t  ( e, static void CommitNewSizes(pane, dontnotify) PaneWidget pane; Widget dontnotify; {h     XWindowChanges changes;      Position loc;r     int i, cnt; -     Widget subwidget, nextsubwidget, mullion; %     Constraints subdata, nextsubdata;o     Boolean allfixed;      loc = 0;.     for (i=0 ; i<PaneNumChildren(pane) ; i++)  	{ 	/* Do the subwidget first 	 */# 	subwidget = PaneChildren(pane)[i];(% 	subdata = DataFromWidget(subwidget);)< 	/* depending on the orientation we'll change the subwidgets 	 * x, width or y, height. 	 */ 	changes.x = FindWidth(loc, 0);.  	changes.y = FindHeight(loc, 0);< 	changes.width = FindWidth(subdata->dlength, Breadth(pane));> 	changes.height = FindHeight(subdata->dlength, Breadth(pane)); 	changes.border_width = 0;H 	if (changes.x != subwidget->core.x || changes.y != subwidget->core.y ||0 	      changes.width != subwidget->core.width ||2 	      changes.height != subwidget->core.height ||= 	      changes.border_width != subwidget->core.border_width) b 	    {# 	    subwidget->core.x = changes.x;s# 	    subwidget->core.y = changes.y; + 	    subwidget->core.width = changes.width; - 	    subwidget->core.height = changes.height;-9 	    subwidget->core.border_width = changes.border_width; % 	    if (XtIsRealized(subwidget))    e 		{m= 		XConfigureWindow(XtDisplay(subwidget), XtWindow(subwidget), ? 		    (unsigned) CWX |CWY | CWWidth | CWHeight | CWBorderWidth,t 		    &changes); 		}i# 	    if (subwidget != dontnotify &&;@ 		 XtClass(subwidget)->core_class.resize != (XtWidgetProc) NULL) 		{ B 		(*(subwidget->core.widget_class->core_class.resize))(subwidget); 		}u 	    } 	loc += Length(subwidget);   	/* Now position the mullion t 	 */ 	mullion = subdata->mullion;  c  	/* Get any new width and height 	 */9 	changes.width = FindWidth(InterSub(pane),Breadth(pane)); ; 	changes.height = FindHeight(InterSub(pane),Breadth(pane));e* 	changes.border_width = MullionSize(pane);  n3 	/* Move this mullion where they can't get to it ift# 	 * the subwidget is the last childO 	 */$ 	if (i < PaneNumChildren(pane) - 1)  	    { 	# 	    changes.x = FindWidth(loc, 0); $ 	    changes.y = FindHeight(loc, 0);  	    loc += MullionLength(pane); 	    } , 	else  	    {%     	    changes.x = changes.y = -99;m 	    loc += InterSub(pane);r 	    }! 	    mullion->core.x = changes.x;n! 	    mullion->core.y = changes.y; ) 	    mullion->core.width = changes.width;t+ 	    mullion->core.height = changes.height;w7 	    mullion->core.border_width = changes.border_width;r 	    if (XtIsRealized(mullion))f 		{P9 		XConfigureWindow(XtDisplay(mullion), XtWindow(mullion),g@ 		    (unsigned) CWX | CWY | CWWidth | CWHeight | CWBorderWidth, 		    &changes);6 		XRaiseWindow(XtDisplay(mullion), XtWindow(mullion)); 		},     }a }_  D  e e /*  * Invert the given border.e  */	   . static void InvertIt(pane, loc, mullionlength) PaneWidget pane;
 Position loc;t Dimension mullionlength; { L     loc += mullionlength / 2 + 1;   /* Deal with X's definition that wide */+ 				    /* lines are centered around the */,  				    /* specified points.  */   ;     XDrawLine(XtDisplay(pane), XtWindow(pane), InvGC(pane), - 	      FindWidth(loc, 0), FindHeight(loc, 0),aF 	      FindWidth(loc, Breadth(pane)), FindHeight(loc, Breadth(pane))); }   R  l k /*J  * Move the magic borders to the location specified by the current dlength  * values. a  */k   " static void MoveMagicBorders(pane) PaneWidget pane; {a     Position loc;k     int i, cnt;L%     Constraints subdata, nextsubdata;x     Boolean allfixed;a       loc = 0;-     for (i=0 ; i<PaneNumChildren(pane) ; i++)P 	{1 	subdata = DataFromWidget(PaneChildren(pane)[i]);  	loc += subdata->dlength; " 	if (loc != subdata->magicborder)  	    {4 	    if (PaneChildren(pane)[i] == WhichAdjust(pane)) 		{s- 		if (subdata->magicborder != OrigLoc(pane)) e@ 		    InvertIt(pane, subdata->magicborder, MullionLength(pane)); 		if (loc != OrigLoc(pane)) 0 		    InvertIt(pane, loc, MullionLength(pane));  		}o	 	    else  		{  		if (subdata->magicborder != G 		   (StartLoc(PaneChildren(pane)[i]) + Length(PaneChildren(pane)[i]))) @ 		    InvertIt(pane, subdata->magicborder, MullionLength(pane));
 		if (loc != XG 		   (StartLoc(PaneChildren(pane)[i]) + Length(PaneChildren(pane)[i])))e/ 		    InvertIt(pane, loc, MullionLength(pane));  		}   	    subdata->magicborder = loc; 	    }$ 	if (i < PaneNumChildren(pane) - 1)  	    {  	    loc += MullionLength(pane); 	    } 	else  	    { 	    loc += InterSub(pane);x 	    } 	} }   t c /*  * Turn on the magic borders.y  */>  f" static void DrawMagicBorders(pane) PaneWidget pane; {(     Position loc;c     int i, cnt;o%     Constraints subdata, nextsubdata;c     Boolean allfixed;(       loc = 0;/     for (i=0 ; i<PaneNumChildren(pane) ; i++) {t1 	subdata = DataFromWidget(PaneChildren(pane)[i]);r 	loc += subdata->dlength;u 	subdata->magicborder = loc;$ 	if (i < PaneNumChildren(pane) - 1)  	    { G  	    loc += MullionLength(pane); 	    } o 	else  	    { 	    loc += InterSub(pane);l 	    }     }; }t  c i /*  * Turn off the magic borders.  */l  ;# static void EraseMagicBorders(pane)t PaneWidget pane; {n     int		i;      Constraints subdata;.     for (i=0 ; i<PaneNumChildren(pane) ; i++)  	{0 	if (PaneChildren(pane)[i] == WhichAdjust(pane)) 	    {5 	    subdata = DataFromWidget(PaneChildren(pane)[i]); / 	    if (subdata->magicborder != OrigLoc(pane)) < 		InvertIt(pane, subdata->magicborder, MullionLength(pane)); 	    } 	else  	    {5 	    subdata = DataFromWidget(PaneChildren(pane)[i]);:! 	    if (subdata->magicborder !=  J 	       (StartLoc(PaneChildren(pane)[i]) + Length(PaneChildren(pane)[i])))< 		InvertIt(pane, subdata->magicborder, MullionLength(pane)); 	    } 	}2     XClearWindow(XtDisplay(pane), XtWindow(pane)); }A  o  e c /*J  * Find where (lengthwise) in the pane window the given event is pointing.1  * (The event was delivered to the given widget.)E  */}   6 static Position FindWherePointing(pane, widget, event) PaneWidget pane; Widget widget; XEvent *event; {e     Position x, y;     x = event->xbutton.x;M     y = event->xbutton.y;c%     while (widget != (Widget) pane) {l 	x += widget->core.x;o 	y += widget->core.y;r 	widget = widget->core.parent;     }r     return FindLength(x, y); }	  t  i r /*A  * Given that the button down event was delivered to the mullion, I  * figure out which window is above the border that the user is trying too  * adjust.    */n  e2 static Widget FindWhichAdjust(pane, widget, event) PaneWidget pane; Widget widget; XEvent *event; {p     Widget result;     Position where, loc;
     int i;     Constraints subdata;  3     where = FindWherePointing(pane, widget, event);e$     loc = MullionLength(pane)/2 + 1;#     result = PaneChildren(pane)[0];_/     for (i=0 ; i<PaneNumChildren(pane) ; i++) {L  	widget = PaneChildren(pane)[i];" 	if (loc < where) result = widget; 	    else break;" 	subdata = DataFromWidget(widget);- 	loc += Length(widget) + MullionLength(pane);b     }      return result; }t  b A /*.  * Handle button events in the mullion window.  */c  ). static void HandleMullionEvents(widget, event) Widget widget; XEvent *event; {s7     PaneWidget pane = (PaneWidget) widget->core.parent;R+     if (PaneNumChildren(pane) == 0) return;      switch (event->type) {       case EnterNotify:s1 	if (Orientation(pane) == DwtOrientationVertical)e 	    {` 	    XDefineCursor (XtDisplay(widget->core.parent), XtWindow(widget->core.parent), VPaneCursor); 	    } 	else  	    {` 	    XDefineCursor (XtDisplay(widget->core.parent), XtWindow(widget->core.parent), HPaneCursor); 	    } 	LeftMullion(pane) = False;p 	break;        case LeaveNotify:  	if (WhichAdjust(pane) == NULL)h 	    {U 	    XUndefineCursor (XtDisplay(widget->core.parent), XtWindow(widget->core.parent));n 	    } 	else  	    { 	    LeftMullion(pane) = True; 	    } 	break;        case ButtonPress:f: 	WhichAdjust(pane) = FindWhichAdjust(pane, widget, event); /*V  * The OrigLoc is the Origicnal location of the dividing line between two panes. It isR  * calculated by adding the starting location (x or y depending on orientation) to9  * the length (width or height depending on orientation)    */ I 	OrigLoc(pane) = StartLoc(WhichAdjust(pane)) + Length(WhichAdjust(pane));*. 	RefigureDlengths(pane, WhichAdjust(pane), 0); 	DrawMagicBorders(pane); 	break;t       case MotionNotify:& 	if (WhichAdjust(pane) == NULL) break;* 	RefigureDlengths(pane, WhichAdjust(pane),, 			 FindWherePointing(pane, widget, event) - 			     OrigLoc(pane));V 	MoveMagicBorders(pane); 	break;L       case ButtonRelease:	 /* N+  * make sure the operation wasn't canceled r */  	if (WhichAdjust(pane) != NULL)  	    {. 	    RefigureDlengths(pane, WhichAdjust(pane),0 			     FindWherePointing(pane, widget, event) - 				 OrigLoc(pane)); 	    MoveMagicBorders(pane); 	    EraseMagicBorders(pane); ) 	    CommitNewSizes(pane, (Widget) NULL);  	    WhichAdjust(pane) = NULL; 	    } 	if (LeftMullion(pane))i 	    {U 	    XUndefineCursor (XtDisplay(widget->core.parent), XtWindow(widget->core.parent));E 	    LeftMullion(pane) = False;  	    } 	break;e     }  }i  i /*G  * Handle cancel (MB2 & MB3 press) button events in the mullion window.   */a  o- static void HandleCancelMullionEvents(widget)t Widget widget; {N7     PaneWidget pane = (PaneWidget) widget->core.parent; +     if (PaneNumChildren(pane) == 0) return;a     if (LeftMullion(pane)) 	{ 	EraseMagicBorders(pane); Q 	XUndefineCursor (XtDisplay(widget->core.parent), XtWindow(widget->core.parent));  	LeftMullion(pane) = False;  	}     WhichAdjust(pane) = NULL;  }  L% static void ClassInitialize(unused_w), Widget unused_w; { *     DwtResolvePartOffsets(panewidgetclass,/ 		 &panewidgetclassrec.pane_class.paneoffsets); B     compiledtextbindings = XtParseTranslationTable (textbindings); }L       *  c  _ u /*$  * Initialize this instance of pane.  */r  n) static void Initialize(unused_request, w)N Widget unused_request, w;  { %     PaneWidget pane = (PaneWidget) w;*     XGCValues values;X  h /* **  Create the pane cursors... */     if (VPaneCursor == NULL) 	{     /*&      *  Local data for the pane cursorM      *	Note: Normally one would do this sort of thing in ClassInitialize but,iN      *	setting up cursors requires a live widget which ClassInit doesn't have.      */r! 	XColor cursor_fore, cursor_back;w 	Font   cursor_font; 	int    cursor_wait;  o     /*     **  Set up the colorsl     */ 	cursor_fore.pixel = 0;. 	cursor_fore.red   = 65535;n 	cursor_fore.green = 65535;d 	cursor_fore.blue  = 65535;p  ) 	cursor_back.pixel = 0;F 	cursor_back.red   = 0;B 	cursor_back.green = 0;r 	cursor_back.blue  = 0;n  n7 	cursor_font = XLoadFont (XtDisplay(w), "decw$cursor");c# 	cursor_wait = decw$c_vpane_cursor; X 	VPaneCursor = XCreateGlyphCursor (XtDisplay(w), cursor_font, cursor_font, cursor_wait, 8 						     cursor_wait + 1, &cursor_fore, &cursor_back);# 	cursor_wait = decw$c_hpane_cursor;nX 	HPaneCursor = XCreateGlyphCursor (XtDisplay(w), cursor_font, cursor_font, cursor_wait, 8 						     cursor_wait + 1, &cursor_fore, &cursor_back);) 	XUnloadFont (XtDisplay(w), cursor_font);e 	}   E     if (Width(pane) == 0) Width(pane) = 200; /* Better default?%%% */r.     if (Height(pane) == 0) Height(pane) = 200;     PaneNumChildren(pane) = 0;     PaneChildren(pane) = NULL;     WhichAdjust(pane) = NULL;      OrigLoc(pane) = 0;     LastHadFocus(pane) = NULL;C     MullionLength(pane) = (MullionSize(pane) * 2) + InterSub(pane);b     values.function = GXinvert;hA     values.foreground = BackgroundPixel(pane) ^ Foreground(pane);h6     if (values.foreground == 0) values.foreground = 1;'     values.line_width = InterSub(pane);g     if (values.line_width == 1);B 	values.line_width = 0;	/* Take advantage of fast server lines. */A     values.plane_mask = BackgroundPixel(pane) ^ Foreground(pane); "     values.fill_style = FillSolid;-     values.subwindow_mode = IncludeInferiors;;     InvGC(pane) = XtGetGC(w,. 			       (XtGCMask) GCFunction | GCForeground3 			       | GCLineWidth | GCPlaneMask | GCFillStylen 			       | GCSubwindowMode, 			       &values);  }R  z x /*  * Realize the pane widget.d  */a   ) static void Realize(w, vMask, attributes)e	 Widget w;  Mask *vMask;! XSetWindowAttributes *attributes;  { %     PaneWidget pane = (PaneWidget) w;e     Mask valueMask = *vMask;   -     if (ResizeMode(pane) != DwtResizeFixed) {  /*N  * For now the ResizeMode is forced to DwtResizeFixed so that you can move theR  * mullion once you get this beast up. If the user wants to change the pane widgetP  * back he should call DwtPaneAllowResizing, do the work in adjusting the widget!  * and then reset the value back.m  * dI  * This needs to be changed and modeled after the DIALOG widget. See the s  * adapt_to_kids routine.	  */u# 	ResizeMode(pane) = DwtResizeFixed;  	TryToFillPane(pane);a% 	CommitNewSizes(pane, (Widget) NULL);t     }      /     attributes->bit_gravity = NorthWestGravity;s4     attributes->background_pixel = Foreground(pane);,     valueMask |= CWBitGravity | CWBackPixel;     L     XtCreateWindow(w, (unsigned int) InputOutput, (Visual *) CopyFromParent, 		   valueMask, attributes); }a  b   /*  * Destroy the pane widget.   */e    static void Destroy(w)	 Widget w;  {*%     PaneWidget pane = (PaneWidget) w;c  gN /* Free the memory allocated for the children that are displayed and those in H  * the composite field. We created and allocated space for them it so we  * must Free it.  */b#     XtFree((char *)Children(pane));b'     XtFree((char *)PaneChildren(pane));c  e /*)  * Remove all callbacks that were createdt  */ :     XtRemoveAllCallbacks ((Widget)pane, DwtNhelpCallback);;     XtRemoveAllCallbacks ((Widget)pane, DwtNfocusCallback);m9     XtRemoveAllCallbacks ((Widget)pane, DwtNmapCallback);a;     XtRemoveAllCallbacks ((Widget)pane, DwtNunmapCallback);t /*#  *  Free the InvGC that was createdo  */      XtDestroyGC (InvGC(pane)); }g  e   /*C  * The purpose of this routine is to check and see in the Vertical sH  * orientation if a change in width will also change a subwidgets height  */d  L$ static void CheckHeightChanges(pane)     PaneWidget pane; {n%     XtWidgetGeometry intended, reply;u     Widget subwidget;l     Constraints subdata;
     int i;  t=     if (Orientation(pane) != DwtOrientationVertical) return;    (@     intended.request_mode = CWWidth;		/* ask about this width */  e-     for (i=0 ; i<PaneNumChildren(pane); i++) a 	{# 	subwidget = PaneChildren(pane)[i]; % 	subdata = DataFromWidget(subwidget);r 	if (!subdata->resizable)* 	    {A 	    intended.width = Width(pane);   /* if it affects the size */] 					    /* he'll tell us */  w< 	    switch (XtQueryGeometry (subwidget, &intended, &reply)) 		{ 6 		case XtGeometryAlmost:		/* he wants to compromise */  u, 		    if ((reply.request_mode & CWHeight) &&. 			    subwidget->core.height != reply.height) 			{  			/* take height he suggests */* 			subwidget->core.height = reply.height;	5 			RefigureDlengths(pane,subwidget,subdata->dlength -  					    reply.height);l 			} 		    break;  t 		case XtGeometryYes:u 		case XtGeometryNo:! 			/* he agrees, no problem w/ */t 			/* current height */o 		    break; 		} /* end case */ 	    } /* end if */; 	} /* end for loop */  }   e C /*7  * The pane widget has been resized; handle everything.D  */b  a static void Resize(w)d	 Widget w;  {y%     PaneWidget pane = (PaneWidget) w;g     CheckHeightChanges(pane);l     TryToFillPane(pane);(     CommitNewSizes(pane, (Widget) NULL); }g  < n /*8  * Resources in the pane widget have changed; handle it.  */n  s3 static Boolean SetValues (old, unused_request, new)>$     Widget old, unused_request, new; { *     PaneWidget	oldpane = (PaneWidget) old;*     PaneWidget	newpane = (PaneWidget) new;     Boolean	redisplay = FALSE;     XGCValues	values;     /*  * Update the callbacksP  */a:     LclUpdateCallback (	    &(oldpane->pane.map_callback),F 			 (Widget) newpane, &(newpane->pane.map_callback), DwtNmapCallback);<     LclUpdateCallback (	    &(oldpane->pane.unmap_callback),J 			 (Widget) newpane, &(newpane->pane.unmap_callback), DwtNunmapCallback);:     LclUpdateCallback (	    &(oldpane->pane.helpcallback),G 			 (Widget) newpane, &(newpane->pane.helpcallback), DwtNhelpCallback); <     LclUpdateCallback (	    &(oldpane->pane.focus_callback),J 			 (Widget) newpane, &(newpane->pane.focus_callback), DwtNfocusCallback);  ; /*%  * For now ignore orientation changeso  */s5     if (Orientation(newpane) != Orientation(oldpane))] 	{- 	Orientation(newpane) = Orientation(oldpane);e 	}  n /*$  * For now ignore resize mode change  */ 3     if (ResizeMode(newpane) != ResizeMode(oldpane))h 	{+ 	ResizeMode(newpane) = ResizeMode(oldpane);a 	} /*M  * Something should be done with foreground here but I don't think that workss(  * anyway so wait till you fix it latter  */e  i /*A  * Check the mullion and spacing for changes. If so set redisplay-  */.9     if ((MullionSize(newpane) != MullionSize(oldpane)) || * 	(InterSub(newpane) != InterSub(oldpane))) 	    { /*9  * Change the inverted lines width to InterSub new length   */ 0 	    if (InterSub(newpane) != InterSub(oldpane)) 		{e( 		values.line_width = InterSub(newpane); 		if (values.line_width == 1)iG 		    values.line_width = 0;	/* Take advantage of fast server lines. */ F 		XChangeGC (XtDisplay(newpane),InvGC(newpane), GCLineWidth, &values); 		}i #ifdef bugfixedl /*O  * Currently there is a bug in the XConfirgureWindow which prevents reseting of|L  * the border width. In the mean time don't allow any change in MullionSize.  */XM 	    MullionLength(newpane) = (MullionSize(newpane) * 2) + InterSub(newpane);g #elsee1 	    MullionSize(newpane) = MullionSize(oldpane);u #endif /* cQ  * if the mullions need to be changed in width and or height they will be changed>"  * in the CommitNewSizes routine.   */e 	    redisplay = TRUE; 	    TryToFillPane(newpane);, 	    CommitNewSizes(newpane, (Widget) NULL); 	    }  a     return redisplay;c }	   /*7  * SetValue on the callback is interpreted as replacing   * all callbacks  */    static void 0 LclUpdateCallback (rstruct, s, sstruct, argname)?     DwtCallbackStructPtr rstruct;		/* the real callback list */ )     Widget s;					/* the scratch widget*/ B     DwtCallbackStructPtr sstruct;		/* the scratch callback list */     char           *argname; {      DwtCallbackPtr list;       /*B      * if a new callback has been specified in the scratch widget,7      * remove and deallocate old callback and init new i      */h1     if (rstruct->ecallback != sstruct->ecallback)_     { + 	list = (DwtCallbackPtr)sstruct->ecallback;( 	/*o: 	 *  Copy the old callback list into the new widget, since. 	 *  XtRemoveCallbacks needs the "real" widget     	 */         *sstruct = *rstruct;" 	XtRemoveAllCallbacks(s, argname); 	sstruct->ecallback = NULL;	" 	XtAddCallbacks(s, argname, list);     }h }i     d  e *E static Boolean SetConstraintValues(current, unused_widget, newWidget);/     Widget   current, unused_widget, newWidget;  {o     Constraints cur, new;      Cardinal	position;     Dimension	min, max;      Boolean	resizable;     Cardinal	sharedflag;"     Boolean	do_add_widget = FALSE;  n"     cur = DataFromWidget(current);$     new = DataFromWidget(newWidget);     position = new->position;F     min = new->min;(     max = new->max;c     resizable = new->resizable;k!     sharedflag = new->sharedflag;t  l     if (max == 0)y 	max = resource_max;     if (min == 0)  	min = resource_min; /*J  * We have to reset all of these because the address of newWidget what is K  * acutally stored in the pane widget. If you use the current widget you'll   * stack dump.  */N"     if (position != cur->position) 	{ 	do_add_widget = TRUE; 	new->position = cur->position;- 	}     if (min != cur->min) 	{ 	do_add_widget = TRUE; 	new->min = cur->min;e 	}     if (max != cur->max) 	{ 	do_add_widget = TRUE; 	new->max = cur->max;  	}$     if (resizable != cur->resizable) 	{ 	do_add_widget = TRUE;! 	new->resizable = cur->resizable;e 	}&     if (sharedflag != cur->sharedflag) 	{ 	do_add_widget = TRUE;# 	new->sharedflag = cur->sharedflag;c 	}  i /* (?  * This is just like DwtPaneAddWidget so I'll just call it and ,"  * let it take care of everything.  */)     if (do_add_widget) 	{I 	DwtPaneAddWidget (newWidget, position, min, max, resizable, sharedflag);eG 	/* We must reset all of these because it is possible they have changed G 	 * and if we don't change them they will just get changed back to whatu) 	 * they were when we leave this routine.  	 */% 	current->core.x = newWidget->core.x; % 	current->core.y = newWidget->core.y;s- 	current->core.width = newWidget->core.width;)/ 	current->core.height = newWidget->core.height;n 	}     return TRUE; }t  u t /*I  * One of our subwidgets is trying to resize itself. For now we will onlyN<  * deal with DwtResizeFixed. Anything else won't work right.  */p  )B static XtGeometryResult GeometryManager(subwidget, request, reply) Widget subwidget;r" XtWidgetGeometry *request, *reply; {u     XtGeometryResult result;:     PaneWidget pane = (PaneWidget) subwidget->core.parent;     Constraints subdata;      Dimension rlength, rbreadth;  /     if ((request->request_mode & CWWidth) == 0)n( 	request->width = subwidget->core.width;0     if ((request->request_mode & CWHeight) == 0)* 	request->height = subwidget->core.height;:     rlength = FindLength(request->width, request->height);<     rbreadth = FindBreadth(request->width, request->height);(     subdata = DataFromWidget(subwidget);     result = XtGeometryAlmost;      if (rlength < subdata->min)  	{ 	rlength = subdata->min; 	} )%     else if (rlength > subdata->max)   	{ 	rlength = subdata->max; 	};)!     if (rbreadth > Breadth(pane))) 	{ 	    result = XtGeometryNo;i 	    rbreadth = Breadth(pane); 	};}#     if (rbreadth == Breadth(pane)) ) 	{! 	if (subdata->dlength == rlength)  	    { 	    /*nB 	     * I know this seams bizare since everthing looks like it is C 	     * already set. However the Text widget does things in a funnyi@ 	     * order and it resets the height back so we must redo the > 	     * CommitNewSizes to get the widget back in sinc with the 	     * constraint.n 	     */* 	    CommitNewSizes(pane, (Widget) NULL);  	    result = XtGeometryDone;  	    } 	elser 	    {C 	    RefigureDlengths(pane, subwidget, rlength - subdata->dlength);t* 	    CommitNewSizes(pane, (Widget) NULL); J 	    if (subdata->dlength == FindLength(request->width, request->height))  		result = XtGeometryDone; 	    };  	}"     if (result != XtGeometryDone)  	{ 	*reply = *request;t 	rbreadth = Breadth(pane);- 	reply->width = FindWidth(rlength, rbreadth);r/ 	reply->height = FindHeight(rlength, rbreadth);  	}     return result; }   r     d r /*8  * One of our subwidgets has changed its managed status.  */     static void ChangeManaged(w)	 Widget w;  {      XWindowChanges changes;)%     PaneWidget pane = (PaneWidget) w;)#     Widget subwidget, cursubwidget;e$     Constraints subdata, cursubdata;     int position, i;  +     PaneNumChildren(pane) = 0;?     for (i=(NumChildren(pane)+1)/2 ; i<NumChildren(pane); i++) u 	{ 	subwidget = Children(pane)[i];*/ 	if (XtClass (subwidget) == mullionWidgetClass)v 	    { 	    continue; 	    }% 	subdata = DataFromWidget(subwidget);d  ) /* eK  * Recreate the PaneChildren list by only adding those subwidgets which arevD  * managed and if shared, are in view. If a subwidget fails the testQ  * move his mullion into oblivion. Like the rest of the mullions that don't need t  * to be seen.  */a  	if (subwidget->core.managed && - 		(subdata->sharedflag == NoSharedPaneMask ||t@ 		subdata->sharedflag == (SharedPaneMask | ViewableInPaneMask))) 	    {. 	    if (subdata->sharedflag & SharedPaneMask) 		{o+ 		XtSetMappedWhenManaged (subwidget, TRUE);  		}  	    /*iC 	     * NOTE:The only reason we do the realizing here is because iftE 	     *	    it isn't realized the mullions don't show up on top. OncebE 	     *	    mullions are removed you can get rid of this if statementp 	     */: 	    if (XtIsRealized(pane) && !(XtIsRealized(subwidget))) 		{i 		XtRealizeWidget(subwidget);I 		};? 	    PaneChildren(pane)[(PaneNumChildren(pane))++] = subwidget;n 	    }* 	else if (subwidget->core.being_destroyed) 	    { 	/*e8 	 * This subwidget is in the process of being destroyed.K 	 * If this widget is shared then give the pane to first subwidget sharing , 	 * the same position. 	 */< 	    for (position=(NumChildren(pane)/2)+subdata->position; " 		 position <= NumChildren(pane);  		 position++) 		{,- 		cursubwidget = Children(pane) [position-1]; - 		cursubdata = DataFromWidget (cursubwidget);e2 		if (cursubdata->position != subdata->position ||  		    cursubwidget == subwidget) 		    continue;W% 		DwtPaneMakeViewable (cursubwidget);  	    /*DH 	     * It is necessary to add the subwidget to the PaneChildren list ifG 	     * we have already gone passed it. It will be in the correct ordera1 	     * since PaneChildren are based on position.e 	     */ 		if (position < i)n@ 		    PaneChildren(pane)[(PaneNumChildren(pane))++] = subwidget; 		break; 		}p 	    } 	elsee 	    { 	    /*w/ 	     * UnMap any shared panes that aren't used= 	     */. 	    if (subdata->sharedflag & SharedPaneMask) 		{l, 		XtSetMappedWhenManaged (subwidget, FALSE);3 		XtSetMappedWhenManaged (subdata->mullion, FALSE);E 		}(	 	    elsei 		{w 		/** 		 * Move the mullion widget into oblivion 		 */r 		changes.x = changes.y = -99;/ 		if (changes.x != subdata->mullion->core.x || e) 			changes.y != subdata->mullion->core.y)i 		    {(+ 		    subdata->mullion->core.x = changes.x;e+ 		    subdata->mullion->core.y = changes.y;e) 		    if (XtIsRealized(subdata->mullion)) 1 			XConfigureWindow(XtDisplay(subdata->mullion), u5 				XtWindow(subdata->mullion), CWX | CWY, &changes);, 		    }e 		}t 	    }     }l /*I  * Ok now you only have those children that are managed so fill the pane.d  */;     TryToFillPane(pane);(     CommitNewSizes(pane, (Widget) NULL); }*     , static void RememberFocus(w, unused_tag, cb)	 Widget w;_ caddr_t unused_tag;  DwtAnyCallbackStruct * cb; {w"     DwtAnyCallbackStruct focus_cb;/     PaneWidget pane = (PaneWidget) XtParent(w);C     LastHadFocus(pane) = w;   *!     focus_cb.reason = DwtCRFocus;      focus_cb.event = cb->event;t:     XtCallCallbacks ((Widget)pane, DwtNfocusCallback, cb); }u  r  e r /*"  * A new subwidget has been added.  */.= static DwtCallback focus_cb[2] = {RememberFocus, NULL, NULL};f  ;" static void InsertChild(subwidget) Widget subwidget;c {r:     PaneWidget pane = (PaneWidget) subwidget->core.parent;     Widget cursubwidget;$     Constraints subdata, cursubdata;     int i, position;  l  0N     /* check for mullion class here since when we create the mullion this codeK      * will get called again. Get the desired length from the actual length=M      * and then create a mullion for this widget. Finally position the widget_      * where the user wants it      */ 2     if (XtClass(subwidget) != mullionWidgetClass)  	{4 	subdata = (Constraints)subwidget->core.constraints;& 	subdata->dlength = Length(subwidget); 	if (subdata->max == 0) ! 	    subdata->max = resource_max;o 	if (subdata->min == 0)X! 	    subdata->min = resource_min;n" 	if (subdata->max < subdata->min) ! 	    subdata->max = subdata->min;f  t^ 	subdata->mullion = XtCreateWidget("mullion", (WidgetClass) mullionWidgetClass, (Widget) pane,) 				       (ArgList) NULL, (Cardinal) 0);a! 	XtManageChild(subdata->mullion);; 	if (subdata->position)= 	    {> 	    position = subdata->position + ((NumChildren(pane)+1)/2);* 	    if (position > (NumChildren(pane)+1)) 		{s# 		position = (NumChildren(pane)+1);  		}r 	    } 	else  	    {' 	    position = (NumChildren(pane)+1);   	    }; 	subdata->position = position - ((NumChildren(pane)+1)/2); t 	position--; 	} i	     else 0 	{" 	position = (NumChildren(pane)/2); 	}     Children(pane) =  8         (WidgetList) XtRealloc((caddr_t) Children(pane),:     	(unsigned) (NumChildren(pane) + 1) * sizeof(Widget));  r6     /* Ripple children up one space from "position" */2     for (i = NumChildren(pane); i > position; i--) 	{; 	if (XtClass (Children(pane)[i-1]) != mullionWidgetClass && / 	    XtClass (subwidget) != mullionWidgetClass)p 	    {( 	    cursubwidget = Children(pane)[i-1];> 	    cursubdata = (Constraints)cursubwidget->core.constraints; 	    /* E 	     * Check to see if the position of the current subwidget is less*F 	     * than that of the subwidget we are creating. If it is then thatF 	     * means there are other subwidgets below this one which are alsoA 	     * shared and I should exit at this point to store this new t* 	     * subwidget in the list of children. 	     */2 	    if (cursubdata->position < subdata->position) 		{e 		break; 		}a
 	    else  		{i 		/*> 		 * Check to see if the position of the current subwidget and9 		 * the created subwidget are the same. If they are and s3 		 * the new one is shared, then set the old one toa> 		 * shared as well. Also set the current subwidgets inview to, 		 * false if the subwidget will be in view. 		 *? 		 * Otherwise, if the subwidget isn't shared the new one just e; 		 * wants the currents ones position so bump it up by one.V 		 */)5 		if ((cursubdata->position == subdata->position) &&  * 			(subdata->sharedflag & SharedPaneMask)) 		    {c4 		    if (subdata->sharedflag & ViewableInPaneMask)  			{+ 			cursubdata->sharedflag = SharedPaneMask;d 			}
 		    else 			{ 			/* 8 			 * Only set those that aren't shared. Those that are 7 			 * shared are already set and since the new one doesb7 			 * not want to be viewable we will just keep what we* 			 * have.( 			 */2 			if (cursubdata->sharedflag == NoSharedPaneMask) 			    {D 			    cursubdata->sharedflag = SharedPaneMask | ViewableInPaneMask; 			    } 			} 		    }e3 		else if (subdata->sharedflag == NoSharedPaneMask)d 		    {  		    cursubdata->position++;e 		    }c 		} /* end else */ 	    } /* end if */*0         Children(pane)[i] = Children(pane)[i-1]; 	}"     Children(pane)[i] = subwidget;     NumChildren(pane)++;%     PaneChildren(pane) = (WidgetList)t& 	XtRealloc((char *)PaneChildren(pane),3 		  (Cardinal) NumChildren(pane) * sizeof(Widget));t  c9     /* this allows text widgets tabs to work like normal        */tH     if (OverrideText(pane) && XtIsSubclass(subwidget, textwidgetclass))  	{9 	XtOverrideTranslations(subwidget, compiledtextbindings);V  	if (LastHadFocus(pane) == NULL)$ 	    LastHadFocus(pane) = subwidget; 	}I     if (XtHasCallbacks(subwidget, DwtNfocusCallback) != XtCallbackNoList)i8 	XtAddCallbacks(subwidget, DwtNfocusCallback, focus_cb); }w           /*   * A subwidget has been removed.  */e  i# static void DeleteChild(subwidget)   Widget subwidget;  {/:     PaneWidget pane = (PaneWidget) subwidget->core.parent;     Constraints subdata;     int i, position;  m /*H  * Destroy will destroy mullion and the child. If it is a mullion being <  * deleted skip the stuff about subdata and shared position.  */ 2     if (XtClass(subwidget) != mullionWidgetClass)  	{% 	subdata = DataFromWidget(subwidget);e     /* t      * destory the mullion        */i$ 	XtDestroyWidget (subdata->mullion); 	} /*@  * Ok now we need to remove this widget from the composite list   *//A     for (position = 0; position < NumChildren(pane); position++) n 	{4         if (Children(pane) [position] == subwidget)  	    {             break; 	    } 	}  i.     if (position == NumChildren(pane)) return;   8     /* Ripple children down one space from "position" */     NumChildren(pane)--;3     for (i = position; i < NumChildren(pane); i++) U 	{2         Children(pane) [i] = Children(pane) [i+1]; 	} }      d i7 /*---------------------------------------------------*/s7 /* this routine will be called from the widget's     */a7 /* main event handler via the translation manager.   */a7 /*---------------------------------------------------*/   G static void Help(w, event)	 Widget w;  XEvent *event; {      DwtAnyCallbackStruct temp;  -%     temp.reason = DwtCRHelpRequested;a     temp.event = event;a  a4     if (XtClass(w) == (WidgetClass) panewidgetclass) 	{1     	XtCallCallbacks(w, DwtNhelpCallback, &temp);( 	}     else 	{7 	XtCallCallbacks(XtParent(w), DwtNhelpCallback, &temp);	 	};( }p  - n /*J  *************************************************************************  *  * Public creation entry points   *J  *************************************************************************  */a /*  * low level create entry pointF  */w  n& Widget DwtPaneCreate (p, name, al, ac)%     Widget  p;				/* parent widget */p+     char    *name;			/* pane widget name */o     ArgList al;      Cardinal ac;     { J     return XtCreateWidget(name, (WidgetClass) panewidgetclass, p, al, ac); }     #ifdef  VMSe, Widget DWT$PANE_CREATE (p, name$dsc, al, ac)%     Widget			*p;		/* parent widget */e*     struct dsc$descriptor_s    	*name$dsc;     ArgList			al;x     int				*ac;      {      PaneWidget pane;     char *name;a  s,     name  = DwtDescToNull(name$dsc);        Y     pane = (PaneWidget) XtCreateWidget(name, (WidgetClass) panewidgetclass, *p, al, *ac);         XtFree(name);n     return (Widget) pane;S }n #endif  /* VMS */      I /*!  * high level pane create routine   */   a Widget DwtHVPane(p, 
 	      name,  
 	      x, y, n 	      width, height,a 	      orientation,/! 	      mapcallback, helpcallback)e  *,     Widget         p;				/* parent widget */1     char          *name;			/* pane widget name */l5     Position	   x, y;			/* location of pane widget */d:     Dimension	   width, height;		/* size of pane widget */4     int		   orientation;			/* horizontal or vertical@     DwtCallbackPtr mapcallback;			/* callback for data struct */6     DwtCallbackPtr helpcallback;		/* help requested */ {S     Arg al[25];e     Cardinal ac = 0;  l     /*)      * set up the parameters we are given       */h  e-     XtSetArg (al[ac], XtNname,		name);		ac++; '     XtSetArg (al[ac], XtNx,		x);		ac++;n'     XtSetArg (al[ac], XtNy,		y);		ac++;i/     XtSetArg (al[ac], XtNwidth,		width);		ac++; /     XtSetArg (al[ac], XtNheight,	height);	ac++;t:     XtSetArg (al[ac], DwtNorientation,	orientation);	ac++;  d  C     if (mapcallback != NULL) r 	{5 	XtSetArg (al[ac], DwtNmapCallback,     mapcallback);b 	ac++; 	}        if (helpcallback != NULL)  	{6 	XtSetArg (al[ac], DwtNhelpCallback,    helpcallback); 	ac++; 	}  /K     return XtCreateWidget (name, (WidgetClass) panewidgetclass, p, al, ac);* }    #ifdef  VMS  Widget DWT$H_V_PANE(p, s 	      name$dsc,  
 	      x, y, e 	      width, height,n 	      orientation,h! 	      mapcallback, helpcallback)r  -,     Widget        *p;				/* parent widget */?     struct dsc$descriptor_s  	*name$dsc;	/* form widget name */t6     Position	  *x, *y;			/* location of form widget */:     Dimension	  *width, *height;		/* size of the widget */1     int		  *orientation;			/* pane orientation */ 0     DwtCallbackPtr *mapcallback;		/* callback */7     DwtCallbackPtr *helpcallback;		/* help requested */c {e     PaneWidget pane;     Arg al[25];g     int ac = 0;s     char    *name;   $     name  = DwtDescToNull(name$dsc);     /*)      * set up the parameters we are givenl      */a  ;5     XtSetArg (al[ac], XtNname,	      name);	    ac++; -     XtSetArg (al[ac], XtNname,		name);		ac++; '     XtSetArg (al[ac], XtNx,		x);		ac++; '     XtSetArg (al[ac], XtNy,		y);		ac++;-/     XtSetArg (al[ac], XtNwidth,		width);		ac++;-/     XtSetArg (al[ac], XtNheight,	height);	ac++; :     XtSetArg (al[ac], DwtNorientation,	orientation);	ac++;     m     if (mapcallback != NULL) a 	{5 	XtSetArg (al[ac], DwtNmapCallback,     mapcallback);h 	ac++; 	}  a     if (helpcallback != NULL)  	{6 	XtSetArg (al[ac], DwtNhelpCallback,    helpcallback); 	ac++; 	}  nX     pane = (PaneWidget)XtCreateWidget (name, (WidgetClass) panewidgetclass, *p, al, ac);  (     XtFree(name);{     return (Widget) pane;n }> #endif  /* VMS */      f /*%  * high level pane add widget routineU  */n  >K void DwtPaneAddWidget(subwidget, position, min, max, resizable, sharedflag)t     Widget	subwidget;l     Cardinal	position;     Dimension	min, max;u     Boolean	resizable;     Cardinal	sharedflag; {r     XWindowChanges changes;}:     PaneWidget	pane = (PaneWidget) subwidget->core.parent;     Widget	cursubwidget;1     Constraints subdata, cursubdata, cursubdata2;d'     int		i, curpos, lastsharedposition;oE     Boolean	subnotfound=TRUE, subnotplaced=TRUE, cursubnotreset=TRUE;e  b /*.  * Get the position the window is currently in  */o(     subdata = DataFromWidget(subwidget);     curpos = subdata->position;n    /*N  * Compare that to the position the user desires and change the windows around  */w)     if (position > (NumChildren(pane)/2))w" 	position = (NumChildren(pane)/2);,     if (position != curpos && position != 0) 	{ 	if (position < curpos)* 	    {6 	    for (i = NumChildren(pane); i >= position*2; i--) 		{l% 		cursubwidget = Children(pane)[i-1];n, 		cursubdata = DataFromWidget(cursubwidget); 		/* RB 		 * Check to see if the position of the current subwidget is less3 		 * than that of the subwidget. If it is then thattC 		 * means there are other subwidgets below this one which are alsop> 		 * shared and I should exit at this point to store this new ' 		 * subwidget in the list of children.W 		 */=& 		if (cursubdata->position < position) 		    { $ 		    Children(pane)[i] = subwidget;# 		    subdata->position = position;t 		    break; 		    }n 		/*> 		 * if subwidget came from a shared position we need to make ? 		 * sure that at least one of the old widgets that shared the m# 		 * position will now be displayedo 		 */m3 		if (cursubdata->position == subdata->position && =( 			subdata->sharedflag & SharedPaneMask) 		    {a 		    if (cursubnotreset)b 			{@ 			cursubdata->sharedflag = SharedPaneMask | ViewableInPaneMask; 			cursubnotreset = FALSE; 			} 		    }e 		/*' 		 * move the subwidgets up one unless  B 		 * the current subwidget is subwidget we are trying to change or8 		 * the current subs position > the current position or 		 */ / 		if (cursubwidget == subwidget || subnotfound)i 		    {i$ 		    if (cursubwidget == subwidget) 			{ 			subnotfound = FALSE;  			continue; 			} 		    }h 		else 		    {s. 		    Children(pane)[i] = Children(pane)[i-1]; 		    }N 		/*> 		 * Reposition the current subwidgets position as appropriate 		 */r 		if (subnotfound) 		    {h 		    /*@ 		     * This is a little tricky here. This will before you find: 		     * the subwidget. If the subwidget was not formerly E 		     * shared and is not to be shared || the subwidget was formerly B 		     * shared and will be shared at its new position we will notA 		     * change the position. For the other two conditions we do.tB 		     * In one case it is necessary to subtract and the other add 		     * to the position	 		     */*6 		    if ((subdata->sharedflag == NoSharedPaneMask) &&! 			(sharedflag & SharedPaneMask))( 			    cursubdata->position--;8 		    else if ((subdata->sharedflag & SharedPaneMask) &&$ 			(sharedflag == NoSharedPaneMask)) 			    cursubdata->position++; 		    }  		else 		    {  		    /*B 		     * Only change the position if our subwidget wont be shared.7 		     * Otherwise the position will still be occupied.]	 		     */C) 		    if (sharedflag == NoSharedPaneMask)  			cursubdata->position++; 		    }a 		/*> 		 * Check to see if the position of the current subwidget and@ 		 * the subwidget's new position are the same. If they are and 3 		 * the new one is shared, then set the old one to > 		 * shared as well. Also set the current subwidgets inview to, 		 * false if the subwidget will be in view. 		 *? 		 * Otherwise, if the subwidget isn't shared the new one just k; 		 * wants the currents ones position so bump it up by one.n 		 */)) 		if(cursubdata->position == position && a 			sharedflag & SharedPaneMask)W 		    {d+ 		    if (sharedflag & ViewableInPaneMask)   			{+ 			cursubdata->sharedflag = SharedPaneMask;c 			}
 		    else 			{ 			/* 8 			 * Only set those that aren't shared. Those that are 7 			 * shared are already set and since the new one doesm7 			 * not want to be viewable we will just keep what wei 			 * have.) 			 */2 			if (cursubdata->sharedflag == NoSharedPaneMask) 			    {D 			    cursubdata->sharedflag = SharedPaneMask | ViewableInPaneMask; 			    } 			} 		    }  		}   /* end for loop */ 	    } 	else	/* position > curpos */o 	    {H 	    for (i = (NumChildren(pane)/2)+curpos; i <= NumChildren(pane); i++) 		{ % 		cursubwidget = Children(pane)[i-1];i, 		cursubdata = DataFromWidget(cursubwidget); 		/*A 		 * Even though you start at the current position it is possibletA 		 * for the position to be less than the current position due tor 		 * shared panes. 		 */a@ 		if (cursubdata->position < curpos || cursubwidget == subwidget 		    || (subnotfound))	 		    {k$ 		    if (cursubwidget == subwidget) 			    subnotfound = FALSE;d 		    continue;  		    }h 		/*> 		 * if subwidget came from a shared position we need to make ? 		 * sure that at least one of the old widgets that shared the i# 		 * position will now be displayed  		 */a3 		if (cursubdata->position == subdata->position && e( 			subdata->sharedflag & SharedPaneMask) 		    {w 		    if (cursubnotreset)p 			{@ 			cursubdata->sharedflag = SharedPaneMask | ViewableInPaneMask; 			cursubnotreset = FALSE; 			} 		    }u 		/*' 		 * move the subwidgets up one unless dB 		 * the current subwidget is subwidget we are trying to change or8 		 * the current subs position > the desired position or@ 		 * the current subs position = the desired postion and the sub2 		 *   we were working with was previously shared. 		 */d( 		if (cursubdata->position > position ||2 		     ((subdata->sharedflag & SharedPaneMask) && + 		       cursubdata->position == position))W 		    {i	 		    /* t; 		     * Place subwidget only once after you moved all subsh	 		     */	 		    if (subnotplaced)  			{# 			Children(pane)[i-2] = subwidget;r  			subdata->position = position; 			subnotplaced=FALSE; 			} 		    }  		else 		    {p0 		    Children(pane)[i-2] = Children(pane)[i-1]; 		    }( 		/*> 		 * Reposition the current subwidgets position as appropriate 		 */c 		if (subnotplaced)l 		    {t 		    /*A 		     * Only change the position if our subwidget wasn't shared.s7 		     * Otherwise the position will still be occupied. 	 		     */e2 		    if (subdata->sharedflag == NoSharedPaneMask) 			cursubdata->position--; 		    }  		else 		    {s 		    /*A 		     * This is a little tricky here. This will happen after youuA 		     * placed the subwidget. If the subwidget was not formerly bE 		     * shared and is not to be shared || the subwidget was formerly;B 		     * shared and will be shared at its new position we will notA 		     * change the position. For the other two conditions we do.cB 		     * In one case it is necessary to subtract and the other add 		     * to the position	 		     */u6 		    if ((subdata->sharedflag == NoSharedPaneMask) &&! 			(sharedflag & SharedPaneMask))  			    cursubdata->position--;8 		    else if ((subdata->sharedflag & SharedPaneMask) &&$ 			(sharedflag == NoSharedPaneMask)) 			    cursubdata->position++; 		    }  		/*> 		 * Check to see if the position of the current subwidget and@ 		 * the subwidget's new position are the same. If they are and 3 		 * the new one is shared, then set the old one tob> 		 * shared as well. Also set the current subwidgets inview to, 		 * false if the subwidget will be in view. 		 *? 		 * Otherwise, if the subwidget isn't shared the new one just C; 		 * wants the currents ones position so bump it up by one.  		 */t) 		if(cursubdata->position == position && e 			sharedflag & SharedPaneMask)m 		    {p+ 		    if (sharedflag & ViewableInPaneMask) e 			{+ 			cursubdata->sharedflag = SharedPaneMask;  			}
 		    else 			{ 			/* 8 			 * Only set those that aren't shared. Those that are 7 			 * shared are already set and since the new one doesN7 			 * not want to be viewable we will just keep what we  			 * have.X 			 */2 			if (cursubdata->sharedflag == NoSharedPaneMask) 			    {D 			    cursubdata->sharedflag = SharedPaneMask | ViewableInPaneMask; 			    } 			} 		    }i 		}   /* end for loop */
 	    }			      	/*iD 	 * Now that the position has been properly set we can take care of  	 * the shared flag. o 	 */" 	subdata->sharedflag = sharedflag; 	/*lB 	 * Just for grins lets loop back through and make sure that if a 2 	 * subwidget says that it is shared it really is. 	 */7 	for (i=NumChildren(pane)/2; i<NumChildren(pane); i++) f 	    {& 	    cursubwidget = Children(pane)[i];/ 	    cursubdata = DataFromWidget(cursubwidget);w1 	    if (cursubdata->sharedflag & SharedPaneMask)l 		{t? 		if (i+1 != NumChildren(pane))	/* Dont check passed bountry */  		    {e8 		    cursubdata2 = DataFromWidget(Children(pane)[i+1]);8 		    if (cursubdata->position == cursubdata2->position)- 			lastsharedposition = cursubdata->position;b 		    }d1 		if (lastsharedposition != cursubdata->position)a 		    { 0 		    cursubdata->sharedflag = NoSharedPaneMask;2 		    XtSetMappedWhenManaged (cursubwidget, TRUE); 		    }e 		}  	    } 	}     else 	{ 	/*lG 	 * There was no change in position so if the user wants this subwidget & 	 * to be viewable lets do it for him. 	 */% 	if (sharedflag & ViewableInPaneMask)f% 	    DwtPaneMakeViewable (subwidget);i 	}  &#     subdata->resizable = resizable;a     if (max == 0)  	max = resource_max;     if (min == 0)n 	min = resource_min;     if (max < min)   	max = min;a     if (subdata->resizable)  	{ 	subdata->min = min; 	subdata->max = max; 	}      if (subwidget->core.managed) 	{ 	PaneNumChildren(pane) = 0;e7 	for (i=NumChildren(pane)/2; i<NumChildren(pane); i++) w 	    {& 	    cursubwidget = Children(pane)[i];/ 	    cursubdata = DataFromWidget(cursubwidget);r  d     /* eO      * Recreate the PaneChildren list by only adding those subwidgets which are H      * managed and if shared, are in view. If a subwidget fails the testU      * move his mullion into oblivion. Like the rest of the mullions that don't need i      * to be seen.      */ ' 	    if (cursubwidget->core.managed && u4 		    (cursubdata->sharedflag == NoSharedPaneMask ||G 		    cursubdata->sharedflag == (SharedPaneMask | ViewableInPaneMask)))p 		{*. 		if (cursubdata->sharedflag & SharedPaneMask) 		    {a2 		    XtSetMappedWhenManaged (cursubwidget, TRUE); 		    })? 		PaneChildren(pane)[(PaneNumChildren(pane))++] = cursubwidget;a 		}i	 	    elsee 		{m 		/*, 		 * UnMap any shared panes that aren't used 		 */ . 		if (cursubdata->sharedflag & SharedPaneMask) 		    {c3 		    XtSetMappedWhenManaged (cursubwidget, FALSE);i: 		    XtSetMappedWhenManaged (cursubdata->mullion, FALSE); 		    }  		else 		    {s 		    /*. 		     * Move the mullion widget into oblivion	 		     */e" 		    changes.x = changes.y = -99;6 		    if (changes.x != cursubdata->mullion->core.x || 0 			    changes.y != cursubdata->mullion->core.y) 			{+ 			cursubdata->mullion->core.x = changes.x;I+ 			cursubdata->mullion->core.y = changes.y; ) 			if (XtIsRealized(cursubdata->mullion))*8 			    XConfigureWindow(XtDisplay(cursubdata->mullion), < 				    XtWindow(cursubdata->mullion), CWX | CWY, &changes); 			} 		    }n 		}  	    } /* end for loop */u$ 	} /* end if subwidget is managed */     /*M      * Ok now you only have those children that are managed so fill the pane.t      */C /*O  * Check to see if the dlength for the subwidget is greater than the max. If it O  * is then I must call RefigureDlengths instead of TryToFillPane. TryToFillPaneeO  * will use the current length which hasn't been change so it will pass a deltaCN  * change to RefigureDlengths of 0 which does zippo. Since I know the amount I;  * need to change I'll just call RefigureDlengths directly.d  */ % 	if (subdata->dlength > subdata->max)- 	    {I 	    RefigureDlengths (pane, subwidget, subdata->dlength - subdata->max);  	    }* 	else if (subdata->dlength < subdata->min) 	    {I 	    RefigureDlengths (pane, subwidget, subdata->dlength - subdata->min);n 	    } 	else  	    { 	    TryToFillPane(pane);a 	    }% 	CommitNewSizes(pane, (Widget) NULL);R }e   #ifdef  VMS $ void DWT$PANE_ADD_WIDGET(subwidget,  	      position, 	      min, max,   	      resizable,b 	      sharedflag)  k,     Widget        *subwidget;			/* widget */;     Cardinal	  *position;			/* position of the subwidget */*@     Dimension	  *min, *max;			/* min & max size of the widget */:     Boolean	  *resizable;			/* is the widget resizeable *//     Cardinal	  *sharedflag;			/* shared flag */* {*M     DwtPaneAddWidget (*subwidget,*position,*min,*max,*resizable,*sharedflag);t }e #endif  /* VMS */   )* void DwtPaneGetMinMax(subwidget, min, max) Widget subwidget;/ Dimension *min, *max;  {      Constraints subdata;(     subdata = DataFromWidget(subwidget);     if (subdata) { 	*min = subdata->min;c 	*max = subdata->max;e
     } else7 	XtWarning("DwtPaneGetMinMax called with bad widget.");p }n   #ifdef  VMS % void DWT$PANE_GET_MIN_MAX(subwidget, ; 	      min, max)+     Widget        subwidget;			/* widget */p@     Dimension	  *min, *max;			/* min & max size of the widget */ {      Constraints subdata;(     subdata = DataFromWidget(subwidget);     if (subdata) { 	*min = subdata->min;n 	*max = subdata->max;g
     } else7 	XtWarning("DwtPaneGetMinMax called with bad widget.");e }  #endif  /* VMS */   g D /*I  * NOTE: In setting the min or max in DwtPaneSetMinMax, DwtPaneSetMin, oriF  *	DwtPaneSetMax we donot check for valid min, max values. Values lessC  *	than 1 will certianly cause stack dumps and min > max will also aC  *	cause some form of headache, though I haven't tried it yet. MostiC  *	DW code doesn't check for valid attributes so I see no reason toe  *	do so here either.l  */e  c* void DwtPaneSetMinMax(subwidget, min, max) Widget subwidget;c Dimension min, max;P {h:     PaneWidget pane = (PaneWidget) subwidget->core.parent;     Constraints subdata;  *     if (max == 0)  	max = resource_max;     if (min == 0)  	min = resource_min;     if (max < min)   	max = min;g(     subdata = DataFromWidget(subwidget);     if (subdata->resizable)  	{ 	subdata->min = min; 	subdata->max = max; 	}  -     if (subdata->sharedflag & SharedPaneMask)  	{ 	Widget subwidget2;r 	Constraints subdata2; 	int i, visable_child=NULL;l  < 	for (i=(NumChildren(pane)+1)/2 ; i<NumChildren(pane); i++)  	    {$ 	    subwidget2 = Children(pane)[i];3 	    if (XtClass (subwidget) == mullionWidgetClass)c 		{  		continue;; 		}++ 	    subdata2 = DataFromWidget(subwidget2);(5 	    if ((subdata2->position != subdata->position) ||f 		(subwidget2 == subwidget)) 		{  		continue;, 		};" 	    subdata2->min = subdata->min;" 	    subdata2->max = subdata->max;3 	    if (subdata2->sharedflag & ViewableInPaneMask)/ 		{e 		visable_child = i; 		}c 	    } 	if (visable_child != NULL)d 	    {/ 	    subwidget = Children(pane)[visable_child];m) 	    subdata = DataFromWidget(subwidget);; 	    } 	}B     /* only try to fill pane and commit sizes if we really need to      */lK     if (subdata->dlength < subdata->min || subdata->dlength > subdata->max)  	{ /*O  * Check to see if the dlength for the subwidget is greater than the max. If itrO  * is then I must call RefigureDlengths instead of TryToFillPane. TryToFillPaneaO  * will use the current length which hasn't been change so it will pass a delta	N  * change to RefigureDlengths of 0 which does zippo. Since I know the amount I;  * need to change I'll just call RefigureDlengths directly.-  */ % 	if (subdata->dlength > subdata->max)c 	    {I 	    RefigureDlengths (pane, subwidget, subdata->dlength - subdata->max);r 	    }* 	else if (subdata->dlength < subdata->min) 	    {I 	    RefigureDlengths (pane, subwidget, subdata->dlength - subdata->min);+ 	    } 	else  	    { 	    TryToFillPane(pane);S 	    }% 	CommitNewSizes(pane, (Widget) NULL);k 	} }+    #ifdef  VMSa% void DWT$PANE_SET_MIN_MAX(subwidget, ( 	      min, max),     Widget        *subwidget;			/* widget */@     Dimension	  *min, *max;			/* min & max size of the widget */ {*+     DwtPaneSetMinMax(*subwidget,*min,*max);> }o #endif  /* VMS */   B void DwtPaneSetConstraints(subwidget, min, max, height, resizable) Widget subwidget;n Dimension min, max, height;i Boolean resizable; {e:     PaneWidget pane = (PaneWidget) subwidget->core.parent;     Constraints subdata;        if (max == 0)i 	max = resource_max;     if (min == 0)e 	min = resource_min;     if (max < min) r 	max = min;   (     subdata = DataFromWidget(subwidget);     subdata->min = min;      subdata->max = max;n  B     /* only try to fill pane and commit sizes if we really need to      */ #     if (subdata->dlength != height); 	{ /*O  * Check to see if the dlength for the subwidget is greater than the max. If itrO  * is then I must call RefigureDlengths instead of TryToFillPane. TryToFillPanewO  * will use the current length which hasn't been change so it will pass a delta)N  * change to RefigureDlengths of 0 which does zippo. Since I know the amount I;  * need to change I'll just call RefigureDlengths directly.   */s 	if (subdata->dlength > height)g 	    {C 	    RefigureDlengths (pane, subwidget, subdata->dlength - height);e 	    }$ 	else if (subdata->dlength < height) 	    {C 	    RefigureDlengths (pane, subwidget, subdata->dlength - height);s 	    } 	else  	    { 	    TryToFillPane(pane);s 	    }% 	CommitNewSizes(pane, (Widget) NULL);h 	}#     subdata->resizable = resizable;i }< s" void DwtPaneSetMin(subwidget, min) Widget subwidget;  Dimension min; {t:     PaneWidget pane = (PaneWidget) subwidget->core.parent;     Constraints subdata;     if (min == 0)m 	min = resource_min;(     subdata = DataFromWidget(subwidget);     if (subdata->resizable)w 	{ 	subdata->min = min;! 	if (subdata->max < subdata->min)-! 	    subdata->max = subdata->min;l 	}  -     if (subdata->sharedflag & SharedPaneMask)s 	{ 	Widget subwidget2;- 	Constraints subdata2; 	int i, visable_child=NULL;	  < 	for (i=(NumChildren(pane)+1)/2 ; i<NumChildren(pane); i++)  	    {$ 	    subwidget2 = Children(pane)[i];3 	    if (XtClass (subwidget) == mullionWidgetClass)t 		{r 		continue;i 		}>+ 	    subdata2 = DataFromWidget(subwidget2);b5 	    if ((subdata2->position != subdata->position) ||f 		(subwidget2 == subwidget)) 		{  		continue;d 		};" 	    subdata2->min = subdata->min;3 	    if (subdata2->sharedflag & ViewableInPaneMask)p 		{i 		visable_child = i; 		}R 	    } 	if (visable_child != NULL)t 	    {/ 	    subwidget = Children(pane)[visable_child]; ) 	    subdata = DataFromWidget(subwidget);h 	    } 	}  (     if (subdata->dlength < subdata->min) 	{E 	RefigureDlengths (pane, subwidget, subdata->dlength - subdata->min); % 	CommitNewSizes(pane, (Widget) NULL);* 	} }     #ifdef  VMSd% void DWT$PANE_SET_MIN(subwidget, min) ,     Widget        *subwidget;			/* widget */5     Dimension	  *min;				/* min size of the widget */  {t#     DwtPaneSetMin(*subwidget,*min);h }o #endif  /* VMS */   " void DwtPaneSetMax(subwidget, max) Widget subwidget;( Dimension max; {P:     PaneWidget pane = (PaneWidget) subwidget->core.parent;     Constraints subdata;     if (max == 0)( 	max = resource_max;(     subdata = DataFromWidget(subwidget);     if (max < subdata->min)  	max = subdata->min;     if (subdata->resizable)s 	{ 	subdata->max = max; 	}-     if (subdata->sharedflag & SharedPaneMask)i 	{ 	Widget subwidget2;f 	Constraints subdata2; 	int i, visable_child=NULL;s  < 	for (i=(NumChildren(pane)+1)/2 ; i<NumChildren(pane); i++)  	    {$ 	    subwidget2 = Children(pane)[i];3 	    if (XtClass (subwidget) == mullionWidgetClass)e 		{o 		continue;  		}s+ 	    subdata2 = DataFromWidget(subwidget2); 5 	    if ((subdata2->position != subdata->position) ||  		(subwidget2 == subwidget)) 		{	 		continue;  		};" 	    subdata2->max = subdata->max;3 	    if (subdata2->sharedflag & ViewableInPaneMask)  		{  		visable_child = i; 		}u 	    } 	if (visable_child != NULL)s 	    {/ 	    subwidget = Children(pane)[visable_child];l) 	    subdata = DataFromWidget(subwidget);d 	    } 	}(     if (subdata->dlength > subdata->max) 	{E 	RefigureDlengths (pane, subwidget, subdata->dlength - subdata->max); % 	CommitNewSizes(pane, (Widget) NULL);n 	} }d  m #ifdef  VMSa% void DWT$PANE_SET_MAX(subwidget, max)t,     Widget        *subwidget;			/* widget */5     Dimension	  *max;				/* max size of the widget */u {t#     DwtPaneSetMax(*subwidget,*max);a }I #endif  /* VMS */  	3 /* this needs to be incorporated into set values */	* void DwtPaneAllowResizing(pane, allowtype) PaneWidget pane; int allowtype; {=!     ResizeMode(pane) = allowtype;u(     if (!allowtype) TryToFillPane(pane); }a  =  t o# void DwtPaneMakeViewable(subwidget)e Widget subwidget;a {h:     PaneWidget pane = (PaneWidget) subwidget->core.parent;$     Constraints cursubdata, subdata;-     Widget cursubwidget, curmullion, mullion;a     XWindowChanges changes;u(     int	viewable, notviewable, position;  	 /*H  * The current subwidget is the one occuppying the same position in the L  * PaneChildren Widget list. If not then we need to go down the list till we-  * find the one that is sharing this positionn  */t(     subdata = DataFromWidget(subwidget);@     for (position = subdata->position; position > 0; position--) 	{1 	cursubwidget = PaneChildren(pane)[position - 1];e+ 	cursubdata = DataFromWidget(cursubwidget);t/ 	if (cursubdata->position == subdata->position)a 	    break;I 	};M  ; /*N  * If this subwidget is the one currently displayed or is not in a shared paneA  * or it is not managed then don't bother doing any of this work.c  */ A     if (subwidget == cursubwidget || !subwidget->core.managed || t- 	    subdata->sharedflag == NoSharedPaneMask)a 	return;  	3     viewable = SharedPaneMask | ViewableInPaneMask;*!     notviewable = SharedPaneMask;s  o /*D  * Get the subdata of widget currently viewable and set the mullions  */p%     curmullion = cursubdata->mullion;      mullion = subdata->mullion;l  n  a /*9  * Set the changes based on the current widget attributes   */ %     changes.x = cursubwidget->core.x;	%     changes.y = cursubwidget->core.y;o-     changes.width = cursubwidget->core.width;p/     changes.height = cursubwidget->core.height;;     changes.border_width = 0;oK     if (changes.x != subwidget->core.x || changes.y != subwidget->core.y ||l, 	  changes.width != subwidget->core.width ||. 	  changes.height != subwidget->core.height ||9 	  changes.border_width != subwidget->core.border_width)   	{ 	subwidget->core.x = changes.x;= 	subwidget->core.y = changes.y;-' 	subwidget->core.width = changes.width; ) 	subwidget->core.height = changes.height;h5 	subwidget->core.border_width = changes.border_width;u! 	if (XtIsRealized(subwidget))    o 	    {@ 	    XConfigureWindow(XtDisplay(subwidget), XtWindow(subwidget),6 			     CWX |CWY | CWWidth | CWHeight | CWBorderWidth, 			     &changes); 	    }B 	if (XtClass(subwidget)->core_class.resize != (XtWidgetProc) NULL) 	    {E 	    (*(subwidget->core.widget_class->core_class.resize))(subwidget);i 	    } 	}  u /*A  * Set the current widgets and subwidget's shared pane attributesg  */a)     cursubdata->sharedflag = notviewable;-#     subdata->sharedflag = viewable;a   /*G  * Set the min and the max values based on the currently visable widget-  */t#     subdata->min = cursubdata->min; #     subdata->max = cursubdata->max;b  g /*P  * Unmap the current widget and map the subwidget by setting mapped_when_managed  */i-     XtSetMappedWhenManaged (subwidget, TRUE); 1     XtSetMappedWhenManaged (cursubwidget, FALSE);   * /*L  * If the cursubwidget was the last to have focus change it to the subwidget  */s+     if (LastHadFocus(pane) == cursubwidget)e  	LastHadFocus(pane) = subwidget;  e /*;  * Set the changes based on the current mullions attributesf  */ #     changes.x = curmullion->core.x;(#     changes.y = curmullion->core.y;	F     if (changes.x != mullion->core.x || changes.y != mullion->core.y)  	{ 	mullion->core.x = changes.x;  	mullion->core.y = changes.y; ! 	if (XtIsRealized(subwidget))    n 	    {< 	    XConfigureWindow(XtDisplay(mullion), XtWindow(mullion), 			     CWX | CWY, &changes);  	    } 	} /*P  * Unmap the current widget and map the subwidget by setting mapped_when_managed  */e+     XtSetMappedWhenManaged (mullion, TRUE);	/     XtSetMappedWhenManaged (curmullion, FALSE);   i2     PaneChildren(pane)[position -  1] = subwidget;      }   e #ifdef  VMS & void DWT$PANE_MAKE_VIEWABLE(subwidget),     Widget        *subwidget;			/* widget */ {o$     DwtPaneMakeViewable(*subwidget); }  #endif  /* VMS */   $ unsigned int PaneInitializeForDRM () {=	 int	stat;(  eP /*  Initialize DRM                                                            */P /*  This MUST be done before the XtInitialize call...                         */P /*                                                                            */ DwtInitializeDRM ();   5 stat = DwtRegisterClass (DRMwcUnknown, "pane_widget", 3 	"DwtPaneCreate", DwtPaneCreate,  panewidgetclass);   l if (stat != DRMSuccess)b 	{. 	printf ("pane widget registration failed\n");
 	return stat;> 	};i  a return stat; }  sL #define AcceptFocusProc(w) ((w)->core.widget_class->core_class.accept_focus)# static Boolean AcceptFocus(w, time) 	 Widget w;e Time *time;  {h%     PaneWidget pane = (PaneWidget) w; 
     int i;     Boolean took_focus;   %     if (LastHadFocus(pane) == NULL) {s 	for (i=0 ;i< 	     i<PaneNumChildren(pane) && LastHadFocus(pane) == NULL; 	     i++) {0 	    if (AcceptFocusProc(PaneChildren(pane)[i]))- 		LastHadFocus(pane) = PaneChildren(pane)[i];= 	}: 	if (LastHadFocus(pane) == NULL) return ((Boolean) FALSE);     }s4     if (AcceptFocusProc(LastHadFocus(pane)) != NULL) 	{O 	took_focus = (*AcceptFocusProc(LastHadFocus(pane)))(LastHadFocus(pane), time);u 	return (took_focus);m 	}     return ((Boolean) FALSE);  }r  w  e   static void GrabFocus(w, event)t	 Widget w;m XEvent *event; {)     Time time;   A     EventToTime(time,event);  /* get the time out of the event */ $     AcceptFocus(XtParent(w), &time); }      v . static void FocusNext(w, event) 	 Widget w;i XEvent *event; {v/     PaneWidget pane = (PaneWidget) XtParent(w);d     Time time;
     int i, j; A     EventToTime(time,event);  /* get the time out of the event */e,     for (i=0 ; i<PaneNumChildren(pane); i++)' 	if (PaneChildren(pane)[i] == w) break;e1     for (j=i+1 ; j<PaneNumChildren(pane) ; j++) {&6 	if (AcceptFocusProc(PaneChildren(pane)[j]) != NULL) {0 	    LastHadFocus(pane) = PaneChildren(pane)[j];% 	    AcceptFocus(XtParent(w), &time);b 	    return; 	}     }e }	    * static void FocusPrev(w, event)t	 Widget w;d XEvent *event; {s/     PaneWidget pane = (PaneWidget) XtParent(w);	     Time time;
     int i, j;sA     EventToTime(time,event);  /* get the time out of the event */o,     for (i=0 ; i<PaneNumChildren(pane); i++)' 	if (PaneChildren(pane)[i] == w) break;      for (j=i-1 ; j>=0 ; j--) {6 	if (AcceptFocusProc(PaneChildren(pane)[j]) != NULL) {0 	    LastHadFocus(pane) = PaneChildren(pane)[j];% 	    AcceptFocus(XtParent(w), &time);u 	    return; 	}     }c }g  x2 /*  DEC/CMS REPLACEMENT HISTORY, Element PANE.C */: /*  *3    30-AUG-1989 15:59:18 BRINKLEY "const removed" */6 /*  *2    29-AUG-1989 16:42:50 BRINKLEY "bug fixed" */@ /*  *1    22-AUG-1989 16:55:37 RYAN "Initial elements for V3" */2 /*  DEC/CMS REPLACEMENT HISTORY, Element PANE.C */