 #ifndef NEWS_H #define NEWS_H   /*d  * $Header: /net/objy27/wrld/mnt11/ricks/src/master/xrn/news.h,v 1.4 1993/01/11 02:15:07 ricks Exp $  */    /*$  * xrn - an X-based NNTP news reader  *G  * Copyright (c) 1988-1993, Ellen M. Sentovich and Rick L. Spickelmier.   *H  * Permission to use, copy, modify, and distribute this software and itsL  * documentation for any purpose and without fee is hereby granted, providedJ  * that the above copyright notice appear in all copies and that both thatC  * copyright notice and this permission notice appear in supporting G  * documentation, and that the name of the University of California not E  * be used in advertising or publicity pertaining to distribution of  K  * the software without specific, written prior permission.  The University G  * of California makes no representations about the suitability of this G  * software for any purpose.  It is provided "as is" without express or   * implied warranty.  *H  * THE UNIVERSITY OF CALIFORNIA DISCLAIMS ALL WARRANTIES WITH REGARD TO J  * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND H  * FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE FORK  * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER G  * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF G  * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN  ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   */     
 #ifndef AVL_H  #include "avl.h" #endif   /*#  * news.h: internal data structures   *  */     N typedef int art_num;	/* easy way to pick out variables refering to articles */O typedef short ng_num;	/* easy way to pick out newsgroup variables            */     extern avl_tree *NewsGroupTable; extern int ActiveGroupsCount;  extern avl_tree *StringPool;  + /* this is indexed via 'current - first' */  struct artStat {     unsigned int status;         /* ART_* */  };    + /* this is indexed via 'current - first' */  struct article {<     int position;	/* header/body separation point (bytes)	*/-     char *subject;      /* subject line				*/ ,     char *author;       /* author name				*/<     char *lines;        /* number of lines in the article	*/,     char *text;		/* text of the article			*/$     char *msgid;	/* message ID				*/&     char *refs[3];	/* references				*/3     art_num parent;	/* article number of parent		*/ 0     art_num child;	/* first child of a chain		*/ };     struct newsgroup {N     char *name;        /* name of the group                                 */N     ng_num newsrc;     /* index of this group into Newsrc                   */     unsigned short status;         /* NG_* */N     art_num first;     /* first available article number                    */N     art_num last;      /* last article number                               */N     art_num current;   /* current article number                            */<     art_num initial;   /* art-num when first loaded			    */G     struct artStat *artStatus;/* List of per-article status info	    */ N     struct list *nglist;  /* newsgroup entry for unsubscribed groups        */ };  5 /* handle first and/or last article number changes */ W extern void articleArrayResync _ARGUMENTS((struct newsgroup *, art_num, art_num, int)); E extern void updateArticleArray _ARGUMENTS((struct newsgroup *, int));    /*M  * NOTE: if first > last, that means that there are no articles available for -  * the group and no articles array will exist   */     ' /* article has been read / is unread */  #define ART_READ      0x0001 #define ART_UNREAD    0x0002
 /* printed */  #define ART_PRINTED   0x0004 #define ART_UNPRINTED 0x0008- /* article has been fetched / is unfetched */  #define ART_FETCHED   0x0010 #define ART_UNFETCHED 0x0020 /* article is not available */ #define ART_UNAVAIL   0x0040  
 /* headers */ # #define ART_ALL_HEADERS      0x0100 # #define ART_STRIPPED_HEADERS 0x0200    /* rotation */ #define ART_ROTATED   0x0400 #define ART_UNROTATED 0x0800   /* saved */  #define ART_SAVED   0x4000 #define ART_UNSAVED 0x8000   /* marked */ #define ART_MARKED   0x1000  #define ART_UNMARKED 0x2000    /* killed */ #define ART_KILLED   0x10000 #define ART_UNKILLED 0x20000   #define ART_ACTIVE   0x40000 #define ART_INACTIVE 0x80000   /* Translated */ #define ART_XLATED	0x100000  #define ART_UNXLATED	0x200000    #define ART_CLEAR       (ART_UNREAD | ART_UNFETCHED | ART_STRIPPED_HEADERS | ART_UNROTATED | ART_UNMARKED | ART_UNKILLED | ART_INACTIVE | ART_UNXLATED)  #define ART_CLEAR_READ  (ART_READ | ART_UNFETCHED | ART_STRIPPED_HEADERS | ART_UNROTATED | ART_UNMARKED | ART_UNKILLED | ART_INACTIVE | ART_UNXLATED)    /* helper macros */ B #define IS_READ(art)       (((art).status & ART_READ) == ART_READ)F #define IS_UNREAD(art)     (((art).status & ART_UNREAD) == ART_UNREAD)H #define IS_PRINTED(art)    (((art).status & ART_PRINTED) == ART_PRINTED)L #define IS_UNPRINTED(art)  (((art).status & ART_UNPRINTED) == ART_UNPRINTED)H #define IS_FETCHED(art)    (((art).status & ART_FETCHED) == ART_FETCHED)L #define IS_UNFETCHED(art)  (((art).status & ART_UNFETCHED) == ART_UNFETCHED)H #define IS_UNAVAIL(art)    (((art).status & ART_UNAVAIL) == ART_UNAVAIL)Q #define IS_ALL_HEADERS(art) (((art).status & ART_ALL_HEADERS) == ART_ALL_HEADERS) H #define IS_ROTATED(art)    (((art).status & ART_ROTATED) == ART_ROTATED)D #define IS_SAVED(art)      (((art).status & ART_SAVED) == ART_SAVED)F #define IS_MARKED(art)     (((art).status & ART_MARKED) == ART_MARKED)J #define IS_UNMARKED(art)   (((art).status & ART_UNMARKED) == ART_UNMARKED)F #define IS_KILLED(art)     (((art).status & ART_KILLED) == ART_KILLED)J #define IS_UNKILLED(art)   (((art).status & ART_UNKILLED) == ART_UNKILLED)F #define IS_ACTIVE(art)     (((art).status & ART_ACTIVE) == ART_ACTIVE)J #define IS_INACTIVE(art)   (((art).status & ART_INACTIVE) == ART_INACTIVE)F #define IS_XLATED(art)     (((art).status & ART_XLATED) == ART_XLATED)      P #define SET_READ(art)	   ((art).status &= ~ART_UNREAD, (art).status |= ART_READ)R #define SET_UNREAD(art)    ((art).status &= ~ART_READ, (art).status |= ART_UNREAD)T #define SET_PRINTED(art) ((art).status &= ~ART_PRINTED, (art).status |= ART_PRINTED)Z #define SET_UNPRINTED(art) ((art).status &= ~ART_UNPRINTED, (art).status |= ART_UNPRINTED)X #define SET_FETCHED(art)   ((art).status &= ~ART_UNFETCHED, (art).status |= ART_FETCHED)X #define SET_UNFETCHED(art) ((art).status &= ~ART_FETCHED, (art).status |= ART_UNFETCHED)j #define SET_STRIPPED_HEADERS(art) ((art).status &= ~ART_ALL_HEADERS, (art).status |= ART_STRIPPED_HEADERS)e #define SET_ALL_HEADERS(art) ((art).status &= ~ART_STRIPPED_HEADERS, (art).status |= ART_ALL_HEADERS) X #define SET_UNROTATED(art) ((art).status &= ~ART_ROTATED, (art).status |= ART_UNROTATED)X #define SET_ROTATED(art)   ((art).status &= ~ART_UNROTATED, (art).status |= ART_ROTATED)8 #define SET_UNAVAIL(art)   ((art).status |= ART_UNAVAIL)T #define SET_SAVED(art)     ((art).status &= ~ART_UNSAVED, (art).status |= ART_SAVED)V #define SET_MARKED(art)    ((art).status &= ~ART_UNMARKED, (art).status |= ART_MARKED)V #define SET_UNMARKED(art)  ((art).status &= ~ART_MARKED, (art).status |= ART_UNMARKED)V #define SET_KILLED(art)    ((art).status &= ~ART_UNKILLED, (art).status |= ART_KILLED)V #define SET_UNKILLED(art)  ((art).status &= ~ART_KILLED, (art).status |= ART_UNKILLED)V #define SET_ACTIVE(art)    ((art).status &= ~ART_INACTIVE, (art).status |= ART_ACTIVE)V #define SET_INACTIVE(art)  ((art).status &= ~ART_ACTIVE, (art).status |= ART_INACTIVE)U #define SET_UNXLATED(art) ((art).status &= ~ART_XLATED, (art).status |= ART_UNXLATED) S #define SET_XLATED(art) ((art).status &= ~ART_UNXLATED, (art).status |= ART_XLATED)    #define CLEAR_TEXT(art) \ "   if ((art).text != NIL(char)) { \       FREE((art).text); \        (art).text = NIL(char); \    }	  5 #define CLEAR_SUBJECT(art) (art).subject = NIL(char)    2 #define CLEAR_AUTHOR(art) (art).author = NIL(char)  0 #define CLEAR_LINES(art) (art).lines = NIL(char)   0 #define CLEAR_MSGID(art) (art).msgid = NIL(char)   #define CLEAR_REFS(art) \  	(art).refs[0] = NIL(char); \  	(art).refs[1] = NIL(char); \  	(art).refs[2] = NIL(char);   - /* newsgroup is subscribed/unsubscribed to */  #define NG_SUB      0x0001 #define NG_UNSUB    0x0002, /* no entry in the .newsrc for this group */ #define NG_NOENTRY  0x0004F /* newsgroup can be posted to / can not be posted to / is moderated */ #define NG_POSTABLE 0x0008 #define NG_UNPOSTABLE 0x0010 #define NG_MODERATED 0x0020  /* newsgroup is an alias */  #define NG_ALIAS    0x0040 #define NG_ALIASSEEN 0x0080   = #define IS_SUBSCRIBED(ng) (((ng)->status & NG_SUB) == NG_SUB) E #define IS_NOENTRY(ng)    (((ng)->status & NG_NOENTRY) == NG_NOENTRY) > #define IS_ALIAS(ng)	  (((ng)->status & NG_ALIAS) == NG_ALIAS): #define IS_NOTALIAS(ng)	  (((ng)->status & NG_ALIAS) == 0)   J #define SET_SUB(ng)    ((ng)->status &= ~NG_UNSUB, (ng)->status |= NG_SUB)J #define SET_UNSUB(ng)  ((ng)->status &= ~NG_SUB, (ng)->status |= NG_UNSUB)7 #define CLEAR_NOENTRY(ng) ((ng)->status &= ~NG_NOENTRY)   E #define EMPTY_GROUP(ng) ((ng)->last < (ng)->first || (ng)->last == 0)    @ #define CLEAR_ARTICLES(ng) currentArticles = NIL(struct article)   #define CLEAR_ARTSTATUS(ng) \ 1   if ((ng)->artStatus != NIL(struct artStat)) { \        FREE((ng)->artStatus); \.       (ng)->artStatus = NIL(struct artStat); \   }	  2 #define INDEX(artnum)  (artnum - newsgroup->first)0 #define CURRENT        INDEX(newsgroup->current)- #define LAST           INDEX(newsgroup->last)   : extern struct newsgroup *CurrentGroup;	/* Current group */  S extern ng_num MaxGroupNumber;       /* size of the newsrc array                  */   S extern struct newsgroup **Newsrc;   /* sequence list for .newsrc file            */   = #define NOT_IN_NEWSRC -1            /* must be less than 0 */   - /* not a valid group (must be less than 0) */  #define NO_GROUP -1      #define GROUP_NAME_SIZE 128    #endif /* NEWS_H */ 