 #ifndef INTERNALS_H  #define INTERNALS_H    /*i  * $Header: /net/objy27/wrld/mnt11/ricks/src/master/xrn/internals.h,v 1.4 1993/01/11 02:15:00 ricks Exp $   */    /*$  * xrn - an X-based NNTP news reader  *G  * Copyright (c) 1988-1993, Ellen M. Sentovich and Rick L. Spickelmier.   *H  * Permission to use, copy, modify, and distribute this software and itsL  * documentation for any purpose and without fee is hereby granted, providedJ  * that the above copyright notice appear in all copies and that both thatC  * copyright notice and this permission notice appear in supporting G  * documentation, and that the name of the University of California not E  * be used in advertising or publicity pertaining to distribution of  K  * the software without specific, written prior permission.  The University G  * of California makes no representations about the suitability of this G  * software for any purpose.  It is provided "as is" without express or   * implied warranty.  *H  * THE UNIVERSITY OF CALIFORNIA DISCLAIMS ALL WARRANTIES WITH REGARD TO J  * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND H  * FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE FORK  * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER G  * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF G  * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN  ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   */      /*%  * internals.h: news system interface   */    /*3  * Get datatype definitions we need for prototyping   */  #include "news.h"    #define XRN_ERROR 0  #define XRN_NOMORE 0 #define XRN_OKAY   1   /*    * kill file stuff  */  #define KILL_GLOBAL 0  #define KILL_LOCAL 1/ extern void killItem _ARGUMENTS((char *, int)); @ extern char *localKillFile _ARGUMENTS((struct newsgroup*, int));) extern void killThread _ARGUMENTS((int));    /*4  * routines for adding newsgroups to the newsrc file  */    - /* 'status' values for the 'add' functions */  #define SUBSCRIBE 1  #define UNSUBSCRIBE 0 :                                                           C extern int addToNewsrcAfterGroup _ARGUMENTS((char *, char *, int)); 4 extern int addToNewsrcEnd _ARGUMENTS((char *, int));: extern int addToNewsrcBeginning _ARGUMENTS((char *, int));     /**  * routines for doing newsgroup management  */   # /* jump/goto/add newsgroup codes */  #define BAD_GROUP -1 #define GOOD_GROUP 1  B /* set the internal group to 'name', with prefetch invalidation */. extern int gotoNewsgroup _ARGUMENTS((char *));5 extern int gotoNewsgroupForRead _ARGUMENTS((char *)); 3 /* same thing, but without prefetch invalidation */ - extern int setNewsgroup _ARGUMENTS((char *));   ` /* set the internal group to 'name', and if all of the articles are read, unmark the last one */0 extern int jumpToNewsgroup _ARGUMENTS((char *));  6 /* getNewsgroup returns 0 if a bad group, 1 if okay */ extern int getNewsgroup();  ( /* subscribe to the current newsgroup */ extern void subscribe();* /* unsubscribe to the current newsgroup */ extern void unsubscribe();   /* check subscription status */  extern int issubscribed();  R /* updates the .newsrc file so that the current newsgroup is marked as all read */ extern void catchUp();     /*(  * routines for doing article management  */   . extern void gotoArticle _ARGUMENTS((art_num)); extern void gotoFirstArticle();   9 extern int getArticleText _ARGUMENTS((char **, char **)); 8 extern int toggleHeaders _ARGUMENTS((char **, char **));9 extern int toggleRotation _ARGUMENTS((char **, char **));  extern char *openQuestion(); extern char *currentQuestion();    /* mark articles */ 4 extern void markArticleAsRead _ARGUMENTS((art_num));6 extern void markArticleAsUnread _ARGUMENTS((art_num));6 extern void markArticleAsKilled _ARGUMENTS((art_num));8 extern void markArticleAsUnkilled _ARGUMENTS((art_num));  I /* get a single subject line, stripped of leading/trailing spaces, Re: */ . extern char *getSubject _ARGUMENTS((art_num));- extern char *getAuthor _ARGUMENTS((art_num)); + extern char *getText _ARGUMENTS((art_num)); 2 extern char *getSubjectLine _ARGUMENTS((art_num));  1 extern Boolean articleRead _ARGUMENTS((art_num)); 9 extern Boolean articleMarkedUnread _ARGUMENTS((art_num));   M /* get the subject line for the previous subject (and get the article too) */ > /* only called when going off the top of the subject string */ extern char *getPrevSubject();   extern void startSearch(); extern void failedSearch();    /*!  * information gathering routines   */    extern void checkLock(); extern void removeLock();    2 /* read the .newsrc file, find out what to read */ extern void initializeNews();   * /* query the server for new information */ extern void rescanServer();   & /* return the new newsgroups string */& extern struct newsgroup **newGroups();  ' /* return the unread newsgroups list */ 9 extern ng_num *unreadGroups _ARGUMENTS((int, Boolean *));   $ /* return the group status string */+ extern char *groupStatus _ARGUMENTS((int)); ) extern char *groupName _ARGUMENTS((int));    /* return the subject string */ 
 #define ALL 0  #define UNREAD 1 #define UNKILLED 2 #define ACTIVE 3  ; extern art_num *getArticleNumbers _ARGUMENTS((int, int *));  /* Types of subject sorting */ #define UNSORTED 0 #define ARTICLE_SORTED 1 #define STRICT_SORTED 2  #define THREAD_SORTED 3   & /* build and return the status list *// extern ng_num *getStatusList _ARGUMENTS((int)); / extern char *getStatusString _ARGUMENTS((int));    extern void bogusNewsgroup();   ( extern void releaseNewsgroupResources(); extern void clearArtCache();  . extern void fillUpArray _ARGUMENTS((art_num));  4 #define GETARTICLES(newsgroup) (currentArticles) ? \+ 	(currentArticles) : getarticles(newsgroup) = struct article *getarticles _ARGUMENTS((struct newsgroup *));   7 #define GETSTATUS(newsgroup) (newsgroup->artStatus) ? \ 1 	(newsgroup->artStatus) : getartstatus(newsgroup)   > struct artStat *getartstatus _ARGUMENTS((struct newsgroup *));  . extern int checkArticle _ARGUMENTS((art_num));   #endif /* INTERNALS_H */