  % #if !defined(lint) && !defined(SABER)  static char XRNrcsid[] = "$Header: /net/objy27/wrld/mnt11/ricks/src/master/xrn/internals.c,v 1.9 1993/02/04 18:22:19 ricks Exp $"; #endif   /*$  * xrn - an X-based NNTP news reader  *G  * Copyright (c) 1988-1993, Ellen M. Sentovich and Rick L. Spickelmier.   *H  * Permission to use, copy, modify, and distribute this software and itsL  * documentation for any purpose and without fee is hereby granted, providedJ  * that the above copyright notice appear in all copies and that both thatC  * copyright notice and this permission notice appear in supporting G  * documentation, and that the name of the University of California not E  * be used in advertising or publicity pertaining to distribution of  K  * the software without specific, written prior permission.  The University G  * of California makes no representations about the suitability of this G  * software for any purpose.  It is provided "as is" without express or   * implied warranty.  *H  * THE UNIVERSITY OF CALIFORNIA DISCLAIMS ALL WARRANTIES WITH REGARD TO J  * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND H  * FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE FORK  * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER G  * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF G  * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN  ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   */    /*B  * internals.c: routines for handling the internal data structures@  *    calls server routines, is calls by the user interface code  *  */    #include "copyright.h"
 #ifdef VMS #include <jpidef.h>  #include <ssdef.h> #ifdef MOTIF #include <X11/Xos.h> #else  #include <decw$include/Xos.h>  #endif #endif #include <stdio.h> #include <errno.h> #include "config.h"  #include "utils.h" #include <assert.h>  #ifndef VMS  #include <sys/param.h> #include <sys/file.h>  #include <sys/stat.h>  #else  #define index strchr #include <file.h>  #include <ctype.h> #endif /* VMS */ #ifdef __STDC__  #include <time.h>  #ifndef VMS  #include <unistd.h>  #else  #include <unixlib.h> extern int sys$getjpiw();  extern int unlink(); #endif #include <stdlib.h>  #endif /* __STDC__ */  #include "avl.h" #include "news.h"  #include "newsrcfile.h"  #include "resources.h" #include "server.h"  #include "mesg.h"  #include "error_hnds.h"  #include "save.h"  #include "internals.h" #include "xrn.h"   #ifdef SYSV_REGEX      extern char *regcmp();     extern char *regex();  #else      extern char *re_comp();  #endif  & #if !defined(VMS) && defined(__STDC__)1 extern int gethostname _ARGUMENTS((char *, int));  #endif   #define BUFFER_SIZE 1024 #define FATAL 0  #define OKAY  1    extern void stop_server(); extern Boolean watchingGroup(); K struct article *currentArticles = NULL;	/* List of article data pointers */   struct article *savedArt = NULL;3 int artCount = 0;		/* Count of entries available */ % static char subjectline[BUFFER_SIZE];   V #define SETARTICLES(newsgroup) if (currentArticles == 0) (void) getarticles(newsgroup)Z #define SETSTATUS(newsgroup) if (newsgroup->artStatus == 0) (void) getartstatus(newsgroup) static char *strip();    /*)  * length of lines in the top text window   */  #define LINE_LENGTH 512    /*D  * next article to get when faulting in articles that are of the top  * of the subject screen.   */ # static art_num NextPreviousArticle;    > /* storage for all newsgroups, key is the name of the group */) avl_tree *NewsGroupTable = NIL(avl_tree);   ' /* storage for newsgroup message ids */ ( static avl_tree *msgids = NIL(avl_tree);  ) /* number of groups in the active file */  int ActiveGroupsCount = 0;  3 /* number of the group currently being processed */ $ struct newsgroup * CurrentGroup = 0;  * /* number of groups in the .newsrc file */ ng_num MaxGroupNumber = 0;  ' /* index number of last article read */ - static int PrevArtIndx[5] = {-1,-1,-1,-1,-1};   $ /* Storage for shared string pool */% avl_tree *StringPool = NIL(avl_tree);   0 /* sprintf format string for article subjects */& static char formatString[LINE_LENGTH];   /*   * see if another xrn is running  */  void checkLock()  { 9     char *buffer = utTildeExpand(app_resources.lockFile); 
 #ifdef VMS     char *ptr;     struct _itemList { 	short item_size;  	short item_code;  	void *item_ptr; 	int   item_rtn_size;  	int   end_list;     } itemList;  #endif /* VMS */     char host[64];     char myhost[64];     int pid;
     FILE *fp;        if (!buffer) {% 	/* silently ignore this condition */  	return;     }    #ifndef VMS 4     if (gethostname(myhost, sizeof(myhost)) == -1) {$ 	(void) strcpy(myhost, "bogusHost");     }  #else      ptr = getenv("SYS$NODE");      if (ptr != NIL(char)) {  	(void) strcpy(myhost, ptr); 	ptr = index(myhost, ':'); 	if (ptr != NIL(char)) { 	    *ptr = '\0';  	}     }        if (*myhost == '\0') {$ 	(void) strcpy(myhost, "bogusHost");     }  #endif /* VMS */  ,     if ((fp = fopen(buffer, "r")) == NULL) {) 	if ((fp = fopen(buffer, "w")) == NULL) { ) 	    /* silently ignore this condition */  	    return; 	}1 	(void) fprintf(fp, "%s %d\n", myhost, getpid());  	(void) fclose(fp);  	return;     }   +     (void) fscanf(fp, "%s %d", host, &pid);    #ifndef VMS %     /* see if I'm on the same host */ $     if (strcmp(host, myhost) == 0) {0 	if ((kill(pid, 0) == -1) && (errno == ESRCH)) {$ 	    /* hey, it's not running.... */7 	    /* why do it right when you can just do this... */  	    removeLock(); 	    checkLock();  	    return; 	}     }  #else %     /* see if I'm on the same host */ $     if (strcmp(host, myhost) == 0) { 	int status, pidTmp;. 	/* whoa!  I am, see if the process is mine */ 	if (pid == getpid()) { # 	    /* It's mine.. so delete it */ 7 	    /* why do it right when you can just do this... */  	    (void) fclose(fp);  	    removeLock(); 	    checkLock();  	    return; 	}1 	/* whoa!  I am, see if the process is running */  	itemList.item_size = 4; 	itemList.item_code = JPI$_PID;  	itemList.item_ptr = &pidTmp;  	itemList.item_rtn_size = 0; 	itemList.end_list = 0;    	pidTmp = 0;6 	status = sys$getjpiw(0, &pid, 0, &itemList, 0, 0, 0); 	if (status == SS$_NONEXPR) { $ 	    /* hey, it's not running.... */7 	    /* why do it right when you can just do this... */  	    removeLock(); 	    checkLock();  	    return; 	}     }  #endif  O     (void) fprintf(stderr, "An XRN of yours is running on %s as process %d.\n",  		   host, pid);E     (void) fprintf(stderr, "If it is no longer running, remove %s\n", 
 		   buffer); 
     exit(-1);        return;  }      void removeLock() { 9     char *buffer = utTildeExpand(app_resources.lockFile);        if (buffer) {  	(void) unlink(buffer);      }      return;  }    int groupCompare(str1, str2)! #if defined(__STDC__) && __STDC__  const char *str1;  const char *str2;  #else  char *str1;  char *str2;  #endif {      if (str1 == NULL) return 1;       if (str2 == NULL) return -1;$     return(strncmp(str1, str2, 40)); }    /*-  * initialize the program and the news system   *   read newsrc, etc   *  *   returns: void  *  */  void initializeNews() { +     start_server(app_resources.nntpServer);        do {0 	 NewsGroupTable = avl_init_table(groupCompare); 	 if (! NewsGroupTable) { & 	     ehErrorExitXRN("out of memory"); 	 }       	 getactive(); 	 * 	 if (readnewsrc(app_resources.newsrcFile,! 			app_resources.saveNewsrcFile)) 
 	      break;  	 9 	 ehErrorRetryXRN("Can not read the .newsrc file", True);   1 	 avl_free_table(NewsGroupTable, XtFree, XtFree);      } while (1); 	 E #if !defined(FIXED_C_NEWS_ACTIVE_FILE) && !defined(FIXED_ACTIVE_FILE)      fixLowArticleNumbers();  #endif     return;  }    /*C  * get the active file again and grow the Newsrc array if necessary   */  void rescanServer() {       int old = ActiveGroupsCount;        /* update the newsrc file */     while (!updatenewsrc()) 9 	ehErrorRetryXRN("Can not update the newsrc file", True);   & #if !defined(NNTP_REREADS_ACTIVE_FILE)     stop_server();     start_server(NIL(char)); #endif          getactive();  "     if (ActiveGroupsCount > old) {9 	/* new newsgroups were found, allocate a bigger array */ : 	Newsrc = (struct newsgroup **) XtRealloc((char *) Newsrc,? 		(unsigned) (sizeof(struct newsgroup *) * ActiveGroupsCount));      }   E #if !defined(FIXED_C_NEWS_ACTIVE_FILE) && !defined(FIXED_ACTIVE_FILE)      fixLowArticleNumbers();  #endif     return;  }    #define lsDestroy(lst) \$     if (lst != NIL(struct list)) { \ 	struct list *_next; \ 	do { \  	    _next = lst->next; \  	    FREE(lst); \  	    lst = _next; \ % 	} while (lst != NIL(struct list)); \      }    /*<  * accurately count the number of unread articles in a group  *8  *   returns: the number of unread articles in the group  */  int  unreadArticleCount(newsgroup)  struct newsgroup *newsgroup; {      art_num i;3     struct artStat *artstat = GETSTATUS(newsgroup);      int count = 0;      register struct artStat *ap;,     register art_num	last	= newsgroup->last;     register art_num	artn;    !     if (EMPTY_GROUP(newsgroup)) { 
 	return 0;     }      <     if ((newsgroup->first == 0) && (newsgroup->last == 0)) {
 	return 0;     }      +     ap = &artstat[INDEX(newsgroup->first)];   9     for (artn = newsgroup->first; artn <= last; artn++) { * 	if (IS_UNREAD(*ap) && !IS_UNAVAIL(*ap)) {
 	    count++;  	} 	ap++;     }      return count;  }    /*5  * accurately count the number of articles in a group   *7  *   returns: the total number of articles in the group   */  int  totalArticleCount(newsgroup) struct newsgroup *newsgroup; {      art_num i;3     struct artStat *artstat = GETSTATUS(newsgroup);      int count = 0;     struct artStat *ap; #     art_num last = newsgroup->last;    !     if (EMPTY_GROUP(newsgroup)) { 
 	return 0;     }      <     if ((newsgroup->first == 0) && (newsgroup->last == 0)) {
 	return 0;     }      +     ap = &artstat[INDEX(newsgroup->first)];   0     for (i = newsgroup->first; i <= last; i++) { 	if (!IS_UNAVAIL(*ap)) {
 	    count++;  	} 	ap++;     }      return count;  }    /*N  * find the first (possibly unread) article in a group and set 'current' to it  *  * returns: void  *  */  static void " setCurrentArticle(newsgroup, mode) struct newsgroup *newsgroup;	 int mode;  { 3     struct artStat *artstat = GETSTATUS(newsgroup);      art_num i;     int start;  -     newsgroup->current = newsgroup->last + 1;      D     /* if the resource 'onlyShow' is > 0, then mark all but the last%      * 'onlyShow' articles as read */        start = newsgroup->first; %     if (app_resources.onlyShow > 0) { > 	start = MAX(start, newsgroup->last - app_resources.onlyShow);     }           if (mode == UNREAD) { 7 	for (i = newsgroup->first; i<= newsgroup->last; i++) {  	    long indx = INDEX(i);B 	    if (IS_UNREAD(artstat[indx]) && !IS_UNAVAIL(artstat[indx])) {. 		newsgroup->initial = newsgroup->current = i;	 		return;  	    } 	}       }      if (mode == UNKILLED) {  	if (newsgroup->initial == 0) + 	    newsgroup->initial = newsgroup->first; 9 	for (i = newsgroup->initial; i<= newsgroup->last; i++) {  	    long indx = INDEX(i);B 	    if (IS_UNKILLED(artstat[indx]) && IS_ACTIVE(artstat[indx]) && 		!IS_UNAVAIL(artstat[indx])) {  		newsgroup->current = i; 	 		return;  	    } 	}       }        if (mode == ACTIVE) {  	if (newsgroup->initial == 0) + 	    newsgroup->initial = newsgroup->first; 9 	for (i = newsgroup->initial; i<= newsgroup->last; i++) {  	    long indx = INDEX(i);B 	    if (IS_ACTIVE(artstat[indx]) && !IS_UNAVAIL(artstat[indx])) { 		newsgroup->current = i; 	 		return;  	    } 	}       }        if (mode == ALL) {' 	newsgroup->initial = newsgroup->first; 9 	for (i = newsgroup->initial; i<= newsgroup->last; i++) {  	    long indx = INDEX(i);& 	    if (!IS_UNAVAIL(artstat[indx])) {. 		newsgroup->initial = newsgroup->current = i;	 		return;  	    } 	}       }        return;  }    int  unreadNews() {      int i, count = 0;       struct newsgroup *newsgroup;  *     for (i = 0; i < MaxGroupNumber; i++) { 	newsgroup = Newsrc[i];  #ifdef WATCHB 	if (IS_SUBSCRIBED(newsgroup) && watchingGroup(newsgroup->name)) { #else   	if (IS_SUBSCRIBED(newsgroup)) { #endif, 	    count += unreadArticleCount(newsgroup); 	}     }      return count;  }    /*M  * build and return an array of information about groups that need to be read   */  ng_num * unreadGroups(mode, flag)	 int mode;  Boolean *flag; {       struct newsgroup *newsgroup;
     ng_num i;      int unread;      int subscribedGroups = 0;      ng_num *ar;   .     ar = ARRAYALLOC(ng_num, MaxGroupNumber+1);       *flag = False;  *     for (i = 0; i < MaxGroupNumber; i++) { 	newsgroup = Newsrc[i];     	if (IS_SUBSCRIBED(newsgroup) &&? 	   (((unread = unreadArticleCount(newsgroup)) > 0) || mode)) {   	    ar[subscribedGroups++] = i;" 	    if (unread > 0) *flag = True; 	}     }         ar[subscribedGroups++] = -1;     return ar; }    /*=  * build and return a string describing the status of a group   */  char * groupStatus(which)
 int which; { #     static char dummy[LINE_LENGTH];       struct newsgroup *newsgroup;     int unread, total;       dummy[0] = '\0';  ,     if (which < 0 || which > MaxGroupNumber) 	return dummy;       newsgroup = Newsrc[which];)     total = totalArticleCount(newsgroup); +     unread = unreadArticleCount(newsgroup);   @     (void) sprintf(dummy, "%6s %7s %-40s%5d article%s +%5d old",  			(unread > 0 ? "Unread" : ""),  			(total > 0 ? "news in" : ""), 			newsgroup->name, unread,  			((unread != 1) ? "s" : " "),  			total-unread);      return dummy;  }  /*!  * return the name of a newsgroup   */  char * groupName(which)
 int which; {       struct newsgroup *newsgroup;     static char *dummy = ".";   ,     if (which < 0 || which > MaxGroupNumber) 	return dummy;       newsgroup = Newsrc[which];     return newsgroup->name;  }  /*<  * determine the newsgroups that are not in the .newsrc file  *9  *   returns an array containing the newsgroup structures   */  struct newsgroup **  newGroups()  {      int count = 0;     avl_generator *gen;      char *key, *value;     struct newsgroup **ar;  ?     ar = ARRAYALLOC(struct newsgroup *, ActiveGroupsCount + 1);   4     gen = avl_init_gen(NewsGroupTable, AVL_FORWARD);     if (! gen) {! 	ehErrorExitXRN("out of memory");      }   (     while (avl_gen(gen, &key, &value)) {: 	struct newsgroup *newsgroup = (struct newsgroup *) value;  7 	if (IS_NOENTRY(newsgroup) && IS_NOTALIAS(newsgroup)) {  	    ar[count++] = newsgroup;  	}     }        avl_free_gen(gen);       /* no new groups return */     if (count == 0) {  	FREE(ar);	 
 	return NULL;      }        ar[count] = NULL;      return ar; }    /*  *   release some resources   *  *   returns: void  */  void releaseNewsgroupResources()  { 
     int i;       if (StringPool != NULL) { * 	avl_free_table(StringPool, XtFree, NULL);     } (     StringPool = avl_init_table(strcmp);       for (i = 0; i < 5; i++)  	PrevArtIndx[i] = -1;      /*7      * CurrentGroup can be invalid when called from the       * signal catcher       */ 1     if (CurrentGroup != NIL(struct newsgroup) ) { , 	struct newsgroup *newsgroup = CurrentGroup;, 	struct article *articles = currentArticles;0 	struct artStat *artstat = newsgroup->artStatus;
 	art_num art;    	newsgroup->initial = 0;8 	if ((newsgroup->last == 0) || EMPTY_GROUP(newsgroup)) { 	    return; 	}  > 	for (art = newsgroup->first; art <= newsgroup->last; art++) { 	    long indx = INDEX(art); 	      	    if (articles) {  		CLEAR_SUBJECT(articles[indx]); 		CLEAR_AUTHOR(articles[indx]);  		CLEAR_LINES(articles[indx]); 		CLEAR_TEXT(articles[indx]);  		CLEAR_MSGID(articles[indx]); 		CLEAR_REFS(articles[indx]);  	    } 	    if (artstat) {  		SET_UNFETCHED(artstat[indx]);  		SET_UNMARKED(artstat[indx]); 	    } 	}) 	/* free the articles array every time */  	CLEAR_ARTICLES(newsgroup);      }   -     if (app_resources.updateNewsrc == TRUE) {  	if (!updatenewsrc()) { 6 	    ehErrorExitXRN("Can not update the newsrc file"); 	}     }n       return;t }c   void clearArtCache() {/
     int i;     for (i = 0; i < 5; i++)n 	PrevArtIndx[i] = -1;/     return;9 }c   /*J  * update an article array if the first and/or last article numbers change  *  *  returns: voidS  */i void2 articleArrayResync(newsgroup, first, last, number) struct newsgroup *newsgroup; art_num first, last; int number;n {r/     struct article *articles = currentArticles;r      struct article *newarticles;5     struct artStat *artstatus = newsgroup->artStatus;p!     struct artStat *newartstatus;o
     int i;     int newsize;       /*B      * if there are actually no articles in the group, free up the2      * article array and set the first/last values      */f        e     if (number == 0) { 	CLEAR_ARTICLES(newsgroup);  	CLEAR_ARTSTATUS(newsgroup);( 	newsgroup->first = newsgroup->last + 1; 	return;     }      '     /* refuse to resync if last == 0 */"     if (last == 0) { 	return;     }w       if (first > last) {S% 	/* all articles have been removed */I 	CLEAR_ARTICLES(newsgroup);O 	CLEAR_ARTSTATUS(newsgroup);( 	newsgroup->first = newsgroup->last + 1; 	return;     }   -     /* don't allow last to go backwards!!! */ !     if (last < newsgroup->last) {E 	last = newsgroup->last;     }S  .     /* don't allow first to go backwards!!! */#     if (first < newsgroup->first) {N 	first = newsgroup->first;     }  	IC     if ((first != newsgroup->first) || (last != newsgroup->last)) {   < 	/* only do this if the articles array has been allocated */ 	if (currentArticles) {t  5 	    /* the first/last values have changed, resync */e    	    articles = currentArticles;    	    newsize = last - first + 1; 	    if (newsize > artCount) { 		newsize = MAX(newsize, 1000);o? 		savedArt = newarticles = ARRAYALLOC(struct article, newsize);c 		artCount = newsize;e
 	    } else {c 		newarticles = savedArt;" 	    }   	    /*<- 	     * initialize the new article structures> 	     */ 	y& 	    for (i = first; i <= last; i++) {- 		newarticles[i - first].subject = NIL(char);i, 		newarticles[i - first].author = NIL(char);* 		newarticles[i - first].text = NIL(char);+ 		newarticles[i - first].lines = NIL(char);.+ 		newarticles[i - first].msgid = NIL(char);l- 		newarticles[i - first].refs[0] = NIL(char); - 		newarticles[i - first].refs[1] = NIL(char);h- 		newarticles[i - first].refs[2] = NIL(char);e$ 		newarticles[i - first].parent = 0;# 		newarticles[i - first].child = 0;i 	    }  % 	    if ((!EMPTY_GROUP(newsgroup)) &&e6 		(newsgroup->first != 0) && (newsgroup->last != 0) &&& 		(articles != NIL(struct article))) {# 		for (i = first; i <= last; i++) { > 		    if ((i >= newsgroup->first) && (i <= newsgroup->last)) {/ 			newarticles[i - first] = articles[INDEX(i)];U 		    }  		}   8 		/* free up the old resources - before the new first */. 		for (i = newsgroup->first; i < first; i++) { 		    long indx = INDEX(i);L$ 		    CLEAR_SUBJECT(articles[indx]);# 		    CLEAR_AUTHOR(articles[indx]);n" 		    CLEAR_LINES(articles[indx]);" 		    CLEAR_MSGID(articles[indx]);! 		    CLEAR_REFS(articles[indx]);T! 		    CLEAR_TEXT(articles[indx]);s% 		    SET_UNFETCHED(artstatus[indx]);d 		}  		/* after the new last */0 		for (i = last + 1; i < newsgroup->last; i++) { 		    long indx = INDEX(i); $ 		    CLEAR_SUBJECT(articles[indx]);# 		    CLEAR_AUTHOR(articles[indx]); " 		    CLEAR_LINES(articles[indx]);" 		    CLEAR_MSGID(articles[indx]);! 		    CLEAR_REFS(articles[indx]); ! 		    CLEAR_TEXT(articles[indx]);A% 		    SET_UNFETCHED(artstatus[indx]);o 		}k 	    }  + 	    if (articles != NIL(struct article) &&e 		articles != savedArt) {o 		FREE(articles);m 	    }# 	    currentArticles = newarticles;( 	}   	if (newsgroup->artStatus) {  5 	    /* the first/last values have changed, resync */m  & 	    artstatus = newsgroup->artStatus;A 	    newartstatus = ARRAYALLOC(struct artStat, last - first + 1);n   	    /*c) 	     * initialize the new article statusi 	     */ 	f& 	    for (i = first; i <= last; i++) { 		if (i < newsgroup->first) { 8 		    /* handle first decreasing... mark them as read */6 		    newartstatus[i - first].status = ART_CLEAR_READ;
 		} else {1 		    newartstatus[i - first].status = ART_CLEAR;  		}e 	    }  % 	    if ((!EMPTY_GROUP(newsgroup)) &&(6 		(newsgroup->first != 0) && (newsgroup->last != 0) &&2 		(newsgroup->artStatus != NIL(struct artStat))) {# 		for (i = first; i <= last; i++) {t> 		    if ((i >= newsgroup->first) && (i <= newsgroup->last)) {1 			newartstatus[i - first] = artstatus[INDEX(i)];h 		    }4 		}  	    }, 	    if (artstatus != NIL(struct artStat)) { 		FREE(artstatus); 	    }) 	    newsgroup->artStatus = newartstatus;  	} 	newsgroup->first = first; 	newsgroup->last = last;     }=     return;d }t     char * localKillFile(newsgroup, mode) struct newsgroup *newsgroup;	 int mode;t {=$     static char buffer[BUFFER_SIZE];     char *ptr;
     int i;       if (!createNewsDir()) {{ 	return NIL(char);     }   9     (void) strcpy(buffer, app_resources.expandedSaveDir);o     i = strlen(buffer);f   #ifndef VMS      buffer[i++] = '/';  3     for (ptr = newsgroup->name; *ptr != 0; ptr++) {U 	if (*ptr == '.') {t 	    if (mode) { 		buffer[i] = '\0';r 		(void) mkdir(buffer, 0777);  	    } 	    buffer[i] = '/';o	 	    i++;f	 	} else {r 	    buffer[i++] = *ptr; 	}     }%     buffer[i] = '\0';      if (mode) {  	(void) mkdir(buffer, 0777);     } '     (void) strcpy(&buffer[i], "/KILL");( #elsed>     i = i + utGroupToVmsFilename(&buffer[i], newsgroup->name);'     (void) strcpy(&buffer[i], ".KILL");u #endif       return buffer; }m     char * globalKillFile() { $     static char buffer[BUFFER_SIZE];       if (!createNewsDir()) {  	return NIL(char);     }s9     (void) strcpy(buffer, app_resources.expandedSaveDir);h #ifndef VMSm#     (void) strcat(buffer, "/KILL");  #elses.     (void) strcat(buffer, "NEWS$GLOBAL.KILL"); #endif     return buffer; }*   /*  * mark a thread as killed  */v void killThread(artNum) art_num artNum;  { /     struct newsgroup *newsgroup = CurrentGroup; 6     struct article *articles = GETARTICLES(newsgroup);     long indx = INDEX(artNum);       if (articles[indx].child) {  	artNum = articles[indx].child;m 	while (artNum) {y& 	    if (!articleMarkedUnread(artNum)) 		markArticleAsKilled(artNum); 	    indx = INDEX(artNum);# 	    artNum = articles[indx].child;  	}     }n }s   /*1  * add a kill subject/author entry to a kill file   */r void killItem(item, type) char *item;f	 int type;r {"#     char input[BUFFER_SIZE], *iptr;r$     char output[BUFFER_SIZE], *optr;
     FILE *fp;s/     struct newsgroup *newsgroup = CurrentGroup;      char *file;        if (type == KILL_LOCAL) { $ 	file = localKillFile(newsgroup, 1);     } else { 	file = globalKillFile();c     }   *     if ((fp = fopen(file, "a")) == NULL) {? 	mesgPane(XRN_SERIOUS, "Can not open the %s kill file for %s",  3 		       (type == KILL_LOCAL) ? "local" : "global",o 		       newsgroup->name); 	return;     }*)     /* get rid of all magic characters */e/     (void) strncpy(input, item, sizeof(input));e     iptr = input;s     optr = output;     while (*iptr) {r 	if ((*iptr == '/')  ||  	    (*iptr == '\\') ||  	    (*iptr == '(')  ||* 	    (*iptr == '[')  ||e 	    (*iptr == '+')  ||r 	    (*iptr == '-')  ||) 	    (*iptr == ':')  ||u 	    (*iptr == '.')  ||r 	    (*iptr == '^')  ||s 	    (*iptr == '*')  ||r 	    (*iptr == '$')  ||" 	    (*iptr == '\'') ||v 	    (*iptr == '\"')) {c 	    *iptr = '.';r 	} 	*optr++ = *iptr++;s     }r     *optr = '\0';e  '     fprintf(fp, "/%.24s/:j\n", output);h     (void) fclose(fp);     return;e }b     /*9  * kill all subjects in the newsgroup that match the killf  * orders in fp.  */E5 /* XXX  THIS ROUTINE REALLY NEEDS TO BE CLEANED UP */l static void  killArticles(newsgroup, fp)* struct newsgroup *newsgroup;	 FILE *fp;h {eJ     char string[BUFFER_SIZE], pattern[BUFFER_SIZE], commands[BUFFER_SIZE];     char dummy[BUFFER_SIZE];*     art_num i, start = newsgroup->current;/     char *subject, *author, *subj, *ptr, *pptr;r7     int scount = 0, kcount = 0, ucount = 0, mcount = 0;)     int append;(     char *reRet;     char type;       mesgDisableRedisplay();   !     info("processing KILL file");   M     /* XXX don't reprocess global each time, keep in persistent hash table */s  7     while (fgets(string, sizeof(string), fp) != NULL) {s 	append = 0;   	/*A0 	 * see if there is a 'THRU artnum' line, if so,. 	 * only compare subjects from that article on 	 * XXX need to update THRUs 	 */! 	if (STREQN(string, "THRU", 4)) {  	    i = atol(&string[5]);2 	    /* if THRU is less than current, ignore it */& 	    if (i + 1 > newsgroup->current) { 		start = i + 1;
 	    } else {t 		start = newsgroup->current;c 	    } 	    continue; 	}   	if (*string == '&') {& 	    /* 'rn' switch setting, ignore */ 	    continue; 	}     	/*n3 	 * process kill file request should be in the formC 	 */ 	ptr = string + 1; 	pptr = pattern;  I 	while (*ptr && (*ptr != '/' || ((*ptr == '/') && *(ptr - 1) == '\\'))) {  	   *pptr++ = *ptr; 
 	   ptr++; 	} 	*pptr = '\0';  
 	if (!*ptr) {n^ 	    mesgPane(XRN_SERIOUS, "In newsgroup `%s':\nMalformed KILL file entry (pattern): %s (%s)",) 		     newsgroup->name, string, pattern);p 	    continue; 	}  6 	/* rn puts ': *' in front of patterns, xrn doesn't */' 	if (strncmp(pattern, ": *", 3) == 0) { ( 	    /* deal with overlapping strings */' 	    (void) strcpy(dummy, pattern + 3);S# 	    (void) strcpy(pattern, dummy);  	}  ( 	/* XXX kludge to deal with :.*checks */ 	if (*pattern == ':') {b( 	    /* deal with overlapping strings */' 	    (void) strcpy(dummy, pattern + 1);r# 	    (void) strcpy(pattern, dummy);e 	}   #ifdef SYSV_REGEXp/ 	if ((reRet = regcmp(pattern, NULL)) == NULL) {t@ 	    mesgPane(XRN_SERIOUS, "Bad KILL file pattern: %s", string); #elset/ 	if ((reRet = re_comp(pattern)) != NIL(char)) { K 	    mesgPane(XRN_SERIOUS, "Bad KILL file pattern: %s\n%s", string, reRet);g #endif 	    continue; 	}  ! 	ptr++;	/* skip past the slash */  	(void) strcpy(commands, ptr);1 	if ((ptr = index(commands, ':')) == NIL(char)) {sJ 	    mesgPane(XRN_SERIOUS, "Malformed KILL file entry (command): %s (%s)", 		     string, commands);  	    continue; 	}! 	ptr++;	/* skip past the colon */n
 	type = *ptr;t   	switch (type) { 	    case 'j': 	    case 'm': 	    case 's': 	        break;s
 	    default:t 	        mesgPane(XRN_INFO,n, 			 "unknown KILL file option: %s", string); 	        break;) 	}  - 	for (i = start; i <= newsgroup->last; i++) {c   	    /* short cut */6 	    if (IS_UNAVAIL(newsgroup->artStatus[INDEX(i)]) ||? 		((type == 'j') && IS_READ(newsgroup->artStatus[INDEX(i)])) || A 		((type == 'm') && IS_UNREAD(newsgroup->artStatus[INDEX(i)]))) {> 		continue;t 	    }  - 	    if (currentArticles[INDEX(i)].subject || , 	        currentArticles[INDEX(i)].author) {  . 		subject = currentArticles[INDEX(i)].subject;, 		author = currentArticles[INDEX(i)].author;   		if (subject) {# 		    subj = strip(subject, FALSE);e 		}u   #ifdef SYSV_REGEXp2 		if ((subject && (regex(reRet, subj) != NULL)) ||4 		    (author  && (regex(reRet, author) != NULL))) { #else # 		if ((subject && re_exec(subj)) ||r% 		    (author  && re_exec(author))) {  #endif 		    switch (type) {l 			case 'j':0 			    SET_READ(newsgroup->artStatus[INDEX(i)]);1 			    mesgPane(XRN_INFO | append, "killed - %s",x 				     subject); 			    append = XRN_APPEND;  			    kcount++;
 			    break;e   			case 'm':2 			    SET_UNREAD(newsgroup->artStatus[INDEX(i)]);8 			    mesgPane(XRN_INFO | append, "marked unread - %s", 				     subject); 			    append = XRN_APPEND;X 			    mcount++;
 			    break;i   			case 's':3 			    (void) saveArticle(NIL(char), newsgroup, i);	0 			    mesgPane(XRN_INFO | append, "saved - %s", 				     subject); 			    append = XRN_APPEND;  			    scount++;
 			    break;    			default:; 			    ucount++;
 			    break;i 		    }i 		}S 	    } 	}     }d       append = 0;-   #define printcount(c,m) \      if( c != 0 ) \     {	\ $ 	mesgPane(XRN_INFO | append, m, c, \ 		 ((c==1) ? "" : "s"), \, 		 newsgroup->name); \ 	append = XRN_APPEND; \      }   ,     if (app_resources.verboseKill == True) {1 	printcount(kcount, "killed %d article%s in %s");g8 	printcount(mcount, "marked %d article%s unread in %s");0 	printcount(scount, "saved %d article%s in %s");F 	printcount(ucount, "matched %d article%s with unknown option in %s");     }i   #undef printcounty       mesgEnableRedisplay();       return;r }    /*-  * mark articles as read if in the kill files   */l static void  checkKillFiles(newsgroup)s struct newsgroup *newsgroup; {n
     FILE *fp;   6     if ((fp = fopen(globalKillFile(), "r")) != NULL) { 	killArticles(newsgroup, fp);; 	(void) fclose(fp);;     }   A     if ((fp = fopen(localKillFile(newsgroup, 0), "r")) != NULL) {i 	killArticles(newsgroup, fp);  	(void) fclose(fp);d     }C       return;) }0   /*7  * Find the sort order for this newsgroup and set it upa  */)   static void  setSortOrder(name) char *name;o {+     char rname[200];     char *type;b     XrmValue value;i     XrmValue converted;o   #ifdef MOTIF3     sprintf(rname, "mxrn.%s.sortedSubjects", name);t #else 3     sprintf(rname, "dxrn.%s.sortedSubjects", name);; #endif7     if (XrmGetResource(XtDatabase(XtDisplay(TopLevel)), - 			rname, "SortedSubjects", &type, &value)) {  	converted.addr = NULL;w 	converted.size = 0;A 	XtConvert(TopLevel, type, &value, "SortedSubjects", &converted);r 	if (converted.addr) {E 	    app_resources.sortedSubjects = (int) *((int *)(converted.addr));n	 	} else {,D 	    app_resources.sortedSubjects = app_resources.defSortedSubjects; 	}     } else {@ 	app_resources.sortedSubjects = app_resources.defSortedSubjects;     }  }        static void*! setUpGroup(newsgroup, killfilesp)h struct newsgroup *newsgroup;? int killfilesp;		/* check kill files? no for jumpToNewsgroup */  {w     art_num first, last;     int number;      *     /* get the latest group information */6     if (getgroup(newsgroup, &first, &last, &number)) { 	return;     } "     if (!EMPTY_GROUP(newsgroup)) {!         CurrentGroup = newsgroup;** 	currentArticles = GETARTICLES(newsgroup);- 	newsgroup->artStatus = GETSTATUS(newsgroup);  	newsgroup->initial = 0;4 	articleArrayResync(newsgroup, first, last, number);& 	setCurrentArticle(newsgroup, UNREAD);* 	NextPreviousArticle = newsgroup->current;0 	if (!getoverview(newsgroup, newsgroup->current, 			 newsgroup->last, False)) {2 	    getsubjectlist(newsgroup, newsgroup->current, 			newsgroup->last, False);p1 	    getauthorlist(newsgroup, newsgroup->current,L 			newsgroup->last, False);o0 	    getlineslist(newsgroup, newsgroup->current, 			newsgroup->last, False);u0 	    getmsgidlist(newsgroup, newsgroup->current, 			newsgroup->last, False); / 	    getrefslist(newsgroup, newsgroup->current,* 			newsgroup->last, False);* 	}7 	if (killfilesp && (app_resources.killFiles == TRUE)) {  	    checkKillFiles(newsgroup);g 	}     }L"     setSortOrder(newsgroup->name);     return;  }    /*  * goto a particular newsgroup  */; int  gotoNewsgroup(name)i char *name;t {x     char *ptr;      struct newsgroup *newsgroup;  2     if (!avl_lookup(NewsGroupTable, name, &ptr)) {> 	mesgPane(XRN_SERIOUS, "Newsgroup `%s' does not exist", name); 	return BAD_GROUP;     }C  )     newsgroup = (struct newsgroup *) ptr;r     CurrentGroup = newsgroup;a"     setSortOrder(newsgroup->name);     return GOOD_GROUP; }n      /*  * goto a particular newsgroup?  *   if all of the articles have been read, unmark the last oner  */f int  gotoNewsgroupForRead(name) char *name;n {n     char *ptr;      struct newsgroup *newsgroup;     art_num i;  2     if (!avl_lookup(NewsGroupTable, name, &ptr)) {> 	mesgPane(XRN_SERIOUS, "Newsgroup `%s' does not exist", name); 	return BAD_GROUP;     }   )     newsgroup = (struct newsgroup *) ptr;i     CurrentGroup = newsgroup;(     !     if (EMPTY_GROUP(newsgroup)) {i 	mesgPane(XRN_SERIOUS,: 	    "Cannot go to the newsgroup, no articles available"); 	return BAD_GROUP;     }(     /*C      * if there are no unread articles, find the last available oner      * and mark it as unread      *6      * XXX bug if the last article becomes unavailable      */ -     if (unreadArticleCount(newsgroup) == 0) {A3 	if (newsgroup->artStatus == NIL(struct artStat)) {n 	    mesgPane(XRN_SERIOUS,7 		"Cannot go to the newsgroup, no articles available");S 	    return BAD_GROUP; 	}	    n5 	assert(newsgroup->artStatus != NIL(struct artStat));r8 	for (i = newsgroup->last; i >= newsgroup->first; i--) {7 	    if (!IS_UNAVAIL(newsgroup->artStatus[INDEX(i)])) {*- 		SET_UNREAD(newsgroup->artStatus[INDEX(i)]);e 		break; 	    } 	}     }u     return GOOD_GROUP; }    /*I  * set the current state to indicate that we're in a particular newsgroupi  */  int, setNewsgroup(name) char *name;y {d     char *ptr;      struct newsgroup *newsgroup;  2     if (!avl_lookup(NewsGroupTable, name, &ptr)) {> 	mesgPane(XRN_SERIOUS, "Newsgroup `%s' does not exist", name); 	return BAD_GROUP;     }   )     newsgroup = (struct newsgroup *) ptr;      CurrentGroup = newsgroup; "     setSortOrder(newsgroup->name);     return GOOD_GROUP; }m   static struct newsgroup *s findNewsGroupMatch(name) char *name;  {w     static char *reRet;-
     int i;  3     /* no single character queries, to comfusing */a     if (strlen(name) == 1) { 	return NIL(struct newsgroup);     }s   #ifdef SYSV_REGEXd/     if ((reRet = regcmp(name, NULL)) == NULL) {i 	return NIL(struct newsgroup);     }w #else>*     if ((reRet = re_comp(name)) != NULL) { 	return NIL(struct newsgroup);     }) #endif    *     for (i = 0; i < MaxGroupNumber; i++) {) 	struct newsgroup *newsgroup = Newsrc[i];  #ifdef SYSV_REGEXt- 	if (regex(reRet, newsgroup->name) != NULL) {e 	    return newsgroup; 	} #elsee  	if (re_exec(newsgroup->name)) { 	    return newsgroup; 	} #endif 	    ,     }o  !     return NIL(struct newsgroup);O }t   /*  * goto a particular newsgroup?  *   if all of the articles have been read, unmark the last one   *// int  jumpToNewsgroup(name)w char *name;c {e     char *ptr;      struct newsgroup *newsgroup;     art_num i;     2     if (!avl_lookup(NewsGroupTable, name, &ptr)) {0 	/* is not the full name, try regexp matching */G 	if ((newsgroup = findNewsGroupMatch(name)) == NIL(struct newsgroup)) {aB 	    mesgPane(XRN_SERIOUS, "Newsgroup `%s' does not exist", name); 	    return BAD_GROUP; 	}     } else {& 	newsgroup = (struct newsgroup *) ptr;     }s       CurrentGroup = newsgroup;t  !     if (EMPTY_GROUP(newsgroup)) {tL 	mesgPane(XRN_SERIOUS, "Cannot go to the newsgroup, no articles available"); 	return BAD_GROUP;     }        SETARTICLES(newsgroup);	  $     if (!IS_SUBSCRIBED(newsgroup)) {% 	updateArticleArray(newsgroup, True);      }i       /*C      * if there are no unread articles, find the last available one       * and mark it as unread      *6      * XXX bug if the last article becomes unavailable      */ -     if (unreadArticleCount(newsgroup) == 0) { 3 	if (newsgroup->artStatus == NIL(struct artStat)) {iP 	    mesgPane(XRN_SERIOUS, "Cannot go to the newsgroup, no articles available"); 	    return BAD_GROUP; 	}5 	assert(newsgroup->artStatus != NIL(struct artStat));_8 	for (i = newsgroup->last; i >= newsgroup->first; i--) {7 	    if (!IS_UNAVAIL(newsgroup->artStatus[INDEX(i)])) { - 		SET_UNREAD(newsgroup->artStatus[INDEX(i)]);  		break; 	    } 	}     }J     setUpGroup(newsgroup, 0);A     return GOOD_GROUP; }       /*  * get the newsgroup  *#  * returns:  XRN_NOMORE - bad group	  *           XRN_OKAY   - okay  */  intA getNewsgroup() {x/     struct newsgroup *newsgroup = CurrentGroup;k  J     if (IS_SUBSCRIBED(newsgroup) && (unreadArticleCount(newsgroup) > 0)) { 	setUpGroup(newsgroup, 1); 	return XRN_OKAY;t     }s          return XRN_NOMORE; }g   /*+  * mark all articles in a newsgroup as read   *:  *   other functions will take care of releasing resources  *  *   returns: void  *  */C void	 catchUp()l { /     struct newsgroup *newsgroup = CurrentGroup;e     art_num art;       SETSTATUS(newsgroup); A     for (art = newsgroup->first; art <= newsgroup->last; art++) {*5 	if (IS_UNMARKED(newsgroup->artStatus[INDEX(art)])) { 0 	    SET_READ(newsgroup->artStatus[INDEX(art)]);	 	} else { 2 	    SET_UNREAD(newsgroup->artStatus[INDEX(art)]);4 	    SET_UNMARKED(newsgroup->artStatus[INDEX(art)]); 	}     }o     return;0 }&     intu issubscribed() {	/     struct newsgroup *newsgroup = CurrentGroup;   #     if (IS_SUBSCRIBED(newsgroup)) {	
 	return 1;     } else {
 	return 0;     }g }p   /*  * subscribe to a newsgroups  *  *   returns: void  *  */  void subscribe()  {i/     struct newsgroup *newsgroup = CurrentGroup;t     $     if (!IS_SUBSCRIBED(newsgroup)) { 	SET_SUB(newsgroup);% 	updateArticleArray(newsgroup, True);>     }l     return;  }    /*  * unsubscribe to a newsgroupl  *  *   returns: void  *  */o void
 unsubscribe()o {t/     struct newsgroup *newsgroup = CurrentGroup;h          SET_UNSUB(newsgroup);c     return;) }{   /*7  * build a string that is used as the question for whate!  * to do at the end of an article   *+  *   returns: the question in a static area   *  */ 
 static char *n buildQuestion(newsgroup) struct newsgroup *newsgroup; { "     static char dummy[LABEL_SIZE];     art_num i;3     struct artStat *artstat = GETSTATUS(newsgroup);      long unread = 0;     ng_num number;$     struct newsgroup *nextnewsgroup;     int found;     ;     for (i = newsgroup->first; i <= newsgroup->last; i++) {e 	long indx = INDEX(i);> 	if (IS_UNREAD(artstat[indx]) && !IS_UNAVAIL(artstat[indx])) { 	    unread++; 	}     }[ 	    I     found = 0;D     for (number = CurrentGroup->newsrc + 1; number < MaxGroupNumber;
 	 number++) {F  	nextnewsgroup = Newsrc[number];A 	/* find a group that is subscribed to and has unread articles */_O 	if (IS_SUBSCRIBED(nextnewsgroup) && (unreadArticleCount(nextnewsgroup) > 0)) {  	    found = 1;) 	    break;r 	}     }B 	    "     if (found) { 	if (unread <= 0) {*Q 	    (void) sprintf(dummy, "Article %ld in %s\nNext group: %s, with %d articles", * 			   newsgroup->current, newsgroup->name,> 			   nextnewsgroup->name, unreadArticleCount(nextnewsgroup));	 	} else { a 	    (void) sprintf(dummy, "Article %ld in %s (%ld remaining)\nNext group: %s, with %d articles",N2 			   newsgroup->current, newsgroup->name, unread,> 			   nextnewsgroup->name, unreadArticleCount(nextnewsgroup)); 	}     } else { 	if (unread <= 0) {n/ 	    (void) sprintf(dummy, "Article %ld in %s", + 			   newsgroup->current, newsgroup->name);)	 	} else {m? 	    (void) sprintf(dummy, "Article %ld in %s (%ld remaining)",r3 			   newsgroup->current, newsgroup->name, unread);u 	}     }p     return dummy;n }o   char *currentQuestion()  {f/     struct newsgroup *newsgroup = CurrentGroup;e$     return buildQuestion(newsgroup); }l   /*7  * build a string that is used as the question for what)!  * to do at the end of an article   *+  *   returns: the question in a static area=  *  */C char * openQuestion() { /     struct newsgroup *newsgroup = CurrentGroup; "     static char dummy[LABEL_SIZE];     art_num i;3     struct artStat *artstat = GETSTATUS(newsgroup);t     long unread = 0;     ng_num number;$     struct newsgroup *nextnewsgroup;     int found;  ;     for (i = newsgroup->first; i <= newsgroup->last; i++) {t 	long indx = INDEX(i);> 	if (IS_UNREAD(artstat[indx]) && !IS_UNAVAIL(artstat[indx])) { 	    unread++; 	}     }| 	          found = 0;D     for (number = CurrentGroup->newsrc + 1; number < MaxGroupNumber;
 	 number++) {   	nextnewsgroup = Newsrc[number];A 	/* find a group that is subscribed to and has unread articles */nO 	if (IS_SUBSCRIBED(nextnewsgroup) && (unreadArticleCount(nextnewsgroup) > 0)) {c 	    found = 1;u 	    break;t 	}     }* 	          if (found) { 	if (unread <= 0) {LH 	    (void) sprintf(dummy, "Group %s\nNext group: %s, with %d articles", 			   newsgroup->name,> 			   nextnewsgroup->name, unreadArticleCount(nextnewsgroup));	 	} else {oX 	    (void) sprintf(dummy, "Group %s (%ld remaining)\nNext group: %s, with %d articles", 			   newsgroup->name, unread,> 			   nextnewsgroup->name, unreadArticleCount(nextnewsgroup)); 	}     } else { 	if (unread <= 0) { 8 	    (void) sprintf(dummy, "Group %s", newsgroup->name);	 	} else {n6 	    (void) sprintf(dummy, "Group %s (%ld remaining)", 			   newsgroup->name, unread);i 	}     }t     return dummy;l }f   static voidz handleXref(article)U art_num article; { >     char *string, *ptr, *token, group[GROUP_NAME_SIZE], *gptr;     int count, number;      struct newsgroup *newsgroup;       #     xhdr(article, "xref", &string);"       if (string == NIL(char)) { 	/* no xrefs */R 	return;     }r       /*$      * an xrefs line is of the form:      *9      *   host group:number group:number .... group:numberc      */   2     if ((ptr = index(string, ' ')) == NIL(char)) { 	FREE(string); 	return;     }r  5     while ((token = strtok(ptr, " ")) != NIL(char)) {  	ptr = NIL(char);n 	e4 	count = sscanf(token, "%[^: ]:%d", group, &number); 	if (count != 2) { 	    /* bogus entry */ 	    continue; 	}  1 	if (!avl_lookup(NewsGroupTable, group, &gptr)) {p 	    /* bogus group */ 	    continue; 	}  . 	/* only Xref groups that are subscribed to */ 	 ' 	newsgroup = (struct newsgroup *) gptr;o    	if (IS_SUBSCRIBED(newsgroup) &&C 	    (number >= newsgroup->first) && (number <= newsgroup->last)) {/? 	    SETSTATUS(newsgroup);	/* defer until we have to do this */r  3 	    SET_READ(newsgroup->artStatus[INDEX(number)]);  	}     }(     FREE(string);n     return;} }    /*  * get the next articlec  *1  * returns: XRN_ERROR - article has been canceledv(  *          XRN_OKAY  - article returned  */  intr getArticleText(text, question) char **text; char **question; {E/     struct newsgroup *newsgroup = CurrentGroup;L6     struct article *articles = GETARTICLES(newsgroup);3     struct artStat *artstat = GETSTATUS(newsgroup);)     long indx = CURRENT;     int header, rotation;I #ifdef XLATE     int	xlation; #endif /* XLATE */
     int i;     static int artIndex = -1;t   /*;  *  Point to next cell in the index array, wrapping around.m  */      if (artIndex < 4) {  	artIndex++;     } else { 	artIndex = 0;     }  /*@  *  Is this article one of the last five read? If so, re-use the  *  stored article array  */*     for (i = 0; i < 5; i++) {t 	if (PrevArtIndx[i] == indx) { 	    artIndex = i; 	    break;b 	}     }  /*?  *  If No match found, we free the article text for the currento<  *  cell in the storage array. Else, it's left in the cache.  */sK     if ((PrevArtIndx[artIndex] != -1) && (PrevArtIndx[artIndex] != indx)) {a! 	if (PrevArtIndx[artIndex] < 0 || B 	    PrevArtIndx[artIndex] > newsgroup->last - newsgroup->first) { 		PrevArtIndx[artIndex] = -1;t	 	} else {i1 	    CLEAR_TEXT(articles[PrevArtIndx[artIndex]]);r3 	    SET_UNFETCHED(artstat[PrevArtIndx[artIndex]]);s  	    PrevArtIndx[artIndex] = -1; 	}     }t  &     if (IS_UNFETCHED(artstat[indx])) { 	r6 	/* get the article and handle unavailable ones.... */H 	header = (IS_ALL_HEADERS(artstat[indx]) ? FULL_HEADER : NORMAL_HEADER);@ 	rotation = (IS_ROTATED(artstat[indx]) ? ROTATED : NOT_ROTATED); #ifdef XLATE< 	xlation = (IS_XLATED(artstat[indx]) ? XLATED : NOT_XLATED);; 	if ((articles[indx].text = getarticle(newsgroup->current, l& 				         &articles[indx].position,0 					 header, rotation,xlation)) == NIL(char)) { #else /* XLATE */-; 	if ((articles[indx].text = getarticle(newsgroup->current,  & 				         &articles[indx].position,( 					 header, rotation)) == NIL(char)) { #endif /* XLATE */  	    SET_UNAVAIL(artstat[indx]);r 	    mesgPane(XRN_SERIOUS, "Can not get the next article, it was canceled by the author or a file system filled"); 	    return XRN_ERROR; 	} 	SET_FETCHED(artstat[indx]);     } else {( 	if (articles[indx].text == NIL(char)) { 	    /* refetch the text */ " 	    SET_UNFETCHED(artstat[indx]);+ 	    return getArticleText(text, question);  	}	    e     }	        *text = articles[indx].text;     SET_READ(artstat[indx]);)     *question = buildQuestion(newsgroup);	#     handleXref(newsgroup->current);, /*)  *  Save the index of this article in thea  *  cache array   */P!     PrevArtIndx[artIndex] = indx;o     return XRN_OKAY; })     intt toggleHeaders(text, question)e char **text; char **question; {m/     struct newsgroup *newsgroup = CurrentGroup;c6     struct article *articles = GETARTICLES(newsgroup);3     struct artStat *artstat = GETSTATUS(newsgroup);      long indx = CURRENT;
     int i; /*:  *  Find the article in the storage array and "forget" it.  */d     for (i = 0; i < 5; i++) {t 	if (PrevArtIndx[i] == indx) {# 	    CLEAR_TEXT(articles[CURRENT]); % 	    SET_UNFETCHED(artstat[CURRENT]);e 	    PrevArtIndx[i] = -1;= 	    break;l 	}     }e  +     if (IS_ALL_HEADERS(artstat[CURRENT])) { ( 	SET_STRIPPED_HEADERS(artstat[CURRENT]);     } else {# 	SET_ALL_HEADERS(artstat[CURRENT]);f     }	"     CLEAR_TEXT(articles[CURRENT]);$     SET_UNFETCHED(artstat[CURRENT]);*     return getArticleText(text, question); }t     int  toggleRotation(text, question) char **text; char **question; {h/     struct newsgroup *newsgroup = CurrentGroup;n6     struct article *articles = GETARTICLES(newsgroup);3     struct artStat *artstat = GETSTATUS(newsgroup);x  '     if (IS_ROTATED(artstat[CURRENT])) { ! 	SET_UNROTATED(artstat[CURRENT]);p     } else { 	SET_ROTATED(artstat[CURRENT]);t     }	"     CLEAR_TEXT(articles[CURRENT]);$     SET_UNFETCHED(artstat[CURRENT]);*     return getArticleText(text, question); })   #ifdef XLATE intd toggleXlation(text, question)S char **text; char **question; {./     struct newsgroup *newsgroup = CurrentGroup;b6     struct article *articles = GETARTICLES(newsgroup);3     struct artStat *artstat = GETSTATUS(newsgroup);S  &     if (IS_XLATED(artstat[CURRENT])) {  	SET_UNXLATED(artstat[CURRENT]);     } else { 	SET_XLATED(artstat[CURRENT]);     }	"     CLEAR_TEXT(articles[CURRENT]);$     SET_UNFETCHED(artstat[CURRENT]);*     return getArticleText(text, question); }t #endif /* XLATE */   /*3  * mark the articles in a group that have been read{  *  *   returns: void  *  */Y( #if defined(STDC) && !defined(_NO_PROTO) void: updateArticleArray(struct newsgroup *newsgroup, int force) #elser void$ updateArticleArray(newsgroup, force)M struct newsgroup *newsgroup;    /* newsgroup to update article array for   */n' int force;			/* True to force update */u #endif {n     struct list *item;     art_num art;     extern void XtFree();   #ifndef FIXED_C_NEWS_ACTIVE_FILE     int number;( #endif       if (newsgroup->last == 0) {p 	return;     }   !     if (EMPTY_GROUP(newsgroup)) {u' 	currentArticles = NIL(struct article);o, 	newsgroup->artStatus = NIL(struct artStat); 	return;     }p  0     if (newsgroup->nglist == NIL(struct list)) { 	return;     }	  .     if (!IS_SUBSCRIBED(newsgroup) && !force) {' 	currentArticles = NIL(struct article);>, 	newsgroup->artStatus = NIL(struct artStat); 	return;     }     #ifndef FIXED_C_NEWS_ACTIVE_FILE>     /* get the group range to fix c-news low number problem */2     if ((XRNState & XRN_NEWS_UP) == XRN_NEWS_UP) {J 	(void) getgroup(newsgroup, &newsgroup->first, &newsgroup->last, &number);J 	articleArrayResync(newsgroup, newsgroup->first, newsgroup->last, number);F 	if ((newsgroup->first == 0 && newsgroup->last == 0) || number == 0) {" 	    lsDestroy(newsgroup->nglist);* 	    newsgroup->nglist = NIL(struct list); 	    return; 	}     }  #endif       SETSTATUS(newsgroup);e  "     /* process the .newsrc line */  Q     for (item = newsgroup->nglist; item != NIL(struct list); item = item->next) {  	switch (item->type) { 	    case SINGLE:)3 	    if (item->contents.single > newsgroup->last) {o0 		/* something really bad has happened, reset */Z 		mesgPane(XRN_SERIOUS, "Article numbering problem, marking all articles in %s as unread", 			       newsgroup->name); ? 		for (art = newsgroup->first; art <= newsgroup->last; art++) {o6 		    if (newsgroup->artStatus != NIL(struct artStat))7 			newsgroup->artStatus[INDEX(art)].status = ART_CLEAR;o 		}o 		lsDestroy(newsgroup->nglist);A' 		newsgroup->nglist = NIL(struct list); 	 		return;a 	    }5 	    if (item->contents.single >= newsgroup->first) { M 		newsgroup->artStatus[INDEX(item->contents.single)].status = ART_CLEAR_READ;  	    } 	    break;l   	    case RANGE:: 	    if ((item->contents.range.start > newsgroup->last) ||1 		(item->contents.range.end > newsgroup->last)) {e0 		/* something really bad has happened, reset */3 		if (newsgroup->first != 0 && newsgroup->last !=0)I 		    mesgPane(XRN_SERIOUS, E 	"Article numbering problem, marking all articles in %s as unread\n",n 			       newsgroup->name);)? 		for (art = newsgroup->first; art <= newsgroup->last; art++) { 6 		    if (newsgroup->artStatus != NIL(struct artStat))7 			newsgroup->artStatus[INDEX(art)].status = ART_CLEAR;a 		}s 		lsDestroy(newsgroup->nglist);n' 		newsgroup->nglist = NIL(struct list); 	 		return;w 	    }9 	    if (item->contents.range.start < newsgroup->first) {r0 		item->contents.range.start = newsgroup->first; 	    } 	    e7 	    if (item->contents.range.end < newsgroup->first) {  		break; 	    }U 	    for (art = item->contents.range.start; art <= item->contents.range.end; art++) {R; 		newsgroup->artStatus[INDEX(art)].status = ART_CLEAR_READ;m 	    } 	}     }w  !     lsDestroy(newsgroup->nglist);;)     newsgroup->nglist = NIL(struct list);c          return;f }t   /*  * mark an article as read  */n void markArticleAsRead(article) art_num article; {t/     struct newsgroup *newsgroup = CurrentGroup;t       SETSTATUS(newsgroup);s=     SET_READ(newsgroup->artStatus[INDEX((art_num) article)]);uA     SET_UNMARKED(newsgroup->artStatus[INDEX((art_num) article)]);b%     if (app_resources.xrefMarkRead) {p 	handleXref(article);S     }E     return;x }R   /*  * mark an article as unread  */t void markArticleAsUnread(article) art_num article; {)/     struct newsgroup *newsgroup = CurrentGroup;        SETSTATUS(newsgroup); ?     SET_UNREAD(newsgroup->artStatus[INDEX((art_num) article)]);l?     SET_MARKED(newsgroup->artStatus[INDEX((art_num) article)]);      return;r }(   /*  * mark an article as killed  */  void markArticleAsKilled(article) art_num article; { /     struct newsgroup *newsgroup = CurrentGroup;        SETSTATUS(newsgroup); =     SET_READ(newsgroup->artStatus[INDEX((art_num) article)]); ?     SET_KILLED(newsgroup->artStatus[INDEX((art_num) article)]);uA     SET_UNMARKED(newsgroup->artStatus[INDEX((art_num) article)]);l     return;o }=   /*  * mark an article as unkilled  */u void markArticleAsUnkilled(article) art_num article; { /     struct newsgroup *newsgroup = CurrentGroup;g       SETSTATUS(newsgroup);;?     SET_UNREAD(newsgroup->artStatus[INDEX((art_num) article)]); A     SET_UNKILLED(newsgroup->artStatus[INDEX((art_num) article)]);T?     SET_MARKED(newsgroup->artStatus[INDEX((art_num) article)]);      return;  }i   /*!  * Return TRUE if article is read   */* BooleanX articleRead(article) art_num article; {b/     struct newsgroup *newsgroup = CurrentGroup;p       SETSTATUS(newsgroup);rF     return(IS_READ(newsgroup->artStatus[INDEX((art_num) article)])  ||C     	   IS_MARKED(newsgroup->artStatus[INDEX((art_num) article)]));  }    /**  * Return TRUE if article is marked unread  */  Boolean  articleMarkedUnread(article) art_num article; { /     struct newsgroup *newsgroup = CurrentGroup; 3     struct artStat *artstat = GETSTATUS(newsgroup);	)     long indx = INDEX((art_num) article);n  B     return (IS_UNREAD(artstat[indx]) && IS_MARKED(artstat[indx])); }p     /*$  * handle adding items to the newsrc  *  *   3 cases  *  *   1. add to the beginningA  *        move 0 to MaxGroupNumber-1 down 1, update newsrc fieldsf  *        update 0  *        inc MaxGroupNumber  *   2. add to the end  *        inc MaxGroupNumber!  *        update MaxGroupNumber-1uG  *   3. add after a group (newloc is the current location of the group)*9  *      move newloc+1 to end down 1, update newsrc fieldss  *      update newlocd  *      in MaxGroupNumberl  *3  *   And the case of 'subscribe' (assumes it moves)   *  *   1. add to the beginning9  *        move 0 to oldloc-1 down 1, update newsrc fieldsu  *        update 0  *   2. add to the endJ  *        move oldloc+1 to MaxGroupNumber-1 update 1, update newsrc fields!  *        upadte MaxGroupNumber-1e  *   3. add after a groupt  *  */    intM& addToNewsrcBeginning(newGroup, status) char *newGroup;  int status;  {      char *ptr;      struct newsgroup *newsgroup;
     ng_num i;n     6     if (!avl_lookup(NewsGroupTable, newGroup, &ptr)) {B 	mesgPane(XRN_SERIOUS, "Newsgroup `%s' does not exist", newGroup); 	return BAD_GROUP;     }d     )     newsgroup = (struct newsgroup *) ptr;w       CLEAR_NOENTRY(newsgroup);t     if (status == SUBSCRIBE) { 	SET_SUB(newsgroup);     } else { 	SET_UNSUB(newsgroup);     }T-     if (newsgroup->newsrc == NOT_IN_NEWSRC) {b, 	for (i = MaxGroupNumber - 1; i >= 0; i--) { 	    Newsrc[i + 1] = Newsrc[i]; # 	    Newsrc[i + 1]->newsrc = i + 1;  	}      	MaxGroupNumber++; 	U     } else {/ 	for (i = newsgroup->newsrc - 1; i >= 0; i--) {i 	    Newsrc[i + 1] = Newsrc[i]; # 	    Newsrc[i + 1]->newsrc = i + 1;* 	}     }r          newsgroup->newsrc = 0;     Newsrc[0] = newsgroup;          return GOOD_GROUP; }n     int*  addToNewsrcEnd(newGroup, status) char *newGroup;  int status;; {      char *ptr;      struct newsgroup *newsgroup;
     ng_num i;a     6     if (!avl_lookup(NewsGroupTable, newGroup, &ptr)) {B 	mesgPane(XRN_SERIOUS, "Newsgroup `%s' does not exist", newGroup); 	return BAD_GROUP;     }n     )     newsgroup = (struct newsgroup *) ptr;!       CLEAR_NOENTRY(newsgroup);      if (status == SUBSCRIBE) { 	SET_SUB(newsgroup);     } else { 	SET_UNSUB(newsgroup);     }<-     if (newsgroup->newsrc == NOT_IN_NEWSRC) {p 	MaxGroupNumber++;     } else {; 	for (i = newsgroup->newsrc + 1; i < MaxGroupNumber; i++) {_ 	    Newsrc[i - 1] = Newsrc[i];e# 	    Newsrc[i - 1]->newsrc = i - 1;  	}     }d     +     newsgroup->newsrc = MaxGroupNumber - 1;o+     Newsrc[MaxGroupNumber - 1] = newsgroup;i          return GOOD_GROUP; }x     int%3 addToNewsrcAfterGroup(newGroup, afterGroup, status)s char *newGroup;  char *afterGroup;m int status;c {o     char *ptr;%     struct newsgroup *newsgroup, *ng;u     ng_num newloc, i;      6     if (!avl_lookup(NewsGroupTable, newGroup, &ptr)) {B 	mesgPane(XRN_SERIOUS, "Newsgroup `%s' does not exist", newGroup); 	return BAD_GROUP;     }e     )     newsgroup = (struct newsgroup *) ptr;n       CLEAR_NOENTRY(newsgroup);i     if (status == SUBSCRIBE) { 	SET_SUB(newsgroup);     } else { 	SET_UNSUB(newsgroup);     }m8     if (!avl_lookup(NewsGroupTable, afterGroup, &ptr)) {D 	mesgPane(XRN_SERIOUS, "Newsgroup `%s' does not exist", afterGroup); 	return BAD_GROUP;     }(     "     ng = (struct newsgroup *) ptr;     newloc = ng->newsrc;  "     if (newloc == NOT_IN_NEWSRC) {Q 	mesgPane(XRN_SERIOUS, "Newsgroup `%s' is not in your .newsrc file", afterGroup);  	return BAD_GROUP;     }   -     if (newsgroup->newsrc == NOT_IN_NEWSRC) { 5 	for (i = MaxGroupNumber - 1; i >= newloc + 1; i--) {u 	    Newsrc[i + 1] = Newsrc[i];m# 	    Newsrc[i + 1]->newsrc = i + 1;t 	}   	MaxGroupNumber++;  	newsgroup->newsrc = newloc + 1;  	Newsrc[newloc + 1] = newsgroup;       } else { 	e& 	if (newloc + 1 < newsgroup->newsrc) {< 	    for (i = newsgroup->newsrc - 1; i >= newloc + 1; i--) { 		Newsrc[i + 1] = Newsrc[i];  		Newsrc[i + 1]->newsrc = i + 1; 	    }$ 	    newsgroup->newsrc = newloc + 1;$ 	    Newsrc[newloc + 1] = newsgroup; 	    n- 	} else if (newsgroup->newsrc < newloc + 1) { ; 	    for (i = newsgroup->newsrc + 1; i < newloc + 1; i++) {o 		Newsrc[i - 1] = Newsrc[i];  		Newsrc[i - 1]->newsrc = i - 1; 	    }  	    newsgroup->newsrc = newloc;  	    Newsrc[newloc] = newsgroup; 	}= 	/* if its in the correct location already, don't touch it */i     }a          return GOOD_GROUP; }u   	" /*?  * build and return an array that shows the subscription status @  * of all newsgroups; assumes all groups have been subscribed or   * unsubscribed to by this time.  *A  *   if sorted is non-zero, the list is sorted alphabetically, if @  *    zero, the list is returned as it exists in the newsrc file  */( ng_num * getStatusList(sorted){ int sorted;  {0     int i, count = 0;t     avl_generator *gen;g     char *key, *value;     ng_num *ar;i  3     ar = ARRAYALLOC(ng_num, ActiveGroupsCount + 1);-       if (sorted) { 1 	gen = avl_init_gen(NewsGroupTable, AVL_FORWARD);d  % 	while (avl_gen(gen, &key, &value)) { > 	    struct newsgroup *newsgroup = (struct newsgroup *) value; 	    o" 	    if (IS_NOTALIAS(newsgroup)) {" 		ar[count++] = newsgroup->newsrc; 	    } 	} 	avl_free_gen(gen);t 	g     } else {' 	for (i = 0; i < MaxGroupNumber; i++) { B 	    struct newsgroup *newsgroup = (struct newsgroup *) Newsrc[i]; 	    u" 	    if (IS_NOTALIAS(newsgroup)) { 		ar[count++] = i; 	    } 	}
     }	              ar[count++] = -1;t     return ar; }    /*?  * build and return a string that shows the subscription statusN  * of a newsgroup.  */s char * getStatusString(which)
 int which; {       struct newsgroup *newsgroup;#     static char dummy[LINE_LENGTH];_       dummy[0] = '\0';,     if (which < 0 || which > MaxGroupNumber) 	return dummy;       newsgroup = Newsrc[which]; 	    d!     if (IS_NOTALIAS(newsgroup)) {w! 	(void) sprintf(dummy, "%-60s%s",B 		newsgroup->name,> 		IS_SUBSCRIBED(newsgroup) ? "subscribed  " : "unsubscribed");     }      return dummy;p }/ /*'  * build and return the subjects stringS  */A	 art_num *-  getUnSortedArticles(mode, count)	 int mode;  int *count;n { /     struct newsgroup *newsgroup = CurrentGroup;*6     struct article *articles = GETARTICLES(newsgroup);3     struct artStat *artstat = GETSTATUS(newsgroup);e     art_num i;     int	    j;     char *start, *end;     art_num *ar;       *count = 0;r!     if (EMPTY_GROUP(newsgroup)) {t 	return NIL(art_num);I     }w       if (mode == ALL) {? 	newsgroup->initial = newsgroup->current = NextPreviousArticle;      } else {$ 	setCurrentArticle(newsgroup, mode);     }e  /     if (newsgroup->current > newsgroup->last) {e 	return NIL(art_num);n     }x  -     NextPreviousArticle = newsgroup->current;   9     if ((newsgroup->last - newsgroup->current + 1) < 0) {nQ 	(void) sprintf(error_buffer, "Active File Error: last - current + 1 < 0 (%s)\n",t 			       newsgroup->name);  	ehErrorExitXRN(error_buffer);     }i 	P /*2  * Allocate an array to store the article numbers.  */}I     ar = ARRAYALLOC(art_num, (newsgroup->last - newsgroup->current + 3));nB     for (i = 0; i <= (newsgroup->last - newsgroup->current);i++) { 	ar[i] = 0;P     }n  
     j = 0;=     for (i = newsgroup->current; i <= newsgroup->last; i++) {a 	long indx = INDEX(i); 	A@ 	/* canceled and empty articles will not have a subject entry */+ 	if (articles[indx].subject != NIL(char)) {R 	    r? 	    /* don't put articles in the string if already read ... */A 	    if ((mode == ALL) ||P; 	        (mode == UNKILLED && IS_UNKILLED(artstat[indx]) &&D% 				     IS_ACTIVE(artstat[indx])) ||i1 		(mode == ACTIVE && IS_ACTIVE(artstat[indx])) ||I8 	        (mode == UNREAD && IS_UNREAD(artstat[indx]))) { 		if (mode != UNKILLED)E  		    SET_ACTIVE(artstat[indx]); 		ar[j] = i; 		j++; 	    }	 	} else {AH 	    /* if you can't get the subject, mark the article as unavailable */  	    SET_UNAVAIL(artstat[indx]); 	}     }&       *count = j;t     return ar; }      struct entry {     int startingArticle;     art_num *articleList;d
     int used;t
     int left;>
     int size;	 };   static voidi valfree(ptr)
 char *ptr; { -     struct entry *val = (struct entry *) ptr; &     XtFree((char *) val->articleList);     XtFree((char *) val);o     return;t }t    ( #if defined(STDC) && !defined(_NO_PROTO)
 static int( pteCompare(const void *a, const void *b) #elset
 static int pteCompare(a, b) void *a, *b; #endif { ,     struct entry **pa = (struct entry **) a;,     struct entry **pb = (struct entry **) b;  ;     return (*pa)->startingArticle - (*pb)->startingArticle;  }r     /*E  * XXX AVL TREE is the wrong data structure here, hash table would be(:  * better.... no need for ordering based on subject string  */t /*'  * build and return the subjects stringr  */  static art_num * getSortedArticles(mode, count)	 int mode;; int *count;t {o/     struct newsgroup *newsgroup = CurrentGroup;*6     struct article *articles = GETARTICLES(newsgroup);3     struct artStat *artstat = GETSTATUS(newsgroup);n     struct article *art;     art_num i;
     int j, k;r     art_num *ar;       struct entry *pte;     struct entry **pteArray;       avl_generator *gen;e     char *key, *ptr, *p;     avl_tree *tree;i     char curSub[81];     int treeSize, sz;(     char buffer[LINE_LENGTH];U       *count = 0;R!     if (EMPTY_GROUP(newsgroup)) {= 	return NIL(art_num);      }   ,     tree = avl_init_table(utSubjectCompare);       if (mode == ALL) {? 	newsgroup->initial = newsgroup->current = NextPreviousArticle;      } else {$ 	setCurrentArticle(newsgroup, mode);     }(  /     if (newsgroup->current > newsgroup->last) {  	return NIL(art_num);      }e  -     NextPreviousArticle = newsgroup->current;e  9     if ((newsgroup->last - newsgroup->current + 1) < 0) { Q 	(void) sprintf(error_buffer, "Active File Error: last - current + 1 < 0 (%s)\n",  			       newsgroup->name);  	ehErrorExitXRN(error_buffer);     }  	T     /* D       * build the subject groups       */T=     for (i = newsgroup->current; i <= newsgroup->last; i++) {N 	long indx = INDEX(i);  @ 	/* canceled and empty articles will not have a subject entry */+ 	if (articles[indx].subject != NIL(char)) {s  ? 	    /* don't put articles in the string if already read ... */e 	    if ((mode == ALL) || ; 	        (mode == UNKILLED && IS_UNKILLED(artstat[indx]) &&u% 				     IS_ACTIVE(artstat[indx])) ||u1 		(mode == ACTIVE && IS_ACTIVE(artstat[indx])) ||T8 	        (mode == UNREAD && IS_UNREAD(artstat[indx]))) { 		if (mode != UNKILLED)   		    SET_ACTIVE(artstat[indx]);8 		(void) strncpy(curSub, getSubject(i), sizeof(curSub));" 		curSub[sizeof(curSub)-1] = '\0';  ' 		if (avl_lookup(tree, curSub, &ptr)) {  		    /* add to the end */! 		    pte = (struct entry *) ptr;  		    if (pte->left <= 0) {( 			pte->left = pte->size;i 			pte->size = pte->size * 2;g 			pte->articleList =r3 				(art_num *) XtRealloc((char *)pte->articleList,n' 					     pte->size * sizeof(art_num));p 		    }c& 		    pte->articleList[pte->used] = i; 		    pte->used++; 		    pte->left--;
 		} else { 		    /* create new */  		    pte = ALLOC(struct entry); 		    pte->startingArticle = i;n1 		    pte->articleList = ARRAYALLOC(art_num, 32);  		    pte->used = 1; 		    pte->size = 32;e( 		    pte->left = pte->size - pte->used; 		    pte->articleList[0] = i;A 		    (void) avl_insert(tree, XtNewString(curSub), (char *) pte);n 		}  	    }	 	} else {)H 	    /* if you can't get the subject, mark the article as unavailable */  	    SET_UNAVAIL(artstat[indx]); 	}     }g  
     i = 0;     treeSize = avl_count(tree);;+     if (treeSize == 0) {		/* No articles */ ' 	avl_free_table(tree, XtFree, valfree);l 	return NIL(art_num);      }X  4     pteArray = ARRAYALLOC(struct entry *, treeSize);*     gen = avl_init_gen(tree, AVL_FORWARD);&     while (avl_gen(gen, &key, &ptr)) {& 	pteArray[i++] = (struct entry *) ptr;     }b     avl_free_gen(gen);        /* sort by article number */7     if (app_resources.sortedSubjects == ARTICLE_SORTED) F 	qsort((void *) pteArray, treeSize, sizeof(struct pte *), pteCompare);   /*A  * Allocate a pointer array - with an end null string followed by   * an end pointer of NULLl  */i  I     ar = ARRAYALLOC(art_num, (newsgroup->last - newsgroup->current + 3));cB     for (i = 0; i <= (newsgroup->last - newsgroup->current);i++) { 	ar[i] = 0;g     }   
     j = 0;$     for (i = 0; i < treeSize; i++) {* 	for (k = 0; k < pteArray[i]->used; k++) {+ 	    ar[j++] = pteArray[i]->articleList[k];n 	}     }o  *     avl_free_table(tree, XtFree, valfree);     FREE(pteArray);      ar[j] = 0;     *count = j;t     return ar; }n   /*4  * Build a list of article numbers in threaded order  */e static art_num *  getThreadedArticles(mode, count)	 int mode;s int *count;n { /     struct newsgroup *newsgroup = CurrentGroup;u6     struct article *articles = GETARTICLES(newsgroup);3     struct artStat *artstat = GETSTATUS(newsgroup);e     struct article *art, *art1;      art_num i, num;e
     int j, k;o     art_num *ar;     int num_arts = 0;      struct entry *pte;     struct entry **pteArray;     avl_generator *gen;(     char *key, *ptr, *p;     avl_tree *tree;      char curSub[81];     int treeSize, sz;r     char buffer[LINE_LENGTH];e       *count = 0;"!     if (EMPTY_GROUP(newsgroup)) {	 	return NIL(art_num);i     }t       if (mode == ALL) {? 	newsgroup->initial = newsgroup->current = NextPreviousArticle;n     } else {$ 	setCurrentArticle(newsgroup, mode);     }   /     if (newsgroup->current > newsgroup->last) {s 	return NIL(art_num);      }n  -     NextPreviousArticle = newsgroup->current;   9     if ((newsgroup->last - newsgroup->current + 1) < 0) {pQ 	(void) sprintf(error_buffer, "Active File Error: last - current + 1 < 0 (%s)\n",  			       newsgroup->name);r 	ehErrorExitXRN(error_buffer);     }i 	- /*2  * Allocate an array to store the article numbers.  */aI     ar = ARRAYALLOC(art_num, (newsgroup->last - newsgroup->current + 3));uB     for (i = 0; i <= (newsgroup->last - newsgroup->current);i++) { 	ar[i] = 0;      }*  $     msgids = avl_init_table(strcmp);     if (msgids == NULL) {rK 	(void) sprintf(error_buffer, "Can't build message ID hash table for %s\n",E 			       newsgroup->name);_ 	ehErrorExitXRN(error_buffer);     }m       /* )?      * Step 1: Initialize and build the message ID lookup table)      */      num_arts = 0;r=     for (i = newsgroup->current; i <= newsgroup->last; i++) {R 	long indx = INDEX(i);  @ 	/* canceled and empty articles will not have a subject entry */+ 	if (articles[indx].subject != NIL(char)) {u  ? 	    /* don't put articles in the string if already read ... */p 	    if ((mode == ALL) || ; 	        (mode == UNKILLED && IS_UNKILLED(artstat[indx]) &&n% 				     IS_ACTIVE(artstat[indx])) ||*1 		(mode == ACTIVE && IS_ACTIVE(artstat[indx])) ||i8 	        (mode == UNREAD && IS_UNREAD(artstat[indx]))) { 		if (mode != UNKILLED)n  		    SET_ACTIVE(artstat[indx]);D 		avl_insert(msgids, articles[indx].msgid, (char *)&articles[indx]); 		articles[indx].parent = 0; 		articles[indx].child = 0;) 		ar[num_arts++] = i;n 	    }	 	} else {[H 	    /* if you can't get the subject, mark the article as unavailable */  	    SET_UNAVAIL(artstat[indx]); 	}     }(       /* r-      * Step 2: find parents and link articlesr      */r$     for (i = 0; i < num_arts; i++) { 	long indx = INDEX(ar[i]);  8 	if (avl_lookup(msgids, articles[indx].refs[0], &ptr) ||8 	    avl_lookup(msgids, articles[indx].refs[1], &ptr) ||8 	    avl_lookup(msgids, articles[indx].refs[2], &ptr)) {) 	    art1 = art = (struct article *) ptr;r# 	    articles[indx].parent = ar[i];l 	    /*i 	     * Find end of child chaint 	     */ 	    while (art1->child) {' 		art1 = &articles[INDEX(art1->child)];e 	    } 	    art1->child = ar[i];N 	} a     }        /*  :      * Step 3: subject sort toplevel articles (no parents)      */),     tree = avl_init_table(utSubjectCompare);  $     for (i = 0; i < num_arts; i++) { 	long indx = INDEX(ar[i]);   	if (!articles[indx].parent) {? 	    (void) strncpy(curSub, getSubject(ar[i]), sizeof(curSub));U% 	    curSub[sizeof(curSub)-1] = '\0';a  * 	    if (avl_lookup(tree, curSub, &ptr)) { 		/* add to the end */ 		pte = (struct entry *) ptr;  		if (pte->left <= 0) {  		    pte->left = pte->size;  		    pte->size = pte->size * 2; 		    pte->articleList =2 			(art_num *) XtRealloc((char *)pte->articleList,' 					     pte->size * sizeof(art_num));* 		} & 		pte->articleList[pte->used] = ar[i]; 		pte->used++; 		pte->left--;
 	    } else {3 		/* create new */ 		pte = ALLOC(struct entry); 		pte->startingArticle = ar[i];w- 		pte->articleList = ARRAYALLOC(art_num, 32);  		pte->used = 1; 		pte->size = 32;u$ 		pte->left = pte->size - pte->used; 		pte->articleList[0] = ar[i];= 		(void) avl_insert(tree, XtNewString(curSub), (char *) pte);w 	    } 	}     }f
     i = 0;       treeSize = avl_count(tree);e+     if (treeSize == 0) {		/* No articles */-' 	avl_free_table(tree, XtFree, valfree);  	return NIL(art_num);-     }   4     pteArray = ARRAYALLOC(struct entry *, treeSize);*     gen = avl_init_gen(tree, AVL_FORWARD);&     while (avl_gen(gen, &key, &ptr)) {& 	pteArray[i++] = (struct entry *) ptr;     }      avl_free_gen(gen);        /* sort by article number */I     qsort((void *) pteArray, treeSize, sizeof(struct pte *), pteCompare);A       /*  .      * Step 4: generate output in thread order      */ B     for (i = 0; i <= (newsgroup->last - newsgroup->current);i++) { 	ar[i] = 0;p     }   
     j = 0;$     for (i = 0; i < treeSize; i++) {* 	for (k = 0; k < pteArray[i]->used; k++) {1 	    ar[j++] = num = pteArray[i]->articleList[k];[" 	    art1 = &articles[INDEX(num)]; 	    while (art1->child) { 		ar[j++] = art1->child;' 		art1 = &articles[INDEX(art1->child)];w 	    } 	}     }-  *     avl_free_table(tree, XtFree, valfree);'     avl_free_table(msgids, NULL, NULL);r     FREE(pteArray);-     ar[j] = 0;     *count = j;s     return ar; }e    	 art_num *; getArticleNumbers(mode, count)	 int mode;a int *count;e {o)     if (app_resources.displayLineCount) { > 	sprintf(formatString,"  %%5ld:%%-%d\056%ds %%6.6s %%-%d.%ds",; 		app_resources.subjectLength, app_resources.subjectLength,I: 		app_resources.authorLength, app_resources.authorLength);     } else {8 	sprintf(formatString,"  %%5ld:%%-%d\056%ds  %%-%d.%ds",; 		app_resources.subjectLength, app_resources.subjectLength, : 		app_resources.authorLength, app_resources.authorLength);     } 8     if (app_resources.sortedSubjects == THREAD_SORTED) {) 	return getThreadedArticles(mode, count);-     } '     if (app_resources.sortedSubjects) {w' 	return getSortedArticles(mode, count);      } else {) 	return getUnSortedArticles(mode, count);w     }a }o   /*4  * set the internal pointers to a particular article  */  void gotoArticle(article) art_num article; {r/     struct newsgroup *newsgroup = CurrentGroup;*  +     newsgroup->current = (art_num) article;o,     NextPreviousArticle = (art_num) article;     return;  }g   /*1  * set the internal pointers to the first articlee  */G void gotoFirstArticle() {_/     struct newsgroup *newsgroup = CurrentGroup;p)     art_num article = newsgroup->initial;e  +     newsgroup->current = (art_num) article;A,     NextPreviousArticle = (art_num) article;     return;T }B   into checkArticle(art)  art_num art; {o/     struct newsgroup *newsgroup = CurrentGroup;   5     /* Check if requested article is not available */%:     if (art < newsgroup->first || art > newsgroup->last) {         return XRN_ERROR;w     }*     return XRN_OKAY; }    r   /*8  * first and last are the same and there are no articles  *4  * representation bug in the news system active file  *  */r void bogusNewsgroup() { /     struct newsgroup *newsgroup = CurrentGroup;(    6     if (newsgroup->artStatus != NIL(struct artStat)) {& 	SET_READ(newsgroup->artStatus[LAST]);) 	SET_UNAVAIL(newsgroup->artStatus[LAST]);+     }w  \     mesgPane(XRN_INFO, "No articles in `%s', probably killed or canceled", newsgroup->name);          return;w })    < #define STRIPLEADINGSPACES   for (; *start == ' '; start++);D #define STRIPENDINGSPACES  for ( ; *end == ' '; *end = '\0', end--);  
 static char *> strip(str, striprefs) 
 char *str; Boolean striprefs; { %     register char *start, *end, *ptr; "     static char work[BUFFER_SIZE];       if (str == NIL(char)) {; 	return NIL(char);     } +     (void) strncpy(work, str, BUFFER_SIZE);      start = work;o!     work[BUFFER_SIZE - 1] = '\0';e!     end = index(start, '\0') - 1;i       STRIPLEADINGSPACES;a       /*0      * strip leading '[rR][eE]: ' and 'Re^N: ' -E      * only if striprefs is TRUE (want to be able to kill follow-ups)n      */      if (striprefs) {# 	while (STREQN(start, "Re: ", 4) ||e# 	       STREQN(start, "RE: ", 4) ||.# 	       STREQN(start, "re: ", 4) || # 	       STREQN(start, "Re: ", 4)) {* 	    start += 4; 	 / 	    /* strip leading spaces after '[rR]e: ' */g 	    STRIPLEADINGSPACES; 	}  " 	while (STREQN(start, "Re^", 3)) { 	    start += 3; 	    ptr = index(start, ':');a 	    if (ptr != NIL(char)) { 		start = ptr + 1; 	    } 	    STRIPLEADINGSPACES; 	}  4 	for (end = start; (end = index(end, '(')) != NULL;) 	  if (STREQN(end,"(was:",5)  	      ||  STREQN(end,"(Was:",5)# 	      ||  STREQN(end,"(WAS:",5)) {o 	      *end = '\0'; 
 	      break;A 	  } 	  else ++end;     }t  !     end = index(start, '\0') - 1;      STRIPENDINGSPACES;       return start;( }    /*J  * return the subject of an article with trailing/leading spaces stripped,A  * leading '[rR]e: ' stripped, and trailing ' ([wW]as: ' strippedc  */+ char * getSubject(article)  art_num article; {+/     struct newsgroup *newsgroup = CurrentGroup;r'     art_num artnum = (art_num) article;n       SETARTICLES(newsgroup);*  ?     return strip(currentArticles[INDEX(artnum)].subject, True);g }p   /*"  * return the author of an article  */] char * getAuthor(article) art_num article; {w/     struct newsgroup *newsgroup = CurrentGroup;s6     struct article *articles = GETARTICLES(newsgroup);  5     return articles[INDEX((art_num) article)].author;u }n   /*   * return the text of an article  */d char * getText(article) art_num article; {y/     struct newsgroup *newsgroup = CurrentGroup;n6     struct article *articles = GETARTICLES(newsgroup);  3     return articles[INDEX((art_num) article)].text;s }u   /*D  * get the previous subject (article number is NextPreviousArticle).;  * only called when going off the top of the subject string_  *%  *   returns a point to a static arean  *I  *  NextPreviousArticle is set to current on building the subject string.r7  *  NextPreviousArticle is decremented by this routine.n  */o char * getPrevSubject() {e/     struct newsgroup *newsgroup = CurrentGroup;r6     struct article *articles = GETARTICLES(newsgroup);  H     /* search for the next available article in the reverse direction */     for (NextPreviousArticle--;eC 	 NextPreviousArticle >= newsgroup->first; NextPreviousArticle--) {(( 	long indx = INDEX(NextPreviousArticle); 	r. 	if (NextPreviousArticle < newsgroup->initial). 	    newsgroup->initial = NextPreviousArticle;  @ 	/* get the subject (and author) if it does not already exist */+ 	if (articles[indx].subject == NIL(char)) {u  ) 	    /* get the subject and a few more */  	    getsubjectlist(newsgroup,< 			   MAX(newsgroup->first, NextPreviousArticle - SUBJECTS)," 			   NextPreviousArticle, False); 	}  * 	if (articles[indx].author == NIL(char)) { 	    getauthorlist(newsgroup,a; 			  MAX(newsgroup->first, NextPreviousArticle - SUBJECTS),." 			   NextPreviousArticle, False);   	}  ) 	if (articles[indx].lines == NIL(char)) {e 	    getlineslist(newsgroup,: 			 MAX(newsgroup->first, NextPreviousArticle - SUBJECTS),  			 NextPreviousArticle, False); 	}  ) 	if (articles[indx].msgid == NIL(char)) {a 	    getmsgidlist(newsgroup,: 			 MAX(newsgroup->first, NextPreviousArticle - SUBJECTS),  			 NextPreviousArticle, False); 	}  + 	if (articles[indx].refs[0] == NIL(char)) {  	    getrefslist(newsgroup,t: 			 MAX(newsgroup->first, NextPreviousArticle - SUBJECTS),  			 NextPreviousArticle, False); 	}   	if (articles[indx].subject) {0 	    (void) getSubjectLine(NextPreviousArticle); 	    return subjectline; 	} 	/* continue on */     }        return NIL(char);t }v    Y static art_num justInCase;   /* old NextPreviousArticle, just in case the search fails */(   void
 startSearch()tM /* the front-end is about to do an article search, save the starting point */i {(%     justInCase = NextPreviousArticle;t     return;s }o     void failedSearch(); /* the article search failed, restore the original point */y {p%     NextPreviousArticle = justInCase;t     return;r }      void fillUpArray(art) art_num art; {i/     struct newsgroup *newsgroup = CurrentGroup;X  #     if (art < newsgroup->current) {eC 	if (!getoverview(newsgroup, art, newsgroup->current - 1, False)) { C 	    getsubjectlist(newsgroup, art, newsgroup->current - 1, False);*B 	    getauthorlist(newsgroup, art, newsgroup->current - 1, False);A 	    getlineslist(newsgroup, art, newsgroup->current - 1, False); A 	    getmsgidlist(newsgroup, art, newsgroup->current - 1, False);t@ 	    getrefslist(newsgroup, art, newsgroup->current - 1, False); 	}     }      return;, }r     /*1  * getinfofromfile	Get a string from a named filet%  *			Handle white space and comments.n  *6  *	Parameters:	"file" is the name of the file to read.  *6  *	Returns:	Pointer to static data area containing the+  *			first non-ws/comment line in the file.R.  *			NULL on error (or lack of entry in file).  *  *	Side effects:	None.  */t   char * getinfofromfile(file)= char	*file;w {o 	register FILE	*fp;u 	register char	*cp;i 	static char	buf[256]; 	char		*getenv();c   	if (file == NULL) 		return (NULL);   	fp = fopen(file, "r");o 	if (fp == NULL) 		return (NULL);  / 	while (fgets(buf, sizeof (buf), fp) != NULL) {r" 		if (*buf == '\n' || *buf == '#') 			continue; 		cp = index(buf, '\n');	 		if (cp)r 			*cp = '\0'; 		(void) fclose(fp); 		return (buf);( 	}   	(void) fclose(fp);u! 	return (NULL);			 /* No entry */u }r   char * getSubjectLine(art)* art_num art; {t/     struct newsgroup *newsgroup = CurrentGroup;n6     struct article *articles = GETARTICLES(newsgroup);3     struct artStat *artstat = GETSTATUS(newsgroup);u     long indx = INDEX(art);[       subjectline[0] = '\0';8     if (art < newsgroup->first || art > newsgroup->last) 	return subjectline;)     if (app_resources.displayLineCount) {D+ 	(void) sprintf(subjectline, formatString, I
 		       art,t/ 		       (articles[indx].subject != NIL(char) ?t' 		       articles[indx].subject : " "),&- 		       (articles[indx].lines != NIL(char) ?N% 		       articles[indx].lines : " "),]. 		       (articles[indx].author == NIL(char) ?, 		       "(none)" : articles[indx].author));     } else {* 	(void) sprintf(subjectline, formatString,
 		       art,// 		       (articles[indx].subject != NIL(char) ?t' 		       articles[indx].subject : " "),e. 		       (articles[indx].author == NIL(char) ?, 		       "(none)" : articles[indx].author));     }t6     /* mark articles if they have already been read */!     if (IS_READ(artstat[indx])) {> 	subjectline[0] = '+';     } else { 	subjectline[0] = ' ';     } #     if (IS_KILLED(artstat[indx])) {t 	subjectline[0] = 'k';     }n?     if (IS_UNREAD(artstat[indx]) && IS_MARKED(artstat[indx])) {  	subjectline[0] = 'u';     }t"     if (IS_SAVED(artstat[indx])) { 	subjectline[1] = 'S';*     } else if(IS_PRINTED(artstat[indx])) { 	subjectline[1] = 'P';     } else { 	subjectline[1] = ' ';     }}     return subjectline;c }t