  % #if !defined(lint) && !defined(SABER)  static char XRNrcsid[] = "$Header: /net/objy27/wrld/mnt11/ricks/src/master/xrn/cursor.c,v 1.5 1993/01/11 02:14:44 ricks Exp $";  #endif   /*$  * xrn - an X-based NNTP news reader  *G  * Copyright (c) 1988-1993, Ellen M. Sentovich and Rick L. Spickelmier.   *H  * Permission to use, copy, modify, and distribute this software and itsL  * documentation for any purpose and without fee is hereby granted, providedJ  * that the above copyright notice appear in all copies and that both thatC  * copyright notice and this permission notice appear in supporting G  * documentation, and that the name of the University of California not E  * be used in advertising or publicity pertaining to distribution of  K  * the software without specific, written prior permission.  The University G  * of California makes no representations about the suitability of this G  * software for any purpose.  It is provided "as is" without express or   * implied warranty.  *H  * THE UNIVERSITY OF CALIFORNIA DISCLAIMS ALL WARRANTIES WITH REGARD TO J  * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND H  * FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE FORK  * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER G  * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF G  * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN  ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   */    /*G  * cursor.c: routines for manipulating the cursor and/or text in a text   *           window   */    #include "copyright.h" #include "config.h"  #include <stdio.h> #ifdef __STDC__  #include <stdlib.h>  #endif #include "utils.h" #include "mesg.h"  #include "news.h"  #include "internals.h" #include "modes.h" #include "xrn.h" #include "cursor.h"  #include "error_hnds.h"    /*4  * Return the name of the group on the current line.!  * Assume there is a group there.   */  void* currentNewsgroup(mode, tstring, groupName) int mode;			/* xrn Mode */" char *tstring;			/* text string */6 char *groupName;		/* string to return group name in */ { 3     if ((mode != ALL_MODE) && (mode != ADD_MODE)) { < 	if (sscanf(&tstring[0], NEWS_GROUP_LINE, groupName) == 1) { 	    return;	 	} else {  	    *groupName = '\0';  	    return; 	}     } else {- 	(void) sscanf(&tstring[0], "%s", groupName);      }      return;  }    /*6  * Return the status of the group on the current line.  */  void% currentMode(tstring, groupName, mode)  char *tstring; char *groupName;
 int *mode; {      char status[100];   ;     (void) sscanf(&tstring[0], "%s %s", groupName, status); -     if (strcmp(status,"unsubscribed") == 0) {  	*mode = UNSUBSCRIBE;      } else { 	*mode = SUBSCRIBE;      }      return;  }    /*C  * Mark the article at the current ArticlePosition as read,if it is ?  * not already marked. Return the article number of the article @  * that was marked.  This subroutine only marks the text string;7  * the article is marked internally as read by calling    * markArticleAsRead().   */  int  markStringRead(tstring) " char *tstring;			/* text string */ {      if (tstring[0] == ' ') { 	tstring[0] = '+';     }      return atoi(&tstring[2]);  }    /*%  * Mark an article as read or unread.   */  void markArticle(artNum, marker)  art_num artNum; % int marker;			/* either '+' or ' ' */  { )     if (marker == '+' || marker == 'S') {  	markArticleAsRead(artNum);      } else { 	if (marker != 'P') { ! 	    markArticleAsUnread(artNum);  	}     }      return;  }    int ? subjectSearch(dir, artnums, position, expr, text, ques, artNum) 2 int dir;			/* direction, either FORWARD or BACK */: art_num *artnums;		/* text string (may be changed here) */' int  *position;			/* cursor position */ 4 char *expr;			/* regular expression to search for */@ char **text, **ques;		/* text and status line for new article */- art_num *artNum;		/* number of new article */  {  #ifdef SYSV_REGEX      extern char *regcmp();     extern char *regex();  #else 6     char *re_comp();		/* regular expression routine */ #endif9     static char *reRet;		/* returned by re_comp/regcmp */ 4     char *newsubject;		/* subject of current line */C     char lowersubject[128];	/* lowercase subject of current line */      char *newLine;     extern void abortClear();      extern int abortP();)     static Boolean caseSensitive = False;        abortClear();        if (expr != NIL(char)) {! 	utLowerCase(lowersubject, expr); ' 	if (strcmp(expr, lowersubject) != 0) {  	    caseSensitive = True;	 	} else {  	    caseSensitive = False;  	}   #ifdef SYSV_REGEX , 	if ((reRet = regcmp(expr, NULL)) == NULL) { #else ' 	if ((reRet = re_comp(expr)) != NULL) {  #endif! 	    /* bad regular expression */  #ifdef SYSV_REGEX : 	    mesgPane(XRN_SERIOUS, "error in regular expression"); #else " 	    mesgPane(XRN_SERIOUS, reRet); #endif 	    failedSearch(); 	    return ERROR; 	}     }        if (dir == FORWARD) {  	for (;;) {  	    if (abortP()) { 		return ABORT;  	    }# 	    if (artnums[*position] == 0) {  		if (*position == 0) {   9 		    /* the string is null, no more articles are left */    		    return EXIT; 		}  		return NOMATCH;  	    } 	    *position = *position + 1; # 	    if (artnums[*position] == 0) {    		/* reached end of string */    		return NOMATCH;  	    }" 	    *artNum = artnums[*position];& 	    newsubject = getSubject(*artNum); 	    if (caseSensitive) { # 		strcpy(lowersubject, newsubject); 
 	    } else { ( 		utLowerCase(lowersubject, newsubject); 	    }   #ifdef SYSV_REGEX . 	    if (regex(reRet, lowersubject) != NULL) { #else ! 	    if (re_exec(lowersubject)) {  #endif/ 		/* found a match to the regular expression */    		gotoArticle(*artNum); / 		if (getArticleText(text, ques) != XRN_OKAY) {   , 		    /* the matching article was invalid */   		    continue;  		}  		return MATCH;  	    } 	}     } else { 	startSearch();  	for (;;) {  	    if (abortP()) {  8 		/* reset pointers back to where we began, since the */ 		/* search was aborted */   		failedSearch();  		return ABORT;  	    } 	    if ((*position == 0) && 		(artnums[*position] == 0) ) {   8 		/* no more articles remain, return to Newgroup mode */   		return EXIT; 	    } 	    if (*position != 0) {  , 		/* we are still within the subject list */   		*position = *position - 1; 		*artNum = artnums[*position]; # 		newsubject = getSubject(*artNum);  		if (caseSensitive) {, 		    utLowerCase(lowersubject, newsubject);
 		} else {' 		    strcpy(lowersubject, newsubject);  		}    #ifdef SYSV_REGEX + 		if (regex(reRet, lowersubject) != NULL) {  #else  		if (re_exec(lowersubject)) { #endif@ 		    /* an article matching the regular expression was found */   		    gotoArticle(*artNum); 3 		    if (getArticleText(text, ques) != XRN_OKAY) {   : 			/* article is invalid, remove it from the text string*/   			continue; 		    }  		    return MATCH;  		} 
 	    } else {   9 		/* must query the news server for articles not shown */ % 		/* on the current subject screen */   2 		if ((newLine = getPrevSubject()) == NIL(char)) { 		    = 		    /* all articles have been exhausted, reset variables */ ; 		    /* to what they were before the search was started */    		    failedSearch();  		    return NOMATCH;  		}  		newLine[0] = '+';  		*artNum = atol(&newLine[2]);# 		newsubject = getSubject(*artNum);  		if (caseSensitive) {, 		    utLowerCase(lowersubject, newsubject);
 		} else {' 		    strcpy(lowersubject, newsubject);  		}  #ifdef SYSV_REGEX + 		if (regex(reRet, lowersubject) != NULL) {  #else  		if (re_exec(lowersubject)) { #endif7 		    /* the new article (subjectline) obtained here */ ; 		    /* does not need to be checked for validity, since */ 8 		    /* getPrevSubject() only returns valid articles */   		    gotoArticle(*artNum); ( 		    (void) getArticleText(text, ques); 		    return WINDOWCHANGE; 		}  		continue;  	    } 	}     }  }    int > authorSearch(dir, artnums, position, expr, text, ques, artNum)2 int dir;			/* direction, either FORWARD or BACK */: art_num *artnums;		/* text string (may be changed here) */' int  *position;			/* cursor position */ 4 char *expr;			/* regular expression to search for */@ char **text, **ques;		/* text and status line for new article */- art_num *artNum;		/* number of new article */  {  #ifdef SYSV_REGEX      extern char *regcmp();     extern char *regex();  #else 6     char *re_comp();		/* regular expression routine */ #endif9     static char *reRet;		/* returned by re_comp/regcmp */ 2     char *newauthor;		/* author of current line */1     char lowerauthor[128];	/* lowercase author */      char *newLine;     extern void abortClear();      extern int abortP();       abortClear();        if (expr != NIL(char)) { #ifdef SYSV_REGEX , 	if ((reRet = regcmp(expr, NULL)) == NULL) { #else ' 	if ((reRet = re_comp(expr)) != NULL) {  #endif! 	    /* bad regular expression */  #ifdef SYSV_REGEX : 	    mesgPane(XRN_SERIOUS, "error in regular expression"); #else " 	    mesgPane(XRN_SERIOUS, reRet); #endif 	    failedSearch(); 	    return ERROR; 	}     }        if (dir == FORWARD) {  	for (;;) {  	    if (abortP()) { 		return ABORT;  	    }# 	    if (artnums[*position] == 0) {  		if (*position == 0) {   9 		    /* the string is null, no more articles are left */    		    return EXIT; 		}  		return NOMATCH;  	    } 	    *position = *position + 1; # 	    if (artnums[*position] == 0) {    		/* reached end of string */    		return NOMATCH;  	    }" 	    *artNum = artnums[*position];$ 	    newauthor = getAuthor(*artNum);) 	    utLowerCase(lowerauthor, newauthor);    #ifdef SYSV_REGEX - 	    if (regex(reRet, lowerauthor) != NULL) {  #else   	    if (re_exec(lowerauthor)) { #endif/ 		/* found a match to the regular expression */    		gotoArticle(*artNum); / 		if (getArticleText(text, ques) != XRN_OKAY) {   , 		    /* the matching article was invalid */   		    continue;  		}  		return MATCH;  	    } 	}     } else { 	startSearch();  	for (;;) {  	    if (abortP()) {  8 		/* reset pointers back to where we began, since the */ 		/* search was aborted */   		failedSearch();  		return ABORT;  	    } 	    if ((*position == 0) && 		(artnums[*position] == 0) ) {   8 		/* no more articles remain, return to Newgroup mode */   		return EXIT; 	    } 	    if (*position != 0) {  , 		/* we are still within the article list */   		*position = *position - 1; 		*artNum = artnums[*position]; ! 		newauthor = getAuthor(*artNum); & 		utLowerCase(lowerauthor, newauthor);   #ifdef SYSV_REGEX * 		if (regex(reRet, lowerauthor) != NULL) { #else  		if (re_exec(lowerauthor)) {  #endif@ 		    /* an article matching the regular expression was found */   		    gotoArticle(*artNum); 3 		    if (getArticleText(text, ques) != XRN_OKAY) {   : 			/* article is invalid, remove it from the text string*/   			continue; 		    }  		    return MATCH;  		} 
 	    } else {    		failedSearch();  		return NOMATCH;  	    } 	}     }  }      int ! moveToArticle(artNum, file, ques) - art_num artNum;			/* number of new article */ @ char **file, **ques;		/* text and status line for new article */ {      fillUpArray(artNum);  +     if (checkArticle(artNum) != XRN_OKAY) {  	return NOMATCH;     }        gotoArticle(artNum);1     if (getArticleText(file, ques) != XRN_OKAY) {  	return ERROR;     }        return MATCH;  } 