% #if !defined(lint) && !defined(SABER)  static char XRNrcsid[] = "$Header: /net/objy27/wrld/mnt11/ricks/src/master/xrn/compose.c,v 1.9 1993/02/04 18:22:12 ricks Exp $"; #endif   /*$  * xrn - an X-based NNTP news reader  *G  * Copyright (c) 1988-1993, Ellen M. Sentovich and Rick L. Spickelmier.   *H  * Permission to use, copy, modify, and distribute this software and itsL  * documentation for any purpose and without fee is hereby granted, providedJ  * that the above copyright notice appear in all copies and that both thatC  * copyright notice and this permission notice appear in supporting G  * documentation, and that the name of the University of California not E  * be used in advertising or publicity pertaining to distribution of  K  * the software without specific, written prior permission.  The University G  * of California makes no representations about the suitability of this G  * software for any purpose.  It is provided "as is" without express or   * implied warranty.  *H  * THE UNIVERSITY OF CALIFORNIA DISCLAIMS ALL WARRANTIES WITH REGARD TO J  * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND H  * FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE FORK  * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER G  * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF G  * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN  ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   */    /*:  * compose.c: routines for composing messages and articles  */    #include "copyright.h"   #include <ctype.h> #include <stdio.h> #include <time.h>  #include "config.h"  #include "utils.h"   #ifndef VMS  #ifdef __STDC__  #include <unistd.h>  #endif #else /* VMS */  #include <unixio.h>  extern char *  localHostName();  #ifdef __STDC__  #define CADDR_T  #include <unixio.h>  #include <socket.h>  #endif #endif /* VMS */   #if defined(__hpux)  #include <unistd.h>  #endif  7 #if defined(sun) && defined(sparc) && !defined(SOLARIS)  #include <vfork.h> /*E  * Unfortunately, it's necessary to declare fclose on the Sun because @  * stdio.h in the standard Sun C library doesn't, and we need to6  * assign fclose to a function pointer variable below.  */ ' extern int fclose _ARGUMENTS((FILE *));  #else /* sun & ! solaris */  #ifndef SVR4_0 extern int vfork();  #else /* SVR4 */ extern pid_t vfork(void);  #endif /* SVR4 */  #endif /* sun & !solaris */    #ifndef i386 extern int getdtablesize();  #endif   #ifndef VMS  #include <sys/wait.h>  #include <sys/file.h>  #include <sys/stat.h>  #include <pwd.h> #else /* VMS */  #include <stat.h>  #include <file.h>  #define index strchr #define rindex strrchr extern char* getenv(); extern void unlink();  extern int sys$putmsg(); extern int MAIL$SEND_BEGIN(); % extern int MAIL$SEND_ADD_ATTRIBUTE(); # extern int MAIL$SEND_ADD_ADDRESS(); $ extern int MAIL$SEND_ADD_BODYPART(); extern int MAIL$SEND_MESSAGE();  extern int MAIL$SEND_END();  extern int MAIL$SEND_ABORT();  extern int lib$spawn();  extern void addTimeOut();  extern void removeTimeOut(); #endif   #include <signal.h>  #ifdef RESOLVER  #ifndef VMS  #include <sys/types.h> #include <sys/socket.h>  #include <netdb.h> #endif	/* VMS */ #endif	/* RESOLVER */   " #if defined(aiws) || defined(DGUX) struct passwd *getpwuid(); struct passwd *getpwnam(); #endif   #ifndef VMS  #include <X11/StringDefs.h>  #include <X11/Intrinsic.h> #include <X11/Shell.h> #else  #include <types.h>$ #include <decw$include/StringDefs.h># #include <decw$include/Intrinsic.h>  #include <decw$include/Shell.h>  #endif #ifdef MOTIF #include <Xm/PanedW.h> #include <Xm/TextP.h>  #include <Xm/RowColumn.h>  #include <Xm/PushB.h>  #include <Xm/Label.h>  #include <Xm/Frame.h> ) #if (XmVERSION == 1) && (XmREVISION == 0)  #define MOTIF_V10  #endif9 extern void PaneSetMinMax _ARGUMENTS((Widget, int, int));  #else  #ifndef DwtNmenuExtendLastRow 1 #define DwtNmenuExtendLastRow "menuExtendLastRow"  #endif #ifndef VMS " #include <X11/DECwDwtWidgetProg.h> #include "Pane.h"  #else + #include <decw$include/DECwDwtWidgetProg.h>  #include "Pane.h"  #endif #endif  3 extern char *getinfofromfile _ARGUMENTS((char * ));  #include "avl.h" #include "xthelper.h"  #include "resources.h" #include "dialogs.h" #include "news.h"  #include "server.h"  #include "mesg.h"  #include "internals.h" #include "xrn.h" #include "xmisc.h" #include "error_hnds.h"  #include "butdefs.h"   #ifndef R_OK5 #define F_OK            0       /* does file exist */ @ #define X_OK            1       /* is it executable by caller */8 #define W_OK            2       /* writable by caller */8 #define R_OK            4       /* readable by caller */ #endif /* R_OK */    /* entire pane */ $ Widget ComposeTopLevel = (Widget) 0; Boolean ComposeActive = False; /* text window */   Widget ComposeText = (Widget) 0;
 /* buttons */  static Widget AbortButton; static Widget SendButton;  static Widget SaveButton;   static Widget IncludeFileButton;# static Widget IncludeArticleButton; # static Widget IncludeCurrentButton;  static Widget WrapTextButton;  static int InsertionPoint = 0; static int EditorPosition = 0; Widget HeaderText = (Widget) 0;  #ifdef MOTIF' static Widget headerFrame = (Widget) 0; % static Widget textFrame = (Widget) 0;  #endif  + static char *CompositionString = NIL(char); & static char *HeaderString = NIL(char);$ static char *TempString = NIL(char); static int CompositionSize = 0;  static int editMessage();    #define BUFFER_SIZE 1024   #define POST     0 #define FOLLOWUP 1 #define REPLY    2 #define FORWARD  3 #define GRIPE    4 #define FOLLOWUPREPLY 5  static int PostingMode = POST;# static char *PostingModeStrings[] = M     { "post", "followup", "reply", "forward", "gripe", "followup-and-mail" };   * static Boolean IncludeCurrentMode = False;  
 #ifdef VMS static int spawnStat;  #endif   struct header {      art_num article;     char *artText;     char *newsgroups;      char *subject;     char *messageId;     char *followupTo;      char *references;      char *from;      char *replyTo;     char *distribution;      char *keywords;        char *user;      char *real_user;     char *fullname;      char *host;      char *real_host;?     char *path;		/* note: this is not used with InterNetNews */      char *organization;   7     char  *date; /* added to header structure....... */  };     /*D  * storage for the header information needed for building, checking,C  * and repairing the header.  Once this is created, the user can go D  * to another article or another group and still use the composition	  * window   */   M static struct header Header = {0, NIL(char), NIL(char), NIL(char), NIL(char), 1 				  NIL(char), NIL(char), NIL(char), NIL(char), 1 				  NIL(char), NIL(char), NIL(char), NIL(char), ' 				  NIL(char), NIL(char), NIL(char)};      #define HOST_NAME_SIZE 1024    static void  sizeCompose(newSize) int newSize; {      newSize += 10000; $     if (newSize > CompositionSize) {& 	if (CompositionString == NIL(char)) {+ 	    CompositionString = XtMalloc(newSize); & 	    HeaderString = XtMalloc(newSize);# 	    TempString= XtMalloc(newSize); 	 	} else { ? 	    CompositionString = XtRealloc(CompositionString, newSize); 5 	    HeaderString = XtRealloc(HeaderString, newSize); 0 	    TempString= XtRealloc(TempString, newSize); 	} 	CompositionSize = newSize;      }  }    /*@  * get the header and other important information for an article  *I  * if called with article equal to zero, will only set up the non-article   * specific entries   *  */  static void  getHeader(article) art_num article; { /     struct newsgroup *newsgroup = CurrentGroup;  #ifndef VMS      struct passwd *pwd;  #endif$     char host[HOST_NAME_SIZE], *ptr;#     char real_host[HOST_NAME_SIZE]; 
 #ifdef INN>     char *inn_domain = (char *) GetFileConfigValue ("domain");     char *inn_org; #else      char path[HOST_NAME_SIZE]; #endif   #ifndef VMS . #if defined(RESOLVER) && !defined(RETURN_HOST)     struct hostent *hent;  #endif #endif     char buffer[10000];      char *getenv();           if (article > 0) { 	Header.article = article;1 	xhdr(article, "newsgroups", &Header.newsgroups); + 	xhdr(article, "subject", &Header.subject); 0 	xhdr(article, "message-id", &Header.messageId);2 	xhdr(article, "followup-to", &Header.followupTo);1 	xhdr(article, "references", &Header.references); % 	xhdr(article, "from", &Header.from); , 	xhdr(article, "reply-to", &Header.replyTo);5 	xhdr(article, "distribution", &Header.distribution); - 	xhdr(article, "keywords", &Header.keywords);      } else { 	/* information for 'post' */  	if (newsgroup) { 6 	    Header.newsgroups = XtNewString(newsgroup->name);	 	} else { ) 	    Header.newsgroups = XtNewString("");  	} 	Header.artText = NULL;      }        /*K      * since I'm lazy down below, I'm going to replace NIL pointers with ""       */ )     if (Header.newsgroups == NIL(char)) { % 	Header.newsgroups = XtNewString("");      } &     if (Header.subject == NIL(char)) {" 	Header.subject = XtNewString("");     } (     if (Header.messageId == NIL(char)) {$ 	Header.messageId = XtNewString("");     } )     if (Header.followupTo == NIL(char)) { % 	Header.followupTo = XtNewString("");      } )     if (Header.references == NIL(char)) { % 	Header.references = XtNewString("");      } #     if (Header.from == NIL(char)) {  	Header.from = XtNewString("");      } &     if (Header.replyTo == NIL(char)) {" 	Header.replyTo = XtNewString("");     } +     if (Header.distribution == NIL(char)) { ' 	Header.distribution = XtNewString("");      } '     if (Header.keywords == NIL(char)) { # 	Header.keywords = XtNewString("");      }        real_host[0] = 0;      host[0] = 0; #ifdef	UUCPNAME      {          FILE * uup;      3         if ((uup = fopen(UUCPNAME, "r")) != NULL) {      		char   *p;     		char    xbuf[BUFSIZ];      6     		while (fgets(xbuf, sizeof(xbuf), uup) != NULL) {+     		    if (*xbuf <= ' ' || *xbuf == '#')      			continue;     		    break;     		}       		if (p = index(xbuf, '\n'))     		    *p = '\0';=     		(void) strncpy(real_host, xbuf, sizeof(real_host) - 1);  		strcpy(host, real_host);     		(void) fclose(uup); 	         }      }  #endif     if (real_host[0] == 0) {
 #ifdef INN5 	/* always let values in inn.cofnf take precedence */ : 	char *inn_fromhost = (char *) GetConfigValue("fromhost");! 	if (inn_fromhost != NIL(char)) { , 	    (void) strcpy(real_host, inn_fromhost);& 	} else if (inn_domain != NIL(char)) {* 	    (void) strcpy(real_host, inn_domain);	 	} else {  #endif /* INN */8         if ((ptr = getenv("HIDDENHOST")) != NIL(char)) {9 	    (void) strncpy(real_host, ptr, sizeof(real_host)-1); B         } else if ((ptr = getinfofromfile(HIDDEN_FILE)) != NULL) {; 	    (void) strncpy(real_host, ptr, sizeof(real_host) - 1); 	 	} else {  #ifdef RETURN_HOST+ 	    (void) strcpy(real_host, RETURN_HOST);  #else /* Not RETURN_HOST */  #ifndef VMS 6 	    (void) gethostname(real_host, sizeof(real_host)); #ifdef RESOLVER % 	    hent = gethostbyname(real_host);  	    if (hent != NULL) {( 		(void) strcpy(real_host,hent->h_name); 	    } #endif #else  	    ptr = localHostName();  	    if (ptr != NIL(char)) {  		(void) strcpy(real_host, ptr); 	    }! 	    ptr = index(real_host, '.');  	    if (ptr == NIL(char)) { 		ptr = index(real_host, ':'); 		if (ptr != NIL(char)) {  		    *ptr = '\0'; 		} ( 		(void) strcat(real_host, DOMAIN_NAME); 	    } 	    utDowncase(real_host);  #endif #endif /* Not RETURN_HOST */ 	}
 #ifdef INN 	} #endif	/* INN */     }      -     if (app_resources.hostName != NIL(char)){ + 	utLowerCase(host, app_resources.hostName);      } else {1 	if ((ptr = getenv("HIDDENHOST")) != NIL(char)) { / 	    (void) strncpy(host, ptr, sizeof(host)-1); 	 	} else {  	    strcpy(host, real_host);  	}     }    #ifndef INN     4     if ((ptr = getenv("HIDDENPATH")) != NIL(char)) {+ 	(void) strncpy(path, ptr, sizeof(path)-1); <     } else if ((ptr = getinfofromfile(PATH_FILE)) != NULL) {+ 	(void) strncpy(path, ptr, sizeof(path)-1);      } else {, 	(void) strncpy(path, host, sizeof(path)-1);     }  #endif /* INN */  G     /* If the host name is not a full domain name, put in the domain */ )     if (index (host, '.') == NIL(char)) {          char   *domain;      9         if ((domain = getenv ("DOMAIN")) != NIL (char)) { ! 	    (void) strcat(host, domain); 
 #ifdef INN& 	} else if (inn_domain != NIL(char)) {% 	    (void) strcat(host, inn_domain);  #endif /* INN */	     > 	} else if ((domain = getinfofromfile(DOMAIN_FILE)) != NULL) {! 	    (void) strcat(host, domain);          } else {' 	    (void) strcat (host, DOMAIN_NAME);  	}     }   $     Header.host = XtNewString(host);.     Header.real_host = XtNewString(real_host); #ifndef INN     $     Header.path = XtNewString(path); #endif /* INN */   #ifndef VMS L     if ((ptr = getinfofromfile(utTildeExpand("~/.organization"))) != NULL) {( 	Header.organization = XtNewString(ptr);
     } else #endif2     if (app_resources.organization != NIL(char)) {? 	Header.organization = XtNewString(app_resources.organization);  #ifndef apollo>     } else if ((ptr = getenv ("ORGANIZATION")) != NIL(char)) { #else 9     } else if ((ptr = getenv ("NEWSORG")) != NIL(char)) {  #endif( 	Header.organization = XtNewString(ptr);
 #ifdef INNR     } else if ((inn_org = (char *) GetConfigValue("organization")) != NIL(char)) {, 	Header.organization = XtNewString(inn_org); #endif /* INN */     #ifdef ORG_FILE ;     } else if ((ptr = getinfofromfile(ORG_FILE)) != NULL) { ( 	Header.organization = XtNewString(ptr); #endif /* ORG_FILE */      } else {- 	Header.organization = XtNewString(ORG_NAME);      }  #ifndef VMS      pwd = getpwuid(getuid()); '     if (Header.user = getenv("USER")) { ( 	Header.user = XtNewString(Header.user);,     } else if (Header.user = pwd->pw_name) {( 	Header.user = XtNewString(Header.user);     } else { 	Header.user = XtNewString("");      } *     if (Header.real_user = pwd->pw_name) {2 	Header.real_user = XtNewString(Header.real_user);     } else {$ 	Header.real_user = XtNewString("");     } /     if (Header.fullname = getenv("FULLNAME")) { 0 	Header.fullname = XtNewString(Header.fullname);1     } else if (Header.fullname = pwd->pw_gecos) { 0 	Header.fullname = XtNewString(Header.fullname);     } else {# 	Header.fullname = XtNewString("");      }  #else .     Header.user = XtNewString(getenv("USER"));     utDowncase(Header.user);0     Header.real_user = XtNewString(Header.user);  -     if (app_resources.personalName != NULL) { ; 	Header.fullname = XtNewString(app_resources.personalName);      } else {: 	if ((Header.fullname = getenv("FULLNAME")) == NIL (char))' 	    Header.fullname = XtNewString("");  	else 4 	    Header.fullname = XtNewString(Header.fullname);     }  #endif&     ptr = index(Header.fullname, ',');     if (ptr != NIL(char)) { 
 	*ptr = '\0';      }           /* & expansion */ &     ptr = index(Header.fullname, '&');     if (ptr != NIL(char)) { , 	char *p = buffer + (ptr - Header.fullname);   	buffer[0] = '\0';
 	*ptr = '\0'; ( 	(void) strcpy(buffer, Header.fullname);$ 	(void) strcat(buffer, Header.user); 	if (isascii(*p)) {  	    *p = toupper(*p); 	} 	ptr++;  	(void) strcat(buffer, ptr); 	FREE(Header.fullname); ' 	Header.fullname = XtNewString(buffer);      }           return;  }    /*C  * see if a field exists in the header that begins with `fieldName'   *%  * returns 0 for no, non-zero for yes   */ 
 static int fieldExists(string, fieldName)
 char *string;  char *fieldName; {      char *ptr;  E     for (ptr = string; (ptr != NIL(char)) && (*ptr != '\0'); ptr++) { , 	if ((ptr[0] == '\n') && (ptr[1] == '\0')) { 	    /* end of message */  	    return(0);  	}, 	if ((ptr[0] == '\n') && (ptr[1] == '\n')) { 	    /* end of header */ 	    return(0);  	}   	/* ? 	 * see if the field name is in the string and at the beginning 7 	 * of the line and that the field name ends with a ':'  	 *// 	if (((ptr == string) || (*(ptr-1) == '\n')) && 3 	    STREQN(fieldName, ptr, utStrlen(fieldName)) && ) 	    (ptr[utStrlen(fieldName)] == ':')) {  	    return(1);i 	}     }l     return(0); }B   /*#  * add a header field to a message.e#  * this is a destructive operation.x  */m static void1 addField(string, field)E
 char *string;  char *field; {      char buffer[10000];   "     (void) strcpy(buffer, string);     string[0] = '\0';.!     (void) strcat(string, field);o"     (void) strcat(string, buffer);       return;d }    *   /*?  * remove all fields from a header that begin with `fieldName'.d#  * this is a destructive operation.e  */a static voide stripField(string, fieldName)g
 char *string;h char *fieldName; {a     char *ptr, *nl;     V     for (ptr = string; (ptr != NIL(char)) && (*ptr != '\0'); ptr = index(ptr, '\n')) { 	if (ptr != string) {r& 	    /* character after the newline */ 	    ptr++;  	} 	c, 	if ((ptr[0] == '\n') && (ptr[1] == '\0')) { 	    /* end of message */e 	    return; 	}, 	if ((ptr[0] == '\n') && (ptr[1] == '\n')) { 	    /* end of header */ 	    return; 	}   	/*o3 	 * make sure a ':' is at the end of the field nameL 	 */X 	if (STREQN(fieldName, ptr, utStrlen(fieldName)) && (ptr[utStrlen(fieldName)] == ':')) { 	    nl = index(ptr, '\n');  	    (void) strcpy(ptr, ++nl); 	    if (*ptr == '\n') {	 		return;F 	    } 	    ptr--;N 	}     }O     return;A }E   /*:  * remove fields from a header that begin with `fieldName'2  * and return the removed characters in `removed'.#  * this is a destructive operation.R  */  static void ' returnField(string, fieldName, removed)C
 char *string;A char *fieldName; char *removed; {n     char *ptr, *nl, *copyPtr;r       *removed = '\0';Y     for (ptr = string; (ptr != NIL(char)) && (*ptr != '\0');  ptr = index(++ptr, '\n')) {f 	if (ptr != string) {.& 	    /* character after the newline */ 	    ptr++;d 	} 	e, 	if ((ptr[0] == '\n') && (ptr[1] == '\0')) { 	    /* end of message */e 	    return; 	}, 	if ((ptr[0] == '\n') && (ptr[1] == '\n')) { 	    /* end of header */ 	    return; 	}   	/*i3 	 * make sure a ':' is at the end of the field namei 	 */3 	if (STREQN(fieldName, ptr, utStrlen(fieldName)) &&c) 	    (ptr[utStrlen(fieldName)] == ':')) {n 	    nl = index(ptr, '\n'); - 	    copyPtr = ptr + utStrlen(fieldName) + 1;n8 	    while (*copyPtr == ' ')		/* strip leading spaces */ 		copyPtr++;$ 	    for (; copyPtr < nl; copyPtr++)  	         *removed++ = *copyPtr; 	    *removed = '\0';  	    (void) strcpy(ptr, ++nl); 	    return; 	}     }      return;v }k   static voidf PopdownCompositionTopLevel() {l&     XtSetSensitive(SendButton, False);&     XtSetSensitive(SaveButton, False);-     XtSetSensitive(IncludeFileButton, False); 0     XtSetSensitive(IncludeArticleButton, False);0     XtSetSensitive(IncludeCurrentButton, False);*     XtSetSensitive(WrapTextButton, False);(     if (ComposeTopLevel != (Widget) 0) {! 	xthUnmapWidget(ComposeTopLevel);x 	XtPopdown(ComposeTopLevel);     }i     ComposeActive = False;     return;t }I   static voidE freeHeader() {t     if (PostingMode != GRIPE) {n 	FREE(Header.newsgroups);  	FREE(Header.subject); 	FREE(Header.messageId); 	FREE(Header.followupTo);s 	FREE(Header.references);m 	FREE(Header.from);  	FREE(Header.replyTo); 	FREE(Header.distribution);d 	FREE(Header.keywords);  	FREE(Header.user);. 	FREE(Header.real_user); 	FREE(Header.fullname);e 	FREE(Header.host);f 	FREE(Header.real_host); #ifndef INN	 	FREE(Header.path);t #endif /* INN */	; 	FREE(Header.organization);      }      return;  }i   /*2  * add a subject field to the header of a message.5  * deal with supressing multiple '[rR][eE]: ' stringsu  */e static voidr buildSubject(message)e char *message; {c,     if (STREQN(Header.subject, "Re: ", 4) ||% 	STREQN(Header.subject, "RE: ", 4) || % 	STREQN(Header.subject, "re: ", 4)) {w% 	(void) strcat(message, "Subject: ");c     } else {) 	(void) strcat(message, "Subject: Re: ");N     }&+     (void) strcat(message, Header.subject);d!     (void) strcat(message, "\n");M       return;n }i   /*ARGSUSED*/ static voide/ compAbortFunction(widget, event, string, count)m Widget widget; XEvent *event; String *string;e Cardinal *count; {o     char *ptr;!     PopdownCompositionTopLevel();c     freeHeader();r     switch (PostingMode) { 	case POST:f 	case FOLLOWUP:g 	case FOLLOWUPREPLY: 	    ptr = "Article";u 	    break;i	 	default:e 	    ptr = "Message";o 	    break;c     }i  *     mesgPane(XRN_INFO, "%s aborted", ptr);       return;" }g   static void" saveMessage(fname) char *fname; {u
     FILE *fp;i%     char *file = utNameExpand(fname);f     time_t clock;K     char *msg;       if (file == NIL(char)) {> 	mesgPane(XRN_SERIOUS, "Cannot save the article/message (%s)", 		 errmsg(errno)); 	return;     }      7     (void) sprintf(error_buffer, "Saving in %s", file);      infoNow(error_buffer);      #ifndef VMS *     if ((fp = fopen(file, "a")) != NULL) { #elset*     if ((fp = fopen(file, "w")) != NULL) { #endifD 	/* Provide initial 'From' line (note ctime() provides a newline) */  1 	if (Header.user == NULL) getHeader((art_num) 0);e 	(void) time(&clock);WD 	if (fprintf(fp, "From %s %s", Header.user, ctime(&clock)) == EOF) { 	    goto finished;t 	}  A 	/* copy body of message, protecting any embedded 'From' lines */    	msg = HeaderString; 	while (*msg) {a# 	    if (STREQN(msg, "From ", 5)) {  		if (fputc('>', fp) == EOF) { 		    goto hdrfinished;e 		}m 	    } 	    while (*msg) {t 		if (fputc(*msg, fp) == EOF) {L 		    goto hdrfinished;a 		}r 		++msg; 		if (*(msg-1) == '\n') break; 	    } 	}   hdrfinished: 	i  	if (fputs("\n\n", fp) == EOF) { 	    goto finished;U 	}   	msg = CompositionString;  	while (*msg) {W# 	    if (STREQN(msg, "From ", 5)) {W 		if (fputc('>', fp) == EOF) { 		    goto finished; 		}c 	    } 	    while (*msg) {t 		if (fputc(*msg, fp) == EOF) {  		    goto finished; 		}r 		++msg; 		if (*(msg-1) == '\n') break; 	    } 	} 	t/ 	/* ensure there is an empty line at the end */V    	if (fputs("\n\n", fp) == EOF) { 	    goto finished;  	}  	 finished:; 	(void) fclose(fp);        } else {? 	mesgPane(XRN_SERIOUS, "Can not save the article/message (%s)",w 	 errmsg(errno));e     }s     return;* }m   /*ARGSUSED*/ static voidh. compSaveFunction(widget, event, string, count) Widget widget; XEvent *event; String *string;l Cardinal *count; {t     char *textString;;      #ifdef MOTIF/     textString = xmWrapTextWidget(ComposeText);  #else*0     textString = DwtSTextGetString(ComposeText); #endif&     sizeCompose(utStrlen(textString));*     strcpy(CompositionString, textString);     XtFree(textString);p #ifdef MOTIF-     textString = XmTextGetString(HeaderText);* #elset/     textString = DwtSTextGetString(HeaderText);m #endif%     strcpy(HeaderString, textString);d     XtFree(textString);,,     saveMessage(app_resources.savePostings); }r   static voidI saveDeadLetter(textString) char	*textString;) {I
     FILE *fp;a   #ifndef VMS(M     if ((fp = fopen(utNameExpand(app_resources.deadLetters), "a")) != NULL) {  #elseoM     if ((fp = fopen(utNameExpand(app_resources.deadLetters), "w")) != NULL) {p #endifC 	(void) fwrite(textString ,sizeof(char), utStrlen(textString), fp);g 	(void) putc('\n', fp);  	(void) putc('\n', fp);c 	(void) fclose(fp);S     } else {D 	mesgPane(XRN_SERIOUS, "Can not save the dead article/message (%s)", 		 errmsg(errno));     }H     return;  }e     /*:  * go through the string and look for fields that have not!  * been filled in and remove them=  */i /*ARGSUSED*/ static voidg stripBlankFields(string)
 char *string;t {      char *ptr, *nl, *end;a  (     ptr = string + utStrlen(string) - 1; /*#  * make sure it ends with a newlinee  */*     if (*ptr != '\n') {H 	ptr++;i 	*ptr++ = '\n';i 	*ptr++ = '\0';u     }gV     for (ptr = string; (ptr != NIL(char)) && (*ptr != '\0'); ptr = index(ptr, '\n')) {, 	if ((ptr[0] == '\n') && (ptr[1] == '\0')) {5 	    ptr[1] = '\n';		/* put in the missing newline */n 	    ptr[2] = '\0';n 	    /* end of message */h 	    return; 	}, 	if ((ptr[0] == '\n') && (ptr[1] == '\n')) { 	    /* end of header */ 	    return; 	}   	if (ptr != string) {u& 	    /* character after the newline */ 	    ptr++;0 	} 	  	/* get the line */ , 	if ((nl = index(ptr, '\n')) == NIL(char)) { 	    /* weird */ 	    return; 	}  D 	if (strncmp(ptr, "-=-=", 4) == 0 || strncmp(ptr, "=-=-", 4) == 0) {  	    /* end of message banner */ 	    *ptr++ = '\n';d 	    strcpy(ptr, ++nl);  	    return; 	} 	/* ignore trailing spaces */,
 	end = nl; 	end--;  	for ( ; *end == ' '; end--) ; 	o1 	if ((*end == ':') && (end == index(ptr, ':'))) {  	    /* blank field */ 	    (void) strcpy(ptr, ++nl); 	    if (*ptr == '\n') {	 		return;y 	    } 	    ptr--;{ 	}     }m     return;s }        /*$  * Remote the 'start of text' header  */w static voido stripHeaderField(string)
 char *string;r {s     char *ptr, *nl;   (     ptr = string + utStrlen(string) - 1;V     for (ptr = string; (ptr != NIL(char)) && (*ptr != '\0'); ptr = index(ptr, '\n')) {, 	if ((ptr[0] == '\n') && (ptr[1] == '\0')) {5 	    ptr[1] = '\n';		/* put in the missing newline */f 	    ptr[2] = '\0';I 	    /* end of message */  	    break;( 	}   	if (ptr != string) {m& 	    /* character after the newline */ 	    ptr++;r 	} 	; 	/* get the line */d, 	if ((nl = index(ptr, '\n')) == NIL(char)) { 	    /* weird */ 	    break;  	}  D 	if (strncmp(ptr, "-=-=", 4) == 0 || strncmp(ptr, "=-=-", 4) == 0) {  	    /* end of message banner */ 	    *ptr++ = '\n';  	    strcpy(ptr, ++nl);g 	    break;  	}     }e(     ptr = string + utStrlen(string) - 1;     while (*ptr == '\n') ptr--; 
     ptr++;     strcpy(ptr, "\n\n");     return;. }    u  
 #ifdef VMS #include <ssdef.h> #include <descrip.h> #include <maildef.h>% static Widget	mailErrorDialog = NULL;  static char	VMSmessage[255]; static char	TXTmessage[255]; static char	*VMSmessPtr; static int	VMSmessSize;f
 static int grabMessage(descr) struct	dsc$descriptor_s *descr;  {h     char *p;     short s;#     s = (short)descr->dsc$w_length;,%     p = (char *)descr->dsc$a_pointer;="     strncpy(VMSmessPtr, p, s);         VMSmessSize += s; #     VMSmessage[VMSmessSize] = '\n';\     VMSmessSize++;#     VMSmessage[VMSmessSize] = '\0';t     VMSmessPtr += VMSmessSize;
     return 0;, }a
 static int handleMailSignal(sig, mech) 
 int sig[]; int mech[];  {f     sig[0] = sig[0] - 2;     VMSmessPtr = VMSmessage;     VMSmessSize = 0;'     sys$putmsg(sig, grabMessage, 0, 0);      sig[0] = sig[0] + 2;     return SS$_CONTINUE; }L static void + popDownMail(widget, client_data, call_data)} Widget widget; caddr_t client_data; caddr_t call_data; {_#     PopDownDialog(mailErrorDialog);f     return;  }  static voidg mailError()H {"&     static struct DialogArg args[] = {2 	{"Click to continue", popDownMail, (caddr_t) -1},     };  4     (void) strcpy(TXTmessage,"Error sending mail:");)     (void) strcat(TXTmessage,VMSmessage);t:     mailErrorDialog = CreateDialog(TopLevel, "Mail Error",! 				   TXTmessage, DIALOG_NOTEXT,* 				   args, XtNumber(args));M!     PopUpDialog(mailErrorDialog);s     return;l }s #endif /* VMS */   static void  sendFollowupMail(str)s
 char *str; {h     char *message;     char pathFormatString[100];e  +     message = XtMalloc(strlen(str) + 1024);t  /     if (app_resources.replyPath != NIL(char)) {r 	if (app_resources.ccForward) { 2 	    sprintf(pathFormatString, "To: %s\nCc: %s\n",( 		app_resources.replyPath, Header.user);	 	} else {=$ 	    if (app_resources.cc == True) {- 		sprintf(pathFormatString, "To: %s\nCc: \n",  			app_resources.replyPath);
 	    } else {e@ 		sprintf(pathFormatString, "To: %s\n",app_resources.replyPath); 	    } 	}     } else { 	if (app_resources.ccForward) { F 	    sprintf(pathFormatString, "To: %s\nCc: %s\n", "%s", Header.user);	 	} else {I$ 	    if (app_resources.cc == True) {- 		strcpy(pathFormatString, "To: %s\nCc: \n");s
 	    } else {p' 		strcpy(pathFormatString, "To: %s\n");e 	    } 	}     }(-     (void) sprintf(message, pathFormatString,(? 		   (*Header.replyTo != '\0') ? Header.replyTo : Header.from);   -     if (app_resources.replyTo != NIL(char)) {t' 	 (void) strcat(message, "Reply-To: "); 0 	 (void) strcat(message, app_resources.replyTo); 	 (void) strcat(message, "\n");      }        buildSubject(message);     strcat(message, "\n");     strcat(message, str);'-     switch (postArticle(message, XRN_MAIL)) {  	case POST_TRYAGAIN: 	case POST_FAILED:$ 	    XBell(XtDisplay(TopLevel), 50);4 	    mesgPane(XRN_SERIOUS, "Could not send reply."); 	    return; 	    break;o 	case POST_OKAY:- 	    mesgPane(XRN_INFO, "Mail Message Sent");f 	    break;e     }o }l /*ARGSUSED*/ static void . compSendFunction(widget, event, string, count) Widget widget; XEvent *event; String *string;} Cardinal *count; {r     char buffer[10000];;     char *textString;=     /*F      * I am loathe to use buffers that are 1024 bytes long for the oldF      * from line, new from line and sender line, since they are almostF      * certainly going to be much shorter than this, but this seems toA      * be the way things are done elsewhere in this file, so I'll!      * stick with it..      */i"     char oldNgString[BUFFER_SIZE];"     char newNgString[BUFFER_SIZE];A     char oldFromString[BUFFER_SIZE], tempFromString[BUFFER_SIZE]; $     char newFromString[BUFFER_SIZE];#     char senderString[BUFFER_SIZE];a     int mode, i,j, len, comma; #if defined(INN)!     char subjString[BUFFER_SIZE];g #endif  3     if (app_resources.editorCommand == NIL(char)) {X #ifdef MOTIF, 	textString = xmWrapTextWidget(ComposeText); #else - 	textString = DwtSTextGetString(ComposeText);U #endif# 	sizeCompose(utStrlen(textString));r' 	strcpy(CompositionString, textString);  	XtFree(textString); #ifdef MOTIF* 	textString = XmTextGetString(HeaderText); #elsed, 	textString = DwtSTextGetString(HeaderText); #endif" 	strcpy(HeaderString, textString); 	XtFree(textString);  	stripBlankFields(HeaderString);  	stripHeaderField(HeaderString);     } else {) 	strcpy(HeaderString, CompositionString);  	CompositionString[0] = '\0';p  	stripBlankFields(HeaderString);  	stripHeaderField(HeaderString);     }l     =     if ((PostingMode == POST) || (PostingMode == FOLLOWUP) ||l" 	(PostingMode == FOLLOWUPREPLY)) { 	mode = XRN_NEWS;w0 	if (app_resources.editorCommand == NIL(char)) {1 	    if (!fieldExists(HeaderString, "Subject")) {w 		if (PostingMode == POST) {% 		    XBell(XtDisplay(TopLevel), 50);g4 		    (void) sprintf(buffer, "Subject: ********\n"); 		    mesgPane(XRN_SERIOUS,a5 			 "The Subject field is missing in your message!");a% 		    addField(HeaderString, buffer);s #ifdef MOTIF0 		    XmTextSetString(HeaderText, HeaderString); #ifndef MOTIF_V10 > 		    XmTextSetCursorPosition(HeaderText, (XmTextPosition) 0); #endifA 		    XmTextSetInsertionPosition(HeaderText, (XmTextPosition) 0);l #elseX2 		    DwtSTextSetString(HeaderText, HeaderString);1 		    DwtTextSetInsertionPosition(HeaderText, 0);L #endif
 		    return;' 		}  		buffer[0] = '\0';e 		buildSubject(buffer);n! 		addField(HeaderString, buffer);( 	    }
 #ifdef INNH 	    /* Let's be more strict, since inews doesn't see empty headers.  */6 	    returnField(HeaderString, "Subject", subjString);! 	    if (subjString[0] == '\0') {   		XBell(XtDisplay(TopLevel), 0);G 		mesgPane(XRN_SERIOUS, "The Subject field is empty in your message!");n	 		return;a 	    }2 	    sprintf(buffer, "Subject: %s\n", subjString);$ 	    addField(HeaderString, buffer); #endif /* INN */	a 	}? 	if (PostingMode == FOLLOWUP || PostingMode == FOLLOWUPREPLY) { 4 	    if (!fieldExists(HeaderString, "References")) {? 		(void) sprintf(buffer, "References: %s\n", Header.messageId);r! 		addField(HeaderString, buffer);p 	    } 	}   #ifdef INEWS 	/*[B 	 * Extract any From: field currently in the message, and store it 	 * in the newFromString.[ 	 */2 	returnField(HeaderString, "From", newFromString); 	/* B 	 * This is the default that was displayed in the Composition pane 	 */, 	(void) sprintf(oldFromString, "%s@%s (%s)",2 			    Header.user, Header.host, Header.fullname); 	/*g= 	 * If we're using INEWS we pass on any From: header the userl 	 * may have set explicitly. 	 */, 	if (strcmp(oldFromString, newFromString)) {9 	    (void) sprintf(buffer, "From: %s\n", newFromString); $ 	    addField(HeaderString, buffer); 	} 	/*i; 	 * Get rid of any Sender: field currently in the mesage --i> 	 * the Sender: field should not ever be inserted by the user. 	 */ 	stripField("Sender:");i #else  	/*.= 	 * Strip any From: field currently in the message, and store  	 * it in oldFromString. 	 */2 	returnField(HeaderString, "From", oldFromString); 	/*h8 	 * If there was no From: field in the message, create a 	 * template one.i 	 */ 	if (*oldFromString == '\0')1 	     (void) sprintf(oldFromString, "%s@%s (%s)", 2 			    Header.user, Header.host, Header.fullname); 	/* < 	 * Now add into the message either the From: field that was0 	 * pulled out or the one that was just created. 	 */5 	(void) sprintf(buffer, "From: %s\n", oldFromString);   	addField(HeaderString, buffer); 	/*i; 	 * Now figure out what the default From: field should looka< 	 * like, with the real username in it (in case the user has: 	 * specified a different username in the USER environment 	 * variable). 	 */, 	(void) sprintf(newFromString, "%s@%s (%s)",> 		       Header.real_user, Header.real_host, Header.fullname); 	/* < 	 * Get rid of any Sender: field currently in the message --> 	 * the Sender: field should not ever be inserted by the user. 	 */3 	returnField(HeaderString, "Sender", senderString);m 	/*.7 	 * If the default From: field is different from what's = 	 * actually in the message, then insert a Sender: field withr" 	 * the default information in it. 	 */, 	if (strcmp(oldFromString, newFromString)) {: 	     (void) sprintf(senderString, "Sender: %s@%s (%s)\n",* 			    Header.real_user, Header.real_host, 			    Header.fullname);+ 	     addField(HeaderString, senderString);  	} #endif /* INEWS */	   0 	if (!fieldExists(HeaderString, "Newsgroups")) {C 	    (void) sprintf(buffer, "Newsgroups: %s\n", Header.newsgroups);/$ 	    addField(HeaderString, buffer);	 	} else {  	    /* B 	     * fix up the Newsgroups: field - inews can not handle spaces 	     * between group namesc 	     */: 	    returnField(HeaderString, "Newsgroups", oldNgString); 	    len = strlen(oldNgString);e 	    j = 0;+ 	    comma = 0;(  	    for (i = 0; i < len; i++) {1 		if (comma && (oldNgString[i] == ' ')) continue;  		comma = 0;$ 		newNgString[j++] = oldNgString[i]; 		if (oldNgString[i] == ',') { 		    comma = 1; 		}r 	    } 	    newNgString[j] = '\0'; ; 	    sprintf(oldNgString, "Newsgroups: %s\n", newNgString);n) 	    addField(HeaderString, oldNgString);i 	}   #ifndef INNeB 	/* The inews in INN adds the Path: header for us, and has its own@ 	 * idea of policy.  We don't bother creating it, freeing it, or5 	 * anything else in compose.c that has to do with itl 	 */* 	if (!fieldExists(HeaderString, "Path")) {( #if defined(INEWS) || defined(HIDE_PATH)7 	    (void) sprintf(buffer, "Path: %s\n", Header.user);  #elseuG 	    (void) sprintf(buffer, "Path: %s!%s\n", Header.path, Header.user);  #endif$ 	    addField(HeaderString, buffer); 	} #elseF3 	returnField(HeaderString, "Sender", senderString);F #endif /* INN */  ? /*	stripField("Message-ID:");  .............we need this !!! */d+ 	stripField(HeaderString, "Relay-Version");E- 	stripField(HeaderString, "Posting-Version");E  1 	(void) strcat (HeaderString, CompositionString);d     } else {1 	(void) strcat (HeaderString, CompositionString);  	mode = XRN_MAIL;o     }t  -     switch (postArticle(HeaderString,mode)) {s 	case POST_TRYAGAIN: 	    return;   	case POST_FAILED:$ 	    XBell(XtDisplay(TopLevel), 50);: 	    mesgPane(XRN_SERIOUS, "Could not post, saving to %s", 		app_resources.deadLetters);j" 	    saveDeadLetter(HeaderString); 	    break;"   	case POST_NOTALLOWED:M 	mesgPane(XRN_SERIOUS, "Posting not allowed from this machine, saving in %s",( 		 app_resources.deadLetters); 	break;  	      	case POST_OKAY:$ 	if (PostingMode == FOLLOWUPREPLY) {$ 	    sendFollowupMail(HeaderString); 	} 	switch (mode) { 		case XRN_NEWS:' 		mesgPane(XRN_INFO, "Article Posted");u 		break;   		case XRN_MAIL:* 		mesgPane(XRN_INFO, "Mail Message Sent"); 		break; 	} 	break;      }C 	o3     if (app_resources.editorCommand == NIL(char)) {o 	PopdownCompositionTopLevel();     }W     freeHeader();P       return;r }"
 #ifdef VMS intb mailArticle(article) char *article; {o     struct _itemList { 	short item_size;I 	short item_code;p 	char* item_ptr; 	int   item_rtn_size;  	int   end_list;     } itemList;u 	      struct _ccList { 	short item1_size; 	short item1_code; 	char* item1_ptr;r 	int   item1_rtn_size; 	short item2_size; 	short item2_code; 	char* item2_ptr;i 	int   item2_rtn_size; 	int   end_list;
     } ccList;  	 
     FILE *fp;r     char toString[BUFFER_SIZE];,     char ccString[BUFFER_SIZE];r!     char subjString[BUFFER_SIZE];      char listFileName[512];{     char listName[512];o     int  listNameSize;     int	context, status;     char *textPtr, *nl;t     char *toElement, *tokPtr;      char *p;     char *ccElement;     int mailCC = MAIL$_CC;     char **wrappedLines;     char **lines;a     long zero = 0;     int lineCount;  %     VAXC$ESTABLISH(handleMailSignal);m'     sizeCompose(strlen(article) + 500);n"     strcpy(HeaderString, article);.     returnField(HeaderString, "To", toString);        if (strlen(toString) == 0) { 	XBell(XtDisplay(TopLevel), 0); = 	mesgPane(XRN_SERIOUS, "You must enter a non-Null TO field");	 	return POST_TRYAGAIN; 	}  5     returnField(HeaderString, "Subject", subjString); "     if (strlen(subjString) == 0) { 	XBell(XtDisplay(TopLevel), 0);d< 	mesgPane(XRN_SERIOUS, "You must enter a non-Null subject"); 	return POST_TRYAGAIN;     } -     returnField(HeaderString,"Cc", ccString);s     context = 0;5     status = MAIL$SEND_BEGIN(&context, &zero, &zero);      if ((status&1) != 1) {
 	mailError();f 	return POST_TRYAGAIN;     } &     if (index(toString,'"') == NULL) {& 	for (p = toString; *p != '\0'; p++) { 	    *p = toupper(*p); 	}     }d&     if (index(ccString,'"') == NULL) {& 	for (p = ccString; *p != '\0'; p++) { 	    *p = toupper(*p); 	}     }e,     itemList.item_code = MAIL$_SEND_TO_LINE;!     itemList.item_ptr = toString;i*     itemList.item_size = strlen(toString);     itemList.item_rtn_size = 0;v     itemList.end_list = 0;A     status = MAIL$SEND_ADD_ATTRIBUTE(&context, &itemList, &zero);e     if ((status&1) != 1) {
 	mailError(); 0         MAIL$SEND_ABORT(&context, &zero, &zero); 	return POST_TRYAGAIN;     }(,     itemList.item_code = MAIL$_SEND_CC_LINE;!     itemList.item_ptr = ccString;x*     itemList.item_size = strlen(ccString);     itemList.item_rtn_size = 0;s     itemList.end_list = 0;A     status = MAIL$SEND_ADD_ATTRIBUTE(&context, &itemList, &zero);n     if ((status&1) != 1) {
 	mailError();s0         MAIL$SEND_ABORT(&context, &zero, &zero); 	return POST_TRYAGAIN;     }      tokPtr = toString;7     while ((toElement = strtok(tokPtr, ",")) != NULL) {e* 	itemList.item_code = MAIL$_SEND_USERNAME;7 	if ((itemList.item_ptr = getenv(toElement)) == NULL) {s# 	    itemList.item_ptr = toElement;p 	}0 	itemList.item_size = strlen(itemList.item_ptr);- 	for (p = itemList.item_ptr; *p == ' '; p++);) 	if (*p == '@') {n	 	    p++;(3 	    if ((fp = fopen(p, "r","dna=.dis")) == NULL) {U> 		sprintf(VMSmessage, "Error opening distribution file %s",p); 		mailError();* 		MAIL$SEND_ABORT(&context, &zero, &zero); 		return POST_TRYAGAIN;t
 	    } else {*, 		while (fgets(listName, 128, fp) != NULL) {& 		    listNameSize = strlen(listName);/ 		    listNameSize--;			/* strip the newline */e$ 		    listName[listNameSize] = '\0';/ 		    itemList.item_code = MAIL$_SEND_USERNAME;n; 		    if ((itemList.item_ptr = getenv(listName)) == NULL) {i  			itemList.item_ptr = listName; 		    }s4 		    for (p = itemList.item_ptr; *p != '\0'; p++) { 			if (*p == '!')i 			    *p = '\0';  			if (*p == '\t') 			    *p = ' '; 		    }  		    p = itemList.item_ptr;4 		    if ((itemList.item_ptr = getenv(p)) == NULL) { 			itemList.item_ptr = p;] 		    } 5 		    itemList.item_size = strlen(itemList.item_ptr);r! 		    itemList.item_rtn_size = 0;u 		    itemList.end_list = 0;A 		    status = MAIL$SEND_ADD_ADDRESS(&context, &itemList, &zero);i 		    if ((status&1) != 1) { 			fclose(fp); 			mailError();;+ 			MAIL$SEND_ABORT(&context, &zero, &zero);s 			return POST_TRYAGAIN; 		    }  		}n
 		fclose(fp);n 	    }	 	} else {   	    itemList.item_rtn_size = 0; 	    itemList.end_list = 0;e@ 	    status = MAIL$SEND_ADD_ADDRESS(&context, &itemList, &zero); 	    if ((status&1) != 1) {: 		mailError();* 		MAIL$SEND_ABORT(&context, &zero, &zero); 		return POST_TRYAGAIN;+ 	    } 	} 	tokPtr = NULL;{     }u     tokPtr = ccString;7     while ((toElement = strtok(tokPtr, ",")) != NULL) { ) 	ccList.item1_code = MAIL$_SEND_USERNAME; 6 	if ((ccList.item1_ptr = getenv(toElement)) == NULL) {" 	    ccList.item1_ptr = toElement; 	}. 	ccList.item1_size = strlen(ccList.item1_ptr);, 	for (p = ccList.item1_ptr; *p == ' '; p++); 	if (*p == '@') {[	 	    p++; 3 	    if ((fp = fopen(p, "r","dna=.dis")) == NULL) {n> 		sprintf(VMSmessage, "Error opening distribution file %s",p); 		mailError();* 		MAIL$SEND_ABORT(&context, &zero, &zero); 		return POST_TRYAGAIN;e
 	    } else {p, 		while (fgets(listName, 128, fp) != NULL) {& 		    listNameSize = strlen(listName);/ 		    listNameSize--;			/* strip the newline */p$ 		    listName[listNameSize] = '\0';. 		    ccList.item1_code = MAIL$_SEND_USERNAME;: 		    if ((ccList.item1_ptr = getenv(listName)) == NULL) { 			ccList.item1_ptr = listName;g 		    }e3 		    for (p = ccList.item1_ptr; *p != '\0'; p++) {  			if (*p == '!')p 			    *p = '\0';e 			if (*p == '\t') 			    *p = ' '; 		    }> 		    p = ccList.item1_ptr;u3 		    if ((ccList.item1_ptr = getenv(p)) == NULL) {  			ccList.item1_ptr = p; 		    }t3 		    ccList.item1_size = strlen(ccList.item1_ptr);t  		    ccList.item1_rtn_size = 0;3 		    ccList.item2_code = MAIL$_SEND_USERNAME_TYPE; * 		    ccList.item2_ptr = (char *) &mailCC; 		    ccList.item2_size = 2;  		    ccList.item2_rtn_size = 0; 		    ccList.end_list = 0;? 		    status = MAIL$SEND_ADD_ADDRESS(&context, &ccList, &zero);  		    if ((status&1) != 1) { 			fclose(fp); 			mailError();t+ 			MAIL$SEND_ABORT(&context, &zero, &zero);0 			return POST_TRYAGAIN; 		    }l 		} 
 		fclose(fp);[ 	    }	 	} else {f 	    ccList.item1_rtn_size = 0;M2 	    ccList.item2_code = MAIL$_SEND_USERNAME_TYPE;) 	    ccList.item2_ptr = (char *) &mailCC;[ 	    ccList.item2_size = 2;S 	    ccList.item2_rtn_size = 0;o 	    ccList.end_list = 0;t> 	    status = MAIL$SEND_ADD_ADDRESS(&context, &ccList, &zero); 	    if ((status&1) != 1) {o 		mailError();* 		MAIL$SEND_ABORT(&context, &zero, &zero); 		return POST_TRYAGAIN;r 	    } 	} 	tokPtr = NULL;C     } ,     itemList.item_code = MAIL$_SEND_SUBJECT;,     itemList.item_size = strlen(subjString);#     itemList.item_ptr = subjString;a     itemList.item_rtn_size = 0;a     itemList.end_list = 0;A     status = MAIL$SEND_ADD_ATTRIBUTE(&context, &itemList, &zero);N     if ((status&1) != 1) {
 	mailError();a0         MAIL$SEND_ABORT(&context, &zero, &zero); 	return POST_TRYAGAIN;     }s /*:  * Iterate over the composition string, extracting records5  * delimited by newlines and sending each as a record   *  */(     textPtr = HeaderString;L     while (*textPtr == '\n') 	textPtr++; 9     lines = wrappedLines = wrapText(textPtr, &lineCount);_       while (*lines) {( 	itemList.item_code = MAIL$_SEND_RECORD;% 	itemList.item_size = strlen(*lines);t 	itemList.item_ptr = *lines; 	itemList.item_rtn_size = 0; 	itemList.end_list = 0;a= 	status = MAIL$SEND_ADD_BODYPART(&context, &itemList, &zero);} 	if ((status&1) != 1) {r 	    mailError(); - 	    MAIL$SEND_ABORT(&context, &zero, &zero);  	    return POST_FAILED; 	} 	s 	FREE(*lines);	 	lines++;s     }T     FREE(wrappedLines);a7     status = MAIL$SEND_MESSAGE(&context, &zero, &zero);t     if ((status&1) != 1) {
 	mailError(); .         MAIL$SEND_END(&context, &zero, &zero); 	return POST_FAILED;     }=*     MAIL$SEND_END(&context, &zero, &zero);     return POST_OKAY;e }T #endif   static voidv includeArticleText() {l     char line[256], *end;(     char *art, *art1;r  H     sizeCompose(utStrlen(CompositionString) + utStrlen(Header.artText));-     end = CompositionString + InsertionPoint;s#     (void) strcpy(TempString, end);(     *end = '\0';  !     if (Header.artText == NULL) {T 	XBell(XtDisplay(TopLevel), 0);p0 	mesgPane(XRN_SERIOUS, "No article to include"); 	return;     } 6     if (PostingMode == REPLY && !IncludeCurrentMode) {9        (void) sprintf(line, "In article %s you write:\n",  		Header.messageId );c     } else {:        (void) sprintf(line, "In article %s, %s writes:\n",$ 		   Header.messageId, Header.from);     }n  +     (void) strcat(CompositionString, line);t:     end = CompositionString + utStrlen(CompositionString);     *end = '\0';       /* copy the article */       art = Header.artText;,'     if (!app_resources.includeHeader) {g5 	for (art1 = art + 1; *art1 != '\0'; art++, art1++) { ) 	    if (*art == '\n' && *art1 == '\n') {n 		art = ++art1;l 		break; 	    } 	}     }  	*E     if (app_resources.includeSep == TRUE && PostingMode != FORWARD) {E8         (void) strcat(end, app_resources.includePrefix);. 	end += utStrlen(app_resources.includePrefix);     } !     for (; *art != '\0'; art++) {  	*end++ = *art;l     	*end = '\0';i 	if (*art == '\n')F 	    if (app_resources.includeSep == TRUE && PostingMode != FORWARD) {2 		(void) strcat(end, app_resources.includePrefix);/ 		end += utStrlen(app_resources.includePrefix);w 	    }     }(     *end++ = '\n';     *end = '\0';6     /* copy back the text after the insertion point */#     (void) strcat(end, TempString);f$     if (ComposeText != (Widget) 0) { #ifdef MOTIF0 	XmTextSetString(ComposeText,CompositionString); #elsed2 	DwtSTextSetString(ComposeText,CompositionString); #endif     }p     return;e }r   /*ARGSUSED*/ static voide8 compIncludeArticleFunction(widget, event, string, count) Widget widget; XEvent *event; String *string;r Cardinal *count; {t     char *art;
 #ifndef MOTIFr     Arg textPos[1];  #endif     long beforeSize, afterSize;n      #ifdef MOTIF(     art = xmWrapTextWidget(ComposeText); #elseR)     art = DwtSTextGetString(ComposeText);= #endif     sizeCompose(utStrlen(art));d#     strcpy(CompositionString, art);n     XtFree(art); #ifdef MOTIF #ifdef MOTIF_V10=     InsertionPoint = XmTextGetInsertionPosition(ComposeText);	 #elseg:     InsertionPoint = XmTextGetCursorPosition(ComposeText); #endif #else L     XtSetArg(textPos[0], DwtNinsertionPosition, (XtArgVal) &InsertionPoint);9     XtGetValues(ComposeText, textPos, XtNumber(textPos));e #endif  -     beforeSize = utStrlen(CompositionString);      includeArticleText();i,     afterSize = utStrlen(CompositionString);  =     InsertionPoint = InsertionPoint + afterSize - beforeSize;x   #ifdef MOTIF3     XmTextSetString(ComposeText,CompositionString);  #ifndef MOTIF_V10eJ     XmTextSetCursorPosition(ComposeText, (XmTextPosition) InsertionPoint); #endifM     XmTextSetInsertionPosition(ComposeText, (XmTextPosition) InsertionPoint);r #elsee5     DwtSTextSetString(ComposeText,CompositionString);SK     XtSetArg(textPos[0], DwtNinsertionPosition,	(XtArgVal) InsertionPoint);S9     XtSetValues(ComposeText, textPos, XtNumber(textPos));n #endif       return;f }f   /*ARGSUSED*/ static voidi8 compIncludeCurrentFunction(widget, event, string, count) Widget widget; XEvent *event; String *string;M Cardinal *count; { /     struct newsgroup *newsgroup = CurrentGroup;e     art_num current;       if (newsgroup != NULL) {. 	Header.artText = getText(newsgroup->current); 	getHeader(current);     } else { 	Header.artText = NULL;m     }      IncludeCurrentMode = True;9     compIncludeArticleFunction(widget, NULL, NULL, NULL);e     IncludeCurrentMode = False;  }   # #define XRNinclude_ABORT          0l# #define XRNinclude_DOIT           1(  R static Widget IncludeBox = (Widget) 0;  /* box for typing in the name of a file */   /*ARGSUSED*/ static voidu. includeHandler(widget, client_data, call_data) Widget widget; caddr_t client_data; caddr_t call_data; /*  * handler for the include box  */i {(
 #ifndef MOTIF%     Arg textPos[1];  #endif     char *end, *file;u
     int i;     FILE *filefp;f     struct stat fileStat;y       PopDownDialog(IncludeBox);  0     if ((int) client_data != XRNinclude_ABORT) {* 	end = CompositionString + InsertionPoint;  	(void) strcpy(TempString, end);
 	*end = '\0';e   	/* copy the file */0 	file = XtNewString(GetDialogValue(IncludeBox));& 	if ((stat(file, &fileStat) != -1) && - 	    ((filefp = fopen(file, "r")) != NULL)) { : 	    sizeCompose(CompositionSize + utStrlen(TempString) +  			fileStat.st_size + 10000); . 	    end = CompositionString + InsertionPoint;( 	    while ((i = getc(filefp)) != EOF) { 		*end = i;e 		end++; 	    } 	    *end = '\0';u 	    (void) fclose(filefp);j	 	} else {.4 	    mesgPane(XRN_SERIOUS, "Can not open `%s' (%s)", 		     file, errmsg(errno)); 	} 	XtFree(file); 	/* new insertion point */* 	InsertionPoint = end - CompositionString;  3 	/* copy back the text after the insertion point */   	(void) strcat(end, TempString);   #ifdef MOTIF1 	XmTextSetString(ComposeText, CompositionString);S #ifndef MOTIF_V10,6 	XmTextSetCursorPosition(ComposeText, InsertionPoint); #endif9 	XmTextSetInsertionPosition(ComposeText, InsertionPoint);e #else-3 	DwtSTextSetString(ComposeText, CompositionString);y, 	XtSetArg(textPos[0], DwtNinsertionPosition,- 	    (XtArgVal) utStrlen(CompositionString));u6 	XtSetValues(ComposeText, textPos, XtNumber(textPos)); #endif     }t       return;n }    e   /*ARGSUSED*/ static voido5 compIncludeFileFunction(widget, event, string, count)m Widget widget; XEvent *event; String *string;e Cardinal *count; { 
 #ifndef MOTIFe     Arg textPos[1];h #endif     char *art;&     static struct DialogArg args[] = {6 	{"doit",  includeHandler, (caddr_t) XRNinclude_DOIT},7 	{"abort", includeHandler, (caddr_t) XRNinclude_ABORT},u     };   #ifdef MOTIF(     art = xmWrapTextWidget(ComposeText); #elseg)     art = DwtSTextGetString(ComposeText);i #endif     sizeCompose(utStrlen(art));t#     strcpy(CompositionString, art);      XtFree(art); #ifdef MOTIF #ifdef MOTIF_V10=     InsertionPoint = XmTextGetInsertionPosition(ComposeText);  #else0:     InsertionPoint = XmTextGetCursorPosition(ComposeText); #endif #elseNL     XtSetArg(textPos[0], DwtNinsertionPosition, (XtArgVal) &InsertionPoint);9     XtGetValues(ComposeText, textPos, XtNumber(textPos));r #endif     #     if (IncludeBox == (Widget) 0) {f+ 	IncludeBox = CreateDialog(ComposeTopLevel,) 				 "Include File Select",g 				 "    File Name?    ",) 				  DIALOG_TEXT, args, XtNumber(args));h     }r     PopUpDialog(IncludeBox);       return;  }  /*ARGSUSED*/ static voidr2 compWrapTextFunction(widget, event, string, count) Widget widget; XEvent *event; String *string;t Cardinal *count; {      char *textString, *ptr;E     char **wrappedLines;     char **lines;\
     int size;)     int oldBreak, oldWrap;
 #ifndef MOTIFt     Arg textPos[1];a #endif     int lineCount;  )     oldBreak = app_resources.breakLength;s6     if (oldBreak == 0) app_resources.breakLength = 80;'     oldWrap = app_resources.lineLength;a4     if (oldWrap == 0) app_resources.lineLength = 72;   #ifdef MOTIF/     textString = xmWrapTextWidget(ComposeText);P #ifdef MOTIF_V10=     InsertionPoint = XmTextGetInsertionPosition(ComposeText);l #else(:     InsertionPoint = XmTextGetCursorPosition(ComposeText); #endif #elset0     textString = DwtSTextGetString(ComposeText);L     XtSetArg(textPos[0], DwtNinsertionPosition, (XtArgVal) &InsertionPoint);9     XtGetValues(ComposeText, textPos, XtNumber(textPos));o #endif<     lines = wrappedLines = wrapText(textString, &lineCount);     XtFree(textString);e  
     size = 0;T     while (*lines) { 	size += strlen(*lines) + 1;	 	lines++;t     }h     sizeCompose(size);     ptr = CompositionString;*     strcpy(CompositionString, textString);       lines = wrappedLines;      while (*lines) { 	strcpy(ptr, *lines);i 	ptr += strlen(*lines);N 	strcpy(ptr, "\n");I 	ptr++;i 	FREE(*lines);	 	lines++;      }X     FREE(wrappedLines);I   #ifdef MOTIF3     XmTextSetString(ComposeText,CompositionString);f #ifndef MOTIF_V10tJ     XmTextSetCursorPosition(ComposeText, (XmTextPosition) InsertionPoint); #endifM     XmTextSetInsertionPosition(ComposeText, (XmTextPosition) InsertionPoint);  #else 5     DwtSTextSetString(ComposeText,CompositionString);e/     XtSetArg(textPos[0], DwtNinsertionPosition,t 	(XtArgVal) InsertionPoint);9     XtSetValues(ComposeText, textPos, XtNumber(textPos));1 #endif)     app_resources.breakLength = oldBreak; '     app_resources.lineLength = oldWrap;c }*   static struct stat originalBuf;; static char FileName[512];  M /* Must reset ComposeActive here, unless we call editMessage() again - ggh */U /* ARGSUSED */ static Boolean processMessage() {      FILE *filefp;1     struct stat buf;/     char *ptr, *msg_type, *confirm1, *confirm2;,
     int mode;h       switch (PostingMode) { 	case POST:o 	case FOLLOWUP:* 	case FOLLOWUPREPLY: 	    msg_type = "article";$ 	    confirm1 = "Post the article?";' 	    confirm2 = "Re-edit the article?";i 	    break; 	 	default:B 	    msg_type= "message"; $ 	    confirm1 = "Send the message?";' 	    confirm2 = "Re-edit the message?";  	    break;e     }i2     if ((filefp = fopen(FileName, "r")) == NULL) {H 	mesgPane(XRN_SERIOUS, "Cannot open the temp file (%s)", errmsg(errno));) 	ComposeActive = False;					    /* ggh */T
 	return True;      }u  ,     if (fstat(fileno(filefp), &buf) == -1) {H 	mesgPane(XRN_SERIOUS, "Cannot stat the temp file (%s)", errmsg(errno)); 	(void) fclose(filefp);u 	(void) unlink(FileName);") 	ComposeActive = False;					    /* ggh */u
 	return True;t     }c  /     if (originalBuf.st_mtime == buf.st_mtime) {$8 	mesgPane(XRN_INFO, "No change, %s aborted.", msg_type); 	(void) fclose(filefp);r 	(void) unlink(FileName); ) 	ComposeActive = False;					    /* ggh */f
 	return True;g     }        if (buf.st_size == 0) {(7 	mesgPane(XRN_INFO, "Zero size, %s aborted", msg_type);  	(void) fclose(filefp);  	(void) unlink(FileName);p) 	ComposeActive = False;					    /* ggh */e
 	return True;O     }        sizeCompose(buf.st_size+1); 0     ptr = ARRAYALLOC(char, (buf.st_size + 100));9     (void) fread(ptr, sizeof(char), buf.st_size, filefp);      ptr[buf.st_size] = '\0';     (void) fclose(filefp);     stripBlankFields(ptr);     stripHeaderField(ptr);     strcpy(HeaderString, ptr);       /* pop up a confirm box */>     if (ConfirmationBox(TopLevel, confirm1) == XRN_CB_ABORT) {; 	if (ConfirmationBox(TopLevel, confirm2) == XRN_CB_ABORT) {c; 	    mesgPane(XRN_SERIOUS, "Aborting the %s, saving to %s",l, 		     msg_type, app_resources.deadLetters); 	    saveDeadLetter(ptr);) 	    FREE(ptr);u. 	    (void) unlink(FileName);				    /* ggh */, 	    ComposeActive = False;				    /* ggh */	 	} else {  	    FREE(ptr);= 	    editMessage(True, NULL);n 	}
 	return True;"     }  	L&     /* send to the proper processor */!     if ((PostingMode == GRIPE) ||  	(PostingMode == FORWARD) || 	(PostingMode == REPLY)) { 	mode = XRN_MAIL;e     } else { 	mode = XRN_NEWS;.     }r     %     switch (postArticle(ptr, mode)) {+ 	case POST_FAILED: 	XBell(XtDisplay(TopLevel), 0);f6 	mesgPane(XRN_SERIOUS, "Could not send, saving in %s", 		 app_resources.deadLetters); 	saveDeadLetter(ptr);o 	FREE(ptr);S 	(void) unlink(FileName);&) 	ComposeActive = False;					    /* ggh */s
 	return True;f      	case POST_NOTALLOWED:M 	mesgPane(XRN_SERIOUS, "Posting not allowed from this machine, saving in %s",t" 		     app_resources.deadLetters); 	(void) unlink(FileName);m) 	ComposeActive = False;					    /* ggh */  	break;e 	s 	case POST_TRYAGAIN:; 	if (ConfirmationBox(TopLevel, confirm2) == XRN_CB_ABORT) { ; 	    mesgPane(XRN_SERIOUS, "Aborting the %s, saving to %s",i, 		     msg_type, app_resources.deadLetters); 	    saveDeadLetter(ptr); . 	    (void) unlink(FileName);				    /* ggh */, 	    ComposeActive = False;				    /* ggh */	 	} else {.) 	    if (editMessage(True, NULL) == -1) {e 		FREE(ptr); 		(void) unlink(FileName);) 		ComposeActive = False;				    /* ggh */i 		return True; 	    } 	} 	break;$ 	D 	case POST_OKAY:$ 	if (PostingMode == FOLLOWUPREPLY) { 	    sendFollowupMail(ptr);p 	} 	switch (mode) { 		case XRN_NEWS:' 		mesgPane(XRN_INFO, "Article Posted");T 		(void) unlink(FileName);) 		ComposeActive = False;				    /* ggh */e 		break;   		case XRN_MAIL:* 		mesgPane(XRN_INFO, "Mail Message Sent"); 		(void) unlink(FileName);) 		ComposeActive = False;				    /* ggh */1 		break; 	} 	break;	     }N     FREE(ptr);     return True; }e     static int forkpid;    #ifndef VMS  #ifdef __STDC__  static voidc catch_sigchld(signo)
 int signo; {t     if (signo != SIGCHLD) {  	/* whoops! */ 	return;     }S$     (void) signal(SIGCHLD, SIG_DFL);     if (forkpid != wait(0)) {  	/* whoops! */ 	return;     }}4     XtAddWorkProc((XtWorkProc)processMessage, NULL);M     /* Don't clobber file name - user might want to re-edit the file.  ggh */i-     /* FileName[0] = '\0'; 					       ggh */      return;m }a #elser
 static int catch_sigchld(signo)
 int signo; {(     if (signo != SIGCHLD) {t 	/* whoops! */
 	return 1;     }A$     (void) signal(SIGCHLD, SIG_DFL);     if (forkpid != wait(0)) {  	/* whoops! */
 	return 1;     }e4     XtAddWorkProc((XtWorkProc)processMessage, NULL);M     /* Don't clobber file name - user might want to re-edit the file.  ggh */N-     /* FileName[0] = '\0'; 					       ggh */N
     return 1;{ }	 #endif /* __STDC__ */t #else /* VMS */  static void=
 spawnDone() {t       if ((spawnStat & 1) != 1) {=? 	mesgPane(XRN_SERIOUS, "Error return from editor command - %d", 
 		spawnStat);      }i4     XtAddWorkProc((XtWorkProc)processMessage, NULL); }= #endif   /*  * definition of the buttons  */	 extern int inCommand;   
 #ifndef MOTIFm  #define XmNlabelString DwtNlabel0 #define XmNactivateCallback DwtNactivateCallback& #define XmNborderWidth DwtNborderWidth #endif   BUTTON(compAbort)t BUTTON(compSend) BUTTON(compSave) BUTTON(compIncludeArticle) BUTTON(compIncludeCurrent) BUTTON(compIncludeFile)& BUTTON(compWrapText)  ( static XtActionsRec ComposeActions[] = {5     {"composeAbort", (XtActionProc) compAbortAction},&4     {"composeSend",  (XtActionProc) compSendAction},5     {"composeSave",   (XtActionProc) compSaveAction},mG     {"composeIncludeCurrent", (XtActionProc) compIncludeCurrentAction}, G     {"composeIncludeArticle", (XtActionProc) compIncludeArticleAction}, A     {"composeIncludeFile", (XtActionProc) compIncludeFileAction},u;     {"composeWrapText", (XtActionProc) compWrapTextAction},  };  D /* Used to fork editors when the widget editor is not being used. */  & static int editMessage(reEdit, header) Boolean reEdit;C
 char *header;t {i     char buffer[1024];     FILE *filefp;m     int sysStat;     int maxdesc;
 #ifdef VMS%     struct dsc$descriptor_s cmd_desc;t$     int one = 1;		/* cli$m_nowait */ #endif       if (!reEdit) { #ifndef VMSI? 	(void) sprintf(buffer, "%s/xrnXXXXXXX", app_resources.tmpDir);m #elser> 	(void) sprintf(buffer, "%sxrnXXXXXXX", app_resources.tmpDir); #endif 	(void) mktemp(buffer);e, 	(void) sprintf(FileName, "%s.tmp", buffer); 	r/ 	if ((filefp = fopen(FileName, "w")) == NULL) {aM 	    mesgPane(XRN_SERIOUS, "Can not open the temp file (%s)", errmsg(errno));  	    return(-1); 	}  % 	sizeCompose(utStrlen(header) + 100);e0 	(void) strcpy(CompositionString, HeaderString);* 	(void) strcat(CompositionString, header);  9 	if ((PostingMode != FORWARD) && (PostingMode != POST) &&. 	    (PostingMode != GRIPE)) { 	    includeArticleText(); 	}	    _     U 	(void) fwrite(CompositionString, sizeof(char), utStrlen(CompositionString), filefp);I 	(void) fclose(filefp);eD 	/* Stat the file only at first edit, not at re-edits.	       ggh */9 	if (stat(FileName, &originalBuf) == -1) {		    /* ggh */EF 	    mesgPane(XRN_SERIOUS, "Can not stat the temp file");    /* ggh */# 	    return(-1);						    /* ggh */e 	}							    /* ggh */     }T 	I     /*O      * app_resources.editorCommand is a sprintf'able string with a %s where thedG      * file name should be placed.  The result should be a command that )      * handles all editing and windowing.t      *      * Examples are:      *      *   emacsclient %s       *   xterm -e vi %se      *   xterm -e microEmacs %se      *      */ C      (void) sprintf(buffer, app_resources.editorCommand, FileName);l #ifndef VMS  #ifdef VFORK_SUPPORTED#     if ((forkpid = vfork()) == 0) {r #else "     if ((forkpid = fork()) == 0) { #endif 	int i;d   #ifdef hpuxo 	maxdesc = _NFILE; #elsel #ifdef SVR4e #include <ulimit.h>a 	maxdesc = ulimit(UL_GDESLIM); #elsep 	maxdesc = getdtablesize();s #endif #endif  	for (i = 3; i < maxdesc; i++) { 	    (void) close(i);s 	}8 	(void) execl("/bin/csh", "csh", "-f", "-c", buffer, 0);8 	(void) fprintf(stderr, "execl of %s failed\n", buffer); 	(void) _exit(127);      }r     if (forkpid < 0) {E 	sprintf(error_buffer, "Can not execute editor (%s)", errmsg(errno));' 	infoNow(error_buffer); A 	/* ComposeActive = False; /* Done in composePane()	       ggh */;A 	unlink (FileName);	  /* instead of FileName[0] = '\0'     ggh */&: 	return -1;		  /* Tell composePane that we failed   ggh */     } else { #ifdef __STDC__d  	signal(SIGCHLD, catch_sigchld); #else;* 	signal(SIGCHLD, (SIG_PF0) catch_sigchld); #endif     }t #else )     cmd_desc.dsc$b_class = DSC$K_CLASS_S; )     cmd_desc.dsc$b_dtype = DSC$K_DTYPE_T;g+     cmd_desc.dsc$w_length = strlen(buffer);r$     cmd_desc.dsc$a_pointer = buffer;  H     sysStat = lib$spawn(&cmd_desc,0,0,&one,0,0, &spawnStat,0,spawnDone);     if ((sysStat & 1) != 1) {k@ 	mesgPane(XRN_SERIOUS, "Error return from spawn - %d, aborting", 		sysStat);  	return(-1);     }( #endif
     return 1;T }    /*:  * brings up a new vertical pane, not moded, but maintains8  * enough state so that the current group and/or current  * article can be changedS  *"  * only one compose pane at a time  *:  * the pane consists of 4 parts: title bar, header window,&  * scrollable text window,  button box  *  * seven functions:i  *    post article  *    followup article  *    reply to authort:  *    include the text of the article (followup and reply)  *    include a file  *    send a gripe  *    forward a messaged  */ 
 static int  composePane(titleString, header) char *titleString;
 char *header;a {;     Widget pane, buttonBox;V
     int i;     Arg paneArgs[15];n     Dimension paneWidth; #ifdef MOTIF     static Arg boxArgs[] = {$ 	{XmNresizeHeight,	(XtArgVal) True},$ 	{XmNresizeWidth,	(XtArgVal) False},$ 	{XmNadjustLast, 	(XtArgVal) False},+ 	{XmNorientation,	(XtArgVal) XmHORIZONTAL},s( 	{XmNpacking,		(XtArgVal) XmPACK_TIGHT},     };     static Arg headerArgs[] = {  	{XmNcolumns,		(XtArgVal) 80}, 	{XmNrows,		(XtArgVal) 10},n' 	{XmNscrollVertical, 	(XtArgVal) TRUE},n0 	{XmNeditMode,  		(XtArgVal) XmMULTI_LINE_EDIT},% 	{XmNpendingDelete,	(XtArgVal) True},t     };     static Arg textArgs[] = {m 	{XmNcolumns,		(XtArgVal) 80}, 	{XmNrows,		(XtArgVal) 30},P' 	{XmNscrollVertical, 	(XtArgVal) TRUE},i0 	{XmNeditMode,  		(XtArgVal) XmMULTI_LINE_EDIT},% 	{XmNpendingDelete,	(XtArgVal) True},s     };       static Arg frameArgs[] = {+ 	{XmNshadowType,		(XtArgVal) XmSHADOW_OUT},I     }; #else /* MOTIF */V     Arg textPos[1];x     static Arg boxArgs[] = {% 	{DwtNresizeHeight,	(XtArgVal) True},/% 	{DwtNresizeWidth,	(XtArgVal) False},i8 	{DwtNorientation,	(XtArgVal) DwtOrientationHorizontal},3 	{DwtNmenuPacking,	(XtArgVal) DwtMenuPackingTight},t+ 	{DwtNmenuExtendLastRow, (XtArgVal) False}, ! 	{DwtNborderWidth,	(XtArgVal) 3},r! 	{DwtNentryBorder,	(XtArgVal) 2},e 	{DwtNspacing,		(XtArgVal) 2},& 	{DwtNchildOverlap,	(XtArgVal) False},$ 	{DwtNmenuNumColumns,	(XtArgVal) 1}, 	{DwtNmin,		(XtArgVal) 30},n) 	{DwtNmenuType,		(XtArgVal) DwtWorkarea},L     };     static Arg headerArgs[] = {  	{DwtNcols,		(XtArgVal) 80}, 	{DwtNrows,		(XtArgVal) 10}," 	{DwtNwordWrap,		(XtArgVal) TRUE},' 	{DwtNscrollVertical,	(XtArgVal) TRUE},n     };     static Arg textArgs[] = {D 	{DwtNcols,		(XtArgVal) 80}, 	{DwtNrows,		(XtArgVal) 30},# 	{DwtNwordWrap, 		(XtArgVal) TRUE},d' 	{DwtNscrollVertical,	(XtArgVal) TRUE},f     };   #endif /* MOTIF */     if (ComposeActive) {> 	mesgPane(XRN_SERIOUS, "Only one composition pane at a time"); 	return(-1);     }t  3     if (app_resources.editorCommand != NIL(char)) {  	ComposeActive = True;' 	if (editMessage(False, header) == -1){n 	    ComposeActive = False;o 	    return -1;r 	}C 	/* We aren't done composing until we get a SIGCHLD -	       ggh */e+ 	/* ComposeActive = False;				       ggh */& 	return(0);-     }           ComposeActive = True; (     if (ComposeTopLevel != (Widget) 0) { 	i = 0;S #ifdef MOTIF> 	XtSetArg(paneArgs[i], XmNtitle,		(XtArgVal) titleString);i++; #elseI> 	XtSetArg(paneArgs[i], DwtNtitle,	(XtArgVal) titleString);i++; #endif+ 	XtSetValues(ComposeTopLevel, paneArgs, i);o     } else { 	i = 0;} #ifdef MOTIF8 	XtSetArg(paneArgs[i], XtNinput, 	(XtArgVal) True); i++;D 	XtSetArg(paneArgs[i], XmNiconName, 	(XtArgVal) "XRN Compose"); i++;< 	XtSetArg(paneArgs[i], XmNtransient,	(XtArgVal) False); i++;? 	XtSetArg(paneArgs[i], XmNtitle,		(XtArgVal) titleString); i++;iG 	XtSetArg(paneArgs[i], XmNcursorPositionVisible, (XtArgVal) True); i++;  #else 8 	XtSetArg(paneArgs[i], XtNinput, 	(XtArgVal) True); i++;B 	XtSetArg(paneArgs[i], XtNallowShellResize, (XtArgVal) True); i++;> 	XtSetArg(paneArgs[i], DwtNtitle,	(XtArgVal) titleString);i++; #endif  4 	ComposeTopLevel = XtCreatePopupShell("composeTop",  					 topLevelShellWidgetClass,) 					 TopLevel,C 					 paneArgs, i);X   #ifdef MOTIF? 	pane = XtCreateManagedWidget("pane", xmPanedWindowWidgetClass,c 					ComposeTopLevel, NULL, 0);i #elsev 	i = 0;n6 	XtSetArg(paneArgs[i], DwtNwidth,	(XtArgVal) 680);i++;7 	XtSetArg(paneArgs[i], DwtNheight,	(XtArgVal) 600);i++;o6 	pane = XtCreateManagedWidget("pane", panewidgetclass,# 					ComposeTopLevel, paneArgs, i);d #endif  A     /* XXX how to make a 80 column text window with scroll bar */l& 	if (app_resources.breakLength > 39) {V             headerArgs[0].value = (XtArgVal) app_resources.breakLength; /* set cols */> 	    textArgs[0].value = (XtArgVal) app_resources.breakLength;	 	} else { ) 	    headerArgs[0].value = (XtArgVal) 80;d' 	    textArgs[0].value = (XtArgVal) 80;G 	}% 	if (app_resources.composeRows > 0) { > 	    textArgs[1].value = (XtArgVal) app_resources.composeRows; 	} #ifdef MOTIFG 	headerFrame = XtCreateManagedWidget("headerFrame", xmFrameWidgetClass, * 					pane, frameArgs,XtNumber(frameArgs));= 	HeaderText = XmCreateScrolledText(headerFrame, "headerText",f' 					headerArgs, XtNumber(headerArgs));v- 	fitFrameToContents(headerFrame, HeaderText);i #else?0 	HeaderText = DwtSTextCreate(pane, "headerText",' 					headerArgs, XtNumber(headerArgs));  #endif 	XtManageChild(HeaderText);c #ifdef MOTIFC 	textFrame = XtCreateManagedWidget("textFrame", xmFrameWidgetClass,** 					pane, frameArgs,XtNumber(frameArgs));> 	ComposeText = XmCreateScrolledText(textFrame, "composeText", # 					textArgs, XtNumber(textArgs));n, 	fitFrameToContents(textFrame, ComposeText); #else[3 	ComposeText = DwtSTextCreate(pane, "composeText", p# 					textArgs, XtNumber(textArgs));B #endif 	XtManageChild(ComposeText); #ifdef MOTIFA 	buttonBox = XtCreateManagedWidget("box", xmRowColumnWidgetClass,e$ 		pane, boxArgs, XtNumber(boxArgs)); #elsetD 	buttonBox = DwtMenuCreate(pane, "box", boxArgs, XtNumber(boxArgs)); 	XtManageChild(buttonBox);   	paneWidth = 0;). 	XtSetArg(paneArgs[0], DwtNwidth, &paneWidth);' 	XtGetValues(ComposeText, paneArgs, 1); - 	XtSetArg(paneArgs[0], DwtNwidth, paneWidth);   	XtSetValues(pane, paneArgs, 1); #endif  1 	if (compAbortArgs[1].value == (XtArgVal) NULL) {o #ifdef MOTIFC 	    compAbortArgs[1].value = (XtArgVal)XmStringLtoRCreate("Abort",x 			XmSTRING_DEFAULT_CHARSET);  #elsetA 	    compAbortArgs[1].value = (XtArgVal)DwtLatin1String("Abort");e #endif 	} #ifdef MOTIFF 	AbortButton = XtCreateManagedWidget("abort", xmPushButtonWidgetClass,6 			buttonBox, compAbortArgs, XtNumber(compAbortArgs));      	paneWidth = 0;i. 	XtSetArg(paneArgs[0], XmNheight, &paneWidth);' 	XtGetValues(AbortButton, paneArgs, 1); 2 	PaneSetMinMax(buttonBox, paneWidth, paneWidth+5); #elseID 	AbortButton = XtCreateManagedWidget("abort", pushbuttonwidgetclass,6 			buttonBox, compAbortArgs, XtNumber(compAbortArgs)); #endif0 	if (compSendArgs[1].value == (XtArgVal) NULL) { #ifdef MOTIFA 	    compSendArgs[1].value = (XtArgVal)XmStringLtoRCreate("Send",  			XmSTRING_DEFAULT_CHARSET);, #elset? 	    compSendArgs[1].value = (XtArgVal)DwtLatin1String("Send");( #endif 	} #ifdef MOTIFD 	SendButton = XtCreateManagedWidget("send", xmPushButtonWidgetClass,4 			buttonBox, compSendArgs, XtNumber(compSendArgs)); #else.B 	SendButton = XtCreateManagedWidget("send", pushbuttonwidgetclass,4 			buttonBox, compSendArgs, XtNumber(compSendArgs)); #endif     0 	if (compSaveArgs[1].value == (XtArgVal) NULL) { #ifdef MOTIFA 	    compSaveArgs[1].value = (XtArgVal)XmStringLtoRCreate("Save",; 			XmSTRING_DEFAULT_CHARSET);n #else*? 	    compSaveArgs[1].value = (XtArgVal)DwtLatin1String("Save");O #endif 	} #ifdef MOTIFD 	SaveButton = XtCreateManagedWidget("save", xmPushButtonWidgetClass,4 			buttonBox, compSaveArgs, XtNumber(compSaveArgs)); #else B 	SaveButton = XtCreateManagedWidget("save", pushbuttonwidgetclass,4 			buttonBox, compSaveArgs, XtNumber(compSaveArgs)); #endif  7 	if (compIncludeFileArgs[1].value == (XtArgVal) NULL) {) #ifdef MOTIFB 	    compIncludeFileArgs[1].value = (XtArgVal) XmStringLtoRCreate( 			"Include File", 			XmSTRING_DEFAULT_CHARSET);r #elser> 	    compIncludeFileArgs[1].value = (XtArgVal)DwtLatin1String( 			"Include File");" #endif 	} #ifdef MOTIF9 	IncludeFileButton = XtCreateManagedWidget("includeFile",n& 			xmPushButtonWidgetClass, buttonBox,7 			compIncludeFileArgs, XtNumber(compIncludeFileArgs));r #elseu9 	IncludeFileButton = XtCreateManagedWidget("includeFile",n$ 			pushbuttonwidgetclass, buttonBox,7 			compIncludeFileArgs, XtNumber(compIncludeFileArgs));i #endif  : 	if (compIncludeArticleArgs[1].value == (XtArgVal) NULL) { #ifdef MOTIFD 	    compIncludeArticleArgs[1].value = (XtArgVal)XmStringLtoRCreate( 			"Include Article",d 			XmSTRING_DEFAULT_CHARSET);c #elseFA 	    compIncludeArticleArgs[1].value = (XtArgVal)DwtLatin1String(( 		 	"Include Article");  #endif 	} #ifdef MOTIF? 	IncludeArticleButton = XtCreateManagedWidget("includeArticle",f& 			xmPushButtonWidgetClass, buttonBox,= 			compIncludeArticleArgs, XtNumber(compIncludeArticleArgs));i #elseF? 	IncludeArticleButton = XtCreateManagedWidget("includeArticle",f$ 			pushbuttonwidgetclass, buttonBox,= 			compIncludeArticleArgs, XtNumber(compIncludeArticleArgs));e #endif: 	if (compIncludeCurrentArgs[1].value == (XtArgVal) NULL) { #ifdef MOTIFD 	    compIncludeCurrentArgs[1].value = (XtArgVal)XmStringLtoRCreate( 			"Include Current",  			XmSTRING_DEFAULT_CHARSET);k #elsemA 	    compIncludeCurrentArgs[1].value = (XtArgVal)DwtLatin1String(  			"Include Current"); #endif 	} #ifdef MOTIF? 	IncludeCurrentButton = XtCreateManagedWidget("includeCurrent",o& 			xmPushButtonWidgetClass, buttonBox,= 			compIncludeCurrentArgs, XtNumber(compIncludeCurrentArgs));P #else ? 	IncludeCurrentButton = XtCreateManagedWidget("includeCurrent", $ 			pushbuttonwidgetclass, buttonBox,= 			compIncludeCurrentArgs, XtNumber(compIncludeCurrentArgs));P #endif4 	if (compWrapTextArgs[1].value == (XtArgVal) NULL) { #ifdef MOTIF> 	    compWrapTextArgs[1].value = (XtArgVal)XmStringLtoRCreate( 			"Word Wrap Text", 			XmSTRING_DEFAULT_CHARSET);r #elser; 	    compWrapTextArgs[1].value = (XtArgVal)DwtLatin1String(o 			"Word Wrap Text");t #endif 	} #ifdef MOTIF3 	WrapTextButton = XtCreateManagedWidget("wrapText",k& 			xmPushButtonWidgetClass, buttonBox,1 			compWrapTextArgs, XtNumber(compWrapTextArgs));: #elseC3 	WrapTextButton = XtCreateManagedWidget("wrapText", $ 			pushbuttonwidgetclass, buttonBox,1 			compWrapTextArgs, XtNumber(compWrapTextArgs));u #endif 	xmIconCreate(ComposeTopLevel);t8 	XtAddActions(ComposeActions, XtNumber(ComposeActions));     }e  "     sizeCompose(utStrlen(header));-     (void) strcpy(CompositionString, header);  #ifdef MOTIF-     XmTextSetString(HeaderText,HeaderString); 3     XmTextSetString(ComposeText,CompositionString);} #ifndef MOTIF_V10sJ     XmTextSetCursorPosition(ComposeText, (XmTextPosition) EditorPosition); #endifM     XmTextSetInsertionPosition(ComposeText, (XmTextPosition) EditorPosition);  #else)/     DwtSTextSetString(HeaderText,HeaderString); 5     DwtSTextSetString(ComposeText,CompositionString);XK     XtSetArg(textPos[0], DwtNinsertionPosition, (XtArgVal) EditorPosition); 9     XtSetValues(ComposeText, textPos, XtNumber(textPos));  #endif  %     XtSetSensitive(SendButton, True);t%     XtSetSensitive(SaveButton, True);D,     XtSetSensitive(IncludeFileButton, True);@     XtSetSensitive(IncludeArticleButton, (PostingMode != POST));/     XtSetSensitive(IncludeCurrentButton, True); )     XtSetSensitive(WrapTextButton, True);/%     XtRealizeWidget(ComposeTopLevel);X     ) #if defined(MOTIF) && !defined(MOTIF_V10)o8     XmProcessTraversal(ComposeText, XmTRAVERSE_CURRENT); #endif  )     XtPopup(ComposeTopLevel, XtGrabNone);        return(0); }s   /*F  * return a string containing the contents of the users signature file  *   (in a static buffer)r  *M  * if the signature file is bigger than MAX_SIGNATURE_SIZE, return NIL(char).   */h static char *signatureFile() {      char *file;W     FILE *infofp;a     int (*close_func)() = 0;     long count;e+     static char info[MAX_SIGNATURE_SIZE+5];      static char *retinfo;	      static char *sigfile = NULL;     char *artfile = NULL;      FILE *fpsave;t     Boolean execSig;   #if defined(INEWS_READS_SIG)O     /* these posting modes do not go through INEWS, so include the signature */w;     if ((PostingMode != REPLY) && (PostingMode != GRIPE)) {e
 	return 0;     }f #endif /* INEWS_READS_SIG */       if (sigfile != NULL) { 	FREE(sigfile);      }   K     if ((file = utTildeExpand(app_resources.signatureFile)) == NIL(char)) {a 	return NIL(char);     }D  $     /* handle multiple signatures */     while (1) {S 	/* find an appropriate sig */3         struct newsgroup *newsgroup = CurrentGroup;N 	char *psigfile = NIL(char); 	char *ptr;    	if (!CurrentGroup) {s+ 	    sigfile = XtMalloc(strlen(file) + 10);n	 	} else {b4 	    /* signature according to group or hierarchy */E 	    sigfile = XtMalloc(strlen(file) + 10 + strlen(newsgroup->name)); ) 	    if (app_resources.localSignatures) {c( 		ptr = localKillFile(newsgroup, FALSE); 		(void) strcpy(sigfile, ptr); 		ptr = rindex(sigfile, '/'); 
 		ptr[1] = 0;eC 		ptr = (char *) (sigfile + strlen(app_resources.expandedSaveDir));"5 		while ((psigfile = rindex(sigfile, '/')) != NULL) {o 		    if (psigfile < ptr) {  			psigfile = NULL;s	 			break;t 		    }e 		    psigfile[0] = 0;+ 		    (void) strcat(sigfile, "/SIGNATURE"); $ 		    if (! access(sigfile, F_OK)) { 			/* FOUND */	 			break;  		    }  		    psigfile[0] = 0; 		}s
 	    } else {e 		(void) strcpy(sigfile, file);n 		(void) strcat(sigfile, "-"); 		ptr = rindex(sigfile, '-');p* 		(void) strcat(sigfile, newsgroup->name); 		(void) strcat(sigfile, ".");: 		while ((psigfile = rindex(sigfile, '.')) != NIL(char)) { 		    if (psigfile < ptr) {o 			psigfile = NIL(char);	 			break;r 		    }i 		    psigfile[0] = 0;$ 		    if (! access(sigfile, F_OK)) {
 			/*FOUND*/ a	 			break;t 		    }i 		}s 	    } 	}   	if (psigfile != NIL(char)) {  	    /*FOUND*/ 	    break;  	}  + 	/* signature according to posting mode. */t 	(void) strcpy(sigfile, file); 	(void) strcat(sigfile, ".");t9 	(void) strcat(sigfile, PostingModeStrings[PostingMode]);t   	if (! access(sigfile, F_OK)) {r 	    /*FOUND*/ 	    break;  	}   	(void) strcpy(sigfile, file); 	if (! access(sigfile, F_OK)) {i 	    break;I	 	} else {c 	    return NIL(char); 	}     }n       {s 	char cmdbuf[1024];t  	char *p = rindex(sigfile, '/');   	infofp = NIL(FILE);   	if (! p) {* 	     p = sigfile;	 	} else {"
 	     p++; 	}   #ifndef VMS  	if (Header.artText) {- 	    artfile = (char *) tempnam(NULL, "XRN");/! 	    fpsave = fopen(artfile,"w");s 	    if (fpsave) {  		fputs(Header.artText, fpsave); 		(void) fclose(fpsave);
 	    } else {p 		artfile = NULL;s 	    } 	}  G 	if (app_resources.executableSignatures && (! access(sigfile, X_OK))) {a) 	    if (app_resources.signatureNotify) { A 		mesgPane(XRN_INFO, "Executing signature command %s.", sigfile);* 	    }* 	    (void) sprintf(cmdbuf, "%s %s %s %s", 			    sigfile,F3 			    (CurrentGroup ? CurrentGroup->name : "NIL"), ' 			    PostingModeStrings[PostingMode], $ 			    (artfile ? artfile : "NIL"));! 	    infofp = popen(cmdbuf, "r");x 	    close_func = pclose;d 	    if (!infofp) {l 		mesgPane(XRN_SERIOUS, : 			 "Cannot execute signature file %s.  Reading instead.",
 			 sigfile);( 	    }	 	} else {  #endif) 	    if (app_resources.signatureNotify) {/ 		mesgPane(XRN_INFO,+ 			 "Reading signature file %s.", sigfile);e 	    } #ifndef VMS  	} #endif   	if (!infofp) { " 	    infofp = fopen(sigfile, "r"); 	    close_func = fclose;  	    if (! infofp) {9 		mesgPane(XRN_SERIOUS, "Cannot read signature file %s.",v
 			 sigfile);o 		return NIL(char);  	    } 	}     }n  !     (void) strcpy(info, "-- \n");eD     count = fread(&info[4], sizeof(char), sizeof(info) - 4, infofp);     info[count + 4] = '\0';i       if (! feof(infofp)) {L  	/* Signature file is too big */ 	retinfo = NIL(char);t     }h1     else if (strncmp(info + 4, "--\n", 3) == 0 ||a+ 	     strncmp(info + 4, "-- \n", 4) == 0) {e 	retinfo = info + 4;     } else { 	retinfo = info;     })  !     if (artfile) unlink(artfile);e!     (void) (*close_func)(infofp);d       return retinfo;n }t  J /* public functions 'reply', 'gripe', 'forward', 'followup', and 'post' */   void reply()  {d/     struct newsgroup *newsgroup = CurrentGroup; )     art_num current = newsgroup->current;      char title[LABEL_SIZE];o     char pathFormatString[100];t     char *message, *signature;%     int OldPostingMode = PostingMode;        if (ComposeActive) {> 	mesgPane(XRN_SERIOUS, "Only one composition pane at a time"); 	return;     }r     getHeader(current);t&     Header.artText = getText(current);       PostingMode = REPLY;:     message = XtMalloc(MAX_SIGNATURE_SIZE + BUFFER_SIZE +  			utStrlen(Header.artText));)M     sizeCompose(utStrlen(Header.artText) + MAX_SIGNATURE_SIZE + BUFFER_SIZE);t  @     (void) sprintf(title, "Reply to article %ld in %s", current, 		newsgroup->name);g     /     if (app_resources.replyPath != NIL(char)) {n 	if (app_resources.ccForward) {f2 	    sprintf(pathFormatString, "To: %s\nCc: %s\n",( 		app_resources.replyPath, Header.user);	 	} else {F$ 	    if (app_resources.cc == True) {- 		sprintf(pathFormatString, "To: %s\nCc: \n",A 			app_resources.replyPath);
 	    } else {,@ 		sprintf(pathFormatString, "To: %s\n",app_resources.replyPath); 	    } 	}     } else { 	if (app_resources.ccForward) {,F 	    sprintf(pathFormatString, "To: %s\nCc: %s\n", "%s", Header.user);	 	} else {g$ 	    if (app_resources.cc == True) {- 		strcpy(pathFormatString, "To: %s\nCc: \n");t
 	    } else {{' 		strcpy(pathFormatString, "To: %s\n");r 	    } 	}     }T-     (void) sprintf(message, pathFormatString,N? 		   (*Header.replyTo != '\0') ? Header.replyTo : Header.from);t  -     if (app_resources.replyTo != NIL(char)) {g' 	 (void) strcat(message, "Reply-To: ");T0 	 (void) strcat(message, app_resources.replyTo); 	 (void) strcat(message, "\n");A     }T  )     if (app_resources.extraMailHeaders) {i+ 	 (void) sprintf(&message[strlen(message)],n) 			"X-Newsgroups: %s\nIn-reply-to: %s\n", ( 			Header.newsgroups, Header.messageId);     }(       buildSubject(message);.     if (app_resources.editorCommand != NULL) { 	(void) strcat(message,n1   		"-=-=-=-= Enter your text below this line ");F? 	(void) strcat(message, "(don't delete this line) =-=-=-=-\n");a     }n!     (void) strcat(message, "\n");r'     InsertionPoint = utStrlen(message);g!     (void) strcat(message, "\n");0"     strcpy(HeaderString, message);     message[0] = '\0';     EditorPosition = 0;t5     if ((signature = signatureFile()) != NIL(char)) {g 	(void) strcpy(message, "\n");# 	(void) strcat(message, signature);      }o$     if (composePane(title, message)) 	 PostingMode = OldPostingMode;        FREE(message);     return;f }o     void gripe()s {n     char title[LABEL_SIZE];o9     char message[MAX_SIGNATURE_SIZE + 10000], *signature;p%     int OldPostingMode = PostingMode;      char gripeTo[200];          if (ComposeActive) {> 	mesgPane(XRN_SERIOUS, "Only one composition pane at a time"); 	return;     }o     sizeCompose(1000);
 #ifdef VMS/     if (app_resources.replyPath != NIL(char)) { 3 	sprintf(gripeTo, app_resources.replyPath, GRIPES);A     } else { 	strcpy(gripeTo, GRIPES);=     }t #else      strcpy(gripeTo, GRIPES); #endif"     (void) strcpy(title, "Gripe");F     (void) sprintf(message, "To: %s\nSubject: GRIPE about XRN %s\n\n", 		   gripeTo, XRN_VERSION);a.     if (app_resources.editorCommand != NULL) { 	(void) strcat(message,F1   		"-=-=-=-= Enter your text below this line ");)? 	(void) strcat(message, "(don't delete this line) =-=-=-=-\n");o     }+'     InsertionPoint = utStrlen(message);(!     (void) strcat(message, "\n");a)     (void) strcpy(HeaderString, message);g       EditorPosition = 0;s     message[0] = '\0';5     if ((signature = signatureFile()) != NIL(char)) {r 	(void) strcpy(message, "\n");# 	(void) strcat(message, signature);l     }l       Header.artText = NULL;     PostingMode = GRIPE;$     if (composePane(title, message)) 	 PostingMode = OldPostingMode;C       return;( }m     void	 forward()L {l     char title[LABEL_SIZE];L     char *signature;/     struct newsgroup *newsgroup = CurrentGroup;d)     art_num current = newsgroup->current;	%     int OldPostingMode = PostingMode;i          if (ComposeActive) {> 	mesgPane(XRN_SERIOUS, "Only one composition pane at a time"); 	return;     })     getHeader(current);a&     Header.artText = getText(current);!     if (Header.artText == NULL) {  	XBell(XtDisplay(TopLevel), 0);a0 	mesgPane(XRN_SERIOUS, "No article to include"); 	freeHeader(); 	return;     }   F     sizeCompose(MAX_SIGNATURE_SIZE + utStrlen(Header.artText) + 1000);I     (void) sprintf(title, "Forward article %ld in %s to a User", current,; 		   newsgroup->name);*     if (app_resources.ccForward == True) {F 	(void) sprintf(HeaderString, "To: \nCc: %s\nSubject: %s - %s #%ld\n", 		       Header.user,l3 		       Header.subject, newsgroup->name, current);f     } else {  	if (app_resources.cc == True) {" 	    (void) sprintf(HeaderString, ) 		"To: \nCc: \nSubject: %s - %s #%ld\n" ,H, 		Header.subject, newsgroup->name, current);	 	} else {"C 	    (void) sprintf(HeaderString, "To: \nSubject: %s - %s #%ld\n" ,d, 		Header.subject, newsgroup->name, current); 	}     }a.     if (app_resources.editorCommand != NULL) { 	(void) strcat(HeaderString,1   		"-=-=-=-= Enter your text below this line ");=D 	(void) strcat(HeaderString, "(don't delete this line) =-=-=-=-\n");     }s     InsertionPoint = 0;C5     if ((signature = signatureFile()) != NIL(char)) {x& 	(void) strcpy(TempString, signature);     } else { 	*TempString = '\0';     }e  *     strcpy(CompositionString, TempString);1     EditorPosition = utStrlen(CompositionString);r     InsertionPoint = 0;C     PostingMode = FORWARD;     includeArticleText();MB     EditorPosition = utStrlen(CompositionString) - EditorPosition;/     if (EditorPosition < 0) EditorPosition = 0;e*     strcpy(TempString, CompositionString);'     if (composePane(title, TempString))= 	 PostingMode = OldPostingMode;w     return;d };   #ifdef GENERATE_EXTRA_FIELDS /*  *  generate a message id0  */t static char genid[132];S   static char *gen_id()1 {      char *timestr, *cp;r     time_t cur_time;       time(&cur_time);     timestr = ctime(&cur_time);   ;     (void) sprintf(genid, "<%.4s%.3s%.2s.%.2s%.2s%.2s@%s>",R- 		    &timestr[20], &timestr[4], &timestr[8],X/ 		    &timestr[11], &timestr[14], &timestr[17],i 		    Header.host);t     cp = &genid[8];i       if (*cp == ' ') {n 	do {l 	    *cp = *(cp + 1);  	} while (*cp++);(     }r       return(genid); }h /*$  * generate a valid RFC822 date-time  */W static char gendate[40];   static char *gen_date()n {t       time_t clockTime;t     char *atime, *tz;I     struct tm *cur_time;       (void) time(&clockTime);"     cur_time = gmtime(&clockTime);     if (cur_time) {b 	atime = ctime(&clockTime);S 	tz = "GMT";     } else {( 	atime = asctime(localtime(&clockTime)); 	tz = getenv(TIMEZONE_ENV);n 	if (tz == NULL) {5 	    fprintf(stderr, "xrn: TIMEZONE_ENV not set\n"); A 	    tz = "GMT"; 	}     }a9     sprintf(gendate, "%3.3s, %2.2s %3.3s %2.2s %8.8s %s", 2 	atime, atime+8, atime+4, atime+22, atime+11, tz);     return(gendate); }e #endif   static voidn doFollowup(newMode)n int newMode; {e/     struct newsgroup *newsgroup = CurrentGroup;b)     art_num current = newsgroup->current;g*     char buffer[10000], title[LABEL_SIZE];     char *signature;%     int OldPostingMode = PostingMode;v       if (ComposeActive) {> 	mesgPane(XRN_SERIOUS, "Only one composition pane at a time"); 	return;     }l       getHeader(current);i  0     if (! strcmp(Header.followupTo, "poster")) { 	 freeHeader();Wa 	 mesgPane(XRN_INFO, "Message says to followup to poster; composing reply instead of followup."); 
 	 reply();	 	 return;e     }W  ?     if ((newsgroup->status & NG_UNPOSTABLE) == NG_UNPOSTABLE) {t 	freeHeader();> 	mesgPane(XRN_SERIOUS, "Can not post articles to this group"); 	return;     }f  &     Header.artText = getText(current);F     sizeCompose(utStrlen(Header.artText) + MAX_SIGNATURE_SIZE + 1000);          PostingMode = newMode;:     (void) sprintf(title, "Followup to article %ld in %s", 		   current, newsgroup->name);M  ( #if defined(INEWS) || defined(HIDE_PATH):     (void) sprintf(TempString, "Path: %s\n", Header.user); #elsemJ     (void) sprintf(TempString, "Path: %s!%s\n", Header.path, Header.user); #endifK     if ((Header.followupTo != NIL(char)) && (*Header.followupTo != '\0')) {c4 	Header.newsgroups = XtNewString(Header.followupTo);     } B     (void) sprintf(buffer, "Newsgroups: %s\n", Header.newsgroups);&     (void) strcpy(TempString, buffer);0     (void) strcat(TempString, "Distribution: ");O     if ((Header.distribution != NIL(char)) && (*Header.distribution != '\0')) {]0 	(void) strcat(TempString, Header.distribution);,     } else if (app_resources.distribution) {7 	(void) strcat(TempString, app_resources.distribution);f
     } else {	o) 	(void) strcat(TempString, DISTRIBUTION);i     },$     (void) strcat(TempString, "\n");8     (void) sprintf(buffer, "X-Newsreader: %s\n", TITLE);&     (void) strcat(TempString, buffer);1     (void) strcat(TempString, "Followup-To: \n");o1     (void) sprintf(buffer, "References: %s %s\n",u& 	Header.references, Header.messageId);&     (void) strcat(TempString, buffer);0     (void) sprintf(buffer, "From: %s@%s (%s)\n",0 		   Header.user, Header.host, Header.fullname);&     (void) strcat(TempString, buffer);   #ifdef GENERATE_EXTRA_FIELDS2     /* stuff to generate Message-ID and Date... */5     (void) sprintf(buffer, "Date: %s\n", gen_date());u&     (void) strcat(TempString, buffer);9     (void) sprintf(buffer, "Message-ID: %s\n", gen_id());d&     (void) strcat(TempString, buffer); #endif  ,     (void) strcat(TempString, "Reply-To: ");-     if (app_resources.replyTo != NIL(char)) {e2 	(void) strcat(TempString, app_resources.replyTo);     } else {% 	(void) sprintf(buffer, "%s@%s (%s)",L4 		       Header.user, Header.host, Header.fullname);# 	(void) strcat(TempString, buffer);d     }e$     (void) strcat(TempString, "\n");  0     (void) strcat(TempString, "Organization: ");2     if (app_resources.organization != NIL(char)) {7 	(void) strcat(TempString, app_resources.organization);w     } else { 	if (Header.organization) {t4 	    (void) strcat(TempString, Header.organization);	 	} else {C) 	    (void) strcat(TempString, ORG_NAME);w 	}     } $     (void) strcat(TempString, "\n");       buildSubject(TempString);p     ,     (void) strcat(TempString, "Keywords: ");G     if ((Header.keywords != NIL(char)) && (*Header.keywords != '\0')) { , 	(void) strcat(TempString, Header.keywords);     }p$     (void) strcat(TempString, "\n");.     if (app_resources.editorCommand != NULL) { 	(void) strcat(TempString,1   		"-=-=-=-= Enter your text below this line ");sB 	(void) strcat(TempString, "(don't delete this line) =-=-=-=-\n");     };,     (void) strcpy(HeaderString, TempString);  ;     EditorPosition = InsertionPoint = utStrlen(TempString);t      #if !defined(INEWS_READS_SIG) 5     if ((signature = signatureFile()) != NIL(char)) { ! 	(void) strcpy(TempString, "\n");i& 	(void) strcat(TempString, signature);     } else { 	*TempString = '\0';     }u #elsex     *TempString = '\0';t #endif  '     if (composePane(title, TempString))e 	 PostingMode = OldPostingMode;n       return;i }u void
 followup() {e     doFollowup(FOLLOWUP);t },   void followupAndReply() {t     doFollowup(FOLLOWUPREPLY); }T   void post() {n/     struct newsgroup *newsgroup = CurrentGroup;e*     char title[LABEL_SIZE], buffer[10000];     char *signature;%     int OldPostingMode = PostingMode;t       if (ComposeActive) {> 	mesgPane(XRN_SERIOUS, "Only one composition pane at a time"); 	return;     }r     if (newsgroup) {< 	if ((newsgroup->status & NG_UNPOSTABLE) == NG_UNPOSTABLE) {B 	    mesgPane(XRN_SERIOUS, "Can not post articles to this group"); 	    return; 	}     }        sizeCompose(10000);u     getHeader((art_num) 0);W       if (!newsgroup) {  	FREE(Header.newsgroups); % 	Header.newsgroups = XtNewString("");X9 	(void) strcpy(title, "Post article (no current group)");c     } else {@ 	(void) sprintf(title, "Post article to `%s'", newsgroup->name);2 	Header.newsgroups = XtNewString(newsgroup->name);     }p  ( #if defined(INEWS) || defined(HIDE_PATH):     (void) sprintf(TempString, "Path: %s\n", Header.user); #elseoJ     (void) sprintf(TempString, "Path: %s!%s\n", Header.path, Header.user); #endifB     (void) sprintf(buffer, "Newsgroups: %s\n", Header.newsgroups);&     (void) strcat(TempString, buffer);0     (void) strcat(TempString, "Distribution: ");%     if (app_resources.distribution) { 7 	(void) strcat(TempString, app_resources.distribution);w
     } else {	u) 	(void) strcat(TempString, DISTRIBUTION);h     }c$     (void) strcat(TempString, "\n");8     (void) sprintf(buffer, "X-Newsreader: %s\n", TITLE);&     (void) strcat(TempString, buffer);   #ifdef GENERATE_EXTRA_FIELDS2     /* stuff to generate Message-ID and Date... */5     (void) sprintf(buffer, "Date: %s\n", gen_date());o&     (void) strcat(TempString, buffer);9     (void) sprintf(buffer, "Message-ID: %s\n", gen_id());t&     (void) strcat(TempString, buffer); #endif  1     (void) strcat(TempString, "Followup-To: \n");=0     (void) sprintf(buffer, "From: %s@%s (%s)\n",0 		   Header.user, Header.host, Header.fullname);&     (void) strcat(TempString, buffer);,     (void) strcat(TempString, "Reply-To: ");-     if (app_resources.replyTo != NIL(char)) { 2 	(void) strcat(TempString, app_resources.replyTo);     } else {Q 	(void) sprintf(buffer, "%s@%s (%s)", Header.user, Header.host, Header.fullname);s# 	(void) strcat(TempString, buffer);l     }g$     (void) strcat(TempString, "\n");  0     (void) strcat(TempString, "Organization: ");2     if (app_resources.organization != NIL(char)) {7 	(void) strcat(TempString, app_resources.organization);0     } else { 	if (Header.organization) {{4 	    (void) strcat(TempString, Header.organization);	 	} else {p) 	    (void) strcat(TempString, ORG_NAME);  	}     } $     (void) strcat(TempString, "\n");-     (void) strcat(TempString, "Subject: \n");(.     (void) strcat(TempString, "Keywords: \n");.     if (app_resources.editorCommand != NULL) { 	(void) strcat(TempString,1   		"-=-=-=-= Enter your text below this line ");yB 	(void) strcat(TempString, "(don't delete this line) =-=-=-=-\n");     }c,     (void) strcpy(HeaderString, TempString);  (     EditorPosition = InsertionPoint = 0; #if !defined(INEWS_READS_SIG)I5     if ((signature = signatureFile()) != NIL(char)) { ! 	(void) strcpy(TempString, "\n");H& 	(void) strcat(TempString, signature);     } else { 	*TempString = '\0';     }e #elsel     *TempString = '\0';) #endif       PostingMode = POST;;'     if (composePane(title, TempString))p 	 PostingMode = OldPostingMode;        return;u }s     void cancelArticle()  {e/     struct newsgroup *newsgroup = CurrentGroup;g)     art_num current = newsgroup->current;c     char buffer[10000];s     char *bufptr;        if (ComposeActive) {> 	mesgPane(XRN_SERIOUS, "Only one composition pane at a time"); 	return;     } ?     if ((newsgroup->status & NG_UNPOSTABLE) == NG_UNPOSTABLE) {l> 	mesgPane(XRN_SERIOUS, "Can not post articles to this group"); 	return;     }o       getHeader(current);        sizeCompose(10000);	5     /* verify that the user can cancel the article */,%     bufptr = index(Header.from, '@');e     if (bufptr != NIL(char)) {
 	bufptr++; 	(void) strcpy(buffer, bufptr);R2 	if ((bufptr = index(buffer, ' ')) != NIL(char)) { 	    *bufptr = '\0'; 	}8 	if (strncmp(Header.host, buffer, utStrlen(Header.host))A 	   || (strncmp(Header.user, Header.from, utStrlen(Header.user))  ) 	      && strcmp(Header.user, "root"))) {fA 	    mesgPane(XRN_SERIOUS, "Not entitled to cancel the article");p 	    freeHeader(); 	    return;	         }]     }f  ( #if defined(INEWS) || defined(HIDE_PATH):     (void) sprintf(TempString, "Path: %s\n", Header.user); #elseiJ     (void) sprintf(TempString, "Path: %s!%s\n", Header.path, Header.user); #endif\     (void) sprintf(buffer, "From: %s@%s (%s)\n", Header.user, Header.host, Header.fullname);&     (void) strcat(TempString, buffer);E     (void) sprintf(buffer, "Subject: cancel %s\n", Header.messageId); &     (void) strcat(TempString, buffer);%     if (*Header.followupTo != '\0') {w4 	Header.newsgroups = XtNewString(Header.followupTo);     }pB     (void) sprintf(buffer, "Newsgroups: %s\n", Header.newsgroups);&     (void) strcat(TempString, buffer);1     (void) sprintf(buffer, "References: %s %s\n",i* 		   Header.references, Header.messageId);&     (void) strcat(TempString, buffer);  0     (void) strcat(TempString, "Distribution: ");O     if ((Header.distribution != NIL(char)) && (*Header.distribution != '\0')) {r0 	(void) strcat(TempString, Header.distribution);,     } else if (app_resources.distribution) {7 	(void) strcat(TempString, app_resources.distribution);H     } else {) 	(void) strcat(TempString, DISTRIBUTION);      })$     (void) strcat(TempString, "\n");E     (void) sprintf(buffer, "Control: cancel %s\n", Header.messageId);l&     (void) strcat(TempString, buffer); #ifdef GENERATE_EXTRA_FIELDS2     /* stuff to generate Message-ID and Date... */5     (void) sprintf(buffer, "Date: %s\n", gen_date());r&     (void) strcat(TempString, buffer);9     (void) sprintf(buffer, "Message-ID: %s\n", gen_id());;&     (void) strcat(TempString, buffer); #endif       freeHeader();s  /     switch (postArticle(TempString,XRN_NEWS)) {s 	case POST_FAILED:7 	mesgPane(XRN_SERIOUS, "Could not cancel the article");, 	break;s   	case POST_NOTALLOWED:@ 	mesgPane(XRN_SERIOUS, "Posting not allowed from this machine"); 	break;t 	    } 	case POST_OKAY:, 	mesgPane(XRN_INFO, "Canceled the article"); 	break;      })       return;e }a