G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) 0  * ISO 13818-3 MPEG-2 Audio Multichannel Encoder  *6  * $Id: tonal.c 1.8 1996/02/12 07:13:35 rowlands Exp $  *  * $Log: tonal.c $.  * Revision 1.8  1996/02/12 07:13:35  rowlands#  * Release following Munich meeting   *3  * Revision 1.5.2.1  1995/11/06  04:19:12  rowlands %  * Received from Uwe Felderhoff (IRT)   *.  * Revision 1.7  1995/08/14  08:06:37  tenkate0  * ML-LSF added Warner ten Kate 7/8/95 (Philips)@  * II_psycho_one() split into II_psycho_one() for audio data and,  * II_psycho_one_ml() for MultiLingual data.B  * Variables crit_band, cbound and sub_size has been made local to  * these functions. 6  * Tables "cb" and "th" are copied from LSF-directory.$  * ltg has found its ml counterpart.  *.  * Revision 1.6  1995/07/31  07:47:50  tenkate=  * bugs correction (if center==1 in Psycho_One), 25/07/95 WtK   *3  * Revision 1.4.2.1  1995/06/16  03:46:42  rowlands $  * Input from Susanne Ritscher (IRT)  *H  **********************************************************************/  G /********************************************************************** G  *   date   programmers         comment                               * G  * 2/25/91  Douglas Wong        start of version 1.1 records          * G  * 3/06/91  Douglas Wong        rename: setup.h to endef.h            * G  *                              updated I_psycho_one and II_psycho_one* G  * 3/11/91  W. J. Carter        Added Douglas Wong's updates dated    * G  *                              3/9/91 for I_Psycho_One() and for     * G  *                              II_Psycho_One().                      * G  * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         * G  *                              Located and fixed numerous software   * G  *                              bugs and table data errors.           * G  * 6/11/91  Davis Pan           corrected several bugs                * G  *                              based on comments from H. Fuchs       * G  * 01jul91  dpwe (Aware Inc.)   Made pow() args float                 * G  *                              Removed logical bug in I_tonal_label: * G  *                              Sometimes *tone returned == STOP      * G  * 7/10/91  Earle Jennings      no change necessary in port to MsDos  * G  * 11sep91  dpwe@aware.com      Subtracted 90.3dB from II_f_f_t peaks * G  * 10/1/91  Peter W. Farrett    Updated II_Psycho_One(),I_Psycho_One()* #  *				to include comments.		      * G  *11/29/91  Masahiro Iwadare    Bug fix regarding POWERNORM           * G  *                              fixed several other miscellaneous bugs* G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  * 2/12/92  Masahiro Iwadare    Fixed some potential bugs in          * G  *          Davis Pan           subsampling()                         * G  * 2/25/92  Masahiro Iwadare    Fixed some more potential bugs        * D  * 92-11-06 Soren H. Nielsen	Corrected power calculation in I_ and *!  *				II_f_f_t.		              *	 G  ********************************************************************** G  *                                                                    * G  *                                                                    * G  *  MPEG/audio Phase 2 coding/decoding multichannel                   * G  *                                                                    * G  *  7/27/93        Susanne Ritscher,  IRT Munich                      * G  *  8/27/93        Susanne Ritscher, IRT Munich                       * G  *                 Channel-Switching is working                       * G  *  9/1/93         Susanne Ritscher,  IRT Munich                      * G  *                 all channels normalized                            * G  *                                                                    * G  *  9/20/93        channel-switching is only performed at a           * G  *                 certain limit of TC_ALLOC dB, which is included    * G  *                 in encoder.h                                       * G  *                                                                    * G  * 10/18/93        seperated smr and ltmin                            * G  *                                                                    * G  *  Version 1.0                                                       * G  *                                                                    * G  *  07/12/94       Susanne Ritscher,  IRT Munich                      * G  *                 Tel: +49 89 32399 458                              * G  *                 Fax: +49 89 32399 415                              * G  *                                                                    * G  *  Version 1.1                                                       * G  *                                                                    * D  *  02/23/95	   Susanne Ritscher,  IRT Munich                      *G  *                 corrected some bugs                                * G  *                 extension bitstream is working                     * G  *                                                                    * H  **********************************************************************/G #define TONAL_WIDTH 0.1 /* When more than one tonal component is within D                            this width in Bark, the weaker one(s) are(                            eliminated */     #include "common.h"  #include "encoder.h"  H /**********************************************************************/ /*C /*        This module implements the psychoacoustic model I for the D /* MPEG encoder layer II. It uses simplified tonal and noise maskingD /* threshold analysis to generate SMR for the encoder bit allocation /* routine.  /*H /**********************************************************************/  & int read_crit_band(int lay, int freq)  {   int crit_band; 
  FILE *fp;  char r[16], t[80];     strcpy(r, "2cb1");   r[0] = (char) lay + '0';   r[3] = (char) freq + '0';B  if( !(fp = OpenTableFile(r)) ){       /* check boundary values */1     printf("Please check %s boundary table\n",r);      exit(0);  }  fgets(t,80,fp);  sscanf(t,"%d\n",&crit_band);   fclose(fp);  return(crit_band); 	 }           @ void read_cbound(int lay, int freq, int crit_band, int *cbound) 6  /* this function reads in critical band boundaries */ {   int i,j,k; 
  FILE *fp;  char r[16], t[80];     strcpy(r, "2cb1");   r[0] = (char) lay + '0';   r[3] = (char) freq + '0';B  if( !(fp = OpenTableFile(r)) ){       /* check boundary values */1     printf("Please check %s boundary table\n",r);      exit(0);  }B  fgets(t,80,fp);               /* skip input for critical bands */  sscanf(t,"%d\n",&k);   for(i=0;i<crit_band;i++){       fgets(t,80,fp);      sscanf(t,"%d %d\n",&j, &k);      if(i==j) cbound[j] = k; *     else {                     /* error */@        printf("Please check index %d in cbound table %s\n",i,r);        exit(0);      }   }  fclose(fp);	 }           B void read_freq_band(int *sub_size, g_ptr *ltg, int lay, int freq) ?   /* this function reads in frequency bands and bark values  */  {   int i,j, k;  double a,b,c;
  FILE *fp;  char r[16], t[80];     strcpy(r, "2th1");   r[0] = (char) lay + '0';   r[3] = (char) freq + '0';<  if( !(fp = OpenTableFile(r)) ){   /* check freq. values  */<     printf("Please check frequency and cband table %s\n",r);     exit(0);  }A  fgets(t,80,fp);              /* read input for freq. subbands */*  sscanf(t,"%d\n",sub_size); A  *ltg = (g_ptr) mem_alloc (sizeof(g_thres) * (*sub_size), "ltg");OG  (*ltg)[0].line = 0;          /* initialize global masking threshold */0  (*ltg)[0].bark = 0;  (*ltg)[0].hear = 0;D  for(i=1;i<(*sub_size);i++){    /* continue to read freq. subband */A     fgets(t,80,fp);          /* and assign                     */9/     sscanf(t,"%d %d %lf %lf\n",&j, &k, &b, &c);I     if(i == j){s        (*ltg)[j].line = k;        (*ltg)[j].bark = b;        (*ltg)[j].hear = c;     }*(     else {                   /* error */A        printf("Please check index %d in freq-cb table %s\n",i,r);         exit(0);_     }b  }  fclose(fp); }   7 void make_map (int sub_size, mask *power, g_thres *ltg)d; /* this function calculates the global masking threshold */  {n
     int i, j;*    s"     for (i = 1; i < sub_size; i++)/ 	for (j = ltg[i-1].line; j <= ltg[i].line; j++)e 	    power[j].map = i; }v  ! double add_db(double a, double b)r {a  a = pow(10.0,a/10.0);  b = pow(10.0,b/10.0);  return 10 * log10(a+b); }*  B /****************************************************************/ /*6 /*        Fast Fourier transform of the input samples. /*B /****************************************************************/  M void II_f_f_t (double *sample, mask *power) /* this function calculates an */g* 					    /* FFT analysis for the freq.  */* 					    /* domain                      */ {p     int i,j,k,ll,l=0;I     int ip, le, le1;     double t_r, t_i, u_r, u_i;-     static int M, MM1, init = 0, N, NV2, NM1;      double *x_r, *x_i, *energy;P     static int *rev;     static double *w_r, *w_i;   6     x_r = (double *) mem_alloc (sizeof (DFFT), "x_r");6     x_i = (double *) mem_alloc (sizeof (DFFT), "x_i");<     energy = (double *) mem_alloc (sizeof (DFFT), "energy");       if (!init)     { 0 	rev = (int *) mem_alloc (sizeof (IFFT), "rev");2 	w_r = (double *) mem_alloc (sizeof (D10), "w_r");2 	w_i = (double *) mem_alloc (sizeof (D10), "w_i"); 	M = 10;	 	MM1 = 9;a 	N = FFT_SIZE; 	NV2 = FFT_SIZE >> 1;  	NM1 = FFT_SIZE - 1; 	for (ll = 0; ll < M; ll++)a 	{ 	    le = 1 << (M-ll); 	    le1 = le >> 1;  	    w_r[ll] = cos (PI / le1); 	    w_i[ll] = -sin (PI / le1);  	}+ 	for (i = 0; i < FFT_SIZE; rev[i] = l, i++) $ 	    for (j = 0, l = 0; j < 10; j++) 	    { 		k = (i >> j) & 1;M$ 		l |= (k << 9 - j);                 	    }
 	init = 1;     }I  "     for (i = 0; i < FFT_SIZE; i++)     {t        x_r[i] = sample[i];        x_i[i] = energy[i] = 0;     }e /*G     memcpy ((char *) x_r, (char *) sample, sizeof (double) * FFT_SIZE);  */      for (ll = 0; ll < MM1; ll++)     {i 	le = 1 << (M - ll); 	le1 = le >> 1; 	 	u_r = 1; 	 	u_i = 0;a 	for (j = 0; j < le1; j++) 	{  	    for (i = j; i < N; i += le) 	    { 		ip = i + le1;  		t_r = x_r[i] + x_r[ip];  		t_i = x_i[i] + x_i[ip];  		x_r[ip] = x_r[i] - x_r[ip];u 		x_i[ip] = x_i[i] - x_i[ip];  		x_r[i] = t_r;  		x_i[i] = t_i;s 		t_r = x_r[ip];* 		x_r[ip] = x_r[ip] * u_r - x_i[ip] * u_i;& 		x_i[ip] = x_i[ip] * u_r + t_r * u_i; 	    } 	    t_r = u_r; ) 	    u_r = u_r * w_r[ll] - u_i * w_i[ll]; ) 	    u_i = u_i * w_r[ll] + t_r * w_i[ll];t 	}     }a     for (i = 0; i < N; i += 2)     {  	ip = i + 1; 	t_r = x_r[i] + x_r[ip]; 	t_i = x_i[i] + x_i[ip]; 	x_r[ip] = x_r[i] - x_r[ip]; 	x_i[ip] = x_i[i] - x_i[ip]; 	x_r[i] = t_r; 	x_i[i] = t_i;/ 	energy[i] = x_r[i] * x_r[i] + x_i[i] * x_i[i];      }i"     for (i = 0; i < FFT_SIZE; i++) 	if (i < rev[i]) 	{ 	    t_r = energy[i];a  	    energy[i] = energy[rev[i]]; 	    energy[rev[i]] = t_r; 	}"     for (i = 0; i < HAN_SIZE; i++)     { ' 	/* calculate power density spectrum */* 	if (energy[i] < 1E-20)* 	    energy[i] = 1E-20;*> 	/* power calculation corrected with a factor 4, both positive5 	   and negative frequencies exist, 1992-11-06 shn */ 7 	power[i].x = 10 * log10 (energy[i] * 4.0) + POWERNORM;  	power[i].next = STOP; 	power[i].type = FALSE;      }        mem_free ((void **) &x_r);     mem_free ((void **) &x_i);!     mem_free ((void **) &energy);    }s  B /****************************************************************/ /*, /*         Window the incoming audio signal. /*B /****************************************************************/  E void II_hann_win (double *sample)   /* this function calculates a  */ ) 				    /* Hann window for PCM (input) */m* {				    /* samples for a 1024-pt. FFT  */     register int i; "     register double sqrt_8_over_3;     static int init = 0;     static double *window;          if (!init)     { : 	/* calculate window function for the Fourier transform */9 	window = (double *) mem_alloc (sizeof (DFFT), "window"); & 	sqrt_8_over_3 = pow (8.0 / 3.0, 0.5); 	for (i = 0; i < FFT_SIZE; i++)  	{ 	    /* Hann window formula */V 	    window[i] = sqrt_8_over_3 * 0.5 * (1 - cos (2.0*PI*i / (FFT_SIZE-1))) / FFT_SIZE; 	}
 	init = 1;     }   "     for (i = 0; i < FFT_SIZE; i++) 	sample[i] *= window[i]; }   E /*******************************************************************/  /*D /*        This function finds the maximum spectral component in eachC /* subband and return them to the encoder for time-domain threshold9 /* determination.  /*E /*******************************************************************/   - void II_pick_max (mask *power, double *spike)  {   double max;	  int i,j;   K  for(i=0;i<HAN_SIZE;spike[i>>4] = max, i+=16)      /* calculate the      */ K  for(j=0, max = DBMIN;j<16;j++)                    /* maximum spectral   */ K     max = (max>power[i+j].x) ? max : power[i+j].x; /* component in each  */ K }                                                  /* subband from bound */ K                                                    /* 4-16               */   B /****************************************************************/ /*? /*        This function labels the tonal component in the power  /* spectrum. /*B /****************************************************************/  P void II_tonal_label(mask *power, int *tone) /* this function extracts (tonal) */- 					    /* sinusoidals from the spectrum  */o {.B  int i,j, last = LAST, first, run, last_but_one = LAST; /* dpwe */  double max;    *tone = LAST;  for(i=2;i<HAN_SIZE-12;i++){<     if(power[i].x>power[i-1].x && power[i].x>=power[i+1].x){        power[i].type = TONE;        power[i].next = LAST;-        if(last != LAST) power[last].next = i;u        else first = *tone = i;        last = i;     }*  }
  last = LAST;*  first = *tone;d  *tone = LAST;P  while(first != LAST){               /* the conditions for the tonal          */P     if(first<2 || first>499) run = 0;/* otherwise k+/-j will be out of bounds */P     else if(first<62) run = 2;       /* components in layer II, which         */P     else if(first<126) run = 3;      /* are the boundaries for calc.          */P     else if(first<254) run = 6;      /* the tonal components                  */     else run = 12;G     max = power[first].x - 7;        /* after calculation of tonal   */rG     for(j=2;j<=run;j++)              /* components, set to local max */"<        if(max < power[first-j].x || max < power[first+j].x){$           power[first].type = FALSE;           break;        }C     if(power[first].type == TONE){   /* extract tonal components */;        int help=first;%        if(*tone==LAST) *tone = first; E        while((power[help].next!=LAST)&&(power[help].next-first)<=run)t            help=power[help].next;        help=power[help].next;n        power[first].next=help;        if((first-last)<=run){pB           if(last_but_one != LAST) power[last_but_one].next=first;        }C        if(first>1 && first<255){     /* calculate the sum of the */zC           double tmp;                /* powers of the components */e;           tmp = add_db(power[first-1].x, power[first+1].x);,7           power[first].x = add_db(power[first].x, tmp);)        }        for(j=1;j<=run;j++){ 6           power[first-j].x = power[first+j].x = DBMIN;;           power[first-j].next = power[first+j].next = STOP;a<           power[first-j].type = power[first+j].type = FALSE;        }        last_but_one=last;u        last = first;!        first = power[first].next;      }o
     else {        int ll;>        if(last == LAST); /* *tone = power[first].next; dpwe */1        else power[last].next = power[first].next;l        ll = first;!        first = power[first].next;n        power[ll].next = STOP;      }t  } }f  B /****************************************************************/ /*: /*        This function groups all the remaining non-tonal? /* spectral lines into critical band where they are replaced by  /* one single line.{ /*B /****************************************************************/         S void noise_label(int crit_band, int *cbound, mask *power, int *noise, g_thres *ltg)t {b  int i,j, centre, last = LAST;  double index, weight, sum;eD                               /* calculate the remaining spectral */D  for(i=0;i<crit_band-1;i++){  /* lines for non-tonal components   */A      for(j=cbound[i],weight = 0.0,sum = DBMIN;j<cbound[i+1];j++){e"         if(power[j].type != TONE){#            if(power[j].x != DBMIN){g+               sum = add_db(power[j].x,sum);*P               weight += pow(10.0, power[j].x/10.0) * (ltg[power[j].map].bark-i);!               power[j].x = DBMIN;*            }F         }   /* check to see if the spectral line is low dB, and if  */F      }      /* so replace the center of the critical band, which is */F             /* the center freq. of the noise component              */;      if(sum <= DBMIN)  centre = (cbound[i+1]+cbound[i]) /2;,      else { *         index = weight/pow(10.0,sum/10.0);O         centre = cbound[i] + (int) (index * (double) (cbound[i+1]-cbound[i]) ); @      }     /* locate next non-tonal component until finished; */@            /* add to list of non-tonal components             */-      if(power[centre].type == TONE) centre++;"&      if(last == LAST) *noise = centre;      else {c"         power[centre].next = LAST;"         power[last].next = centre;      }      power[centre].x = sum;z(      power[centre].type = NOISE;              last = centre;=
  }         }   B /****************************************************************/ /*= /*        This function reduces the number of noise and tonal , /* component for further threshold analysis. /*B /****************************************************************/  C void subsampling (mask *power, g_thres *ltg, int *tone, int *noise)  {}     int i, old;           i = *tone;     old = STOP;)(     /* calculate tonal components for */     while (i != LAST)      { % 	/* reduction of spectral lines    */ ) 	if (power[i].x < ltg[power[i].map].hear)/ 	{ 	    power[i].type = FALSE;) 	    power[i].x = DBMIN; 	    if (old == STOP)  		*tone = power[i].next;	 	    elsej" 		power[old].next = power[i].next; 	} 	elsel
 	    old = i;p 	i = power[i].next;      }+     i = *noise;      old = STOP;],     /* calculate non-tonal components for */     while (i != LAST)	     {=) 	/* reduction of spectral lines        */ 0         if (power[i].x < ltg[power[i].map].hear) 	{ 	    power[i].type = FALSE;  	    power[i].x = DBMIN; 	    if (old == STOP)] 		*noise = power[i].next;i	 	    elser" 		power[old].next = power[i].next; 	} 	else=
 	    old = i;  	i = power[i].next;      }r     i = *tone;     old = STOP;i     while (i != LAST)=     {  	/* if more than one */i 	if (power[i].next == LAST);. 	    break;             /* tonal component  */D 	if (ltg[power[power[i].next].map].bark -     /* is less than .5  */* 	    ltg[power[i].map].bark < TONAL_WIDTH) 	{ 	    /* bark, take the   */ - 	    if (power[power[i].next].x > power[i].x)  	    { 		/* maximum          */ 		if (old == STOP) 		    *tone = power[i].next; 		else& 		    power[old].next = power[i].next; 		power[i].type = FALSE; 		power[i].x = DBMIN;  	    }	 	    elsee 	    {$ 		power[power[i].next].type = FALSE;! 		power[power[i].next].x = DBMIN;P, 		power[i].next = power[power[i].next].next; 	    } 	} 	else 
 	    old = i;r 	i = power[i].next;      }_ }e    O /* ----------------------------------------------------------------------------*K The masking function parameters are here set according to the parameters iniO the IRT real time implementation. The constant definitions are for convenience.* 1993-07-23 shnO ---------------------------------------------------------------------------- */   J #define AV_TONAL_K    -9.0 /* Masking index, tonal, constant part  [dB] */J #define AV_NOISE_K    -5.0 /* Masking index, noisy, constant part  [dB] */O #define AV_TONAL_DZ   -0.3 /* Masking index, tonal, CBR dependence [dB/Bark] */fO #define AV_NOISE_DZ   -0.3 /* Masking index, noisy, CBR dependence [dB/Bark] */T  S #define LOW_LIM_1     -1.0 /* 1st lower slope from 0         to LOW_LIM_1 [Bark] */ S #define LOW_LIM_2     -3.0 /* 2nd lower slope from LOW_LIM_1 to LOW_LIM_2 [Bark] */   I #define LOW_DZ_K_1     6.0 /* 1st lower slope, constant part [dB/Bark] */=O #define LOW_DZ_SPL_1   0.4 /* 1st lower slope, SPL dependence [dB/(Bark*dB)] */*I #define LOW_DZ_MIN_1  17.0 /* 1st lower slope, minimum value [dB/Bark] */i: #define LOW_DZ_2      17.0 /* 2nd lower slope [dB/Bark] */  Q #define UP_LIM_1       1.0 /* 1st upper slope from 0        to UP_LIM_1 [Bark] */*Q #define UP_LIM_2       8.0 /* 2nd upper slope from UP_LIM_1 to UP_LIM_2 [Bark] */(  I #define UP_DZ_1      -18.0 /* 1st upper slope, constant part [dB/Bark] */SO #define UP_SPL_1       0.0 /* 1st upper slope, SPL dependence [dB/(Bark*dB)] */II #define UP_DZ_2      -17.0 /* 2nd upper slope, constant part [dB/Bark] */wO #define UP_SPL_2      -0.1 /* 2nd upper slope, SPL dependence [dB/(Bark*dB)] */   > #define H_THR_OFFSET -12.0 /* Hearing threshold offset [dB] */Y #define H_THR_OS_BR    0 /*96*/   /* Minimum datarate for offset, [kbit/s per channel] */*  I #define MASK_ADD       2.0 /* Addition of maskers	                [dB] */eO #define QUIET_ADD      3.0 /* Addition of masker and threshold in quiet [dB] */*  A /***************************************************************** *e> *        This function calculates the individual threshold and< * sum with the quiet threshold to find the global threshold. *rA ****************************************************************/L  \ void threshold(int sub_size, mask *power, g_thres *ltg, int *tone, int *noise, int bit_rate) {    int k, t;.   double z, dz, spl, vf, tmps;  5   for (k=1; k<sub_size; k++) /* Target frequencies */u   {      ltg[k].x = DBMIN; E     t = *tone;          /* calculate individual masking threshold  */oE     while(t != LAST)    /* for tonal components, t,  to find LTG   */t     {lF       z   = ltg[power[t].map].bark; /* critical band rate of masker */?       dz  = ltg[k].bark - z ;       /* distance of bark value*/oH       spl = power[t].x;             /* sound pressure level of masker */  ,       if (dz >= LOW_LIM_2 && dz <  UP_LIM_2)       {i2         tmps = spl + AV_TONAL_K + AV_TONAL_DZ * z;  7         /* masking function for lower & upper slopes */s*         if (LOW_LIM_2<=dz && dz<LOW_LIM_1)=           if (LOW_DZ_SPL_1 * spl + LOW_DZ_K_1 > LOW_DZ_MIN_1)e/             vf = LOW_DZ_2 * (dz - LOW_LIM_1) + ]>                 (LOW_DZ_SPL_1 * spl + LOW_DZ_K_1) * LOW_LIM_1;           elseH             vf = LOW_DZ_2 * (dz - LOW_LIM_1) + LOW_DZ_MIN_1 * LOW_LIM_1;'         else if (LOW_LIM_1<=dz && dz<0) =           if (LOW_DZ_SPL_1 * spl + LOW_DZ_K_1 > LOW_DZ_MIN_1)e8             vf = (LOW_DZ_SPL_1 * spl + LOW_DZ_K_1) * dz;           else#             vf = LOW_DZ_MIN_1 * dz; &         else if (0<=dz && dz<UP_LIM_1)           vf = (UP_DZ_1 * dz);-         else if (UP_LIM_1<=dz && dz<UP_LIM_2)x=           vf = (dz - UP_LIM_1) * (UP_DZ_2 - UP_SPL_2 * spl) +c"                UP_DZ_1 * UP_LIM_1;         tmps += vf;         9         ltg[k].x = non_lin_add(ltg[k].x, tmps, MASK_ADD);f       },       t = power[t].next;     } /* while */x  E     t = *noise;        /* calculate individual masking threshold   */ E     while(t != LAST)   /* for non-tonal components, t, to find LTG */[     {]F       z   = ltg[power[t].map].bark; /* critical band rate of masker */?       dz  = ltg[k].bark - z ;       /* distance of bark value*/ H       spl = power[t].x;             /* sound pressure level of masker */  ,       if (dz >= LOW_LIM_2 && dz <  UP_LIM_2)       {o2         tmps = spl + AV_NOISE_K + AV_NOISE_DZ * z;  7         /* masking function for lower & upper slopes */=*         if (LOW_LIM_2<=dz && dz<LOW_LIM_1)=           if (LOW_DZ_SPL_1 * spl + LOW_DZ_K_1 > LOW_DZ_MIN_1)*/             vf = LOW_DZ_2 * (dz - LOW_LIM_1) + s>                 (LOW_DZ_SPL_1 * spl + LOW_DZ_K_1) * LOW_LIM_1;           elseH             vf = LOW_DZ_2 * (dz - LOW_LIM_1) + LOW_DZ_MIN_1 * LOW_LIM_1;'         else if (LOW_LIM_1<=dz && dz<0)*=           if (LOW_DZ_SPL_1 * spl + LOW_DZ_K_1 > LOW_DZ_MIN_1),8             vf = (LOW_DZ_SPL_1 * spl + LOW_DZ_K_1) * dz;           else#             vf = LOW_DZ_MIN_1 * dz; &         else if (0<=dz && dz<UP_LIM_1)           vf = (UP_DZ_1 * dz);-         else if (UP_LIM_1<=dz && dz<UP_LIM_2)c=           vf = (dz - UP_LIM_1) * (UP_DZ_2 - UP_SPL_2 * spl) +<"                UP_DZ_1 * UP_LIM_1;        tmps += vf;        8        ltg[k].x = non_lin_add(ltg[k].x, tmps, MASK_ADD);      }       t = power[t].next;     }        if (bit_rate < H_THR_OS_BR)o?       ltg[k].x = non_lin_add(ltg[k].hear, ltg[k].x, QUIET_ADD);      elseN       ltg[k].x = non_lin_add(ltg[k].hear + H_THR_OFFSET, ltg[k].x, QUIET_ADD);  s
   } /* for */e   fflush(stderr);l }n      A /* --------------------------------------------------------------  non_lin_add ( A flexible addition function for levels.# Input: a,b: the levels to be added. 6 	 c: the number of dB increase when a and b are equal.- Common values for c are 3.01 (power addition)1" 		    and 6.02 (voltage addition). 10.0/(10*log10(2)) = 3.3219n* Function added 1993-04-14 Soren H. NielsenA -------------------------------------------------------------- */=0 double non_lin_add(double a, double b, double c) {n   c *= 3.3219;)   a = pow(10.0, a/c); b = pow(10.0, b/c);    return(c*log10(a+b));n };    B /****************************************************************/ /*? /*        This function finds the minimum masking threshold and*# /* return the value to the encoder.* /*B /****************************************************************/  L void II_minimum_mask(int sub_size, g_thres *ltg, double *ltmin, int sblimit) {*  double min;	  int i,j;*  *    j=1;   for(i=0;i<sblimit;i++)*L     if(j>=sub_size-1)                   /* check subband limit, and       */L        ltmin[i] = ltg[sub_size-1].hear; /* calculate the minimum masking  */L     else {                              /* level of LTMIN for each subband*/        min = ltg[j].x;2        while(ltg[j].line>>4 == i && j < sub_size){(        if(min>ltg[j].x)  min = ltg[j].x;        j++;[     };     ltmin[i] = min;[  } }x  C /*****************************************************************/  /*= /*        This procedure is called in musicin to pick out thel+ /* smaller of the scalefactor or threshold.  /*C /*****************************************************************/<  a void II_smr (double *ltmin, double *smr, double *spike, double *scale, int sblimit, int l, int m)  {P     int i,j;     double max;  		   s     for (i = l; i < m; i++)[     {; 	/* determine the signal   */iI 	max = 20 * log10 (scale[i] * 32768) - 10;   /* level for each subband */! 	if (spike[i] > max)7 	    max = spike[i];			    /* for the maximum scale  */b4 	max -= ltmin[i];			    /* factors                */ 	smr[i] = max;     }b }          B /****************************************************************/ /*= /*        This procedure calls all the necessary functions toe( /* complete the psychoacoustic analysis. /*B /****************************************************************/  + void II_Psycho_One (double (*buffer)[1152],A 		    double (*scale)[32], 		    double (*ltmin)[32], 		    frame_params *fr_ps, 		    double (*smr)[32], 		    double (*spiki)[32], 		    int aiff)[ {e      layer *info = fr_ps->header;!     int   stereo = fr_ps->stereo;e&     int   stereomc = fr_ps->stereomc;	(     int   stereoaug = fr_ps->stereoaug;	#     int   sblimit = fr_ps->sblimit;c     int k,i, tone=0, noise=0;c     static char init = 0;i     static int 	off[12] = {256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256}; /* max 7 MC channels + 5 compatible channels */-     double *sample;-     DSBL *spike;     static D1408 *fft_buf;     static mask_ptr power;     static g_ptr ltg;/     int j, l, z, q;      static int crit_band;i     static int *cbound;/     static int sub_size;     <     sample = (double *) mem_alloc (sizeof (DFFT), "sample");:     spike = (DSBL *) mem_alloc (sizeof (D12SBL), "spike");    ]     if (!init)     {_& 	/* bands, bark values, and mapping */. 	/* changed 5 to 7 for matricing 8/10/93,SR */4 	/* changed 7 to 12 for aug matricing 8/11/96,FdB */G 	fft_buf = (D1408 *) mem_alloc ((long) sizeof (D1408) * 12, "fft_buf");aF     	power = (mask_ptr) mem_alloc (sizeof (mask) * HAN_SIZE, "power");4 	/* call functions for critical boundaries, freq. */B 	crit_band = read_crit_band (info->lay, info->sampling_frequency);A 	cbound = (int *) mem_alloc (sizeof (int) * crit_band, "cbound");1F 	read_cbound (info->lay, info->sampling_frequency, crit_band, cbound);G 	read_freq_band (&sub_size, &ltg, info->lay, info->sampling_frequency); ! 	make_map (sub_size, power, ltg);p 	for (i = 0; i < 1408; i++)B4 	    fft_buf[0][i] = fft_buf[1][i] = fft_buf[2][i] =4 	    fft_buf[3][i] = fft_buf[4][i] = fft_buf[5][i] =4 	    fft_buf[6][i] = fft_buf[7][i] = fft_buf[8][i] =9 	    fft_buf[9][i] = fft_buf[10][i] = fft_buf[11][i] = 0;p
 	init = 1;     }B  *     if (aiff != 1)     {- 	j = 0;e 	l = 2;e     }f     else	     {      	j = 0;Bc 	if (stereoaug == 2) l = 12; /*fr_ps->stereo + fr_ps->stereomc + fr_ps->stereoaug + 5 compatible */0P 	else                l =  7; /*fr_ps->stereo + fr_ps->stereomc + 2 compatible */     }        for (k = j; k < l; k++)      {*"         for (i = 0; i < 1152; i++)E 	    fft_buf[k][(i + off[k]) % 1408] = (double) buffer[k][i] / SCALE;e 	for (i = 0; i < FFT_SIZE; i++) 8 	    sample[i] = fft_buf[k][(i + 1216 + off[k]) % 1408];      	off[k] += 1152; 	off[k] %= 1408;/ 	/* call functions for windowing PCM samples,*/iF 	II_hann_win (sample);		/* location of spectral components in each  */ 	for (i = 0; i < HAN_SIZE; i++)z5 	    power[i].x = DBMIN;		/* subband with labeling */ 6 	II_f_f_t (sample, power);	/* locate remaining non- */        n* 	if (fr_ps->header->center == 3 && k == 2) 	{$ 	    /* set center to 0, 9/2/93,SR*/& 	    /* add to Left and Right ? WtK */% 	    for (z = 184; z < HAN_SIZE; z++)m1 		power[z].x = -103.670;    /* DBMIN + 96.330; */  	}: 	II_pick_max (power, spike[k]); /* tonal sinusoidals,   */   #ifdef PRINTOUT  	if (verbosity >= 3) 	{  	    printf ("\nChannel %d", k);< 	    printf ("\nSignal value per subband, from the FFT:\n");" 	    for (i = 0; i < sblimit; i++)% 		printf ("%5.1f dB  ", spike[k][i]);e; 	    printf ("\nMax. signal peak per subband, SCF SPL:\n");_N 	    for (i = 0; i < sblimit; i++)   /* from [II_smr] determine the SCF SPL */: 		printf ("%5.1f dB  ", 20 * log10(scale[k][i] * 32768));  	    fflush (stdout);K 	} #endif  [ 	II_tonal_label (power, &tone);                /* reduce noise & tonal components , find */ 6 	noise_label (crit_band, cbound, power, &noise, ltg);    #ifdef PRINTOUT+ 	if (verbosity >= 3) 	{> 	    printf ("\nMaskers before sorting, FFT based levels:\n"); 	    for (i = 0; i < 511; i++) 	    {6 		if ((power[i].type == NOISE) && (power[i].x > -200))1 		    printf ("N:%3u %5.1f dB  ", i, power[i].x);_5 		if ((power[i].type == TONE) && (power[i].x > -200))*1 		    printf ("T:%3u %5.1f dB  ", i, power[i].x);Z 	    }5 	    printf ("tone = %d noise = %d \n", tone, noise);= 	    fflush (stdout);t 	} #endif  I 	subsampling (power, ltg, &tone, &noise);      /* global & minimal     */e      #ifdef PRINTOUTn 	if (verbosity >= 3) 	{+ 	    printf ("\nMaskers after sorting:\n");a 	    for (i = 0; i < 511; i++) 	    {6 		if ((power[i].type == NOISE) && (power[i].x > -200))1 		    printf ("N:%3u %5.1f dB  ", i, power[i].x); 5 		if ((power[i].type == TONE) && (power[i].x > -200)) 1 		    printf ("T:%3u %5.1f dB  ", i, power[i].x);  	    } 	    fflush (stdout);  	} #endif  0 	threshold (sub_size, power, ltg, &tone, &noise, 		   bitrate[info->lay-1][info->bitrate_index] / (stereo+stereomc+stereoaug)); /*to-mask ratio*//* 21/03/1995 JMZ BUG ???!!!???*/O8 	II_minimum_mask (sub_size, ltg, &ltmin[k][0], sblimit);      #ifdef PRINTOUT  	if (verbosity >= 3) 	{/ 	    printf ("\nMinimum masking threshold:\n");_" 	    for (i = 0; i < sblimit; i++)% 		printf ("%5.1f dB  ", ltmin[k][i]);I 	    fflush (stdout);  	} #endif   	for (i = 0; i < SBLIMIT; i++) 	    spiki[k][i] = spike[k][i];_      _ 	i = 0;,
 	q = sblimit;f> 	II_smr (ltmin[k], smr[k], spike[k], scale[k], sblimit, i, q);     }      !     mem_free ((void **) &sample); !     mem_free ((void **) &spike); f } /*II_Psycho_One*/    void II_Psycho_One_ml (  	double (*buffer)[1152], 	double (*scale)[32],* 	double (*ltmin)[32],s 	frame_params *fr_ps,U 	double (*smr)[32],  	double (*spiki)[32] )  {       layer *info = fr_ps->header;'     int	n_ml_ch   = info->multiling_ch;e'     int sblimit_ml = fr_ps->sblimit_ml;H     int k,i, tone=0, noise=0;n     static char init = 0;[V     static int off[7] = {256, 256, 256, 256, 256, 256, 256};   /* max 7 ML channels */     double *sample;      DSBL *spike;     static D1408 *fft_buf;     static mask_ptr power;     static g_ptr ltg_ml;     static int crit_band_ml;     static int *cbound_ml;     static int sub_size_ml;h     int j, l, z, q;     <     sample = (double *) mem_alloc (sizeof (DFFT), "sample");9     spike = (DSBL *) mem_alloc (sizeof (D7SBL), "spike");t    d     if (!init)     {0& 	/* bands, bark values, and mapping */F 	fft_buf = (D1408 *) mem_alloc ((long) sizeof (D1408) * 7, "fft_buf");B 	power = (mask_ptr) mem_alloc (sizeof (mask) * HAN_SIZE, "power");4 	/* call functions for critical boundaries, freq. */ 	if (info->multiling_fs == 0)n 	{I 	    crit_band_ml = read_crit_band (info->lay, info->sampling_frequency);*N 	    cbound_ml = (int *) mem_alloc (sizeof (int) * crit_band_ml, "cbound_ml");P 	    read_cbound (info->lay, info->sampling_frequency, crit_band_ml, cbound_ml);Q 	    read_freq_band (&sub_size_ml, &ltg_ml, info->lay, info->sampling_frequency);n: 	    /* values are equal to those for the mc audio data */ 	} 	elsem 	{M 	    crit_band_ml = read_crit_band (info->lay, info->sampling_frequency + 4); N 	    cbound_ml = (int *) mem_alloc (sizeof (int) * crit_band_ml, "cbound_ml");T 	    read_cbound (info->lay, info->sampling_frequency + 4, crit_band_ml, cbound_ml);U 	    read_freq_band (&sub_size_ml, &ltg_ml, info->lay, info->sampling_frequency + 4);[ 	}' 	make_map (sub_size_ml, power, ltg_ml);  	for (i = 0; i < 1408; i++) 9 	    fft_buf[0][i] = fft_buf[1][i] = fft_buf[2][i] =     *G 	    fft_buf[3][i] = fft_buf[4][i] = fft_buf[5][i] = fft_buf[6][i] = 0; 
 	init = 1;     }         if (n_ml_ch > 0) d     {  	for (k = 0; k < n_ml_ch; k++) 	{ * 	    for (i = 0; i < 1152; i++) A 		fft_buf[k][(i+off[k]) % 1408]= (double) buffer[7+k][i] / SCALE;l# 	    for (i = 0; i < FFT_SIZE; i++) 1 		sample[i] = fft_buf[k][(i+1216+off[k]) % 1408];l      	    off[k] += 1152; 	    off[k] %= 1408;  3 	    /* call functions for windowing PCM samples,*/eJ 	    II_hann_win (sample);		/* location of spectral components in each  */# 	    for (i = 0; i < HAN_SIZE; i++) 2 		power[i].x = DBMIN;		/* subband with labeling */; 	    II_f_f_t (sample, power);		/* locate remaining non- */* 	    *# 	    II_pick_max (power, spike[k]);   						/* tonal sinusoidals,   */ 	cP 	    II_tonal_label (power, &tone);	/* reduce noise & tonal components , find */C 	    noise_label (crit_band_ml, cbound_ml, power, &noise, ltg_ml); o 	eK 	    subsampling (power, ltg_ml, &tone, &noise);	/* global & minimal     */[ 	    	: 	    threshold (sub_size_ml, power, ltg_ml, &tone, &noise,L 		       bitrate[info->lay-1][info->bitrate_index] / 2);	/* to-mask ratio */# 									/* threshold, and sgnl- */ N 	    /* fprintf(stderr,  "sblimit_ml : %d\n",  sblimit_ml); fflush(stderr); */G 	    II_minimum_mask (sub_size_ml, ltg_ml, &ltmin[7+k][0], sblimit_ml);t 	    a" 	    for (i = 0; i < SBLIMIT; i++) 		spiki[7+k][i] = spike[k][i]; 	  	    i = 0;  	    q = sblimit_ml;K 	    II_smr (ltmin[7+k], smr[7+k], spike[k], scale[7+k], sblimit_ml, i, q);p 	; 	} /* k-loop*/     } /*n_ml_ch>0*/t  !     mem_free ((void **) &sample);l!     mem_free ((void **) &spike); t } /* II_psycho_One_ml */  H /**********************************************************************/ /*C /*        This module implements the psychoacoustic model I for theeC /* MPEG encoder layer I. It uses simplified tonal and noise masking D /* threshold analysis to generate SMR for the encoder bit allocation /* routine.  /*H /**********************************************************************/  B /****************************************************************/ /*6 /*        Fast Fourier transform of the input samples. /*B /****************************************************************/  J void I_f_f_t (double *sample, mask *power)  /* this function calculates */' 					    /* an FFT analysis for the  */a' 					    /* freq. domain             */b {d  int i,j,k,ll,l=0;  int ip, le, le1;n  double t_r, t_i, u_r, u_i;e*  static int M, MM1, init = 0, N, NV2, NM1;  double *x_r, *x_i, *energy;  static int *rev;=  static double *w_r, *w_i;  2  x_r = (double *) mem_alloc(sizeof(DFFT2), "x_r");2  x_i = (double *) mem_alloc(sizeof(DFFT2), "x_i");8  energy = (double *) mem_alloc(sizeof(DFFT2), "energy");;  for(i=0;i<FFT_SIZE/2;i++) x_r[i] = x_i[i] = energy[i] = 0;   if(!init){=2     rev = (int *) mem_alloc(sizeof(IFFT2), "rev");2     w_r = (double *) mem_alloc(sizeof(D9), "w_r");2     w_i = (double *) mem_alloc(sizeof(D9), "w_i");
     M = 9;     MM1 = 8;     N = FFT_SIZE/2;t     NV2 = FFT_SIZE/2 >> 1;     NM1 = FFT_SIZE/2 - 1;      for(ll=0;ll<M;ll++){        le = 1 << (M-ll);        le1 = le >> 1;o        w_r[ll] = cos(PI/le1);r        w_i[ll] = -sin(PI/le1);     }S>     for(i=0;i<FFT_SIZE/2;rev[i] = l,i++) for(j=0,l=0;j<9;j++){        k=(i>>j) & 1;%        l |= (k<<8-j);                t     }r
     init = 1;s  }E  memcpy( (char *) x_r, (char *) sample, sizeof(double) * FFT_SIZE/2);a  for(ll=0;ll<MM1;ll++){H     le = 1 << (M-ll);w     le1 = le >> 1;     u_r = 1;     u_i = 0;     for(j=0;j<le1;j++){;        for(i=j;i<N;i+=le){           ip = i + le1;e!           t_r = x_r[i] + x_r[ip]; !           t_i = x_i[i] + x_i[ip]; %           x_r[ip] = x_r[i] - x_r[ip]; %           x_i[ip] = x_i[i] - x_i[ip];            x_r[i] = t_r;            x_i[i] = t_i;            t_r = x_r[ip];2           x_r[ip] = x_r[ip] * u_r - x_i[ip] * u_i;.           x_i[ip] = x_i[ip] * u_r + t_r * u_i;        }        t_r = u_r; +        u_r = u_r * w_r[ll] - u_i * w_i[ll];"+        u_i = u_i * w_r[ll] + t_r * w_i[ll];n     }.  }  for(i=0;i<N;i+=2){      ip = i + 1;a     t_r = x_r[i] + x_r[ip];C     t_i = x_i[i] + x_i[ip];;     x_r[ip] = x_r[i] - x_r[ip];s     x_i[ip] = x_i[i] - x_i[ip];r     x_r[i] = t_r;      x_i[i] = t_i;[2     energy[i] = x_r[i] * x_r[i] + x_i[i] * x_i[i];  }(  for(i=0;i<FFT_SIZE/2;i++) if(i<rev[i]){     t_r = energy[i];     energy[i] = energy[rev[i]];e     energy[rev[i]] = t_r;p  }F  for(i=0;i<HAN_SIZE/2;i++){                     /* calculate power  */F     if(energy[i] < 1E-20) energy[i] = 1E-20;    /* density spectrum */D        /* power calculation corrected with a factor 4, both positive4 	  and negative frequencies exist, 1992-11-06 shn */8        power[i].x = 10 * log10(energy[i]*4) + POWERNORM;        power[i].next = STOP;        power[i].type = FALSE;   }     mem_free ((void **) &x_r);     mem_free ((void **) &x_i);!     mem_free ((void **) &energy);a }i  B /****************************************************************/ /*, /*         Window the incoming audio signal. /*B /****************************************************************/  E void I_hann_win (double *sample)    /* this function calculates a  */r) 				    /* Hann window for PCM (input) */ * {				    /* samples for a 512-pt. FFT   */  register int i;  register double sqrt_8_over_3;w  static int init = 0;   static double *window;e  F  if(!init){  /* calculate window function for the Fourier transform */=     window = (double *) mem_alloc (sizeof (DFFT2), "window");/&     sqrt_8_over_3 = pow(8.0/3.0, 0.5);     for(i=0;i<FFT_SIZE/2;i++){       /* Hann window formula */tP       window[i]=sqrt_8_over_3*0.5*(1-cos(2.0*PI*i/(FFT_SIZE/2-1)))/(FFT_SIZE/2);     }e
     init = 1;   }2  for(i=0;i<FFT_SIZE/2;i++) sample[i] *= window[i]; }t  E /*******************************************************************/M /*D /*        This function finds the maximum spectral component in eachC /* subband and return them to the encoder for time-domain threshold  /* determination._ /*E /*******************************************************************/h  , void I_pick_max (mask *power, double *spike) {f  double max;	  int i,j;l  7  /* calculate the spectral component in each subband */d.  for(i=0;i<HAN_SIZE/2;spike[i>>3] = max, i+=8)P     for(j=0, max = DBMIN;j<8;j++) max = (max>power[i+j].x) ? max : power[i+j].x; }   B /****************************************************************/ /*? /*        This function labels the tonal component in the power2 /* spectrum. /*B /****************************************************************/  J void I_tonal_label (mask *power, int *tone) /* this function extracts   */' 					    /* (tonal) sinusoidals from */i' 					    /* the spectrum             */l { "  int i,j, last = LAST, first, run;  double max;  int last_but_one=LAST;     *tone = LAST;  for(i=2;i<HAN_SIZE/2-6;i++){f<     if(power[i].x>power[i-1].x && power[i].x>=power[i+1].x){        power[i].type = TONE;        power[i].next = LAST;-        if(last != LAST) power[last].next = i;r        else first = *tone = i;        last = i;     }"  }
  last = LAST;o  first = *tone;o  *tone = LAST;H  while(first != LAST){                /* conditions for the tonal     */P     if(first<2 || first>249) run = 0; /* otherwise k+/-j will be out of bounds*/I     else if(first<62) run = 2;        /* components in layer II, which */sJ     else if(first<126) run = 3;       /* are the boundaries for calc.   */I     else run = 6;                     /* the tonal components          */u     max = power[first].x - 7;tJ     for(j=2;j<=run;j++)  /* after calc. of tonal components, set to loc.*/J        if(max < power[first-j].x || max < power[first+j].x){   /* max   */$           power[first].type = FALSE;           break;        }D     if(power[first].type == TONE){    /* extract tonal components */        int help=first;'        if(*tone == LAST) *tone = first;[E        while((power[help].next!=LAST)&&(power[help].next-first)<=run)i            help=power[help].next;        help=power[help].next;         power[first].next=help;        if((first-last)<=run){[B           if(last_but_one != LAST) power[last_but_one].next=first;        }C        if(first>1 && first<255){     /* calculate the sum of the */[C           double tmp;                /* powers of the components */ ;           tmp = add_db(power[first-1].x, power[first+1].x);f7           power[first].x = add_db(power[first].x, tmp);=        }        for(j=1;j<=run;j++){n6           power[first-j].x = power[first+j].x = DBMIN;P           power[first-j].next = power[first+j].next = STOP; /*dpwe: 2nd was .x*/<           power[first-j].type = power[first+j].type = FALSE;        }        last_but_one=last;n        last = first;!        first = power[first].next;      }	
     else {        int ll;?        if(last == LAST) ; /* *tone = power[first].next; dpwe */o1        else power[last].next = power[first].next;         ll = first;!        first = power[first].next;i        power[ll].next = STOP;e     }l  } }                                                           B /****************************************************************/ /*? /*        This function finds the minimum masking threshold and*# /* return the value to the encoder._ /*B /****************************************************************/  > void I_minimum_mask(int sub_size, g_thres *ltg, double *ltmin) {   double min;	  int i,j;p    j=1;i  for(i=0;i<SBLIMIT;i++) L     if(j>=sub_size-1)                   /* check subband limit, and       */L        ltmin[i] = ltg[sub_size-1].hear; /* calculate the minimum masking  */L     else {                              /* level of LTMIN for each subband*/        min = ltg[j].x;2        while(ltg[j].line>>3 == i && j < sub_size){,           if (min>ltg[j].x)  min = ltg[j].x;           j++;        }        ltmin[i] = min;     }o }   C /*****************************************************************/y /*= /*        This procedure is called in musicin to pick out the*+ /* smaller of the scalefactor or threshold.* /*C /*****************************************************************/*  8 void I_smr (double *ltmin, double *spike, double *scale) {o	  int i,j;   double max;                 J  for(i=0;i<SBLIMIT;i++){                      /* determine the signal   */J     max = 20 * log10(scale[i] * 32768) - 10;  /* level for each subband */J     if(spike[i]>max) max = spike[i];          /* for the scalefactor    */     max -= ltmin[i];     ltmin[i] = max;i  } }u         B /****************************************************************/ /*= /*        This procedure calls all the necessary functions to*( /* complete the psychoacoustic analysis. /*B /****************************************************************/   void
 I_Psycho_One(e 	double (*buffer)[1152], 	double (*scale)[32],] 	double (*ltmin)[32],( 	frame_params *fr_ps ) {   int stereo = fr_ps->stereo;   the_layer info = fr_ps->header;  int k,i, tone=0, noise=0;  static char init = 0;  static int off[2] = {256,256};   double *sample;
  DSBL *spike;t  static D640 *fft_buf;  static mask_ptr power;2  static g_ptr ltg;  static int crit_band;  static int *cbound;  static int sub_size;   8  sample = (double *) mem_alloc(sizeof(DFFT2), "sample");4  spike = (DSBL *) mem_alloc(sizeof(D2SBL), "spike");?             /* call functions for critical boundaries, freq. */ >  if(!init){ /* bands, bark values, and mapping              */>     fft_buf = (D640 *) mem_alloc(sizeof(D640) * 2, "fft_buf");E     power = (mask_ptr) mem_alloc(sizeof(mask) * HAN_SIZE/2, "power"); C     crit_band = read_crit_band(info->lay,info->sampling_frequency); B     cbound = (int *) mem_alloc(sizeof(int) * crit_band, "cbound");E     read_cbound(info->lay,info->sampling_frequency,crit_band,cbound); F     read_freq_band(&sub_size,&ltg,info->lay,info->sampling_frequency);!     make_map(sub_size,power,ltg);;9     for(i=0;i<640;i++) fft_buf[0][i] = fft_buf[1][i] = 0; 
     init = 1;_  }?  for(k=0;k<stereo;k++){    /* check PCM input for a block of */u?     for(i=0;i<384;i++)     /* 384 samples for a 512-pt. FFT  */*?        fft_buf[k][(i+off[k])%640]= (double) buffer[k][i]/SCALE;      for(i=0;i<FFT_SIZE/2;i++) 2        sample[i] = fft_buf[k][(i+448+off[k])%640];     off[k] += 384;     off[k] %= 640;I                         /* call functions for windowing PCM samples,   */ I     I_hann_win(sample); /* location of spectral components in each     */nI     for(i=0;i<HAN_SIZE/2;i++) power[i].x = DBMIN;   /* subband with    */ I     I_f_f_t(sample, power);              /* labeling, locate remaining */ I     I_pick_max(power, &spike[k][0]);     /* non-tonal sinusoidals,     *//I     I_tonal_label(power, &tone);         /* reduce noise & tonal com., */vZ     noise_label(crit_band,cbound,power, &noise, ltg);     /* find global & minimal      */J     subsampling (power, ltg, &tone, &noise);  /* threshold, and sgnl-   */R     threshold(sub_size,power, ltg, &tone, &noise,     /* to-mask ratio          */8       bitrate[info->lay-1][info->bitrate_index]/stereo);/     I_minimum_mask(sub_size,ltg, &ltmin[k][0]); <     I_smr(&ltmin[k][0], &spike[k][0], &scale[k][0]);          }!     mem_free ((void **) &sample);       mem_free ((void **) &spike); }*