G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) 0  * ISO 13818-3 MPEG-2 Audio Multichannel Encoder  *4  * $Id: psy.c 1.7 1996/02/12 07:13:35 rowlands Exp $  *  * $Log: psy.c $.  * Revision 1.7  1996/02/12 07:13:35  rowlands#  * Release following Munich meeting   *H  **********************************************************************/  G /********************************************************************** G  *   date   programmers         comment                               * G  * 2/25/91  Davis Pan           start of version 1.0 records          * G  * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         * G  * 7/10/91  Earle Jennings      Ported to MsDos.                      * G  *                              replace of floats with FLOAT          * G  * 2/11/92  W. Joseph Carter    Fixed mem_alloc() arg for "absthr".   * H  **********************************************************************/   #include "common.h"  #include "encoder.h"   void psycho_anal( 	double *buffer, 	short int *savebuf,	 	int chn, 	 	int lay,  	float *snr32,E 	double sfreq /* to match prototype : float args are always double */  ) {   unsigned int   i, j, k;#  FLOAT          r_prime, phi_prime; 9  FLOAT          freq_mult, bval_lo, minthres, sum_energy; (  double         tb, temp1, temp2, temp3;  L /* The static variables "r", "phi_sav", "new", "old" and "oldest" have    */L /* to be remembered for the unpredictability measure.  For "r" and        */L /* "phi_sav", the first index from the left is the channel select and     */L /* the second index is the "age" of the data.                             */  -  static int     new = 0, old = 1, oldest = 0; 5  static int     init = 0, flush, syncsize, sfreq_idx;   M /* The following static variables are constants.                           */     static double  nmt = 5.5;  I  static FLOAT   crit_band[27] = {0,  100,  200, 300, 400, 510, 630,  770, I                                920, 1080, 1270,1480,1720,2000,2320, 2700, I                               3150, 3700, 4400,5300,6400,7700,9500,12000, 0                              15500,25000,30000};  E  static FLOAT   bmax[27] = {20.0, 20.0, 20.0, 20.0, 20.0, 17.0, 15.0, E                             10.0,  7.0,  4.4,  4.5,  4.5,  4.5,  4.5, E                              4.5,  4.5,  4.5,  4.5,  4.5,  4.5,  4.5, @                              4.5,  4.5,  4.5,  3.5,  3.5,  3.5};  L /* The following pointer variables point to large areas of memory         */L /* dynamically allocated by the mem_alloc() function.  Dynamic memory     */L /* allocation is used in order to avoid stack frame or data area          */L /* overflow errors that otherwise would have occurred at compile time     */L /* on the Macintosh computer.                                             */  <  FLOAT          *grouped_c, *grouped_e, *nb, *cb, *ecb, *bc;2  FLOAT          *wsamp_r, *wsamp_i, *phi, *energy;  FLOAT          *c, *fthr;  F32            *snrtmp;    static int     *numlines;  static int     *partition;   static FLOAT   *cbval, *rnorm;   static FLOAT   *window;  static FLOAT   *absthr;  static double  *tmn;   static FCB     *s;   static FHBLK   *lthr;  static F2HBLK  *r, *phi_sav;   L /* These dynamic memory allocations simulate "automatic" variables        */L /* placed on the stack.  For each mem_alloc() call here, there must be    */L /* a corresponding mem_free() call at the end of this function.           */  ;  grouped_c = (FLOAT *) mem_alloc(sizeof(FCB), "grouped_c"); ;  grouped_e = (FLOAT *) mem_alloc(sizeof(FCB), "grouped_e"); -  nb = (FLOAT *) mem_alloc(sizeof(FCB), "nb"); -  cb = (FLOAT *) mem_alloc(sizeof(FCB), "cb"); /  ecb = (FLOAT *) mem_alloc(sizeof(FCB), "ecb"); -  bc = (FLOAT *) mem_alloc(sizeof(FCB), "bc"); 8  wsamp_r = (FLOAT *) mem_alloc(sizeof(FBLK), "wsamp_r");8  wsamp_i = (FLOAT *) mem_alloc(sizeof(FBLK), "wsamp_i");0  phi = (FLOAT *) mem_alloc(sizeof(FBLK), "phi");6  energy = (FLOAT *) mem_alloc(sizeof(FBLK), "energy");-  c = (FLOAT *) mem_alloc(sizeof(FHBLK), "c"); 3  fthr = (FLOAT *) mem_alloc(sizeof(FHBLK), "fthr"); 5  snrtmp = (F32 *) mem_alloc(sizeof(F2_32), "snrtmp");   
  if(init==0){   L /* These dynamic memory allocations simulate "static" variables placed    */L /* in the data space.  Each mem_alloc() call here occurs only once at     */L /* initialization time.  The mem_free() function must not be called.      */  ;      numlines = (int *) mem_alloc(sizeof(ICB), "numlines"); ?      partition = (int *) mem_alloc(sizeof(IHBLK), "partition"); 7      cbval = (FLOAT *) mem_alloc(sizeof(FCB), "cbval"); 7      rnorm = (FLOAT *) mem_alloc(sizeof(FCB), "rnorm"); :      window = (FLOAT *) mem_alloc(sizeof(FBLK), "window");;      absthr = (FLOAT *) mem_alloc(sizeof(FHBLK), "absthr"); 4      tmn = (double *) mem_alloc(sizeof(DCB), "tmn");/      s = (FCB *) mem_alloc(sizeof(FCBCB), "s"); 8      lthr = (FHBLK *) mem_alloc(sizeof(F2HBLK), "lthr");4      r = (F2HBLK *) mem_alloc(sizeof(F22HBLK), "r");@      phi_sav = (F2HBLK *) mem_alloc(sizeof(F22HBLK), "phi_sav");        i = sfreq + 0.5;       switch(i){ )         case 32000: sfreq_idx = 0; break; )         case 44100: sfreq_idx = 1; break; )         case 48000: sfreq_idx = 2; break; K         default:    printf("error, invalid sampling frequency: %d Hz\n",i);          exit(-1);       }W      if (verbosity >= 2) printf("absthr[][] sampling frequency index: %d\n",sfreq_idx); $      read_absthr(absthr, sfreq_idx);      if(lay==1){         flush = 448;         syncsize = 1024;      }      else {          flush = 384*3.0/2.0;         syncsize = 1056;      }( /* calculate HANN window coefficients */I      for(i=0;i<BLKSIZE;i++)window[i]=0.5*(1-cos(2.0*PI*i/(BLKSIZE-1.0))); 3 /* reset states used in unpredictability measure */       for(i=0;i<HBLKSIZE;i++){ 6         r[0][0][i]=r[1][0][i]=r[0][1][i]=r[1][1][i]=0;,         phi_sav[0][0][i]=phi_sav[1][0][i]=0;,         phi_sav[0][1][i]=phi_sav[1][1][i]=0;&         lthr[0][i] = 60802371420160.0;&         lthr[1][i] = 60802371420160.0;      }N /*****************************************************************************N  * Initialization: Compute the following constants for use later             *N  *    partition[HBLKSIZE] = the partition number associated with each        *N  *                          frequency line                                   *N  *    cbval[CBANDS]       = the center (average) bark value of each          *N  *                          partition                                        *N  *    numlines[CBANDS]    = the number of frequency lines in each partition  *N  *    tmn[CBANDS]         = tone masking noise                               *O  *****************************************************************************/ ( /* compute fft frequency multiplicand */      freq_mult = sfreq/BLKSIZE;    P /* calculate fft frequency, then bval of each line (use fthr[] as tmp storage)*/      for(i=0;i<HBLKSIZE;i++){          temp1 = i*freq_mult;         j = 1;%         while(temp1>crit_band[j])j++; I         fthr[i]=j-1+(temp1-crit_band[j-1])/(crit_band[j]-crit_band[j-1]);       }      partition[0] = 0;M /* temp2 is the counter of the number of frequency lines in each partition */       temp2 = 1;       cbval[0]=fthr[0];      bval_lo=fthr[0];       for(i=1;i<HBLKSIZE;i++){ #         if((fthr[i]-bval_lo)>0.33){ )            partition[i]=partition[i-1]+1; ?            cbval[partition[i-1]] = cbval[partition[i-1]]/temp2; )            cbval[partition[i]] = fthr[i];             bval_lo = fthr[i]; ,            numlines[partition[i-1]] = temp2;            temp2 = 1; 	         }          else {'            partition[i]=partition[i-1]; *            cbval[partition[i]] += fthr[i];            temp2++; 	         }       }&      numlines[partition[i-1]] = temp2;9      cbval[partition[i-1]] = cbval[partition[i-1]]/temp2;    I /************************************************************************ I  * Now compute the spreading function, s[j][i], the value of the spread-* I  * ing function, centered at band j, for band i, store for later use    **J  ************************************************************************/      for(j=0;j<CBANDS;j++){8         for(i=0;i<CBANDS;i++){.            temp1 = (cbval[i] - cbval[j])*1.05;(            if(temp1>=0.5 && temp1<=2.5){"               temp2 = temp1 - 0.5;8               temp2 = 8.0 * (temp2*temp2 - 2.0 * temp2);            }            else temp2 = 0;            temp1 += 0.474;M            temp3 = 15.811389+7.5*temp1-17.5*sqrt((double) (1.0+temp1*temp1));d)            if(temp3 <= -100) s[i][j] = 0;             else { 2               temp3 = (temp2 + temp3)*LN_TO_LOG10;#               s[i][j] = exp(temp3);             }	         }d      }  +   /* Calculate Tone Masking Noise values */e      for(j=0;j<CBANDS;j++){           temp1 = 15.5 + cbval[j];-         tmn[j] = (temp1>24.5) ? temp1 : 24.5;OG   /* Calculate normalization factors for the net spreading functions */          rnorm[j] = 0;*         for(i=0;i<CBANDS;i++){            rnorm[j] += s[j][i]; 	         }"      }      init++;  }  .O /************************* End of Initialization *****************************/t  switch(lay) {	   case 1:u	   case 2:*      for(i=0; i<lay; i++){N /*****************************************************************************N  * Net offset is 480 samples (1056-576) for layer 2; this is because one must*N  * stagger input data by 256 samples to synchronize psychoacoustic model with*N  * filter bank outputs, then stagger so that center of 1024 FFT window lines *N  * up with center of 576 "new" audio samples.                                *N  *                                                                           *N  * For layer 1, the input data still needs to be staggered by 256 samples,   *N  * then it must be staggered again so that the 384 "new" samples are centered*N  * in the 1024 FFT window.  The net offset is then 576 and you need 448 "new"*N  * samples for each iteration to keep the 384 samples of interest centered   *O  *****************************************************************************/0"         for(j=0; j<syncsize; j++){?            if(j<(syncsize-flush))savebuf[j] = savebuf[j+flush]; '            else savebuf[j] = *buffer++;AO /**window data with HANN window***********************************************/             if(j<BLKSIZE){5:               wsamp_r[j] = window[j]*((FLOAT) savebuf[j]);               wsamp_i[j] = 0;             }	         } O /**Compute FFT****************************************************************/i(         fft(wsamp_r,wsamp_i,energy,phi);N /*****************************************************************************N  * calculate the unpredictability measure, given energy[f] and phi[f]        *O  *****************************************************************************/ "         for(j=0; j<HBLKSIZE; j++){>            r_prime = 2.0 * r[chn][old][j] - r[chn][oldest][j];L            phi_prime = 2.0 * phi_sav[chn][old][j] - phi_sav[chn][oldest][j];5            r[chn][new][j] = sqrt((double) energy[j]);m)            phi_sav[chn][new][j] = phi[j];nP temp1=r[chn][new][j] * cos((double) phi[j]) - r_prime * cos((double) phi_prime);P temp2=r[chn][new][j] * sin((double) phi[j]) - r_prime * sin((double) phi_prime);8            temp3=r[chn][new][j] + fabs((double)r_prime);B            if(temp3 != 0)c[j]=sqrt(temp1*temp1+temp2*temp2)/temp3;            else c[j] = 0;e	         }oO /*only update data "age" pointers after you are done with the second channel */ O /*for layer 1 computations, for the layer 2 double computations, the pointers*/gO /*are reset automatically on the second pass                                 */          if(lay==2 || chn==1){,+            if(new==0){new = 1; oldest = 1;}B&            else {new = 0; oldest = 0;}+            if(old==0)old = 1; else old = 0;o	         }BN /*****************************************************************************N  * Calculate the grouped, energy-weighted, unpredictability measure,         *N  * grouped_c[], and the grouped energy. grouped_e[]                          *O  *****************************************************************************/K         for(j=1;j<CBANDS;j++){            grouped_e[j] = 0;            grouped_c[j] = 0;	         }m!         grouped_e[0] = energy[0];t&         grouped_c[0] = energy[0]*c[0];          for(j=1;j<HBLKSIZE;j++){0            grouped_e[partition[j]] += energy[j];5            grouped_c[partition[j]] += energy[j]*c[j]; 	         }nN /*****************************************************************************N  * convolve the grouped energy-weighted unpredictability measure             *N  * and the grouped energy with the spreading function, s[j][k]               *O  *****************************************************************************/          for(j=0;j<CBANDS;j++){            ecb[j] = 0;            cb[j] = 0;B!            for(k=0;k<CBANDS;k++){l!               if(s[j][k] != 0.0){ 0                  ecb[j] += s[j][k]*grouped_e[k];/                  cb[j] += s[j][k]*grouped_c[k];;               }(            }.            if(ecb[j] !=0)cb[j] = cb[j]/ecb[j];            else cb[j] = 0;	         } N /*****************************************************************************N  * Calculate the required SNR for each of the frequency partitions           *N  *         this whole section can be accomplished by a table lookup          *O  *****************************************************************************/          for(j=0;j<CBANDS;j++){#            if(cb[j]<.05)cb[j]=0.05; &            else if(cb[j]>.5)cb[j]=0.5;=            tb = -0.434294482*log((double) cb[j])-0.301029996;1,            bc[j] = tmn[j]*tb + nmt*(1.0-tb);            k = cbval[j] + 0.5;7            bc[j] = (bc[j] > bmax[k]) ? bc[j] : bmax[k];r4            bc[j] = exp((double) -bc[j]*LN_TO_LOG10);	         }HN /*****************************************************************************N  * Calculate the permissible noise energy level in each of the frequency     *N  * partitions. Include absolute threshold and pre-echo controls              *N  *         this whole section can be accomplished by a table lookup          *O  *****************************************************************************/          for(j=0;j<CBANDS;j++)I&            if(rnorm[j] && numlines[j]):               nb[j] = ecb[j]*bc[j]/(rnorm[j]*numlines[j]);            else nb[j] = 0;          for(j=0;j<HBLKSIZE;j++){' /*temp1 is the preliminary threshold */c"            temp1=nb[partition[j]];3            temp1=(temp1>absthr[j])?temp1:absthr[j]; O /*do not use pre-echo control for layer 2 because it may do bad things to the*/*O /*  MUSICAM bit allocation algorithm                                         */             if(lay==1){F               fthr[j] = (temp1 < lthr[chn][j]) ? temp1 : lthr[chn][j];&               temp2 = temp1 * 0.00316;<               fthr[j] = (temp2 > fthr[j]) ? temp2 : fthr[j];            }             else fthr[j] = temp1;&            lthr[chn][j] = LXMIN*temp1;	         }qN /*****************************************************************************N  * Translate the 512 threshold values to the 32 filter bands of the coder    *O  *****************************************************************************/i         for(j=0;j<193;j += 16){c'            minthres = 60802371420160.0;             sum_energy = 0.0;            for(k=0;k<17;k++){09               if(minthres>fthr[j+k])minthres = fthr[j+k]; (               sum_energy += energy[j+k];            }:            snrtmp[i][j/16] = sum_energy/(minthres * 17.0);H            snrtmp[i][j/16] = 4.342944819 * log((double)snrtmp[i][j/16]);	         } *         for(j=208;j<(HBLKSIZE-1);j += 16){            minthres = 0.0;            sum_energy = 0.0;            for(k=0;k<17;k++){+$               minthres += fthr[j+k];(               sum_energy += energy[j+k];            }1            snrtmp[i][j/16] = sum_energy/minthres;*H            snrtmp[i][j/16] = 4.342944819 * log((double)snrtmp[i][j/16]);	         }gN /*****************************************************************************N  * End of Psychoacuostic calculation loop                                    *O  *****************************************************************************/(      }      for(i=0; i<32; i++){1         if(lay==2)J            snr32[i]=(snrtmp[0][i]>snrtmp[1][i])?snrtmp[0][i]:snrtmp[1][i];#         else snr32[i]=snrtmp[0][i];.      }      break;0	   case 3: 4      printf("layer 3 is not currently supported\n");      break;;
   default:@      printf("error, invalid MPEG/audio coding layer: %d\n",lay);  }  K /* These mem_free() calls must correspond with the mem_alloc() calls     */eK /* used at the beginning of this function to simulate "automatic"        */ K /* variables placed on the stack.                                        */      mem_free((void **) &grouped_c);   mem_free((void **) &grouped_e);  mem_free((void **) &nb);e  mem_free((void **) &cb);e  mem_free((void **) &ecb);  mem_free((void **) &bc);*  mem_free((void **) &wsamp_r);  mem_free((void **) &wsamp_i);  mem_free((void **) &phi);  mem_free((void **) &energy);+  mem_free((void **) &c);  mem_free((void **) &fthr);a  mem_free((void **) &snrtmp);* }t  O /*******************************************************************************, routine to read in absthr table from a file.O ******************************************************************************/b  / void read_absthr(float *absthr, long int table)l {t
  FILE *fp;  long i,j,index;	  float a;   char t[80], *ta = "absthr_0";  r  switch(table){f     case 0 : ta[7] = '0';*              break;6     case 1 : ta[7] = '1';               break;      case 2 : ta[7] = '2';               break; ?     default : printf("absthr table: Not valid table number\n");a  }!  if(!(fp = OpenTableFile(ta) ) ){p*     printf("Please check %s table\n", ta);     exit(0);  }  fgets(t, 150, fp);e   sscanf(t, "table %ld", &index);  if(index != table){*     printf("error in absthr table %s",ta);     exit(0);  }  for(j=0; j<HBLKSIZE; j++){r     fgets(t,80,fp);*     sscanf(t,"%f", &a);*     absthr[j] =  a;*  }  fclose(fp); }*