G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) 0  * ISO 13818-3 MPEG-2 Audio Multichannel Encoder  *9  * $Id: predisto.c 1.6 1996/02/12 07:13:35 rowlands Exp $   *  * $Log: predisto.c $ .  * Revision 1.6  1996/02/12 07:13:35  rowlands#  * Release following Munich meeting   *.  * Revision 1.5  1996/02/12 05:51:17  rowlands1  * Added verbosity switch to control text output. >  * Fixed uninitialized variable d in subband_quantization_pre.  *3  * Revision 1.3.2.1  1995/11/06  04:19:12  rowlands %  * Received from Uwe Felderhoff (IRT)   *.  * Revision 1.4  1995/08/14  08:06:01  tenkate0  * ML-LSF added Warner ten Kate 7/8/95 (Philips)J  * change alloc and sblimit into alloc_ml and sblimit_ml where appropriate  *H  **********************************************************************/  G  /********************************************************************* G  *                                                                    * G  *                                                                    * G  *  MPEG/audio Phase 2 coding/decoding multichannel                   * G  *                                                                    * G  *                                                                    * G  *                                                                    * G  *  Version 4.0    Susanne Ritscher, IRT Munich                       * G  *                                                                    * G  *  9/20/93        Implemented Prediction written by                  * G  *                 Heiko Purnhagen,  Uni Hannover in                  * G  *                 new source-file called prediction.c                * G  *                                                                    * G  *                                                                    * G  *                                                                    * G  *  version 4.1    Susanne Ritscher, IRT Munich                       * G  *                                                                    * G  *  9/20/93        channel-switching is only performed at a           * G  *                 certain limit of TC_ALLOC dB, which is included    * G  *                 in encoder.h                                       * G  *                                                                    * G  * 01/16/94        prediction will not work with trans._pat._errsig   * ;  *		   Have to do a new strategy with a new bal for       * ;  *		   the add. channels                                  * G  *                                                                    * C  * 04/08/94	   started with predistortion                         * G  *                                                                    * G  * 06/28/94        started with predistortion according to the DIS    * ;  *		   and the tc_table                                   * G  *                                                                    * G  *                                                                    * G  *  version 5.0    Susanne Ritscher,  IRT Munich                      * G  *                                                                    * G  *  7/12/94        bitstream according to DIS                         * G  *                 extension bitstream is working                     * G  *                 predistortion is working                           * G  *                                                                    * G  *  Version 1.1                                                       * G  *                                                                    * D  *  02/23/95	   Susanne Ritscher,  IRT Munich                      *G  *                 corrected some bugs                                * G  *                 extension bitstream is working                     * G  *                                                                    * G  *  Version 2.0                                                       * G  *                                                                    * G  *  01/28/97       Frans de Bont, Philips Sound & Vision, Eindhoven   * ;  *		    - dynamic crosstalk working for all configurations* ;  *		    - prediction working for all configurations	      * -  *		    - extension bitstream fixed			      * ;  *		    - fully compliant to DIS 13818-3.2                * X  *                                                                    *				      *		    H  *********************************************************************/   G /**********************************************************************   *  ,  *  This program computes the predistortion.=  *  The three additional channels are AFTER THE BITALLOCATION =  *  quantized and dequantized. With these dequantized samples H  *  the frontchannels are matriced again in order to dematrice them in aH  *  more exact way. This should improve the quality of matriced signals.  *  I  *  In case of prediction the whole process of decoding predicted signals   *  is worked off????   *  L  **************************************************************************/ #include "common.h"  #include "encoder.h"    R void predistortion(double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], I 		    unsigned int (*bit_alloc)[32], unsigned int (*subband)[3][12][32],  N 		    frame_params *fr_ps, double (*perm_smr)[32], unsigned int (*scfsi)[32], . 		    int *adb, unsigned int (*scfsi_dyn)[32]) { <     double sbs_sample[7][3][12][SBLIMIT];  /*predistortion*/     int l, m, i, n, k;     int sblimit;     int ch, gr, sb;      int ad;      sblimit = fr_ps->sblimit;      l = 2; m = 7;      N     pre_quant(sbs_sample, l, m, sb_sample, scalar, bit_alloc, subband, fr_ps); 	     J     matri(sbs_sample, fr_ps, sb_sample, scalar, sblimit, scfsi, scfsi_dyn,           bit_alloc, subband);       l = 0; m = 2;      =     /*II_scale_factor_calc(sb_sample,scalar,sblimit, l, m);*/ 2     trans_pattern(scalar, scfsi, fr_ps,scfsi_dyn);       4     bit_all(perm_smr, scfsi, bit_alloc, adb, fr_ps); }                   E static double snr[18] = { 0.00,  6.03, 11.80, 15.81, /* 0, 3, 5, 7 */ 0 			 19.03, 23.50, 29.82, 35.99, /* 9,15,31,63 */0 			 42.08, 48.13, 54.17, 60.20, /* 127, ...   */0 			 66.22, 72.25, 78.27, 84.29, /* 2047, ...  */0 			 90.31, 96.33};              /* 16383, ... */    & /* Multilingual TEST 17/03/1995 JMZ */| int bit_all(double (*perm_smr)[32], unsigned int (*scfsi)[32], unsigned int (*bit_alloc)[32], int *adb, frame_params *fr_ps)9                               /* minimum masking level */   H /* bit_all() recalculates allocation for compatible signals Lo and Ro */H /* which are channels k==0 and k==1. This recalculation is performed  */H /* because of signal modifications by predistortion.                  */H /* WtK 7/8/95. Information from SR.                                   */	                                 { N     int n_ml_ch = fr_ps->header->multiling_ch; 	/*JMZ 17/03/95 Multilingual */G     int i, min_ch, min_sb, oth_ch, k, increment, scale, seli, ba, j, l; $     int adb_hlp, adb_hlp1, adb_hlp2;(     int bspl, bscf, bsel, ad, noisy_sbs;(     int bspl_mpg1, bscf_mpg1, bsel_mpg1;E     double mnr[14][SBLIMIT], small;				/*JMZ 17/03/95 Multilingual */ ?     char used[14][SBLIMIT];						/*JMZ 17/03/95 Multilingual */      int stereo	= fr_ps->stereo; #     int stereomc = fr_ps->stereomc; %     int stereoaug = fr_ps->stereoaug; !     int sblimit = fr_ps->sblimit; '     int sblimit_mc = fr_ps->sblimit_mc; '     int sblimit_ml = fr_ps->sblimit_ml;   !     int jsbound = fr_ps->jsbound; #     al_table *alloc = fr_ps->alloc; )     al_table *alloc_mc = fr_ps->alloc_mc; )     al_table *alloc_ml = fr_ps->alloc_ml;   B     double dynsmr = 0.0;  /* border of SMR for dynamic datarate */     static char init= 0;     static int banc, berr;/     int bbal, bancmc, pred, bancext, bbal_mpg1;      int ll, pci, adb_mpg1;>     int bits = 0; /*bits already used for the front-channels*/K     static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */      +     banc = 32; /* banc: bits for header */;*0     /* 960627 FdB reserve extra bits wrt bugs */     banc += 200;  (     if (fr_ps->header->error_protection) 	berr = 16;E     else# 	berr = 0; /* added 92-08-11 shn */7  
     pred = 0;x     bancmc = 0;:     bancext = 0;
     bbal = 0;1     bbal_mpg1 = 0;P     adb_mpg1 = bitrate[fr_ps->header->lay-1][fr_ps->header->bitrate_index] * 24;   #ifdef DEBUGh if (verbosity >= 3) printf("stereo+stereomc+stereoaug+n_ml_ch=%d\n", stereo+stereomc+stereoaug+n_ml_ch); #endif . 	*-     if (fr_ps->header->mode == MPG_MD_STEREO)w     {  	for (i = 0; i < sblimit; ++i), 	    bbal += (stereo) * (*alloc)[i][0].bits;! 	for (i = 0; i < sblimit_mc; ++i)r8 	    bbal += (stereomc+stereoaug) * (*alloc)[i][0].bits;! 	for (i = 0; i < sblimit_ml; ++i)p0 	    bbal += (n_ml_ch) * (*alloc_ml)[i][0].bits;     }	 *3     if (fr_ps->header->mode == MPG_MD_JOINT_STEREO)*     {* 	for (i = 0; i < jsbound; ++i), 	    bbal += (stereo) * (*alloc)[i][0].bits;$ 	for (i = jsbound; i < sblimit; ++i). 	    bbal += (stereo-1) * (*alloc)[i][0].bits;! 	for (i = 0; i < sblimit_mc; ++i)a8 	    bbal += (stereomc+stereoaug) * (*alloc)[i][0].bits;! 	for (i = 0; i < sblimit_ml; ++i) 0 	    bbal += (n_ml_ch) * (*alloc_ml)[i][0].bits;     }   0     if (fr_ps->header->center == 3) bbal -= 41;   3     if (fr_ps->header->ext_bit_stream_present == 0) H 	bancmc += 35;      /* mc_header + crc + tc_sbgr_select+ dyn_cross_on + > 			      mc_prediction_on  01/05/94,  SR  new! 05/04/94,  SR*/     else     {  	bancmc += 43;			    / 	bancext = 40;     }d
       			    t+     if (fr_ps->header->tc_sbgr_select == 0)  	bancmc += 36;     else 	bancmc += 3;	  )     if (fr_ps->header->dyn_cross_on == 1)i? 	bancmc += 49;      /* now with dyn_cross_LR,  505/04/94,  SR*/   -     if (fr_ps->header->mc_prediction_on == 1)      { A 	for (i = 0; i < 8; i++)   /*now only 8 sb_groups, 05/04/94, SR*/* 	{ 	    bancmc += 1; ( 	    if (fr_ps->header->mc_pred[i] == 1)9 		bancmc += n_pred_coef[fr_ps->header->dyn_cross[i]] * 2;  	}   	for (i = 0; i < 8; i++)  ( 	    if (fr_ps->header->mc_pred[i] == 1)@ 		for (j = 0; j < n_pred_coef[fr_ps->header->dyn_cross[i]]; j++)+ 		    if (fr_ps->header->predsi[i][j] != 0)c 		    {m
 			pred += 3;d: 			for (pci = 0; pci < fr_ps->header->predsi[i][j]; pci++) 			    pred += 8;  		    }	     }      	 !     for (l = 0; l < sblimit; l++)  	for (k = 0; k < 2; k++) 	    used[k][l] = 0;     G     for (l = 0; l < SBLIMIT; l++)		  /* searching for the sb min SMR */      {a 	i = sbgrp[l];  5 	for (j = stereo; j < stereo+stereomc+stereoaug; j++) ' 	    if ((j < stereo && l < sblimit) || " 		(j >= stereo && l < sblimit_mc)) 	    {A 		/* k = transmission_channel5[fr_ps->header->tc_alloc[i]][j]; */ + 	  	k = transmission_channel (fr_ps, i, j);    		if (j < stereo) 8 		    bits += 12 * ((*alloc)[l][bit_alloc[k][l]].group *) 				  (*alloc)[l][bit_alloc[k][l]].bits);d5 		else if (j < 7 || n_ml_ch == 0) /* Multichannel */  ; 		    bits += 12 * ((*alloc_mc)[l][bit_alloc[k][l]].group * , 				  (*alloc_mc)[l][bit_alloc[k][l]].bits); 		else /* MultiLingual */ ; 		    bits += 12 * ((*alloc_ml)[l][bit_alloc[k][l]].group * , 				  (*alloc_ml)[l][bit_alloc[k][l]].bits);   		if (bit_alloc[k][l] != 0)  		{  		    bits += 2; 		    switch (scfsi[k][l]) 		    {  			case 0: bits += 18; break;  			case 1: bits += 12; break;		m 			case 2: bits += 6; break; 			case 3: bits += 12; break;		r
 		    }    		}  	    }     }        for (i = 0; i < 12; i++)     { L 	if ((fr_ps->header->tc_alloc[i] == 1) || (fr_ps->header->tc_alloc[i] == 7)) 	{7 	    bits += 12 * ((*alloc)[l][bit_alloc[0][l]].group * ( 			  (*alloc)[l][bit_alloc[0][l]].bits); 	    if (bit_alloc[0][l] != 0) 	    { 		bits += 2; 		switch(scfsi[0][l])  		{*  		    case 0: bits += 18; break;" 		    case 1: bits += 12; break;		 		    case 2: bits += 6; break;t" 		    case 3: bits += 12; break;		 		}    	    } 	    used[0][l] = 2; 	}  L 	if ((fr_ps->header->tc_alloc[i] == 2) || (fr_ps->header->tc_alloc[i] == 6)) 	{7 	    bits += 12 * ((*alloc)[l][bit_alloc[1][l]].group * ( 			  (*alloc)[l][bit_alloc[1][l]].bits); 	    if (bit_alloc[1][l] != 0) 	    { 		bits += 2; 		switch(scfsi[1][l])* 		{   		    case 0: bits += 18; break;" 		    case 1: bits += 12; break;		 		    case 2: bits += 6; break;n" 		    case 3: bits += 12; break;		 		}    	    } 	    used[1][l] = 2; 	}     }	    7     	if(fr_ps->header->ext_bit_stream_present == 0)     7 	    *adb -= bbal + berr + banc + bancmc + pred + bits;	 	else* 	{? 	    *adb = *adb - bbal - berr - banc - bancmc - pred - bits -  / 	    bancext - (fr_ps->header->n_ad_bytes * 8);*! 	    for(i = 0; i < sblimit; ++i)*( 		 bbal_mpg1 += 2 * (*alloc)[i][0].bits;3 	    adb_mpg1 -= bbal_mpg1 + berr + banc + bancmc +A& 	     (fr_ps->header->n_ad_bytes * 8); 	 }            ad = *adb;  e  	    for(l = 0;l < sblimit; l++) 	    { 		for( k = 0; k < 2; k++)e 		{a$ 				mnr[k][l]=snr[0]-perm_smr[k][l]; 				if(used[k][l] == 0)e 			        bit_alloc[k][l] = 0;p 		}		o 	    }    rF /********************************************************************/# /* JMZ 08/03/1995 Multilingual */  *  " 	for (i = 0; i < sblimit_ml; i++) " 		for (k = 7; k < 7+n_ml_ch; k++)  		{ " 		mnr[k][i]=snr[0]-perm_smr[k][i];F 		 /* mask-to-noise-level = signal-to-noise-level - minimum-masking-*/ 		 /* threshold*/s   		bit_alloc[k][i] = 0; 		used[k][i] = 0;m 		}a  $ /* JMZ 08/03/1995 Multilingual */   F /********************************************************************/         b    s< 	bspl = bscf = bsel = bspl_mpg1 = bscf_mpg1 = bsel_mpg1 = 0;  n	     do  {n 	small = 999999.0;
 	min_sb = -1; 
 	min_ch = -1;     $         for(i = 0; i < sblimit; i++) 	{ 	     for( k = 0; k < 2; k++)e 		{m4 		    if ((used[k][i] != 2) && (small > mnr[k][i]))  		    {a 			small = mnr[k][i];s 			min_sb = i;  min_ch = k;f 		    }_ 		}    	 }  	 D /******************************************************************/! /* Multilingual JMZ 08/03/1995 */)   if(n_ml_ch >0) {r! 	for (i = 0; i < sblimit_ml; i++) # 	  for(j = 7; j < (n_ml_ch+7); ++j)b 	  {
 	     k=j;4 	     if ((used[k][i] != 2) && (small > mnr[k][i]))  	     {0$                   small = mnr[k][i];*                   min_sb = i;  min_ch = k; 	     }2 	} }.  ! /* Multilingual JMZ 08/03/1995 */	D /******************************************************************/   	       if(min_sb > -1)        { i        if (min_ch < stereo)         {J 	 increment = 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].group * B 	             (*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);% 		     /* how many bits are needed */b"          if (used[min_ch][min_sb])Q           increment -= 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]].group * lN                             (*alloc)[min_sb][bit_alloc[min_ch][min_sb]].bits);	        }  ?        else if (min_ch < 7 || n_ml_ch == 0) /* Multichannel */          {M 	 increment = 12 * ((*alloc_mc)[min_sb][bit_alloc[min_ch][min_sb]+1].group * iE 	             (*alloc_mc)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);h% 		     /* how many bits are needed */l"          if (used[min_ch][min_sb])T           increment -= 12 * ((*alloc_mc)[min_sb][bit_alloc[min_ch][min_sb]].group * Q                             (*alloc_mc)[min_sb][bit_alloc[min_ch][min_sb]].bits);r	        } B*        else /* MultiLingual 7/8/95 WtK */         {K 	  increment   = ((*alloc_ml)[min_sb][bit_alloc[min_ch][min_sb]+1].group * o; 			 (*alloc_ml)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);  	  if (used[min_ch][min_sb])I 	   increment -= ((*alloc_ml)[min_sb][bit_alloc[min_ch][min_sb]].group * r9 			 (*alloc_ml)[min_sb][bit_alloc[min_ch][min_sb]].bits);l7 	  if (fr_ps->header->multiling_fs==1) increment *=  6;_7 	  else                                increment *= 12;r        }  9        /* scale factor bits required for subband [min] */c2        if (used[min_ch][min_sb]) scale = seli = 0;        else :        {			  /* this channel had no bits or scfs before */          seli = 2;8          scale = 6 * sfsPerScfsi[scfsi[min_ch][min_sb]]; 	} 	o5        if(fr_ps->header->ext_bit_stream_present == 1)         {N 	if (adb_mpg1 > bspl_mpg1 + bscf_mpg1 + bsel_mpg1 + seli + scale + increment)  	{: 	   bspl_mpg1 += increment;  /* bits for subband sample */8 	   bscf_mpg1 += scale;      /* bits for scale factor */6 	   bsel_mpg1 += seli;       /* bits for scfsi code */ 	} 	else > 	   used[min_ch][min_sb] = 2;  /* can't increase this alloc */        } 	e         `        if ((ad > bspl + bscf + bsel + seli + scale + increment) && (used[min_ch][min_sb] != 2))         {: 	    ba = ++bit_alloc[min_ch][min_sb]; /* next up alloc */: 	    bspl += increment;		    /* bits for subband sample */4 	    bscf += scale;		    /* bits for scale factor */2 	    bsel += seli;			    /* bits for scfsi code */9 	    used[min_ch][min_sb] = 1;	    /* subband has bits */+ 	    if (min_ch<7)8 	      mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +* 				    snr[(*alloc)[min_sb][ba].quant+1];	 	    else(8 	      mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +- 				    snr[(*alloc_ml)[min_sb][ba].quant+1];+ 			    b= 	    /* Check if subband has been fully allocated max bits */m 	    if (min_ch < stereo)  	    {J 	     if (ba >= (1<<(*alloc)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2; 	    } (= 	    else if (min_ch < 7 || n_ml_ch == 0) /* Multichannel */ a 	    {M 	     if (ba >= (1<<(*alloc_mc)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2;  	    } =
 	    else  	    {M 	     if (ba >= (1<<(*alloc_ml)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2;, 	    } 	}@ 	else used[min_ch][min_sb] = 2;  /* can't increase this alloc */  ,       }   /* end of if-loop if min_sb >-1 */<    } while(min_sb > -1);   /* until could find no channel */*    /* Calculate the number of bits left */      ad -= bspl+bscf+bsel;  
    *adb = ad;y9    for (i=sblimit;i<SBLIMIT;i++) for (k = 0; k < 2; k++) _       bit_alloc[k][i]=0;D    for (i=sblimit_ml;i<SBLIMIT;i++) for (k = 7; k < 7+n_ml_ch; k++)        bit_alloc[k][i]=0; }      ` void matri(double (*sbs_sample)[3][12][32], frame_params *fr_ps, double (*sb_sample)[3][12][32],I 	 unsigned int (*scalar)[3][32], int sblimit, unsigned int (*scfsi)[32],  @ 	 unsigned int (*scfsi_dyn)[32], unsigned int (*bit_alloc)[32], % 	 unsigned int (*subband)[3][12][32])  { !   int i, j, k, l, ch1, ch2, m, n;       layer *info = fr_ps->header;   	for(k = 0; k < 8; k++)  	{,           if(fr_ps->header->mc_pred[k] == 0) 	  {	l' 	    switch(fr_ps->header->tc_alloc[k])[ 	    {
 		case 0:  	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)n 			{d 				sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sbs_sample[2][j][l][k] + sbs_sample[3][j][l][k];d 				sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sbs_sample[2][j][l][k] + sbs_sample[4][j][l][k]; 			} 			m = 0; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, k, sb_sample); 
 		     break;o	 		case 1:i 	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)o 			{d 				sb_sample[0][j][l][k] = sbs_sample[5][j][l][k] + sb_sample[2][j][l][k] + sbs_sample[3][j][l][k]; 			} 			[ 			m = 0; n = 1;9 			scale_factor_calc(scalar,sblimit, m, n, k, sb_sample);	1 			trans_pattern(scalar, scfsi, fr_ps,scfsi_dyn);oM 			pre_quant(sbs_sample, m, n, sb_sample, scalar, bit_alloc, subband, fr_ps);;   	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)  			{f 				sbs_sample[2][j][l][k] = sbs_sample[0][j][l][k] - sbs_sample[5][j][l][k] - sbs_sample[3][j][l][k];d 				sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sbs_sample[2][j][l][k] + sbs_sample[4][j][l][k]; 			} 			m = 1; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, k, sb_sample);c 			c
 		     break; 	 		case 2:= 	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)] 			{d 				sb_sample[1][j][l][k] = sbs_sample[6][j][l][k] + sb_sample[2][j][l][k] + sbs_sample[4][j][l][k]; 			} 			e 			m = 1; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, k, sb_sample);s1 			trans_pattern(scalar, scfsi, fr_ps,scfsi_dyn); M 			pre_quant(sbs_sample, m, n, sb_sample, scalar, bit_alloc, subband, fr_ps);    	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)  			{f 				sbs_sample[2][j][l][k] = sbs_sample[1][j][l][k] - sbs_sample[6][j][l][k] - sbs_sample[4][j][l][k];d 				sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sbs_sample[2][j][l][k] + sbs_sample[3][j][l][k]; 			} 			m = 0; n = 1;9 			scale_factor_calc(scalar,sblimit, m, n, k, sb_sample);  			;
 		     break; 
 		case 3:  	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)s 			{d 				sb_sample[0][j][l][k] = sbs_sample[5][j][l][k] + sbs_sample[2][j][l][k] + sb_sample[3][j][l][k];d 				sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sbs_sample[2][j][l][k] + sbs_sample[4][j][l][k]; 			} 			m = 0; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, k, sb_sample); 
 		     break;a
 		case 4:  	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)  			{d 				sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sbs_sample[2][j][l][k] + sbs_sample[3][j][l][k];d 				sb_sample[1][j][l][k] = sbs_sample[6][j][l][k] + sbs_sample[2][j][l][k] + sb_sample[4][j][l][k]; 			} 			m = 0; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, k, sb_sample);*
 		     break;/
 		case 5:  	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)k 			{d 				sb_sample[0][j][l][k] = sbs_sample[5][j][l][k] + sbs_sample[2][j][l][k] + sb_sample[3][j][l][k];d 				sb_sample[1][j][l][k] = sbs_sample[6][j][l][k] + sbs_sample[2][j][l][k] + sb_sample[4][j][l][k]; 			} 			m = 0; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, k, sb_sample);*
 		     break;*	 		case 6:* 	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)m 			{d 				sb_sample[1][j][l][k] = sbs_sample[6][j][l][k] + sb_sample[2][j][l][k] + sbs_sample[4][j][l][k]; 			} 			l 			m = 1; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, k, sb_sample);=1 			trans_pattern(scalar, scfsi, fr_ps,scfsi_dyn);mM 			pre_quant(sbs_sample, m, n, sb_sample, scalar, bit_alloc, subband, fr_ps);*   	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)M 			{f 				sbs_sample[2][j][l][k] = sbs_sample[1][j][l][k] - sbs_sample[6][j][l][k] - sbs_sample[4][j][l][k];d 				sb_sample[0][j][l][k] = sbs_sample[5][j][l][k] + sbs_sample[2][j][l][k] + sb_sample[3][j][l][k]; 			} 			m = 0; n = 1;9 			scale_factor_calc(scalar,sblimit, m, n, k, sb_sample);  			 
 		     break;l	 		case 7:M 	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)* 			{d 				sb_sample[0][j][l][k] = sbs_sample[5][j][l][k] + sb_sample[2][j][l][k] + sbs_sample[3][j][l][k]; 			} 			  			m = 0; n = 1;9 			scale_factor_calc(scalar,sblimit, m, n, k, sb_sample);*1 			trans_pattern(scalar, scfsi, fr_ps,scfsi_dyn); M 			pre_quant(sbs_sample, m, n, sb_sample, scalar, bit_alloc, subband, fr_ps);    	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)_ 			{f 				sbs_sample[2][j][l][k] = sbs_sample[0][j][l][k] - sbs_sample[5][j][l][k] - sbs_sample[3][j][l][k];d 				sb_sample[1][j][l][k] = sbs_sample[6][j][l][k] + sbs_sample[2][j][l][k] + sb_sample[4][j][l][k]; 			} 			m = 1; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, k, sb_sample);b 			_
 		     break;i 	    } 	  } 	} 	 	  	for(i = 8; i < 12; i++) 	{,           if(fr_ps->header->mc_pred[k] == 0) 	  {' 	    switch(fr_ps->header->tc_alloc[i])a 	    {
 		case 0:  	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)i; 			    for( k = sb_groups[i-1] + 1; k <= sb_groups[i]; k++)M 			    {d 				sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sbs_sample[2][j][l][k] + sbs_sample[3][j][l][k];d 				sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sbs_sample[2][j][l][k] + sbs_sample[4][j][l][k]; 			    } 			 m = 0; n = 2;    i: 			 scale_factor_calc(scalar,sblimit, m, n, i, sb_sample);
 		     break;h	 		case 1:b 	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)6; 			    for( k = sb_groups[i-1] + 1; k <= sb_groups[i]; k++)  			    {d 				sb_sample[0][j][l][k] = sbs_sample[5][j][l][k] + sb_sample[2][j][l][k] + sbs_sample[3][j][l][k]; 			    } 			  			m = 0; n = 1;9 			scale_factor_calc(scalar,sblimit, m, n, i, sb_sample); 1 			trans_pattern(scalar, scfsi, fr_ps,scfsi_dyn);mM 			pre_quant(sbs_sample, m, n, sb_sample, scalar, bit_alloc, subband, fr_ps);    	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++) ; 			    for( k = sb_groups[i-1] + 1; k <= sb_groups[i]; k++)/ 			    {f 				sbs_sample[2][j][l][k] = sbs_sample[0][j][l][k] - sbs_sample[5][j][l][k] - sbs_sample[3][j][l][k];d 				sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sbs_sample[2][j][l][k] + sbs_sample[4][j][l][k]; 			    } 			m = 1; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, i, sb_sample);e
 		     break;n	 		case 2:] 	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++) ; 			    for( k = sb_groups[i-1] + 1; k <= sb_groups[i]; k++)b 			    {d 				sb_sample[1][j][l][k] = sbs_sample[6][j][l][k] + sb_sample[2][j][l][k] + sbs_sample[4][j][l][k]; 			    } 			u 			m = 1; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, i, sb_sample); 1 			trans_pattern(scalar, scfsi, fr_ps,scfsi_dyn);+M 			pre_quant(sbs_sample, m, n, sb_sample, scalar, bit_alloc, subband, fr_ps);n   	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)_; 			    for( k = sb_groups[i-1] + 1; k <= sb_groups[i]; k++)e 			    {f 				sbs_sample[2][j][l][k] = sbs_sample[1][j][l][k] - sbs_sample[6][j][l][k] - sbs_sample[4][j][l][k];d 				sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sbs_sample[2][j][l][k] + sbs_sample[3][j][l][k]; 			    } 			m = 0; n = 1;9 			scale_factor_calc(scalar,sblimit, m, n, i, sb_sample);  			    =
 		     break; 
 		case 3:  	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)n; 			    for( k = sb_groups[i-1] + 1; k <= sb_groups[i]; k++)a 			    {d 				sb_sample[0][j][l][k] = sbs_sample[5][j][l][k] + sbs_sample[2][j][l][k] + sb_sample[3][j][l][k];d 				sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sbs_sample[2][j][l][k] + sbs_sample[4][j][l][k]; 			    } 			m = 0; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, i, sb_sample);o
 		     break;f
 		case 4:  	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)i; 			    for( k = sb_groups[i-1] + 1; k <= sb_groups[i]; k++)] 			    {d 				sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sbs_sample[2][j][l][k] + sbs_sample[3][j][l][k];d 				sb_sample[1][j][l][k] = sbs_sample[6][j][l][k] + sbs_sample[2][j][l][k] + sb_sample[4][j][l][k]; 			    } 			m = 0; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, i, sb_sample);f
 		     break;e
 		case 5:  	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)]; 			    for( k = sb_groups[i-1] + 1; k <= sb_groups[i]; k++)  			    {d 				sb_sample[0][j][l][k] = sbs_sample[5][j][l][k] + sbs_sample[2][j][l][k] + sb_sample[3][j][l][k];d 				sb_sample[1][j][l][k] = sbs_sample[6][j][l][k] + sbs_sample[2][j][l][k] + sb_sample[4][j][l][k]; 			    } 			m = 0; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, i, sb_sample);0
 		     break;a	 		case 6:a 	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)a; 			    for( k = sb_groups[i-1] + 1; k <= sb_groups[i]; k++)  			    {d 				sb_sample[1][j][l][k] = sbs_sample[6][j][l][k] + sb_sample[2][j][l][k] + sbs_sample[4][j][l][k]; 			    } 			  			m = 1; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, i, sb_sample); 1 			trans_pattern(scalar, scfsi, fr_ps,scfsi_dyn); M 			pre_quant(sbs_sample, m, n, sb_sample, scalar, bit_alloc, subband, fr_ps);    	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++) ; 			    for( k = sb_groups[i-1] + 1; k <= sb_groups[i]; k++)b 			    {f 				sbs_sample[2][j][l][k] = sbs_sample[1][j][l][k] - sbs_sample[6][j][l][k] - sbs_sample[4][j][l][k];d 				sb_sample[0][j][l][k] = sbs_sample[5][j][l][k] + sbs_sample[2][j][l][k] + sb_sample[3][j][l][k]; 			    } 			m = 0; n = 1;9 			scale_factor_calc(scalar,sblimit, m, n, i, sb_sample);f 			=
 		     break;+	 		case 7:	 	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)2; 			    for( k = sb_groups[i-1] + 1; k <= sb_groups[i]; k++)  			    {d 				sb_sample[0][j][l][k] = sbs_sample[5][j][l][k] + sb_sample[2][j][l][k] + sbs_sample[3][j][l][k]; 			    } 			a 			m = 0; n = 1;9 			scale_factor_calc(scalar,sblimit, m, n, i, sb_sample); 1 			trans_pattern(scalar, scfsi, fr_ps,scfsi_dyn);+M 			pre_quant(sbs_sample, m, n, sb_sample, scalar, bit_alloc, subband, fr_ps);]   	 	    for( j = 0; j < 3; ++j) 			for(l = 0; l < 12; l ++)b; 			    for( k = sb_groups[i-1] + 1; k <= sb_groups[i]; k++)j 			    {f 				sbs_sample[2][j][l][k] = sbs_sample[0][j][l][k] - sbs_sample[5][j][l][k] - sbs_sample[3][j][l][k];d 				sb_sample[1][j][l][k] = sbs_sample[6][j][l][k] + sbs_sample[2][j][l][k] + sb_sample[4][j][l][k]; 			    } 			m = 1; n = 2;9 			scale_factor_calc(scalar,sblimit, m, n, i, sb_sample);b 			l
 		     break;  	    } 	  } 	}  }         buffer_sample(unsigned int (*keep_it)[36][32], unsigned int (*sample)[3][32], unsigned int (*bit_alloc)[32], frame_params *fr_ps, int l, int z, int q) {     int i,j,k,m;;    int stereo = fr_ps->stereo;     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc;    unsigned int x;  @    for (i=0;i<sblimit;i++) for (j= l;j<((i<jsbound)?z:l+1);j++)     {        if (bit_alloc[j][i])         {,          /* check for grouping in subband */1 	 /* if ((*alloc)[i][bit_alloc[j][i]].group==3)*/             for (m=0;m<3;m++) 	 	   {=5               sample[j][m][i] = keep_it[j][q*3+m][i];b            }         s        }        else -        {      /* for no sample transmitted */k/          for (k=0;k<3;k++) sample[j][k][i] = 0;k        }G        if(stereo == 2 && i>= jsbound)  /* joint stereo : copy L to R */i>           for (k=0;k<3;k++) sample[1][k][i] = sample[0][k][i];    }F    for (i=sblimit;i<SBLIMIT;i++) for (j= l;j< z;j++) for (k=0;k<3;k++)       sample[j][k][i] = 0; }      _       static double a[17] = {[B   0.750000000, 0.625000000, 0.875000000, 0.562500000, 0.937500000,B   0.968750000, 0.984375000, 0.992187500, 0.996093750, 0.998046875,B   0.999023438, 0.999511719, 0.999755859, 0.999877930, 0.999938965,   0.999969482, 0.999984741 };     static double b[17] = {+G   -0.250000000, -0.375000000, -0.125000000, -0.437500000, -0.062500000,sG   -0.031250000, -0.015625000, -0.007812500, -0.003906250, -0.001953125,	G   -0.000976563, -0.000488281, -0.000244141, -0.000122070, -0.000061035,    -0.000030518, -0.000015259 };m  0     void subband_quantization_pre(unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32], unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32], frame_params *fr_ps, int ch1, int ch2) {p,    int i, j, k, s, n, qnt, sig, m, l, ll, z;    int stereo	= fr_ps->stereo;"    int stereomc = fr_ps->stereomc;     int sblimit = fr_ps->sblimit;    unsigned int stps, y;    double d;"    al_table *alloc = fr_ps->alloc;    l      for (s=0;s<3;s++)      for (j=0;j<12;j= j+3) 	for (i=0;i<sblimit;i++) 	  for(k = ch1; k < ch2; k++)  	  { 	    for(z = 0; z < 3; z ++) 	    { 		    if(bit_alloc[k][i]) I 	               d = sb_samples[k][s][j+z][i] / multiple[scalar[k][s][i]]; 
 		    else 		       d = 0;s 	    	   = 	    if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */a 	    {K 		printf("In predistortion, not scaled properly, %d %d %d %d\n",k,s,j+z,i); 4 		printf("Value %1.10f\n",sb_samples[k][s][j+z][i]); 	    }. 	    qnt = (*alloc)[i][bit_alloc[k][i]].quant;$             d = d * a[qnt] + b[qnt];F              /* extract MSB N-1 bits from the floating point sample */!              if (d >= 0) sig = 1; (              else { sig = 0; d += 1.0; }              n = 0;  #ifndef MS_DOS7              stps = (*alloc)[i][bit_alloc[k][i]].steps; (              while ((1L<<n) < stps) n++; #else 6              while  ( ( (unsigned long)(1L<<(long)n) <G 	                 ((unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps) "                           & 0xffff                          )#                       ) && ( n <16)+                     ) n++; #endif              n--;iJ              sbband[k][s][j+z][i] = (unsigned int) (d * (double) (1L<<n));D              /* tag the inverted sign bit to sbband at position N */I              /* The bit inversion is a must for grouping with 3,5,9 stepsa1                 so it is done for all subbands */e3              if (sig) sbband[k][s][j+z][i] |= 1<<n;, 	     4 	     if(!bit_alloc[k][i]) sbband[k][s][j+z][i] = 0; 	    }   /*try try try ! 7/7/94 */   < /*             if ((*alloc)[i][bit_alloc[k][i]].group != 3)  	     {[5                y =(*alloc)[i][bit_alloc[k][i]].steps;[8                sbband[k][s][j][i] = sbband[k][s][j][i] +6                       		    sbband[k][s][j+1][i] * y +A                                     sbband[k][s][j+2][i] * y * y;s9                sbband[k][s][j+1][i] = sbband[k][s][j][i];e9                sbband[k][s][j+2][i] = sbband[k][s][j][i]; 
 	      }*/   	      	      	 }-            for (s=0;s<3;s++)*              for (j=sblimit;j<SBLIMIT;j++)D 		for (i=0;i<12;i++) for (k = 0; k < 7; k++) sbband[k][s][i][j] = 0; }	             void trans_pattern(unsigned int (*scalar)[3][32], unsigned int (*scfsi)[32], frame_params *fr_ps, unsigned int (*scfsi_dyn)[32]) {	    int stereo  = fr_ps->stereo;a"    int stereomc = fr_ps->stereomc;     int sblimit = fr_ps->sblimit;
 	int dscf[2];l 	int class[2],i,j,k;> static int pattern[5][5] = {0x123, 0x122, 0x122, 0x133, 0x123,>                             0x113, 0x111, 0x111, 0x444, 0x113,>                             0x111, 0x111, 0x111, 0x333, 0x113,>                             0x222, 0x222, 0x222, 0x333, 0x123,?                             0x123, 0x122, 0x122, 0x133, 0x123};_  c   for (k = 0; k < 2; k++)b      for (i=0;i<sblimit;i++) e      {4        dscf[0] =  (scalar[k][0][i]-scalar[k][1][i]);4        dscf[1] =  (scalar[k][1][i]-scalar[k][2][i]);        for (j=0;j<2;j++)        {'          if (dscf[j]<=-3) class[j] = 0;[;          else if (dscf[j] > -3 && dscf[j] <0) class[j] = 1;	2               else if (dscf[j] == 0) class[j] = 2;E                    else if (dscf[j] > 0 && dscf[j] < 3) class[j] = 3; *                         else class[j] = 4;        },        switch (pattern[class[0]][class[1]])         {)          case 0x123 :    scfsi[k][i] = 0;                           break;1)          case 0x122 :    scfsi[k][i] = 3;b;                          scalar[k][2][i] = scalar[k][1][i];]                          break; )          case 0x133 :    scfsi[k][i] = 3;];                          scalar[k][1][i] = scalar[k][2][i];                           break;f)          case 0x113 :    scfsi[k][i] = 1;l;                          scalar[k][1][i] = scalar[k][0][i];+                          break; )          case 0x111 :    scfsi[k][i] = 2;_M                          scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];+                          break;l)          case 0x222 :    scfsi[k][i] = 2; M                          scalar[k][0][i] = scalar[k][2][i] = scalar[k][1][i];                           break;c)          case 0x333 :    scfsi[k][i] = 2;)M                          scalar[k][0][i] = scalar[k][1][i] = scalar[k][2][i];                           break;g)          case 0x444 :    scfsi[k][i] = 2;	?                          if (scalar[k][0][i] > scalar[k][2][i])a@                               scalar[k][0][i] = scalar[k][2][i];M                          scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];s    e 	}     }s	 }    	   ,          ^ void pre_quant(double (*sbs_sample)[3][12][32], int l, int m, double (*sb_sample)[3][12][32], @ 		unsigned int (*scalar)[3][32], unsigned int (*bit_alloc)[32], : 		unsigned int (*subband)[3][12][32], frame_params *fr_ps) {b?     double sb_pre_sample[7][3][12][SBLIMIT];  /*predistortion*/l'     unsigned int sample[7][3][SBLIMIT];m)     unsigned int keep_it[7][36][SBLIMIT];s     int ch, sb, gr, i;     int hi,  hu;  Q     subband_quantization_pre(scalar, sb_sample, bit_alloc, subband, fr_ps, l, m);m   		     for (ch = l; ch < m; ch++)&       for (sb = 0; sb < SBLIMIT; sb++) 	for (gr = 0; gr < 3; gr++)  	    for (i = 0; i < 12; i++) 4 		keep_it[ch][i+gr*12][sb] = subband[ch][gr][i][sb];   		for(i = 0; i < 12; i++) 	 		{      p= 		    buffer_sample(keep_it,sample,bit_alloc,fr_ps, l, m, i);=  M 		    II_dequantize_sample(sample, bit_alloc, sb_pre_sample, fr_ps, l, m, i);pI 		    II_denormalize_sample(sb_pre_sample, scalar, fr_ps, i>>2, l, m, i);_ 	        }      	    o 		     for (ch = l; ch < m; ch++)        for (sb=0;sb<SBLIMIT;sb++) 	for (i = 0; i < 4; i++) 	    for (gr=0;gr<3;gr++) A 		sbs_sample[ch][0][i*3 + gr][sb] = sb_pre_sample[ch][gr][i][sb];s 		     for (ch = l; ch < m; ch++)        for (sb=0;sb<SBLIMIT;sb++) 	for (i = 4; i < 8; i++) 	    for (gr=0;gr<3;gr++)sE 		sbs_sample[ch][1][(i-4)*3 + gr][sb] = sb_pre_sample[ch][gr][i][sb];        for (ch = l; ch < m; ch++)        for (sb=0;sb<SBLIMIT;sb++) 	for (i = 8; i < 12; i++)  	    for (gr=0;gr<3;gr++)sE 		sbs_sample[ch][2][(i-8)*3 + gr][sb] = sb_pre_sample[ch][gr][i][sb];n     }i  ? /**************************************************************  /*9 /*   Restore the compressed sample to a factional number.t+ /*   first complement the MSB of the samples /*   for Layer II :a# /*   Use the formula s = s' * c + d  /*; /*  taken out of decoder,modified for prediction 9/16/93,SRj /*@ /**************************************************************/  D static double c[17] = { 1.33333333333, 1.60000000000, 1.14285714286,D                         1.77777777777, 1.06666666666, 1.03225806452,D                         1.01587301587, 1.00787401575, 1.00392156863,D                         1.00195694716, 1.00097751711, 1.00048851979,D                         1.00024420024, 1.00012208522, 1.00006103888,7                         1.00003051851, 1.00001525902 };   K static double d[17] = { 0.500000000, 0.500000000, 0.250000000, 0.500000000,iK                         0.125000000, 0.062500000, 0.031250000, 0.015625000,iL                         0.007812500, 0.003906250, 0.001953125, 0.0009765625,D                         0.00048828125, 0.00024414063, 0.00012207031,7                         0.00006103516, 0.00003051758 };9  D /************************** Layer II stuff ************************/   void II_dequantize_sample(unsigned int (*sample)[3][32], unsigned int (*bit_alloc)[32], double (*fraction)[3][12][32], frame_params *fr_ps, int l, int m, int z) {0    int i, j, k, x;    int stereo = fr_ps->stereo;     int sblimit = fr_ps->sblimit;"    al_table *alloc = fr_ps->alloc;  D    for (i=0;i<sblimit;i++)  for (j=0;j<3;j++) for (k = l;k < m ;k++)      if (bit_alloc[k][i]) {3  %        /* locate MSB in the sample */e
        x = 0;[
 #ifndef MSDOSm@        while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++; #else,1        /* microsoft C thinks an int is a short */s/        while (( (unsigned long) (1L<<(long)x) <sD                 (unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)#               ) && ( x < 16) ) x++;; #endif          /* MSB inversion *//        if (((sample[k][j][i] >> x-1) & 1) == 1);%           fraction[k][j][z][i] = 0.0;+)        else  fraction[k][j][z][i] = -1.0;   )        /* Form a 2's complement sample */lJ        fraction[k][j][z][i] += (double) (sample[k][j][i] & ((1<<x-1)-1)) //                             (double) (1L<<x-1);n  "        /* Dequantize the sample */E        fraction[k][j][z][i] += d[(*alloc)[i][bit_alloc[k][i]].quant];1E        fraction[k][j][z][i] *= c[(*alloc)[i][bit_alloc[k][i]].quant];a      }(      else fraction[k][j][z][i] = 0.0;       ;I    for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<3;j++) for(k = l; k < m; k++)        fraction[k][j][z][i] = 0.0; }                          void II_denormalize_sample(double (*fraction)[3][12][32], unsigned int (*scale_index)[3][32], frame_params *fr_ps, int x, int l, int m, int z)+        /*far*/                             g(                                                                                   {]
    int i,j,k;     int stereo = fr_ps->stereo;     int sblimit = fr_ps->sblimit;  2    for (i=0;i<sblimit;i++) for (j= l;j < m; j++) {=       fraction[j][0][z][i] *= multiple[scale_index[j][x][i]];i=       fraction[j][1][z][i] *= multiple[scale_index[j][x][i]]; =       fraction[j][2][z][i] *= multiple[scale_index[j][x][i]];/    } }       w void scale_factor_calc(unsigned int (*scalar)[3][32], int sblimit, int l, int m, int z, double (*sb_sample)[3][12][32])b#                                                               ;                                           /* (see above) */  {    int i,j, k,t;    double s[SBLIMIT];  [+   for (k = l; k< m; k++) for (t=0;t<3;t++) =   {oA    for (i=((z == 0) ? 0:(sb_groups[z-1]+1));i<=sb_groups[z];i++)      {? 	for (j=1, s[i] = mod(sb_sample[k][t][0][i]);j<SCALE_BLOCK;j++)** 		  if (mod(sb_sample[k][t][j][i]) > s[i])& 			 s[i] = mod(sb_sample[k][t][j][i]);    } bA     for (i=((z == 0) ? 0:(sb_groups[z-1]+1));i<=sb_groups[z];i++)s     { 8         for (j=SCALE_RANGE-1,scalar[k][t][i]=0;j>=0;j--) 		if (s[i] < multiple[j]) > 		{                       /* <= changed to <, 1992-11-06 shn*/'                    scalar[k][t][i] = j;s                    break;                  }n      }    } }         