G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) 0  * ISO 13818-3 MPEG-2 Audio Multichannel Encoder  *8  * $Id: musicin.c 1.9 1996/02/12 07:13:35 rowlands Exp $  *  * $Log: musicin.c $.  * Revision 1.9  1996/02/12 07:13:35  rowlands#  * Release following Munich meeting   *3  * Revision 1.6.2.1  1995/11/06  04:19:12  rowlands %  * Received from Uwe Felderhoff (IRT)   *.  * Revision 1.8  1995/08/14  07:57:11  tenkate0  * ML-LSF added Warner ten Kate 7/8/95 (Philips)  * debugging (whole packet) /  * obtain_params() and parse_args() cleaned up. F  * get_audio_ml() and Psycho_one_ml() only add odd frames upon LSF-ML.1  * II_smr() is called separately because of that. ,  * sample shifting is added because of that.  *.  * Revision 1.7  1995/07/31  07:49:58  tenkate<  * addition of phantom coding, at sevral lines, 25/07/95 WtK  *3  * Revision 1.4.3.1  1995/06/16  08:25:11  rowlands )  * Input from Sang Wook Kim (Samsung AIT)   *3  * Revision 1.4.2.1  1995/06/16  03:46:42  rowlands $  * Input from Susanne Ritscher (IRT)  *3  * Revision 1.4.1.4  1995/06/16  02:49:33  rowlands   * Added dematrix procedure 2   *E  * Added support for dematrix procedure 2, without predistortion yet. =  * Calculated the compatible stereo signal subband samples by C  * transforming the compatible signal used for the psychoacoustics, @  * instead of recalculating in the subband domain from the other  * channels.  *H  **********************************************************************/  G /********************************************************************** G  *   date   programmers         comment                               * G  * 3/01/91  Douglas Wong,       start of version 1.1 records          * G  *          Davis Pan                                                 * G  * 3/06/91  Douglas Wong,       rename: setup.h to endef.h            * G  *                              removed extraneous variables          * G  * 3/21/91  J.Georges Fritsch   introduction of the bit-stream        * G  *                              package. This package allows you      * G  *                              to generate the bit-stream in a       * G  *                              binary or ascii format                * G  * 3/31/91  Bill Aspromonte     replaced the read of the SB matrix    * G  *                              by an "code generated" one            * G  * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         * G  *                              Incorporated Jean-Georges Fritsch's   * G  *                              "bitstream.c" package.                * G  *                              Modified to strictly adhere to        * G  *                              encoded bitstream specs, including    * G  *                              "Berlin changes".                     * G  *                              Modified user interface dialog & code * G  *                              to accept any input & output          * G  *                              filenames desired.  Also added        * G  *                              de-emphasis prompt and final bail-out * G  *                              opportunity before encoding.          * G  *                              Added AIFF PCM sound file reading     * G  *                              capability.                           * G  *                              Modified PCM sound file handling to   * G  *                              process all incoming samples and fill * G  *                              out last encoded frame with zeros     * G  *                              (silence) if needed.                  * G  *                              Located and fixed numerous software   * G  *                              bugs and table data errors.           * G  * 27jun91  dpwe (Aware Inc)    Used new frame_params struct.         * G  *                              Clear all automatic arrays.           * G  *                              Changed some variable names,          * G  *                              simplified some code.                 * G  *                              Track number of bits actually sent.   * G  *                              Fixed padding slot, stereo bitrate    * G  *                              Added joint-stereo : scales L+R.      * G  * 6/12/91  Earle Jennings      added fix for MS_DOS in obtain_param  * G  * 6/13/91  Earle Jennings      added stack length adjustment before  * G  *                              main for MS_DOS                       * G  * 7/10/91  Earle Jennings      conversion of all float to FLOAT      * G  *                              port to MsDos from MacIntosh completed* G  * 8/ 8/91  Jens Spille         Change for MS-C6.00                   * G  * 8/22/91  Jens Spille         new obtain_parameters()               * G  *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           * G  *          Don H. Lee,                                               * G  *          Peter W. Farrett                                          * G  *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   * G  *                              newly introduced functions are        * G  *                              I_CRC_calc, II_CRC_calc and encode_CRC* G  *                              Additions and revisions are marked    * G  *                              with "dhl" for clarity                * G  *11/11/91 Katherine Wang       Documentation of code.                * G  *                                (variables in documentation are     * G  *                                surround by the # symbol, and an '*'* G  *                                denotes layer I or II versions)     * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  * 2/25/92  Masahiro Iwadare    made code cleaner and more consistent * G  *10 jul 92 Susanne Ritscher    Bug fix in main, scale factor calc.   * G  * 5 aug 92 Soren H. Nielsen    Printout of bit allocation.           * D  *19 aug 92 Soren H. Nielsen	Changed MS-DOS file name extensions.  *D  * 2 dec 92 Susanne Ritscher	Start of changes to multi-channel with*S  *                                                  several options   *										 * G  ********************************************************************** G  *                                                                    * G  *                                                                    * G  *  MPEG/audio Phase 2 coding/decoding multichannel                   * G  *                                                                    * G  *                                                                    * G  *  7/27/93        Susanne Ritscher,  IRT Munich                      * G  *                                                                    * B  *	                                                              *G  *  8/13/93        implemented channel-switching by changing          * G  *                 a lot in encode.c                                  * G  *                                                                    * G  *  8/27/93        Susanne Ritscher, IRT Munich                       * G  *                 Channel-Switching is working                       * G  *  9/1/93         Susanne Ritscher,  IRT Munich                      * G  *                 all channels normalized                            * G  *  9/20/93        channel-switching is only performed at a           * G  *                 certain limit of TC_ALLOC dB, which is included    **G  *                 in encoder.h                                       *nG  *  1/04/94        try get all the rubbish out!                       *$G  *                                                                    *nG  *                                                                    *gG  *  Version 1.0                                                       * G  *                                                                    * G  *  07/12/94       Susanne Ritscher,  IRT Munich                      *dG  *                                                                    * G  *  Version 1.1                                                       * G  *                                                                    * D  *  02/23/95	   Susanne Ritscher,  IRT Munich                      *G  *                 corrected some bugs                                **G  *                 extension bitstream is working                     *oG  *                                                                    *aG  *  Version 2.0                                                       */G  *                                                                    *sG  *  01/28/97       Frans de Bont, Philips Sound & Vision, Eindhoven   *e;  *		    - dynamic crosstalk working for all configurations*o;  *		    - prediction working for all configurations	      **-  *		    - extension bitstream fixed			      * ;  *		    - fully compliant to DIS 13818-3.2                **X  *                                                                    *				      *		    H  **********************************************************************/G /**********************************************************************vG  *                                                                    * D  *  06/06/95	   Yeon Bae Thomas Kim,  Samsung AIT                  *G  *                 ancillary data is working                          *eG  *                                                                    *dD  *  06/06/95	   Sang Wook Kim,  Samsung AIT                        *G  *                 corrected some bugs                                *oG  *                                                                    *iH  **********************************************************************/
 #ifdef MS_DOS  #include <dos.h> #endif #include "common.h"  #include "encoder.h" #include <math.h>   1 /* Global variable definitions for "musicin.c" */i   FILE               *musicin;A FILE               *musicin_ml;	/* 08/03/1995 JMZ Multilingual */  Bit_stream_struc   bs; Bit_stream_struc   bs_ext; Bit_stream_struc   bs_mpg;  char               *programName;1 int		   mesg_index=0; /* YBKim060695 ancillary */  int		   verbosity;  M char multilingual_file_name[MAX_NAME_SIZE];	/* 08/03/1995 JMZ Multilingual */n   /* Implementations */   I /************************************************************************  /* /* obtain_parameters /*E /* PURPOSE:  Prompts for and reads user input for encoding parameters  /*' /* SEMANTICS:  The parameters read are:  /* - input and output filenameseK /* - sampling frequency (if AIFF file, will read from the AIFF file header)t /* - layer numbern6 /* - mode (stereo, joint stereo, dual channel or mono)# /* - psychoacoustic model (I or II) , /* - total bitrate, irrespective of the modeH /* - de-emphasis, error protection, copyright and original or copy flags /*J /************************************************************************/   void obtain_parameters (  	frame_params *fr_ps, 
 	int *psy,  	long unsigned int *num_samples,# 	long unsigned int *num_samples_ml,n 	char *original_file_name, 	char *encoded_file_name,  	IFF_AIFF *pcm_aiff_data,o 	IFF_AIFF *pcm_aiff_data_ml, 	int *aiff,  	int *byte_per_sample, 	int *mat_mode,  	int *aug_mat_mode,e
 	int *cha_sw,  	int *aug_cha_sw,m 	char *encoded_file_name_ext,  	int *bit_rate,  	char *encoded_file_name_mpg, 
 	int *dyn_cr,* 	int *dyn_cr_LR, 	int *aug_dyn_cr,  	int *ancillaryUse,  	int *verbosity) { *     int j, bool, max_rate, max_rate_index;     long int i; :     int tot_channels = 0;		/* 21/03/1995 JMZ Multimode */ :     char configuration[50];	/* 21/03/1995 JMZ Multimode */     char t[50];t        layer *info = fr_ps->header;  ,     *aiff = 0;	 /* flag for AIFF-Soundfile*/ 	      do     { 9        printf ("Enter PCM input file name <required>: ");6!        gets (original_file_name);t.        if (original_file_name[0] == NULL_CHAR)5        printf ("PCM input file name is required.\n"); 1     } while (original_file_name[0] == NULL_CHAR);l  C     printf(">>> PCM input file name is: %s\n", original_file_name);   m=     if ((musicin = fopen (original_file_name, "rb")) == NULL)f     {6?        printf ("Could not find \"%s\".\n", original_file_name);a        exit (1);     }   M /***************************************************************************/ M /* 08/03/1995 Multi lingual extension JMZ                                  */   C     printf ("Do you have multi lingual channels? (Y)es, (<N>)o: ");0"     gets (multilingual_file_name);O     if ((*multilingual_file_name == 'Y') || (multilingual_file_name[0] == 'y'))d     {oZ 	printf ("Enter multilingual input file name <%s.%s>: ", original_file_name, DFLT_ML_EXT); 	gets (multilingual_file_name);d, 	if (multilingual_file_name[0] == NULL_CHAR) 	{ 	    printf ("Null char\n");O 	    strcat (strcpy (multilingual_file_name, original_file_name), DFLT_ML_EXT);f 	}B 	if ((musicin_ml = fopen (multilingual_file_name, "rb")) == NULL)  	{A 	    printf ("Could not find \"%s\".\n", multilingual_file_name);b 	    exit (1); 	}  2 	/*remplir fr_ps il y a au moins un multilingual*/M 	if (aiff_read_headers (musicin_ml, pcm_aiff_data_ml, byte_per_sample) == 0) o 	{@ 	    printf (">>> Using Audio IFF multilingual file headers\n");8 	    info->multiling_ch = pcm_aiff_data_ml->numChannels;H 	    printf (">>> Using %d multilingual channels\n",info->multiling_ch);6 	    *num_samples_ml = pcm_aiff_data_ml->numChannels *+ 			      pcm_aiff_data_ml->numSampleFrames;o 	}7 	else     /* Not using Audio IFF sound file headers. */r 	{T 	    printf ("***WARNING: Could not read AIFF header - No MultiLingual coding!!\n"); 	    info->multiling_ch = 0; 	}     }      else     {e( 	printf ("no multi lingual coding!!\n"); 	info->multiling_ch = 0;     }b  M /* 08/03/1995 Multi lingual extension JMZ                                  */eM /***************************************************************************/a 	 :     printf("Enter MPEG encoded output file name <%s%s>: ",  		original_file_name, DFLT_EXT);       gets (encoded_file_name);e  *     if (encoded_file_name[0] == NULL_CHAR)     {aK 	strcat (strcpy (encoded_file_name_ext, original_file_name), DFLT_EXT_EXT); C 	strcat (strcpy (encoded_file_name, original_file_name), DFLT_EXT);*F 	strcat (strcpy (encoded_file_name_mpg, encoded_file_name), DFLT_EXT);     }      else     { J 	strcat (strcpy (encoded_file_name_ext, encoded_file_name), DFLT_EXT_EXT);& 	strcat (encoded_file_name, DFLT_EXT);F 	strcat (strcpy (encoded_file_name_mpg, encoded_file_name), DFLT_EXT);     } L     printf(">>> MPEG encoded output file name is: %s\n", encoded_file_name);   <     open_bit_stream_w (&bs, encoded_file_name, BUFFER_SIZE);  sI     if (aiff_read_headers (musicin, pcm_aiff_data, byte_per_sample) == 0)      {    	*aiff = 1; 4 	printf(">>> Using Audio IFF sound file headers\n");  < /**********************************************************/ /* 21/03/1995 JMZ Multimode */  + 	tot_channels = pcm_aiff_data->numChannels;n8 	printf (">>> Using %d audio channels\n", tot_channels);  ; 	/********* 27/01/97, FdB, select LFE ********************/  	if (tot_channels > 1) 	{8 	    printf ("Do you want to use LFE coding? (y/<n>) "); 	    gets (t);$ 	    if ((*t == 'y') || (*t == 'Y')) 	    {' 		printf (">>> LFE coding is used.\n");i 		info->lfe = 1; 	    }  	 	    else  	    {$ 		printf (">>> No LFE coding.\n");	  		info->lfe = 0; 	    }	         }a   #ifdef Augmentation_7cho$ 	if (tot_channels - info->lfe == 7)  	{  	    if (info->multiling_ch > 0) 	    {L 		printf ("7.1 channel augmentation and multilingual cannot be combined\n"); 		exit (1);  	    } 	    fr_ps->stereomc = 3;i 	    fr_ps->stereoaug = 2; 	    fr_ps->lfe_pos = 3; 	    info->center = 1;   	    info->surround = 2;   	    fr_ps->config = 320; 0 	    printf (">>> Using 5/2 configuration.\n");  	} 	else  #endif$ 	if (tot_channels - info->lfe == 5)  	{ 	    fr_ps->stereomc = 3;  	    fr_ps->stereoaug = 0; 	    fr_ps->lfe_pos = 3;: 	    printf ("Which configuration do you want to use?\n");6 	    printf ("Available: 3/2 (<1>), 3/0 + 2/0 (2): "); 	    gets (configuration); 	    switch (*configuration)
     	    { 	    case '1':   		    info->center = 1;  		    info->surround = 2;  		    fr_ps->config = 320;1 		    printf (">>> Using 3/2 configuration.\n"); n 		    break; 	    case '2':   		    info->center = 1;  		    info->surround = 3;  		    fr_ps->config = 302;7 		    printf (">>> Using 3/0 + 2/0 configuration.\n");   		    break; 	    default:    		    info->center = 1;  		    info->surround = 2;  		    fr_ps->config = 320;9 		    printf (">>> Using default 3/2 configuration.\n");   		    break; 	    } 	}) 	else if (tot_channels - info->lfe == 4)   	{ 	    fr_ps->stereomc = 2;  	    fr_ps->stereoaug = 0;: 	    printf ("Which configuration do you want to use?\n");? 	    printf ("Available: 3/1 (<1>), 2/2 (2), 2/0 + 2/0 (3): ");  	    gets (configuration); 	    switch (*configuration)
     	    { 	    case '1':   		    info->center = 1;  		    info->surround = 1;  		    fr_ps->config = 310; 		    fr_ps->lfe_pos = 3;*1 		    printf (">>> Using 3/1 configuration.\n"); * 		    break; 	    case '2': * 		    info->center = 0;  		    info->surround = 2;  		    fr_ps->config = 220; 		    fr_ps->lfe_pos = 2; 1 		    printf (">>> Using 2/2 configuration.\n"); o 		    break; 	    case '3':   		    info->center = 0;  		    info->surround = 3;  		    fr_ps->config = 202; 		    fr_ps->lfe_pos = 2; 7 		    printf (">>> Using 2/0 + 2/0 configuration.\n"); / 		    break; 	    default:  I 		    info->center = 1;  		    info->surround = 1;  		    fr_ps->config = 310; 		    fr_ps->lfe_pos = 3; 9 		    printf (">>> Using default 3/1 configuration.\n");   		    break; 	    } 	}) 	else if (tot_channels - info->lfe == 3) * 	{ 	    fr_ps->stereoaug = 0;: 	    printf ("Which configuration do you want to use?\n");? 	    printf ("Available: 3/0 (<1>), 2/1 (2), 1/0 + 2/0 (3): ");i 	    gets (configuration); 	    switch (*configuration)
     	    { 	    case '1': 9 		    info->center = 1;  		    info->surround = 0;  		    fr_ps->config = 300; 		    fr_ps->stereomc = 1; 		    fr_ps->lfe_pos = 3; 1 		    printf (">>> Using 3/0 configuration.\n");   		    break; 	    case '2': i 		    info->center = 0;  		    info->surround = 1;  		    fr_ps->config = 210; 		    fr_ps->stereomc = 1; 		    fr_ps->lfe_pos = 2;*1 		    printf (">>> Using 2/1 configuration.\n"); a 		    break; 	    case '3': p 		    info->center = 0;  		    info->surround = 3;  		    fr_ps->config = 102; 		    fr_ps->stereomc = 2; 		    fr_ps->lfe_pos = 1;-7 		    printf (">>> Using 1/0 + 2/0 configuration.\n"); F 		    break; 	    default:  e 		    info->center = 1;  		    info->surround = 0;  		    fr_ps->config = 300; 		    fr_ps->stereomc = 1; 		    fr_ps->lfe_pos = 3; 9 		    printf (">>> Using default 3/0 configuration.\n"); g 		    break; 	    } 	}) 	else if (tot_channels - info->lfe == 2) * 	{ 	    fr_ps->config = 200;  	    fr_ps->stereomc = 0;  	    fr_ps->stereoaug = 0; 	    fr_ps->lfe_pos = 2; 	}) 	else if (tot_channels - info->lfe == 1) _ 	{ 	    if (info->lfe)e 	    {6 		printf ("single channel plus LFE not supported.\n"); 		exit (1);m 	    } 	    fr_ps->config = 100;* 	    fr_ps->stereomc = 0;_ 	    fr_ps->stereoaug = 0; 	} 	else_ 	{= 	    printf ("Channels = %d not supported.\n", tot_channels);_ 	    exit (1); 	}  0 	aiff_check (original_file_name, pcm_aiff_data);   /* 21/03/1995 JMZ Multimode */< /**********************************************************/    R         info->sampling_frequency = SmpFrqIndex ((long) pcm_aiff_data->sampleRate);W         printf (">>> %.f Hz sampling frequency selected\n", pcm_aiff_data->sampleRate);a  7         /* Determine number of samples in sound file */IS         *num_samples = pcm_aiff_data->numChannels * pcm_aiff_data->numSampleFrames;e   	if (info->multiling_ch > 0) 	{Z 	    switch (SmpFrqIndex ((long) pcm_aiff_data_ml->sampleRate) - info->sampling_frequency) 	    {7 	    case 16 : printf ("MultiLingual is LSF coded.\n");C 		      info->multiling_fs = 1;u 		      break;K 	    case  0 : printf ("MultiLingual sample rate equals that of Audio.\n");e 		      info->multiling_fs = 0;  		      break;g 	    default : printf ("***WARNING: MultiLingual sample rate does not equal (half) mc sample rate.\n");*? 	    	      printf ("            No MultiLingual coding!!!\n");  		      info->multiling_ch = 0;  		      break; 	    } /*switch*/n 	} /*if (ml_ch>0)*/i     }l     else6     {    /* Not using Audio IFF sound file headers. */& 	printf("no multichannel coding!!\n"); 	fr_ps->stereomc = 0;e 	fr_ps->stereoaug = 0; 	info->multiling_ch = 0;A         printf ("What is the sampling frequency? <48000>[Hz]: ");;         gets (t);a         i = atol(t);         switch (i) 	{2         case 48000 : info->sampling_frequency = 1;@ 	             printf (">>> %ld Hz sampling freq selected\n", i);
 		     break;}2         case 44100 : info->sampling_frequency = 0;9 		     printf (">>> %ld Hz sampling freq selected\n", i);n
 		     break;_2         case 32000 : info->sampling_frequency = 2;9 		     printf (">>> %ld Hz sampling freq selected\n", i);(
 		     break;_2         default:     info->sampling_frequency = 1;: 		     printf (">>> Default 48 kHz samp freq selected\n");	         }l  i.         if (fseek (musicin, 0, SEEK_SET) != 0) 	{B           printf ("Could not seek to PCM sound data in \"%s\".\n",&                   original_file_name);           exit (1);m	         }m  nF         /* Declare sound file to have "infinite" number of samples. */$         *num_samples = MAX_U_32_NUM;     }o  1     printf ("Which layer do you want to use?\n"); 3     printf ("Available: Layer (1), Layer (<2>): "); 
     gets (t);o     switch (*t)d     {"G     case '1': info->lay = 1; printf (">>> Using Layer %s\n", t); break;sG     case '2': info->lay = 2; printf (">>> Using Layer %s\n", t); break;*K     default : info->lay = 2; printf (">>> Using default Layer 2\n"); break;G     }d  D     printf ("Which mode do you want for the two front channels?\n");7     printf ("Available: (<s>)tereo, (j)oint stereo, ");=:     printf ("(d)ual channel, s(i)ngle Channel, n(o)ne: ");
     gets (t);_5     if (fr_ps->config < 200) /* compatible is mono */a     {g 	info->mode = MPG_MD_MONO; 	info->mode_ext = 0;* 	printf (">>> Using default mono mode\n");     }      else 	switch (*t) 	{
 	case 's':: 	case 'S': info->mode = MPG_MD_STEREO; info->mode_ext = 0;% 		  printf (">>> Using mode %s\n",t);;
 		  break;
 	case 'j':, 	case 'J': info->mode = MPG_MD_JOINT_STEREO;% 		  printf (">>> Using mode %s\n",t);d
 		  break;
 	case 'd':@ 	case 'D': info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext = 0;% 		  printf (">>> Using mode %s\n",t);i
 		  break;
 	case 'i':8 	case 'I': info->mode = MPG_MD_MONO; info->mode_ext = 0;% 		  printf (">>> Using mode %s\n",t);u
 		  break;
 	case 'o':8 	case 'O': info->mode = MPG_MD_NONE; info->mode_ext = 0;% 		  printf (">>> Using mode %s\n",t);t
 		  break;: 	default:  info->mode = MPG_MD_STEREO; info->mode_ext = 0;/ 		  printf (">>> Using default stereo mode\n");/
 		  break; 	}       *psy = DFLT_PSY;  "     if (info->mode == MPG_MD_MONO) 	max_rate_index = 10;u     else 	max_rate_index = 14;gP /*    max_rate_index = 6; */ /* 48 kHz => 96 kbps for multiple table testing */ 4     max_rate = bitrate[info->lay-1][max_rate_index];A     printf ("What is the total bitrate? <%u>[kbps]: ", DFLT_BRT); 
     gets (t);a     i = atol (t);t     if (i == 0) i = -10;
     j = 0;      while (j <= max_rate_index)      { ( 	if (bitrate[info->lay-1][j] == (int) i) 	    break;u 	j++;u     }o     if (j > max_rate_index)      {          if (i < max_rate)3	         {_ 	    if (DFLT_BRT <= max_rate) 	    { 	    	i = DFLT_BRT;e3 		printf (">>> Using default %u kbps\n", DFLT_BRT);f 	    }	 	    elsei 	    { 	       	i = max_rate;8 		printf (">>> Using max. bitrate %u kbps\n", max_rate); 	    } 	    for (j = 0; j < 15; j++) * 		if (bitrate[info->lay-1][j] == (int) i)  		{  		    info->bitrate_index = j; 		    break; 		}  	} 	else; 	{& 	    info->ext_bit_stream_present = 1; 	    *bit_rate = i;t 	    if (DFLT_BRT <= max_rate) 	    	i = DFLT_BRT; 	 	    else  	       	i = max_rate; 	    for (j = 0; j < 15; j++)r* 		if (bitrate[info->lay-1][j] == (int) i)  		{n 		    info->bitrate_index = j; 		    break; 		}aS 	    info->ext_length = ((*bit_rate - i) * 144) / s_freq[info->sampling_frequency];p3 	    printf (">>> Bitrate = %d kbps\n", *bit_rate);c 	}			        };     else     {           info->bitrate_index = j;D         printf (">>> Bitrate = %d kbps\n", bitrate[info->lay-1][j]);     }f  B     printf ("What type of de-emphasis should the decoder use?\n");I     printf ("Available: (<n>)one, (5)0/15 microseconds, (c)citt j.17: ");2
     gets (t);>,     if (*t != 'n' && *t != '5' && *t != 'c')     {y6         printf (">>> Using default no de-emphasis\n");         info->emphasis = 0;      }g     else     {n/         if (*t == 'n')      info->emphasis = 0; /         else if (*t == '5') info->emphasis = 1;o/         else if (*t == 'c') info->emphasis = 3; 2         printf (">>> Using de-emphasis %c\n", *t);     }u  i= /*  Start 2. Part changes for CD Ver 3.2; jsp; 22-Aug-1991 */=   =     printf ("Do you want to set the private bit? (y/<n>): "); 
     gets (t);=4     if (*t == 'y' || *t == 'Y') info->extension = 1;4     else                        info->extension = 0;:     if (info->extension) printf (">>> Private bit set\n");>     else                 printf (">>> Private bit not set\n");  c3 /*  End changes for CD Ver 3.2; jsp; 22-Aug-1991 */  	 7     printf ("Do you want error protection? (y/<n>): ");r
     gets (t);1>     if (*t == 'y' || *t == 'Y') info->error_protection = TRUE;?     else                        info->error_protection = FALSE;oG     if (info->error_protection) printf (">>> Error protection used\n");t6     else			printf (">>> Error protection not used\n"); 	t  6     printf ("Is the material copyrighted? (y/<n>): ");
     gets (t);u4     if (*t == 'y' || *t == 'Y') info->copyright = 1;4     else                        info->copyright = 0;?     if (info->copyright) printf (">>> Copyrighted material\n"); C     else                 printf (">>> Material not copyrighted\n");u  i/     printf ("Is this the original? (y/<n>): "); 
     gets (t);03     if (*t == 'y' || *t == 'Y') info->original = 1; 3     else                        info->original = 0;s;     if (info->original) printf (">>> Original material\n");	8     else	        printf (">>> Material not original\n");     :     /* Option for multichannel for matricing, 7/12/93,SR*/     if (*aiff == 1)      {lR         printf ("which kind of matrix do you want(<(-3, -3) = 0>;(-xx, -3) = 1;");. 	printf (" (-oo, -3) = 2; (-oo, -oo) = 3)  ");
 	gets (t);* 	if (strcmp (t,"") == 0) info->matrix = 0;  	else			info->matrix = atoi (t);4 	printf ("The matrix %d is chosen\n", info->matrix); 	*mat_mode = info->matrix;   #ifdef Augmentation_7chs3 	if (fr_ps->stereoaug == 2)  /* 7.1 channel mode */s 	{C 	    printf ("which kind of aug matrix do you want? (<0>; 1; 3) ");  	    gets (t);5 	    if (strcmp (t, "") == 0) info->aug_mtx_proc = 0;_. 	    else		     info->aug_mtx_proc = atoi (t);B 	    printf ("The aug matrix %d is chosen\n", info->aug_mtx_proc);( 	    *aug_mat_mode = info->aug_mtx_proc; 	} #endif  ; 	printf ("Do you want to have Channel-switching?(<y>/n) ");e
 	gets (t); 	if (*t == 'y' || *t == 'Y') 	    *cha_sw = *aug_cha_sw = 1;c  ' 	if (*cha_sw == 0 || info->matrix == 3)* 	{ 	    *cha_sw = 0;d1 	    printf ("Channel-switching is not used!\n");*I 	    printf ("Which mode of Channel-switching do you want? (not used) ");p 	    gets (t);' 	    printf("CHA mode: %d\n", *cha_sw);a 	} 	elseu 	{ 	    *cha_sw = 1;i. 	    printf ("Channel-switching is used\n");	  	    dos 	    {F 		printf ("Which mode of Channel-switching do you want? (-2 ... 7) "); 		gets (t);n 		*cha_sw = atoi (t); % 		printf ("CHA mode: %d\n", *cha_sw);c 		if (fr_ps->config == 320)f 		    bool = *cha_sw > 7;f5 		else if (fr_ps->config == 310 && info->matrix == 2)" 		    bool = *cha_sw > 5;n  		else if (fr_ps->config == 310) 		    bool = *cha_sw > 4;c  		else if (fr_ps->config == 220) 		    bool = *cha_sw > 3;iP 		else if (fr_ps->config == 300 || fr_ps->config == 302 || fr_ps->config == 210) 		    bool = *cha_sw > 2;s 		else 		    bool = *cha_sw > 0;  		if (bool)n| 		    printf ("!!! Channel-switching mode %d cannot be used together with Configuration: %d !!!\n", *cha_sw, fr_ps->config); 	    } while (bool); 	}   #ifdef Augmentation_7che3 	if (fr_ps->stereoaug == 2)  /* 7.1 channel mode */  	{5 	    if (*aug_cha_sw == 0 || info->aug_mtx_proc == 3)c 	    { 		*aug_cha_sw = 0;2 		printf ("Aug Channel-switching is not used!\n");J 		printf ("Which mode of Aug Channel-switching do you want? (not used) "); 		gets (t); , 		printf("Aug CHA mode: %d\n", *aug_cha_sw); 	    }	 	    elsec 	    { 		*aug_cha_sw = 1;/ 		printf ("Aug Channel-switching is used\n");	   		do 		{ N 		    printf ("Which mode of Aug Channel-switching do you want? (-1 ... 7) "); 		    gets (t);c 		    *aug_cha_sw = atoi (t); 1 		    printf ("Aug CHA mode: %d\n", *aug_cha_sw);	  > 		    if (info->aug_mtx_proc == 0 || info->aug_mtx_proc == -1) 			bool = *aug_cha_sw > 7;' 		    else if (info->aug_mtx_proc == 1)i 			bool = *aug_cha_sw > 3;
 		    else 			bool = *aug_cha_sw > 0;   		    if (bool)sY 		        printf ("!!! TCA7 mode %d cannot be used together with aug_mtx_proc: %d !!!\n",.% 				*aug_cha_sw, info->aug_mtx_proc);a 		} while (bool);t 	    } 	} 	else  #endif 	    *aug_cha_sw = 0;l  @ 	/********* 27/07/95, WtK , phantom coding ********************/2 	if ((fr_ps->stereomc > 0) && (info->center == 1)) 	{Q 	    printf ("Do you want to use Phantom Coding of the Center signal? (y/<n>) ");( 	    gets (t);$ 	    if ((*t == 'y') || (*t == 'Y')) 	    {+ 		printf (">>> Phantom Coding is used.\n");  		fr_ps->phantom_c = 1;; 	    } "	 	    elsea 	    {( 		printf (">>> No Phantom Coding.\n");	  		fr_ps->phantom_c = 0;a 	    }	         }e  C 	/********* 05/24/95, SR , dynamic cross_talk ********************/h; 	printf ("Do you want to have Dynamic Crosstalk?(y/<n>) ");r
 	gets (t); 	if (*t == 'y')  h 	{- 	    printf ("Dynamic Crosstalk is used!\n");_ 	    bool = 1; 	    do  	    {G 		printf ("Which mode of Dynamic Crosstalk do you want? (-1 ... 14) ");x 		gets (t);t 		*dyn_cr = atoi (t);o& 		printf ("DynX mode: %d\n", *dyn_cr);/ 		if (fr_ps->phantom_c && fr_ps->config == 320)_` 		    bool = ((*dyn_cr==9) || (*dyn_cr==10) || (*dyn_cr==11) || (*dyn_cr==12) || (*dyn_cr==14));N 		else if (fr_ps->phantom_c && ((fr_ps->config==310) || (fr_ps->config==220))) 		    bool = (*dyn_cr==4); 		else 		    bool = 0;P 		if (bool)Nj 		    printf ("!!! Dynamic Crosstalk mode %d cannot be used together with Phantom Coding !!!\n", *dyn_cr); 	    } while (bool);   #ifdef Augmentation_7chf7 	    if (fr_ps->stereoaug == 2)  /* 7.1 channel mode */s 	    { 		bool = 1;P 		do 		{iO 		    printf ("Which mode of Aug Dynamic Crosstalk do you want? (-1 ... 18) ");  		    gets (t);_ 		    *aug_dyn_cr = atoi (t); 2 		    printf ("Aug DynX mode: %d\n", *aug_dyn_cr); 		    bool = *aug_dyn_cr > 18;   		    if (bool)oR 			printf ("!!! Aug Dynamic Crosstalk mode %d cannot be used !!!\n", *aug_dyn_cr); 		} while (bool);= 	    } #endif 	} 6 	elseo 	{ 	    *dyn_cr = 0;g2 	    printf ("Dynamic Crosstalk is not used\n");	 I 	    printf ("Which mode of Dynamic Crosstalk do you want? (not used) ");  	    gets (t);) 	    printf ("DynX mode: %d\n", *dyn_cr);; #ifdef Augmentation_7chj7 	    if (fr_ps->stereoaug == 2)  /* 7.1 channel mode */] 	    { 	        *aug_dyn_cr = 0; K 		printf ("Which mode of Aug Dynamic Crosstalk do you want? (-1 ... 18) ");  		gets (t);i. 		printf ("Aug DynX mode: %d\n", *aug_dyn_cr); 	    } #endif 	}
 	bool = 1; 	do% 	{0 	    printf ("Value for dyn_cross_LR?(<0>/1) "); 	    gets (t); 	    *dyn_cr_LR = atoi (t);x. 	    bool = *dyn_cr_LR < -1 || *dyn_cr_LR > 1;   	    if (bool)L 		printf ("!!! dyn_cross_LR %d invalid value -1, 0 or 1 !!!\n", *dyn_cr_LR); 	} while (bool);+ 	printf ("dyn_cross_LR: %d\n", *dyn_cr_LR);b  B 	/********* 27/01/97, FdB, select prediction ********************/I 	if (fr_ps->stereomc > 0 && fr_ps->config != 202 && fr_ps->config != 102)( 	{; 	    printf ("Do you want to use MC prediction? (y/<n>) ");  	    gets (t);$ 	    if ((*t == 'y') || (*t == 'Y')) 	    {* 		printf (">>> MC prediction is used.\n"); 		info->mc_prediction_on = 1;c 	    }  	 	    else> 	    {' 		printf (">>> No MC prediction.\n");	   		info->mc_prediction_on = 0;  	    }	         }      }        /* YBKim060695 ancillary */s=     printf ("Do you want to use ancillary part ? (y:<n>): ");e
     gets (t); -     *ancillaryUse = (*t == 'y' || *t == 'Y');l.     printf ("Ancillary: %d\n", *ancillaryUse);  H     printf ("How verbose would you like the output ? (0, <1>, 2, 3): ");
     gets (t);n     if (*t >= '0' && *t <= '3')a 	*verbosity = atoi (t);m     else 	*verbosity = DFLT_VERB;/     printf ("Verbose level: %d\n", *verbosity);0  L     printf ("Do you wish to exit (last chance before encoding)? (y/<n>): ");
     gets (t);s     if (*t == 'y' || *t == 'Y')g
 	exit (1); }     I /************************************************************************1 /*
 /* parse_argsf /*B /* PURPOSE:  Sets encoding parameters to the specifications of the: /* command line.  Default settings are used for parameters% /* not specified in the command line.  /*D /* SEMANTICS:  The command line is parsed according to the following
 /* syntax: /*& /* -l  is followed by the layer number8 /* -m  is followed by the mode of the two front channels' /* -r  is followed by the sampling ratetA /* -b  is followed by the total bitrate, irrespective of the mode A /* -B  is followed by the MPEG1 bitrate, irrespective of the modeo' /* -d  is followed by the emphasis flago" /* -c  turns the copyright flag on! /* -o  turns the original flag on	) /* -e  turns the error_protection flag on;R /* -C  is followed by the configuration code "???" (front,rear,2ndstereo) channels /* -L  turns the LFE flag on  /* -x  is followed by the matrixC /* -k  is followed by a fixed tca value, or if '-1' a random value tL /* -y  is followed by the dynamic crosstalk mode, or if '-1' a random value  #ifdef Augmentation_7chu, /* -X  is followed by the 7.1-ch aug. matrixO /* -K  is followed by a fixed 7.1-ch aug. tca value, or if '-1' a random value  K /* -Y  is followed by the 7.1-ch aug. dynX mode, or if '-1' a random value r #endifH /* -w  sets phantom coding /* 27/07/95: '-p' already reserved for psy */ /* -g  sets MultiLingual codingo% /* -D  turns the dyn_cross_LR flag onR3 /* -P  turns the 'random prediction values' flag oni8 /* -n  is followed by the number of ancillary data bytes" /* -a  turns the ancillary flag on= /* -v  sets level of verbosity of debug and progress messagest /*F /* If the input file is in AIFF format, the sampling frequency is read /* from the AIFF header. /*G /* The input and output filenames are read into #inpath# and #outpath#.2 /*J /************************************************************************/    void! parse_args(int argc, char **argv,  	frame_params *fr_ps,n
 	int *psy,  	long unsigned int *num_samples,# 	long unsigned int *num_samples_ml,  	char *original_file_name, 	char *encoded_file_name,  	IFF_AIFF *pcm_aiff_data,a 	IFF_AIFF *pcm_aiff_data_ml, 	int *aiff,u 	int *byte_per_sample, 	int *mat_mode,) 	int *aug_mat_mode,*
 	int *cha_sw,= 	int *aug_cha_sw,w 	char *encoded_file_name_ext,h 	int *bit_rate,- 	char *encoded_file_name_mpg,w
 	int *dyn_cr,i 	int *dyn_cr_LR, 	int *aug_dyn_cr,n 	int *ancillaryUse,h 	int *verbosity) {w     FLOAT srate;1     int	 brate = DFLT_BRT;    /* MPEG1 bitrate */A      layer *info = fr_ps->header;     int   err = 0, bool, i = 0;p3     int   ml_present = 0; /* MultiLingual coding */           fr_ps->mnr_min = 0.0;a     *aiff = 0;0     *bit_rate = DFLT_BRT;    /* total bitrate */     fr_ps->phantom_c = 0;C     *verbosity = DFLT_VERB;	  (     /* preset defaults */ &     original_file_name[0] = NULL_CHAR;%     encoded_file_name[0] = NULL_CHAR;      info->lay = DFLT_LAY;      switch(DFLT_MOD)     {1A 	case 'r': info->mode = MPG_MD_STEREO; info->mode_ext = 0; break;	E 	case 'd': info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext=0; break;f3 	case 'j': info->mode = MPG_MD_JOINT_STEREO; break;_? 	case 'm': info->mode = MPG_MD_MONO; info->mode_ext = 0; break; L 	default : fprintf(stderr, "%s: Bad mode dflt %c\n", programName, DFLT_MOD);
 		  abort ();      },     *psy = DFLT_PSY;N     if ((info->sampling_frequency = SmpFrqIndex ((long) (1000*DFLT_SFQ))) < 0)     {hO         fprintf (stderr, "%s: bad sfrq default %.2f\n", programName, DFLT_SFQ);{         abort ();;     }n#     info->bitrate_index = DFLT_BRT;dG     if ((info->bitrate_index = BitrateIndex (info->lay, DFLT_BRT)) < 0)u     {;I 	fprintf (stderr, "%s: bad default bitrate %u\n", programName, DFLT_BRT);e
 	abort ();     }g     switch(DFLT_EMP)     {C% 	case 'n': info->emphasis = 0; break; % 	case '5': info->emphasis = 1; break;C% 	case 'c': info->emphasis = 3; break;)M 	default : fprintf (stderr, "%s: Bad emph dflt %c\n", programName, DFLT_EMP);m
 		  abort ();g     })     info->copyright = 0;     info->original = 0;g#     info->error_protection = FALSE;s        /* process args */"     while (++i < argc && err == 0)     {   	char c, *token, *arg, *nextArg; 	int  argUsed;    f 	token = argv[i];  	if (*token++ == '-')% 	{ 	    if (i+1 < argc) 	       nextArg = argv[i+1];	 	    elsec 	       nextArg = "";o      	    argUsed = 0;  	    while (c = *token++)  	    {# 		if (*token /* NumericQ(token) */)5 		   arg = token;i 		else 		   arg = nextArg;       		switch (c) 		{ & 		    case 'l':	info->lay = atoi(arg); 				argUsed = 1;' 				if (info->lay < 1 || info->lay > 2)< 				{(> 				   fprintf(stderr,"%s: -l layer must be 1 or 2, not %s\n", 					programName, arg);d 				   err = 1;  				}p
 				break;   		    case 'm':	argUsed = 1; 				if (*arg == 's'); 				    { info->mode = MPG_MD_STEREO; info->mode_ext = 0; }  				else if (*arg == 'd')2A 				    { info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext = 0; }y 				else if (*arg == 'j')s- 				    { info->mode = MPG_MD_JOINT_STEREO; }  				else if (*arg == 'm')i9 				    { info->mode = MPG_MD_MONO; info->mode_ext = 0; }{ 				else if (*arg == 'n')D9 				    { info->mode = MPG_MD_NONE; info->mode_ext = 0; }t	 				else   				{(@ 				    fprintf (stderr, "%s: -m mode must be s/d/j/m not %s\n", 						     programName, arg);	 				    err = 1; 				}|
 				break;  " 		    case 'r':	srate = atof(arg); 				argUsed = 1;# 				if ((info->sampling_frequency =_/ 				    SmpFrqIndex ((long) (1000*srate))) < 0)  				    err = 1;
 				break;  & 		    case 'b':	*bit_rate = atoi(arg); 				argUsed = 1; 				if (*bit_rate > brate) 				{e) 				    info->ext_bit_stream_present = 1; Z 				    info->ext_length = ((*bit_rate - brate) * 144) / s_freq[info->sampling_frequency]; 				}o 				else 				{	) 				    info->ext_bit_stream_present = 0;h 				    brate = *bit_rate; 				}o
 				break;  " 		    case 'B':	brate = atoi(arg); 				argUsed = 1; 				if (*bit_rate > brate) 				{e) 				    info->ext_bit_stream_present = 1;yZ 				    info->ext_length = ((*bit_rate - brate) * 144) / s_freq[info->sampling_frequency]; 				}, 				else) 				    info->ext_bit_stream_present = 0;}
 				break;  * 		    case 'C':	fr_ps->config = atoi(arg); 				argUsed = 1;
 				break;   		    case 'd':	argUsed = 1;( 				if (*arg == 'n')	info->emphasis = 0;- 				else if (*arg == '5')	info->emphasis = 1;"- 				else if (*arg == 'c')	info->emphasis = 3; 	 				else r 				{== 				    fprintf (stderr, "%s: -d emp must be n/5/c not %s\n",  						     programName, arg);D 				    err = 1; 				}a
 				break;  - 		    case 'c':   info->copyright = 1; break; - 		    case 'o':   info->original  = 1; break; 7 		    case 'e':   info->error_protection = TRUE; break;/  6 		    case 'x':	info->matrix = *mat_mode = atoi(arg); ( 		                if (info->matrix == 3) 				    *cha_sw = 0; 				argUsed = 1;
 				break;% 		    case 'k':	*cha_sw = atoi(arg); _ 				argUsed = 1;
 				break;.           	    case 'y':	*dyn_cr = atoi(arg);	 				argUsed = 1; 				break;		   i #ifdef Augmentation_7ch @ 		    case 'X':	info->aug_mtx_proc = *aug_mat_mode = atoi(arg); . 		                if (info->aug_mtx_proc == 3) 				    *aug_cha_sw = 0; 				argUsed = 1;
 				break;) 		    case 'K':	*aug_cha_sw = atoi(arg); ( 				argUsed = 1;
 				break;2           	    case 'Y':	*aug_dyn_cr = atoi(arg);	 				argUsed = 1; 				break;		   p #endif  		    case 'D':	*dyn_cr_LR = 1;	 				break;		     		    case 'L':	info->lfe = 1;	m 				break;		   *& 		    case 'w':	fr_ps->phantom_c = 1;	 				break;		   n, 		    case 'P':	info->mc_prediction_on = 1;	 				break;		   =  		    case 'g':	ml_present = 1;	 				break;		   U- 		    case 'n':	info->n_ad_bytes = atoi(arg);  				argUsed = 1;
 				break;" 		    case 'a':	*ancillaryUse = 1;
 				break;' 		    case 'v':	*verbosity = atoi(arg);  				argUsed = 1;
 				break;  9 		    default:    fprintf(stderr,"%s: unrec option %c\n",D8                                         programName, c);(                                 err = 1;
 				break; 		}i 	      	      		if (argUsed) 		{* 		    if (arg == token)*( 			token = "";		/* no more from token */
 		    else 			i++;		/* skip arg we used */r 		    arg = "";a 		    argUsed = 0; 		}l 	    } 	} 	elsen 	{, 	    if (original_file_name[0] == NULL_CHAR)' 		strcpy (original_file_name, argv[i]);c0 	    else if (encoded_file_name[0] == NULL_CHAR)& 		strcpy (encoded_file_name, argv[i]);	 	    elseb 	    {@ 		fprintf (stderr, "%s: excess arg %s\n", programName, argv[i]);
 		err = 1; 	    } 	}     }*  D     if ((info->bitrate_index = BitrateIndex (info->lay, brate)) < 0)	 	err = 1;d2     if (err || original_file_name[0] == NULL_CHAR) 	usage ();  /* never returns */f  o*     if (encoded_file_name[0] == NULL_CHAR)     {tK 	strcat (strcpy (encoded_file_name_ext, original_file_name), DFLT_EXT_EXT);oC 	strcat (strcpy (encoded_file_name, original_file_name), DFLT_EXT);sF 	strcat (strcpy (encoded_file_name_mpg, encoded_file_name), DFLT_EXT);     }l     else     {cJ 	strcat (strcpy (encoded_file_name_ext, encoded_file_name), DFLT_EXT_EXT);& 	strcat (encoded_file_name, DFLT_EXT);F 	strcat (strcpy (encoded_file_name_mpg, encoded_file_name), DFLT_EXT);     }i  =     if ((musicin = fopen (original_file_name, "rb")) == NULL)v     { 9 	printf ("Could not find \"%s\".\n", original_file_name); 
 	exit (0);     }e  <     open_bit_stream_w (&bs, encoded_file_name, BUFFER_SIZE);  I     if (aiff_read_headers (musicin, pcm_aiff_data, byte_per_sample) == 0)L     {o 	int wrong_nr_channels = 0;p   	*aiff = 1;s 	if (*verbosity >= 2)o9 	    printf (">>> Using Audio IFF sound file headers\n");t  0 	aiff_check (original_file_name, pcm_aiff_data);   	if (fr_ps->config)m 	{? 	    /* check if config and number of channels is consistent */e 	    switch (fr_ps->config)I 	    {B 		case 100:   wrong_nr_channels = pcm_aiff_data->numChannels != 1;  			    info->mode = MPG_MD_MONO; 			    info->mode_ext = 0;
 			    break;*N 		case 200:   wrong_nr_channels = pcm_aiff_data->numChannels - info->lfe != 2; 			    fr_ps->lfe_pos = 2;
 			    break;aN 		case 102:   wrong_nr_channels = pcm_aiff_data->numChannels - info->lfe != 3;  			    info->mode = MPG_MD_MONO; 			    info->mode_ext = 0; 			    info->surround = 3; u 			    fr_ps->stereomc = 2;t 			    fr_ps->lfe_pos = 1;
 			    break;hN 		case 202:   wrong_nr_channels = pcm_aiff_data->numChannels - info->lfe != 4; 			    info->surround = 3;   			    fr_ps->stereomc = 2;L 			    fr_ps->lfe_pos = 2;
 			    break;hN 		case 210:   wrong_nr_channels = pcm_aiff_data->numChannels - info->lfe != 3; 			    info->surround = 1;   			    fr_ps->stereomc = 1;r 			    fr_ps->lfe_pos = 2;
 			    break;=N 		case 220:   wrong_nr_channels = pcm_aiff_data->numChannels - info->lfe != 4; 			    info->surround = 2;   			    fr_ps->stereomc = 2;p 			    fr_ps->lfe_pos = 2;
 			    break;EN 		case 302:   wrong_nr_channels = pcm_aiff_data->numChannels - info->lfe != 5; 			    info->center = 1; L 			    info->surround = 3; T 			    fr_ps->stereomc = 3; 
 			    break;rN 		case 310:   wrong_nr_channels = pcm_aiff_data->numChannels - info->lfe != 4; 			    info->center = 1; f 			    info->surround = 1;   			    fr_ps->stereomc = 2;T 			    fr_ps->lfe_pos = 3;
 			    break;PN 		case 320:   wrong_nr_channels = pcm_aiff_data->numChannels - info->lfe != 5; 			    info->center = 1; F 			    info->surround = 2;   			    fr_ps->stereomc = 3;  			    fr_ps->lfe_pos = 3;
 			    break;  #ifdef Augmentation_7ch N 		case 520:   wrong_nr_channels = pcm_aiff_data->numChannels - info->lfe != 7; 			    if (ml_present) 			    {N 				printf ("7.1 channel augmentation and multilingual cannot be combined\n");
 				exit (1);f 			    } 			    fr_ps->config = 320;n 			    info->center = 1; t 			    info->surround = 2; D 			    fr_ps->stereomc = 3;g 			    fr_ps->stereoaug = 2; 			    fr_ps->lfe_pos = 3;
 			    break;c #endifJ 		default:    printf ("Configuration: %d not supported\n", fr_ps->config); 			    exit (1); 	    } 	} 	elsef 	{) 	    if (pcm_aiff_data->numChannels == 1)) 	    { 		fr_ps->config = 100; 		info->mode = MPG_MD_MONO;g 		info->mode_ext = 0;c 	    }	 	    else  	    {1 		switch (pcm_aiff_data->numChannels - info->lfe)  		{ " 		    case 2: fr_ps->config = 200; 			    fr_ps->lfe_pos = 2;
 			    break;i" 		    case 3: fr_ps->config = 210; 			    info->surround = 1;   			    fr_ps->stereomc = 1;  			    fr_ps->lfe_pos = 2;
 			    break; " 		    case 4: fr_ps->config = 310; 			    info->center = 1; k 			    info->surround = 1;   			    fr_ps->stereomc = 2;  			    fr_ps->lfe_pos = 3;
 			    break;n" 		    case 5: fr_ps->config = 320; 			    info->center = 1; | 			    info->surround = 2; 	 			    fr_ps->stereomc = 3;e 			    fr_ps->lfe_pos = 3;
 			    break;a #ifdef Augmentation_7ch1" 		    case 7: fr_ps->config = 320; 			    info->center = 1; ( 			    info->surround = 2; > 			    fr_ps->stereomc = 3;o 			    fr_ps->stereoaug = 2; 			    fr_ps->lfe_pos = 3;
 			    break;_ #endif% 		    default: wrong_nr_channels = 1;i 		}r 	    } 	} 		 	if (wrong_nr_channels)_ 	{Q 	    printf ("Configuration: %d lfe: %d do not match with audio channels: %d\n", >> 		     fr_ps->config,  info->lfe, pcm_aiff_data->numChannels); 	    exit (1); 	}   	switch (fr_ps->config)l 	{< 	    case 100:   printf (">>> Using 1/0 configuration.\n"); 	 			break;,< 	    case 200:   printf (">>> Using 2/0 configuration.\n"); 	 			break; B 	    case 102:   printf (">>> Using 1/0 + 2/0 configuration.\n"); 	 			break;rB 	    case 202:   printf (">>> Using 2/0 + 2/0 configuration.\n"); 	 			break; < 	    case 210:   printf (">>> Using 2/1 configuration.\n"); 	 			break;	< 	    case 220:   printf (">>> Using 2/2 configuration.\n"); 	 			break;1B 	    case 302:   printf (">>> Using 3/0 + 2/0 configuration.\n"); 	 			break;i< 	    case 310:   printf (">>> Using 3/1 configuration.\n"); 	 			break;e+ 	    case 320:   if (fr_ps->stereoaug == 0)o2 			    printf (">>> Using 3/2 configuration.\n");  #ifdef Augmentation_7ch( 			else 2 			    printf (">>> Using 5/2 configuration.\n");  #endif	 			break;n 	}  K 	info->sampling_frequency = SmpFrqIndex ((long) pcm_aiff_data->sampleRate);	 	if (*verbosity >= 2) 8 	    printf (">>> %.f Hz sampling frequency selected\n",! 		    pcm_aiff_data->sampleRate);   0 	/* Determine number of samples in sound file */ #ifndef MS_DOS, 	*num_samples = pcm_aiff_data->numChannels *( 		       pcm_aiff_data->numSampleFrames; #else 5 	*num_samples = (long) (pcm_aiff_data->numChannels) * ?                        (long) (pcm_aiff_data->numSampleFrames);	 #endif   	if (*cha_sw > 0)  	{ 	    if (fr_ps->config == 320) 		bool = *cha_sw > 7;n8 	    else if (fr_ps->config == 310 && info->matrix == 2) 		bool = *cha_sw > 5; # 	    else if (fr_ps->config == 310)T 		bool = *cha_sw > 4;a# 	    else if (fr_ps->config == 220)o 		bool = *cha_sw > 3; S 	    else if (fr_ps->config == 300 || fr_ps->config == 302 || fr_ps->config == 210)  		bool = *cha_sw > 2;i	 	    else	 		bool = 1;;   	    if (bool) 	    {x 		printf ("!!! Channel-switching mode %d cannot be used together with Configuration: %d !!!\n", *cha_sw, fr_ps->config); 		exit (1);* 	    } 	} #ifdef Augmentation_7ch  	if (*aug_cha_sw > 0)t 	{= 	    if (info->aug_mtx_proc == 0 || info->aug_mtx_proc == -1); 		bool = *aug_cha_sw > 7;s& 	    else if (info->aug_mtx_proc == 1) 		bool = *aug_cha_sw > 3; 	 	    elsey 		bool = 1;r   	    if (bool) 	    {Q 		printf ("!!! TCA7 mode %d cannot be used together with aug_mtx_proc: %d !!!\n",a$ 			*aug_cha_sw, info->aug_mtx_proc); 		exit (1);a 	    } 	} #endif 	if (*dyn_cr > 0)a 	{ 	    if (fr_ps->config == 320) 		bool = *dyn_cr > 14;; 	    else if (fr_ps->config == 310 || fr_ps->config == 220)  		bool = *dyn_cr > 4;oS 	    else if (fr_ps->config == 300 || fr_ps->config == 302 || fr_ps->config == 210)s 		bool = *dyn_cr > 1; 	 	    else	 	    	bool = 1;(   	    if (bool) 	    {n 		printf ("!!! Dynamic Crosstalk mode %d cannot be used for Configuration: %d !!!\n", *dyn_cr, fr_ps->config); 		exit (1);, 	    } 	     # 	    if (!bool && fr_ps->phantom_c)r 	    { 	    	if (fr_ps->config == 320))` 		    bool = ((*dyn_cr==9) || (*dyn_cr==10) || (*dyn_cr==11) || (*dyn_cr==12) || (*dyn_cr==14));  		else if (fr_ps->config == 310) 		    bool = (*dyn_cr==4);   		if (bool)} 		{s 		    printf ("!!! Dynamic Crosstalk mode %d cannot be used together with Phantom Coding for Configuration: %d!!!\n", *dyn_cr, fr_ps->config); 		    exit (1);e 		}e 	    } 	}   #ifdef Augmentation_7ch	 	if (*aug_dyn_cr > 18) 	{T 	    printf ("!!! Aug Dynamic Crosstalk mode %d cannot be used !!!\n", *aug_dyn_cr); 	    exit (1); 	} #endif     }l     else     { . 	/* Not using Audio IFF sound file headers. */    U 	if (*verbosity >= 2)*+ 	    printf(" NO MULTICHANNEL CODING!!\n");n 	ml_present = 0;  ' 	if (fseek (musicin, 0, SEEK_SET) != 0)a 	{S 	    printf  ("Could not seek to PCM sound data in \"%s\".\n", original_file_name);l 	    exit (0); 	}  s? 	/* Declare sound file to have "infinite" number of samples. */T 	*num_samples = MAX_U_32_NUM;c     }a  Q     /***************************************************************************/dQ     /* 7/8/95 Multi lingual extension WtK                                      */        if (ml_present)      {mK 	strcat (strcpy (multilingual_file_name, original_file_name), DFLT_ML_EXT); B 	if ((musicin_ml = fopen (multilingual_file_name, "rb")) == NULL)  	{Y 	    printf ("Could not find \"%s\".\nNo MultiLingual Coding\n", multilingual_file_name);n 	    info->multiling_ch = 0; 	}R 	else if (aiff_read_headers (musicin_ml, pcm_aiff_data_ml, byte_per_sample) == 0)  	{ 	    if (*verbosity >= 2) = 		printf (">>> Using Audio IFF multilingual file headers\n");,8 	    info->multiling_ch = pcm_aiff_data_ml->numChannels; 	    if (*verbosity >= 2)hF 		printf (">>> Using %d multilingual channels\n", info->multiling_ch);6 	    *num_samples_ml = pcm_aiff_data_ml->numChannels *+ 			      pcm_aiff_data_ml->numSampleFrames;i 	}7 	else     /* Not using Audio IFF sound file headers. */a 	{V 	    printf("***WARNING: Could not read ML AIFF header - No MultiLingual coding!!\n"); 	    info->multiling_ch = 0; 	}   	if (info->multiling_ch > 0) 	{Z 	    switch (SmpFrqIndex ((long) pcm_aiff_data_ml->sampleRate) - info->sampling_frequency) 	    {" 		case 16 :   if (*verbosity >= 2), 				printf ("MultiLingual is LSF coded.\n"); 			    info->multiling_fs = 1;
 			    break;-" 		case  0 :   if (*verbosity >= 2)@ 				printf ("MultiLingual sample rate equals that of Audio.\n"); 			    info->multiling_fs = 0;
 			    break; ` 		default :   printf ("***WARNING: MultiLingual sample rate unequals (half) mc sample rate.\n");A        			    printf ("            No MultiLingual coding!!!\n");k 			    info->multiling_ch = 0;
 			    break;d 	    } /*switch*/i 	} /*if (ml_ch>0)*/      }s     else     {	 	info->multiling_ch = 0;     } /* if (ml_present) */   Q     /* 7/8/95 Multi lingual extension WtK                                      */lQ     /***************************************************************************/t }o  I /************************************************************************m /* /* print_config! /*0 /* PURPOSE:  Prints the encoding parameters used /*J /************************************************************************/    voidt print_config (frame_params *fr_ps, int *psy, long unsigned int *num_samples, char *inPath, char *outPath, int *aiff) {n      layer *info = fr_ps->header;   )     printf ("Encoding configuration:\n");      if (*aiff == 1)_9 	printf ("Layer=%s   mode=%s   extn=%d   psy model=%d\n",h: 	        layer_names[info->lay-1], mode_names[info->mode], 	        info->mode_ext, *psy);t     else: 	printf ("Layer=%s   mode=%s   extn=%d    psy model=%d\n",: 	        layer_names[info->lay-1], mode_names[info->mode], 	        info->mode_ext, *psy);   !     if (info->bitrate_index != 0)s     {o7 	if (bitrate[info->lay-1][info->bitrate_index] == 1000)dC 	    printf ("samp frq=%.1f kHz   total bitrate=dynamic bitrate\n",>( 		    s_freq[info->sampling_frequency]); 	else{; 	    printf ("samp frq=%.1f kHz   mpeg1 bitrate=%d kbps\n",-' 		    s_freq[info->sampling_frequency],O1 		    bitrate[info->lay-1][info->bitrate_index]); " 	if (info->ext_bit_stream_present)i 	    printf ("ext bitrate=%d kbps\n", (int) (info->ext_length * s_freq[info->sampling_frequency] / 144));	     }e       if (info->multiling_ch > 0)f     {oA         printf ("%d multilingual channels ", info->multiling_ch);;$         if (info->multiling_fs == 1) 	    printf ("LSF coded.\n");n         else* 	    printf ("full sample rate coded.\n");     }=     else& 	printf ("No multilingual coding.\n");  ?     printf ("de-emph=%d   c/right=%d   orig=%d   errprot=%d\n", <             info->emphasis, info->copyright, info->original,$             info->error_protection);X     printf ("matrix=%d  center=%d  surround=%d  stereo=%d  stereomc=%d  stereoaug=%d\n",7             info->matrix, info->center, info->surround,o7 	    fr_ps->stereo, fr_ps->stereomc, fr_ps->stereoaug);;G     printf ("input file: '%s'   output file: '%s'\n", inPath, outPath);      fflush (stdout); }n  hI /************************************************************************i /* /* maind /*: /* PURPOSE:  MPEG I Encoder supporting layers 1 and 2, and> /* psychoacoustic models 1 (MUSICAM) and 2 (AT&T),now portatedE /* to multichannel (two front channels, one center and three surround G /* channels. There are different possibilities to code the AIFF-signal, @ /* like coding only the surround channels or the front channels,; /* different bitrates for front and surropund channels etc.f /* dec1992 sr. /*E /* SEMANTICS:  One overlapping frame of audio of up to 2 channels are . /* processed at a time in the following order:+ /* (associated routines are in parentheses)s /*6 /* 1.  Filter sliding window of data to get 32 subband /* samples per channel.:" /* (window_subband,filter_subband) /*< /* 2.  If joint stereo mode, combine left and right channels  /* for subbands above #jsbound#. /* (*_combine_LR)  /*< /* 3.  Calculate scalefactors for the frame, and if layer 2,1 /* also calculate scalefactor select information.i /* (*_scale_factor_calc) /*= /* 4.  Calculate psychoacoustic masking levels using selected= /* psychoacoustic model. /* (*_Psycho_One, psycho_anal) /*= /* 5.  Perform iterative bit allocation for subbands with low 9 /* mask_to_noise ratios using masking levels from step 4.c /* (*_main_bit_allocation) /*= /* 6.  If error protection flag is active, add redundancy forl /* error protection. /* (*_CRC_calc)  /*@ /* 7.  Pack bit allocation, scalefactors, and scalefactor select( /* information (layer 2) onto bitstream.> /* (*_encode_bit_alloc,*_encode_scale,II_transmission_pattern) /*5 /* 8.  Quantize subbands and pack them into bitstream . /* (*_subband_quantization, *_sample_encoding) /*J /************************************************************************/  
 #ifdef MS_DOSc  extern unsigned _stklen = 16384; #endif  ' typedef double JSBS[2][3][12][SBLIMIT];i6 typedef double IN[14][HAN_SIZE];		/* JMZ 08/03/1995 */B typedef unsigned int SUB[14][3][12][SBLIMIT]; /* JMZ 08/03/1995 */ typedef double SAM[12];  typedef unsigned int LSB[12];t   main (int argc, char **argv) {t?     double  sb_sample[14][3][12][SBLIMIT];	/* JMZ 08/03/1995 */      JSBS    *j_sample;     IN	    *win_que;     SUB	    *subband;e     SAM	    *lfe_sample;     LSB	    *lfe_sbband;  >     frame_params fr_ps;=     layer info;    )+     char original_file_name[MAX_NAME_SIZE];b*     char encoded_file_name[MAX_NAME_SIZE];.     char encoded_file_name_ext[MAX_NAME_SIZE];.     char encoded_file_name_mpg[MAX_NAME_SIZE];0     double *win_buf[14];				/* JMZ 08/03/1995 */=     static double buffer[14][1152];			/* JMZ 08/03/1995 */			=6     double spiki[14][SBLIMIT];				/* JMZ 08/03/1995 */u     static unsigned int bit_alloc[14][SBLIMIT], scfsi[14][SBLIMIT], scfsi_dyn[14][SBLIMIT];						/* JMZ 08/03/1995 */ d     static unsigned int scalar[14][3][SBLIMIT], j_scale[2][3][SBLIMIT],  scalar_dyn[14][3][SBLIMIT];{     static double ltmin[14][SBLIMIT], lgmin[14][SBLIMIT], max_sc[14][SBLIMIT], smr[14][SBLIMIT];							/* JMZ 08/03/1995 */c  "     static unsigned int lfe_alloc;$     static unsigned int lfe_scalar;        FLOAT snr32[32];1     short sam[14][1056];					/* JMZ 08/03/1995 */ 8     double buffer_matr[14][1152];			/* JMZ 08/03/1995 */"     int whole_SpF, extra_slot = 0;3     double avg_slots_per_frame, frac_SpF, slot_lag;a=     int model, stereo, error_protection, stereomc, stereoaug;e3     static unsigned int crc, crcmc, crcaug, crcext;y&     int i, j, k, adb, p, l, m, lfe, s;=     unsigned long bitsPerSlot, samplesPerFrame, frameNum = 0; *     unsigned long frameBits, sentBits = 0;     unsigned long num_samples;R     unsigned long num_samples_ml;	               /* 08/03/1995 JMZ Multilingual */~     int odd_ml = 1;                                    /* LSF MultiLingual: audio inputting only at odd frames , WtK 7/8/95 */     int ml_eof = 0;                                    /* MultiLingual: frame loop stops if either audio or ML-file has been exhausted , WtK 7/8/95 */       IFF_AIFF aiff_ptr;R     IFF_AIFF aiff_ptr_ml;	                       /* 08/03/1995 JMZ Multilingual */Y     int aiff = 0;                                      /* misused to indicate mc-input */p     int byte_per_sample = 0;       int mat_mode = 0;m     int aug_mat_mode = 0;T     int cha_sw = -2;     int aug_cha_sw = 0;u     int dyn_cr = 0;=     int dyn_cr_LR = 0;     int aug_dyn_cr = 0;.     int predis = 0;i     int bit_rate = 0;e      unsigned int crc_buffer[15];       int lfe_bits = 0;r     int sentBits1, frameBits1;     int hi,  hu,  ho;p   /*    char *blubb = "rm ";*/	t6     char blubb[128];	/* Corrected BUG JMZ 29/03/1995*/  7     int  ancillaryUse = 0;  /* YBKim060695 ancillary */l        #ifdef  PRINTOUT(     int       loop_channel,loop_subband;     5     al_table  *loop_alloc; /* a pointer to a table */p7     sb_alloc  loop_struct; /* a structure of 4 int's */fD     alloc_ptr loop_str_ptr; /* a pointer to an sb_alloc structure */     float     loop_bits; #endif   #ifdef  MACINTOSHd,     console_options.nrows = MAC_WINDOW_SIZE;     argc = ccommand(&argv);i #endif       program_information();  >     /* Most large variables are declared dynamically to ensure-        compatibility with smaller machines */   A     j_sample = (JSBS *) mem_alloc (sizeof (JSBS), "j_sample");   c  ?     win_que = (IN *) mem_alloc (sizeof (IN), "Win_que");        A     subband = (SUB *) mem_alloc (sizeof (SUB),"subband");        q  @     lfe_sample = (SAM *) mem_alloc (sizeof (SAM), "lfe_sample");?     lfe_sbband = (LSB *) mem_alloc (sizeof (LSB),"lfe_sbband");   q     /* clear buffers */e1     memset ((char *) buffer, 0, sizeof (buffer));L7     memset ((char *) bit_alloc, 0, sizeof (bit_alloc));	1     memset ((char *) scalar, 0, sizeof (scalar));*3     memset ((char *) j_scale, 0, sizeof (j_scale));;/     memset ((char *) scfsi, 0, sizeof (scfsi));u/     memset ((char *) ltmin, 0, sizeof (ltmin)); /     memset ((char *) lgmin, 0, sizeof (lgmin));*1     memset ((char *) max_sc, 0, sizeof (max_sc)); /     memset ((char *) snr32, 0, sizeof (snr32));*+     memset ((char *) sam, 0, sizeof (sam));c  i     fr_ps.header = &info;      info.mode_ext = 0;9     fr_ps.tab_num = -1;             /* no table loaded */*     fr_ps.tab_num_mc = -1;     fr_ps.tab_num_ml = -1;     fr_ps.alloc = NULL;l     fr_ps.alloc_mc = NULL;     fr_ps.alloc_ml = NULL;  !     info.version = MPEG_AUDIO_ID;      info.bitrate_index = 0;fD     info.lfe = 0;	    /* no low frequency effect channel present! */     info.center = 0; d     info.surround = 0;         info.multiling_ch  = 0;m     info.multiling_fs  = 0;      info.multiling_lay = 0;        info.matrix = 0; #ifdef Augmentation_7ch      info.aug_mtx_proc = 0; #endif$     info.ext_bit_stream_present = 0;      info.n_ad_bytes = DFLT_NADB;     info.audio_mix = 0;t/     info.dyn_cross_LR = 0;    /* C out of Lo */[&     info.mc_prediction_on = 0;	            info.ext_length = 0;     info.ext_bit = 0;i     info.copy_ident_bit = 0;     info.copy_ident_start = 0;       fr_ps.config = 0;1     fr_ps.phantom_c = 0;     fr_ps.stereomc = 0;f     fr_ps.stereoaug = 0;       programName = argv[0];3     if (argc == 1)			    /* no command-line args */nV 	obtain_parameters (&fr_ps, &model, &num_samples, &num_samples_ml, original_file_name,K 			   encoded_file_name, &aiff_ptr, &aiff_ptr_ml, &aiff, &byte_per_sample,  5 			   &mat_mode, &aug_mat_mode, &cha_sw, &aug_cha_sw,i> 			   encoded_file_name_ext, &bit_rate, encoded_file_name_mpg,C 			   &dyn_cr, &dyn_cr_LR, &aug_dyn_cr, &ancillaryUse, &verbosity);"     elsea         parse_args(argc, argv, &fr_ps, &model, &num_samples, &num_samples_ml, original_file_name,dK 			   encoded_file_name, &aiff_ptr, &aiff_ptr_ml, &aiff, &byte_per_sample, a5 			   &mat_mode, &aug_mat_mode, &cha_sw, &aug_cha_sw,m> 			   encoded_file_name_ext, &bit_rate, encoded_file_name_mpg,C 			   &dyn_cr, &dyn_cr_LR, &aug_dyn_cr, &ancillaryUse, &verbosity);        hdr_to_frps (&fr_ps);e  &     if (aiff != 1) fr_ps.stereomc = 0;  /     print_config (&fr_ps, &model, &num_samples,P2 		  original_file_name, encoded_file_name, &aiff);        stereo = fr_ps.stereo;     stereomc = fr_ps.stereomc;      stereoaug = fr_ps.stereoaug;     lfe = info.lfe;l-     error_protection = info.error_protection;(  ID     if (info.lay == 1) { bitsPerSlot = 32; samplesPerFrame = 384;  }D     else               { bitsPerSlot = 8;  samplesPerFrame = 1152; }5     /* Figure average number of 'slots' per frame. */l>     /* Bitrate means TOTAL for both channels, not per side. */J     if (bit_rate == 0) bit_rate = bitrate[info.lay-1][info.bitrate_index];<     if (verbosity >= 2) printf("bit_rate = %d\n", bit_rate);     fflush(stderr);  i   X     avg_slots_per_frame = ((double) samplesPerFrame / s_freq[info.sampling_frequency]) *0 			  ((double) bit_rate / (double) bitsPerSlot);  R     whole_SpF = (int) avg_slots_per_frame;	 /* Bytes per frame within datastream*/     if (verbosity >= 2)s* 	printf ("slots/frame = %d\n", whole_SpF);9     frac_SpF  = avg_slots_per_frame - (double) whole_SpF;,     slot_lag  = -frac_SpF;     if (verbosity >= 2)tA 	printf("frac SpF=%.3f, tot bit_rate=%d kbps, s freq=%.1f kHz\n",hE                 frac_SpF, bit_rate, s_freq[info.sampling_frequency]);(  s     if (frac_SpF != 0)     {5 	if (verbosity >= 2)? 	    printf ("Fractional number of slots, padding required\n");n     }n     else 	info.padding = 0;   #ifdef PRINTOUT)     if (verbosity >= 3)t     {f 	printf ("\nFrame ");n? 	for (loop_subband = 0; loop_subband < SBLIMIT; loop_subband++)c! 	    printf ("%3d",loop_subband);  	printf ("\n");t     }f #endif  a     while ( J              ( get_audio (musicin, buffer, num_samples, stereo, &aiff_ptr,H 	                  stereomc, stereoaug, &fr_ps, &aiff, &byte_per_sample,( 	                  buffer_matr) > 0 ) && 	     ( !ml_eof )* 	  )     {*C 	/****************************************************************/ C 	/*                                                              */ C 	/*                  START OF FRAME LOOP                         */nC 	/*                                                              */SC 	/****************************************************************/g  M 	/* the following allocation must happen within the while-loop. 1/5/93, SR */S 	  j 	if (mat_mode == -1) 	{4 	    if (fr_ps.config == 320 || fr_ps.config == 310) 		info.matrix = rand () % 4;	 	    else_ 	    { 		info.matrix = rand () % 3; 		if (info.matrix == 2)m 		    info.matrix++; 	    } 	} 	else_ 	    info.matrix = mat_mode;   	init_mc_pred (&fr_ps);N 	info.tc_sbgr_select = 1;d 	info.dyn_cross_on = 0;  E? 	if (dyn_cr != 0 || fr_ps.config == 302 || fr_ps.config == 202)d 	    if (dyn_cr_LR == -1)*" 		info.dyn_cross_LR = rand () % 2;	 	    elseL  		info.dyn_cross_LR = dyn_cr_LR; 	elsec 	    info.dyn_cross_LR = 0;B   #ifdef Augmentation_7ch  	if (aug_mat_mode == -1) 	{% 	    info.aug_mtx_proc = rand () % 3;e  	    if (info.aug_mtx_proc == 2) 		info.aug_mtx_proc++; 	} 	else[& 	    info.aug_mtx_proc = aug_mat_mode;   	info.aug_dyn_cross_on = 0;    _ 	info.aug_future_ext = 0;L #endif 	for (i = 0; i < 12; i++)  	{ 	    info.tc_alloc[i] = 0; 	    info.dyn_cross[i] = 0; # 	    info.dyn_second_stereo[i] = 0;  #ifdef Augmentation_7ch	 	    info.aug_tc_alloc[i] = 0; 	    info.aug_dyn_cross[i] = 0;J #endif 	} 	/ 	lfe_alloc = 0;p   L 	if (stereomc > 0 && (fr_ps.header->center == 1 || fr_ps.header->center==3)) 	{8 	    if (fr_ps.phantom_c == 1) fr_ps.header->center = 3;8 	    if (fr_ps.phantom_c == 0) fr_ps.header->center = 1; 	}            if (verbosity >= 1)i 	{. 	    fprintf (stderr, "{%4lu}\r", frameNum++); 	    fflush (stderr);r 	}   	win_buf[0] = &buffer[0][0]; 	win_buf[1] = &buffer[1][0]; 	win_buf[2] = &buffer[2][0]; 	win_buf[3] = &buffer[3][0]; 	win_buf[4] = &buffer[4][0]; 	win_buf[5] = &buffer[5][0]; 	win_buf[6] = &buffer[6][0];> 	win_buf[7] = &buffer[7][0];	/* JMZ 08/03/1995 Multilingual */> 	win_buf[8] = &buffer[8][0];	/* JMZ 08/03/1995 Multilingual */> 	win_buf[9] = &buffer[9][0];	/* JMZ 08/03/1995 Multilingual */@ 	win_buf[10] = &buffer[10][0];	/* JMZ 08/03/1995 Multilingual */@ 	win_buf[11] = &buffer[11][0];	/* JMZ 08/03/1995 Multilingual */@ 	win_buf[12] = &buffer[12][0];	/* JMZ 08/03/1995 Multilingual */@ 	win_buf[13] = &buffer[13][0];	/* JMZ 08/03/1995 Multilingual */           if (frac_SpF != 0) 	{% 	    if (slot_lag > (frac_SpF - 1.0))w 	    { 	        slot_lag -= frac_SpF; 	        extra_slot = 0; 	        info.padding = 0; 	        if (verbosity >= 2). 		    printf ("No padding for this frame\n");  	    }	 	    elsen 	    { 	        extra_slot = 1; 	        info.padding = 1;" 	        slot_lag += (1-frac_SpF); 	    }	         } . 	adb = (whole_SpF + extra_slot) * bitsPerSlot; 	if (verbosity >= 2)! 	    printf ("Adb0: %ld\n", adb);T  L /**************************************************************************/. /* 08/03/1995 JMZ Multilingual , WtK 7/8/95 */   	if (info.multiling_ch > 0)* 	{ 	    if (odd_ml) 	    {K 		if (get_audio_ml (musicin_ml, buffer, num_samples_ml, &aiff_ptr, &fr_ps,  F 				  &aiff, &byte_per_sample,buffer_matr) != 1152*info.multiling_ch ) 		{= 		    if (verbosity >= 2) / 			printf("\nHit end of MultiLingual file.\n");  		    ml_eof = 1;r 		}n 	c 		for (i = 0; i < 3; i++)a 		    for (j = 0; j < 12; j++)/ 			for (k = 7; k < 7 + info.multiling_ch; k++) J 			{: 			    window_subband (&win_buf[k], &(*win_que)[k][0], k);D 			    filter_subband (&(*win_que)[k][0], &(sb_sample)[k][i][j][0]); 			} 		if (info.multiling_fs == 1)pL 		    ml_sb_sample_swap (7, 7 + info.multiling_ch, sb_sample); /* half fs */ 	    }	 	    else(; 		ml_sb_sample_shift (7, 7 + info.multiling_ch, sb_sample);t 	}  ! /* 08/03/1995 JMZ Multilingual */ L /**************************************************************************/             switch (info.lay) 	         {(  aJ /***************************** Layer I **********************************/  (         case 1: for (j = 0; j < 12; j++)" 		    for (k = 0; k < stereo; k++) 		    { 6 			window_subband (&win_buf[k], &(*win_que)[k][0], k);E 			filter_subband (&(*win_que)[k][0], &(/***/sb_sample)[k][0][j][0]);                      },  2 		I_scale_factor_calc (sb_sample, scalar, stereo);/ 		if (fr_ps.actual_mode == MPG_MD_JOINT_STEREO)  		{ * 		    I_combine_LR (sb_sample, *j_sample);6 		    I_scale_factor_calc (/***/sb_sample, scalar, 1); 		}      % 		put_scale (scalar, &fr_ps, max_sc);l     / 		I_Psycho_One (buffer, max_sc, ltmin, &fr_ps);o     9 		I_main_bit_allocation (ltmin, bit_alloc, &adb, &fr_ps);f      		if (error_protection)n+ 		    I_CRC_calc (&fr_ps, bit_alloc, &crc);       		encode_info (&fr_ps, &bs);      		if (error_protection)o 		    encode_CRC (crc, &bs);     . 		I_encode_bit_alloc (bit_alloc, &fr_ps, &bs);2 		I_encode_scale (scalar, bit_alloc, &fr_ps, &bs);E 		I_subband_quantization (scalar,/** */sb_sample, j_scale, *j_sample, ) 				        bit_alloc, *subband, &fr_ps);*7 		I_sample_encoding (*subband, bit_alloc, &fr_ps, &bs);l      		/* YBKim060695 ancillary */  		if(ancillaryUse)( 		    ancillary_encode (&fr_ps,&bs,adb); 		else 		    for (i = 0; i < adb; i++)_ 			put1bit (&bs, 0);   	        break;p  tJ /***************************** Layer 2 **********************************/  a 	case 2: if (aiff != 1)_ 		{e 		    for (i = 0; i < 3; i++)l 			for (j = 0;j < 12; j++)# 			    for (k = 0; k < stereo; k++), 			    {7 				window_subband (&win_buf[k], &(*win_que)[k][0], k);dA 				filter_subband (&(*win_que)[k][0], &(sb_sample)[k][i][j][0]);x 			    } 					  		    l = 0; 		    m = stereo;,  L 		    II_scale_factor_calc (&fr_ps, sb_sample, scalar, fr_ps.sblimit, l, m);  		    if (info.multiling_ch > 0)g 		        II_scale_factor_calc (&fr_ps, sb_sample, scalar, fr_ps.sblimit_ml, 7, 7 + info.multiling_ch);f     D 		    pick_scale (scalar, &fr_ps, max_sc, cha_sw, aug_cha_sw, aiff);3 		    if (fr_ps.actual_mode == MPG_MD_JOINT_STEREO)i 		    {p7 			II_combine_LR (sb_sample, *j_sample, fr_ps.sblimit);,J 			II_scale_factor_calc (&fr_ps, *j_sample, j_scale, fr_ps.sblimit, 0, 1); 		    }; 		 				 n8 		    /* this way we calculate more mono than we need */)                     /* but it is cheap */   F 		    II_Psycho_One (buffer, max_sc, ltmin, &fr_ps, smr, spiki, aiff);  		    if (info.multiling_ch > 0) 		    {r 			if (odd_ml)D 			    II_Psycho_One_ml (buffer, max_sc, ltmin, &fr_ps, smr, spiki); 			if (info.multiling_fs)} 			{3 			    pick_scale_ml_2 (&fr_ps, sb_sample, max_sc);e3 			    for (k = 7; k < 7 + info.multiling_ch; k++) ej 				II_smr (&ltmin[k][0], &smr[k][0], &spiki[k][0], &max_sc[k][0], fr_ps.sblimit_ml, 0, fr_ps.sblimit_ml); 			} 		    }o  6 		    II_transmission_pattern (scalar, scfsi, &fr_ps);  A 		    II_main_bit_allocation (smr, ltmin, scfsi, bit_alloc, &adb,_# 					    &fr_ps, &aiff, sb_sample, r% 					    scalar, max_sc, buffer_matr,)# 					    spiki, *j_sample, j_scale,) 					    dyn_cr, aug_dyn_cr,  					    scfsi_dyn, scalar_dyn);   		    if (error_protection)e0 			II_CRC_calc (&fr_ps, bit_alloc, scfsi, &crc);    		    encode_info (&fr_ps, &bs);      		    if (error_protection)) 			encode_CRC (crc, &bs);   3 		    II_encode_bit_alloc (bit_alloc, &fr_ps, &bs);p    f 		    k = 0; 		    i = stereo;1; 		    II_encode_scale (bit_alloc, scfsi, scalar, lfe_alloc,a+ 				     lfe_scalar, &fr_ps, &bs, &k , &i); E 		    II_subband_quantization (scalar, sb_sample, j_scale, *j_sample,o' 					     bit_alloc, *subband, &fr_ps);l< 		    II_sample_encoding (*subband, bit_alloc, &fr_ps, &bs);         9 /*******************************************************/s! /* 08/03/1995 JMZ Multilingual */   		    if (info.multiling_ch > 0) 		    { 	 			k = 7;   			i = info.multiling_ch + 7;		 3 			II_encode_bit_alloc_ml (bit_alloc, &fr_ps, &bs); F 			II_encode_scale_ml (bit_alloc, scfsi, scalar, &fr_ps, &bs, &k, &i);: 			II_subband_quantization_ml (scalar, sb_sample, j_scale,2 						    *j_sample, bit_alloc, *subband, &fr_ps);< 			II_sample_encoding_ml (*subband, bit_alloc, &fr_ps, &bs); 		    } ! /* 08/03/1995 JMZ Multilingual */ 9 /*******************************************************/     ! 		    /* YBKim060695 ancillary */  		    if (ancillaryUse) * 			   ancillary_encode (&fr_ps, &bs, adb);
 		    else 			for (i = 0; i < adb; i++) 			    put1bit (&bs, 0); 		}w  R /*********************** Now Layer 2 with MC extension **************************/   		else 		{  		    if (verbosity >= 2)  			printf ("Adb1: %ld\n", adb);i 		    if (lfe) 		    {s 			lfe_bits = adb;5 			lfe_filter (&win_buf[fr_ps.lfe_pos], *lfe_sample);n- 			lf_scalefactor (*lfe_sample, &lfe_scalar);r% 			lfe_allocation (&lfe_alloc, &adb);) 			lfe_bits -= adb;      		    }f        s 		    for (i = 0; i < 3; i++)| 			for (j = 0; j < 12; j++)s 			{
 			    l = 0;  	    			    for (k = 0; k < 7; k++) 			    {$ 				if (lfe && (k == fr_ps.lfe_pos)) 				    l +=1; ;7 				window_subband (&win_buf[l], &(*win_que)[k][0], k);tA 				filter_subband (&(*win_que)[k][0], &(sb_sample)[k][i][j][0]);n 				l++; 			    } 			} 	_ #ifdef Augmentation_7chg 		    if (stereoaug == 2)  		    {u' 			normalizing_aug (sb_sample, &fr_ps);y% 			matricing_aug (sb_sample, &fr_ps);e 		    } 
 		    else #endif# 			normalizing (sb_sample, &fr_ps);c     $ 		    matricing (sb_sample, &fr_ps);      		    l = 0;! 		    if (stereoaug == 2) m = 12;c 		    else		m = 7;  Q 		    II_scale_factor_calc (&fr_ps, sb_sample, scalar, fr_ps.sblimit, 0, stereo); T 		    II_scale_factor_calc (&fr_ps, sb_sample, scalar, fr_ps.sblimit_mc, stereo, m);  		    if (info.multiling_ch > 0)g 		        II_scale_factor_calc (&fr_ps, sb_sample, scalar, fr_ps.sblimit_ml, 7, 7 + info.multiling_ch);s  D 		    pick_scale (scalar, &fr_ps, max_sc, cha_sw, aug_cha_sw, aiff);     3 		    if (fr_ps.actual_mode == MPG_MD_JOINT_STEREO)f 		    {f 			if (verbosity >= 2) 			{ 			    printf ("JOINT!!\n"); 			    fflush (stdout);  			} 			i = 0;		n7 			II_combine_LR (sb_sample, *j_sample, fr_ps.sblimit);w@ 			II_scale_factor_calc1 (*j_sample, j_scale, fr_ps.sblimit, i); 		    }      K 		    II_Psycho_One (buffer_matr, max_sc, ltmin, &fr_ps, smr, spiki, aiff);M  		    if (info.multiling_ch > 0) 		    {= 			if (odd_ml)I 			    II_Psycho_One_ml (buffer_matr, max_sc, ltmin, &fr_ps, smr, spiki);8      			if (info.multiling_fs)f 			{3 			    pick_scale_ml_2 (&fr_ps, sb_sample, max_sc);w3 			    for (k = 7; k < 7 + info.multiling_ch; k++) ij 				II_smr (&ltmin[k][0], &smr[k][0], &spiki[k][0], &max_sc[k][0], fr_ps.sblimit_ml, 0, fr_ps.sblimit_ml); 			} 		    }  				    6 		    II_transmission_pattern (scalar, scfsi, &fr_ps);     U 		    /*in case of ext_bit_stream adb is the complete number of bits!! 06/22/94, SR*/        A 		    II_main_bit_allocation (smr, ltmin, scfsi, bit_alloc, &adb,(* 					    &fr_ps, &aiff, sb_sample, scalar,$ 					    max_sc, buffer_matr, spiki,H 					    *j_sample, j_scale, dyn_cr, aug_dyn_cr, scfsi_dyn, scalar_dyn); 		    if (verbosity >= 2)* 			printf ("Adb2: %ld\n", adb);/	 					    1  		    if (info.mc_prediction_on) 			set_mc_pred (&fr_ps);  $ 		    /* PREDISTORTION, 4/7/94, SR*/  		    if (fr_ps.config == 320 &&1 			FALSE &&		    /* still a problem 7/2/97 FdB */a 		    	info.matrix == 0 &&& 			info.mode != MPG_MD_JOINT_STEREO && 			info.dyn_cross_on == 0 && #ifdef Augmentation_7chu 			stereoaug == 0 && #endif 			info.mc_prediction_on == 0) 		    { ; 			adb = (whole_SpF + extra_slot) * bitsPerSlot - lfe_bits;79 			predistortion (sb_sample, scalar, bit_alloc, *subband,&0 				       &fr_ps, smr, scfsi, &adb, scfsi_dyn); 			predis = 1; u 			if (verbosity >= 2)# 			    printf ("Adb3: %ld\n", adb);i 		    }	     /* */) 		    /********** PREDISTORTION-END*****/s      		    if (error_protection) 0 			II_CRC_calc (&fr_ps, bit_alloc, scfsi, &crc); 			    b 		    lfe_alloc = 4;C 		    II_CRC_calc_mc (&fr_ps, bit_alloc, lfe_alloc, scfsi, &crcmc);* 		    lfe_alloc = 0;   #ifdef Augmentation_7ch  		    if (stereoaug == 2) 7 			II_CRC_calc_aug (&fr_ps, bit_alloc, scfsi, &crcaug);* #endif    		    encode_info (&fr_ps, &bs); 		   j 		    if (error_protection)  			encode_CRC (crc, &bs);	     3 		    II_encode_bit_alloc (bit_alloc, &fr_ps, &bs);k 		    k = 0; 		    i = stereo;		      ] 		    II_encode_scale (bit_alloc, scfsi, scalar, lfe_alloc, lfe_scalar, &fr_ps, &bs, &k, &i);c 		    : 		    II_subband_quantization (scalar, sb_sample, j_scale,2 					     *j_sample, bit_alloc, *subband, &fr_ps);	 				     a	 				     /< 		    II_sample_encoding (*subband, bit_alloc, &fr_ps, &bs);  D 		    /***** Now bitstream for the surround channels **************/  $ 		    encode_info_mc1 (&fr_ps, &bs); 		     		    encode_CRC (crcmc, &bs); 		    ? 		    encode_info_mc2 (&fr_ps, &bs);    /*new draft 5.7.93 SR*/	 		     		    if (lfe) 		    {  		        lfe_alloc = 4;7 		        II_encode_lfe_alloc (lfe_alloc, &fr_ps, &bs);( 		    },     6 		    II_encode_bit_alloc_mc (bit_alloc, &fr_ps, &bs); 		    k = stereo;u 		    i = stereo + stereomc; 		    ] 		    II_encode_scale (bit_alloc, scfsi, scalar, lfe_alloc, lfe_scalar, &fr_ps, &bs, &k, &i);b    l= 		    II_subband_quantization_mc (scalar, sb_sample, j_scale,a4 					       *j_sample, bit_alloc, *subband, &fr_ps);    l 		    if (lfe) =B 		        II_lfe_quantisation (lfe_scalar, *lfe_sample, lfe_alloc, 					     *lfe_sbband, &fr_ps);r 				       *W 		    II_sample_encoding_mc (*subband, *lfe_sbband, bit_alloc, lfe_alloc, &fr_ps, &bs);+    		    if (info.multiling_ch > 0) 		    { 	 			k = 7;e  			i = info.multiling_ch + 7;		 3 			II_encode_bit_alloc_ml (bit_alloc, &fr_ps, &bs);tF 			II_encode_scale_ml (bit_alloc, scfsi, scalar, &fr_ps, &bs, &k, &i); 	 : 			II_subband_quantization_ml (scalar, sb_sample, j_scale,2 						    *j_sample, bit_alloc, *subband, &fr_ps); 	  	 < 			II_sample_encoding_ml (*subband, bit_alloc, &fr_ps, &bs); 		    }b   #ifdef Augmentation_7chm 		    if (stereoaug == 2)g 		    { 0 			/* bitstream for the augmentation channels */! 			encode_info_aug (&fr_ps, &bs);r 			c 			encode_CRC (crcaug, &bs); 			 4 			II_encode_bit_alloc_aug (bit_alloc, &fr_ps, &bs);   			k = stereo + stereomc;t% 			i = stereo + stereomc + stereoaug;_Z 			II_encode_scale (bit_alloc, scfsi, scalar, lfe_alloc, lfe_scalar, &fr_ps, &bs, &k, &i);         ; 			II_subband_quantization_aug (scalar, sb_sample, j_scale,n3 						     *j_sample, bit_alloc, *subband, &fr_ps);         (= 			II_sample_encoding_aug (*subband, bit_alloc, &fr_ps, &bs);c 		    }  #endif  * 		    frameBits = sstell (&bs) - sentBits;' 		    frameBits += info.n_ad_bytes * 8;l& 		    if (info.ext_bit_stream_present) 			frameBits += 40;7  = 		    if (frameBits < (whole_SpF + extra_slot) * bitsPerSlot)] 		    {k< 			adb = (whole_SpF + extra_slot) * bitsPerSlot - frameBits; 			if (verbosity >= 2)# 			    printf ("Adb4: %ld\n", adb);i 			adb += info.n_ad_bytes * 8;# 			if (info.ext_bit_stream_present)l 			    adb += 40;  		    }& 		    else if (verbosity >= 2)/ 			printf ("Adb4: %ld but %ld bits overflow\n",m= 				adb, frameBits - (whole_SpF + extra_slot) * bitsPerSlot);n    l! 		    /* YBKim060695 ancillary */i 		    if (ancillaryUse)_' 			ancillary_encode (&fr_ps, &bs, adb);o
 		    else 			for (i = 0; i < adb; i++) 			    put1bit (&bs, 0); 		}  		break;J /***************************** Layer 3, not done yet!!*******************/   /*	case 3: break; */   	}  e% 	frameBits = sstell (&bs) - sentBits;l7 	if (frameBits % bitsPerSlot)   /* a program failure */ F 	    fprintf (stderr, "Sent %ld bits = %ld slots plus %ld adb: %ld\n",* 		     frameBits, frameBits / bitsPerSlot,% 		     frameBits % bitsPerSlot, adb);l 	sentBits += frameBits;    #ifdef DEBUG 	if (verbosity >= 3) 	{ 	   if ( (info.lay==2) && * 		((int) aiff_ptr.sampleRate == 48000) && ( 		(info.ext_bit_stream_present == 0) && < 		(frameBits != 24*bitrate[info.lay-1][info.bitrate_index]) ) 	      ) /* for debugging purposes WtK */eV 	      fprintf (stderr, "\n***Error. %d bits have been written instead of %d bits.\n",? 			     frameBits, 24*bitrate[info.lay-1][info.bitrate_index]);d 	} #endif   #ifdef PRINTOUTn 	if (verbosity >= 3) 	{ #ifdef Augmentation_7ch  	    if (stereoaug == 2)v 		printf ("\nFrame %4lu   channel 1  channel 2  channel 3  channel 4  channel 5  channel 6  channel 7\n", frameNum-1);	 	    elsee #endif` 		printf ("\nFrame %4lu   channel 1  channel 2  channel 3  channel 4  channel 5\n", frameNum-1);     C 	    for (loop_subband = 0; loop_subband < SBLIMIT; loop_subband++)* 	    { 		l = sbgrp[i]; ) 		printf ("subband %2d :", loop_subband); V 		for (loop_channel = 0; loop_channel < stereo + stereomc + stereoaug; loop_channel++) 		{ = 		    /* make loop_alloc point to the alloc-table in fr_ps */f9 		    k = transmission_channel (&fr_ps, l, loop_channel);d  		    if (loop_channel < stereo)  		    	loop_alloc = fr_ps.alloc;
 		    else# 		    	loop_alloc = fr_ps.alloc_mc;{P 		    loop_bits = (* loop_alloc)[loop_subband][bit_alloc[k][loop_subband]].bits; 		    if ((k == 1) && ( 			(info.mode == MPG_MD_JOINT_STEREO) &&# 			(loop_subband >= fr_ps.jsbound))i 			printf ("      js   ");
 		    else 		    {iK 			if ((* loop_alloc)[loop_subband][bit_alloc[k][loop_subband]].steps == 0)( 			    printf("    - bits ");n 			elseg 			{O 			    if ((* loop_alloc)[loop_subband][bit_alloc[k][loop_subband]].group == 1)e 			    loop_bits /= 3;) 			    printf ("%5.1f bits ", loop_bits);n 			} 		    }f 		} /* for (loop_channel..) */ 		printf("\n");=! 	    } /* for (loop_subband..) */        	    /* Now the ML part , WtK */ 	    if (info.multiling_ch > 0)s 	    {) 		printf ("\nFrame %4lu ", frameNum - 1);mG 		for (loop_channel=7;loop_channel<7+info.multiling_ch; loop_channel++) + 		    printf("  MLchann %d", loop_channel);b 		printf ("\n");@ 		for (loop_subband = 0; loop_subband < SBLIMIT; loop_subband++) 		{r- 		    printf ("subband %2d :", loop_subband); N 		    for (loop_channel = 0; loop_channel < info.multiling_ch; loop_channel++) 		    {): 			/* make loop_alloc point to the alloc-table in fr_ps */ 			loop_alloc = fr_ps.alloc_ml;bX 			loop_bits = (* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].bits;V 			if ((* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].steps == 0) 			    printf("    - bits ");	 			elsen 			{Z 			    if ((* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].group == 1) 				loop_bits /= 3;)) 			    printf ("%5.1f bits ", loop_bits);  			}" 		    } /* for (loop_channel..) */ 		    printf("\n");r 		} /* for (loop_subband..) */ 	    } /*n_ml_ch>0*/ 	    fflush (stdout);[ 	} /* verbosity */ #endif   	if (info.multiling_fs == 1)* 	    odd_ml = 1 - odd_ml; /* ML half fs */C 	/****************************************************************/cC 	/*                                                              */SC 	/*                   END OF FRAME LOOP                          */lC 	/*                                                              */sC 	/****************************************************************/c+     } /* end of while (get_audio) - loop */t         close_bit_stream_w (&bs);      )     if (info.ext_bit_stream_present == 1)o     {s9 	open_bit_stream_r (&bs, encoded_file_name, BUFFER_SIZE);/+ 	if (encoded_file_name_ext[0] == NULL_CHAR)&N 	    strcat (strcpy (encoded_file_name_ext, encoded_file_name), DFLT_EXT_EXT);d 	if (verbosity >= 2) printf(">>> file name of extension bitstream is: %s\n", encoded_file_name_ext);A 	open_bit_stream_w (&bs_ext, encoded_file_name_ext, BUFFER_SIZE);h+ 	if (encoded_file_name_mpg[0] == NULL_CHAR)sJ 	    strcat (strcpy (encoded_file_name_mpg, encoded_file_name), DFLT_EXT);A 	open_bit_stream_w (&bs_mpg, encoded_file_name_mpg, BUFFER_SIZE);o   	for (m = 0; m < frameNum; m++)l 	{H 	    i = (((double) samplesPerFrame / s_freq[info.sampling_frequency]) *N 		  (double) bitrate[info.lay-1][info.bitrate_index]) - (info.n_ad_bytes * 8);   	    for (j = 0; j < i; j++) 	    {  		crc_buffer[0] = get1bit (&bs);# 		put1bit (&bs_mpg, crc_buffer[0]);	 	    }. 	    for (j = 0; j < info.n_ad_bytes * 8; j++) 		put1bit (&bs_mpg, 0);_ 	  a( 	    encode_info_ext1 (&fr_ps, &bs_ext);   	    for (i = 0; i < 14; i++)&# 		crc_buffer[i] = getbits (&bs, 8);_' 	    crc_buffer[14] = getbits (&bs, 4);   3 	    II_CRC_calc_ext (&fr_ps, crc_buffer, &crcext);)  0 	    encode_info_ext2 (&fr_ps, &bs_ext, crcext);   	    for (i = 0; i < 14; i++)	& 		putbits (&bs_ext, crc_buffer[i], 8);* 	    putbits (&bs_ext, crc_buffer[14], 4); 	z* 	    i = (info.ext_length * 8) - 40 - 116; 	    for (j = 0; j < i; j++) 	    {  		crc_buffer[0] = get1bit (&bs);# 		put1bit (&bs_ext, crc_buffer[0]);l 	    }  . 	    for (j = 0; j < 5 + info.n_ad_bytes; j++)# 		crc_buffer[i] = getbits (&bs, 8);	 	}   	close_bit_stream_r (&bs); 	close_bit_stream_w (&bs_ext); 	close_bit_stream_w (&bs_mpg); 	_ 	strcpy (blubb, "rm ");e# 	strcat (blubb, encoded_file_name);f #ifdef DEBUG         if (verbosity >= 3)  	    printf ("%s\n", blubb); #endif c 	system (blubb);   	strcpy (blubb, "mv ");c' 	strcat (blubb, encoded_file_name_mpg);; 	strcat (blubb, " ");	# 	strcat (blubb, encoded_file_name);	 #ifdef DEBUG         if (verbosity >= 3)a 	    printf ("%s\n", blubb); #endif & 	system (blubb);
     }    	          if (verbosity >= 2)sB 	printf ("Avg slots/frame = %.3f; b/smp = %.2f; br = %.3f kbps\n",. 		(FLOAT) sentBits / (frameNum * bitsPerSlot),2 		(FLOAT) sentBits / (frameNum * samplesPerFrame),3 		(FLOAT) sentBits / (frameNum * samplesPerFrame) *s$ 			s_freq[info.sampling_frequency]);          if (fclose (musicin) != 0)     {	: 	printf ("Could not close \"%s\".\n", original_file_name);
 	exit (2);     }+      #ifdef  MACINTOSHaB 	set_mac_file_attr(encoded_file_name, VOL_REF_NUM, CREATOR_ENCODE, 			  FILETYPE_ENCODE); #endif       if (verbosity >= 2)u     {iI 	printf ("Encoding of \"%s\" with psychoacoustic model %d is finished\n",d$ 	        original_file_name, model); 	if (aiff == 1) / 	    printf (" It is a multichannel file !\n");e 	else_0 	    printf (" It is a twochannel file!\n");	   9 	printf ("The MPEG encoded output file name is \"%s\"\n",a 		encoded_file_name);c     }c }_   I /************************************************************************  /* /* usage /*I /* PURPOSE:  Writes command line syntax to the file specified by #stderr#_ /*J /************************************************************************/  3 static void usage (void)  /* print syntax & exit */e { g     fprintf (stderr, "usage: %s                         queries for all arguments, or\n", programName);am     fprintf (stderr, "       %s [-l lay][-m mode][-r sfrq][-b br][-B br][-d emp][-C config]\n", programName);_ #ifdef Augmentation_7ch(e     fprintf (stderr, "          [-x matr][-k tca][-y dynX][-X aug_matr][-K aug_tca][-Y aug_dynX]\n");b #elsel?     fprintf (stderr, "          [-x matr][-k tca][-y dynX]\n");  #endifc     fprintf (stderr, "          [-c][-o][-e][-w][-g][-v verb][-L][-a][-P][-D] inputPCM [outBS]\n");i      fprintf (stderr, "where\n");R     fprintf (stderr, " -l lay   use layer <lay> coding   (dflt %4u)\n", DFLT_LAY);R     fprintf (stderr, " -m mode  channel mode : s/d/j/m   (dflt %4c)\n", DFLT_MOD);R     fprintf (stderr, " -n mode  surround mode : s/d/j/m  (dflt %4c)\n", DFLT_MOD);T     fprintf (stderr, " -r sfrq  input smpl rate in kHz   (dflt %4.1f)\n", DFLT_SFQ);R     fprintf (stderr, " -b br    total bitrate in kbps    (dflt %4u)\n", DFLT_BRT);R     fprintf (stderr, " -B br    MPEG1 bitrate in kbps    (dflt %4u)\n", DFLT_BRT);R     fprintf (stderr, " -d emp   de-emphasis n/5/c        (dflt %4c)\n", DFLT_EMP);6     fprintf (stderr, " -c       mark as copyright\n");5     fprintf (stderr, " -o       mark as original\n");f9     fprintf (stderr, " -e       add error protection\n"); F     fprintf (stderr, " -x matr  matrix                   (dflt 0)\n");G     fprintf (stderr, " -k tca   set channel-switching    (dflt -2)\n"); S     fprintf (stderr, " -y dynX  set dyn_cross mode       (dflt 0)\n");               #ifdef Augmentation_7cheF     fprintf (stderr, " -X Amatr 7.1-ch aug. matrix       (dflt 0)\n");F     fprintf (stderr, " -K Atca  set 7.1-ch aug. tca      (dflt 0)\n");S     fprintf (stderr, " -Y AdynX 7.1-ch aug. DynX mode    (dflt 0)\n");             t #endifH     fprintf (stderr, " -w       set phantom coding       (dflt off)\n");H     fprintf (stderr, " -L       set LFE on               (dflt off)\n");H     fprintf (stderr, " -C mode  set configuration        (dflt 320)\n");y     fprintf (stderr, " -g       set MultiLingual file    (dflt off) input ML filename = inputPCM+\"%s\"\n", DFLT_ML_EXT); H     fprintf (stderr, " -P       set mc prediction on     (dflt off)\n");H     fprintf (stderr, " -D       set dyn_cross_LR on      (dflt off)\n");R     fprintf (stderr, " -n nr    number of anc data Bytes (dflt %d)\n", DFLT_NADB);H     fprintf (stderr, " -a       set ancillary data on    (dflt off)\n");R     fprintf (stderr, " -v verb  level of verbosity 0-3 	 (dflt %d)\n", DFLT_VERB);L     fprintf (stderr, " inputPCM input PCM sound file (standard or AIFF)\n");b     fprintf (stderr, " outBS    output bit stream of encoded audio (dflt inName+%s)\n", DFLT_EXT);
     exit (1);) }   I /************************************************************************s /*
 /* aiff_check] /*E /* PURPOSE:  Checks AIFF header information to make sure it is valid.{ /*           Exits if not. /*J /************************************************************************/  : void aiff_check (char *file_name, IFF_AIFF *pcm_aiff_data)<                           /* Pointer to name of AIFF file */>                           /* Pointer to AIFF data structure */ {i  =     if (strcmp (pcm_aiff_data->sampleType, IFF_ID_SSND) != 0)a     { @        printf ("Sound data is not PCM in \"%s\".\n", file_name);        exit (1);     }f  ;     if (SmpFrqIndex ((long) pcm_aiff_data->sampleRate) < 0)_     { *        printf ("in \"%s\".\n", file_name);        exit (1);     }b  D     if (pcm_aiff_data->sampleSize != sizeof(short) * BITS_IN_A_BYTE)     {m9         printf ("Sound data is not %d bits in \"%s\".\n",o:                sizeof(short) * BITS_IN_A_BYTE, file_name);         exit(1);     }s  I     if (pcm_aiff_data->numChannels < 1 || pcm_aiff_data->numChannels > 8)      {(J        printf ("Sound data is not 1 - 8 channel in \"%s\".\n", file_name);        exit (1);     }b  .     if (pcm_aiff_data->blkAlgn.blockSize != 0)     {sI        printf ("Block size is not %lu bytes in \"%s\".\n", 0, file_name);=        exit (1);     }1  +     if (pcm_aiff_data->blkAlgn.offset != 0)o     {nK        printf ("Block offset is not %lu bytes in \"%s\".\n", 0, file_name);_        exit (1);     }u }[