G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) 0  * ISO 13818-3 MPEG-2 Audio Multichannel Encoder  *7  * $Id: encode.c 1.9 1996/02/12 07:13:35 rowlands Exp $   *  * $Log: encode.c $ .  * Revision 1.9  1996/02/12 07:13:35  rowlands#  * Release following Munich meeting   *3  * Revision 1.6.2.1  1995/11/06  04:19:12  rowlands %  * Received from Uwe Felderhoff (IRT)   *.  * Revision 1.8  1995/08/14  07:53:28  tenkate0  * ML-LSF added Warner ten Kate 7/8/95 (Philips)>  * variables "alloc" and "sblimit" changed into "alloc_ml" and"  * "sblimit_ml" where appropriate.@  * sample loops adapted to 12 or 6 depending on full or half fs./  * II_a_bit_allocation separate summing for ML.   *.  * Revision 1.7  1995/07/31  07:48:55  tenkate@  * addition of phantom coding, in void matricing(), 25/07/95 WtK  *3  * Revision 1.4.3.1  1995/06/16  08:25:11  rowlands )  * Input from Sang Wook Kim (Samsung AIT)   *3  * Revision 1.4.2.1  1995/06/16  03:46:42  rowlands $  * Input from Susanne Ritscher (IRT)  *3  * Revision 1.4.1.6  1995/06/16  02:41:51  rowlands <  * Added dematrix procedure 2, corrected dematrixing values.  *A  * Added support for dematrix procedure 2, without predistortion. A  * To implement predistortion will require a delay in the encoder D  * to be able to calculate the predistorted filtered surround signal  * subband samples.   *@  * Modified procedure matricing() to reuse the compatible stereoB  * channel signals computed by matricing_fft(). This was needed toA  * avoid calculating the low-pass-filtered surround signal in the A  * subband domain. The main function of procedure matricing() now @  * is to weight the multichannels. These channels are unweighted5  * prior to this for the benefit of the psycho model.   *9  * Corrected weighting values for dematrixing procedures. .  * Deleted matrixing on multilingual channels.?  * In the quantization procedures, made quantizing to zero bits >  * a special case to skip some operations on undefined values.  *H  **********************************************************************/  G /********************************************************************** G  *   date   programmers         comment                               * G  * 3/01/91  Douglas Wong,       start of version 1.1 records          * G  *          Davis Pan                                                 * G  * 3/06/91  Douglas Wong        rename: setup.h to endef.h            * G  *                                      efilter to enfilter           * G  *                                      ewindow to enwindow           * G  *                              integrated "quantizer", "scalefactor",* G  *                              and "transmission" files              * G  *                              update routine "window_subband"       * G  * 3/31/91  Bill Aspromonte     replaced read_filter by               * G  *                              create_an_filter                      * G  * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         * G  *                              Incorporated Jean-Georges Fritsch's   * G  *                              "bitstream.c" package.                * G  *                              Incorporated Bill Aspromonte's        * G  *                              filterbank coefficient matrix         * G  *                              calculation routines and added        * G  *                              roundoff to coincide with specs.      * G  *                              Modified to strictly adhere to        * G  *                              encoded bitstream specs, including    * G  *                              "Berlin changes".                     * G  *                              Modified PCM sound file handling to   * G  *                              process all incoming samples and fill * G  *                              out last encoded frame with zeros     * G  *                              (silence) if needed.                  * G  *                              Located and fixed numerous software   * G  *                              bugs and table data errors.           * G  * 19jun91  dpwe (Aware)        moved "alloc_*" reader to common.c    * G  *                              Globals sblimit, alloc replaced by new* G  *                              struct 'frame_params' passed as arg.  * G  *                              Added JOINT STEREO coding, layers I,II* G  *                              Affects: *_bit_allocation,            * G  *                              subband_quantization, encode_bit_alloc* G  *                              sample_encoding                       * G  * 6/10/91  Earle Jennings      modified II_subband_quantization to   * G  *                              resolve type cast problem for MS_DOS  * G  * 6/11/91  Earle Jennings      modified to avoid overflow on MS_DOS  * G  *                              in routine filter_subband             * G  * 7/10/91  Earle Jennings      port to MsDos from MacIntosh version  * G  * 8/ 8/91  Jens Spille         Change for MS-C6.00                   * G  *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           * G  *          Don H. Lee,                                               * G  *          Peter W. Farrett                                          * G  *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   * G  *                              newly introduced function encode_CRC  * G  *11/ 8/91  Kathy Wang          Documentation of code                 * G  *                              All variablenames are referred to     * G  *                              with surrounding pound (#) signs      * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  * 92-08-11 Soren H. Nielsen    Fixed bug: allocation of space in the * G  *                              bitstream for the CRC-word. Fixed     * G  *                              reading of window from file.          * D  * 92-11-06 Soren H. Nielsen	Fixed scalefactor calculation.        *G  ********************************************************************** G  *                                                                    * G  *                                                                    * G  *  MPEG/audio Phase 2 coding/decoding multichannel                   * G  *                                                                    * G  *  7/27/93        Susanne Ritscher,  IRT Munich                      * G  *  8/10/93        changed matricing to 7 channels                    * B  *	           added void matricing_fft                           *G  *  8/12/93        added int required_bits,                           * G  *                       int max_alloc                                * G  *                 implemented the new mc_header (third working draft)* G  *  8/13/93        added channel-switching in required_bits and       * G  *                 II_subband_quantisation, II_encode_scale,          * G  *                 II_encode_bit_alloc, II_encode_sample,             * G  *                 encode_info                                        * G  *                 all channels normalized                            * G  *  9/20/93        channel-switching is only performed at a           * G  *                 certain limit of TC_ALLOC dB, which is included    * G  *                 in encoder.h                                       * G  *  1/04/94        get out some rubbish                               **G  *                                                                    *pG  * 01/05/94        implemented the Committee Draft header             *nG  *                                                                    * G  * 01/12/94        changed matricing procedure according to           * G  *                 Committee Draft                                    * G  *                                                                    *sG  *  Version 1.0                                                       */G  *                                                                    *"G  *  07/12/94       Susanne Ritscher,  IRT Munich                      *rG  *                 Tel: +49 89 32399 458                              * G  *                 Fax: +49 89 32399 415                              * G  *                                                                    *.G  *  Version 1.1                                                       *gG  *                                                                    *tD  *  02/23/95	   Susanne Ritscher,  IRT Munich                      *G  *                 corrected some bugs                                *lG  *                 extension bitstream is working                     *nG  *                                                                    **G  *  Version 2.0                                                       *bG  *                                                                    *iG  *  01/28/97       Frans de Bont, Philips Sound & Vision, Eindhoven   *e;  *		    - dynamic crosstalk working for all configurations*n;  *		    - prediction working for all configurations	      * -  *		    - extension bitstream fixed			      *n;  *		    - fully compliant to DIS 13818-3.2                *bX  *                                                                    *				      *		    H  **********************************************************************/G /**********************************************************************eG  *                                                                    **G  *  06/06/95       Yeon Bae Thomas Kim, Samsung AIT                   **G  *                 ancillary data is working                          *oG  *                                                                    *tG  *  06/06/95       Sang Wook Kim, Samsung AIT                         * G  *                 corrected some bugs                                *eG  *                                                                    * H  **********************************************************************/7 #define VERY_FAST_FILTER  1	/* JMZ 08/03/1995 FILTER */    #include "common.h"d #include "encoder.h"  rJ /*=======================================================================\I |                                                                       | I | This segment contains all the core routines of the encoder,           | I | except for the psychoacoustic models.                                 |*I |                                                                       | I | The user can select either one of the two psychoacoustic              | I | models. Model I is a simple tonal and noise masking threshold         | I | generator, and Model II is a more sophisticated cochlear masking      | I | threshold generator. Model I is recommended for lower complexity      | I | applications whereas Model II gives better subjective quality at low  | I | bit rates.                                                            | I |                                                                       | I | Layers I and II of mono, stereo, and joint stereo modes are supported.| I | Routines associated with a given layer are prefixed by "I_" for layer | I | 1 and "II_" for layer 2.                                              | J \=======================================================================*/   J /************************************************************************/ /* /* read_samples()  /*< /* PURPOSE:  reads the PCM samples from a file to the buffer /* /*  SEMANTICS:C /* Reads #samples_read# number of shorts from #musicin# filepointer ? /* into #sample_buffer[]#.  Returns the number of samples read.t /*J /************************************************************************/   unsigned long read_samples(FILE *musicin, long int *sample_buffer, long unsigned int num_samples, long unsigned int frame_size, intO  *byte_per_sample, int *aiff)  {  unsigned long samples_read;*% static unsigned long samples_to_read;  static char init = TRUE;I short pcm_sample_buffer[9216];        /*for correct reading of pcm-data*/p int i;      if (init) {&         samples_to_read = num_samples;         init = FALSE;_    }%    if (samples_to_read >= frame_size) "         samples_read = frame_size;    else # 		  samples_read = samples_to_read;o  ) 	if((*aiff==1) &&(*byte_per_sample !=2)){  	              if ((samples_read =fM 		  fread(sample_buffer, *byte_per_sample, (int)samples_read, musicin)) == 0)m: 		  if (verbosity >= 2) printf("Hit end of audio data\n"); 	    	} 	else{ 	 if ((samples_read =0N 		  fread(pcm_sample_buffer, sizeof(short), (int)samples_read, musicin)) == 0): 		  if (verbosity >= 2) printf("Hit end of audio data\n");N             for(i = 0; i < 9216; ++i) sample_buffer[i] = pcm_sample_buffer[i];	         }o  #    samples_to_read -= samples_read;r7    if (samples_read < frame_size && samples_read > 0) { b         if (verbosity >= 2) printf("Insufficient PCM input for one frame - fillout with zeros\n");M         for (; samples_read < frame_size; sample_buffer[samples_read++] = 0);          samples_to_read = 0;    }    return(samples_read); }g  J /************************************************************************/ /* /* get_audio() /*C /* PURPOSE:  reads a frame of audio data from a file to the buffer, = /*   aligns the data for future processing, and separates the* /*   left and right channels /* /*  SEMANTICS:F /* Calls read_samples() to read a frame of audio data from filepointerG /* #musicin# to #insampl[]#.  The data is shifted to make sure the dataiL /* is centered for the 1024pt window to be used by the psychoacoustic model,G /* and to compensate for the 256 sample delay from the filter bank. For E /* stereo, the channels are also demultiplexed into #buffer[0][]# andg /* #buffer[1][]# /*' /* 21/03/1995 JMZ Multimode adaptations:J /************************************************************************/  h
 unsigned longe get_audio (  	FILE *musicin,  	double (*buffer)[1152], 	long unsigned int num_samples,1 	int stereo, 	IFF_AIFF *aiff_ptr, 	int stereomc, 	int stereoaug,* 	frame_params *fr_ps,* 	int *aiff,* 	int *byte_per_sample, 	double (*buffer_matr)[1152] )  {      int k, j, i;     long insamp[9216];     unsigned long samples_read;      int lay;     int lfe;      layer *info = fr_ps->header;          lay = info->lay;     lfe = info->lfe;       if (lay == 1)      {  	if (stereo == 2)  	{ /* layer 1, stereo */? 	    samples_read = read_samples (musicin, insamp, num_samples, 9 				         (unsigned long) 768, byte_per_sample, aiff);  	    for (j = 0; j < 448; j++)   	    { 		if (j<64)  		{ & 		    buffer[0][j] = buffer[0][j+384];& 		    buffer[1][j] = buffer[1][j+384]; 		    buffer[2][j] = 0;  		    buffer[3][j] = 0;x 		    buffer[4][j] = 0;  		}  		else   		{ % 		    buffer[0][j] = insamp[2*j-128];d% 		    buffer[1][j] = insamp[2*j-127];  		    buffer[2][j] = 0;c 		    buffer[3][j] = 0;  		    buffer[4][j] = 0;  		}_ 	    } 	} 	else  	{ /* layer 1, mono */? 	    samples_read = read_samples (musicin, insamp, num_samples, 9 				         (unsigned long) 384, byte_per_sample, aiff);  	    for (j = 0; j < 448; j++) 	    { 		if (j < 64)  		{ & 		    buffer[0][j] = buffer[0][j+384]; 		    buffer[1][j] = 0;n 		    buffer[2][j] = 0;o 		    buffer[3][j] = 0;* 		    buffer[4][j] = 0;l 		}o 		else C 		{w" 		    buffer[0][j] = insamp[j-64]; 		    buffer[1][j] = 0;  		    buffer[2][j] = 0;  		    buffer[3][j] = 0;  		    buffer[4][j] = 0;  		}  	    } 	}     } 	     else       {  	if (*aiff == 1) 	{ 	    k = aiff_ptr->numChannels; ? 	    samples_read = read_samples (musicin, insamp, num_samples, = 					     (unsigned long) (k * 1152), byte_per_sample, aiff);    	    for (i = 0; i < k; i++) 		for (j = 0; j < 1152; j++)# 		    buffer[i][j] = insamp[k*j+i];  	} 	else  	{  /* layerII, stereo */  	    if (stereo == 2)  	    {< 		samples_read = read_samples (musicin, insamp, num_samples,: 			(unsigned long) ((2+lfe)*1152), byte_per_sample, aiff); 		for (j = 0; j < 1152; j++)  		{ /* fixed bug 28.6.93 S.R. */' 		    buffer[0][j] = insamp[(2+lfe)*j];1) 		    buffer[1][j] = insamp[(2+lfe)*j+1];  		    buffer[2][j] = 0;  		    buffer[3+lfe][j] = 0;3 		    buffer[4+lfe][j] = 0;  		    if (lfe)? 		        buffer[3][j] = insamp[(2+lfe)*j+2]; /* ########### */  		}  	    }	 	    else ! 	    { /* layer 2 (or 3), mono */ < 		samples_read = read_samples (musicin, insamp, num_samples,0 			(unsigned long) 1152, byte_per_sample, aiff); 		for (j = 0; j < 1152; j++) 		{  		    buffer[0][j] = insamp[j];a 		    buffer[1][j] = 0;  		    buffer[2][j] = 0;* 		    buffer[3][j] = 0;d 		    buffer[4][j] = 0;  		}          	    } 	}     }        /*0      * If LFE is not enabled, "buffer" contains:      *	buffer[0]	L      *	buffer[1]	R      *	buffer[2]	C      *	buffer[3]	Lss      *	buffer[4]	Rs  #ifdef Augmentation_7ch 1      *  optional in 7.1 channel augmentation mode       *	buffer[5]	Lc       *	buffer[6]	Rc  #endif      *,      * If LFE is enabled, "buffer" contains:      *	buffer[0]	L      *	buffer[1]	R      *	buffer[2]	C      *	buffer[3]	LFE      *	buffer[4]	Lsa      *	buffer[5]	Rs  #ifdef Augmentation_7ch 1      *  optional in 7.1 channel augmentation moden      *	buffer[6]	Lc       *	buffer[7]	Rc  #endif      */    #ifdef Augmentation_7ch      if (stereoaug == 2) 4     	matricing_aug_fft (buffer, buffer_matr, fr_ps);     else #endif, 	matricing_fft (buffer, buffer_matr, fr_ps);       /*/      * After matrixing, "buffer_matr" contains:       *	buffer_matr[0]	Lo      *	buffer_matr[1]	Ro      *	buffer_matr[2]	Co      *	buffer_matr[3]	Ls      *	buffer_matr[4]	Rs      *	buffer_matr[5]	La      *	buffer_matr[6]	R  #ifdef Augmentation_7ch 1      *  optional in 7.1 channel augmentation mode       *	buffer_matr[7]	L7      *	buffer_matr[8]	R7      *	buffer_matr[9]	C7      *	buffer_matr[10]	Lc       *	buffer_matr[11]	Rc  #endif      */        return (samples_read); }   J /************************************************************************* /* /* matricing() /*9 /* The five-channel signal must be matricied to guaranteeZ+ /* the compatibility to the stereo-decoder.d= /* There must be something of the surround information in the=; /* two front channels. In a five-channel decoder there will  /* be a dematricing.= /* There must be 7 channels for channel switching 8/10/93, SR  /* r7 /* Channel 5 and 6 are the not matriced signals L and Ry /*; /* If phantom coding is used the high-frequency part of the / /* center signal is matrixed to left and right.  /* 27/07/95 WtK M /*                                                                         */eM /***************************************************************************/o  F void normalizing (double (*sb_sample)[3][12][32], frame_params *fr_ps) { 5     double matrNorm;	/* factor for normalizing JMZ */ 9     double matrC;	/* weighting factor for C, Phantom C */t6     double matrLsRs;	/* weighting factor for Ls, Rs */     int stereo = fr_ps->stereo;      int i, j, k, l;            layer *info = fr_ps->header;        switch (info->matrix)s     {IA     /* Changed the factors according to International Standard */n            case 0:g+     case 2: matrNorm	= 1 / (1 + sqrt(2.0));  	    matrC	= 1 / sqrt(2.0);  	    matrLsRs	= 1 / sqrt(2.0); 	    break; 1     case 1: matrNorm	= 1 / (1.5 + 0.5*sqrt(2.0));= 	    matrC	= 1 / sqrt(2.0);* 	    matrLsRs	= 0.5; 	    break;*     case 3: matrNorm	= 1;* 	    matrC	= 1;r 	    matrLsRs	= 1; 	    break;r     }e          for (i = 0; i < stereo; i++)     	for (j = 0; j < 3; j++) 	    for (l = 0; l < 12; l++)s$ 	    	for (k = 0; k < SBLIMIT; k ++)( 		    sb_sample[i][j][l][k] *= matrNorm;       for (j = 0; j < 3; ++j)* 	for (l = 0; l < 12; l ++)# 	    for (k = 0; k < SBLIMIT; k ++)  		if (fr_ps->config == 320)L 		{sG 		    sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matrNorm * matrC;eJ 		    sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matrNorm * matrLsRs;J 		    sb_sample[4][j][l][k] = sb_sample[4][j][l][k] * matrNorm * matrLsRs; 		}h  		else if (fr_ps->config == 310) 		{oG 		    sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matrNorm * matrC;eJ 		    sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matrNorm * matrLsRs; 		}   		else if (fr_ps->config == 220) 		{aJ 		    sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matrNorm * matrLsRs;J 		    sb_sample[3][j][l][k] = sb_sample[3][j][l][k] * matrNorm * matrLsRs; 		}e8 		else if (fr_ps->config == 300 || fr_ps->config == 302)G 		    sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matrNorm * matrC;}  		else if (fr_ps->config == 210)J 		    sb_sample[2][j][l][k] = sb_sample[2][j][l][k] * matrNorm * matrLsRs; }   D void matricing (double (*sb_sample)[3][12][32], frame_params *fr_ps) {(7     double matrPC;	/* weighting factor for Phantom C */r     double mono_surround;l     register double val;     int i, j, k, l;a           layer *info = fr_ps->header;        switch (info->matrix)n     {uG     /* Changed the factors according to International Standard */      ;     case 0:      case 1:      case 2: matrPC	= 1;d 	    break; #     case 3: matrPC	= 1 / sqrt(2.0);r 	    break;_     }          for (j = 0; j < 3; ++j)*     {* 	for (l = 0; l < 12; l ++) 	{# 	    for (k = 0; k < SBLIMIT; k ++)R 	    {0 		sb_sample[5][j][l][k] = sb_sample[0][j][l][k];0 		sb_sample[6][j][l][k] = sb_sample[1][j][l][k];   		if (fr_ps->config == 320)n 		{h( 		    /* 960819 FdB changed matricing */1 		    if (info->matrix == 0 || info->matrix == 1)l 		    { e 			    sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sb_sample[2][j][l][k] + sb_sample[3][j][l][k]; e 			    sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sb_sample[2][j][l][k] + sb_sample[4][j][l][k];f 		    }k! 		    else if (info->matrix == 2)  		    {lM 			    mono_surround = (sb_sample[3][j][l][k] + sb_sample[4][j][l][k]) / 2.0;m] 			    sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sb_sample[2][j][l][k] - mono_surround;h] 			    sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sb_sample[2][j][l][k] + mono_surround;n 		    }s
 		    else 		    {F5 			    sb_sample[0][j][l][k] = sb_sample[5][j][l][k];a5 			    sb_sample[1][j][l][k] = sb_sample[6][j][l][k];, 		    }  		}f  		else if (fr_ps->config == 310) 		{;( 		    /* 960819 FdB changed matricing */1 		    if (info->matrix == 0 || info->matrix == 1)a 		    { e 			    sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sb_sample[2][j][l][k] + sb_sample[3][j][l][k];se 			    sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sb_sample[2][j][l][k] + sb_sample[3][j][l][k];  		    } ! 		    else if (info->matrix == 2)s 		    {fe 			    sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sb_sample[2][j][l][k] - sb_sample[3][j][l][k];4e 			    sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sb_sample[2][j][l][k] + sb_sample[3][j][l][k];u 		    }]
 		    else 		    { 5 			    sb_sample[0][j][l][k] = sb_sample[5][j][l][k];u5 			    sb_sample[1][j][l][k] = sb_sample[6][j][l][k];c 		    }u 		}3  		else if (fr_ps->config == 220) 		{	( 		    /* 960819 FdB changed matricing */1 		    if (info->matrix == 0 || info->matrix == 1)s 		    {sM 			    sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sb_sample[2][j][l][k];(M 			    sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sb_sample[3][j][l][k];[ 		    };! 		    else if (info->matrix == 3)u 		    {]5 			    sb_sample[0][j][l][k] = sb_sample[5][j][l][k];05 			    sb_sample[1][j][l][k] = sb_sample[6][j][l][k];- 		    }  		}f8 		else if (fr_ps->config == 300 || fr_ps->config == 302) 		{0( 		    /* 960819 FdB changed matricing */1 		    if (info->matrix == 0 || info->matrix == 1)  		    {kM 			    sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sb_sample[2][j][l][k];nM 			    sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sb_sample[2][j][l][k];  		    }(! 		    else if (info->matrix == 3)  		    {+5 			    sb_sample[0][j][l][k] = sb_sample[5][j][l][k];{5 			    sb_sample[1][j][l][k] = sb_sample[6][j][l][k];{ 		    }e 		}d  		else if (fr_ps->config == 210) 		{a( 		    /* 960819 FdB changed matricing */1 		    if (info->matrix == 0 || info->matrix == 1)+ 		    {*M 			    sb_sample[0][j][l][k] = sb_sample[5][j][l][k] + sb_sample[2][j][l][k];fM 			    sb_sample[1][j][l][k] = sb_sample[6][j][l][k] + sb_sample[2][j][l][k];[ 		    } ! 		    else if (info->matrix == 3)  		    { 5 			    sb_sample[0][j][l][k] = sb_sample[5][j][l][k];#5 			    sb_sample[1][j][l][k] = sb_sample[6][j][l][k];o 		    }o 		}  	    }  9 	    if (info->center == 3)            /* 27/07/95 WtK */i 	    { 		if (info->matrix==3)% 		    for (k = 12; k < SBLIMIT; k ++)  		    { ( 			val = matrPC * sb_sample[2][j][l][k];  			sb_sample[0][j][l][k] += val;  			sb_sample[1][j][l][k] += val; 			sb_sample[2][j][l][k] = 0;  		    }  		else  % 		    for (k = 12; k < SBLIMIT; k ++)a 		    {f( 			val = matrPC * sb_sample[2][j][l][k];  			sb_sample[5][j][l][k] += val;  			sb_sample[6][j][l][k] += val; 			sb_sample[2][j][l][k] = 0;c 		    }* 	    } 	}     }h }e   #ifdef Augmentation_7ch*J void normalizing_aug (double (*sb_sample)[3][12][32], frame_params *fr_ps) { 1     double norm;	/* factor for normalizing JMZ */e     double c[7];     int i, j, k, l;e           layer *info = fr_ps->header;        for (i = 0; i < 7; i++)_ 	c[i] = 1.0;       switch (info->matrix)n     {m6     	/* factors according to International Standard */     	case 0:W     	case 2: c[2] = c[3] = c[4] = 1.0 / sqrt (2.0);	/* weigh factor for C, Ls and Rs */r 	    	break;J     	case 1: c[2] = 1.0 / sqrt (2.0);		/* weigh factor for C            */: 		c[3] = c[4] = 0.5;			/* weigh factor for Ls, Rs       */ 		break;     }         if (info->aug_mtx_proc == 0)1     	/* factors according to 7-ch augmentation */e  	/* unweigh factor for LC, RC */ 	c[5] = c[6] = 0.75;       /* normalization factor */3     switch (info->matrix * 10 + info->aug_mtx_proc)      {b     case 00:5     case 20: norm = 1.0 / (1.75 + 1.25 * sqrt (2.0));  	     break;5     case 10: norm = 1.0 / (2.25 + 0.75 * sqrt (2.0));* 	     break;     case 30: norm = 1.0 / 1.75;* 	     break;     case 01:-     case 21: norm = 1.0 / (2.0 + sqrt (2.0));m 	     break;3     case 11: norm = 1.0 / (2.5 + 0.5 * sqrt (2.0));r 	     break;     case 31: norm = 0.5; 	     break;     case 03:-     case 23: norm = 1.0 / (1.0 + sqrt (2.0));= 	     break;3     case 13: norm = 1.0 / (1.5 + 0.5 * sqrt (2.0));b 	     break;     case 33: norm = 1.0; 	     break;     }t       for (i = 0; i < 7; i++)a 	c[i] *= norm;       /* normalizing */      for (i = 0; i < 7; i++)o 	for (j = 0; j < 3; j++) 	    for (k = 0; k < 12; k++)i 		for (l = 0; l < SBLIMIT; l++)t$ 		    sb_sample[i][j][k][l] *= c[i]; }   H void matricing_aug (double (*sb_sample)[3][12][32], frame_params *fr_ps) {*     int i, j, k, l;*           layer *info = fr_ps->header;        for (j = 0; j < 3; ++j)p 	for (l = 0; l < 12; l ++)# 	    for (k = 0; k < SBLIMIT; k ++)  	    {8 		/* copy L7, R7, C7, Lc and Rc to sb_sample[7 .. 11] */1 		sb_sample[11][j][l][k] = sb_sample[6][j][l][k];e1 		sb_sample[10][j][l][k] = sb_sample[5][j][l][k];s1 		sb_sample[ 9][j][l][k] = sb_sample[2][j][l][k];i1 		sb_sample[ 8][j][l][k] = sb_sample[1][j][l][k];s1 		sb_sample[ 7][j][l][k] = sb_sample[0][j][l][k];n  $ 		/* 960819 FdB changed matricing */9 		if (info->aug_mtx_proc == 0 || info->aug_mtx_proc == 1)m 		{=5 		    sb_sample[0][j][l][k] += sb_sample[5][j][l][k];b5 		    sb_sample[1][j][l][k] += sb_sample[6][j][l][k];)                 }/ 		if (info->aug_mtx_proc == 0)S 		    sb_sample[2][j][l][k] += (sb_sample[5][j][l][k] + sb_sample[6][j][l][k]) / 3;  	    } }  #endif  J /************************************************************************* /* /* matricing_fft() /*A /* To get the best results in psychoacoustics there must be both,N; /* the matriced and the not matriced signal. This matricing+ /* may be in full bandwith.M  *,  * If LFE is not enabled, "buffer" contains:  *	buffer[0]	L  *	buffer[1]	R  *	buffer[2]	C  *	buffer[3]	Lst  *	buffer[4]	Rsm  *(  * If LFE is enabled, "buffer" contains:  *	buffer[0]	L  *	buffer[1]	R  *	buffer[2]	C  *	buffer[3]	LFE  *	buffer[4]	Lsm  *	buffer[5]	Rs	  *C  * This function matrixes the original audio samples to pass to themB  * psychoacoustic model. The model considers the matrixed and non->  * matrixed versions of the signal, so both are retained here.  * >A  * On exit, buffer_matr[0] to buffer_matr[6] contain the channels[)  * Lo, Ro, C, Ls, Rs, L, R, respectively.l  *L  **************************************************************************/  + void matricing_fft (double (*buffer)[1152], " 		    double (*buffer_matr)[1152], 		    frame_params *fr_ps) {}5     double matrNorm;	/* factor for normalizing JMZ */j/     double matrC;		/* weighting factor for C */L6     double matrLsRs;	/* weighting factor for Ls, Rs */     double mono_surround;(     int i, j, k, l;/     int lfe, lfe_pos;P     double dummy;o           layer *info = fr_ps->header;     lfe = info->lfe;     lfe_pos = fr_ps->lfe_pos;        switch(info->matrix)     {o     case 0: +     case 2: matrNorm	= 1 / (1 + sqrt(2.0));  	    matrC	= 1 / sqrt(2.0);  	    matrLsRs	= 1 / sqrt(2.0); 	    break;a1     case 1: matrNorm	= 1 / (1.5 + 0.5*sqrt(2.0));s 	    matrC	= 1 / sqrt(2.0);  	    matrLsRs	= 0.5; 	    break;*     case 3: matrNorm	= 1;1 	    matrC	= 1;  	    matrLsRs	= 1; 	    break;      }        for (i = 0; i < 1152; i++)     {[ 	if (lfe && lfe_pos < 3)& 	    buffer_matr[2][i]	= buffer[3][i]; 	elsec& 	    buffer_matr[2][i]	= buffer[2][i];& 	buffer_matr[3][i]	= buffer[3+lfe][i];& 	buffer_matr[4][i]	= buffer[4+lfe][i];" 	buffer_matr[5][i]	= buffer[0][i];" 	buffer_matr[6][i]	= buffer[1][i];    l 	switch (info->matrix) 	{ 	case 0:l 	case 1: buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer_matr[2][i] + matrLsRs*buffer_matr[3][i]);e 		buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer_matr[2][i] + matrLsRs*buffer_matr[4][i]);] 		break;G 	case 2: mono_surround = (buffer_matr[3][i] + buffer_matr[4][i]) / 2.0;ec 		buffer_matr[0][i] = matrNorm*(buffer[0][i] + matrC*buffer_matr[2][i] - matrLsRs * mono_surround);]c 		buffer_matr[1][i] = matrNorm*(buffer[1][i] + matrC*buffer_matr[2][i] + matrLsRs * mono_surround);[ 		break;* 	case 3: buffer_matr[0][i] = buffer[0][i];# 		buffer_matr[1][i] = buffer[1][i];i 		break; 	}    } })   #ifdef Augmentation_7ch J /************************************************************************* /* /* matricing_aug_fft() /*A /* To get the best results in psychoacoustics there must be both,[; /* the matriced and the not matriced signal. This matricing[ /* may be in full bandwith.s  *,  * If LFE is not enabled, "buffer" contains:  *	buffer[0]	L  *	buffer[1]	R  *	buffer[2]	C  *	buffer[3]	Lsa  *	buffer[4]	Rs+  *	buffer[5]	Lcl  *	buffer[6]	Rc3  *(  * If LFE is enabled, "buffer" contains:  *	buffer[0]	L  *	buffer[1]	R  *	buffer[2]	C  *	buffer[3]	LFE  *	buffer[4]	Ls	  *	buffer[5]	Rs   *	buffer[6]	Lce  *	buffer[7]	Rc_  *C  * This function matrixes the original audio samples to pass to the]B  * psychoacoustic model. The model considers the matrixed and non->  * matrixed versions of the signal, so both are retained here.  * -7  * On exit, buffer[0] to buffer[5] contain the channelss,  * L5, R5, C5, (LFE, ) Ls, Rs, respectively.B  * On exit, buffer_matr[7] to buffer_matr[11] contain the channels&  * L7, R7, C7, Lc and Rc respectively.  *L  **************************************************************************/  / void matricing_aug_fft (double (*buffer)[1152],l 			double (*buffer_matr)[1152],  			frame_params *fr_ps)f {s5     double matrNorm;	/* factor for normalizing JMZ */r.     double matrC;	/* weighting factor for C */2     double matrLR;	/* weighting factor for L, R */6     double matrLsRs;	/* weighting factor for Ls, Rs */     int i, j, k, l;[     int lfe;     double dummy;a           layer *info = fr_ps->header;     lfe = info->lfe;        switch (info->aug_mtx_proc)l     {s     case 0:] 	  matrNorm	= 1 / 1.75;e 	  matrC		= 0.25;a 	  matrLR	= 0.75; 	 	  break;	     case 1:  	  matrNorm	= 0.5; 	  matrC		= 0; 	  matrLR	= 1;	 	  break;c     case 3:  	  matrNorm	= 1; 	  matrC		= 0; 	  matrLR	= 0;	 	  break;      }p       for (i = 0; i < 1152; i++)     {s/ 	buffer_matr[3][i] = buffer[3+lfe][i];	/* Ls */[/ 	buffer_matr[4][i] = buffer[4+lfe][i];	/* Rs */]    	+ 	buffer_matr[7][i] = buffer[0][i];	/* L7 */	+ 	buffer_matr[8][i] = buffer[1][i];	/* R7 */p+ 	buffer_matr[9][i] = buffer[2][i];	/* C7 */]0 	buffer_matr[10][i] = buffer[5+lfe][i];	/* Lc */0 	buffer_matr[11][i] = buffer[6+lfe][i];	/* Rc */   	/* calculate L5, R5, C5 */oR 	buffer_matr[0][i] = matrNorm * (buffer_matr[7][i] + matrLR * buffer_matr[10][i]);R 	buffer_matr[1][i] = matrNorm * (buffer_matr[8][i] + matrLR * buffer_matr[11][i]);h 	buffer_matr[2][i] = matrNorm * (buffer_matr[9][i] + matrC * (buffer_matr[10][i] + buffer_matr[11][i]));     }l       switch (info->matrix)]     {	     case 0:[     case 2:a" 	  matrNorm	= 1 / (1 + sqrt(2.0)); 	  matrC		= 1 / sqrt(2.0); 	  matrLsRs	= 1 / sqrt(2.0);	 	  break;      case 1:t( 	  matrNorm	= 1 / (1.5 + 0.5*sqrt(2.0)); 	  matrC		= 1 / sqrt(2.0); 	  matrLsRs	= 0.5;	 	  break;e     case 3:t 	  matrNorm	= 1; 	  matrC		= 1; 	  matrLsRs	= 1;	 	  break;l     }        for (i = 0; i < 1152; i++)     { ' 	buffer_matr[5][i] = buffer_matr[0][i]; ' 	buffer_matr[6][i] = buffer_matr[1][i];     a 	switch (info->matrix) 	{ 	case 0:< 	case 1: buffer_matr[0][i] = matrNorm * (buffer_matr[0][i] +! 						matrC * buffer_matr[2][i] +L$ 						matrLsRs * buffer_matr[3][i]);5 		buffer_matr[1][i] = matrNorm * (buffer_matr[1][i] + ! 						matrC * buffer_matr[2][i] + $ 						matrLsRs * buffer_matr[4][i]); 		break;< 	case 2: buffer_matr[0][i] = matrNorm * (buffer_matr[0][i] +! 						matrC * buffer_matr[2][i] -n 						matrLsRs * 0.5 *0 						 (buffer_matr[3][i] + buffer_matr[4][i]));5 		buffer_matr[1][i] = matrNorm * (buffer_matr[1][i] +_! 						matrC * buffer_matr[2][i] +a 						matrLsRs * 0.5 *0 						 (buffer_matr[3][i] + buffer_matr[4][i])); 		break; 	}     }  }. #endif    J /************************************************************************/ /* /* read_ana_window() /*F /* PURPOSE:  Reads encoder window file "enwindow" into array #ana_win# /*J /************************************************************************/  e% void read_ana_window(double *ana_win)s!        /*far*/                   e {:     int i,j[4];5
     FILE *fp;2     double f[4];     char t[150];   .     if (!(fp = OpenTableFile("enwindow") ) ) {A        printf("Please check analysis window table 'enwindow'\n");=        exit(1);      }      for (i=0;i<512;i+=4) {=        fgets(t, 80, fp); /* changed from 150, 92-08-11 shn */bD        sscanf(t,"C[%d] = %lf C[%d] = %lf C[%d] = %lf C[%d] = %lf\n",,               j, f,j+1,f+1,j+2,f+2,j+3,f+3);        if (i==j[0]) {            ana_win[i] = f[0];           ana_win[i+1] = f[1];           ana_win[i+2] = f[2];           ana_win[i+3] = f[3];        }
        else {p;           printf("Check index in analysis window table\n");[           exit(1);        };        fgets(t,80,fp); /* changed from 150, 92-08-11 shn */      }m     fclose(fp);= }_  J /************************************************************************/ /* /* window_subband()_ /*. /* PURPOSE:  Overlapping window on PCM samples /*
 /* SEMANTICS:oD /* 32 16-bit pcm samples are scaled to fractional 2's complement andG /* concatenated to the end of the window buffer #x#. The updated windowsH /* buffer #x# is then windowed by the analysis window #c# to produce the /* windowed sample #z# /*J /************************************************************************/   7 void window_subband (double **buffer, double *z, int k)* {*F     typedef double XX[14][HAN_SIZE];	/* 08/03/1995 JMZ Multilingual */     static XX *x;h
     int i, j;hS     static off[14]= {0,0,0,0,0,0,0,0,0,0,0,0,0,0};/* 08/03/1995 JMZ Multilingual */a     static char init = 0;n     static double *c;n  n     if (!init)     {b@ 	c = (double *) mem_alloc (sizeof(double) * HAN_SIZE, "window"); 	read_ana_window (c); ( 	x = (XX *) mem_alloc (sizeof(XX), "x"); 	for (i = 0; i < 14; i++)*" 	   for (j = 0; j < HAN_SIZE; j++) 		 (*x)[i][j] = 0;
 	init = 1;     }t  e     for (i = 0; i < 32; i++)6 	(*x)[k][31-i+off[k]] = (double) *(*buffer)++ / SCALE;"     for (i = 0; i < HAN_SIZE; i++). 	z[i] = (*x)[k][(i+off[k])&HAN_SIZE-1] * c[i];4     off[k] += 480; /*offset is modulo (HAN_SIZE-1)*/     off[k] &= HAN_SIZE-1;  }L  RJ /************************************************************************/ /* /* create_ana_filter() /*= /* PURPOSE:  Calculates the analysis filter bank coefficients  /*
 /* SEMANTICS:rD /* Calculates the analysis filterbank coefficients and rounds to theA /* 9th decimal place accuracy of the filterbank tables in the ISOf5 /* document.  The coefficients are stored in #filter#L /*J /************************************************************************/   , void create_ana_filter(double (*filter)[64])#        /*far*/                       {f    register int i,k;       for (i = 0; i < 32; i++)         for (k = 0; k < 64; k++) {K           if ((filter[i][k] = 1e9*cos((double)((2*i+1)*(16-k)*PI64))) >= 0) 3              modf(filter[i][k]+0.5, &filter[i][k]);1           else3              modf(filter[i][k]-0.5, &filter[i][k]);R           filter[i][k] *= 1e-9;3    } }m  J /************************************************************************/ /* /* filter_subband()  /*= /* PURPOSE:  Calculates the analysis filter bank coefficientsi /*
 /* SEMANTICS:fM /*      The windowed samples #z# is filtered by the digital filter matrix #m#_E /* to produce the subband samples #s#. This done by first selectivelyfE /* picking out values from the windowed samples, and then multiplying ; /* them by the filter matrix, producing 32 subband samples.r /*J /************************************************************************/  (- void filter_subband_old(double *z, double *s)R'        /*far*/                         : {n    double y[64];    int i,j, k; static char init = 0;0"    typedef double MM[SBLIMIT][64]; static MM /*far*/ *m;f    double sum1, sum2;R    o
 #ifdef MS_DOS     long    SIZE_OF_MM;     SIZE_OF_MM      = SBLIMIT*64;    SIZE_OF_MM      *= 8;    if (!init) { :        m = (MM /*far*/ *) mem_alloc(SIZE_OF_MM, "filter");        create_ana_filter(*m);         init = 1;    } #elsef    if (!init) { :        m = (MM /*far*/ *) mem_alloc(sizeof(MM), "filter");        create_ana_filter(*m);i        init = 1;    } #endif    /* Window */s    for (i=0; i<64; i++)b    {%       for (k=0, sum1 = 0.0; k<8; k++)d          sum1 += z[i+64*k];m       y[i] = sum1;    }      /* Filter */t    for (i=0;i<SBLIMIT;i++)    {$        for (k=0, sum1=0.0 ;k<64;k++)$           sum1 += (*m)[i][k] * y[k];        s[i] = sum1;     }  H /*   for (i=0;i<64;i++) for (j=0, y[i] = 0;j<8;j++) y[i] += z[i+64*j];*/ /*   for (i=0;i<SBLIMIT;i++)*/A /*       for (j=0, s[i]= 0;j<64;j++) s[i] += (*m)[i][j] * y[j];*/e   }b  J /************************************************************************/ /* JMZ 08/03/1995 FILTER */o  ) void filter_subband(double *z, double *s)-'        /*far*/                         b {     double y[64];    int i,j, k; static char init = 0;["    typedef double MM[SBLIMIT][64]; static MM /*far*/ *m;s    double sum1, sum2;        if (!init) {f:        m = (MM /*far*/ *) mem_alloc(sizeof(MM), "filter");        create_ana_filter(*m);*        init = 1;    }    /* Window */*    for (i=0; i<64; i++)o    {%       for (k=0, sum1 = 0.0; k<8; k++)l          sum1 += z[i+64*k];5       y[i] = sum1;    }      /* Filter */e #if VERY_FAST_FILTER r    for (i=0; i<SBLIMIT/2; i++)    {+        for (k=0, sum1=0.0, sum2=0.0; k<16;)t        {& 	sum1 += (*m)[i][k] * (y[k]+y[32-k]); * 	sum2 += (*m)[i][k+1] * (y[k+1]+y[31-k]); , 	sum2 += (*m)[i][k+33] * (y[k+33]-y[63-k]); , 	sum1 += (*m)[i][k+34] * (y[k+34]-y[62-k]);  	k+=2;        }0 	sum1 += (*m)[i][16]*y[16] - (*m)[i][48]*y[48];    	s[i]    = sum1 + sum2;r 	s[31-i] = sum1 - sum2;	    } #elsem    for (i=0;i<SBLIMIT;i++)    {$        for (k=0, sum1=0.0 ;k<64;k++)$           sum1 += (*m)[i][k] * y[k];        s[i] = sum1;	    } #endif /*VERY_FAST_FILTER*/; }    /* JMZ 08/03/1995 FILTER */=J /************************************************************************/  J /************************************************************************/ /* /* encode_info() /* encode_infomc1() SR /* encode_infomc2() SR /*C /* PURPOSE:  Puts the syncword and header information on the outputf
 /* bitstream.* /*J /************************************************************************/  5< void encode_info (frame_params *fr_ps, Bit_stream_struc *bs) {       layer *info = fr_ps->header;  E     putbits (bs, 0xfff, 12);                   /* syncword 12 bits */ E     put1bit (bs, info->version);               /* ID        1 bit  */tE     putbits (bs, 4-info->lay, 2);              /* layer     2 bits */ K     put1bit (bs, !info->error_protection);     /* bit set => no err prot */t)     putbits (bs, info->bitrate_index, 4);t.     putbits (bs, info->sampling_frequency, 2);      put1bit (bs, info->padding);@     put1bit (bs, info->extension);             /* private_bit */      putbits (bs, info->mode, 2);$     putbits (bs, info->mode_ext, 2);"     put1bit (bs, info->copyright);!     put1bit (bs, info->original);_$     putbits (bs, info->emphasis, 2); }_  @ void encode_info_mc1 (frame_params *fr_ps, Bit_stream_struc *bs) {e      layer *info = fr_ps->header;  /     put1bit (bs, info->ext_bit_stream_present);	*     if(info->ext_bit_stream_present == 1) )       putbits (bs, info->n_ad_bytes, 8);  #     putbits (bs, info->center, 2);  $     putbits (bs, info->surround, 2);     put1bit (bs, info->lfe);"     put1bit (bs, info->audio_mix);"     putbits (bs, info->matrix, 2);(     putbits (bs, info->multiling_ch, 3);%     put1bit (bs, info->multiling_fs); &     put1bit (bs, info->multiling_lay);'     put1bit (bs, info->copy_ident_bit);[)     put1bit (bs, info->copy_ident_start);u }r  @ void encode_info_mc2 (frame_params *fr_ps, Bit_stream_struc *bs) {       layer *info = fr_ps->header;     int i, j;         '     put1bit (bs, info->tc_sbgr_select);w%     put1bit (bs, info->dyn_cross_on);o)     put1bit (bs, info->mc_prediction_on);   8     /* 960627 FdB tca bits dependent on configuration */5     if (fr_ps->config == 320 || fr_ps->config == 310)n     {  	/* 3 bits for tca's */  	if (info->tc_sbgr_select == 1)I* 	    putbits (bs, info->tc_allocation, 3); 	else  	    for (i = 0; i < 12; i++)i% 		putbits (bs, info->tc_alloc[i], 3);c     }s<     else if (fr_ps->config == 300 || fr_ps->config == 302 ||3 	     fr_ps->config == 220 || fr_ps->config == 210)      {  	/* 2 bits for tca's */b 	if (info->tc_sbgr_select == 1)%* 	    putbits (bs, info->tc_allocation, 2); 	else  	    for (i = 0; i < 12; i++) % 		putbits (bs, info->tc_alloc[i], 2);i     }f        if (info->dyn_cross_on == 1)     { " 	put1bit (bs, info->dyn_cross_LR); 	for (i = 0; i < 12; i++)  	{: 	    /* 960627 FdB DynX bits dependent on configuration */ 	    if (fr_ps->config == 320) 		/* 3/2 */}& 		putbits (bs, info->dyn_cross[i], 4);; 	    else if (fr_ps->config == 310 || fr_ps->config == 220)* 		/* 3/1 and 2/2 */*& 		putbits (bs, info->dyn_cross[i], 3);S 	    else if (fr_ps->config == 300 || fr_ps->config == 302 || fr_ps->config == 210)  		/* 3/0 (+2/0) and 2/1 */& 		putbits (bs, info->dyn_cross[i], 1);    	    if (info->surround == 3)e+ 		put1bit (bs, info->dyn_second_stereo[i]);d 	}	    o     }b  $     if (info->mc_prediction_on == 1)     {o 	for(i = 0; i < 8; i++)w 	{& 	    put1bit (bs, info->mc_pred[i]);   	    if (info->mc_pred[i] == 1)* 	    {7 		for (j = 0; j < n_pred_coef[info->dyn_cross[i]]; j++)o* 		    putbits (bs, info->predsi[i][j], 2); 	    } 	}       }0 }			        #ifdef Augmentation_7chX@ void encode_info_aug (frame_params *fr_ps, Bit_stream_struc *bs) {0
     int sbgr;9      layer *info = fr_ps->header;  )     putbits (bs, info->aug_mtx_proc,  2); )     put1bit (bs, info->aug_dyn_cross_on);_'     put1bit (bs, info->aug_future_ext);"      if (info->aug_mtx_proc == 0)" 	for (sbgr = 0; sbgr < 12; sbgr++)0 	    putbits (bs, info->aug_tc_alloc[sbgr], 3); %     else if (info->aug_mtx_proc == 1) " 	for (sbgr = 0; sbgr < 12; sbgr++)0 	    putbits (bs, info->aug_tc_alloc[sbgr], 2); $     if (info->aug_dyn_cross_on == 1)" 	for (sbgr = 0; sbgr < 12; sbgr++)1 	    putbits (bs, info->aug_dyn_cross[sbgr], 5); f }  #endif  E void encode_info_ext1 (frame_params *fr_ps, Bit_stream_struc *bs_ext)* {*      layer *info = fr_ps->header;       info->ext_sync = 0x7ff;_  *     putbits (bs_ext, info->ext_sync, 12);  }l  W void encode_info_ext2 (frame_params *fr_ps, Bit_stream_struc *bs_ext, unsigned int crc)o {i      layer *info = fr_ps->header;       putbits (bs_ext, crc, 16);+     putbits (bs_ext, info->ext_length, 11);o$     put1bit (bs_ext, info->ext_bit); }*    J /************************************************************************/ /* /* mod() /*7 /* PURPOSE:  Returns the absolute value of its argument  /*J /************************************************************************/    double mod(double a) {      return (a > 0) ? a : -a; }l  (J /************************************************************************/ /* /* I_combine_LR    (Layer I) /* II_combine_LR	 (Layer II) /*? /* PURPOSE:Combines left and right channels into a mono channel* /*H /* SEMANTICS:  The average of left and right subband samples is put into /* #joint_sample#* /*< /* Layer I and II differ in frame length and # subbands used /*J /************************************************************************/  mT void I_combine_LR(double (*sb_sample)[3][12][32], double (*joint_sample)[3][12][32])5        /*far*/                                        8        /*far*/                                          / {   /* make a filtered mono for joint stereo */*     int sb, smp;  *     for(sb = 0; sb<SBLIMIT; ++sb)*       for(smp = 0; smp<SCALE_BLOCK; ++smp)& 		  joint_sample[0][0][smp][sb] = .5 *J                     (sb_sample[0][0][smp][sb] + sb_sample[1][0][smp][sb]); }l  Mb void II_combine_LR(double (*sb_sample)[3][12][32], double (*joint_sample)[3][12][32], int sblimit)5        /*far*/                                       M8        /*far*/                                                       . {  /* make a filtered mono for joint stereo */    int sb, smp, sufr;         for(sb = 0; sb<sblimit; ++sb)*       for(smp = 0; smp<SCALE_BLOCK; ++smp)&          for(sufr = 0; sufr<3; ++sufr)D 		joint_sample[0][sufr][smp][sb] = .5 * (sb_sample[0][sufr][smp][sb]I                                           + sb_sample[1][sufr][smp][sb]);* }m    I /************************************************************************{ /*$ /* I_scale_factor_calc     (Layer I)% /* II_scale_factor_calc    (Layer II)  /*D /* PURPOSE:For each subband, calculate the scale factor for each set2 /* of the 12 (6 in case of lsf ML) subband samples /*E /* SEMANTICS:  Pick the scalefactor #multiple[]# just larger than the ; /* absolute value of the peak subband sample of 12 samples,*= /* and store the corresponding scalefactor index in #scalar#._ /*G /* Layer II has three sets of 12 (6 in case of lsf ML) subband samples   /* for a given subband.i /*J /************************************************************************/  *c void I_scale_factor_calc(double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], int stereo) 5        /*far*/                                        #                                    (            + {     int i,j, k;    double s[SBLIMIT];k  l    for (k=0;k<stereo;k++) {5      for (i=0;i<SBLIMIT;i++)E        for (j=1, s[i] = mod(sb_sample[k][0][0][i]);j<SCALE_BLOCK;j++))/          if (mod(sb_sample[k][0][j][i]) > s[i]);.             s[i] = mod(sb_sample[k][0][j][i]);         for (i=0;i<SBLIMIT;i++)7        for (j=SCALE_RANGE-1,scalar[k][0][i]=0;j>=0;j--))H          if (s[i] < multiple[j]) { /* <= changed to <, 1992-11-06 shn */              scalar[k][0][i] = j;             break;
          }    } }3  J /******************************** Layer II ******************************/  (/ void II_scale_factor_calc (frame_params *fr_ps,i% 			   double (*sb_sample)[3][12][32],}$ 			   unsigned int (*scalar)[3][32],  			   int sblimit, int l, int m)F /* sblimit has the value of sblimit_ml in case II_scale_factor_calc */E /* is called in a ML channel , 7/8/95 WtK                          */* {/     int    i,j, k,t;     double s[SBLIMIT];     int    leng;    R#     leng = SCALE_BLOCK; /* == 12 */a3     if (l >= 7 && fr_ps->header->multiling_fs == 1)  	leng /= 2;*        for (k = l; k < m; k++)* 	for (t = 0; t < 3; t++) * 	{" 	    for (i = 0; i < sblimit; i++)@ 		for (j = 1, s[i] = mod (sb_sample[k][t][0][i]); j < leng; j++)- 		    if (mod (sb_sample[k][t][j][i]) > s[i]) & 			s[i] = mod (sb_sample[k][t][j][i]);    i" 	    for (i = 0; i < sblimit; i++)= 		for (j = SCALE_RANGE - 1, scalar[k][t][i] = 0; j >= 0; j--)  		    if (s[i] < multiple[j])  		    {,( 			/* <= changed to <, 1992-11-06 shn */ 			scalar[k][t][i] = j;u	 			break;i 		    }a( 	    for (i = sblimit; i < SBLIMIT; i++)$ 		scalar[k][t][i] = SCALE_RANGE - 1; 	} }   L /***************************************************************************A /* void II_scale_factor_calc1(sb_sample, scalar, stereo, sblimit)  /*? /* in case of any joint stereo the scalefactor must be computed_( /* a second time for the combind samples /*M /***************************************************************************/   o void II_scale_factor_calc1(double (*sb_sample)[3][12][32], unsigned int (*scalar)[3][32], int sblimit, int dim)15        /*far*/                                       b#                                    b                       {;   int i,j, k,t;,   double s[SBLIMIT];   	for (t=0;t<3;t++) { 	 for (i=0;i<sblimit;i++)mB 		for (j=1, s[i] = mod(sb_sample[dim][t][0][i]);j<SCALE_BLOCK;j++), 		  if (mod(sb_sample[dim][t][j][i]) > s[i])) 				 s[i] = mod(sb_sample[dim][t][j][i]);c     for (i=0;i<sblimit;i++) 4 	 for (j=SCALE_RANGE-1,scalar[dim][t][i]=0;j>=0;j--)A 		if (s[i] < multiple[j]) { /* <= changed to <, 1992-11-06 shn */f 			scalar[dim][t][i] = j; 	 			break;  		} B 		for (i=sblimit;i<SBLIMIT;i++) scalar[dim][t][i] = SCALE_RANGE-1; 	 }o }o      I /************************************************************************e /* /* pick_scale  (Layer II)( /*C /* PURPOSE:For each subband, puts the smallest scalefactor of the 3a7 /* associated with a frame into #max_sc#.  This is useds" /* used by Psychoacoustic Model I./ /* (I would recommend changin max_sc to min_sc)f /*J /************************************************************************/   / void pick_scale (unsigned int (*scalar)[3][32],i 		 frame_params *fr_ps,  		 double (*max_sc)[32], 		 int cha_sw, 		 int aug_cha_sw, 		 int aiff)         c {o     int i,j,k,l,m;     int max;      int stereo  = fr_ps->stereo;#     int stereomc = fr_ps->stereomc;(%     int stereoaug = fr_ps->stereoaug;b!     int sblimit = fr_ps->sblimit;('     int sblimit_mc = fr_ps->sblimit_mc;F'     int sblimit_ml = fr_ps->sblimit_ml;/P     int n_ml_ch = fr_ps->header->multiling_ch; /* 08/03/1995 JMZ Multilingual */             if (aiff != 1)     {3        l = 0; m = stereo;*     }3     else     {   
        l = 0;-"        if (stereoaug == 2) m = 12;        else		   m = 7;     }n         for (k = 0; k < stereo; k++)     {0< 	for (i = 0; i < sblimit; max_sc[k][i] = multiple[max], i++)- 	    for (j=1, max = scalar[k][0][i];j<3;j++),# 	        if (max > scalar[k][j][i])  		    max = scalar[k][j][i];# 	for (i = sblimit; i < SBLIMIT;i++)= 	    max_sc[k][i] = 1E-20;     }  s         for (k = stereo; k < m; k++)     {d? 	for (i = 0; i < sblimit_mc; max_sc[k][i] = multiple[max], i++)[- 	    for (j=1, max = scalar[k][0][i];j<3;j++)j# 	        if (max > scalar[k][j][i])  		    max = scalar[k][j][i];& 	for (i = sblimit_mc; i < SBLIMIT;i++) 	    max_sc[k][i] = 1E-20;     }  n        if (aiff == 1)     {p /* OLD 961114 FdBu/ 	if (fr_ps->header->matrix == 3 || cha_sw == 0)  	{' 	    fr_ps->header->tc_sbgr_select = 1;b 	    for (i = 0; i < 12; i++) ! 		fr_ps->header->tc_alloc[i] = 0;( 	} 	elseb 	    tc_alloc (fr_ps, max_sc); */   	for (i = 0; i < 12; i++) 4 	    if (cha_sw == -1 && fr_ps->header->matrix != 3) 		switch (fr_ps->config) 		{t 		case 320:oH 			if (fr_ps->header->center == 3 && i >= 10)   /* tc_alloc = 0,3,4,5 */ 			{0 			    fr_ps->header->tc_alloc[i] = rand () % 4;* 			    if (fr_ps->header->tc_alloc[i] > 0)$ 				fr_ps->header->tc_alloc[i] += 2; 			} 			elsec0 			    fr_ps->header->tc_alloc[i] = rand () % 8;	 			break;> 		case 310:7F 			if (fr_ps->header->center == 3 && i >= 10)   /* tc_alloc = 0,3,4 */ 			{0 			    fr_ps->header->tc_alloc[i] = rand () % 3;* 			    if (fr_ps->header->tc_alloc[i] > 0)$ 				fr_ps->header->tc_alloc[i] += 2; 			}' 			else if (fr_ps->header->matrix == 2),0 			    fr_ps->header->tc_alloc[i] = rand () % 6; 			else*0 			    fr_ps->header->tc_alloc[i] = rand () % 5;	 			break;* 		case 300:* 		case 302:*B 			if (fr_ps->header->center == 3 && i >= 10)   /* tc_alloc = 0 */& 			    fr_ps->header->tc_alloc[i] = 0; 			else*0 			    fr_ps->header->tc_alloc[i] = rand () % 3;	 			break;  		case 220:;, 			fr_ps->header->tc_alloc[i] = rand () % 4;	 			break;* 		case 210:*, 			fr_ps->header->tc_alloc[i] = rand () % 3;	 			break;b
 		default:	 			break;  		}R9 	    else if (cha_sw == -2 && fr_ps->header->matrix != 3)  	    	tc_alloc (fr_ps, max_sc); ) 	    else if (fr_ps->header->matrix == 3) ! 		fr_ps->header->tc_alloc[i] = 0;a	 	    elser& 		fr_ps->header->tc_alloc[i] = cha_sw;  # 	fr_ps->header->tc_sbgr_select = 1;*; 	fr_ps->header->tc_allocation = fr_ps->header->tc_alloc[0];o 	for (i = 1; i < 12; i++)]B 	    if (fr_ps->header->tc_alloc[i] != fr_ps->header->tc_alloc[0])( 	    	fr_ps->header->tc_sbgr_select = 0;   #ifdef Augmentation_7ch  	for (i = 0; i < 12; i++)  	    if (aug_cha_sw == -1)& 		switch (fr_ps->header->aug_mtx_proc) 		{s7 		case 0: fr_ps->header->aug_tc_alloc[i] = rand () % 8;m	 			break;n7 		case 1: fr_ps->header->aug_tc_alloc[i] = rand () % 4;a	 			break;s- 		case 3: fr_ps->header->aug_tc_alloc[i] = 0;o	 			break;n 		}d	 	    elses. 		fr_ps->header->aug_tc_alloc[i] = aug_cha_sw; #endif     }i   : /********************************************************/0 /* JMZ 08/03/1995 Multilingual , WtK 07/08/95 */       if (n_ml_ch > 0)     {f" 	for (k = 7; k < 7 + n_ml_ch; k++) 	{C 	    for (i = 0; i < sblimit_ml; max_sc[k][i] = multiple[max], i++) 0 		for (j = 1, max = scalar[k][0][i]; j < 3; j++)  		    if (max > scalar[k][j][i]) 			max = scalar[k][j][i];s' 	  for (i= sblimit_ml; i < SBLIMIT;i++)  	    max_sc[k][i] = 1E-20; 	}     }[  ! /* JMZ 08/03/1995 Multilingual */*: /********************************************************/   }{  L /*************************************************************************** /*% /* tc_alloc  (Layer II, multichannel)a /*D /* PURPOSE: For each subbandgroup the three transmissionchannels areB /*          determined by taking the channel with the lowest level= /*          according to the tabel tc_allocation in the drafte /*  8/10/93, SR          o /* eI /*           changed to a certain limit of TC_ALLOC which must be steppede6 /*           beyond, before there is channel-switching /*           9/20/93 SR*  D /* JMZ 08/03/1995 Ajout pour traiter les differentes configurations  /*		envisagees dans la normeL /**************************************************************************/  9 void tc_alloc (frame_params *fr_ps, double (*max_sc)[32])  { #     layer 	*info 	= fr_ps->header;	 "     int 	center 	= info->center;		$     int 	surround = info->surround;	"     int 	matrix 	= info->matrix;		     int 	i, l, k;s
     int 	min;m     double 	min1;S     double 	min2[7][12]; 	      *     /* 01/03/1995 JMZ Configuration 3/2 */%     if (surround == 2 && center != 0)      {r$ 	/* if (matrix == 3)		->tc_alloc = 0. 	   else if (center == 3)	->tc_alloc = 0,3,4,5+ 	   else				->tc_alloc = 0,1,2,3,4,5,6,7 */    	if (matrix == 3)  	{ 	    for (i = 0; i < 12; i++) ! 		fr_ps->header->tc_alloc[i] = 0;  	}+ 	else if (center == 3) /* && matrix != 3 */* 	{$ 	    /* 3/2 Phantom Center coding */ 	    for (i = 0; i < 8; i++) 	    {K 		if (((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)[ 		{ & 		    if (max_sc[6][i] < max_sc[4][i])" 			fr_ps->header->tc_alloc[i] = 5;
 		    else" 			fr_ps->header->tc_alloc[i] = 3; 		}  nP 		else if (((20 * log10(max_sc[4][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)% 		    fr_ps->header->tc_alloc[i] = 4;  		else& 		    fr_ps->header->tc_alloc[i] = 0;  	    } p 	h 	    for (i = 8; i < 12; i++)n 	    { 		for (k = 2; k < 7; k++); 		{* 		    min2[k][i] = 0.0;	 *< 		    for (l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)  			min2[k][i] += max_sc[k][l];	 A 		    min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]);   		}   G 		if (((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)j 		{A" 		    if (min2[6][i] < min2[4][i])" 			fr_ps->header->tc_alloc[i] = 5;
 		    else" 			fr_ps->header->tc_alloc[i] = 3; 		}  hL 		else if (((20 * log10(min2[4][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)% 		    fr_ps->header->tc_alloc[i] = 4;C 		else% 		    fr_ps->header->tc_alloc[i] = 0;* 	    } 	}	* 	else* 	{' 	    /* 3/2 no Phantom Center coding */s 	    for (i = 0; i < 8; i++) 	    {K 		if (((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)c 		{e& 		    if (max_sc[6][i] < max_sc[5][i]) 			min = 6;*, 		    else if (max_sc[6][i] == max_sc[5][i]) 		    {*$ 			if (max_sc[3][i] <= max_sc[5][i]) 			    min = 5;  			elsel 			    min = 6;	           		    }[
 		    else 			min = 5;d 		}   P 		else if (((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC) 		{  		    min = 6;) 		    /* 01/03/1995 JMZ Simplification */s 		}  T 		else   	  	    ; 		{{ 		    min = 2; 		}t 	+ 		switch (min) 		{=C 		    case 5: if (max_sc[4][i] <= max_sc[6][i])  /* left front,Rs*/l# 				fr_ps->header->tc_alloc[i] = 1;  			    else[* 				fr_ps->header->tc_alloc[i] = 7;  /*R*/
 			    break;AD 		    case 6: if (max_sc[3][i] <= max_sc[5][i])  /* right front,Ls*/# 				fr_ps->header->tc_alloc[i] = 2;f 			    elsei, 				fr_ps->header->tc_alloc[i] = 6;  /* L */ 			    break;		    cW 		    case 2: if (((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)* 			    {( 				if  (max_sc[4][i] <= max_sc[6][i])  ' 				    fr_ps->header->tc_alloc[i] = 3;u 			       else' 				    fr_ps->header->tc_alloc[i] = 5;a
 			    }   			    elsex 			    {O 				if (((20 * log10(max_sc[4][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)  _' 				    fr_ps->header->tc_alloc[i] = 4;* 				else' 				    fr_ps->header->tc_alloc[i] = 0;/ 			    }    
 			    break;e 		}  	    }  T 	    for (i = 8; i < 12; i++)    /*taking the average scalefactor of each sb-group*/ 	    { 		for (k = 2; k < 7; k++)  		{  		    min2[k][i] = 0.0;	 a< 		    for (l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)  			min2[k][i] += max_sc[k][l];	 A 		    min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); i 		}c  G 		if (((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)_ 		{ " 		    if (min2[6][i] < min2[5][i]) 			min = 6;M( 		    else if (min2[6][i] == min2[5][i]) 		    {3  			if (min2[3][i] <= min2[5][i]) 			    min = 5;  			else  			    min = 6;	           		    })
 		    else 			min = 5;  		}   L 		else if (((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC) 		{_ 		    min = 6;) 		    /* 01/03/1995 JMZ Simplification */[ 		}  ] 		else   	  	      		{m 		    min = 2; 		}  		 		switch (min) 		{]? 		    case 5: if (min2[4][i] <= min2[6][i])  /* left front,Rs*/E# 				fr_ps->header->tc_alloc[i] = 1;e 			    else)* 				fr_ps->header->tc_alloc[i] = 7;  /*R*/
 			    break;p@ 		    case 6: if (min2[3][i] <= min2[5][i])  /* right front,Ls*/# 				fr_ps->header->tc_alloc[i] = 2;	 			    elsel, 				fr_ps->header->tc_alloc[i] = 6;  /* L */
 			    break;xS 		    case 2: if (((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)  			    {# 				if (min2[4][i] <= min2[6][i])  {' 				    fr_ps->header->tc_alloc[i] = 3;b 				else' 				    fr_ps->header->tc_alloc[i] = 5;t
 			    }   			    elses 			    {K 				if (((20 * log10(min2[4][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)  =' 				    fr_ps->header->tc_alloc[i] = 4;t 				else' 				    fr_ps->header->tc_alloc[i] = 0;s 			    }    
 			    break;  		}  	    } 	}     },  *     /* 01/03/1995 JMZ Configuration 3/1 */%     if (surround == 1 && center != 0)r     {l$ 	/* if (matrix == 3)		->tc_alloc = 0, 	   else if (center == 3)	->tc_alloc = 0,3,42 	   else if (matrix == 2)	->tc_alloc = 0,1,2,3,4,5% 	   else				->tc_alloc = 0,1,2,3,4 */    	if (matrix == 3)l 	{!     	    for (i = 0; i < 12; i++)d! 		fr_ps->header->tc_alloc[i] = 0;  	}+ 	else if (center == 3) /* && matrix != 3 */- 	{$ 	    /* 3/1 Phantom Center coding */ 	    for	(i = 0; i < 8; i++) 	    {K 		if (((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)> 		{l& 		    if (max_sc[6][i] < max_sc[5][i])" 			fr_ps->header->tc_alloc[i] = 4;
 		    else" 			fr_ps->header->tc_alloc[i] = 3; 		}  	P 		else if (((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)% 		    fr_ps->header->tc_alloc[i] = 4;; 		else& 		    fr_ps->header->tc_alloc[i] = 0;  	    } * 		! 	    for (i = 8; i < 12; i++)    l 	    { 		for (k = 2; k < 7; k++)	 		{l 		    min2[k][i] = 0.0;	 e< 		    for (l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)$ 			    min2[k][i] += max_sc[k][l];	 A 		    min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]);   		}e 		    G 		if (((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)1 		{f" 		    if (min2[6][i] < min2[5][i])" 			fr_ps->header->tc_alloc[i] = 4; 		    else 	" 			fr_ps->header->tc_alloc[i] = 3; 		}  _ 		else 	K 		    if (((20 * log10(min2[3][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)o" 			fr_ps->header->tc_alloc[i] = 4; 		    else   	# 			fr_ps->header->tc_alloc[i] = 0; a 	    } o 	}		 	elsea /* 		if(matrix==2)a 		{    o 		}= 		else */ 	{		' 	    /* 3/1 no Phantom Center coding */_ 	    for (i = 0; i < 8; i++) 	    {K 		if (((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)  		{p& 		    if (max_sc[6][i] < max_sc[5][i]) 			min = 6; 
 		    else 			min = 5;* 		}  *P 		else if (((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC) 		    min = 6; 		else   	  	    f 		    min = 2; 	n 		switch (min) 		{ - 		    case 5: fr_ps->header->tc_alloc[i] = 1;t
 			    break;   - 		    case 6: fr_ps->header->tc_alloc[i] = 2;)
 			    break;  		    W 		    case 2: if (((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)x 			    {' 				if (max_sc[6][i] <= max_sc[5][i])   ' 				    fr_ps->header->tc_alloc[i] = 4;* 				else' 				    fr_ps->header->tc_alloc[i] = 3;*
 			    }   			    else* 			    {O 				if (((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)   ' 				    fr_ps->header->tc_alloc[i] = 4;e 				else' 				    fr_ps->header->tc_alloc[i] = 0;b 			    }    
 			    break;  		}t 	    }    	    for (i = 8; i < 12; i++)t 	    { 		for (k = 2; k < 7; k++)0 		{S 		    min2[k][i] = 0.0;	  < 		    for (l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)  			min2[k][i] += max_sc[k][l];	 A 		    min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 3 		}   G 		if (((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)n 		{ " 		    if (min2[6][i] < min2[5][i]) 			min = 6;*
 		    else 			min = 5;/ 		}  dL 		else if (((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC) 		    min = 6; 		else   	  	      		    min = 2; 	  		switch (min) 		{n- 		    case 5: fr_ps->header->tc_alloc[i] = 1;;
 			    break;   - 		    case 6: fr_ps->header->tc_alloc[i] = 2;o
 			    break;2 		    S 		    case 2: if (((20 * log10(min2[3][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)0 			    {# 				if (min2[6][i] <= min2[5][i])  0' 				    fr_ps->header->tc_alloc[i] = 4;0 				else' 				    fr_ps->header->tc_alloc[i] = 3; 
 			    }   			    else{ 			    {K 				if (((20 * log10(min2[3][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)  t' 				    fr_ps->header->tc_alloc[i] = 4;/ 				else' 				    fr_ps->header->tc_alloc[i] = 0;< 			    }    
 			    break;* 		}0 	    } 	}     }2      11     /* 01/03/1995 JMZ Configuration 3/0 (+2/0) */_8     if (center != 0 && (surround == 3 || surround == 0))     {   	if (matrix == 3 || center == 3) 	{!     	    for (i = 0; i < 12; i++)1! 		fr_ps->header->tc_alloc[i] = 0;s 	}. /* 02/02/97 FdB no matrix == 2 allowed for 3/0 	else if (matrix == 2)   	{ 		for(i = 0; i < 8; i++) 		{ K 			if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC); 			{# 				if(max_sc[6][i] < max_sc[5][i])o$ 					fr_ps->header->tc_alloc[i] = 2;) 				else 	fr_ps->header->tc_alloc[i] = 1;l 			}  Q 			else 	if(((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)0$ 					fr_ps->header->tc_alloc[i] = 2;, 				else   	fr_ps->header->tc_alloc[i] = 0;  		}  		 		for(i = 8; i < 12; i++)    		for(k = 2; k < 7; k++) 			min2[k][i] = 0.0;	   l 		for(i = 8; i < 12; i++)    ( 		{  			for(k = 2; k < 7; k++)l 			{9 				for(l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)= 				{	" 					min2[k][i] += max_sc[k][l];	  				}*? 				min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); * 			} 		G 			if(((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)  			{ 				if(min2[6][i] < min2[5][i])e$ 					fr_ps->header->tc_alloc[i] = 2;) 				else 	fr_ps->header->tc_alloc[i] = 1;i 			}  M 			else 	if(((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)	$ 					fr_ps->header->tc_alloc[i] = 2;, 				else   	fr_ps->header->tc_alloc[i] = 0;  		}  	} */ 	elsea 	{	2 	    for (i = 0; i < 8; i++) 	    {K 		if (((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)  		{T& 		    if (max_sc[6][i] < max_sc[5][i]) 			min = 6; 
 		    else 			min = 5;  		}  5P 		else if (((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC) 		    min = 6; 		else   	  	    p 		    min = 2;   		switch (min) 		{ - 		    case 5: fr_ps->header->tc_alloc[i] = 1;a
 			    break;   - 		    case 6: fr_ps->header->tc_alloc[i] = 2;=
 			    break;s  - 		    case 2: fr_ps->header->tc_alloc[i] = 0; 
 			    break;  		}  	    }   	    for (i = 8; i < 12; i++)i 	    { 		for (k = 2; k < 7; k++)  		{L 		    min2[k][i] = 0.0;	 x< 		    for (l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)  			min2[k][i] += max_sc[k][l];	 A 		    min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); { 		}	  G 		if (((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)_ 		{	" 		    if (min2[6][i] < min2[5][i]) 			min = 6;	
 		    else 			min = 5;l 		}  =L 		else if (((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC) 		    min = 6; 		else   	  	    c 		    min = 2; 	p 		switch (min) 		{=- 		    case 5: fr_ps->header->tc_alloc[i] = 1;	
 			    break;l  - 		    case 6: fr_ps->header->tc_alloc[i] = 2; 
 			    break;=  - 		    case 2: fr_ps->header->tc_alloc[i] = 0; 
 			    break;  		}o 	    } 	}     }   *     /* 01/03/1995 JMZ Configuration 2/2 */%     if (center == 0 && surround == 2)      {i 	if (matrix == 3)i 	{!     	    for (i = 0; i < 12; i++)]! 		fr_ps->header->tc_alloc[i] = 0;  	} 	else	 	{ 	    for (i = 0; i < 8; i++) 	    {K 		if (((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)l 		{ & 		    if (max_sc[6][i] < max_sc[3][i])" 			fr_ps->header->tc_alloc[i] = 3; 		    else 	" 			fr_ps->header->tc_alloc[i] = 2; 		}   P 		else if (((20 * log10(max_sc[3][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC)% 		    fr_ps->header->tc_alloc[i] = 1;[ 		else   	  	    R% 		    fr_ps->header->tc_alloc[i] = 0;1 	    }   	    for (i = 8; i < 12; i++)l 	    { 		for (k = 2; k < 7; k++)  		{  		    min2[k][i] = 0.0;	 i< 		    for (l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)  			min2[k][i] += max_sc[k][l];	 A 		    min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); ( 		}*  G 		if (((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)	 		{i" 		    if (min2[6][i] < min2[3][i])" 			fr_ps->header->tc_alloc[i] = 3; 		    else 	" 			fr_ps->header->tc_alloc[i] = 2; 		}  }L 		else if (((20 * log10(min2[3][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC)% 		    fr_ps->header->tc_alloc[i] = 1;p 		else   	  	    [% 		    fr_ps->header->tc_alloc[i] = 0;e 	    } 	}     }s  	,     /* 01/03/1995 JMZ et Configuration 2/1*/%     if (center == 0 && surround == 1)r     {/ 	if (matrix == 3)u 	{!     	    for (i = 0; i < 12; i++)f! 		fr_ps->header->tc_alloc[i] = 0;  	} 	else	 	{ 	    for (i = 0; i < 8; i++) 	    {K 		if (((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[5][i]))) > TC_ALLOC)  		{i& 		    if (max_sc[6][i] < max_sc[5][i]) 			min = 6;+
 		    else 			min = 5;l 		}  =P 		else if (((20 * log10(max_sc[2][i])) - (20 * log10(max_sc[6][i]))) > TC_ALLOC) 		    min = 6; 		else   	  	    < 		    min = 2; 		 		switch (min) 		{s- 		    case 5: fr_ps->header->tc_alloc[i] = 1;L
 			    break;   - 		    case 6: fr_ps->header->tc_alloc[i] = 2;d
 			    break;  		    - 		    case 2: fr_ps->header->tc_alloc[i] = 0;	
 			    break;  		}  	    }   	    for (i = 8; i < 12; i++)s 	    { 		for (k = 2; k < 7; k++)- 		{e 		    min2[k][i] = 0.0;	 e< 		    for (l = (sb_groups[i-1] + 1); l <= sb_groups[i]; l++)  			min2[k][i] += max_sc[k][l];	 A 		    min2[k][i] = min2[k][i] / (sb_groups[i] - sb_groups[i-1]); 	 		}o  G 		if (((20 * log10(min2[2][i])) - (20 * log10(min2[5][i]))) > TC_ALLOC)m 		{[" 		    if (min2[6][i] < min2[5][i]) 			min = 6;u
 		    else 			min = 5;  		}   L 		else if (((20 * log10(min2[2][i])) - (20 * log10(min2[6][i]))) > TC_ALLOC) 		    min = 6; 		else   	  	    n 		    min = 2; 	> 		switch (min) 		{ - 		    case 5: fr_ps->header->tc_alloc[i] = 1; 
 			    break;	  - 		    case 6: fr_ps->header->tc_alloc[i] = 2; 
 			    break;[ 		    - 		    case 2: fr_ps->header->tc_alloc[i] = 0; 
 			    break;  		}_ 	    } 	}     }c  C     if (fr_ps->header->tc_alloc[0] == fr_ps->header->tc_alloc[1] &&=< 	fr_ps->header->tc_alloc[1] == fr_ps->header->tc_alloc[2] &&< 	fr_ps->header->tc_alloc[2] == fr_ps->header->tc_alloc[3] &&< 	fr_ps->header->tc_alloc[3] == fr_ps->header->tc_alloc[4] &&< 	fr_ps->header->tc_alloc[4] == fr_ps->header->tc_alloc[5] &&< 	fr_ps->header->tc_alloc[5] == fr_ps->header->tc_alloc[6] &&< 	fr_ps->header->tc_alloc[6] == fr_ps->header->tc_alloc[7] &&< 	fr_ps->header->tc_alloc[7] == fr_ps->header->tc_alloc[8] &&< 	fr_ps->header->tc_alloc[8] == fr_ps->header->tc_alloc[9] &&= 	fr_ps->header->tc_alloc[9] == fr_ps->header->tc_alloc[10] && < 	fr_ps->header->tc_alloc[10] == fr_ps->header->tc_alloc[11]) 	{' 	    fr_ps->header->tc_sbgr_select = 1;{? 	    fr_ps->header->tc_allocation = fr_ps->header->tc_alloc[0];- 	} 	else]> 	    fr_ps->header->tc_sbgr_select = 0; /* added 8/20/93,SR*/  }}    I /************************************************************************a /* /* put_scale   (Layer I) /*= /* PURPOSE:Sets #max_sc# to the scalefactor index in #scalar.h) /* This is used by Psychoacoustic Model I  /*J /************************************************************************/   X void put_scale(unsigned int (*scalar)[3][32], frame_params *fr_ps, double (*max_sc)[32])#                                    m                     "        /*far*/                     {     int i,j,k, max;    int stereo  = fr_ps->stereo;["    int stereomc = fr_ps->stereomc;     int sblimit = fr_ps->sblimit;  [T /*	for (k = 0; k < stereo+stereomc+2; k++) 960814 FdB bug for some configurations */ 	for (k = 0; k < 7; k++)! 	   for (i = 0; i < SBLIMIT; i++) 7               max_sc[k][i] = multiple[scalar[k][0][i]];t }(  )I /************************************************************************	 /** /* II_transmission_pattern (Layer II only) /*C /* PURPOSE:For a given subband, determines whether to send 1, 2, or : /* all 3 of the scalefactors, and fills in the scalefactor! /* select information accordingly- /*I /* SEMANTICS:  The subbands and channels are classified based on how much @ /* the scalefactors changes over its three values (corresponding@ /* to the 3 sets of 12 samples per subband).  The classificationE /* will send 1 or 2 scalefactors instead of three if the scalefactors0; /* do not change much.  The scalefactor select information, % /* #scfsi#, is filled in accordingly.o /*J /************************************************************************/   l void II_transmission_pattern (unsigned int (*scalar)[3][32], unsigned int (*scfsi)[32], frame_params *fr_ps) {       int stereo  = fr_ps->stereo;#     int stereomc = fr_ps->stereomc;      int sblimit;'     int sblimit_mc = fr_ps->sblimit_mc;x'     int sblimit_ml = fr_ps->sblimit_ml; .     int n_ml_ch = fr_ps->header->multiling_ch;       int dscf[2];     int class[2],i,j,k;;  > static int pattern[5][5] = {0x123, 0x122, 0x122, 0x133, 0x123,>                             0x113, 0x111, 0x111, 0x444, 0x113,>                             0x111, 0x111, 0x111, 0x333, 0x113,>                             0x222, 0x222, 0x222, 0x333, 0x123,?                             0x123, 0x122, 0x122, 0x133, 0x123};   ;;     if (stereomc > 0 && fr_ps->sblimit_mc > fr_ps->sblimit)	 	sblimit = fr_ps->sblimit_mc;      else 	sblimit = fr_ps->sblimit;  U /*  for (k = 0; k < stereo+stereomc+2; k++) 960814 FdB bug for some configurations */g     for (k = 0; k < 12; k++) 	for (i = 0; i < SBLIMIT; i++)   	{3 	    dscf[0] = (scalar[k][0][i] - scalar[k][1][i]);i3 	    dscf[1] = (scalar[k][1][i] - scalar[k][2][i]);; 	    for (j = 0; j < 2; j++) 	    { 	        if (dscf[j] <= -3)( 		    class[j] = 0;). 	        else if (dscf[j] > -3 && dscf[j] < 0) 		    class[j] = 1;l 		else if (dscf[j] == 0) 		    class[j] = 2;[& 		else if (dscf[j] > 0 && dscf[j] < 3) 		    class[j] = 3;  		else 		    class[j] = 4;g 	    }* 	    switch (pattern[class[0]][class[1]])  	    {' 	      case 0x123 :    scfsi[k][i] = 0;] 			      break; ' 	      case 0x122 :    scfsi[k][i] = 3;e+ 			      scalar[k][2][i] = scalar[k][1][i];0 			      break;>' 	      case 0x133 :    scfsi[k][i] = 3; + 			      scalar[k][1][i] = scalar[k][2][i];  			      break;p' 	      case 0x113 :    scfsi[k][i] = 1;k+ 			      scalar[k][1][i] = scalar[k][0][i];] 			      break;e' 	      case 0x111 :    scfsi[k][i] = 2;l= 			      scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];i 			      break; ' 	      case 0x222 :    scfsi[k][i] = 2; = 			      scalar[k][0][i] = scalar[k][2][i] = scalar[k][1][i];< 			      break;+' 	      case 0x333 :    scfsi[k][i] = 2; = 			      scalar[k][0][i] = scalar[k][1][i] = scalar[k][2][i];  			      break;0' 	      case 0x444 :    scfsi[k][i] = 2;5/ 			      if (scalar[k][0][i] > scalar[k][2][i])<( 				  scalar[k][0][i] = scalar[k][2][i];= 			      scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];* 	g 	m 	    } /* switch */O 	} /* subband */       if (n_ml_ch > 0)     { " 	for (k = 7; k < 7 + n_ml_ch; k++)& 	    for (i = 0; i < sblimit_ml; i++)  	    {0 		dscf[0] = (scalar[k][0][i] - scalar[k][1][i]);0 		dscf[1] = (scalar[k][1][i] - scalar[k][2][i]); 		for (j = 0; j < 2; j++)  		{  		    if (dscf[j] <= -3) 			class[j] = 0;+ 		    else if (dscf[j] > -3 && dscf[j] < 0)( 			class[j] = 1; 		    else if (dscf[j] == 0) 			class[j] = 2;* 		    else if (dscf[j] > 0 && dscf[j] < 3) 			class[j] = 3;
 		    else 			class[j] = 4; 		} ' 		switch (pattern[class[0]][class[1]]) g 		{x$ 		  case 0x123 :    scfsi[k][i] = 0; 				  break;$ 		  case 0x122 :    scfsi[k][i] = 3;( 				  scalar[k][2][i] = scalar[k][1][i]; 				  break;$ 		  case 0x133 :    scfsi[k][i] = 3;( 				  scalar[k][1][i] = scalar[k][2][i]; 				  break;$ 		  case 0x113 :    scfsi[k][i] = 1;( 				  scalar[k][1][i] = scalar[k][0][i]; 				  break;$ 		  case 0x111 :    scfsi[k][i] = 2;: 				  scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i]; 				  break;$ 		  case 0x222 :    scfsi[k][i] = 2;: 				  scalar[k][0][i] = scalar[k][2][i] = scalar[k][1][i]; 				  break;$ 		  case 0x333 :    scfsi[k][i] = 2;: 				  scalar[k][0][i] = scalar[k][1][i] = scalar[k][2][i]; 				  break;$ 		  case 0x444 :    scfsi[k][i] = 2;, 				  if (scalar[k][0][i] > scalar[k][2][i]), 				      scalar[k][0][i] = scalar[k][2][i];: 				  scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i]; 		} /* switch */ 	    } /* subband */     }) }(  *I /************************************************************************	 /* /* I_encode_scale  (Layer I) /* II_encode_scale (Layer II)  /*@ /* PURPOSE:The encoded scalar factor information is arranged and1 /* queued into the output fifo to be transmitted.  /*8 /* For Layer II, the three scale factors associated with< /* a given subband and channel are transmitted in accordance. /* with the scfsi, which is transmitted first. /*J /************************************************************************/  ]| void I_encode_scale(unsigned int (*scalar)[3][32], unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs) {L    int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;    int i,j;s  	1    for (i=0;i<SBLIMIT;i++) for (j=0;j<stereo;j++) 9       if (bit_alloc[j][i]) putbits(bs,scalar[j][0][i],6);  }   bJ /***************************** Layer II  ********************************/   void II_encode_scale ( 	unsigned int (*bit_alloc)[32],  	unsigned int (*scfsi)[32],	A 	unsigned int (*scalar)[3][32], /* JMZ 08/03/1995 Multilingual */; 	unsigned int lfe_alloc, 	 	unsigned int lfe_scalar,  	frame_params *fr_ps,m 	Bit_stream_struc *bs, 	int *l, 	int *z; )  {o#    layer *info     = fr_ps->header; "    int center      = info->center;$    int surround    = info->surround;    int stereo  = fr_ps->stereo;     int sblimit; $    int lfe     = fr_ps->header->lfe;    int i,j,k, m, n, pci;    int pred;       if (*l == 0) 	sblimit = fr_ps->sblimit;     else 	sblimit = fr_ps->sblimit_mc;a  !     for (i = 0; i < sblimit; i++)      {  	n = sbgrp[i]; 	for (m = *l; m < *z; m++) 	{, 	    k = transmission_channel (fr_ps, n, m);  > 	    if (bit_alloc[k][i] && (i < 12 || m != 2 || center != 3)) 		putbits (bs, scfsi[k][i], 2);a 	}     }o  
     pred = 0;a     if (*l == stereo)f     {e* 	if (fr_ps->header->mc_prediction_on == 1) 	{ 	    for (i = 0; i < 8; i++) 	    {, 	        if (fr_ps->header->mc_pred[i] == 1)
 	        {D 		    for (m = 0; m < n_pred_coef[fr_ps->header->dyn_cross[i]]; m++) 		    {c/ 		        if (fr_ps->header->predsi[i][m] != 0)s 		        {a? 		            putbits (bs, fr_ps->header->delay_comp[i][m], 3);c 			    pred += 3;d> 			    for (pci = 0; pci < fr_ps->header->predsi[i][m]; pci++) 			    {9 				putbits (bs, fr_ps->header->pred_coef[i][m][pci], 8);l 				pred += 8;			      c 			    } 		        }    d 		    }l
 	        } 	    } 	}       }  1   )     if (*l == stereo && lfe && lfe_alloc){ 	putbits (bs, lfe_scalar, 6);t  !     for (i = 0; i < sblimit; i++)}     {] 	n = sbgrp[i]; 	for (m = *l; m < *z; m++) 	{, 	    k = transmission_channel (fr_ps, n, m);  G             if (bit_alloc[k][i] && (i < 12 || m != 2 || center != 3))  ( 	    switch (scfsi[k][i])  	    {! 		case 0: for (j = 0; j < 3; j++)l=                             putbits (bs, scalar[k][j][i], 6);*	 			break;*	 		case 1:*+ 		case 3:	putbits (bs, scalar[k][0][i], 6); $ 			putbits (bs, scalar[k][2][i], 6);	 			break;m+ 		case 2: putbits (bs, scalar[k][0][i], 6);  	    } 	}     }	 }    ) /*JMZ 24/2/95 Multilingual , WtK 7/8/95*/ R void II_encode_scale_ml (unsigned int (*bit_alloc)[32], unsigned int (*scfsi)[32],7 			 unsigned int (*scalar)[3][32], frame_params *fr_ps,i) 			 Bit_stream_struc *bs, int *l, int *z)2 {+!    int stereo    = fr_ps->stereo;a&    int sblimit_ml = fr_ps->sblimit_ml;    int i,j,k, m, n, pci;   for (i=0;i<sblimit_ml;i++)   for (m = *l; m < *z; m++)] 	{ 	k=m;  	if (bit_alloc[k][i])  * 		putbits(bs,scfsi[k][i],2); 	} for (i=0;i<sblimit_ml;i++)   for (m = *l;m < *z; m++) 	{ 	k=m;  	if (bit_alloc[k][i])  b 		switch (scfsi[k][i]) t 		{d 			case 0: for (j=0;j<3;j++)" 				putbits(bs,scalar[k][j][i],6);
 				break;
 			case 1:) 			case 3: putbits(bs,scalar[k][0][i],6);b" 				putbits(bs,scalar[k][2][i],6);
 				break;) 			case 2: putbits(bs,scalar[k][0][i],6);t
 				break; 		}e 	}	i }   J /*=======================================================================\J |                                                                        |J |      The following routines are done after the masking threshold       |J | has been calculated by the fft analysis routines in the Psychoacoustic |J | model. Using the MNR calculated, the actual number of bits allocated   |J | to each subband is found iteratively.                                  |J |                                                                        |J \=======================================================================*/   I /************************************************************************l /*  /* I_bits_for_nonoise  (Layer I)! /* II_bits_for_nonoise (Layer II)  /*; /* PURPOSE:Returns the number of bits required to produce axG /* mask-to-noise ratio better or equal to the noise/no_noise threshold.  /*
 /* SEMANTICS: 3 /* bbal = # bits needed for encoding bit allocation C /* bsel = # bits needed for encoding scalefactor select informationoA /* banc = # bits needed for ancillary data (header info included)b /*? /* For each subband and channel, will add bits until one of the  /* following occurs:@ /* - Hit maximum number of bits we can allocate for that subband= /* - MNR is better than or equal to the minimum masking level= /*   (NOISY_MIN_MNR)B /* Then the bits required for scalefactors, scfsi, bit allocation,A /* and the subband samples are tallied (#req_bits#) and returned.3 /*F /* (NOISY_MIN_MNR) is the smallest MNR a subband can have before it isA /* counted as 'noisy' by the logic which chooses the number of JS  /* subbands. /* /* Joint stereo is supported.s /*J /************************************************************************/  ; /*static double snr[18] = {0.00, 7.00, 11.00, 16.00, 20.84, 4                          25.28, 31.59, 37.75, 43.84,;                          49.89, 55.93, 61.96, 67.98, 74.01,b7                          80.03, 86.05, 92.01, 98.01};*/ E static double snr[18] = { 0.00,  6.03, 11.80, 15.81, /* 0, 3, 5, 7 */10 			 19.03, 23.50, 29.82, 35.99, /* 9,15,31,63 */0 			 42.08, 48.13, 54.17, 60.20, /* 127, ...   */0 			 66.22, 72.25, 78.27, 84.29, /* 2047, ...  */0 			 90.31, 96.33};              /* 16383, ... */  C int I_bits_for_nonoise(double (*perm_smr)[32], frame_params *fr_ps)[ {0
    int i,j,k;]    int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;    int req_bits = 0;  [/    /* initial b_anc (header) allocation bits */cB    req_bits = 32 + 4 * ( (jsbound * stereo) + (SBLIMIT-jsbound) );  [    for(i=0; i<SBLIMIT; ++i)].      for(j=0; j<((i<jsbound)?stereo:1); ++j) {        for(k=0;k<14; ++k)[4 			if( (-perm_smr[j][i] + snr[k]) >= fr_ps->mnr_min),            break; /* we found enough bits */I          if(stereo == 2 && i >= jsbound)     /* check other JS channel */             for(;k<14; ++k)? 				 if( (-perm_smr[1-j][i] + snr[k]) >= fr_ps->mnr_min) break;[B          if(k>0) req_bits += (k+1)*12 + 6*((i>=jsbound)?stereo:1);    }    return req_bits;i }d  [J /***************************** Layer II  ********************************/  ax int II_bits_for_nonoise(double (*perm_smr)[32], unsigned int (*scfsi)[32], frame_params *fr_ps, int a, int b, int *aiff) {r     int sb,ch,ba,i;)      int stereo  = fr_ps->stereo;#     int stereomc = fr_ps->stereomc;0%     int stereoaug = fr_ps->stereoaug;rP     int n_ml_ch = fr_ps->header->multiling_ch;	/* 23/03/1995 JMZ Multilingual */!     int sblimit = fr_ps->sblimit;]'     int sblimit_mc = fr_ps->sblimit_mc;c'     int sblimit_ml = fr_ps->sblimit_ml;c!     int jsbound = fr_ps->jsbound;a#     al_table *alloc = fr_ps->alloc; )     al_table *alloc_mc = fr_ps->alloc_mc;k)     al_table *alloc_ml = fr_ps->alloc_ml;      int bbal = 0;	>     int berr;		                  /* before: =0 92-08-11 shn */?     int banc = 32; 	                  /* header ISO Layer II */iW     int bancmc = 0;                            /* header multichannel = 93, 5.7.93,SR*/;R     int bancext = 0;                      /* header multichannel = 93, 5.7.93,SR*/.     int maxAlloc, sel_bits, sc_bits, smp_bits;     int req_bits = 0;	*     int tca_bits, dynx_bits, aug_tca_bits;K     static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */*  5     if (verbosity >= 3) printf("bits_for_nonoise\n");a       if( *aiff == 1)P     { 0 	if (fr_ps->header->ext_bit_stream_present == 0)L 	    bancmc += 35;      /* mc_header + crc + tc_sbgr_select+ dyn_cross_on + 9 				mc_prediction_on  01/05/94,  SR  new! 05/04/94,  SR*/a 	elsen 	{ 	    bancmc += 43;			    e 	    bancext = 40; 	}  5 	/* 960627 FdB TCA bits dependent on configuration */* 	if (fr_ps->config == 320) 	    tca_bits = 3; 	else if (fr_ps->config == 310)i 	    tca_bits = 3; 	else if (fr_ps->config == 220)r 	    tca_bits = 2;O 	else if (fr_ps->config == 300 || fr_ps->config == 302 || fr_ps->config == 210)s 	    tca_bits = 2; 	else	 	    tca_bits = 0;     ( 	if (fr_ps->header->tc_sbgr_select == 0) 	    bancmc += 12 * tca_bits;j 	else, 	    bancmc += tca_bits;	*  & 	if (fr_ps->header->dyn_cross_on == 1) 	{5 	    /* 960627 FdB DynX dependent on configuration */  	    if (fr_ps->config == 320) 		dynx_bits = 4;; 	    else if (fr_ps->config == 310 || fr_ps->config == 220)l 		dynx_bits = 3;S 	    else if (fr_ps->config == 300 || fr_ps->config == 302 || fr_ps->config == 210)  		dynx_bits = 1;	 	    else  		dynx_bits = 0;     ! 	    bancmc = 1 + 12 * dynx_bits; & 	    if (fr_ps->header->surround == 3)D 		bancmc += 12;      /* now with dyn_second_stereo,  17/02/95,  SR*/ 	}     * 	if (fr_ps->header->mc_prediction_on == 1) 	{1 	    /* mc_pred, predsi, delay_comp, pred_coef */_/ 	    /* bancmc += 8 * (3 + 6 * (3 + 3 * 8)); */_ 	    for (i = 0; i < 8; i++) 	    { 		bancmc += 3;: 		bancmc += n_pred_coef[fr_ps->header->dyn_cross[i]] * 27; 	    } 	}	e      #ifdef Augmentation_7cht 	if (stereoaug == 2) 	{* 	    if (fr_ps->header->aug_mtx_proc == 0) 		aug_tca_bits = 3; / 	    else if (fr_ps->header->aug_mtx_proc == 1)  		aug_tca_bits = 2;d	 	    elsei 		aug_tca_bits = 0;      ! 	    bancmc += 12 * aug_tca_bits;      . 	    if (fr_ps->header->aug_dyn_cross_on == 1) 		bancmc += 12 * 5;_ 	} #endif
     }          else 	bancmc = 0;  (     if (fr_ps->header->error_protection)	 	berr=16;s     else! 	berr=0; /* added 92-08-11 shn */_  $     for (sb = 0; sb < jsbound; sb++)) 	bbal += (stereo) * (*alloc)[sb][0].bits;f*     for (sb = jsbound; sb < sblimit; sb++)2 	bbal += (stereo-1) * (*alloc)[sb][0].bits;     	 '     for (sb = 0; sb < sblimit_mc; sb++) ? 	bbal += (stereomc+stereoaug) * (*alloc_mc)[sb][0].bits;     	 1'     for (sb = 0; sb < sblimit_ml; sb++)a4 	bbal += (n_ml_ch) * (*alloc_ml)[sb][0].bits;     	   +     req_bits = banc + bancmc + bbal + berr;   $     for (sb = 0; sb < SBLIMIT; sb++)I 	for (ch = 0; ch < ((sb < jsbound)? stereo+stereomc+stereoaug : 1); ch++)( 	{ 	    if (ch < stereo)! 	    { 		alloc = fr_ps->alloc;] 		sblimit = fr_ps->sblimit;= 	    }	 	    else  	    { 		alloc = fr_ps->alloc_mc; 		sblimit = fr_ps->sblimit_mc; 	    } 	    if (sb < sblimit) 	    {) 		maxAlloc = (1<<(*alloc)[sb][0].bits)-1;l$ 		sel_bits = sc_bits = smp_bits = 0;% 		for (ba = 0; ba < maxAlloc-1; ba++) J 		    if ((-perm_smr[ch][sb] + snr[(*alloc)[sb][ba].quant + ((ba>0)?1:0)]) 				    >= fr_ps->mnr_min)	 			break;l( 		if (((b - a) >= 1) && (sb >= jsbound))! 		{ /* check other JS channels */e# 		    for (; ba < maxAlloc-1; ba++)cI 			if ((-perm_smr[1-ch][sb] + snr[(*alloc)[sb][ba].quant + ((ba>0)?1:0)])m 				   >= fr_ps->mnr_min) 
 			    break;, 		}c 	    		if (ba > 0)  		{;G 		    smp_bits = 12 * ((*alloc)[sb][ba].group * (*alloc)[sb][ba].bits); 2 		    /* scale factor bits required for subband */ 		    sel_bits = 2;*0 		    sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];    	' 		    if (stereo == 2 && sb >= jsbound)f 		    {<% 			/* each new js sb has L+R scfsis*/6 			sel_bits += 2;c0 			sc_bits  += 6 * sfsPerScfsi[scfsi[1-ch][sb]]; 		    }     s. 		    req_bits += (smp_bits+sel_bits+sc_bits); 		}b 	    } 	}       if (n_ml_ch > 0)     {}K 	/* remaining part from jsbound to sblimit_ml in II_bits_for_indi() , WtK*/=E 	for (sb = 0; sb < (jsbound < sblimit_ml) ? jsbound:sblimit_ml; sb++)  	{) 	    for (ch = 7; ch < 7+n_ml_ch; ch++)  o 	    {, 		maxAlloc = (1<<(*alloc_ml)[sb][0].bits)-1;$ 		sel_bits = sc_bits = smp_bits = 0;% 		for (ba = 0; ba < maxAlloc-1; ba++)tM 		    if ((-perm_smr[ch][sb] + snr[(*alloc_ml)[sb][ba].quant + ((ba>0)?1:0)])s 				 >= fr_ps->mnr_min)  			break;	         		if (ba > 0)  		{ ) 		    if (fr_ps->header->multiling_fs==1) J 			smp_bits =  6 * ((*alloc_ml)[sb][ba].group * (*alloc_ml)[sb][ba].bits);
 		    elseJ 			smp_bits = 12 * ((*alloc_ml)[sb][ba].group * (*alloc_ml)[sb][ba].bits);  2 		    /* scale factor bits required for subband */ 		    sel_bits = 2;a0 		    sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];  . 		    req_bits += (smp_bits+sel_bits+sc_bits); 		}  	    } 	}     }s       return req_bits; }     I /**********************************************************************/  H /*now for the independent channels, 8/6/93, SR                        */H /**********************************************************************/w int II_bits_for_indi(double (*perm_smr)[32], unsigned int (*scfsi)[32], frame_params *fr_ps, int *a, int *b, int *aiff)o {h     int sb,ch,ba,i;i      int stereo  = fr_ps->stereo;#     int stereomc = fr_ps->stereomc;N%     int stereoaug = fr_ps->stereoaug;fP     int n_ml_ch = fr_ps->header->multiling_ch;	/* 23/03/1995 JMZ Multilingual */$     int sblimit = fr_ps->sblimit_mc;'     int sblimit_ml = fr_ps->sblimit_ml; !     int jsbound = fr_ps->jsbound; &     al_table *alloc = fr_ps->alloc_mc;)     al_table *alloc_ml = fr_ps->alloc_ml;s     int req_bits = 0;*.     int maxAlloc, sel_bits, sc_bits, smp_bits;K     static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */.  *     for (sb = jsbound; sb < sblimit; sb++)     {39 	for (ch = stereo; ch < stereo+stereomc+stereoaug; ch++) 7 	{, 	    maxAlloc = (1<<(*alloc)[sb][0].bits)-1;' 	    sel_bits = sc_bits = smp_bits = 0; ( 	    for (ba = 0; ba < maxAlloc-1; ba++)F 		if ((-perm_smr[ch][sb] + snr[(*alloc)[sb][ba].quant + ((ba>0)?1:0)]) 			 >= fr_ps->mnr_min)( 		    break;		/* we found enough bits */   	    if (ba > 0) 0 	    {C 		smp_bits = 12 * ((*alloc)[sb][ba].group * (*alloc)[sb][ba].bits);*. 		/* scale factor bits required for subband */ 		sel_bits = 2;s, 		sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];( 		req_bits += smp_bits+sel_bits+sc_bits; 	    } 	}     }t       if (n_ml_ch > 0)* 	for (sb = jsbound; sb < sblimit_ml; sb++) 	{( 	    for (ch = 7; ch < 7+n_ml_ch; ch++)  	    {, 		maxAlloc = (1<<(*alloc_ml)[sb][0].bits)-1;$ 		sel_bits = sc_bits = smp_bits = 0;% 		for (ba = 0; ba < maxAlloc-1; ba++)(M 		    if ((-perm_smr[ch][sb] + snr[(*alloc_ml)[sb][ba].quant + ((ba>0)?1:0)])n 			  >= fr_ps->mnr_min)(% 			break;		/* we found enough bits */c   		if (ba > 0)  		{ + 		    if (fr_ps->header->multiling_fs == 1)mJ 			smp_bits =  6 * ((*alloc_ml)[sb][ba].group * (*alloc_ml)[sb][ba].bits);
 		    elseJ 			smp_bits = 12 * ((*alloc_ml)[sb][ba].group * (*alloc_ml)[sb][ba].bits);  3 		     /* scale factor bits required for subband */* 		    sel_bits = 2;t0 		    sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]];  , 		    req_bits += smp_bits+sel_bits+sc_bits; 		 } 	    } 	}       return req_bits; }n   	     I /************************************************************************  /*$ /* I_main_bit_allocation   (Layer I)% /* II_main_bit_allocation  (Layer II)J /*A /* PURPOSE:For joint stereo mode, determines which of the 4 joint_B /* stereo modes is needed.  Then calls *_a_bit_allocation(), whichG /* allocates bits for each of the subbands until there are no more bits 7 /* left, or the MNR is at the noise/no_noise threshold.* /*
 /* SEMANTICS:l /*> /* For joint stereo mode, joint stereo is changed to stereo if? /* there are enough bits to encode stereo at or better than the*> /* no-noise threshold (fr_ps->mnr_min).  Otherwise, the systemB /* iteratively allocates less bits by using joint stereo until one /* of the following occurs:h= /* - there are no more noisy subbands (MNR >= fr_ps->mnr_min)sA /* - mode_ext has been reduced to 0, which means that all but thex? /*   lowest 4 subbands have been converted from stereo to joint 2 /*   stereo, and no more subbands may be converted /*I /*     This function calls *_bits_for_nonoise() and *_a_bit_allocation()._ /*J /************************************************************************/  cp void I_main_bit_allocation(double (*perm_smr)[32], unsigned int (*bit_alloc)[32], int *adb, frame_params *fr_ps) {m    int  noisy_sbs;    int  mode, mode_ext, lay, i;7    int  rq_db, av_db = *adb; static  int init = 0;_  >    if(init == 0) {$      /* rearrange snr for layer I */      snr[2] = snr[3];t*      for (i=3;i<16;i++) snr[i] = snr[i+2];      init = 1;    }  f;    if((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO) {i)      fr_ps->header->mode = MPG_MD_STEREO; !      fr_ps->header->mode_ext = 0;e%      fr_ps->jsbound = fr_ps->sblimit; =      if(rq_db = I_bits_for_nonoise(perm_smr, fr_ps) > *adb) {f1        fr_ps->header->mode = MPG_MD_JOINT_STEREO;7@        mode_ext = 4;           /* 3 is least severe reduction */         lay = fr_ps->header->lay;        do {c           --mode_ext;c3           fr_ps->jsbound = js_bound(lay, mode_ext);-6           rq_db = I_bits_for_nonoise(perm_smr, fr_ps);2        } while( (rq_db > *adb) && (mode_ext > 0));*        fr_ps->header->mode_ext = mode_ext;D      }    /* well we either eliminated noisy sbs or mode_ext == 0 */    }C    noisy_sbs = I_a_bit_allocation(perm_smr, bit_alloc, adb, fr_ps);c }e  t  _  J /***************************** Layer II  ********************************/  + void II_main_bit_allocation (_U 	double (*perm_smr)[32], /* minimum masking level *//* JMZ 08/03/1995 Multilingual */hR 	double (*ltmin)[32], /* minimum masking level *//* JMZ 08/03/1995 Multilingual */= 	unsigned int (*scfsi)[32], /* JMZ 08/03/1995 Multilingual */uA 	unsigned int (*bit_alloc)[32], /* JMZ 08/03/1995 Multilingual */ 
 	int *adb, 	frame_params *fr_ps,	 	int *aiff,=B 	double (*sb_sample)[3][12][32], /* JMZ 08/03/1995 Multilingual */A 	unsigned int (*scalar)[3][32], /* JMZ 08/03/1995 Multilingual */ 8 	double (*max_sc)[32], /* JMZ 08/03/1995 Multilingual */: 	double (*buffer)[1152], /* JMZ 08/03/1995 Multilingual */7 	double (*spiki)[32], /* JMZ 08/03/1995 Multilingual */)# 	double (*joint_sample)[3][12][32],.! 	unsigned int (*j_scale)[3][32],  
 	int dyn_cr,   	int aug_dyn_cr,  % 	unsigned int (*scfsi_dyn)[SBLIMIT],  ' 	unsigned int (*scalar_dyn)[3][SBLIMIT]= )t {o     int noisy_sbs, nn;(     int mode, mode_ext, lay, modemc_hlp;5     int rq_db, av_db = *adb, bits_nonoise, bits_indi;m     int a, b, i, l, m, sb, k;e     int sbbound = -30;     float adb_help;       double smr_pred[7][SBLIMIT];     float preco[12][4];      float prega[3][32];+%     int bits1, bits2, ba, ba1, subgr;      int maxAlloc; #     al_table *alloc = fr_ps->alloc; %     int stereoaug = fr_ps->stereoaug; K     static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */ ,     double sb_sample_sum[5][3][12][32];	         int subfr, ch, sum_chs;e+     unsigned int scalar_sum[5][3][SBLIMIT]; (     unsigned int scfsi_sum[5][SBLIMIT];   J     /***************************layer II two channels *******************/     if (*aiff == 0)l     {(8 	if ((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO) 	{ 	    a = 0;  	    b = 1; ) 	    fr_ps->header->mode = MPG_MD_STEREO;[! 	    fr_ps->header->mode_ext = 0;(% 	    fr_ps->jsbound = fr_ps->sblimit;nQ 	    if (rq_db = II_bits_for_nonoise (perm_smr, scfsi, fr_ps, a, b, aiff) > *adb)c 	    {, 		fr_ps->header->mode = MPG_MD_JOINT_STEREO;; 		mode_ext = 4;           /* 3 is least severe reduction */* 		lay = fr_ps->header->lay;S 		do 		{c 		  --mode_ext;	. 		  fr_ps->jsbound = js_bound (lay, mode_ext);E 		  rq_db = II_bits_for_nonoise (perm_smr, scfsi, fr_ps, a, b, aiff);s- 		} while ((rq_db > *adb) && (mode_ext > 0)); % 		fr_ps->header->mode_ext = mode_ext;_A 	    }	/* well we either eliminated noisy sbs or mode_ext == 0 *// 	}     } K     /***************** layer II five channels ****************************/      else     {b 	trans_chan (fr_ps); #ifdef Augmentation_7ch  	if (stereoaug == 2)# 	    trans_chan_aug (fr_ps); 		    = #endif 	if (verbosity >= 2) ;e 	    printf ("js actual_mode: %d  mode: %d  mode_ext: %d  jsbound: %d dyn_cr: %2d aug_dyn_cr: %2d\n",]p 	         fr_ps->actual_mode, fr_ps->header->mode, fr_ps->header->mode_ext, fr_ps->jsbound, dyn_cr, aug_dyn_cr);  ! 	for (sb = 0; sb < SBLIMIT; ++sb)l 	{ 	    subgr = sbgrp[sb]; 0 	    maxAlloc = (1 << (*alloc)[sb][0].bits) - 1;( 	    for (ba = 0; ba < maxAlloc-1; ++ba)J 	        if ((-perm_smr[0][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)]) 				>= fr_ps->mnr_min)( 		    break;		/* we found enough bits */+ 	    for (ba1 = 0; ba1 < maxAlloc-1; ++ba1)	E 		if ((-perm_smr[no_channel[fr_ps->header->tc_alloc[subgr]][0]][sb] + 3 		      snr[(*alloc)[sb][ba1].quant+((ba1>0)?1:0)])* 				>= fr_ps->mnr_min)( 		    break;		/* we found enough bits */ 	    if (ba1 > ba) 	    {Y 	        perm_smr[0][sb] = perm_smr[no_channel[fr_ps->header->tc_alloc[subgr]][0]][sb];		* 	        ba = ba1; 	    } 		 n. 	    maxAlloc = (1<<(*alloc)[sb][0].bits) - 1;( 	    for (ba = 0; ba < maxAlloc-1; ++ba)J 	        if ((-perm_smr[1][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)]) 			       >= fr_ps->mnr_min)( 		    break;		/* we found enough bits */+ 	    for (ba1 = 0; ba1 < maxAlloc-1; ++ba1)gL 	        if ((-perm_smr[no_channel[fr_ps->header->tc_alloc[subgr]][1]][sb] +3 		      snr[(*alloc)[sb][ba1].quant+((ba1>0)?1:0)])o 			       >= fr_ps->mnr_min)( 		    break;		/* we found enough bits */ 	    if (ba1 > ba) 	    {Y 	        perm_smr[1][sb] = perm_smr[no_channel[fr_ps->header->tc_alloc[subgr]][1]][sb];		i 	        ba = ba1; 	    } 	}  H 	/************ 05/24/95, SR, dyn_cross talk **********************/	    3 	if (dyn_cr != 0 || (fr_ps->header->dyn_cross_LR &&tO 			    (fr_ps->config == 302 || fr_ps->config == 202 || fr_ps->config == 102)))  	{1 	    combine (fr_ps, sb_sample, sb_sample_sum); 	l     & 	    for (ch = 0; ch < CHANMAX2; ch++) 	    {, 	        for (subfr = 0; subfr < 3; subfr++)- 		    for (sb = 0; sb < fr_ps->sblimit; sb++) = 		        scalar_dyn[ch][subfr][sb] = scalar[ch][subfr][sb]; b     D 	        scfsi_calc_dyn (scalar_dyn, ch, fr_ps->sblimit, scfsi_dyn);8 	        scfsi_calc (scalar, ch, fr_ps->sblimit, scfsi); 	    }      	    if (fr_ps->config == 320) 		sum_chs = 4; 	    else if (fr_ps->config == 302 || fr_ps->config == 310 || fr_ps->config == 220 || fr_ps->config == 202 || fr_ps->config == 102)  		sum_chs = 1;	 	    elsel 		sum_chs = 0;     & 	    for (ch = 0; ch < sum_chs; ch++)  	    {; 		scf_calc (sb_sample_sum, fr_ps->sblimit, ch, scalar_sum);+= 		scfsi_calc_dyn (scalar_sum, ch, fr_ps->sblimit, scfsi_sum);- 	    }U 	    take_dyn_cross (dyn_cr, fr_ps, sb_sample_sum, scalar_sum, scfsi_sum, scfsi_dyn, a& 			    sb_sample, scalar, scfsi); 				 	}  H 	/************ 05/24/95, SR, dyn_cross talk **********************/	     #ifdef Augmentation_7ch[ 	if (aug_dyn_cr != 0)_ 	{5 	    combine_aug (fr_ps, sb_sample, sb_sample_sum); 	f     - 	    for (ch = CHANMAX2; ch < CHANMAX3; ch++)= 	    {, 	        for (subfr = 0; subfr < 3; subfr++)- 		    for (sb = 0; sb < fr_ps->sblimit; sb++) = 		        scalar_dyn[ch][subfr][sb] = scalar[ch][subfr][sb]; *     D 	        scfsi_calc_dyn (scalar_dyn, ch, fr_ps->sblimit, scfsi_dyn);8 	        scfsi_calc (scalar, ch, fr_ps->sblimit, scfsi); 	    }     = 	    scf_calc (sb_sample_sum, fr_ps->sblimit, 4, scalar_sum); ? 	    scfsi_calc_dyn (scalar_sum, 4, fr_ps->sblimit, scfsi_sum);c  F 	    take_dyn_cross_aug (aug_dyn_cr, fr_ps, sb_sample_sum, scalar_sum,9 				scfsi_sum, scfsi_dyn, sb_sample, scalar, scfsi); 				M 	} #endif8 	if ((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO) 	{ 	    a = 0;a 	    b = 1;s) 	    fr_ps->header->mode = MPG_MD_STEREO;*! 	    fr_ps->header->mode_ext = 0;)% 	    fr_ps->jsbound = fr_ps->sblimit;y 	    adb_help = *adb; M 	    bits_nonoise = II_bits_for_nonoise (perm_smr, scfsi, fr_ps, a, b, aiff);oI 	    bits_indi = II_bits_for_indi (perm_smr, scfsi, fr_ps, &a, &b, aiff);tG 	    rq_db = ((bits_nonoise / 10) % 2) * 10 * bits_nonoise + bits_indi;e 	    if (verbosity >= 2)  6 		printf ("rq_db: %5d ( %5d + %5d ) available: %5d\n",, 		    rq_db, bits_nonoise, bits_indi, *adb); 	    if (rq_db > adb_help) 	    {2 	       fr_ps->header->mode = MPG_MD_JOINT_STEREO;A 	       mode_ext = 4;           /* 3 is least severe reduction */s! 	       lay = fr_ps->header->lay;3
 	       do	 	       {a 		 --mode_ext;- 		 fr_ps->jsbound = js_bound (lay, mode_ext);,K 		 bits_nonoise = II_bits_for_nonoise (perm_smr, scfsi, fr_ps, a, b, aiff); G 		 bits_indi = II_bits_for_indi (perm_smr, scfsi, fr_ps, &a, &b, aiff);fE 		 rq_db = ((bits_nonoise / 10) % 2) * 10 * bits_nonoise + bits_indi;m 		 if (verbosity >= 2)  : 		    printf ("rq_db: %5d ( %5d + %5d ) available: %5d\n",* 			 rq_db, bits_nonoise, bits_indi, *adb);2 	       } while ((rq_db >*adb) && (mode_ext > 0));+ 	       fr_ps->header->mode_ext = mode_ext; B 	    }	 /* well we either eliminated noisy sbs or mode_ext == 0 */ 	}'     }  /* end of else (five-channel) */   S     noisy_sbs = II_a_bit_allocation (perm_smr, scfsi, bit_alloc, adb, fr_ps, aiff);  }    I /************************************************************************n /*  /* I_a_bit_allocation  (Layer I)! /* II_a_bit_allocation (Layer II); /*B /* PURPOSE:Adds bits to the subbands with the lowest mask-to-noise? /* ratios, until the maximum number of bits for the subband hasI /* been allocated. /*
 /* SEMANTICS:aC /* 1. Find the subband and channel with the smallest MNR (#min_sb#,* /*    and #min_ch#)*B /* 2. Calculate the increase in bits needed if we increase the bit) /*    allocation to the next higher level3F /* 3. If there are enough bits available for increasing the resolutionD /*    in #min_sb#, #min_ch#, and the subband has not yet reached itsB /*    maximum allocation, update the bit allocation, MNR, and bits /*    available accordingly D /* 4. Repeat until there are no more bits left, or no more available? /*    subbands. (A subband is still available until the maximumcA /*    number of bits for the subband has been allocated, or there[C /*    aren't enough bits to go to the next higher resolution in theM /*    subband.)i /*J /************************************************************************/  n int I_a_bit_allocation(double (*perm_smr)[32], unsigned int (*bit_alloc)[32], int *adb, frame_params *fr_ps)	/* return noisy sbs */   $        /*far*/                      #                                     	                                 {;;    int i, k, smpl_bits, scale_bits, min_sb, min_ch, oth_ch; +    int bspl, bscf, ad, noisy_sbs, done = 0; !    double mnr[2][SBLIMIT], small;b    char used[2][SBLIMIT];     int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc;    static char init= 0;u    static int bbal, banc, berr;c  t    if (!init) {{:       banc = 32;     /* before: berr = 0; 92-08-11 shn */        init = 1;1  \       if (fr_ps->header->error_protection) berr = 16; else berr= 0; /* added 92-08-11 shn */    }9    bbal = 4 * ( (jsbound * stereo) + (SBLIMIT-jsbound) );*    *adb -= bbal + berr + banc;    ad= *adb;   3    for (i=0;i<SBLIMIT;i++) for (k=0;k<stereo;k++) {l%      mnr[k][i]=snr[0]-perm_smr[k][i];       bit_alloc[k][i] = 0;       used[k][i] = 0;    }    bspl = bscf = 0;s  e    do  {.      /* locate the subband with minimum SMR */6      small = mnr[0][0]+1;    min_sb = -1; min_ch = -1;3      for (i=0;i<SBLIMIT;i++) for (k=0;k<stereo;k++)e.        /* go on only if there are bits left */2        if (used[k][i] != 2 && small > mnr[k][i]) {          small = mnr[k][i]; !          min_sb = i;  min_ch = k;j        }:      if(min_sb > -1) {   /* there was something to find */4        /* first step of bit allocation is biggest */E        if (used[min_ch][min_sb])  { smpl_bits = 12; scale_bits = 0; } E        else                       { smpl_bits = 24; scale_bits = 6; } 9        if(min_sb >= jsbound)        scale_bits *= stereo;*  *8        /* check to see enough bits were available for */6        /* increasing resolution in the minimum band */  a8        if (ad  > bspl + bscf + scale_bits + smpl_bits) {8          bspl += smpl_bits; /* bit for subband sample */7          bscf += scale_bits; /* bit for scale factor */ %          bit_alloc[min_ch][min_sb]++;d9          used[min_ch][min_sb] = 1; /* subband has bits */_8          mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb]@                                + snr[bit_alloc[min_ch][min_sb]];A          /* Check if subband has been fully allocated max bits */]I          if (bit_alloc[min_ch][min_sb] ==  14 ) used[min_ch][min_sb] = 2;	        }9        else            /* no room to improve this band */lA          used[min_ch][min_sb] = 2; /*   for allocation anymore */[-        if(stereo == 2 && min_sb >= jsbound) {1:          oth_ch = 1-min_ch;  /* joint-st : fix other ch */?          bit_alloc[oth_ch][min_sb] = bit_alloc[min_ch][min_sb]; 5          used[oth_ch][min_sb] = used[min_ch][min_sb];>8          mnr[oth_ch][min_sb] = -perm_smr[oth_ch][min_sb]@                                + snr[bit_alloc[oth_ch][min_sb]];        }      }B    } while(min_sb>-1);     /* i.e. still some sub-bands to find */  A    /* Calculate the number of bits left, add on to pointed var */     ad -= bspl+bscf; 
    *adb = ad;   (    /* see how many channels are noisy */$    noisy_sbs = 0; small = mnr[0][0];    for(k=0; k<stereo; ++k) {"      for(i = 0; i< SBLIMIT; ++i) {/ 		 if(mnr[k][i] < fr_ps->mnr_min)	 ++noisy_sbs; 9        if(small > mnr[k][i])           small = mnr[k][i];       }    }    return noisy_sbs; }[  J /***************************** Layer II  ********************************/  K int II_a_bit_allocation (double (*perm_smr)[32], unsigned int (*scfsi)[32],	, 			 unsigned int (*bit_alloc)[32], int *adb,# 			 frame_params *fr_ps, int *aiff)= {2N     int n_ml_ch = fr_ps->header->multiling_ch; 	/*JMZ 08/03/95 Multilingual */G     int i, min_ch, min_sb, oth_ch, k, increment, scale, seli, ba, j, l;)"     int increment1, scale1, seli1;$     int adb_hlp, adb_hlp1, adb_hlp2;(     int bspl, bscf, bsel, ad, noisy_sbs;(     int bspl_mpg1, bscf_mpg1, bsel_mpg1;F     double mnr[14][SBLIMIT], small;		/* JMZ 08/03/1995 Multilingual */@     char used[14][SBLIMIT];				/* JMZ 08/03/1995 Multilingual */!     layer *info  = fr_ps->header;>      int center   = info->center;"     int surround = info->surround;     int stereo	= fr_ps->stereo;n#     int stereomc = fr_ps->stereomc; %     int stereoaug = fr_ps->stereoaug; !     int sblimit = fr_ps->sblimit; '     int sblimit_mc = fr_ps->sblimit_mc; '     int sblimit_ml = fr_ps->sblimit_ml;i!     int jsbound = fr_ps->jsbound;c#     al_table *alloc = fr_ps->alloc; )     al_table *alloc_mc = fr_ps->alloc_mc;d)     al_table *alloc_ml = fr_ps->alloc_ml;fB     double dynsmr = 0.0;  /* border of SMR for dynamic datarate */     static char init= 0;     static int banc, berr;)     int bbal, bancmc, bancext, bbal_mpg1;[M     int ll, pred, pci, adb_mpg1, sbgr, sb, tca_bits, dynx_bits, aug_tca_bits;)K     static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */f       if (!init)     { 
 	init = 1;( 	banc = 32; /* banc: bits for header */;7 	/* 960627 FdB reserve extra bits dependent wrt bugs */r
 	banc += 200;   % 	if (fr_ps->header->error_protection)f 	    berr = 16;f 	else;% 	    berr=0; /* added 92-08-11 shn */s     }i  
     pred = 0;}     bancmc = 0;c
     bbal = 0;s     bbal_mpg1 = 0;     bancext = 0;P     adb_mpg1 = bitrate[fr_ps->header->lay-1][fr_ps->header->bitrate_index] * 24;2     /* 960814 FdB next line added for debugging */     /* adb_mpg1 -= banc; */n       if (*aiff == 1)f     {	/ 	if (fr_ps->actual_mode == MPG_MD_JOINT_STEREO)= 	{" 	    for (i = 0; i < jsbound; ++i)) 		bbal += (stereo) * (*alloc)[i][0].bits;M( 	    for (i = jsbound; i < sblimit; ++i)+ 		bbal += (stereo-1) * (*alloc)[i][0].bits;t% 	    for (i = 0; i < sblimit_mc; ++i)o8 		bbal += (stereomc+stereoaug) * (*alloc_mc)[i][0].bits;% 	    for (i = 0; i < sblimit_ml; ++i)i- 		bbal += (n_ml_ch) * (*alloc_ml)[i][0].bits;  	}	  b 	elset 	{" 	    for (i = 0; i < sblimit; ++i)) 		bbal += (stereo) * (*alloc)[i][0].bits; % 	    for (i = 0; i < sblimit_mc; ++i)i8 		bbal += (stereomc+stereoaug) * (*alloc_mc)[i][0].bits;% 	    for (i = 0; i < sblimit_ml; ++i) - 		bbal += (n_ml_ch) * (*alloc_ml)[i][0].bits;E 	}  - 	if (fr_ps->header->center == 3) bbal -= 41; e     }c     else     {  	for (i = 0; i < jsbound; ++i)* 	    bbal += stereo * (*alloc)[i][0].bits;+         for (i = jsbound; i < sblimit; ++i)t! 	    bbal += (*alloc)[i][0].bits;r     }s  )     if (fr_ps->header->dyn_cross_on == 1)_ 	for (i = 0; i < 12; i++)f 	{] 	    bbal -= dyn_bbal (fr_ps->config, fr_ps->header->center, fr_ps->header->dyn_cross[i], i); & 	    if (fr_ps->header->surround == 3)B 		bbal -= dyn_bbal_2ndst (fr_ps->header->dyn_second_stereo[i], i); 	} 	_  3     if (fr_ps->header->ext_bit_stream_present == 0)xO         bancmc += 35;      /* mc_header + crc + tc_sbgr_select+ dyn_cross_on +  < 			    mc_prediction_on  01/05/94,  SR  new! 05/04/94,  SR*/     else     {e         bancmc += 43;			     	bancext = 40;     }m  8     /* 960627 FdB TCA bits dependent on configuration */     if (fr_ps->config == 320)* 	tca_bits = 3;"     else if (fr_ps->config == 310) 	tca_bits = 3;"     else if (fr_ps->config == 220) 	tca_bits = 2;R     else if (fr_ps->config == 300 || fr_ps->config == 302 || fr_ps->config == 210) 	tca_bits = 2;     else 	tca_bits = 0;  +     if (fr_ps->header->tc_sbgr_select == 0)i          bancmc += 12 * tca_bits;     else         bancmc += tca_bits;	  )     if (fr_ps->header->dyn_cross_on == 1)s     { 1 	/* 960627 FdB DynX dependent on configuration */t 	if (fr_ps->config == 320) 	    dynx_bits = 4;a7 	else if (fr_ps->config == 310 || fr_ps->config == 220)# 	    dynx_bits = 3;aO 	else if (fr_ps->config == 300 || fr_ps->config == 302 || fr_ps->config == 210)M 	    dynx_bits = 1;v 	else  	    dynx_bits = 0;e   	bancmc += 12 * dynx_bits + 1;" 	if (fr_ps->header->surround == 3)G 	    bancmc += 12;      /* now with dyn_second_stereo,  17/02/95,  SR*/      }r  -     if (fr_ps->header->mc_prediction_on == 1)      {e /*	for (i = 0; i < 8; i++) 	{ 	    bancmc += 1;h( 	    if (fr_ps->header->mc_pred[i] == 1)@ 	        bancmc += n_pred_coef[fr_ps->header->dyn_cross[i]] * 2; 	} */- 	/* mc_pred, predsi, delay_comp, pred_coef */n+ 	/* bancmc += 8 * (3 + 6 * (3 + 3 * 8)); */r 	for (i = 0; i < 8; i++) 	{ 	    bancmc += 3; = 	    bancmc += n_pred_coef[fr_ps->header->dyn_cross[i]] * 27;  	}     }    #ifdef Augmentation_7chi     if (stereoaug == 2)s     {b& 	if (fr_ps->header->aug_mtx_proc == 0) 	    aug_tca_bits = 3;+ 	else if (fr_ps->header->aug_mtx_proc == 1)  	    aug_tca_bits = 2; 	elsee 	    aug_tca_bits = 0;  $         bancmc += 12 * aug_tca_bits;  1         if (fr_ps->header->aug_dyn_cross_on == 1)> 	{ 	    bancmc += 12 * 5;   	    for (i = 0; i < 12; i++)e< 		bbal -= dyn_bbal_aug (fr_ps->header->aug_dyn_cross[i], i); 	}     }0 #endif  "     for (i = 0; i < SBLIMIT; i++) \ /*       for (k = 0; k < (stereo+stereomc+2); k++) 960814 FdB bug for some configurations */!         for (k = 0; k < 12; k++) I	         {)) 	    mnr[k][i] = snr[0] - perm_smr[k][i];=I 	    /* mask-to-noise-level = signal-to-noise-level - minimum-masking- */k 	    /* threshold */    	    bit_alloc[k][i] = 0;0 	    used[k][i] = 0;	         }      %     for (i = 0; i < sblimit_ml; i++) a# 	for (k = 7; k < 7 + n_ml_ch; k++)   	{% 	    mnr[k][i]=snr[0]-perm_smr[k][i];_H 	    /* mask-to-noise-level = signal-to-noise-level - minimum-masking-*/ 	    /* threshold*/r      	    bit_alloc[k][i] = 0;] 	    used[k][i] = 0; 	}  >     /* dyamic crosstalk, lock sbgr which are use for dyncr. */)     if (fr_ps->header->dyn_cross_on == 1)/     { % 	for (sbgr = 0; sbgr < SBGRS; sbgr++)s 	{		P 	    for (sb = ((sbgr == 0)?0:sb_groups[sbgr-1]+1); sb <= sb_groups[sbgr]; sb++) 	    {2 		/* 960627 FdB DynX dependent on configuration */ 		if (fr_ps->config == 320)6 		{  		    /* 3/2 */>, 		    switch(fr_ps->header->dyn_cross[sbgr]) 		    {  			case 0: e
 				break; 			case 1: case 8: case 10:  				used[T4[sbgr]][sb] = 2;e
 				break; 			case 2: case 9: a 				used[T3[sbgr]][sb] = 2;  				break; { 			case 3: p 				used[T2[sbgr]][sb] = 2;b
 				break;& 			case 4: case 11: case 12: case 14:  				used[T3[sbgr]][sb] = 2;  				used[T4[sbgr]][sb] = 2;d
 				break; 			case 5: case 13:  				used[T2[sbgr]][sb] = 2;  				used[T4[sbgr]][sb] = 2;-
 				break; 			case 6:   				used[T2[sbgr]][sb] = 2;  				used[T3[sbgr]][sb] = 2;s
 				break; 			case 7: f 				used[T2[sbgr]][sb] = 2;  				used[T4[sbgr]][sb] = 2; 	b 				used[T3[sbgr]][sb] = 2;1
 				break; 		    }s 		}28 		else if (fr_ps->config == 310 || fr_ps->config == 220) 		{  		    /* 3/1 and 2/2 */i, 		    switch(fr_ps->header->dyn_cross[sbgr]) 		    {  			case 0: =
 				break; 			case 1: case 4:   				used[T3[sbgr]][sb] = 2;o
 				break; 			case 2:   				used[T2[sbgr]][sb] = 2;n 				break; l 			case 3: n 				used[T2[sbgr]][sb] = 2;[ 				used[T3[sbgr]][sb] = 2;]
 				break; 		    }c 		}nP 		else if (fr_ps->config == 300 || fr_ps->config == 302 || fr_ps->config == 210) 		{] 		    /* 3/0 (+2/0) and 2/1 */, 		    switch(fr_ps->header->dyn_cross[sbgr]) 		    {o 			case 0:  
 				break; 			case 1: o 				used[T2[sbgr]][sb] = 2;d
 				break; 		    }p1 		    if (fr_ps->header->dyn_second_stereo[sbgr])n 			used[T4[sbgr]][sb] = 2; 		}0  		else if (fr_ps->config == 202) 		{r1 		    if (fr_ps->header->dyn_second_stereo[sbgr])i 			used[T3[sbgr]][sb] = 2; 		}n  		else if (fr_ps->config == 102) 		{)1 		    if (fr_ps->header->dyn_second_stereo[sbgr])t 			used[T2[sbgr]][sb] = 2; 		}* 	    }	/* for(sb.. */r 	}	/* for(sbgr.. */*     }		/* if(fr_ps.. */  #ifdef Augmentation_7ch -     if (fr_ps->header->aug_dyn_cross_on == 1)	     {n% 	for (sbgr = 0; sbgr < SBGRS; sbgr++)  	{		P 	    for (sb = ((sbgr == 0)?0:sb_groups[sbgr-1]+1); sb <= sb_groups[sbgr]; sb++) 	    { 		/* 5/2 */g- 		switch (fr_ps->header->aug_dyn_cross[sbgr])n 		{n 		    case 0: 
 			    break; 
 		    case 1: 
 		    case 2: 
 		    case 3:,
 		    case 4:h 			    used[T6[sbgr]][sb] = 2;
 			    break; 
 		    case 5:g 		    case 10: 		    case 14: 			    used[T5[sbgr]][sb] = 2;
 			    break;5 		    case 6:  		    case 7:  		    case 8:  		    case 9:  		    case 11: / 		    case 12:   		    case 13: > 		    case 15:   		    case 16:   		    case 17: = 		    case 18:   			    used[T5[sbgr]][sb] = 2; 			    used[T6[sbgr]][sb] = 2;
 			    break;  		}o 	    }	/* for(sb.. */  	}	/* for(sbgr.. */r     }		/* if(fr_ps.. */  #endif   /*-     if (fr_ps->header->mc_prediction_on == 1)b     {l          for (i = 0; i < 8; i++) 	         {l( 	    if (fr_ps->header->mc_pred[i] == 1) 	    {G 	        for (j = 0; j < n_pred_coef[fr_ps->header->dyn_cross[i]]; j++) 
 	        {+ 		    if (fr_ps->header->predsi[i][j] != 0)t 		    {  		        pred += 3;A 		        for (pci = 0; pci < fr_ps->header->predsi[i][j]; pci++)1 			    pred += 8;d 		    }	
 	        } 	    }	         }_     }  _ */     adb_hlp = *adb;t       if (*aiff != 1)1     {  	*adb -= bbal + berr + banc;     } 	     else       { 8     	if (fr_ps->header->ext_bit_stream_present == 0)    1 	    *adb -= bbal + berr + banc + bancmc + pred +r* 	    	    (fr_ps->header->n_ad_bytes * 8); 	elsec 	{1 	    *adb -= bbal + berr + banc + bancmc + pred + 3 	    	   bancext + (fr_ps->header->n_ad_bytes * 8);c 	     (             for(i = 0; i < jsbound; ++i), 		bbal_mpg1 += stereo * (*alloc)[i][0].bits;' 	    for(i = jsbound; i < sblimit; ++i)*# 		bbal_mpg1 += (*alloc)[i][0].bits;e  3 	    adb_mpg1 -= bbal_mpg1 + berr + banc + bancmc + # 			(fr_ps->header->n_ad_bytes * 8);> 	}   m     }		    _     ad = *adb;  ?     bspl = bscf = bsel = bspl_mpg1 = bscf_mpg1 = bsel_mpg1 = 0;c       do     { 1         /* locate the subband with minimum SMR */s 	small = 999999.0;
 	min_sb = -1; 
 	min_ch = -1;i  D 	for (i = 0; i < SBLIMIT; i++)		  /* searching for the sb min SMR */ 	{ 	    l = sbgrp[i];6 	    for (j = 0; j < (stereo+stereomc+stereoaug); ++j)$ 		if ((j < stereo && i < sblimit) ||& 		    (j >= stereo && i < sblimit_mc)) 		{s- 		    k = transmission_channel (fr_ps, l, j);;     @ 		    if ((i >= 12) && (fr_ps->header->center == 3) && (k == 2)) 			used[k][i] = 2;     4 		    if ((used[k][i] != 2) && (small > mnr[k][i]))  		    {. 			 small = mnr[k][i]; 			 min_sb = i;= 			 min_ch = k;e 			 ll = l;		    /*sb-group*/r 		    }i 		}b 	}  D /******************************************************************/! /* Multilingual JMZ 08/03/1995 */  	if (n_ml_ch > 0)i 	{% 	    for (i = 0; i < sblimit_ml; i++)c# 		for (j = 7; j < (n_ml_ch+7); ++j)i 		{  		    k = j;4 		    if ((used[k][i] != 2) && (small > mnr[k][i]))  		    {r 			small = mnr[k][i];  			min_sb = i; 			min_ch = k; 			ll = l;		     		    }d 		}r 	}! /* Multilingual JMZ 08/03/1995 */ D /******************************************************************/     	if (min_sb > -1) & 	{   /* there was something to find */; 	    /* find increase in bit allocation in subband [min] */4 	    if (min_ch < stereo)  	    {J 		increment = 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].group * : 				  (*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);  		/* how many bits are needed */ 		if (used[min_ch][min_sb])tM 		    increment -= 12 * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]].group * >= 				       (*alloc)[min_sb][bit_alloc[min_ch][min_sb]].bits);  	    }  = 	    else if (min_ch < 7 || n_ml_ch == 0) /* Multichannel */ r 	    {M 		increment = 12 * ((*alloc_mc)[min_sb][bit_alloc[min_ch][min_sb]+1].group * 	= 				  (*alloc_mc)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);6  		/* how many bits are needed */ 		if (used[min_ch][min_sb])=P 		    increment -= 12 * ((*alloc_mc)[min_sb][bit_alloc[min_ch][min_sb]].group * @ 				       (*alloc_mc)[min_sb][bit_alloc[min_ch][min_sb]].bits); 	    }  ( 	    else /* MultiLingual 7/8/95 WtK */  	    {H 		increment = ((*alloc_ml)[min_sb][bit_alloc[min_ch][min_sb]+1].group * ? 			     (*alloc_ml)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);t 		if (used[min_ch][min_sb])5K 		    increment -= ((*alloc_ml)[min_sb][bit_alloc[min_ch][min_sb]].group * *; 				  (*alloc_ml)[min_sb][bit_alloc[min_ch][min_sb]].bits);_8 		if (fr_ps->header->multiling_fs == 1) increment *=  6;8 		else                                  increment *= 12; 	    }     7 	    /* scale factor bits required for subband [min] */ * 	    /* above js bound, need both chans */     8 	    if ((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && & 					((min_ch == 0) || (min_ch == 1))) 		oth_ch = 1 - min_ch;       u 		 	    if (used[min_ch][min_sb]) 		scale = seli = 0; 
 	    else 8 	    {			  /* this channel had no bits or scfs before */ 		seli = 2;b1 		scale = 6 * sfsPerScfsi[scfsi[min_ch][min_sb]];      K 		if ((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && (min_sb >= jsbound) && , 				      ((min_ch == 0) || (min_ch == 1)))  		{1) 		    /* each new js sb has L+R scfsis */a 		    seli += 2;6 		    scale += 6 * sfsPerScfsi[scfsi[oth_ch][min_sb]]; 		}i' 		if (fr_ps->header->dyn_cross_on == 1)e 		{+@ 		    dyn_bal (scfsi, ll, fr_ps, min_ch, min_sb, &seli, &scale);B 		    /* 960819 FdB joint stereo in combination with DynX added */O 		    if ((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && (min_sb >= jsbound) &&*6 			(stereo == 2) && ((min_ch == 0) || (min_ch == 1))) = 			dyn_bal (scfsi, ll, fr_ps, oth_ch, min_sb, &seli, &scale);b 		}_ #ifdef Augmentation_7chk+ 		if (fr_ps->header->aug_dyn_cross_on == 1)r 		{eD 		    dyn_bal_aug (scfsi, ll, fr_ps, min_ch, min_sb, &seli, &scale);B 		    /* 960819 FdB joint stereo in combination with DynX added */O 		    if ((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && (min_sb >= jsbound) &&u6 			(stereo == 2) && ((min_ch == 0) || (min_ch == 1))) A 			dyn_bal_aug (scfsi, ll, fr_ps, oth_ch, min_sb, &seli, &scale);r 		}= #endif 	    }     6 	    /* check to see enough bits were available for */4 	    /* increasing resolution in the minimum band */  <             if (fr_ps->header->ext_bit_stream_present == 1) 
             {y4 		if ((min_ch == 0) || (min_ch == 1 && stereo == 2)) 		{ S 		    if (adb_mpg1 > bspl_mpg1 + bscf_mpg1 + bsel_mpg1 + seli + scale + increment)   		    {T9 			bspl_mpg1 += increment;  /* bits for subband sample */[7 			bscf_mpg1 += scale;      /* bits for scale factor */:5 			bsel_mpg1 += seli;       /* bits for scfsi code */b 		    }=
 		    else= 			used[min_ch][min_sb] = 2;  /* can't increase this alloc */s 		}[
             }-  ^ 	    if ((ad > bspl + bscf + bsel + seli + scale + increment) && (used[min_ch][min_sb] != 2))  	    {7 		ba = ++bit_alloc[min_ch][min_sb]; /* next up alloc */s3 		bspl += increment;  /* bits for subband sample */ 1 		bscf += scale;      /* bits for scale factor */f/ 		bsel += seli;       /* bits for scfsi code */*2 		used[min_ch][min_sb] = 1; /* subband has bits */        		if (min_ch < stereo)   		{s7 		    mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] + ) 					  snr[(*alloc)[min_sb][ba].quant+1]; > 		    /* Check if subband has been fully allocated max bits */2 		    if (ba >= (1<<(*alloc)[min_sb][0].bits) - 1) 			used[min_ch][min_sb] = 2; 		}f: 		else if (min_ch < 7 || n_ml_ch == 0)  /* Multichannel */ 		{(7 		    mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +b, 					  snr[(*alloc_mc)[min_sb][ba].quant+1];> 		    /* Check if subband has been fully allocated max bits */5 		    if (ba >= (1<<(*alloc_mc)[min_sb][0].bits) - 1)e 			used[min_ch][min_sb] = 2; 		}i% 		else /* MultiLingual 7/8/95 WtK */ f 		{p7 		    mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +b. 					    snr[(*alloc_ml)[min_sb][ba].quant+1];5 		    if (ba >= (1<<(*alloc_ml)[min_sb][0].bits) - 1)t 			used[min_ch][min_sb] = 2; 		}  	    }	 	    else*< 		used[min_ch][min_sb] = 2;  /* can't increase this alloc */   	    if (verbosity >= 3) 	    {1 		if (fr_ps->header->ext_bit_stream_present == 1) U 		    printf("ch: %02d sb: %02d used: %d adb: %05d used: %05d ad: %05d used: %05d\n", , 			    min_ch, min_sb, used[min_ch][min_sb],3 			    adb_mpg1, bspl_mpg1 + bscf_mpg1 + bsel_mpg1,  			    ad, bspl + bscf + bsel);	 		else@ 		    printf("ch: %02d sb: %02d used: %d ad: %05d used: %05d\n",, 			    min_ch, min_sb, used[min_ch][min_sb], 			    ad, bspl + bscf + bsel);1 	    }    _ 	    if ((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && (min_sb >= jsbound) && (stereo == 2) &&e( 		    ((min_ch == 0) || (min_ch == 1)))  	    {( 		/* above jsbound, alloc applies L+R */= 		ba = bit_alloc[oth_ch][min_sb] = bit_alloc[min_ch][min_sb];b. 		used[oth_ch][min_sb] = used[min_ch][min_sb];3 		mnr[oth_ch][min_sb] = -perm_smr[oth_ch][min_sb] +.' 					snr[(*alloc)[min_sb][ba].quant+1];  	    }* 	    if (fr_ps->header->dyn_cross_on == 1) 	    {4 		choose_dyn (fr_ps, min_ch, min_sb, ll, bit_alloc);> 		/* 960819 FdB joint stereo in combination with DynX added */K 		if ((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && (min_sb >= jsbound) &&p9 		    (stereo == 2) && ((min_ch == 0) || (min_ch == 1)))  8 		    choose_dyn (fr_ps, oth_ch, min_sb, ll, bit_alloc); 	    } #ifdef Augmentation_7ch . 	    if (fr_ps->header->aug_dyn_cross_on == 1) 	    {8 		choose_dyn_aug (fr_ps, min_ch, min_sb, ll, bit_alloc);> 		/* 960819 FdB joint stereo in combination with DynX added */K 		if ((fr_ps->actual_mode == MPG_MD_JOINT_STEREO) && (min_sb >= jsbound) &&n9 		    (stereo == 2) && ((min_ch == 0) || (min_ch == 1))) *< 		    choose_dyn_aug (fr_ps, oth_ch, min_sb, ll, bit_alloc); 	    } #endif' 	}   /* end of if-loop if min_sb >-1 */)>     } while (min_sb > -1);   /* until could find no channel */+     /* Calculate the number of bits left */i       ad -= bspl+bscf+bsel;      *adb = ad;      for (k = 0; k < stereo; k++)$ 	for (i = sblimit; i < SBLIMIT; i++) 	    bit_alloc[k][i] = 0;n     if (n_ml_ch > 0)     {  	for (k = stereo; k < 7; k++) + 	    for (i = sblimit_mc; i < SBLIMIT; i++)b 		bit_alloc[k][i] = 0;' 	for (i = sblimit_ml; i < SBLIMIT; i++)i 	    for (k = 7; k < 14; k++)9 		bit_alloc[k][i] = 0;     }      else 	for (k = stereo; k < 12; k++)+ 	    for (i = sblimit_mc; i < SBLIMIT; i++)  		bit_alloc[k][i] = 0;   2     /* not used !?! perhaps later!! 8/21/93, SR */     noisy_sbs = 0;:     small = mnr[0][0];      /* calc worst noise in case */5     for (k = 0; k < (stereo+stereomc+stereoaug); k++)      {>&         for (i = 0; i < sblimit; i++)  	{"             if (small > mnr[k][i]) 		small = mnr[k][i];$ 	    if (mnr[k][i] < fr_ps->mnr_min)( 		noisy_sbs++; /* noise is not masked */	         }h     }        if (n_ml_ch > 0)     { " 	for (k = 7; k < (7+n_ml_ch); k++) 	{& 	    for (i = 0; i < sblimit_ml; i++)  	    { 		if (small > mnr[k][i]) 		    small = mnr[k][i];! 		if (mnr[k][i] < fr_ps->mnr_min)l, 		    noisy_sbs++; /* noise is not masked */ 	    } 	}     }        return noisy_sbs;] }   2I /************************************************************************; /*$ /* I_subband_quantization  (Layer I)% /* II_subband_quantization (Layer II)/( /* II_subband_quantisationmc (MPEG2)  SRB /* PURPOSE:Quantizes subband samples to appropriate number of bits /*G /* SEMANTICS:  Subband samples are divided by their scalefactors, whichs@ /* makes the quantization more efficient. The scaled samples areB /* quantized by the function a*x+b, where a and b are functions ofB /* the number of quantization levels. The result is then truncated= /* to the appropriate number of bits and the MSB is inverted.m /*C /* Note that for fractional 2's complement, inverting the MSB for a 5 /* negative number x is equivalent to adding 1 to it.  /*J /************************************************************************/    static double I_a[15] = {_(   0.750000000, 0.875000000, 0.937500000,B   0.968750000, 0.984375000, 0.992187500, 0.996093750, 0.998046875,B   0.999023438, 0.999511719, 0.999755859, 0.999877930, 0.999938965,   0.999969482, 0.999984741 };l  m static double I_b[15] = {]+   -0.250000000, -0.125000000, -0.062500000,nG   -0.031250000, -0.015625000, -0.007812500, -0.003906250, -0.001953125,aG   -0.000976563, -0.000488281, -0.000244141, -0.000122070, -0.000061035,n   -0.000030518, -0.000015259 };   l static double II_a[17] = {B   0.750000000, 0.625000000, 0.875000000, 0.562500000, 0.937500000,B   0.968750000, 0.984375000, 0.992187500, 0.996093750, 0.998046875,B   0.999023438, 0.999511719, 0.999755859, 0.999877930, 0.999938965,   0.999969482, 0.999984741 };   r static double II_b[17] = {G   -0.250000000, -0.375000000, -0.125000000, -0.437500000, -0.062500000,aG   -0.031250000, -0.015625000, -0.007812500, -0.003906250, -0.001953125,tG   -0.000976563, -0.000488281, -0.000244141, -0.000122070, -0.000061035,    -0.000030518, -0.000015259 };=  )= void I_subband_quantization (unsigned int   (*scalar)[3][32],i, 			     double	    (*sb_samples)[3][12][32],) 			     unsigned int   (*j_scale)[3][32],b) 			     double	    (*j_samps)[3][12][32],r( 			     unsigned int   (*bit_alloc)[32],, 			     unsigned int   (*sbband)[3][12][32], 			     frame_params   *fr_ps) {     int i, j, k, n, sig;c    int stereo  = fr_ps->stereo;e     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;    double d;  -    for (j=0;j<12;j++) for (i=0;i<SBLIMIT;i++)n+      for (k=0;k<((i<jsbound)?stereo:1);k++)         if (bit_alloc[k][i]) {iL          /* for joint stereo mode, have to construct a single subband streamH             for the js channels.  At present, we calculate a set of monoG             subband samples and pass them through the scaling system tob;             generate an alternate normalised sample stream.   dM             Could normalise both streams (divide by their scfs), then average F             them.  In bad conditions, this could give rise to spuriousL             cancellations.  Instead, we could just select the sb stream fromI             the larger channel (higher scf), in which case _that_ channel=K             would be 'properly' reconstructed, and the mate would just be a M             scaled version.  Spec recommends averaging the two (unnormalised)sF             subband channels, then normalising this new signal withoutK             actually sending this scale factor... This means looking ahead.=          */ &          if(stereo == 2 && i>=jsbound)-            /* use the joint data passed in */>: 			  d = j_samps[0][0][j][i] / multiple[j_scale[0][0][i]];
          else B            d = sb_samples[k][0][j][i] / multiple[scalar[k][0][i]];7          /* scale and quantize floating point sample */_          n = bit_alloc[k][i]; %          d = d * I_a[n-1] + I_b[n-1];	B          /* extract MSB N-1 bits from the floating point sample */          if (d >= 0) sig = 1;>$          else { sig = 0; d += 1.0; }D          sbband[k][0][j][i] = (unsigned int) (d * (double) (1L<<n));@          /* tag the inverted sign bit to sbband at position N */-          if (sig) sbband[k][0][j][i] |= 1<<n;         } }   lJ /***************************** Layer II  ********************************/  m] void II_subband_quantization (unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32],iF 			      unsigned int (*j_scale)[3][32], double (*j_samps)[3][12][32],J 			      unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32], 			      frame_params *fr_ps)s {0%    int i, j, k, s, n, qnt, sig, l, m;     int stereo	= fr_ps->stereo;"    int stereomc = fr_ps->stereomc;     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;    unsigned int stps;n    double d;"    al_table *alloc = fr_ps->alloc;      for (s=0;s<3;s++)      for (j=0;j<12;j++)         for (i=0;i<sblimit;i++)/          for (k=0;k<((i<jsbound)?stereo:1);k++)e 	 {u   	     if (bit_alloc[k][i]) 	     { =                /* scale and quantize floating point sample */rM                if(stereo == 2 && i>=jsbound)       /* use j-stereo samples */b? 	         d = j_samps[0][s][j][i] / multiple[j_scale[0][s][i]];*                elsesH                  d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];  @ 	       if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */	 	       {sT          		printf("In compatible part, not scaled properly, %d %d %d %d\n",k,s,j,i);3 			printf("Value %1.10f\n",sb_samples[k][s][j][i]);b 			printf("Channel %d\n", k);a	 	       }s1 	       qnt = (*alloc)[i][bit_alloc[k][i]].quant;2-                d = d * II_a[qnt] + II_b[qnt];cH                /* extract MSB N-1 bits from the floating point sample */#                if (d >= 0) sig = 1; *                else { sig = 0; d += 1.0; }                n = 0;	 #ifndef MS_DOS9                stps = (*alloc)[i][bit_alloc[k][i]].steps;p*                while ((1L<<n) < stps) n++; #elset8                while  ( ( (unsigned long)(1L<<(long)n) <E 	              ( (unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)	6                           & 0xffff)) && ( n <16)) n++; #endif                n--;=J                sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));F                /* tag the inverted sign bit to sbband at position N */K                /* The bit inversion is a must for grouping with 3,5,9 steps=1                 so it is done for all subbands */h3                if (sig) sbband[k][s][j][i] |= 1<<n;  	     }            }_            for (s=0;s<3;s++)*              for (j=sblimit;j<SBLIMIT;j++)"                for (i=0;i<12;i++)   	         for (m=0;m<stereo;m++) 		 sbband[m][s][i][j] = 0; }d    ` void II_subband_quantization_mc (unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32],B 				 unsigned int (*j_scale)[3][32], double (*j_samps)[3][12][32],F 				 unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32], 				 frame_params *fr_ps)  {h*     int i, j, k, s, n, qnt, sig, m, l, ll;!     layer *info  = fr_ps->header;m      int center   = info->center;"     int surround = info->surround;     int stereo	= fr_ps->stereo;f#     int stereomc = fr_ps->stereomc; %     int sblimit  = fr_ps->sblimit_mc;c     unsigned int stps;
     double d;;&     al_table *alloc = fr_ps->alloc_mc;       for (s = 0; s < 3; s++)           for (j = 0; j < 12; j++)" 	    for (i = 0; i < sblimit; i++) 	    { 		ll = sbgrp[i];<                 for (m = stereo; m < stereo + stereomc; ++m)
 	        {. 		    k = transmission_channel (fr_ps, ll, m);  + 		    if (fr_ps->header->dyn_cross_on == 1)/ 		    { 3 			/* 960627 FdB DynX dependent on configuration */*" 			if (dyn_ch (fr_ps, ll, m) == 0) 			    bit_alloc[k][i] = 0;c 		    }g   		    if (bit_alloc[k][i]) 		    { : 			d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];< 			if (mod (d) >= 1.0) /* > changed to >=, 1992-11-06 shn */ 			{H 			    printf ("In MC, not scaled properly, %d %d %d %d\n", k, s, j, i);9 			    printf ("Value %1.10f\n", sb_samples[k][s][j][i]);( 			}, 			qnt = (*alloc)[i][bit_alloc[k][i]].quant;! 			d = d * II_a[qnt] + II_b[qnt];;< 			/* extract MSB N-1 bits from the floating point sample */ 			if (d >= 0) sig = 1;  			else { sig = 0; d += 1.0; }	 			n = 0;  #ifndef MS_DOS- 			stps = (*alloc)[i][bit_alloc[k][i]].steps;* 			while ((1L<<n) < stps) n++; #elset, 			while  ( ( (unsigned long)(1L<<(long)n) <> 				     ((unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps) 				      & 0xffff
 				     ) 				  ) && ( n <16) 
 				) n++; #endif 			n--;a> 			sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));: 			/* tag the inverted sign bit to sbband at position N */? 			/* The bit inversion is a must for grouping with 3,5,9 steps*' 			   so it is done for all subbands */e 			if (sig)t$ 			    sbband[k][s][j][i] |= 1 << n; 		    }a
 		    else 			sbband[k][s][j][i] = 0; 		}r 	    }       for (s = 0; s < 3; s++)h$ 	for (j = sblimit; j < SBLIMIT; j++) 	    for (i = 0; i < 12; i++)  		for (k = stereo; k < 7; k++) 		    sbband[k][s][i][j] = 0;* }*   #ifdef Augmentation_7chla void II_subband_quantization_aug (unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32],0C 				  unsigned int (*j_scale)[3][32], double (*j_samps)[3][12][32],9G 				  unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32],  				  frame_params *fr_ps) {0*     int i, j, k, s, n, qnt, sig, m, l, ll;!     layer *info  = fr_ps->header;0      int center   = info->center;"     int surround = info->surround;     int stereo	= fr_ps->stereo;0#     int stereomc = fr_ps->stereomc;d%     int sblimit  = fr_ps->sblimit_mc;5     unsigned int stps;
     double d;5&     al_table *alloc = fr_ps->alloc_mc;       for (s = 0; s < 3; s++)7          for (j = 0; j < 12; j++)" 	    for (i = 0; i < sblimit; i++) 	    { 		ll = sbgrp[i];'                 for (m = 5; m < 7; ++m) 
 	        {. 		    k = transmission_channel (fr_ps, ll, m);  / 		    if (fr_ps->header->aug_dyn_cross_on == 1)5 		    {33 			/* 960627 FdB DynX dependent on configuration */ " 			if (dyn_ch (fr_ps, ll, m) == 0) 			    bit_alloc[k][i] = 0;0 		    }=   		    if (bit_alloc[k][i]) 		    {g: 			d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];< 			if (mod (d) >= 1.0) /* > changed to >=, 1992-11-06 shn */ 			{H 			    printf ("In MC, not scaled properly, %d %d %d %d\n", k, s, j, i);9 			    printf ("Value %1.10f\n", sb_samples[k][s][j][i]);r 			}, 			qnt = (*alloc)[i][bit_alloc[k][i]].quant;! 			d = d * II_a[qnt] + II_b[qnt]; < 			/* extract MSB N-1 bits from the floating point sample */ 			if (d >= 0) sig = 1;r 			else { sig = 0; d += 1.0; }	 			n = 0;  #ifndef MS_DOS- 			stps = (*alloc)[i][bit_alloc[k][i]].steps;c 			while ((1L<<n) < stps) n++; #elseo, 			while  ( ( (unsigned long)(1L<<(long)n) <> 				     ((unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps) 				      & 0xffff
 				     ) 				  ) && ( n <16)e
 				) n++; #endif 			n--;t> 			sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));: 			/* tag the inverted sign bit to sbband at position N */? 			/* The bit inversion is a must for grouping with 3,5,9 stepsh' 			   so it is done for all subbands */  			if (sig)n$ 			    sbband[k][s][j][i] |= 1 << n; 		    } 
 		    else 			sbband[k][s][j][i] = 0; 		}s 	    }       for (s = 0; s < 3; s++) $ 	for (j = sblimit; j < SBLIMIT; j++) 	    for (i = 0; i < 12; i++)  		for (k = 7; k < 12; k++) 		    sbband[k][s][i][j] = 0;t }t #endif  ` void II_subband_quantization_ml (unsigned int (*scalar)[3][32], double (*sb_samples)[3][12][32],B 				 unsigned int (*j_scale)[3][32], double (*j_samps)[3][12][32],F 				 unsigned int (*bit_alloc)[32], unsigned int (*sbband)[3][12][32], 				 frame_params *fr_ps)  {=*     int i, j, k, s, n, qnt, sig, m, l, ll;0     int n_ml_ch   = fr_ps->header->multiling_ch;$     int sblimit = fr_ps->sblimit_ml;.     int ml_lsf	 = fr_ps->header->multiling_fs;     unsigned int stps;
     double d;[&     al_table *alloc = fr_ps->alloc_ml;          for (s=0;s<3;s++) J 	for (j=0;j<((ml_lsf)?6:12);j++)    /* WtK half sample frequency 7/8/95 */ 	    for (i=0;i<sblimit;i++) 	    {! 		for (m = 7; m < 7+n_ml_ch; ++m)g 		{n 		    k = m; 		    if (bit_alloc[k][i]) 		    {e: 			d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];; 			if (mod(d) >= 1.0) /* > changed to >=, 1992-11-06 shn */*A 			{ printf("In ML, not scaled properly, %d %d %d %d\n",k,s,j,i);o5 			  printf("Value %1.10f\n",sb_samples[k][s][j][i]);2 			}, 			qnt = (*alloc)[i][bit_alloc[k][i]].quant;! 			d = d * II_a[qnt] + II_b[qnt];*< 			/* extract MSB N-1 bits from the floating point sample */ 			if (d >= 0) sig = 1;[ 			else { sig = 0; d += 1.0; }	 			n = 0;0- 			stps = (*alloc)[i][bit_alloc[k][i]].steps;t 			while ((1L<<n) < stps) n++; 			n--; > 			sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));: 			/* tag the inverted sign bit to sbband at position N */? 			/* The bit inversion is a must for grouping with 3,5,9 steps ' 			   so it is done for all subbands */b' 			if (sig) sbband[k][s][j][i] |= 1<<n;n 		    }:
 		    else 			sbband[k][s][j][i] = 0; 		}  	    }       for (s=0;s<3;s++)  	for (j=sblimit;j<SBLIMIT;j++)$ 	    for (i=0;i<((ml_lsf)?6:12);i++)! 		for (k = 7; k < 7+n_ml_ch; k++)o 		    sbband[k][s][i][j] = 0;a }[             I /************************************************************************_ /*  /* I_encode_bit_alloc  (Layer I)! /* II_encode_bit_alloc (Layer II) 1 /* II_encode_bit_alloc_mc (Layer II multichannel)  #ifdef Augmentation_7ch C /* II_encode_bit_alloc_aug (Layer II multichannel 7ch-augmentation)i #endif /*; /* PURPOSE:Writes bit allocation information onto bitstream  /*> /* Layer I uses 4 bits/subband for bit allocation information,6 /* and Layer II uses 4,3,2, or 0 bits depending on the /* quantization table used.i /*J /************************************************************************/   a void I_encode_bit_alloc(unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)* {o    int i,k;o    int stereo  = fr_ps->stereo;w     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;       for (i=0;i<SBLIMIT;i++)J      for (k=0;k<((i<jsbound)?stereo:1);k++) putbits(bs,bit_alloc[k][i],4); }    J /***************************** Layer II  ********************************/   c void II_encode_bit_alloc (unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)g {i    int i,k;t    int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc;  *    for (i=0;i<sblimit;i++)' 	for (k=0;k<((i<jsbound)?stereo:1);k++) 2 		putbits(bs,bit_alloc[k][i],(*alloc)[i][0].bits); }f    f void II_encode_bit_alloc_mc (unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs) {]     int i, k, l, m; $     layer *info     = fr_ps->header;#     int center      = info->center;s$     int stereo      = fr_ps->stereo;&     int stereomc    = fr_ps->stereomc;(     int sblimit     = fr_ps->sblimit_mc;&     al_table *alloc = fr_ps->alloc_mc;     !     for (i = 0; i < sblimit; i++)n     {  	l = sbgrp[i];- 	for (m = stereo; m < stereo + stereomc; ++m)m         {        =, 	    k = transmission_channel (fr_ps, l, m);  D             if ((fr_ps->header->center != 3) || (i < 12) || (k !=2))2 		/* 960627 FdB DynX dependent on configuration */  		if (dyn_ch (fr_ps, l, m) == 1)9 		    putbits (bs, bit_alloc[k][i], (*alloc)[i][0].bits);  	}     }	 }    #ifdef Augmentation_7ch)g void II_encode_bit_alloc_aug (unsigned int (*bit_alloc)[32], frame_params *fr_ps, Bit_stream_struc *bs)e {      int i, k, l, m; $     layer *info     = fr_ps->header;#     int center      = info->center;a&     int stereomc    = fr_ps->stereomc;(     int sblimit     = fr_ps->sblimit_mc;&     al_table *alloc = fr_ps->alloc_mc;     !     for (i = 0; i < sblimit; i++)g     {  	l = sbgrp[i]; 	for (m = 5; m < 7; ++m)         {        i, 	    k = transmission_channel (fr_ps, l, m);  # 	    if (dyn_ch (fr_ps, l, m) == 1) 5 		putbits (bs, bit_alloc[k][i], (*alloc)[i][0].bits);y 	}     }	 }" #endif    I /************************************************************************t /*  /* I_sample_encoding   (Layer I)! /* II_sample_encoding  (Layer II);' /* II_sample_encoding_mc  (Layer II) SRa #ifdef Augmentation_7chi) /* II_sample_encoding_aug  (Layer II) FdB+ #endif /*? /* PURPOSE:Put one frame of subband samples on to the bitstreams /*C /* SEMANTICS:  The number of bits allocated per sample is read fromo7 /* the bit allocation information #bit_alloc#.  Layer 2]: /* supports writing grouped samples for quantization steps /* that are not a power of 2.  /*J /************************************************************************/  	Y void I_sample_encoding (unsigned int (*sbband)[3][12][32], unsigned int (*bit_alloc)[32], - 			frame_params *fr_ps, Bit_stream_struc *bs)d { 
    int i,j,k;s    int stereo  = fr_ps->stereo;[     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;  ;    for(j=0;j<12;j++) {      for(i=0;i<SBLIMIT;i++)(,        for(k=0;k<((i<jsbound)?stereo:1);k++)N          if(bit_alloc[k][i]) putbits(bs,sbband[k][0][j][i],bit_alloc[k][i]+1);    } }i  fJ /***************************** Layer II  ********************************/  [Z void II_sample_encoding (unsigned int (*sbband)[3][12][32], unsigned int (*bit_alloc)[32],. 			 frame_params *fr_ps, Bit_stream_struc *bs) {2    unsigned int temp;d    unsigned int i,j,k,s,x,y;    int stereo	= fr_ps->stereo;"    int stereomc = fr_ps->stereomc;     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc;       for (s=0;s<3;s++)      for (j=0;j<12;j+=3)        for (i=0;i<sblimit;i++)/          for (k=0;k<((i<jsbound)?stereo:1);k++) !            if (bit_alloc[k][i]) { ;              if ((*alloc)[i][bit_alloc[k][i]].group == 3) { A                for (x=0;x<3;x++) putbits(bs,sbband[k][s][j+x][i],	I                                       (*alloc)[i][bit_alloc[k][i]].bits);   
             }c              else {;5                y =(*alloc)[i][bit_alloc[k][i]].steps;	*                temp = sbband[k][s][j][i] +0                       sbband[k][s][j+1][i] * y +3                       sbband[k][s][j+2][i] * y * y;fB                putbits(bs,temp,(*alloc)[i][bit_alloc[k][i]].bits);                }            } })        K /******************* Layer II five channels ******************************/e    [ void II_sample_encoding_mc (unsigned int (*sbband)[3][12][32], unsigned int lfe_sbband[12],)= 			    unsigned int (*bit_alloc)[32], unsigned int lfe_alloc,d1 			    frame_params *fr_ps, Bit_stream_struc *bs)i {f     unsigned int temp;#     unsigned int i,j,k,s,x,y, l, m;	$     layer *info     = fr_ps->header;#     int center      = info->center;)$     int stereo      = fr_ps->stereo;&     int stereomc    = fr_ps->stereomc;(     int sblimit     = fr_ps->sblimit_mc;&     al_table *alloc = fr_ps->alloc_mc;&     int lfe  =     fr_ps->header->lfe;          for (s = 0; s < 3; s++)	#         for (j = 0; j < 12; j += 3)[ 	{
 	    if (lfe)gH 	        putbits (bs, lfe_sbband[s*4+j/3], (*alloc)[0][lfe_alloc].bits);  " 	    for (i = 0; i < sblimit; i++) 	    { 		l = sbgrp[i];i, 		for (m = stereo; m < stereo+stereomc; m++) 		{u- 		    k = transmission_channel (fr_ps, l, m);] 	     @ 		    if (bit_alloc[k][i] && (i < 12 || m != 2 || center != 3))  		    { 7 		        if ((*alloc)[i][bit_alloc[k][i]].group == 3) T 			    for (x = 0; x < 3; x++)& 				putbits (bs, sbband[k][s][j+x][i],) 					 (*alloc)[i][bit_alloc[k][i]].bits);o 		        else n 			{, 			  y = (*alloc)[i][bit_alloc[k][i]].steps;  			  temp = sbband[k][s][j][i] + 				 sbband[k][s][j+1][i] * y +l" 				 sbband[k][s][j+2][i] * y * y;; 			  putbits (bs, temp, (*alloc)[i][bit_alloc[k][i]].bits);  	    			} 		    }_ 		}  	    } 	}	  }    #ifdef Augmentation_7ch;^ void II_sample_encoding_aug (unsigned int (*sbband)[3][12][32], unsigned int (*bit_alloc)[32],2 			     frame_params *fr_ps, Bit_stream_struc *bs) {i     unsigned int temp;#     unsigned int i,j,k,s,x,y, l, m;m$     int sblimit = fr_ps->sblimit_mc;&     al_table *alloc = fr_ps->alloc_mc;          for (s = 0; s < 3; s++) #         for (j = 0; j < 12; j += 3)o" 	    for (i = 0; i < sblimit; i++) 	    { 		l = sbgrp[i];( 		for (m = 5; m < 7; m++)  		{=- 		    k = transmission_channel (fr_ps, l, m);[ 	      		    if (bit_alloc[k][i]) g 		    { 7 		        if ((*alloc)[i][bit_alloc[k][i]].group == 3) l 			    for (x = 0; x < 3; x++)& 				putbits (bs, sbband[k][s][j+x][i],) 					 (*alloc)[i][bit_alloc[k][i]].bits);t 		        else n 			{, 			  y = (*alloc)[i][bit_alloc[k][i]].steps;  			  temp = sbband[k][s][j][i] + 				 sbband[k][s][j+1][i] * y +g" 				 sbband[k][s][j+2][i] * y * y;; 			  putbits (bs, temp, (*alloc)[i][bit_alloc[k][i]].bits);t 			} 		    }< 		}  	    } }  #endif  I /************************************************************************h /*
 /* encode_CRC  /*J /************************************************************************/  ,8 void encode_CRC (unsigned int crc, Bit_stream_struc *bs) {g    putbits (bs, crc, 16);n }   L /*************************************************************************** /* /* ancillary_encode  /*H /* PURPOSE: The use of ancillary part of the bitstream for information   /*          storage. /*         ]
 /*        L /**************************************************************************/  # void ancillary_encode(fr_ps,bs,adb)( frame_params *fr_ps; Bit_stream_struc *bs;  int adb; {b     int bitsPerSlot; u     int	samplesPerFrame;     int	bit_rate;_     int	avg_slots_per_frame;     int	whole_SpF;     int	usedAdb;     int	adbNumberStart; 
     int l;4     char *mesg="This bitstream use ancillary part.";     extern int mesg_index;       register int i;d         double frac_SpF;     double slot_lag;      layer *info = fr_ps->header;    E     if (info->lay == 1) { bitsPerSlot = 32; samplesPerFrame = 384;  }/D     else               { bitsPerSlot = 8;  samplesPerFrame = 1152; }  9     bit_rate = bitrate[info->lay-1][info->bitrate_index];s  4     avg_slots_per_frame = ((double)samplesPerFrame />                            s_freq[info->sampling_frequency]) *C                           ((double)bit_rate / (double)bitsPerSlot);c,     whole_SpF = (int) avg_slots_per_frame;	   =     adbNumberStart = (whole_SpF+info->padding) * bitsPerSlot;o#     usedAdb = adbNumberStart - adb;c  '     if(usedAdb <= (adbNumberStart-8)) {c 	if(usedAdb % 8) {" 	   for(i=0;i<(8-(usedAdb%8));i++) 	      put1bit(bs,0);_# 	   usedAdb += (8 - (usedAdb % 8));> 	}& 	while(usedAdb < adbNumberStart - 8) { 	   for(i=0;i<8;i++) 	      put1bit(bs,0);< 	   usedAdb += 8;: 	}  	if(mesg_index >= strlen(mesg)){ 	   for(i=0;i<8;i++) 	      put1bit(bs,0);e	 	} else {m- 	   putbits(bs,(int)(mesg[mesg_index++]), 8);* 	}    } else {_ 	for(i=0;i<adb;i++)n 	   put1bit(bs,0);    }   }         	     	e    	    