G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) 0  * ISO 13818-3 MPEG-2 Audio Multichannel Encoder  *:  * $Id: dyn_cross.c 1.3 1996/02/12 07:13:35 rowlands Exp $  *  * $Log: dyn_cross.c $.  * Revision 1.3  1996/02/12 07:13:35  rowlands#  * Release following Munich meeting   *H  **********************************************************************/   #include "common.h"  #include "encoder.h"  I /************************************************************************   *  * take_dyn_cross   */  * Version 1.0	    94/10/24	Andreas Silzle, IRT   *C  * Copy the sums, scf, scfsi, if required, in the normal positions.   *J  ************************************************************************/    4 /* #define LOW_SBGR	5	original value 960619 FdB			*/J #define LOW_SBGR	0   /* lowest subbandgroup, in which dyn_cross is done.*/< 			    /* All sb-groups under that boarder are not	       */+ 			    /* affected by dyn_cross			       */    void take_dyn_cross (  	int		dyn_cr,	 	frame_params	*fr_ps,  		     . 	    /* out: int	fr_ps->header->dyn_cross_on, - 	     *	    int	fr_ps->header->dyn_cross_LR,  9     	     *	    int	fr_ps->header->dyn_cross[SBGRS],	      	     */			     9 	double		sb_sample_sum[5][3][SCALE_BLOCK][SBLIMIT], 	     , 						    /* in, T23, T24, T34, T234, T56 */4 	unsigned int	scalar_sum[][3][SBLIMIT], 			/* in */ 1 	unsigned int	scfsi_sum[][SBLIMIT],  				/* in */ 1 	unsigned int	scfsi_dyn[][SBLIMIT],  				/* in */ @ 	double		sb_sample[CHANMAX3][3][SCALE_BLOCK][SBLIMIT],	/* out */2 	unsigned int	scalar[][3][SBLIMIT], 				/* out */ - 	unsigned int	scfsi[][SBLIMIT]) 				/* out */  { 7     int	    sbgr, sb, sufr, smp, dyn_second_stereo = 0; !     layer *info  = fr_ps->header;       int center   = info->center;"     int surround = info->surround;  $     fr_ps->header->dyn_cross_on = 0;n     if (fr_ps->header->dyn_cross_LR && (fr_ps->config == 302 || fr_ps->config == 202 || fr_ps->config == 102)) 	dyn_second_stereo = 1;   * /*    printf ("dyn_cr: %2d\n", dyn_cr); */  /     for (sbgr = LOW_SBGR; sbgr < SBGRS; sbgr++)      {  	/* signalization */+ 	if (dyn_cr == 0 && dyn_second_stereo == 0)  	{( 	    fr_ps->header->dyn_cross[sbgr] = 0;0 	    fr_ps->header->dyn_second_stereo[sbgr] = 0; 	} 	else  	{% 	    fr_ps->header->dyn_cross_on = 1; % 	    /* original value 960619 FdB */  3 	    /* fr_ps->header->dyn_cross[sbgr] = dyn_cr; */ F 	    /* systematic variation of dynamic crosstalk over all subbands */ 	    if (dyn_cr == -1) 	    { 		switch (fr_ps->config) 		{ > 		    case 320:	fr_ps->header->dyn_cross[sbgr] = rand () % 15;
 				break; 		    case 310: = 		    case 220:	fr_ps->header->dyn_cross[sbgr] = rand () % 5; 
 				break; 		    case 300:  		    case 302: = 		    case 210:	fr_ps->header->dyn_cross[sbgr] = rand () % 2; 
 				break;2 		    default:	fr_ps->header->dyn_cross[sbgr] = 0;
 				break; 		}  	    }	 	    else * 		fr_ps->header->dyn_cross[sbgr] = dyn_cr;  @ 	    fr_ps->header->dyn_second_stereo[sbgr] = dyn_second_stereo; /*>             printf ("sbgr: %2d dyn_cr: %2d dyn_2nd_st: %2d\n",/ 	    	    sbgr, fr_ps->header->dyn_cross[sbgr], . 		    fr_ps->header->dyn_second_stereo[sbgr]); */# 	    /* copying sums, scf, scfsi */  	     5 	    /* 960627 FdB DynX dependent on configuration */  	    if (fr_ps->config == 320) 	    { 		/* 3/2 */ S 		if(fr_ps->header->dyn_cross[sbgr] == 9 || fr_ps->header->dyn_cross[sbgr] == 11) {  		    T3from[sbgr] = T2[sbgr];4 		    for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); # 			    sb<=sb_groups[sbgr]; sb++) { , 			scfsi[T2[sbgr]][sb] = scfsi_sum[T23][sb];" 			for(sufr = 0; sufr<3; ++sufr) {> 			    scalar[T2[sbgr]][sufr][sb] = scalar_sum[T23][sufr][sb];- 			    for(smp = 0; smp<SCALE_BLOCK; ++smp) { ) 				sb_sample[T2[sbgr]][sufr][smp][sb] =  * 				    sb_sample_sum[T23][sufr][smp][sb]; 			    }   /* for(smp..) */  			}	    /* for(sufr.). */ 		    }	    /* for(sb..) */  		} Y 		else if(fr_ps->header->dyn_cross[sbgr] == 10 || fr_ps->header->dyn_cross[sbgr] == 12) {  		    T4from[sbgr] = T2[sbgr];4 		    for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); # 			    sb<=sb_groups[sbgr]; sb++) { , 			scfsi[T2[sbgr]][sb] = scfsi_sum[T24][sb];" 			for(sufr = 0; sufr<3; ++sufr) {> 			    scalar[T2[sbgr]][sufr][sb] = scalar_sum[T24][sufr][sb];- 			    for(smp = 0; smp<SCALE_BLOCK; ++smp) { ) 				sb_sample[T2[sbgr]][sufr][smp][sb] =  * 				    sb_sample_sum[T24][sufr][smp][sb]; 			    }   /* for(smp..) */  			}	    /* for(sufr..) */ 		    }	    /* for(sb..) */  		} X 		else if(fr_ps->header->dyn_cross[sbgr] == 8 || fr_ps->header->dyn_cross[sbgr] == 13) { 		    T4from[sbgr] = T3[sbgr];4 		    for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); # 			    sb<=sb_groups[sbgr]; sb++) { , 			scfsi[T3[sbgr]][sb] = scfsi_sum[T34][sb];" 			for(sufr = 0; sufr<3; ++sufr) {> 			    scalar[T3[sbgr]][sufr][sb] = scalar_sum[T34][sufr][sb];- 			    for(smp = 0; smp<SCALE_BLOCK; ++smp) { ) 				sb_sample[T3[sbgr]][sufr][smp][sb] =  * 				    sb_sample_sum[T34][sufr][smp][sb]; 			    }   /* for(smp..) */  			}	    /* for(sufr..) */ 		    }	    /* for(sb..) */  		} 1 		else if(fr_ps->header->dyn_cross[sbgr] == 14) { - 		    T3from[sbgr] = T4from[sbgr] = T2[sbgr]; 4 		    for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); # 			    sb<=sb_groups[sbgr]; sb++) { - 			scfsi[T2[sbgr]][sb] = scfsi_sum[T234][sb]; " 			for(sufr = 0; sufr<3; ++sufr) {? 			    scalar[T2[sbgr]][sufr][sb] = scalar_sum[T234][sufr][sb]; - 			    for(smp = 0; smp<SCALE_BLOCK; ++smp) { ) 				sb_sample[T2[sbgr]][sufr][smp][sb] =  + 				    sb_sample_sum[T234][sufr][smp][sb];  			    }   /* for(smp..) */  			}	    /* for(sufr..) */ 		    }	    /* for(sb..) */ # 		}		    /* if(dyncr_do[sbgr]..) */  	 ' 		/* scfsi_dyn in scfsi of L0 and R0 */ 
 		/* T2 */* 		switch(fr_ps->header->dyn_cross[sbgr]) {/ 	      case 3: case 5: case 6: case 7: case 13: # 		    T2from[sbgr] = T2outof[sbgr]; 4 		    for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); " 			    sb<=sb_groups[sbgr]; sb++) ; 			scfsi[T2outof[sbgr]][sb] = scfsi_dyn[T2outof[sbgr]][sb];  		    break;	       		}	/* switch(dyncr_do[sbgr]) */
 		/* T3 */* 		switch(fr_ps->header->dyn_cross[sbgr]) {/ 	      case 2: case 4: case 6: case 7: case 12: # 		    T3from[sbgr] = T3outof[sbgr]; 4 		    for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); " 			    sb<=sb_groups[sbgr]; sb++) % 			scfsi[L0][sb] = scfsi_dyn[L0][sb];  		    break;	       		}	/* switch(dyncr_do[sbgr]) */
 		/* T4 */* 		switch(fr_ps->header->dyn_cross[sbgr]) {/ 	      case 1: case 4: case 5: case 7: case 11: # 		    T4from[sbgr] = T4outof[sbgr]; 4 		    for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); " 			    sb<=sb_groups[sbgr]; sb++) % 			scfsi[R0][sb] = scfsi_dyn[R0][sb];  		    break;	     0 		}	/* switch(fr_ps->header->dyn_cross[sbgr]) */ 	    }; 	    else if (fr_ps->config == 310 || fr_ps->config == 220)  	    { 		/* 3/1 and 2/2 */ + 		if(fr_ps->header->dyn_cross[sbgr] == 4) { 4 		    for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); # 			    sb<=sb_groups[sbgr]; sb++) { , 			scfsi[T2[sbgr]][sb] = scfsi_sum[T23][sb];" 			for(sufr = 0; sufr<3; ++sufr) {> 			    scalar[T2[sbgr]][sufr][sb] = scalar_sum[T23][sufr][sb];- 			    for(smp = 0; smp<SCALE_BLOCK; ++smp) { ) 				sb_sample[T2[sbgr]][sufr][smp][sb] =  * 				    sb_sample_sum[T23][sufr][smp][sb]; 			    }   /* for(smp..) */  			}	    /* for(sufr.). */ 		    }	    /* for(sb..) */  		}      ' 		/* scfsi_dyn in scfsi of L0 and R0 */ 
 		/* T2 */* 		switch(fr_ps->header->dyn_cross[sbgr]) { 	      case 2: case 3:4 		    for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); " 			    sb<=sb_groups[sbgr]; sb++) ; 			scfsi[T2outof[sbgr]][sb] = scfsi_dyn[T2outof[sbgr]][sb];  		    break;	       		}	/* switch(dyncr_do[sbgr]) */
 		/* T3 */* 		switch(fr_ps->header->dyn_cross[sbgr]) { 	      case 1: case 3:4 		    for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); " 			    sb<=sb_groups[sbgr]; sb++) ; 			scfsi[T3outof[sbgr]][sb] = scfsi_dyn[T3outof[sbgr]][sb];  		    break;	       		}	/* switch(dyncr_do[sbgr]) */ 	    }S 	    else if (fr_ps->config == 300 || fr_ps->config == 302 || fr_ps->config == 210)* 	    { 		/* 3/0 (+2/0) and 2/1 */' 		/* scfsi_dyn in scfsi of L0 and R0 */E
 		/* T2 */* 		switch(fr_ps->header->dyn_cross[sbgr]) { 	      case 1:4 		    for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); " 			    sb<=sb_groups[sbgr]; sb++) ; 			scfsi[T2outof[sbgr]][sb] = scfsi_dyn[T2outof[sbgr]][sb];7 		    break;	    *  		}	/* switch(dyncr_do[sbgr]) */     - 		if (fr_ps->header->dyn_second_stereo[sbgr])*O 		    for (sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); sb<=sb_groups[sbgr]; sb++)* 		    {*, 			scfsi[T3[sbgr]][sb] = scfsi_sum[T23][sb];! 			for (sufr = 0; sufr<3; ++sufr)  			{> 			    scalar[T3[sbgr]][sufr][sb] = scalar_sum[T23][sufr][sb];, 			    for (smp = 0; smp<SCALE_BLOCK; ++smp)K 				sb_sample[T3[sbgr]][sufr][smp][sb] = sb_sample_sum[T23][sufr][smp][sb];* 			}	    /* for(sufr..) */ 		    }	    /* for(sb..) */0 	    }# 	    else if (fr_ps->config == 202)s 	    {- 		if (fr_ps->header->dyn_second_stereo[sbgr])lO 		    for (sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); sb<=sb_groups[sbgr]; sb++)	 		    {*, 			scfsi[T2[sbgr]][sb] = scfsi_sum[T23][sb];! 			for (sufr = 0; sufr<3; ++sufr)  			{> 			    scalar[T2[sbgr]][sufr][sb] = scalar_sum[T23][sufr][sb];, 			    for (smp = 0; smp<SCALE_BLOCK; ++smp)K 				sb_sample[T2[sbgr]][sufr][smp][sb] = sb_sample_sum[T23][sufr][smp][sb];5 			}	    /* for(sufr.). */ 		    }	    /* for(sb..) */  	    }# 	    else if (fr_ps->config == 102)s 	    {- 		if (fr_ps->header->dyn_second_stereo[sbgr])[O 		    for (sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); sb<=sb_groups[sbgr]; sb++)d 		    {_% 			scfsi[1][sb] = scfsi_sum[T23][sb];T! 			for (sufr = 0; sufr<3; ++sufr)] 			{7 			    scalar[1][sufr][sb] = scalar_sum[T23][sufr][sb];	, 			    for (smp = 0; smp<SCALE_BLOCK; ++smp)D 				sb_sample[1][sufr][smp][sb] = sb_sample_sum[T23][sufr][smp][sb]; 			}	    /* for(sufr.). */ 		    }	    /* for(sb..) */r 	    }0 	}	/* if(fr_ps->header->dyn_cross[sbgr] == 0) */     }		/* for(sbgr=0.. */& }r   #ifdef Augmentation_7ch- void take_dyn_cross_aug (n 	int		aug_dyn_cr,	 	frame_params	*fr_ps,  		    n. 	    /* out: int	fr_ps->header->dyn_cross_on, - 	     *	    int	fr_ps->header->dyn_cross_LR, /9     	     *	    int	fr_ps->header->dyn_cross[SBGRS],	    = 	     */			    _9 	double		sb_sample_sum[5][3][SCALE_BLOCK][SBLIMIT], 	    e, 						    /* in, T23, T24, T34, T234, T56 */4 	unsigned int	scalar_sum[][3][SBLIMIT], 			/* in */ 1 	unsigned int	scfsi_sum[][SBLIMIT],  				/* in */s1 	unsigned int	scfsi_dyn[][SBLIMIT],  				/* in */o@ 	double		sb_sample[CHANMAX3][3][SCALE_BLOCK][SBLIMIT],	/* out */2 	unsigned int	scalar[][3][SBLIMIT], 				/* out */ - 	unsigned int	scfsi[][SBLIMIT]) 				/* out */1 {       int	    sbgr, sb, sufr, smp;!     layer *info  = fr_ps->header;s      int center   = info->center;"     int surround = info->surround;  (     fr_ps->header->aug_dyn_cross_on = 1;  /     for (sbgr = LOW_SBGR; sbgr < SBGRS; sbgr++)_     {d 	if (aug_dyn_cr == -1)7 	    fr_ps->header->aug_dyn_cross[sbgr] = rand () % 19;d 	elses5 	    fr_ps->header->aug_dyn_cross[sbgr] = aug_dyn_cr;e   	/* copying sums, scf, scfsi */  	 - 	if (fr_ps->header->aug_dyn_cross[sbgr] == 4): 	{6 	    for (sb = ((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); " 		    sb <= sb_groups[sbgr]; sb++) 	    {+ 		scfsi[T5[sbgr]][sb] = scfsi_sum[T56][sb]; " 		for (sufr = 0; sufr < 3; ++sufr) 		{ = 		    scalar[T5[sbgr]][sufr][sb] = scalar_sum[T56][sufr][sb];	- 		    for (smp = 0; smp < SCALE_BLOCK; ++smp) ( 			sb_sample[T5[sbgr]][sufr][smp][sb] = ) 			    sb_sample_sum[T56][sufr][smp][sb];  		}( 	    } 	}  + 	/* scfsi_dyn in scfsi of MPEG2 channels */r	 	/* L0 */ , 	switch (fr_ps->header->aug_dyn_cross[sbgr]) 	{( 	case 5: case 6: case 7: case 8: case 9:8 	      for (sb = ((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); % 		      sb <= sb_groups[sbgr]; sb++) C& 		  scfsi[L0][sb] = scfsi_dyn[L0][sb]; 	      break;	     	}	 	/* R0 */_, 	switch (fr_ps->header->aug_dyn_cross[sbgr]) 	{" 	case 1: case 6: case 11: case 15:8 	      for (sb = ((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); % 		      sb <= sb_groups[sbgr]; sb++) -& 		  scfsi[R0][sb] = scfsi_dyn[R0][sb]; 	      break;	     	}	 	/* T2 */s, 	switch (fr_ps->header->aug_dyn_cross[sbgr]) 	{= 	case 2: case 7: case 10: case 11: case 12: case 13: case 16:48 	      for (sb = ((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); % 		      sb <= sb_groups[sbgr]; sb++) u2 		  scfsi[T2[sbgr]][sb] = scfsi_dyn[T2[sbgr]][sb]; 	      break;	     	}	 	/* T3 */[, 	switch (fr_ps->header->aug_dyn_cross[sbgr]) 	{- 	case 14: case 15: case 16: case 17: case 18:/8 	      for (sb = ((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); % 		      sb <= sb_groups[sbgr]; sb++)  2 		  scfsi[T3[sbgr]][sb] = scfsi_dyn[T3[sbgr]][sb]; 	      break;	     	}	 	/* T4 */(, 	switch (fr_ps->header->aug_dyn_cross[sbgr]) 	{" 	case 3: case 8: case 13: case 17:8 	      for (sb = ((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); % 		      sb <= sb_groups[sbgr]; sb++) g2 		  scfsi[T4[sbgr]][sb] = scfsi_dyn[T4[sbgr]][sb]; 	      break;	     	}     }s }  #endif  I /************************************************************************[  *
  * trans_chan   */  * Version 1.0	    94/06/27	Andreas Silzle, IRT /  * Version 1.1	    94/10/28	Andreas Silzle, IRT-  *3  * Which channels are in the transmission channels bE  * T2[SBGRS], T3[SBGRS], T4[SBGRS], T2outof{SBGRS] per subband group. A  * T2outof[] can be changed later by fr_ps->header->dyn_cross_LR.i  *J  ************************************************************************/  , void trans_chan (frame_params *fr_ps) 		    1 	    /* in:  int	fr_ps->header->tc_alloc[SBGRS], l(     	     *	    int	fr_ps->numchan,	    F 	     *	    int	fr_ps->header->matrix,	    0 normal -, 3 no matricing E 	     *	    int fr_ps->header->dyn_cross_LR  0 out of L0, 1 out of R0r 	     */			      /*  global parametersc[  *  out:    T2[SBGRS], T3[SBGRS], T4[SBGRS], T2outof[SBGRS], T3outof[SBGRS], T4outof[SBGRS]c  */: {   
     int sbgr;   (     for (sbgr = 0; sbgr < SBGRS; sbgr++)     {o0 	/* 960627 FdB tca dependent on configuration */ 	if (fr_ps->config == 320) 	{ 	    /* 3/2 */, 	    switch(fr_ps->header->tc_alloc[sbgr]) {
 	  case 0:- 		T2[sbgr] = C; T3[sbgr] = LS; T4[sbgr] = RS;T& 		if(fr_ps->header->dyn_cross_LR == 0) 		    T2outof[sbgr] = L0;s 		else 		    T2outof[sbgr] = R0;  		T3outof[sbgr] = L0;f 		T4outof[sbgr] = R0;( 		break;
 	  case 1:- 		T2[sbgr] = L; T3[sbgr] = LS; T4[sbgr] = RS;b 		T2outof[sbgr] = L0;= 		T3outof[sbgr] = L0;	 		T4outof[sbgr] = R0;* 		break;
 	  case 2:- 		T2[sbgr] = R; T3[sbgr] = LS; T4[sbgr] = RS;r 		T2outof[sbgr] = R0;s 		T3outof[sbgr] = L0;s 		T4outof[sbgr] = R0;4 		break;
 	  case 3:, 		T2[sbgr] = C; T3[sbgr] = L; T4[sbgr] = RS;& 		if(fr_ps->header->dyn_cross_LR == 0) 		    T2outof[sbgr] = L0;] 		else 		    T2outof[sbgr] = R0;; 		T3outof[sbgr] = L0;r 		T4outof[sbgr] = R0;s 		break;
 	  case 4:, 		T2[sbgr] = C; T3[sbgr] = LS; T4[sbgr] = R;& 		if(fr_ps->header->dyn_cross_LR == 0) 		    T2outof[sbgr] = L0;r 		else 		    T2outof[sbgr] = R0;s 		T3outof[sbgr] = L0;s 		T4outof[sbgr] = R0;< 		break;
 	  case 5:+ 		T2[sbgr] = C; T3[sbgr] = L; T4[sbgr] = R;[& 		if(fr_ps->header->dyn_cross_LR == 0) 		    T2outof[sbgr] = L0;u 		else 		    T2outof[sbgr] = R0;; 		T3outof[sbgr] = L0;m 		T4outof[sbgr] = R0;  		break;
 	  case 6:, 		T2[sbgr] = R; T3[sbgr] = L; T4[sbgr] = RS; 		T2outof[sbgr] = R0;	 		T3outof[sbgr] = L0;* 		T4outof[sbgr] = R0;r 		break;
 	  case 7:, 		T2[sbgr] = L; T3[sbgr] = LS; T4[sbgr] = R; 		T2outof[sbgr] = L0;  		T3outof[sbgr] = L0;_ 		T4outof[sbgr] = R0;b 		break; 	    }	/* switch() */	 	} 	else if (fr_ps->config == 310)s 	{ 	    /* 3/1 */, 	    switch(fr_ps->header->tc_alloc[sbgr]) {
 	  case 0: 		T2[sbgr] = 2;o 		T3[sbgr] = 3;	& 		if(fr_ps->header->dyn_cross_LR == 0)) 		    T2outof[sbgr] = T3outof[sbgr] = L0;d 		else) 		    T2outof[sbgr] = T3outof[sbgr] = R0;  		break;
 	  case 1: 		T2[sbgr] = L;- 		T3[sbgr] = 3;s 		T2outof[sbgr] = L0;+& 		if(fr_ps->header->dyn_cross_LR == 0) 		    T3outof[sbgr] = L0;	 		else 		    T3outof[sbgr] = R0;c 		break;
 	  case 2: 		T2[sbgr] = R;r 		T3[sbgr] = 3;0 		T2outof[sbgr] = R0;2& 		if(fr_ps->header->dyn_cross_LR == 0) 		    T3outof[sbgr] = L0;* 		else 		    T3outof[sbgr] = R0;E 		break;
 	  case 3: 		T2[sbgr] = 2;y 		T3[sbgr] = L; & 		if(fr_ps->header->dyn_cross_LR == 0) 		    T2outof[sbgr] = L0;  		else 		    T2outof[sbgr] = R0;  		T3outof[sbgr] = L0;] 		break;
 	  case 4: 		T2[sbgr] = 2;  		T3[sbgr] = R;*& 		if(fr_ps->header->dyn_cross_LR == 0) 		    T2outof[sbgr] = L0;s 		else 		    T2outof[sbgr] = R0;= 		T3outof[sbgr] = R0;p 		break;
 	  case 5: 		T2[sbgr] = L;+ 		T3[sbgr] = R;s 		T2outof[sbgr] = L0;f 		T3outof[sbgr] = R0;r 		break; 	    }	/* switch() */{ 	} 	else if (fr_ps->config == 220)  	{ 	    /* 2/2 */, 	    switch(fr_ps->header->tc_alloc[sbgr]) {
 	  case 0: 		T2[sbgr] = 2; T3[sbgr] = 3;s 		break;
 	  case 1: 		T2[sbgr] = L; T3[sbgr] = 3;  		break;
 	  case 2: 		T2[sbgr] = 2; T3[sbgr] = R;  		break;
 	  case 3: 		T2[sbgr] = L; T3[sbgr] = R;r 		break; 	    }	/* switch() */g 	    T2outof[sbgr] = L0; 	    T3outof[sbgr] = R0; 	}7 	else if (fr_ps->config == 300 || fr_ps->config == 302)r 	{ 	    /* 3/0 (+ 2/0) */, 	    switch(fr_ps->header->tc_alloc[sbgr]) {
 	  case 0: 		T2[sbgr] = 2;b& 		if(fr_ps->header->dyn_cross_LR == 0) 		    T2outof[sbgr] = L0;K 		else 		    T2outof[sbgr] = R0;u 		break;
 	  case 1: 		T2[sbgr] = L;[ 		T2outof[sbgr] = L0;  		break;
 	  case 2: 		T2[sbgr] = R;) 		T2outof[sbgr] = R0;  		break; 	    }	/* switch() */{ 	} 	else if (fr_ps->config == 210)r 	{ 	    /* 2/1 */, 	    switch(fr_ps->header->tc_alloc[sbgr]) {
 	  case 0: 		T2[sbgr] = 2;	& 		if(fr_ps->header->dyn_cross_LR == 0) 		    T2outof[sbgr] = L0;u 		else 		    T2outof[sbgr] = R0;[ 		break;
 	  case 1: 		T2[sbgr] = L;] 		T2outof[sbgr] = L0;; 		break;
 	  case 2: 		T2[sbgr] = R;[ 		T2outof[sbgr] = R0;s 		break; 	    }	/* switch() */	 	} 	if (fr_ps->config == 302) 	{ 	    /* 3/0 + 2/0 */ 	    T3[sbgr] = 3; > 	    T4[sbgr] = 4; r 	    T4outof[sbgr] = 3;( 	} 	else if (fr_ps->config == 202)o 	{ 	    /* 2/0 + 2/0 */ 	    T2[sbgr] = 2; y 	    T3[sbgr] = 3; 	 	    T3outof[sbgr] = 2;  	} 	else if (fr_ps->config == 102)  	{ 	    /* 1/0 + 2/0 */ 	    T2[sbgr] = 2; / 	    T2outof[sbgr] = 1;p 	}     }	/* for(sbgr.. */ }    #ifdef Augmentation_7chl0 void trans_chan_aug (frame_params *fr_ps) 		    1 	    /* in:  int	fr_ps->header->tc_alloc[SBGRS], u(     	     *	    int	fr_ps->numchan,	    F 	     *	    int	fr_ps->header->matrix,	    0 normal -, 3 no matricing E 	     *	    int fr_ps->header->dyn_cross_LR  0 out of L0, 1 out of R03 	     */			    L /*  global parametersg[  *  out:    T2[SBGRS], T3[SBGRS], T4[SBGRS], T2outof[SBGRS], T3outof[SBGRS], T4outof[SBGRS]   */  {  	
     int sbgr;u  (     for (sbgr = 0; sbgr < SBGRS; sbgr++)     {n
 	/* 5/2 */+ 	switch (fr_ps->header->aug_tc_alloc[sbgr])o 	{ 	case 0: 	      T5[sbgr] = LC;o 	      T6[sbgr] = RC;s
 	      break;  	case 1: 	      T5[sbgr] = L7;i 	      T6[sbgr] = RC; 
 	      break;r 	case 2: 	      T5[sbgr] = LC;  	      T6[sbgr] = R7;s
 	      break;y 	case 3: 	      T5[sbgr] = L7;/ 	      T6[sbgr] = R7;f
 	      break;  	case 4: 	      T5[sbgr] = LC;r 	      T6[sbgr] = C7;(
 	      break;  	case 5: 	      T5[sbgr] = L7;  	      T6[sbgr] = C7;;
 	      break;  	case 6: 	      T5[sbgr] = C7;[ 	      T6[sbgr] = RC; 
 	      break;+ 	case 7: 	      T5[sbgr] = C7;r 	      T6[sbgr] = R7;u
 	      break;] 	}	/* switch() */=     }  }C #endif  I /************************************************************************6  *
  * combine  */  * Version 1.0	    94/06/27	Andreas Silzle, IRTG  *G  * Add two channels into a mono channel to use it in dynamic crosstalk.   *J  ************************************************************************/   void combine (   	frame_params	*fr_ps, 		    1 	    /* in:  int	fr_ps->header->tc_alloc[SBGRS],  " 	     *	    int fr_ps->sblimit,			 	     */> 	double	sb_sample[CHANMAX3][3][SCALE_BLOCK][SBLIMIT],	/* in */4 	double	sb_sample_sum[5][3][SCALE_BLOCK][SBLIMIT]) 	) 		    /* out; T23, T24, T34, T234, T56 */; {  ) /*  global parameters '  *  in:	T2[SBGRS], T3[SBGRS], T4[SBGRS]}  *      sb_groups[SBGRS]  */e     int sb, sbgr, smp, sufr;  &     for (sbgr=0; sbgr < SBGRS; sbgr++)     {e2 	for (sb = ((sbgr==0) ? 0:(sb_groups[sbgr-1]+1));  		sb <= sb_groups[sbgr]; sb++) 	{, 	    for (smp = 0; smp < SCALE_BLOCK; smp++) 	    {" 		for (sufr = 0; sufr < 3; ++sufr) 		{ g 		    if (fr_ps->config == 320 || fr_ps->config == 310 || fr_ps->config == 220 || fr_ps->config == 202)c' 			sb_sample_sum[T23][sufr][smp][sb] = :/ 			    .5 * (sb_sample[T2[sbgr]][sufr][smp][sb][* 				+ sb_sample[T3[sbgr]][sufr][smp][sb]);$ 		    else if (fr_ps->config == 102)' 			sb_sample_sum[T23][sufr][smp][sb] = d/ 			    .5 * (sb_sample[1       ][sufr][smp][sb]s* 				+ sb_sample[T2[sbgr]][sufr][smp][sb]);$ 		    else if (fr_ps->config == 302)' 			sb_sample_sum[T23][sufr][smp][sb] = [/ 			    .5 * (sb_sample[T3[sbgr]][sufr][smp][sb]b* 				+ sb_sample[T4[sbgr]][sufr][smp][sb]); 		    if (fr_ps->config == 320)* 		    {*' 			sb_sample_sum[T24][sufr][smp][sb] = a/ 			    .5 * (sb_sample[T2[sbgr]][sufr][smp][sb]e* 				+ sb_sample[T4[sbgr]][sufr][smp][sb]);' 			sb_sample_sum[T34][sufr][smp][sb] = n/ 			    .5 * (sb_sample[T3[sbgr]][sufr][smp][sb]G* 				+ sb_sample[T4[sbgr]][sufr][smp][sb]);( 			sb_sample_sum[T234][sufr][smp][sb] = 4 			    .333333 * (sb_sample[T2[sbgr]][sufr][smp][sb]( 				+ sb_sample[T3[sbgr]][sufr][smp][sb]* 				+ sb_sample[T4[sbgr]][sufr][smp][sb]); 		    }_ 		}   /* for(sufr.. */ 	    }	    /* for(smp.. */ 	}	    /* for(sb.. */	     }		    /* for(sbgr.. */	 }    #ifdef Augmentation_7chm void combine_aug ( , 	frame_params	*fr_ps, 		    1 	    /* in:  int	fr_ps->header->tc_alloc[SBGRS],  " 	     *	    int fr_ps->sblimit,			 	     */> 	double	sb_sample[CHANMAX3][3][SCALE_BLOCK][SBLIMIT],	/* in */4 	double	sb_sample_sum[5][3][SCALE_BLOCK][SBLIMIT]) 	) 		    /* out; T23, T24, T34, T234, T56 */s {  ) /*  global parametersB'  *  in:	T2[SBGRS], T3[SBGRS], T4[SBGRS]f  *      sb_groups[SBGRS]  *//     int sb, sbgr, smp, sufr;  (     for (sbgr = 0; sbgr < SBGRS; sbgr++)     {C2 	for (sb = ((sbgr==0) ? 0:(sb_groups[sbgr-1]+1));  		sb <= sb_groups[sbgr]; sb++) 	{, 	    for (smp = 0; smp < SCALE_BLOCK; smp++) 	    {" 		for (sufr = 0; sufr < 3; ++sufr) 		{(* 		    sb_sample_sum[T56][sufr][smp][sb] = + 			.5 * (sb_sample[T5[sbgr]][sufr][smp][sb] - 			    + sb_sample[T6[sbgr]][sufr][smp][sb]);  		}   /* for (sufr.. */: 	    }	    /* for (smp.. */L 	}	    /* for (sb.. */     }		    /* for (sbgr.. */	b }  #endif  M /****************************************************************************g  *  *  void dyn_bal  *H  *  Add the bits for scf and scfsi of the channel with dynamic crosstalk'  *  in the case of min_ch is L0 and R0.4  *  *  07/94	Susanne Ritscher-  *  94/10/28	Andreas Silzle	    little remaker  *O  *****************************************************************************/	   void dyn_bal (3 	unsigned int	scfsi[CHANMAX3][SBLIMIT],   /* in */ < 	int		sbgr,			    /* in */ 	frame_params	*fr_ps,L. 	    /* in:  fr_ps->header->dyn_cross[sbgr] */ 	int		min_ch,			    /* in */ 	int		min_sb,			    /* in */  	int		*seli,			    /* in, out */! 	int		*scale)			    /* in, out */; {  /*  global parametersRW  *  in:	T2[SBGRS], T3[SBGRS], T4[SBGRS], T2outof[SBGRS], T3outof[SBGRS], T4outof[SBGRS][  */ K     static int	sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */	!     layer *info  = fr_ps->header;r      int center   = info->center;"     int surround = info->surround;  4     /* 960627 FdB DynX dependent on configuration */     if (fr_ps->config == 320)l     {r
 	/* 3/2 */* 	switch (fr_ps->header->dyn_cross[sbgr]) {       case 0:	1 	    break;	    /* no additional scf and scfsi */[       case 1:  l 	    if (min_ch == R0) {
 		*seli += 2; 5 		*scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];] 	    } 	    break;r       case 2:  _ 	    if (min_ch == L0) {
 		*seli += 2;u5 		*scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];	 	    } 	    break;	       case 3: A 	    if (min_ch == T2outof[sbgr] && (center != 3 || sbgr < 10)) {r
 		*seli += 2;	5 		*scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];  	    } 	    break;s       case 4:  	    if (min_ch == L0) {
 		*seli += 2;d5 		*scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];l 	    } 	    if (min_ch == R0) {
 		*seli += 2; 5 		*scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];] 	    } 	    break;e       case 5:  RA 	    if (min_ch == T2outof[sbgr] && (center != 3 || sbgr < 10)) {0
 		*seli += 2;b5 		*scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];3 	    } 	    if (min_ch == R0) {
 		*seli += 2;b5 		*scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];  	    } 	    break;2       case 6: A 	    if (min_ch == T2outof[sbgr] && (center != 3 || sbgr < 10)) { 
 		*seli += 2; 5 		*scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];3 	    } 	    if (min_ch == L0) {
 		*seli += 2;25 		*scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];  	    } 	    break;a       case 7: A 	    if (min_ch == T2outof[sbgr] && (center != 3 || sbgr < 10)) { 
 		*seli += 2;-5 		*scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];/ 	    } 	    if (min_ch == L0) {
 		*seli += 2;[5 		*scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];d 	    } 	    if (min_ch == R0) {
 		*seli += 2;K5 		*scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];  	    } 	    break; 
       case 8:  	    if (min_ch == T3[sbgr]) {
 		*seli += 2; 5 		*scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];{ 	    } 	    break;-       case 9:    	    if (min_ch == T2[sbgr]) {
 		*seli += 2;t5 		*scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];_ 	    } 	    break;_       case 10:   	    if (min_ch == T2[sbgr]) {
 		*seli += 2; 5 		*scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];o 	    } 	    break;a       case 11:   	    if (min_ch == T2[sbgr]) {
 		*seli += 2;;5 		*scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];) 	    } 	    if (min_ch == R0) {
 		*seli += 2; 5 		*scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];s 	    } 	    break;=       case 12:   	    if (min_ch == T2[sbgr]) {
 		*seli += 2;b5 		*scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];p 	    } 	    if (min_ch == L0) {
 		*seli += 2; 5 		*scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];* 	    } 	    break;        case 13:  A 	    if (min_ch == T2outof[sbgr] && (center != 3 || sbgr < 10)) {n
 		*seli += 2;e5 		*scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];m 	    } 	    if (min_ch == T3[sbgr]) {
 		*seli += 2;05 		*scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];e 	    } 	    break;t       case 14:   	    if (min_ch == T2[sbgr]) {
 		*seli += 4;*5 		*scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];S5 		*scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];  	    } 	    break;g       case 15: R3 	    fprintf(stderr, "FORBIDDEN DYN_CROSS!!!!!\n");r 	    fflush(stderr);
 	    exit(0);  	    break;r 	}	    /* switch.. */r     }s:     else if (fr_ps->config == 310 || fr_ps->config == 220)     {  	/* 3/1 and 2/2 */* 	switch (fr_ps->header->dyn_cross[sbgr]) {       case 0:	1 	    break;	    /* no additional scf and scfsi */        case 1:   # 	    if (min_ch == T3outof[sbgr]) { 
 		*seli += 2;r5 		*scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];  	    } 	    break;        case 2:  7A 	    if (min_ch == T2outof[sbgr] && (center != 3 || sbgr < 10)) {r
 		*seli += 2; 5 		*scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];b 	    } 	    break;e       case 3: A 	    if (min_ch == T2outof[sbgr] && (center != 3 || sbgr < 10)) {*
 		*seli += 2;*5 		*scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];1 	    }# 	    if (min_ch == T3outof[sbgr]) {A
 		*seli += 2; 5 		*scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];* 	    } 	    break;*       case 4:  * 	    if (min_ch == T2[sbgr]) {
 		*seli += 2;m5 		*scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];t 	    } 	    break;l       default:  3 	    fprintf(stderr, "FORBIDDEN DYN_CROSS!!!!!\n");s 	    fflush(stderr);
 	    exit(0);I 	    break;  	}	    /* switch.. */]     }LR     else if (fr_ps->config == 300 || fr_ps->config == 302 || fr_ps->config == 210)     {r 	/* 3/0 (+2/0) and 2/1 */B) 	switch(fr_ps->header->dyn_cross[sbgr]) {        case 0:	1 	    break;	    /* no additional scf and scfsi */;       case 1:   A 	    if (min_ch == T2outof[sbgr] && (center != 3 || sbgr < 10)) {p
 		*seli += 2; 5 		*scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];{ 	    } 	    break;f       default: 	3 	    fprintf(stderr, "FORBIDDEN DYN_CROSS!!!!!\n");= 	    fflush(stderr);
 	    exit(0);- 	    break;2 	}	    /* switch.. */3     V 	if (fr_ps->config == 302 && info->dyn_second_stereo[sbgr] && min_ch == T4outof[sbgr]) 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]]; 	}     }]^     else if (fr_ps->config == 202 && info->dyn_second_stereo[sbgr] && min_ch == T3outof[sbgr])     {  	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];     } ^     else if (fr_ps->config == 102 && info->dyn_second_stereo[sbgr] && min_ch == T2outof[sbgr])     {p 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];     }  }_     #ifdef Augmentation_7chb void dyn_bal_aug (3 	unsigned int	scfsi[CHANMAX3][SBLIMIT],   /* in */ r 	int		sbgr,			    /* in */E 	frame_params	*fr_ps,			    /* in:  fr_ps->header->dyn_cross[sbgr] */m 	int		min_ch,			    /* in */ 	int		min_sb,			    /* in */  	int		*seli,			    /* in, out */! 	int		*scale)			    /* in, out */] {u /*  global parameterss2  *  in:	T2[SBGRS], T3[SBGRS], T4[SBGRS], T5[SBGRS]  */sK     static int	sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */o+     int dynx_T2 = !dyn_ch (fr_ps, sbgr, 2); +     int dynx_T3 = !dyn_ch (fr_ps, sbgr, 3);	+     int dynx_T4 = !dyn_ch (fr_ps, sbgr, 4);c(     int T5T0 = L0, T6T0 = L0, T6T1 = R0;     Y     if (fr_ps->header->aug_tc_alloc[sbgr] == 4 || fr_ps->header->aug_tc_alloc[sbgr] == 5)_*     	if (fr_ps->header->dyn_cross_LR == 0) 	    T6T1 = L0;3 	else, 	    T6T0 = R0;*^     else if (fr_ps->header->aug_tc_alloc[sbgr] == 6 || fr_ps->header->aug_tc_alloc[sbgr] == 7)(         if (fr_ps->header->dyn_cross_LR) 	    T5T0 = R0;B  
     /* 5/2 */ /     switch (fr_ps->header->aug_dyn_cross[sbgr])1     {	     case  0:- 	break;	    /* no additional scf and scfsi */A     case  1: 	if (min_ch == T6T1) 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;e     case  2:? 	if (min_ch == T2[sbgr] || (dynx_T2 && min_ch == T2from[sbgr]))  	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;      case  3:? 	if (min_ch == T4[sbgr] || (dynx_T4 && min_ch == T4from[sbgr]))* 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;h     case  4: 	if (min_ch == T5[sbgr]) 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;l     case  5: 	if (min_ch == T5T0) 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]]; 	} 	break;s     case  6: 	if (min_ch == T5T0) 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]]; 	} 	else if (min_ch == T6T1)/ 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;/     case  7: 	if (min_ch == T5T0) 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]]; 	}? 	if (min_ch == T2[sbgr] || (dynx_T2 && min_ch == T2from[sbgr]))f 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;      case  8: 	if (min_ch == T5T0) 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]]; 	}? 	if (min_ch == T4[sbgr] || (dynx_T4 && min_ch == T4from[sbgr]))_ 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;i     case  9: 	if (min_ch == T5T0) 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]]; 	} 	if (min_ch == T6T0) 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;s     case 10:? 	if (min_ch == T2[sbgr] || (dynx_T2 && min_ch == T2from[sbgr]))= 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]]; 	} 	break;[     case 11:? 	if (min_ch == T2[sbgr] || (dynx_T2 && min_ch == T2from[sbgr]))c 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]]; 	} 	if (min_ch == T6T1) 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;      case 12:? 	if (min_ch == T2[sbgr] || (dynx_T2 && min_ch == T2from[sbgr]))| 	{ 	    *seli += 4;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]];8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;      case 13:? 	if (min_ch == T2[sbgr] || (dynx_T2 && min_ch == T2from[sbgr]))  	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]]; 	}? 	if (min_ch == T4[sbgr] || (dynx_T4 && min_ch == T4from[sbgr]))  	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;]     case 14:? 	if (min_ch == T3[sbgr] || (dynx_T3 && min_ch == T3from[sbgr]))c 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]]; 	} 	break;_     case 15:? 	if (min_ch == T3[sbgr] || (dynx_T3 && min_ch == T3from[sbgr]))r 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]]; 	} 	if (min_ch == T6T1) 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;[     case 16:? 	if (min_ch == T3[sbgr] || (dynx_T3 && min_ch == T3from[sbgr])){ 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]]; 	}? 	if (min_ch == T2[sbgr] || (dynx_T2 && min_ch == T2from[sbgr]))  	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;+     case 17:? 	if (min_ch == T3[sbgr] || (dynx_T3 && min_ch == T3from[sbgr]))1 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]]; 	}? 	if (min_ch == T4[sbgr] || (dynx_T4 && min_ch == T4from[sbgr]))l 	{ 	    *seli += 2;8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;      case 18:? 	if (min_ch == T3[sbgr] || (dynx_T3 && min_ch == T3from[sbgr]))P 	{ 	    *seli += 4;8 	    *scale += 6 * sfsPerScfsi[scfsi[T5[sbgr]][min_sb]];8 	    *scale += 6 * sfsPerScfsi[scfsi[T6[sbgr]][min_sb]]; 	} 	break;    default:  4 	fprintf (stderr, "FORBIDDEN AUG_DYN_CROSS!!!!!\n"); 	fflush (stderr);<
 	exit (1); 	break;2     }s }e #endif    M /****************************************************************************s  *  *  void choose_dyn   *F  *  bit_alloc of the dynamic crosstalk channels must be have a value; '  *  only for sending scf in datastream.s  *  *  07/94	Susanne Ritscher-  *  94/10/31	Andreas Silzle	    little remake    *  94/12/30	Andreas Silzle	    9  *		    fill only up to that subband of the basic channeln  *		    which is unequal zero.  *O  *****************************************************************************/r   void choose_dyn (  	frame_params	*fr_ps, , 	    /* in:  fr_ps->header->dyn_cross[sbgr]  	     *	    fr_ps->alloc 	     */ 	int		min_ch,				/* in */	 	int		min_sb,				/* in */i 	int		sbgr, 				/* in */5 	unsigned int	bit_alloc[CHANMAX3][SBLIMIT])	/* out */  {s /*  global parameters 7  *  in:	T2[SBGRS], T3[SBGRS], T4[SBGRS], T2outof[SBGRS]b  */ !     layer *info  = fr_ps->header;       int center   = info->center;"     int surround = info->surround;  0 /* 960627 FdB DynX dependent on configuration */ if (fr_ps->config == 320)  {a
     /* 3/2 */ ,     switch(fr_ps->header->dyn_cross[sbgr]) {
   case 0:	 	break; 
   case 1: / 	if(min_ch == R0 && bit_alloc[R0][min_sb] != 0)1% 	    bit_alloc[T4[sbgr]][min_sb] = 1;g 	break;	
   case 2: / 	if(min_ch == L0 && bit_alloc[L0][min_sb] != 0)_% 	    bit_alloc[T3[sbgr]][min_sb] = 1;e 	break; 
   case 3: E 	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0)s( 	       bit_alloc[T2[sbgr]][min_sb] = 1; 	break;l
   case 4: / 	if(min_ch == R0 && bit_alloc[R0][min_sb] != 0) % 	    bit_alloc[T4[sbgr]][min_sb] = 1; / 	if(min_ch == L0 && bit_alloc[L0][min_sb] != 0)e% 	    bit_alloc[T3[sbgr]][min_sb] = 1;f 	break; 
   case 5: F 	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0) % 	    bit_alloc[T2[sbgr]][min_sb] = 1; 0 	if(min_ch == R0 && bit_alloc[R0][min_sb] != 0) % 	    bit_alloc[T4[sbgr]][min_sb] = 1;o 	break;]
   case 6: F 	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0) % 	    bit_alloc[T2[sbgr]][min_sb] = 1;e0 	if(min_ch == L0 && bit_alloc[L0][min_sb] != 0) % 	    bit_alloc[T3[sbgr]][min_sb] = 1;( 	break; 
   case 7: F 	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0) % 	    bit_alloc[T2[sbgr]][min_sb] = 1;i0 	if(min_ch == L0 && bit_alloc[L0][min_sb] != 0) % 	    bit_alloc[T3[sbgr]][min_sb] = 1;r0 	if(min_ch == R0 && bit_alloc[R0][min_sb] != 0) % 	    bit_alloc[T4[sbgr]][min_sb] = 1;g 	break;_
   case 8: ; 	if(min_ch == T3[sbgr] && bit_alloc[T3[sbgr]][min_sb] != 0)S% 	    bit_alloc[T4[sbgr]][min_sb] = 1;  	break;i
   case 9: ; 	if(min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0)u% 	    bit_alloc[T3[sbgr]][min_sb] = 1;  	break; 
  case 10: ; 	if(min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0)e% 	    bit_alloc[T4[sbgr]][min_sb] = 1;g 	break;c
  case 11: ; 	if(min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0)p% 	    bit_alloc[T3[sbgr]][min_sb] = 1;e/ 	if(min_ch == R0 && bit_alloc[R0][min_sb] != 0) % 	    bit_alloc[T4[sbgr]][min_sb] = 1;	 	break; 
  case 12: ; 	if(min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0)m% 	    bit_alloc[T4[sbgr]][min_sb] = 1;4/ 	if(min_ch == L0 && bit_alloc[L0][min_sb] != 0)f% 	    bit_alloc[T3[sbgr]][min_sb] = 1;p 	break;*
  case 13: F 	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0) % 	    bit_alloc[T2[sbgr]][min_sb] = 1;f; 	if(min_ch == T3[sbgr] && bit_alloc[T3[sbgr]][min_sb] != 0) % 	    bit_alloc[T4[sbgr]][min_sb] = 1;[ 	break;4
  case 14: = 	if(min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0) {r% 	    bit_alloc[T3[sbgr]][min_sb] = 1; % 	    bit_alloc[T4[sbgr]][min_sb] = 1;e 	} 	break;a
  case 15: / 	fprintf(stderr, "FORBIDDEN DYN_CROSS!!!!!\n");  	fflush(stderr);	 	exit(0);c 	break;      }	    /* switch.. */ }26 else if (fr_ps->config == 310 || fr_ps->config == 220) {      /* 3/1 and 2/2 */k,     switch(fr_ps->header->dyn_cross[sbgr]) {
   case 0:	 	break; 
   case 1: E 	if(min_ch == T3outof[sbgr] && bit_alloc[T3outof[sbgr]][min_sb] != 0)s% 	    bit_alloc[T3[sbgr]][min_sb] = 1;m 	break;T
   case 2: E 	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0) % 	    bit_alloc[T2[sbgr]][min_sb] = 1;s 	break; 
   case 3: F 	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0) % 	    bit_alloc[T2[sbgr]][min_sb] = 1; F 	if(min_ch == T3outof[sbgr] && bit_alloc[T3outof[sbgr]][min_sb] != 0) % 	    bit_alloc[T3[sbgr]][min_sb] = 1;e 	break; 
   case 4: ; 	if(min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0) % 	    bit_alloc[T3[sbgr]][min_sb] = 1;  	break;+
  default: / 	fprintf(stderr, "FORBIDDEN DYN_CROSS!!!!!\n");; 	fflush(stderr);	 	exit(0);  	break;c     }	    /* switch.. */ } N else if (fr_ps->config == 300 || fr_ps->config == 302 || fr_ps->config == 210) {=     /* 3/0 (+2/0) and 2/1 */,     switch(fr_ps->header->dyn_cross[sbgr]) {
   case 0:	 	break;e
   case 1: E 	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0)s% 	    bit_alloc[T2[sbgr]][min_sb] = 1;} 	break;n
  default: / 	fprintf(stderr, "FORBIDDEN DYN_CROSS!!!!!\n");  	fflush(stderr);	 	exit(0);  	break;s     }	    /* switch.. *//     if (fr_ps->header->dyn_second_stereo[sbgr]) E 	if(min_ch == T4outof[sbgr] && bit_alloc[T4outof[sbgr]][min_sb] != 0)[% 	    bit_alloc[T4[sbgr]][min_sb] = 1;[ }r else if (fr_ps->config == 202) {b/     if (fr_ps->header->dyn_second_stereo[sbgr])sE 	if(min_ch == T3outof[sbgr] && bit_alloc[T3outof[sbgr]][min_sb] != 0)m% 	    bit_alloc[T3[sbgr]][min_sb] = 1;  }* else if (fr_ps->config == 102) {b/     if (fr_ps->header->dyn_second_stereo[sbgr]) E 	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0) % 	    bit_alloc[T2[sbgr]][min_sb] = 1;  }T }b   #ifdef Augmentation_7ch= void choose_dyn_aug (  	frame_params	*fr_ps, , 	    /* in:  fr_ps->header->dyn_cross[sbgr]  	     *	    fr_ps->alloc 	     */ 	int		min_ch,				/* in */x 	int		min_sb,				/* in */r 	int		sbgr, 				/* in */5 	unsigned int	bit_alloc[CHANMAX3][SBLIMIT])	/* out */] {  /*  global parameters)7  *  in:	T2[SBGRS], T3[SBGRS], T4[SBGRS], T2outof[SBGRS]f  */[!     layer *info  = fr_ps->header; +     int dynx_T2 = !dyn_ch (fr_ps, sbgr, 2); +     int dynx_T3 = !dyn_ch (fr_ps, sbgr, 3);++     int dynx_T4 = !dyn_ch (fr_ps, sbgr, 4);[(     int T5T0 = L0, T6T0 = L0, T6T1 = R0;     G     if (info->aug_tc_alloc[sbgr] == 4 || info->aug_tc_alloc[sbgr] == 5)[*     	if (fr_ps->header->dyn_cross_LR == 0) 	    T6T1 = L0;i 	else  	    T6T0 = R0;*L     else if (info->aug_tc_alloc[sbgr] == 6 || info->aug_tc_alloc[sbgr] == 7)         if (info->dyn_cross_LR){ 	    T5T0 = R0;;  
     /* 5/2 */6/     switch (fr_ps->header->aug_dyn_cross[sbgr])e     {      case 0:		 	  break;=     case 1: 6 	  if (min_ch == T6T1 && bit_alloc[T6T1][min_sb] != 0)' 	      bit_alloc[T6[sbgr]][min_sb] = 1;T	 	  break;n     case 2: B 	  if ((min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0) ||S 	      (dynx_T2 && min_ch == T2from[sbgr] && bit_alloc[T2from[sbgr]][min_sb] != 0))r' 	      bit_alloc[T6[sbgr]][min_sb] = 1;{	 	  break;i     case 3: B 	  if ((min_ch == T4[sbgr] && bit_alloc[T4[sbgr]][min_sb] != 0) ||S 	      (dynx_T4 && min_ch == T4from[sbgr] && bit_alloc[T4from[sbgr]][min_sb] != 0)) ' 	      bit_alloc[T6[sbgr]][min_sb] = 1;f	 	  break;[     case 4: > 	  if (min_ch == T5[sbgr] && bit_alloc[T5[sbgr]][min_sb] != 0)' 	      bit_alloc[T6[sbgr]][min_sb] = 1;l	 	  break;s     case 5: 7 	  if (min_ch == T5T0 && bit_alloc[T5T0][min_sb] != 0) n' 	      bit_alloc[T5[sbgr]][min_sb] = 1;T	 	  break;)     case 6: 7 	  if (min_ch == T5T0 && bit_alloc[T5T0][min_sb] != 0) ]' 	      bit_alloc[T5[sbgr]][min_sb] = 1;|7 	  if (min_ch == T6T1 && bit_alloc[T6T1][min_sb] != 0)  ' 	      bit_alloc[T6[sbgr]][min_sb] = 1;T	 	  break;n     case 7: 7 	  if (min_ch == T5T0 && bit_alloc[T5T0][min_sb] != 0)  ' 	      bit_alloc[T5[sbgr]][min_sb] = 1;eB 	  if ((min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0) ||S 	      (dynx_T2 && min_ch == T2from[sbgr] && bit_alloc[T2from[sbgr]][min_sb] != 0)) ' 	      bit_alloc[T6[sbgr]][min_sb] = 1;S	 	  break;      case 8: 7 	  if (min_ch == T5T0 && bit_alloc[T5T0][min_sb] != 0) *' 	      bit_alloc[T5[sbgr]][min_sb] = 1;*B 	  if ((min_ch == T4[sbgr] && bit_alloc[T4[sbgr]][min_sb] != 0) ||S 	      (dynx_T4 && min_ch == T4from[sbgr] && bit_alloc[T4from[sbgr]][min_sb] != 0))g' 	      bit_alloc[T6[sbgr]][min_sb] = 1;n	 	  break;      case 9: 6 	  if (min_ch == T5T0 && bit_alloc[T5T0][min_sb] != 0)' 	      bit_alloc[T5[sbgr]][min_sb] = 1;s6 	  if (min_ch == T6T0 && bit_alloc[T6T0][min_sb] != 0)' 	      bit_alloc[T6[sbgr]][min_sb] = 1;*	 	  break;*    case 10: B 	  if ((min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0) ||S 	      (dynx_T2 && min_ch == T2from[sbgr] && bit_alloc[T2from[sbgr]][min_sb] != 0))i' 	      bit_alloc[T5[sbgr]][min_sb] = 1;		 	  break;     case 11: B 	  if ((min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0) ||S 	      (dynx_T2 && min_ch == T2from[sbgr] && bit_alloc[T2from[sbgr]][min_sb] != 0)) ' 	      bit_alloc[T5[sbgr]][min_sb] = 1; 6 	  if (min_ch == T6T1 && bit_alloc[T6T1][min_sb] != 0)' 	      bit_alloc[T6[sbgr]][min_sb] = 1;e	 	  break;g    case 12: B 	  if ((min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0) ||S 	      (dynx_T2 && min_ch == T2from[sbgr] && bit_alloc[T2from[sbgr]][min_sb] != 0))oE 	      bit_alloc[T5[sbgr]][min_sb] = bit_alloc[T6[sbgr]][min_sb] = 1; 	 	  break;     case 13: B 	  if ((min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0) ||S 	      (dynx_T2 && min_ch == T2from[sbgr] && bit_alloc[T2from[sbgr]][min_sb] != 0))[' 	      bit_alloc[T5[sbgr]][min_sb] = 1;]B 	  if ((min_ch == T4[sbgr] && bit_alloc[T4[sbgr]][min_sb] != 0) ||S 	      (dynx_T4 && min_ch == T4from[sbgr] && bit_alloc[T4from[sbgr]][min_sb] != 0))l' 	      bit_alloc[T6[sbgr]][min_sb] = 1;[	 	  break;s    case 14: B 	  if ((min_ch == T3[sbgr] && bit_alloc[T3[sbgr]][min_sb] != 0) ||S 	      (dynx_T3 && min_ch == T3from[sbgr] && bit_alloc[T3from[sbgr]][min_sb] != 0))_' 	      bit_alloc[T5[sbgr]][min_sb] = 1;T	 	  break;n    case 15: B 	  if ((min_ch == T3[sbgr] && bit_alloc[T3[sbgr]][min_sb] != 0) ||S 	      (dynx_T3 && min_ch == T3from[sbgr] && bit_alloc[T3from[sbgr]][min_sb] != 0))i' 	      bit_alloc[T5[sbgr]][min_sb] = 1;c6 	  if (min_ch == T6T1 && bit_alloc[T6T1][min_sb] != 0)' 	      bit_alloc[T6[sbgr]][min_sb] = 1;s	 	  break;b    case 16: B 	  if ((min_ch == T3[sbgr] && bit_alloc[T3[sbgr]][min_sb] != 0) ||S 	      (dynx_T3 && min_ch == T3from[sbgr] && bit_alloc[T3from[sbgr]][min_sb] != 0))o' 	      bit_alloc[T5[sbgr]][min_sb] = 1;bB 	  if ((min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0) ||S 	      (dynx_T2 && min_ch == T2from[sbgr] && bit_alloc[T2from[sbgr]][min_sb] != 0)) ' 	      bit_alloc[T6[sbgr]][min_sb] = 1;_	 	  break;g    case 17: B 	  if ((min_ch == T3[sbgr] && bit_alloc[T3[sbgr]][min_sb] != 0) ||S 	      (dynx_T3 && min_ch == T3from[sbgr] && bit_alloc[T3from[sbgr]][min_sb] != 0))]' 	      bit_alloc[T5[sbgr]][min_sb] = 1;(B 	  if ((min_ch == T4[sbgr] && bit_alloc[T4[sbgr]][min_sb] != 0) ||S 	      (dynx_T4 && min_ch == T4from[sbgr] && bit_alloc[T4from[sbgr]][min_sb] != 0))b' 	      bit_alloc[T6[sbgr]][min_sb] = 1; 	 	  break;     case 18:=B 	  if ((min_ch == T3[sbgr] && bit_alloc[T3[sbgr]][min_sb] != 0) ||S 	      (dynx_T3 && min_ch == T3from[sbgr] && bit_alloc[T3from[sbgr]][min_sb] != 0))cE 	      bit_alloc[T5[sbgr]][min_sb] = bit_alloc[T6[sbgr]][min_sb] = 1;b	 	  break;a    default: 6 	  fprintf (stderr, "FORBIDDEN AUG_DYN_CROSS!!!!!\n"); 	  fflush (stderr);3 	  exit (1);	 	  break;g     }_ }  #endif    I /************************************************************************s  *  * scfsi_calc_dyn    [  */  * Version 1.0	    94/07/07	Andreas Silzle, IRT1  *B  * Calculating the scale factor select information of one channel &  * without changing the scale factors.  *J  ************************************************************************/   void scfsi_calc_dyn (16 	unsigned int	scalar_dyn[][3][SBLIMIT],   /* in/out */ 	int		ch, 			    /* in */y 	int		sblimit,		    /* in */ b2 	unsigned int	scfsi_dyn[][SBLIMIT]) 	    /* out */ {a     int	    sb;]     $     for (sb = 0; sb < sblimit; sb++)     {=H 	/* If the subbands are coded only with SCF's, they must be accurate. */$ 	/* 1993-02-19 and 1994-03-17 shn */> 	/* 4 patterns are possible: 0: ABC, 1: AAB, 2: AAA, 3: ABB */8 	if ((scalar_dyn[ch][0][sb] != scalar_dyn[ch][1][sb]) &&6 	    (scalar_dyn[ch][1][sb] != scalar_dyn[ch][2][sb])) 	    scfsi_dyn[ch][sb] = 0;t 	else]8 	if ((scalar_dyn[ch][0][sb] == scalar_dyn[ch][1][sb]) &&6 	    (scalar_dyn[ch][1][sb] != scalar_dyn[ch][2][sb])) 	    scfsi_dyn[ch][sb] = 1;  	elsea8 	if ((scalar_dyn[ch][0][sb] == scalar_dyn[ch][1][sb]) &&6 	    (scalar_dyn[ch][1][sb] == scalar_dyn[ch][2][sb])) 	    scfsi_dyn[ch][sb] = 2;  	else  	    scfsi_dyn[ch][sb] = 3;f     }	/* for (sb.. */f }s  I /************************************************************************   *  * scfsi_calc    >  */  * Version 1.0	    94/07/07	Andreas Silzle, IRT   *C  * Calculating the scale factor select information of one channel.    *1  * route: II_transmission_pattern (Layer II only)t  *C  * PURPOSE:For a given subband, determines whether to send 1, 2, ore:  * all 3 of the scalefactors, and fills in the scalefactor!  * select information accordingly   *I  * SEMANTICS:  The subbands and channels are classified based on how mucht@  * the scalefactors changes over its three values (corresponding@  * to the 3 sets of 12 samples per subband).  The classificationE  * will send 1 or 2 scalefactors instead of three if the scalefactorsa;  * do not change much.  The scalefactor select information,0%  * #scfsi#, is filled in accordingly.n  *J  ************************************************************************/   void scfsi_calc (l1 	unsigned int	scalar[][3][SBLIMIT], 	/* in/out */t 	int		ch, 			/* in */_ 	int		sblimit,		/* in */ f* 	unsigned int	scfsi[][SBLIMIT]) 	/* out */ {b     int dscf[2];     int class[2], sb, j;      static int pattern[5][5] = {# 	0x123, 0x122, 0x122, 0x133, 0x123,*# 	0x113, 0x111, 0x111, 0x444, 0x113,A# 	0x111, 0x111, 0x111, 0x333, 0x113,b# 	0x222, 0x222, 0x222, 0x333, 0x123,[( 	0x123, 0x122, 0x122, 0x133, 0x123    };  $     for (sb = 0; sb < sblimit; sb++)     {x3 	dscf[0] = (scalar[ch][0][sb] - scalar[ch][1][sb]);d3 	dscf[1] = (scalar[ch][1][sb] - scalar[ch][2][sb]);f 	for (j=0; j<2; j++) 	{ 	    if (dscf[j] <= -3)1 		class[j] = 0; * 	    else if (dscf[j] > -3 && dscf[j] < 0) 		class[j] = 1;  	    else if (dscf[j] == 0)r 		class[j] = 2; ) 	    else if (dscf[j] > 0 && dscf[j] < 3)0 		class[j] = 3;i
 	    else  		class[j] = 4;| 	}% 	switch (pattern[class[0]][class[1]])f 	{
 	case 0x123 :R 	    scfsi[ch][sb] = 0;  	    break; 
 	case 0x122 :p 	    scfsi[ch][sb] = 3;s+ 	    scalar[ch][2][sb] = scalar[ch][1][sb];  	    break;i
 	case 0x133 :T 	    scfsi[ch][sb] = 3;s+ 	    scalar[ch][1][sb] = scalar[ch][2][sb];= 	    break;k
 	case 0x113 :  	    scfsi[ch][sb] = 1;g+ 	    scalar[ch][1][sb] = scalar[ch][0][sb];  	    break; 
 	case 0x111 :f 	    scfsi[ch][sb] = 2;f? 	    scalar[ch][1][sb] = scalar[ch][2][sb] = scalar[ch][0][sb];1 	    break;i
 	case 0x222 :  	    scfsi[ch][sb] = 2;]? 	    scalar[ch][0][sb] = scalar[ch][2][sb] = scalar[ch][1][sb];c 	    break;b
 	case 0x333 :c 	    scfsi[ch][sb] = 2; ? 	    scalar[ch][0][sb] = scalar[ch][1][sb] = scalar[ch][2][sb];a 	    break; 
 	case 0x444 :b 	    scfsi[ch][sb] = 2;]/ 	    if (scalar[ch][0][sb] > scalar[ch][2][sb])]( 		scalar[ch][0][sb] = scalar[ch][2][sb];? 	    scalar[ch][1][sb] = scalar[ch][2][sb] = scalar[ch][0][sb];c 	}	/* switch */]     }		/* for (sb.. */ }e  I /************************************************************************l  *  * scf_calc    =  *0  * Calculating the scale factor for one channel.  */  * Version 1.0	    94/07/07	Andreas Silzle, IRT   *!  * route: II_scale_factor_calc() =  *D  * PURPOSE:For each subband, calculate the scale factor for each set  * of the 12 subband samples  *E  * SEMANTICS:  Pick the scalefactor #multiple[]# just larger than the=;  * absolute value of the peak subband sample of 12 samples, =  * and store the corresponding scalefactor index in #scalar#.   *<  * Layer II has three sets of 12-subband samples for a given  * subband.b  *J  ************************************************************************/   void scf_calc (x4 	double		sample[][3][SCALE_BLOCK][SBLIMIT], /* in */ 	int		sblimit,		/* in */ 	int		ch,			/* in */+ 	unsigned int	scf[][3][SBLIMIT])	/* out */   {n /* global variables: c  * double multiple[64]    */t     int	    sb, smp, sufr, r;      double  s[SBLIMIT];b        for (sufr=0; sufr<3; sufr++)     {l 	for (sb=0; sb<sblimit; sb++)b7 	    for (smp=1, s[sb] = mod(sample[ch][sufr][0][sb]); l 		    smp<SCALE_BLOCK; smp++) - 		if (mod(sample[ch][sufr][smp][sb]) > s[sb])t- 		    s[sb] = mod(sample[ch][sufr][smp][sb]);t   	for (sb=0; sb<sblimit; sb++) : 	    for (r=SCALE_RANGE-1, scf[ch][sufr][sb]=0; r>=0; r--) 		if (s[sb] < multiple[r])> 		{                       /* <= changed to <, 1992-11-06 shn*/ 		    scf[ch][sufr][sb] = r; 		    break; 		}r     }   /* for (sufr.. */n }   