G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) 0  * ISO 13818-3 MPEG-2 Audio Multichannel Decoder  *:  * $Id: musicout.c 1.11 1996/04/18 05:37:23 rowlands Exp $  *  * $Log: musicout.c $ /  * Revision 1.11  1996/04/18 05:37:23  rowlands %  * Release following Florence meeting   */  * Revision 1.10  1996/02/12 07:13:06  rowlands #  * Release following Munich meeting   *3  * Revision 1.9.1.1  1996/01/20  17:28:45  rowlands B  * Received from Ralf Schwalbe (Telekom FTZ) - includes prediction  *2  * Revision 1.7.1.3  1995/08/14  08:13:37  tenkate0  * ML-LSF added Warner ten Kate 7/8/95 (Philips)  * debugging3  * change "alloc" and "sblimit" into "alloc_ml" and "  * "sblimit_ml" where appropriate.C  * adapt sample-loops to 6 or 12 depending on half or full ML rate.   *3  * Revision 1.7.1.1  1995/07/14  06:12:46  rowlands 6  * Updated dynamic crosstalk from FTZ: revision FTZ_03  *3  * Revision 1.3.3.1  1995/06/16  08:00:46  rowlands )  * Input from Sang Wook Kim (Samsung AIT)   *3  * Revision 1.3.1.1  1995/06/14  04:36:30  rowlands -  * Added support for dematrixing procedure 2.   *H  **********************************************************************/  G /********************************************************************** G  *   date   programmers                comment                        * G  * 2/25/91  Douglas Wong        start of version 1.0 records          * G  * 3/06/91  Douglas Wong        rename setup.h to dedef.h             * G  *                              removed extraneous variables          * G  *                              removed window_samples (now part of   * G  *                              filter_samples)                       * G  * 3/07/91  Davis Pan           changed output file to "codmusic"     * G  * 5/10/91  Vish (PRISM)        Ported to Macintosh and Unix.         * G  *                              Incorporated new "out_fifo()" which   * G  *                              writes out last incomplete buffer.    * G  *                              Incorporated all AIFF routines which  * G  *                              are also compatible with SUN.         * G  *                              Incorporated user interface for       * G  *                              specifying sound file names.          * G  *                              Also incorporated user interface for  * G  *                              writing AIFF compatible sound files.  * G  * 27jun91  dpwe (Aware)        Added musicout and &sample_frames as  * G  *                              args to out_fifo (were glob refs).    * G  *                              Used new 'frame_params' struct.       * G  *                              Clean,simplify, track clipped output  * G  *                              and total bits/frame received.        * G  * 7/10/91  Earle Jennings      changed to floats to FLOAT            * G  *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           * G  *          Don H. Lee,                                               * G  *          Peter W. Farrett                                          * G  *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   * G  *                              newly introduced functions are        * G  *                              buffer_CRC and recover_CRC_error      * G  *                              Additions and revisions are marked    * G  *                              with "dhl" for clarity                * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  ********************************************************************** G  *                                                                    * G  *                                                                    * G  *  MPEG/audio Phase 2 coding/decoding multichannel                   * G  *                                                                    * G  *  Version 1.0                                                       * G  *                                                                    * G  *  7/27/93        Susanne Ritscher,  IRT Munich                      * G  *                                                                    * G  *                  thanks to                                         * G  *                  Ralf Schwalbe,    Telekom FTZ Berlin              * G  *                  Heiko Purnhagen,  Uni Hannover                    * G  *                                                                    * G  *  Version 2.0                                                       * G  *                                                                    * G  *  8/27/93        Susanne Ritscher, IRT Munich                       * G  *                 Channel-Switching is working                       * G  *                                                                    * G  *  Version 2.1                                                       * G  *                                                                    * G  *  9/1/93         Susanne Ritscher,  IRT Munich                      * G  *                 all channels normalized                            * G  *                                                                    * G  *  Version 3.0                                                       * G  *                                                                    * G  *  06/16/94       Ralf Schwalbe, Telekom FTZ Berlin                  * G  *                 all sources and variables adapted due to MPEG-2 -  * G  *                 DIS from March 1994                                * G  *                  - dematrix and denormalize procedure              * G  *                  - new tc - allocation (0-7)                       * G  *                  - some new structures and variables as a basis    * G  *                    for further decoding modes                      * G  **********************************************************************   *								      * G  *  Version 1.0                                                       * G  *                                                                    * G  *  11/04/94       Ralf Schwalbe,  Telekom FTZ Berlin                 * G  *                  - decoding tc-allocation                          * G  *                  - some new subroutines, globale variables and     * G  *                    structures (important to handle the ext. bitst.)* G  *                  - changed all functions to ANSI-C funktion header * ;  *		    - corrected some bugs to decode bitstreams > 512kB*   *								      * G  *  Version 1.1                                                       * G  *                                                                    * G  *  12/07/94       Ralf Schwalbe,  Telekom FTZ Berlin                 * G  *                  - decoding extension bitstream                    * G  *                                                                    * G  *  Version 1.1.1                                                     * G  *                 Ralf Schwalbe, Telekom FTZ Berlin                  * G  *                  - fixed some bugs                                 * G  *                                                                    * G  *  Version 1.2                                                       * G  *                                                                    * G  *  6/21/95       Ralf Schwalbe, Deutsche Telekom FTZ Berlin          * F  *            	    - decoding dynamic crosstalk                      *H  *                  - decoding phantom center                         * G  *                  - decoding MPEG1 compatible part only (stereo)    *oG  *                  - corrected some settings and bugs                *   * 								      *C  *  7/12/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin          * /  *		    - corrected dynamic crosstalk 		      *d;  *		    - 3/2,3/1,3/0,2/1, channel configurations         *.G  *                    are working                                     *e  *		  						      *r@  * 10/31/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin	      *6  *		    - decoding of LFE-channel is working  	      *2  *		    - corrected any settings and bugs		      *;  *		    - corrected table-switch for channel mode < 3/2   *-4  *		      and tc-allocation / dyn-crosstalk		      *;  *		    - still a problem with compl. bitstream 18/19     *UB  * 01/12/96	  Ralf Schwalbe, Deutsche Telekom TZ Darmstadt	      */  *		    - decoder prediction installed		      *t;  *		    - problem with compl. bitstream 19 solved,        *1C  * 03/27/96	  Ralf Schwalbe, Deutsche Telekom TZ Darmstadt        *e;  *		    - Multilingual mode adapted for max. 7 channels   **X  *                                                                    *				      *		    G  *  Version 2.0                                                       * G  *                                                                    * G  * 01/28/97       Frans de Bont, Philips Sound & Vision, Eindhoven    * ;  *		    - simultaneous use of tc allocation and dynamic   *s:  *		      crosstalk working for all configurations	      *;  *		    - prediction working for all configurations	      * &  *		    - layer 1 MC working			      *;  *		    - variable bit rate and extension bitstreams      * ;  *		    - fully compliant to 13818-3.2                    *tX  *                                                                    *				      *		    H  **********************************************************************/G /**********************************************************************oG  *                                                                    *hG  *  06/06/95       Yeon Bae Thomas Kim,  Samsung AIT                  *fG  *                 ancillary data is working                          *a  *								      **G  *  06/06/95       Sang Wook Kim,  Samsung AIT                        **G  *                 corrected some bugs                                **  *								      *rH  **********************************************************************/   #include        "common.h" #include        "decoder.h"   E /********************************************************************  * B *        This part contains the MPEG I / II decoder for Layers II. * B *        Core of the Layer II decoder.  Default layer is Layer II. */F *********************************************************************/  2 /* Global variable definitions for "musicout.c" */   char 		   *programName;o int 		   Frame_Bits,Bitrate; double		   S_freq;   /* Implementations */e  : main (int argc, char **argv)  /* R.S. 7 channels for ML */ {/" typedef long PCM[7][3][SBLIMIT];		 	PCM  *pcm_sample;8 	PCM  *pcm_sample_ml;			/* 10/03/1995 JMZ Multilingual*/) typedef unsigned int SAM[7][3][SBLIMIT];	  	SAM  *sample;4 	SAM  *sample_ml;			/* 10/03/1995 JMZ Multilingual*/O typedef double FRA[7][SBLIMIT][3][12];		/* 7.10.93 R.S. mem - alloc for DOS */   	FRA  *fraction;6 	FRA  *fraction_ml;			/*JMZ 09/03/1995 Multilingual */L typedef double FRA_HELP[12][7][3][SBLIMIT];	/* 10/03/1995 JMZ Multilingual*/ 	FRA_HELP *fraction_help;v 	FRA_HELP *fraction_help_ml;, typedef double FRA_BUF[2][8][36+PREDDEL];    	FRA_BUF  *pred_buf;  ! typedef double VE[7][HAN_SIZE];		  	VE  *w;   	frame_params      fr_ps;  	layer 		  info;) 	Bit_stream        bs_mpg, bs_ext, bs_mc; # 	FILE              *musicout, *lfe;eC 	FILE              *musicout_ml;			/* 10/03/1995 JMZ Multilingual*/ ! 	unsigned long     sample_frames; $ 	unsigned long     sample_frames_ml;9 	int		  i,jj, j, k, ii, stereo, done=FALSE, clip, sync,f; 3 	int               error_protection, crc_check = 1; + 	int		  crc_error_count, total_error_count;*< 	int               crc_error_count_mc, total_error_count_mc; #ifdef Augmentation_7ch > 	int               crc_error_count_aug, total_error_count_aug; #endif$ 	unsigned int      old_crc, new_crc;. 	unsigned int      I_bit_alloc[3][7][SBLIMIT];< 	unsigned int      bit_alloc[7][SBLIMIT], scfsi[7][SBLIMIT],! 			  scale_index[7][3][SBLIMIT];  B 	unsigned int      bit_alloc_ml[7][SBLIMIT], scfsi_ml[7][SBLIMIT],E 			  scale_index_ml[7][3][SBLIMIT]; /* 09/03/1995 JMZ Multilingual */70 	unsigned long     bitsPerSlot, samplesPerFrame;! 	IFF_AIFF          pcm_aiff_data; 1 	char 	      	  encoded_file_name[MAX_NAME_SIZE]; B 	char 	      	  encoded_file_name1[MAX_NAME_SIZE]; /* 8/11/92.sr*/4 	char              decoded_file_name[MAX_NAME_SIZE];W 	char              decoded_file_name_ml[MAX_NAME_SIZE];/* 10/03/1995 JMZ Multilingual*/ + 	char		  ext_bitstream_name[MAX_NAME_SIZE]; # 	char		  frame_name[MAX_NAME_SIZE]; & 	char		  lfe_file_name[MAX_NAME_SIZE]; 	char              t[50];  	int               need_aiff; # 	int		  l, m, print_out = 0, ml =0;  	int		  ch_start,lfe_init = 1;Z 	int		  tca_log = 0, dynx_log = 0, bits_log = 0, rate_log = 0, scfsi_log = 0, any_log = 0; 	short int	  lfe_tmp[12]; R 	unsigned int	  sym_sample_ml[12][7][3][SBLIMIT];	/* 18/03/1996 FDB Multilingual*/ 	int		  part, layer_I_frames; 0 	int		  mpeg = 2; /* R.S. mpeg default for mc */! 	int		  channels=2, mc_channel=0;  	unsigned long	  frameNum = 0L;/ 	unsigned long	  frameMod = 1L;R 	unsigned long	  frameBits; O /*****************************************************************************/  	int hi, hu, ho; 	FILE *fp1;  	FILE *fp2;  	FILE *fp3;  	FILE *fp4;  	FILE *fp5;  	FILE *fp6; P /******************************************************************************/   #ifdef  MACINTOSH ) 	console_options.nrows = MAC_WINDOW_SIZE;e 	argc = ccommand(&argv); #endif; 	/* Most large variables are declared dynamically to ensured* 	   compatibility with smaller machines */  @ 	pcm_sample = (PCM *) mem_alloc((long) sizeof(PCM), "PCM Samp");C 	pcm_sample_ml = (PCM *) mem_alloc((long) sizeof(PCM), "PCM Samp"); > 	sample 	   = (SAM *) mem_alloc((long) sizeof(SAM), "Sample");? 	sample_ml   = (SAM *) mem_alloc((long) sizeof(SAM), "Sample"); L 	fraction   = (FRA *) mem_alloc((long) sizeof(FRA), "fraction");  /* R.S. */O 	fraction_ml   = (FRA *) mem_alloc((long) sizeof(FRA), "fraction");  /* R.S. */	M 	fraction_help = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction"); P 	fraction_help_ml = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction");G 	pred_buf  = (FRA_BUF *) mem_alloc((long) sizeof(FRA_BUF), "pred_buf");* 				. 	w = (VE *) mem_alloc((long) sizeof(VE), "w");   	bs_mpg.header_size = 0;F 	bs_mpg.bits = (unsigned char *) mem_alloc ((long) 13824, "MPG Bits"); 	bs_ext.header_size = 0;F 	bs_ext.bits = (unsigned char *) mem_alloc ((long) 16376, "EXT Bits");E 	bs_mc.bits  = (unsigned char *) mem_alloc ((long) 30208, "MC Bits");    	fr_ps.header = &info; 	fr_ps.bs_mpg = &bs_mpg; 	fr_ps.bs_ext = &bs_ext; 	fr_ps.bs_mc  = &bs_mc; 9 	fr_ps.tab_num = -1;                /* no table loaded */ < 	fr_ps.tab_num_mc = -1;                /* no table loaded */ 	fr_ps.tab_num_ml = -1;i 	fr_ps.alloc = NULL; 	fr_ps.alloc_mc = NULL;o 	fr_ps.alloc_ml = NULL;    	info.mode_ext = 0;* 	info.version = MPEG_AUDIO_ID; 	info.bitrate_index = 0;F 	info.lfe = 0;	    		   /* no low frequency effect channel present! */  ! 	info.no_of_multi_lingual_ch = 0;l 	info.multi_lingual_fs = 0;n 	info.multi_lingual_layer = 0;  ! 	info.ext_bit_stream_present = 0;  	info.ext_length = 0; + 	info.n_ad_bytes = 0;    /* 7.12.94 R.S. */    	info.lfe = 0;  = 	for (i=0;i<HAN_SIZE;i++) for (j=0;j<5;j++) (*w)[j][i] = 0.0;    	program_information();  	programName = argv[0];  	if(argc==1)0 	{        /* no command line args -> interact */ 	   do 	   {h4 		  printf ("Enter encoded file name <required>: "); 		  gets (encoded_file_name); G 		  f = strlen(encoded_file_name)-4;	  /*cut off extension.8/11/92.sr*/ * 		  if (encoded_file_name[0] == NULL_CHAR)1 			 printf ("Encoded file name is required. \n");*0 	   } while (encoded_file_name[0] == NULL_CHAR);  B 	   printf (">>> Encoded file name is: %s \n", encoded_file_name);B 	   strcpy(encoded_file_name1, encoded_file_name);  /*8/11/92.sr*/S 	   strcpy(&encoded_file_name1[f], DFLT_OPEXT_DEC);	  /*.dec-extension.8/11/92.sr*/ G 	   printf ("Enter MPEG decoded file name <%s>: ", encoded_file_name1);  	   gets (decoded_file_name);9* 	   if (decoded_file_name[0] == NULL_CHAR)0 		strcpy(decoded_file_name, encoded_file_name1);  ! /* JMZ 10/03/1995 Multilingual */   G 	   printf (">>> MPEG decoded file name is: %s \n", decoded_file_name);l  1            /* encoded_file_name1 only for help */r2 	   strcpy(encoded_file_name1, encoded_file_name);@ 	   strcpy(&encoded_file_name1[f], DFLT_IPEXT_EXT);	  /* .ext */V 	   printf (">>> Enter MPEG 2 decoded extension filename <%s>: ", encoded_file_name1); 	   gets(ext_bitstream_name); , 	   if( ext_bitstream_name[0] == NULL_CHAR )1 		strcpy(ext_bitstream_name, encoded_file_name1); M 	   printf("Extension bitstream <%s> will be decoded \n",ext_bitstream_name); O 	   /* 6/21/95 Ralf Schwalbe: stand a chance to decode MPEG1 compatible part */ L 	   if ((open_bit_stream_r (&bs_ext, ext_bitstream_name, BUFFER_SIZE)) == 0) 	   { 	 F 		printf("No extension bitstream <%s> present \n",ext_bitstream_name);C 		printf("Do you want to decode an MPEG 2 bitstream ? (<y>/n) : ");u
 		gets(t);! 	   	if (*t == 'N' || *t == 'n')   		{t 			mpeg = 1;= 			printf("An MPEG-1 Layer II bitstream will be decoded \n");a 		}n	 	   	else	 		{  			mpeg = 2;= 			printf("An MPEG-2 Layer II bitstream will be decoded \n");x 		}o 	   } N 	   printf("Do you wish to write an AIFF compatible sound file ? (<y>/n) : "); 	   gets(t);2 	   if (*t == 'N' || *t == 'n') need_aiff = FALSE;1 	   else                        need_aiff = TRUE;* 	   if (need_aiff)@ 		printf(">>> An AIFF compatible sound file will be written\n");G 	   else printf(">>> A non-headered PCM sound file will be written\n");  	   L 	   printf("Do you want to print out all decoding information ? (y/<n>) :"); 	   gets(t);/ 	   if( *t == 'y' || *t == 'Y' ) print_out = 1;g  	   else		      		print_out = 0;   	   printf( F 		  "Do you wish to exit (last chance before decoding) ? (y/<n>) : "); 	   gets(t);( 	   if (*t == 'y' || *t == 'Y') exit(0); 	}  : 	else	/************** interpret CL Args *****************/! 		/* default: -write an AIFF file*0 	 		    -print encoded bitstream information  */
 	{         	   int i=0, err=0;*    #ifdef UNIX /* default values */ 	   need_aiff = TRUE; O 	   print_out = 0;   /* 10/31/95 Ralf Schwalbe: set print_out off in CL Args */ 
 	   mpeg = 2;e #elseI 	   need_aiff = FALSE; #endif% 	   encoded_file_name[0] = NULL_CHAR;*% 	   decoded_file_name[0] = NULL_CHAR;*& 	   ext_bitstream_name[0] = NULL_CHAR;   	   while(++i<argc && err == 0)r 	   {o# 		  char c, *token, *arg, *nextArg;e 		  int  argUsed;I   		  token = argv[i]; 		  if(*token++ == '-')) 		  {S' 			 if(i+1 < argc) nextArg = argv[i+1];P  			 else           nextArg = ""; 			 argUsed = 0; 			 while((c = *token++) != 0) 			 {n1 				if(*token /* NumericQ(token) */) arg = token; 3 				else                             arg = nextArg; 
 				switch(c)  				{ $ 				   case 'a':  need_aiff = FALSE; 					      break;o   				   case 'b':  bits_log = 1;F 					      break;	 					    			 				   case 'd':  dynx_log = 1;e 					      break;[ 					    			, 				   case 'h':  bs_mpg.header_size = 2304;% 					      bs_ext.header_size = 2304;; 					      break;A    				   case 'i':  print_out = 1; 					      break;e 					    			 				   case 'm':  mpeg = 1;  					      break;f #ifdef Augmentation_7ch  				   case 'n':  mpeg = 3;_ 					      break;  #endif 				   case 'r':  rate_log = 1;  					      break;m 					    			  				   case 's':  scfsi_log = 1; 					      break;r 					    			 				   case 't':  tca_log = 1; 					      break;  					    			@ 				   default:   fprintf(stderr,"%s: unrecognized option %c\n", 							  programName, c);r 					      err = 1;r 					      break;  				}  				if(argUsed)m 				{l: 					if(arg == token) token = ""; /* no more from token */& 					else  ++i; /* skip arg we used */ 					arg = ""; argUsed = 0;  				}d 			 }e 		  }  		  else 		  { - 		     if (encoded_file_name[0] == NULL_CHAR)  		     {' 			strcpy (encoded_file_name, argv[i]);a" 			f = strlen (encoded_file_name);2 			strcpy (&encoded_file_name[f], DFLT_IPEXT_MPG);2 			strcpy (ext_bitstream_name, encoded_file_name);3 			strcpy (&ext_bitstream_name[f], DFLT_IPEXT_EXT);r 		     }2 		     else if (decoded_file_name[0] == NULL_CHAR) 		     {' 			strcpy (decoded_file_name, argv[i]);c" 			f = strlen (decoded_file_name);2 			strcpy (&decoded_file_name[f], DFLT_OPEXT_DEC); 		     } 		     else_ 		     {A 			fprintf (stderr, "%s: excess arg %s\n", programName, argv[i]);J 			err = 1;a 		     } 		  }t        } /* end while argc */   D        if (bits_log || dynx_log || rate_log || scfsi_log || tca_log) 	  any_log = 1;     4        if (err || encoded_file_name[0] == NULL_CHAR)(           usage ();  /* never returns */  O        if ((open_bit_stream_r (&bs_ext, ext_bitstream_name, BUFFER_SIZE)) == 0)s        {G 		printf("No extension bitstream <%s> present \n", ext_bitstream_name);m$ 		ext_bitstream_name[0] = NULL_CHAR;        }        i-        if (decoded_file_name[0] == NULL_CHAR)         {& 	  f = strlen (encoded_file_name) - 4;1 	  strcpy (decoded_file_name, encoded_file_name); 2 	  strcpy (&decoded_file_name[f], DFLT_OPEXT_DEC);        }       }  /* else arg-line end */  %     /* JMZ 10/03/1995 Multilingual */*4     strcpy(decoded_file_name_ml, decoded_file_name);0     strcat(decoded_file_name_ml, DFLT_OPEXT_ML);  . 	/* report results of dialog / command line */5     printf("Input file = '%s' \nOutput file = '%s' ",S+ 		   encoded_file_name, decoded_file_name);e8     if (mpeg >= 2 && ext_bitstream_name[0] != NULL_CHAR):     	printf("Ext_bitstream = '%s'\n", ext_bitstream_name);     if(mpeg == 1) C 	   	printf(">>>\nA MPEG 1 Layer-1/2 bitstream will be decoded\n");; 	   elseB 		printf(">>>\nA MPEG 2 Layer-1/2 bitstream will be decoded\n");   	   A     if(need_aiff) printf("Output file written in AIFF format\n");(  =     if ((musicout = fopen(decoded_file_name, "w+b")) == NULL)F     {eF 	   fprintf (stderr, "Could not create \"%s\".\n", decoded_file_name);
 	   exit (1);c     } I     if (open_bit_stream_r (&bs_mpg, encoded_file_name, BUFFER_SIZE) == 0)l     {nA 	fprintf (stderr, "Could not open \"%s\".\n", encoded_file_name);)
 	exit (1);     }i       if (need_aiff)/ 	  if (aiff_seek_to_sound_data(musicout) == -1)  	  {E 		  fprintf (stderr, "Could not seek to PCM sound data in \"%s\".\n",, 				 decoded_file_name);
 		  exit (1);p 	   }=       sample_frames = 0;     sample_frames_ml = 0;"1     total_error_count = total_error_count_mc = 0;n #ifdef Augmentation_7chn     total_error_count_aug = 0; #endif       while (!end_bs (&bs_mpg)))     { F     /****************************************************************/F     /*                                                              */F     /*                  START OF FRAME LOOP                         */F     /*                                                              */F     /****************************************************************/  # 	   sync = seek_sync_mpg (&bs_mpg);f 	   frameBits = bs_mpg.totbits;  	   if (!sync) 	   {r@ 		  printf("\nFrame cannot be located, end of input stream \n"); 		  done = TRUE;& 		  /* finally write out the buffer */P 		  out_fifo (*pcm_sample, 3, &fr_ps, done, musicout, &sample_frames, channels);R 		  out_fifo_ml (*pcm_sample_ml, 3, &fr_ps, done, musicout_ml, &sample_frames_ml);
 		  break; 	   }*  ! 	   info.lfe = 0;  		/* R.S. ! */i" 	   decode_info (&bs_mpg, &fr_ps); 	   hdr_to_frps (&fr_ps);    	   stereo = fr_ps.stereo;- 	   error_protection = info.error_protection;f 	   crc_error_count = 0;L 	   if (frameNum == 0) WriteHdr (&fr_ps, stdout);  /* printout layer/mode */  ! 	   if (frameNum % frameMod == 0)n 	   {i: 		fprintf(stderr, "{%4lu}\r", frameNum++); fflush(stderr);1 		if (frameNum / frameMod >= 100) frameMod *= 10;  	   }_ 	   else
 		frameNum++;>  % 	   Frame_Bits = 144*Bitrate/S_freq; l 	   if(info.padding)6 		Frame_Bits++;    /* R.Schwalbe add a padding byte */= 	   Frame_Bits*=8;	 /* R.Schwalbe to get bits per frame *8 */t8 	   if (error_protection) buffer_CRC(&bs_mpg, &old_crc);
             0            /* 7/8/95 added message WtK 7/8/95 */ 	   if (info.lay == 3) 	   {[R 	     fprintf (stderr, "\nLayer = %d, not supported.\nexit.\n\n",info.lay); break; 	     exit (1);* 	   }  	   % 	   bs_mc.totbits = bs_mc.curpos = 0;\   	   if (info.lay == 1) 	   {  	      if (mpeg > 1) 		 layer_I_frames = 3; 	      elsec 	      	 layer_I_frames = 1;  4 	      for (part = 0; part < layer_I_frames; part++) 	      { 		 bitsPerSlot = 32; 		 samplesPerFrame = 384;e 		 ch_start = 0; 		 channels = stereo;1   		 if (part > 0) 		 {% 		    sync = seek_sync_mpg (&bs_mpg); ! 		    frameBits = bs_mpg.totbits;e 		    if (!sync) 		    {)T 			   fprintf (stderr, "2nd or 3th Frame cannot be located, end of input stream\n"); 			   exit (1);  		    }   $ 		    decode_info (&bs_mpg, &fr_ps); 		    hdr_to_frps (&fr_ps);_ 	  		    stereo = fr_ps.stereo;/ 		    error_protection = info.error_protection;e 		    crc_error_count = 0;  & 		    Frame_Bits = 12*Bitrate/S_freq;  		    if (info.padding)E8 			 Frame_Bits++;    /* R.Schwalbe add a padding byte */B 		    Frame_Bits *=32;	 /* R.Schwalbe to get bits per frame *32 */ 		    if (error_protection) ( 		       buffer_CRC (&bs_mpg, &old_crc);
           + 		    /* 7/8/95 added message WtK 7/8/95 */e 		    if (info.lay != 1) 		    {"V 		      fprintf (stderr, "Change of Layer = %d, not supported.\nexit.\n\n", info.lay); 		      exit (1);= 		    }d 		 }  D 		 I_decode_bitalloc (&bs_mpg, &fr_ps, I_bit_alloc[part], bits_log);U 		 I_decode_scale (&bs_mpg, &fr_ps, I_bit_alloc[part], scale_index, part, scfsi_log);i   		 if (error_protection) 		 {4 			I_CRC_calc (&fr_ps, I_bit_alloc[part], &new_crc); 			if (new_crc != old_crc) 			{/ 			   printf(" \n ERROR in LAYER 1 - CRC! \n");= 			   crc_error_count++; 			   total_error_count++;6 			   recover_CRC_error (*pcm_sample, crc_error_count,2 					 &fr_ps, musicout, &sample_frames, channels); 			} 			else  			   crc_error_count = 0; 		 }   		 clip = 0;   		 for (i=0;i<12;i++)  		 {C 			I_buffer_sample (&bs_mpg, &fr_ps, (*sample), I_bit_alloc[part]);i
 if (!any_log)t {mS 			I_dequantize_sample ((*sample), part, I_bit_alloc[part], *fraction, &fr_ps, &i);/C 			I_denormalize_sample (*fraction, scale_index, part, &fr_ps, &i);l }  		 }   /* end of for loop */   		 if (mpeg > 1) 		 {. 		    while (bs_mpg.curpos < bs_mpg.totbits-1)D 		       bs_mc.bits[bs_mc.totbits++] = bs_mpg.bits[bs_mpg.curpos++];   		    if (part == 0) 		    {;$ 		       mc_header (&bs_mc, &fr_ps);! 		       mc_hdr_to_frps (&fr_ps);n 		    }   4 		    bs_mc.totbits -= fr_ps.header->n_ad_bytes * 8; 		 } 	      } 	      if (mpeg > 1) 	      {, 		 if (fr_ps.header->ext_bit_stream_present) 		 {- 		    sync = seek_sync_ext (&bs_ext, &fr_ps); " 		    frameBits += bs_ext.totbits; 		    if (!sync) 		    {	U 		       fprintf(stderr, "Extension frame cannot be located, end of input stream\n");a 		       exit (1); 		    }   , 		    while (bs_ext.curpos < bs_ext.totbits)D 		       bs_mc.bits[bs_mc.totbits++] = bs_ext.bits[bs_ext.curpos++]; 		 }   		 for (i=0; i < channels; i++)c! 		    for (j=0; j < SBLIMIT; j++);& 		       if (I_bit_alloc[0][i][j] > 0)3 		          bit_alloc[i][j] = I_bit_alloc[0][i][j]; + 		       else if (I_bit_alloc[1][i][j] > 0)c3 		          bit_alloc[i][j] = I_bit_alloc[1][i][j];e+ 		       else if (I_bit_alloc[2][i][j] > 0)	3 		          bit_alloc[i][j] = I_bit_alloc[2][i][j];=
 		       else   		          bit_alloc[i][j] = 0; 	      } 	   }  	   else if (info.lay == 2 ) 	   {	 	      layer_I_frames = 3; 	      bitsPerSlot = 8;  	      samplesPerFrame = 1152; 	      ch_start = 0; 	      channels = stereo;	A 	      II_decode_bitalloc (&bs_mpg, &fr_ps, bit_alloc, bits_log); i 	      II_decode_scale (&bs_mpg, &fr_ps, scfsi, bit_alloc, scale_index, &ch_start, &channels, scfsi_log);i   	      if (error_protection) 	      {3 		 II_CRC_calc(&fr_ps, bit_alloc, scfsi, &new_crc);  		 if (new_crc != old_crc) 		 {/ 		    printf(" \n ERROR in LAYER 2 - CRC! \n");_ 		    crc_error_count++; 		    total_error_count++;6 		    recover_CRC_error (*pcm_sample, crc_error_count,7 				       &fr_ps, musicout, &sample_frames, channels);  		 } 		 else crc_error_count = 0; 	      }   	      clip = 0;   	      for (i=0;i<12;i++)U 	      {< 		 II_buffer_sample (&bs_mpg, &fr_ps, (*sample), bit_alloc);
 if (!any_log)l {aF 		 II_dequantize_sample ((*sample), bit_alloc, *fraction, &fr_ps, &i);D 		 II_denormalize_sample (*fraction, scale_index, &fr_ps, i>>2, &i); }e  	      }   /* end of for loop */   	      if (mpeg > 1) 	      {) 		 while (bs_mpg.curpos < bs_mpg.totbits) A 		    bs_mc.bits[bs_mc.totbits++] = bs_mpg.bits[bs_mpg.curpos++];i   		 mc_header (&bs_mc, &fr_ps); 		 mc_hdr_to_frps (&fr_ps);)  1 		 bs_mc.totbits -= fr_ps.header->n_ad_bytes * 8;_  , 		 if (fr_ps.header->ext_bit_stream_present) 		 {- 		    sync = seek_sync_ext (&bs_ext, &fr_ps); " 		    frameBits += bs_ext.totbits; 		    if (!sync) 		    {UU 		       fprintf(stderr, "Extension frame cannot be located, end of input stream\n");  		       exit (1); 		    }a  , 		    while (bs_ext.curpos < bs_ext.totbits)D 		       bs_mc.bits[bs_mc.totbits++] = bs_ext.bits[bs_ext.curpos++]; 		 } 	      } 	   }a  @ 	   /**********************************************************/5 	   /*     	multichannel - decoding    	           */d@ 	   /*             7.07.93 Susanne Ritscher                   */@ 	   /*            13.10.93 Ralf Schwalbe                      */, 	   /*	       30.05.94 Ralf Schwalbe			   */@ 	   /**********************************************************/   	   if (rate_log)bb 	     printf ("frame: %5d bitrate: %8.3f kbps\n", frameNum, frameBits * S_freq / samplesPerFrame); 	   else if (mpeg >= 2)n 	   {	F 	     if ( (frameNum==1) && (fr_ps.header->no_of_multi_lingual_ch>0) ) 	     { ' 	       /*frameNum==1 NOT frameNum==0*/t3 	       if (fr_ps.header->no_of_multi_lingual_ch>7)(	 	       {ei 		 printf("\n\n***Warning. There are %d multilingual channels.\n", fr_ps.header->no_of_multi_lingual_ch); M 		 printf    ("            This decoder supports only upto 7 channels.\n\n");F	 	       }=e 	       printf("There are %d multilingual channels, coded at ",fr_ps.header->no_of_multi_lingual_ch); S 	       if (fr_ps.header->multi_lingual_fs==0) printf("full"); else printf("half");tY 	       printf(" sampling rate.\n They are outputted in \"%s\".\n",decoded_file_name_ml); G 	       if ((musicout_ml = fopen(decoded_file_name_ml, "w+b")) == NULL) 	 	       {rX 		 fprintf (stderr, "***Error. Could not create \"%s\".\nExit\n", decoded_file_name_ml); 		 exit (1);	 	       }l 	       if(need_aiff) 	 	       { 8 		 printf("Multilingual file written in AIFF format\n");3 		 if (aiff_seek_to_sound_data (musicout_ml) == -1)  		 {J 		    fprintf (stderr, "Could not seek to ML PCM sound data in \"%s\".\n", 			    decoded_file_name_ml);  		    exit (1);  		 }  	 	       }  	     }   $ 	     mc_channel = fr_ps.mc_channel; 	     crc_error_count_mc = 0;*I 	     buffer_CRC (&bs_mc, &old_crc);   /* read CRC - check from header */tC 	     mc_composite_status_info (&bs_mc, &fr_ps, tca_log, dynx_log);, 	      	     if (frameNum == 1) e 	   	if (info.lfe)P 		    printf ("mc-channel=%d, MPEG2-ext-length=%d kbit/s lfe-channel present\n",U 		    		mc_channel, (int) (info.ext_length * s_freq[info.sampling_frequency] / 144));t  		elsep< 		    printf ("mc-channel=%d, MPEG2-ext-length=%d kbit/s\n",U 		    		mc_channel, (int) (info.ext_length * s_freq[info.sampling_frequency] / 144));o  J 	     /* Achtung: fr_ps.jsbound = 27; wird in Abhngikeit von fs gesetzt*/ 	     ch_start = stereo;% 	     channels = stereo + mc_channel;/  $ 	     /* decoding bitallocation's */ 	   X 	     II_decode_bitalloc_mc (&bs_mc, &fr_ps, bit_alloc, &ch_start, &channels, bits_log);g 	     II_decode_scale (&bs_mc, &fr_ps, scfsi, bit_alloc, scale_index, &ch_start, &channels, scfsi_log);B  & 	     /* mandatory CRC check is set */ 	     if (crc_check) 	     {aJ 		mc_error_check (&fr_ps, bit_alloc, scfsi, &new_crc, ch_start, channels); 		if (new_crc != old_crc)t 		{n 		   crc_error_count_mc++; 		   total_error_count_mc++;# 		   for (i = 0; i < SBLIMIT; i ++)/0 		      for (ii = ch_start; ii < channels; ++ii) 			 bit_alloc[ii][i] = 0;uC 		   printf ("\nERROR in MC-CRC -> mc frame can't be decoded !\n");  		}  		else 		   crc_error_count_mc = 0; 	     }  /* endif crc_check */   	     clip = 0;) 	     for (i = 0; i < 12; i++) 	     { T 		II_buffer_sample_mc (&bs_mc, &fr_ps, (*sample), bit_alloc, ch_start, channels, i);
 if (!any_log)P {l\ 		II_dequantize_sample_mc ((*sample), bit_alloc, *fraction, &fr_ps, ch_start, channels, &i);Z 		II_denormalize_sample_mc (*fraction, scale_index, &fr_ps, i>>2, ch_start, channels, &i); }f 	     }   & 	     /* 10/31/95 Ralf Schwalbe LFE */ 	     if( info.lfe ) t 	     {  		if(lfe_init) 		{	( 		   f = strlen (encoded_file_name) - 4;/ 		   strcpy (lfe_file_name, encoded_file_name);)0 		   strcpy (&lfe_file_name[f], DFLT_OPEXT_LFE);6 		   if ((lfe = fopen (lfe_file_name, "w+b")) == NULL) 		   {F 		      fprintf (stderr, "Could not create \"%s\".\n",lfe_file_name ); 		      exit (1);/ 		   } 		   if (need_aiff)t 		   {5 		      printf ("LFE file written in AIFF format\n");m0 		      if (aiff_seek_to_sound_data (lfe) == -1)	 		      {&I 			 fprintf (stderr, "Could not seek to LFE PCM sound data in \"%s\".\n",e 				 lfe_file_name);
 			 exit (1);  		      }  t 		   }	, 		}n) 		lfe_init = 0; /* R.S. only one time */	" 		II_lfe_calc(&fr_ps);   	     }	G /*********************************************************************/ . /* JMZ 09/03/1995 Multilingual , WtK 7/8/95 */  ) 	     if (info.no_of_multi_lingual_ch>0) o 	     {	9 		/* SWKim060695 add the condion with 32, 44.1kHz case */a# 		if (info.sampling_frequency == 1)c 		   fr_ps.jsbound = 27; 		else 		   fr_ps.jsbound = 30;  " 		m = info.no_of_multi_lingual_ch;  ; 		II_decode_bitalloc_ml (&bs_mc, &fr_ps, bit_alloc_ml, &m); R 		II_decode_scale_ml (&bs_mc, &fr_ps, scfsi_ml, bit_alloc_ml, scale_index_ml, &m);     		   clip = 0;^ 		   for (i=0; i< ( (info.multi_lingual_fs==0) ? 12 : 6 ); i++) /* ngr : n_of_granules loop */ 		   {M 		      II_buffer_sample_ml (&bs_mc, &fr_ps, (*sample_ml), bit_alloc_ml, &m);p
 if (!any_log)t {l[ 		      II_dequantize_sample_ml ((*sample_ml), bit_alloc_ml, *fraction_ml, &fr_ps, &m, &i);rG 		      II_denormalize_sample_ml (*fraction_ml, scale_index_ml, &fr_ps,	E 					      ( (info.multi_lingual_fs==0) ? (i>>2) : (i>>1) ), &m, &i);. }b9 		      for (k = 0; k < info.no_of_multi_lingual_ch; k++)  			 for (ii = 0; ii < 3; ii++) 			    for (j = 0; j < 32; j++)d> 			       sym_sample_ml[i][k][ii][j] = (*sample_ml)[k][ii][j]; 		   } 	     }   ! /* JMZ 09/03/1995 Multilingual */ G /*********************************************************************/    #ifdef Augmentation_7chx 	     if (mpeg == 3)T 	       if (stereo != 2 || fr_ps.header->surround != 2 || fr_ps.header->center == 0)	 	       {  		 /* no 3/2 mode */: 		 printf ("WARNING: Stream does not contain 5/2 info\n");< 		 printf ("         Continue decoding of MPEG2 MC part\n"); 		 mpeg = 2;	 	       }.   	     if (mpeg == 3) 	     {	  	       crc_error_count_aug = 0;I 	       mc_aug_composite_status_info (&bs_mc, &fr_ps, tca_log, dynx_log);	  K 	       buffer_CRC (&bs_mc, &old_crc);   /* read CRC - check from header */o 	       L 	       /* Achtung: fr_ps.jsbound = 27; wird in Abhngikeit von fs gesetzt*/ 	       ch_start = 5;> 	       channels = 7;l  & 	       /* decoding bitallocation's */ 	     [ 	       II_decode_bitalloc_aug (&bs_mc, &fr_ps, bit_alloc, &ch_start, &channels, bits_log); i 	       II_decode_scale (&bs_mc, &fr_ps, scfsi, bit_alloc, scale_index, &ch_start, &channels, scfsi_log);   ( 	       /* mandatory CRC check is set */ 	       if (crc_check)	 	       {,> 		     mc_aug_error_check(&fr_ps, bit_alloc, scfsi, &new_crc); 		     if (new_crc != old_crc) 		     { 			     crc_error_count_aug++;  			     total_error_count_aug++;& 			     for( i = 0; i < SBLIMIT; i ++)0 				     for(ii = ch_start; ii < channels; ++ii) 					     bit_alloc[ii][i] = 0;n  K 			     printf("ERROR in MC-AUG-CRC -> mc aug frame can't be decoded !\n");r 		     } 		     elser  			     crc_error_count_aug = 0;  	       }  /* endif crc_check */   		       clip = 0; 		       for (i=0;i<12;i++) 
 		       {G 			     II_buffer_sample_aug (&bs_mc, &fr_ps, (*sample), bit_alloc, i); 
 if (!any_log)e {bO 			     II_dequantize_sample_aug ((*sample), bit_alloc, *fraction, &fr_ps, &i);rM 			     II_denormalize_sample_aug (*fraction, scale_index, &fr_ps, i>>2, &i);  }2 			} 	     }   /* endif mpeg == 3 */o #endif    	     if (info.mc_prediction_on) 		for (k=0; k<2; k++)s 		   for (ii=0; ii<8; ii++)  		   {! 		      for (j=0; j<PREDDEL; j++)r5 			 (*pred_buf)[k][ii][j] = (*pred_buf)[k][ii][j+36];o 		      for (j =0; j <3; j++)t 			 for (jj=0;jj<12;jj++)bF 			    (*pred_buf)[k][ii][PREDDEL+j+3*jj] = (*fraction)[k][ii][j][jj]; 		   }  / 	     /* prediction & dematricing MPEG2 part */=
 if (!any_log);" 	     if (crc_error_count_mc == 0)0 		dematricing_mc (*fraction, &fr_ps, *pred_buf);   #ifdef Augmentation_7ch) 	     if (mpeg == 3) 	     {a
 if (!any_log)  		if (crc_error_count_aug == 0)  		{ ) 		   dematricing_aug (*fraction, &fr_ps);s+ 		   denormalizing_aug (*fraction, &fr_ps);  		}* 	      } 	      else* #endif# 	      if (crc_error_count_mc == 0) 1 		denormalizing_mc (*fraction, &fr_ps, channels);* 	   }   /* endif mpeg >= 2 */t  
 if (!any_log) ' 	   for (jj=0;jj<4*layer_I_frames;jj++) # 	      for (k=0; k < channels; k++)  		  for (j =0; j <3; j++)w$ 		     for (ii=0; ii< SBLIMIT; ii++)> 			(*fraction_help)[jj][k][j][ii] = (*fraction)[k][ii][j][jj];
 if (!any_log)f$ 	   for (i=0;i<4*layer_I_frames;i++)
 	   {			   	      for (j=0;j<3;j++) a& 	         for (k=0; k < channels; k++)C 		    clip += SubBandSynthesis (&((*fraction_help)[i][k][j][0]), k,)$ 					    &((*pcm_sample)[k][j][0]));    N8 	      out_fifo (*pcm_sample, 3, &fr_ps, done, musicout," 				    &sample_frames, channels); 	   }.  ( 	/* 31/10/95 Ralf Schwalbe LFE output */
 if (!any_log)f 	   if (info.lfe)  	   {i" 	      for (jj = 0; jj < 12; jj++) 	      {F 		/* lfe_tmp[jj] = (short int) (info.lfe_spl_fraction[jj] * SCALE); */? 		double foo = floor (info.lfe_spl_fraction[jj] * SCALE + 0.5);c  @ 		if (foo >= (long) SCALE)      {lfe_tmp[jj] = SCALE-1; clip++;}@ 		else if (foo < (long) -SCALE) {lfe_tmp[jj] =-SCALE;   clip++;}3 		else                           lfe_tmp[jj] = foo;  	      }) 	      fwrite (&lfe_tmp[0], 2, 12, lfe); + 	   }  	   if (clip > 0) . 	      printf("\n%d samples clipped\n", clip); 			"A /***************************************************************/ . /* 10/03/1995 JMZ Multilingual , WtK 7/8/95 */' 	   if (info.no_of_multi_lingual_ch>0) 	 	   {f@ 	      for(jj=0;jj<( (info.multi_lingual_fs==0) ? 12 : 6 );jj++)/ 		 for(k=0; k<info.no_of_multi_lingual_ch; k++)% 		     for(j =0; j <3; j++)_ 			for(ii=0; ii< SBLIMIT; ii++)}H 	      (*fraction_help_ml)[jj][k][j][ii] = (*fraction_ml)[k][ii][j][jj];   	      clip = 0;> 	      for (i=0;i<( (info.multi_lingual_fs==0) ? 12 : 6 );i++)
 	      {			    		for (j=0;j<3;j++) 1 		  for (k=0; k<info.no_of_multi_lingual_ch; k++) J 		      clip += SubBandSynthesis_ml(&((*fraction_help_ml)[i][k][j][0]), k,* 					       &((*pcm_sample_ml)[k][j][0]));  O 		out_fifo_ml(*pcm_sample_ml, 3, &fr_ps, done, musicout_ml, &sample_frames_ml);q 	      }H 	      if(clip > 0) printf("\n%d MultiLingual samples clipped\n", clip); 	   }	! /* 10/03/1995 JMZ Multilingual */e@ /**************************************************************/ 		 if( print_out == 1)i {i 	if(frameNum == 1) g 	{ 		fp6 = fopen("SUB_ML","w+");   		fp5 = fopen("DYN_CROSS","w+"); 		fp4 = fopen("INFODEC", "w+");c 		fp2 = fopen("BALDEC", "w+");  		fp3 = fopen("SCFSIDEC", "w+"); 		fp1 = fopen("SCFDEC", "w+"); 	}Q /*********************Ausgabe***************************************************/rZ fprintf(fp1, "******************** FRAME %d *****************************\n", frameNum-1);\ fprintf(fp2, "\n******************** FRAME %d *****************************\n", frameNum-1);\ fprintf(fp3, "\n******************** FRAME %d *****************************\n", frameNum-1);Z fprintf(fp4, "******************** FRAME %d *****************************\n", frameNum-1);Z fprintf(fp6, "******************** FRAME %d *****************************\n", frameNum-1);  - fprintf(fp4, "version = %d, ", info.version);n% fprintf(fp4, "lay = %d, ", info.lay); ? fprintf(fp4, "error_protection = %d\n", info.error_protection);s  9 fprintf(fp4, "bitrate_index = %d, ", info.bitrate_index);f  B fprintf(fp4, "sampling_frequency = %d,", info.sampling_frequency);- fprintf(fp4, "padding = %d, ", info.padding);d1 fprintf(fp4, "extension = %d\n", info.extension);s  ' fprintf(fp4, "mode = %d, ", info.mode); . fprintf(fp4, "mode_ext = %d,", info.mode_ext);1 fprintf(fp4, "copyright = %d, ", info.copyright);	/ fprintf(fp4, "original = %d, ", info.original);s/ fprintf(fp4, "emphasis = %d\n", info.emphasis);s  + fprintf(fp4, "center = %d, ", info.center); / fprintf(fp4, "surround = %d, ", info.surround);)C fprintf(fp4, "dematrix_procedure = %d, ", info.dematrix_procedure);i% fprintf(fp4, "lfe = %d\n", info.lfe);   K fprintf(fp4, "no_of_multi_lingual_ch = %d, ", info.no_of_multi_lingual_ch);n? fprintf(fp4, "multi_lingual_fs = %d, ", info.multi_lingual_fs);&E fprintf(fp4, "multi_lingual_layer = %d\n", info.multi_lingual_layer);\  7 fprintf(fp4, "dyn_cross_on = %d\n", info.dyn_cross_on);	? fprintf(fp4, "mc_prediction_on = %d\n", info.mc_prediction_on);e   #ifdef	DEBUG_PREDICTION  if(info.mc_prediction_on == 1)    for(hu = 0; hu < 8; ++ hu)*    {E 	fprintf(fp4, "mc_prediction[%d] = %d ", hu, info.mc_prediction[hu]);_ 	for(ho = 0; ho < 4; ho++) 	{J 		fprintf(fp4, "mc_predsi[%d][%d] = %d  ", hu,ho, info.mc_predsi[hu][ho]);M 		fprintf(fp4, "mc_delay[%d][%d] = %d  ", hu,ho, info.mc_delay_comp[hu][ho]);= 		fprintf(fp4, " \n"); 		for(hi = 0;hi <3; hi++)dW 		fprintf(fp4, "pred_coeff[%d][%d][%d] = %d ",hu,ho,hi,info.mc_pred_coeff[hu][ho][hi]);_ 		fprintf(fp4, " \n"); 	}    } #endif   if(info.dyn_cross_on == 1) {f] 	fprintf(fp5, "\n******************** FRAME %d *****************************\n", frameNum-1);{6 	fprintf(fp5,"dyn_cross_LR = %d\n",info.dyn_cross_LR); 	for(ho = 0; ho < 12; ho ++) 	{B 		fprintf(fp5,"dyn_cross[%d] = %d   ",ho,info.dyn_cross_mode[ho]);& 		if((ho+1)%4 == 0) fprintf(fp5,"\n"); 	} 	if (info.surround == 3) 		for(ho = 0; ho < 12; ho ++)  		{sN 			fprintf(fp5,"dyn_second_stereo[%d] = %d   ",ho,info.dyn_second_stereo[ho]);' 			if((ho+1)%4 == 0) fprintf(fp5,"\n");l 		}l };  ; fprintf(fp4, "tc_sbgr_select = %d\n", info.tc_sbgr_select);3 if(info.tc_sbgr_select == 1);   fprintf(fp4, "tc_allocation = %d\n", info.tc_allocation);  else 	{ 		for(ho = 0; ho < 12; ho ++)* 	{! 		if(info.mc_prediction[ho] == 0)*= 		fprintf(fp4, "tc_alloc[%d] = %d\n", ho, info.tc_alloc[ho]);  		else{= 		for(hu = 0; hu < 4; hu++) J 				fprintf(fp4, "predsi[%d][%d] = %d\n", ho, hu, info.mc_predsi[ho][hu]); 		}o 	} 	fprintf(fp4, "\n"); 	}   for(hu = 0; hu < SBLIMIT; ++hu)f {" 	fprintf(fp2, "\n"); 	fprintf(fp3, "\n");  " 	for(hi = 0; hi < channels; hi ++) 	{ 	fprintf(fp1, "\n"); 	if (layer_I_frames == 1)rJ 	   fprintf(fp2, "BAL[%d][%02d] = %d   ", hi, hu, I_bit_alloc[0][hi][hu]); 	elseoE 	   fprintf(fp2, "BAL[%d][%02d] = %d   ", hi, hu, bit_alloc[hi][hu]);-@ 	fprintf(fp3, "SCFSI[%d][%02d] = %d   ", hi, hu, scfsi[hi][hu]);  ) 	for( ho = 0; ho < layer_I_frames; ho ++)  	{S 	   fprintf(fp1, "SCF[%d][%d][%02d] = %d   ", hi, ho, hu, scale_index[hi][ho][hu]);  	} 	}5 	for(hi = 0; hi < info.no_of_multi_lingual_ch; hi ++)o 	{ 	   fprintf(fp1, "\n");_1 	   /* 960315 added FDB Multi-Lingual bitalloc */fK 	   fprintf(fp2, "BAL_ML[%d][%02d] = %d   ", hi, hu, bit_alloc_ml[hi][hu]);m8 	   /* 960315 added FDB Multi-Lingual scf select info */I 	   fprintf(fp3, "SCFSI_ML[%d][%02d] = %d   ", hi, hu, scfsi_ml[hi][hu]); - 	   /* 960315 added FDB Multi-Lingual scfs */r 	   for( ho = 0; ho < 3; ho ++)a\ 	      fprintf(fp1, "SCF_ML[%d][%d][%02d] = %d   ", hi, ho, hu, scale_index_ml[hi][ho][hu]);	         }+ 	fprintf(fp1, "\n"); }[  ; /* 960318 added FDB Multi-Lingual subband samples symbols*/r, for(k=0; k<info.no_of_multi_lingual_ch; k++)    for(ii=0; ii< SBLIMIT; ii++)u    {3       fprintf(fp6, "SB_SYM_ML[%d][%02d]: ", k, ii); ?       for(jj=0;jj<( (info.multi_lingual_fs==0) ? 12 : 6 );jj++)a          for(j =0; j <3; j++)p>             fprintf(fp6, " %6d", sym_sample_ml[jj][k][j][ii]);       fprintf(fp6, "\n");a    }    4 /* 960318 added FDB Multi-Lingual subband samples */, for(k=0; k<info.no_of_multi_lingual_ch; k++)    for(ii=0; ii< SBLIMIT; ii++)e    {/       fprintf(fp6, "SB_ML[%d][%02d]: ", k, ii); ?       for(jj=0;jj<( (info.multi_lingual_fs==0) ? 12 : 6 );jj++)           for(j =0; j <3; j++) G             fprintf(fp6, " %12.5e", (*fraction_help_ml)[jj][k][j][ii]);;       fprintf(fp6, "\n");;    }
 fflush (fp1);(
 fflush (fp2);i
 fflush (fp3);j
 fflush (fp4);[
 fflush (fp5); 
 fflush (fp6); Q /*******************************************************************************/n   } /* endif of print_out == 1 */t  F     /****************************************************************/F     /*                                                              */F     /*                   END OF FRAME LOOP                          */F     /*                                                              */F     /****************************************************************/  % }/*end of while(!endof(bs)) - loop */l   	if (need_aiff); 	{ #ifdef Augmentation_7ch  	   if (mpeg == 3)+ 	      pcm_aiff_data.numChannels       = 7;	 	   else #endif= 	      pcm_aiff_data.numChannels       = stereo + mc_channel;n4 	   pcm_aiff_data.numSampleFrames   = sample_frames;) 	   pcm_aiff_data.sampleSize        = 16;=K 	   pcm_aiff_data.sampleRate        = s_freq[info.sampling_frequency]*1000;n2 	   strcpy(pcm_aiff_data.sampleType, IFF_ID_SSND);( 	   pcm_aiff_data.blkAlgn.offset    = 0;( 	   pcm_aiff_data.blkAlgn.blockSize = 0;  ; 	   if (aiff_write_headers(musicout, &pcm_aiff_data) == -1)1 	   {R@ 		  fprintf (stderr, "Could not write AIFF headers to \"%s\"\n", 				 decoded_file_name);
 		  exit (1);             }  6            if (fr_ps.header->no_of_multi_lingual_ch>0) 	   {/M 	     pcm_aiff_data.numChannels       = fr_ps.header->no_of_multi_lingual_ch; 6 	     pcm_aiff_data.numSampleFrames   = sample_frames;+ 	     pcm_aiff_data.sampleSize        = 16;=M 	     pcm_aiff_data.sampleRate        = s_freq[info.sampling_frequency]*1000; M 	     if (fr_ps.header->multi_lingual_fs==1) pcm_aiff_data.sampleRate *= 0.5; 4 	     strcpy(pcm_aiff_data.sampleType, IFF_ID_SSND);* 	     pcm_aiff_data.blkAlgn.offset    = 0;* 	     pcm_aiff_data.blkAlgn.blockSize = 0;   @ 	     if (aiff_write_headers(musicout_ml, &pcm_aiff_data) == -1) 	     { B 		    fprintf (stderr, "Could not write AIFF headers to \"%s\"\n", 				   decoded_file_name_ml);c 		    exit (1);f 	     }j 	   }+ 	   if (lfe_init == 0) 	   {i* 	     pcm_aiff_data.numChannels       = 1;; 	     pcm_aiff_data.numSampleFrames   = sample_frames / 96; + 	     pcm_aiff_data.sampleSize        = 16; T 	     pcm_aiff_data.sampleRate        = (s_freq[info.sampling_frequency]*1000) / 96;4 	     strcpy(pcm_aiff_data.sampleType, IFF_ID_SSND);* 	     pcm_aiff_data.blkAlgn.offset    = 0;* 	     pcm_aiff_data.blkAlgn.blockSize = 0;  8 	     if (aiff_write_headers(lfe, &pcm_aiff_data) == -1) 	     {sB 		    fprintf (stderr, "Could not write AIFF headers to \"%s\"\n", 				   lfe_file_name); 		    exit (1);1 	     }u 	   }u 	 }e   	close_bit_stream_r(&bs_mpg);*  ! 	if (info.ext_bit_stream_present)  	{" 	     close_bit_stream_r(&bs_ext);   	} 	fclose(musicout); 	if(info.lfe) fclose(lfe);     #ifdef  MACINTOSH A 	if (need_aiff) set_mac_file_attr(decoded_file_name, VOL_REF_NUM,	, 									 CREATR_DEC_AIFF, FILTYP_DEC_AIFF);A 	else           set_mac_file_attr(decoded_file_name, VOL_REF_NUM,*, 									 CREATR_DEC_BNRY, FILTYP_DEC_BNRY); #endif  Y 	printf("Decoding of \"%s\" with %lu frames is finished\n", encoded_file_name, frameNum);*K 	printf("The decoded PCM output file name is \"%s\"\n", decoded_file_name);p 	if (need_aiff)*D 	   printf("\"%s\" has been written with AIFF header information\n", 			  decoded_file_name);  . 	if (fr_ps.header->no_of_multi_lingual_ch>0) {g           printf("There are %d multilingual channels, coded at ",fr_ps.header->no_of_multi_lingual_ch);mU           if (fr_ps.header->multi_lingual_fs==0) printf("full"); else printf("half");.[           printf(" sampling rate.\n They are outputted in \"%s\".\n",decoded_file_name_ml);r           if (need_aiff)P 	   printf("Multilingual file has been written with AIFF header information\n"); 	}   	if (total_error_count_mc != 0).` 	    printf ("There were %d frames,  which were not in multichannel!!\n", total_error_count_mc); #ifdef Augmentation_7cho  	if (total_error_count_aug != 0)k 	    printf ("There were %d frames,  which were not in augmented multichannel!!\n", total_error_count_aug);p #endif     if (print_out == 1)i     {  	fclose (fp1); 	fclose (fp2); 	fclose (fp3); 	fclose (fp4); 	fclose (fp5); 	fclose (fp6);     }(     return (1);o }u    , void usage (void)  /* print syntax & exit */ {"    fprintf (stderr,)J       "usage: %s                         queries for all arguments, or\n", 	   programName);,    fprintf (stderr,%G       "       %s [-a] [-h] [-i] [-m] inputBS [outPCM]\n", programName);,    fprintf (stderr,"where\n");c    fprintf (stderr," -a       write a RAW data sound file  (default: write an AIFF sound file)\n");oX    fprintf (stderr," -b       write alloc bits per subband to stdout (default: off)\n");L    fprintf (stderr," -d       write dynx modes to stdout (default: off)\n");^    fprintf (stderr," -h       bitstreams contain a 2304 byte header  (default: no header)\n");Q    fprintf (stderr," -i       write decoded bitstream-information in a file\n"); ,1 			      /* default: write encoded information */"N    fprintf (stderr," -m       encoded bitstream is a MPEG 1 Layer-2 file\n"); 9 			      /* default: decode a MPEG 2 Layer-2 bitstream */\ #ifdef Augmentation_7ch d    fprintf (stderr," -n       encoded bitstream is a MPEG 2 Layer-2 file with 7.1 augmentation\n"); 9 			      /* default: decode a MPEG 2 Layer-2 bitstream */" #endifV    fprintf (stderr," -s       write scf bits per subband to stdout (default: off)\n");K    fprintf (stderr," -t       write tca modes to stdout (default: off)\n");iD    fprintf (stderr," inputBS  input bit stream of encoded audio\n");F    fprintf (stderr," outPCM   output PCM sound file (dflt inName)\n");    exit (1); }f