G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) 0  * ISO 13818-3 MPEG-2 Audio Multichannel Decoder  *8  * $Id: decode.c 1.12 1997/01/17 04:26:01 rowlands Exp $  *  * $Log: decode.c $ /  * Revision 1.12  1997/01/17 04:26:01  rowlands *  * Fixed base bitstream joint stereo bugs.&  * Fixed PCM output file cleanup bugs.  */  * Revision 1.11  1996/04/18 05:37:23  rowlands %  * Release following Florence meeting   */  * Revision 1.10  1996/02/12 07:13:06  rowlands #  * Release following Munich meeting   *3  * Revision 1.9.1.4  1996/01/29  03:36:47  rowlands <  * Fixed problem with dynamic crosstalk in 2/2 configuration8  * Fixed bug in dynamic crosstalk for 3/1 configuration.  *3  * Revision 1.9.1.1  1996/01/20  17:28:45  rowlands B  * Received from Ralf Schwalbe (Telekom FTZ) - includes prediction  *2  * Revision 1.7.1.3  1995/08/14  08:12:10  tenkate0  * ML-LSF added Warner ten Kate 7/8/95 (Philips)3  * change "alloc" and "sblimit" into "alloc_ml" and "  * "sblimit_ml" where appropriate.  *3  * Revision 1.7.1.1  1995/07/14  06:12:46  rowlands 6  * Updated dynamic crosstalk from FTZ: revision FTZ_03  *3  * Revision 1.3.3.1  1995/06/16  08:00:46  rowlands )  * Input from Sang Wook Kim (Samsung AIT)   *3  * Revision 1.3.2.1  1995/06/16  03:27:20  rowlands 5  * Corrected prediction select syntax according to IS F  * Added dematrixing procedure 2. Corrected dematrix weighting values.  *H  **********************************************************************/  G /********************************************************************** G  *   date   programmers                comment                        * G  * 2/25/91  Douglas Wong        start of version 1.0 records          * G  * 3/06/91  Douglas Wong        rename setup.h to dedef.h             * G  *                              removed extraneous variables          * G  *                              removed window_samples (now part of   * G  *                              filter_samples)                       * G  * 3/07/91  Davis Pan           changed output file to "codmusic"     * G  * 5/10/91  Vish (PRISM)        Ported to Macintosh and Unix.         * G  *                              Incorporated new "out_fifo()" which   * G  *                              writes out last incomplete buffer.    * G  *                              Incorporated all AIFF routines which  * G  *                              are also compatible with SUN.         * G  *                              Incorporated user interface for       * G  *                              specifying sound file names.          * G  *                              Also incorporated user interface for  * G  *                              writing AIFF compatible sound files.  * G  * 27jun91  dpwe (Aware)        Added musicout and &sample_frames as  * G  *                              args to out_fifo (were glob refs).    * G  *                              Used new 'frame_params' struct.       * G  *                              Clean,simplify, track clipped output  * G  *                              and total bits/frame received.        * G  * 7/10/91  Earle Jennings      changed to floats to FLOAT            * G  *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           * G  *          Don H. Lee,                                               * G  *          Peter W. Farrett                                          * G  *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   * G  *                              newly introduced functions are        * G  *                              buffer_CRC and recover_CRC_error      * G  *                              Additions and revisions are marked    * G  *                              with "dhl" for clarity                * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  ********************************************************************** G  *                                                                    * G  *                                                                    * G  *  MPEG/audio Phase 2 coding/decoding multichannel                   * G  *                                                                    * G  *  Version 1.0                                                       * G  *                                                                    * G  *  7/27/93        Susanne Ritscher,  IRT Munich                      * G  *                                                                    * G  *                  thanks to                                         * G  *                  Ralf Schwalbe,    Telekom FTZ Berlin              * G  *                  Heiko Purnhagen,  Uni Hannover                    * G  *                                                                    * G  *  Version 2.0                                                       * G  *                                                                    * G  *  8/27/93        Susanne Ritscher, IRT Munich                       * G  *                 Channel-Switching is working                       * G  *                                                                    * G  *  Version 2.1                                                       * G  *                                                                    * G  *  9/1/93         Susanne Ritscher,  IRT Munich                      * G  *                 all channels normalized                            * G  *                                                                    * G  *  Version 3.0                                                       * G  *                                                                    * G  *  06/16/94       Ralf Schwalbe, Telekom FTZ Berlin                  * G  *                 all sources and variables adapted due to MPEG-2 -  * G  *                 DIS from March 1994                                * G  *                  - dematrix and denormalize procedure              * G  *                  - new tc - allocation (0-7)                       * G  *                  - some new structures and variables as a basis    * G  *                    for further decoding modes                      * G  **********************************************************************   *								      * G  *  Version 1.0                                                       * G  *                                                                    * G  *  11/04/94       Ralf Schwalbe,  Telekom FTZ Berlin                 * G  *                  - decoding tc-allocation                          * G  *                  - some new subroutines, globale variables and     * G  *                    structures (important to handle the ext. bitst.)* G  *                  - changed all functions to ANSI-C funktion header * ;  *		    - corrected some bugs to decode bitstreams > 512kB*   *								      * G  *  Version 1.1                                                       * G  *                                                                    * G  *  12/07/94       Ralf Schwalbe,  Telekom FTZ Berlin                 * G  *                  - decoding extension bitstream                    * G  *                                                                    * G  *  Version 1.1.1                                                     * G  *                 Ralf Schwalbe, Telekom FTZ Berlin                  * G  *                  - fixed some bugs                                 * G  *                                                                    **G  *  Version 1.2                                                       *1G  *                                                                    *0G  *  6/21/95       Ralf Schwalbe, Deutsche Telekom FTZ Berlin          * F  *            	    - decoding dynamic crosstalk                      *H  *                  - decoding phantom center                         * G  *                  - decoding MPEG1 compatible part only (stereo)    *vG  *                  - corrected some settings and bugs                *eH  *                                                                    * C  *  7/12/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin          * /  *		    - corrected dynamic crosstalk 		      *R;  *		    - 3/2,3/1,3/0,2/1, channel configurations         * G  *                    are working                                     *.  *		  						      *:@  * 10/31/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin	      *6  *		    - decoding of LFE-channel is working  	      *2  *		    - corrected any settings and bugs		      *;  *		    - corrected table-switch for channel mode < 3/2   *o4  *		      and tc-allocation / dyn-crosstalk		      *;  *		    - still a problem with compl. bitstream 18/19     *   *								      *	B  * 01/12/96	  Ralf Schwalbe, Deutsche Telekom TZ Darmstadt	      */  *		    - decoder prediction installed		      *A;  *		    - problem with compl. bitstream 19 solved,        *lP  *                                                                    *         G  *  Version 2.0                                                       **G  *                                                                    * G  * 01/28/97       Frans de Bont, Philips Sound & Vision, Eindhoven    * ;  *		    - simultaneous use of tc allocation and dynamic   * :  *		      crosstalk working for all configurations	      *;  *		    - prediction working for all configurations	      * &  *		    - layer 1 MC working			      *;  *		    - variable bit rate and extension bitstreams      * ;  *		    - fully compliant to 13818-3.2                    *fX  *                                                                    *				      *		    H  **********************************************************************/  G /**********************************************************************.G  *                                                                    *iG  *  06/06/95       Yeon Bae Thomas Kim,  Samsung AIT                  * G  *                 ancillary data is working                          *   *								      * H  **********************************************************************/H  /*********************************************************************/   #include        "common.h" #include        "decoder.h"   @ /*************************************************************** /*: /* This module contains the core of the decoder ie all the0 /* computational routines. (Layer I and II only), /* Functions are common to both layer unless /* otherwise specified.  /*A /***************************************************************/   B /***************************************************************** /*7 /* The following routines decode the system information  /*B /****************************************************************/  B /************************* Layer II  ****************************/    void decode_info(Bit_stream *bs, 		 frame_params *fr_ps)  {     layer *hdr = fr_ps->header;      hdr->version = get1bit (bs);o"    hdr->lay = 4 - getbits (bs, 2);I    hdr->error_protection = !get1bit (bs); /* error protect. TRUE/FALSE */ (    hdr->bitrate_index = getbits (bs, 4);-    hdr->sampling_frequency = getbits (bs, 2);     hdr->padding = get1bit (bs); !    hdr->extension = get1bit (bs);"    hdr->mode = getbits (bs, 2);*#    hdr->mode_ext = getbits (bs, 2);n!    hdr->copyright = get1bit (bs);*     hdr->original = get1bit (bs);#    hdr->emphasis = getbits (bs, 2);  }       H /**********************************************************************/ /*																	  */ H /*  7.7.93 Susanne Ritscher Systeminformation for multi-channel       */D /* 27.5.94 Ralf Schwalbe    Systeminformation and names due to		  */B /*					MPEG 2 DIS from March 1994  */					                         /*								*/H /**********************************************************************/   void mc_header(Bit_stream *bs, 	       frame_params *fr_ps) {i    layer *hdr = fr_ps->header;.    hdr->ext_bit_stream_present = get1bit (bs);(    if( hdr->ext_bit_stream_present == 1)$ 	hdr->n_ad_bytes =  getbits (bs, 8);!    hdr->center = getbits (bs, 2); #    hdr->surround = getbits (bs, 2);     hdr->lfe = get1bit (bs);*E    hdr->audio_mix = get1bit (bs);     /* large or small room  R.S. */ -    hdr->dematrix_procedure = getbits (bs, 2); 1    hdr->no_of_multi_lingual_ch = getbits (bs, 3); (    hdr->multi_lingual_fs = get1bit (bs);+    hdr->multi_lingual_layer = get1bit (bs); +    hdr->copyright_ident_bit = get1bit (bs); -    hdr->copyright_ident_start = get1bit (bs);  }   4 /* R.S. prediction table MPEG-2 IS November, 1995 */; /* FdB  prediction table MPEG-2 CD 13818-3.2 March, 1996 */ @ int pred_coef_table[6][16] = {{6,4,4,4,2,2,2,0,2,2,2,0,0,0,0,0},+ 			      {4,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0}, + 			      {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},a+ 			      {4,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0}, + 			      {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, , 			      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};    - void mc_composite_status_info(Bit_stream *bs, 8 			      frame_params *fr_ps, int tca_log, int dynx_log) {     layer *hdr = fr_ps->header;    int sbgr, j, pci;    &    hdr->tc_sbgr_select = get1bit (bs);$    hdr->dyn_cross_on = get1bit (bs);(    hdr->mc_prediction_on = get1bit (bs);      if(hdr->tc_sbgr_select == 1)     {6 	hdr->tc_allocation = getbits (bs, fr_ps->alloc_bits);/ 	/* tc_allocation is valid for all sbgr R.S. */ $ 	for(sbgr = 0; sbgr < 12; sbgr++)   + 		hdr->tc_alloc[sbgr] = hdr->tc_allocation;R    }    else     { 	hdr->tc_allocation = 0;! 	for(sbgr = 0; sbgr < 12; sbgr++) 8 		hdr->tc_alloc[sbgr] = getbits (bs, fr_ps->alloc_bits);    }      if (tca_log) '       for (sbgr = 0; sbgr < 12; sbgr++) @ 	 printf ("tc_alloc[ %2d ] = %2d\n", sbgr, hdr->tc_alloc[sbgr]);      if( hdr->dyn_cross_on == 1)    {# 		hdr->dyn_cross_LR = get1bit (bs); " 		for(sbgr = 0; sbgr < 12; sbgr++) 		{ C 			hdr->dyn_cross_mode[sbgr] = getbits (bs, fr_ps->dyn_cross_bits);P+ 			/* 960816 FdB dyn_second_stereo added */  			if (hdr->surround == 3)0 				hdr->dyn_second_stereo[sbgr] = get1bit (bs); 		}i    }    else     { 		hdr->dyn_cross_LR = 0;" 		for(sbgr = 0; sbgr < 12; sbgr++)! 			hdr->dyn_cross_mode[sbgr] = 0;     }      if (dynx_log)'       for (sbgr = 0; sbgr < 12; sbgr++) F 	 printf ("dynx_mod[ %2d ] = %2d\n", sbgr, hdr->dyn_cross_mode[sbgr]);  "    if( hdr->mc_prediction_on == 1)    {# 	  for(sbgr = 0; sbgr < 8; sbgr++)   	  {  6 		if( (hdr->mc_prediction[sbgr] = get1bit (bs)) == 1 ) 		{ N /* R.S. read from npredcoef-table max number of coef. for 3/2 configuration */9 /* and then the predsi info -> 0    : no prediction    */ & /*			    -> 1..3 : 1..3 coefficient */[ 		    for(pci=0; pci< pred_coef_table[fr_ps->pred_mode][hdr->dyn_cross_mode[sbgr]] ; pci++) / 			hdr->mc_predsi[sbgr][pci] = getbits (bs, 2);  		}u 	  }    } }n       #ifdef Augmentation_7ch b void mc_aug_composite_status_info (Bit_stream *bs, frame_params *fr_ps, int tca_log, int dynx_log) {     layer *hdr = fr_ps->header;    int sbgr, j, pci;  '    hdr->aug_mtx_proc = getbits (bs, 2); (    hdr->aug_dyn_cross_on = get1bit (bs);&    hdr->aug_future_ext = get1bit (bs);      if(hdr->aug_mtx_proc == 0)     {$ 	for(sbgr = 0; sbgr < 12; sbgr++)   , 		hdr->tc_aug_alloc[sbgr] = getbits (bs, 3);    }"    else if(hdr->aug_mtx_proc == 1)    {! 	for(sbgr = 0; sbgr < 12; sbgr++) , 		hdr->tc_aug_alloc[sbgr] = getbits (bs, 2);    }    else ! 	for(sbgr = 0; sbgr < 12; sbgr++)  		hdr->tc_aug_alloc[sbgr] = 0;      if (tca_log) '       for (sbgr = 0; sbgr < 12; sbgr++) H 	 printf ("tc_aug_alloc[ %2d ] = %2d\n", sbgr, hdr->tc_aug_alloc[sbgr]);  "    if( hdr->aug_dyn_cross_on == 1)    {! 	for(sbgr = 0; sbgr < 12; sbgr++) 2 		hdr->dyn_cross_aug_mode[sbgr] = getbits (bs, 5);    }    else ! 	for(sbgr = 0; sbgr < 12; sbgr++) $ 		hdr->dyn_cross_aug_mode[sbgr] = 0;      if (dynx_log)'       for (sbgr = 0; sbgr < 12; sbgr++) N 	 printf ("dynx_aug_mod[ %2d ] = %2d\n", sbgr, hdr->dyn_cross_aug_mode[sbgr]); }  #endif  D /******************************************************************* /*5 /* The bit allocation information is decoded. Layer I*< /* has 4 bit per subband whereas Layer II is Ws and bit rate
 /* dependent.  /*F /********************************************************************/  ) void I_decode_bitalloc (Bit_stream   *bs,l 			frame_params *fr_ps, ' 			unsigned int bit_alloc[7][SBLIMIT],	* 			int	     bits_log), {a    int i,j;a    int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;	    int b;       for (i=0;i<jsbound;i++)       for (j=0;j<stereo;j++)$ 	 bit_alloc[j][i] = getbits (bs, 4);  "    for (i=jsbound; i<SBLIMIT; i++)    {       b = getbits (bs, 4);       for (j=0; j<stereo; j++) 	 bit_alloc[j][i] = b;    }      if (bits_log)    {!       for (j= 0; j < stereo; j++)	&          for (i = 0; i < SBLIMIT; i++) 	 {84 	    int alloc_bits = 0, alloc_id = bit_alloc[j][i];  8 	    if ((j == 0 || i < jsbound) && bit_alloc[j][i] > 0)) 	       alloc_bits = 12 * (alloc_id + 1);   ? 	    printf ("alloc_bi[ %d ][ %2d ]= %3d\n", j, i, alloc_bits);  	 }     } }     ( void II_decode_bitalloc (Bit_stream *bs, 			 frame_params *fr_ps,( 			 unsigned int bit_alloc[7][SBLIMIT],	 			 int bits_log)  {     int i,j,c,sbgr;    int stereo = fr_ps->stereo;     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc;)    unsigned int actual_alloc[7][SBLIMIT];*       for (i = 0; i < SBLIMIT; i++)"       for (j = 0; j < stereo; j++) 	 actual_alloc[j][i] = 0;i      for (i=0; i<jsbound; i++)       for (j=0;j<stereo;j++)R 	 actual_alloc[j][i] = bit_alloc[j][i] = (char) getbits (bs, (*alloc)[i][0].bits);  ?    for (i=jsbound; i<sblimit; i++)   /* expand to 2 channels */ h       actual_alloc[0][i] = bit_alloc[0][i] = bit_alloc[1][i] = (char) getbits (bs, (*alloc)[i][0].bits);  "    for (i=sblimit; i<SBLIMIT; i++)       for (j=0; j<stereo; j++) 	  bit_alloc[j][i] = 0;*      if (bits_log)    {!       for (j= 0; j < stereo; j++) &          for (i = 0; i < SBLIMIT; i++) 	 {a4 	    int alloc_bits = 0, alloc_id = bit_alloc[j][i];    	    if (actual_alloc[j][i] > 0)S 	       alloc_bits = 12 * (*alloc)[i][alloc_id].bits * (*alloc)[i][alloc_id].group;*  ? 	    printf ("alloc_bi[ %d ][ %2d ]= %3d\n", j, i, alloc_bits);* 	 }*    } }*    + void II_decode_bitalloc_mc (Bit_stream *bs,c 			    frame_params *fr_ps,c+ 			    unsigned int bit_alloc[7][SBLIMIT],	*$ 			    int *l, int *m, int bits_log) {i    layer *info = fr_ps->header;     int i,j,c,sbgr;#    int sblimit = fr_ps->sblimit_mc;n%    al_table *alloc = fr_ps->alloc_mc;b)    unsigned int actual_alloc[7][SBLIMIT];        for (i = 0; i < SBLIMIT; i++)       for (j = *l; j < *m; j++)  	 actual_alloc[j][i] = 0;*  #    /* 10/31/95 Ralf Schwalbe LFE */*    if (info->lfe)oA       info->lfe_alloc = (char) getbits (bs, (*alloc)[0][0].bits);*      for (i=0; i<sblimit; i++)"       if (info->dyn_cross_on == 0) 	 for (j=*l;j<*m;j++)* 	 {*= 	    if ((fr_ps->header->center != 3) || (i < 12) || (j !=2))aX 	       actual_alloc[j][i] = bit_alloc[j][i] = (char) getbits (bs, (*alloc)[i][0].bits);	 	    elsea 	       bit_alloc[j][i] = 0; 	 }r!       else  /* dyn. cross mode */e       {e 	 if (i == 0) sbgr = 0;r 	 else 	    for (c = 1; c < 12; c++)h 	    {8 	       if ((sb_groups[c-1] < i) && (i <= sb_groups[c]))	 	       { 3 		  sbgr = c;  /* search the valid subband group */t
 		  break;	 	       }> 	    }  g5 	 /* 960816 FdB new setup for dyn. crosstalk modes */ & 	 if (info->dyn_cross_mode[sbgr] == 0) 	 {s 	    for (j = *l; j < *m; j++)< 	       if (fr_ps->header->center == 3 && i >= 12 && j == 2) 		  bit_alloc[j][i] = 0;K 	       else if (info->surround == 3 && info->dyn_second_stereo[sbgr] == 1) 	 	       {*$ 		  if (info->center != 0 && j == 4)) 		     bit_alloc[j][i] = bit_alloc[3][i]; ) 		  else if (info->center == 0 && j == 3) ) 		     bit_alloc[j][i] = bit_alloc[2][i];* 		  elseW 		     actual_alloc[j][i] = bit_alloc[j][i] = (char) getbits (bs, (*alloc)[i][0].bits);m	 	       }r 	       elseT 		  actual_alloc[j][i] = bit_alloc[j][i] = (char) getbits (bs, (*alloc)[i][0].bits); 	 }_K 	 else if (fr_ps->dyn_cross_bits == 1)   /* for channel mode 3/0 and 2/1 */r 	 {t  	    /* DynX mode has to be 1 */H 	    if ((info->center == 3) && (i >= 12))    /* 3/0 + phantom center */ 	       bit_alloc[2][i] = 0;( 	    else if (info->tc_alloc[sbgr] == 1)* 	       bit_alloc[2][i] = bit_alloc[0][i];( 	    else if (info->tc_alloc[sbgr] == 2)* 	       bit_alloc[2][i] = bit_alloc[1][i];	 	    elsea 	       if (info->dyn_cross_LR)y& 		  bit_alloc[2][i] = bit_alloc[1][i]; 	       else& 		  bit_alloc[2][i] = bit_alloc[0][i];  r. 	    if (info->surround == 3)		/* 3/0 + 2/0 */ 	    {X 	       actual_alloc[3][i] = bit_alloc[3][i] = (char) getbits (bs, (*alloc)[i][0].bits);/ 	       if (info->dyn_second_stereo[sbgr] == 1),& 		  bit_alloc[4][i] = bit_alloc[3][i]; 	       elseT 		  actual_alloc[4][i] = bit_alloc[4][i] = (char) getbits (bs, (*alloc)[i][0].bits); 	    } 	 },K 	 else if (fr_ps->dyn_cross_bits == 3)   /* for channel mode 3/1 and 2/2 */t 	 {fH 	    if ((info->center == 3) && (i >= 12))    /* 3/1 + phantom center */ 	       bit_alloc[2][i] = 0;U 	    else if ((info->dyn_cross_mode[sbgr] == 1) || (info->dyn_cross_mode[sbgr] == 4))_X 	       actual_alloc[2][i] = bit_alloc[2][i] = (char) getbits (bs, (*alloc)[i][0].bits);	 	    else  	    {  	       /* T2 not transmitted */< 	       if (fr_ps->header->surround == 2 ||	/* 2/2 mode */		9 		   fr_ps->header->tc_alloc[sbgr] == 1 ||	/* 3/1 mode */lN 		   fr_ps->header->tc_alloc[sbgr] == 5 ||	/* 3/1 mode (matrix mode 2 only) */H 		   fr_ps->header->tc_alloc[sbgr] != 2 && !fr_ps->header->dyn_cross_LR)? 		  bit_alloc[2][i] = bit_alloc[0][i];	/* C, L or Ls from L0 */  	       else? 		  bit_alloc[2][i] = bit_alloc[1][i];	/* C, R or Rs from RO */c 	    }   ) 	    if (info->dyn_cross_mode[sbgr] == 2)-X 	       actual_alloc[3][i] = bit_alloc[3][i] = (char) getbits (bs, (*alloc)[i][0].bits);. 	    else if (info->dyn_cross_mode[sbgr] == 4)* 	       bit_alloc[3][i] = bit_alloc[2][i];	 	    elsei 	    {  	       /* T3 not transmitted */: 	       if (fr_ps->header->surround == 2 ||	/* 2/2 mode */9 		   fr_ps->header->tc_alloc[sbgr] == 4 ||	/* 3/1 mode */)N 		   fr_ps->header->tc_alloc[sbgr] == 5 ||	/* 3/1 mode (matrix mode 2 only) */F 		   fr_ps->header->tc_alloc[sbgr] < 3 && fr_ps->header->dyn_cross_LR)? 		  bit_alloc[3][i] = bit_alloc[1][i];	/* S, R or Rs from R0 */  	       else? 		  bit_alloc[3][i] = bit_alloc[0][i];	/* S, L or Ls from LO */r 	    } 	 } C 	 else if (fr_ps->dyn_cross_bits == 4)   /* for channel mode 3/2 */f 	 { 
 	    /* T2 */oH 	    if ((info->center == 3) && (i >= 12))    /* 3/2 + phantom center */ 	       bit_alloc[2][i] = 0;- 	    else switch (info->dyn_cross_mode[sbgr])p 	    {/ 	    case 1 :   /* T2 contains bitalloc info */c
 	    case 2 :c
 	    case 4 :s
 	    case 8 : 
 	    case 9 :  	    case 10:  	    case 11:  	    case 12:  	    case 14: Y 		       actual_alloc[2][i] = bit_alloc[2][i] = (char) getbits (bs, (*alloc)[i][0].bits);- 		       break;s2 	    case 3 :   /* T2 contains no bitalloc info */
 	    case 5 :u
 	    case 6 :=
 	    case 7 :  	    case 13: H 		       if ((info->tc_alloc[sbgr] == 1) || (info->tc_alloc[sbgr] == 7))' 			  bit_alloc[2][i] = bit_alloc[0][i];_M 		       else if ((info->tc_alloc[sbgr] == 2) || (info->tc_alloc[sbgr] == 6)) ' 			  bit_alloc[2][i] = bit_alloc[1][i];-
 		       elseb 			  if (info->dyn_cross_LR)* 			     bit_alloc[2][i] = bit_alloc[1][i];	 			  else_* 			     bit_alloc[2][i] = bit_alloc[0][i]; 		       break;; 	    }   
 	    /* T3 */n( 	    switch (info->dyn_cross_mode[sbgr]) 	    {/ 	    case 1 :   /* T3 contains bitalloc info */=
 	    case 3 :r
 	    case 5 : 
 	    case 8 :  	    case 10:  	    case 13: Y 		       actual_alloc[3][i] = bit_alloc[3][i] = (char) getbits (bs, (*alloc)[i][0].bits);g 		       break; 9 	    case 2 :   /* T3 has to copy its bitalloc from T0 */ 
 	    case 4 :n
 	    case 6 :]
 	    case 7 :, 	    case 12: + 		       bit_alloc[3][i] = bit_alloc[0][i];* 		       break;*9 	    case 9 :   /* T3 has to copy its bitalloc from T2 */t
 	    case 11:  	    case 14: + 		       bit_alloc[3][i] = bit_alloc[2][i];I 		       break;a 	    }  n
 	    /* T4 */*( 	    switch (info->dyn_cross_mode[sbgr]) 	    {/ 	    case 2 :   /* T4 contains bitalloc info */t
 	    case 3 :	
 	    case 6 :f 	    case 9 : Y 		       actual_alloc[4][i] = bit_alloc[4][i] = (char) getbits (bs, (*alloc)[i][0].bits);= 		       break; 9 	    case 1 :   /* T4 has to copy its bitalloc from T1 */s
 	    case 4 :b
 	    case 5 :=
 	    case 7 :) 	    case 11: + 		       bit_alloc[4][i] = bit_alloc[1][i];b 		       break;(9 	    case 10:   /* T4 has to copy its bitalloc from T2 */;
 	    case 12:0 	    case 14: + 		       bit_alloc[4][i] = bit_alloc[2][i];_ 		       break; 9 	    case 8 :   /* T4 has to copy its bitalloc from T3 */M 	    case 13: + 		       bit_alloc[4][i] = bit_alloc[3][i];[ 		       break;  	    } 	 }        })  "    for (i=sblimit; i<SBLIMIT; i++)       for (j=*l; j<*m; j++)  	  bit_alloc[j][i] = 0;i      if (bits_log)    {       for (j= *l; j < *m; j++)&          for (i = 0; i < SBLIMIT; i++) 	 {,4 	    int alloc_bits = 0, alloc_id = bit_alloc[j][i];    	    if (actual_alloc[j][i] > 0)S 	       alloc_bits = 12 * (*alloc)[i][alloc_id].bits * (*alloc)[i][alloc_id].group;i  ? 	    printf ("alloc_bi[ %d ][ %2d ]= %3d\n", j, i, alloc_bits);l 	 }     } }e   #ifdef Augmentation_7chI, void II_decode_bitalloc_aug (Bit_stream *bs, 			     frame_params *fr_ps,, 			     unsigned int bit_alloc[7][SBLIMIT],	% 			     int *l, int *m, int bits_log); {)    layer *info = fr_ps->header;c    int i,j,c,sbgr;E    /* int stereo = fr_ps->stereo; */ /* not used for mc - decoding *//#    int sblimit = fr_ps->sblimit_mc;u%    al_table *alloc = fr_ps->alloc_mc;a)    unsigned int actual_alloc[7][SBLIMIT];]       for (i = 0; i < SBLIMIT; i++)       for (j = *l; j < *m; j++)t 	 actual_alloc[j][i] = 0;[      for (i=0; i<sblimit; i++)&       if (info->aug_dyn_cross_on == 0) 	 for (j=*l;j<*m;j++)<U 	    actual_alloc[j][i] = bit_alloc[j][i] = (char) getbits (bs, (*alloc)[i][0].bits);a!       else  /* dyn. cross mode */o       {1)         int T5T0 = 0, T6T0 = 0, T6T1 = 1;]      	 if(i == 0) sbgr = 0; 	 else 	    for(c = 1; c < 12; c++) 	    {7 	       if((sb_groups[c-1] < i) && (i <= sb_groups[c]))c	 	       {m2 		 sbgr = c;  /* search the valid subband group */	 		 break;l 		}] 	     },   K         if (info->tc_aug_alloc[sbgr] == 4 || info->tc_aug_alloc[sbgr] == 5) #     	  if (info->dyn_cross_LR == 0)_ 	    T6T1 = 0; 	  elsea 	    T6T0 = 1;P         else if (info->tc_aug_alloc[sbgr] == 6 || info->tc_aug_alloc[sbgr] == 7)!           if (info->dyn_cross_LR)< 	    T5T0 = 1;  ) 	 /* read bitalloc info from bitstream */ ) 	 switch (info->dyn_cross_aug_mode[sbgr])  	 {>3 	 case  0:   /* T5 and T6 contains bitalloc info */*V 		    actual_alloc[5][i] = bit_alloc[5][i] = (char) getbits (bs, (*alloc)[i][0].bits);V 		    actual_alloc[6][i] = bit_alloc[6][i] = (char) getbits (bs, (*alloc)[i][0].bits); 		    break;, 	 case  1:   /* T5 contains bitalloc info */
 	 case  2:
 	 case  3:
 	 case  4:V 		    actual_alloc[5][i] = bit_alloc[5][i] = (char) getbits (bs, (*alloc)[i][0].bits); 		    break;  l, 	 case  5:   /* T6 contains bitalloc info */
 	 case 10:
 	 case 14:V 		    actual_alloc[6][i] = bit_alloc[6][i] = (char) getbits (bs, (*alloc)[i][0].bits); 		    break; 	 };   . 	 /* copy bitalloc info from other channels */) 	 switch (info->dyn_cross_aug_mode[sbgr])y 	 {s" 	 case  1:   /* copy T6 from T1 */+ 		    bit_alloc[6][i] = bit_alloc[T6T1][i];e 		    break;" 	 case  2:   /* copy T6 from T2 */( 		    bit_alloc[6][i] = bit_alloc[2][i]; 		    break;" 	 case  3:   /* copy T6 from T4 */( 		    bit_alloc[6][i] = bit_alloc[4][i]; 		    break;" 	 case  4:   /* copy T6 from T5 */( 		    bit_alloc[6][i] = bit_alloc[5][i]; 		    break;" 	 case  5:   /* copy T5 from T0 */+ 		    bit_alloc[5][i] = bit_alloc[T5T0][i];[ 		    break;1 	 case  6:   /* copy T5 from T0 and T6 from T1 */ + 		    bit_alloc[5][i] = bit_alloc[T5T0][i];c+ 		    bit_alloc[6][i] = bit_alloc[T6T1][i];i 		    break;1 	 case  7:   /* copy T5 from T0 and T6 from T2 */e+ 		    bit_alloc[5][i] = bit_alloc[T5T0][i];d( 		    bit_alloc[6][i] = bit_alloc[2][i]; 		    break;1 	 case  8:   /* copy T5 from T0 and T6 from T4 */o+ 		    bit_alloc[5][i] = bit_alloc[T5T0][i];g( 		    bit_alloc[6][i] = bit_alloc[4][i]; 		    break;) 	 case  9:   /* copy T5 and T6 from T0 */ + 		    bit_alloc[5][i] = bit_alloc[T5T0][i];e+ 		    bit_alloc[6][i] = bit_alloc[T6T0][i];i 		    break;" 	 case 10:   /* copy T5 from T2 */( 		    bit_alloc[5][i] = bit_alloc[2][i]; 		    break;1 	 case 11:   /* copy T5 from T2 and T6 from T1 */c( 		    bit_alloc[5][i] = bit_alloc[2][i];+ 		    bit_alloc[6][i] = bit_alloc[T6T1][i];  		    break;) 	 case 12:   /* copy T5 and T6 from T2 */]: 		    bit_alloc[5][i] = bit_alloc[6][i] = bit_alloc[2][i]; 		    break;1 	 case 13:   /* copy T5 from T2 and T6 from T4 */ ( 		    bit_alloc[5][i] = bit_alloc[2][i];( 		    bit_alloc[6][i] = bit_alloc[4][i]; 		    break;" 	 case 14:   /* copy T5 from T3 */( 		    bit_alloc[5][i] = bit_alloc[3][i]; 		    break;1 	 case 15:   /* copy T5 from T3 and T6 from T1 */ ( 		    bit_alloc[5][i] = bit_alloc[3][i];+ 		    bit_alloc[6][i] = bit_alloc[T6T1][i];[ 		    break;1 	 case 16:   /* copy T5 from T3 and T6 from T2 */{( 		    bit_alloc[5][i] = bit_alloc[3][i];( 		    bit_alloc[6][i] = bit_alloc[2][i]; 		    break;1 	 case 17:   /* copy T5 from T3 and T6 from T4 */o( 		    bit_alloc[5][i] = bit_alloc[3][i];( 		    bit_alloc[6][i] = bit_alloc[4][i]; 		    break;) 	 case 18:   /* copy T5 and T6 from T3 */a: 		    bit_alloc[5][i] = bit_alloc[6][i] = bit_alloc[3][i]; 		    break; 	 }0       }   "    for (i=sblimit; i<SBLIMIT; i++)       for (j=*l; j<*m; j++)  	 bit_alloc[j][i] = 0;      if (bits_log)    {       for (j= *l; j < *m; j++)&          for (i = 0; i < SBLIMIT; i++) 	 {b4 	    int alloc_bits = 0, alloc_id = bit_alloc[j][i];    	    if (actual_alloc[j][i] > 0)S 	       alloc_bits = 12 * (*alloc)[i][alloc_id].bits * (*alloc)[i][alloc_id].group;   ? 	    printf ("alloc_bi[ %d ][ %2d ]= %3d\n", j, i, alloc_bits);> 	 }r    } }c #endif  * void II_decode_bitalloc_ml(Bit_stream *bs, 			   frame_params *fr_ps,- 			   unsigned int bit_alloc_ml[7][SBLIMIT],	r
 			   int *m)] {3    int i,j;a&    int sblimit_ml = fr_ps->sblimit_ml;(    al_table *alloc_ml = fr_ps->alloc_ml;  ;    /* JR: no dynamic crosstalk for multilingual channels */L?    /* JR: no phantom center coding for multilingual channels */s6    /* JR: no joint coding for multilingual channels */0    /* JR: they're really simple, aren't they? */      for (i=0;i<sblimit_ml;i++)      for (j=0;j<*m;j++)  F      bit_alloc_ml[j][i] = (char) getbits (bs, (*alloc_ml)[i][0].bits);$    for (i=sblimit_ml;i<SBLIMIT;i++)      for (j=0;j<*m;j++)        bit_alloc_ml[j][i] = 0; }   B /***************************************************************** /*5 /* The following two functions implement the layer II > /* format of scale factor extraction. Layer I involves reading? /* 6 bit per subband as scale factor. Layer II requires reading E /* first the scfsi which in turn indicate the number of scale factors  /* transmitted.b /*   Layer II : II_decode_scale= /*H /*************************** Layer II stuff ***************************/9 /* 28.9.93 R.S. reading of the prediction coefficients */]9 /* 03.6.94 R.S. read pred-coef. due to MPEG 2 - DIS    */iH /**********************************************************************/H /* JMZ 09/03/1995 Multilingual adaptations , WtK 7/8/95               */H /**********************************************************************/  & void I_decode_scale (Bit_stream   *bs, 		     frame_params *fr_ps, + 		     unsigned int bit_alloc[7][SBLIMIT],	]0 		     unsigned int scale_index[7][3][SBLIMIT],	 		     int	  part, 		     int	  scf_log)s {     int i,j;     int stereo = fr_ps->stereo;     int sblimit = fr_ps->sblimit;      for (i=0; i<SBLIMIT; i++)       for (j=0;j<stereo;j++) 	 if (!bit_alloc[j][i])b- 	    scale_index[j][part][i] = SCALE_RANGE-1;i6 	 else                    /* 6 bit per scale factor *// 	    scale_index[j][part][i] = getbits (bs, 6);  }e  % void II_decode_scale (Bit_stream *bs,i 		      frame_params *fr_ps,* 		      unsigned int scfsi[7][SBLIMIT], 		, 		      unsigned int bit_alloc[7][SBLIMIT],	1 		      unsigned int scale_index[7][3][SBLIMIT],	i& 		      int *l, int *m, int scfsi_log) {)      layer *info = fr_ps->header;     int stereo = fr_ps->stereo;      int i,j;     int px,pci;c!     int sblimit = fr_ps->sblimit;        if (*m == stereo)  	sblimit = fr_ps->sblimit;     else!     	sblimit = fr_ps->sblimit_mc;   "     for (i = 0; i < sblimit; i++)      { . 	for (j = *l; j < *m; j++)   /* 2 bit scfsi */ 	    if (bit_alloc[j][i]) ( 	 	scfsi[j][i] = (char) getbits (bs, 2);	 	    else  		scfsi[j][i] = 4;     }   (     for (i = sblimit; i < SBLIMIT; i++)  	for (j = *l; j < *m; j++) 	    scfsi[j][i] = 4;        if (scfsi_log)     {S 	for (j= *l; j < *m; j++)*" 	    for (i = 0; i < SBLIMIT; i++) 	    { 		int scf_bits;       		switch (scfsi[j][i]) 		{)/ 		    /* all three scale factors transmitted */  		    case 0 : scf_bits = 20;  			     break;) 		    /* two scale factors transmitted */  		    case 1 : 		    case 3 : scf_bits = 14;s 			     break;- 		    /* only one scale factor transmitted */] 		    case 2 : scf_bits = 8; 			     break;( 		    /* no scale factors transmitted */ 		    default : scf_bits = 0;a 		},: 		printf ("scf_bits[ %d ][ %2d ]= %3d\n", j, i, scf_bits); 	    }     }	  G     /* 3.6.94 R.S. read the prediction coefficients in the mc - part */r     if (*m > stereo && *m < 7)* 	if (fr_ps->header->mc_prediction_on == 1) 	    for (i = 0; i < 8; i++)+ 		if (fr_ps->header->mc_prediction[i] == 1)cb 		    for (px = 0; px < pred_coef_table[fr_ps->pred_mode][fr_ps->header->dyn_cross_mode[i]]; px++), 			if (fr_ps->header->mc_predsi[i][px] != 0) 			{& 			    /* predictors are transfered */= 			    fr_ps->header->mc_delay_comp[i][px] = getbits (bs, 3);+B 			    for (pci = 0; pci < fr_ps->header->mc_predsi[i][px]; pci++)? 				fr_ps->header->mc_pred_coeff[i][px][pci] = getbits (bs, 8);  			} 			else  			{  			    /* no prediction coef. */O 			    fr_ps->header->mc_pred_coeff[i][px][0] = 127;     /* Index 127 -> 0.0 */b/ 			    fr_ps->header->mc_delay_comp[i][px] = 0;  			}  $     /* 31/10/95 Ralf Schwalbe LFE */     if (*l == stereo)  	if (info->lfe)  	    if (info->lfe_alloc)a" 		info->lfe_scf = getbits (bs, 6);  "     for (i = 0; i < sblimit; i++)  	for (j = *l; j < *m; j++) 	    if (bit_alloc[j][i]); 		switch (scfsi[j][i]) 		{u/ 		    /* all three scale factors transmitted */ 6 		    case 0 : scale_index[j][0][i] = getbits (bs, 6);/ 			     scale_index[j][1][i] = getbits (bs, 6);w/ 			     scale_index[j][2][i] = getbits (bs, 6);a 			     break;* 		    /* scale factor 1 & 3 transmitted */% 		    case 1 : scale_index[j][0][i] =r/ 			     scale_index[j][1][i] = getbits (bs, 6);l/ 			     scale_index[j][2][i] = getbits (bs, 6);b 			     break;* 		    /* scale factor 1 & 2 transmitted */6 		    case 3 : scale_index[j][0][i] = getbits (bs, 6); 			     scale_index[j][1][i] =/ 			     scale_index[j][2][i] = getbits (bs, 6);] 			     break;- 		    /* only one scale factor transmitted */l% 		    case 2 : scale_index[j][0][i] =  			     scale_index[j][1][i] =/ 			     scale_index[j][2][i] = getbits (bs, 6);; 			     break;& 		    default : scale_index[j][0][i] = 			      scale_index[j][1][i] =>. 			      scale_index[j][2][i] = SCALE_RANGE-1; 			      break;  		}		 	    elseoU 		scale_index[j][0][i] = scale_index[j][1][i] = scale_index[j][2][i] = SCALE_RANGE-1;   '     for (i = sblimit; i < SBLIMIT; i++)r 	for (j = *l; j < *m; j++)X 	    scale_index[j][0][i] = scale_index[j][1][i] = scale_index[j][2][i] = SCALE_RANGE-1; }   H /**********************************************************************/H /* JMZ 15/03/1995 Multilingual                                        */H /**********************************************************************/  ' void II_decode_scale_ml(Bit_stream *bs,  		        frame_params *fr_ps,, 		        unsigned int scfsi[7][SBLIMIT], 		. 		        unsigned int bit_alloc[7][SBLIMIT],	3 		        unsigned int scale_index[7][3][SBLIMIT],	_ 		        int *m)  {a    int i,j;:    int px,pci;&    int sblimit_ml = fr_ps->sblimit_ml;    D    for (i=0;i<sblimit_ml;i++) for (j=0;j<*m;j++)   /* 2 bit scfsi */ 	if (bit_alloc[j][i])  		{ ) 	  	scfsi[j][i] = (char) getbits (bs, 2);[ 	  	}  	else scfsi[j][i] = 4;6    for (i=sblimit_ml;i<SBLIMIT;i++) for (j=0;j<*m;j++) 	scfsi[j][i] = 4;o  >    for (i = 0; i < sblimit_ml; i++) for (j = 0; j < *m; j++) { 	  if (bit_alloc[j][i])o 	    switch (scfsi[j][i]) {*, 		 /* all three scale factors transmitted */3 		 case 0 : scale_index[j][0][i] = getbits (bs, 6);r, 			  scale_index[j][1][i] = getbits (bs, 6);, 			  scale_index[j][2][i] = getbits (bs, 6); 			  break;i' 		 /* scale factor 1 & 3 transmitted */ " 		 case 1 : scale_index[j][0][i] =, 			  scale_index[j][1][i] = getbits (bs, 6);, 			  scale_index[j][2][i] = getbits (bs, 6); 			  break; . 	         /* scale factor 1 & 2 transmitted */3 		 case 3 : scale_index[j][0][i] = getbits (bs, 6);r 			  scale_index[j][1][i] = , 			  scale_index[j][2][i] = getbits (bs, 6);          		  break;l* 		 /* only one scale factor transmitted */) 	         case 2 : scale_index[j][0][i] = " 		          scale_index[j][1][i] =3 		          scale_index[j][2][i] = getbits (bs, 6);;          		  break;y# 		 default : scale_index[j][0][i] = # 		           scale_index[j][1][i] =	2 		           scale_index[j][2][i] = SCALE_RANGE-1;          		   break;           }o           else {G                           scale_index[j][0][i] = scale_index[j][1][i] = 8 	                  scale_index[j][2][i] = SCALE_RANGE-1; 	  }    }  8    for (i=sblimit_ml;i<SBLIMIT;i++) for (j=0;j<*m;j++) {9 		          scale_index[j][0][i] = scale_index[j][1][i] =T1 		          scale_index[j][2][i] = SCALE_RANGE-1;i    } }]  ? /**************************************************************  /*6 /* The following two routines take care of reading the5 /* compressed sample from the bit stream for layer 2.l4 /* For layer 1, read the number of bits as indicated< /* by the bit_alloc information. For layer 2, if grouping is? /* indicated for a particular subband, then the sample size hasi< /* to be read from the bits_group and the merged samples has> /* to be decompose into the three distinct samples. Otherwise,# /* it is the same for as layer one.R /*E /*************************** Layer II stuff ************************/t  % void I_buffer_sample (Bit_stream *bs,/ 		      frame_params *fr_ps,+ 		      unsigned int sample[7][3][SBLIMIT],++ 		      unsigned int bit_alloc[7][SBLIMIT])m {]
    int i,j,k;t    int stereo = fr_ps->stereo;     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;    unsigned int s;      for (i=0; i<jsbound; i++)       for (j=0; j<stereo; j++)! 	 if ((k = bit_alloc[j][i]) == 0)o 	    sample[j][0][i] = 0;t 	 else r8 	    sample[j][0][i] = (unsigned int) getbits (bs, k+1);  "    for (i=jsbound; i<SBLIMIT; i++)    {%       if ((k = bit_alloc[0][i]) == 0)r 	 s = 0;       else u' 	 s = (unsigned int) getbits (bs, k+1);          for (j=0; j<stereo; j++) 	 sample[j][0][i] = s;    } }*  & void II_buffer_sample (Bit_stream *bs, 		       frame_params *fr_ps,R, 		       unsigned int sample[7][3][SBLIMIT],, 		       unsigned int bit_alloc[7][SBLIMIT]) {     int i,j,k,m;*    int stereo = fr_ps->stereo;     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc;      for (i=0;i<sblimit;i++).       for (j= 0;j<((i<jsbound)? stereo:1);j++)       {I 	   if (bit_alloc[j][i]) 	   { & 		 /* check for grouping in subband */- 		 if ((*alloc)[i][bit_alloc[j][i]].group==3)g 	 	 {  			for (m=0;m<3;m++) 			{+ 			  k = (*alloc)[i][bit_alloc[j][i]].bits; 6 			  sample[j][m][i] = (unsigned int) getbits (bs, k); 			 }t 		 } 		 elsei! 		 {    /* bit_alloc = 3, 5, 9 */  		   unsigned int nlevels, c=0;f  2 		   nlevels = (*alloc)[i][bit_alloc[j][i]].steps;) 		   k=(*alloc)[i][bit_alloc[j][i]].bits;*( 		   c = (unsigned int) getbits (bs, k);   		   for (k=0;k<3;k++) 		   {" 			 sample[j][k][i] = c % nlevels; 			 c /= nlevels;  		   } 		 } 	   }  	   else* 	   {      /* for no sample transmitted */) 		 for (k=0;k<3;k++) sample[j][k][i] = 0;  	   }dD 	   if(stereo == 2 && i>= jsbound)  /* joint stereo : copy L to R */8 		  for (k=0;k<3;k++) sample[1][k][i] = sample[0][k][i];       }>&    for (i = sblimit; i < SBLIMIT; i++) 	 for (j = 0; j < stereo; j++) 		for (k = 0; k < 3; k++)o 		   sample[j][k][i] = 0;i }   G /******************** mc - layer2 stuff ******************************/; /* 19.10.93 R.S. */(  ) void II_buffer_sample_mc (Bit_stream *bs,  			  frame_params *fr_ps,s( 			  unsigned int sample[7][3][SBLIMIT],( 			  unsigned int bit_alloc[7][SBLIMIT],( 			  int ch_start, int channels, int gr) {     layer *info = fr_ps->header;[    int i,j,k,m,sbgr,l;    unsigned int nlevels, c=0;<#    int sblimit = fr_ps->sblimit_mc;M    int transmitted;n%    al_table *alloc = fr_ps->alloc_mc;i  #    /* 31/10/95 Ralf Schwalbe LFE */o0    /* 961003 FdB LFE number of bits corrected */'    if(info->lfe && info->lfe_alloc > 0)oD 	info->lfe_spl[gr] = (unsigned int) getbits (bs, info->lfe_alloc+1);       for (i = 0; i < sblimit; i++)    { 	  if( i == 0) sbgr = 0 ;a 	  elsef 	     for(l = 1; l < 12; l++) 1 		if((sb_groups[l-1] < i) && (i <= sb_groups[l]))  		{_ 		   sbgr = l; break;n 		}s  ' 	 for (j = ch_start; j < channels; j++)s 	 {  	   if (bit_alloc[j][i]) 	   {. 	     transmitted = 1;+ 	     if (fr_ps->header->dyn_cross_on == 1)s 	     {*% 		if (fr_ps->dyn_cross_bits == 4 && (o7 			(fr_ps->header->dyn_cross_mode[sbgr]==1  && j==4) ||a7 			(fr_ps->header->dyn_cross_mode[sbgr]==2  && j==3) ||d7 			(fr_ps->header->dyn_cross_mode[sbgr]==3  && j==2) ||d7 			(fr_ps->header->dyn_cross_mode[sbgr]==4  && j!=2) ||)7 			(fr_ps->header->dyn_cross_mode[sbgr]==5  && j!=3) ||_7 			(fr_ps->header->dyn_cross_mode[sbgr]==6  && j!=4) || . 			(fr_ps->header->dyn_cross_mode[sbgr]==7) ||7 			(fr_ps->header->dyn_cross_mode[sbgr]==8  && j==4) ||c7 			(fr_ps->header->dyn_cross_mode[sbgr]==9  && j==3) ||o7 			(fr_ps->header->dyn_cross_mode[sbgr]==10 && j==4) ||[7 			(fr_ps->header->dyn_cross_mode[sbgr]==11 && j!=2) ||s7 			(fr_ps->header->dyn_cross_mode[sbgr]==12 && j!=2) ||07 			(fr_ps->header->dyn_cross_mode[sbgr]==13 && j!=3) ||f4 			(fr_ps->header->dyn_cross_mode[sbgr]==14 && j!=2) 					          ))   		   transmitted = 0;		/* 3/2 */% 		if (fr_ps->dyn_cross_bits == 3 && ( 7 			(fr_ps->header->dyn_cross_mode[sbgr]==1  && j==3) ||*7 			(fr_ps->header->dyn_cross_mode[sbgr]==2  && j==2) ||s. 			(fr_ps->header->dyn_cross_mode[sbgr]==3) ||4 			(fr_ps->header->dyn_cross_mode[sbgr]==4  && j==3)
 						  ))( 		   transmitted = 0;		/* 3/1 and 2/2 */S 		if (fr_ps->dyn_cross_bits == 1 && fr_ps->header->dyn_cross_mode[sbgr]==1 && j==2)	/ 		   transmitted = 0;		/* 3/0 (+2/0) and 2/1 */	R 		if (fr_ps->header->surround == 3 && fr_ps->header->dyn_second_stereo[sbgr] == 1) 		{ N 		   if ((fr_ps->header->center == 1 || fr_ps->header->center == 3) && j == 4) 	              transmitted = 0; : 	           else if (fr_ps->header->center == 0 && j == 3) 	              transmitted = 0;s 		}d 	     }  	   }2 	   else 	      transmitted = 0;    	   if (transmitted == 1)  	   {_% 		/* check for grouping in subband */ , 		if ((*alloc)[i][bit_alloc[j][i]].group==3) 		{  			for (m=0;m<3;m++) 			{* 				k = (*alloc)[i][bit_alloc[j][i]].bits;5 				sample[j][m][i] = (unsigned int) getbits (bs, k);n 			} 		}] 		else 		{	/* bit_alloc = 3, 5, 9 */]0 			nlevels = (*alloc)[i][bit_alloc[j][i]].steps;' 			k=(*alloc)[i][bit_alloc[j][i]].bits; & 			c = (unsigned int) getbits (bs, k); 			for (k=0;k<3;k++) 			{" 				sample[j][k][i] = c % nlevels; 				c /= nlevels;* 			} 		}* 	   }*' 	   else   /* no samples transmitted *// 	      for (k=0; k<3; k++) 		 sample[j][k][i] = 0;  	 }  /* for channel loop */*    }  /* for sblimit loop */  &    for (i = sblimit; i < SBLIMIT; i++)' 	 for (j = ch_start; j < channels; j++)_/ 		for (k = 0; k < 3; k++)  sample[j][k][i] = 0;B }I   #ifdef Augmentation_7chi) void II_buffer_sample_aug(Bit_stream *bs,n 			frame_params *fr_ps,S& 			unsigned int sample[7][3][SBLIMIT],& 			unsigned int bit_alloc[7][SBLIMIT],
 			int gr) {l    int i,j,k,m,sbgr,l;    unsigned int nlevels, c=0;*#    int sblimit = fr_ps->sblimit_mc;a    int transmitted; %    al_table *alloc = fr_ps->alloc_mc;[       for (i = 0; i < sblimit; i++)    {       if( i == 0) sbgr = 0;o
       else 	 for(l = 1; l < 12; l++) 4 	    if((sb_groups[l-1] < i) && (i <= sb_groups[l])) 	    { 	       sbgr = l; break; 	    }         for (j = 5; j < 7; j++)        {l 	 if (bit_alloc[j][i]) 	 {c 	    transmitted = 1;0. 	    if (fr_ps->header->aug_dyn_cross_on == 1) 	    { 	       if (j == 5)s	 	       {j4 		  if (fr_ps->header->dyn_cross_aug_mode[sbgr] > 4) 		     transmitted = 0;*	 	       }  	       else	 	       {= 		  transmitted = 0;4 		  switch (fr_ps->header->dyn_cross_aug_mode[sbgr]) 		  {  		  case  0: 		  case  5: 		  case 10: 		  case 14: 			   transmitted = 1; 			   break; 		  }[	 	       }s 	    } 	 }	 	 else 	    transmitted = 0;    	 if (transmitted == 1)b 	 {b* 	      /* check for grouping in subband */1 	      if ((*alloc)[i][bit_alloc[j][i]].group==3)a 	      { 		      for (m=0;m<3;m++)l	 		      {1/ 			      k = (*alloc)[i][bit_alloc[j][i]].bits;s: 			      sample[j][m][i] = (unsigned int) getbits (bs, k);	 		      }  	      } 	      elsex" 	      {	/* bit_alloc = 3, 5, 9 */5 		      nlevels = (*alloc)[i][bit_alloc[j][i]].steps; , 		      k=(*alloc)[i][bit_alloc[j][i]].bits;+ 		      c = (unsigned int) getbits (bs, k);[ 		      for (k=0;k<3;k++) 	 		      {x' 			      sample[j][k][i] = c % nlevels;  			      c /= nlevels;	 		      }  	      } 	 }+% 	 else   /* no samples transmitted */= 	    for (k=0; k<3; k++) 	       sample[j][k][i] = 0;       }  /* for channel loop */     }  /* for sblimit loop */  &    for (i = sblimit; i < SBLIMIT; i++) 	 for (j = 5; j < 7; j++) / 		for (k = 0; k < 3; k++)  sample[j][k][i] = 0;o }h #endif  A /***************************************************************/t! /* 09/03/1995 JMZ Multilingual */.  A /***************************************************************/t /* 15/03/1995 JMZ */  ( void II_buffer_sample_ml(Bit_stream *bs, 			 frame_params *fr_ps,* 			 unsigned int sample_ml[7][3][SBLIMIT],* 			 unsigned int bit_alloc_ml[7][SBLIMIT], 			 int *n_ml_ch)* {*    int i,j,k,m,sbgr,l;    unsigned int nlevels, c=0;*&    int sblimit_ml = fr_ps->sblimit_ml;(    al_table *alloc_ml = fr_ps->alloc_ml;  #    for (i = 0; i < sblimit_ml; i++)+    {  	 for (j = 0; j < *n_ml_ch; j++) 	 {m 	   if (bit_alloc_ml[j][i])s 	   { : 		/* JR: no dynamic crosstalk for multilingual channels */% 		/* check for grouping in subband */ 2 		if ((*alloc_ml)[i][bit_alloc_ml[j][i]].group==3) 		{r   			for (m=0;m<3;m++) 			{0 				k = (*alloc_ml)[i][bit_alloc_ml[j][i]].bits;8 				sample_ml[j][m][i] = (unsigned int) getbits (bs, k); 			}   		}( 		else  		{    /* bit_alloc = 3, 5, 9 */7 		  nlevels = (*alloc_ml)[i][bit_alloc_ml[j][i]].steps; . 		  k=(*alloc_ml)[i][bit_alloc_ml[j][i]].bits;' 		  c = (unsigned int) getbits (bs, k);i 		  for (k=0;k<3;k++)d 		  {f$ 			sample_ml[j][k][i] = c % nlevels; 			c /= nlevels; 		  }  		}u 	   }  	   else* 	   {      /* for no sample transmitted */, 		 for (k=0;k<3;k++) sample_ml[j][k][i] = 0; 	   }e 	 }r    }  )    for (i = sblimit_ml; i < SBLIMIT; i++)i  	 for (j = 0; j < *n_ml_ch; j++) 		for (k = 0; k < 3; k++)o 		   sample_ml[j][k][i] = 0; }   ? /**************************************************************i /*9 /*   Restore the compressed sample to a factional number. + /*   first complement the MSB of the sampleg /*    for layer I :;1 /*    Use s = (s' + 2^(-nb+1) ) * 2^nb / (2^nb-1)] /*   for Layer II :[# /*   Use the formula s = s' * c + d, /*@ /**************************************************************/  D static double c[17] = { 1.33333333333, 1.60000000000, 1.14285714286,2 						1.77777777777, 1.06666666666, 1.03225806452,2 						1.01587301587, 1.00787401575, 1.00392156863,2 						1.00195694716, 1.00097751711, 1.00048851979,2 						1.00024420024, 1.00012208522, 1.00006103888,% 						1.00003051851, 1.00001525902 };   K static double d[17] = { 0.500000000, 0.500000000, 0.250000000, 0.500000000,e9 						0.125000000, 0.062500000, 0.031250000, 0.015625000,	: 						0.007812500, 0.003906250, 0.001953125, 0.0009765625,2 						0.00048828125, 0.00024414063, 0.00012207031,% 						0.00006103516, 0.00003051758 };   D /************************** Layer II stuff ************************/  = void I_dequantize_sample (unsigned int sample[7][3][SBLIMIT],. 			  int part,( 			  unsigned int bit_alloc[7][SBLIMIT],( 			  double fraction[7][SBLIMIT][3][12],! 			  frame_params *fr_ps, int *z)  {     int i, nb, k, gr_id, gr_sam;c    int stereo = fr_ps->stereo;     int sblimit = fr_ps->sblimit;      gr_id = 4*part + (*z / 3);s    gr_sam = *z % 3;0      for (i=0; i<SBLIMIT; i++)       for (k=0; k<stereo; k++) 	 if (bit_alloc[k][i]) 	 {l 	    nb = bit_alloc[k][i] + 1;. 	    if (((sample[k][0][i] >> nb-1) & 1) == 1), 	       fraction[k][i][gr_sam][gr_id] = 0.0;	 	    else0- 	       fraction[k][i][gr_sam][gr_id] = -1.0;   R 	    fraction[k][i][gr_sam][gr_id] += (double) (sample[k][0][i] & ((1<<nb-1)-1)) / 		 (double) (1L<<nb-1);   $ 	    fraction[k][i][gr_sam][gr_id] =H 		 (double) (fraction[k][i][gr_sam][gr_id] + 1.0 / (double)(1L<<nb-1)) *1 		     (double) (1L<<nb) / (double) ((1L<<nb)-1);  	 }( 	 else) 	    fraction[k][i][gr_sam][gr_id] = 0.0;  } > void II_dequantize_sample (unsigned int sample[7][3][SBLIMIT],) 			   unsigned int bit_alloc[7][SBLIMIT],-) 			   double fraction[7][SBLIMIT][3][12],(" 			   frame_params *fr_ps, int *z) {     int i, j, k, x;    int stereo = fr_ps->stereo;     int sblimit = fr_ps->sblimit;"    al_table *alloc = fr_ps->alloc;  K    for (i=0;i<sblimit;i++)  for (j=0;j<3;j++) for (k = 0; k < stereo ; k++)a 	 if (bit_alloc[k][i]) 	 { " 	   /* locate MSB in the sample */
 	   x = 0;
 #ifndef MSDOS	= 	   while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;p #elsee. 	   /* microsoft C thinks an int is a short */, 	   while (( (unsigned long) (1L<<(long)x) <8 				(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps) 			  ) && ( x < 16) ) x++; #endif   	   /* MSB inversion */ . 	   if (((sample[k][j][i] >> (x-1)) & 1) == 1)  		  fraction[k][i][j][*z] = 0.0;' 	   else  fraction[k][i][j][*z] = -1.0;   & 	   /* Form a 2's complement sample */J 	   fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) / 							(double) (1L<<(x-1));   	   /* Dequantize the sample */ C 	   fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];pC 	   fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];i 	 }=# 	 else fraction[k][i][j][*z] = 0.0;d       for (i=sblimit;i<SBLIMIT;i++) 	  for (j=0;j<3;j++) 		 for(k = 0; k < stereo; k++)  			 fraction[k][i][j][*z] = 0.0; }(    G /************************** MC Layer II stuff ************************/   A void II_dequantize_sample_mc (unsigned int sample[7][3][SBLIMIT],=, 			      unsigned int bit_alloc[7][SBLIMIT],, 			      double fraction[7][SBLIMIT][3][12],A 			      frame_params *fr_ps, int ch_start, int channels, int *z)  {     int i, j, k, x,sbgr,l;i#    int sblimit = fr_ps->sblimit_mc;1%    al_table *alloc = fr_ps->alloc_mc;s       for (i = 0; i < sblimit; i++)    { 	if (i == 0) sbgr = 0; 	else= 	   for (l = 1; l < 12; l++)2 		if ((sb_groups[l-1] < i) && (i <= sb_groups[l])) 		{s 		    sbgr = l; break; 		}    	for (j = 0; j < 3; j++)* 	    for (k = ch_start; k < channels; k++) 		if (bit_alloc[k][i]) 		{ + 		    if (fr_ps->header->dyn_cross_on == 0)c 		    {n! 			/* locate MSB in the sample */=	 			x = 0; 
 #ifndef MSDOSe9 			while ((1L << x) < (*alloc)[i][bit_alloc[k][i]].steps)  			    x++;e #elseo- 			/* microsoft C thinks an int is a short */ - 			while (((unsigned long) (1L << (long) x) <nC 			        (unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)) &&< 			       (x < 16))  			    x++;; #endif 			/* MSB inversion */- 			if (((sample[k][j][i] >> (x-1)) & 1) == 1)i# 			    fraction[k][i][j][*z] = 0.0;r 			else $ 			    fraction[k][i][j][*z] = -1.0;  % 			/* Form a 2's complement sample */MI 			fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /m  						     (double) (1L<<(x-1));   			/* Dequantize the sample */B 			fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];B 			fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant]; 		    } 9 		    else   /* 21.07.94 Ralf Schwalbe dyn. cross mode */l 		    {&% 			if (fr_ps->dyn_cross_bits == 4  && 3 			    ((fr_ps->header->dyn_cross_mode[sbgr]==0) ||j< 			     (fr_ps->header->dyn_cross_mode[sbgr]==1  && k!=4) ||< 			     (fr_ps->header->dyn_cross_mode[sbgr]==2  && k!=3) ||< 			     (fr_ps->header->dyn_cross_mode[sbgr]==3  && k!=2) ||< 			     (fr_ps->header->dyn_cross_mode[sbgr]==8  && k!=4) ||< 			     (fr_ps->header->dyn_cross_mode[sbgr]==9  && k!=3) ||; 			     (fr_ps->header->dyn_cross_mode[sbgr]==10 && k!=4)))  			{
 			    x = 0; 
 #ifndef MSDOSa= 			    while ((1L << x) < (*alloc)[i][bit_alloc[k][i]].steps)s 				x++; #else 1 			    /* microsoft C thinks an int is a short */=1 			    while (((unsigned long) (1L << (long) x) < @ 				    (unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)) && 				   (x < 16)) 				x++; #endif 			    /* MSB inversion */1 			    if (((sample[k][j][i] >> (x-1)) & 1) == 1)=  				fraction[k][i][j][*z] = 0.0; 			    else ! 				fraction[k][i][j][*z] = -1.0;i  ) 			    /* Form a 2's complement sample */oM 			    fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /	 						    (double) (1L<<(x-1));(  " 			    /* Dequantize the sample */F 			    fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];F 			    fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];+ 			}  /* end if 2-channel dyn-cross mode */[  $ 			if (fr_ps->dyn_cross_bits != 4 ||< 			    ((fr_ps->header->dyn_cross_mode[sbgr]==4  && k==2) ||< 			     (fr_ps->header->dyn_cross_mode[sbgr]==5  && k==3) ||< 			     (fr_ps->header->dyn_cross_mode[sbgr]==6  && k==4) ||< 			     (fr_ps->header->dyn_cross_mode[sbgr]==11 && k==2) ||< 			     (fr_ps->header->dyn_cross_mode[sbgr]==12 && k==2) ||< 			     (fr_ps->header->dyn_cross_mode[sbgr]==13 && k==3) ||< 			     (fr_ps->header->dyn_cross_mode[sbgr]==14 && k==2)))  			{a 			     if ((fr_ps->dyn_cross_bits == 3 && ((fr_ps->header->dyn_cross_mode[sbgr] == 1 && k==3) ||h> 								 (fr_ps->header->dyn_cross_mode[sbgr] == 2 && k==2) ||4 								 fr_ps->header->dyn_cross_mode[sbgr] == 3 ||; 								 (fr_ps->header->dyn_cross_mode[sbgr] == 4 && k==3)i
 								)) ||oZ 				 (fr_ps->dyn_cross_bits == 1 && fr_ps->header->dyn_cross_mode[sbgr] == 1 && k == 2) ||T 				 (fr_ps->header->surround == 3 && fr_ps->header->dyn_second_stereo[sbgr] == 1 &&Z 				  ((fr_ps->header->center != 0 && j == 4) || (fr_ps->header->center == 0 && j == 3))))	 			     {[' 				     /* no samples to dequantize */m	 			     }= 			     else	 			     {b
 				x = 0;
 #ifndef MSDOSe: 				while ((1L << x) < (*alloc)[i][bit_alloc[k][i]].steps) 				    x++; #elsei. 				/* microsoft C thinks an int is a short */. 				while (((unsigned long) (1L << (long) x) <= 					(unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)) &&  				       (x < 16)) 				    x++; #endif 				/* MSB inversion */ . 				if (((sample[k][j][i] >> (x-1)) & 1) == 1)$ 				    fraction[k][i][j][*z] = 0.0; 				else% 				    fraction[k][i][j][*z] = -1.0;I  & 				/* Form a 2's complement sample */J 				fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) / 							(double) (1L<<(x-1));   				/* Dequantize the sample */ C 				fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];mC 				fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];s 			    } /* end if ..bits */, 			}   /* end if 1-channel dyn-cross mode */! 		    } /* end if dyn-cross on */* 		} /* if bit_alloc */ 	  	else" 		    fraction[k][i][j][*z] = 0.0;     } '     for (i = sblimit; i < SBLIMIT; i++)4 	for (j = 0; j < 3; j++)* 	    for (k = ch_start; k < channels; k++) 		fraction[k][i][j][*z] = 0.0; }6   #ifdef Augmentation_7ch0B void II_dequantize_sample_aug (unsigned int sample[7][3][SBLIMIT],- 			       unsigned int bit_alloc[7][SBLIMIT],}- 			       double fraction[7][SBLIMIT][3][12],0& 			       frame_params *fr_ps, int *z) {.    int i, j, k, x,sbgr,l;3#    int sblimit = fr_ps->sblimit_mc;2%    al_table *alloc = fr_ps->alloc_mc;5       for (i = 0; i < sblimit; i++)    { 	if( i == 0) sbgr = 0 ;0 	else1 	   for(l = 1; l < 12; l++)*1 		if((sb_groups[l-1] < i) && (i <= sb_groups[l]))* 		{* 		    sbgr = l; break; 		}p 	for (j = 0; j < 3; j++) 	   for ( k = 5; k < 7; k++) 		if (bit_alloc[k][i]) 		{[9 		   if ((fr_ps->header->dyn_cross_aug_mode[sbgr]== 0) || A 		       (fr_ps->header->dyn_cross_aug_mode[sbgr]== 1 && k==5) ||cA 		       (fr_ps->header->dyn_cross_aug_mode[sbgr]== 2 && k==5) || A 		       (fr_ps->header->dyn_cross_aug_mode[sbgr]== 3 && k==5) ||=A 		       (fr_ps->header->dyn_cross_aug_mode[sbgr]== 4 && k==5) ||[A 		       (fr_ps->header->dyn_cross_aug_mode[sbgr]== 5 && k==6) ||0A 		       (fr_ps->header->dyn_cross_aug_mode[sbgr]==10 && k==6) ||.? 		       (fr_ps->header->dyn_cross_aug_mode[sbgr]==14 && k==6))  		   {	 			x = 0;[
 #ifndef MSDOS+< 			while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++; #else)- 			/* microsoft C thinks an int is a short */(+ 			while (( (unsigned long) (1L<<(long)x) </L 			(unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps)) && ( x < 16) ) x++; #endif 			/* MSB inversion */- 			if (((sample[k][j][i] >> (x-1)) & 1) == 1)s% 			      fraction[k][i][j][*z] = 0.0;T& 			else  fraction[k][i][j][*z] = -1.0;  % 			/* Form a 2's complement sample */[I 			fraction[k][i][j][*z] += (double) (sample[k][j][i] & ((1<<(x-1))-1)) /t 						(double) (1L<<(x-1));i   			/* Dequantize the sample */B 			fraction[k][i][j][*z] += d[(*alloc)[i][bit_alloc[k][i]].quant];B 			fraction[k][i][j][*z] *= c[(*alloc)[i][bit_alloc[k][i]].quant];- 		   }  /* end if 2-channel dyn-cross mode */  		} /* if bit_alloc */ 		else! 		   fraction[k][i][j][*z] = 0.0;[    }&    for (i = sblimit; i < SBLIMIT; i++) 	  for (j = 0; j < 3; j++) 		 for(k = 5; k < 7; k++))  			 fraction[k][i][j][*z] = 0.0; }( #endif  K /*************************************************************************/i! /* JMZ 09/03/1995 Multilingual */]  C void II_dequantize_sample_ml(unsigned int sample_ml[7][3][SBLIMIT],r. 			     unsigned int bit_alloc_ml[7][SBLIMIT],. 			     double fraction_ml[7][SBLIMIT][3][12], 			     frame_params *fr_ps, 			     int *n_ml_ch,	 			     int *z)< {-    int i, j, k, x,sbgr,l;h&    int sblimit_ml = fr_ps->sblimit_ml;(    al_table *alloc_ml = fr_ps->alloc_ml;  #    for (i = 0; i < sblimit_ml; i++)c    { 	  for (j = 0; j < 3; j++)" 		 for ( k = 0; k < *n_ml_ch; k++) 			if (bit_alloc_ml[k][i]) 			{ 			  /* JR: ditto */# 			  /* locate MSB in the sample */) 			   x = 0;
 #ifndef MSDOS E 			   while ((1L<<x) < (*alloc_ml)[i][bit_alloc_ml[k][i]].steps) x++;* #else*0 			   /* microsoft C thinks an int is a short */. 			   while (( (unsigned long) (1L<<(long)x) <> 				(unsigned long)( (*alloc_ml)[i][bit_alloc_ml[k][i]].steps) 			   ) && ( x < 16) ) x++;  #endif 			   /* MSB inversion */ 3 			   if (((sample_ml[k][j][i] >> (x-1)) & 1) == 1)m$ 					fraction_ml[k][i][j][*z] = 0.0;, 			   else  fraction_ml[k][i][j][*z] = -1.0;  ( 			   /* Form a 2's complement sample */R 			   fraction_ml[k][i][j][*z] += (double) (sample_ml[k][j][i] & ((1<<(x-1))-1)) / 							(double) (1L<<(x-1));  ! 			   /* Dequantize the sample */ N 			   fraction_ml[k][i][j][*z] += d[(*alloc_ml)[i][bit_alloc_ml[k][i]].quant];N 			   fraction_ml[k][i][j][*z] *= c[(*alloc_ml)[i][bit_alloc_ml[k][i]].quant]; 			} /* if bit_alloc */i' 			else fraction_ml[k][i][j][*z] = 0.0;o    })    for (i = sblimit_ml; i < SBLIMIT; i++)s 	  for (j = 0; j < 3; j++)  		 for(k = 0; k < *n_ml_ch; k++)# 			 fraction_ml[k][i][j][*z] = 0.0;  }   K /**************************************************************************< II_lfe_calc();  R.Schwalbe  K **************************************************************************/ % void II_lfe_calc(frame_params *fr_ps)  {	    layer *info = fr_ps->header;;    int x,i;m%    al_table *alloc = fr_ps->alloc_mc;o      for(i = 0; i < 12; i++)    { 	x = 0; 
 #ifndef MSDOS =    	while ((1L<<x) < (*alloc)[0][info->lfe_alloc].steps) x++;m #else .    	/* microsoft C thinks an int is a short */,    	while (( (unsigned long) (1L<<(long)x) <M    	(unsigned long)( (*alloc)[0][info->lfe_alloc].steps)) && ( x < 16) ) x++;l #endif    	/* MSB inversion */	/    	if (((info->lfe_spl[i] >> (x-1)) & 1) == 1)	'      		info->lfe_spl_fraction[i] = 0.0;]+    	else 	info->lfe_spl_fraction[i] = -1.0;o  &    	/* Form a 2's complement sample */O    	info->lfe_spl_fraction[i] += (double) (info->lfe_spl[i] & ((1<<(x-1))-1)) /o 	 			(double) (1L<<(x-1));      	/* Dequantize the sample */eG    	info->lfe_spl_fraction[i] += d[(*alloc)[0][info->lfe_alloc].quant];&G    	info->lfe_spl_fraction[i] *= c[(*alloc)[0][info->lfe_alloc].quant];        	/* Denormalize the sample */9    	info->lfe_spl_fraction[i] *= multiple[info->lfe_scf];e     }	 }+  = /************************************************************	 /*9 /*   Restore the original value of the sample ie multiplyg, /*    the fraction value by its scalefactor. /*A /************************* Layer II Stuff **********************/	  > void I_denormalize_sample (double fraction[7][SBLIMIT][3][12],. 			   unsigned int scale_index[7][3][SBLIMIT], 			   int part,i 			   frame_params *fr_ps,
 			   int *z)* {     int i, j, k, gr_id, gr_sam;    int stereo = fr_ps->stereo;     int sblimit = fr_ps->sblimit;      gr_id = 4*part + (*z / 3);n    gr_sam = *z % 3;	      for (i=0; i<SBLIMIT; i++)       for (j=0; j<stereo; j++)E 	 fraction[j][i][gr_sam][gr_id] *= multiple[scale_index[j][part][i]];a };  > void II_denormalize_sample(double fraction[7][SBLIMIT][3][12],. 			   unsigned int scale_index[7][3][SBLIMIT], 			   frame_params *fr_ps, 			   int x,
 			   int *z)r {y
    int i,j,k;g    int stereo = fr_ps->stereo;     int sblimit = fr_ps->sblimit;      for (i=0;i<sblimit;i++) 	for (j = 0;j < stereo; j++) 	{; 	  fraction[j][i][0][*z] *= multiple[scale_index[j][x][i]];2; 	  fraction[j][i][1][*z] *= multiple[scale_index[j][x][i]];3; 	  fraction[j][i][2][*z] *= multiple[scale_index[j][x][i]];4 	} }2  D /************************* MC Layer II Stuff **********************/  A void II_denormalize_sample_mc(double fraction[7][SBLIMIT][3][12],c0 			     unsigned int scale_index[7][3][SBLIMIT], 			     frame_params *fr_ps,2 			     int x, int ch_start, int channels, int *z) {=    int i,j,k,sbgr,l,bl=0;o#    int sblimit = fr_ps->sblimit_mc;        for (i = 0; i < sblimit; i++)    {       if (i == 0) sbgr = 0 ;
       else 	for (l = 1; l < 12; l++)n2 		if ((sb_groups[l-1] < i) && (i <= sb_groups[l])) 		{e 			sbgr = l; break;( 		}-  9       /* 960821 FdB new setup for dyn. crosstalk modes */o%       for (bl = 0; bl < 3; bl++)	  		 & 	if (fr_ps->header->dyn_cross_on == 0)' 		for (j = ch_start; j < channels; j++)l< 			fraction[j][i][bl][*z] *= multiple[scale_index[j][x][i]];I 	else if (fr_ps->dyn_cross_bits == 0)   /* for channel mode 2/0 (+2/0) */( 	{A 		if (fr_ps->header->surround == 3)	/* 2/0 + 2/0 and 1/0 + 2/0 */& 		{	J 			fraction[ch_start][i][bl][*z] *= multiple[scale_index[ch_start][x][i]];3 			if (fr_ps->header->dyn_second_stereo[sbgr] == 0)iO 				fraction[ch_start+1][i][bl][*z] *= multiple[scale_index[ch_start+1][x][i]];* 			else'm 				fraction[ch_start+1][i][bl][*z] = (fraction[ch_start][i][bl][*z] / multiple[scale_index[ch_start][x][i]])b4 									 * multiple[scale_index[ch_start+1][x][i]]; 		}r 	}Q 	else if (fr_ps->dyn_cross_bits == 1)   /* for channel mode 3/0 (+2/0) and 2/1 */z 	{. 		switch (fr_ps->header->dyn_cross_mode[sbgr]) 		{ F 		  case 0 :	fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];6 				if (fr_ps->header->surround == 3)		/* 3/0 + 2/0 */ 				{	> 					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];5 					if (fr_ps->header->dyn_second_stereo[sbgr] == 0)(? 						fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]]; 	 					elsefX 						fraction[4][i][bl][*z] = (fraction[3][i][bl][*z] / multiple[scale_index[3][x][i]])- 											 * multiple[scale_index[4][x][i]];	 				}  			  	break;4 		  case 1 :	if (fr_ps->header->tc_alloc[sbgr] == 0)8 					if (fr_ps->header->dyn_cross_LR)	/* C,S from R0 */ X 						fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])/ 							 					 * multiple[scale_index[2][x][i]]; # 				    	else					/* C,S from L0 */gX 						fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]]). 												 * multiple[scale_index[2][x][i]];+ 				if (fr_ps->header->tc_alloc[sbgr] == 1)aW 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])=- 											 * multiple[scale_index[2][x][i]];c+ 				if (fr_ps->header->tc_alloc[sbgr] == 2) W 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])c- 											 * multiple[scale_index[2][x][i]];(6 				if (fr_ps->header->surround == 3)		/* 3/0 + 2/0 */ 				{ > 					fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];5 					if (fr_ps->header->dyn_second_stereo[sbgr] == 0)k? 						fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];*	 					elseiX 						fraction[4][i][bl][*z] = (fraction[3][i][bl][*z] / multiple[scale_index[3][x][i]])- 											 * multiple[scale_index[4][x][i]];i 				}n 		  	break;i 		}_ 	}J 	else if (fr_ps->dyn_cross_bits == 3)   /* for channel mode 3/1 and 2/2 */ 	{. 		switch (fr_ps->header->dyn_cross_mode[sbgr]) 		{o2 		  case 0 :	for (j = ch_start; j < channels; j++)> 					fraction[j][i][bl][*z] *= multiple[scale_index[j][x][i]]; 			  	break;F 		  case 1 :	fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];7 				if (fr_ps->header->surround == 2 ||		/* 2/2 mode */]< 				    fr_ps->header->tc_alloc[sbgr] == 4 ||	/* 3/1 mode */K 				    fr_ps->header->tc_alloc[sbgr] == 5 ||	/* 3/1 mode, matrix mode 2 */ L 				    (fr_ps->header->tc_alloc[sbgr] != 3 && fr_ps->header->dyn_cross_LR)) 					/* S, R or Rs from R0 */rX 					fraction[3][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]]). 											  * multiple[scale_index[3][x][i]]; 				else 					/* S, L or Ls from L0 */*X 					fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]]). 											  * multiple[scale_index[3][x][i]]; 			  	break;F 		  case 2 :	fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];7 				if (fr_ps->header->surround == 2 ||		/* 2/2 mode */ < 				    fr_ps->header->tc_alloc[sbgr] == 1 ||	/* 3/1 mode */K 				    fr_ps->header->tc_alloc[sbgr] == 5 ||	/* 3/1 mode, matrix mode 2 */mM 				    (fr_ps->header->tc_alloc[sbgr] != 2 && !fr_ps->header->dyn_cross_LR))	 					/* C, L or Ls from L0 */)W 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])e- 											 * multiple[scale_index[2][x][i]];  				else 					/* C, R or Rs from RO */[W 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])(- 											 * multiple[scale_index[2][x][i]];  			  	break;@ 		  case 3 :	if (fr_ps->header->surround == 2 ||		/* 2/2 mode */< 				    fr_ps->header->tc_alloc[sbgr] == 1 ||	/* 3/1 mode */K 				    fr_ps->header->tc_alloc[sbgr] == 5 ||	/* 3/1 mode, matrix mode 2 */ M 				    (fr_ps->header->tc_alloc[sbgr] != 2 && !fr_ps->header->dyn_cross_LR))	 					/* C, L or Ls from L0 */ W 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])*- 											 * multiple[scale_index[2][x][i]];] 				else 					/* C, R or Rs from RO */mW 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])q- 											 * multiple[scale_index[2][x][i]];i7 				if (fr_ps->header->surround == 2 ||		/* 2/2 mode */ < 				    fr_ps->header->tc_alloc[sbgr] == 4 ||	/* 3/1 mode */K 				    fr_ps->header->tc_alloc[sbgr] == 5 ||	/* 3/1 mode, matrix mode 2 */*L 				    (fr_ps->header->tc_alloc[sbgr] != 3 && fr_ps->header->dyn_cross_LR)) 					/* S, R or Rs from R0 */*X 					fraction[3][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]]). 											  * multiple[scale_index[3][x][i]]; 				else 					/* S, L or Ls from L0 */sX 					fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]]). 											  * multiple[scale_index[3][x][i]]; 			  	break;= 		  case 4 :	fraction[3][i][bl][*z] = fraction[2][i][bl][*z];n= 				fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];-= 				fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];v 			  	break; 		}( 	}B 	else if (fr_ps->dyn_cross_bits == 4)   /* for channel mode 3/2 */ 	{. 		switch (fr_ps->header->dyn_cross_mode[sbgr]) 		{ 2 		  case 0 :	for (j = ch_start; j < channels; j++)> 					fraction[j][i][bl][*z] *= multiple[scale_index[j][x][i]]; 			  	break; 		  case 1 :	/* C from T2 */= 				fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];(= 				fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];nW 				fraction[4][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])n- 										  * multiple[scale_index[4][x][i]];c 			  	break; 		  case 2 :	/* C from T2 */U 				fraction[2][i][bl][*z] = fraction[2][i][bl][*z] * multiple[scale_index[2][x][i]];lW 				fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])*- 										  * multiple[scale_index[3][x][i]];o= 				fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];	 			  	break;^ 		  case 3 :	if ((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))W 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])>- 											 * multiple[scale_index[2][x][i]];gZ 				else if ((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))W 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])a- 											 * multiple[scale_index[2][x][i]]; 9 				else if (fr_ps->header->dyn_cross_LR)	/* C from RO */sW 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]]);- 											 * multiple[scale_index[2][x][i]];= 				else					/* C from LO */W 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])a- 											 * multiple[scale_index[2][x][i]];]  > 				fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]]; = 				fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];* 			  	break; 		  case 4 :	/* C from T2 */= 				fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];iW 				fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]]),- 										  * multiple[scale_index[3][x][i]];,W 				fraction[4][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]]) - 										  * multiple[scale_index[4][x][i]];  			  	break;^ 		  case 5 :	if ((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))W 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]]))- 											 * multiple[scale_index[2][x][i]]; Z 				else if ((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))W 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]]){- 											 * multiple[scale_index[2][x][i]];2: 				else if (fr_ps->header->dyn_cross_LR)  /* C from RO */W 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]]) - 											 * multiple[scale_index[2][x][i]];m 				else					/* C from LO */W 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])]- 											 * multiple[scale_index[2][x][i]];	  = 				fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]]; W 				fraction[4][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])h- 										  * multiple[scale_index[4][x][i]];	 			  	break;^ 		  case 6 :	if ((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))W 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])	- 											 * multiple[scale_index[2][x][i]];=Z 				else if ((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))W 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])	- 											 * multiple[scale_index[2][x][i]]; 9 				else if (fr_ps->header->dyn_cross_LR)	/* C from RO */]W 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])]- 											 * multiple[scale_index[2][x][i]];_ 				else					/* C from LO */W 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])n- 											 * multiple[scale_index[2][x][i]];i  W 				fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])h- 										  * multiple[scale_index[3][x][i]];i= 				fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];] 			  	break;^ 		  case 7 :	if ((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))W 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])	- 											 * multiple[scale_index[2][x][i]];(Z 				else if ((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))W 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])	- 											 * multiple[scale_index[2][x][i]];49 				else if (fr_ps->header->dyn_cross_LR)	/* C from RO */cW 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])4- 											 * multiple[scale_index[2][x][i]];s 				else					/* C from LO */W 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])r- 											 * multiple[scale_index[2][x][i]];hW 				fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]]);- 										  * multiple[scale_index[3][x][i]];lW 				fraction[4][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]]) - 										  * multiple[scale_index[4][x][i]];m 			  	break; 		  case 8 :	/* C from T2 */= 				fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];r5 				fraction[4][i][bl][*z]  = fraction[3][i][bl][*z]; = 				fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];(= 				fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];	 			  	break; 		  case 9 :	/* C from T2 */4 				fraction[3][i][bl][*z] = fraction[2][i][bl][*z];= 				fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];[= 				fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]]; = 				fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];_ 			  	break; 		  case 10 :	/* C from T2 */o5 				fraction[4][i][bl][*z]  = fraction[2][i][bl][*z];_= 				fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];l= 				fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];s= 				fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];	 			  	break;? 		  case 11 :	fraction[3][i][bl][*z]  = fraction[2][i][bl][*z];[= 				fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];p= 				fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];OW 				fraction[4][i][bl][*z]  = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])i- 										  * multiple[scale_index[4][x][i]];i 			  	break;? 		  case 12 :	fraction[4][i][bl][*z]  = fraction[2][i][bl][*z];d= 				fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]]; W 				fraction[3][i][bl][*z]  = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]]) - 										  * multiple[scale_index[3][x][i]];h= 				fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];a 			  	break;^ 		  case 13:	if ((fr_ps->header->tc_alloc[sbgr] == 1) || (fr_ps->header->tc_alloc[sbgr] == 7))W 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]]) - 											 * multiple[scale_index[2][x][i]];xZ 				else if ((fr_ps->header->tc_alloc[sbgr] == 2) || (fr_ps->header->tc_alloc[sbgr] == 6))W 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]]) - 											 * multiple[scale_index[2][x][i]];*9 				else if (fr_ps->header->dyn_cross_LR)	/* C from RO */lW 					fraction[2][i][bl][*z] = (fraction[1][i][bl][*z] / multiple[scale_index[1][x][i]])t- 											 * multiple[scale_index[2][x][i]];m 				else					/* C from LO */W 					fraction[2][i][bl][*z] = (fraction[0][i][bl][*z] / multiple[scale_index[0][x][i]])s- 											 * multiple[scale_index[2][x][i]];]5 				fraction[4][i][bl][*z]  = fraction[3][i][bl][*z]; = 				fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]];f= 				fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];2 			  	break;? 		  case 14 :	fraction[4][i][bl][*z]  = fraction[2][i][bl][*z]; 5 				fraction[3][i][bl][*z]  = fraction[2][i][bl][*z];} 				/* C from T2 */n= 				fraction[2][i][bl][*z] *= multiple[scale_index[2][x][i]];r= 				fraction[3][i][bl][*z] *= multiple[scale_index[3][x][i]]; > 				fraction[4][i][bl][*z] *= multiple[scale_index[4][x][i]];	
 				break; 		}[ 	}    } /* for sblimit */ }a   #ifdef Augmentation_7ch	B void II_denormalize_sample_aug(double fraction[7][SBLIMIT][3][12],0 			     unsigned int scale_index[7][3][SBLIMIT], 			     frame_params *fr_ps, 			     int x, 			     int *z)u {p    layer *info = fr_ps->header;	    int i,j,k,sbgr,l,bl=0;x#    int sblimit = fr_ps->sblimit_mc;2          for (i = 0; i < sblimit; i++)    {'       int T5T0 = 0, T6T0 = 0, T6T1 = 1;e         if (i == 0) sbgr = 0 ;
       else 	 for (l = 1; l < 12; l++)5 	    if ((sb_groups[l-1] < i) && (i <= sb_groups[l]))t 	    { 	       sbgr = l; break; 	    }  I       if (info->tc_aug_alloc[sbgr] == 4 || info->tc_aug_alloc[sbgr] == 5):!     	if (info->dyn_cross_LR == 0)  	  T6T1 = 0; 	elsee 	  T6T0 = 1;N       else if (info->tc_aug_alloc[sbgr] == 6 || info->tc_aug_alloc[sbgr] == 7)         if (info->dyn_cross_LR)  	  T5T0 = 1;    9       /* 960821 FdB new setup for dyn. crosstalk modes */r        for (bl = 0; bl < 3; bl++)       {=2 	 switch (fr_ps->header->dyn_cross_aug_mode[sbgr]) 	 {z% 	   case  0 :	/* T5 and T6 present */	 			 for (j = 5; j < 7; j++)d@ 			    fraction[j][i][bl][*z] *= multiple[scale_index[j][x][i]];
 			 break; 	   case  1 :	/* T6 from T1 */= 			 fraction[5][i][bl][*z] *= multiple[scale_index[5][x][i]];	] 			 fraction[6][i][bl][*z]  = (fraction[T6T1][i][bl][*z] / multiple[scale_index[T6T1][x][i]])z0 									      * multiple[scale_index[6][x][i]];
 			 break; 	   case  2 :	/* T6 from T2 */= 			 fraction[5][i][bl][*z] *= multiple[scale_index[5][x][i]];eW 			 fraction[6][i][bl][*z]  = (fraction[2][i][bl][*z] / multiple[scale_index[2][x][i]])	- 									   * multiple[scale_index[6][x][i]];i
 			 break; 	   case  3 :	/* T6 from T4 */= 			 fraction[5][i][bl][*z] *= multiple[scale_index[5][x][i]]; W 			 fraction[6][i][bl][*z]  = (fraction[4][i][bl][*z] / multiple[scale_index[4][x][i]])r- 									   * multiple[scale_index[6][x][i]]; 
 			 break; 	   case  4 :	/* T6 from T5 */= 			 fraction[5][i][bl][*z] *= multiple[scale_index[5][x][i]];5W 			 fraction[6][i][bl][*z]  = (fraction[5][i][bl][*z] / multiple[scale_index[5][x][i]])	- 									   * multiple[scale_index[6][x][i]];z
 			 break; 	   case  5 :	/* T5 from T0 */] 			 fraction[5][i][bl][*z]  = (fraction[T5T0][i][bl][*z] / multiple[scale_index[T5T0][x][i]])(0 									      * multiple[scale_index[5][x][i]];= 			 fraction[6][i][bl][*z] *= multiple[scale_index[6][x][i]];x
 			 break;- 	   case  6 :	/* T5 from T0 and T6 from T1 */2] 			 fraction[5][i][bl][*z]  = (fraction[T5T0][i][bl][*z] / multiple[scale_index[T5T0][x][i]])a0 									      * multiple[scale_index[5][x][i]];] 			 fraction[6][i][bl][*z]  = (fraction[T6T1][i][bl][*z] / multiple[scale_index[T6T1][x][i]])o0 									      * multiple[scale_index[6][x][i]];
 			 break;- 	   case  7 :	/* T5 from T0 and T6 from T2 */d] 			 fraction[5][i][bl][*z]  = (fraction[T5T0][i][bl][*z] / multiple[scale_index[T5T0][x][i]])40 									      * multiple[scale_index[5][x][i]];W 			 fraction[6][i][bl][*z]  = (fraction[2][i][bl][*z] / multiple[scale_index[2][x][i]])	- 									   * multiple[scale_index[6][x][i]];=
 			 break;- 	   case  8 :	/* T5 from T0 and T6 from T4 */[] 			 fraction[5][i][bl][*z]  = (fraction[T5T0][i][bl][*z] / multiple[scale_index[T5T0][x][i]])p0 									      * multiple[scale_index[5][x][i]];W 			 fraction[6][i][bl][*z]  = (fraction[4][i][bl][*z] / multiple[scale_index[4][x][i]])[- 									   * multiple[scale_index[6][x][i]];a
 			 break;% 	   case  9 :	/* T5 and T6 from T0 */i] 			 fraction[5][i][bl][*z]  = (fraction[T5T0][i][bl][*z] / multiple[scale_index[T5T0][x][i]])i0 									      * multiple[scale_index[5][x][i]];] 			 fraction[6][i][bl][*z]  = (fraction[T6T0][i][bl][*z] / multiple[scale_index[T6T0][x][i]]) 0 									      * multiple[scale_index[6][x][i]];
 			 break; 	   case 10 :	/* T5 from T2 */W 			 fraction[5][i][bl][*z]  = (fraction[2][i][bl][*z] / multiple[scale_index[2][x][i]])[- 									   * multiple[scale_index[5][x][i]];h= 			 fraction[6][i][bl][*z] *= multiple[scale_index[6][x][i]];4
 			 break;- 	   case 11 :	/* T5 from T2 and T6 from T1 */aW 			 fraction[5][i][bl][*z]  = (fraction[2][i][bl][*z] / multiple[scale_index[2][x][i]])r- 									   * multiple[scale_index[5][x][i]];o] 			 fraction[6][i][bl][*z]  = (fraction[T6T1][i][bl][*z] / multiple[scale_index[T6T1][x][i]])]- 									   * multiple[scale_index[6][x][i]]; 
 			 break;% 	   case 12 :	/* T5 and T6 from T2 */	W 			 fraction[5][i][bl][*z]  = (fraction[2][i][bl][*z] / multiple[scale_index[2][x][i]])	- 									   * multiple[scale_index[5][x][i]];	W 			 fraction[6][i][bl][*z]  = (fraction[2][i][bl][*z] / multiple[scale_index[2][x][i]])a- 									   * multiple[scale_index[6][x][i]];]
 			 break;- 	   case 13 :	/* T5 from T2 and T6 from T4 */	W 			 fraction[5][i][bl][*z]  = (fraction[2][i][bl][*z] / multiple[scale_index[2][x][i]])e- 									   * multiple[scale_index[5][x][i]];eW 			 fraction[6][i][bl][*z]  = (fraction[4][i][bl][*z] / multiple[scale_index[4][x][i]])e- 									   * multiple[scale_index[6][x][i]];e
 			 break; 	   case 14 :	/* T5 from T3 */W 			 fraction[5][i][bl][*z]  = (fraction[3][i][bl][*z] / multiple[scale_index[3][x][i]])t- 									   * multiple[scale_index[5][x][i]]; = 			 fraction[6][i][bl][*z] *= multiple[scale_index[6][x][i]];e
 			 break;- 	   case 15 :	/* T5 from T3 and T6 from T1 */cW 			 fraction[5][i][bl][*z]  = (fraction[3][i][bl][*z] / multiple[scale_index[3][x][i]])	- 									   * multiple[scale_index[5][x][i]];4] 			 fraction[6][i][bl][*z]  = (fraction[T6T1][i][bl][*z] / multiple[scale_index[T6T1][x][i]])]0 									      * multiple[scale_index[6][x][i]];
 			 break;- 	   case 16 :	/* T5 from T3 and T6 from T2 */uW 			 fraction[5][i][bl][*z]  = (fraction[3][i][bl][*z] / multiple[scale_index[3][x][i]])i- 									   * multiple[scale_index[5][x][i]];*W 			 fraction[6][i][bl][*z]  = (fraction[2][i][bl][*z] / multiple[scale_index[2][x][i]]) - 									   * multiple[scale_index[6][x][i]];3
 			 break;- 	   case 17 :	/* T5 from T3 and T6 from T4 */iW 			 fraction[5][i][bl][*z]  = (fraction[3][i][bl][*z] / multiple[scale_index[3][x][i]])n- 									   * multiple[scale_index[5][x][i]];	W 			 fraction[6][i][bl][*z]  = (fraction[4][i][bl][*z] / multiple[scale_index[4][x][i]]) - 									   * multiple[scale_index[6][x][i]];4
 			 break;% 	   case 18 :	/* T5 and T6 from T3 */sW 			 fraction[5][i][bl][*z]  = (fraction[3][i][bl][*z] / multiple[scale_index[3][x][i]]) - 									   * multiple[scale_index[5][x][i]];[W 			 fraction[6][i][bl][*z]  = (fraction[3][i][bl][*z] / multiple[scale_index[3][x][i]])n- 									   * multiple[scale_index[6][x][i]];t
 			 break; 	 }0       }	  		    } /* for sblimit */ }i #endif  ? /*************************************************************/i! /* JMZ 09/03/1995 Multilingual */   D void II_denormalize_sample_ml(double fraction_ml[7][SBLIMIT][3][12],4 			      unsigned int scale_index_ml[7][3][SBLIMIT], 			      frame_params *fr_ps,0 			      int x,	 			      int *n_ml_ch, 			      int *z) {	    int i,j;p&    int sblimit_ml = fr_ps->sblimit_ml;  #    for (i = 0; i < sblimit_ml; i++)f"     for (j = 0; j < *n_ml_ch; j++)      {E        fraction_ml[j][i][0][*z] *= multiple[scale_index_ml[j][x][i]];dE        fraction_ml[j][i][1][*z] *= multiple[scale_index_ml[j][x][i]];*E        fraction_ml[j][i][2][*z] *= multiple[scale_index_ml[j][x][i]];a      } }[  B /***************************************************************** /*? /* The following are the subband synthesis routines. They applyz? /* to both layer I and layer II stereo or mono. The user has toe; /* decide what parameters are to be passed to the routines.[ /*A /***************************************************************/i  > /************************************************************* /*9 /*   Pass the subband sample through the synthesis windowi /*@ /**************************************************************/    /* create in synthesis filter */  9 static void create_syn_filter(double filter[64][SBLIMIT])r {i    register int i,k;      for (i=0; i<64; i++)]       for (k=0; k<32; k++) {E 		 if ((filter[i][k] = 1e9*cos((double)((PI64*i+PI4)*(2*k+1)))) >= 0) ) 			modf(filter[i][k]+0.5, &filter[i][k]); 
          elsel2             modf(filter[i][k]-0.5, &filter[i][k]); 		 filter[i][k] *= 1e-9; 	  } }[  @ /*************************************************************** /* /*   Window the restored sample> /*A /***************************************************************/c   /* read in synthesis window */  4 static void read_syn_window(double window[HAN_SIZE]) {     int i,j[4];    FILE *fp;    double f[4];     char t[150];+  ,    if (!(fp = OpenTableFile("dewindow") )) {H 	  fprintf (stderr, "Please check synthesis window table 'dewindow'\n"); 	  exit (1);    }    for (i=0;i<512;i+=4) {r 		fgets(t,150, fp);f@ 	  sscanf(t,"D[%d] = %lf D[%d] = %lf D[%d] = %lf D[%d] = %lf\n"," 			 j, f,j+1,f+1,j+2,f+2,j+3,f+3); 	  if (i==j[0]) {a 		 window[i] = f[0]; 		 window[i+1] = f[1]; 		 window[i+2] = f[2]; 		 window[i+3] = f[3]; 	  }	 	  else {o? 		 fprintf (stderr, "Check index in synthesis window table\n");w 			exit (1); 	  } 	  fgets(t,80,fp);    }    fclose(fp); }     & int SubBandSynthesis (double *bandPtr, 		      int channel, 		      long *samples) {l
     long foo;e     register int i,j,k; '     register double *bufOffsetPtr, sum;i     static int init = 1;     typedef double NN[64][32];     static NN *filter;&     typedef double BB[7][2*HAN_SIZE];      static BB *buf;i     static int bufOffset = 64;     static double *window;M     int clip = 0;               /* count & return how many samples clipped */s       if (init) {]* 		buf = (BB *) mem_alloc(sizeof(BB),"BB");. 		filter = (NN *) mem_alloc(sizeof(NN), "NN"); 		create_syn_filter(*filter);iB 		window = (double *) mem_alloc(sizeof(double) * HAN_SIZE, "WIN"); 		read_syn_window(window); 		bufOffset = 64;[ 		init = 0;  	}8 	if (channel == 0) bufOffset = (bufOffset - 64) & 0x3ff;. 	bufOffsetPtr = &((*buf)[channel][bufOffset]);   	for (i=0; i<64; i++)	 	{
 		sum = 0; 		for (k=0; k<32; k++)' 			sum += bandPtr[k] * (*filter)[i][k];s 		bufOffsetPtr[i] = sum; 	}  3 	/*  S(i,j) = D(j+32i) * U(j+32i+((i+1)>>1)*64)  */pD 	/*  samples(i,j) = MWindow(j+32i) * bufPtr(j+32i+((i+1)>>1)*64)  */ 	for (j=0; j<32; j++)a 	{         sum = 0; 		for (i=0; i<16; i++) 		{] 			k = j + (i<<5);M             sum += window[k] * (*buf) [channel] [( (k + ( ((i+1)>>1) <<6) ) +lF                                                   bufOffset) & 0x3ff];	         }   F /*   {long foo = (sum > 0) ? sum * SCALE + 0.5 : sum * SCALE - 0.5; */! /*   {long foo = sum * SCALE;  */b      / #ifdef	SB_OUTPUTB 	 sum = bandPtr[j];	/* 960814 FdB for subband sample generation */ #endif  ! 	 foo = floor(sum * SCALE + 0.5);1? 	 if (foo >= (long) SCALE)      {samples[j] = SCALE-1; ++clip;} > 	 else if (foo < (long) -SCALE) {samples[j] =-SCALE;  ++clip;}2 	 else                           samples[j] = foo;  *     }f     return(clip);] }]  ) int SubBandSynthesis_ml (double *bandPtr,	 		         int channel,_ 		         long *samples)i {6
     long foo;      register int i,j,k; '     register double *bufOffsetPtr, sum;	     static int init = 1;     typedef double NN[64][32];     static NN *filter;&     typedef double BB[7][2*HAN_SIZE];      static BB *buf;0     static int bufOffset = 64;     static double *window;M     int clip = 0;               /* count & return how many samples clipped */o       if (init) {u* 		buf = (BB *) mem_alloc(sizeof(BB),"BB");. 		filter = (NN *) mem_alloc(sizeof(NN), "NN"); 		create_syn_filter(*filter); B 		window = (double *) mem_alloc(sizeof(double) * HAN_SIZE, "WIN"); 		read_syn_window(window); 		bufOffset = 64;  		init = 0;[ 	}8 	if (channel == 0) bufOffset = (bufOffset - 64) & 0x3ff;. 	bufOffsetPtr = &((*buf)[channel][bufOffset]);   	for (i=0; i<64; i++)* 	{
 		sum = 0; 		for (k=0; k<32; k++)' 			sum += bandPtr[k] * (*filter)[i][k];  		bufOffsetPtr[i] = sum; 	}  3 	/*  S(i,j) = D(j+32i) * U(j+32i+((i+1)>>1)*64)  */ D 	/*  samples(i,j) = MWindow(j+32i) * bufPtr(j+32i+((i+1)>>1)*64)  */ 	for (j=0; j<32; j++)i 	{         sum = 0; 		for (i=0; i<16; i++) 		{r 			k = j + (i<<5);M             sum += window[k] * (*buf) [channel] [( (k + ( ((i+1)>>1) <<6) ) +dF                                                   bufOffset) & 0x3ff];	         }b  F /*   {long foo = (sum > 0) ? sum * SCALE + 0.5 : sum * SCALE - 0.5; */! /*   {long foo = sum * SCALE;  */x      i #ifdef	SB_OUTPUTB 	 sum = bandPtr[j];	/* 960814 FdB for subband sample generation */ #endif  ! 	 foo = floor(sum * SCALE + 0.5);d? 	 if (foo >= (long) SCALE)      {samples[j] = SCALE-1; ++clip;}	> 	 else if (foo < (long) -SCALE) {samples[j] =-SCALE;  ++clip;}2 	 else                           samples[j] = foo;  d     }]     return (clip); }     . void out_fifo (long pcm_sample[7][3][SBLIMIT], 	       int num, 	       frame_params *fr_ps, 	       int done,x 	       FILE *outFile,# 	       unsigned long *psampFrames,  	       int ch)] {]
    int i,j,l;o static short int outsamp[1600];i static long k = 0;       if (!done) 	for (i = 0; i < num; i++)# 	    for (j = 0; j < SBLIMIT; j++) T 	    { 		(*psampFrames)++;* 		for (l = 0; l < ch; l++) 		{u 		    if (!(k % 1600) && k)  		    {	& 			fwrite (outsamp, 2, 1600, outFile);	 			k = 0;n 		    }]) 		    outsamp[k++] = pcm_sample[l][i][j];	 		}a 	    }     else if (k > 0)T     {6' 	fwrite (outsamp, 2, (int) k, outFile);  	k = 0;o     }[ }[  0 void out_fifo_ml(long pcm_sample[7][3][SBLIMIT], 	         int num, 	         frame_params *fr_ps, 	         int done,o 	         FILE *outFile,% 	         unsigned long *psampFrames)	 { 
    int i,j,l;c7    int n_ml_ch = fr_ps->header->no_of_multi_lingual_ch;m"    static short int outsamp[1600];    static long k = 0;t  
    if (!done)        for (i=0; i<num; i++)i 	 for (j=0; j<SBLIMIT; j++)s 	 {i 	    (*psampFrames)++; 	    for (l=0; l<n_ml_ch; l++) 	    { 	       if (!(k%1600) && k)x	 	       { ' 		  fwrite (outsamp, 2, 1600, outFile);]
 		  k = 0;	 	       } + 	       outsamp[k++] = pcm_sample[l][i][j];	 	    } 	 }[    else if (k > 0)    {,       fwrite (outsamp, 2, (int) k, outFile);       k = 0;    } }e  3 /*************************************************/ ! /* JMZ 10/03/1995 Multilingual */s  ! /* JMZ 10/03/1995 Multilingual */ 3 /*************************************************/e  ! void  buffer_CRC(Bit_stream  *bs,r 		 unsigned int  *old_crc) {o    *old_crc = getbits (bs, 16);i }x  7 void  recover_CRC_error(long pcm_sample[7][3][SBLIMIT],[ 			int error_count,b 			frame_params *fr_ps,[ 			FILE *outFile,s 			unsigned long *psampFrames,
 			int ch) {s    int  stereo = fr_ps->stereo;;    int  num, done, i; (    int  samplesPerFrame, samplesPerSlot;    layer  *hdr = fr_ps->header;*    long  offset;    short  *temp;      num = 3;n    if (hdr->lay == 1) num = 1;  +    samplesPerSlot = SBLIMIT * num * stereo;,)    samplesPerFrame = samplesPerSlot * 32;]  F    if (error_count == 1) {   /* replicate previous error_free frame */       done = 1;  	  /* flush out fifo */jD 	  out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames, ch);7 	  /* go back to the beginning of the previous frame */ 0 	  offset = sizeof(short int) * samplesPerFrame;(       fseek(outFile, -offset, SEEK_CUR);       done = 0;l        for (i = 0; i < 12; i++) {1 		 fread(pcm_sample, 2, samplesPerSlot, outFile);nD 		 out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames, ch);       }*    }    else{   /* mute the frame */i!       temp = (short*) pcm_sample;e       done = 0;*'       for (i = 0; i < 2*3*SBLIMIT; i++)o;          *temp++ = MUTE;   /* MUTE value is in decoder.h */s       for (i = 0; i < 12; i++)J          out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames, ch);    } }*    9 /*******************************************************/b5 /* prediction corrected, Heiko Purnhagen 08-nov-94 */*9 /*******************************************************/*  # /* this is only a local function */c: static double predict (double pred_buf[2][8][36+PREDDEL],  		frame_params *fr_ps,
 		int sb, 
 		int jj,  		int j,	 		int ch,  		int idx)   {i   int i;   double t;o     t = 0;5   for (i=0; i<fr_ps->header->mc_predsi[sb][idx]; i++)lQ     t += pred_buf[ch][sb][PREDDEL+3*jj+j-i-fr_ps->header->mc_delay_comp[sb][idx]]	@       * (fr_ps->header->mc_pred_coeff[sb][idx][i] - 127) * STEP;   return t;* }*    @ /**************************************************************// /* JMZ 09/03/1995 Multilingual modifications */*  ; void dematricing_mc (double pcm_sample[7][SBLIMIT][3][12], n 		     frame_params *fr_ps,E) 		     double pred_buf[2][8][36+PREDDEL])u { *   int i, j, jj, k, tc_alloc, l, sbgr = 0 ;   layer *info = fr_ps->header;2   double tmp_sample, tmp_sample1, surround_sample;      for (jj=0; jj<12; jj++);   for( j = 0; j < 3; ++j)+    { 	for(k = 0; k < SBLIMIT; k ++) 	{+ 	    if(fr_ps->header->tc_sbgr_select == 1)%S 		tc_alloc = fr_ps->header->tc_allocation; /* one tc_alloc is valid for all sbgr */ 	 	    else+ 	    { 		if(k == 0) sbgr = 0; 		else 			for(l = 1; l < 12; l++) 			{3 				if((sb_groups[l-1] < k) && (k <= sb_groups[l]))d 				{e4 					sbgr = l;  /* search the valid subband group */ 					break;; 				}  			}W 			tc_alloc = fr_ps->header->tc_alloc[sbgr]; /* no prediction, but different tc_alloc's  									per subband*/& 	    }  /* else tc_sbgr_select == 0 */  U 	    if (fr_ps->header->mc_prediction_on && k < 8 && fr_ps->header->mc_prediction[k])f 	    { 		/* prediction on in sbgr */SH    		if ((fr_ps->header->surround == 2) && (fr_ps->header->center != 0)) 		{    n  		    /* FdB channel mode 3/2 */N 		    switch (fr_ps->header->dyn_cross_mode[k])   /* if prediction on in sb */ 		    {mH 			case 0: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)I 			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);lE 			    	pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2) 5 					 	         + predict(pred_buf,fr_ps,k,jj,j,1,3);fE 			    	pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,4)f4 						         + predict(pred_buf,fr_ps,k,jj,j,1,5);
 				break; 			 H 			case 1: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)I 			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);2E 			    	pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2) 5 					 	         + predict(pred_buf,fr_ps,k,jj,j,1,3);< 			    	break; 			 H 			case 2: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)I 			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1); E 			    	pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2) 4 						         + predict(pred_buf,fr_ps,k,jj,j,1,3);
 				break; 			aH 			case 3: pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)5 					 	         + predict(pred_buf,fr_ps,k,jj,j,1,1);)E 			    	pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2) 4 						         + predict(pred_buf,fr_ps,k,jj,j,1,3);
 				break; 			sH 			case 4: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)I 			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);6 			    	break; 			 H 			case 5: pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)5 					 	         + predict(pred_buf,fr_ps,k,jj,j,1,1);t 			    	break; 			yH 			case 6: pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)4 						         + predict(pred_buf,fr_ps,k,jj,j,1,1);
 				break;  H 			case 8: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)I 			                                 + predict(pred_buf,fr_ps,k,jj,j,1,1);e 			    	break;  H 			case 9: pcm_sample[4][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)4 						         + predict(pred_buf,fr_ps,k,jj,j,1,1);
 				break;  O 		       case 10: pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)b4 						         + predict(pred_buf,fr_ps,k,jj,j,1,1); 			    	break;   		     } 		} /* 3/2 mode */J 		else if ((fr_ps->header->surround == 1 && fr_ps->header->center != 0) ||A 			 (fr_ps->header->surround == 2 && fr_ps->header->center == 0))s 		{s) 		    /* FdB channel modes 3/1 and 2/2 */)M 		    switch(fr_ps->header->dyn_cross_mode[k])   /* if prediction on in sb */+ 		    { H 			case 0: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)- 							 + predict(pred_buf,fr_ps,k,jj,j,1,1); A 				pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,2) - 							 + predict(pred_buf,fr_ps,k,jj,j,1,3);m
 				break; 			/H 			case 1: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)- 							 + predict(pred_buf,fr_ps,k,jj,j,1,1);r
 				break; 			 H 			case 2: pcm_sample[3][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)- 							 + predict(pred_buf,fr_ps,k,jj,j,1,1);(
 				break;   		    }j 		} /* 3/1 and 2/2 modes */ l 		else if (((fr_ps->header->surround == 0 || fr_ps->header->surround == 3) && fr_ps->header->center != 0) ||A 			 (fr_ps->header->surround == 1 && fr_ps->header->center == 0)), 		{ 1 		    /* FdB channel modes 3/0 (+ 2/0) and 2/1 */iM 		    switch(fr_ps->header->dyn_cross_mode[k])   /* if prediction on in sb */t 		    {1H 			case 0: pcm_sample[2][k][j][jj] += predict(pred_buf,fr_ps,k,jj,j,0,0)- 							 + predict(pred_buf,fr_ps,k,jj,j,1,1);	
 				break; 			* 		    }l 		} 
 	    }      0 	    if (fr_ps->header->dematrix_procedure != 3)H    		if ((fr_ps->header->surround == 2) && (fr_ps->header->center != 0)) 		{    s  		    /* FdB channel mode 3/2 */ 		    switch(tc_alloc) 		    {t 		     case 0:4 			    if (fr_ps->header->dematrix_procedure == 2) {P 				surround_sample = (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0;b 				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + surround_sample;b 				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - surround_sample; 			    }
 			    else {gj 				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];j 				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj]; 			    }
 			    break;       		     case 1:4 			    if (fr_ps->header->dematrix_procedure == 2) {T 				    surround_sample = (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0;5 				    tmp_sample = pcm_sample[2][k][j][jj]; /* L */*f 				    pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + surround_sample;f 				    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - surround_sample;- 				    pcm_sample[0][k][j][jj] = tmp_sample;  			    }
 			    else {o5 				    tmp_sample = pcm_sample[2][k][j][jj]; /* L */	n 				    pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];n 				    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];- 				    pcm_sample[0][k][j][jj] = tmp_sample;= 			    }
 			    break;1      		     case 2:4 			    if (fr_ps->header->dematrix_procedure == 2) {T 				    surround_sample = (pcm_sample[3][k][j][jj] + pcm_sample[4][k][j][jj]) / 2.0;5 				    tmp_sample = pcm_sample[2][k][j][jj]; /* R */*f 				    pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - surround_sample;f 				    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + surround_sample;- 				    pcm_sample[1][k][j][jj] = tmp_sample;= 			    }
 			    else {e5 				    tmp_sample = pcm_sample[2][k][j][jj]; /* R */fn 				    pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];n 				    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];- 				    pcm_sample[1][k][j][jj] = tmp_sample;  			    }
 			    break;)      		     case 3:4 			    if (fr_ps->header->dematrix_procedure == 2) {< 				    tmp_sample = pcm_sample[3][k][j][jj];  /* L in T3 */ 				    pcm_sample[3][k][j][jj] = -2.0 * (pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] -  pcm_sample[3][k][j][jj]) - pcm_sample[4][k][j][jj]; 				    pcm_sample[1][k][j][jj] = pcm_sample[0][k][j][jj] + pcm_sample[1][k][j][jj] - 2.0 * pcm_sample[2][k][j][jj] - tmp_sample;	- 				    pcm_sample[0][k][j][jj] = tmp_sample;  			    }
 			    else { < 				    tmp_sample = pcm_sample[3][k][j][jj];  /* L in T3 */n 				    pcm_sample[3][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];n 				    pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];- 				    pcm_sample[0][k][j][jj] = tmp_sample;t 			    }
 			    break;i      		     case 4:4 			    if (fr_ps->header->dematrix_procedure == 2) {< 				    tmp_sample = pcm_sample[4][k][j][jj];  /* R in T4 */ 				    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] + pcm_sample[1][k][j][jj] - 2.0 * pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj]; 				    pcm_sample[4][k][j][jj] = 2.0 * pcm_sample[1][k][j][jj] - 2.0 * (pcm_sample[2][k][j][jj] + pcm_sample[4][k][j][jj]) - pcm_sample[3][k][j][jj];- 				    pcm_sample[1][k][j][jj] = tmp_sample;r 			    }
 			    else { < 				    tmp_sample = pcm_sample[4][k][j][jj];  /* R in T4 */n 				    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];n 				    pcm_sample[4][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[4][k][j][jj] - pcm_sample[2][k][j][jj];- 				    pcm_sample[1][k][j][jj] = tmp_sample;* 			    }
 			    break;       		     case 5:4 			    if (fr_ps->header->dematrix_procedure == 2) {< 				    tmp_sample = pcm_sample[3][k][j][jj];  /* L in T3 */ 				    pcm_sample[3][k][j][jj] = 0.5 * (pcm_sample[1][k][j][jj] - pcm_sample[0][k][j][jj] + pcm_sample[3][k][j][jj] - pcm_sample[4][k][j][jj]);- 				    pcm_sample[0][k][j][jj] = tmp_sample; H 				    pcm_sample[1][k][j][jj] = pcm_sample[4][k][j][jj]; /* R in T4 */H 				    pcm_sample[4][k][j][jj] = pcm_sample[3][k][j][jj]; /* RS = LS */ 			    }
 			    else {a- 				    tmp_sample = pcm_sample[3][k][j][jj];jn 				    pcm_sample[3][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];- 				    pcm_sample[0][k][j][jj] = tmp_sample;i- 				    tmp_sample = pcm_sample[4][k][j][jj]; n 				    pcm_sample[4][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[4][k][j][jj] - pcm_sample[2][k][j][jj];- 				    pcm_sample[1][k][j][jj] = tmp_sample;	 			    }
 			    break;=      		     case 6:4 			    if (fr_ps->header->dematrix_procedure == 2) {< 				    tmp_sample = pcm_sample[2][k][j][jj];  /* R in T2 */= 				    tmp_sample1 = pcm_sample[3][k][j][jj];  /* L in T3 */  				    pcm_sample[3][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + pcm_sample[3][k][j][jj] - pcm_sample[4][k][j][jj]; 				    pcm_sample[2][k][j][jj] = 0.5 * (pcm_sample[0][k][j][jj] + pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - tmp_sample1);- 				    pcm_sample[1][k][j][jj] = tmp_sample;	. 				    pcm_sample[0][k][j][jj] = tmp_sample1; 			    }
 			    else { < 				    tmp_sample = pcm_sample[2][k][j][jj];  /* R in T2 */n 				    pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[4][k][j][jj];- 				    pcm_sample[1][k][j][jj] = tmp_sample;r< 				    tmp_sample = pcm_sample[3][k][j][jj];  /* L in T3 */n 				    pcm_sample[3][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[2][k][j][jj];- 				    pcm_sample[0][k][j][jj] = tmp_sample;_ 			    }
 			    break;       		     case 7:4 			    if (fr_ps->header->dematrix_procedure == 2) {< 				    tmp_sample = pcm_sample[2][k][j][jj];  /* L in T2 */= 				    tmp_sample1 = pcm_sample[4][k][j][jj];  /* R in T4 */, 				    pcm_sample[4][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[0][k][j][jj] + pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj] - pcm_sample[4][k][j][jj]; 				    pcm_sample[2][k][j][jj] = 0.5 * (pcm_sample[0][k][j][jj] + pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - tmp_sample1);- 				    pcm_sample[0][k][j][jj] = tmp_sample; . 				    pcm_sample[1][k][j][jj] = tmp_sample1; 			    }
 			    else {0- 				    tmp_sample = pcm_sample[2][k][j][jj];sn 				    pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];- 				    pcm_sample[0][k][j][jj] = tmp_sample; - 				    tmp_sample = pcm_sample[4][k][j][jj];dn 				    pcm_sample[4][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[4][k][j][jj] - pcm_sample[2][k][j][jj];- 				    pcm_sample[1][k][j][jj] = tmp_sample;r 			    }
 			    break;,      		    } /* switch end loop*/ 		}mH 		else if (fr_ps->header->surround == 1 && fr_ps->header->center != 0)   		{    b  		    /* FdB channel mode 3/1 */ 		    switch(tc_alloc) 		    {k 			 case 0: / 				if (fr_ps->header->dematrix_procedure == 2)cn 				    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + pcm_sample[3][k][j][jj]; 				elsen 				    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];j 				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];
 				break;   			 case 1: 1 				tmp_sample = pcm_sample[2][k][j][jj]; /* L */:/ 				if (fr_ps->header->dematrix_procedure == 2)sn 				    pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + pcm_sample[3][k][j][jj]; 				elsen 				    pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];j 				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];) 				pcm_sample[0][k][j][jj] = tmp_sample;	
 				break;   			 case 2: 1 				tmp_sample = pcm_sample[2][k][j][jj]; /* R */	j 				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];/ 				if (fr_ps->header->dematrix_procedure == 2)_n 				    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + pcm_sample[3][k][j][jj]; 				elsen 				    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];) 				pcm_sample[1][k][j][jj] = tmp_sample;j
 				break;   			 case 3: 8 				tmp_sample = pcm_sample[3][k][j][jj];  /* L in T3 *// 				if (fr_ps->header->dematrix_procedure == 2)mo 				    pcm_sample[3][k][j][jj] = -pcm_sample[0][k][j][jj] + pcm_sample[2][k][j][jj] + pcm_sample[3][k][j][jj];	 				elsen 				    pcm_sample[3][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];j 				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];) 				pcm_sample[0][k][j][jj] = tmp_sample;s
 				break;   			 case 4:p8 				tmp_sample = pcm_sample[3][k][j][jj];  /* R in T3 */j 				pcm_sample[3][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];/ 				if (fr_ps->header->dematrix_procedure == 2)en 				    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] + pcm_sample[3][k][j][jj]; 				elsen 				    pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj] - pcm_sample[3][k][j][jj];) 				pcm_sample[1][k][j][jj] = tmp_sample; 
 				break;   			 case 5:m8 				tmp_sample = pcm_sample[2][k][j][jj];  /* L in T2 */9 				tmp_sample1 = pcm_sample[3][k][j][jj];  /* R in T3 */rs 				pcm_sample[2][k][j][jj] = 0.5 * (pcm_sample[0][k][j][jj] + pcm_sample[1][k][j][jj] - tmp_sample - tmp_sample1); s 				pcm_sample[3][k][j][jj] = 0.5 * (pcm_sample[1][k][j][jj] - pcm_sample[0][k][j][jj] + tmp_sample - tmp_sample1);]) 				pcm_sample[0][k][j][jj] = tmp_sample; * 				pcm_sample[1][k][j][jj] = tmp_sample1;
 				break; 		    }   /* switch end */ 		}cF 		else if (fr_ps->header->surround == 1 || fr_ps->header->center != 0) 		{c1 		    /* FdB channel modes 3/0 (+ 2/0) and 2/1 */[ 		    switch(tc_alloc) 		    {  			 case 0: Q 				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj]; mP 				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj];
 				break;   			 case 1:]1 				tmp_sample = pcm_sample[2][k][j][jj]; /* L */kP 				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];P 				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj];) 				pcm_sample[0][k][j][jj] = tmp_sample;_
 				break;   			 case 2: 1 				tmp_sample = pcm_sample[2][k][j][jj]; /* R */]P 				pcm_sample[2][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[2][k][j][jj];P 				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];) 				pcm_sample[1][k][j][jj] = tmp_sample;j
 				break; 		    }   /* switch end */ 		}_* 		else if (fr_ps->header->surround == 2)   		{   		    /* FdB channel mode 2/2 */ 		    switch(tc_alloc) 		    {x 			 case 0: P 				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];T 			    	pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj];
 				break;   			 case 1:e1 				tmp_sample = pcm_sample[2][k][j][jj]; /* L */.P 				pcm_sample[1][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj];P 				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];) 				pcm_sample[0][k][j][jj] = tmp_sample;e
 				break;   			 case 2: 1 				tmp_sample = pcm_sample[3][k][j][jj]; /* R */cP 				pcm_sample[0][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];P 				pcm_sample[3][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj];) 				pcm_sample[1][k][j][jj] = tmp_sample;1
 				break;   			 case 3: 1 				tmp_sample = pcm_sample[2][k][j][jj]; /* L */ P 				pcm_sample[2][k][j][jj] = pcm_sample[0][k][j][jj] - pcm_sample[2][k][j][jj];) 				pcm_sample[0][k][j][jj] = tmp_sample;a1 				tmp_sample = pcm_sample[3][k][j][jj]; /* R */-P 				pcm_sample[3][k][j][jj] = pcm_sample[1][k][j][jj] - pcm_sample[3][k][j][jj];) 				pcm_sample[1][k][j][jj] = tmp_sample; 
 				break; 		    }   /* switch end */ 		}e! 	}     /* for k < sblimit loop */         }     /* for j < 3 loop */ }e  _ void denormalizing_mc (double pcm_sample[7][SBLIMIT][3][12], frame_params *fr_ps, int channels)] { *   double matr1;   /* normalizing factor */*   double matr2;   /* matricing factor   */*   double matr3;   /* matricing factor   */   int i, j, jj, k, l;e   layer *info = fr_ps->header;   int  stereo = fr_ps->stereo;   #   switch (info->dematrix_procedure)[   { 5     /* factors according to International Standard */	     case 0:e=     case 2: matr1 = 1 + sqrt(2.0);	/* factor for L and R   */	2 	    matr2 = sqrt(2.0) * matr1;	/* factor for C */7 	    matr3 = sqrt(2.0) * matr1;	/* factor for Ls, Rs */j 	    break;TD     case 1: matr1 = (1.5 + 0.5*sqrt(2.0));/* factor for L, R      */: 	    matr2 = sqrt(2.0) * matr1;	/* factor for C         */1 	    matr3 = 2 * matr1;		/* factor for Ls, Rs  */  	    break;[     case 3: matr1 = 1.0; 	    matr2 = 1.0;  	    matr3 = 1.0;[ 	    break;p   }m     /* denormalized signals */B   if (fr_ps->header->dematrix_procedure != 3 ) 		/* dematrixing */     for (jj=0; jj<12; jj++)e       for( j = 0; j < 3; ++j)[ 	for (k = 0; k < SBLIMIT; k ++)  	{   /* Lo / Ro */! 	    for (i = 0; i < stereo; i++)]< 		pcm_sample[i][k][j][jj] = pcm_sample[i][k][j][jj] * matr1;  u 	    if (fr_ps->header->dematrix_procedure != 1)  /* matrix 0 and 2, since C, Ls, Rs, and S all use the same value */  	    { 		/* second stereo channels */# 		if (fr_ps->header->surround == 3)[ 		{[% 		    if (fr_ps->header->center != 0)p= 			pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;0 		}j	 		else   _ 		{e$ 		    for (l = 2; l < channels; l++)C 		       pcm_sample[l][k][j][jj] = pcm_sample[l][k][j][jj] * matr2;	 		}  	    } 	    else   /* matrix 1 */ 	    {# 		if (fr_ps->header->surround == 3)a 		{4% 		    if (fr_ps->header->center != 0)c= 			pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;[ 		}[9 		else if (fr_ps->mc_channel == 3)   /* R.S. matr2 = C */c 		{p@ 		    pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;@ 		    pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr3;@ 		    pcm_sample[4][k][j][jj] = pcm_sample[4][k][j][jj] * matr3; 		}	" 		else if (fr_ps->mc_channel == 2) 		{;1 		    if (fr_ps->header->surround == 2)	/* 2/2 */m 		    {]? 			pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr3;  j= 			pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr3;	 		    }a 		    else				/* 3/1 */a 		    {	= 			pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;e= 			pcm_sample[3][k][j][jj] = pcm_sample[3][k][j][jj] * matr3;j 		    }a 		}2 		else	/* mc_channel == 1 */ 		{[/ 		    if (fr_ps->header->center == 0)	/* 2/1 */,? 			pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr3; 	d 		    else				/* 3/0 */s= 			pcm_sample[2][k][j][jj] = pcm_sample[2][k][j][jj] * matr2;/ 		}  	    } 	} }_   #ifdef Augmentation_7ch0P void dematricing_aug (double pcm_sample[7][SBLIMIT][3][12], frame_params *fr_ps) { 0   double c0, c1;   /* denormalization factors */.   int i, j, jj, k, tc_aug_alloc, l, sbgr = 0 ;   layer *info = fr_ps->header;"   double tmp_sample1, tmp_sample2;      c0 = 1.0 / 3.0;[$   if (info->dematrix_procedure != 3)     c0 *= sqrt (0.5);[   c1 = 1.0 / c0;     for (jj=0; jj<12; jj++)]     for( j = 0; j < 3; ++j)a     { #       for(k = 0; k < SBLIMIT; k ++)j       {* 	if (k == 0) sbgr = 0; 	elset 	{ 	  for(l = 1; l < 12; l++) 	  {4 	    if((sb_groups[l-1] < k) && (k <= sb_groups[l])) 	    {6 	      sbgr = l;  /* search the valid subband group */
 	      break;[ 	    } 	  } 	}2 	tc_aug_alloc = fr_ps->header->tc_aug_alloc[sbgr];   	if (info->aug_mtx_proc == 0)] 	  switch (tc_aug_alloc) 	  {? 	  case 0:  pcm_sample[0][k][j][jj] -= pcm_sample[5][k][j][jj];a8 		   pcm_sample[1][k][j][jj] -= pcm_sample[6][k][j][jj];Y 		   pcm_sample[2][k][j][jj] -= c0 * (pcm_sample[5][k][j][jj] + pcm_sample[6][k][j][jj]);a 		   break;[2 	  case 1:  tmp_sample1 = pcm_sample[0][k][j][jj];7 		   pcm_sample[0][k][j][jj] = pcm_sample[5][k][j][jj];	E 		   pcm_sample[5][k][j][jj] = tmp_sample1 - pcm_sample[5][k][j][jj];[8 		   pcm_sample[1][k][j][jj] -= pcm_sample[6][k][j][jj];Y 		   pcm_sample[2][k][j][jj] -= c0 * (pcm_sample[5][k][j][jj] + pcm_sample[6][k][j][jj]);] 		   break;	? 	  case 2:  pcm_sample[0][k][j][jj] -= pcm_sample[5][k][j][jj]; + 		   tmp_sample2 = pcm_sample[1][k][j][jj];/7 		   pcm_sample[1][k][j][jj] = pcm_sample[6][k][j][jj];=E 		   pcm_sample[6][k][j][jj] = tmp_sample2 - pcm_sample[6][k][j][jj];sY 		   pcm_sample[2][k][j][jj] -= c0 * (pcm_sample[5][k][j][jj] + pcm_sample[6][k][j][jj]);  		   break;[2 	  case 3:  tmp_sample1 = pcm_sample[0][k][j][jj];7 		   pcm_sample[0][k][j][jj] = pcm_sample[5][k][j][jj];]E 		   pcm_sample[5][k][j][jj] = tmp_sample1 - pcm_sample[5][k][j][jj];a+ 		   tmp_sample2 = pcm_sample[1][k][j][jj]; 7 		   pcm_sample[1][k][j][jj] = pcm_sample[6][k][j][jj]; E 		   pcm_sample[6][k][j][jj] = tmp_sample2 - pcm_sample[6][k][j][jj]; Y 		   pcm_sample[2][k][j][jj] -= c0 * (pcm_sample[5][k][j][jj] + pcm_sample[6][k][j][jj]);r 		   break;	? 	  case 4:  pcm_sample[0][k][j][jj] -= pcm_sample[5][k][j][jj];e+ 		   tmp_sample1 = pcm_sample[2][k][j][jj];	+ 		   tmp_sample2 = pcm_sample[6][k][j][jj];a+ 		   pcm_sample[2][k][j][jj] = tmp_sample2; Z 		   pcm_sample[6][k][j][jj] = c1 * (tmp_sample1 - tmp_sample2) - pcm_sample[5][k][j][jj];8 		   pcm_sample[1][k][j][jj] -= pcm_sample[6][k][j][jj]; 		   break;_2 	  case 5:  tmp_sample1 = pcm_sample[0][k][j][jj];7 		   pcm_sample[0][k][j][jj] = pcm_sample[5][k][j][jj];jE 		   pcm_sample[5][k][j][jj] = tmp_sample1 - pcm_sample[5][k][j][jj];p+ 		   tmp_sample1 = pcm_sample[2][k][j][jj];j+ 		   tmp_sample2 = pcm_sample[6][k][j][jj];m+ 		   pcm_sample[2][k][j][jj] = tmp_sample2;mZ 		   pcm_sample[6][k][j][jj] = c1 * (tmp_sample1 - tmp_sample2) - pcm_sample[5][k][j][jj];8 		   pcm_sample[1][k][j][jj] -= pcm_sample[6][k][j][jj]; 		   break;t? 	  case 6:  pcm_sample[1][k][j][jj] -= pcm_sample[6][k][j][jj];[+ 		   tmp_sample1 = pcm_sample[2][k][j][jj];0+ 		   tmp_sample2 = pcm_sample[5][k][j][jj];0+ 		   pcm_sample[2][k][j][jj] = tmp_sample2;	Z 		   pcm_sample[5][k][j][jj] = c1 * (tmp_sample1 - tmp_sample2) - pcm_sample[6][k][j][jj];8 		   pcm_sample[0][k][j][jj] -= pcm_sample[5][k][j][jj]; 		   break;c2 	  case 7:  tmp_sample1 = pcm_sample[1][k][j][jj];7 		   pcm_sample[1][k][j][jj] = pcm_sample[6][k][j][jj];_E 		   pcm_sample[6][k][j][jj] = tmp_sample1 - pcm_sample[6][k][j][jj];[+ 		   tmp_sample1 = pcm_sample[2][k][j][jj]; + 		   tmp_sample2 = pcm_sample[5][k][j][jj];*+ 		   pcm_sample[2][k][j][jj] = tmp_sample2;pZ 		   pcm_sample[5][k][j][jj] = c1 * (tmp_sample1 - tmp_sample2) - pcm_sample[6][k][j][jj];8 		   pcm_sample[0][k][j][jj] -= pcm_sample[5][k][j][jj]; 		   break;p 	  }" 	else if (info->aug_mtx_proc == 1) 	  switch (tc_aug_alloc) 	  {? 	  case 0:  pcm_sample[0][k][j][jj] -= pcm_sample[5][k][j][jj]; 8 		   pcm_sample[1][k][j][jj] -= pcm_sample[6][k][j][jj]; 		   break; 2 	  case 1:  tmp_sample1 = pcm_sample[0][k][j][jj];7 		   pcm_sample[0][k][j][jj] = pcm_sample[5][k][j][jj];jE 		   pcm_sample[5][k][j][jj] = tmp_sample1 - pcm_sample[5][k][j][jj];e8 		   pcm_sample[1][k][j][jj] -= pcm_sample[6][k][j][jj]; 		   break;_? 	  case 2:  pcm_sample[0][k][j][jj] -= pcm_sample[5][k][j][jj];[+ 		   tmp_sample2 = pcm_sample[1][k][j][jj];p7 		   pcm_sample[1][k][j][jj] = pcm_sample[6][k][j][jj];eE 		   pcm_sample[6][k][j][jj] = tmp_sample2 - pcm_sample[6][k][j][jj];] 		   break;	2 	  case 3:  tmp_sample1 = pcm_sample[0][k][j][jj];7 		   pcm_sample[0][k][j][jj] = pcm_sample[5][k][j][jj]; E 		   pcm_sample[5][k][j][jj] = tmp_sample1 - pcm_sample[5][k][j][jj];]+ 		   tmp_sample2 = pcm_sample[1][k][j][jj];e7 		   pcm_sample[1][k][j][jj] = pcm_sample[6][k][j][jj]; E 		   pcm_sample[6][k][j][jj] = tmp_sample2 - pcm_sample[6][k][j][jj];] 		   break;	 	  }&       }     /* for k < sblimit loop */     }     /* for j < 3 loop */ }     R void denormalizing_aug (double pcm_sample[7][SBLIMIT][3][12], frame_params *fr_ps) { 9   double c[7], d, denorm;   /* denormalization factors */    int j, jj, k, l;   layer *info = fr_ps->header;     for (l = 0; l < 7; l++)f     c[l] = 1.0;   "   switch(info->dematrix_procedure)   {p5     /* factors according to International Standard */s     case 0:bR     case 2: c[2] = c[3] = c[4] = sqrt (2.0);	/* unweigh factor for C, Ls and Rs */ 	    break; F     case 1: c[2] = sqrt (2.0);			/* unweigh factor for C            */? 	    c[3] = c[4] = 2.0;			/* unweigh factor for Ls, Rs       */e 	    break;u   }      if (info->aug_mtx_proc == 0)0     /* factors according to 7-ch augmentation */<     c[5] = c[6] = 4.0 / 3;			/* unweigh factor for LC, RC */     /* denormalization factor */=   switch (info->dematrix_procedure * 10 + info->aug_mtx_proc)s   {      case 00:/     case 20: denorm = 1.75 + 1.25 * sqrt (2.0);o 	     break;/     case 10: denorm = 2.25 + 0.75 * sqrt (2.0);o 	     break;     case 30: denorm = 1.75;  	     break;     case 01:'     case 21: denorm = 2.0 + sqrt (2.0);m 	     break;-     case 11: denorm = 2.5 + 0.5 * sqrt (2.0);d 	     break;     case 31: denorm = 2.0; 	     break;     case 03:'     case 23: denorm = 1.0 + sqrt (2.0);2 	     break;-     case 13: denorm = 1.5 + 0.5 * sqrt (2.0);L 	     break;     case 33: denorm = 1.0; 	     break;   };     for (l = 0; l < 7; l++)[     c[l] *= denorm;]     /* denormalizing */iQ   if (fr_ps->header->dematrix_procedure != 3 || fr_ps->header->aug_mtx_proc != 3)      for (jj=0; jj<12; jj++)        for( j = 0; j < 3; ++j)n 	for (k = 0; k < SBLIMIT; k ++)o 	  for (l = 0; l < 7; l++)% 	    pcm_sample[l][k][j][jj] *= c[l];m }[ #endif