G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) H  * ISO 13818-3 MPEG-2 Audio Encoder - Lower Sampling Frequency Extension  *:  * $Id: musicin.c,v 1.2 1997/01/19 22:28:29 rowlands Exp $  *  * $Log: musicin.c,v $.  * Revision 1.2  1997/01/19 22:28:29  rowlands(  * Layer 3 bug fixes from Seymour Shlien  *.  * Revision 1.1  1996/02/14 04:04:23  rowlands  * Initial revision   *  * Received from Mike Coleman H  **********************************************************************/G /********************************************************************** G  *   date   programmers         comment                               * G  * 3/01/91  Douglas Wong,       start of version 1.1 records          * G  *          Davis Pan                                                 * G  * 3/06/91  Douglas Wong,       rename: setup.h to endef.h            * G  *                              removed extraneous variables          * G  * 3/21/91  J.Georges Fritsch   introduction of the bit-stream        * G  *                              package. This package allows you      * G  *                              to generate the bit-stream in a       * G  *                              binary or ascii format                * G  * 3/31/91  Bill Aspromonte     replaced the read of the SB matrix    * G  *                              by an "code generated" one            * G  * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         * G  *                              Incorporated Jean-Georges Fritsch's   * G  *                              "bitstream.c" package.                * G  *                              Modified to strictly adhere to        * G  *                              encoded bitstream specs, including    * G  *                              "Berlin changes".                     * G  *                              Modified user interface dialog & code * G  *                              to accept any input & output          * G  *                              filenames desired.  Also added        * G  *                              de-emphasis prompt and final bail-out * G  *                              opportunity before encoding.          * G  *                              Added AIFF PCM sound file reading     * G  *                              capability.                           * G  *                              Modified PCM sound file handling to   * G  *                              process all incoming samples and fill * G  *                              out last encoded frame with zeros     * G  *                              (silence) if needed.                  * G  *                              Located and fixed numerous software   * G  *                              bugs and table data errors.           * G  * 27jun91  dpwe (Aware Inc)    Used new frame_params struct.         * G  *                              Clear all automatic arrays.           * G  *                              Changed some variable names,          * G  *                              simplified some code.                 * G  *                              Track number of bits actually sent.   * G  *                              Fixed padding slot, stereo bitrate    * G  *                              Added joint-stereo : scales L+R.      * G  * 6/12/91  Earle Jennings      added fix for MS_DOS in obtain_param  * G  * 6/13/91  Earle Jennings      added stack length adjustment before  * G  *                              main for MS_DOS                       * G  * 7/10/91  Earle Jennings      conversion of all float to FLOAT      * G  *                              port to MsDos from MacIntosh completed* G  * 8/ 8/91  Jens Spille         Change for MS-C6.00                   * G  * 8/22/91  Jens Spille         new obtain_parameters()               * G  *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           * G  *          Don H. Lee,                                               * G  *          Peter W. Farrett                                          * G  *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   * G  *                              newly introduced functions are        * G  *                              I_CRC_calc, II_CRC_calc and encode_CRC* G  *                              Additions and revisions are marked    * G  *                              with "dhl" for clarity                * G  *11/11/91 Katherine Wang       Documentation of code.                * G  *                                (variables in documentation are     * G  *                                surround by the # symbol, and an '*'* G  *                                denotes layer I or II versions)     * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  * 2/25/92  Masahiro Iwadare    made code cleaner and more consistent * G  * 8/07/92  Mike Coleman        make exit() codes return error status * G  *                              made slight changes for portability   * G  *19 aug 92 Soren H. Nielsen    Changed MS-DOS file name extensions.  * G  * 8/25/92  Shaun Astarabadi    Replaced rint() function with explicit* G  *                              rounding for portability with MSDOS.  * G  * 9/22/92  jddevine@aware.com  Fixed _scale_factor_calc() calls.     * G  *10/19/92  Masahiro Iwadare    added info->mode and info->mode_ext   * G  *                              updates for AIFF format files         * G  * 3/10/93  Kevin Peterson      In parse_args, only set non default   * G  *                              bit rate if specified in arg list.    * G  *                              Use return value from aiff_read_hdrs  * G  *                              to fseek to start of sound data       * G  * 7/26/93  Davis Pan           fixed bug in printing info->mode_ext  * G  *                              value for joint stereo condition      * G  * 8/27/93 Seymour Shlien,      Fixes in Unix and MSDOS ports,        * G  *         Daniel Lauzon, and                                         * G  *         Bill Truerniet                                             * G  * 11/7/95 Soeren H. Nielsen    LSF added. Bug fix in MSDOS ext.      * G  * 8/02/95 mc@fivebats.com      Changed default bitrate selection so  * G  *                              it works with the new LSF stuff       * G  *10/01/95 mc@fivebats.com      Added layer3                          * H  **********************************************************************/  
 #ifdef MS_DOS  #include <dos.h> #endif #include <stdlib.h>  #include "common.h"  #include "encoder.h" #include "l3psy.h" #include "mdct.h"  #include "loop.h"  #include "l3bitstream.h" #include <assert.h>   1 /* Global variable definitions for "musicin.c" */    FILE               *musicin; Bit_stream_struc   bs;  char               *programName;   /* Implementations */   I /************************************************************************  *  * obtain_parameters  * D * PURPOSE:  Prompts for and reads user input for encoding parameters * & * SEMANTICS:  The parameters read are: * - input and output filenamesJ * - sampling frequency (if AIFF file, will read from the AIFF file header) * - layer number5 * - mode (stereo, joint stereo, dual channel or mono) " * - psychoacoustic model (I or II)+ * - total bitrate, irrespective of the mode G * - de-emphasis, error protection, copyright and original or copy flags  * I ************************************************************************/    voidM obtain_parameters(fr_ps,psy,num_samples,original_file_name,encoded_file_name)  frame_params    *fr_ps;  int             *psy;  unsigned long   *num_samples; 2 char            original_file_name[MAX_NAME_SIZE];1 char            encoded_file_name[MAX_NAME_SIZE];  { 
     int j;     long int freq;     int model, brt;      char t[50];      IFF_AIFF pcm_aiff_data;       layer *info = fr_ps->header;     long soundPosition; & #if (defined  MS_DOS) || (defined VMS)!     char temp_str[MAX_NAME_SIZE];  #endif    	     do  { 8        printf("Enter PCM input file name <required>: ");         gets(original_file_name);.        if (original_file_name[0] == NULL_CHAR)4        printf("PCM input file name is required.\n");1     } while (original_file_name[0] == NULL_CHAR); C     printf(">>> PCM input file name is: %s\n", original_file_name);    >     if ((musicin = fopen(original_file_name, "rb")) == NULL) {>        printf("Could not find \"%s\".\n", original_file_name);        exit(1);      }   & #if (defined  MS_DOS) || (defined VMS)H     /* replace old extension with new one, 1992-08-19, 1995-06-12 shn */4     new_ext(original_file_name, DFLT_EXT, temp_str);8     printf("Enter MPEG encoded output file name <%s>: ",            temp_str);  #else :     printf("Enter MPEG encoded output file name <%s%s>: ",)            original_file_name, DFLT_EXT);  #endif        gets(encoded_file_name);     ,     if (encoded_file_name[0] == NULL_CHAR) {& #if (defined  MS_DOS) || (defined VMS)&   strcpy(encoded_file_name, temp_str); #else H         strcat(strcpy(encoded_file_name, original_file_name), DFLT_EXT); #endif     }            L     printf(">>> MPEG encoded output file name is: %s\n", encoded_file_name);   ;     open_bit_stream_w(&bs, encoded_file_name, BUFFER_SIZE);    M     if ((soundPosition = aiff_read_headers(musicin, &pcm_aiff_data)) != -1) {   :        printf(">>> Using Audio IFF sound file headers\n");  F        aiff_check(original_file_name, &pcm_aiff_data, &info->version);  :        if (fseek(musicin, soundPosition, SEEK_SET) != 0) {A           printf("Could not seek to PCM sound data in \"%s\".\n", %                  original_file_name);            exit(1);        }  !        info->sampling_frequency = B       SmpFrqIndex((long)pcm_aiff_data.sampleRate, &info->version);8        printf(">>> %f Hz sampling frequency selected\n",(               pcm_aiff_data.sampleRate);  6        /* Determine number of samples in sound file */ #ifndef MS_DOS1        *num_samples = pcm_aiff_data.numChannels * 4                       pcm_aiff_data.numSampleFrames; #else 9        *num_samples = (long)(pcm_aiff_data.numChannels) * <                       (long)(pcm_aiff_data.numSampleFrames); #endif       } ;     else {    /* Not using Audio IFF sound file headers. */   ?        printf("What is the sampling frequency? <44100>[Hz]: ");         gets(t);         freq = atol(t);        switch (freq) {4           case 48000 : info->sampling_frequency = 1;B               printf(">>> %ld Hz sampling freq selected\n", freq);               break;4           case 44100 : info->sampling_frequency = 0;B               printf(">>> %ld Hz sampling freq selected\n", freq);               break;4           case 32000 : info->sampling_frequency = 2;B               printf(">>> %ld Hz sampling freq selected\n", freq);               break;4           case 24000 : info->sampling_frequency = 1;(         info->version = MPEG_PHASE2_LSF;B               printf(">>> %ld Hz sampling freq selected\n", freq);               break;4           case 22050 : info->sampling_frequency = 0;(         info->version = MPEG_PHASE2_LSF;B               printf(">>> %ld Hz sampling freq selected\n", freq);               break;4           case 16000 : info->sampling_frequency = 2;(         info->version = MPEG_PHASE2_LSF;B               printf(">>> %ld Hz sampling freq selected\n", freq);               break;3           default:    info->sampling_frequency = 0; B               printf(">>> Default 44.1 kHz samp freq selected\n");        }N        printf(">>> Encoding algorithm is %s\n", version_names[info->version]);.        if (fseek(musicin, 0, SEEK_SET) != 0) {A           printf("Could not seek to PCM sound data in \"%s\".\n", &                   original_file_name);           exit(1);        }   E        /* Declare sound file to have "infinite" number of samples. */ #        *num_samples = MAX_U_32_NUM;        }   0     printf("Which layer do you want to use?\n");=     printf("Available: Layer (1), Layer (<2>), Layer (3): ");      gets(t);     switch(*t){ H        case '1': info->lay = 1; printf(">>> Using Layer %s\n",t); break;H        case '2': info->lay = 2; printf(">>> Using Layer %s\n",t); break;F      case '3': info->lay = 3; printf(">>> Using Layer %s\n",t); break;M        default:  info->lay = 2; printf(">>> Using default Layer 2\n"); break;      }   (     printf("Which mode do you want?\n");6     printf("Available: (<s>)tereo, (j)oint stereo, ");1     printf("(d)ual channel, s(i)ngle Channel: ");      gets(t);     switch(*t){         case 's':        case 'S':9           info->mode = MPG_MD_STEREO; info->mode_ext = 0; *           printf(">>> Using mode %s\n",t);           break;        case 'j':        case 'J':+           info->mode = MPG_MD_JOINT_STEREO; *           printf(">>> Using mode %s\n",t);           break;        case 'd':        case 'D':?           info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext = 0; *           printf(">>> Using mode %s\n",t);           break;        case 'i':        case 'I':7           info->mode = MPG_MD_MONO; info->mode_ext = 0; *           printf(">>> Using mode %s\n",t);           break;        default: 9           info->mode = MPG_MD_STEREO; info->mode_ext = 0; 4           printf(">>> Using default stereo mode\n");           break;     }   C     printf("Which psychoacoustic model do you want to use? <2>: ");      gets(t);     model = atoi(t);!     if (model > 2 || model < 1) { 0        printf(">>> Default model 2 selected\n");        *psy = 2;     } 
     else {        *psy = model;<        printf(">>> Using psychoacoustic model %d\n", model);     }      C     /* set default bitrate to highest allowed, which is index 14 */ 0   brt = bitrate[info->version][info->lay-1][14];=     printf( "What is the total bitrate? <%u>[kbps]: ", brt );      gets( t );     brt = atoi( t );     if ( brt == 0 ) 
       j = 15;      else       j = 0;     while ( j < 15 )     { 8     if ( bitrate[info->version][info->lay-1][j] == brt )           break;     j++;     }      if ( j == 15 )     { 2     brt = bitrate[info->version][info->lay-1][14];5         printf( ">>> Using default %u kbps\n", brt ); !         info->bitrate_index = 14;      }      else     {         info->bitrate_index = j; S        printf( ">>> Bitrate = %d kbps\n", bitrate[info->version][info->lay-1][j] );      }    A     printf("What type of de-emphasis should the decoder use?\n"); H     printf("Available: (<n>)one, (5)0/15 microseconds, (c)citt j.17: ");     gets(t);.     if (*t != 'n' && *t != '5' && *t != 'c') {4        printf(">>> Using default no de-emphasis\n");        info->emphasis = 0;     } 
     else {.        if (*t == 'n')      info->emphasis = 0;.        else if (*t == '5') info->emphasis = 1;.        else if (*t == 'c') info->emphasis = 3;.        printf(">>> Using de-emphasis %s\n",t);     }    = /*  Start 2. Part changes for CD Ver 3.2; jsp; 22-Aug-1991 */    <     printf("Do you want to set the private bit? (y/<n>): ");     gets(t);4     if (*t == 'y' || *t == 'Y') info->extension = 1;4     else                        info->extension = 0;8     if(info->extension) printf(">>> Private bit set\n");<     else                printf(">>> Private bit not set\n");   3 /*  End changes for CD Ver 3.2; jsp; 22-Aug-1991 */    6     printf("Do you want error protection? (y/<n>): ");     gets(t);>     if (*t == 'y' || *t == 'Y') info->error_protection = TRUE;?     else                        info->error_protection = FALSE; E     if(info->error_protection) printf(">>> Error protection used\n"); 3     else printf(">>> Error protection not used\n");*  *5     printf("Is the material copyrighted? (y/<n>): ");i     gets(t);4     if (*t == 'y' || *t == 'Y') info->copyright = 1;4     else                        info->copyright = 0;=     if(info->copyright) printf(">>> Copyrighted material\n");*A     else                printf(">>> Material not copyrighted\n");l  s.     printf("Is this the original? (y/<n>): ");     gets(t);3     if (*t == 'y' || *t == 'Y') info->original = 1; 3     else                        info->original = 0;*9     if(info->original) printf(">>> Original material\n");*=     else               printf(">>> Material not original\n");*  *K     printf("Do you wish to exit (last chance before encoding)? (y/<n>): ");      gets(t);(     if (*t == 'y' || *t == 'Y') exit(0); }s  I /************************************************************************  *  * parse_args * A * PURPOSE:  Sets encoding parameters to the specifications of the 9 * command line.  Default settings are used for parameters $ * not specified in the command line. *nC * SEMANTICS:  The command line is parsed according to the following 	 * syntax:T * % * -l  is followed by the layer number  * -m  is followed by the mode 4 * -p  is followed by the psychoacoustic model number& * -s  is followed by the sampling rate@ * -b  is followed by the total bitrate, irrespective of the mode& * -d  is followed by the emphasis flag4 * -c  is followed by the copyright/no_copyright flag3 * -o  is followed by the original/not_original flag 5 * -e  is followed by the error_protection on/off flagp *tE * If the input file is in AIFF format, the sampling frequency is reade * from the AIFF header.  * F * The input and output filenames are read into #inpath# and #outpath#. * I ************************************************************************/     void@ parse_args(argc, argv, fr_ps, psy, num_samples, inPath, outPath)
 int     argc;  char    **argv;i frame_params  *fr_ps;l
 int     *psy;* unsigned long *num_samples;  char    inPath[MAX_NAME_SIZE]; char    outPath[MAX_NAME_SIZE];  {     FLOAT srate;i    int   brate;     layer *info = fr_ps->header;     int   err = 0, i = 0;    IFF_AIFF pcm_aiff_data;    long samplerate;     long soundPosition;  c    /* preset defaults */)    inPath[0] = '\0';   outPath[0] = '\0';u    info->lay = DFLT_LAY;    switch(DFLT_MOD) { F       case 's': info->mode = MPG_MD_STEREO; info->mode_ext = 0; break;J       case 'd': info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext=0; break;8       case 'j': info->mode = MPG_MD_JOINT_STEREO; break;D       case 'm': info->mode = MPG_MD_MONO; info->mode_ext = 0; break;       default:J          fprintf(stderr, "%s: Bad mode dflt %c\n", programName, DFLT_MOD);          abort();     }    *psy = DFLT_PSY; \    if((info->sampling_frequency = SmpFrqIndex((long)(1000*DFLT_SFQ), &info->version)) < 0) {L       fprintf(stderr, "%s: bad sfrq default %.2f\n", programName, DFLT_SFQ);       abort();    }   info->bitrate_index = 14;    brate = 0;    switch(DFLT_EMP) {e*       case 'n': info->emphasis = 0; break;*       case '5': info->emphasis = 1; break;*       case 'c': info->emphasis = 3; break;       default: uJ          fprintf(stderr, "%s: Bad emph dflt %c\n", programName, DFLT_EMP);          abort();t    }K    info->copyright = 0; info->original = 0; info->error_protection = FALSE;   *    /* process args */s     while(++i<argc && err == 0) {%       char c, *token, *arg, *nextArg;s       int  argUsed;g  a       token = argv[i];       if(*token++ == '-') { ,          if(i+1 < argc) nextArg = argv[i+1];%          else           nextArg = "";o          argUsed = 0; "          while( (c = *token++) ) {9             if(*token /* NumericQ(token) */) arg = token;s;             else                             arg = nextArg;8             switch(c) { C                case 'l':        info->lay = atoi(arg); argUsed = 1;n2                   if(info->lay<1 || info->lay>3) {P                      fprintf(stderr,"%s: -l layer must be 1, 2, or 3, not %s\n",,                           programName, arg);                      err = 1;                    }m                   break;,                case 'm':        argUsed = 1;"                   if (*arg == 's')G                     { info->mode = MPG_MD_STEREO; info->mode_ext = 0; } '                   else if (*arg == 'd')nK                     { info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext=0; }f'                   else if (*arg == 'j')K9                     { info->mode = MPG_MD_JOINT_STEREO; } '                   else if (*arg == 'm')aE                     { info->mode = MPG_MD_MONO; info->mode_ext = 0; }r                   else {J                     fprintf(stderr,"%s: -m mode must be s/d/j/m not %s\n",.                             programName, arg);                     err = 1;                   }                    break;>                case 'p':        *psy = atoi(arg); argUsed = 1;(                   if(*psy<1 || *psy>2) {L                      fprintf(stderr,"%s: -p model must be 1 or 2, not %s\n",/                              programName, arg);t                      err = 1;                    }o                   break;                  case 's':                   argUsed = 1;&                   srate = atof( arg );@                   /* samplerate = rint( 1000.0 * srate ); $A  */A                   samplerate = (long) (( 1000.0 * srate ) + 0.5); 1                   if( (info->sampling_frequency =n?           SmpFrqIndex((long) samplerate, &info->version)) < 0 )                        err = 1;                   break;                                    case 'b':                 argUsed = 1;       brate = atoi(arg); e       break;,                case 'd':        argUsed = 1;I                   if (*arg == 'n')                    info->emphasis = 0;pI                   else if (*arg == '5')               info->emphasis = 1;cI                   else if (*arg == 'c')               info->emphasis = 3;a                   else {H                      fprintf(stderr,"%s: -d emp must be n/5/c not %s\n",/                              programName, arg);                       err = 1;                    }                    break;;                 case 'c':       info->copyright = 1; break;l;                 case 'o':       info->original  = 1; break;oE                 case 'e':       info->error_protection = TRUE; break; G                 default:        fprintf(stderr,"%s: unrec option %c\n", 8                                         programName, c);/                                 err = 1; break; 
             }              if(argUsed) { I                if(arg == token)    token = "";   /* no more from token */ G                else                ++i;          /* skip arg we used */d%                arg = ""; argUsed = 0;8
             }a
          }       }e       else {=          if(inPath[0] == '\0')       strcpy(inPath, argv[i]); >          else if(outPath[0] == '\0') strcpy(outPath, argv[i]);          else { H             fprintf(stderr,"%s: excess arg %s\n", programName, argv[i]);             err = 1;
          }       }u    }  =    if(err || inPath[0] == '\0') usage();  /* never returns */e  n    if(outPath[0] == '\0') { 
 #ifdef MS_DOShJ       /* replace old extension with new one, 1992-08-19, 1995-06-12 shn */)       new_ext(inPath, DFLT_EXT, outPath);" #else        strcpy(outPath, inPath);        strcat(outPath, DFLT_EXT); #endif    }  1    if ((musicin = fopen(inPath, "rb")) == NULL) {*1       printf("Could not find \"%s\".\n", inPath);*       exit(1);    }  t0    open_bit_stream_w(&bs, outPath, BUFFER_SIZE);  L    if ((soundPosition = aiff_read_headers(musicin, &pcm_aiff_data)) != -1) {  9       printf(">>> Using Audio IFF sound file headers\n");e  9       aiff_check(inPath, &pcm_aiff_data, &info->version);   9       if (fseek(musicin, soundPosition, SEEK_SET) != 0) {oI          printf("Could not seek to PCM sound data in \"%s\".\n", inPath);           exit(1);p       },  ]       info->sampling_frequency = SmpFrqIndex((long)pcm_aiff_data.sampleRate, &info->version);*7       printf(">>> %f Hz sampling frequency selected\n",,'              pcm_aiff_data.sampleRate);l  5       /* Determine number of samples in sound file */  #ifndef MS_DOS0       *num_samples = pcm_aiff_data.numChannels *3                      pcm_aiff_data.numSampleFrames;[ #elseE8       *num_samples = (long)(pcm_aiff_data.numChannels) *;                      (long)(pcm_aiff_data.numSampleFrames);  #endif-       if ( pcm_aiff_data.numChannels == 1 ) { !         info->mode = MPG_MD_MONO;M         info->mode_ext = 0;E       }     }:    else {    /* Not using Audio IFF sound file headers. */  -       if (fseek(musicin, 0, SEEK_SET) != 0) { I          printf("Could not seek to PCM sound data in \"%s\".\n", inPath);l          exit(1);\       }   hD       /* Declare sound file to have "infinite" number of samples. */"       *num_samples = MAX_U_32_NUM;      }    if ( brate == 0 )4     brate = bitrate[info->version][info->lay-1][14];X    if( (info->bitrate_index = BitrateIndex(info->lay, brate, info->version)) < 0) err=1;=    if(err || inPath[0] == '\0') usage();  /* never returns */w   }e  I /************************************************************************T *e * print_config *f/ * PURPOSE:  Prints the encoding parameters used  * I ************************************************************************/%  >N void print_config( frame_params *fr_ps, int *psy, char *inPath, char *outPath) {_  layer *info = fr_ps->header;i  n'    printf("Encoding configuration:\n");D:    printf("Algorithm=%s\n", version_names[info->version]);(    if(info->mode != MPG_MD_JOINT_STEREO)=       printf("Layer=%s   mode=%s   extn=%d   psy model=%d\n", >              layer_names[info->lay-1], mode_names[info->mode],#              info->mode_ext, *psy);sK    else printf("Layer=%s   mode=%s   extn=data dependant   psy model=%d\n",aG                layer_names[info->lay-1], mode_names[info->mode], *psy);>8    printf("samp frq=%.1f kHz   total bitrate=%d kbps\n",:           s_freq[info->version][info->sampling_frequency],D           bitrate[info->version][info->lay-1][info->bitrate_index]);=    printf("de-emph=%d   c/right=%d   orig=%d   errprot=%s\n", :           info->emphasis, info->copyright, info->original,5           ((info->error_protection) ? "on" : "off"));nE    printf("input file: '%s'   output file: '%s'\n", inPath, outPath);> }            I /************************************************************************/ *e * main *bA * PURPOSE:  MPEG I Encoder supporting layers 1 and 2, and 3, with 0 * psychoacoustic models 1 (MUSICAM) and 2 (AT&T) * D * SEMANTICS:  One overlapping frame of audio of up to 2 channels are- * processed at a time in the following order: * * (associated routines are in parentheses) *d5 * 1.  Filter sliding window of data to get 32 subbandd * samples per channel.! * (window_subband,filter_subband)r *e; * 2.  If joint stereo mode, combine left and right channelst * for subbands above #jsbound#.  * (*_combine_LR) *-; * 3.  Calculate scalefactors for the frame, and if layer 2,m0 * also calculate scalefactor select information. * (*_scale_factor_calc): *f< * 4.  Calculate psychoacoustic masking levels using selected * psychoacoustic model.  * (*_Psycho_One, psycho_anal)  * < * 5.  Perform iterative bit allocation for subbands with low8 * mask_to_noise ratios using masking levels from step 4. * (*_main_bit_allocation)  *e< * 6.  If error protection flag is active, add redundancy for * error protection.  * (*_CRC_calc) *"? * 7.  Pack bit allocation, scalefactors, and scalefactor select;' * information (layer 2) onto bitstream.r= * (*_encode_bit_alloc,*_encode_scale,II_transmission_pattern)  * 4 * 8.  Quantize subbands and pack them into bitstream- * (*_subband_quantization, *_sample_encoding)i *-I ************************************************************************/    int frameNum=0;l   #ifndef VMSr void #else" intq #endif  main(argc, argv) 
 int     argc;: char    **argv;g {e3     typedef double SBS[2][3][SCALE_BLOCK][SBLIMIT];k     SBS  FAR        *sb_sample; $     L3SBS  FAR        *l3_sb_sample;1     typedef double JSBS[3][SCALE_BLOCK][SBLIMIT];      JSBS FAR        *j_sample;#     typedef double IN[2][HAN_SIZE];      IN   FAR        *win_que;"9     typedef unsigned int SUB[2][3][SCALE_BLOCK][SBLIMIT];x     SUB  FAR        *subband;           frame_params fr_ps;i     layer info;a+     char original_file_name[MAX_NAME_SIZE];M*     char encoded_file_name[MAX_NAME_SIZE];     short FAR **win_buf;%     static short FAR buffer[2][1152];>A     static unsigned int bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT];:C     static unsigned int scalar[2][3][SBLIMIT], j_scale[3][SBLIMIT]; O     static double FAR ltmin[2][SBLIMIT], lgmin[2][SBLIMIT], max_sc[2][SBLIMIT];-     FLOAT snr32[32];)     short sam[2][1344]; /* was [1056]; */t"     int whole_SpF, extra_slot = 0;3     double avg_slots_per_frame, frac_SpF, slot_lag;h(     int model, stereo, error_protection;     static unsigned int crc;     int i, j, k, adb;"/     unsigned long bitsPerSlot, samplesPerFrame;t*     unsigned long frameBits, sentBits = 0;     unsigned long num_samples;      #ifdef  MACINTOSH>     argc = ccommand( &argv );f #endif       >     /* Most large variables are declared dynamically to ensure-        compatibility with smaller machines */      @     sb_sample = (SBS FAR *) mem_alloc(sizeof(SBS), "sb_sample");H     l3_sb_sample = (L3SBS FAR *) mem_alloc(sizeof(SBS), "l3_sb_sample");@     j_sample = (JSBS FAR *) mem_alloc(sizeof(JSBS), "j_sample");:     win_que = (IN FAR *) mem_alloc(sizeof(IN), "Win_que");;     subband = (SUB FAR *) mem_alloc(sizeof(SUB),"subband");nE     win_buf = (short FAR **) mem_alloc(sizeof(short *)*2, "win_buf");         /* clear buffers */O/     memset((char *) buffer, 0, sizeof(buffer));n5     memset((char *) bit_alloc, 0, sizeof(bit_alloc)); /     memset((char *) scalar, 0, sizeof(scalar));t1     memset((char *) j_scale, 0, sizeof(j_scale));t-     memset((char *) scfsi, 0, sizeof(scfsi));p-     memset((char *) ltmin, 0, sizeof(ltmin)); -     memset((char *) lgmin, 0, sizeof(lgmin));o/     memset((char *) max_sc, 0, sizeof(max_sc));e-     memset((char *) snr32, 0, sizeof(snr32));u)     memset((char *) sam, 0, sizeof(sam));e  4     fr_ps.header = &info;>9     fr_ps.tab_num = -1;             /* no table loaded */b     fr_ps.alloc = NULL;t9     info.version = MPEG_AUDIO_ID;   /* Default: MPEG-1 */        programName = argv[0];.     if(argc==1)     /* no command-line args */6        obtain_parameters(&fr_ps, &model, &num_samples,@                          original_file_name, encoded_file_name);     else5 	parse_args(argc, argv, &fr_ps, &model, &num_samples, , 		   original_file_name, encoded_file_name);      print_config(&fr_ps, &model,8                  original_file_name, encoded_file_name);          hdr_to_frps(&fr_ps);     stereo = fr_ps.stereo;-     error_protection = info.error_protection;"          if (info.lay == 1)1     { bitsPerSlot = 32; samplesPerFrame = 384;  }n	     else / 	if ( info.lay == 2 )t. 	{ bitsPerSlot = 8;  samplesPerFrame = 1152; } 	else	 	{  /* layer 3 */  	    bitsPerSlot = 8;d6 	    samplesPerFrame = info.version == 1 ? 1152 : 576; 	     ) 	    /* Apologize for missing features */-, 	    if ( info.mode == MPG_MD_JOINT_STEREO ) 	    {J 		fprintf( stderr, "Sorry, joint stereo not yet available for layer3\n" ); 		exit( 1 ); 	    } #if 0 ) 	    if ( info.version != MPEG_AUDIO_ID )D 	    {G 		fprintf( stderr, "Sorry, MPEG2-LSF not yet available for layer3\n" );t 		exit( 1 ); 	    } #endif 	    if ( model != 2 ) 	    {H 		fprintf( stderr, "Sorry, psycho model 1 not available for layer3\n" ); 		exit( 1 ); 	    } 	}5     /* Figure average number of 'slots' per frame. */ >     /* Bitrate means TOTAL for both channels, not per side. */4     avg_slots_per_frame = ((double)samplesPerFrame /K                            s_freq[info.version][info.sampling_frequency]) * F 			   ((double)bitrate[info.version][info.lay-1][info.bitrate_index] / 			    (double)bitsPerSlot);*     whole_SpF = (int) avg_slots_per_frame;+     printf("slots/frame = %d\n",whole_SpF);t8     frac_SpF  = avg_slots_per_frame - (double)whole_SpF;     slot_lag  = -frac_SpF;C     printf("frac SpF=%.3f, tot bitrate=%d kbps, s freq=%.1f kHz\n",yK            frac_SpF, bitrate[info.version][info.lay-1][info.bitrate_index],-:            s_freq[info.version][info.sampling_frequency]);          if (frac_SpF != 0): 	printf("Fractional number of slots, padding required\n");     else info.padding = 0;     H     while ( get_audio(musicin, buffer, num_samples, stereo, &info) > 0 )     { 7 	fprintf(stderr, "{%4lu}", frameNum++); fflush(stderr);( 	win_buf[0] = &buffer[0][0]; 	win_buf[1] = &buffer[1][0]; 	if (frac_SpF != 0) {n& 	    if (slot_lag > (frac_SpF-1.0) ) { 		slot_lag -= frac_SpF;  		extra_slot = 0;  		info.padding = 0; / 		/*  printf("No padding for this frame\n"); */* 	    } 	    else {* 		extra_slot = 1;* 		info.padding = 1;* 		slot_lag += (1-frac_SpF); / 		/*  printf("Padding for this frame\n");    */f 	    } 	}, 	adb = (whole_SpF+extra_slot) * bitsPerSlot; 	f 	switch (info.lay) 	{ 	     J /***************************** Layer I **********************************/ 	                case 1 :  	    for (j=0;j<SCALE_BLOCK;j++) 		for (k=0;k<stereo;k++) {8 		    window_subband(&win_buf[k], &(*win_que)[k][0], k);C 		    filter_subband(&(*win_que)[k][0], &(*sb_sample)[k][0][j][0]);e 		}t 	    l5 	    I_scale_factor_calc(*sb_sample, scalar, stereo);y3 	    if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO) {t4                 I_combine_LR(*sb_sample, *j_sample);;                 I_scale_factor_calc(j_sample, &j_scale, 1);  	    } 	    t' 	    put_scale(scalar, &fr_ps, max_sc);t 	    lA 	    if (model == 1) I_Psycho_One(buffer, max_sc, ltmin, &fr_ps);n 	    else {n(                 for (k=0;k<stereo;k++) {? 		    psycho_anal(&buffer[k][0],&sam[k][0], k, info.lay, snr32,*? 				(FLOAT)s_freq[info.version][info.sampling_frequency]*1000);s> 		    for (i=0;i<SBLIMIT;i++) ltmin[k][i] = (double) snr32[i];                 }  	    } 	     ; 	    I_main_bit_allocation(ltmin, bit_alloc, &adb, &fr_ps);  	     ? 	    if (error_protection) I_CRC_calc(&fr_ps, bit_alloc, &crc);  	    r 	    encode_info(&fr_ps, &bs); 	    =0 	    if (error_protection) encode_CRC(crc, &bs); 	    e0 	    I_encode_bit_alloc(bit_alloc, &fr_ps, &bs);4 	    I_encode_scale(scalar, bit_alloc, &fr_ps, &bs);C 	    I_subband_quantization(scalar, *sb_sample, j_scale, *j_sample,>$ 				   bit_alloc, *subband, &fr_ps);9 	    I_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);L) 	    for (i=0;i<adb;i++) put1bit(&bs, 0);  	    break;M 	    OJ /***************************** Layer 2 **********************************/ 	    r           case 2 :2 	    for (i=0;i<3;i++) for (j=0;j<SCALE_BLOCK;j++)(                 for (k=0;k<stereo;k++) {8 		    window_subband(&win_buf[k], &(*win_que)[k][0], k);C 		    filter_subband(&(*win_que)[k][0], &(*sb_sample)[k][i][j][0]);                  }  	    dE 	    II_scale_factor_calc(*sb_sample, scalar, stereo, fr_ps.sblimit); ( 	    pick_scale(scalar, &fr_ps, max_sc);3 	    if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO) {s6 		II_combine_LR(*sb_sample, *j_sample, fr_ps.sblimit);= 		II_scale_factor_calc(j_sample, &j_scale, 1, fr_ps.sblimit); ? 	    }       /* this way we calculate more mono than we need */F 	    /* but it is cheap */ 	     B 	    if (model == 1) II_Psycho_One(buffer, max_sc, ltmin, &fr_ps); 	    else {  		for (k=0;k<stereo;k++) {/ 		    psycho_anal(&buffer[k][0],&sam[k][0], k, n 				info.lay, snr32,? 				(FLOAT)s_freq[info.version][info.sampling_frequency]*1000); > 		    for (i=0;i<SBLIMIT;i++) ltmin[k][i] = (double) snr32[i]; 		}s 	    } 	    t4 	    II_transmission_pattern(scalar, scfsi, &fr_ps);C 	    II_main_bit_allocation(ltmin, scfsi, bit_alloc, &adb, &fr_ps);t 	      	    if (error_protection). 		II_CRC_calc(&fr_ps, bit_alloc, scfsi, &crc); 	      	    encode_info(&fr_ps, &bs); 	    o0 	    if (error_protection) encode_CRC(crc, &bs); 	    f1 	    II_encode_bit_alloc(bit_alloc, &fr_ps, &bs);r< 	    II_encode_scale(bit_alloc, scfsi, scalar, &fr_ps, &bs);9 	    II_subband_quantization(scalar, *sb_sample, j_scale, 0 				    *j_sample, bit_alloc, *subband, &fr_ps);: 	    II_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);) 	    for (i=0;i<adb;i++) put1bit(&bs, 0);  	    break;n 	    eJ /***************************** Layer 3 **********************************/  
 	  case 3: 	  {	 	      /*n: 		large "auto" vars are static due to the Macintosh linker
 	      */ # 	      static double xr[2][2][576]; ' 	      static double xr_dec[2][2][576];  	      static double pe[2][2];$ 	      static int l3_enc[2][2][576];" 	      static III_psy_ratio ratio;& 	      static III_side_info_t l3_side;' 	      static III_scalefac_t  scalefac;m 	      int gr, mode_gr, ch;,# 	      int mean_bits, sideinfo_len;N 	      ;= 	      int bitsPerFrame = 8 * whole_SpF + (info.padding * 8); - 	      mode_gr = (info.version == 1) ? 2 : 1;   	 	      /*r* 		determine the mean bitrate for main data	 	      */) 	      sideinfo_len = 32;r 	      if ( info.version == 1 )  	      {   /* MPEG 1 */  		  if ( stereo == 1 ) 		      sideinfo_len += 136; 		  else 		      sideinfo_len += 256; 	      } 	      elser 	      {   /* MPEG 2 */s 		  if ( stereo == 1 ) 		      sideinfo_len += 72;  		  else 		      sideinfo_len += 136; 	      }# 	      if ( info.error_protection )  		  sideinfo_len += 16;p; 	      mean_bits = (bitsPerFrame - sideinfo_len) / mode_gr;   	 	      /*s 		psychoacoustic model	 	      */F) 	      for ( gr = 0; gr < mode_gr; gr++ ) % 		  for ( ch = 0; ch < stereo; ch++ )  		  { F 		      L3psycho_anal( &buffer[ch][gr*576], &sam[ch][0], ch, info.lay,G 				     snr32, s_freq[info.version][info.sampling_frequency] * 1000.0, 2 				     &ratio.l[gr][ch][0], &ratio.s[gr][ch][0],2 				     &pe[gr][ch], &l3_side.gr[gr].ch[ch].tt ); 		  }   	 	      /*  		polyphase filtering'	 	      */ ( 	      for( gr = 0; gr < mode_gr; gr++ )% 		  for ( ch = 0; ch < stereo; ch++ )n" 		      for ( j = 0; j < 18; j++ )	 		      { < 			  window_subband( &win_buf[ch], &(*win_que)[ch][0], ch );M 			  filter_subband( &(*win_que)[ch][0],  &(*l3_sb_sample)[ch][gr+1][j][0] ); 	 		      }   	 	      /* % 		apply mdct to the polyphase outputs 	 	      */a? 	      mdct_sub( l3_sb_sample, xr, stereo, &l3_side, mode_gr );' #if 0  	      delay( xr, stereo );o #endif	 	      /*a 		bit and noise allocation	 	      */TC 	      iteration_loop( pe, xr, &ratio, &l3_side, l3_enc, mean_bits,e> 			      stereo, xr_dec, &scalefac, &fr_ps, 0, bitsPerFrame );  	 	      /* " 		write the frame to the bitstream	 	      */ T 	      III_format_bitstream( bitsPerFrame, &fr_ps, l3_enc, &l3_side, &scalefac, &bs, 				    xr, NULL, 0 ); 	  }! 	    break;  /* end of layer 3 */  	        	} /* end switch  */ 	d& 	frameBits = sstell( &bs ) - sentBits;9 	if ( frameBits % bitsPerSlot )   /* a program failure */ = 	    fprintf( stderr, "Sent %ld bits = %ld slots plus %ld\n", ( 		     frameBits, frameBits/bitsPerSlot, 		     frameBits%bitsPerSlot );  	sentBits += frameBits;t  	     }    e       if ( info.lay == 3 ) 	III_FlushBitstream();       close_bit_stream_w( &bs );  D     printf("Avg slots/frame = %.3f; b/smp = %.2f; br = %.3f kbps\n",7            (FLOAT) sentBits / (frameNum * bitsPerSlot),p;            (FLOAT) sentBits / (frameNum * samplesPerFrame),/<            (FLOAT) sentBits / (frameNum * samplesPerFrame) *:            s_freq[info.version][info.sampling_frequency]);       if (fclose(musicin) != 0){9 	printf("Could not close \"%s\".\n", original_file_name);d	 	exit(2);,     })   #ifdef  MACINTOSH F     set_mac_file_attr( encoded_file_name, VOL_REF_NUM, CREATOR_ENCODE, 		       FILETYPE_ENCODE );( #endif  K     printf("Encoding of \"%s\" with psychoacoustic model %d is finished\n",e&            original_file_name, model);;     printf("The MPEG encoded output file name is \"%s\"\n",u 	   encoded_file_name);0     exit(0); }i  (I /************************************************************************) *  * usage  * H * PURPOSE:  Writes command line syntax to the file specified by #stderr# *nI ************************************************************************/   ' void usage()  /* print syntax & exit */  {      fprintf(stderr,fH     "usage: %s                         queries for all arguments, or\n",             programName);      fprintf(stderr,_D     "       %s [-l lay][-m mode][-p psy][-s sfrq][-b br][-d emp]\n",             programName);      fprintf(stderr,c1     "          [-c][-o][-e] inputPCM [outBS]\n");p     fprintf(stderr,"where\n");O     fprintf(stderr," -l lay   use layer <lay> coding   (dflt %4u)\n",DFLT_LAY); O     fprintf(stderr," -m mode  channel mode : s/d/j/m   (dflt %4c)\n",DFLT_MOD);(O     fprintf(stderr," -p psy   psychoacoustic model 1/2 (dflt %4u)\n",DFLT_PSY); Q     fprintf(stderr," -s sfrq  input smpl rate in kHz   (dflt %4.1f)\n",DFLT_SFQ);fJ     fprintf(stderr," -b br    total bitrate in kbps    (dflt highest)\n");O     fprintf(stderr," -d emp   de-emphasis n/5/c        (dflt %4c)\n",DFLT_EMP);14     fprintf(stderr," -c       mark as copyright\n");3     fprintf(stderr," -o       mark as original\n"); 7     fprintf(stderr," -e       add error protection\n");eJ     fprintf(stderr," inputPCM input PCM sound file (standard or AIFF)\n");U     fprintf(stderr," outBS    output bit stream of encoded audio (dflt inName+%s)\n",*             DFLT_EXT);     exit(1); }*  I /************************************************************************p *  * aiff_check *rD * PURPOSE:  Checks AIFF header information to make sure it is valid. *           Exits if not.p *tI ************************************************************************/_  H void aiff_check( char *file_name, IFF_AIFF *pcm_aiff_data, int *version) { 3     if (pcm_aiff_data->sampleType != IFF_ID_SSND) {n?        printf("Sound data is not PCM in \"%s\".\n", file_name);"        exit(1);s     }=  C     if(SmpFrqIndex((long)pcm_aiff_data->sampleRate, version) < 0) {y)        printf("in \"%s\".\n", file_name);i        exit(1);f     }t  F     if (pcm_aiff_data->sampleSize != sizeof(short) * BITS_IN_A_BYTE) {8         printf("Sound data is not %d bits in \"%s\".\n",:                sizeof(short) * BITS_IN_A_BYTE, file_name);         exit(1);     }   -     if (pcm_aiff_data->numChannels != MONO &&-/         pcm_aiff_data->numChannels != STEREO) { J        printf("Sound data is not mono or stereo in \"%s\".\n", file_name);        exit(1);      }   0     if (pcm_aiff_data->blkAlgn.blockSize != 0) {G        printf("Block size is not %d bytes in \"%s\".\n", 0, file_name);p        exit(1);a     }n  -     if (pcm_aiff_data->blkAlgn.offset != 0) {nI        printf("Block offset is not %d bytes in \"%s\".\n", 0, file_name);n        exit(1);s     }a }m