G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) H  * ISO 13818-3 MPEG-2 Audio Encoder - Lower Sampling Frequency Extension  *8  * $Id: l3psy.c,v 1.2 1997/01/19 22:28:29 rowlands Exp $  *  * $Log: l3psy.c,v $.  * Revision 1.2  1997/01/19 22:28:29  rowlands(  * Layer 3 bug fixes from Seymour Shlien  *.  * Revision 1.1  1996/02/14 04:04:23  rowlands  * Initial revision   *  * Received from Mike Coleman H  **********************************************************************/G /********************************************************************** G  *   date   programmers         comment                               * G  * 2/25/91  Davis Pan           start of version 1.0 records          * G  * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         * G  * 7/10/91  Earle Jennings      Ported to MsDos.                      * G  *                              replace of floats with FLOAT          * G  * 2/11/92  W. Joseph Carter    Fixed mem_alloc() arg for "absthr".   * D  * 3/16/92  Masahiro Iwadare	Modification for Layer III            *G  * 17/4/93  Masahiro Iwadare    Updated for IS Modification           * H  **********************************************************************/   #include "common.h"  #include "encoder.h" #include "l3psy.h" #include "l3side.h"  #include <assert.h>   & #define maximum(x,y) ( (x>y) ? x : y )& #define minimum(x,y) ( (x<y) ? x : y )  P void L3para_read( double sfreq, int numlines[CBANDS], int partition_l[HBLKSIZE],H 		  double minval[CBANDS], double qthr_l[CBANDS], double norm_l[CBANDS],V 		  double s3_l[CBANDS][CBANDS], int partition_s[HBLKSIZE_s], double qthr_s[CBANDS_s],4 		  double norm_s[CBANDS_s], double SNR_s[CBANDS_s],= 		  int cbw_l[SBMAX_l], int bu_l[SBMAX_l], int bo_l[SBMAX_l], / 		  double w1_l[SBMAX_l], double w2_l[SBMAX_l], = 		  int cbw_s[SBMAX_s], int bu_s[SBMAX_s], int bo_s[SBMAX_s], 1 		  double w1_s[SBMAX_s], double w2_s[SBMAX_s] ); 	 									 b void L3psycho_anal( short int *buffer, short int savebuf[1344], int chn, int lay, FLOAT snr32[32],? 		    double sfreq, double ratio_d[21], double ratio_ds[12][3], % 		    double *pe, gr_info *cod_info )  {      static double ratio[2][21]; $     static double ratio_s[2][12][3];     int blocktype;     unsigned int   b, i, j, k;6     double         r_prime, phi_prime; /* not FLOAT */=     FLOAT          freq_mult, bval_lo, min_thres, sum_energy; )     double         tb, temp1,temp2,temp3;   #     /*         nint(); Layer III */      double   thr[CBANDS];   L /* The static variables "r", "phi_sav", "new", "old" and "oldest" have    */L /* to be remembered for the unpredictability measure.  For "r" and        */L /* "phi_sav", the first index from the left is the channel select and     */L /* the second index is the "age" of the data.                             */    %    static FLOAT window_s[BLKSIZE_s] ; -  static int     new = 0, old = 1, oldest = 0; A  static int     init = 0, flush, sync_flush, syncsize, sfreq_idx; )  static double 	cw[HBLKSIZE], eb[CBANDS];   static double 	ctb[CBANDS];.  static double	SNR_l[CBANDS], SNR_s[CBANDS_s];  static int	init_L3;<  static double	minval[CBANDS],qthr_l[CBANDS],norm_l[CBANDS];1  static double	qthr_s[CBANDS_s],norm_s[CBANDS_s]; 0  static double	nb_1[2][CBANDS], nb_2[2][CBANDS];D  static double	s3_l[CBANDS][CBANDS]; /* s3_s[CBANDS_s][CBANDS_s]; */   /* Scale Factor Bands */8  static int	cbw_l[SBMAX_l],bu_l[SBMAX_l],bo_l[SBMAX_l] ;8  static int	cbw_s[SBMAX_s],bu_s[SBMAX_s],bo_s[SBMAX_s] ;,  static double	w1_l[SBMAX_l], w2_l[SBMAX_l];,  static double	w1_s[SBMAX_s], w2_s[SBMAX_s];,  static double	en[SBMAX_l],   thm[SBMAX_l] ;  static int	blocktype_old[2] ;  int	sb,sblock; :  static int	partition_l[HBLKSIZE],partition_s[HBLKSIZE_s];    M /* The following static variables are constants.                           */     static double  nmt = 5.5;  I  static FLOAT   crit_band[27] = {0,  100,  200, 300, 400, 510, 630,  770, I                                920, 1080, 1270,1480,1720,2000,2320, 2700, I                               3150, 3700, 4400,5300,6400,7700,9500,12000, 0                              15500,25000,30000};  E  static FLOAT   bmax[27] = {20.0, 20.0, 20.0, 20.0, 20.0, 17.0, 15.0, E                             10.0,  7.0,  4.4,  4.5,  4.5,  4.5,  4.5, E                              4.5,  4.5,  4.5,  4.5,  4.5,  4.5,  4.5, @                              4.5,  4.5,  4.5,  3.5,  3.5,  3.5};  L /* The following pointer variables point to large areas of memory         */L /* dynamically allocated by the mem_alloc() function.  Dynamic memory     */L /* allocation is used in order to avoid stack frame or data area          */L /* overflow errors that otherwise would have occurred at compile time     */L /* on the Macintosh computer.                                             */  <  FLOAT          *grouped_c, *grouped_e, *nb, *cb, *ecb, *bc;2  FLOAT          *wsamp_r, *wsamp_i, *phi, *energy;  static FLOAT	energy_s[3][256]; 7  static FLOAT phi_s[3][256] ; /* 256 samples not 129 */   FLOAT          *c, *fthr;  F32            *snrtmp;    static	int	*numlines ;   static int     *partition;   static FLOAT   *cbval, *rnorm;   static FLOAT   *window;  static FLOAT   *absthr;  static double  *tmn;   static FCB     *s;   static FHBLK   *lthr;  static F2HBLK  *r, *phi_sav;   L /* These dynamic memory allocations simulate "automatic" variables        */L /* placed on the stack.  For each mem_alloc() call here, there must be    */L /* a corresponding mem_free() call at the end of this function.           */  ;  grouped_c = (FLOAT *) mem_alloc(sizeof(FCB), "grouped_c"); ;  grouped_e = (FLOAT *) mem_alloc(sizeof(FCB), "grouped_e"); -  nb = (FLOAT *) mem_alloc(sizeof(FCB), "nb"); -  cb = (FLOAT *) mem_alloc(sizeof(FCB), "cb"); /  ecb = (FLOAT *) mem_alloc(sizeof(FCB), "ecb"); -  bc = (FLOAT *) mem_alloc(sizeof(FCB), "bc"); 8  wsamp_r = (FLOAT *) mem_alloc(sizeof(FBLK), "wsamp_r");8  wsamp_i = (FLOAT *) mem_alloc(sizeof(FBLK), "wsamp_i");0  phi = (FLOAT *) mem_alloc(sizeof(FBLK), "phi");6  energy = (FLOAT *) mem_alloc(sizeof(FBLK), "energy");-  c = (FLOAT *) mem_alloc(sizeof(FHBLK), "c"); 3  fthr = (FLOAT *) mem_alloc(sizeof(FHBLK), "fthr"); 5  snrtmp = (F32 *) mem_alloc(sizeof(F2_32), "snrtmp");        assert( lay == 3 ); 
  if(init==0){   L /* These dynamic memory allocations simulate "static" variables placed    */L /* in the data space.  Each mem_alloc() call here occurs only once at     */L /* initialization time.  The mem_free() function must not be called.      */;      numlines = (int *) mem_alloc(sizeof(ICB), "numlines"); ?      partition = (int *) mem_alloc(sizeof(IHBLK), "partition"); 7      cbval = (FLOAT *) mem_alloc(sizeof(FCB), "cbval"); 7      rnorm = (FLOAT *) mem_alloc(sizeof(FCB), "rnorm"); :      window = (FLOAT *) mem_alloc(sizeof(FBLK), "window");<      absthr = (FLOAT *) mem_alloc(sizeof(FHBLK), "absthr"); 4      tmn = (double *) mem_alloc(sizeof(DCB), "tmn");/      s = (FCB *) mem_alloc(sizeof(FCBCB), "s"); 8      lthr = (FHBLK *) mem_alloc(sizeof(F2HBLK), "lthr");4      r = (F2HBLK *) mem_alloc(sizeof(F22HBLK), "r");@      phi_sav = (F2HBLK *) mem_alloc(sizeof(F22HBLK), "phi_sav");  
 /*#if 0 */      i = sfreq + 0.5;       switch(i){ )         case 32000: sfreq_idx = 0; break; )         case 44100: sfreq_idx = 1; break; )         case 48000: sfreq_idx = 2; break; K         default:    printf("error, invalid sampling frequency: %d Hz\n",i);          exit(-1);       }C      printf("absthr[][] sampling frequency index: %d\n",sfreq_idx); $      read_absthr(absthr, sfreq_idx);      switch(lay){ 9 	case 1: sync_flush=576; flush=384; syncsize=1024; break; 9 	case 2: sync_flush=480; flush=576; syncsize=1056; break; 9 	case 3: sync_flush=768; flush=576; syncsize=1344; break; B        default: printf("Bad lay value:(%d)",lay); exit(-1); break;      } /* #endif */  ( /* calculate HANN window coefficients */O /*   for(i=0;i<BLKSIZE;i++)  window[i]  =0.5*(1-cos(2.0*PI*i/(BLKSIZE-1.0)));*/ M      for(i=0;i<BLKSIZE;i++)  window[i]  =0.5*(1-cos(2.0*PI*(i-0.5)/BLKSIZE)); O      for(i=0;i<BLKSIZE_s;i++)window_s[i]=0.5*(1-cos(2.0*PI*(i-0.5)/BLKSIZE_s));O3 /* reset states used in unpredictability measure */       for(i=0;i<HBLKSIZE;i++){n6         r[0][0][i]=r[1][0][i]=r[0][1][i]=r[1][1][i]=0;,         phi_sav[0][0][i]=phi_sav[1][0][i]=0;,         phi_sav[0][1][i]=phi_sav[1][1][i]=0;&         lthr[0][i] = 60802371420160.0;&         lthr[1][i] = 60802371420160.0;      }N /*****************************************************************************N  * Initialization: Compute the following constants for use later             *N  *    partition[HBLKSIZE] = the partition number associated with each        *N  *                          frequency line                                   *N  *    cbval[CBANDS]       = the center (average) bark value of each          *N  *                          partition                                        *N  *    numlines[CBANDS]    = the number of frequency lines in each partition  *N  *    tmn[CBANDS]         = tone masking noise                               *O  *****************************************************************************/f( /* compute fft frequency multiplicand */      freq_mult = sfreq/BLKSIZE;    P /* calculate fft frequency, then bval of each line (use fthr[] as tmp storage)*/      for(i=0;i<HBLKSIZE;i++){e         temp1 = i*freq_mult;         j = 1;%         while(temp1>crit_band[j])j++;eI         fthr[i]=j-1+(temp1-crit_band[j-1])/(crit_band[j]-crit_band[j-1]);)      }      partition[0] = 0;M /* temp2 is the counter of the number of frequency lines in each partition */b      temp2 = 1;,      cbval[0]=fthr[0];      bval_lo=fthr[0];       for(i=1;i<HBLKSIZE;i++){,#         if((fthr[i]-bval_lo)>0.33){q)            partition[i]=partition[i-1]+1;s?            cbval[partition[i-1]] = cbval[partition[i-1]]/temp2;X)            cbval[partition[i]] = fthr[i];B            bval_lo = fthr[i]; ,            numlines[partition[i-1]] = temp2;            temp2 = 1;o	         }B         else {'            partition[i]=partition[i-1];h*            cbval[partition[i]] += fthr[i];            temp2++;l	         }n      }&      numlines[partition[i-1]] = temp2;9      cbval[partition[i-1]] = cbval[partition[i-1]]/temp2;i   I /************************************************************************3I  * Now compute the spreading function, s[j][i], the value of the spread-*rI  * ing function, centered at band j, for band i, store for later use    *mJ  ************************************************************************/      for(j=0;j<CBANDS;j++){          for(i=0;i<CBANDS;i++){.            temp1 = (cbval[i] - cbval[j])*1.05;(            if(temp1>=0.5 && temp1<=2.5){"               temp2 = temp1 - 0.5;8               temp2 = 8.0 * (temp2*temp2 - 2.0 * temp2);            }            else temp2 = 0;            temp1 += 0.474;M            temp3 = 15.811389+7.5*temp1-17.5*sqrt((double) (1.0+temp1*temp1));i)            if(temp3 <= -100) s[i][j] = 0;             else {=2               temp3 = (temp2 + temp3)*LN_TO_LOG10;#               s[i][j] = exp(temp3);	            }	         }       }  +   /* Calculate Tone Masking Noise values */A      for(j=0;j<CBANDS;j++){i          temp1 = 15.5 + cbval[j];-         tmn[j] = (temp1>24.5) ? temp1 : 24.5;aG   /* Calculate normalization factors for the net spreading functions */A         rnorm[j] = 0;          for(i=0;i<CBANDS;i++){            rnorm[j] += s[j][i]; 	         }a      }      init++;  }  nO /************************* End of Initialization *****************************/B  switch(lay) {	   case 1:a	   case 2:w 	for ( i=0; i<lay; i++)l   {sN /*****************************************************************************N  * Net offset is 480 samples (1056-576) for layer 2; this is because one must*N  * stagger input data by 256 samples to synchronize psychoacoustic model with*N  * filter bank outputs, then stagger so that center of 1024 FFT window lines *N  * up with center of 576 "new" audio samples.                                *N  *                                                                           *N  * For layer 1, the input data still needs to be staggered by 256 samples,   *N  * then it must be staggered again so that the 384 "new" samples are centered*N  * in the 1024 FFT window.  The net offset is then 576 and you need 448 "new"*N  * samples for each iteration to keep the 384 samples of interest centered   *O  *****************************************************************************/*   for (j=0; j<syncsize; j++)   {i     if (j < (sync_flush) )$       savebuf[j] = savebuf[j+flush];     else       savebuf[j] = *buffer++;r  O /**window data with HANN window***********************************************/      if (j<BLKSIZE)     { 3       wsamp_r[j] = window[j]*((FLOAT) savebuf[j]);         wsamp_i[j] = 0;p     }    } O /**Compute FFT****************************************************************/ -         fft(wsamp_r,wsamp_i,energy,phi,1024); N /*****************************************************************************N  * calculate the unpredictability measure, given energy[f] and phi[f]        *O  *****************************************************************************/A"         for(j=0; j<HBLKSIZE; j++){>            r_prime = 2.0 * r[chn][old][j] - r[chn][oldest][j];L            phi_prime = 2.0 * phi_sav[chn][old][j] - phi_sav[chn][oldest][j];5            r[chn][new][j] = sqrt((double) energy[j]);")            phi_sav[chn][new][j] = phi[j];k1 	   temp1 = r[chn][new][j] * cos((double) phi[j])   		   - r_prime * cos(phi_prime);/ 	   temp2=r[chn][new][j] * sin((double) phi[j])   		   - r_prime * sin(phi_prime);0            temp3=r[chn][new][j] + fabs(r_prime);B            if(temp3 != 0)c[j]=sqrt(temp1*temp1+temp2*temp2)/temp3;            else c[j] = 0;F	         }_O /*only update data "age" pointers after you are done with the second channel */ O /*for layer 1 computations, for the layer 2 double computations, the pointers*/(O /*are reset automatically on the second pass                                 */i         if(lay==2 || chn==1){B+            if(new==0){new = 1; oldest = 1;}i&            else {new = 0; oldest = 0;}+            if(old==0)old = 1; else old = 0;T	         }oN /*****************************************************************************N  * Calculate the grouped, energy-weighted, unpredictability measure,         *N  * grouped_c[], and the grouped energy. grouped_e[]                          *O  *****************************************************************************/e         for(j=1;j<CBANDS;j++){            grouped_e[j] = 0;            grouped_c[j] = 0;	         } !         grouped_e[0] = energy[0];s&         grouped_c[0] = energy[0]*c[0];          for(j=1;j<HBLKSIZE;j++){0            grouped_e[partition[j]] += energy[j];5            grouped_c[partition[j]] += energy[j]*c[j];(	         })N /*****************************************************************************N  * convolve the grouped energy-weighted unpredictability measure             *N  * and the grouped energy with the spreading function, s[j][k]               *O  *****************************************************************************/_         for(j=0;j<CBANDS;j++){            ecb[j] = 0;            cb[j] = 0;s!            for(k=0;k<CBANDS;k++){e!               if(s[j][k] != 0.0){10                  ecb[j] += s[j][k]*grouped_e[k];/                  cb[j] += s[j][k]*grouped_c[k];"               }m            }.            if(ecb[j] !=0)cb[j] = cb[j]/ecb[j];            else cb[j] = 0;	         }yN /*****************************************************************************N  * Calculate the required SNR for each of the frequency partitions           *N  *         this whole section can be accomplished by a table lookup          *O  *****************************************************************************/-         for(j=0;j<CBANDS;j++){#            if(cb[j]<.05)cb[j]=0.05;e&            else if(cb[j]>.5)cb[j]=0.5;@ /*         tb = -0.434294482*log((double) cb[j])-0.301029996; */3            tb = -0.43 *log((double) cb[j]) - 0.29 ;K5            if(tb<0.0) tb=0.0; else if(tb>1.0) tb=1.0;(,            bc[j] = tmn[j]*tb + nmt*(1.0-tb);            k = cbval[j] + 0.5;7            bc[j] = (bc[j] > bmax[k]) ? bc[j] : bmax[k];04            bc[j] = exp((double) -bc[j]*LN_TO_LOG10);	         }]N /*****************************************************************************N  * Calculate the permissible noise energy level in each of the frequency     *N  * partitions. Include absolute threshold and pre-echo controls              *N  *         this whole section can be accomplished by a table lookup          *O  *****************************************************************************/          for(j=0;j<CBANDS;j++) &            if(rnorm[j] && numlines[j]):               nb[j] = ecb[j]*bc[j]/(rnorm[j]*numlines[j]);            else nb[j] = 0;          for(j=0;j<HBLKSIZE;j++){@            temp1=nb[partition[j]];		 /* preliminary threshold */3            temp1=(temp1>absthr[j])?temp1:absthr[j]; O /*do not use pre-echo control for layer 2 because it may do bad things to the*/*O /*  MUSICAM bit allocation algorithm                                         */*            if(lay==1){F               fthr[j] = (temp1 < lthr[chn][j]) ? temp1 : lthr[chn][j];&               temp2 = temp1 * 0.00316;<               fthr[j] = (temp2 > fthr[j]) ? temp2 : fthr[j];            }             else fthr[j] = temp1;&            lthr[chn][j] = LXMIN*temp1;	         }+N /*****************************************************************************N  * Translate the 512 threshold values to the 32 filter bands of the coder    *O  *****************************************************************************/r         for(j=0;j<193;j += 16){f            min_thres = fthr[j]; "            sum_energy = energy[j];            for(k=1;k<17;k++){1<               if(min_thres>fthr[j+k]) min_thres = fthr[j+k];(               sum_energy += energy[j+k];            };            snrtmp[i][j/16] = sum_energy/(min_thres * 17.0);oH            snrtmp[i][j/16] = 4.342944819 * log((double)snrtmp[i][j/16]);	         }v*         for(j=208;j<(HBLKSIZE-1);j += 16){            min_thres = 0.0;             sum_energy = 0.0;            for(k=0;k<17;k++){1%               min_thres += fthr[j+k]; (               sum_energy += energy[j+k];            }2            snrtmp[i][j/16] = sum_energy/min_thres;H            snrtmp[i][j/16] = 4.342944819 * log((double)snrtmp[i][j/16]);	         }bN /*****************************************************************************N  * End of Psychoacuostic calculation loop                                    *O  *****************************************************************************/0      }      for(i=0; i<32; i++){e1         if(lay==2)		/* if(lay==2 && chn==2) MI */mJ            snr32[i]=(snrtmp[0][i]>snrtmp[1][i])?snrtmp[0][i]:snrtmp[1][i];#         else snr32[i]=snrtmp[0][i];=      }      break;1  K /*************************************************************************/0K /**       LAYER 3                                                        */ K /*************************************************************************/C  
    case 3: 	if ( init_L3 == 0 ) 	{G 	    L3para_read( sfreq,numlines,partition_l,minval,qthr_l,norm_l,s3_l,m$ 			 partition_s,qthr_s,norm_s,SNR_s,; 			 cbw_l,bu_l,bo_l,w1_l,w2_l, cbw_s,bu_s,bo_s,w1_s,w2_s );n 	    init_L3 ++ ;  	} 	] 	for ( j = 0; j < 21; j++ )N  	    ratio_d[j] = ratio[chn][j]; 	for ( j = 0; j < 12; j++ )  	    for ( i = 0; i < 3; i++ )& 		ratio_ds[j][i] = ratio_s[chn][j][i]; 	* 	if ( chn == 0 ) 	    if ( new == 0 ) 	    {
 		new = 1;
 		old = 0;
 		oldest = 1;i 	    }	 	    else* 	    {
 		new = 0;
 		old = 1;
 		oldest = 0;* 	    }    G /**********************************************************************bG *  Delay signal by sync_flush=768 samples                             *cG **********************************************************************/e 	fA 	for ( j = 0; j < sync_flush; j++ ) /* for long window samples */l# 	    savebuf[j] = savebuf[j+flush];  	 * 	for ( j = sync_flush; j < syncsize; j++ ) 	    savebuf[j] = *buffer++; 	*  	for ( j = 0; j < BLKSIZE; j++ )% 	{ /**window data with HANN window**/ + 	    wsamp_r[j] = window[j] * savebuf[j];  t 	    wsamp_i[j] = 0.0; 	}    G /********************************************************************** H *    compute unpredicatability of first six spectral lines            * G **********************************************************************/*  < 	fft( wsamp_r, wsamp_i, energy, phi, 1024 );		/**long FFT**/ 	for ( j = 0; j < 6; j++ )/ 	{	 /* calculate unpredictability measure cw */ 8 	    r_prime = 2.0 * r[chn][old][j] - r[chn][oldest][j];D 	    phi_prime = 2.0 * phi_sav[chn][old][j]-phi_sav[chn][oldest][j];/ 	    r[chn][new][j] = sqrt((double) energy[j]); # 	    phi_sav[chn][new][j] = phi[j];p2 	    temp1 = r[chn][new][j] * cos((double) phi[j]) 		- r_prime * cos(phi_prime);*2 	    temp2 = r[chn][new][j] * sin((double) phi[j]) 		- r_prime * sin(phi_prime);** 	    temp3=r[chn][new][j] + fabs(r_prime); 	    * 	    if ( temp3 != 0.0 )2 		cw[j] = sqrt( temp1*temp1+temp2*temp2 ) / temp3;	 	    else* 		cw[j] = 0; 	}    G /**********************************************************************jG *     compute unpredicatibility of next 200 spectral lines            *sH **********************************************************************/ ) 	for ( sblock = 0; sblock < 3; sblock++ )t% 	{ /**window data with HANN window**/s= 	    for ( j = 0, k = 128 * (2 + sblock); j < 256; j++, k++ )o 	    {( 		wsamp_r[j] = window_s[j]* savebuf[k];  		wsamp_i[j] = 0.0;[ 	    }							/* short FFT*/	 	    pK 	    fft( wsamp_r, wsamp_i, &energy_s[sblock][0], &phi_s[sblock][0], 256 ); 	         }e            sblock = 1;t   	for ( j = 6; j < 206; j += 4 ) - 	{/* calculate unpredictability measure cw */a* 	    double r2, phi2, temp1, temp2, temp3; 	    c 	    k = (j+2) / 4; 2 	    r_prime = 2.0 * sqrt((double) energy_s[0][k])" 		- sqrt((double) energy_s[2][k]);1 	    phi_prime = 2.0 * phi_s[0][k] - phi_s[2][k]; ( 	    r2 = sqrt((double) energy_s[1][k]); 	    phi2 = phi_s[1][k];; 	    temp1 = r2 * cos( phi2 ) - r_prime * cos( phi_prime );}; 	    temp2 = r2 * sin( phi2 ) - r_prime * sin( phi_prime );*" 	    temp3 = r2 + fabs( r_prime ); 	    if ( temp3 != 0.0 )8 		cw[j] = sqrt( temp1 * temp1 + temp2 * temp2 ) / temp3;	 	    elseb 		cw[j] = 0.0;) 	    cw[j+1] = cw[j+2] = cw[j+3] = cw[j];n 	}    G /***********************************************************************G *    Set unpredicatiblility of remaining spectral lines to 0.4        *+G **********************************************************************/ # 	for ( j = 206; j < HBLKSIZE; j++ )  	    cw[j] = 0.4;] 	e    G /**********************************************************************iG *    Calculate the energy and the unpredictability in the threshold   *]G *    calculation partitions                                           **G **********************************************************************/i   	for ( b = 0; b < CBANDS; b++ )t 	{ 	    eb[b] = 0.0;t 	    cb[b] = 0.0;o 	}! 	for ( j = 0; j < HBLKSIZE; j++ )* 	{ 	    int tp = partition_l[j];* 	    if ( tp >= 0 )* 	    { 		eb[tp] += energy[j]; 		cb[tp] += cw[j] * energy[j]; 	    } 	}    G /**********************************************************************!G *      convolve the partitioned energy and unpredictability           * G *      with the spreading function, s3_l[b][k]                        * G ******************************************************************** */  	  	for ( b = 0; b < CBANDS; b++ )* 	{ 	    ecb[b] = 0.0; 	    ctb[b] = 0.0; 	} 	for ( b = 0;b < CBANDS; b++ ) 	{# 	    for ( k = 0; k < CBANDS; k++ )  	    {; 		ecb[b] += s3_l[b][k] * eb[k];	/* sprdngf for Layer III */l 		ctb[b] += s3_l[b][k] * cb[k];* 	    } 	}  E 	/* calculate the tonality of each threshold calculation partition */BA 	/* calculate the SNR in each threshhold calculation partition */f   	for ( b = 0; b < CBANDS; b++ )  	{ 	    double cbb,tbb; 	    if (ecb[b] != 0.0 )                 {4 		cbb = ctb[b]/ecb[b];*                 if (cbb <0.01) cbb = 0.01; 		cbb = log( cbb);                 }=	 	    else+
 		cbb = 0.0 ; > 	    tbb = -0.299 - 0.43*cbb;  /* conv1=-0.299, conv2=-0.43 */> 	    tbb = minimum( 1.0, maximum( 0.0, tbb) ) ;  /* 0<tbb<1 */= 	    SNR_l[b] = maximum( minval[b], 29.0*tbb+6.0*(1.0-tbb) );*8 	}	/* TMN=29.0,NMT=6.0 for all calculation partitions */ 	pP 	for ( b = 0; b < CBANDS; b++ ) /* calculate the threshold for each partition */A 	    nb[b] = ecb[b] * norm_l[b] * exp( -SNR_l[b] * LN_TO_LOG10 );    	for ( b = 0; b < CBANDS; b++ )l 	{ /* pre-echo control */ # 	    double temp_1; /* BUG of IS */*L 	    temp_1 = minimum( nb[b], minimum(2.0*nb_1[chn][b],16.0*nb_2[chn][b]) );I 	    thr[b] = maximum( qthr_l[b], temp_1 );/* rpelev=2.0, rpelev2=16.0 */b! 	    nb_2[chn][b] = nb_1[chn][b];  	    nb_1[chn][b] = nb[b]; 	}    / 	*pe = 0.0;		/*  calculate percetual entropy */[ 	for ( b = 0; b < CBANDS; b++ )/ 	{ 	    double tp ;H 	    tp = minimum( 0.0, log((thr[b]+1.0) / (eb[b]+1.0) ) ) ; /*not log*/ 	    *pe -= numlines[b] * tp ;7 	}	/* thr[b] -> thr[b]+1.0 : for non sound portition */  	  #define switch_pe  1800*         blocktype = NORM_TYPE; 	    	if ( *pe < switch_pe )h' 	{				/* no attack : use long blocks */ " 	    switch( blocktype_old[chn] )  	    { 	      case NORM_TYPE: 	      case STOP_TYPE: 		blocktype = NORM_TYPE; 		break;      	      case SHORT_TYPE:[ 		blocktype = STOP_TYPE; 		break;      	      case START_TYPE:*2 		fprintf( stderr, "Error in block selecting\n" );
 		abort(); 		break; /* problem */ 	    }  ) 	    /* threshold calculation (part 2) */*' 	    for ( sb = 0; sb < SBMAX_l; sb++ )* 	    {= 		en[sb] = w1_l[sb] * eb[bu_l[sb]] + w2_l[sb] * eb[bo_l[sb]];m? 		thm[sb] = w1_l[sb] *thr[bu_l[sb]] + w2_l[sb] * thr[bo_l[sb]]; + 		for ( b = bu_l[sb]+1; b < bo_l[sb]; b++ )t 		{f 		    en[sb]  += eb[b];r 		    thm[sb] += thr[b]; 		}y 		if ( en[sb] != 0.0 )& 		    ratio[chn][sb] = thm[sb]/en[sb]; 		else 		    ratio[chn][sb] = 0.0;  	    } 	} 	else  	{$ 	    /* attack : use short blocks */ 	    blocktype = SHORT_TYPE; 	    H, 	    if ( blocktype_old[chn] == NORM_TYPE ) " 		blocktype_old[chn] = START_TYPE;+ 	    if ( blocktype_old[chn] == STOP_TYPE ) # 		blocktype_old[chn] = SHORT_TYPE ;  	    n1 	    /* threshold calculation for short blocks */m 	    1- 	    for ( sblock = 0; sblock < 3; sblock++ )] 	    {" 		for ( b = 0; b < CBANDS_s; b++ ) 		{] 		    eb[b] = 0.0; 		    ecb[b] = 0.0;* 		}*$ 		for ( j = 0; j < HBLKSIZE_s; j++ )0 		    eb[partition_s[j]] += energy_s[sblock][j];" 		for ( b = 0; b < CBANDS_s; b++ )& 		    for ( k = 0; k < CBANDS_s; k++ )  			ecb[b] += s3_l[b][k] * eb[k];" 		for ( b = 0; b < CBANDS_s; b++ ) 		{+J 		    nb[b] = ecb[b] * norm_l[b] * exp( (double) SNR_s[b] * LN_TO_LOG10 );) 		    thr[b] = maximum (qthr_s[b],nb[b]);s 		}[$ 		for ( sb = 0; sb < SBMAX_s; sb++ ) 		{=A 		    en[sb] = w1_s[sb] * eb[bu_s[sb]] + w2_s[sb] * eb[bo_s[sb]];*C 		    thm[sb] = w1_s[sb] *thr[bu_s[sb]] + w2_s[sb] * thr[bo_s[sb]]; / 		    for ( b = bu_s[sb]+1; b < bo_s[sb]; b++ )* 		    {* 			en[sb] += eb[b];* 			thm[sb] += thr[b];* 		    }* 		    if ( en[sb] != 0.0 )- 			ratio_s[chn][sb][sblock] = thm[sb]/en[sb];n
 		    else" 			ratio_s[chn][sb][sblock] = 0.0; 		}t 	    } 	} n 	_+ 	cod_info->block_type = blocktype_old[chn];s  	blocktype_old[chn] = blocktype;  ) 	if ( cod_info->block_type == NORM_TYPE ) ) 	    cod_info->window_switching_flag = 0;( 	else ) 	    cod_info->window_switching_flag = 1;+  	cod_info->mixed_block_flag = 0; 	break;     
   default:@      printf("error, invalid MPEG/audio coding layer: %d\n",lay);  }  K /* These mem_free() calls must correspond with the mem_alloc() calls     */}K /* used at the beginning of this function to simulate "automatic"        */bK /* variables placed on the stack.                                        */*     mem_free((void **) &grouped_c);   mem_free((void **) &grouped_e);  mem_free((void **) &nb);c  mem_free((void **) &cb);i  mem_free((void **) &ecb);  mem_free((void **) &bc);   mem_free((void **) &wsamp_r);  mem_free((void **) &wsamp_i);  mem_free((void **) &phi);  mem_free((void **) &energy);i  mem_free((void **) &c);  mem_free((void **) &fthr);w  mem_free((void **) &snrtmp);p }j #ifdef DEBUG #undef DEBUG #endif    >void L3para_read(double sfreq, int *numlines, int *partition_l, double *minval, double *qthr_l, double *norm_l, double (*s3_l)[63], int *partition_s, double *qthr_s, double *norm_s, double *SNR, int *cbw_l, int *bu_l, int *bo_l, double *w1_l, double *w2_l, int *cbw_s, int *bu_s, int *bo_s, double *w1_s, double *w2_s) {t    double freq_tp;0    static double bval_l[CBANDS], bval_s[CBANDS];    int   cbmax, cbmax_tp;*&    static double s3_s[CBANDS][CBANDS];  
    FILE *fin;n    char tp[256];    int  sbmax ;)!    int  i,j,k,k2,loop, part_max ;[  %    fin = OpenTableFile( "psy_data" );d    if (fin == NULL)_        exit( 1 );m   /* Read long block data */         for(loop=0;loop<6;loop++)r       {(> 	fscanf(fin,"freq = %lf partition = %d\n",&freq_tp,&cbmax_tp); 	cbmax_tp++; #ifdef DEBUG4 	printf("freq = %f partition = %d\n",freq_tp,cbmax); #endif   	if (sfreq == freq_tp )* 	  { 	     cbmax = cbmax_tp;*" 	     for(i=0,k2=0;i<cbmax_tp;i++)	 	       {p
 		fscanf(fin,b> 		  "No=%d #lines=%d minval=%lf qthr=%lf norm=%lf bval=%lf\n",A 		  &j,&numlines[i],&minval[i],&qthr_l[i],&norm_l[i],&bval_l[i]);l 	        if (j!=i)0 	         { printf("please check \"psy_data\""); 		   exit(-1); 	         }  		for(k=0;k<numlines[i];k++) 		  partition_l[k2++] = i ;= #ifdef DEBUGP      printf("No=%2d #lines=%2d minval=%4.1f qthr=%8.3f norm=%5.3f bval=%8.3f\n",? 		     i,numlines[i],minval[i],qthr_l[i],norm_l[i],bval_l[i] );) #endif 		}e 	   }  	   else 	   {t 	     for(j=0;j<cbmax_tp;j++) 	 	       {c 		fgets(tp,255,fin);' 	        sscanf(tp,"No=%d %s\n",&i,tp);  	        if (j!=i)3 	         { printf("please check \"psy_data.\"\n");s 		   exit(-1); 	         } 	 	       }o 	   }n        }  I /************************************************************************bI  * Now compute the spreading function, s[j][i], the value of the spread-* I  * ing function, centered at band j, for band i, store for later use    * J  ************************************************************************/ #ifdef DEBUG 	printf("freq = %f\n",sfreq);  #endif 	  part_max = cbmax ;	!           for(i=0;i<part_max;i++)] 	  { 	  double tempx,x,tempy,temp;*#             for(j=0;j<part_max;j++)* 	    {2              tempx = (bval_l[i] - bval_l[j])*1.05;;              if (j>=i) tempx = (bval_l[i] - bval_l[j])*3.0;*;                else    tempx = (bval_l[i] - bval_l[j])*1.5;j= /*             if (j>=i) tempx = (bval_l[j] - bval_l[i])*3.0;*>                else    tempx = (bval_l[j] - bval_l[i])*1.5; */)              if(tempx>=0.5 && tempx<=2.5)d 	     {y"                temp = tempx - 0.5;2                x = 8.0 * (temp*temp - 2.0 * temp);              }              else x = 0.0;              tempx += 0.474;H              tempy = 15.811389 + 7.5*tempx - 17.5*sqrt(1.0+tempx*tempx);2              if (tempy <= -60.0) s3_l[i][j] = 0.0;M              else                s3_l[i][j] = exp( (x + tempy)*LN_TO_LOG10 );+ #ifdef DEBUG_S3b. 	     printf("s[%d][%d]=%f\n",i,j,s3_l[i][j]); #endif  
 #ifdef DEBUGP*C 	     printf("j=%d i=%d tempy=%f s[i][j]=%f \n",i,j,tempy,s[i][j]);t 	   minval[i] = bmax[j-1];E 	   printf("minval[%d] = %f, j-1=%d %f\n",i, minval[i] , j,fthr[i]) ;  #endif
             }*           }*     /* Read short block data */*         for(loop=0;loop<6;loop++)b       { > 	fscanf(fin,"freq = %lf partition = %d\n",&freq_tp,&cbmax_tp); 	cbmax_tp++; #ifdef DEBUG4 	printf("freq = %f partition = %d\n",freq_tp,cbmax); #endif   	if (sfreq == freq_tp )s 	  { 	     cbmax = cbmax_tp;[" 	     for(i=0,k2=0;i<cbmax_tp;i++)	 	       {a
 		fscanf(fin,a; 		  "No=%d #lines=%d qthr=%lf norm=%lf SNR=%lf bval=%lf\n",t? 		   &j,&numlines[i],&qthr_s[i],&norm_s[i],&SNR[i],&bval_s[i]);b 	        if (j!=i)0 	         { printf("please check \"psy_data\""); 		   exit(-1); 	         }	 		for(k=0;k<numlines[i];k++) 		  partition_s[k2++] = i ;0 #ifdef DEBUGN       printf("No=%2d #lines=%2d qthr=%8.3f norm=%5.3f SNR=%6.3f bval=%8.3f\n",= 		      i,numlines[i],qthr_s[i],norm_s[i],SNR[i],bval_s[i] );  #endif 		}  	   }b 	   else 	   {  	     for(j=0;j<cbmax_tp;j++)n	 	       {0 		fgets(tp,255,fin);' 	        sscanf(tp,"No=%d %s\n",&i,tp);i 	        if (j!=i)3 	         { printf("please check \"psy_data.\"\n");r 		   exit(-1); 	         } 	 	       }= 	   }         }  I /************************************************************************/I  * Now compute the spreading function, s[j][i], the value of the spread-* I  * ing function, centered at band j, for band i, store for later use    * J  ************************************************************************/ #ifdef DEBUG_S3[ fpp=fopen("s3_s","w"); #endif 	  part_max = cbmax ;/!           for(i=0;i<part_max;i++)  	  { 	  double tempx,x,tempy,temp; #             for(j=0;j<part_max;j++)0 	    {2              tempx = (bval_s[i] - bval_s[j])*1.05;;              if (j>=i) tempx = (bval_s[i] - bval_s[j])*3.0;n;                else    tempx = (bval_s[i] - bval_s[j])*1.5;l)              if(tempx>=0.5 && tempx<=2.5)t 	     { "                temp = tempx - 0.5;2                x = 8.0 * (temp*temp - 2.0 * temp);              }              else x = 0.0;              tempx += 0.474;H              tempy = 15.811389 + 7.5*tempx - 17.5*sqrt(1.0+tempx*tempx);2              if (tempy <= -60.0) s3_s[i][j] = 0.0;M              else                s3_s[i][j] = exp( (x + tempy)*LN_TO_LOG10 );  #ifdef DEBUG_S3 6 	     fprintf(fpp,"s3_s[%d][%d]=%f\n",i,j,s3_s[i][j]); #endif
 #ifdef DEBUGPnC 	     printf("j=%d i=%d tempy=%f s[i][j]=%f \n",i,j,tempy,s[i][j]);  	   minval[i] = bmax[j-1];E 	   printf("minval[%d] = %f, j-1=%d %f\n",i, minval[i] , j,fthr[i]) ;t #endif
             }=           }  #ifdef DEBUG_S3b
 	fclose(fpp);( #endif= /* Read long block data for converting threshold calculation  &    partitions to scale factor bands */         for(loop=0;loop<6;loop++)b       { 0 	fscanf(fin,"freq=%lf sb=%d\n",&freq_tp,&sbmax);	 	sbmax++;[ #ifdef DEBUG- 	printf("freq = %f sb = %d\n",freq_tp,sbmax);  #endif   	if (sfreq == freq_tp) 	  { 	     for(i=0;i<sbmax;i++) 	      {
 		fscanf(fin,// 		  "sb=%d cbw=%d bu=%d bo=%d w1=%lf w2=%lf\n", 6 		  &j,&cbw_l[i],&bu_l[i],&bo_l[i],&w1_l[i],&w2_l[i]); 	        if (j!=i)5 	         { printf("30:please check \"psy_data\"\n");[ 		   exit(-1); 	         }  #ifdef DEBUG	 		printf( 7 		  "sb=%2d cbw=%1d bu=%2d bo=%2d w1=%5.3f w2=%5.3f\n", 0 		  j,cbw_l[i],bu_l[i],bo_l[i],w1_l[i],w2_l[i]); #endif 	        if (i!=0)* 		 if ( (bo_l[i] != (bu_l[i]+cbw_l[i])) ||, 				 (fabs(1.0-w1_l[i]-w2_l[i-1]) > 0.01 ) )6 	         { printf("31:please check \"psy_data.\"\n"); 		   exit(-1); 	         }, 	      } 	   }	 	   else 	   {< 	     for(j=0;j<sbmax;j++)	 	       {w 		fgets(tp,255,fin);' 	        sscanf(tp,"sb=%d %s\n",&i,tp);b 	        if (j!=i)3 	         { printf("please check \"psy_data.\"\n");  		   exit(-1); 	         } 	 	       }* 	   }[        }  > /* Read short block data for converting threshold calculation &    partitions to scale factor bands */         for(loop=0;loop<6;loop++)n       {o0 	fscanf(fin,"freq=%lf sb=%d\n",&freq_tp,&sbmax);	 	sbmax++;l #ifdef DEBUG- 	printf("freq = %f sb = %d\n",freq_tp,sbmax);  #endif   	if (sfreq == freq_tp) 	  { 	     for(i=0;i<sbmax;i++) 	      {
 		fscanf(fin, / 		  "sb=%d cbw=%d bu=%d bo=%d w1=%lf w2=%lf\n",-6 		  &j,&cbw_s[i],&bu_s[i],&bo_s[i],&w1_s[i],&w2_s[i]); 	        if (j!=i)5 	         { printf("30:please check \"psy_data\"\n");m 		   exit(-1); 	         }n #ifdef DEBUG	 		printf(l7 		  "sb=%2d cbw=%1d bu=%2d bo=%2d w1=%5.3f w2=%5.3f\n",s0 		  j,cbw_s[i],bu_s[i],bo_s[i],w1_s[i],w2_s[i]); #endif 	        if (i!=0)* 		 if ( (bo_s[i] != (bu_s[i]+cbw_s[i])) ||, 				 (fabs(1.0-w1_s[i]-w2_s[i-1]) > 0.01 ) )6 	         { printf("31:please check \"psy_data.\"\n"); 		   exit(-1); 	         }* 	      } 	   }e 	   else 	   {  	     for(j=0;j<sbmax;j++)	 	       {f 		fgets(tp,255,fin);' 	        sscanf(tp,"sb=%d %s\n",&i,tp);( 	        if (j!=i)3 	         { printf("please check \"psy_data.\"\n");) 		   exit(-1); 	         }m	 	       }i 	   }B        }   }G