G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) H  * ISO 13818-3 MPEG-2 Audio Encoder - Lower Sampling Frequency Extension  *>  * $Id: l3bitstream.c,v 1.1 1996/02/14 04:04:23 rowlands Exp $  *  * $Log: l3bitstream.c,v $.  * Revision 1.1  1996/02/14 04:04:23  rowlands  * Initial revision   *  * Received from Mike Coleman H  **********************************************************************/ /*   Revision History:   /   Date        Programmer                Comment G   ==========  ========================= =============================== /   1995/08/06  mc@fivebats.com           created G   1995/09/06  mc@fivebats.com           modified to use formatBitstream  */   #include <stdlib.h> 3 #include "l3bitstream.h" /* the public interface */  #include "l3psy.h" #include "mdct.h"  #include "loop.h"  #include "formatBitstream.h" #include "huffman.h" #include <assert.h>  #include "l3bitstream-pvt.h"   static int stereo = 1;# static frame_params *fr_ps  = NULL; # static Bit_stream_struc *bs = NULL;   % BF_FrameData    *frameData    = NULL; % BF_FrameResults *frameResults = NULL;    int PartHoldersInitialized = 0;    BF_PartHolder *headerPH; BF_PartHolder *frameSIPH; + BF_PartHolder *channelSIPH[ MAX_CHANNELS ]; < BF_PartHolder *spectrumSIPH[ MAX_GRANULES ][ MAX_CHANNELS ];> BF_PartHolder *scaleFactorsPH[ MAX_GRANULES ][ MAX_CHANNELS ];; BF_PartHolder *codedDataPH[ MAX_GRANULES ][ MAX_CHANNELS ]; > BF_PartHolder *userSpectrumPH[ MAX_GRANULES ][ MAX_CHANNELS ]; BF_PartHolder *userFrameDataPH;     ( void putMyBits( uint32 val, uint16 len ) {      putbits( bs, val, len ); }    /*   III_format_bitstream()   E   This is called after a frame of audio has been quantized and coded. =   It will write the encoded audio to the bitstream. Note that A   from a layer3 encoder's perspective the bit stream is primarily B   a series of main_data() blocks, with header and side informationG   inserted at the proper locations to maintain framing. (See Figure A.7 
   in the IS).    */   void4 III_format_bitstream( int              bitsPerFrame,# 		      frame_params     *in_fr_ps, + 		      int              l3_enc[2][2][576], " 		      III_side_info_t  *l3_side,# 		      III_scalefac_t   *scalefac,   		      Bit_stream_struc *in_bs,' 		      double           (*xr)[2][576], $ 		      char             *ancillary,) 		      int              ancillary_bits )  {      int gr, ch, i, mode_gr;      fr_ps = in_fr_ps;      bs = in_bs;      stereo = fr_ps->stereo; 4     mode_gr = (fr_ps->header->version == 1) ? 2 : 1;          if ( frameData == NULL )     { - 	frameData = calloc( 1, sizeof(*frameData) );  	assert( frameData );      }      if ( frameResults == NULL )      { 0 	frameResults = calloc( 1, sizeof(*frameData) ); 	assert( frameData );      } "     if ( !PartHoldersInitialized )     { # 	headerPH = BF_newPartHolder( 12 ); $ 	frameSIPH = BF_newPartHolder( 12 );  ( 	for ( ch = 0; ch < MAX_CHANNELS; ch++ )- 	    channelSIPH[ch] = BF_newPartHolder( 8 );   ) 	for ( gr = 0; gr < MAX_GRANULES; gr++ )	 , 	    for ( ch = 0; ch < MAX_CHANNELS; ch++ ) 	    {2 		spectrumSIPH[gr][ch]   = BF_newPartHolder( 32 );2 		scaleFactorsPH[gr][ch] = BF_newPartHolder( 64 );3 		codedDataPH[gr][ch]    = BF_newPartHolder( 576 ); 1 		userSpectrumPH[gr][ch] = BF_newPartHolder( 4 );  	    }) 	userFrameDataPH = BF_newPartHolder( 8 );  	PartHoldersInitialized = 1;     }    #if 1 &     for ( gr = 0; gr < mode_gr; gr++ )# 	for ( ch =  0; ch < stereo; ch++ )  	{" 	    int *pi = &l3_enc[gr][ch][0];! 	    double *pr = &xr[gr][ch][0]; , 	    for ( i = 0; i < 576; i++, pr++, pi++ ) 	    { 		if ( (*pr < 0) && (*pi > 0) )  		    *pi *= -1; 	    } 	} #endif       encodeSideInfo( l3_side );0     encodeMainData( l3_enc, l3_side, scalefac );6     write_ancillary_data( ancillary, ancillary_bits );       if ( l3_side->resvDrain ) 1 	drain_into_ancillary_data( l3_side->resvDrain );      /*)       Put frameData together for the call        to BitstreamFrame()      */'     frameData->putbits     = putMyBits; *     frameData->frameLength = bitsPerFrame;%     frameData->nGranules   = mode_gr; $     frameData->nChannels   = stereo;,     frameData->header      = headerPH->part;-     frameData->frameSI     = frameSIPH->part;   %     for ( ch = 0; ch < stereo; ch++ ) 2 	frameData->channelSI[ch] = channelSIPH[ch]->part;  &     for ( gr = 0; gr < mode_gr; gr++ )" 	for ( ch = 0; ch < stereo; ch++ ) 	{B 	    frameData->spectrumSI[gr][ch]   = spectrumSIPH[gr][ch]->part;D 	    frameData->scaleFactors[gr][ch] = scaleFactorsPH[gr][ch]->part;A 	    frameData->codedData[gr][ch]    = codedDataPH[gr][ch]->part; D 	    frameData->userSpectrum[gr][ch] = userSpectrumPH[gr][ch]->part; 	}5     frameData->userFrameData = userFrameDataPH->part;   1     BF_BitstreamFrame( frameData, frameResults );   K     /* we set this here -- it will be tested in the next loops iteration */ 9     l3_side->main_data_begin = frameResults->nextBackPtr;  }    void III_FlushBitstream() { %     assert( PartHoldersInitialized ); 1     BF_FlushBitstream( frameData, frameResults );  }   S static unsigned slen1_tab[16] = { 0, 0, 0, 0, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4 }; S static unsigned slen2_tab[16] = { 0, 1, 2, 3, 0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 2, 3 };    static void 3 encodeMainData( int              l3_enc[2][2][576],  		III_side_info_t  *si,  		III_scalefac_t   *scalefac ) { (     int i, gr, ch, sfb, window, mode_gr;      layer *info = fr_ps->header;       if ( info->version == 1 ) 
 	mode_gr = 2;      else
 	mode_gr = 1;   &     for ( gr = 0; gr < mode_gr; gr++ )" 	for ( ch = 0; ch < stereo; ch++ )1 	    scaleFactorsPH[gr][ch]->part->nrEntries = 0;   &     for ( gr = 0; gr < mode_gr; gr++ )" 	for ( ch = 0; ch < stereo; ch++ ). 	    codedDataPH[gr][ch]->part->nrEntries = 0;       if ( info->version == 1 )      {  /* MPEG 1 */  	for ( gr = 0; gr < 2; gr++ )  	{& 	    for ( ch = 0; ch < stereo; ch++ ) 	    {2 		BF_PartHolder **pph = &scaleFactorsPH[gr][ch];		( 		gr_info *gi = &(si->gr[gr].ch[ch].tt);6 		unsigned slen1 = slen1_tab[ gi->scalefac_compress ];6 		unsigned slen2 = slen2_tab[ gi->scalefac_compress ]; 		int *ix = &l3_enc[gr][ch][0];   B 		if ( (gi->window_switching_flag == 1) && (gi->block_type == 2) ) 		{ ! 		    if ( gi->mixed_block_flag )  		    { " 			for ( sfb = 0; sfb < 8; sfb++ )D 			    *pph = BF_addEntry( *pph,  scalefac->l[gr][ch][sfb], slen1 );  " 			for ( sfb = 3; sfb < 6; sfb++ )/ 			    for ( window = 0; window < 3; window++ ) I 				*pph = BF_addEntry( *pph,  scalefac->s[gr][ch][sfb][window], slen1 );   # 			for ( sfb = 6; sfb < 12; sfb++ ) / 			    for ( window = 0; window < 3; window++ ) I 				*pph = BF_addEntry( *pph,  scalefac->s[gr][ch][sfb][window], slen2 );    		    } 
 		    else 		    { " 			for ( sfb = 0; sfb < 6; sfb++ )/ 			    for ( window = 0; window < 3; window++ ) I 				*pph = BF_addEntry( *pph,  scalefac->s[gr][ch][sfb][window], slen1 );   # 			for ( sfb = 6; sfb < 12; sfb++ ) / 			    for ( window = 0; window < 3; window++ ) I 				*pph = BF_addEntry( *pph,  scalefac->s[gr][ch][sfb][window], slen2 );  		    }  		}  		else 		{ 1 		    if ( (gr == 0) || (si->scfsi[ch][0] == 0) ) " 			for ( sfb = 0; sfb < 6; sfb++ )D 			    *pph = BF_addEntry( *pph,  scalefac->l[gr][ch][sfb], slen1 );  1 		    if ( (gr == 0) || (si->scfsi[ch][1] == 0) ) # 			for ( sfb = 6; sfb < 11; sfb++ ) D 			    *pph = BF_addEntry( *pph,  scalefac->l[gr][ch][sfb], slen1 );  1 		    if ( (gr == 0) || (si->scfsi[ch][2] == 0) ) $ 			for ( sfb = 11; sfb < 16; sfb++ )D 			    *pph = BF_addEntry( *pph,  scalefac->l[gr][ch][sfb], slen2 );  1 		    if ( (gr == 0) || (si->scfsi[ch][3] == 0) ) $ 			for ( sfb = 16; sfb < 21; sfb++ )D 			    *pph = BF_addEntry( *pph,  scalefac->l[gr][ch][sfb], slen2 ); 		} 2 		Huffmancodebits( &codedDataPH[gr][ch], ix, gi ); 	    } /* for ch */  	} /* for gr */      }      else     {  /* MPEG 2 */  	gr = 0;" 	for ( ch = 0; ch < stereo; ch++ ) 	{5 	    BF_PartHolder **pph = &scaleFactorsPH[gr][ch];		 + 	    gr_info *gi = &(si->gr[gr].ch[ch].tt); " 	    int *ix = &l3_enc[gr][ch][0]; 	    int sfb_partition;*  ' 	    assert( gi->sfb_partition_table );o  E 	    if ( (gi->window_switching_flag == 1) && (gi->block_type == 2) )  	    { 		if ( gi->mixed_block_flag )* 		{$ 		    sfb_partition = 0;% 		    for ( sfb = 0; sfb < 8; sfb++ )*R 			*pph = BF_addEntry( *pph,  scalefac->l[gr][ch][sfb], gi->slen[sfb_partition] );  L 		    for ( sfb = 3, sfb_partition = 1; sfb_partition < 4; sfb_partition++ ) 		    {*; 			int sfbs = gi->sfb_partition_table[ sfb_partition ] / 3; ( 			int slen = gi->slen[ sfb_partition ];& 			for ( i = 0; i < sfbs; i++, sfb++ )/ 			    for ( window = 0; window < 3; window++ )/H 				*pph = BF_addEntry( *pph,  scalefac->s[gr][ch][sfb][window], slen ); 		    }i 		}t 		else 		{iL 		    for ( sfb = 0, sfb_partition = 0; sfb_partition < 4; sfb_partition++ ) 		    {*; 			int sfbs = gi->sfb_partition_table[ sfb_partition ] / 3; ( 			int slen = gi->slen[ sfb_partition ];& 			for ( i = 0; i < sfbs; i++, sfb++ )/ 			    for ( window = 0; window < 3; window++ ) H 				*pph = BF_addEntry( *pph,  scalefac->s[gr][ch][sfb][window], slen ); 		    }a 		}a 	    }	 	    else  	    {H 		for ( sfb = 0, sfb_partition = 0; sfb_partition < 4; sfb_partition++ ) 		{F: 		    int sfbs = gi->sfb_partition_table[ sfb_partition ];+ 		    int slen = gi->slen[ sfb_partition ];H) 		    for ( i = 0; i < sfbs; i++, sfb++ )A? 			*pph = BF_addEntry( *pph,  scalefac->l[gr][ch][sfb], slen );N 		}; 	    }5 	    Huffmancodebits( &codedDataPH[gr][ch], ix, gi );  	} /* for ch */e     }u } /* main_data */[   static unsigned int crc = 0;  1 static int encodeSideInfo( III_side_info_t  *si )i {6?     int gr, ch, scfsi_band, region, window, bits_sent, mode_gr;b      layer *info = fr_ps->header;     ,     mode_gr =  (info->version == 1) ? 2 : 1;  "     headerPH->part->nrEntries = 0;E     headerPH = BF_addEntry( headerPH, 0xfff,                    12 );iD     headerPH = BF_addEntry( headerPH, info->version,            1 );D     headerPH = BF_addEntry( headerPH, 4 - info->lay,            2 );D     headerPH = BF_addEntry( headerPH, !info->error_protection,  1 );D     headerPH = BF_addEntry( headerPH, info->bitrate_index,      4 );D     headerPH = BF_addEntry( headerPH, info->sampling_frequency, 2 );D     headerPH = BF_addEntry( headerPH, info->padding,            1 );D     headerPH = BF_addEntry( headerPH, info->extension,          1 );D     headerPH = BF_addEntry( headerPH, info->mode,               2 );D     headerPH = BF_addEntry( headerPH, info->mode_ext,           2 );D     headerPH = BF_addEntry( headerPH, info->copyright,          1 );D     headerPH = BF_addEntry( headerPH, info->original,           1 );D     headerPH = BF_addEntry( headerPH, info->emphasis,           2 );          bits_sent = 32;u  *     if ( fr_ps->header->error_protection )     {z- 	headerPH = BF_addEntry( headerPH, crc, 16 );  	bits_sent += 16;o     }i  #     frameSIPH->part->nrEntries = 0;a  $     for (ch = 0; ch < stereo; ch++ )& 	channelSIPH[ch]->part->nrEntries = 0;  &     for ( gr = 0; gr < mode_gr; gr++ )" 	for ( ch = 0; ch < stereo; ch++ )/ 	    spectrumSIPH[gr][ch]->part->nrEntries = 0;        if ( info->version == 1 )      {  /* MPEG1 */> 	frameSIPH = BF_addEntry( frameSIPH, si->main_data_begin, 9 );   	if ( stereo == 2 );? 	    frameSIPH = BF_addEntry( frameSIPH, si->private_bits, 3 );c 	elseg? 	    frameSIPH = BF_addEntry( frameSIPH, si->private_bits, 5 );e 	r" 	for ( ch = 0; ch < stereo; ch++ )9 	    for ( scfsi_band = 0; scfsi_band < 4; scfsi_band++ )  	    {) 		BF_PartHolder **pph = &channelSIPH[ch]; ; 		*pph = BF_addEntry( *pph, si->scfsi[ch][scfsi_band], 1 );h 	    }   	for ( gr = 0; gr < 2; gr++ )r& 	    for ( ch = 0; ch < stereo; ch++ ) 	    {. 		BF_PartHolder **pph = &spectrumSIPH[gr][ch];( 		gr_info *gi = &(si->gr[gr].ch[ch].tt);< 		*pph = BF_addEntry( *pph, gi->part2_3_length,        12 );; 		*pph = BF_addEntry( *pph, gi->big_values,            9 ); ; 		*pph = BF_addEntry( *pph, gi->global_gain,           8 );*; 		*pph = BF_addEntry( *pph, gi->scalefac_compress,     4 );e; 		*pph = BF_addEntry( *pph, gi->window_switching_flag, 1 );   " 		if ( gi->window_switching_flag ) 		{   : 		    *pph = BF_addEntry( *pph, gi->block_type,       2 );: 		    *pph = BF_addEntry( *pph, gi->mixed_block_flag, 1 );  . 		    for ( region = 0; region < 2; region++ )< 			*pph = BF_addEntry( *pph, gi->table_select[region],  5 );. 		    for ( window = 0; window < 3; window++ )< 			*pph = BF_addEntry( *pph, gi->subblock_gain[window], 3 ); 		}  		else 		{>$ 		    assert( gi->block_type == 0 );. 		    for ( region = 0; region < 3; region++ ); 			*pph = BF_addEntry( *pph, gi->table_select[region], 5 );[  7 		    *pph = BF_addEntry( *pph, gi->region0_count, 4 );s7 		    *pph = BF_addEntry( *pph, gi->region1_count, 3 );  		}m  8 		*pph = BF_addEntry( *pph, gi->preflag,            1 );8 		*pph = BF_addEntry( *pph, gi->scalefac_scale,     1 );8 		*pph = BF_addEntry( *pph, gi->count1table_select, 1 ); 	    }   	if ( stereo == 2 )g 	    bits_sent += 256; 	else  	    bits_sent += 136;     }m     else     {  /* MPEG2 */> 	frameSIPH = BF_addEntry( frameSIPH, si->main_data_begin, 8 );   	if ( stereo == 2 )g? 	    frameSIPH = BF_addEntry( frameSIPH, si->private_bits, 2 );, 	else ? 	    frameSIPH = BF_addEntry( frameSIPH, si->private_bits, 1 );, 	  	gr = 0;" 	for ( ch = 0; ch < stereo; ch++ ) 	{1 	    BF_PartHolder **pph = &spectrumSIPH[gr][ch];_+ 	    gr_info *gi = &(si->gr[gr].ch[ch].tt); ? 	    *pph = BF_addEntry( *pph, gi->part2_3_length,        12 );-> 	    *pph = BF_addEntry( *pph, gi->big_values,            9 );> 	    *pph = BF_addEntry( *pph, gi->global_gain,           8 );> 	    *pph = BF_addEntry( *pph, gi->scalefac_compress,     9 );> 	    *pph = BF_addEntry( *pph, gi->window_switching_flag, 1 );  % 	    if ( gi->window_switching_flag ) 	 	    {   H6 		*pph = BF_addEntry( *pph, gi->block_type,       2 );6 		*pph = BF_addEntry( *pph, gi->mixed_block_flag, 1 );  * 		for ( region = 0; region < 2; region++ )? 		    *pph = BF_addEntry( *pph, gi->table_select[region],  5 ); * 		for ( window = 0; window < 3; window++ )? 		    *pph = BF_addEntry( *pph, gi->subblock_gain[window], 3 );s 	    }	 	    elsei 	    {* 		for ( region = 0; region < 3; region++ )> 		    *pph = BF_addEntry( *pph, gi->table_select[region], 5 );  3 		*pph = BF_addEntry( *pph, gi->region0_count, 4 );	3 		*pph = BF_addEntry( *pph, gi->region1_count, 3 );p 	    }  ; 	    *pph = BF_addEntry( *pph, gi->scalefac_scale,     1 );s; 	    *pph = BF_addEntry( *pph, gi->count1table_select, 1 );; 	} 	if ( stereo == 2 )B 	    bits_sent += 136; 	elseg 	    bits_sent += 72;e     }      return bits_sent;  }2   static void 7 write_ancillary_data( char *theData, int lengthInBits )B {d     /*      */a'     int bytesToSend = lengthInBits / 8; )     int remainingBits = lengthInBits % 8;s     unsigned wrd;b
     int i;  )     userFrameDataPH->part->nrEntries = 0;	  '     for ( i = 0; i < bytesToSend; i++ )]     {b 	wrd = theData[i];: 	userFrameDataPH = BF_addEntry( userFrameDataPH, wrd, 8 );     }w     if ( remainingBits )     {=# 	/* right-justify remaining bits */c3 	wrd = theData[bytesToSend] >> (8 - remainingBits);	F 	userFrameDataPH = BF_addEntry( userFrameDataPH, wrd, remainingBits );     }       })   /*J   Some combinations of bitrate, Fs, and stereo make it impossible to stuffH   out a frame using just main_data, due to the limited number of bits toK   indicate main_data_length. In these situations, we put stuffing bits into    the ancillary data...  */ static void - drain_into_ancillary_data( int lengthInBits )  {      /*      */n*     int wordsToSend   = lengthInBits / 32;*     int remainingBits = lengthInBits % 32;
     int i;       /*L       userFrameDataPH->part->nrEntries set by call to write_ancillary_data()     */  '     for ( i = 0; i < wordsToSend; i++ )e9 	userFrameDataPH = BF_addEntry( userFrameDataPH, 0, 32 );      if ( remainingBits )H 	userFrameDataPH = BF_addEntry( userFrameDataPH, 0, remainingBits );     }B   /*6   Note the discussion of huffmancodebits() on pages 28:   and 29 of the IS, as well as the definitions of the side!   information on pages 26 and 27.    */ static voids< Huffmancodebits( BF_PartHolder **pph, int *ix, gr_info *gi ) { j     int L3_huffman_coder_count1( BF_PartHolder **pph, struct huffcodetab *h, int v, int w, int x, int y );8     int bigv_bitcount( int ix[576], gr_info *cod_info );       int region1Start;h     int region2Start;r      int i, bigvalues, count1End;5     int v, w, x, y, bits, cbits, xbits, stuffingBits;)     unsigned int code, ext;>     struct huffcodetab *h;8     int bvbits, c1bits, tablezeros, r0, r1, r2, rt, *pr;     int bitsWritten = 0;     int idx = 0;     tablezeros = 0;w     r0 = r1 = r2 = 0;            /* 1: Write the bigvalues */#     bigvalues = gi->big_values * 2;      if ( bigvalues )     { U 	if ( !(gi->mixed_block_flag) && gi->window_switching_flag && (gi->block_type == 2) )i 	{ /* Three short blocks */a 	    /*pA 	      Within each scalefactor band, data is given for successive(F 	      time windows, beginning with window 0 and ending with window 2.D 	      Within each window, the quantized values are then arranged in' 	      order of increasing frequency... 	 	      */ ' 	    int sfb, window, line, start, end;f   	    I192_3 *ix_s;i 	    int *scalefac = &sfBandIndex[fr_ps->header->sampling_frequency + (fr_ps->header->version * 3)].s[0];s 	    i 	    ix_s = (I192_3 *) ix; 	    region1Start = 12;  	    region2Start = 576;  % 	    for ( sfb = 0; sfb < 13; sfb++ )	 	    { 		unsigned tableindex = 100; 		start = scalefac[ sfb ]; 		end   = scalefac[ sfb+1 ];   		if ( start < region1Start )e) 		    tableindex = gi->table_select[ 0 ];( 		else) 		    tableindex = gi->table_select[ 1 ];_ 		assert( tableindex < 32 );  * 		for ( window = 0; window < 3; window++ )1 		    for ( line = start; line < end; line += 2 ); 		    {e 			x = (*ix_s)[line][window]; ! 			y = (*ix_s)[line + 1][window];  			assert( idx < 576 );  			assert( idx >= 0 );G 			bits = HuffmanCode( tableindex, x, y, &code, &ext, &cbits, &xbits );d, 			*pph = BF_addEntry( *pph,  code, cbits );+ 			*pph = BF_addEntry( *pph,  ext, xbits );f 			bitsWritten += bits;; 		    }d 		 	    } 	} 	elsed7 	    if ( gi->mixed_block_flag && gi->block_type == 2 )d& 	    {  /* Mixed blocks long, short */$ 		int sfb, window, line, start, end; 		unsigned tableindex; 		I192_3 *ix_s; f 		int *scalefac = &sfBandIndex[fr_ps->header->sampling_frequency + (fr_ps->header->version * 3)].s[0]; 		 		ix_s = (I192_3 *) ix;   # 		/* Write the long block region */r# 		tableindex = gi->table_select[0];  		if ( tableindex )t# 		    for ( i = 0; i < 36; i += 2 )  		    { 
 			x = ix[i];_ 			y = ix[i + 1]; G 			bits = HuffmanCode( tableindex, x, y, &code, &ext, &cbits, &xbits );o, 			*pph = BF_addEntry( *pph,  code, cbits );+ 			*pph = BF_addEntry( *pph,  ext, xbits );t 			bitsWritten += bits;P 			F 		    }($ 		/* Write the short block region */% 		tableindex = gi->table_select[ 1 ];E 		assert( tableindex < 32 );  " 		for ( sfb = 3; sfb < 13; sfb++ ) 		{a 		    start = scalefac[ sfb ];+ 		    end   = scalefac[ sfb+1 ];           c 		    . 		    for ( window = 0; window < 3; window++ ). 			for ( line = start; line < end; line += 2 ) 			{! 			    x = (*ix_s)[line][window];t% 			    y = (*ix_s)[line + 1][window];;K 			    bits = HuffmanCode( tableindex, x, y, &code, &ext, &cbits, &xbits );e0 			    *pph = BF_addEntry( *pph,  code, cbits );/ 			    *pph = BF_addEntry( *pph,  ext, xbits );c 			    bitsWritten += bits;  			} 		}f   	    }	 	    elsen 	    { /* Long blocks */f 		int *scalefac = &sfBandIndex[fr_ps->header->sampling_frequency + (fr_ps->header->version * 3)].l[0];  		unsigned scalefac_index = 100; 		 		if ( gi->mixed_block_flag )c 		{t 		    region1Start = 36; 		    region2Start = 576;u 		}[ 		else 		{r- 		    scalefac_index = gi->region0_count + 1;B$ 		    assert( scalefac_index < 23 );0 		    region1Start = scalefac[ scalefac_index ];. 		    scalefac_index += gi->region1_count + 1;( 		    assert( scalefac_index < 23 );    0 		    region2Start = scalefac[ scalefac_index ];- 		    assert( region1Start == gi->address1 );w 		}c& 		for ( i = 0; i < bigvalues; i += 2 ) 		{n  		    unsigned tableindex = 100; 		    /* get table pointer */  		    if ( i < region1Start )E 		    {h$ 			tableindex = gi->table_select[0]; 			pr = &r0; 		    }n
 		    else 			if ( i < region2Start ) 			{( 			    tableindex = gi->table_select[1]; 			    pr = &r1; 			} 			elsew 			{( 			    tableindex = gi->table_select[2]; 			    pr = &r2; 			}  		    assert( tableindex < 32 ); 		    h = &ht[ tableindex ]; 		    /* get huffman code */ 		    x = ix[i]; 		    y = ix[i + 1]; 		    if ( tableindex )) 		    { G 			bits = HuffmanCode( tableindex, x, y, &code, &ext, &cbits, &xbits );E, 			*pph = BF_addEntry( *pph,  code, cbits );+ 			*pph = BF_addEntry( *pph,  ext, xbits );  			bitsWritten += rt = bits;
 			*pr += rt;c 		    }a
 		    else 		    {= 			tablezeros += 1;i 			*pr = 0;_ 		    }  		}  	    }     }t     bvbits = bitsWritten;        /* 2: Write count1 area */+     assert( (gi->count1table_select < 2) ); )     h = &ht[gi->count1table_select + 32];i-     count1End = bigvalues + (gi->count1 * 4);      assert( count1End <= 576 );P0     for ( i = bigvalues; i < count1End; i += 4 )     {d 	v = ix[i];S
 	w = ix[i+1];e
 	x = ix[i+2]; 
 	y = ix[i+3];r> 	bitsWritten += L3_huffman_coder_count1( pph, h, v, w, x, y );     }m"     c1bits = bitsWritten - bvbits;O     if ( (stuffingBits = gi->part2_3_length - gi->part2_length - bitsWritten) )      {-' 	int stuffingWords = stuffingBits / 32;v' 	int remainingBits = stuffingBits % 32;d 	assert( stuffingBits > 0 );   	/* ( 	  Due to the nature of the Huffman code  	  tables, we will pad with ones 	*/  	while ( stuffingWords-- )( 	    *pph = BF_addEntry( *pph, ~0, 32 ); 	if ( remainingBits ) 3 	    *pph = BF_addEntry( *pph, ~0, remainingBits );y 	bitsWritten += stuffingBits;E     }pC     assert( bitsWritten == gi->part2_3_length - gi->part2_length );i #ifdef DEBUGu     printf( "#### %d Huffman bits written (%02d + %02d), part2_length = %d, part2_3_length = %d, %d stuffing ####\n",_W 	    bitsWritten, bvbits, c1bits, gi->part2_length, gi->part2_3_length, stuffingBits );i #endif }i   int  abs_and_sign( int *x ) {_     if ( *x > 0 )>
 	return 0;
     *x *= -1; 
     return 1;d }t   intha L3_huffman_coder_count1( BF_PartHolder **pph, struct huffcodetab *h, int v, int w, int x, int y )p {      HUFFBITS huffbits;/     unsigned int signv, signw, signx, signy, p;(     int len;     int totalBits = 0;          signv = abs_and_sign( &v );t     signw = abs_and_sign( &w );+     signx = abs_and_sign( &x );e     signy = abs_and_sign( &y );n     +     p = v + (w << 1) + (x << 2) + (y << 3);d     huffbits = h->table[p];y     len = h->hlen[ p ];//     *pph = BF_addEntry( *pph,  huffbits, len );      totalBits += len;      if ( v )     {m' 	*pph = BF_addEntry( *pph,  signv, 1 );  	totalBits += 1;     }      if ( w )     {=' 	*pph = BF_addEntry( *pph,  signw, 1 );t 	totalBits += 1;     }        if ( x )     {r' 	*pph = BF_addEntry( *pph,  signx, 1 );  	totalBits += 1;     }=     if ( y )     { ' 	*pph = BF_addEntry( *pph,  signy, 1 );H 	totalBits += 1;     }D     return totalBits;t };   /*0   Implements the pseudocode of page 98 of the IS   */ inttl HuffmanCode( int table_select, int x, int y, unsigned int *code, unsigned int *ext, int *cbits, int *xbits ) {iH     unsigned signx, signy, linbitsx, linbitsy, linbits, xlen, ylen, idx;     struct huffcodetab *h;       *cbits = 0;_     *xbits = 0;t     *code  = 0;t     *ext   = 0;           if ( table_select == 0 )
 	return 0;          signx = abs_and_sign( &x );i     signy = abs_and_sign( &y );      h = &(ht[table_select]);     xlen = h->xlen;      ylen = h->ylen;)     linbits = h->linbits;;     linbitsx = linbitsy = 0;       if ( table_select > 15 )     { /* ESC-table is used */( 	if ( x > 14 ) 	{ 	    linbitsx = x - 15;t% 	    assert( linbitsx <= h->linmax );; 	    x = 15; 	} 	if ( y > 14 ) 	{ 	    linbitsy = y - 15;a% 	    assert( linbitsy <= h->linmax );t 	    y = 15; 	} 	idx = (x * ylen) + y; 	*code = h->table[idx];/ 	*cbits = h->hlen[ idx ];b 	if ( x > 14 ) 	{ 	    *ext |= linbitsx; 	    *xbits += linbits;m 	} 	if ( x != 0 ) 	{ 	    *ext <<= 1; 	    *ext |= signx;t 	    *xbits += 1;n 	} 	if ( y > 14 ) 	{ 	    *ext <<= linbits; 	    *ext |= linbitsy; 	    *xbits += linbits;n 	} 	if ( y != 0 ) 	{ 	    *ext <<= 1; 	    *ext |= signy;w 	    *xbits += 1;, 	}     }f     else     { /* No ESC-words */ 	idx = (x * ylen) + y; 	*code = h->table[idx];  	*cbits += h->hlen[ idx ]; 	if ( x != 0 ) 	{ 	    *code <<= 1;  	    *code |= signx; 	    *cbits += 1;  	} 	if ( y != 0 ) 	{ 	    *code <<= 1;  	    *code |= signy; 	    *cbits += 1;_ 	}     }      assert( *cbits <= 32 );      assert( *xbits <= 32 );g     return *cbits + *xbits;g } 