F /*********************************************************************?   Copyright (c) 1995 ISO/IEC JTC1 SC29 WG1, All Rights Reserved    formatBitstream.c G **********************************************************************/  /*   Revision History:   /   Date        Programmer                Comment G   ==========  ========================= =============================== /   1995/09/06  mc@fivebats.com           created A   1995/09/18  mc@fivebats.com           bugfix: WriteMainDataBits ?   1995/09/20  mc@fivebats.com           bugfix: store_side_info  */   #include "formatBitstream.h" #include <stdlib.h>  #include <stdio.h> #include <assert.h>    #ifndef EXIT_FAILURE #define EXIT_FAILURE 1 #endif  
 /* globals */  static int BitCount       = 0; static int ThisFrameSize  = 0; static int BitsRemaining  = 0;! static BitsFcnPtr PutBits = NULL;    /* forward declarations */6 static int store_side_info( BF_FrameData *frameInfo );J static int main_data( BF_FrameData *frameInfo, BF_FrameResults *results );P static int side_queue_elements( int *forwardFrameLength, int *forwardSILength ); static void free_side_queues(); , static void WriteMainDataBits( unsigned val,.                                unsigned nbits,% 			       BF_FrameResults *results );  /*9   BitStreamFrame is the public interface to the bitstream @   formatting package. It writes one frame of main data per call.     Assumptions:.   - The back pointer is zero on the first call5   - An integral number of bytes is written each frame   :   You should be able to change the frame length, side info9   length, #channels, #granules on a frame-by-frame basis.   ;   See formatBitstream.h for more information about the data &   structures and the bitstream syntax. */ voidF BF_BitstreamFrame( BF_FrameData *frameInfo, BF_FrameResults *results ) { 6     int elements, forwardFrameLength, forwardSILength;  3     assert( frameInfo->nGranules <= MAX_GRANULES ); 3     assert( frameInfo->nChannels <= MAX_CHANNELS );   )     /* get ptr to bit writing function */ !     PutBits = frameInfo->putbits;      assert( PutBits );(     /* save SI and compute its length */5     results->SILength = store_side_info( frameInfo );   ?     /* write the main data, inserting SI to maintain framing */ >     results->mainDataLength = main_data( frameInfo, results );       /*7       Caller must ensure that back SI and main data are 9       an integral number of bytes, since the back pointer 5       can only point to a byte boundary and this code         does not add stuffing bits     */'     assert( (BitsRemaining % 8) == 0 );   #     /* calculate nextBackPointer */ L     elements = side_queue_elements( &forwardFrameLength, &forwardSILength );b     results->nextBackPtr = (BitsRemaining / 8) + (forwardFrameLength / 8) - (forwardSILength / 8); }    /*,   FlushBitstream writes zeros into main data+   until all queued headers are written. The $   queue data buffers are also freed. */ voidF BF_FlushBitstream( BF_FrameData *frameInfo, BF_FrameResults *results ) { 6     int elements, forwardFrameLength, forwardSILength;  )     /* get ptr to bit writing function */ !     PutBits = frameInfo->putbits;      assert( PutBits );  L     elements = side_queue_elements( &forwardFrameLength, &forwardSILength );       if ( elements )      { : 	int bitsRemaining = forwardFrameLength - forwardSILength;) 	int wordsRemaining = bitsRemaining / 32;  	while ( wordsRemaining-- ) ) 	    WriteMainDataBits( 0, 32, results ); 8 	WriteMainDataBits( 0, (bitsRemaining % 32), results );	     }   C     results->mainDataLength = forwardFrameLength - forwardSILength; .     results->SILength       = forwardSILength;      results->nextBackPtr    = 0;       /* reclaim queue space */      free_side_queues();        /* reinitialize globals */     BitCount       = 0;      ThisFrameSize  = 0;      BitsRemaining  = 0;          PutBits        = NULL;     return;  }    int ' BF_PartLength( BF_BitstreamPart *part )  { ,     BF_BitstreamElement *ep = part->element;     int i, bits;  
     bits = 0; 1     for ( i = 0; i < part->nrEntries; i++, ep++ )  	bits += ep->length;     return bits; }      /*+   The following is all private to this file  */   typedef struct {      int frameLength;     int SILength;      int nGranules;     int nChannels;     BF_PartHolder *headerPH;     BF_PartHolder *frameSIPH; -     BF_PartHolder *channelSIPH[MAX_CHANNELS]; <     BF_PartHolder *spectrumSIPH[MAX_GRANULES][MAX_CHANNELS];
 } MYSideInfo;   # static MYSideInfo *get_side_info();  static int write_side_info(); S typedef int (*PartWriteFcnPtr)( BF_BitstreamPart *part, BF_FrameResults *results );     
 static intE writePartMainData( BF_BitstreamPart *part, BF_FrameResults *results )  {      BF_BitstreamElement *ep;     int i, bits;       assert( results );     assert( part );   
     bits = 0;      ep = part->element; 1     for ( i = 0; i < part->nrEntries; i++, ep++ )      { 5 	WriteMainDataBits( ep->value, ep->length, results );  	bits += ep->length;     }      return bits; }   
 static intE writePartSideInfo( BF_BitstreamPart *part, BF_FrameResults *results )  {      BF_BitstreamElement *ep;     int i, bits;       assert( part );   
     bits = 0;      ep = part->element; 1     for ( i = 0; i < part->nrEntries; i++, ep++ )      { % 	(*PutBits)( ep->value, ep->length );  	bits += ep->length;     }      return bits; }   
 static int7 main_data( BF_FrameData *fi, BF_FrameResults *results )  {      int gr, ch, bits; +     PartWriteFcnPtr wp = writePartMainData; 
     bits = 0;       results->mainDataLength = 0;  ,     for ( gr = 0; gr < fi->nGranules; gr++ )) 	for ( ch = 0; ch < fi->nChannels; ch++ )  	{8 	    bits += (*wp)( fi->scaleFactors[gr][ch], results );8 	    bits += (*wp)( fi->codedData[gr][ch],    results );8 	    bits += (*wp)( fi->userSpectrum[gr][ch], results ); 	}0     bits += (*wp)( fi->userFrameData, results );     return bits; }    /*=   This is a wrapper around PutBits() that makes sure that the 9   framing header and side info are inserted at the proper    locations  */   static void   WriteMainDataBits( unsigned val, 		   unsigned nbits, 		   BF_FrameResults *results )  {      assert( nbits <= 32 );$     if ( BitCount == ThisFrameSize )     {  	BitCount = write_side_info();* 	BitsRemaining = ThisFrameSize - BitCount;     }      if ( nbits == 0 )  	return;      if ( nbits > BitsRemaining )     { 1 	unsigned extra = val >> (nbits - BitsRemaining);  	nbits -= BitsRemaining;$ 	(*PutBits)( extra, BitsRemaining ); 	BitCount = write_side_info();* 	BitsRemaining = ThisFrameSize - BitCount; 	(*PutBits)( val, nbits );     }      else 	(*PutBits)( val, nbits );     BitCount += nbits;     BitsRemaining -= nbits; (     assert( BitCount <= ThisFrameSize );!     assert( BitsRemaining >= 0 ); :     assert( (BitCount + BitsRemaining) == ThisFrameSize ); }     
 static int write_side_info()  {      MYSideInfo *si;      int bits, ch, gr; +     PartWriteFcnPtr wp = writePartSideInfo;   
     bits = 0;      si = get_side_info(); $     ThisFrameSize = si->frameLength;/     bits += (*wp)( si->headerPH->part,  NULL ); /     bits += (*wp)( si->frameSIPH->part, NULL );   ,     for ( ch = 0; ch < si->nChannels; ch++ )2 	bits += (*wp)( si->channelSIPH[ch]->part, NULL );  ,     for ( gr = 0; gr < si->nGranules; gr++ )) 	for ( ch = 0; ch < si->nChannels; ch++ ) ; 	    bits += (*wp)( si->spectrumSIPH[gr][ch]->part, NULL );      return bits; }    typedef struct side_info_link  {       struct side_info_link *next;#     MYSideInfo           side_info;  } side_info_link;   7 static struct side_info_link *side_queue_head   = NULL; 7 static struct side_info_link *side_queue_free   = NULL;   5 static void free_side_info_link( side_info_link *l );   
 static int6 side_queue_elements( int *frameLength, int *SILength ) {      int elements = 0; (     side_info_link *l = side_queue_head;       *frameLength = 0;      *SILength    = 0;   /     for ( l = side_queue_head; l; l = l->next )      {  	elements++;* 	*frameLength += l->side_info.frameLength;' 	*SILength    += l->side_info.SILength;*     }*     return elements; }*  
 static int% store_side_info( BF_FrameData *info )C {C     int ch, gr;i     side_info_link *l = NULL;a/     /* obtain a side_info_link to store info */*(     side_info_link *f = side_queue_free;     int bits = 0;a       if ( f == NULL )!     { /* must allocate another */  #ifdef DEBUG 	static int n_si = 0;= 	n_si += 1;=B 	fprintf( stderr, "allocating side_info_link number %d\n", n_si ); #endif< 	l = (side_info_link *) calloc( 1, sizeof(side_info_link) ); 	if ( l == NULL )  	{9 	    fprintf( stderr, "cannot allocate side_info_link" );a 	    exit( EXIT_FAILURE ); 	} 	l->next = NULL;F 	l->side_info.headerPH  = BF_newPartHolder( info->header->nrEntries );G 	l->side_info.frameSIPH = BF_newPartHolder( info->frameSI->nrEntries );e+ 	for ( ch = 0; ch < info->nChannels; ch++ )tW 	    l->side_info.channelSIPH[ch] = BF_newPartHolder( info->channelSI[ch]->nrEntries );o+ 	for ( gr = 0; gr < info->nGranules; gr++ )_/ 	    for ( ch = 0; ch < info->nChannels; ch++ )e^ 		l->side_info.spectrumSIPH[gr][ch] = BF_newPartHolder( info->spectrumSI[gr][ch]->nrEntries ); 	v     }e     else%     { /* remove from the free list */u 	side_queue_free = f->next;  	f->next = NULL; 	l = f;t     }      /* copy data */ 1     l->side_info.frameLength = info->frameLength;t/     l->side_info.nGranules   = info->nGranules;t/     l->side_info.nChannels   = info->nChannels;uf     l->side_info.headerPH    = BF_LoadHolderFromBitstreamPart( l->side_info.headerPH,  info->header );g     l->side_info.frameSIPH   = BF_LoadHolderFromBitstreamPart( l->side_info.frameSIPH, info->frameSI );   *     bits += BF_PartLength( info->header );+     bits += BF_PartLength( info->frameSI );   .     for ( ch = 0; ch < info->nChannels; ch++ )     {e] 	l->side_info.channelSIPH[ch] = BF_LoadHolderFromBitstreamPart( l->side_info.channelSIPH[ch],e% 								       info->channelSI[ch] ); . 	bits += BF_PartLength( info->channelSI[ch] );     }r  .     for ( gr = 0; gr < info->nGranules; gr++ )+ 	for ( ch = 0; ch < info->nChannels; ch++ )t 	{k 	    l->side_info.spectrumSIPH[gr][ch] = BF_LoadHolderFromBitstreamPart( l->side_info.spectrumSIPH[gr][ch], % 										info->spectrumSI[gr][ch] ); 7 	    bits += BF_PartLength( info->spectrumSI[gr][ch] );* 	}!     l->side_info.SILength = bits;d     /* place at end of queue */      f = side_queue_head;     if ( f == NULL )     {  /* empty queue */ 	side_queue_head = l;s     }e     else     { /* find last element */  	while ( f->next ) 	    f = f->next;s
 	f->next = l;n     }      return bits; }B   static MYSideInfo* get_side_info()l {a(     side_info_link *f = side_queue_free;(     side_info_link *l = side_queue_head;          /*8       If we stop here it means you didn't provide enough9       headers to support the amount of main data that wasl       written.     */     assert( l );          /* update queue head */t     side_queue_head = l->next;       /*1       Append l to the free list. You can continuea/       to use it until store_side_info is calledl1       again, which will not happen again for this        frame.     */     side_queue_free = l;     l->next = f;     return &l->side_info;t };   static voids free_side_queues() {      side_info_link *l, *next;L     ,     for ( l = side_queue_head; l; l = next )     {g 	next = l->next; 	free_side_info_link( l );     }e     side_queue_head = NULL;   ,     for ( l = side_queue_free; l; l = next )     {  	next = l->next; 	free_side_info_link( l );     }n     side_queue_free = NULL;  }    static voidi( free_side_info_link( side_info_link *l ) {e     int gr, ch;t  H     l->side_info.headerPH  = BF_freePartHolder( l->side_info.headerPH );I     l->side_info.frameSIPH = BF_freePartHolder( l->side_info.frameSIPH );z  5     for ( ch = 0; ch < l->side_info.nChannels; ch++ ) R 	l->side_info.channelSIPH[ch] = BF_freePartHolder( l->side_info.channelSIPH[ch] );  5     for ( gr = 0; gr < l->side_info.nGranules; gr++ ) 2 	for ( ch = 0; ch < l->side_info.nChannels; ch++ )` 	    l->side_info.spectrumSIPH[gr][ch] = BF_freePartHolder( l->side_info.spectrumSIPH[gr][ch] );       free( l ); }  /*'   Allocate a new holder of a given size  */3 BF_PartHolder *BF_newPartHolder( int max_elements ); { A     BF_PartHolder *newPH    = calloc( 1, sizeof(BF_PartHolder) );r     assert( newPH );(     newPH->max_elements  = max_elements;A     newPH->part          = calloc( 1, sizeof(BF_BitstreamPart) );[     assert( newPH->part );O     newPH->part->element = calloc( max_elements, sizeof(BF_BitstreamElement) );n#     assert( newPH->part->element );)     newPH->part->nrEntries = 0;e     return newPH;  }   I BF_PartHolder *BF_NewHolderFromBitstreamPart( BF_BitstreamPart *thePart )u { F     BF_PartHolder *newHolder = BF_newPartHolder( thePart->nrEntries );@     return BF_LoadHolderFromBitstreamPart( newHolder, thePart ); }e  d BF_PartHolder *BF_LoadHolderFromBitstreamPart( BF_PartHolder *theHolder, BF_BitstreamPart *thePart ) {,     BF_BitstreamElement *pElem;;
     int i;  #     theHolder->part->nrEntries = 0;P.     for ( i = 0; i < thePart->nrEntries; i++ )     {e  	pElem = &(thePart->element[i]);/ 	theHolder = BF_addElement( theHolder, pElem );      }      return theHolder;r }e   /*4   Grow or shrink a part holder. Always creates a new5   one of the right length and frees the old one after    copying the data.  */L BF_PartHolder *BF_resizePartHolder( BF_PartHolder *oldPH, int max_elements ) {e     int elems, i;n     BF_PartHolder *newPH;r   #ifdef DEBUG<     fprintf( stderr, "Resizing part holder from %d to %d\n",* 	     oldPH->max_elements, max_elements ); #endif/     /* create new holder of the right length */{-     newPH = BF_newPartHolder( max_elements );   %     /* copy values from old to new */DV     elems = (oldPH->max_elements > max_elements) ? max_elements : oldPH->max_elements;#     newPH->part->nrEntries = elems;a!     for ( i = 0; i < elems; i++ ) 3 	newPH->part->element[i] = oldPH->part->element[i];        /* free old holder */d     BF_freePartHolder( oldPH );t          return newPH;  }   8 BF_PartHolder *BF_freePartHolder( BF_PartHolder *thePH ) { !     free( thePH->part->element );t     free( thePH->part );     free( thePH );     return NULL; }e   /*0   Add theElement to thePH, growing the holder if1   necessary. Returns ptr to the holder, which may($   not be the one you called it with! */U BF_PartHolder *BF_addElement( BF_PartHolder *thePH, BF_BitstreamElement *theElement )  {s!     BF_PartHolder *retPH = thePH;s4     int needed_entries = thePH->part->nrEntries + 1;D     int extraPad = 8;  /* add this many more if we need to resize */       /* grow if necessary */b/     if ( needed_entries > thePH->max_elements ) A 	retPH = BF_resizePartHolder( thePH, needed_entries + extraPad );i       /* copy the data */sA     retPH->part->element[retPH->part->nrEntries++] = *theElement;t     return retPH;i }(   /*9   Add a bit value and length to the element list in thePHt */O BF_PartHolder *BF_addEntry( BF_PartHolder *thePH, uint32 value, uint16 length )h {r"     BF_BitstreamElement myElement;     myElement.value  = value;      myElement.length = length;     if ( length )U+ 	return BF_addElement( thePH, &myElement );s     else 	return thePH; }>