G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) H  * ISO 13818-3 MPEG-2 Audio Encoder - Lower Sampling Frequency Extension  *9  * $Id: encode.c,v 1.1 1996/02/14 04:04:23 rowlands Exp $   *  * $Log: encode.c,v $ .  * Revision 1.1  1996/02/14 04:04:23  rowlands  * Initial revision   *  * Received from Mike Coleman H  **********************************************************************/G /********************************************************************** G  *   date   programmers         comment                               * G  * 3/01/91  Douglas Wong,       start of version 1.1 records          * G  *          Davis Pan                                                 * G  * 3/06/91  Douglas Wong        rename: setup.h to endef.h            * G  *                                      efilter to enfilter           * G  *                                      ewindow to enwindow           * G  *                              integrated "quantizer", "scalefactor",* G  *                              and "transmission" files              * G  *                              update routine "window_subband"       * G  * 3/31/91  Bill Aspromonte     replaced read_filter by               * G  *                              create_an_filter                      * G  * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         * G  *                              Incorporated Jean-Georges Fritsch's   * G  *                              "bitstream.c" package.                * G  *                              Incorporated Bill Aspromonte's        * G  *                              filterbank coefficient matrix         * G  *                              calculation routines and added        * G  *                              roundoff to coincide with specs.      * G  *                              Modified to strictly adhere to        * G  *                              encoded bitstream specs, including    * G  *                              "Berlin changes".                     * G  *                              Modified PCM sound file handling to   * G  *                              process all incoming samples and fill * G  *                              out last encoded frame with zeros     * G  *                              (silence) if needed.                  * G  *                              Located and fixed numerous software   * G  *                              bugs and table data errors.           * G  * 19jun91  dpwe (Aware)        moved "alloc_*" reader to common.c    * G  *                              Globals sblimit, alloc replaced by new* G  *                              struct 'frame_params' passed as arg.  * G  *                              Added JOINT STEREO coding, layers I,II* G  *                              Affects: *_bit_allocation,            * G  *                              subband_quantization, encode_bit_alloc* G  *                              sample_encoding                       * G  * 6/10/91  Earle Jennings      modified II_subband_quantization to   * G  *                              resolve type cast problem for MS_DOS  * G  * 6/11/91  Earle Jennings      modified to avoid overflow on MS_DOS  * G  *                              in routine filter_subband             * G  * 7/10/91  Earle Jennings      port to MsDos from MacIntosh version  * G  * 8/ 8/91  Jens Spille         Change for MS-C6.00                   * G  *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           * G  *          Don H. Lee,                                               * G  *          Peter W. Farrett                                          * G  *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   * G  *                              newly introduced function encode_CRC  * G  *11/ 8/91  Kathy Wang          Documentation of code                 * G  *                              All variablenames are referred to     * G  *                              with surrounding pound (#) signs      * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  * 6/16/92  Shaun Astarabadi    Changed I_scale_factor_calc() and     * G  *                              II_scale_factor_calc() to use scale   * G  *                              factor 0 thru 62 only and not to      * G  *                              encode index 63 into the bit stream.  * G  * 7/27/92  Mike Li             (re-)Port to MS-DOS                   * G  * 9/22/92  jddevine@aware.com  Fixed _scale_factor_calc() defs       * G  * 3/31/93  Giogio Dimino       changed II_a_bit_allocation() from:   * G  *                              if( ad > ...) to if(ad >= ...)        * G  * 8/05/93  TEST                changed I_a_bit_allocation() from:    * G  *                              if( ad > ...) to if(ad >= ...)        * G  * 8/02/95  mc@fivebats.com     Changed audio file reading code to    * G  *                              read samples big-endian               * G  *10/15/95  mc@fivebats.com     Modified get_audio() for layer3-LSF   * H  **********************************************************************/    #include "common.h"  #include "encoder.h"  
 #ifdef MS_DOS   extern unsigned _stklen = 16384; #endif    J /*=======================================================================\I |                                                                       | I | This segment contains all the core routines of the encoder,           | I | except for the psychoacoustic models.                                 | I |                                                                       | I | The user can select either one of the two psychoacoustic              | I | models. Model I is a simple tonal and noise masking threshold         | I | generator, and Model II is a more sophisticated cochlear masking      | I | threshold generator. Model I is recommended for lower complexity      | I | applications whereas Model II gives better subjective quality at low  | I | bit rates.                                                            | I |                                                                       | I | Layers I and II of mono, stereo, and joint stereo modes are supported.| I | Routines associated with a given layer are prefixed by "I_" for layer | I | 1 and "II_" for layer 2.                                              | J \=======================================================================*/   I /************************************************************************  *  * read_samples() * ; * PURPOSE:  reads the PCM samples from a file to the buffer  * 
 *  SEMANTICS: B * Reads #samples_read# number of shorts from #musicin# filepointer> * into #sample_buffer[]#.  Returns the number of samples read. * I ************************************************************************/   K unsigned long read_samples(musicin, sample_buffer, num_samples, frame_size)  FILE *musicin; short sample_buffer[2304];& unsigned long num_samples, frame_size; {      unsigned long samples_read; )     static unsigned long samples_to_read;      static char init = TRUE;       if (init) { &         samples_to_read = num_samples;         init = FALSE;      } &     if (samples_to_read >= frame_size)"         samples_read = frame_size;     else'         samples_read = samples_to_read;      if ((samples_read = O          fread(sample_buffer, sizeof(short), (int)samples_read, musicin)) == 0) *         printf("Hit end of audio data\n");     /*A        Samples are big-endian. If this is a little-endian machine         we must swap       */ +     if ( NativeByteOrder == order_unknown )        { ( 	NativeByteOrder = DetermineByteOrder();( 	if ( NativeByteOrder == order_unknown ) 	  {6 	    fprintf( stderr, "byte order not determined\n" ); 	    exit( 1 );  	  }       }  #ifndef VMS 0     if ( NativeByteOrder == order_littleEndian )6       SwapBytesInWords( sample_buffer, samples_read ); #endif  $     samples_to_read -= samples_read;8     if (samples_read < frame_size && samples_read > 0) {N         printf("Insufficient PCM input for one frame - fillout with zeros\n");M         for (; samples_read < frame_size; sample_buffer[samples_read++] = 0);          samples_to_read = 0;     }      return(samples_read);  }   I /************************************************************************  * 
 * get_audio()  * B * PURPOSE:  reads a frame of audio data from a file to the buffer,< *   aligns the data for future processing, and separates the *   left and right channels  *  * I ************************************************************************/    E unsigned long get_audio( musicin, buffer, num_samples, stereo, info )  FILE *musicin; short FAR buffer[2][1152]; unsigned long num_samples; int stereo;  layer *info; { 
     int j;     short insamp[2304];      unsigned long samples_read;      int lay;     lay = info->lay;  -     if ( (lay == 3) && (info->version == 0) )      {  	if ( stereo == 2 )  	{? 	    samples_read = read_samples( musicin, insamp, num_samples,  					 (unsigned long) 1152 );   	    for ( j = 0; j < 576; j++ ) 	    { 		buffer[0][j] = insamp[2 * j]; # 		buffer[1][j] = insamp[2 * j + 1];  	    } 	} 	else  	{? 	    samples_read = read_samples( musicin, insamp, num_samples,  					 (unsigned long) 576 );  	    for ( j = 0; j < 576; j++ ) 	    { 		buffer[0][j] = insamp[j];  		buffer[1][j] = 0;  	    } 	}     }      else     {  	if (lay == 1){ + 	    if(stereo == 2){ /* layer 1, stereo */ ; 		samples_read = read_samples(musicin, insamp, num_samples,  					    (unsigned long) 768); 		for(j=0;j<448;j++) { 		    if(j<64) {# 			buffer[0][j] = buffer[0][j+384]; # 			buffer[1][j] = buffer[1][j+384];  		    }  		    else {" 			buffer[0][j] = insamp[2*j-128];" 			buffer[1][j] = insamp[2*j-127]; 		    }  		}  	    } 	    else { /* layer 1, mono */ ; 		samples_read = read_samples(musicin, insamp, num_samples,  					    (unsigned long) 384); 		for(j=0;j<448;j++){  		    if(j<64) {# 			buffer[0][j] = buffer[0][j+384];  			buffer[1][j] = 0; 		    }  		    else { 			buffer[0][j] = insamp[j-64];  			buffer[1][j] = 0; 		    }  		}  	    } 	} 	else { 2 	    if(stereo == 2){ /* layer 2 (or 3), stereo */; 		samples_read = read_samples(musicin, insamp, num_samples,  					    (unsigned long) 2304);  		for(j=0;j<1152;j++) { ! 		    buffer[0][j] = insamp[2*j]; # 		    buffer[1][j] = insamp[2*j+1];  		}  	    }& 	    else { /* layer 2 (or 3), mono */; 		samples_read = read_samples(musicin, insamp, num_samples,  					    (unsigned long) 1152);  		for(j=0;j<1152;j++){ 		    buffer[0][j] = insamp[j];  		    buffer[1][j] = 0;  		}  	    } 	}     }      return(samples_read);  }    I /************************************************************************  *  * read_ana_window()  * E * PURPOSE:  Reads encoder window file "enwindow" into array #ana_win#  * I ************************************************************************/     void read_ana_window(ana_win)  double FAR ana_win[HAN_SIZE];  {      int i,j[4]; 
     FILE *fp;      double f[4];     char t[150];   .     if (!(fp = OpenTableFile("enwindow") ) ) {A        printf("Please check analysis window table 'enwindow'\n");         exit(1);      }      for (i=0;i<512;i+=4) {        fgets(t, 150, fp); D        sscanf(t,"C[%d] = %lf C[%d] = %lf C[%d] = %lf C[%d] = %lf\n",,               j, f,j+1,f+1,j+2,f+2,j+3,f+3);        if (i==j[0]) {            ana_win[i] = f[0];           ana_win[i+1] = f[1];           ana_win[i+2] = f[2];           ana_win[i+3] = f[3];        }
        else { ;           printf("Check index in analysis window table\n");            exit(1);        }        fgets(t,150,fp);      }      fclose(fp);  }   I /************************************************************************  *  * window_subband() * - * PURPOSE:  Overlapping window on PCM samples  *  * SEMANTICS:C * 32 16-bit pcm samples are scaled to fractional 2's complement and F * concatenated to the end of the window buffer #x#. The updated windowG * buffer #x# is then windowed by the analysis window #c# to produce the  * windowed sample #z#  * I ************************************************************************/    ! void window_subband(buffer, z, k)  short FAR **buffer;  double FAR z[HAN_SIZE];  int k; { '     typedef double FAR XX[2][HAN_SIZE];      static XX FAR *x; 
     int i, j;      static off[2] = {0,0};     static char init = 0;      static double FAR *c;      if (!init) {J         c = (double FAR *) mem_alloc(sizeof(double) * HAN_SIZE, "window");         read_ana_window(c); 1         x = (XX FAR *) mem_alloc(sizeof(XX),"x");          for (i=0;i<2;i++) $             for (j=0;j<HAN_SIZE;j++)                 (*x)[i][j] = 0;          init = 1;      }   7     /* replace 32 oldest samples with 32 new samples */ J     for (i=0;i<32;i++) (*x)[k][31-i+off[k]] = (double) *(*buffer)++/SCALE;4     /* shift samples into proper window positions */J     for (i=0;i<HAN_SIZE;i++) z[i] = (*x)[k][(i+off[k])&HAN_SIZE-1] * c[i];A     off[k] += 480;              /*offset is modulo (HAN_SIZE-1)*/      off[k] &= HAN_SIZE-1;    }    I /************************************************************************  *  * create_ana_filter()  * < * PURPOSE:  Calculates the analysis filter bank coefficients *  * SEMANTICS:C * Calculates the analysis filterbank coefficients and rounds to the @ * 9th decimal place accuracy of the filterbank tables in the ISO4 * document.  The coefficients are stored in #filter#  I ************************************************************************/     void create_ana_filter(filter) double FAR filter[SBLIMIT][64];  {     register int i,k;       for (i=0; i<32; i++)        for (k=0; k<64; k++) {K           if ((filter[i][k] = 1e9*cos((double)((2*i+1)*(16-k)*PI64))) >= 0) 3              modf(filter[i][k]+0.5, &filter[i][k]);            else3              modf(filter[i][k]-0.5, &filter[i][k]);            filter[i][k] *= 1e-9;     } }   I /************************************************************************  *  * filter_subband() * < * PURPOSE:  Calculates the analysis filter bank coefficients *  * SEMANTICS:L *      The windowed samples #z# is filtered by the digital filter matrix #m#D * to produce the subband samples #s#. This done by first selectivelyD * picking out values from the windowed samples, and then multiplying: * them by the filter matrix, producing 32 subband samples. * I ************************************************************************/     void filter_subband(z,s)# double FAR z[HAN_SIZE], s[SBLIMIT];  {     double y[64];    int i,j;  static char init = 0; "    typedef double MM[SBLIMIT][64]; static MM FAR *m; 
 #ifdef MS_DOS     long    SIZE_OF_MM;     SIZE_OF_MM      = SBLIMIT*64;    SIZE_OF_MM      *= 8;    if (!init) { 6        m = (MM FAR *) mem_alloc(SIZE_OF_MM, "filter");        create_ana_filter(*m);         init = 1;    } #else     if (!init) { 6        m = (MM FAR *) mem_alloc(sizeof(MM), "filter");        create_ana_filter(*m);         init = 1;    } #endifD    for (i=0;i<64;i++) for (j=0, y[i] = 0;j<8;j++) y[i] += z[i+64*j];    for (i=0;i<SBLIMIT;i++)=        for (j=0, s[i]= 0;j<64;j++) s[i] += (*m)[i][j] * y[j];  }   I /************************************************************************  * encode_info()  * B * PURPOSE:  Puts the syncword and header information on the output * bitstream. * I ************************************************************************/     void encode_info(fr_ps,bs) frame_params *fr_ps; Bit_stream_struc *bs;* {*$         layer *info = fr_ps->header;  *G         putbits(bs,0xfff,12);                    /* syncword 12 bits */ G         put1bit(bs,info->version);               /* ID        1 bit  */nG         putbits(bs,4-info->lay,2);               /* layer     2 bits */$M         put1bit(bs,!info->error_protection);     /* bit set => no err prot */r*         putbits(bs,info->bitrate_index,4);/         putbits(bs,info->sampling_frequency,2);*"         put1bit(bs,info->padding);B         put1bit(bs,info->extension);             /* private_bit */!         putbits(bs,info->mode,2); %         putbits(bs,info->mode_ext,2);0$         put1bit(bs,info->copyright);#         put1bit(bs,info->original); %         putbits(bs,info->emphasis,2);  }    I /************************************************************************h *  * mod()  **6 * PURPOSE:  Returns the absolute value of its argument * I ************************************************************************/    
 double mod(a) 	 double a;  {      return (a > 0) ? a : -a; }a  aI /************************************************************************  *  * I_combine_LR    (Layer I)  * II_combine_LR   (Layer II) *a> * PURPOSE:Combines left and right channels into a mono channel *bG * SEMANTICS:  The average of left and right subband samples is put into  * #joint_sample# **; * Layer I and II differ in frame length and # subbands used  * I ************************************************************************/    * void I_combine_LR(sb_sample, joint_sample)1 double FAR sb_sample[2][3][SCALE_BLOCK][SBLIMIT]; 1 double FAR joint_sample[3][SCALE_BLOCK][SBLIMIT]; / {   /* make a filtered mono for joint stereo */c     int sb, smp;        for(sb = 0; sb<SBLIMIT; ++sb)*       for(smp = 0; smp<SCALE_BLOCK; ++smp)'         joint_sample[0][smp][sb] = .5 * J                     (sb_sample[0][0][smp][sb] + sb_sample[1][0][smp][sb]); }t  a4 void II_combine_LR(sb_sample, joint_sample, sblimit)1 double FAR sb_sample[2][3][SCALE_BLOCK][SBLIMIT]; 1 double FAR joint_sample[3][SCALE_BLOCK][SBLIMIT];  int sblimit;. {  /* make a filtered mono for joint stereo */    int sb, smp, sufr;*        for(sb = 0; sb<sblimit; ++sb)*       for(smp = 0; smp<SCALE_BLOCK; ++smp)&          for(sufr = 0; sufr<3; ++sufr)K             joint_sample[sufr][smp][sb] = .5 * (sb_sample[0][sufr][smp][sb] J                                            + sb_sample[1][sufr][smp][sb]); }s  wI /************************************************************************  * # * I_scale_factor_calc     (Layer I)o$ * II_scale_factor_calc    (Layer II) **C * PURPOSE:For each subband, calculate the scale factor for each set  * of the 12 subband samples  * D * SEMANTICS:  Pick the scalefactor #multiple[]# just larger than the: * absolute value of the peak subband sample of 12 samples,< * and store the corresponding scalefactor index in #scalar#. * ; * Layer II has three sets of 12-subband samples for a givenl
 * subband. * I ************************************************************************/   l1 void I_scale_factor_calc(sb_sample,scalar,stereo) 0 double FAR sb_sample[][3][SCALE_BLOCK][SBLIMIT];" unsigned int scalar[][3][SBLIMIT]; int stereo;e {n    int i,j, k;    double s[SBLIMIT];S  S    for (k=0;k<stereo;k++) {       for (i=0;i<SBLIMIT;i++)E        for (j=1, s[i] = mod(sb_sample[k][0][0][i]);j<SCALE_BLOCK;j++)M/          if (mod(sb_sample[k][0][j][i]) > s[i]) .             s[i] = mod(sb_sample[k][0][j][i]);         for (i=0;i<SBLIMIT;i++)H        for (j=SCALE_RANGE-2,scalar[k][0][i]=0;j>=0;j--) /* $A 6/16/92 */#          if (s[i] <= multiple[j]) {               scalar[k][0][i] = j;             break;
          }    } }*  J /******************************** Layer II ******************************/   : void II_scale_factor_calc(sb_sample,scalar,stereo,sblimit)0 double FAR sb_sample[][3][SCALE_BLOCK][SBLIMIT];" unsigned int scalar[][3][SBLIMIT]; int stereo,sblimit;  {l   int i,j, k,t;r   double s[SBLIMIT];   ,   for (k=0;k<stereo;k++) for (t=0;t<3;t++) {     for (i=0;i<sblimit;i++)1D       for (j=1, s[i] = mod(sb_sample[k][t][0][i]);j<SCALE_BLOCK;j++).         if (mod(sb_sample[k][t][j][i]) > s[i])/              s[i] = mod(sb_sample[k][t][j][i]);       for (i=0;i<sblimit;i++)sH     for (j=SCALE_RANGE-2,scalar[k][t][i]=0;j>=0;j--)    /* $A 6/16/92 */        if (s[i] <= multiple[j]) {          scalar[k][t][i] = j;r          break;        } D       for (i=sblimit;i<SBLIMIT;i++) scalar[k][t][i] = SCALE_RANGE-1;     }  }   I /************************************************************************  *  * pick_scale  (Layer II) *tB * PURPOSE:For each subband, puts the smallest scalefactor of the 36 * associated with a frame into #max_sc#.  This is used! * used by Psychoacoustic Model I. . * (I would recommend changin max_sc to min_sc) *eI ************************************************************************/t   & void pick_scale(scalar, fr_ps, max_sc)# unsigned int scalar[2][3][SBLIMIT];n frame_params *fr_ps; double FAR max_sc[2][SBLIMIT]; {r   int i,j,k,max;   int stereo  = fr_ps->stereo;   int sblimit = fr_ps->sblimit;e  c   for (k=0;k<stereo;k++)8     for (i=0;i<sblimit;max_sc[k][i] = multiple[max],i++).       for (j=1, max = scalar[k][0][i];j<3;j++):          if (max > scalar[k][j][i]) max = scalar[k][j][i];D   for (i=sblimit;i<SBLIMIT;i++) max_sc[0][i] = max_sc[1][i] = 1E-20; }   I /************************************************************************t *o * put_scale   (Layer I)r *i< * PURPOSE:Sets #max_sc# to the scalefactor index in #scalar.( * This is used by Psychoacoustic Model I *fI ************************************************************************/*  *% void put_scale(scalar, fr_ps, max_sc)*# unsigned int scalar[2][3][SBLIMIT];  frame_params *fr_ps; double FAR max_sc[2][SBLIMIT]; {s    int i,j,k, max;    int stereo  = fr_ps->stereo;=     int sblimit = fr_ps->sblimit;  =1    for (k=0;k<stereo;k++) for (i=0;i<SBLIMIT;i++) 1         max_sc[k][i] = multiple[scalar[k][0][i]];c }a   I /************************************************************************a *s) * II_transmission_pattern (Layer II only)  * B * PURPOSE:For a given subband, determines whether to send 1, 2, or9 * all 3 of the scalefactors, and fills in the scalefactorc  * select information accordingly *eH * SEMANTICS:  The subbands and channels are classified based on how much? * the scalefactors changes over its three values (corresponding ? * to the 3 sets of 12 samples per subband).  The classification D * will send 1 or 2 scalefactors instead of three if the scalefactors: * do not change much.  The scalefactor select information,$ * #scfsi#, is filled in accordingly. * I ************************************************************************/a  I2 void II_transmission_pattern(scalar, scfsi, fr_ps)# unsigned int scalar[2][3][SBLIMIT];g unsigned int scfsi[2][SBLIMIT];o frame_params *fr_ps; {     int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;    int dscf[2];=    int class[2],i,j,k;> static int pattern[5][5] = {0x123, 0x122, 0x122, 0x133, 0x123,>                             0x113, 0x111, 0x111, 0x444, 0x113,>                             0x111, 0x111, 0x111, 0x333, 0x113,>                             0x222, 0x222, 0x222, 0x333, 0x123,?                             0x123, 0x122, 0x122, 0x133, 0x123};e  m    for (k=0;k<stereo;k++)*      for (i=0;i<sblimit;i++) {4        dscf[0] =  (scalar[k][0][i]-scalar[k][1][i]);4        dscf[1] =  (scalar[k][1][i]-scalar[k][2][i]);        for (j=0;j<2;j++) {'          if (dscf[j]<=-3) class[j] = 0;n;          else if (dscf[j] > -3 && dscf[j] <0) class[j] = 1;d2               else if (dscf[j] == 0) class[j] = 2;E                    else if (dscf[j] > 0 && dscf[j] < 3) class[j] = 3; *                         else class[j] = 4;        }-        switch (pattern[class[0]][class[1]]) {_)          case 0x123 :    scfsi[k][i] = 0;e                          break;f)          case 0x122 :    scfsi[k][i] = 3;u;                          scalar[k][2][i] = scalar[k][1][i];                           break;\)          case 0x133 :    scfsi[k][i] = 3;.;                          scalar[k][1][i] = scalar[k][2][i];                           break;=)          case 0x113 :    scfsi[k][i] = 1;d;                          scalar[k][1][i] = scalar[k][0][i];k                          break;r)          case 0x111 :    scfsi[k][i] = 2;iM                          scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];e                          break; )          case 0x222 :    scfsi[k][i] = 2; M                          scalar[k][0][i] = scalar[k][2][i] = scalar[k][1][i];s                          break;u)          case 0x333 :    scfsi[k][i] = 2;wM                          scalar[k][0][i] = scalar[k][1][i] = scalar[k][2][i];_                          break;o)          case 0x444 :    scfsi[k][i] = 2;)?                          if (scalar[k][0][i] > scalar[k][2][i])*@                               scalar[k][0][i] = scalar[k][2][i];M                          scalar[k][1][i] = scalar[k][2][i] = scalar[k][0][i];o       }a    } }t  tI /************************************************************************* ** * I_encode_scale  (Layer I)* * II_encode_scale (Layer II) *i? * PURPOSE:The encoded scalar factor information is arranged and 0 * queued into the output fifo to be transmitted. *;7 * For Layer II, the three scale factors associated withn; * a given subband and channel are transmitted in accordance - * with the scfsi, which is transmitted first.( *oI ************************************************************************/e  s1 void I_encode_scale(scalar, bit_alloc, fr_ps, bs)g# unsigned int scalar[2][3][SBLIMIT]; # unsigned int bit_alloc[2][SBLIMIT];] frame_params *fr_ps; Bit_stream_struc *bs;  {     int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;    int i,j;,  m1    for (i=0;i<SBLIMIT;i++) for (j=0;j<stereo;j++)(9       if (bit_alloc[j][i]) putbits(bs,scalar[j][0][i],6);  }	  fJ /***************************** Layer II  ********************************/  (9 void II_encode_scale(bit_alloc, scfsi, scalar, fr_ps, bs)_6 unsigned int bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT];# unsigned int scalar[2][3][SBLIMIT];{ frame_params *fr_ps; Bit_stream_struc *bs;0 {+    int stereo  = fr_ps->stereo;1     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;
    int i,j,k;]   1    for (i=0;i<sblimit;i++) for (k=0;k<stereo;k++)s5      if (bit_alloc[k][i])  putbits(bs,scfsi[k][i],2);(  i1    for (i=0;i<sblimit;i++) for (k=0;k<stereo;k++))K      if (bit_alloc[k][i])  /* above jsbound, bit_alloc[0][i] == ba[1][i] */[         switch (scfsi[k][i]) {$            case 0: for (j=0;j<3;j++)3                      putbits(bs,scalar[k][j][i],6);	                    break;             case 1:1            case 3: putbits(bs,scalar[k][0][i],6);_1                    putbits(bs,scalar[k][2][i],6);n                    break;(1            case 2: putbits(bs,scalar[k][0][i],6);]	         }u }r  [J /*=======================================================================\J |                                                                        |J |      The following routines are done after the masking threshold       |J | has been calculated by the fft analysis routines in the Psychoacoustic |J | model. Using the MNR calculated, the actual number of bits allocated   |J | to each subband is found iteratively.                                  |J |                                                                        |J \=======================================================================*/   I /************************************************************************o *e * I_bits_for_nonoise  (Layer I)   * II_bits_for_nonoise (Layer II) *): * PURPOSE:Returns the number of bits required to produce aF * mask-to-noise ratio better or equal to the noise/no_noise threshold. *f * SEMANTICS:2 * bbal = # bits needed for encoding bit allocationB * bsel = # bits needed for encoding scalefactor select information@ * banc = # bits needed for ancillary data (header info included) *_> * For each subband and channel, will add bits until one of the * following occurs: ? * - Hit maximum number of bits we can allocate for that subbandi< * - MNR is better than or equal to the minimum masking level *   (NOISY_MIN_MNR) A * Then the bits required for scalefactors, scfsi, bit allocation,*@ * and the subband samples are tallied (#req_bits#) and returned. * E * (NOISY_MIN_MNR) is the smallest MNR a subband can have before it isa@ * counted as 'noisy' by the logic which chooses the number of JS * subbands.f *e * Joint stereo is supported. *iI ************************************************************************/h  9 static double snr[18] = {0.00, 7.00, 11.00, 16.00, 20.84,*4                          25.28, 31.59, 37.75, 43.84,;                          49.89, 55.93, 61.96, 67.98, 74.01,F5                          80.03, 86.05, 92.01, 98.01};[  ' int I_bits_for_nonoise(perm_smr, fr_ps)   double FAR perm_smr[2][SBLIMIT]; frame_params *fr_ps; {t
    int i,j,k;t    int stereo  = fr_ps->stereo;)     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;    int req_bits = 0;  a/    /* initial b_anc (header) allocation bits */sB    req_bits = 32 + 4 * ( (jsbound * stereo) + (SBLIMIT-jsbound) );  N    for(i=0; i<SBLIMIT; ++i)*.      for(j=0; j<((i<jsbound)?stereo:1); ++j) {        for(k=0;k<14; ++k)l9          if( (-perm_smr[j][i] + snr[k]) >= NOISY_MIN_MNR)3,            break; /* we found enough bits */I          if(stereo == 2 && i >= jsbound)     /* check other JS channel */;            for(;k<14; ++k)F              if( (-perm_smr[1-j][i] + snr[k]) >= NOISY_MIN_MNR) break;K          if(k>0) req_bits += (k+1)*SCALE_BLOCK + 6*((i>=jsbound)?stereo:1);*    }    return req_bits;* }*  *J /***************************** Layer II  ********************************/  a/ int II_bits_for_nonoise(perm_smr, scfsi, fr_ps):  double FAR perm_smr[2][SBLIMIT]; unsigned int scfsi[2][SBLIMIT];h frame_params *fr_ps; {c    int sb,ch,ba;    int stereo  = fr_ps->stereo;e     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc;3    int req_bits = 0, bbal = 0, berr = 0, banc = 32;)-    int maxAlloc, sel_bits, sc_bits, smp_bits;sG static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */       /* added 92-08-11 shn */e>    if (fr_ps->header->error_protection) berr=16; else berr=0;   t    for (sb=0; sb<jsbound; ++sb) +      bbal += stereo * (*alloc)[sb][0].bits;0%    for (sb=jsbound; sb<sblimit; ++sb)i"      bbal += (*alloc)[sb][0].bits;!    req_bits = banc + bbal + berr;*  *    for(sb=0; sb<sblimit; ++sb)2      for(ch=0; ch<((sb<jsbound)?stereo:1); ++ch) {.        maxAlloc = (1<<(*alloc)[sb][0].bits)-1;)        sel_bits = sc_bits = smp_bits = 0;e$        for(ba=0;ba<maxAlloc-1; ++ba)K          if( (-perm_smr[ch][sb] + snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])n              >= NOISY_MIN_MNR)2             break;      /* we found enough bits */D        if(stereo == 2 && sb >= jsbound) /* check other JS channel */"          for(;ba<maxAlloc-1; ++ba)N            if( (-perm_smr[1-ch][sb]+ snr[(*alloc)[sb][ba].quant+((ba>0)?1:0)])                 >= NOISY_MIN_MNR)              break;0        if(ba>0) {lS          smp_bits = SCALE_BLOCK * ((*alloc)[sb][ba].group * (*alloc)[sb][ba].bits);Z5          /* scale factor bits required for subband */           sel_bits = 2;3          sc_bits  = 6 * sfsPerScfsi[scfsi[ch][sb]]; +          if(stereo == 2 && sb >= jsbound) { .            /* each new js sb has L+R scfsis */            sel_bits += 2;f8            sc_bits  += 6 * sfsPerScfsi[scfsi[1-ch][sb]];
          }/          req_bits += smp_bits+sel_bits+sc_bits;j        }    }    return req_bits;< }I  ;I /************************************************************************  **# * I_main_bit_allocation   (Layer I)*$ * II_main_bit_allocation  (Layer II) *e@ * PURPOSE:For joint stereo mode, determines which of the 4 jointA * stereo modes is needed.  Then calls *_a_bit_allocation(), which*F * allocates bits for each of the subbands until there are no more bits6 * left, or the MNR is at the noise/no_noise threshold. *  * SEMANTICS: *p= * For joint stereo mode, joint stereo is changed to stereo if > * there are enough bits to encode stereo at or better than the< * no-noise threshold (NOISY_MIN_MNR).  Otherwise, the systemA * iteratively allocates less bits by using joint stereo until one! * of the following occurs:; * - there are no more noisy subbands (MNR >= NOISY_MIN_MNR)a@ * - mode_ext has been reduced to 0, which means that all but the> *   lowest 4 subbands have been converted from stereo to joint1 *   stereo, and no more subbands may be convertedt *sH *     This function calls *_bits_for_nonoise() and *_a_bit_allocation(). *iI ************************************************************************/i  -; void I_main_bit_allocation(perm_smr, bit_alloc, adb, fr_ps)*  double FAR perm_smr[2][SBLIMIT];# unsigned int bit_alloc[2][SBLIMIT];u	 int *adb;o frame_params *fr_ps; {t    int  noisy_sbs;    int  mode, mode_ext, lay, i;*    int  rq_db, av_db = *adb; static  int init = 0;e       if(init == 0) {$      /* rearrange snr for layer I */      snr[2] = snr[3];**      for (i=3;i<16;i++) snr[i] = snr[i+2];      init = 1;    }   ;    if((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO) {n)      fr_ps->header->mode = MPG_MD_STEREO; !      fr_ps->header->mode_ext = 0; %      fr_ps->jsbound = fr_ps->sblimit;j=      if(rq_db = I_bits_for_nonoise(perm_smr, fr_ps) > *adb) { 1        fr_ps->header->mode = MPG_MD_JOINT_STEREO;*@        mode_ext = 4;           /* 3 is least severe reduction */         lay = fr_ps->header->lay;        do {2           --mode_ext;I3           fr_ps->jsbound = js_bound(lay, mode_ext);]6           rq_db = I_bits_for_nonoise(perm_smr, fr_ps);2        } while( (rq_db > *adb) && (mode_ext > 0));*        fr_ps->header->mode_ext = mode_ext;D      }    /* well we either eliminated noisy sbs or mode_ext == 0 */    }C    noisy_sbs = I_a_bit_allocation(perm_smr, bit_alloc, adb, fr_ps);R }_  pJ /***************************** Layer II  ********************************/   C void II_main_bit_allocation(perm_smr, scfsi, bit_alloc, adb, fr_ps)/  double FAR perm_smr[2][SBLIMIT]; unsigned int scfsi[2][SBLIMIT]; # unsigned int bit_alloc[2][SBLIMIT]; 	 int *adb;m frame_params *fr_ps; {+    int  noisy_sbs, nn;    int  mode, mode_ext, lay;    int  rq_db, av_db = *adb;   ;    if((mode = fr_ps->actual_mode) == MPG_MD_JOINT_STEREO) { )      fr_ps->header->mode = MPG_MD_STEREO;s!      fr_ps->header->mode_ext = 0;*%      fr_ps->jsbound = fr_ps->sblimit;*E      if((rq_db=II_bits_for_nonoise(perm_smr, scfsi, fr_ps)) > *adb) {o1        fr_ps->header->mode = MPG_MD_JOINT_STEREO;d@        mode_ext = 4;           /* 3 is least severe reduction */         lay = fr_ps->header->lay;        do {#          --mode_ext;2          fr_ps->jsbound = js_bound(lay, mode_ext);=          rq_db = II_bits_for_nonoise(perm_smr, scfsi, fr_ps);n2        } while( (rq_db > *adb) && (mode_ext > 0));*        fr_ps->header->mode_ext = mode_ext;D      }    /* well we either eliminated noisy sbs or mode_ext == 0 */    }K    noisy_sbs = II_a_bit_allocation(perm_smr, scfsi, bit_alloc, adb, fr_ps);p }]  [I /************************************************************************n *  * I_a_bit_allocation  (Layer I)]  * II_a_bit_allocation (Layer II) * A * PURPOSE:Adds bits to the subbands with the lowest mask-to-noise[> * ratios, until the maximum number of bits for the subband has * been allocated.  *  * SEMANTICS:B * 1. Find the subband and channel with the smallest MNR (#min_sb#, *    and #min_ch#)A * 2. Calculate the increase in bits needed if we increase the bit ( *    allocation to the next higher levelE * 3. If there are enough bits available for increasing the resolution*C *    in #min_sb#, #min_ch#, and the subband has not yet reached itsIA *    maximum allocation, update the bit allocation, MNR, and bits_     available accordinglyLC * 4. Repeat until there are no more bits left, or no more available > *    subbands. (A subband is still available until the maximum@ *    number of bits for the subband has been allocated, or thereB *    aren't enough bits to go to the next higher resolution in the
     subband.)l *]I ************************************************************************/    N int I_a_bit_allocation(perm_smr, bit_alloc, adb, fr_ps) /* return noisy sbs */  double FAR perm_smr[2][SBLIMIT];# unsigned int bit_alloc[2][SBLIMIT];[	 int *adb;  frame_params *fr_ps; { ;    int i, k, smpl_bits, scale_bits, min_sb, min_ch, oth_ch;A2    int bspl, bscf, ad, noisy_sbs, done = 0, bbal ;!    double mnr[2][SBLIMIT], small;*    char used[2][SBLIMIT];     int stereo  = fr_ps->stereo;h     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc; static char init= 0; static int banc=32, berr=0;c  e    if (!init) {        init = 1;*O       if (fr_ps->header->error_protection) berr = 16;  /* added 92-08-11 shn */d    }9    bbal = 4 * ( (jsbound * stereo) + (SBLIMIT-jsbound) );I    *adb -= bbal + berr + banc;    ad= *adb;  ]3    for (i=0;i<SBLIMIT;i++) for (k=0;k<stereo;k++) {p%      mnr[k][i]=snr[0]-perm_smr[k][i];m      bit_alloc[k][i] = 0;e      used[k][i] = 0;    }    bspl = bscf = 0;t  e    do  {.      /* locate the subband with minimum SMR */6      small = mnr[0][0]+1;    min_sb = -1; min_ch = -1;3      for (i=0;i<SBLIMIT;i++) for (k=0;k<stereo;k++)m.        /* go on only if there are bits left */2        if (used[k][i] != 2 && small > mnr[k][i]) {          small = mnr[k][i];I!          min_sb = i;  min_ch = k;t        }:      if(min_sb > -1) {   /* there was something to find */4        /* first step of bit allocation is biggest */N        if (used[min_ch][min_sb])  { smpl_bits = SCALE_BLOCK; scale_bits = 0; }E        else                       { smpl_bits = 24; scale_bits = 6; }s9        if(min_sb >= jsbound)        scale_bits *= stereo;_  >8        /* check to see enough bits were available for */6        /* increasing resolution in the minimum band */  [8        if (ad >= bspl + bscf + scale_bits + smpl_bits) {8          bspl += smpl_bits; /* bit for subband sample */7          bscf += scale_bits; /* bit for scale factor */U%          bit_alloc[min_ch][min_sb]++;h9          used[min_ch][min_sb] = 1; /* subband has bits */l8          mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb]@                                + snr[bit_alloc[min_ch][min_sb]];A          /* Check if subband has been fully allocated max bits */sI          if (bit_alloc[min_ch][min_sb] ==  14 ) used[min_ch][min_sb] = 2;         }9        else            /* no room to improve this band */ A          used[min_ch][min_sb] = 2; /*   for allocation anymore */i-        if(stereo == 2 && min_sb >= jsbound) {*:          oth_ch = 1-min_ch;  /* joint-st : fix other ch */?          bit_alloc[oth_ch][min_sb] = bit_alloc[min_ch][min_sb];d5          used[oth_ch][min_sb] = used[min_ch][min_sb];I8          mnr[oth_ch][min_sb] = -perm_smr[oth_ch][min_sb]@                                + snr[bit_alloc[oth_ch][min_sb]];        }      }B    } while(min_sb>-1);     /* i.e. still some sub-bands to find */  A    /* Calculate the number of bits left, add on to pointed var */     ad -= bspl+bscf;x
    *adb = ad;1  (    /* see how many channels are noisy */$    noisy_sbs = 0; small = mnr[0][0];    for(k=0; k<stereo; ++k) {"      for(i = 0; i< SBLIMIT; ++i) {3        if(mnr[k][i] < NOISY_MIN_MNR)   ++noisy_sbs;i9        if(small > mnr[k][i])           small = mnr[k][i];]      }    }    return noisy_sbs; }s  J /***************************** Layer II  ********************************/  =? int II_a_bit_allocation(perm_smr, scfsi, bit_alloc, adb, fr_ps)d  double FAR perm_smr[2][SBLIMIT]; unsigned int scfsi[2][SBLIMIT]; # unsigned int bit_alloc[2][SBLIMIT];<	 int *adb;] frame_params *fr_ps; { @    int i, min_ch, min_sb, oth_ch, k, increment, scale, seli, ba;/    int bspl, bscf, bsel, ad, noisy_sbs, bbal=0;k!    double mnr[2][SBLIMIT], small;     char used[2][SBLIMIT];2    int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc; static char init= 0; static int banc=32, berr=0; G static int sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */        if (!init) {         init = 1;  M        if (fr_ps->header->error_protection) berr=16; /* added 92-08-11 shn */     }    for (i=0; i<jsbound; ++i)*      bbal += stereo * (*alloc)[i][0].bits;"    for (i=jsbound; i<sblimit; ++i)!      bbal += (*alloc)[i][0].bits;     *adb -= bbal + berr + banc;
    ad = *adb;s  i3    for (i=0;i<sblimit;i++) for (k=0;k<stereo;k++) {]%      mnr[k][i]=snr[0]-perm_smr[k][i];       bit_alloc[k][i] = 0;e      used[k][i] = 0;    }    bspl = bscf = bsel = 0;       do  {.      /* locate the subband with minimum SMR */0      small = 999999.0; min_sb = -1; min_ch = -1;2      for (i=0;i<sblimit;i++) for(k=0;k<stereo;++k)3        if (used[k][i]  != 2 && small > mnr[k][i]) {           small = mnr[k][i]; !          min_sb = i;  min_ch = k;       }:      if(min_sb > -1) {   /* there was something to find */=        /* find increase in bit allocation in subband [min] */*W        increment = SCALE_BLOCK * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].group *cL                         (*alloc)[min_sb][bit_alloc[min_ch][min_sb]+1].bits);         if (used[min_ch][min_sb])W          increment -= SCALE_BLOCK * ((*alloc)[min_sb][bit_alloc[min_ch][min_sb]].group*nM                            (*alloc)[min_sb][bit_alloc[min_ch][min_sb]].bits);i  h9        /* scale factor bits required for subband [min] */*D        oth_ch = 1 - min_ch;    /* above js bound, need both chans */2        if (used[min_ch][min_sb]) scale = seli = 0;D        else {          /* this channel had no bits or scfs before */          seli = 2;8          scale = 6 * sfsPerScfsi[scfsi[min_ch][min_sb]];/          if(stereo == 2 && min_sb >= jsbound) {f.            /* each new js sb has L+R scfsis */            seli += 2;i;            scale += 6 * sfsPerScfsi[scfsi[oth_ch][min_sb]];*
          }        }8        /* check to see enough bits were available for */6        /* increasing resolution in the minimum band */A        if (ad >= bspl + bscf + bsel + seli + scale + increment) {[>          ba = ++bit_alloc[min_ch][min_sb]; /* next up alloc */:          bspl += increment;  /* bits for subband sample */8          bscf += scale;      /* bits for scale factor */6          bsel += seli;       /* bits for scfsi code */9          used[min_ch][min_sb] = 1; /* subband has bits */ :          mnr[min_ch][min_sb] = -perm_smr[min_ch][min_sb] +A                                snr[(*alloc)[min_sb][ba].quant+1]; A          /* Check if subband has been fully allocated max bits */)M          if (ba >= (1<<(*alloc)[min_sb][0].bits)-1) used[min_ch][min_sb] = 2;k        }E        else used[min_ch][min_sb] = 2; /* can't increase this alloc */ -        if(min_sb >= jsbound && stereo == 2) { /          /* above jsbound, alloc applies L+R */iD          ba = bit_alloc[oth_ch][min_sb] = bit_alloc[min_ch][min_sb];5          used[oth_ch][min_sb] = used[min_ch][min_sb]; :          mnr[oth_ch][min_sb] = -perm_smr[oth_ch][min_sb] +A                                snr[(*alloc)[min_sb][ba].quant+1];i        }      }<    } while(min_sb > -1);   /* until could find no channel */*    /* Calculate the number of bits left */%    ad -= bspl+bscf+bsel;   *adb = ad;cJ    for (i=sblimit;i<SBLIMIT;i++) for (k=0;k<stereo;k++) bit_alloc[k][i]=0;   I    noisy_sbs = 0;  small = mnr[0][0];      /* calc worst noise in case */     for(k=0;k<stereo;++k) {      for (i=0;i<sblimit;i++) {0        if (small > mnr[k][i]) small = mnr[k][i];K        if(mnr[k][i] < NOISY_MIN_MNR) ++noisy_sbs; /* noise is not masked */         }    }    return noisy_sbs; }I   I /************************************************************************o * # * I_subband_quantization  (Layer I)_$ * II_subband_quantization (Layer II) *lA * PURPOSE:Quantizes subband samples to appropriate number of bitsd *rF * SEMANTICS:  Subband samples are divided by their scalefactors, which>  makes the quantization more efficient. The scaled samples areA * quantized by the function a*x+b, where a and b are functions ofiA * the number of quantization levels. The result is then truncated < * to the appropriate number of bits and the MSB is inverted. *MB * Note that for fractional 2's complement, inverting the MSB for a3  negative number x is equivalent to adding 1 to it._ *sI ************************************************************************/a  b static double a[17] = {sB   0.750000000, 0.625000000, 0.875000000, 0.562500000, 0.937500000,B   0.968750000, 0.984375000, 0.992187500, 0.996093750, 0.998046875,B   0.999023438, 0.999511719, 0.999755859, 0.999877930, 0.999938965,   0.999969482, 0.999984741 };2  4 static double b[17] = { G   -0.250000000, -0.375000000, -0.125000000, -0.437500000, -0.062500000,.G   -0.031250000, -0.015625000, -0.007812500, -0.003906250, -0.001953125,[G   -0.000976563, -0.000488281, -0.000244141, -0.000122070, -0.000061035,M   -0.000030518, -0.000015259 };   tA void I_subband_quantization(scalar, sb_samples, j_scale, j_samps,>5                             bit_alloc, sbband, fr_ps)b# unsigned int scalar[2][3][SBLIMIT];a2 double FAR sb_samples[2][3][SCALE_BLOCK][SBLIMIT];! unsigned int j_scale[3][SBLIMIT];dM double FAR j_samps[3][SCALE_BLOCK][SBLIMIT]; /* L+R for j-stereo if necess */ # unsigned int bit_alloc[2][SBLIMIT]; 4 unsigned int FAR sbband[2][3][SCALE_BLOCK][SBLIMIT]; frame_params *fr_ps; {w    int i, j, k, n, sig;     int stereo  = fr_ps->stereo;o     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;    double d; static char init = 0;       if (!init) {N      init = 1;E      /* rearrange quantization coef to correspond to layer I table */)      a[1] = a[2]; b[1] = b[2];9      for (i=2;i<15;i++) { a[i] = a[i+2]; b[i] = b[i+2]; }*    }6    for (j=0;j<SCALE_BLOCK;j++) for (i=0;i<SBLIMIT;i++)+      for (k=0;k<((i<jsbound)?stereo:1);k++)T        if (bit_alloc[k][i]) {IL          /* for joint stereo mode, have to construct a single subband streamH             for the js channels.  At present, we calculate a set of monoG             subband samples and pass them through the scaling system to ;             generate an alternate normalised sample stream.s  tM             Could normalise both streams (divide by their scfs), then average F             them.  In bad conditions, this could give rise to spuriousL             cancellations.  Instead, we could just select the sb stream fromI             the larger channel (higher scf), in which case _that_ channel(K             would be 'properly' reconstructed, and the mate would just be a<M             scaled version.  Spec recommends averaging the two (unnormalised)lF             subband channels, then normalising this new signal withoutK             actually sending this scale factor... This means looking ahead.           */)&          if(stereo == 2 && i>=jsbound)-            /* use the joint data passed in */ :            d = j_samps[0][j][i] / multiple[j_scale[0][i]];
          elsekB            d = sb_samples[k][0][j][i] / multiple[scalar[k][0][i]];7          /* scale and quantize floating point sample */a          n = bit_alloc[k][i];O!          d = d * a[n-1] + b[n-1]; B          /* extract MSB N-1 bits from the floating point sample */          if (d >= 0) sig = 1;t$          else { sig = 0; d += 1.0; }D          sbband[k][0][j][i] = (unsigned int) (d * (double) (1L<<n));@          /* tag the inverted sign bit to sbband at position N */-          if (sig) sbband[k][0][j][i] |= 1<<n;R        } }    J /***************************** Layer II  ********************************/   B void II_subband_quantization(scalar, sb_samples, j_scale, j_samps,6                              bit_alloc, sbband, fr_ps)# unsigned int scalar[2][3][SBLIMIT];*2 double FAR sb_samples[2][3][SCALE_BLOCK][SBLIMIT];! unsigned int j_scale[3][SBLIMIT];n, double FAR j_samps[3][SCALE_BLOCK][SBLIMIT];# unsigned int bit_alloc[2][SBLIMIT]; 4 unsigned int FAR sbband[2][3][SCALE_BLOCK][SBLIMIT]; frame_params *fr_ps; {     int i, j, k, s, n, qnt, sig;i    int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;    unsigned int stps;d    double d;"    al_table *alloc = fr_ps->alloc;      for (s=0;s<3;s++)       for (j=0;j<SCALE_BLOCK;j++)        for (i=0;i<sblimit;i++)/          for (k=0;k<((i<jsbound)?stereo:1);k++)e!            if (bit_alloc[k][i]) {n;              /* scale and quantize floating point sample */oK              if(stereo == 2 && i>=jsbound)       /* use j-stereo samples */c>                d = j_samps[s][j][i] / multiple[j_scale[s][i]];              elsejF                d = sb_samples[k][s][j][i] / multiple[scalar[k][s][i]];              if (mod(d) > 1.0)C                printf("Not scaled properly %d %d %d %d\n",k,s,j,i);*6              qnt = (*alloc)[i][bit_alloc[k][i]].quant;%              d = d * a[qnt] + b[qnt];dF              /* extract MSB N-1 bits from the floating point sample */!              if (d >= 0) sig = 1;s(              else { sig = 0; d += 1.0; }              n = 0;i #ifndef MS_DOS7              stps = (*alloc)[i][bit_alloc[k][i]].steps;=(              while ((1L<<n) < stps) n++; #else 6              while  ( ( (unsigned long)(1L<<(long)n) <L                        ((unsigned long) ((*alloc)[i][bit_alloc[k][i]].steps)                          & 0xffff                         ) $                        ) && ( n <16)                      ) n++;l #endif              n--;iH              sbband[k][s][j][i] = (unsigned int) (d * (double) (1L<<n));D              /* tag the inverted sign bit to sbband at position N */I              /* The bit inversion is a must for grouping with 3,5,9 steps 1                 so it is done for all subbands */a1              if (sig) sbband[k][s][j][i] |= 1<<n;e            }            for (s=0;s<3;s++)*              for (j=sblimit;j<SBLIMIT;j++)Y                for (i=0;i<SCALE_BLOCK;i++) for (k=0;k<stereo;k++) sbband[k][s][i][j] = 0;  }/   J /************************************************************************* * I_encode_bit_alloc  (Layer I)*  * II_encode_bit_alloc (Layer II) **: * PURPOSE:Writes bit allocation information onto bitstream *a= * Layer I uses 4 bits/subband for bit allocation information,i5 * and Layer II uses 4,3,2, or 0 bits depending on theI * quantization table used. **I ************************************************************************/q  ,- void I_encode_bit_alloc(bit_alloc, fr_ps, bs)_# unsigned int bit_alloc[2][SBLIMIT];  frame_params *fr_ps; Bit_stream_struc *bs;f {s    int i,k;e    int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;  r    for (i=0;i<SBLIMIT;i++)J      for (k=0;k<((i<jsbound)?stereo:1);k++) putbits(bs,bit_alloc[k][i],4); }s  aJ /***************************** Layer II  ********************************/   . void II_encode_bit_alloc(bit_alloc, fr_ps, bs)# unsigned int bit_alloc[2][SBLIMIT];_ frame_params *fr_ps; Bit_stream_struc *bs;  {     int i,k;_    int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc;       for (i=0;i<sblimit;i++)+      for (k=0;k<((i<jsbound)?stereo:1);k++)a7        putbits(bs,bit_alloc[k][i],(*alloc)[i][0].bits);* }*  *I /************************************************************************a *t * I_sample_encoding   (Layer I)P  * II_sample_encoding  (Layer II) *e> * PURPOSE:Put one frame of subband samples on to the bitstream *fB * SEMANTICS:  The number of bits allocated per sample is read from6 * the bit allocation information #bit_alloc#.  Layer 29 * supports writing grouped samples for quantization stepse * that are not a power of 2. * I ************************************************************************/l  o4 void I_sample_encoding(sbband, bit_alloc, fr_ps, bs)4 unsigned int FAR sbband[2][3][SCALE_BLOCK][SBLIMIT];# unsigned int bit_alloc[2][SBLIMIT];a frame_params *fr_ps; Bit_stream_struc *bs;l { 
    int i,j,k;i    int stereo  = fr_ps->stereo;      int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;  t    for(j=0;j<SCALE_BLOCK;j++) {o      for(i=0;i<SBLIMIT;i++)t,        for(k=0;k<((i<jsbound)?stereo:1);k++)N          if(bit_alloc[k][i]) putbits(bs,sbband[k][0][j][i],bit_alloc[k][i]+1);    } }*  *J /***************************** Layer II  ********************************/  a5 void II_sample_encoding(sbband, bit_alloc, fr_ps, bs)r4 unsigned int FAR sbband[2][3][SCALE_BLOCK][SBLIMIT];# unsigned int bit_alloc[2][SBLIMIT];  frame_params *fr_ps; Bit_stream_struc *bs;b {i    unsigned int temp;b    unsigned int i,j,k,s,x,y;    int stereo  = fr_ps->stereo;L     int sblimit = fr_ps->sblimit;     int jsbound = fr_ps->jsbound;"    al_table *alloc = fr_ps->alloc;  i    for (s=0;s<3;s++)!      for (j=0;j<SCALE_BLOCK;j+=3)=        for (i=0;i<sblimit;i++)/          for (k=0;k<((i<jsbound)?stereo:1);k++)n!            if (bit_alloc[k][i]) {(;              if ((*alloc)[i][bit_alloc[k][i]].group == 3) {1A                for (x=0;x<3;x++) putbits(bs,sbband[k][s][j+x][i],nL                                          (*alloc)[i][bit_alloc[k][i]].bits);              }              else { 5                y =(*alloc)[i][bit_alloc[k][i]].steps;]*                temp = sbband[k][s][j][i] +0                       sbband[k][s][j+1][i] * y +3                       sbband[k][s][j+2][i] * y * y; B                putbits(bs,temp,(*alloc)[i][bit_alloc[k][i]].bits);              }            } }y   I /************************************************************************  *  * encode_CRC *kI ************************************************************************/{  / void encode_CRC(crc, bs) unsigned int crc;i Bit_stream_struc *bs;i {i    putbits(bs, crc, 16); }[