G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) H  * ISO 13818-3 MPEG-2 Audio Encoder - Lower Sampling Frequency Extension  *9  * $Id: common.c,v 1.2 1997/01/19 22:28:29 rowlands Exp $   *  * $Log: common.c,v $ .  * Revision 1.2  1997/01/19 22:28:29  rowlands(  * Layer 3 bug fixes from Seymour Shlien  *.  * Revision 1.1  1996/02/14 04:04:23  rowlands  * Initial revision   *  * Received from Mike Coleman H  **********************************************************************/G /********************************************************************** G  *   date   programmers         comment                               * G  * 2/25/91  Doulas Wong,        start of version 1.0 records          * G  *          Davis Pan                                                 * G  * 5/10/91  W. Joseph Carter    Created this file for all common      * G  *                              functions and global variables.       * G  *                              Ported to Macintosh and Unix.         * G  *                              Added Jean-Georges Fritsch's          * G  *                              "bitstream.c" package.                * G  *                              Added routines to handle AIFF PCM     * G  *                              sound files.                          * G  *                              Added "mem_alloc()" and "mem_free()"  * G  *                              routines for memory allocation        * G  *                              portability.                          * G  *                              Added routines to convert between     * G  *                              Apple SANE extended floating point    * G  *                              format and IEEE double precision      * G  *                              floating point format.  For AIFF.     * G  * 02jul91 dpwe (Aware Inc)     Moved allocation table input here;    * G  *                              Tables read from subdir TABLES_PATH.  * G  *                              Added some debug printout fns (Write*)* G  * 7/10/91 Earle Jennings       replacement of the one float by FLOAT * G  *                              port to MsDos from MacIntosh version  * G  * 8/ 5/91 Jean-Georges Fritsch fixed bug in open_bit_stream_r()      * G  *10/ 1/91 S.I. Sudharsanan,    Ported to IBM AIX platform.           * G  *         Don H. Lee,                                                * G  *         Peter W. Farrett                                           * G  *10/3/91  Don H. Lee           implemented CRC-16 error protection   * G  *                              newly introduced functions are        * G  *                              I_CRC_calc, II_CRC_calc and           * G  *                              update_CRC. Additions and revisions   * G  *                              are marked with dhl for clarity       * G  *10/18/91 Jean-Georges Fritsch fixed bug in update_CRC(),            * G  *                              II_CRC_calc() and I_CRC_calc()        * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  * 3/20/92 Jean-Georges Fritsch  fixed bug in start-of-frame search   * G  * 6/15/92 Juan Pineda          added refill_buffer(bs) "n"           * G  *                              initialization                        * G  * 7/08/92 Susanne Ritscher     MS-DOS, MSC6.0 port fixes             * G  * 7/27/92 Mike Li               (re-)Port to MS-DOS                  * G  * 8/19/92 Soren H. Nielsen     Fixed bug in I_CRC_calc and in        * G  *                              II_CRC_calc.  Added function: new_ext * G  *                              for better MS-DOS compatability       * G  * 3/10/93 Kevin Peterson       changed aiff_read_headers to handle   * G  *                              chunks in any order.  now returns     * G  *                              position of sound data in file.       * G  * 3/31/93 Jens Spille          changed IFF_* string compares to use  * G  *                              strcmp()                              * G  * 5/30/93 Masahiro Iwadare     removed the previous modification     * G  *                              for UNIX.                             * G  * 8/27/93 Seymour Shlien,      Fixes in Unix and MSDOS ports,        * G  *         Daniel Lauzon, and                                         * G  *         Bill Truerniet                                             * G  *--------------------------------------------------------------------* G  *  8/24/93 Masahiro Iwadare    Included IS modification in Layer III.* G  *                              Changed for 1 pass decoding.          * G  *  9/07/93 Toshiyuki Ishino    Integrated Layer III with Ver 3.9.    * G  *--------------------------------------------------------------------* G  * 11/20/93 Masahiro Iwadare    Integrated Layer III with Ver 4.0.    * G  *--------------------------------------------------------------------* G  *  7/14/94 Juergen Koller      rewind of bitbuffer added             * G  *  6/12/95 Soeren H. Nielsen   Bug fix in new_ext().                 * G  *  7/11/95 Soeren H. Nielsen   Changes for MPEG-2 LSF Layer I and II * G  *--------------------------------------------------------------------* G  * 8/02/95  mc@fivebats.com     Added code to determine byte-order,   * G  *                              fixes to AIFF routines. Modified Mac  * G  *                              code to work with new Apple headers   * H  **********************************************************************/  H /*********************************************************************** *  *  Global Include Files  * H ***********************************************************************/   #include    "common.h"( #include	<string.h> /* 1995-07-11 shn */ #include	<ctype.h> #include <stdlib.h>   H /*********************************************************************** *  *  Global Variable Definitions * H ***********************************************************************/  G char *mode_names[4] = { "stereo", "j-stereo", "dual-ch", "single-ch" }; , char *layer_names[3] = { "I", "II", "III" };4 char *version_names[2] = { "MPEG-2 LSF", "MPEG-1" };  . /* 1: MPEG-1, 0: MPEG-2 LSF, 1995-07-11 shn */? double  s_freq[2][4] = {{22.05, 24, 16, 0}, {44.1, 48, 32, 0}};   . /* 1: MPEG-1, 0: MPEG-2 LSF, 1995-07-11 shn */ int     bitrate[2][3][15] = { A           {{0,32,48,56,64,80,96,112,128,144,160,176,192,224,256}, <            {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160},=            {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160}}, = 	  {{0,32,64,96,128,160,192,224,256,288,320,352,384,416,448}, A            {0,32,48,56,64,80,96,112,128,160,192,224,256,320,384}, @            {0,32,40,48,56,64,80,96,112,128,160,192,224,256,320}}
         };   double FAR multiple[64] = { 5 2.00000000000000, 1.58740105196820, 1.25992104989487, G 1.00000000000000, 0.79370052598410, 0.62996052494744, 0.50000000000000, G 0.39685026299205, 0.31498026247372, 0.25000000000000, 0.19842513149602, G 0.15749013123686, 0.12500000000000, 0.09921256574801, 0.07874506561843, G 0.06250000000000, 0.04960628287401, 0.03937253280921, 0.03125000000000, G 0.02480314143700, 0.01968626640461, 0.01562500000000, 0.01240157071850, G 0.00984313320230, 0.00781250000000, 0.00620078535925, 0.00492156660115, G 0.00390625000000, 0.00310039267963, 0.00246078330058, 0.00195312500000, G 0.00155019633981, 0.00123039165029, 0.00097656250000, 0.00077509816991, G 0.00061519582514, 0.00048828125000, 0.00038754908495, 0.00030759791257, G 0.00024414062500, 0.00019377454248, 0.00015379895629, 0.00012207031250, G 0.00009688727124, 0.00007689947814, 0.00006103515625, 0.00004844363562, G 0.00003844973907, 0.00003051757813, 0.00002422181781, 0.00001922486954, G 0.00001525878906, 0.00001211090890, 0.00000961243477, 0.00000762939453, G 0.00000605545445, 0.00000480621738, 0.00000381469727, 0.00000302772723, G 0.00000240310869, 0.00000190734863, 0.00000151386361, 0.00000120155435,  1E-20  };  0 enum byte_order NativeByteOrder = order_unknown;  H /*********************************************************************** *  *  Global Function Definitions * H ***********************************************************************/  E /* The system uses a variety of data files.  By opening them via this 5    function, we can accommodate various locations. */    FILE *OpenTableFile(name)  char *name;  {      char fulname[80];      char *envdir;      FILE *f;          fulname[0] = '\0';      #ifdef TABLES_PATHJ     strcpy(fulname, TABLES_PATH);   /* default relative path for tables */I #endif /* TABLES_PATH */          /* (includes terminal path seperator */      F #ifdef UNIX                       /* envir. variables for UNIX only */ {      char *getenv();      >     envdir = getenv(MPEGTABENV);   /* check for environment */     if(envdir != NULL) 	strcpy(fulname, envdir); @     strcat(fulname, PATH_SEPARATOR);  /* add a "/" on the end */ }  #endif /* UNIX */ D #ifdef VMS                       /* envir. variables for VMS only */ {      char *getenv();      >     envdir = getenv(MPEGTABENV);   /* check for environment */     if(envdir != NULL) 	strcpy(fulname, envdir);  }  #endif /* VMS */   strcat(fulname, name);$ if( (f=fopen(fulname,"r"))==NULL ) {>     fprintf(stderr,"OpenTable: could not find %s\n", fulname);      #ifdef UNIX      if(envdir != NULL)@ 	fprintf(stderr,"Check %s directory '%s'\n",MPEGTABENV, envdir);           elseI             fprintf(stderr,"Check local directory './%s' or setenv %s\n", -                     TABLES_PATH, MPEGTABENV); / #else /* not unix : no environment variables */    #ifdef TABLES_PATHI             fprintf(stderr,"Check local directory './%s'\n",TABLES_PATH);  #endif /* TABLES_PATH */   #endif /* UNIX */        } 
     return f;  }   H /*********************************************************************** * G * Read one of the data files ("alloc_*") specifying the bit allocation/ > * quatization parameters for each subband in layer II encoding * G **********************************************************************/   N int read_bit_alloc(table, alloc)        /* read in table, return # subbands */
 int table; al_table *alloc; { &         unsigned int a, b, c, d, i, j;         FILE *fp;          char name[16], t[80];          int sblim;            strcpy(name, "alloc_0");           switch (table) {6                 case 0 : name[6] = '0';         break;6                 case 1 : name[6] = '1';         break;6                 case 2 : name[6] = '2';         break;6                 case 3 : name[6] = '3';         break;A 		case 4 : name[6] = '4';		break; /* LSF, added 1995-07-11 shn */ (                 default : name[6] = '0';	         }   *         if (!(fp = OpenTableFile(name))) {G                 printf("Please check bit allocation table %s\n", name);                  exit(1);	         }   8         printf("using bit allocation table %s\n", name);           fgets(t, 80, fp); "         sscanf(t, "%d\n", &sblim);         while (!feof(fp)) { !                 fgets(t, 80, fp); I                 sscanf(t, "%d %d %d %d %d %d\n", &i, &j, &a, &b, &c, &d); 1                         (*alloc)[i][j].steps = a; 1                         (*alloc)[i][j].bits  = b; 1                         (*alloc)[i][j].group = c; 1                         (*alloc)[i][j].quant = d; 	         }          fclose(fp);          return sblim;  }   H /*********************************************************************** * B * Using the decoded info the appropriate possible quantization per * subband table is loaded  * G **********************************************************************/   I int pick_table(fr_ps)   /* choose table, load if necess, return # sb's */  frame_params *fr_ps; { 1         int table, lay, ws, bsp, br_per_ch, sfrq; M         int sblim = fr_ps->sblimit;     /* return current value if no load */   %         lay = fr_ps->header->lay - 1; +         bsp = fr_ps->header->bitrate_index; N         br_per_ch = bitrate[fr_ps->header->version][lay][bsp] / fr_ps->stereo;/         ws = fr_ps->header->sampling_frequency; 2         sfrq = s_freq[fr_ps->header->version][ws];K         /* decision rules refer to per-channel bitrates (kbits/sec/chan) */ < 	if (fr_ps->header->version == MPEG_AUDIO_ID) { /* MPEG-1 */+ 	    if ((sfrq == 48 && br_per_ch >= 56) || 2 		(br_per_ch >= 56 && br_per_ch <= 80)) table = 0;7 	    else if (sfrq != 48 && br_per_ch >= 96) table = 1; 7 	    else if (sfrq != 32 && br_per_ch <= 48) table = 2;  	    else table = 3; 	} 	else { /* MPEG-2 LSF */ 	    table = 4;  	}&         if (fr_ps->tab_num != table) {#            if (fr_ps->tab_num >= 0) 1               mem_free((void **)&(fr_ps->alloc)); F            fr_ps->alloc = (al_table FAR *) mem_alloc(sizeof(al_table),B                                                          "alloc");H            sblim = read_bit_alloc(fr_ps->tab_num = table, fr_ps->alloc);	         }          return sblim;  }    int js_bound(lay, m_ext) int lay, m_ext;  { B static int jsb_table[3][4] =  { { 4, 8, 12, 16 }, { 4, 8, 12, 16},K                                 { 0, 4, 8, 16} };  /* lay+m_e -> jsbound */   /     if(lay<1 || lay >3 || m_ext<0 || m_ext>3) { K         fprintf(stderr, "js_bound bad layer/modext (%d/%d)\n", lay, m_ext);          exit(1);     } $     return(jsb_table[lay-1][m_ext]); }   J void hdr_to_frps(fr_ps) /* interpret data in hdr str to fields in fr_ps */ frame_params *fr_ps; { : layer *hdr = fr_ps->header;     /* (or pass in as arg?) */  #     fr_ps->actual_mode = hdr->mode; 7     fr_ps->stereo = (hdr->mode == MPG_MD_MONO) ? 1 : 2; C     if (hdr->lay == 2)          fr_ps->sblimit = pick_table(fr_ps); 9     else                        fr_ps->sblimit = SBLIMIT; (     if(hdr->mode == MPG_MD_JOINT_STEREO);         fr_ps->jsbound = js_bound(hdr->lay, hdr->mode_ext);      else(         fr_ps->jsbound = fr_ps->sblimit;*     /* alloc, tab_num set in pick_table */ }    void WriteHdr(fr_ps, s)  frame_params *fr_ps; FILE *s; {  layer *info = fr_ps->header;  F    fprintf(s, "HDR: s=FFF, id=%X, l=%X, ep=%s, br=%X, sf=%X, pd=%X, ",O            info->version, info->lay, ((info->error_protection) ? "on" : "off"), I            info->bitrate_index, info->sampling_frequency, info->padding); 7    fprintf(s, "pr=%X, m=%X, js=%X, c=%X, o=%X, e=%X\n", 7            info->extension, info->mode, info->mode_ext, <            info->copyright, info->original, info->emphasis);?    fprintf(s, "alg.=%s, layer=%s, tot bitrate=%d, sfrq=%.1f\n", B            version_names[info->version], layer_names[info->lay-1],= 	   bitrate[info->version][info->lay-1][info->bitrate_index], <            s_freq[info->version][info->sampling_frequency]);4    fprintf(s, "mode=%s, sblim=%d, jsbd=%d, ch=%d\n",R            mode_names[info->mode], fr_ps->sblimit, fr_ps->jsbound, fr_ps->stereo);
    fflush(s);  }   % void WriteBitAlloc(bit_alloc, f_p, s) # unsigned int bit_alloc[2][SBLIMIT];  frame_params *f_p; FILE *s; {  int i,j; int st = f_p->stereo;  int sbl = f_p->sblimit;  int jsb = f_p->jsbound;        fprintf(s, "BITA ");     for(i=0; i<sbl; ++i) {$         if(i == jsb) fprintf(s,"-");         for(j=0; j<st; ++j) /             fprintf(s, "%1x", bit_alloc[j][i]);      } "     fprintf(s, "\n");   fflush(s); }   3 void WriteScale(bit_alloc, scfsi, scalar, fr_ps, s) M unsigned int bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT], scalar[2][3][SBLIMIT];  frame_params *fr_ps; FILE *s; {  int stereo  = fr_ps->stereo; int sblimit = fr_ps->sblimit; ! int lay     = fr_ps->header->lay; 
 int i,j,k;           if(lay == 2) {              fprintf(s, "SFSI ");:             for (i=0;i<sblimit;i++) for (k=0;k<stereo;k++)B                 if (bit_alloc[k][i])  fprintf(s,"%d",scfsi[k][i]);"             fprintf(s, "\nSCFs ");$             for (k=0;k<stereo;k++) {'                 for (i=0;i<sblimit;i++):(                     if (bit_alloc[k][i]).                         switch (scfsi[k][i]) {3                           case 0: for (j=0;j<3;j++)*D                                   fprintf(s,"%2d%c",scalar[k][j][i],:                                           (j==2)?';':'-');(                                   break;!                           case 1:*D                           case 3: fprintf(s,"%2d-",scalar[k][0][i]);D                                   fprintf(s,"%2d;",scalar[k][2][i]);(                                   break;D                           case 2: fprintf(s,"%2d;",scalar[k][0][i]);                         }.!                 fprintf(s, "\n"); 
             } 	         }          else{   /* lay == 1 */              fprintf(s, "SCFs ");:             for (i=0;i<sblimit;i++) for (k=0;k<stereo;k++)H                 if (bit_alloc[k][i])  fprintf(s,"%2d;",scalar[k][0][i]);             fprintf(s, "\n"); 	         }  }   2 void WriteSamples(ch, sample, bit_alloc, fr_ps, s) int ch; ! unsigned int FAR sample[SBLIMIT];e  unsigned int bit_alloc[SBLIMIT]; frame_params *fr_ps; FILE *s; {  int i; int stereo = fr_ps->stereo;  int sblimit = fr_ps->sblimit;c           fprintf(s, "SMPL ");         for (i=0;i<sblimit;i++)s'                 if ( bit_alloc[i] != 0) 1                     fprintf(s, "%d:", sample[i]); 1         if(ch==(stereo-1) )     fprintf(s, "\n"); 1         else                    fprintf(s, "\t");  }   C int NumericQ(s) /* see if a string lookd like a numeric argument */  char *s; { 
 char    c;  F     while( (c = *s++)!='\0' && isspace((int)c)) /* strip leading ws */	         ;      if( c == '+' || c == '-' )A         c = *s++;               /* perhaps skip leading + or - */      return isdigit((int)c);s }a  O int BitrateIndex(layr, bRate, version)   /* convert bitrate in kbps to index */i$ int     layr;           /* 1 or 2 */8 int     bRate;          /* legal rates from 32 to 448 */' int	version;	/* MPEG-1 or MPEG-2 LSF */s {  int     index = 0; int     found = 0;  !     while(!found && index<15)   {_4         if(bitrate[version][layr-1][index] == bRate)             found = 1;         else             ++index;     } 
     if(found)          return(index);
     else {O         fprintf(stderr, "BitrateIndex: %d (layer %d) is not a legal bitrate\n",                  bRate, layr);e$         return(-1);     /* Error! */     }  }   F int SmpFrqIndex(sRate, version)  /* convert samp frq in Hz to index */R long sRate;             /* legal rates 16000, 22050, 24000, 32000, 44100, 48000 */ int  *version; {i     if (sRate == 44100L) {,         *version = MPEG_AUDIO_ID; return(0);     }      else if (sRate == 48000L) {-,         *version = MPEG_AUDIO_ID; return(1);     }      else if (sRate == 32000L) { ,         *version = MPEG_AUDIO_ID; return(2);     }2     else if (sRate == 24000L) {c.         *version = MPEG_PHASE2_LSF; return(1);     }      else if (sRate == 22050L) {a.         *version = MPEG_PHASE2_LSF; return(0);     }t     else if (sRate == 16000L) {*.         *version = MPEG_PHASE2_LSF; return(2);     }a
     else {P         fprintf(stderr, "SmpFrqIndex: %ld is not a legal sample rate\n", sRate);$         return(-1);     /* Error! */     }i }S  P /******************************************************************************* * 7 *  Allocate number of bytes of memory equal to "block".v *fP *******************************************************************************/  ! void  FAR *mem_alloc(block, item)t unsigned long   block; char            *item; {1       void    *ptr;    #ifdef  MACINTOSHe     ptr = NewPtr(block); #endif   #ifdef MSC60W     /*ptr = (void FAR *) _fmalloc((unsigned int)block);*/ /* far memory, 92-07-08 sr */SQ     ptr = (void FAR *) malloc((unsigned int)block); /* far memory, 93-08-24 ss */S #endif  . #if ! defined (MACINTOSH) && ! defined (MSC60)%     ptr = (void FAR *) malloc(block);* #endif       if (ptr != NULL){C
 #ifdef  MSC60 L         _fmemset(ptr, 0, (unsigned int)block); /* far memory, 92-07-08 sr */ #else          memset(ptr, 0, block); #endif     }e	     else{_0         printf("Unable to allocate %s\n", item);         exit(0);     }.     return(ptr); }     M /****************************************************************************3 *n) *  Free memory pointed to by "*ptr_addr".a * N *****************************************************************************/   void    mem_free(ptr_addr) void    **ptr_addr;r {o       if (*ptr_addr != NULL){  #ifdef  MACINTOSH          DisposPtr(*ptr_addr);  #else          free(*ptr_addr); #endif         *ptr_addr = NULL;      }    }   P /******************************************************************************* * F *  Check block of memory all equal to a single byte, else return FALSE *-P *******************************************************************************/   int memcheck(array, test, num) char *array;? int test;       /* but only tested as a char (bottom 8 bits) */. int num; { 	  int i=0;   )    while (array[i] == test && i<num) i++;     if (i==num) return TRUE;-    else return FALSE;- }-  N /***************************************************************************** *w2 *  Routines to determine byte order and swap bytes *-N *****************************************************************************/  $ enum byte_order DetermineByteOrder() {      char s[ sizeof(long) + 1 ];w	     union      {          long longval;r%         char charval[ sizeof(long) ];L     } probe;5     probe.longval = 0x41424344L;  /* ABCD in ASCII */-.     strncpy( s, probe.charval, sizeof(long) );     s[ sizeof(long) ] = '\0';y5     /* fprintf( stderr, "byte order is %s\n", s ); */o!     if ( strcmp(s, "ABCD") == 0 )*         return order_bigEndian;e     else%         if ( strcmp(s, "DCBA") == 0 )*&             return order_littleEndian;         else!             return order_unknown;* }*  . void SwapBytesInWords( short *loc, int words ) {o
     int i;     short thisval;     char *dst, *src;     src = (char *) &thisval;!     for ( i = 0; i < words; i++ ).     {c         thisval = *loc;7         dst = (char *) loc++;          dst[0] = src[1];         dst[1] = src[0];     }* }*  N /*****************************************************************************  *6  *  Read Audio Interchange File Format (AIFF) headers.  *O  *****************************************************************************/r  ; int aiff_read_headers( FILE *file_ptr, IFF_AIFF *aiff_ptr )] {{+     int chunkSize, subSize, sound_position;:     ,     if ( fseek(file_ptr, 0, SEEK_SET) != 0 )         return -1;     5     if ( Read32BitsHighLow(file_ptr) != IFF_ID_FORM )-         return -1;     .     chunkSize = Read32BitsHighLow( file_ptr );     5     if ( Read32BitsHighLow(file_ptr) != IFF_ID_AIFF ),         return -1;          sound_position = 0;{     while ( chunkSize > 0 )6     {8         chunkSize -= 4;4.         switch ( Read32BitsHighLow(file_ptr) ) 	{                        case IFF_ID_COMM:,A             chunkSize -= subSize = Read32BitsHighLow( file_ptr );1B             aiff_ptr->numChannels = Read16BitsHighLow( file_ptr );             subSize -= 2;9F             aiff_ptr->numSampleFrames = Read32BitsHighLow( file_ptr );             subSize -= 4; A             aiff_ptr->sampleSize = Read16BitsHighLow( file_ptr );6             subSize -= 2;2H             aiff_ptr->sampleRate  = ReadIeeeExtendedHighLow( file_ptr );             subSize -= 10;!             while ( subSize > 0 )4 	    {!                 getc( file_ptr );.                 subSize -= 1;2 	    }             break;                        case IFF_ID_SSND:0A             chunkSize -= subSize = Read32BitsHighLow( file_ptr );5E             aiff_ptr->blkAlgn.offset = Read32BitsHighLow( file_ptr );0             subSize -= 4;0H             aiff_ptr->blkAlgn.blockSize = Read32BitsHighLow( file_ptr );             subSize -= 4;1J             sound_position = ftell( file_ptr ) + aiff_ptr->blkAlgn.offset;A             if ( fseek(file_ptr, (long) subSize, SEEK_CUR) != 0 ).                 return -1;/             aiff_ptr->sampleType = IFF_ID_SSND;0             break;                        default:A             chunkSize -= subSize = Read32BitsHighLow( file_ptr );3!             while ( subSize > 0 )5 	    {!                 getc( file_ptr );e                 subSize -= 1;* 	    }             break; 	}     }*     return sound_position; }   N /*****************************************************************************  *N  *  Seek past some Audio Interchange File Format (AIFF) headers to sound data.  *O  *****************************************************************************/n  - int aiff_seek_to_sound_data( FILE *file_ptr )a {8U 	if ( fseek(file_ptr, AIFF_FORM_HEADER_SIZE + AIFF_SSND_HEADER_SIZE, SEEK_SET) != 0 )E         return(-1);l     return(0); }   P /*******************************************************************************  *7  *  Write Audio Interchange File Format (AIFF) headers.   *Q  *******************************************************************************/n  < int aiff_write_headers( FILE *file_ptr, IFF_AIFF *aiff_ptr ) {v     int chunkSize;V     int sampleBytes = (aiff_ptr->sampleSize / 8) + (aiff_ptr->sampleSize % 8 ? 1 : 0);     -     if ( fseek(file_ptr, 0L, SEEK_SET) != 0 )          return -1;          /* write FORM chunk */]     chunkSize = 8 + 18 + 8 + aiff_ptr->numChannels * aiff_ptr->numSampleFrames * sampleBytes; 0     Write32BitsHighLow( file_ptr, IFF_ID_FORM );.     Write32BitsHighLow( file_ptr, chunkSize );0     Write32BitsHighLow( file_ptr, IFF_ID_AIFF );     /* write COMM chunk */0     Write32BitsHighLow( file_ptr, IFF_ID_COMM );8     Write32BitsHighLow( file_ptr, 18 ); /* chunk size */:     Write16BitsHighLow( file_ptr, aiff_ptr->numChannels );>     Write32BitsHighLow( file_ptr, aiff_ptr->numSampleFrames );9     Write16BitsHighLow( file_ptr, aiff_ptr->sampleSize );n?     WriteIeeeExtendedHighLow( file_ptr, aiff_ptr->sampleRate );e!     /* write SSND chunk header */,T     chunkSize = 8 + aiff_ptr->numChannels * aiff_ptr->numSampleFrames * sampleBytes;0     Write32BitsHighLow( file_ptr, IFF_ID_SSND );.     Write32BitsHighLow( file_ptr, chunkSize );3     Write32BitsHighLow( file_ptr, 0 ); /* offset */o7     Write32BitsHighLow( file_ptr, 0 ); /* block size */y
     return 0;  }   N /***************************************************************************** *b *  bit_stream.c package 5 *  Author:  Jean-Georges Fritsch, C-Cube Microsystems  *tN *****************************************************************************/  E /********************************************************************">   This package provides functions to write (exclusive or read)4   information from (exclusive or to) the bit stream.  E   If the bit stream is opened in read mode only the get functions are C   available. If the bit stream is opened in write mode only the put;   functions are available.E ********************************************************************/e  L /*open_bit_stream_w(); open the device to write the bit stream into it    */L /*open_bit_stream_r(); open the device to read the bit stream from it     */L /*close_bit_stream();  close the device containing the bit stream         */L /*alloc_buffer();      open and initialize the buffer;                    */L /*desalloc_buffer();   empty and close the buffer                         */L /*back_track_buffer();     goes back N bits in the buffer                 */L /*unsigned int get1bit();  read 1 bit from the bit stream                 */L /*unsigned long getbits(); read N bits from the bit stream                */N /*unsigned long byte_ali_getbits();   read the next byte aligned N bits from*/N /*                                    the bit stream                        */N /*unsigned long look_ahead(); grep the next N bits in the bit stream without*/N /*                            changing the buffer pointer                   */0 /*put1bit(); write 1 bit from the bit stream  */0 /*put1bit(); write 1 bit from the bit stream  */0 /*putbits(); write N bits from the bit stream */N /*byte_ali_putbits(); write byte aligned the next N bits into the bit stream*/N /*unsigned long sstell(); return the current bit stream length (in bits)    */N /*int end_bs(); return 1 if the end of bit stream reached otherwise 0       */N /*int seek_sync(); return 1 if a sync word was found in the bit stream      */N /*                 otherwise returns 0                                      */  N /* refill the buffer from the input device when the buffer becomes empty    */ int refill_buffer(bs)D2 Bit_stream_struc *bs;   /* bit stream structure */ {52    register int i=bs->buf_size-2-bs->buf_byte_idx;    register unsigned long n=1;    register int index=0;    char val[2];   !    while ((i>=0) && (!bs->eob)) {b         if (bs->format == BINARY) D          n = fread(&bs->buf[i--], sizeof(unsigned char), 1, bs->pt);         else {"          while((index < 2) && n) {<             n = fread(&val[index], sizeof(char), 1, bs->pt);!             switch (val[index]) {)                   case 0x30:                   case 0x31:                   case 0x32:                   case 0x33:                   case 0x34:                   case 0x35:                   case 0x36:                   case 0x37:                   case 0x38:                   case 0x39:                   case 0x41:                   case 0x42:                   case 0x43:                   case 0x44:                   case 0x45:                   case 0x46:                   index++;                   break;!                   default: break;e
             }l
          }  A          if (val[0] <= 0x39)   bs->buf[i] = (val[0] - 0x30) << 4;l9                  else  bs->buf[i] = (val[0] - 0x37) << 4;s?          if (val[1] <= 0x39)   bs->buf[i--] |= (val[1] - 0x30);e7                  else  bs->buf[i--] |= (val[1] - 0x37);M          index = 0;f       }y         if (!n) {p          bs->eob= i+1;       }        }     return 0; }   % static char *he = "0123456789ABCDEF";r  H /* empty the buffer to the output device when the buffer becomes full */ void empty_buffer(bs, minimum)2 Bit_stream_struc *bs;   /* bit stream structure */8 int minimum;            /* end of the buffer to empty */ {     register int i;   #if BS_FORMAT == BINARY (    for (i=bs->buf_size-1;i>=minimum;i--)<       fwrite(&bs->buf[i], sizeof(unsigned char), 1, bs->pt); #elser*    for (i=bs->buf_size-1;i>=minimum;i--) {        char val[2]; /        val[0] = he[((bs->buf[i] >> 4) & 0x0F)];n(        val[1] = he[(bs->buf[i] & 0x0F)];,        fwrite(val, sizeof(char), 2, bs->pt);    } #endif2 fflush(bs->pt); /* NEW SS to assist in debugging*/      for (i=minimum-1; i>=0; i--)m8        bs->buf[bs->buf_size - minimum + i] = bs->buf[i];  0    bs->buf_byte_idx = bs->buf_size -1 - minimum;    bs->buf_bit_idx = 8;l }1  5 /* open the device to write the bit stream into it */_, void open_bit_stream_w(bs, bs_filenam, size)2 Bit_stream_struc *bs;   /* bit stream structure */9 char *bs_filenam;       /* name of the bit stream file */e0 int size;               /* size of the buffer */ { 4    if ((bs->pt = fopen(bs_filenam, "wb")) == NULL) {7       printf("Could not create \"%s\".\n", bs_filenam);*       exit(1);    }    alloc_buffer(bs, size);    bs->buf_byte_idx = size-1;n    bs->buf_bit_idx=8;     bs->totbit=0;    bs->mode = WRITE_MODE;l    bs->eob = FALSE;i    bs->eobs = FALSE; }   4 /* open the device to read the bit stream from it */, void open_bit_stream_r(bs, bs_filenam, size)2 Bit_stream_struc *bs;   /* bit stream structure */9 char *bs_filenam;       /* name of the bit stream file */I0 int size;               /* size of the buffer */ {m    register unsigned long n;#    register unsigned char flag = 1;b    unsigned char val;   4    if ((bs->pt = fopen(bs_filenam, "rb")) == NULL) {5       printf("Could not find \"%s\".\n", bs_filenam);        exit(1);    }      do { 7      n = fread(&val, sizeof(unsigned char), 1, bs->pt);i      switch (val) {f       case 0x30:       case 0x31:       case 0x32:       case 0x33:       case 0x34:       case 0x35:       case 0x36:       case 0x37:       case 0x38:       case 0x39:       case 0x41:       case 0x42:       case 0x43:       case 0x44:       case 0x45:       case 0x46:       case 0xa:  /* \n */,       case 0xd:  /* cr */        case 0x1a:  /* sub */            break;  5       default: /* detection of an binary character */            flag--;            break;      }      } while (flag & n);      if (flag) {G       printf ("the bit stream file %s is an ASCII file\n", bs_filenam);[       bs->format = ASCII;     }	    else {;       bs->format = BINARY;G       printf ("the bit stream file %s is a BINARY file\n", bs_filenam);     }      fclose(bs->pt);  4    if ((bs->pt = fopen(bs_filenam, "rb")) == NULL) {5       printf("Could not find \"%s\".\n", bs_filenam);        exit(1);    }      alloc_buffer(bs, size);    bs->buf_byte_idx=0;    bs->buf_bit_idx=0;d    bs->totbit=0;    bs->mode = READ_MODE;    bs->eob = FALSE;     bs->eobs = FALSE; }h  C /*close the device containing the bit stream after a read process*/I void close_bit_stream_r(bs)S2 Bit_stream_struc *bs;   /* bit stream structure */ {n    fclose(bs->pt);    desalloc_buffer(bs);p }s  D /*close the device containing the bit stream after a write process*/ void close_bit_stream_w(bs)a2 Bit_stream_struc *bs;   /* bit stream structure */ {a&    empty_buffer(bs, bs->buf_byte_idx);    fclose(bs->pt);    desalloc_buffer(bs);  }   $ /*open and initialize the buffer; */ void alloc_buffer(bs, size)o2 Bit_stream_struc *bs;   /* bit stream structure */	 int size;  {lA    bs->buf = (unsigned char FAR *) mem_alloc(size*sizeof(unsigned                char), "buffer");'    bs->buf_size = size;  }    /*empty and close the buffer */r void desalloc_buffer(bs)2 Bit_stream_struc *bs;   /* bit stream structure */ {)    free(bs->buf);t }n  A int putmask[9]={0x0, 0x1, 0x3, 0x7, 0xf, 0x1f, 0x3f, 0x7f, 0xff};tG int clearmask[9]={0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 0x0};P  B void back_track_buffer(bs, N) /* goes back N bits in the buffer */2 Bit_stream_struc *bs;   /* bit stream structure */ int N; {n    int tmp = N - (N/8)*8;     register int i;      bs->totbit -= N;eI    for (i=bs->buf_byte_idx;i< bs->buf_byte_idx+N/8-1;i++) bs->buf[i] = 0;i    bs->buf_byte_idx += N/8; '    if ( (tmp + bs->buf_bit_idx) <= 8) {        bs->buf_bit_idx += tmp;     }	    else {        bs->buf_byte_idx ++;#       bs->buf_bit_idx += (tmp - 8);/    };    bs->buf[bs->buf_byte_idx] &= clearmask[bs->buf_bit_idx];g }r  9 int mask[8]={0x1, 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80};o  # /*read 1 bit from the bit stream */  unsigned int get1bit(bs)2 Bit_stream_struc *bs;   /* bit stream structure */ {-    unsigned int bit;    register int i;      bs->totbit++;      if (!bs->buf_bit_idx) {         bs->buf_bit_idx = 8;         bs->buf_byte_idx--;eK         if ((bs->buf_byte_idx < MINIMUM) || (bs->buf_byte_idx < bs->eob)) {               if (bs->eob)2                  bs->eobs = TRUE;              else {;2                 for (i=bs->buf_byte_idx; i>=0;i--)J                   bs->buf[bs->buf_size-1-bs->buf_byte_idx+i] = bs->buf[i];"                 refill_buffer(bs);2                 bs->buf_byte_idx = bs->buf_size-1;              }	         }     };    bit = bs->buf[bs->buf_byte_idx]&mask[bs->buf_bit_idx-1];*$    bit = bit >> (bs->buf_bit_idx-1);    bs->buf_bit_idx--;a    return(bit);f }*  $ /*write 1 bit from the bit stream */ void put1bit(bs, bit)*2 Bit_stream_struc *bs;   /* bit stream structure */: int bit;                /* bit to write into the buffer */ {d    bs->totbit++;  A    bs->buf[bs->buf_byte_idx] |= (bit&0x1) << (bs->buf_bit_idx-1);     bs->buf_bit_idx--;m    if (!bs->buf_bit_idx) {        bs->buf_bit_idx = 8;*        bs->buf_byte_idx--;         if (bs->buf_byte_idx < 0)$           empty_buffer(bs, MINIMUM);%        bs->buf[bs->buf_byte_idx] = 0;S    } }   7 /*look ahead for the next N bits from the bit stream */= unsigned long look_ahead(bs, N) 2 Bit_stream_struc *bs;   /* bit stream structure */H int N;                  /* number of bits to read from the bit stream */ {   unsigned long val=0;"  register int j = N;  register int k, tmp;t(  register int bit_idx = bs->buf_bit_idx;*  register int byte_idx = bs->buf_byte_idx;    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);    while (j > 0) {     if (!bit_idx) {*         bit_idx = 8;         byte_idx--;a     }o     k = MIN (j, bit_idx); -     tmp = bs->buf[byte_idx]&putmask[bit_idx];      tmp = tmp >> (bit_idx-k);      val |= tmp << (j-k);     bit_idx -= k;      j -= k;   }
  return(val);  }   # /*read N bit from the bit stream */* unsigned long getbits(bs, N)2 Bit_stream_struc *bs;   /* bit stream structure */H int N;                  /* number of bits to read from the bit stream */ {*  unsigned long val=0;*  register int i;  register int j = N;  register int k, tmp;r    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);    bs->totbit += N;t  while (j > 0) {    if (!bs->buf_bit_idx) {         bs->buf_bit_idx = 8;         bs->buf_byte_idx--;*K         if ((bs->buf_byte_idx < MINIMUM) || (bs->buf_byte_idx < bs->eob)) {i              if (bs->eob)s                  bs->eobs = TRUE;              else {*2                 for (i=bs->buf_byte_idx; i>=0;i--)K                    bs->buf[bs->buf_size-1-bs->buf_byte_idx+i] = bs->buf[i]; "                 refill_buffer(bs);2                 bs->buf_byte_idx = bs->buf_size-1;              }	         }C    }     k = MIN (j, bs->buf_bit_idx);<    tmp = bs->buf[bs->buf_byte_idx]&putmask[bs->buf_bit_idx];$    tmp = tmp >> (bs->buf_bit_idx-k);    val |= tmp << (j-k);m    bs->buf_bit_idx -= k;
    j -= k;  }
  return(val);  }l  % /*write N bits into the bit stream */* void putbits(bs, val, N)2 Bit_stream_struc *bs;   /* bit stream structure */: unsigned int val;       /* val to write into the buffer */3 int N;                  /* number of bits of val */* {,  register int j = N;  register int k, tmp;     if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);    bs->totbit += N;   while (j > 0) {    k = MIN(j, bs->buf_bit_idx);*    tmp = val >> (j-k);H    bs->buf[bs->buf_byte_idx] |= (tmp&putmask[k]) << (bs->buf_bit_idx-k);    bs->buf_bit_idx -= k;    if (!bs->buf_bit_idx) {        bs->buf_bit_idx = 8;*        bs->buf_byte_idx--;         if (bs->buf_byte_idx < 0)$           empty_buffer(bs, MINIMUM);%        bs->buf[bs->buf_byte_idx] = 0;     }
    j -= k;  } }_  2 /*write N bits byte aligned into the bit stream */! void byte_ali_putbits(bs, val, N)!2 Bit_stream_struc *bs;   /* bit stream structure */: unsigned int val;       /* val to write into the buffer */3 int N;                  /* number of bits of val */u {-"  unsigned long aligning, sstell();    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);  aligning = sstell(bs)%8;   if (aligning)6      putbits(bs, (unsigned int)0, (int)(8-aligning));     putbits(bs, val, N);  }   : /*read the next bute aligned N bits from the bit stream */% unsigned long byte_ali_getbits(bs, N) 2 Bit_stream_struc *bs;   /* bit stream structure */3 int N;                  /* number of bits of val */p {>"  unsigned long aligning, sstell();    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);  aligning = sstell(bs)%8;   if (aligning)#     getbits(bs, (int)(8-aligning));     return(getbits(bs, N)); }.  2 /*return the current bit stream length (in bits)*/ unsigned long sstell(bs)2 Bit_stream_struc *bs;   /* bit stream structure */ {i   return(bs->totbit);  }e  ' /*return the status of the bit stream*/s0 /* returns 1 if end of bit stream was reached */4 /* returns 0 if end of bit stream was not reached */ int end_bs(bs)2 Bit_stream_struc *bs;   /* bit stream structure */ {    return(bs->eobs);f }l  H /*this function seeks for a byte aligned sync word in the bit stream and5   places the bit stream pointer right after the sync.nJ   This function returns 1 if the sync was found otherwise it returns 0  */ int seek_sync(bs, sync, N)2 Bit_stream_struc *bs;   /* bit stream structure *// long sync;      /* sync word maximum 32 bits */ & int N;          /* sync word length */ {p, #if defined(MACINTOSH) && !defined(__powerc)  double pow(); #endif!  unsigned long aligning, stell();;  unsigned long val;*)  long maxi = (int)pow(2.0, (FLOAT)N) - 1;*     aligning = sstell(bs)%ALIGNING;  if (aligning)*     getbits(bs, (int)(ALIGNING-aligning));     val = getbits(bs, N);*1   while (((val&maxi) != sync) && (!end_bs(bs))) {*         val <<= ALIGNING;s%         val |= getbits(bs, ALIGNING);8   }     if (end_bs(bs)) return(0);D  else return(1); }EN /***************************************************************************** ** *  End of bit_stream.c package **N *****************************************************************************/  N /***************************************************************************** ** *  CRC error protection packagei *hN *****************************************************************************/  & void I_CRC_calc(fr_ps, bit_alloc, crc) frame_params *fr_ps;# unsigned int bit_alloc[2][SBLIMIT];l unsigned int *crc; {          int i, k;n$         layer *info = fr_ps->header;$         int stereo  = fr_ps->stereo;%         int jsbound = fr_ps->jsbound;m  :         *crc = 0xffff; /* changed from '0' 92-08-11 shn */0         update_CRC(info->bitrate_index, 4, crc);5         update_CRC(info->sampling_frequency, 2, crc); *         update_CRC(info->padding, 1, crc);,         update_CRC(info->extension, 1, crc);'         update_CRC(info->mode, 2, crc); +         update_CRC(info->mode_ext, 2, crc);r,         update_CRC(info->copyright, 1, crc);+         update_CRC(info->original, 1, crc);1+         update_CRC(info->emphasis, 2, crc);)           for (i=0;i<SBLIMIT;i++)i6                 for (k=0;k<((i<jsbound)?stereo:1);k++)<                         update_CRC(bit_alloc[k][i], 4, crc); }r  . void II_CRC_calc(fr_ps, bit_alloc, scfsi, crc) frame_params *fr_ps;6 unsigned int bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT]; unsigned int *crc; {L         int i, k;/$         layer *info = fr_ps->header;$         int stereo  = fr_ps->stereo;%         int sblimit = fr_ps->sblimit;*%         int jsbound = fr_ps->jsbound;*'         al_table *alloc = fr_ps->alloc;k  :         *crc = 0xffff; /* changed from '0' 92-08-11 shn */0         update_CRC(info->bitrate_index, 4, crc);5         update_CRC(info->sampling_frequency, 2, crc);**         update_CRC(info->padding, 1, crc);,         update_CRC(info->extension, 1, crc);'         update_CRC(info->mode, 2, crc);r+         update_CRC(info->mode_ext, 2, crc);t,         update_CRC(info->copyright, 1, crc);+         update_CRC(info->original, 1, crc);t+         update_CRC(info->emphasis, 2, crc);            for (i=0;i<sblimit;i++)*6                 for (k=0;k<((i<jsbound)?stereo:1);k++)N                         update_CRC(bit_alloc[k][i], (*alloc)[i][0].bits, crc);           for (i=0;i<sblimit;i++)h&                 for (k=0;k<stereo;k++),                         if (bit_alloc[k][i])@                                 update_CRC(scfsi[k][i], 2, crc); }n  " void update_CRC(data, length, crc)  unsigned int data, length, *crc; {y%         unsigned int  masking, carry;            masking = 1 << length;           while((masking >>= 1)){ &                 carry = *crc & 0x8000;                 *crc <<= 1;s/                 if (!carry ^ !(data & masking))(1                         *crc ^= CRC16_POLYNOMIAL;/	         }d         *crc &= 0xffff;  }e  N /***************************************************************************** * & *  End of CRC error protection package *dN *****************************************************************************/   #ifdef  MACINTOSHhN /***************************************************************************** *i! *  Set Macintosh file attributes.b *fN *****************************************************************************/e void set_mac_file_attr( char fileName[MAX_NAME_SIZE], short vRefNum, OSType creator, OSType fileType)u {t(     char pascal_fileName[MAX_NAME_SIZE];     FInfo fndrInfo;e     OSErr anErr;     long dirID = 0L;     /     CtoPstr(strcpy(pascal_fileName, fileName));sU     anErr = HGetFInfo(vRefNum, dirID, (ConstStr255Param) pascal_fileName, &fndrInfo);      if ( anErr != noErr )          return;f!     fndrInfo.fdCreator = creator;e     fndrInfo.fdType = fileType; U     anErr = HSetFInfo(vRefNum, dirID, (ConstStr255Param) pascal_fileName, &fndrInfo);r }s   #endif    & #if (defined  MS_DOS) || (defined VMS)K /* ------------------------------------------------------------------------(	 new_ext()!4 Puts a new extension name on a file name <filename>.( Removes the last extension name, if any. 1992-08-19, 1995-06-12 shnK ------------------------------------------------------------------------ */d void5 new_ext(char *filename, char *extname, char *newname)] {)   int found, dotpos;  "   /* First, strip the extension */#   dotpos=strlen(filename); found=0;    do   {      switch (filename[dotpos])a     {:        case '.' : found=1; break;       case '\\':       case '/' :!       case ':' : found=-1; break; 9       default  : dotpos--; if (dotpos<0) found=-1; break;      }e   } while (found==0); *   if (found==-1) strcpy(newname,filename);L   if (found== 1) { strncpy(newname,filename,dotpos); newname[dotpos]='\0'; }   strcat(newname,extname); }n #endif       #define BUFSIZE 40965 static unsigned long offset,totbit=0, buf_byte_idx=0; ! static unsigned int buf[BUFSIZE];)" static unsigned int buf_bit_idx=8;  2 /*return the current bit stream length (in bits)*/ unsigned long hsstell()l {    return(totbit);i }   G /* int putmask[9]={0x0, 0x1, 0x3, 0x7, 0xf, 0x1f, 0x3f, 0x7f, 0xff}; */) extern int putmask[9];  # /*read N bit from the bit stream */  unsigned long hgetbits(N) H int N;                  /* number of bits to read from the bit stream */ {y  unsigned long val=0;u  register int j = N;  register int k, tmp;d   /*  if (N > MAX_LENGTH)O      printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);d */
  totbit += N;m  while (j > 0) {    if (!buf_bit_idx) {         buf_bit_idx = 8;         buf_byte_idx++;u 	if (buf_byte_idx > offset)[. 	  { printf("Buffer overflow !!\n");exit(3); }    }    k = MIN (j, buf_bit_idx);8    tmp = buf[buf_byte_idx%BUFSIZE]&putmask[buf_bit_idx];     tmp = tmp >> (buf_bit_idx-k);    val |= tmp << (j-k);)    buf_bit_idx -= k;
    j -= k;  }
  return(val);} }e   unsigned int hget1bit()W {  return(hgetbits(1)); }   % /*write N bits into the bit stream */  void hputbuf(val, N): unsigned int val;       /* val to write into the buffer */3 int N;                  /* number of bits of val */  {o<   if (N != 8) { printf("Not Supported yet!!\n"); exit(-3); }   buf[offset % BUFSIZE] = val;   offset++;m }r   void rewindNbits( N )t int N; {     totbit -= N;     buf_bit_idx += N;    while( buf_bit_idx >= 8 )    {  buf_bit_idx -= 8;t       buf_byte_idx--;     } }=   void rewindNbytes( N ) int N; {     totbit -= N*8;     buf_byte_idx -= N;b }i