G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) H  * ISO 13818-3 MPEG-2 Audio Decoder - Lower Sampling Frequency Extension  *;  * $Id: musicout.c,v 1.2 1996/03/28 03:13:37 rowlands Exp $   *  * $Log: musicout.c,v $ .  * Revision 1.2  1996/03/28 03:13:37  rowlands*  * Merged layers 1-2 and layer 3 revisions  *.  * Revision 1.1  1996/02/14 03:45:52  rowlands  * Initial revision   *  * Received from FhGH  **********************************************************************/G /********************************************************************** G  *   date   programmers                comment                        * G  * 2/25/91  Douglas Wong        start of version 1.0 records          * G  * 3/06/91  Douglas Wong        rename setup.h to dedef.h             * G  *                              removed extraneous variables          * G  *                              removed window_samples (now part of   * G  *                              filter_samples)                       * G  * 3/07/91  Davis Pan           changed output file to "codmusic"     * G  * 5/10/91  Vish (PRISM)        Ported to Macintosh and Unix.         * G  *                              Incorporated new "out_fifo()" which   * G  *                              writes out last incomplete buffer.    * G  *                              Incorporated all AIFF routines which  * G  *                              are also compatible with SUN.         * G  *                              Incorporated user interface for       * G  *                              specifying sound file names.          * G  *                              Also incorporated user interface for  * G  *                              writing AIFF compatible sound files.  * G  * 27jun91  dpwe (Aware)        Added musicout and &sample_frames as  * G  *                              args to out_fifo (were glob refs).    * G  *                              Used new 'frame_params' struct.       * G  *                              Clean,simplify, track clipped output  * G  *                              and total bits/frame received.        * G  * 7/10/91  Earle Jennings      changed to floats to FLOAT            * G  *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           * G  *          Don H. Lee,                                               * G  *          Peter W. Farrett                                          * G  *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   * G  *                              newly introduced functions are        * G  *                              buffer_CRC and recover_CRC_error      * G  *                              Additions and revisions are marked    * G  *                              with "dhl" for clarity                * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  *19 aug 92 Soren H. Nielsen    Changed MS-DOS file name extensions.  * G  * 8/27/93 Seymour Shlien,      Fixes in Unix and MSDOS ports,        * G  *         Daniel Lauzon, and                                         * G  *         Bill Truerniet                                             * G  *--------------------------------------------------------------------* G  * 4/23/92  J. Pineda           Added code for layer III.  LayerIII   * G  *          Amit Gulati         decoding is currently performed in    * G  *                              two-passes for ease of sideinfo and   * G  *                              maindata buffering and decoding.      * G  *                              The second (computation) pass is      * G  *                              activated with "decode -3 <outfile>"  * G  * 10/25/92 Amit Gulati         Modified usage() for layerIII         * G  * 12/10/92 Amit Gulati         Changed processing order of re-order- * G  *                              -ing step.  Fixed adjustment of       * G  *                              main_data_end pointer to exclude      * G  *                              side information.                     * G  *  9/07/93 Toshiyuki Ishino    Integrated Layer III with Ver 3.9.    * G  *--------------------------------------------------------------------* G  * 11/20/93 Masahiro Iwadare    Integrated Layer III with Ver 4.0.    * G  *--------------------------------------------------------------------* G  *  7/14/94 Juergen Koller      Bug fixes in Layer III code           * G  *--------------------------------------------------------------------* G  * 08/11/94 IIS                 Bug fixes in Layer III code           * G  *--------------------------------------------------------------------* G  * 11/04/94 Jon Rowlands        Prototype fixes                       * G  *--------------------------------------------------------------------* G  *  7/12/95 Soeren H. Nielsen   Changes for LSF Layer I and II        * G  *--------------------------------------------------------------------* G  *  7/14/94 Juergen Koller      Bug fixes in Layer III code           * G  *--------------------------------------------------------------------* G  *     8/95 Roland Bitto        addapdet to MPEG 2                    * G  *--------------------------------------------------------------------* G  * 11/22/95 Heiko Purnhagen     skip ancillary data in bitstream      * H  **********************************************************************/   #include        "common.h" #include        "decoder.h"   E /********************************************************************  /*B /*        This part contains the MPEG I decoder for Layers I & II. /*G /*********************************************************************/   A /****************************************************************  /*A /*        For MS-DOS user (Turbo c) change all instance of malloc A /*        to _farmalloc and free to _farfree. Compiler model hugh F /*        Also make sure all the pointer specified are changed to far. /*C /*****************************************************************/   /* local functions definition */   static void usage(); static void GetArguments();      F /********************************************************************* /*< /* Core of the Layer II decoder.  Default layer is Layer II. /*G /*********************************************************************/   2 /* Global variable definitions for "musicout.c" */   char *programName; int main_data_slots(); int side_info_slots();   /* Implementations */    main(argc, argv)	 int argc;  char **argv; { % /*typedef short PCM[2][3][SBLIMIT];*/ ' typedef short PCM[2][SSLIMIT][SBLIMIT];      PCM FAR *pcm_sample;( typedef unsigned int SAM[2][3][SBLIMIT];     SAM FAR *sample;" typedef double FRA[2][3][SBLIMIT];     FRA FAR *fraction; typedef double VE[2][HAN_SIZE];      VE FAR *w;       Bit_stream_struc  bs;      frame_params      fr_ps;     layer             info;       FILE              *musicout;$     unsigned long     sample_frames;  ?     int               i, j, k, stereo, done=FALSE, clip, sync;  K     int               error_protection, crc_error_count, total_error_count; '     unsigned int      old_crc, new_crc; ?     unsigned int      bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT], 1                       scale_index[2][3][SBLIMIT]; A     unsigned long     bitsPerSlot, samplesPerFrame, frameNum = 0; -     unsigned long     frameBits, gotBits = 0; $     IFF_AIFF          pcm_aiff_data;      Arguments_t       Arguments;     int Max_gr;    III_scalefac_t III_scalefac; III_side_info_t III_side_info;   #ifdef  MACINTOSH*,     console_options.nrows = MAC_WINDOW_SIZE;     argc = ccommand(&argv);G #endif  >     /* Most large variables are declared dynamically to ensure-        compatibility with smaller machines *//  G     pcm_sample = (PCM FAR *) mem_alloc((long) sizeof(PCM), "PCM Samp");.A     sample = (SAM FAR *) mem_alloc((long) sizeof(SAM), "Sample");rE     fraction = (FRA FAR *) mem_alloc((long) sizeof(FRA), "fraction");l5     w = (VE FAR *) mem_alloc((long) sizeof(VE), "w");*       fr_ps.header = &info;*<     fr_ps.tab_num = -1;                /* no table loaded */     fr_ps.alloc = NULL;*@     for (i=0;i<HAN_SIZE;i++) for (j=0;j<2;j++) (*w)[j][i] = 0.0;       Arguments.topSb = 0;)     GetArguments(argc, argv, &Arguments);0I     if ((musicout = fopen(Arguments.decoded_file_name, "w+b")) == NULL) {eM           printf ("Could not create \"%s\".\n", Arguments.decoded_file_name);s           exit(1);	         } E     open_bit_stream_r(&bs, Arguments.encoded_file_name, BUFFER_SIZE);        if (Arguments.need_aiff)5        if (aiff_seek_to_sound_data(musicout) == -1) { A           printf("Could not seek to PCM sound data in \"%s\".\n",).                  Arguments.decoded_file_name);           exit(1);        }       sample_frames = 0;       while (!end_bs(&bs)) {  9        sync = seek_sync(&bs, SYNC_WORD, SYNC_WORD_LNGTH); )        frameBits = sstell(&bs) - gotBits;tL        if(frameNum > 0)        /* don't want to print on 1st loop; no lay */#           if(frameBits%bitsPerSlot) B              fprintf(stderr,"Got %ld bits = %ld slots plus %ld\n",N                      frameBits, frameBits/bitsPerSlot, frameBits%bitsPerSlot);        gotBits += frameBits;          if (!sync) {e.           printf("Frame cannot be located\n");0           printf("Input stream may be empty\n");           done = TRUE;,           /* finally write out the buffer */C           if (info.lay != 1) out_fifo(*pcm_sample, 3, &fr_ps, done, @                                       musicout, &sample_frames);C           else               out_fifo(*pcm_sample, 1, &fr_ps, done,t@                                       musicout, &sample_frames);           break;        }           decode_info(&bs, &fr_ps);        hdr_to_frps(&fr_ps);         stereo = fr_ps.stereo;d5        if(fr_ps.header->version == MPEG_PHASE2_LSF) {L
 		Max_gr = 1;         }        else 	        {  
 		Max_gr = 2;e        }  0        error_protection = info.error_protection;        crc_error_count = 0;         total_error_count = 0;tM        if(frameNum == 0) WriteHdr(&fr_ps, stdout);  /* printout layer/mode */    #ifdef ESPS + if (frameNum == 0 && Arguments.need_esps) {C: 	esps_write_header(musicout,(long) sample_frames, (double)7 		s_freq[info.version][info.sampling_frequency] * 1000, . 		(int) stereo, Arguments.decoded_file_name );
 } /* MI */ #endif  >        fprintf(stderr, "{%4lu}", frameNum++); fflush(stderr); 7        if (error_protection) buffer_CRC(&bs, &old_crc);           switch (info.lay) {             case 1: { <              bitsPerSlot = 32;        samplesPerFrame = 384;5              I_decode_bitalloc(&bs,bit_alloc,&fr_ps); A              I_decode_scale(&bs, bit_alloc, scale_index, &fr_ps);   $              if (error_protection) {8                 I_CRC_calc(&fr_ps, bit_alloc, &new_crc);)                 if (new_crc != old_crc) { %                    crc_error_count++;t'                    total_error_count++; B                    recover_CRC_error(*pcm_sample, crc_error_count,G                                      &fr_ps, musicout, &sample_frames);S                    break;n                 }t)                 else crc_error_count = 0;               }                clip = 0;*              for (i=0;i<SCALE_BLOCK;i++) {@                 I_buffer_sample(&bs,(*sample),bit_alloc,&fr_ps);H                 I_dequantize_sample(*sample,*fraction,bit_alloc,&fr_ps);E                 I_denormalize_sample((*fraction),scale_index,&fr_ps);   F                 if(Arguments.topSb>0)        /* clear channels to 0 */?                    for(j=Arguments.topSb; j<fr_ps.sblimit; ++j) -                       for(k=0; k<stereo; ++k) 2                          (*fraction)[k][0][j] = 0;  (                 for (j=0;j<stereo;j++) {H                    clip += SubBandSynthesis (&((*fraction)[j][0][0]), j,H                                              &((*pcm_sample)[j][0][0]));                 } 6                 out_fifo(*pcm_sample, 1, &fr_ps, done,3                          musicout, &sample_frames);*              }F              if(clip > 0) printf("%d output samples clipped\n", clip);              break;i           }              case 2: {*<              bitsPerSlot = 8;        samplesPerFrame = 1152;8              II_decode_bitalloc(&bs, bit_alloc, &fr_ps);I              II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps);I  %              if (error_protection) { -@                 II_CRC_calc(&fr_ps, bit_alloc, scfsi, &new_crc);)                 if (new_crc != old_crc) {I%                    crc_error_count++;-'                    total_error_count++;-B                    recover_CRC_error(*pcm_sample, crc_error_count,G                                      &fr_ps, musicout, &sample_frames);-                    break;9                 } )                 else crc_error_count = 0;               }                clip = 0;*              for (i=0;i<SCALE_BLOCK;i++) {A                 II_buffer_sample(&bs,(*sample),bit_alloc,&fr_ps);-M                 II_dequantize_sample((*sample),bit_alloc,(*fraction),&fr_ps); K                 II_denormalize_sample((*fraction),scale_index,&fr_ps,i>>2);-  N                 if(Arguments.topSb>0)        /* debug : clear channels to 0 */?                    for(j=Arguments.topSb; j<fr_ps.sblimit; ++j)--                       for(k=0; k<stereo; ++k)-/                          (*fraction)[k][0][j] =c/                          (*fraction)[k][1][j] =*2                          (*fraction)[k][2][j] = 0;  :                 for (j=0;j<3;j++) for (k=0;k<stereo;k++) {H                    clip += SubBandSynthesis (&((*fraction)[k][j][0]), k,H                                              &((*pcm_sample)[k][j][0]));                 }*@                 out_fifo(*pcm_sample, 3, &fr_ps, done, musicout,)                          &sample_frames);*              }?              if(clip > 0) printf("%d samples clipped\n", clip);f              break;o           }n             case 3: {p              int nSlots;<              int gr, ch, ss, sb, main_data_end, flush_main ; 	     int  bytes_to_discard ;*! 	     static int frame_start = 0;*  %              bitsPerSlot = 8;         9              if(fr_ps.header->version == MPEG_PHASE2_LSF)  		samplesPerFrame = 576;
 	     else 		samplesPerFrame = 1152;*  *<              III_get_side_info(&bs, &III_side_info, &fr_ps);-              nSlots = main_data_slots(fr_ps);*@              for (; nSlots > 0; nSlots--)  /* read main data. */:                 hputbuf((unsigned int) getbits(&bs,8), 8);: 	     main_data_end = hsstell() / 8; /*of privious frame*/;              if ( flush_main=(hsstell() % bitsPerSlot) ) { h:                 hgetbits((int)(bitsPerSlot - flush_main)); 		main_data_end ++;  	     }l;              bytes_to_discard = frame_start - main_data_endm1  			            - III_side_info.main_data_begin ;A'              if( main_data_end > 4096 )Z%              {   frame_start -= 4096;s&                  rewindNbytes( 4096 );              }  3              frame_start += main_data_slots(fr_ps);n(              if (bytes_to_discard < 0) {P          printf("Not enough main data to decode frame %d.  Frame discarded.\n", -                         frameNum - 1); break;u              }J              for (; bytes_to_discard > 0; bytes_to_discard--) hgetbits(8);                clip = 0;(              for (gr=0;gr<Max_gr;gr++) {F                double lr[2][SBLIMIT][SSLIMIT],ro[2][SBLIMIT][SSLIMIT];  ,                for (ch=0; ch<stereo; ch++) {J                  long int is[SBLIMIT][SSLIMIT];   /* Quantized samples. */!                  int part2_start;I)                  part2_start = hsstell(); =                  if(fr_ps.header->version != MPEG_PHASE2_LSF)Z                  {M                     III_get_scale_factors(&III_scalefac,&III_side_info,gr,ch,  			   &fr_ps);                  }                  else                   {<                     III_get_LSF_scale_factors(&III_scalefac,C                                                     &III_side_info,nB                                                     gr,ch,&fr_ps);                  }K                  III_hufman_decode(is, &III_side_info, ch, gr, part2_start, +                                    &fr_ps); A                  III_dequantize_sample(is, ro[ch], &III_scalefac,)O                                    &(III_side_info.ch[ch].gr[gr]), ch, &fr_ps);u                }.                III_stereo(ro,lr,&III_scalefac,C                             &(III_side_info.ch[0].gr[gr]), &fr_ps);r  ,                for (ch=0; ch<stereo; ch++) {0                     double re[SBLIMIT][SSLIMIT];O                     double hybridIn[SBLIMIT][SSLIMIT];/* Hybrid filter input */fN                     double hybridOut[SBLIMIT][SSLIMIT];/* Hybrid filter out */K                     double polyPhaseIn[SBLIMIT];     /* PolyPhase Input. */   J                     III_reorder (lr[ch],re,&(III_side_info.ch[ch].gr[gr]),*                                   &fr_ps);  L                     III_antialias(re, hybridIn, /* Antialias butterflies. */J                                   &(III_side_info.ch[ch].gr[gr]), &fr_ps);  J                     for (sb=0; sb<SBLIMIT; sb++) { /* Hybrid synthesis. */G                         III_hybrid(hybridIn[sb], hybridOut[sb], sb, ch,,K                                    &(III_side_info.ch[ch].gr[gr]), &fr_ps);e                     }m  P                     for (ss=0;ss<18;ss++) /*Frequency inversion for polyphase.*/3                        for (sb=0; sb<SBLIMIT; sb++)f/                           if ((ss%2) && (sb%2))mD                              hybridOut[sb][ss] = -hybridOut[sb][ss];  E                     for (ss=0;ss<18;ss++) { /* Polyphase synthesis */,4                         for (sb=0; sb<SBLIMIT; sb++)@                             polyPhaseIn[sb] = hybridOut[sb][ss];B                         clip += SubBandSynthesis (polyPhaseIn, ch,O                                                   &((*pcm_sample)[ch][ss][0]));	                         }                      }	?                 /* Output PCM sample points for one granule. */oA                 out_fifo(*pcm_sample, 18, &fr_ps, done, musicout,0)                          &sample_frames);s              }@              if(clip > 0) printf("%d samples clipped.\n", clip);              break;e           }d        }  ( /* skip ancillary data   HP 22-nov-95 */=        if (info.bitrate_index > 0) { /* if not free-format */  		long anc_len;_  + 		anc_len = (int)((double)samplesPerFrame /n9 			       s_freq[info.version][info.sampling_frequency] *iI 			       (double)bitrate[info.version][info.lay-1][info.bitrate_index] /) 			       (double)bitsPerSlot);  		if (info.padding)3
 			anc_len++;e 		anc_len *= bitsPerSlot; 1 		anc_len -= sstell(&bs)-gotBits+SYNC_WORD_LNGTH;  		for (j=0; j<anc_len; j++)t 			get1bit(&bs); 	}     }        if (Arguments.need_aiff) {0        pcm_aiff_data.numChannels       = stereo;7        pcm_aiff_data.numSampleFrames   = sample_frames; ,        pcm_aiff_data.sampleSize        = 16;\        pcm_aiff_data.sampleRate        = s_freq[info.version][info.sampling_frequency]*1000;5        pcm_aiff_data.sampleType        = IFF_ID_SSND;,+        pcm_aiff_data.blkAlgn.offset    = 0; +        pcm_aiff_data.blkAlgn.blockSize = 0;   @        if (aiff_write_headers(musicout, &pcm_aiff_data) == -1) {<           printf("Could not write AIFF headers to \"%s\"\n",.                  Arguments.decoded_file_name);           exit(2);        }     }l  D     printf("Avg slots/frame = %.3f; b/smp = %.2f; br = %.3f kbps\n",6            (FLOAT) gotBits / (frameNum * bitsPerSlot),:            (FLOAT) gotBits / (frameNum * samplesPerFrame),;            (FLOAT) gotBits / (frameNum * samplesPerFrame) * :            s_freq[info.version][info.sampling_frequency]);       close_bit_stream_r(&bs);     fclose(musicout);   1     /* for the correct AIFF header information */ 1     /*             on the Macintosh            */ 1     /* the file type and the file creator for  */s1     /* Macintosh compatible Digidesign is set  */    #ifdef  MACINTOSHp     if (Arguments.need_aiff)= 		set_mac_file_attr(Arguments.decoded_file_name, VOL_REF_NUM, G                                      CREATR_DEC_AIFF, FILTYP_DEC_AIFF); D     else	set_mac_file_attr(Arguments.decoded_file_name, VOL_REF_NUM,G                                      CREATR_DEC_BNRY, FILTYP_DEC_BNRY);t #endif  L     printf("Decoding of \"%s\" is finished\n", Arguments.encoded_file_name);X     printf("The decoded PCM output file name is \"%s\"\n", Arguments.decoded_file_name);     if (Arguments.need_aiff)G        printf("\"%s\" has been written with AIFF header information\n",c+               Arguments.decoded_file_name);r       exit( 0 ); }   . static void usage()  /* print syntax & exit */ {o    fprintf(stderr,J       "usage: %s                         queries for all arguments, or\n",        programName);    fprintf(stderr,?       "       %s [-A][-s sb] inputBS [outPCM]\n", programName);c    fprintf(stderr,"where\n");;E    fprintf(stderr," -A       write an AIFF output PCM sound file\n");tM    fprintf(stderr," -s sb    resynth only up to this sb (debugging only)\n");aC    fprintf(stderr," inputBS  input bit stream of encoded audio\n");cG    fprintf(stderr," outPCM   output PCM sound file (dflt inName+%s)\n",/            DFLT_OPEXT);t    exit(1);  }     / static void GetArguments(argc, argv,Arguments) -
     int argc;      char **argv;     Arguments_t *Arguments;    {      char              t[50];       programName = argv[0];?     if(argc==1) {        /* no command line args -> interact */         do { :           printf ("Enter encoded file name <required>: ");.           gets (Arguments->encoded_file_name);;           if (Arguments->encoded_file_name[0] == NULL_CHAR) :              printf ("Encoded file name is required. \n");>        } while (Arguments->encoded_file_name[0] == NULL_CHAR);P        printf (">>> Encoded file name is: %s \n", Arguments->encoded_file_name); #ifdef  MS_DOS5        printf ("Enter MPEG decoded file name <%s>: ",nU                new_ext(Arguments->encoded_file_name, DFLT_OPEXT)); /* 92-08-19 shn */i #elsee7        printf ("Enter MPEG decoded file name <%s%s>: ",tB                                      Arguments->encoded_file_name,1                                      DFLT_OPEXT);S #endif+        gets (Arguments->decoded_file_name);p:        if (Arguments->decoded_file_name[0] == NULL_CHAR) { #ifdef  MS_DOSA            /* replace old extension with new one, 92-08-19 shn */ /            strcpy(Arguments->decoded_file_name,aK                         new_ext(Arguments->encoded_file_name, DFLT_OPEXT));n #elsen8            strcat (strcpy(Arguments->decoded_file_name, J                                Arguments->encoded_file_name), DFLT_OPEXT); #endif        }7        printf (">>> MPEG decoded file name is: %s \n", bF                                         Arguments->decoded_file_name);          printf(M           "Do you wish to write an AIFF compatible sound file ? (y/<n>) : ");t        gets(t); ?        if (*t == 'y' || *t == 'Y') Arguments->need_aiff = TRUE;f@        else                        Arguments->need_aiff = FALSE;         if (Arguments->need_aiff)J             printf(">>> An AIFF compatible sound file will be written\n");J        else printf(">>> A non-headered PCM sound file will be written\n");          printf(L           "Do you wish to exit (last chance before decoding) ? (y/<n>) : ");        gets(t);++        if (*t == 'y' || *t == 'Y') exit(0);L     }o)     else {        /* interpret CL Args */r        int i=0, err=0;  $        Arguments->need_aiff = FALSE;-        Arguments->need_esps = FALSE;	/* MI */ .        Arguments->encoded_file_name[0] = '\0';.        Arguments->decoded_file_name[0] = '\0';  $        while(++i<argc && err == 0) {)           char c, *token, *arg, *nextArg;_           int  argUsed;a             token = argv[i];           if(*token++ == '-') {}0              if(i+1 < argc) nextArg = argv[i+1];)              else           nextArg = "";I              argUsed = 0; "              while(c = *token++) {=                 if(*token /* NumericQ(token) */) arg = token; ?                 else                             arg = nextArg;h                 switch(c) {fH                    case 's':  Arguments->topSb = atoi(arg); argUsed = 1;J                       if(Arguments->topSb<1 || Arguments->topSb>SBLIMIT) {G                          fprintf(stderr, "%s: -s band %s not %d..%d\n", ?                                  programName, arg, 1, SBLIMIT); !                          err = 1;e                       }p                       break;A                    case 'A':  Arguments->need_aiff = TRUE; break;MJ                    case 'E':  Arguments->need_esps = TRUE; break;	/* MI */L                    default:   fprintf(stderr,"%s: unrecognized option %c\n",6                                       programName, c);%                       err = 1; break;                  }I                 if(argUsed) {_H                    if(arg == token) token = ""; /* no more from token */?                    else             ++i; /* skip arg we used */s)                    arg = ""; argUsed = 0;I                 }g              }           }            else {8              if(Arguments->encoded_file_name[0] == '\0')>                 strcpy(Arguments->encoded_file_name, argv[i]);              else ;                 if(Arguments->decoded_file_name[0] == '\0') A                    strcpy(Arguments->decoded_file_name, argv[i]);r                 else {"                    fprintf(stderr,H                            "%s: excess arg %s\n", programName, argv[i]);                    err = 1;                  }s           }u        }  W        if(err || Arguments->encoded_file_name[0] == '\0') usage();  /* never returns */   4        if(Arguments->decoded_file_name[0] == '\0') {M           strcpy(Arguments->decoded_file_name, Arguments->encoded_file_name); ;           strcat(Arguments->decoded_file_name, DFLT_OPEXT);         }       } 1     /* report results of dialog / command line */ 5     printf("Input file = '%s'  output file = '%s'\n",OG            Arguments->encoded_file_name, Arguments->decoded_file_name);cL     if(Arguments->need_aiff) printf("Output file written in AIFF format\n");U     if(Arguments->need_esps) printf("Output file written in ESPS format\n"); /* MI */  } 