 #ifndef IEEE_FLOAT_H__ #define IEEE_FLOAT_H__/ /* Copyright (C) 1988-1991 Apple Computer, Inc.   * All Rights Reserved.   *  * Warranty Information H  * Even though Apple has reviewed this software, Apple makes no warrantyE  * or representation, either express or implied, with respect to this F  * software, its quality, accuracy, merchantability, or fitness for a G  * particular purpose.  As a result, this software is provided "as is," D  * and you, its user, are assuming the entire risk as to its quality  * and accuracy.  *F  * This code may be used and freely distributed as long as it includes6  * this copyright notice and the warranty information.  *D  * Machine-independent I/O routines for IEEE floating-point numbers.  *@  * NaN's and infinities are converted to HUGE_VAL or HUGE, whichA  * happens to be infinity on IEEE machines.  Unfortunately, it is =  * impossible to preserve NaN's in a machine-independent way. 7  * Infinities are, however, preserved on IEEE machines.   *=  * These routines have been tested on the following machines: &  *	Apple Macintosh, MPW 3.1 C compiler$  *	Apple Macintosh, THINK C compiler'  *	Silicon Graphics IRIS, MIPS compiler   *	Cray X/MP and Y/MP   *	Digital Equipment VAX&  *	Sequent Balance (Multiprocesor 386)  *	NeXT   *  *3  * Implemented by Malcolm Slaney and Ken Turkowski.   *I  * Malcolm Slaney contributions during 1988-1990 include big- and little- E  * endian file I/O, conversion to and from Motorola's extended 80-bit B  * floating-point format, and conversions to and from IEEE single-#  * precision floating-point format.   *A  * In 1991, Ken Turkowski implemented the conversions to and from E  * IEEE double-precision format, added more precision to the extended D  * conversions, and accommodated conversions involving +/- infinity,#  * NaN's, and denormalized numbers.   *;  * $Id: ieeefloat.h,v 1.1 1993/06/11 17:45:46 malcolm Exp $   *  * $Log: ieeefloat.h,v $.  * Revision 1.1  1993/06/11  17:45:46  malcolm  * Initial revision   *  */    #include	<math.h>    typedef float Single;    #ifndef applec  typedef double defdouble; #else /* !applec */   typedef long double defdouble;  #endif /* applec */    #ifndef THINK_C   typedef double Double;  #else /* THINK_C */   typedef short double Double;  #endif /* THINK_C */   #define	kFloatLength	4 #define	kDoubleLength	8  #define	kExtendedLength	10  4 extern defdouble ConvertFromIeeeSingle(char *bytes);< extern void ConvertToIeeeSingle(defdouble num, char *bytes);4 extern defdouble ConvertFromIeeeDouble(char *bytes);< extern void ConvertToIeeeDouble(defdouble num, char *bytes);6 extern defdouble ConvertFromIeeeExtended(char *bytes);> extern void ConvertToIeeeExtended(defdouble num, char *bytes); #endif