/ /* Copyright (C) 1988-1991 Apple Computer, Inc.   * All Rights Reserved.   *  * Warranty Information H  * Even though Apple has reviewed this software, Apple makes no warrantyE  * or representation, either express or implied, with respect to this F  * software, its quality, accuracy, merchantability, or fitness for a G  * particular purpose.  As a result, this software is provided "as is," D  * and you, its user, are assuming the entire risk as to its quality  * and accuracy.  *F  * This code may be used and freely distributed as long as it includes6  * this copyright notice and the warranty information.  *D  * Machine-independent I/O routines for IEEE floating-point numbers.  *@  * NaN's and infinities are converted to HUGE_VAL or HUGE, whichA  * happens to be infinity on IEEE machines.  Unfortunately, it is =  * impossible to preserve NaN's in a machine-independent way. 7  * Infinities are, however, preserved on IEEE machines.   *=  * These routines have been tested on the following machines: &  *	Apple Macintosh, MPW 3.1 C compiler$  *	Apple Macintosh, THINK C compiler'  *	Silicon Graphics IRIS, MIPS compiler   *	Cray X/MP and Y/MP   *	Digital Equipment VAX&  *	Sequent Balance (Multiprocesor 386)  *	NeXT   *  *3  * Implemented by Malcolm Slaney and Ken Turkowski.   *I  * Malcolm Slaney contributions during 1988-1990 include big- and little- E  * endian file I/O, conversion to and from Motorola's extended 80-bit B  * floating-point format, and conversions to and from IEEE single-#  * precision floating-point format.   *A  * In 1991, Ken Turkowski implemented the conversions to and from E  * IEEE double-precision format, added more precision to the extended D  * conversions, and accommodated conversions involving +/- infinity,#  * NaN's, and denormalized numbers.   *;  * $Id: ieeefloat.c,v 1.1 1993/06/11 17:45:46 malcolm Exp $   *  * $Log: ieeefloat.c,v $.  * Revision 1.1  1993/06/11  17:45:46  malcolm  * Initial revision   *  */    #include	<stdio.h> #include	<math.h>  #include	"ieeefloat.h"    A /**************************************************************** >  * The following two routines make up for deficiencies in many>  * compilers to convert properly between unsigned integers and>  * floating-point.  Some compilers which have this bug are the@  * THINK_C compiler for the Macintosh and the C compiler for the$  * Silicon Graphics MIPS-based Iris.B  ****************************************************************/  . #ifdef applec	/* The Apple C compiler works */0 # define FloatToUnsigned(f)	((unsigned long)(f)), # define UnsignedToFloat(u)	((defdouble)(u)) #else /* applec */] # define FloatToUnsigned(f)	((unsigned long)(((long)((f) - 2147483648.0)) + 2147483647L + 1)) Y # define UnsignedToFloat(u)	(((defdouble)((long)((u) - 2147483647L - 1))) + 2147483648.0)  #endif /* applec */     A /**************************************************************** ;  * Single precision IEEE floating-point conversion routines B  ****************************************************************/   #define SEXP_MAX		255  #define SEXP_OFFSET		127 #define SEXP_SIZE		8& #define SEXP_POSITION	(32-SEXP_SIZE-1)    	 defdouble  ConvertFromIeeeSingle(bytes) char* bytes; { 
 	defdouble	f;  	long	mantissa, expon; 	long	bits;   0 	bits =	((unsigned long)(bytes[0] & 0xFF) << 24), 		|	((unsigned long)(bytes[1] & 0xFF) << 16)+ 		|	((unsigned long)(bytes[2] & 0xFF) << 8) H 		|	 (unsigned long)(bytes[3] & 0xFF);		/* Assemble bytes into a long */    	if ((bits & 0x7FFFFFFF) == 0) { 		f = 0; 	}   	else { / 		expon = (bits & 0x7F800000) >> SEXP_POSITION; 1 		if (expon == SEXP_MAX) {		/* Infinity or NaN */ - 			f = HUGE_VAL;		/* Map NaN's to infinity */  		}  		else {. 			if (expon == 0) {	/* Denormalized number */! 				mantissa = (bits & 0x7fffff); L 				f = ldexp((defdouble)mantissa, expon - SEXP_OFFSET - SEXP_POSITION + 1); 			}$ 			else {				/* Normalized number */D 				mantissa = (bits & 0x7fffff) + 0x800000;	/* Insert hidden bit */H 				f = ldexp((defdouble)mantissa, expon - SEXP_OFFSET - SEXP_POSITION); 			} 		}  	}   	if (bits & 0x80000000)  		return -f; 	else  		return f;  }     B /****************************************************************/     void ConvertToIeeeSingle(num, bytes)  defdouble num; char* bytes; {  	long	sign;  	register long bits;  7 	if (num < 0) {	/* Can't distinguish a negative zero */  		sign = 0x80000000; 		num *= -1;	 	} else {  		sign = 0;  	}   	if (num == 0) { 		bits = 0;  	}   	else {  		defdouble fMant; 		int expon;   		fMant = frexp(num, &expon);   ; 		if ((expon > (SEXP_MAX-SEXP_OFFSET+1)) || !(fMant < 1)) { . 			/* NaN's and infinities fail second test */0 			bits = sign | 0x7F800000;		/* +/- infinity */ 		}    		else { 			long mantissa;   @ 			if (expon < -(SEXP_OFFSET-2)) {	/* Smaller than normalized */< 				int shift = (SEXP_POSITION+1) + (SEXP_OFFSET-2) + expon;7 				if (shift < 0) {	/* Way too small: flush to zero */  					bits = sign;  				} . 				else {			/* Nonzero denormalized number */. 					mantissa = (long)(fMant * (1L << shift)); 					bits = sign | mantissa; 				}  			}  $ 			else {				/* Normalized number */> 				mantissa = (long)floor(fMant * (1L << (SEXP_POSITION+1)));7 				mantissa -= (1L << SEXP_POSITION);			/* Hide MSB */ R 				bits = sign | ((long)((expon + SEXP_OFFSET - 1)) << SEXP_POSITION) | mantissa; 			} 		}  	}  1 	bytes[0] = bits >> 24;	/* Copy to byte string */  	bytes[1] = bits >> 16;  	bytes[2] = bits >> 8; 	bytes[3] = bits;  }     A /**************************************************************** ;  * Double precision IEEE floating-point conversion routines B  ****************************************************************/   #define DEXP_MAX		2047 #define DEXP_OFFSET		1023  #define DEXP_SIZE		11 & #define DEXP_POSITION	(32-DEXP_SIZE-1)    	 defdouble  ConvertFromIeeeDouble(bytes) char* bytes; { 
 	defdouble	f;  	long	mantissa, expon; 	unsigned long first, second;   1 	first = ((unsigned long)(bytes[0] & 0xFF) << 24) , 		|	((unsigned long)(bytes[1] & 0xFF) << 16)+ 		|	((unsigned long)(bytes[2] & 0xFF) << 8) & 		|	 (unsigned long)(bytes[3] & 0xFF);1 	second= ((unsigned long)(bytes[4] & 0xFF) << 24) , 		|	((unsigned long)(bytes[5] & 0xFF) << 16)+ 		|	((unsigned long)(bytes[6] & 0xFF) << 8) & 		|	 (unsigned long)(bytes[7] & 0xFF); 	 ! 	if (first == 0 && second == 0) {  		f = 0; 	}   	else { 0 		expon = (first & 0x7FF00000) >> DEXP_POSITION;1 		if (expon == DEXP_MAX) {		/* Infinity or NaN */ - 			f = HUGE_VAL;		/* Map NaN's to infinity */  		}  		else {. 			if (expon == 0) {	/* Denormalized number */$ 				mantissa = (first & 0x000FFFFF);L 				f = ldexp((defdouble)mantissa, expon - DEXP_OFFSET - DEXP_POSITION + 1);V 				f += ldexp(UnsignedToFloat(second), expon - DEXP_OFFSET - DEXP_POSITION + 1 - 32); 			}$ 			else {				/* Normalized number */I 				mantissa = (first & 0x000FFFFF) + 0x00100000;	/* Insert hidden bit */ H 				f = ldexp((defdouble)mantissa, expon - DEXP_OFFSET - DEXP_POSITION);R 				f += ldexp(UnsignedToFloat(second), expon - DEXP_OFFSET - DEXP_POSITION - 32); 			} 		}  	}   	if (first & 0x80000000) 		return -f; 	else  		return f;  }     B /****************************************************************/     void ConvertToIeeeDouble(num, bytes)  defdouble num; char *bytes; {  	long	sign;  	long	first, second;  7 	if (num < 0) {	/* Can't distinguish a negative zero */  		sign = 0x80000000; 		num *= -1;	 	} else {  		sign = 0;  	}   	if (num == 0) { 		first = 0;
 		second = 0;  	}   	else {  		defdouble fMant, fsMant; 		int expon;   		fMant = frexp(num, &expon);   ; 		if ((expon > (DEXP_MAX-DEXP_OFFSET+1)) || !(fMant < 1)) { . 			/* NaN's and infinities fail second test */1 			first = sign | 0x7FF00000;		/* +/- infinity */  			second = 0; 		}    		else { 			long mantissa;   @ 			if (expon < -(DEXP_OFFSET-2)) {	/* Smaller than normalized */< 				int shift = (DEXP_POSITION+1) + (DEXP_OFFSET-2) + expon;A 				if (shift < 0) {	/* Too small for something in the MS word */  					first = sign; 					shift += 32; 8 					if (shift < 0) {	/* Way too small: flush to zero */ 						second = 0;- 					}' 					else {			/* Pretty small demorn */d; 						second = FloatToUnsigned(floor(ldexp(fMant, shift)));v 					} 				}w. 				else {			/* Nonzero denormalized number */" 					fsMant = ldexp(fMant, shift);$ 					mantissa = (long)floor(fsMant); 					first = sign | mantissa;,C 					second = FloatToUnsigned(floor(ldexp(fsMant - mantissa, 32)));e 				}v 			}  $ 			else {				/* Normalized number */+ 				fsMant = ldexp(fMant, DEXP_POSITION+1);d# 				mantissa = (long)floor(fsMant);s7 				mantissa -= (1L << DEXP_POSITION);			/* Hide MSB */ $ 				fsMant -= (1L << DEXP_POSITION);S 				first = sign | ((long)((expon + DEXP_OFFSET - 1)) << DEXP_POSITION) | mantissa;*B 				second = FloatToUnsigned(floor(ldexp(fsMant - mantissa, 32))); 			} 		}t 	} 	f 	bytes[0] = first >> 24; 	bytes[1] = first >> 16; 	bytes[2] = first >> 8;' 	bytes[3] = first; 	bytes[4] = second >> 24;  	bytes[5] = second >> 16;I 	bytes[6] = second >> 8; 	bytes[7] = second;  }t    A /**************************************************************** =  * Extended precision IEEE floating-point conversion routines B  ****************************************************************/  	 defdoublen ConvertFromIeeeExtended(bytes) char* bytes; {e
 	defdouble	f;l 	long	expon; 	unsigned long hiMant, loMant;   #ifdef	TEST	K printf("ConvertFromIEEEExtended(%lx,%lx,%lx,%lx,%lx,%lx,%lx,%lx,%lx,%lx\r",nA 	(long)bytes[0], (long)bytes[1], (long)bytes[2], (long)bytes[3],  1 	(long)bytes[4], (long)bytes[5], (long)bytes[6], i1 	(long)bytes[7], (long)bytes[8], (long)bytes[9]);k #endif 	m6 	expon = ((bytes[0] & 0x7F) << 8) | (bytes[1] & 0xFF);2 	hiMant	=	((unsigned long)(bytes[2] & 0xFF) << 24)- 			|	((unsigned long)(bytes[3] & 0xFF) << 16)v, 			|	((unsigned long)(bytes[4] & 0xFF) << 8)( 			|	((unsigned long)(bytes[5] & 0xFF));2 	loMant	=	((unsigned long)(bytes[6] & 0xFF) << 24)- 			|	((unsigned long)(bytes[7] & 0xFF) << 16):, 			|	((unsigned long)(bytes[8] & 0xFF) << 8)( 			|	((unsigned long)(bytes[9] & 0xFF));  0 	if (expon == 0 && hiMant == 0 && loMant == 0) { 		f = 0; 	} 	else {*. 		if (expon == 0x7FFF) {	/* Infinity or NaN */ 			f = HUGE_VAL; 		}n 		else { 			expon -= 16383;2 			f  = ldexp(UnsignedToFloat(hiMant), expon-=31);2 			f += ldexp(UnsignedToFloat(loMant), expon-=32); 		}e 	}   	if (bytes[0] & 0x80)  		return -f; 	elseo 		return f;e }*    B /****************************************************************/     void! ConvertToIeeeExtended(num, bytes)e defdouble num; char *bytes; {/
 	int	sign; 	int expon;d 	defdouble fMant, fsMant;  	unsigned long hiMant, loMant;   	if (num < 0) {* 		sign = 0x8000; 		num *= -1;	 	} else {n 		sign = 0;( 	}   	if (num == 0) {$ 		expon = 0; hiMant = 0; loMant = 0; 	} 	else {u 		fMant = frexp(num, &expon);4> 		if ((expon > 16384) || !(fMant < 1)) {	/* Infinity or NaN */> 			expon = sign|0x7FFF; hiMant = 0; loMant = 0; /* infinity */ 		}n 		else {	/* Finite */t 			expon += 16382;& 			if (expon < 0) {	/* denormalized */  				fMant = ldexp(fMant, expon); 				expon = 0; 			} 			expon |= sign;E^ 			fMant = ldexp(fMant, 32);          fsMant = floor(fMant); hiMant = FloatToUnsigned(fsMant);^ 			fMant = ldexp(fMant - fsMant, 32); fsMant = floor(fMant); loMant = FloatToUnsigned(fsMant); 		}  	} 		 	bytes[0] = expon >> 8;  	bytes[1] = expon; 	bytes[2] = hiMant >> 24;  	bytes[3] = hiMant >> 16;d 	bytes[4] = hiMant >> 8; 	bytes[5] = hiMant;l 	bytes[6] = loMant >> 24;A 	bytes[7] = loMant >> 16;/ 	bytes[8] = loMant >> 8; 	bytes[9] = loMant;  }   A /****************************************************************x7  * Testing routines for the floating-point conversions.AB  ****************************************************************/   #ifdef METROWERKSm #define IEEE #endif
 #ifdef applecf
 # define IEEEd #endif /* applec */s #ifdef THINK_C
 # define IEEEO #endif /* THINK_C */
 #ifdef sgi
 # define IEEEm #endif /* sgi */ #ifdef sequent
 # define IEEE0 # define LITTLE_ENDIAN #endif /* sequent */
 #ifdef sun
 # define IEEEX #endif /* sun */ #ifdef NeXT}
 # define IEEEi #endif /* NeXT */0   #ifdef MAIN;   union SParts {
 	Single s; 	long i; }; union DParts {
 	Double d; 	long i[2];* }; union EParts {
 	defdouble e;e 	short i[6]; };     intu GetHexValue(x) register int x;	 {n 	x &= 0x7F;  	g 	if ('0' <= x && x <= '9') 		x -= '0';g 	else if ('a' <= x && x <= 'f')= 		x = x - 'a' + 0xA; 	else if ('A' <= x && x <= 'F')} 		x = x - 'A' + 0xA; 	else= 		x = 0; 	e 	return(x);d }l     void Hex2Bytes(hex, bytes)  register char *hex, *bytes;f {e 	for ( ; *hex; hex += 2) {> 		*bytes++ = (GetHexValue(hex[0]) << 4) | GetHexValue(hex[1]); 		if (hex[1] == 0)' 			break;	/* Guard against odd bytes */	 	} }	     int	 GetHexSymbol(x)  register int x;- {X
 	x &= 0xF; 	if (x <= 9) 		x += '0';e 	else	 		x += 'A' - 0xA;_ 	return(x);  }X     void Bytes2Hex(bytes, hex, nBytes){ register char *bytes, *hex;e register int nBytes; {  	for ( ; nBytes--; bytes++) {r% 		*hex++ = GetHexSymbol(*bytes >> 4);   		*hex++ = GetHexSymbol(*bytes); 	}
 	*hex = 0; }m     void MaybeSwapBytes(bytes, nBytes)  char* bytes; int nBytes;a {s #ifdef LITTLE_ENDIAN 	register char *p, *q, t;)7 	for (p = bytes, q = bytes+nBytes-1; p < q; p++, q--) {*	 		t = *p;s
 		*p = *q;	 		*q = t;n 	} #elseS- 	if (bytes, nBytes);		/* Just so it's used */	 #endif /* LITTLE_ENDIAN */ 	4 }*     floatt MachineIEEESingle(bytes) char* bytes; {t	 	float t;s 	MaybeSwapBytes(bytes, 4); 	t = *((float*)(bytes)); 	MaybeSwapBytes(bytes, 4); 	return (t); }*     Double MachineIEEEDouble(bytes) char* bytes; {r
 	Double t; 	MaybeSwapBytes(bytes, 8); 	t = *((Double*)(bytes));* 	MaybeSwapBytes(bytes, 8); 	return (t); }E     void TestFromIeeeSingle(hex)	
 char *hex; {E
 	defdouble f;- 	union SParts p; 	char bytes[4];r   	Hex2Bytes(hex, bytes);r" 	f = ConvertFromIeeeSingle(bytes);	 	p.s = f;x   #ifdef IEEE 9 	fprintf(stderr, "IEEE(%g) [%s] --> float(%g) [%08lX]\n",& 	MachineIEEESingle(bytes), 	hex, f, p.i); #else /* IEEE */B 	fprintf(stderr, "IEEE[%s] --> float(%g) [%08lX]\n", hex, f, p.i); #endif /* IEEE */s }n     void TestToIeeeSingle(f)0 defdouble f; {	 	union SParts p; 	char bytes[4];< 	char hex[8+1];n  	 	p.s = f;s   	ConvertToIeeeSingle(f, bytes);l 	Bytes2Hex(bytes, hex, 4); #ifdef IEEE 9 	fprintf(stderr, "float(%g) [%08lX] --> IEEE(%g) [%s]\n",f	 		f, p.i,F 		MachineIEEESingle(bytes),f 		hex  	);X #else /* IEEE */B 	fprintf(stderr, "float(%g) [%08lX] --> IEEE[%s]\n", f, p.i, hex); #endif /* IEEE */e }n     void TestFromIeeeDouble(hex) 
 char *hex; {(
 	defdouble f;F 	union DParts p; 	char bytes[8];i 	, 	Hex2Bytes(hex, bytes);X" 	f = ConvertFromIeeeDouble(bytes);	 	p.d = f;t   #ifdef IEEE G 	fprintf(stderr, "IEEE(%g) [%.8s %.8s] --> double(%g) [%08lX %08lX]\n",d 	MachineIEEEDouble(bytes),  	hex, hex+8, f, p.i[0], p.i[1]); #else /* IEEE */B 	fprintf(stderr, "IEEE[%.8s %.8s] --> double(%g) [%08lX %08lX]\n",! 		hex, hex+8, f, p.i[0], p.i[1]);e #endif /* IEEE */x   }    void TestToIeeeDouble(f)  defdouble f; {  	union DParts p; 	char bytes[8];e 	char hex[16+1];  	 	p.d = f;    	ConvertToIeeeDouble(f, bytes);* 	Bytes2Hex(bytes, hex, 8); #ifdef IEEE G 	fprintf(stderr, "double(%g) [%08lX %08lX] --> IEEE(%g) [%.8s %.8s]\n",  		f, p.i[0], p.i[1], 		MachineIEEEDouble(bytes),0 		hex, hex+8 	);g #else /* IEEE */B 	fprintf(stderr, "double(%g) [%08lX %08lX] --> IEEE[%.8s %.8s]\n", 		f, p.i[0], p.i[1], hex, hex+8  	);  #endif /* IEEE */    }s     void TestFromIeeeExtended(hex)n
 char *hex; {M
 	defdouble f;, 	union EParts p; 	char bytes[12];   	Hex2Bytes(hex, bytes);n$ 	f = ConvertFromIeeeExtended(bytes);	 	p.e = f;d   	bytes[11] = bytes[9]; 	bytes[10] = bytes[8]; 	bytes[9] = bytes[7];  	bytes[8] = bytes[6];	 	bytes[7] = bytes[5];i 	bytes[6] = bytes[4];T 	bytes[5] = bytes[3];n 	bytes[4] = bytes[2];h 	bytes[3] = 0; 	bytes[2] = 0;  > #if defined(applec) || defined(THINK_C) || defined(METROWERKS)Y 	fprintf(stderr, "IEEE(%g) [%.4s %.8s %.8s] --> extended(%g) [%04X %04X%04X %04X%04X]\n",t 		*((defdouble*)(bytes)),  		hex, hex+4, hex+12, f,K 		p.i[0]&0xFFFF, p.i[2]&0xFFFF, p.i[3]&0xFFFF, p.i[4]&0xFFFF, p.i[5]&0xFFFFo 	);e #else /* !Macintosh */T 	fprintf(stderr, "IEEE[%.4s %.8s %.8s] --> extended(%g) [%04X %04X%04X %04X%04X]\n", 		hex, hex+4, hex+12, f,K 		p.i[0]&0xFFFF, p.i[2]&0xFFFF, p.i[3]&0xFFFF, p.i[4]&0xFFFF, p.i[5]&0xFFFFU 	);e #endif /* Macintosh */ }i     void TestToIeeeExtended(f)e defdouble f; {l 	char bytes[12]; 	char hex[24+1];  ! 	ConvertToIeeeExtended(f, bytes);a 	Bytes2Hex(bytes, hex, 10);	   	bytes[11] = bytes[9]; 	bytes[10] = bytes[8]; 	bytes[9] = bytes[7];< 	bytes[8] = bytes[6];i 	bytes[7] = bytes[5];x 	bytes[6] = bytes[4];  	bytes[5] = bytes[3];t 	bytes[4] = bytes[2];o 	bytes[3] = 0; 	bytes[2] = 0;  > #if defined(applec) || defined(THINK_C) || defined(METROWERKS)@ 	fprintf(stderr, "extended(%g) --> IEEE(%g) [%.4s %.8s %.8s]\n", 		f, *((defdouble*)(bytes)), 		hex, hex+4, hex+12 	);6 #else /* !Macintosh */; 	fprintf(stderr, "extended(%g) --> IEEE[%.4s %.8s %.8s]\n",* 		f, 		hex, hex+4, hex+12 	);* #endif /* Macintosh */ }o   #include	<signal.h>o   void SignalFPE(i, j) int	i; void (*j)(); {*6 	printf("[Floating Point Interrupt Caught.]\n", i, j); 	signal(SIGFPE, SignalFPE);h }  	e void main() {e 	long d[3];x 	char bytes[12];   	signal(SIGFPE, SignalFPE);S    	TestFromIeeeSingle("00000000");  	TestFromIeeeSingle("80000000");  	TestFromIeeeSingle("3F800000");  	TestFromIeeeSingle("BF800000");  	TestFromIeeeSingle("40000000");  	TestFromIeeeSingle("C0000000");  	TestFromIeeeSingle("7F800000");  	TestFromIeeeSingle("FF800000");  	TestFromIeeeSingle("00800000");  	TestFromIeeeSingle("00400000");  	TestFromIeeeSingle("00000001");  	TestFromIeeeSingle("80000001");  	TestFromIeeeSingle("3F8FEDCB");3 	TestFromIeeeSingle("7FC00100");	/* Quiet NaN(1) */]8 	TestFromIeeeSingle("7F800100");	/* Signalling NaN(1) */   	TestToIeeeSingle(0.0);( 	TestToIeeeSingle(-0.0); 	TestToIeeeSingle(1.0);e 	TestToIeeeSingle(-1.0); 	TestToIeeeSingle(2.0);& 	TestToIeeeSingle(-2.0); 	TestToIeeeSingle(3.0);t 	TestToIeeeSingle(-3.0);$ #if !(defined(sgi) || defined(NeXT)) 	TestToIeeeSingle(HUGE_VAL); 	TestToIeeeSingle(-HUGE_VAL);- #endif   #ifdef IEEE(2 	/* These only work on big-endian IEEE machines */j 	d[0] = 0x00800000L; MaybeSwapBytes(d,4); TestToIeeeSingle(*((float*)(&d[0])));		/* Smallest normalized */r 	d[0] = 0x00400000L; MaybeSwapBytes(d,4); TestToIeeeSingle(*((float*)(&d[0])));		/* Almost largest denormalized */l 	d[0] = 0x00000001L; MaybeSwapBytes(d,4); TestToIeeeSingle(*((float*)(&d[0])));		/* Smallest denormalized */x 	d[0] = 0x00000001L; MaybeSwapBytes(d,4); TestToIeeeSingle(*((float*)(&d[0])) * 0.5);	/* Smaller than smallest denorm */O 	d[0] = 0x3F8FEDCBL; MaybeSwapBytes(d,4); TestToIeeeSingle(*((float*)(&d[0]))); $ #if !(defined(sgi) || defined(NeXT))c 	d[0] = 0x7FC00100L; MaybeSwapBytes(d,4); TestToIeeeSingle(*((float*)(&d[0])));		/* Quiet NaN(1) */eh 	d[0] = 0x7F800100L; MaybeSwapBytes(d,4); TestToIeeeSingle(*((float*)(&d[0])));		/* Signalling NaN(1) */ #endif /* sgi */ #endif /* IEEE */|      ( 	TestFromIeeeDouble("0000000000000000");( 	TestFromIeeeDouble("8000000000000000");( 	TestFromIeeeDouble("3FF0000000000000");( 	TestFromIeeeDouble("BFF0000000000000");( 	TestFromIeeeDouble("4000000000000000");( 	TestFromIeeeDouble("C000000000000000");( 	TestFromIeeeDouble("7FF0000000000000");( 	TestFromIeeeDouble("FFF0000000000000");( 	TestFromIeeeDouble("0010000000000000");( 	TestFromIeeeDouble("0008000000000000");( 	TestFromIeeeDouble("0000000000000001");( 	TestFromIeeeDouble("8000000000000001");( 	TestFromIeeeDouble("3FFFEDCBA9876543");; 	TestFromIeeeDouble("7FF8002000000000");	/* Quiet NaN(1) */*@ 	TestFromIeeeDouble("7FF0002000000000");	/* Signalling NaN(1) */   	TestToIeeeDouble(0.0);e 	TestToIeeeDouble(-0.0); 	TestToIeeeDouble(1.0);l 	TestToIeeeDouble(-1.0); 	TestToIeeeDouble(2.0);H 	TestToIeeeDouble(-2.0); 	TestToIeeeDouble(3.0);  	TestToIeeeDouble(-3.0);$ #if !(defined(sgi) || defined(NeXT)) 	TestToIeeeDouble(HUGE_VAL); 	TestToIeeeDouble(-HUGE_VAL);/ #endif   #ifdef IEEEe2 	/* These only work on big-endian IEEE machines */| 	Hex2Bytes("0010000000000000", bytes); MaybeSwapBytes(d,8); TestToIeeeDouble(*((Double*)(bytes)));	/* Smallest normalized */ 	Hex2Bytes("0010000080000000", bytes); MaybeSwapBytes(d,8); TestToIeeeDouble(*((Double*)(bytes)));	/* Normalized, problem with unsigned */ 	Hex2Bytes("0008000000000000", bytes); MaybeSwapBytes(d,8); TestToIeeeDouble(*((Double*)(bytes)));	/* Almost largest denormalized */ 	Hex2Bytes("0000000080000000", bytes); MaybeSwapBytes(d,8); TestToIeeeDouble(*((Double*)(bytes)));	/* Denorm problem with unsigned */x~ 	Hex2Bytes("0000000000000001", bytes); MaybeSwapBytes(d,8); TestToIeeeDouble(*((Double*)(bytes)));	/* Smallest denormalized */ 	Hex2Bytes("0000000000000001", bytes); MaybeSwapBytes(d,8); TestToIeeeDouble(*((Double*)(bytes)) * 0.5);	/* Smaller than smallest denorm */tv 	Hex2Bytes("3FFFEDCBA9876543", bytes); MaybeSwapBytes(d,8); TestToIeeeDouble(*((Double*)(bytes)));	/* accuracy test */$ #if !(defined(sgi) || defined(NeXT))u 	Hex2Bytes("7FF8002000000000", bytes); MaybeSwapBytes(d,8); TestToIeeeDouble(*((Double*)(bytes)));	/* Quiet NaN(1) */sz 	Hex2Bytes("7FF0002000000000", bytes); MaybeSwapBytes(d,8); TestToIeeeDouble(*((Double*)(bytes)));	/* Signalling NaN(1) */ #endif /* sgi */ #endif /* IEEE */i  7 	TestFromIeeeExtended("00000000000000000000");	/* +0 */t7 	TestFromIeeeExtended("80000000000000000000");	/* -0 */ 7 	TestFromIeeeExtended("3FFF8000000000000000");	/* +1 */y7 	TestFromIeeeExtended("BFFF8000000000000000");	/* -1 */h7 	TestFromIeeeExtended("40008000000000000000");	/* +2 */e7 	TestFromIeeeExtended("C0008000000000000000");	/* -2 */w> 	TestFromIeeeExtended("7FFF0000000000000000");	/* +infinity */> 	TestFromIeeeExtended("FFFF0000000000000000");	/* -infinity */A 	TestFromIeeeExtended("7FFF8001000000000000");	/* Quiet NaN(1) */eF 	TestFromIeeeExtended("7FFF0001000000000000");	/* Signalling NaN(1) */B 	TestFromIeeeExtended("3FFFFEDCBA9876543210");	/* accuracy test */   	TestToIeeeExtended(0.0);s 	TestToIeeeExtended(-0.0); 	TestToIeeeExtended(1.0);; 	TestToIeeeExtended(-1.0); 	TestToIeeeExtended(2.0);0 	TestToIeeeExtended(-2.0);$ #if !(defined(sgi) || defined(NeXT)) 	TestToIeeeExtended(HUGE_VAL); 	TestToIeeeExtended(-HUGE_VAL);H #endif /* sgi */  > #if defined(applec) || defined(THINK_C) || defined(METROWERKS)o 	Hex2Bytes("7FFF00008001000000000000", bytes); TestToIeeeExtended(*((long double*)(bytes)));	/* Quiet NaN(1) */%t 	Hex2Bytes("7FFF00000001000000000000", bytes); TestToIeeeExtended(*((long double*)(bytes)));	/* Signalling NaN(1) */\ 	Hex2Bytes("7FFE00008000000000000000", bytes); TestToIeeeExtended(*((long double*)(bytes)));\ 	Hex2Bytes("000000008000000000000000", bytes); TestToIeeeExtended(*((long double*)(bytes)));\ 	Hex2Bytes("000000000000000000000001", bytes); TestToIeeeExtended(*((long double*)(bytes)));\ 	Hex2Bytes("3FFF0000FEDCBA9876543210", bytes); TestToIeeeExtended(*((long double*)(bytes))); #endif },    = /* This is the output of the test program on an IEEE machine: * IEEE(0) [00000000] --> float(0) [00000000], IEEE(-0) [80000000] --> float(-0) [80000000]* IEEE(1) [3F800000] --> float(1) [3F800000], IEEE(-1) [BF800000] --> float(-1) [BF800000]* IEEE(2) [40000000] --> float(2) [40000000], IEEE(-2) [C0000000] --> float(-2) [C0000000]. IEEE(INF) [7F800000] --> float(INF) [7F800000]0 IEEE(-INF) [FF800000] --> float(-INF) [FF800000]> IEEE(1.17549e-38) [00800000] --> float(1.17549e-38) [00800000]> IEEE(5.87747e-39) [00400000] --> float(5.87747e-39) [00400000]< IEEE(1.4013e-45) [00000001] --> float(1.4013e-45) [00000001]> IEEE(-1.4013e-45) [80000001] --> float(-1.4013e-45) [80000001]6 IEEE(1.12444) [3F8FEDCB] --> float(1.12444) [3F8FEDCB]3 IEEE(NAN(001)) [7FC00100] --> float(INF) [7F800000] 3 IEEE(NAN(001)) [7F800100] --> float(INF) [7F800000][* float(0) [00000000] --> IEEE(0) [00000000]+ float(-0) [80000000] --> IEEE(0) [00000000]i* float(1) [3F800000] --> IEEE(1) [3F800000], float(-1) [BF800000] --> IEEE(-1) [BF800000]* float(2) [40000000] --> IEEE(2) [40000000], float(-2) [C0000000] --> IEEE(-2) [C0000000]* float(3) [40400000] --> IEEE(3) [40400000], float(-3) [C0400000] --> IEEE(-3) [C0400000]. float(INF) [7F800000] --> IEEE(INF) [7F800000]0 float(-INF) [FF800000] --> IEEE(-INF) [FF800000]> float(1.17549e-38) [00800000] --> IEEE(1.17549e-38) [00800000]> float(5.87747e-39) [00400000] --> IEEE(5.87747e-39) [00400000]< float(1.4013e-45) [00000001] --> IEEE(1.4013e-45) [00000001]4 float(7.00649e-46) [00000000] --> IEEE(0) [00000000]6 float(1.12444) [3F8FEDCB] --> IEEE(1.12444) [3F8FEDCB]3 float(NAN(001)) [7FC00100] --> IEEE(INF) [7F800000] 3 float(NAN(001)) [7FC00100] --> IEEE(INF) [7F800000]s= IEEE(0) [00000000 00000000] --> double(0) [00000000 00000000] ? IEEE(-0) [80000000 00000000] --> double(-0) [80000000 00000000] = IEEE(1) [3FF00000 00000000] --> double(1) [3FF00000 00000000]f? IEEE(-1) [BFF00000 00000000] --> double(-1) [BFF00000 00000000]4= IEEE(2) [40000000 00000000] --> double(2) [40000000 00000000]e? IEEE(-2) [C0000000 00000000] --> double(-2) [C0000000 00000000])A IEEE(INF) [7FF00000 00000000] --> double(INF) [7FF00000 00000000]eC IEEE(-INF) [FFF00000 00000000] --> double(-INF) [FFF00000 00000000] S IEEE(2.22507e-308) [00100000 00000000] --> double(2.22507e-308) [00100000 00000000] S IEEE(1.11254e-308) [00080000 00000000] --> double(1.11254e-308) [00080000 00000000];S IEEE(4.94066e-324) [00000000 00000001] --> double(4.94066e-324) [00000000 00000001]nU IEEE(-4.94066e-324) [80000000 00000001] --> double(-4.94066e-324) [80000000 00000001]TI IEEE(1.99556) [3FFFEDCB A9876543] --> double(1.99556) [3FFFEDCB A9876543]IF IEEE(NAN(001)) [7FF80020 00000000] --> double(INF) [7FF00000 00000000]F IEEE(NAN(001)) [7FF00020 00000000] --> double(INF) [7FF00000 00000000]= double(0) [00000000 00000000] --> IEEE(0) [00000000 00000000]S> double(-0) [80000000 00000000] --> IEEE(0) [00000000 00000000]= double(1) [3FF00000 00000000] --> IEEE(1) [3FF00000 00000000] ? double(-1) [BFF00000 00000000] --> IEEE(-1) [BFF00000 00000000]I= double(2) [40000000 00000000] --> IEEE(2) [40000000 00000000].? double(-2) [C0000000 00000000] --> IEEE(-2) [C0000000 00000000]I= double(3) [40080000 00000000] --> IEEE(3) [40080000 00000000]I? double(-3) [C0080000 00000000] --> IEEE(-3) [C0080000 00000000]iA double(INF) [7FF00000 00000000] --> IEEE(INF) [7FF00000 00000000]0C double(-INF) [FFF00000 00000000] --> IEEE(-INF) [FFF00000 00000000]0S double(2.22507e-308) [00100000 00000000] --> IEEE(2.22507e-308) [00100000 00000000]eS double(2.22507e-308) [00100000 80000000] --> IEEE(2.22507e-308) [00100000 80000000]MS double(1.11254e-308) [00080000 00000000] --> IEEE(1.11254e-308) [00080000 00000000]/O double(1.061e-314) [00000000 80000000] --> IEEE(1.061e-314) [00000000 80000000] S double(4.94066e-324) [00000000 00000001] --> IEEE(4.94066e-324) [00000000 00000001]eS double(4.94066e-324) [00000000 00000001] --> IEEE(4.94066e-324) [00000000 00000001]xI double(1.99556) [3FFFEDCB A9876543] --> IEEE(1.99556) [3FFFEDCB A9876543]uF double(NAN(001)) [7FF80020 00000000] --> IEEE(INF) [7FF00000 00000000]F double(NAN(001)) [7FF80020 00000000] --> IEEE(INF) [7FF00000 00000000]I IEEE(0) [0000 00000000 00000000] --> extended(0) [0000 00000000 00000000]eK IEEE(-0) [8000 00000000 00000000] --> extended(-0) [8000 00000000 00000000]FI IEEE(1) [3FFF 80000000 00000000] --> extended(1) [3FFF 80000000 00000000];K IEEE(-1) [BFFF 80000000 00000000] --> extended(-1) [BFFF 80000000 00000000]0I IEEE(2) [4000 80000000 00000000] --> extended(2) [4000 80000000 00000000]0K IEEE(-2) [C000 80000000 00000000] --> extended(-2) [C000 80000000 00000000](M IEEE(INF) [7FFF 00000000 00000000] --> extended(INF) [7FFF 00000000 00000000]uO IEEE(-INF) [FFFF 00000000 00000000] --> extended(-INF) [FFFF 00000000 00000000])R IEEE(NAN(001)) [7FFF 80010000 00000000] --> extended(INF) [7FFF 00000000 00000000]R IEEE(NAN(001)) [7FFF 00010000 00000000] --> extended(INF) [7FFF 00000000 00000000]U IEEE(1.99111) [3FFF FEDCBA98 76543210] --> extended(1.99111) [3FFF FEDCBA98 76543210] 0 extended(0) --> IEEE(0) [0000 00000000 00000000]1 extended(-0) --> IEEE(0) [0000 00000000 00000000]I0 extended(1) --> IEEE(1) [3FFF 80000000 00000000]2 extended(-1) --> IEEE(-1) [BFFF 80000000 00000000]0 extended(2) --> IEEE(2) [4000 80000000 00000000]2 extended(-2) --> IEEE(-2) [C000 80000000 00000000]4 extended(INF) --> IEEE(INF) [7FFF 00000000 00000000]6 extended(-INF) --> IEEE(-INF) [FFFF 00000000 00000000]9 extended(NAN(001)) --> IEEE(INF) [7FFF 00000000 00000000]t9 extended(NAN(001)) --> IEEE(INF) [7FFF 00000000 00000000]eH extended(5.94866e+4931) --> IEEE(5.94866e+4931) [7FFE 80000000 00000000]< extended(1e-4927) --> IEEE(1e-4927) [0000 80000000 00000000]< extended(1e-4927) --> IEEE(1e-4927) [0000 00000000 00000001]< extended(1.99111) --> IEEE(1.99111) [3FFF FEDCBA98 76543210] */  o #endif /* TEST_FP */