G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) H  * ISO 13818-3 MPEG-2 Audio Decoder - Lower Sampling Frequency Extension  *9  * $Id: decode.c,v 1.2 1996/03/28 03:13:37 rowlands Exp $   *  * $Log: decode.c,v $ .  * Revision 1.2  1996/03/28 03:13:37  rowlands*  * Merged layers 1-2 and layer 3 revisions  *.  * Revision 1.1  1996/02/14 03:45:52  rowlands  * Initial revision   *  * Received from FhGH  **********************************************************************/G /********************************************************************** G  *   date   programmers         comment                               * G  * 2/25/91  Douglas Wong,       start of version 1.0 records          * G  *          Davis Pan                                                 * G  * 3/06/91  Douglas Wong        rename: setup.h to dedef.h            * G  *                                      dfilter to defilter           * G  *                                      dwindow to dewindow           * G  *                              integrated "quantizer", "scalefactor" * G  *                              combined window_samples routine into  * G  *                              filter samples                        * G  * 3/31/91  Bill Aspromonte     replaced read_filter by               * G  *                              create_syn_filter and introduced a    * G  *                              new Sub-Band Synthesis routine called * G  *                              SubBandSynthesis()                    * G  * 5/10/91  Vish (PRISM)        Ported to Macintosh and Unix.         * G  *                              Changed "out_fifo()" so that last     * G  *                              unfilled block is also written out.   * G  *                              "create_syn_filter()" was modified so * G  *                              that calculation precision is same as * G  *                              in specification tables.              * G  *                              Changed "decode_scale()" to reflect   * G  *                              specifications.                       * G  *                              Removed all routines used by          * G  *                              "synchronize_buffer()".  This is now  * G  *                              replaced by "seek_sync()".            * G  *                              Incorporated Jean-Georges Fritsch's   * G  *                              "bitstream.c" package.                * G  *                              Deleted "reconstruct_sample()".       * G  * 27jun91  dpwe (Aware)        Passed outFile and &sampFrames as     * G  *                              args to out_fifo() - were global.     * G  *                              Moved "alloc_*" reader to common.c.   * G  *                              alloc, sblimit, stereo passed via new * G  *                              'frame_params struct (were globals).  * G  *                              Added JOINT STEREO decoding, lyrs I&II* G  *                              Affects: decode_bitalloc,buffer_samps * G  *                              Plus a few other cleanups.            * G  * 6/10/91   Earle Jennings     conditional expansion added in        * G  *                              II_dequantize_sample to handle range  * G  *                              problems in MSDOS version             * G  * 8/8/91    Jens Spille        Change for MS-C6.00                   * G  *10/1/91    S.I. Sudharsanan,  Ported to IBM AIX platform.           * G  *           Don H. Lee,                                              * G  *           Peter W. Farrett                                         * G  *10/3/91    Don H. Lee         implemented CRC-16 error protection   * G  *                              newly introduced functions are        * G  *                              buffer_CRC and recover_CRC_error.     * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  * 7/27/92  Juan Pineda         Bug fix in SubBandSynthesis()         * G  *--------------------------------------------------------------------* G  * 6/14/92  Juan Pineda         Layer III decoding routines added.    * G  *          Amit Gulati         Follows CD 3-11172 rev2.  Contains    * G  *                              hacks deal with evolving available    * G  *                              layerIII bitstreams.  Some (minor)    * G  *                              modification of prior LI&II code.     * G  * 10/25/92 Amit Gulati         Updated layerIII routines. Added code * G  *                              for subblock_gain, switched block     * G  *                              modes, stereo pre-processing.         * G  *                              Corrected sign bits for huffman       * G  *                              decoding of quadruples region and     * G  *                              adjusted gain factor in III_dequant.  * G  * 11/21/92 Amit Gulati         Several layerIII bugs fixed.          * G  * 12/15/92 Amit Gulati         Corrected reordering (indexing)       * G  *          Stan Searing        within IMDCT routine.                 * G  *  8/24/93 Masahiro Iwadare    Included IS modification in Layer III.* G  *                              Changed for 1 pass decoding.          * G  *  9/07/93 Toshiyuki Ishino    Integrated Layer III with Ver 3.9.    * G  *--------------------------------------------------------------------* G  * 11/20/93 Masahiro Iwadare    Integrated Layer III with Ver 4.0.    * G  *--------------------------------------------------------------------* G  *  7/14/94 Juergen Koller      Bug fixes in Layer III code           * G  *--------------------------------------------------------------------* G  * 08/11/94 IIS                 Bug fixes in Layer III code           * G  *--------------------------------------------------------------------* G  * 9/20/94  Davis Pan           Modification to avoid premature       * G  *                              synchword detection                   * G  *--------------------------------------------------------------------* G  * 11/09/94 Jon Rowlands        Merged premature synchword detection  * G  *                              fix into layer III code version       * G  *--------------------------------------------------------------------* G  * 07/12/95 Soeren H. Nielsen   Changes for LSF Layer I and II        * G  *--------------------------------------------------------------------* @  *    8/95  Roland Bitto	Adapted to MPEG2                      *H  *  9/8/95  Roalnd Bitto        Bugfix in Function III_stereo         * H  **********************************************************************/   #include        "common.h" #include        "decoder.h"  #include        "huffman.h"   @ /*************************************************************** /*: /* This module contains the core of the decoder ie all the0 /* computational routines. (Layer I and II only), /* Functions are common to both layer unless /* otherwise specified.  /*A /***************************************************************/   B /***************************************************************** /*7 /* The following routines decode the system information  /*B /****************************************************************/  ? /************ Layer I, Layer II & Layer III ******************/    void decode_info(bs, fr_ps)  Bit_stream_struc *bs;  frame_params *fr_ps; {      layer *hdr = fr_ps->header;        hdr->version = get1bit(bs);*     hdr->lay = 4-getbits(bs,2);*I     hdr->error_protection = !get1bit(bs); /* error protect. TRUE/FALSE */o'     hdr->bitrate_index = getbits(bs,4);e,     hdr->sampling_frequency = getbits(bs,2);     hdr->padding = get1bit(bs);2!     hdr->extension = get1bit(bs);$     hdr->mode = getbits(bs,2);"     hdr->mode_ext = getbits(bs,2);!     hdr->copyright = get1bit(bs);v      hdr->original = get1bit(bs);"     hdr->emphasis = getbits(bs,2); }v  D /******************************************************************* /*5 /* The bit allocation information is decoded. Layer I*< /* has 4 bit per subband whereas Layer II is Ws and bit rate
 /* dependent.  /*F /********************************************************************/  5 /**************************** Layer II *************/a  - void II_decode_bitalloc(bs, bit_alloc, fr_ps)  Bit_stream_struc *bs;o# unsigned int bit_alloc[2][SBLIMIT];d frame_params *fr_ps; {      int i,j;     int stereo = fr_ps->stereo;d!     int sblimit = fr_ps->sblimit; !     int jsbound = fr_ps->jsbound;o#     al_table *alloc = fr_ps->alloc;   2     for (i=0;i<jsbound;i++) for (j=0;j<stereo;j++)A         bit_alloc[j][i] = (char) getbits(bs,(*alloc)[i][0].bits);n  <     for (i=jsbound;i<sblimit;i++) /* expand to 2 channels */+         bit_alloc[0][i] = bit_alloc[1][i] =o3             (char) getbits(bs,(*alloc)[i][0].bits);   8     for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<stereo;j++)         bit_alloc[j][i] = 0; }   4 /**************************** Layer I *************/  , void I_decode_bitalloc(bs, bit_alloc, fr_ps) Bit_stream_struc *bs;5# unsigned int bit_alloc[2][SBLIMIT];  frame_params *fr_ps; {      int i,j;      int stereo  = fr_ps->stereo;!     int sblimit = fr_ps->sblimit; !     int jsbound = fr_ps->jsbound;d
     int b;  2     for (i=0;i<jsbound;i++) for (j=0;j<stereo;j++)(         bit_alloc[j][i] = getbits(bs,4);#     for (i=jsbound;i<SBLIMIT;i++) {c         b = getbits(bs,4);         for (j=0;j<stereo;j++)              bit_alloc[j][i] = b;     }  }   B /***************************************************************** /*; /* The following two functions implement the layer I and II > /* format of scale factor extraction. Layer I involves reading? /* 6 bit per subband as scale factor. Layer II requires readingoE /* first the scfsi which in turn indicate the number of scale factorsc /* transmitted.) /*    Layer I : I_decode_scale /*   Layer II : II_decode_scalea /*B /****************************************************************/  C /************************** Layer I stuff ************************/c  6 void I_decode_scale(bs, bit_alloc, scale_index, fr_ps) Bit_stream_struc *bs;&? unsigned int bit_alloc[2][SBLIMIT], scale_index[2][3][SBLIMIT];_ frame_params *fr_ps; {      int i,j;     int stereo = fr_ps->stereo;c!     int sblimit = fr_ps->sblimit;   2     for (i=0;i<SBLIMIT;i++) for (j=0;j<stereo;j++)         if (!bit_alloc[j][i]) 1             scale_index[j][0][i] = SCALE_RANGE-1; <         else                    /* 6 bit per scale factor */2             scale_index[j][0][i] =  getbits(bs,6);   }d  H /*************************** Layer II stuff ***************************/  < void II_decode_scale(bs,scfsi, bit_alloc,scale_index, fr_ps) Bit_stream_struc *bs;e6 unsigned int scfsi[2][SBLIMIT], bit_alloc[2][SBLIMIT],(              scale_index[2][3][SBLIMIT]; frame_params *fr_ps; {r     int i,j;     int stereo = fr_ps->stereo;9!     int sblimit = fr_ps->sblimit;M    0D     for (i=0;i<sblimit;i++) for (j=0;j<stereo;j++) /* 2 bit scfsi */@         if (bit_alloc[j][i]) scfsi[j][i] = (char) getbits(bs,2);;     for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<stereo;j++)   r         scfsi[j][i] = 0;  4     for (i=0;i<sblimit;i++) for (j=0;j<stereo;j++) {         if (bit_alloc[j][i])    "             switch (scfsi[j][i]) {9                 /* all three scale factors transmitted */ ;              case 0 : scale_index[j][0][i] = getbits(bs,6);25                 scale_index[j][1][i] = getbits(bs,6);h5                 scale_index[j][2][i] = getbits(bs,6);                  break;4                 /* scale factor 1 & 3 transmitted */,              case 1 : scale_index[j][0][i] =6                  scale_index[j][1][i] = getbits(bs,6);5                 scale_index[j][2][i] = getbits(bs,6);t                 break;4                 /* scale factor 1 & 2 transmitted */;              case 3 : scale_index[j][0][i] = getbits(bs,6);e&                 scale_index[j][1][i] =:                     scale_index[j][2][i] =  getbits(bs,6);                 break;7                 /* only one scale factor transmitted *//,              case 2 : scale_index[j][0][i] ='                  scale_index[j][1][i] =-:                      scale_index[j][2][i] = getbits(bs,6);                 break;                  default : break;
             }          else {9             scale_index[j][0][i] = scale_index[j][1][i] = 5                 scale_index[j][2][i] = SCALE_RANGE-1;e	         }      } :     for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<stereo;j++) {5         scale_index[j][0][i] = scale_index[j][1][i] = 1             scale_index[j][2][i] = SCALE_RANGE-1;      }  }e  ? /**************************************************************u /*8 /*   The following two routines take care of reading the= /* compressed sample from the bit stream for both layer 1 and = /* layer 2. For layer 1, read the number of bits as indicated < /* by the bit_alloc information. For layer 2, if grouping is? /* indicated for a particular subband, then the sample size has_< /* to be read from the bits_group and the merged samples has> /* to be decompose into the three distinct samples. Otherwise,# /* it is the same for as layer one.* /*@ /**************************************************************/  B /******************************* Layer I stuff ******************/  2 void I_buffer_sample(bs, sample, bit_alloc, fr_ps)' unsigned int FAR sample[2][3][SBLIMIT];h# unsigned int bit_alloc[2][SBLIMIT];w Bit_stream_struc *bs;- frame_params *fr_ps; {-     int i,j,k;     int stereo = fr_ps->stereo;/!     int sblimit = fr_ps->sblimit;d!     int jsbound = fr_ps->jsbound;-     unsigned int s;-  2     for (i=0;i<jsbound;i++) for (j=0;j<stereo;j++)(         if ( (k = bit_alloc[j][i]) == 0)              sample[j][0][i] = 0;
         else -=             sample[j][0][i] = (unsigned int) getbits(bs,k+1);I#     for (i=jsbound;i<SBLIMIT;i++) {I(         if ( (k = bit_alloc[0][i]) == 0)             s = 0;
         else -.             s = (unsigned int)getbits(bs,k+1);         for (j=0;j<stereo;j++)#             sample[j][0][i]    = s;      }y }w  E /*************************** Layer II stuff ************************/-  0 void II_buffer_sample(bs,sample,bit_alloc,fr_ps)' unsigned int FAR sample[2][3][SBLIMIT];d# unsigned int bit_alloc[2][SBLIMIT];  Bit_stream_struc *bs;r frame_params *fr_ps; {      int i,j,k,m;     int stereo = fr_ps->stereo;-!     int sblimit = fr_ps->sblimit; !     int jsbound = fr_ps->jsbound; #     al_table *alloc = fr_ps->alloc;-  D     for (i=0;i<sblimit;i++) for (j=0;j<((i<jsbound)?stereo:1);j++) {         if (bit_alloc[j][i]) {/             /* check for grouping in subband */ 6             if ((*alloc)[i][bit_alloc[j][i]].group==3)#                 for (m=0;m<3;m++) {*:                     k = (*alloc)[i][bit_alloc[j][i]].bits;C                     sample[j][m][i] = (unsigned int) getbits(bs,k);*                 }         9             else {              /* bit_alloc = 3, 5, 9 */ *                 unsigned int nlevels, c=0;  =                 nlevels = (*alloc)[i][bit_alloc[j][i]].steps;b4                 k=(*alloc)[i][bit_alloc[j][i]].bits;2                 c = (unsigned int) getbits(bs, k);#                 for (k=0;k<3;k++) {*2                     sample[j][k][i] = c % nlevels;!                     c /= nlevels;e                 } 
             }*	         }*?         else {                  /* for no sample transmitted */L2             for (k=0;k<3;k++) sample[j][k][i] = 0;	         },G         if(stereo == 2 && i>= jsbound) /* joint stereo : copy L to R */r@             for (k=0;k<3;k++) sample[1][k][i] = sample[0][k][i];     }gJ     for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<stereo;j++) for (k=0;k<3;k++)         sample[j][k][i] = 0; }      =  ? /**************************************************************  /*9 /*   Restore the compressed sample to a factional number.$+ /*   first complement the MSB of the sampled /*    for layer I :;1 /*    Use s = (s' + 2^(-nb+1) ) * 2^nb / (2^nb-1)i /*   for Layer II : # /*   Use the formula s = s' * c + d  /*@ /**************************************************************/  D static double c[17] = { 1.33333333333, 1.60000000000, 1.14285714286,D                         1.77777777777, 1.06666666666, 1.03225806452,D                         1.01587301587, 1.00787401575, 1.00392156863,D                         1.00195694716, 1.00097751711, 1.00048851979,D                         1.00024420024, 1.00012208522, 1.00006103888,7                         1.00003051851, 1.00001525902 };   K static double d[17] = { 0.500000000, 0.500000000, 0.250000000, 0.500000000,mK                         0.125000000, 0.062500000, 0.031250000, 0.015625000, L                         0.007812500, 0.003906250, 0.001953125, 0.0009765625,D                         0.00048828125, 0.00024414063, 0.00012207031,7                         0.00006103516, 0.00003051758 };[  D /************************** Layer II stuff ************************/  = void II_dequantize_sample(sample, bit_alloc, fraction, fr_ps)+' unsigned int FAR sample[2][3][SBLIMIT];*# unsigned int bit_alloc[2][SBLIMIT];*# double FAR fraction[2][3][SBLIMIT];c frame_params *fr_ps; {i     int i, j, k, x;      int stereo = fr_ps->stereo;]!     int sblimit = fr_ps->sblimit;n#     al_table *alloc = fr_ps->alloc;e  E     for (i=0;i<sblimit;i++)  for (j=0;j<3;j++) for (k=0;k<stereo;k++)d         if (bit_alloc[k][i]) {  *             /* locate MSB in the sample */             x = 0; #ifndef MS_DOSE             while ((1L<<x) < (*alloc)[i][bit_alloc[k][i]].steps) x++;o #elsej6             /* microsoft C thinks an int is a short */4             while (( (unsigned long) (1L<<(long)x) <H                     (unsigned long)( (*alloc)[i][bit_alloc[k][i]].steps))                     ) && ( x < 16) ) x++;c #endif               /* MSB inversion */r4             if (((sample[k][j][i] >> x-1) & 1) == 1)(                 fraction[k][j][i] = 0.0;+             else  fraction[k][j][i] = -1.0;)  .             /* Form a 2's complement sample */L             fraction[k][j][i] += (double) (sample[k][j][i] & ((1<<x-1)-1)) /#                 (double) (1L<<x-1);*  '             /* Dequantize the sample */cG             fraction[k][j][i] += d[(*alloc)[i][bit_alloc[k][i]].quant];rG             fraction[k][j][i] *= c[(*alloc)[i][bit_alloc[k][i]].quant];_	         }a(         else fraction[k][j][i] = 0.0;       fI     for (i=sblimit;i<SBLIMIT;i++) for (j=0;j<3;j++) for(k=0;k<stereo;k++)T          fraction[k][j][i] = 0.0; }   E /***************************** Layer I stuff ***********************/   < void I_dequantize_sample(sample, fraction, bit_alloc, fr_ps)' unsigned int FAR sample[2][3][SBLIMIT];t# unsigned int bit_alloc[2][SBLIMIT];*# double FAR fraction[2][3][SBLIMIT];* frame_params *fr_ps; {_     int i, nb, k;s     int stereo = fr_ps->stereo; !     int sblimit = fr_ps->sblimit;t       for (i=0;i<SBLIMIT;i++)]         for (k=0;k<stereo;k++)"             if (bit_alloc[k][i]) {)                 nb = bit_alloc[k][i] + 1;fR                 if (((sample[k][0][i] >> nb-1) & 1) == 1) fraction[k][0][i] = 0.0;.                 else fraction[k][0][i] = -1.0;Q                 fraction[k][0][i] += (double) (sample[k][0][i] & ((1<<nb-1)-1)) /S(                     (double) (1L<<nb-1);  #                 fraction[k][0][i] =iI                     (double) (fraction[k][0][i]+1.0/(double)(1L<<nb-1)) * B                         (double) (1L<<nb) / (double) ((1L<<nb)-1);
             }i)             else fraction[k][0][i] = 0.0;[ }0  = /************************************************************t /*9 /*   Restore the original value of the sample ie multiply,, /*    the fraction value by its scalefactor. /*> /************************************************************/  A /************************* Layer II Stuff **********************/;  9 void II_denormalize_sample(fraction, scale_index,fr_ps,x) # double FAR fraction[2][3][SBLIMIT];*( unsigned int scale_index[2][3][SBLIMIT]; frame_params *fr_ps; int x; {[     int i,j,k;     int stereo = fr_ps->stereo;[!     int sblimit = fr_ps->sblimit;l  4     for (i=0;i<sblimit;i++) for (j=0;j<stereo;j++) {<         fraction[j][0][i] *= multiple[scale_index[j][x][i]];<         fraction[j][1][i] *= multiple[scale_index[j][x][i]];<         fraction[j][2][i] *= multiple[scale_index[j][x][i]];     }  }b  K /**************************** Layer I stuff ******************************/   5 void I_denormalize_sample(fraction,scale_index,fr_ps)s# double FAR fraction[2][3][SBLIMIT]; ( unsigned int scale_index[2][3][SBLIMIT]; frame_params *fr_ps; {o     int i,j,k;     int stereo = fr_ps->stereo;)!     int sblimit = fr_ps->sblimit;s  2     for (i=0;i<SBLIMIT;i++) for (j=0;j<stereo;j++)<         fraction[j][0][i] *= multiple[scale_index[j][0][i]]; }*  B /***************************************************************** /*? /* The following are the subband synthesis routines. They applyf? /* to both layer I and layer II stereo or mono. The user has to ; /* decide what parameters are to be passed to the routines.r /*A /***************************************************************/p  > /************************************************************* /*9 /*   Pass the subband sample through the synthesis windowt /*@ /**************************************************************/    /* create in synthesis filter */   void create_syn_filter(filter) double FAR filter[64][SBLIMIT];* {*     register int i,k;e       for (i=0; i<64; i++)         for (k=0; k<32; k++) {N             if ((filter[i][k] = 1e9*cos((double)((PI64*i+PI4)*(2*k+1)))) >= 0)6                 modf(filter[i][k]+0.5, &filter[i][k]);             else6                 modf(filter[i][k]-0.5, &filter[i][k]);!             filter[i][k] *= 1e-9;i	         }  }o  @ /*************************************************************** /* /*   Window the restored samplee /*A /***************************************************************/    /* read in synthesis window */   void read_syn_window(window) double FAR window[HAN_SIZE]; {      int i,j[4]; 
     FILE *fp;l     double f[4];     char t[150];  -     if (!(fp = OpenTableFile("dewindow") )) { C         printf("Please check synthesis window table 'dewindow'\n");*         exit(1);     }      for (i=0;i<512;i+=4) {         fgets(t, 150, fp);E         sscanf(t,"D[%d] = %lf D[%d] = %lf D[%d] = %lf D[%d] = %lf\n",n-                j, f,j+1,f+1,j+2,f+2,j+3,f+3);c         if (i==j[0]) {             window[i] = f[0];              window[i+1] = f[1];              window[i+2] = f[2];              window[i+3] = f[3]; 	         }e         else {>             printf("Check index in synthesis window table\n");             exit(1);	         }_         fgets(t,150,fp);     }e     fclose(fp);n }b  0 int SubBandSynthesis (bandPtr, channel, samples) double *bandPtr; int channel; short *samples;* {      register int i,j,k;l'     register double *bufOffsetPtr, sum;      register long foo;     static int init = 1;     typedef double NN[64][32];     static NN FAR *filter;%     typedef double BB[2][2*HAN_SIZE];      static BB FAR *buf;t&     static int bufOffset[2] = {64,64};     static double FAR *window;M     int clip = 0;               /* count & return how many samples clipped */        if (init) {g4         buf = (BB FAR *) mem_alloc(sizeof(BB),"BB");8         filter = (NN FAR *) mem_alloc(sizeof(NN), "NN");#         create_syn_filter(*filter); L         window = (double FAR *) mem_alloc(sizeof(double) * HAN_SIZE, "WIN");          read_syn_window(window);         init = 0;k     }p /*    if (channel == 0) */;     bufOffset[channel] = (bufOffset[channel] - 64) & 0x3ff;p:     bufOffsetPtr = &((*buf)[channel][bufOffset[channel]]);       for (i=0; i<64; i++) {         sum = 0;         for (k=0; k<32; k++)0             sum += bandPtr[k] * (*filter)[i][k];         bufOffsetPtr[i] = sum;     }*6     /*  S(i,j) = D(j+32i) * U(j+32i+((i+1)>>1)*64)  */G     /*  samples(i,j) = MWindow(j+32i) * bufPtr(j+32i+((i+1)>>1)*64)  */      for (j=0; j<32; j++) {         sum = 0;         for (i=0; i<16; i++) {             k = j + (i<<5);LM             sum += window[k] * (*buf) [channel] [( (k + ( ((i+1)>>1) <<6) ) +*O                                                   bufOffset[channel]) & 0x3ff];1	         }0  N /*      Casting truncates towards zero for both positive and negative numbers,8 	the result is cross-over distortion,  1995-07-12 shn */           if(sum > 0) 	         { ;           foo = (long)(sum * (double) SCALE + (double)0.5); 	         }          else	         {0:            foo = (long)(sum * (double)SCALE -(double)0.5);
         }   K      if (foo >= (long) SCALE)      {samples[j] = (short)(SCALE-1); ++clip;}0K      else if (foo < (long) -SCALE) {samples[j] = (short)(-SCALE);  ++clip;}2;      else                           samples[j] =(short)foo;0     },     return(clip);  }   A void out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames) * short FAR pcm_sample[2][SSLIMIT][SBLIMIT]; int num; frame_params *fr_ps;	 int done;I FILE *outFile; unsigned long *psampFrames;e {n     int i,j,l;     int stereo = fr_ps->stereo; !     int sblimit = fr_ps->sblimit;I#     static short int outsamp[1600];I     static long k = 0;       if (!done)5         for (i=0;i<num;i++) for (j=0;j<SBLIMIT;j++) {n             (*psampFrames)++; $             for (l=0;l<stereo;l++) {%                 if (!(k%1600) && k) {o 		    /*B 		      Samples are big-endian. If this is a little-endian machine 		      we must swap
 		      */- 		    if ( NativeByteOrder == order_unknown )  		    {e* 			NativeByteOrder = DetermineByteOrder();* 			if ( NativeByteOrder == order_unknown ) 			{8 			    fprintf( stderr, "byte order not determined\n" ); 			    exit( 1 );i 			} 		    }<2 		    if ( NativeByteOrder == order_littleEndian )% 			SwapBytesInWords( outsamp, 1600 );  		    3                     fwrite(outsamp,2,1600,outFile);*                     k = 0;                 }[3                 outsamp[k++] = pcm_sample[l][i][j];[
             } 	         }l
     else {)         fwrite(outsamp,2,(int)k,outFile);          k = 0;     }/ }    void  buffer_CRC(bs, old_crc)o Bit_stream_struc  *bs; unsigned int  *old_crc;  {      *old_crc = getbits(bs, 16);  }   M void  recover_CRC_error(pcm_sample, error_count, fr_ps, outFile, psampFrames)t* short FAR pcm_sample[2][SSLIMIT][SBLIMIT]; int error_count; frame_params *fr_ps; FILE *outFile; unsigned long *psampFrames;o {]      int  stereo = fr_ps->stereo;     int  num, done, i;)     int  samplesPerFrame, samplesPerSlot;       layer  *hdr = fr_ps->header;     long  offset;*     short  *temp;r       num = 3;     if (hdr->lay == 1) num = 1;a  ,     samplesPerSlot = SBLIMIT * num * stereo;*     samplesPerFrame = samplesPerSlot * 32;  I     if (error_count == 1) {     /* replicate previous error_free frame */r         done = 1;          /* flush out fifo */E         out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames);o<         /* go back to the beginning of the previous frame */5         offset = sizeof(short int) * samplesPerFrame;a*         fseek(outFile, -offset, SEEK_CUR);         done = 0;)+         for (i = 0; i < SCALE_BLOCK; i++) { :             fread(pcm_sample, 2, samplesPerSlot, outFile);I             out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames); 	         }u     }L4     else{                       /* mute the frame */#         temp = (short*) pcm_sample;[         done = 0;1)         for (i = 0; i < 2*3*SBLIMIT; i++)l@             *temp++ = MUTE;     /* MUTE value is in decoder.h */)         for (i = 0; i < SCALE_BLOCK; i++)*I             out_fifo(pcm_sample, num, fr_ps, done, outFile, psampFrames);t     }i }   E /************************* Layer III routines **********************/c  % void III_get_side_info(bs, si, fr_ps)* Bit_stream_struc *bs;* III_side_info_t *si; frame_params *fr_ps; {t    int ch, gr, i;*    int stereo = fr_ps->stereo;    e0    if(fr_ps->header->version != MPEG_PHASE2_LSF)    {+       si->main_data_begin = getbits(bs, 9);]       if (stereo == 1)*          si->private_bits = getbits(bs,5);/          else si->private_bits = getbits(bs,3);p  "        for (ch=0; ch<stereo; ch++)            for (i=0; i<4; i++)-            si->ch[ch].scfsi[i] = get1bit(bs);e  ]   "         for (gr=0; gr< 2 ; gr++) {(            for (ch=0; ch<stereo; ch++) {A               si->ch[ch].gr[gr].part2_3_length = getbits(bs, 12);*<               si->ch[ch].gr[gr].big_values = getbits(bs, 9);=               si->ch[ch].gr[gr].global_gain = getbits(bs, 8);fC               si->ch[ch].gr[gr].scalefac_compress = getbits(bs, 4);xD               si->ch[ch].gr[gr].window_switching_flag = get1bit(bs);<               if (si->ch[ch].gr[gr].window_switching_flag) {?                  si->ch[ch].gr[gr].block_type = getbits(bs, 2);iB                  si->ch[ch].gr[gr].mixed_block_flag = get1bit(bs);$                  for (i=0; i<2; i++)G                     si->ch[ch].gr[gr].table_select[i] = getbits(bs, 5);T$                  for (i=0; i<3; i++)H                     si->ch[ch].gr[gr].subblock_gain[i] = getbits(bs, 3);                oS             /* Set region_count parameters since they are implicit in this case. */*             9                  if (si->ch[ch].gr[gr].block_type == 0) {sN                    printf("Side info bad: block_type == 0 in split block.\n");                    exit(0);*                  };                  else if (si->ch[ch].gr[gr].block_type == 2 A                       && si->ch[ch].gr[gr].mixed_block_flag == 0) M                              si->ch[ch].gr[gr].region0_count = 8; /* MI 9; */]F                  else si->ch[ch].gr[gr].region0_count = 7; /* MI 8; */<                       si->ch[ch].gr[gr].region1_count = 20 -& 						si->ch[ch].gr[gr].region0_count;              }             else {"                for (i=0; i<3; i++)F                    si->ch[ch].gr[gr].table_select[i] = getbits(bs, 5);@                si->ch[ch].gr[gr].region0_count = getbits(bs, 4);@                si->ch[ch].gr[gr].region1_count = getbits(bs, 3);0                si->ch[ch].gr[gr].block_type = 0;             }       1          si->ch[ch].gr[gr].preflag = get1bit(bs);r8          si->ch[ch].gr[gr].scalefac_scale = get1bit(bs);<          si->ch[ch].gr[gr].count1table_select = get1bit(bs);
          }       }t
     }          else /* Layer 3 LSF */
     {     -         si->main_data_begin = getbits(bs, 8);          if (stereo == 1)2                  si->private_bits = getbits(bs,1);/          else si->private_bits = getbits(bs,2);i  "         for (gr=0; gr< 1 ; gr++) {(            for (ch=0; ch<stereo; ch++) {A               si->ch[ch].gr[gr].part2_3_length = getbits(bs, 12); <               si->ch[ch].gr[gr].big_values = getbits(bs, 9);=               si->ch[ch].gr[gr].global_gain = getbits(bs, 8); C               si->ch[ch].gr[gr].scalefac_compress = getbits(bs, 9); D               si->ch[ch].gr[gr].window_switching_flag = get1bit(bs);<               if (si->ch[ch].gr[gr].window_switching_flag) {?                  si->ch[ch].gr[gr].block_type = getbits(bs, 2);bB                  si->ch[ch].gr[gr].mixed_block_flag = get1bit(bs);$                  for (i=0; i<2; i++)G                     si->ch[ch].gr[gr].table_select[i] = getbits(bs, 5);;$                  for (i=0; i<3; i++)H                     si->ch[ch].gr[gr].subblock_gain[i] = getbits(bs, 3);                mS             /* Set region_count parameters since they are implicit in this case. */              9                  if (si->ch[ch].gr[gr].block_type == 0) {lN                    printf("Side info bad: block_type == 0 in split block.\n");                    exit(0);f                  };                  else if (si->ch[ch].gr[gr].block_type == 2 A                       && si->ch[ch].gr[gr].mixed_block_flag == 0)oM                              si->ch[ch].gr[gr].region0_count = 8; /* MI 9; */ F                  else si->ch[ch].gr[gr].region0_count = 7; /* MI 8; */]                       si->ch[ch].gr[gr].region1_count = 20 - si->ch[ch].gr[gr].region0_count;j                 }i               else {#                 for (i=0; i<3; i++)uF                    si->ch[ch].gr[gr].table_select[i] = getbits(bs, 5);@                si->ch[ch].gr[gr].region0_count = getbits(bs, 4);@                si->ch[ch].gr[gr].region1_count = getbits(bs, 3);0                si->ch[ch].gr[gr].block_type = 0;               }      d  8          si->ch[ch].gr[gr].scalefac_scale = get1bit(bs);<          si->ch[ch].gr[gr].count1table_select = get1bit(bs);
          }      }   }  }   % void III_put_side_info(bs, si, fr_ps)l frame_params *fr_ps; Bit_stream_struc *bs;0 III_side_info_t *si; {(    int ch, gr, i;     int stereo = fr_ps->stereo;  .  if(fr_ps->header->version != MPEG_PHASE2_LSF)  {&    putbits(bs, si->main_data_begin,9);    if (stereo == 1)p'       putbits(bs, si->private_bits, 5); ,       else putbits(bs, si->private_bits, 3);      for (ch=0; ch<stereo; ch++)       for (i=0; i<4; i++)c*          put1bit(bs, si->ch[ch].scfsi[i]);      for (gr=0; gr<2; gr++) {[#       for (ch=0; ch<stereo; ch++) {a;          putbits(bs, si->ch[ch].gr[gr].part2_3_length, 12);p6          putbits(bs, si->ch[ch].gr[gr].big_values, 9);7          putbits(bs, si->ch[ch].gr[gr].global_gain, 8);o=          putbits(bs, si->ch[ch].gr[gr].scalefac_compress, 4);)>          put1bit(bs, si->ch[ch].gr[gr].window_switching_flag);7          if (si->ch[ch].gr[gr].window_switching_flag) {+9             putbits(bs, si->ch[ch].gr[gr].block_type, 2); <             put1bit(bs, si->ch[ch].gr[gr].mixed_block_flag);             for (i=0; i<2; i++)/A                putbits(bs, si->ch[ch].gr[gr].table_select[i], 5);v             for (i=0; i<3; i++);B                putbits(bs, si->ch[ch].gr[gr].subblock_gain[i], 3);
             }r          else {d             for (i=0; i<3; i++) >             putbits(bs, si->ch[ch].gr[gr].table_select[i], 5);<             putbits(bs, si->ch[ch].gr[gr].region0_count, 4);<             putbits(bs, si->ch[ch].gr[gr].region1_count, 3);             }      [  0          put1bit(bs, si->ch[ch].gr[gr].preflag);7          put1bit(bs, si->ch[ch].gr[gr].scalefac_scale);e;          put1bit(bs, si->ch[ch].gr[gr].count1table_select);o
          }       }d  }  else /* Layer 3 LSF */;  {'     putbits(bs, si->main_data_begin,8);=     if (stereo == 1)'       putbits(bs, si->private_bits, 1);r,       else putbits(bs, si->private_bits, 2);      c      for (gr=0; gr<1; gr++) { $        for (ch=0; ch<stereo; ch++) {;          putbits(bs, si->ch[ch].gr[gr].part2_3_length, 12);s6          putbits(bs, si->ch[ch].gr[gr].big_values, 9);7          putbits(bs, si->ch[ch].gr[gr].global_gain, 8);p=          putbits(bs, si->ch[ch].gr[gr].scalefac_compress, 9); >          put1bit(bs, si->ch[ch].gr[gr].window_switching_flag);7          if (si->ch[ch].gr[gr].window_switching_flag) {t9             putbits(bs, si->ch[ch].gr[gr].block_type, 2);i<             put1bit(bs, si->ch[ch].gr[gr].mixed_block_flag);             for (i=0; i<2; i++)mA                putbits(bs, si->ch[ch].gr[gr].table_select[i], 5);a             for (i=0; i<3; i++)uB                putbits(bs, si->ch[ch].gr[gr].subblock_gain[i], 3);
             }u          else             {               for (i=0; i<3; i++)0>             putbits(bs, si->ch[ch].gr[gr].table_select[i], 5);<             putbits(bs, si->ch[ch].gr[gr].region0_count, 4);<             putbits(bs, si->ch[ch].gr[gr].region1_count, 3);            }        7          put1bit(bs, si->ch[ch].gr[gr].scalefac_scale);a;          put1bit(bs, si->ch[ch].gr[gr].count1table_select);I        }      }   }t }+   struct {    int l[5];-    int s[3];} sfbtable = {{0, 6, 11, 16, 21},C&                           {0, 6, 12}};                          ,D int slen[2][16] = {{0, 0, 0, 0, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4},E                    {0, 1, 2, 3, 0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 2, 3}};s	 struct  { 
    int l[23];c    int s[14];} sfBandIndex[6] =mV     {{{0,6,12,18,24,30,36,44,54,66,80,96,116,140,168,200,238,284,336,396,464,522,576},3      {0,4,8,12,18,24,32,42,56,74,100,132,174,192}}, U     {{0,6,12,18,24,30,36,44,54,66,80,96,114,136,162,194,232,278,330,394,464,540,576},t3      {0,4,8,12,18,26,36,48,62,80,104,136,180,192}},gU     {{0,6,12,18,24,30,36,44,54,66,80,96,116,140,168,200,238,284,336,396,464,522,576}, 3      {0,4,8,12,18,26,36,48,62,80,104,134,174,192}},   R     {{0,4,8,12,16,20,24,30,36,44,52,62,74,90,110,134,162,196,238,288,342,418,576},2      {0,4,8,12,16,22,30,40,52,66,84,106,136,192}},R     {{0,4,8,12,16,20,24,30,36,42,50,60,72,88,106,128,156,190,230,276,330,384,576},2      {0,4,8,12,16,22,28,38,50,64,80,100,126,192}},S     {{0,4,8,12,16,20,24,30,36,44,54,66,82,102,126,156,194,240,296,364,448,550,576},>4      {0,4,8,12,16,22,30,42,58,78,104,138,180,192}}};      7 void III_get_scale_factors(scalefac, si, gr, ch, fr_ps)  III_scalefac_t *scalefac;g III_side_info_t *si; int gr, ch;  frame_params *fr_ps; {. int sfb, i, window;a1 struct gr_info_s *gr_info = &(si->ch[ch].gr[gr]);+  H     if (gr_info->window_switching_flag && (gr_info->block_type == 2)) { G       if (gr_info->mixed_block_flag) { /* MIXED */ /* NEW - ag 11/25 */[&          for (sfb = 0; sfb < 8; sfb++)/             (*scalefac)[ch].l[sfb] = hgetbits(  6                  slen[0][gr_info->scalefac_compress]);&          for (sfb = 3; sfb < 6; sfb++).             for (window=0; window<3; window++)9                (*scalefac)[ch].s[window][sfb] = hgetbits("6                  slen[0][gr_info->scalefac_compress]);'          for (sfb = 6; sfb < 12; sfb++)..             for (window=0; window<3; window++)9                (*scalefac)[ch].s[window][sfb] = hgetbits( 6                  slen[1][gr_info->scalefac_compress]);2          for (sfb=12,window=0; window<3; window++)/             (*scalefac)[ch].s[window][sfb] = 0;h       }r       else {  /* SHORT*/          for (i=0; i<2; i++) oC             for (sfb = sfbtable.s[i]; sfb < sfbtable.s[i+1]; sfb++)31                for (window=0; window<3; window++)s=                   (*scalefac)[ch].s[window][sfb] = hgetbits( g9                     slen[i][gr_info->scalefac_compress]);g2          for (sfb=12,window=0; window<3; window++)/             (*scalefac)[ch].s[window][sfb] = 0;        }      }          r#     else {   /* LONG types 0,1,3 */          for (i=0; i<4; i++) {l7            if ((si->ch[ch].scfsi[i] == 0) || (gr == 0))sE               for (sfb = sfbtable.l[i]; sfb < sfbtable.l[i+1]; sfb++)e4                   (*scalefac)[ch].l[sfb] = hgetbits(>                  slen[(i<2)?0:1][gr_info->scalefac_compress]);	         }t#         (*scalefac)[ch].l[22] = 0; >     }_ }s  0 /****************** new MPEG2 stuf  ***********/  W static unsigned nr_of_sfb_block[6][3][4] = {{{6, 5, 5, 5},{ 9, 9, 9, 9 },{6, 9, 9, 9}},gU                                          {{6, 5, 7, 3},{ 9, 9, 12, 6},{6, 9, 12, 6}}, W                                          {{11, 10, 0, 0},{ 18, 18, 0, 0},{15,18,0,0 }},[X                                          {{7, 7, 7, 0},{ 12, 12, 12, 0},{6, 15, 12, 0}},T                                          {{6, 6, 6, 3},{12, 9, 9, 6},{6, 12, 9, 6}},P                                          {{8, 8, 5, 0},{15,12,9,0},{6,18,9,0}}};$ static unsigned scalefac_buffer[54];  8 void III_get_LSF_scale_data(scalefac, si, gr, ch, fr_ps) III_scalefac_t *scalefac;. III_side_info_t *si; int gr, ch;  frame_params *fr_ps; {; short sfb, i,j,k, window; # short blocktypenumber, blocknumber;]  1 struct gr_info_s *gr_info = &(si->ch[ch].gr[gr]);S7 unsigned scalefac_comp, int_scalefac_comp, new_slen[4];s    . layer *hdr = fr_ps->header; , scalefac_comp =  gr_info->scalefac_compress;       blocktypenumber = 0;G     if ((gr_info->block_type == 2) && (gr_info->mixed_block_flag == 0)) L                                                         blocktypenumber = 1;  F    if ((gr_info->block_type == 2) && (gr_info->mixed_block_flag == 1))L                                                         blocktypenumber = 2;  G     if(!((( hdr->mode_ext == 1) || (hdr->mode_ext == 3)) && (ch == 1)))I     {  	if(scalefac_comp < 400)	         {r* 		new_slen[0] = (scalefac_comp >> 4) / 5 ;* 		new_slen[1] = (scalefac_comp >> 4) % 5 ;+ 		new_slen[2] = (scalefac_comp % 16) >> 2 ;+$ 		new_slen[3] = (scalefac_comp % 4);.                 si->ch[ch].gr[gr].preflag = 0;                    blocknumber = 0;
          }   	else if( scalefac_comp  < 500)r	         {14 		new_slen[0] = ((scalefac_comp - 400 )  >> 2) / 5 ;2 		new_slen[1] = ((scalefac_comp - 400) >> 2) % 5 ;, 		new_slen[2] = (scalefac_comp - 400 ) % 4 ; 		new_slen[3] = 0;.                 si->ch[ch].gr[gr].preflag = 0;                  blocknumber = 1;  	         }s   	else if( scalefac_comp  < 512)a	         { , 		new_slen[0] = (scalefac_comp - 500 ) / 3 ;, 		new_slen[1] = (scalefac_comp - 500)  % 3 ; 		new_slen[2] = 0 ;- 		new_slen[3] = 0;.                 si->ch[ch].gr[gr].preflag = 1;                  blocknumber = 2;  	         }t      }  E     if((((hdr->mode_ext == 1) || (hdr->mode_ext == 3)) && (ch == 1)))f     {01       /*   intensity_scale = scalefac_comp %2; */ 0          int_scalefac_comp = scalefac_comp >> 1; 	0$         if(int_scalefac_comp  < 180)	         {+) 		new_slen[0] = int_scalefac_comp  / 36 ;]/ 		new_slen[1] = (int_scalefac_comp % 36 ) / 6 ;c- 		new_slen[2] = (int_scalefac_comp % 36) % 6;b 		new_slen[3] = 0;.                 si->ch[ch].gr[gr].preflag = 0;                  blocknumber = 3;  
          }  # 	else if( int_scalefac_comp  < 244)h	         { : 		new_slen[0] = ((int_scalefac_comp - 180 )  % 64 ) >> 4 ;7 		new_slen[1] = ((int_scalefac_comp - 180) % 16) >> 2 ; 0 		new_slen[2] = (int_scalefac_comp - 180 ) % 4 ; 		new_slen[3] = 0;.                 si->ch[ch].gr[gr].preflag = 0;                  blocknumber = 4;  	         }   # 	else if( int_scalefac_comp  < 255) 	         {i0 		new_slen[0] = (int_scalefac_comp - 244 ) / 3 ;1 		new_slen[1] = (int_scalefac_comp - 244 )  % 3 ;0 		new_slen[2] = 0 ;  		new_slen[3] = 0;.                 si->ch[ch].gr[gr].preflag = 0;                  blocknumber = 5;  	         };      }      u/      for(i=0;i< 45;i++) scalefac_buffer[i] = 0;         k = 0;       for(i = 0;i < 4;i++)s      { .L       	for(j = 0; j < nr_of_sfb_block[blocknumber][blocktypenumber][i]; j++)	         {b            if(new_slen[i] == 0)b            {  	        scalefac_buffer[k] = 0;            }            elset            {   t9      	       scalefac_buffer[k] =  hgetbits(new_slen[i]);r            }            k++;t  s	         }i      }   };      ; void III_get_LSF_scale_factors(scalefac, si, gr, ch, fr_ps)e III_scalefac_t *scalefac;s III_side_info_t *si; int gr, ch;t frame_params *fr_ps; {s int sfb, i,k = 0, window;v1 struct gr_info_s *gr_info = &(si->ch[ch].gr[gr]);g  a9      III_get_LSF_scale_data(scalefac, si, gr, ch, fr_ps);a    H     if (gr_info->window_switching_flag && (gr_info->block_type == 2)) { %       if (gr_info->mixed_block_flag) oN       {                                       /* MIXED */ /* NEW - ag 11/25 */&          for (sfb = 0; sfb < 8; sfb++)
          {:               (*scalefac)[ch].l[sfb] = scalefac_buffer[k];               k++;          } b'          for (sfb = 3; sfb < 12; sfb++) .             for (window=0; window<3; window++)
             {cC                (*scalefac)[ch].s[window][sfb] = scalefac_buffer[k];                 k++;i
             } 5             for (sfb=12,window=0; window<3; window++) 8                      (*scalefac)[ch].s[window][sfb] = 0;          }        else {  /* SHORT*/[)            for (sfb = 0; sfb < 12; sfb++) 1                for (window=0; window<3; window++)c                {F                   (*scalefac)[ch].s[window][sfb] = scalefac_buffer[k];                   k++;                }8                for (sfb=12,window=0; window<3; window++)F                                    (*scalefac)[ch].s[window][sfb] = 0;       }      }           #     else {   /* LONG types 0,1,3 */   )            for (sfb = 0; sfb < 21; sfb++),
             { >                   (*scalefac)[ch].l[sfb] = scalefac_buffer[k];                    k++;8
             }8'             (*scalefac)[ch].l[22] = 0; {        1     }, }5        /* Already declared in huffman.c struct huffcodetab ht[HTN];, */  int huffman_initialized = FALSE;   void initialize_huffman() {8    FILE *fi;   #    if (huffman_initialized) return;,+    if (!(fi = OpenTableFile("huffdec") )) {67       printf("Please check huffman table 'huffdec'\n");4       exit(1);    }      if (fi==NULL) {  3       fprintf(stderr,"decoder table open error\n");          exit(3);         }8  '    if (read_decoder_table(fi) != HTN) {03       fprintf(stderr,"decoder table read error\n");6       exit(4);       }2 huffman_initialized = TRUE;  }   5 III_hufman_decode(is, si, ch, gr, part2_start, fr_ps), long int is[SBLIMIT][SSLIMIT]; III_side_info_t *si; int gr, ch, part2_start; frame_params *fr_ps; {c    int i, x, y;,    int v, w;    struct huffcodetab *h;c    int region1Start;    int region2Start;
    int sfreq;;    int currentBit, grBits;    my_gr_info *gi;_    int bt = (*si).ch[ch].gr[gr].window_switching_flag && ((*si).ch[ch].gr[gr].block_type == 2);=  ,    gi = (my_gr_info *) &(*si).ch[ch].gr[gr];L    sfreq = fr_ps->header->sampling_frequency + (fr_ps->header->version * 3);    initialize_huffman();  3    /* Find region boundary for short block case. */>    f7    if ( ((*si).ch[ch].gr[gr].window_switching_flag) &&  2         ((*si).ch[ch].gr[gr].block_type == 2) ) {             /* Region2. *//         region1Start = 36;  /* sfb[9/3]*3=36 */]B         region2Start = 576; /* No Region2 for short block case. */    }B    else {          /* Find region boundary for long block case. */  '       region1Start = sfBandIndex[sfreq] N                            .l[(*si).ch[ch].gr[gr].region0_count + 1]; /* MI */'       region2Start = sfBandIndex[sfreq]lD                               .l[(*si).ch[ch].gr[gr].region0_count +N                               (*si).ch[ch].gr[gr].region1_count + 2]; /* MI */       };    A    grBits     = part2_start + (*si).ch[ch].gr[gr].part2_3_length;     currentBit = hsstell();      /* Read bigvalues area. */ 8    for (i=0; i<(*si).ch[ch].gr[gr].big_values*2; i+=2) {L       if      (i<region1Start) h = &ht[(*si).ch[ch].gr[gr].table_select[0]];L       else if (i<region2Start) h = &ht[(*si).ch[ch].gr[gr].table_select[1]];L            else                h = &ht[(*si).ch[ch].gr[gr].table_select[2]];)       huffman_decoder(h, &x, &y, &v, &w);s#       is[i/SSLIMIT][i%SSLIMIT] = x;s+       is[(i+1)/SSLIMIT][(i+1)%SSLIMIT] = y;f       }b  A    grBits     = part2_start + (*si).ch[ch].gr[gr].part2_3_length;     currentBit = hsstell();      /* Read count1 area. */6    h = &ht[(*si).ch[ch].gr[gr].count1table_select+32];L    while ((hsstell() < part2_start + (*si).ch[ch].gr[gr].part2_3_length ) &&      ( i < SSLIMIT*SBLIMIT )) { )       huffman_decoder(h, &x, &y, &v, &w);1#       is[i/SSLIMIT][i%SSLIMIT] = v; +       is[(i+1)/SSLIMIT][(i+1)%SSLIMIT] = w;1+       is[(i+2)/SSLIMIT][(i+2)%SSLIMIT] = x; +       is[(i+3)/SSLIMIT][(i+3)%SSLIMIT] = y;1
       i += 4;5       },  A    grBits     = part2_start + (*si).ch[ch].gr[gr].part2_3_length;}    currentBit = hsstell();  D    if (hsstell() > part2_start + (*si).ch[ch].gr[gr].part2_3_length)    {  i -=4;N       rewindNbits(hsstell()-part2_start - (*si).ch[ch].gr[gr].part2_3_length);    }      /* Dismiss stuffing Bits */A    grBits     = part2_start + (*si).ch[ch].gr[gr].part2_3_length;j    currentBit = hsstell();    if ( currentBit < grBits )t&       hgetbits( grBits - currentBit );      /* Zero out rest. */p!    for (; i<SSLIMIT*SBLIMIT; i++) #       is[i/SSLIMIT][i%SSLIMIT] = 0;c }f    ? int pretab[22] = {0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,3,3,3,2,0};   < void III_dequantize_sample(is,xr,scalefac,gr_info, ch,fr_ps) long int is[SBLIMIT][SSLIMIT]; double xr[SBLIMIT][SSLIMIT]; struct gr_info_s *gr_info; III_scalefac_t *scalefac;= frame_params *fr_ps; int ch;a {=    int ss,sb,cb=0,sfreq;    int stereo = fr_ps->stereo;2    int next_cb_boundary, cb_begin, cb_width, sign;  J    sfreq=fr_ps->header->sampling_frequency + (fr_ps->header->version * 3);  K    /* choose correct scalefactor band per block type, initalize boundary */s  E    if (gr_info->window_switching_flag && (gr_info->block_type == 2) )	%       if (gr_info->mixed_block_flag)  L          next_cb_boundary=sfBandIndex[sfreq].l[1];  /* LONG blocks: 0,1,3 */       else {K          next_cb_boundary=sfBandIndex[sfreq].s[1]*3; /* pure SHORT block */m'     cb_width = sfBandIndex[sfreq].s[1];(     cb_begin = 0;)	       }  ;    else I       next_cb_boundary=sfBandIndex[sfreq].l[1];  /* LONG blocks: 0,1,3 */i  %    /* apply formula per block type */   #    for (sb=0 ; sb < SBLIMIT ; sb++)e(       for (ss=0 ; ss < SSLIMIT ; ss++) {  T          if ( (sb*18)+ss == next_cb_boundary)  { /* Adjust critical band boundary */O             if (gr_info->window_switching_flag && (gr_info->block_type == 2)) {.0                if (gr_info->mixed_block_flag)  {A                   if (((sb*18)+ss) == sfBandIndex[sfreq].l[8])  {xA                      next_cb_boundary=sfBandIndex[sfreq].s[4]*3; e                      cb = 3;=                      cb_width = sfBandIndex[sfreq].s[cb+1] - a9                                 sfBandIndex[sfreq].s[cb];mA                      cb_begin = sfBandIndex[sfreq].s[cb]*3;      _                   }aC                   else if (((sb*18)+ss) < sfBandIndex[sfreq].l[8]) [G                      next_cb_boundary = sfBandIndex[sfreq].l[(++cb)+1];                    else {I                      next_cb_boundary = sfBandIndex[sfreq].s[(++cb)+1]*3;;=                      cb_width = sfBandIndex[sfreq].s[cb+1] - e=                                     sfBandIndex[sfreq].s[cb];;A                      cb_begin = sfBandIndex[sfreq].s[cb]*3;      l                   }                   }                else  {F                   next_cb_boundary = sfBandIndex[sfreq].s[(++cb)+1]*3;:                   cb_width = sfBandIndex[sfreq].s[cb+1] - 8                                sfBandIndex[sfreq].s[cb];<                 cb_begin = sfBandIndex[sfreq].s[cb]*3;                      }  
             } "             else /* long blocks */A                next_cb_boundary = sfBandIndex[sfreq].l[(++cb)+1];0
          }  0          /* Compute overall (global) scaling. */  J          xr[sb][ss] = pow( 2.0 , (0.25 * (gr_info->global_gain - 210.0)));  :          /* Do long/short dependent scaling operations. */         0          if (gr_info->window_switching_flag && (O             ((gr_info->block_type == 2) && (gr_info->mixed_block_flag == 0)) ||tW             ((gr_info->block_type == 2) && gr_info->mixed_block_flag && (sb >= 2)) )) {f  1             xr[sb][ss] *= pow(2.0, 0.25 * -8.0 *  P                     gr_info->subblock_gain[(((sb*18)+ss) - cb_begin)/cb_width]);N             xr[sb][ss] *= pow(2.0, 0.25 * -2.0 * (1.0+gr_info->scalefac_scale)K               * (*scalefac)[ch].s[(((sb*18)+ss) - cb_begin)/cb_width][cb]);x
          }R          else {   /* LONG block types 0,1,3 & 1st 2 subbands of switched blocks */G             xr[sb][ss] *= pow(2.0, -0.5 * (1.0+gr_info->scalefac_scale)l@                                         * ((*scalefac)[ch].l[cb]J                                         + gr_info->preflag * pretab[cb]));
          }  %          /* Scale quantized value. */(         (          sign = (is[sb][ss]<0) ? 1 : 0; J          xr[sb][ss] *= pow( (double) abs(is[sb][ss]), ((double)4.0/3.0) );,          if (sign) xr[sb][ss] = -xr[sb][ss];       }] }w  % III_reorder (xr, ro, gr_info, fr_ps)   double xr[SBLIMIT][SSLIMIT]; ( double ro[SBLIMIT][SSLIMIT];   struct gr_info_s *gr_info; frame_params *fr_ps; { 
    int sfreq; !    int sfb, sfb_start, sfb_lines;d0    int sb, ss, window, freq, src_line, des_line;  J    sfreq=fr_ps->header->sampling_frequency + (fr_ps->header->version * 3);      for(sb=0;sb<SBLIMIT;sb++)        for(ss=0;ss<SSLIMIT;ss++)           ro[sb][ss] = 0;  F    if (gr_info->window_switching_flag && (gr_info->block_type == 2)) {&       if (gr_info->mixed_block_flag) {,          /* NO REORDER FOR LOW 2 SUBBANDS */#          for (sb=0 ; sb < 2 ; sb++)+.             for (ss=0 ; ss < SSLIMIT ; ss++) {'                ro[sb][ss] = xr[sb][ss]; 
             }a1          /* REORDERING FOR REST SWITCHED SHORT */ 5          for(sfb=3,sfb_start=sfBandIndex[sfreq].s[3],f;             sfb_lines=sfBandIndex[sfreq].s[4] - sfb_start; n@             sfb < 13; sfb++,sfb_start=sfBandIndex[sfreq].s[sfb],@             (sfb_lines=sfBandIndex[sfreq].s[sfb+1] - sfb_start))0                for(window=0; window<3; window++)5                   for(freq=0;freq<sfb_lines;freq++) { G                      src_line = sfb_start*3 + window*sfb_lines + freq;  B                      des_line = (sfb_start*3) + window + (freq*3);>                      ro[des_line/SSLIMIT][des_line%SSLIMIT] = K                                     xr[src_line/SSLIMIT][src_line%SSLIMIT];a                }       }        else {  /* pure short */B          for(sfb=0,sfb_start=0,sfb_lines=sfBandIndex[sfreq].s[1]; @             sfb < 13; sfb++,sfb_start=sfBandIndex[sfreq].s[sfb],@             (sfb_lines=sfBandIndex[sfreq].s[sfb+1] - sfb_start))0                for(window=0; window<3; window++)5                   for(freq=0;freq<sfb_lines;freq++) {_G                      src_line = sfb_start*3 + window*sfb_lines + freq; lB                      des_line = (sfb_start*3) + window + (freq*3);>                      ro[des_line/SSLIMIT][des_line%SSLIMIT] = K                                     xr[src_line/SSLIMIT][src_line%SSLIMIT];2                }       }=    }    else {   /*long blocks */&       for (sb=0 ; sb < SBLIMIT ; sb++)*          for (ss=0 ; ss < SSLIMIT ; ss++) $             ro[sb][ss] = xr[sb][ss];    } }/  0 static void III_i_stereo_k_values(is_pos,io,i,k)
 double io;
 int is_pos,i;i double FAR k[2][576];_
            {M    if(is_pos == 0)    { s       k[0][i] = 1;       k[1][i] = 1;    }    else if ((is_pos % 2) == 1)    {1       k[0][i] = pow(io,(double)((is_pos + 1)/2));[       k[1][i] = 1;    }    else     {       k[0][i] = 1;+       k[1][i] = pow(io,(double)(is_pos/2));e    } }     1 void III_stereo(xr, lr, scalefac, gr_info, fr_ps)* double xr[2][SBLIMIT][SSLIMIT];r double lr[2][SBLIMIT][SSLIMIT];  III_scalefac_t *scalefac;= struct gr_info_s *gr_info; frame_params *fr_ps; {e
    int sfreq;t    int stereo = fr_ps->stereo;B    int ms_stereo = (fr_ps->header->mode == MPG_MD_JOINT_STEREO) &&4                    (fr_ps->header->mode_ext & 0x2); A    int i_stereo = (fr_ps->header->mode == MPG_MD_JOINT_STEREO) &&(2                   (fr_ps->header->mode_ext & 0x1);R    int js_bound;  /* frequency line that marks the beggining of the zero part */      int sfb,next_sfb_boundary;a    int i,j,sb,ss,ch;"    short is_pos[SBLIMIT*SSLIMIT]; $    double is_ratio[SBLIMIT*SSLIMIT];
    double io;.$    double FAR k[2][SBLIMIT*SSLIMIT];  9    int lsf	= (fr_ps->header->version == MPEG_PHASE2_LSF);&  /     if(  (gr_info->scalefac_compress % 2) == 1)s      {#        io = (double)0.707106781188;s      }	      else2      {#        io = (double)0.840896415256;3      }    J    sfreq=fr_ps->header->sampling_frequency + (fr_ps->header->version * 3);         /* intialization */&    for ( i=0; i<SBLIMIT*SSLIMIT; i++ )       is_pos[i] = 7;  "    if ((stereo == 2) && i_stereo )G    {  if (gr_info->window_switching_flag && (gr_info->block_type == 2))a(       {  if( gr_info->mixed_block_flag )          {  int max_sfb = 0;  !             for ( j=0; j<3; j++ )t             {  int sfbcnt;                sfbcnt = 2;,                for( sfb=12; sfb >=3; sfb-- )                {  int lines;P                   lines = sfBandIndex[sfreq].s[sfb+1]-sfBandIndex[sfreq].s[sfb];F                   i = 3*sfBandIndex[sfreq].s[sfb] + (j+1) * lines - 1;%                   while ( lines > 0 )s>                   {  if ( xr[1][i/SSLIMIT][i%SSLIMIT] != 0.0 )%                      {  sfbcnt = sfb;o"                         sfb = -10;$                         lines = -10;                      }                      lines--;e                      i--;r                   },                }                 sfb = sfbcnt + 1;  #                if ( sfb > max_sfb )/                    max_sfb = sfb;                  while( sfb<12 )M                {  sb = sfBandIndex[sfreq].s[sfb+1]-sfBandIndex[sfreq].s[sfb]; ;                   i = 3*sfBandIndex[sfreq].s[sfb] + j * sb;d'                   for ( ; sb > 0; sb--)c:                   {  is_pos[i] = (*scalefac)[1].s[j][sfb];*                      if ( is_pos[i] != 7 )"                          if( lsf )                          {F                               III_i_stereo_k_values(is_pos[i],io,i,k);                          }                          elsey                          {N                              is_ratio[i] = tan((double)is_pos[i] * (PI / 12));                          }                      i++;d                   }                    sfb++;                }  F                sb = sfBandIndex[sfreq].s[12]-sfBandIndex[sfreq].s[11];9                sfb = 3*sfBandIndex[sfreq].s[11] + j * sb;eF                sb = sfBandIndex[sfreq].s[13]-sfBandIndex[sfreq].s[12];  7                i = 3*sfBandIndex[sfreq].s[11] + j * sb; %                for ( ; sb > 0; sb-- )-*                {  is_pos[i] = is_pos[sfb];.                   is_ratio[i] = is_ratio[sfb];&                   k[0][i] = k[0][sfb];&                   k[1][i] = k[1][sfb];                   i++;                }              }               if ( max_sfb <= 3 )              {  i = 2;                 ss = 17;                 sb = -1;                  while ( i >= 0 )-                 {  if ( xr[1][i][ss] != 0.0 )c#                    {  sb = i*18+ss;-                       i = -1;                     } elses                    {  ss--;c#                       if ( ss < 0 )                        {  i--; !                          ss = 17;s                       }e                    }                 }c                 i = 0;7                 while ( sfBandIndex[sfreq].l[i] <= sb )                     i++;I                 sfb = i;,                 i = sfBandIndex[sfreq].l[i];&                 for ( ; sfb<8; sfb++ )N                 {  sb = sfBandIndex[sfreq].l[sfb+1]-sfBandIndex[sfreq].l[sfb];(                    for ( ; sb > 0; sb--)8                    {  is_pos[i] = (*scalefac)[1].l[sfb];+                       if ( is_pos[i] != 7 )-#                          if ( lsf )/                          {F                               III_i_stereo_k_values(is_pos[i],io,i,k);                          }                          elsef                          {N                              is_ratio[i] = tan((double)is_pos[i] * (PI / 12));                          }                       i++;                    }                 }s
             }(          } elsee!          {  for ( j=0; j<3; j++ )]             {  int sfbcnt;                sfbcnt = -1;l,                for( sfb=12; sfb >=0; sfb-- )                {  int lines;P                   lines = sfBandIndex[sfreq].s[sfb+1]-sfBandIndex[sfreq].s[sfb];F                   i = 3*sfBandIndex[sfreq].s[sfb] + (j+1) * lines - 1;%                   while ( lines > 0 ) >                   {  if ( xr[1][i/SSLIMIT][i%SSLIMIT] != 0.0 )%                      {  sfbcnt = sfb;l"                         sfb = -10;$                         lines = -10;                      }                      lines--;                       i--;u                   }                 }                 sfb = sfbcnt + 1;                while( sfb<12 )M                {  sb = sfBandIndex[sfreq].s[sfb+1]-sfBandIndex[sfreq].s[sfb];r;                   i = 3*sfBandIndex[sfreq].s[sfb] + j * sb;a'                   for ( ; sb > 0; sb--)b:                   {  is_pos[i] = (*scalefac)[1].s[j][sfb];*                      if ( is_pos[i] != 7 )"                          if( lsf )                          {F                               III_i_stereo_k_values(is_pos[i],io,i,k);                          }                          elseb                          {O                              is_ratio[i] = tan( (double)is_pos[i] * (PI / 12));                           }                      i++;                    })                   sfb++;                }  F                sb = sfBandIndex[sfreq].s[12]-sfBandIndex[sfreq].s[11];9                sfb = 3*sfBandIndex[sfreq].s[11] + j * sb; F                sb = sfBandIndex[sfreq].s[13]-sfBandIndex[sfreq].s[12];  7                i = 3*sfBandIndex[sfreq].s[11] + j * sb; %                for ( ; sb > 0; sb-- )-*                {  is_pos[i] = is_pos[sfb];.                   is_ratio[i] = is_ratio[sfb];&                   k[0][i] = k[0][sfb];&                   k[1][i] = k[1][sfb];                   i++;                }
             }b
          }       } else       {  i = 31;          ss = 17;e          sb = 0;          while ( i >= 0 ) &          {  if ( xr[1][i][ss] != 0.0 )             {  sb = i*18+ss;                i = -1;             } else             {  ss--;                if ( ss < 0 )                {  i--;                   ss = 17;                }
             }s
          }          i = 0;s0          while ( sfBandIndex[sfreq].l[i] <= sb )             i++;          sfb = i;+%          i = sfBandIndex[sfreq].l[i];f           for ( ; sfb<21; sfb++ )I          {  sb = sfBandIndex[sfreq].l[sfb+1] - sfBandIndex[sfreq].l[sfb]; !             for ( ; sb > 0; sb--)d1             {  is_pos[i] = (*scalefac)[1].l[sfb];L$                if ( is_pos[i] != 7 )                      if( lsf )                      {C                            III_i_stereo_k_values(is_pos[i],io,i,k);k                      }                      else                       {K                           is_ratio[i] = tan((double)is_pos[i] * (PI / 12));I                      }                i++;;
             }i
          }(          sfb = sfBandIndex[sfreq].l[20];B          for ( sb = 576 - sfBandIndex[sfreq].l[21]; sb > 0; sb-- )$          {  is_pos[i] = is_pos[sfb];(             is_ratio[i] = is_ratio[sfb];              k[0][i] = k[0][sfb];              k[1][i] = k[1][sfb];             i++;
          }       })    }      for(ch=0;ch<2;ch++)       for(sb=0;sb<SBLIMIT;sb++)s#          for(ss=0;ss<SSLIMIT;ss++)               lr[ch][sb][ss] = 0;       if (stereo==2)        for(sb=0;sb<SBLIMIT;sb++) $          for(ss=0;ss<SSLIMIT;ss++) {             i = (sb*18)+ss;e#             if ( is_pos[i] == 7 ) {e!                if ( ms_stereo ) { S                   lr[0][sb][ss] = (xr[0][sb][ss]+xr[1][sb][ss])/(double)1.41421356;rS                   lr[1][sb][ss] = (xr[0][sb][ss]-xr[1][sb][ss])/(double)1.41421356;;                }                else {t0                   lr[0][sb][ss] = xr[0][sb][ss];0                   lr[1][sb][ss] = xr[1][sb][ss];                }
             } !             else if (i_stereo ) {;                 if ( lsf )                 {L:                   lr[0][sb][ss] = xr[0][sb][ss] * k[0][i];;                   lr[1][sb][ss] = xr[0][sb][ss] * k[1][i];                   }                 else8                 {sP                   lr[0][sb][ss] = xr[0][sb][ss] * (is_ratio[i]/(1+is_ratio[i]));G                   lr[1][sb][ss] = xr[0][sb][ss] * (1/(1+is_ratio[i])); l                 }(
             }*             else {5                printf("Error in streo processing\n"); 
             }f
          }2    else  /* mono , bypass xr[0][][] to lr[0][][]*/       for(sb=0;sb<SBLIMIT;sb++))"          for(ss=0;ss<SSLIMIT;ss++)*             lr[0][sb][ss] = xr[0][sb][ss];   }i  F double Ci[8]={-0.6,-0.535,-0.33,-0.185,-0.095,-0.041,-0.0142,-0.0037};    0 void III_antialias(xr, hybridIn, gr_info, fr_ps)  double xr[SBLIMIT][SSLIMIT];    " double hybridIn[SBLIMIT][SSLIMIT];' struct gr_info_s *gr_info;             ]  frame_params *fr_ps;             {     static int    init = 1;    static double ca[8],cs[8];r?    double        bu,bd;  /* upper and lower butterfly inputs */t    int           ss,sb,sblim;       if (init) {       int i;       double    sq;        for (i=0;i<8;i++) { "          sq=sqrt(1.0+Ci[i]*Ci[i]);          cs[i] = 1.0/sq;          ca[i] = Ci[i]/sq;       }        init = 0;b    }         /* clear all inputs */  _            for(sb=0;sb<SBLIMIT;sb++);         for(ss=0;ss<SSLIMIT;ss++)(           hybridIn[sb][ss] = xr[sb][ss];  G    if  (gr_info->window_switching_flag && (gr_info->block_type == 2) &&[+        !gr_info->mixed_block_flag ) return;o  F    if ( gr_info->window_switching_flag && gr_info->mixed_block_flag &&       (gr_info->block_type == 2))       sblim = 1;    else        sblim = SBLIMIT-1;  E    /* 31 alias-reduction operations between each pair of sub-bands */vE    /* with 8 butterflies between each pair                         */       for(sb=0;sb<sblim;sb++)    !       for(ss=0;ss<8;ss++) {                 bu = xr[sb][17-ss];          bd = xr[sb+1][ss]; =          hybridIn[sb][17-ss] = (bu * cs[ss]) - (bd * ca[ss]); <          hybridIn[sb+1][ss] = (bd * cs[ss]) + (bu * ca[ss]);          }   }n  " void inv_mdct(in, out, block_type) double in[18]; double out[36];n int block_type;1 { F /*------------------------------------------------------------------*/F /*                                                                  */F /*    Function: Calculation of the inverse MDCT                     */F /*    In the case of short blocks the 3 output vectors are already  */F /*    overlapped and added in this modul.                           */F /*                                                                  */F /*    New layer3                                                    */F /*                                                                  */F /*------------------------------------------------------------------*/   int     k,i,m,N,p; double  tmp[12],sum; static  double  win[4][36];{ static  int init=0;  static  double COS[4*36];        if(init==0){       /* type 0 */       for(i=0;i<36;i++) +          win[0][i] = sin( PI/36 *(i+0.5) );}       /* type 1*/c       for(i=0;i<18;i++) +          win[1][i] = sin( PI/36 *(i+0.5) );i       for(i=18;i<24;i++)          win[1][i] = 1.0;        for(i=24;i<30;i++).          win[1][i] = sin( PI/12 *(i+0.5-18) );       for(i=30;i<36;i++)          win[1][i] = 0.0;n       /* type 3*/-       for(i=0;i<6;i++)          win[3][i] = 0.0;(       for(i=6;i<12;i++) -          win[3][i] = sin( PI/12 *(i+0.5-6) );;       for(i=12;i<18;i++)          win[3][i] =1.0;       for(i=18;i<36;i++)*          win[3][i] = sin( PI/36*(i+0.5) );       /* type 2*/        for(i=0;i<12;i++)s+          win[2][i] = sin( PI/12*(i+0.5) ) ;        for(i=12;i<36;i++)          win[2][i] = 0.0 ;         for (i=0; i<4*36; i++)%          COS[i] = cos(PI/(2*36) * i);*  
       init++;      }        for(i=0;i<36;i++)         out[i]=0;       if(block_type == 2){        N=12;        for(i=0;i<3;i++){           for(p= 0;p<N;p++){              sum = 0.0;               for(m=0;m<N/2;m++)bG                 sum += in[i+3*m] * cos( PI/(2*N)*(2*p+1+N/2)*(2*m+1) );{0              tmp[p] = sum * win[block_type][p] ;           }b           for(p=0;p<N;p++)$              out[6*i+p+6] += tmp[p];        }     } 	     else{e       N=36;        for(p= 0;p<N;p++){          sum = 0.0;           for(m=0;m<N/2;m++)i<            sum += in[m] * COS[((2*p+1+N/2)*(2*m+1))%(4*36)];+          out[p] = sum * win[block_type][p];        }      }  }1  4 void III_hybrid(fsIn, tsOut ,sb, ch, gr_info, fr_ps)9 double fsIn[SSLIMIT];   /* freq samples per subband in */ : double tsOut[SSLIMIT];  /* time samples per subband out */ int sb, ch;2' struct gr_info_s *gr_info;             r  frame_params *fr_ps;             {]
    int ss;    double rawout[36];n/    static double prevblck[2][SBLIMIT][SSLIMIT];o    static int init = 1; 
    int bt;      if (init) {       int i,j,k;              for(i=0;i<2;i++)          for(j=0;j<SBLIMIT;j++) "             for(k=0;k<SSLIMIT;k++)%                prevblck[i][j][k]=0.0;        init = 0;k    }  G    bt = (gr_info->window_switching_flag && gr_info->mixed_block_flag &&e/           (sb < 2)) ? 0 : gr_info->block_type;        inv_mdct( fsIn, rawout, bt);u      /* overlap addition */      for(ss=0; ss<SSLIMIT; ss++) {4       tsOut[ss] = rawout[ss] + prevblck[ch][sb][ss];+       prevblck[ch][sb][ss] = rawout[ss+18];     } }   @ /* Return the number of slots for main data of current frame, */   int main_data_slots(fr_ps) frame_params fr_ps;  {int nSlots;  R    nSlots = (144 * bitrate[fr_ps.header->version][2][fr_ps.header->bitrate_index])G 	    / s_freq[fr_ps.header->version][fr_ps.header->sampling_frequency]; 3   if ( fr_ps.header->version != MPEG_PHASE2_LSF ) {s=        if (fr_ps.stereo == 1) nSlots -= 17; else nSlots -=32;b   }    else   {        nSlots = nSlots / 2;;       if (fr_ps.stereo == 1) nSlots -= 9; else nSlots -=17;    }   &   if (fr_ps.header->padding) nSlots++;       nSlots -= 4;2   if (fr_ps.header->error_protection) nSlots -= 2;     return(nSlots);  } 