G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) H  * ISO 13818-3 MPEG-2 Audio Decoder - Lower Sampling Frequency Extension  *9  * $Id: common.h,v 1.3 1996/03/28 03:13:37 rowlands Exp $   *  * $Log: common.h,v $ .  * Revision 1.3  1996/03/28 03:13:37  rowlands*  * Merged layers 1-2 and layer 3 revisions  *.  * Revision 1.2  1996/02/14 05:18:36  rowlands  * Cleanups.  *.  * Revision 1.1  1996/02/14 03:45:52  rowlands  * Initial revision   *  * Received from FhGH  **********************************************************************/G /********************************************************************** G  *   date   programmers         comment                               * G  * 2/25/91  Doulas Wong,        start of version 1.0 records          * G  *          Davis Pan                                                 * G  * 5/10/91  W. Joseph Carter    Reorganized & renamed all ".h" files  * G  *                              into "common.h" and "encoder.h".      * G  *                              Ported to Macintosh and Unix.         * G  *                              Added additional type definitions for * G  *                              AIFF, double/SANE and "bitstream.c".  * G  *                              Added function prototypes for more    * G  *                              rigorous type checking.               * G  * 27jun91  dpwe (Aware)        Added "alloc_*" defs & prototypes     * G  *                              Defined new struct 'frame_params'.    * G  *                              Changed info.stereo to info.mode_ext  * G  *                              #define constants for mode types      * G  *                              Prototype arguments if PROTO_ARGS     * G  * 5/28/91  Earle Jennings      added MS_DOS definition               * G  *                              MsDos function prototype declarations * G  * 7/10/91  Earle Jennings      added FLOAT definition as double      * G  *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  *                              Modified some function prototypes.    * G  *                              Changed BUFFER_SIZE back to 4096.     * G  * 7/27/92  Michael Li          (re-)Ported to MS-DOS                 * G  * 7/27/92  Masahiro Iwadare    Ported to Convex                      * G  * 8/07/92  mc@tv.tek.com                                             * G  * 8/10/92  Amit Gulati         Ported to the AIX Platform (RS6000)   * G  *                              AIFF string constants redefined       * G  * 8/27/93 Seymour Shlien,      Fixes in Unix and MSDOS ports,        * G  *         Daniel Lauzon, and                                         * G  *         Bill Truerniet                                             * G  *--------------------------------------------------------------------* G  * 4/23/92  J. Pineda           Added code for Layer III.             * G  * 11/9/92  Amit Gulati         Added defines for layerIII stereo     * G  *                              modes.                                * G  *  8/24/93 Masahiro Iwadare    Included IS modification in Layer III.* G  *                              Changed for 1 pass decoding.          * G  *  9/07/93 Toshiyuki Ishino    Integrated Layer III with Ver 3.9.    * G  *--------------------------------------------------------------------* G  * 11/20/93 Masahiro Iwadare    Integrated Layer III with Ver 4.0.    * G  *--------------------------------------------------------------------* G  *  7/14/94 Juergen Koller      Fix for HPUX an IRIX in AIFF-Strings  * G  *--------------------------------------------------------------------* G  *  6/12/95 Soeren H. Nielsen   Bug fix in new_ext().                 * G  *  7/11/95 Soeren H. Nielsen   Added defs. for MPEG-2 LSF            * G  *--------------------------------------------------------------------* @  *          Roland Bitto	Adapted to MPEG2 low sampling rate    *H  **********************************************************************/   #ifndef COMMON_H #define COMMON_H  H /*********************************************************************** * & *  Global Conditional Compile Switches * H ***********************************************************************/  E /* #define      UNIX            /* Unix conditional compile switch */ J /* #define      MACINTOSH       /* Macintosh conditional compile switch */G /* #define      MS_DOS          /* IBM PC conditional compile switch */ G /* #define      MSC60           /* Compiled for MS_DOS with MSC v6.0 */ G /* #define      AIX             /* AIX conditional compile switch    */ G /* #define      CONVEX          /* CONVEX conditional compile switch */    #if defined(MSC60)   #ifndef MS_DOS #define MS_DOS #endif #ifndef PROTO_ARGS #define PROTO_ARGS #endif #endif   #ifdef  UNIXB #define         TABLES_PATH     "tables"  /* to find data files */> /* name of environment variable holding path of table files */, #define         MPEGTABENV      "MPEGTABLES"C #define         PATH_SEPARATOR  "/"        /* how to build paths */  #endif  /* UNIX */   #ifdef  MACINTOSH C #define      TABLES_PATH ":tables:"  /* where to find data files */  #endif  /* MACINTOSH */    /*  A  * Don't define FAR to far unless you're willing to clean up the  
  * prototypes   */  #define FAR /*far*/    #ifdef __STDC__  #ifndef PROTO_ARGS #define PROTO_ARGS   #endif #endif  
 #ifdef CONVEX  #define SEEK_SET        0  #define SEEK_CUR        1  #define SEEK_END        2  #endif  J /* MS_DOS and VMS do not define TABLES_PATH, so OpenTableFile will default8    to finding the data files in the default directory */  H /*********************************************************************** *  *  Global Include Files  * H ***********************************************************************/   #include        <stdio.h>  #include        <string.h> #include        <math.h> #include "ieeefloat.h" #include "portableio.h"    #ifdef  UNIX #include        <unistd.h> #endif  /* UNIX */   #ifdef __sgi #include	<stdlib.h>  #endif   #ifdef  MACINTOSH  #include        <stdlib.h> #include        <console.h>  #endif  /* MACINTOSH */    #ifdef  MS_DOS #include        <stdlib.h> #ifdef MSC60 #include        <memory.h> #else  #include        <alloc.h>  #include        <mem.h>  #endif  /* MSC60 */  #endif  /* MS_DOS */  H /*********************************************************************** *  *  Global Definitions  * H ***********************************************************************/   /* General Definitions */    #ifdef  MS_DOS. #define         FLOAT                   double #else - #define         FLOAT                   float  #endif  ) #define         FALSE                   0 ) #define         TRUE                    1 , #define         NULL_CHAR               '\0'  2 #define         MAX_U_32_NUM            0xFFFFFFFF
 #ifndef PI8 #define         PI                      3.14159265358979 #endif  , #define         PI4                     PI/4- #define         PI64                    PI/64 4 #define         LN_TO_LOG10             0.2302585093  ) #define         VOL_REF_NUM             0 * #define         MAC_WINDOW_SIZE         24  ) #define         MONO                    1 ) #define         STEREO                  2 ) #define         BITS_IN_A_BYTE          8 * #define         WORD                    16* #define         MAX_NAME_SIZE           81* #define         SBLIMIT                 32* #define         SSLIMIT                 18, #define         FFT_SIZE                1024+ #define         HAN_SIZE                512n* #define         SCALE_BLOCK             12* #define         SCALE_RANGE             64- #define         SCALE                   32768 . #define         CRC16_POLYNOMIAL        0x8005  - /* MPEG Header Definitions - ID Bit Values */o) #define         MPEG_AUDIO_ID           110 #define		MPEG_PHASE2_LSF		0	/* 1995-07-11 SHN */  + /* MPEG Header Definitions - Mode Values */*  ) #define         MPG_MD_STEREO           0*) #define         MPG_MD_JOINT_STEREO     1*) #define         MPG_MD_DUAL_CHANNEL     2d) #define         MPG_MD_MONO             3    /* Mode Extention */  * #define         MPG_MD_LR_LR             0* #define         MPG_MD_LR_I              1* #define         MPG_MD_MS_LR             2* #define         MPG_MD_MS_I              3   /* AIFF Definitions */  + #define IFF_ID_FORM 0x464f524d /* "FORM" */ + #define IFF_ID_AIFF 0x41494646 /* "AIFF" */*+ #define IFF_ID_COMM 0x434f4d4d /* "COMM" */t+ #define IFF_ID_SSND 0x53534e44 /* "SSND" */ + #define IFF_ID_MPEG 0x4d504547 /* "MPEG" */     #define AIFF_FORM_HEADER_SIZE 12  #define AIFF_SSND_HEADER_SIZE 16    # typedef struct  blockAlign_struct {      unsigned long   offset;o     unsigned long   blockSize;
 } blockAlign;i  ! typedef struct  IFF_AIFF_struct {       short           numChannels;$     unsigned long   numSampleFrames;     short           sampleSize;      double          sampleRate;s     unsigned long   sampleType;      blockAlign      blkAlgn; } IFF_AIFF;t  G enum byte_order { order_unknown, order_bigEndian, order_littleEndian }; ' extern enum byte_order NativeByteOrder;t    /* "bit_stream.h" Definitions */  N #define         MINIMUM         4    /* Minimum size of the buffer in bytes */I #define         MAX_LENGTH      32   /* Maximum length of word written or1?                                         read from bit stream */*! #define         READ_MODE       0m! #define         WRITE_MODE      1 ! #define         ALIGNING        8t! #define         BINARY          0 ! #define         ASCII           1m #ifndef BS_FORMATvF #define         BS_FORMAT       ASCII /* BINARY or ASCII = 2x bytes */ #endif$ #define         BUFFER_SIZE     4096  7 #define         MIN(A, B)       ((A) < (B) ? (A) : (B)) 7 #define         MAX(A, B)       ((A) > (B) ? (A) : (B))   H /*********************************************************************** *  *  Global Type Definitions * H ***********************************************************************/ typedef struct {5             char    encoded_file_name[MAX_NAME_SIZE]; 5             char    decoded_file_name[MAX_NAME_SIZE];              int  need_aiff;m             int  need_esps;              int  topSb;                }Arguments_t;k  @ /* Structure for Reading Layer II Allocation Tables from File */   typedef struct {     unsigned int    steps;     unsigned int    bits;      unsigned int    group;     unsigned int    quant; } sb_alloc, *alloc_ptr;   . typedef sb_alloc        al_table[SBLIMIT][16];  " /* Header Information Structure */   typedef struct {     int version;     int lay;     int error_protection;2     int bitrate_index;     int sampling_frequency;t     int padding;     int extension;
     int mode;      int mode_ext;      int copyright;     int original;      int emphasis;  } layer, *the_layer;  C /* Parent Structure Interpreting some Frame Parameters in Header */-   typedef struct {<     layer       *header;        /* raw header information */J     int         actual_mode;    /* when writing IS, may forget if 0 chs */B     al_table    *alloc;         /* bit allocation table read in */?     int         tab_num;        /* number of table as loaded */a>     int         stereo;         /* 1 for mono, 2 for stereo */G     int         jsbound;        /* first band of joint stereo coding */I?     int         sblimit;        /* total number of sub bands */- } frame_params;-  5 /* Double and SANE Floating Point Type Definitions */y  ! typedef struct  IEEE_DBL_struct {-     unsigned long   hi;-     unsigned long   lo;- } IEEE_DBL;*  ! typedef struct  SANE_EXT_struct {      unsigned long   l1;n     unsigned long   l2;-     unsigned short  s1;- } SANE_EXT;-    % /* "bit_stream.h" Type Definitions */e  " typedef struct  bit_stream_struc {B     FILE        *pt;            /* pointer to bit stream device */7     unsigned char *buf;         /* bit stream buffer */-I     int         buf_size;       /* size of buffer (in number of bytes) */ ?     long        totbit;         /* bit counter of bit stream */*C     int         buf_byte_idx;   /* pointer to top byte in buffer */*N     int         buf_bit_idx;    /* pointer to top bit of top byte in buffer */K     int         mode;           /* bit stream open in read or write mode */*9     int         eob;            /* end of buffer index */ <     int         eobs;           /* end of bit stream flag */     char        format;c     2     /* format of file in rd mode (BINARY/ASCII) */ } Bit_stream_struc;   ! /* Layer III side information. */e typedef struct { 	unsigned part2_3_length;D 	unsigned big_values;* 	unsigned global_gain; 	unsigned scalefac_compress;  	unsigned window_switching_flag; 	unsigned block_type;E 	unsigned mixed_block_flag;* 	unsigned table_select[3]; 	unsigned subblock_gain[3];S 	unsigned region0_count; 	unsigned region1_count; 	unsigned preflag; 	unsigned scalefac_scale;A 	unsigned count1table_select;i } my_gr_info ;   typedef struct { 	unsigned main_data_begin; 	unsigned private_bits; 	 	struct {G 	    unsigned scfsi[4];  		struct gr_info_s { 			unsigned part2_3_length;o 			unsigned big_values;  			unsigned global_gain; 			unsigned scalefac_compress;" 			unsigned window_switching_flag; 			unsigned block_type;N 			unsigned mixed_block_flag;n 			unsigned table_select[3]; 			unsigned subblock_gain[3];o 			unsigned region0_count; 			unsigned region1_count; 			unsigned preflag; 			unsigned scalefac_scale;e 			unsigned count1table_select;E 			} gr[2]; 
 		} ch[2]; 	} III_side_info_t;d   /* Layer III scale factors. */   typedef struct {! 	int l[23];            /* [cb] */a) 	int s[3][13];         /* [window][cb] */a! 	} III_scalefac_t[2];  /* [ch] */   H /*********************************************************************** * ( *  Global Variable External Declarations **H ***********************************************************************/   extern char     *mode_names[5];n  extern char     *layer_names[3]; extern char	*version_names[2]; extern double   s_freq[2][4]; " extern int      bitrate[2][3][15]; extern double FAR multiple[64];u  H /*********************************************************************** *u) *  Global Function Prototype DeclarationsH * H ***********************************************************************/  8 /* The following functions are in the file "common.c" */   #ifdef  PROTO_ARGS, extern FILE           *OpenTableFile(char*);5 extern int            read_bit_alloc(int, al_table*);*0 extern int            pick_table(frame_params*);) extern int            js_bound(int, int);*1 extern void           hdr_to_frps(frame_params*);*5 extern void           WriteHdr(frame_params*, FILE*); L extern void           WriteBitAlloc(unsigned int[2][SBLIMIT], frame_params*,                         FILE*); : extern void           WriteScale(unsigned int[2][SBLIMIT],N                         unsigned int[2][SBLIMIT], unsigned int[2][3][SBLIMIT],.                         frame_params*, FILE*);C extern void           WriteSamples(int, unsigned int FAR [SBLIMIT], E                         unsigned int[SBLIMIT], frame_params*, FILE*); & extern int            NumericQ(char*);2 extern int            BitrateIndex(int, int, int);. extern int            SmpFrqIndex(long, int*);0 extern int            memcheck(char*, int, int);; extern void           FAR *mem_alloc(unsigned long, char*);I' extern void           mem_free(void**); < extern void           double_to_extended(double*, char[10]);< extern void           extended_to_double(char[10], double*);: extern int            aiff_read_headers(FILE*, IFF_AIFF*);5 extern int            aiff_seek_to_sound_data(FILE*); ; extern int            aiff_write_headers(FILE*, IFF_AIFF*);n7 extern int            refill_buffer(Bit_stream_struc*);L; extern void           empty_buffer(Bit_stream_struc*, int); G extern void           open_bit_stream_w(Bit_stream_struc*, char*, int); G extern void           open_bit_stream_r(Bit_stream_struc*, char*, int);1< extern void           close_bit_stream_r(Bit_stream_struc*);< extern void           close_bit_stream_w(Bit_stream_struc*);; extern void           alloc_buffer(Bit_stream_struc*, int); 9 extern void           desalloc_buffer(Bit_stream_struc*); @ extern void           back_track_buffer(Bit_stream_struc*, int);1 extern unsigned int   get1bit(Bit_stream_struc*); 6 extern void           put1bit(Bit_stream_struc*, int);9 extern unsigned long  look_ahead(Bit_stream_struc*, int);D6 extern unsigned long  getbits(Bit_stream_struc*, int);D extern void           putbits(Bit_stream_struc*, unsigned int, int);M extern void           byte_ali_putbits(Bit_stream_struc*, unsigned int, int);M? extern unsigned long  byte_ali_getbits(Bit_stream_struc*, int);E0 extern unsigned long  sstell(Bit_stream_struc*);0 extern int            end_bs(Bit_stream_struc*);> extern int            seek_sync(Bit_stream_struc*, long, int);I extern void           I_CRC_calc(frame_params*, unsigned int[2][SBLIMIT],e'                         unsigned int*); J extern void           II_CRC_calc(frame_params*, unsigned int[2][SBLIMIT],A                         unsigned int[2][SBLIMIT], unsigned int*);oL extern void           update_CRC(unsigned int, unsigned int, unsigned int*);/ extern void           read_absthr(FLOAT*, int); * extern unsigned int   hget1bit(); /* MI */$ extern unsigned long  hgetbits(int);  extern unsigned long  hsstell();0 extern void           hputbuf(unsigned int,int);* extern void           rewindNbytes( int );% enum byte_order DetermineByteOrder(); / void SwapBytesInWords( short *loc, int words );        #ifdef  MACINTOSHfK extern void           set_mac_file_attr(char[MAX_NAME_SIZE], short, OsType,S                          OsType); #endif
 #ifdef MS_DOS ? extern char           *new_ext(char *filename, char *extname); 0 #endif   #else ' extern FILE           *OpenTableFile();)' extern int            read_bit_alloc();># extern int            pick_table();*! extern int            js_bound();*$ extern void           hdr_to_frps();! extern void           WriteHdr();*& extern void           WriteBitAlloc();# extern void           WriteScale(); % extern void           WriteSamples();_! extern int            NumericQ();e% extern int            BitrateIndex(); $ extern int            SmpFrqIndex();! extern int            memcheck();p' extern void           FAR *mem_alloc();S! extern void           mem_free();a+ extern void           double_to_extended(); + extern void           extended_to_double(); * extern int            aiff_read_headers();0 extern int            aiff_seek_to_sound_data();+ extern int            aiff_write_headers();;& extern int            refill_buffer();% extern void           empty_buffer(); * extern void           open_bit_stream_w();* extern void           open_bit_stream_r();+ extern void           close_bit_stream_r(); + extern void           close_bit_stream_w();y% extern void           alloc_buffer();h( extern void           desalloc_buffer();* extern void           back_track_buffer();  extern unsigned int   get1bit();  extern void           put1bit();# extern unsigned long  look_ahead();   extern unsigned long  getbits();  extern void           putbits();) extern void           byte_ali_putbits();c) extern unsigned long  byte_ali_getbits();_ extern unsigned long  sstell();  extern int            end_bs();o" extern int            seek_sync();# extern void           I_CRC_calc(); $ extern void           II_CRC_calc();# extern void           update_CRC();*$ extern void           read_absthr();  ! extern unsigned int   hget1bit();t! extern unsigned long  hgetbits();y  extern unsigned long  hsstell();  extern void           hputbuf();% extern void           rewindNbytes();e  
 #ifdef MS_DOST" extern char           *new_ext();  #endif #endif #endif  