G /********************************************************************** ;  * ISO MPEG Audio Subgroup Software Simulation Group (1996) H  * ISO 13818-3 MPEG-2 Audio Decoder - Lower Sampling Frequency Extension  *9  * $Id: common.c,v 1.2 1996/03/28 03:13:37 rowlands Exp $   *  * $Log: common.c,v $ .  * Revision 1.2  1996/03/28 03:13:37  rowlands*  * Merged layers 1-2 and layer 3 revisions  *.  * Revision 1.1  1996/02/14 03:45:52  rowlands  * Initial revision   *  * Received from FhGH  **********************************************************************/G /********************************************************************** G  *   date   programmers         comment                               * G  * 2/25/91  Doulas Wong,        start of version 1.0 records          * G  *          Davis Pan                                                 * G  * 5/10/91  W. Joseph Carter    Created this file for all common      * G  *                              functions and global variables.       * G  *                              Ported to Macintosh and Unix.         * G  *                              Added Jean-Georges Fritsch's          * G  *                              "bitstream.c" package.                * G  *                              Added routines to handle AIFF PCM     * G  *                              sound files.                          * G  *                              Added "mem_alloc()" and "mem_free()"  * G  *                              routines for memory allocation        * G  *                              portability.                          * G  *                              Added routines to convert between     * G  *                              Apple SANE extended floating point    * G  *                              format and IEEE double precision      * G  *                              floating point format.  For AIFF.     * G  * 02jul91 dpwe (Aware Inc)     Moved allocation table input here;    * G  *                              Tables read from subdir TABLES_PATH.  * G  *                              Added some debug printout fns (Write*)* G  * 7/10/91 Earle Jennings       replacement of the one float by FLOAT * G  *                              port to MsDos from MacIntosh version  * G  * 8/ 5/91 Jean-Georges Fritsch fixed bug in open_bit_stream_r()      * G  *10/ 1/91 S.I. Sudharsanan,    Ported to IBM AIX platform.           * G  *         Don H. Lee,                                                * G  *         Peter W. Farrett                                           * G  *10/3/91  Don H. Lee           implemented CRC-16 error protection   * G  *                              newly introduced functions are        * G  *                              I_CRC_calc, II_CRC_calc and           * G  *                              update_CRC. Additions and revisions   * G  *                              are marked with dhl for clarity       * G  *10/18/91 Jean-Georges Fritsch fixed bug in update_CRC(),            * G  *                              II_CRC_calc() and I_CRC_calc()        * G  * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   * G  *                              important fixes involved changing     * G  *                              16-bit ints to long or unsigned in    * G  *                              bit alloc routines for quant of 65535 * G  *                              and passing proper function args.     * G  *                              Removed "Other Joint Stereo" option   * G  *                              and made bitrate be total channel     * G  *                              bitrate, irrespective of the mode.    * G  *                              Fixed many small bugs & reorganized.  * G  * 3/20/92 Jean-Georges Fritsch  fixed bug in start-of-frame search   * G  * 6/15/92 Juan Pineda          added refill_buffer(bs) "n"           * G  *                              initialization                        * G  * 7/08/92 Susanne Ritscher     MS-DOS, MSC6.0 port fixes             * G  * 7/27/92 Mike Li               (re-)Port to MS-DOS                  * G  * 8/19/92 Soren H. Nielsen     Fixed bug in I_CRC_calc and in        * G  *                              II_CRC_calc.  Added function: new_ext * G  *                              for better MS-DOS compatability       * G  * 3/10/93 Kevin Peterson       changed aiff_read_headers to handle   * G  *                              chunks in any order.  now returns     * G  *                              position of sound data in file.       * G  * 3/31/93 Jens Spille          changed IFF_* string compares to use  * G  *                              strcmp()                              * G  * 5/30/93 Masahiro Iwadare     removed the previous modification     * G  *                              for UNIX.                             * G  * 8/27/93 Seymour Shlien,      Fixes in Unix and MSDOS ports,        * G  *         Daniel Lauzon, and                                         * G  *         Bill Truerniet                                             * G  *--------------------------------------------------------------------* G  *  8/24/93 Masahiro Iwadare    Included IS modification in Layer III.* G  *                              Changed for 1 pass decoding.          * G  *  9/07/93 Toshiyuki Ishino    Integrated Layer III with Ver 3.9.    * G  *--------------------------------------------------------------------* G  * 11/20/93 Masahiro Iwadare    Integrated Layer III with Ver 4.0.    * G  *--------------------------------------------------------------------* G  *  7/14/94 Juergen Koller      rewind of bitbuffer added             * G  *--------------------------------------------------------------------* G  *  6/12/95 Soeren H. Nielsen   Bug fix in new_ext().                 * G  *  7/11/95 Soeren H. Nielsen   Changes for MPEG-2 LSF Layer I and II * H  **********************************************************************/  H /*********************************************************************** *  *  Global Include Files  * H ***********************************************************************/   #include        "common.h"   #ifdef  MACINTOSH    #include        <SANE.h> #include        <pascal.h>   #endif  ( #include	<string.h> /* 1995-07-11 shn */ #include	<ctype.h>  H /*********************************************************************** *  *  Global Variable Definitions * H ***********************************************************************/  S char *mode_names[5] = { "stereo", "j-stereo", "dual-ch", "single-ch" , "multi-ch"}; , char *layer_names[3] = { "I", "II", "III" };4 char *version_names[2] = { "MPEG-2 LSF", "MPEG-1" };  . /* 1: MPEG-1, 0: MPEG-2 LSF, 1995-07-11 shn */? double  s_freq[2][4] = {{22.05, 24, 16, 0}, {44.1, 48, 32, 0}};   . /* 1: MPEG-1, 0: MPEG-2 LSF, 1995-07-11 shn */ int     bitrate[2][3][15] = {{@           {0,32,48,56,64,80,96,112,128,144,160,176,192,224,256},;           {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160}, <           {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160}},     D           {{0,32,64,96,128,160,192,224,256,288,320,352,384,416,448},@           {0,32,48,56,64,80,96,112,128,160,192,224,256,320,384},>           {0,32,40,48,56,64,80,96,112,128,160,192,224,256,320}
           }};    double FAR multiple[64] = { 5 2.00000000000000, 1.58740105196820, 1.25992104989487, G 1.00000000000000, 0.79370052598410, 0.62996052494744, 0.50000000000000, G 0.39685026299205, 0.31498026247372, 0.25000000000000, 0.19842513149602, G 0.15749013123686, 0.12500000000000, 0.09921256574801, 0.07874506561843, G 0.06250000000000, 0.04960628287401, 0.03937253280921, 0.03125000000000, G 0.02480314143700, 0.01968626640461, 0.01562500000000, 0.01240157071850, G 0.00984313320230, 0.00781250000000, 0.00620078535925, 0.00492156660115, G 0.00390625000000, 0.00310039267963, 0.00246078330058, 0.00195312500000, G 0.00155019633981, 0.00123039165029, 0.00097656250000, 0.00077509816991, G 0.00061519582514, 0.00048828125000, 0.00038754908495, 0.00030759791257, G 0.00024414062500, 0.00019377454248, 0.00015379895629, 0.00012207031250, G 0.00009688727124, 0.00007689947814, 0.00006103515625, 0.00004844363562,*G 0.00003844973907, 0.00003051757813, 0.00002422181781, 0.00001922486954,wG 0.00001525878906, 0.00001211090890, 0.00000961243477, 0.00000762939453, G 0.00000605545445, 0.00000480621738, 0.00000381469727, 0.00000302772723,:G 0.00000240310869, 0.00000190734863, 0.00000151386361, 0.00000120155435,2 1E-20: };  H /*********************************************************************** */ *  Global Function Definitions *lH ***********************************************************************/  E /* The system uses a variety of data files.  By opening them via this*5    function, we can accommodate various locations. */a   FILE *OpenTableFile(name)  char *name;  {  char fulname[80]; 
 char *envdir;  FILE *f;        fulname[0] = '\0';    #ifdef TABLES_PATHM        strcpy(fulname, TABLES_PATH);   /* default relative path for tables */pI #endif /* TABLES_PATH */          /* (includes terminal path seperator */   F #ifdef UNIX                       /* envir. variables for UNIX only */        {         char *getenv();n  B         envdir = getenv(MPEGTABENV);   /* check for environment */         if(envdir != NULL)$             strcpy(fulname, envdir);D         strcat(fulname, PATH_SEPARATOR);  /* add a "/" on the end */       }a #endif /* UNIX */        strcat(fulname, name);(     if( (f=fopen(fulname,"r"))==NULL ) {B         fprintf(stderr,"OpenTable: could not find %s\n", fulname);   #ifdef UNIX            if(envdir != NULL)K             fprintf(stderr,"Check %s directory '%s'\n",MPEGTABENV, envdir);l           elseI             fprintf(stderr,"Check local directory './%s' or setenv %s\n", -                     TABLES_PATH, MPEGTABENV); / #else /* not unix : no environment variables */    #ifdef TABLES_PATHI             fprintf(stderr,"Check local directory './%s'\n",TABLES_PATH);  #endif /* TABLES_PATH */   #endif /* UNIX */j       } 
     return f;  }e  H /*********************************************************************** /*H /* Read one of the data files ("alloc_*") specifying the bit allocation/? /* quatization parameters for each subband in layer II encodinge /*H /**********************************************************************/  N int read_bit_alloc(table, alloc)        /* read in table, return # subbands */
 int table; al_table *alloc; { &         unsigned int a, b, c, d, i, j;         FILE *fp;          char name[16], t[80];          int sblim;            strcpy(name, "alloc_0");           switch (table) {6                 case 0 : name[6] = '0';         break;6                 case 1 : name[6] = '1';         break;6                 case 2 : name[6] = '2';         break;6                 case 3 : name[6] = '3';         break;A 		case 4 : name[6] = '4';		break; /* LSF, added 1995-07-11 shn */ (                 default : name[6] = '0';	         }   *         if (!(fp = OpenTableFile(name))) {G                 printf("Please check bit allocation table %s\n", name);(                 exit(1);	         }   8         printf("using bit allocation table %s\n", name);           fgets(t, 80, fp);t"         sscanf(t, "%d\n", &sblim);         while (!feof(fp)) { !                 fgets(t, 80, fp);nI                 sscanf(t, "%d %d %d %d %d %d\n", &i, &j, &a, &b, &c, &d);n1                         (*alloc)[i][j].steps = a;o1                         (*alloc)[i][j].bits  = b; 1                         (*alloc)[i][j].group = c; 1                         (*alloc)[i][j].quant = d;t	         }t         fclose(fp);          return sblim;  }e  H /*********************************************************************** /*C /* Using the decoded info the appropriate possible quantization pery /* subband table is loaded /*H /**********************************************************************/  I int pick_table(fr_ps)   /* choose table, load if necess, return # sb's */  frame_params *fr_ps; { 5         int table, lay, ws, bsp, br_per_ch, sfrq,ver;SM         int sblim = fr_ps->sblimit;     /* return current value if no load */i
 	          	ver = fr_ps->header->version;%         lay = fr_ps->header->lay - 1; +         bsp = fr_ps->header->bitrate_index; ;         br_per_ch = bitrate[ver][lay][bsp] / fr_ps->stereo; /         ws = fr_ps->header->sampling_frequency;e         sfrq = s_freq[ver][ws];   K         /* decision rules refer to per-channel bitrates (kbits/sec/chan) */ < 	if (fr_ps->header->version == MPEG_AUDIO_ID) { /* MPEG-1 */+ 	    if ((sfrq == 48 && br_per_ch >= 56) ||i2 		(br_per_ch >= 56 && br_per_ch <= 80)) table = 0;7 	    else if (sfrq != 48 && br_per_ch >= 96) table = 1; 7 	    else if (sfrq != 32 && br_per_ch <= 48) table = 2;  	    else table = 3; 	} 	else { /* MPEG-2 LSF */ 	    table = 4;m 	}  &         if (fr_ps->tab_num != table) {#            if (fr_ps->tab_num >= 0) 1               mem_free((void **)&(fr_ps->alloc));UF            fr_ps->alloc = (al_table FAR *) mem_alloc(sizeof(al_table),B                                                          "alloc");H            sblim = read_bit_alloc(fr_ps->tab_num = table, fr_ps->alloc);	         }-         return sblim;- }    int js_bound(lay, m_ext) int lay, m_ext;o {iB static int jsb_table[3][4] =  { { 4, 8, 12, 16 }, { 4, 8, 12, 16},K                                 { 0, 4, 8, 16} };  /* lay+m_e -> jsbound */r  /     if(lay<1 || lay >3 || m_ext<0 || m_ext>3) {-K         fprintf(stderr, "js_bound bad layer/modext (%d/%d)\n", lay, m_ext);          exit(1);     }t$     return(jsb_table[lay-1][m_ext]); }-  J void hdr_to_frps(fr_ps) /* interpret data in hdr str to fields in fr_ps */ frame_params *fr_ps; {d: layer *hdr = fr_ps->header;     /* (or pass in as arg?) */  #     fr_ps->actual_mode = hdr->mode;/7     fr_ps->stereo = (hdr->mode == MPG_MD_MONO) ? 1 : 2; C     if (hdr->lay == 2)          fr_ps->sblimit = pick_table(fr_ps);r9     else                        fr_ps->sblimit = SBLIMIT;*(     if(hdr->mode == MPG_MD_JOINT_STEREO);         fr_ps->jsbound = js_bound(hdr->lay, hdr->mode_ext);      else(         fr_ps->jsbound = fr_ps->sblimit;*     /* alloc, tab_num set in pick_table */ }*   void WriteHdr(fr_ps, s)c frame_params *fr_ps; FILE *s; {i layer *info = fr_ps->header;  F    fprintf(s, "HDR: s=FFF, id=%X, l=%X, ep=%s, br=%X, sf=%X, pd=%X, ",O            info->version, info->lay, ((info->error_protection) ? "on" : "off"),*I            info->bitrate_index, info->sampling_frequency, info->padding);*7    fprintf(s, "pr=%X, m=%X, js=%X, c=%X, o=%X, e=%X\n",h7            info->extension, info->mode, info->mode_ext,i<            info->copyright, info->original, info->emphasis);?    fprintf(s, "alg.=%s, layer=%s, tot bitrate=%d, sfrq=%.1f\n", B            version_names[info->version], layer_names[info->lay-1],= 	   bitrate[info->version][info->lay-1][info->bitrate_index],:<            s_freq[info->version][info->sampling_frequency]);4    fprintf(s, "mode=%s, sblim=%d, jsbd=%d, ch=%d\n",R            mode_names[info->mode], fr_ps->sblimit, fr_ps->jsbound, fr_ps->stereo);
    fflush(s);, }4  % void WriteBitAlloc(bit_alloc, f_p, s) # unsigned int bit_alloc[2][SBLIMIT];2 frame_params *f_p; FILE *s; {  int i,j; int st = f_p->stereo;8 int sbl = f_p->sblimit;, int jsb = f_p->jsbound;6       fprintf(s, "BITA ");     for(i=0; i<sbl; ++i) {$         if(i == jsb) fprintf(s,"-");         for(j=0; j<st; ++j) /             fprintf(s, "%1x", bit_alloc[j][i]);9     }."     fprintf(s, "\n");   fflush(s); }9  3 void WriteScale(bit_alloc, scfsi, scalar, fr_ps, s)4M unsigned int bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT], scalar[2][3][SBLIMIT];6 frame_params *fr_ps; FILE *s; {8 int stereo  = fr_ps->stereo; int sblimit = fr_ps->sblimit;0! int lay     = fr_ps->header->lay;0
 int i,j,k;           if(lay == 2) {              fprintf(s, "SFSI ");:             for (i=0;i<sblimit;i++) for (k=0;k<stereo;k++)B                 if (bit_alloc[k][i])  fprintf(s,"%d",scfsi[k][i]);"             fprintf(s, "\nSCFs ");$             for (k=0;k<stereo;k++) {'                 for (i=0;i<sblimit;i++) (                     if (bit_alloc[k][i]).                         switch (scfsi[k][i]) {3                           case 0: for (j=0;j<3;j++)5D                                   fprintf(s,"%2d%c",scalar[k][j][i],:                                           (j==2)?';':'-');(                                   break;!                           case 1: D                           case 3: fprintf(s,"%2d-",scalar[k][0][i]);D                                   fprintf(s,"%2d;",scalar[k][2][i]);(                                   break;D                           case 2: fprintf(s,"%2d;",scalar[k][0][i]);                         }*!                 fprintf(s, "\n");s
             }a	         }B         else{   /* lay == 1 */              fprintf(s, "SCFs ");:             for (i=0;i<sblimit;i++) for (k=0;k<stereo;k++)H                 if (bit_alloc[k][i])  fprintf(s,"%2d;",scalar[k][0][i]);             fprintf(s, "\n"); 	         }n },  2 void WriteSamples(ch, sample, bit_alloc, fr_ps, s) int ch;f! unsigned int FAR sample[SBLIMIT];l  unsigned int bit_alloc[SBLIMIT]; frame_params *fr_ps; FILE *s; {  int i; int stereo = fr_ps->stereo;  int sblimit = fr_ps->sblimit;)           fprintf(s, "SMPL ");         for (i=0;i<sblimit;i++)m'                 if ( bit_alloc[i] != 0) 1                     fprintf(s, "%d:", sample[i]);a1         if(ch==(stereo-1) )     fprintf(s, "\n"); 1         else                    fprintf(s, "\t");a };  C int NumericQ(s) /* see if a string lookd like a numeric argument */n char *s; {n
 char    c;  F     while( (c = *s++)!='\0' && isspace((int)c)) /* strip leading ws */	         ;r     if( c == '+' || c == '-' )A         c = *s++;               /* perhaps skip leading + or - */c     return isdigit((int)c);e }v  J int BitrateIndex(ver,layr, bRate)   /* convert bitrate in kbps to index */( int     layr,ver;           /* 1 or 2 */8 int     bRate;          /* legal rates from 32 to 448 */ {. int     index = 0; int     found = 0;  !     while(!found && index<15)   { 0         if(bitrate[ver][layr-1][index] == bRate)             found = 1;         else             ++index;     }f
     if(found)          return(index);
     else {O         fprintf(stderr, "BitrateIndex: %d (layer %d) is not a legal bitrate\n",*                 bRate, layr);*$         return(-1);     /* Error! */     }e }b  F int SmpFrqIndex(sRate, version)  /* convert samp frq in Hz to index */R long sRate;             /* legal rates 16000, 22050, 24000, 32000, 44100, 48000 */ int  *version; {n     if (sRate == 44100L) {,         *version = MPEG_AUDIO_ID; return(0);     }      else if (sRate == 48000L) { ,         *version = MPEG_AUDIO_ID; return(1);     }      else if (sRate == 32000L) { ,         *version = MPEG_AUDIO_ID; return(2);     }      else if (sRate == 24000L) {3.         *version = MPEG_PHASE2_LSF; return(1);     }'     else if (sRate == 22050L) {-.         *version = MPEG_PHASE2_LSF; return(0);     }      else if (sRate == 16000L) {e.         *version = MPEG_PHASE2_LSF; return(2);     }e
     else {P         fprintf(stderr, "SmpFrqIndex: %ld is not a legal sample rate\n", sRate);%         return(-1);      /* Error! */e     }  }     P /******************************************************************************* * 7 *  Allocate number of bytes of memory equal to "block".t *%P *******************************************************************************/  ! void  FAR *mem_alloc(block, item)  unsigned long   block; char            *item; {        void    *ptr;o   #ifdef  MACINTOSH      ptr = NewPtr(block); #endif   #ifdef MSC60W     /*ptr = (void FAR *) _fmalloc((unsigned int)block);*/ /* far memory, 92-07-08 sr */*Q     ptr = (void FAR *) malloc((unsigned int)block); /* far memory, 93-08-24 ss */  #endif  . #if ! defined (MACINTOSH) && ! defined (MSC60)%     ptr = (void FAR *) malloc(block);* #endif       if (ptr != NULL){/
 #ifdef  MSC60bL         _fmemset(ptr, 0, (unsigned int)block); /* far memory, 92-07-08 sr */ #else          memset(ptr, 0, block); #endif     } 	     else{ 0         printf("Unable to allocate %s\n", item);         exit(0);     }*     return(ptr); }=    M /****************************************************************************p *h) *  Free memory pointed to by "*ptr_addr".  *rN *****************************************************************************/   void    mem_free(ptr_addr) void    **ptr_addr;  {d       if (*ptr_addr != NULL){n #ifdef  MACINTOSHs         DisposPtr(*ptr_addr);r #elseo         free(*ptr_addr); #endif         *ptr_addr = NULL;r     }    })  P /******************************************************************************* *rF *  Check block of memory all equal to a single byte, else return FALSE *bP *******************************************************************************/   int memcheck(array, test, num) char *array;? int test;       /* but only tested as a char (bottom 8 bits) */) int num; {c	  int i=0;   )    while (array[i] == test && i<num) i++;c    if (i==num) return TRUE;     else return FALSE;  }     N /***************************************************************************** * 2 *  Routines to determine byte order and swap bytes * N *****************************************************************************/0 enum byte_order NativeByteOrder = order_unknown;  $ enum byte_order DetermineByteOrder() {a     char s[ sizeof(long) + 1 ];y	     union3     {x         long longval; %         char charval[ sizeof(long) ];/     } probe;5     probe.longval = 0x41424344L;  /* ABCD in ASCII */n.     strncpy( s, probe.charval, sizeof(long) );     s[ sizeof(long) ] = '\0';h5     /* fprintf( stderr, "byte order is %s\n", s ); */ !     if ( strcmp(s, "ABCD") == 0 )(         return order_bigEndian;p     else%         if ( strcmp(s, "DCBA") == 0 ) &             return order_littleEndian;         else!             return order_unknown;c }a  . void SwapBytesInWords( short *loc, int words ) {s
     int i;     short thisval;     char *dst, *src;     src = (char *) &thisval;!     for ( i = 0; i < words; i++ ))     {          thisval = *loc;u         dst = (char *) loc++;l         dst[0] = src[1];         dst[1] = src[0];     }, }c  N /*****************************************************************************  *6  *  Read Audio Interchange File Format (AIFF) headers.  *O  *****************************************************************************/   ; int aiff_read_headers( FILE *file_ptr, IFF_AIFF *aiff_ptr )d {).     int i, chunkSize, subSize, sound_position;     ,     if ( fseek(file_ptr, 0, SEEK_SET) != 0 )         return -1;     5     if ( Read32BitsHighLow(file_ptr) != IFF_ID_FORM )          return -1;     .     chunkSize = Read32BitsHighLow( file_ptr );     5     if ( Read32BitsHighLow(file_ptr) != IFF_ID_AIFF )          return -1;          sound_position = 0;_     while ( chunkSize > 0 )n     {s         chunkSize -= 4;e.         switch ( Read32BitsHighLow(file_ptr) ) 	{                        case IFF_ID_COMM:,A             chunkSize -= subSize = Read32BitsHighLow( file_ptr );4B             aiff_ptr->numChannels = Read16BitsHighLow( file_ptr );             subSize -= 2;*F             aiff_ptr->numSampleFrames = Read32BitsHighLow( file_ptr );             subSize -= 4;uA             aiff_ptr->sampleSize = Read16BitsHighLow( file_ptr );              subSize -= 2;"H             aiff_ptr->sampleRate  = ReadIeeeExtendedHighLow( file_ptr );             subSize -= 10;!             while ( subSize > 0 )d 	    {!                 getc( file_ptr );,                 subSize -= 1;[ 	    }             break;                        case IFF_ID_SSND:pA             chunkSize -= subSize = Read32BitsHighLow( file_ptr );-E             aiff_ptr->blkAlgn.offset = Read32BitsHighLow( file_ptr );f             subSize -= 4;pH             aiff_ptr->blkAlgn.blockSize = Read32BitsHighLow( file_ptr );             subSize -= 4;iJ             sound_position = ftell( file_ptr ) + aiff_ptr->blkAlgn.offset;A             if ( fseek(file_ptr, (long) subSize, SEEK_CUR) != 0 )0                 return -1;/             aiff_ptr->sampleType = IFF_ID_SSND;              break;                        default:A             chunkSize -= subSize = Read32BitsHighLow( file_ptr );i!             while ( subSize > 0 )  	    {!                 getc( file_ptr );)                 subSize -= 1;  	    }             break; 	}     }      return sound_position; }   N /*****************************************************************************  *N  *  Seek past some Audio Interchange File Format (AIFF) headers to sound data.  *O  *****************************************************************************/   - int aiff_seek_to_sound_data( FILE *file_ptr )  { U 	if ( fseek(file_ptr, AIFF_FORM_HEADER_SIZE + AIFF_SSND_HEADER_SIZE, SEEK_SET) != 0 );         return(-1);0     return(0); }   P /*******************************************************************************  *7  *  Write Audio Interchange File Format (AIFF) headers.o  *Q  *******************************************************************************/I  < int aiff_write_headers( FILE *file_ptr, IFF_AIFF *aiff_ptr ) {E     int chunkSize;V     int sampleBytes = (aiff_ptr->sampleSize / 8) + (aiff_ptr->sampleSize % 8 ? 1 : 0);     -     if ( fseek(file_ptr, 0L, SEEK_SET) != 0 )          return -1;          /* write FORM chunk */]     chunkSize = 8 + 18 + 8 + aiff_ptr->numChannels * aiff_ptr->numSampleFrames * sampleBytes; 0     Write32BitsHighLow( file_ptr, IFF_ID_FORM );.     Write32BitsHighLow( file_ptr, chunkSize );0     Write32BitsHighLow( file_ptr, IFF_ID_AIFF );     /* write COMM chunk */0     Write32BitsHighLow( file_ptr, IFF_ID_COMM );8     Write32BitsHighLow( file_ptr, 18 ); /* chunk size */:     Write16BitsHighLow( file_ptr, aiff_ptr->numChannels );>     Write32BitsHighLow( file_ptr, aiff_ptr->numSampleFrames );9     Write16BitsHighLow( file_ptr, aiff_ptr->sampleSize ); ?     WriteIeeeExtendedHighLow( file_ptr, aiff_ptr->sampleRate );.!     /* write SSND chunk header */ T     chunkSize = 8 + aiff_ptr->numChannels * aiff_ptr->numSampleFrames * sampleBytes;0     Write32BitsHighLow( file_ptr, IFF_ID_SSND );.     Write32BitsHighLow( file_ptr, chunkSize );3     Write32BitsHighLow( file_ptr, 0 ); /* offset */ 7     Write32BitsHighLow( file_ptr, 0 ); /* block size */ 
     return 0;  }t    N /***************************************************************************** *v *  bit_stream.c packagef5 *  Author:  Jean-Georges Fritsch, C-Cube Microsystemsr *sN *****************************************************************************/  E /********************************************************************l>   This package provides functions to write (exclusive or read)4   information from (exclusive or to) the bit stream.  E   If the bit stream is opened in read mode only the get functions are C   available. If the bit stream is opened in write mode only the put    functions are available.E ********************************************************************/   L /*open_bit_stream_w(); open the device to write the bit stream into it    */L /*open_bit_stream_r(); open the device to read the bit stream from it     */L /*close_bit_stream();  close the device containing the bit stream         */L /*alloc_buffer();      open and initialize the buffer;                    */L /*desalloc_buffer();   empty and close the buffer                         */L /*back_track_buffer();     goes back N bits in the buffer                 */L /*unsigned int get1bit();  read 1 bit from the bit stream                 */L /*unsigned long getbits(); read N bits from the bit stream                */N /*unsigned long byte_ali_getbits();   read the next byte aligned N bits from*/N /*                                    the bit stream                        */N /*unsigned long look_ahead(); grep the next N bits in the bit stream without*/N /*                            changing the buffer pointer                   */0 /*put1bit(); write 1 bit from the bit stream  */0 /*put1bit(); write 1 bit from the bit stream  */0 /*putbits(); write N bits from the bit stream */N /*byte_ali_putbits(); write byte aligned the next N bits into the bit stream*/N /*unsigned long sstell(); return the current bit stream length (in bits)    */N /*int end_bs(); return 1 if the end of bit stream reached otherwise 0       */N /*int seek_sync(); return 1 if a sync word was found in the bit stream      */N /*                 otherwise returns 0                                      */  N /* refill the buffer from the input device when the buffer becomes empty    */ int refill_buffer(bs)d2 Bit_stream_struc *bs;   /* bit stream structure */ {*2    register int i=bs->buf_size-2-bs->buf_byte_idx;    register unsigned long n=1;    register int index=0;    char val[2];t  !    while ((i>=0) && (!bs->eob)) {*         if (bs->format == BINARY)*D          n = fread(&bs->buf[i--], sizeof(unsigned char), 1, bs->pt);         else {"          while((index < 2) && n) {<             n = fread(&val[index], sizeof(char), 1, bs->pt);!             switch (val[index]) {                    case 0x30:                   case 0x31:                   case 0x32:                   case 0x33:                   case 0x34:                   case 0x35:                   case 0x36:                   case 0x37:                   case 0x38:                   case 0x39:                   case 0x41:                   case 0x42:                   case 0x43:                   case 0x44:                   case 0x45:                   case 0x46:                   index++;                   break;!                   default: break;t
             }.
          }  A          if (val[0] <= 0x39)   bs->buf[i] = (val[0] - 0x30) << 4; 9                  else  bs->buf[i] = (val[0] - 0x37) << 4;=?          if (val[1] <= 0x39)   bs->buf[i--] |= (val[1] - 0x30);s7                  else  bs->buf[i--] |= (val[1] - 0x37);E          index = 0;        }          if (!n) {o          bs->eob= i+1;       }(       }o }i  % static char *he = "0123456789ABCDEF";s  H /* empty the buffer to the output device when the buffer becomes full */ void empty_buffer(bs, minimum)2 Bit_stream_struc *bs;   /* bit stream structure */8 int minimum;            /* end of the buffer to empty */ {c    register int i;   #if BS_FORMAT == BINARY*(    for (i=bs->buf_size-1;i>=minimum;i--)<       fwrite(&bs->buf[i], sizeof(unsigned char), 1, bs->pt); #else**    for (i=bs->buf_size-1;i>=minimum;i--) {        char val[2];*/        val[0] = he[((bs->buf[i] >> 4) & 0x0F)];A(        val[1] = he[(bs->buf[i] & 0x0F)];,        fwrite(val, sizeof(char), 2, bs->pt);    } #endif      for (i=minimum-1; i>=0; i--)-8        bs->buf[bs->buf_size - minimum + i] = bs->buf[i];  0    bs->buf_byte_idx = bs->buf_size -1 - minimum;    bs->buf_bit_idx = 8;  }   5 /* open the device to write the bit stream into it */ , void open_bit_stream_w(bs, bs_filenam, size)2 Bit_stream_struc *bs;   /* bit stream structure */9 char *bs_filenam;       /* name of the bit stream file */l0 int size;               /* size of the buffer */ {M4    if ((bs->pt = fopen(bs_filenam, "wb")) == NULL) {7       printf("Could not create \"%s\".\n", bs_filenam);d       exit(1);    }    alloc_buffer(bs, size);    bs->buf_byte_idx = size-1;S    bs->buf_bit_idx=8;s    bs->totbit=0;    bs->mode = WRITE_MODE;4    bs->eob = FALSE;p    bs->eobs = FALSE; }t  4 /* open the device to read the bit stream from it */, void open_bit_stream_r(bs, bs_filenam, size)2 Bit_stream_struc *bs;   /* bit stream structure */9 char *bs_filenam;       /* name of the bit stream file */ 0 int size;               /* size of the buffer */ {     register unsigned long n;#    register unsigned char flag = 1;p    unsigned char val;   4    if ((bs->pt = fopen(bs_filenam, "rb")) == NULL) {5       printf("Could not find \"%s\".\n", bs_filenam);r       exit(1);    }      do { 7      n = fread(&val, sizeof(unsigned char), 1, bs->pt);o      switch (val) {        case 0x30:       case 0x31:       case 0x32:       case 0x33:       case 0x34:       case 0x35:       case 0x36:       case 0x37:       case 0x38:       case 0x39:       case 0x41:       case 0x42:       case 0x43:       case 0x44:       case 0x45:       case 0x46:       case 0xa:  /* \n */S       case 0xd:  /* cr */H       case 0x1a:  /* sub */            break;  5       default: /* detection of an binary character */            flag--;            break;      }      } while (flag & n);      if (flag) {G       printf ("the bit stream file %s is an ASCII file\n", bs_filenam);*       bs->format = ASCII;e    }	    else {o       bs->format = BINARY;G       printf ("the bit stream file %s is a BINARY file\n", bs_filenam);*    }      fclose(bs->pt);  4    if ((bs->pt = fopen(bs_filenam, "rb")) == NULL) {5       printf("Could not find \"%s\".\n", bs_filenam);        exit(1);    }      alloc_buffer(bs, size);    bs->buf_byte_idx=0;    bs->buf_bit_idx=0;*    bs->totbit=0;    bs->mode = READ_MODE;    bs->eob = FALSE;*    bs->eobs = FALSE; }e  C /*close the device containing the bit stream after a read process*/* void close_bit_stream_r(bs)*2 Bit_stream_struc *bs;   /* bit stream structure */ {*    fclose(bs->pt);    desalloc_buffer(bs);h }S  D /*close the device containing the bit stream after a write process*/ void close_bit_stream_w(bs) 2 Bit_stream_struc *bs;   /* bit stream structure */ {e&    empty_buffer(bs, bs->buf_byte_idx);    fclose(bs->pt);    desalloc_buffer(bs);m }n  $ /*open and initialize the buffer; */ void alloc_buffer(bs, size)L2 Bit_stream_struc *bs;   /* bit stream structure */	 int size;  {nA    bs->buf = (unsigned char FAR *) mem_alloc(size*sizeof(unsignedw               char), "buffer");t    bs->buf_size = size;D }M   /*empty and close the buffer */p void desalloc_buffer(bs)2 Bit_stream_struc *bs;   /* bit stream structure */ {l    free(bs->buf);t }g  A int putmask[9]={0x0, 0x1, 0x3, 0x7, 0xf, 0x1f, 0x3f, 0x7f, 0xff}; G int clearmask[9]={0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 0x0};r  B void back_track_buffer(bs, N) /* goes back N bits in the buffer */2 Bit_stream_struc *bs;   /* bit stream structure */ int N; {     int tmp = N - (N/8)*8;B    register int i;      bs->totbit -= N;rI    for (i=bs->buf_byte_idx;i< bs->buf_byte_idx+N/8-1;i++) bs->buf[i] = 0;     bs->buf_byte_idx += N/8;3'    if ( (tmp + bs->buf_bit_idx) <= 8) {e       bs->buf_bit_idx += tmp;*    }	    else {*       bs->buf_byte_idx ++;#       bs->buf_bit_idx += (tmp - 8);     };    bs->buf[bs->buf_byte_idx] &= clearmask[bs->buf_bit_idx];c }y    9 int mask[8]={0x1, 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80};*  # /*read 1 bit from the bit stream */* unsigned int get1bit(bs)2 Bit_stream_struc *bs;   /* bit stream structure */ {i    unsigned int bit;    register int i;      bs->totbit++;      if (!bs->buf_bit_idx) {         bs->buf_bit_idx = 8;         bs->buf_byte_idx--; K         if ((bs->buf_byte_idx < MINIMUM) || (bs->buf_byte_idx < bs->eob)) {l              if (bs->eob)                   bs->eobs = TRUE;              else {*2                 for (i=bs->buf_byte_idx; i>=0;i--)J                   bs->buf[bs->buf_size-1-bs->buf_byte_idx+i] = bs->buf[i];"                 refill_buffer(bs);2                 bs->buf_byte_idx = bs->buf_size-1;              }	         }t    };    bit = bs->buf[bs->buf_byte_idx]&mask[bs->buf_bit_idx-1];b$    bit = bit >> (bs->buf_bit_idx-1);    bs->buf_bit_idx--;d    return(bit);  }   $ /*write 1 bit from the bit stream */ void put1bit(bs, bit)b2 Bit_stream_struc *bs;   /* bit stream structure */: int bit;                /* bit to write into the buffer */ {     bs->totbit++;  A    bs->buf[bs->buf_byte_idx] |= (bit&0x1) << (bs->buf_bit_idx-1);d    bs->buf_bit_idx--;)    if (!bs->buf_bit_idx) {        bs->buf_bit_idx = 8;         bs->buf_byte_idx--;         if (bs->buf_byte_idx < 0)$           empty_buffer(bs, MINIMUM);%        bs->buf[bs->buf_byte_idx] = 0;t    } }*  7 /*look ahead for the next N bits from the bit stream */  unsigned long look_ahead(bs, N)i2 Bit_stream_struc *bs;   /* bit stream structure */H int N;                  /* number of bits to read from the bit stream */ {   unsigned long val=0;)  register int j = N;  register int k, tmp; (  register int bit_idx = bs->buf_bit_idx;*  register int byte_idx = bs->buf_byte_idx;    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);    while (j > 0) {     if (!bit_idx) {h         bit_idx = 8;         byte_idx--;h     }r     k = MIN (j, bit_idx); -     tmp = bs->buf[byte_idx]&putmask[bit_idx];o     tmp = tmp >> (bit_idx-k);f     val |= tmp << (j-k);     bit_idx -= k;d     j -= k;s  }
  return(val);s }a    # /*read N bit from the bit stream */> unsigned long getbits(bs, N)2 Bit_stream_struc *bs;   /* bit stream structure */H int N;                  /* number of bits to read from the bit stream */ {>  unsigned long val=0;   register int i;  register int j = N;  register int k, tmp;;    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);    bs->totbit += N;   while (j > 0) {    if (!bs->buf_bit_idx) {         bs->buf_bit_idx = 8;         bs->buf_byte_idx--;aK         if ((bs->buf_byte_idx < MINIMUM) || (bs->buf_byte_idx < bs->eob)) {               if (bs->eob)                   bs->eobs = TRUE;              else { 2                 for (i=bs->buf_byte_idx; i>=0;i--)K                    bs->buf[bs->buf_size-1-bs->buf_byte_idx+i] = bs->buf[i]; "                 refill_buffer(bs);2                 bs->buf_byte_idx = bs->buf_size-1;              }	         }     }     k = MIN (j, bs->buf_bit_idx);<    tmp = bs->buf[bs->buf_byte_idx]&putmask[bs->buf_bit_idx];$    tmp = tmp >> (bs->buf_bit_idx-k);    val |= tmp << (j-k);     bs->buf_bit_idx -= k;
    j -= k;  }
  return(val);  }x  % /*write N bits into the bit stream */  void putbits(bs, val, N)2 Bit_stream_struc *bs;   /* bit stream structure */: unsigned int val;       /* val to write into the buffer */3 int N;                  /* number of bits of val */i {   register int j = N;  register int k, tmp;e    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);    bs->totbit += N;   while (j > 0) {    k = MIN(j, bs->buf_bit_idx);     tmp = val >> (j-k);H    bs->buf[bs->buf_byte_idx] |= (tmp&putmask[k]) << (bs->buf_bit_idx-k);    bs->buf_bit_idx -= k;    if (!bs->buf_bit_idx) {        bs->buf_bit_idx = 8;s        bs->buf_byte_idx--;         if (bs->buf_byte_idx < 0)$           empty_buffer(bs, MINIMUM);%        bs->buf[bs->buf_byte_idx] = 0;v    }
    j -= k;  } }0  2 /*write N bits byte aligned into the bit stream */! void byte_ali_putbits(bs, val, N);2 Bit_stream_struc *bs;   /* bit stream structure */: unsigned int val;       /* val to write into the buffer */3 int N;                  /* number of bits of val */h {e"  unsigned long aligning, sstell();    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);  aligning = sstell(bs)%8;n  if (aligning)6      putbits(bs, (unsigned int)0, (int)(8-aligning));     putbits(bs, val, N);> }=  : /*read the next bute aligned N bits from the bit stream */% unsigned long byte_ali_getbits(bs, N) 2 Bit_stream_struc *bs;   /* bit stream structure */3 int N;                  /* number of bits of val */- {t"  unsigned long aligning, sstell();    if (N > MAX_LENGTH)N     printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);  aligning = sstell(bs)%8;b  if (aligning)#     getbits(bs, (int)(8-aligning));a    return(getbits(bs, N)); }m  2 /*return the current bit stream length (in bits)*/ unsigned long sstell(bs)2 Bit_stream_struc *bs;   /* bit stream structure */ {s   return(bs->totbit);= }p  ' /*return the status of the bit stream*/=0 /* returns 1 if end of bit stream was reached */4 /* returns 0 if end of bit stream was not reached */ int end_bs(bs)2 Bit_stream_struc *bs;   /* bit stream structure */ {b   return(bs->eobs);  }l  H /*this function seeks for a byte aligned sync word in the bit stream and5   places the bit stream pointer right after the sync. J   This function returns 1 if the sync was found otherwise it returns 0  */ int seek_sync(bs, sync, N)2 Bit_stream_struc *bs;   /* bit stream structure *// long sync;      /* sync word maximum 32 bits */ & int N;          /* sync word length */ {   double pow();!  unsigned long aligning, stell();   unsigned long val; )  long maxi = (int)pow(2.0, (FLOAT)N) - 1;}     aligning = sstell(bs)%ALIGNING;  if (aligning)*     getbits(bs, (int)(ALIGNING-aligning));     val = getbits(bs, N); 1   while (((val&maxi) != sync) && (!end_bs(bs))) {>         val <<= ALIGNING;n%         val |= getbits(bs, ALIGNING);    }n    if (end_bs(bs)) return(0);l  else return(1); } N /***************************************************************************** *. *  End of bit_stream.c package * N *****************************************************************************/  N /***************************************************************************** *A *  CRC error protection packagen *nN *****************************************************************************/  & void I_CRC_calc(fr_ps, bit_alloc, crc) frame_params *fr_ps;# unsigned int bit_alloc[2][SBLIMIT];  unsigned int *crc; {a         int i, k;m$         layer *info = fr_ps->header;$         int stereo  = fr_ps->stereo;%         int jsbound = fr_ps->jsbound;e  :         *crc = 0xffff; /* changed from '0' 92-08-11 shn */0         update_CRC(info->bitrate_index, 4, crc);5         update_CRC(info->sampling_frequency, 2, crc);s*         update_CRC(info->padding, 1, crc);,         update_CRC(info->extension, 1, crc);'         update_CRC(info->mode, 2, crc); +         update_CRC(info->mode_ext, 2, crc);i,         update_CRC(info->copyright, 1, crc);+         update_CRC(info->original, 1, crc);s+         update_CRC(info->emphasis, 2, crc);s           for (i=0;i<SBLIMIT;i++),6                 for (k=0;k<((i<jsbound)?stereo:1);k++)<                         update_CRC(bit_alloc[k][i], 4, crc); }   . void II_CRC_calc(fr_ps, bit_alloc, scfsi, crc) frame_params *fr_ps;6 unsigned int bit_alloc[2][SBLIMIT], scfsi[2][SBLIMIT]; unsigned int *crc; {(         int i, k;e$         layer *info = fr_ps->header;$         int stereo  = fr_ps->stereo;%         int sblimit = fr_ps->sblimit;-%         int jsbound = fr_ps->jsbound;b'         al_table *alloc = fr_ps->alloc;i  :         *crc = 0xffff; /* changed from '0' 92-08-11 shn */0         update_CRC(info->bitrate_index, 4, crc);5         update_CRC(info->sampling_frequency, 2, crc); *         update_CRC(info->padding, 1, crc);,         update_CRC(info->extension, 1, crc);'         update_CRC(info->mode, 2, crc);)+         update_CRC(info->mode_ext, 2, crc);t,         update_CRC(info->copyright, 1, crc);+         update_CRC(info->original, 1, crc);_+         update_CRC(info->emphasis, 2, crc);            for (i=0;i<sblimit;i++)f6                 for (k=0;k<((i<jsbound)?stereo:1);k++)N                         update_CRC(bit_alloc[k][i], (*alloc)[i][0].bits, crc);           for (i=0;i<sblimit;i++) &                 for (k=0;k<stereo;k++),                         if (bit_alloc[k][i])@                                 update_CRC(scfsi[k][i], 2, crc); }   " void update_CRC(data, length, crc)  unsigned int data, length, *crc; { %         unsigned int  masking, carry;s           masking = 1 << length;           while((masking >>= 1)){b&                 carry = *crc & 0x8000;                 *crc <<= 1; /                 if (!carry ^ !(data & masking)) 1                         *crc ^= CRC16_POLYNOMIAL; 	         }          *crc &= 0xffff;  }   N /***************************************************************************** *d& *  End of CRC error protection package *iN *****************************************************************************/   #ifdef  MACINTOSH N /***************************************************************************** * ! *  Set Macintosh file attributes.i *fN *****************************************************************************/  ? void    set_mac_file_attr(fileName, vRefNum, creator, fileType)b  char    fileName[MAX_NAME_SIZE]; short   vRefNum; OsType  creator; OsType  fileType;g {e   short   theFile;' char    pascal_fileName[MAX_NAME_SIZE];g FInfo   fndrInfo;=  3         CtoPstr(strcpy(pascal_fileName, fileName));"  3         FSOpen(pascal_fileName, vRefNum, &theFile);A6         GetFInfo(pascal_fileName, vRefNum, &fndrInfo);%         fndrInfo.fdCreator = creator;h#         fndrInfo.fdType = fileType; 6         SetFInfo(pascal_fileName, vRefNum, &fndrInfo);         FSClose(theFile);    }= #endif     #ifdef  MS_DOSK /* ------------------------------------------------------------------------t	 new_ext()n4 Puts a new extension name on a file name <filename>.( Removes the last extension name, if any. 1992-08-19, 1995-06-12 shnK ------------------------------------------------------------------------ */r, char *new_ext(char *filename, char *extname) {    int found, dotpos; static   char newname[80];m  "   /* First, strip the extension */#   dotpos=strlen(filename); found=0;(   do   {      switch (filename[dotpos])      {u        case '.' : found=1; break;6       case '\\':                  /* used by MS-DOS */4       case '/' :                  /* used by UNIX */K       case ':' : found=-1; break; /* used by MS-DOS in drive designation */ 9       default  : dotpos--; if (dotpos<0) found=-1; break;-     }-   } while (found==0);e*   if (found==-1) strcpy(newname,filename);H   if (found== 1) strncpy(newname,filename,dotpos); newname[dotpos]='\0';   strcat(newname,extname);   return(newname); }b #endif       #define BUFSIZE 40965 static unsigned long offset,totbit=0, buf_byte_idx=0;-! static unsigned int buf[BUFSIZE];(" static unsigned int buf_bit_idx=8;  2 /*return the current bit stream length (in bits)*/ unsigned long hsstell()d {t   return(totbit);i }t  G /* int putmask[9]={0x0, 0x1, 0x3, 0x7, 0xf, 0x1f, 0x3f, 0x7f, 0xff}; */l extern int putmask[9];  # /*read N bit from the bit stream */  unsigned long hgetbits(N)gH int N;                  /* number of bits to read from the bit stream */ {"  unsigned long val=0;r  register int j = N;  register int k, tmp;    /*  if (N > MAX_LENGTH)O      printf("Cannot read or write more than %d bits at a time.\n", MAX_LENGTH);- */
  totbit += N;t  while (j > 0) {    if (!buf_bit_idx) {         buf_bit_idx = 8;         buf_byte_idx++;  	if (buf_byte_idx > offset) . 	  { printf("Buffer overflow !!\n");exit(3); }    }    k = MIN (j, buf_bit_idx);8    tmp = buf[buf_byte_idx%BUFSIZE]&putmask[buf_bit_idx];     tmp = tmp >> (buf_bit_idx-k);    val |= tmp << (j-k);t    buf_bit_idx -= k;
    j -= k;  }
  return(val);  }_   unsigned int hget1bit()s {a return(hgetbits(1)); }i  % /*write N bits into the bit stream */f void hputbuf(val, N): unsigned int val;       /* val to write into the buffer */3 int N;                  /* number of bits of val */f {a<   if (N != 8) { printf("Not Supported yet!!\n"); exit(-3); }   buf[offset % BUFSIZE] = val;   offset++;) }    void rewindNbits( N )i int N; {(    totbit -= N;     buf_bit_idx += N;    while( buf_bit_idx >= 8 )    {  buf_bit_idx -= 8;t       buf_byte_idx--;n    } }i   void rewindNbytes( N ) int N; {s    totbit -= N*8;t    buf_byte_idx -= N;  }   