/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Multichannel Decoder
 *
 * $Id: decoder.h 1.11 1996/04/18 05:37:23 rowlands Exp $
 *
 * $Log: decoder.h $
 * Revision 1.11  1996/04/18 05:37:23  rowlands
 * Release following Florence meeting
 *
 * Revision 1.10  1996/02/12 07:13:06  rowlands
 * Release following Munich meeting
 *
 * Revision 1.9.1.1  1996/01/20  17:28:45  rowlands
 * Received from Ralf Schwalbe (Telekom FTZ) - includes prediction
 *
 * Revision 1.7.1.3  1995/08/14  08:13:06  tenkate
 * ML-LSF added Warner ten Kate 7/8/95 (Philips)
 *
 * Revision 1.7.1.1  1995/07/14  06:12:46  rowlands
 * Updated dynamic crosstalk from FTZ: revision FTZ_03
 *
 * Revision 1.3.3.1  1995/06/16  08:00:46  rowlands
 * Input from Sang Wook Kim (Samsung AIT)
 *
 * Revision 1.3.1.1  1995/06/14  04:35:34  rowlands
 * Added declaration for dematrix procedure 2 routines.
 *
 **********************************************************************/

/**********************************************************************
 *   date   programmers                comment                        *
 * 2/25/91  Douglas Wong        start of version 1.0 records          *
 * 3/06/91  Douglas Wong        rename setup.h to dedef.h             *
 *                              removed extraneous variables          *
 *                              removed window_samples (now part of   *
 *                              filter_samples)                       *
 * 3/07/91  Davis Pan           changed output file to "codmusic"     *
 * 5/10/91  Vish (PRISM)        Ported to Macintosh and Unix.         *
 *                              Incorporated new "out_fifo()" which   *
 *                              writes out last incomplete buffer.    *
 *                              Incorporated all AIFF routines which  *
 *                              are also compatible with SUN.         *
 *                              Incorporated user interface for       *
 *                              specifying sound file names.          *
 *                              Also incorporated user interface for  *
 *                              writing AIFF compatible sound files.  *
 * 27jun91  dpwe (Aware)        Added musicout and &sample_frames as  *
 *                              args to out_fifo (were glob refs).    *
 *                              Used new 'frame_params' struct.       *
 *                              Clean,simplify, track clipped output  *
 *                              and total bits/frame received.        *
 * 7/10/91  Earle Jennings      changed to floats to FLOAT            *
 *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           *
 *          Don H. Lee,                                               *
 *          Peter W. Farrett                                          *
 *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   *
 *                              newly introduced functions are        *
 *                              buffer_CRC and recover_CRC_error      *
 *                              Additions and revisions are marked    *
 *                              with "dhl" for clarity                *
 * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   *
 *                              important fixes involved changing     *
 *                              16-bit ints to long or unsigned in    *
 *                              bit alloc routines for quant of 65535 *
 *                              and passing proper function args.     *
 *                              Removed "Other Joint Stereo" option   *
 *                              and made bitrate be total channel     *
 *                              bitrate, irrespective of the mode.    *
 *                              Fixed many small bugs & reorganized.  *
 **********************************************************************
 *                                                                    *
 *                                                                    *
 *  MPEG/audio Phase 2 coding/decoding multichannel                   *
 *                                                                    *
 *  Version 1.0                                                       *
 *                                                                    *
 *  7/27/93        Susanne Ritscher,  IRT Munich                      *
 *                                                                    *
 *                  thanks to                                         *
 *                  Ralf Schwalbe,    Telekom FTZ Berlin              *
 *                  Heiko Purnhagen,  Uni Hannover                    *
 *                                                                    *
 *  Version 2.0                                                       *
 *                                                                    *
 *  8/27/93        Susanne Ritscher, IRT Munich                       *
 *                 Channel-Switching is working                       *
 *                                                                    *
 *  Version 2.1                                                       *
 *                                                                    *
 *  9/1/93         Susanne Ritscher,  IRT Munich                      *
 *                 all channels normalized                            *
 *                                                                    *
 *  Version 3.0                                                       *
 *                                                                    *
 *  06/16/94       Ralf Schwalbe, Telekom FTZ Berlin                  *
 *                 all sources and variables adapted due to MPEG-2 -  *
 *                 DIS from March 1994                                *
 *                  - dematrix and denormalize procedure              *
 *                  - new tc - allocation (0-7)                       *
 *                  - some new structures and variables as a basis    *
 *                    for further decoding modes                      *
 **********************************************************************
 *								      *
 *  Version 1.0                                                       *
 *                                                                    *
 *  11/04/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                  - decoding tc-allocation                          *
 *                  - some new subroutines, globale variables and     *
 *                    structures (important to handle the ext. bitst.)*
 *                  - changed all functions to ANSI-C funktion header *
 *		    - corrected some bugs to decode bitstreams > 512kB*
 *								      *
 *  Version 1.1                                                       *
 *                                                                    *
 *  12/07/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                  - decoding extension bitstream                    *
 *                                                                    *
 *  Version 1.1.1                                                     *
 *                 Ralf Schwalbe, Telekom FTZ Berlin                  *
 *                  - fixed some bugs                                 *
 *                                                                    *
 *  Version 1.2                                                       *
 *                                                                    *
 *  6/21/95       Ralf Schwalbe, Deutsche Telekom FTZ Berlin          *
 *            	    - decoding dynamic crosstalk                      *
 *                  - decoding phantom center                         * 
 *                  - decoding MPEG1 compatible part only (stereo)    *
 *                  - corrected some settings and bugs                *
 *                                                                    *   
 *  7/12/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin          *
 *		    - corrected dynamic crosstalk 		      *
 *		    - 3/2,3/1,3/0,2/1, channel configurations         *
 *                    are working                                     *
 *		  						      *
 * 10/31/95	  Ralf Schwalbe, Deutsche Telekom FTZ Berlin	      *
 *		    - decoding of LFE-channel is working  	      *
 *		    - corrected any settings and bugs		      *
 *		    - corrected table-switch for channel mode < 3/2   *
 *		      and tc-allocation / dyn-crosstalk		      *
 *		    - still a problem with compl. bitstream 18/19     *
 *								      *	
 * 01/12/96	  Ralf Schwalbe, Deutsche Telekom TZ Darmstadt	      *
 *		    - decoder prediction installed		      *
 *		    - problem with compl. bitstream 19 solved,        *
 *		  						      *
 **********************************************************************/
/**********************************************************************
 *                                                                    *
 *  06/06/95       Yeon Bae Thomas Kim,  Samsung AIT                  *
 *		   ancillary data is working			      *
 *								      *
 **********************************************************************/

/***********************************************************************
*
*  Decoder Include Files
*
***********************************************************************/

/***********************************************************************
*
*  Decoder Definitions
*
***********************************************************************/

#define  DFLT_OPEXT        ".dec"  	/* default output file name extension */
#define  DFLT_OPEXT_EXT	   ".ext" 	/* default input for extension file */
#define  DFLT_OPEXT_LFE	   "_lfe.pcm" 	/* 10/31/95 R.S. output for lfe pcm-file */
#define  DFLT_OPEXT_ML 	   ".ml" 	/* default MultiLingual output file name extension */
#define	 FILTYP_DEC_AIFF   "AIFF"	/* '-> " . 7/13/92. sr */
#define	 FILTYP_DEC_BNRY   "TEXT"	/* '-> " . 7/13/92. sr */
#define	 CREATR_DEC_AIFF   "Sd2a"	/* '-> " . 7/13/92. sr */
#define	 CREATR_DEC_BNRY   "????"	/* '-> " . 7/13/92. sr */

#define   SYNC_WORD         (long) 0xfff
#define   SYNC_WORD_LNGTH   12

#define   MUTE              0
#define   STEP		    0.03125	 /* 13.10.93 R.S. step for prediction */
#define   PREDDEL           (2+7)        /* max. delay in prediction, HP 08-nov-94 */

#define   EXTENSION_CRC_CHECK
/***********************************************************************
*
*  Decoder Type Definitions
*
***********************************************************************/

/***********************************************************************
*
*  Decoder Variable External Declarations
*
***********************************************************************/
extern int bits_in_frame,read_mpeg2_part,mpeg,mc_channel;
extern unsigned long frameNum;
extern unsigned int ext_length;
 
/***********************************************************************
*
*  Decoder Function Prototype Declarations
*
***********************************************************************/

/* The following functions are in the file "musicout.c" */

#ifdef   PROTO_ARGS
extern void   usage(void);
#else
extern void   usage();
#endif

/* The following functions are in the file "decode.c" */

#ifdef   PROTO_ARGS
extern void   decode_info(Bit_stream_struc*, frame_params*);
extern void   II_decode_bitalloc(Bit_stream_struc*, unsigned int[5][SBLIMIT],
					   frame_params*, int*, int*);
extern void   II_decode_scale(Bit_stream_struc*, unsigned int[5][SBLIMIT],
					   unsigned int[5][SBLIMIT], unsigned int[5][3][SBLIMIT],
					   frame_params*, int*, int*);
extern void   II_buffer_sample(Bit_stream_struc*, unsigned int[5][3][SBLIMIT],
					   unsigned int[5][SBLIMIT], frame_params*);
extern void   II_buffer_samplemc(Bit_stream_struc*, unsigned int[5][3][SBLIMIT],
					   unsigned int[5][SBLIMIT], frame_params*, int);
extern void   read_quantizer_table(double[17], double[17]);
extern void   II_dequantize_sample(unsigned int[5][3][SBLIMIT],
					   unsigned int[5][SBLIMIT], double[5][SBLIMIT][3][12],
					   frame_params*, int*);
extern void   II_dequantize_samplemc(unsigned int[5][3][SBLIMIT],
					   unsigned int[5][SBLIMIT], double[5][SBLIMIT][3][12],
					   frame_params*,int*);
extern void   II_lfe_calc(frame_params*);
extern void   read_scale_factor(double[SCALE_RANGE]);
extern void   II_denormalize_sample(double[5][SBLIMIT][3][12],
					   unsigned int[5][3][SBLIMIT], frame_params*, int, int*);
extern void   II_denormalize_samplemc(double[5][SBLIMIT][3][12],
					   unsigned int[5][3][SBLIMIT], frame_params*, int, int*);
extern void   create_syn_filter(double[64][SBLIMIT]);
extern int    SubBandSynthesis (double*, int, long*);
extern void   read_syn_window(double[HAN_SIZE]);
extern void   window_sample(double*, double*);
extern void   out_fifo(long[5][3][SBLIMIT], int, frame_params*, int, FILE*, unsigned long*,int);
extern void   buffer_CRC(Bit_stream_struc*, unsigned int*);
extern void   recover_CRC_error(long[5][3][SBLIMIT], int, frame_params*,FILE*,unsigned long*,int);
extern void   mc_header(Bit_stream_struc*, frame_params*);
extern int    mc_ext_header();
extern int    mc_ext_error_check();
extern void   mc_composite_status_info(Bit_stream_struc*, frame_params*);
extern void   dematricing(double[5][SBLIMIT][3][12], frame_params*,double[3],
			  double[2][8][36+PREDDEL]);
extern void   denormalise(double[5][SBLIMIT][3][12], frame_params, 
		 	  double[12][5][3][SBLIMIT]); 
extern void  ancillaryDecode(frame_params*, Bit_stream_struc*,long);
extern void  init_dematrix2_filter_state(double state[3]);
extern double dematrix2_filter(frame_params *fr_ps,double state[3],double sample);
#else
extern void   decode_info();
extern void   II_decode_bitalloc();
extern void   II_decode_scale();
extern void   II_buffer_sample();
extern void   read_quantizer_table();
extern void   II_dequantize_sample();
extern void   read_scale_factor();
extern void   II_denormalize_sample();
extern void   create_syn_filter();
extern int    SubBandSynthesis ();
extern void   read_syn_window();
extern void   window_sample();
extern void   out_fifo();
extern int    mc_ext_header();
extern int    mc_ext_error_check();
extern void   buffer_CRC();
extern void   recover_CRC_error();
extern void   II_lfe_calc();
#endif
