
#include <os2.h>
#include <pmddi.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "32pmifi.h"

//#define USE_ORIG
#ifdef USE_ORIG
   #pragma import (fdhdr, "FONT_DRIVER_DISPATCH_TABLE", "TRUETYPE", 0)
#else
   #pragma import (fdhdr, "FONT_DRIVER_DISPATCH_TABLE", "FREETYPE", 0)
#endif

extern FDHEADER fdhdr;

#define FNTNAME "e:\\ttf\\gara.TtF"
#define FNTNAME2 "c:\\ttf\\symbol.tTf"
#define BUFSIZE 32768

void ShowChar(PCHARATTR pca, PBITMAPMETRICS pbmm) {
   int i, j;
   int bufwidth = ((pbmm->sizlExtent.cx + 31) & -32) / 8;

   for (i =0; i <  pbmm->sizlExtent.cy; i++) {
      for (j = 0; j < bufwidth * 8; j++)
         if (pca->pBuffer[i * bufwidth + j / 8] & (1 << (7-(j % 8))))
            printf("*");
         else
            printf(" ");
      printf("\n");
   }
}

void main(int argc, char **argv)
{
   PFDDISPATCH   pfdisp;
   ULONG         rc;
   HFF           hff, hff2;      /* font file */
   HFC           hfc, hfc2;      /* font context */
   IFIMETRICS    ifimet;         /* IFI metrics */
   CONTEXTINFO   ci;
   CHARATTR      charattr; /* character attributes */
   BITMAPMETRICS bmm;      /* bit-map metrics */
   PBYTE         buf;
   int           glyph = 0;

   if (argc > 1)
      glyph = atoi(argv[1]);

   buf = (PBYTE)malloc(BUFSIZE);
   if (strncmp("OS/2 FONT DRIVER", fdhdr.strId, 16)) {
      printf("Invalid Font Driver\n");
      return;
   }
   printf("Font Driver OK, ");
   printf("Version %d\n", fdhdr.ulVersion);
   printf("Technology: %s\n", fdhdr.szTechnology);
   hff = fdhdr.pfddisp->FdLoadFontFile(FNTNAME2, NULL);
   hff = fdhdr.pfddisp->FdLoadFontFile(FNTNAME, NULL);
   rc = fdhdr.pfddisp->FdUnloadFontFile(hff, NULL);
   hff = fdhdr.pfddisp->FdLoadFontFile(FNTNAME, NULL);
   printf("Loading font... HFF = %X\n", hff);
   if (hff == (HFF)0xFFFFFFFF)
      return;
   rc = fdhdr.pfddisp->FdQueryFaces(hff, &ifimet, sizeof(ifimet), 1, 0, NULL);
   printf("Querying faces... RC = %X\n", rc);
   hfc = fdhdr.pfddisp->FdOpenFontContext(hff, 0, NULL);
   printf("Opening context... HFC = %X\n", hfc);
   if (hfc == (HFC)0xFFFFFFFF) {
      rc = fdhdr.pfddisp->FdUnloadFontFile(hff, NULL);
      printf("Unloading font... RC = %X\n", rc);
   }
   ci.cb = sizeof(ci);
   ci.fl = 0;
   ci.sizlPPM.cx = 3618;
   ci.sizlPPM.cy = 3622; //3622
   ci.pfxSpot.x = 46340;
   ci.pfxSpot.y = 46340;
   ci.matXform.eM11 = 511;
   ci.matXform.eM12 = 0;
   ci.matXform.eM21 = 0;
   ci.matXform.eM22 = 511;
/*   ci.matXform.eM11 = 618;
   ci.matXform.eM12 = 166;
   ci.matXform.eM21 = 166;
   ci.matXform.eM22 = -618;
   ci.matXform.eM11 = 362;
   ci.matXform.eM12 = 362;
   ci.matXform.eM21 = -363;
   ci.matXform.eM22 = 362;*/

   rc = fdhdr.pfddisp->FdQueryFaceAttr(hfc, FD_QUERY_ABC_WIDTHS, buf,
                                       40 * sizeof(ABC_TRIPLETS), NULL, 0, NULL);
   printf("Querying face attrs... RC = %d\n", rc);

   rc = fdhdr.pfddisp->FdSetFontContext(hfc, &ci, NULL);
   printf("Setting context... rc = %X\n", rc);

   charattr.cb = sizeof(charattr);
   charattr.iQuery = FD_QUERY_BITMAPMETRICS | FD_QUERY_CHARIMAGE;
//   charattr.iQuery = FD_QUERY_OUTLINE;
   charattr.gi = glyph;
   charattr.pBuffer = buf;
   charattr.cbLen = BUFSIZE;
   if (rc == -1)
      return;
   rc = fdhdr.pfddisp->FdQueryCharAttr(hfc, &charattr, &bmm, NULL);
   printf("Querying char attrs... bytes = %d\n", rc);
   ShowChar(&charattr, &bmm);

//   rc = fdhdr.pfddisp->FdQueryCharAttr(hfc, &charattr, &bmm, NULL);
//   printf("Querying char attrs... bytes = %d\n", rc);

   hff2 = fdhdr.pfddisp->FdLoadFontFile(FNTNAME2, NULL);
   printf("Loading font... HFF = %X\n", hff2);
   if (hff2 == (HFF)0xFFFFFFFF)
      return;

   charattr.cbLen = 0;
   rc = fdhdr.pfddisp->FdQueryCharAttr(hfc, &charattr, &bmm, NULL);
   printf("Querying char attrs... bytes = %d\n", rc);
   rc = fdhdr.pfddisp->FdQueryFaces(hff2, &ifimet, sizeof(ifimet), 1, 0, NULL);
   printf("Querying faces... RC = %X\n", rc);
   hfc2 = fdhdr.pfddisp->FdOpenFontContext(hff2, 0, NULL);
   printf("Opening context... HFC = %X\n", hfc2);
   if (hfc2 == (HFC)0xFFFFFFFF) {
      rc = fdhdr.pfddisp->FdUnloadFontFile(hff2, NULL);
      printf("Unloading font... RC = %X\n", rc);
   }
   rc = fdhdr.pfddisp->FdCloseFontContext(hfc, NULL);
   printf("Closing context... RC = %X\n", rc);
   rc = fdhdr.pfddisp->FdUnloadFontFile(hff, NULL);
   printf("Unloading font... RC = %X\n", rc);

   rc = fdhdr.pfddisp->FdCloseFontContext(hfc2, NULL);
   printf("Closing context... RC = %X\n", rc);
   rc = fdhdr.pfddisp->FdUnloadFontFile(hff2, NULL);
   printf("Unloading font... RC = %X\n", rc);
}
