/* smileys.c */

#include <Xm/Xm.h>
#include <Xm/Label.h>
#include "globaldefs.h"
#include "smileys.h"
#include "bit_smiley.h"
#include "bit_saddy.h"

Pixmap	smileypix, saddypix ;

#ifdef	_NO_PROTO
static void	newsmiley() ;
static void	freesmiley() ;
static void	freeallsmileys() ;
#else
static void	newsmiley(Pixmap, list *) ;
static void	freesmiley(list *) ;
static void	freeallsmileys(list *) ;
#endif

/* allocate smiley pixmaps */
void	PrepareSmileys(toplevel)
Widget	toplevel ;
{
    smileypix =
	XCreatePixmapFromBitmapData(XtDisplay(toplevel),
				    RootWindowOfScreen(XtScreen(toplevel)),
				    smiley_bits, smiley_width, smiley_height,
				    fgpix, bgpix,
				    DefaultDepthOfScreen(XtScreen(toplevel))) ;
    saddypix =
	XCreatePixmapFromBitmapData(XtDisplay(toplevel),
				    RootWindowOfScreen(XtScreen(toplevel)),
				    saddy_bits, saddy_width, saddy_height,
				    fgpix, bgpix,
				    DefaultDepthOfScreen(XtScreen(toplevel))) ;
}

/* change number of smileys on lp from old to new */
void	AdjustSmileys(old, new, lp)
int	old, new ;
list	*lp ;
{
    if (old < new)	{
	if (old < 1 && new >= 1)	{
	    freeallsmileys(lp) ;
	    newsmiley(smileypix, lp) ;
	    old = 1 ;
	}
	if (old < 1)
	    while (old < new)	{
		freesmiley(lp) ;
		old++ ;
	    }
	else
	    while (old < new)	{
		newsmiley(smileypix, lp) ;
		old++ ;
	    }
    }
    else if (old > new)	{
	if (old >= 1 && new < 1)	{
	    freeallsmileys(lp) ;
	    newsmiley(saddypix, lp) ;
	    old = 0 ;
	}
	if (old > 0)
	    while (old > new)	{
		freesmiley(lp) ;
		old-- ;
	    }
	else
	    while (old > new)	{
		newsmiley(saddypix, lp) ;
		old-- ;
	    }
    }
}

/* append item to end of list */
static void	newsmiley(pixmap, lp)
Pixmap		pixmap ;
list		*lp ;
{
    int	first = True ;

    if (lp->next)
	first = False ;

    while (lp->next)
	lp = lp->next ;

    lp->next = (list *) xmalloc(sizeof(list)) ;
    lp->next->w = 
	XtVaCreateManagedWidget("smiley", xmLabelWidgetClass,
				XtParent(lp->w),
				XmNlabelType, XmPIXMAP,
				XmNlabelPixmap, pixmap,
				XmNleftAttachment, XmATTACH_WIDGET,
				XmNleftWidget, lp->w,
				XmNleftOffset, first ? 4 : 0,
				XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
				XmNtopWidget, lp->w,
				XmNtopOffset, 0,
				NULL) ;
    lp->next->next = NULL ;
}

/* remove item from the end of list; assume there is at least
   two items in list (the "box" and a smiley/saddy) */
static void	freesmiley(lp)
list		*lp ;
{
    while (lp->next->next)
	lp = lp->next ;

    XtDestroyWidget(lp->next->w) ;
    free(lp->next) ;
    lp->next = NULL ;
}

/* remove everything except the first item from the list */
static void	freeallsmileys(headp)
list		*headp ;
{
    list	*tmpp, *lp ;

    lp = headp->next ;
    headp->next = NULL ;

    while (lp)	{
	XtDestroyWidget(lp->w) ;
	tmpp = lp->next ;
	free(lp) ;
	lp = tmpp ;
    }
}
