/*
 * gl.h - Header file for gl.c graphics functions.  
 *
 * Note: This file can be included without including any X11 header files.
 *
 * Author:  John Sullivan, Amdahl Corporation (jjs40@cd.amdahl.com)
 *
 */

/*****************************************************************************/
/* Some defines.                                                       
*/
/*****************************************************************************/

#define GL_SCREEN_DEPTH		8
#define GL_FOREGROUND		"white"
#define GL_BACKGROUND		"black"
#ifdef vax11c
#define GL_FONT			"-misc-fixed-medium-r-normal--13-120-*-*-c-80-iso8859-1"
#else
#define GL_FONT				"8x13"
#endif /* vax11c */
#define GL_FONT_WIDTH		8
#define GL_FONT_HEIGHT		16
#define GL_FONT_DESCENT		13
#define GL_BUFSIZE			128

/*****************************************************************************/
/* Some GL types                                                       
*/
/*****************************************************************************/

#define GL_FALSE	0
#define GL_TRUE		1
typedef int     GL_BOOL;

#define GL_EVENT_KEY	0
#define GL_EVENT_BUTTON	1
typedef unsigned long GL_EVENT_TYPE;

typedef struct GL_EVENT_S {
	GL_EVENT_TYPE   type;
	int             x, y;
	int             button;
	char            key;
}               GL_EVENT;

typedef unsigned long GL_PIXEL;
typedef unsigned long GL_BITMAP;

typedef void    (*GL_REDRAW_FUNC) ();
typedef void    (*GL_EVENT_FUNC) ();

/*****************************************************************************/
/* Function externs.                                                   
*/
/*****************************************************************************/

extern void     gl_bomb();
extern GL_PIXEL gl_alloc_color();
extern void     gl_redraw_func();
extern void     gl_event_func();
extern char    *gl_event_str();
extern void     gl_main_loop();
extern void     gl_exit_main();
extern void     gl_set_fg();
extern void     gl_set_bg();
extern void     gl_set_fg_bg();
extern void     gl_draw_point();
extern void     gl_draw_line();
extern void     gl_draw_rect();
extern void     gl_fill_rect();
extern void     gl_draw_text();
extern void     gl_ring_bell();
extern GL_BITMAP gl_load_bitmap();
extern void     gl_draw_bitmap();
extern void     gl_init();
extern void     gl_start();
extern void     gl_exit();

/**********************************************************************
*******/

extern void     gu_draw_border();
extern void     gu_draw_centered_text();
extern GL_BOOL  gu_event_in_rect();

/**********************************************************************
*******/

#define GB_BUTTON_LABEL_LEN	16

typedef struct GB_BUTTON_S {
	int             x, y;
	int             w, h;
	GL_PIXEL        border;
	GL_PIXEL        background;
	GL_PIXEL        flash;
	GL_PIXEL        text;
	char            label[GB_BUTTON_LABEL_LEN];
	GL_EVENT_FUNC   event_fn;
}               GB_BUTTON;

/**********************************************************************
*******/

extern void     gb_draw_button();
extern void     gb_draw_buttons();
extern GL_BOOL  gb_event_in_button();
extern void     gb_button_press();
extern GL_BOOL  gb_button_event();
