 .ad l  .nh + .TH segment 1 "10 April 1993" "ImageMagick"  .SH NAMEC segment - segments an image with thresholding and the fuzzy c-Means 
 technique. .SH SYNOPSIS .B "segment"8 [ \fIoptions\fP ... ] \fIinput_file\fP \fIoutput_file\fP .SH DESCRIPTION H \fBsegment\fP segments an image by analyzing the histograms of the colorL components and identifying units that are homogeneous with the fuzzy c-meansG technique.  The scale-space filter analyzes the histograms of the three C color components of the image and identifies a set of classes.  The @ extents of each class is used to coarsely segment the image withD thresholding.  The color associated with each class is determined byF the mean color of all pixels within the extents of a particular class.G Finally, any unclassified pixels are assigned to the closest class with  the fuzzy c-means technique. .PP 9 The fuzzy c-Means algorithm can be summarized as follows:  .RS  .LP ? o Build a histogram, one for each color component of the image.  .LP C o For each histogram, successively apply the scale-space filter and D build an interval tree of zero crossings in the second derivative atB each scale.  Analyze this scale-space ``fingerprint'' to determine= which peaks or valleys in the histogram are most predominant.  .LP G o The fingerprint defines intervals on the axis of the histogram.  Each E interval contains either a minima or a maxima in the original signal. F If each color component lies within the maxima interval, that pixel isA considered ``classified'' and is assigned an unique class number.  .LP I o Any pixel that fails to be classified in the above thresholding pass is D classified using the fuzzy c-Means technique.  It is assigned to one: of the classes discovered in the histogram analysis phase. .RE  .PP L The fuzzy c-Means technique attempts to cluster a pixel by finding the localE minima of the generalized within group sum of squared error objective F function.  A pixel is assigned to the closest class of which the fuzzy membership has a maximum value.    For additional information see .IP L Young Won Lim, Sang Uk Lee, "On The Color Image Segmentation Algorithm BasedK on the Thresholding and the Fuzzy c-Means Techniques", Pattern Recognition, ) Volume 23, Number 9, pages 935-952, 1990.  .SH EXAMPLES .PP ' To segment an image of a cockatoo, use:  .PP  .B-      segment cockatoo.miff cockatoo.segmented  .PP & To segment a raw grayscale image, use: .PP  .B.      segment -size 768x512 gray:raw image.miff .SH OPTIONS  .TP 5 # .B "-cluster_threshold \fIvalue\fP" * eliminate clusters that are insignificant.  @ The number of pixels in each cluster must exceed the the cluster5 threshold to be considered valid.  The default is 1%.  .TP 5  .B "-colorspace \fIvalue\fP"E the type of colorspace: \fBGRAY\fP, \fBOHTA\fP, \fBRGB\fP, \fBXYZ\fP, 2 \fBYCbCr\fP, \fBYIQ\fP, \fBYPbPr\fP, or \fBYUV\fP.  @ Color reduction, by default, takes place in the RGB color space.F Empirical evidence suggests that distances in color spaces such as YUV> or YIQ correspond to perceptual color differences more closelyC than do distances in RGB space.  These color spaces may give better E results when color reducing an image.  Refer to \fBquantize(9)\fP for 
 more details.  .TP 5  .B "-comment \fIstring\fP"! annotate an image with a comment.   A By default, each image is commented with its file name.  Use this E option to assign a specific comment to the image.  Optionally you can C include the image filename, type, width, height, or scene number by B embedding special format characters.  Embed \fB%f\fP for filename,F \fB%m\fP for magick, \fB%w\fP for width, \fB%h\fP for height, \fB%s\fP9 for scene number, or \fB\\n\fP for newline.  For example,    .nf       -comment "%m:%f %wx%h"  .fi   F produces an image comment of \fBMIFF:bird.miff 512x480\fP for an image@ titled \fBbird.miff\fP and whose width is 512 and height is 480.  L If the first character of \fIstring\fP is \fB@\fP, the image comment is read= from a file titled by the remaining characters in the string.  .TP 5  .B "-compress \fItype\fP" H the type of image compression: \fIQEncoded\fP or \fIRunlengthEncoded\fP.  M Specify \fB\+compress\fP to store the binary image in an uncompressed format. @ The default is the compression type of the specified image file. .TP 5 # .B "-density \fI<width>x<height>\fP : vertical and horizontal resolution in pixels of the image.  = This option specifies an image density for a Postscript page. K The default is 72 pixels per inch in the horizontal and vertical direction. J The density is given to Ghostscript as the \fB-r\fP option when decoding a/ Postscript image.  See \fIgs(1)\fP for details.  .TP 5 ) .B "-display \fIhost:display[.screen]\fP" 2 specifies the X server to contact; see \fBX(1)\fP. .TP 5  .B "-font \fIname\fP" F This option specifies the font to be used  for displaying normal text. The default is \fBfixed\fP.  .TP 5  .B "-interlace \fItype\fP"G the type of interlacing scheme: \fBNONE\fP, \fBLINE\fP, or \fBPLANE\fP.   E This option is used to specify the type of interlacing scheme for raw F image formats such as \fBRGB\fP or \fBYUV\fP.  \fBNONE\fP means do not; interlace (RGBRGBRGBRGBRGBRGB...), \fBLINE\fP uses scanline H interlacing (RRR...GGG...BBB...RRR...GGG...BBB...), and \fBPLANE\fP uses0 plane interlacing (RRRRRR...GGGGGG...BBBBBB...).  A Use \fBLINE\fP, or \fBPLANE\fP to create an interlaced GIF image.  .TP 5  .B "-label \fIname\fP" assign a label to an image.   D Use this option to assign a specific label to the image.  OptionallyA you can include the image filename, type, width, height, or scene C number in the label by embedding special format characters.   Embed ? \fB%f\fP for filename, \fB%m\fP for magick, \fB%w\fP for width, @ \fB%h\fP for height, or \fB%s\fP for scene number.  For example, .nf       -label "%m:%f %wx%h"  .fi D produces an image label of \fBMIFF:bird.miff 512x480\fP for an image@ titled \fBbird.miff\fP and whose width is 512 and height is 480.  J If the first character of \fIstring\fP is \fB@\fP, the image label is read= from a file titled by the remaining characters in the string.   I When converting to Postscript, use this option to specify a header string  to print above the image.  .TP 5  .B "-matte" ) store matte channel if the image has one.  .TP 5 ? .B "-page \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP" 3 preferred size and location of the Postscript page.   C Use this option to specify the dimensions of the Postscript page in O pixels per inch or a TEXT page in pixels.  The default for a Postscript page is ; to center the image on a letter page 612 by 792 pixels. The @ margins are 1/2" (i.e.  612x792+36+36).  Other common sizes are:       Letter      612x 792     Tabloid     792x1224     Ledger     1224x 792     Legal       612x1008     Statement   396x 612     Executive   540x 720     A3          842x1190     A4          595x 842     A5          420x 595     B4          729x1032     B5          516x 729     Folio       612x 936     Quarto      610x 780     10x14       720x1008  < For convenience you can specify the page size by media (e.g. A4, Ledger, etc.).  K The page geometry is relative to the vertical and horizontal density of the 1 Postscript page.  See \fB-density\fP for details.   8 The default page dimensions for a TEXT image is 612x792. .TP 5  .B "-quality \fIvalue\fP"  JPEG quality setting.   6 Quality is 0 (worst) to 100 (best). The default is 85. .TP 5  .B "-scene \fIvalue\fP"  image scene number.  .TP 5 0 .B "-size \fI<width>{%}x<height>{%}{+colors}{!}" width and height of the image.  C Use this option to specify the width and height of raw images whose D dimensions are unknown such as \fBGRAY\fP, \fBRGB\fP, or \fBCMYK\fP.C In addition to width and height, use \fB-size\fP to tell the number > of colors in a \fBMAP\fP image file, (e.g. -size 640x512+256). .TP 5 % .B "-smoothing_threshold \fIvalue\fP" : eliminate noise in the second derivative of the histogram.  L As the value is increased, you can expect a smoother second derivative.  The default is 1.5.  .TP 5  .B -verbose + print detailed information about the image.   H This information is printed: image scene number;  image name;  converted? image name;  image size;  the image class (\fIDirectClass\fP or G \fIPseudoClass\fP);  the total number of unique colors;  and the number ) of seconds to read and convert the image.  .PP , Options are processed in command line order.H Any option you specify on the command line remains in effect until it isJ explicitly changed by specifying the option again with a different effect. .PP A Change '-' to '+' in any option above to reverse its effect.  For E example, specify +matte to store the image without its matte channel.  .PP B By default, the image format is determined by its magic number. ToE specify a particular image format, precede the filename with an image D format name and a colon (i.e. ps:image) or specify the image type asE the filename suffix (i.e. image.ps).  See \fBconvert(1)\fP for a list  of valid image formats.  .PP E When you specify \fBX\fP as your image type, the filename has special E meaning.  It specifies an X window by id, name, or \fBroot\fP.  If no F filename is specified, the window is selected by clicking the mouse in the desired window.  .PP 7 Specify \fIinput_file\fP as \fI-\fP for standard input, F \fIoutput_file\fP as \fI-\fP for standard output.  If \fIinput_file\fPF has the extension \fB.Z\fP or \fB.gz\fP, the file is uncompressed withD \fBuncompress\fP or \fBgunzip\fP respectively.  If \fIoutput_file\fPD has the extension \fB.Z\fP or \fB.gz\fP, the file size is compressedG using with \fBcompress\fP or \fBgzip\fP respectively.  Finally, precede E the image file name with \fI|\fP to pipe to or from a system command.  .PP G Use an optional index enclosed in brackets after a file name to specify C a desired subimage of a multi-resolution image format like Photo CD  (e.g. img0001.pcd[4]). .PP G If \fIoutput_file\fP already exists, you will be prompted as to whether  it should be overwritten.  .SH ENVIRONMENT  .PP  .TP 5 
 .B display4 To get the default host, display number, and screen. .SH SEE ALSO .BF display(1), animate(1), import(1), montage(1), mogrify(1), convert(1), combine(1), xtp(1)
 .SH COPYRIGHT 3 Copyright 1995 E. I. du Pont de Nemours and Company  .PP G Permission to use, copy, modify, distribute, and sell this software and @ its documentation for any purpose is hereby granted without fee,F provided that the above copyright notice appear in all copies and that? both that copyright notice and this permission notice appear in G supporting documentation, and that the name of E. I. du Pont de Nemours A and Company not be used in advertising or publicity pertaining to < distribution of the software without specific, written priorJ permission.  E. I. du Pont de Nemours and Company makes no representationsG about the suitability of this software for any purpose.  It is provided , "as is" without express or implied warranty. .PP I E. I. du Pont de Nemours and Company disclaims all warranties with regard E to this software, including all implied warranties of merchantability F and fitness, in no event shall E. I. du Pont de Nemours and Company be@ liable for any special, indirect or consequential damages or anyG damages whatsoever resulting from loss of use, data or profits, whether F in an action of contract, negligence or other tortuous action, arisingE out of or in connection with the use or performance of this software.  .SH ACKNOWLEDGEMENTSG Andy Gallo, University of Delaware.  This software is strongly based on  software Andy wrote. .SH AUTHORS = John Cristy, E.I. du Pont De Nemours and Company Incorporated 