 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %               SSSSS  EEEEE   GGGG  M   M  EEEEE  N   N  TTTTT               % O %               SS     E      G      MM MM  E      NN  N    T                 % O %                SSS   EEE    G GGG  M M M  EEE    N N N    T                 % O %                  SS  E      G   G  M   M  E      N  NN    T                 % O %               SSSSS  EEEEE   GGGG  M   M  EEEEE  N   N    T                 % O %                                                                             % O %                                                                             % O %     Segment an Image with Thresholding and the Fuzzy c-Means Technique.     % O %                                                                             % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                April 1993                                   % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. Dupont de Nemours and Company                         % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. Dupont de Nemours     % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. Dupont de Nemours and Company makes no representations  % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. Dupont de Nemours and Company disclaims all warranties with regard   % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. Dupont de Nemours and Company be      % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Segment segments an image by analyzing the histograms of the color G %  components and identifying units that are homogeneous with the fuzzy H %  c-means technique.  The scale-space filter analyzes the histograms ofK %  the three color components of the image and identifies a set of classes. G %  The extents of each class is used to coarsely segment the image with G %  thresholding.  The color associated with each class is determined by I %  the mean color of all pixels within the extents of a particular class. J %  Finally, any unclassified pixels are assigned to the closest class with %  the fuzzy c-means technique.  % < %  The fuzzy c-Means algorithm can be summarized as follows: % D %    o Build a histogram, one for each color component of the image. % = %    o For each histogram, successively apply the scale-space = %      filter and build an interval tree of zero crossings in 9 %      the second derivative at each scale.  Analyze this ? %      scale-space ``fingerprint'' to determine which peaks and 5 %      valleys in the histogram are most predominant.  % ; %    o The fingerprint defines intervals on the axis of the > %      histogram.  Each interval contains either a minima or a> %      maxima in the original signal.  If each color component@ %      lies within the maxima interval, that pixel is considered= %      ``classified'' and is assigned an unique class number.  % 9 %    o Any pixel that fails to be classified in the above 6 %      thresholding pass is classified using the fuzzy? %      c-Means technique.  It is assigned to one of the classes 2 %      discovered in the histogram analysis phase. % E %  The fuzzy c-Means technique attempts to cluster a pixel by finding H %  the local minima of the generalized within group sum of squared errorI %  objective function.  A pixel is assigned to the closest class of which , %  the fuzzy membership has a maximum value. % J %  Segment is strongly based on software written by Andy Gallo, University %  of Delaware.  % = %  The following reference was used in creating this program:  % K %    Young Won Lim, Sang Uk Lee, "On The Color Image Segmentation Algorithm I %    Based on the Thresholding and the Fuzzy c-Means Techniques", Pattern ; %    Recognition, Volume 23, Number 9, pages 935-952, 1990.  % ! %  The segment program syntax is:  % 6 %  Usage: segment [options ...] input_file output_file %  %  Where options include:  %    -cluster_threshold value > %                        minimum percent of pixels per clusterH %    -colorspace type    GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV4 %    -comment string     annotate image with comment5 %    -compress type      RunlengthEncoded or QEncoded E %    -density geometry   vertical and horizontal density of the image @ %    -display server     obtain image or font from this X server5 %    -font name          X11 font for displaying text - %    -interlace type     NONE, LINE, or PLANE 3 %    -label name         assign a label to an image A %    -matte              store matte channel if the image has one A %    -page geometry      size and location of the Postscript page - %    -quality value      JPEG quality setting  %    -smoothing_threshold value A %                        smoothing threshold of second derivative + %    -scene value        image scene number 2 %    -size geometry      width and height of image? %    -treedepth value    depth of the color classification tree C %    -verbose            print detailed information about the image  % D %  Change '-' to '+' in any option above to reverse its effect.  ForI %  example,  specify +matte to store the image without its matte channel.  % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  */   #include "magick.h"  #include "image.h" #include "X.h" #include "utility.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Procedure Usage displays the program usage; % & %  The format of the Usage routine is: %  %      Usage() %  %  */ static void Usage()  {    char     **p;  
   static char      *options[]=      { !       "-cluster_threshold value", B       "                    minimum percent of pixels per cluster",L       "-colorspace type    GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV",8       "-comment string     annotate image with comment",9       "-compress type      RunlengthEncoded or QEncoded", I       "-density geometry   vertical and horizontal density of the image", D       "-display server     obtain image or font from this X server",9       "-font name          X11 font for displaying text", 1       "-interlace type     NONE, LINE, or PLANE", 7       "-label name         assign a label to an image", E       "-matte              store matte channel if the image has one", E       "-page geometry      size and location of the Postscript page", 1       "-quality value      JPEG quality setting", #       "-smoothing_threshold value", E       "                    smoothing threshold of second derivative", /       "-scene value        image scene number", 6       "-size geometry      width and height of image",C       "-treedepth value    depth of the color classification tree", G       "-verbose            print detailed information about the image",        (char *) NULL      };  +   (void) printf("Version: %s\n\n",Version); C   (void) printf("Usage: %s [options ...] input_file output_file\n",      client_name); .   (void) printf("\nWhere options include:\n");+   for (p=options; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    (void) printf(M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) printf(O     "example,  specify +matte to store the image without an matte channel.\n");    (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n"); 
   exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  M a i n                                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */ int main(argc,argv)  int    argc;    char
   *argv[]; { + #define NotInitialized  (unsigned int) (~0)      char     *filename,     *option;     float      cluster_threshold,     smoothing_threshold;     Image      *image,      *next_image;     ImageInfo      image_info;      int      i,     status,      x;     unsigned int     colorspace,      compression,
     matte,
     scene;     /*!     Initialize program variables.    */   client_name=argv[0];   if (argc < 3)      Usage();   /**     Read image and convert to MIFF format.   */   cluster_threshold=1.0;   colorspace=RGBColorspace; #   compression=UndefinedCompression;    image=(Image *) NULL;    GetImageInfo(&image_info);   matte=NotInitialized; 
   scene=0;   smoothing_threshold=1.5;   /*     Check command syntax.    */   filename=(char *) NULL;    for (i=1; i < (argc-1); i++)   {      option=argv[i]; M     if (((int) strlen(option) < 2) || ((*option != '-') && (*option != '+')))        { 
         /*           Read input image. 
         */         filename=argv[i]; 4         (void) strcpy(image_info.filename,filename);$         if (image != (Image *) NULL):           Error("input image already specified",filename);%         image=ReadImage(&image_info); $         if (image == (Image *) NULL)           exit(1);       }      else       switch(*(option+1))        {          case 'c': 	         { ;           if (strncmp("cluster_threshold",option+1,2) == 0) 
             { $               cluster_threshold=0.0;!               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))O                     Error("Missing value on -cluster_threshold",(char *) NULL);                  } .               cluster_threshold=atof(argv[i]);               break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { '               colorspace=RGBColorspace; !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL); !                   option=argv[i]; 1                   colorspace=UndefinedColorspace; 8                   if (Latin1Compare("gray",option) == 0).                     colorspace=GRAYColorspace;8                   if (Latin1Compare("ohta",option) == 0).                     colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0) -                     colorspace=RGBColorspace; 7                   if (Latin1Compare("xyz",option) == 0) -                     colorspace=XYZColorspace; 9                   if (Latin1Compare("ycbcr",option) == 0) /                     colorspace=YCbCrColorspace; 7                   if (Latin1Compare("yiq",option) == 0) -                     colorspace=YIQColorspace; 9                   if (Latin1Compare("ypbpr",option) == 0) /                     colorspace=YPbPrColorspace; 7                   if (Latin1Compare("yuv",option) == 0) -                     colorspace=YUVColorspace; 8                   if (colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);                  }                break;
             } 1           if (strncmp("comment",option+1,4) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing comment on -comment",(char *) NULL);                  }                break;
             } 2           if (strncmp("compress",option+1,3) == 0)
             { (               compression=NoCompression;!               if (*option == '-')                  {                    i++;                    if (i == argc)E                     Error("Missing type on -compress",(char *) NULL); !                   option=argv[i]; D                   if (Latin1Compare("runlengthencoded",option) == 0)<                     compression=RunlengthEncodedCompression;                   else>                     if (Latin1Compare("qencoded",option) == 0)6                       compression=QEncodedCompression;                     elseL                       Error("Invalid compression type on -compress",option);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'd': 	         { 1           if (strncmp("density",option+1,3) == 0) 
             { /               image_info.density=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];                  }                break;
             } 1           if (strncmp("display",option+1,3) == 0) 
             { 3               image_info.server_name=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL); 1                   image_info.server_name=argv[i];                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'f': 	         { (           image_info.font=(char *) NULL;           if (*option == '-') 
             {                i++;               if (i == argc)B                 Error("Missing font name on -font",(char *) NULL);&               image_info.font=argv[i];
             }            break;	         }          case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)
             {                Usage(True);               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'i': 	         { 3           if (strncmp("interlace",option+1,3) == 0) 
             { 1               image_info.interlace=NoneInterlace; !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace; 8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace; 9                   if (Latin1Compare("plane",option) == 0) 8                     image_info.interlace=PlaneInterlace;A                   if (image_info.interlace == UndefinedInterlace) I                     Error("Invalid interlace type on -interlace",option);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'l': 	         { /           if (strncmp("label",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing label name on -label",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'm': 	         { /           if (strncmp("matte",option+1,5) == 0) 
             { %               matte=(*option == '-');                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'p': 	         { .           if (strncmp("page",option+1,2) == 0)
             { ,               image_info.page=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)J                     Error("Missing page geometry on -page",(char *) NULL);>                   image_info.page=PostscriptGeometry(argv[i]);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'q': 	         {            i++;6           if ((i == argc) || !sscanf(argv[i],"%d",&x))?             Error("Missing quality on -quality",(char *) NULL); +           image_info.quality=atoi(argv[i]);            break;	         }          case 's': 	         { /           if (strncmp("scene",option+1,2) == 0) 
             {                scene=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))C                     Error("Missing value on -scene",(char *) NULL);                  } "               scene=atoi(argv[i]);               break;
             } .           if (strncmp("size",option+1,2) == 0)
             { ,               image_info.size=(char *) NULL;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -size",(char *) NULL); *                   image_info.size=argv[i];                 }                break;
             } =           if (strncmp("smoothing_threshold",option+1,2) == 0) 
             { &               smoothing_threshold=0.0;!               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))B                     Error("Missing value on -smoothing_threshold",%                       (char *) NULL);                  } 0               smoothing_threshold=atof(argv[i]);               break;
             }            break;	         }          case 'v': 	         { 1           if (strncmp("verbose",option+1,2) == 0) 
             { 2               image_info.verbose=(*option == '-');               break;
             } .           Error("Unrecognized option",option);           break;	         }          case '?': 	         {            Usage();           break;	         }          default:	         { .           Error("Unrecognized option",option);           break;	         }        }    }    if (image == (Image *) NULL)6     Error("Missing an image file name",(char *) NULL);   /*     Write images.    */   do   {       if (matte != NotInitialized)       image->matte=matte; ,     if (compression != UndefinedCompression)%       image->compression=compression;      if (scene != 0)        image->scene=scene; +     (void) strcpy(image->filename,argv[i]); *     if (image->previous != (Image *) NULL)C       (void) sprintf(image->filename,"%s.%u",argv[i],image->scene);      /*D       Transmogrify image as defined by the image processing options.     *//     MogrifyImage(&image_info,argc,argv,&image);      /*/       Reduce the number of colors in the image.      */I     SegmentImage(image,colorspace,image_info.verbose,smoothing_threshold,        cluster_threshold);      if (image_info.verbose)        QuantizationError(image);      SyncImage(image); )     status=WriteImage(&image_info,image);      if (image_info.verbose)        DescribeImage(image);      next_image=image->next;      DestroyImage(image);     image=next_image; $   } while (image != (Image *) NULL);%   free((char *) image_info.filename); 
   exit(0);   return(False); } 