 .ad l  .nh ) .TH quantize 9 "1 May 1994" "ImageMagick"  .SH NAME3 Quantize - ImageMagick's color reduction algorithm.  .SH SYNOPSIS .B #include <image.h>  .SH DESCRIPTION L This document describes how \fBImageMagick\fP performs color reduction on anF image.  To fully understand this document, you should have a knowledgeH of basic imaging techniques and the tree data structure and terminology. .PP F For purposes of color allocation, an image is a set of \fIn\fP pixels,G where each pixel is a point in RGB space.  RGB space is a 3-dimensional D vector space, and each pixel, \fIp\d\s-3i\s0\u\fP,  is defined by anF ordered triple of red, green, and blue coordinates, (\fIr\d\s-3i\s0\u,! g\d\s-3i\s0\u, b\d\s-3i\s0\u\fP).  .PP @ Each primary color component (red, green, or blue) represents an: intensity which varies linearly from 0 to a maximum value,C \fIc\d\s-3max\s0\u\fP, which corresponds to full saturation of that C color.  Color allocation is defined over a domain consisting of the 7 cube in RGB space with opposite vertices at (0,0,0) and K (\fIc\d\s-3max\s0\u,c\d\s-3max\s0\u,c\d\s-3max\s0\u\fP).  \fBImageMagick\fP % requires \fIc\d\s-3max\s0\u = 255\fP.  .PP = The algorithm maps this domain onto a tree in which each node C represents a cube within that domain.  In the following discussion, G these cubes are defined by the coordinate of two opposite vertices: The G vertex nearest the origin in RGB space and the vertex farthest from the  origin.  .PP F The tree's root node represents the the entire domain, (0,0,0) throughM (\fIc\d\s-3max\s0\u,c\d\s-3max\s0\u,c\d\s-3max\s0\u\fP).  Each lower level in G the tree is generated by subdividing one node's cube into eight smaller C cubes of equal size.  This corresponds to bisecting the parent cube 7 with planes passing through the midpoints of each edge.  .PP A The basic algorithm operates in three phases:  \fBClassification, B Reduction\fP, and \fBAssignment\fP.  \fBClassification\fP builds aD color description tree for the image.  \fBReduction\fP collapses theE tree until the number it represents, at most, is the number of colors A desired in the output image.  \fBAssignment\fP defines the output D image's color map and sets each pixel's color by reclassification in the reduced tree.  .PP G \fBClassification\fP begins by initializing a color description tree of B sufficient depth to represent each possible input color in a leaf.G However, it is impractical to generate a fully-formed color description 8 tree in the classification phase for realistic values ofB \fIc\d\s-3max\s0\u\fP.  If color components in the input image are@ quantized to \fIk\fP-bit precision, so that \fIc\d\s-3max\s0\u =E 2\u\s-3k\s0\d-1\fP, the tree would need \fIk\fP levels below the root E node to allow representing each possible input color in a leaf.  This ? becomes prohibitive because the tree's total number of nodes is  .PP 0         \fI\s+6\(*S\u\s-9 k\d\di=1\s0 8k\fP\s0\u .PP < A complete tree would require 19,173,961 nodes for \fIk = 8,? c\d\s-3max\s0\u = 255\fP.  Therefore, to avoid building a fully F populated tree, \fBImageMagick\fP: (1) Initializes data structures forG nodes only as they are needed; (2) Chooses a maximum depth for the tree A as a function of the desired number of colors in the output image D (currently \fIlog\d\s-34\s0\u(colormap size)\+2\fP).  A tree of thisG depth generally allows the best representation of the source image with ? the fastest computational speed and the least amount of memory. < However, the default depth is inappropriate for some images.8 Therefore, the caller can request a specific tree depth. .PP E For each pixel in the input image, classification scans downward from F the root of the color description tree.  At each level of the tree, it? identifies the single node which represents a cube in RGB space E containing the pixel's color.  It updates the following data for each 
 such node: .TP 5  .B n\d\s-31\s0\u: D Number of pixels whose color is contained in the RGB cube which this node represents; .TP 5  .B n\d\s-32\s0\u: B Number of pixels whose color is not represented in a node at lowerE depth in the tree;  initially,  \fIn\d\s-32\s0\u = 0\fP for all nodes  except leaves of the tree. .TP 5 / .B S\d\s-3r\s0\u, S\d\s-3g\s0\u, S\d\s-3b\s0\u: D Sums of the red, green, and blue component values for all pixels not? classified at a lower depth.  The combination of these sums and D \fIn\d\s-32\s0\u\fP will ultimately characterize the mean color of a' set of pixels represented by this node.  .PP I \fBReduction\fP repeatedly prunes the tree until the number of nodes with N \fIn\d\s-32\s0\u  > 0\fP is less than or equal to the maximum number of colorsF allowed in the output image.  On any given iteration over the tree, itN selects those nodes whose \fIn\d\s-31\s0\u\fP count is minimal for pruning andC merges their color statistics upward.  It uses a pruning threshold, 9 \fIn\d\s-3p\s0\u\fP, to govern node selection as follows:  .PP    n\d\s-3p\s0\u = 0 T   while number of nodes with (n\d\s-32\s0\u > 0) > required maximum number of colors>       prune all nodes such that n\d\s-31\s0\u <= n\d\s-3p\s0\uE       Set n\d\s-3p\s0\u  to minimum n\d\s-31\s0\u  in remaining nodes  .PP E When a node to be pruned has offspring, the pruning procedure invokes E itself recursively in order to prune the tree from the leaves upward. E The values of \fIn\d\s-32\s0\u  S\d\s-3r\s0\u, S\d\s-3g\s0\u,\fP  and B \fIS\d\s-3b\s0\u\fP in a node being pruned are always added to theB corresponding data in that node's parent.  This retains the pruned1 node's color characteristics for later averaging.  .PP D For each node,  \fIn\d\s-32\s0\u\fP pixels exist for which that nodeD represents the smallest volume in RGB space containing those pixel'sF colors.  When \fIn\d\s-32\s0\u  > 0\fP the node will uniquely define a: color in the output image.  At the beginning of reduction,D \fIn\d\s-32\s0\u = 0\fP  for all nodes except the leaves of the tree2 which represent colors present in the input image. .PP @ The other pixel count, \fIn\d\s-31\s0\u\fP,  indicates the totalC number of colors within the cubic volume which the node represents. E This includes \fIn\d\s-31\s0\u - n\d\s-32\s0\u\fP pixels whose colors 8 should be defined by nodes at a lower level in the tree. .PP F \fBAssignment\fP generates the output image from the pruned tree.  TheB output image consists of two parts:  (1)  A color map, which is anG array of color descriptions (RGB triples) for each color present in the C output image; (2)  A pixel array, which represents each pixel as an  index into the color map array.  .PP @ First, the assignment phase makes one pass over the pruned colorC description tree to establish the image's color map.  For each node : with \fIn\d\s-32\s0\u > 0\fP, it divides \fIS\d\s-3r\s0\u,G S\d\s-3g\s0\u\fP, and \fPS\d\s-3b\s0\u\fP by \fIn\d\s-32\s0\u\fP.  This F produces the mean color of all pixels that classify no lower than this> node.  Each of these colors becomes an entry in the color map. .PP C Finally, the assignment phase reclassifies each pixel in the pruned D tree to identify the deepest node containing the pixel's color.  TheF pixel's value in the pixel array becomes the index of this node's mean color in the color map.  .PP B Empirical evidence suggests that distances in color spaces such asC YUV, or YIQ correspond to perceptual color differences more closely C than do distances in RGB space.  These color spaces may give better I results when color reducing an image.  Here the algorithm is as described L except each pixel is a point in the alternate color space.  For convenience,F the color components are normalized to the range 0 to a maximum value,J \fIc\d\s-3max\s0\u\fP.  The color reduction can then proceed as described.% .SH "MEASURING COLOR REDUCTION ERROR"  .PP C Depending on the image, the color reduction error may be obvious or A invisible.  Images with high spatial frequencies (such as hair or B grass) will show error much less than pictures with large smoothlyA shaded areas (such as faces).  This is because the high-frequency E contour edges introduced by the color reduction process are masked by " the high frequencies in the image. .PP G To measure the difference between the original and color reduced images I (the total color reduction error), \fBImageMagick\fP sums over all pixels C in an image the distance squared in RGB space between each original O pixel value and its color reduced value. \fBImageMagick\fP prints several error K measurements including the mean error per pixel, the normalized mean error, ! and the normalized maximum error.  .PP C The normalized error measurement can be used to compare images.  In D general, the closer the mean error is to zero the more the quantized? image resembles the source image.  Ideally, the error should be = perceptually-based, since the human eye is the final judge of  quantization quality.  .PP K These errors are measured and printed when \fB-verbose\fP and \fB-colors\fI " are specified on the command line: .TP 5  .B mean error per pixel:4 is the mean error for any single pixel in the image. .TP 5   .B normalized mean square error:L is the normalized mean square quantization error for any single pixel in the image.  F This distance measure is normalized to a range between 0 and 1.  It isE independent of the range of red, green, and blue values in the image.  .TP 5 # .B normalized maximum square error: B is the largest normalized square quantization error for any single pixel in the image.   F This distance measure is normalized to a range between 0 and 1.  It isE independent of the range of red, green, and blue values in the image.  .SH SEE ALSO .B6 display(1), animate(1), mogrify(1), import(1), miff(5)
 .SH COPYRIGHT 3 Copyright 1995 E. I. du Pont de Nemours and Company  .PP G Permission to use, copy, modify, distribute, and sell this software and @ its documentation for any purpose is hereby granted without fee,F provided that the above copyright notice appear in all copies and that? both that copyright notice and this permission notice appear in G supporting documentation, and that the name of E. I. du Pont de Nemours A and Company not be used in advertising or publicity pertaining to < distribution of the software without specific, written priorJ permission.  E. I. du Pont de Nemours and Company makes no representationsG about the suitability of this software for any purpose.  It is provided , "as is" without express or implied warranty. .PP I E. I. du Pont de Nemours and Company disclaims all warranties with regard E to this software, including all implied warranties of merchantability F and fitness, in no event shall E. I. du Pont de Nemours and Company be@ liable for any special, indirect or consequential damages or anyG damages whatsoever resulting from loss of use, data or profits, whether F in an action of contract, negligence or other tortuous action, arisingE out of or in connection with the use or performance of this software.  .SH ACKNOWLEDGEMENTSC Paul Raveling, USC Information Sciences Institute, for the original B idea of using space subdivision for the color reduction algorithm.I With Paul's permission, this document is an adaptation from a document he  wrote. .SH AUTHORS = John Cristy, E.I. du Pont de Nemours and Company Incorporated 