 .ad l  .nh % .TH MIFF 5 "1 May 1994" "ImageMagick"  .SH NAMED MIFF - Magick Image File Format is a platform-independent format forD storing bitmap images.  MIFF is a part of the ImageMagick toolkit ofE image manipulation utilities for the X Window System.  ImageMagick is H capable of converting many different image file formats to and from MIFF (e.g. JPEG, XPM, TIFF, etc.).  .SH SYNOPSIS .B #include <image.h>  .SH DESCRIPTION B A MIFF image file consist of two sections.  The first section is aC header composed of keywords describing the image in text form.  The D next section is the binary image data.  The header is separated from> the image databy a \fB:\fP character immediately followed by a \fBnewline\fP. .PP E The MIFF header is composed entirely of ASCII characters.  The fields 6 in the header are keyword and value combination in theG \fIkeyword=value\fP format, with each keyword and value separated by an E equal sign (=).  Each \fIkeyword=value\fP combination is delimited by E at least one control or whitespace character.  Comments may appear in G the header section and are always delimited by braces.  The MIFF header C always ends with a colon (:) character, followed by a \fBnewline\fP F character.  It is also common for a \fBformfeed\fP and a \fBnewline\fPA character to appear before the colon. You can then list the image C keywords with \fImore(1)\fP, without printing the binary image that  follows the colon separator. .PP G The following is a list of \fIkeyword=value\fP combinations that may be  found in a MIFF file:  .TP 5  .B "class=\fIDirectClass\fP" .B "class=\fBPseudoClass\fP"D indicates the type of binary image data stored in the MIFF file.  IfE this keyword is not present, \fBDirectClass\fP image data is assumed.  .TP 5  .B "colors=\fIvalue\fP" B specifies the number of colors in a \fBDirectClass\fP image. For a? \fBPseudoClass\fP image, this keyword specifies the size of the F colormap.  If this keyword is not present in the header, and the imageC is \fBPseudoClass\fP, a linear 256 color grayscale colormap is used  with the image data. .TP 5  .B "columns=\fIvalue\fP"K indicates the width of the image in pixels.  This is a required keyword and  has no default.  .TP 5 ' .B "compression=\fBRunlengthEncoded\fP"  .B "compression=\fBQEncoded\fP" I indicates the type of algorithm used to compress the image data.  If this E keyword is not present, the image data is assumed to be uncompressed.  .TP 5  .B "id=\fBImageMagick\fP" M The id keyword identifies the file as a MIFF-format image file.  This keyword  is required and has no default.  .TP 5  .B "matte=\fBTrue\fP"  .B "matte=\fBFalse\fP"G specifies whether a \fBDirectClass\fP image has matte data.  Matte data G is generally useful for image compositing.  This keyword has no meaning  for pseudo-color images. .TP 5 @ .B "montage=\fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fPD size and location of the individual tiles of a composite image.  See8 \fBX(1)\fP for details about the geometry specification. .PP G Use this keyword when the image is a composite of a number of different A tiles.  A tile consists of an image and optionally a border and a F label.  \fI<width>\fP is the size in pixels of each individual tile inG the horizontal direction and \fI<height>\fP is the size in the vertical F direction.  Each tile must have an equal number of pixels in width andG equal in height.  However, the width can differ from the height.  \fI<x F offset>\fP is the offset in number of pixels from the vertical edge ofB the composite image where the first tile of a row begins and \fI<yF offset>\fP is the offset from the horizontal edge where the first tile of a column begins.  .PP G If this keyword is specified, a directory of tile names must follow the > image header.  The format of the directory is explained below. .TP 5  .B "packets=\fIvalue\fP"B specifies the number of compressed color packets in the image data= section.  This keyword is optional for \fBRunlengthEncoded\fP = images, mandatory for \fBQEncoded\fP images, and not used for  uncompressed image.  .TP 5  .B "rows=\fIvalue\fP" H indicates the height of the image in pixels.  This is a required keyword and has no default.  .TP 5  .B "scene=\fIvalue\fP"F indicates the sequence number for this MIFF image file.  This optionalD keyword is used when a MIFF image file is one in a sequence of files used in an animation.  .TP 5  .B "signature=\fIvalue\fP"@ this optional keyword contains a string that uniquely identifiesG the image colormap.  Unique colormap identifiers are normally used when 1 animating a sequence of \fBPseudoClass\fP images.  .PP K The following is a sample MIFF header.  In this example, <FF> is a formfeed 
 character: .PP      { *       Rendered via Dore by Sandy Tennyson.     }      id=ImageMagickM     class=PseudoClass  colors=256  signature=d79e1c308aa5bbcdeea8ed63df412da9 /     compression=RunlengthEncoded  packets=27601      columns=1280  rows=1024      scene=1      <FF>     :  .PP J Note that \fIkeyword=value\fP combinations may be separated by newlines orF spaces and may occur in any order within the header.  Comments (within- braces) may appear anywhere before the colon.  .PP > If you specify the \fBmontage\fP keyword in the header, followG the header with a directory of image tiles.  This directory consists of : a name for each tile of the composite image separated by aG \fBnewline\fP character.  The list is terminated with a NULL character.  .PP E Following the header (or image directory if the \fBmontage\fP keyword A is in the header) is the binary image data itself.  How the image F data is formatted depends upon the class of the image as specified (orE not specified) by the value of the \fBclass\fP keyword in the header.  .PP E \fBDirectClass\fP images (class=DirectClass) are continuous-tone, RGB F images stored as intensity values in red-green-blue order.  Each colorL value is one byte in size [0..255] and there are three bytes per pixel (four? with an optional matte value).  The total number of pixels in a F \fBDirectClass\fP image is calculates by multiplying the rows value by the column value in the header.  .PP @ \fBPseudoClass\fP images (class=PseudoClass) are colormapped RGBC images.  The colormap is stored as a series of red-green-blue pixel @ values, each value being a byte in size.  The number of colormap@ entries is indicated by the colors keyword in the header, with aB maximum of 65,535 total entries allowed.  The colormap data occurs; immediately following the header (or image directory if the ( \fBmontage\fP keyword is in the header). .PP G \fBPseudoClass\fP image data is an array of index values into the color G map.  If these are 256 or fewer colors in the image, each byte of image B data contains an index value.  If the image contains more than 256G colors, then the index value is stored as two contiguous bytes with the C most significant byte being first.  The total number of pixels in a F \fBPseudoClass\fP image is calculated by multiplying the rows value by  the columns value in the header. .PP F MIFF is capable of storing a digital signature for colormapped images.A This signature was developed for use when animating a sequence of F images on a colormapped X server.  All of the signatures in a sequenceD of MIFF files are checked, and if they all match, you do not need to compute a global colormap. .PP E The default colormap identifier is a digital signature computed using D RSA's Data Security MD5 Digest Algorithm. (See a description of thisF algorithm in Internet draft, [MD5], July 1992.  The colormap signatureE is computed if the MIFF file is part of a scene (i.e. the scene value  does not equal 0). .PP F The image data in a MIFF file may be uncompressed or may be compressedC using one of two algorithms.  The compression keyword in the header C indicates how the image data is compressed. The run-length encoding @ (RLE) algorithm may be used to encode image data into packets ofA compressed data.  For \fBDirectClass\fP images, runs of identical F pixels values (not BYTE values) are encoded into a series of four-byteC packets (five bytes if a matte value is included).  The first three B bytes of the packet contain the red, green, and blue values of theG pixel in the run.  The fourth byte contains the number of pixels in the A run.  This value is in the range of 0 to 255 and is one less than D the actual number of pixels in the run.  For example, a value of 127/ indicates that there are 128 pixels in the run.  .PP F For \fBPseudoClass\fP images, the same RLE algorithm is used.  Runs ofF identical index values are encoded into packets.  Each packet containsF the colormap index value followed by the number of index values in theB run.  The number of bytes n a \fBPseudoClass\fP RLE packet will beF either two or three, depending upon the size of the index values.  TheD number of RLE packets stored in the file is specified by the packets+ keyword in the header, but is not required.  .PP ? A more complex algorithm, the predictive arithmetic compression G algorithm found in the lossless JPEG compression scheme, may be used to @ to achieve a greater compression ratio than run-length encoding.G \fBPseudoClass\fP images are first promoted to \fBDirectClass\fP before A encoding.  The number of compressed packets stored in the file is / specified by the packets keyword in the header.  .PP D MIFF files may contain more than one image.  Simply concatenate eachE individual image (composed of a header and image data) into one file.  .SH SEE ALSO .B[ display(1), animate(1), import(1), montage(1), mogrify(1), convert(1), more(1), compress(1) 
 .SH COPYRIGHT 3 Copyright 1995 E. I. du Pont de Nemours and Company  .PP G Permission to use, copy, modify, distribute, and sell this software and @ its documentation for any purpose is hereby granted without fee,F provided that the above copyright notice appear in all copies and that? both that copyright notice and this permission notice appear in G supporting documentation, and that the name of E. I. du Pont de Nemours A and Company not be used in advertising or publicity pertaining to < distribution of the software without specific, written priorJ permission.  E. I. du Pont de Nemours and Company makes no representationsG about the suitability of this software for any purpose.  It is provided , "as is" without express or implied warranty. .PP I E. I. du Pont de Nemours and Company disclaims all warranties with regard E TO this software, including all implied warranties of merchantability F and fitness, in no event shall E. I. du Pont de Nemours and Company be@ liable for any special, indirect or consequential damages or anyG damages whatsoever resulting from loss of use, data or profits, whether F in an action of contract, negligence or other tortuous action, arisingE out of or in connection with the use or performance of this software.  .SH AUTHORS = John Cristy, E.I. du Pont de Nemours and Company Incorporated 