 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %                                   X   X                                     % O %                                    X X                                      % O %                                     X                                       % O %                                    X X                                      % O %                                   X   X                                     % O %                                                                             % O %                    X11 Utility Routines for ImageMagick.                    % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                  July 1992                                  % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "utility.h" #include "compress.h"  #include "X.h" #include "widget.h"    /*   State declarations.  */ #define ControlState  0x0001 #define DefaultState  0x0000 #define ExitState  0x0002    /*   Global declarations. */ static unsigned int    xerror_alert = False;    /*   Forward declarations.  */ int *   Latin1Compare _Declare((char *,char *));   static void O   XMakeImageLSBFirst _Declare((XResourceInfo *,XWindowInfo *,Image *, XImage *,      XImage *)), O   XMakeImageMSBFirst _Declare((XResourceInfo *,XWindowInfo *,Image *, XImage *,      XImage *));   
 static Window 6   XWindowByProperty _Declare((Display *,Window,Atom));   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s T r u e                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function IsTrue returns True if the boolean is "true", "on", "yes" or "1".  % ' %  The format of the IsTrue routine is:  %  %      option=IsTrue(boolean)  % + %  A description of each parameter follows:  % G %    o option: either True or False depending on the boolean parameter.  % 9 %    o boolean: Specifies a pointer to a character array.  %  %  */ unsigned int IsTrue(boolean) char   *boolean;  {    if (boolean == (char *) NULL)      return(False);)   if (Latin1Compare(boolean,"true") == 0)      return(True); '   if (Latin1Compare(boolean,"on") == 0)      return(True); (   if (Latin1Compare(boolean,"yes") == 0)     return(True); &   if (Latin1Compare(boolean,"1") == 0)     return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L a t i n 1 C o m p a r e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function Latin1Compare compares two null terminated Latin-1 strings, H %  ignoring case differences, and returns an integer greater than, equalF %  to, or less than 0, according to whether first is lexicographicallyD %  greater than, equal to, or less than second.  The two strings are* %  assumed to be encoded using ISO 8859-1. % . %  The format of the Latin1Compare routine is: % " %      Latin1Compare(first,second) % + %  A description of each parameter follows:  % B %    o first: A pointer to the string to convert to Latin1 string. % C %    o second: A pointer to the string to convert to Latin1 string.  %  %  */ int Latin1Compare(first,second)  char	   *first, 
   *second; {    register unsigned char    *p,    *q;     p=(unsigned char *) first;   q=(unsigned char *) second; &   while ((*p != '\0') && (*q != '\0'))   {      register unsigned char       c,       d;       c=(*p);      d=(*q);      if (c != d)        { 
         /*(           Try lowercasing and try again.
         */'         if ((c >= XK_A) && (c <= XK_Z))            c+=(XK_a-XK_A);          else7           if ((c >= XK_Agrave) && (c <= XK_Odiaeresis)) %             c+=(XK_agrave-XK_Agrave);            else6             if ((c >= XK_Ooblique) && (c <= XK_Thorn)))               c+=(XK_oslash-XK_Ooblique); '         if ((d >= XK_A) && (d <= XK_Z))            d+=(XK_a-XK_A);          else7           if ((d >= XK_Agrave) && (d <= XK_Odiaeresis)) %             d+=(XK_agrave-XK_Agrave); 9           else if ((d >= XK_Ooblique) && (d <= XK_Thorn)) '             d+=(XK_oslash-XK_Ooblique);          if (c != d) &           return(((int) c)-((int) d));       }      p++;     q++;   }     return(((int) *p)-((int) *q)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L a t i n 1 U p p e r                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function Latin1Upper copies a null terminated string from source toK %  destination (including the null), changing all Latin-1 lowercase letters G %  to uppercase.  The string is assumed to be encoded using ISO 8859-1.  % , %  The format of the Latin1Upper routine is: %  %      Latin1Upper(string) % + %  A description of each parameter follows:  % G %    o string: A pointer to the string to convert to upper-case Latin1.  %  %  */ static void Latin1Upper(string)  char
   *string; {    unsigned char      c;     c=(*string);   while (c != '\0')    { #     if ((c >= XK_a) && (c <= XK_z))        *string=c-(XK_a-XK_A);     else3       if ((c >= XK_agrave) && (c <= XK_odiaeresis)) (         *string=c-(XK_agrave-XK_Agrave);
       else0         if ((c >= XK_oslash) && (c <= XK_thorn)),           *string=c-(XK_oslash-XK_Ooblique);
     string++;      c=(*string);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n n o t a t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 9 %  Function XAnnotateImage annotates the image with text.  % / %  The format of the XAnnotateImage routine is:  % M %    status=XAnnotateImage(display,pixel_info,annotate_info,background,image)  % + %  A description of each parameter follows:  % C %    o status: Function XAnnotateImage returns True if the image is I %      successfully annotated with text.  False is returned is there is a  %      memory shortage.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % G %    o annotate_info: Specifies a pointer to a XAnnotateInfo structure.  % H %    o background: Specifies whether the background color is included in5 %      the annotation.  Must be either True or False;  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */N unsigned int XAnnotateImage(display,pixel_info,annotate_info,background,image) Display    *display;   
 XPixelInfo   *pixel_info;  
 XAnnotateInfo    *annotate_info;    unsigned int
   background;    Image 	   *image;  { 
   ColorPacket      background_color;      GC     annotate_context;      Image      *annotate_image;     int      x,     y;     Pixmap     annotate_pixmap;     register int     i;     register RunlengthPacket     *p,      *q;      unsigned int
     depth,     height, 
     matte,
     width;     Window     root_window;     XGCValues      context_values;      XImage     *annotate_ximage;      /*     Initialize annotated image.    */   if (!UncompressImage(image))     return(False);   /*      Initialize annotated pixmap.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); 7   depth=XDefaultDepth(display,XDefaultScreen(display)); I   annotate_pixmap=XCreatePixmap(display,root_window,annotate_info->width, '     annotate_info->height,(int) depth); '   if (annotate_pixmap == (Pixmap) NULL)      return(False);   /*     Initialize graphics info.    */   context_values.background=0;1   context_values.foreground=(unsigned long) (~0); 4   context_values.font=annotate_info->font_info->fid;H   annotate_context=XCreateGC(display,root_window,GCBackground | GCFont |"     GCForeground,&context_values);$   if (annotate_context == (GC) NULL)     return(False);   /*     Draw text to pixmap.   */>   XDrawImageString(display,annotate_pixmap,annotate_context,0,?     (int) annotate_info->font_info->ascent,annotate_info->text, !     strlen(annotate_info->text)); $   XFreeGC(display,annotate_context);   /*!     Initialize annotated X image.    */M   annotate_ximage=XGetImage(display,annotate_pixmap,0,0,annotate_info->width, -     annotate_info->height,AllPlanes,ZPixmap); )   if (annotate_ximage == (XImage *) NULL)      return(False);'   XFreePixmap(display,annotate_pixmap);    /*     Initialize annotated image.    */3   annotate_image=AllocateImage((ImageInfo *) NULL); '   if (annotate_image == (Image *) NULL)      return(False);/   annotate_image->columns=annotate_info->width; -   annotate_image->rows=annotate_info->height; G   annotate_image->packets=annotate_image->columns*annotate_image->rows; ,   annotate_image->pixels=(RunlengthPacket *)B     malloc((unsigned int) image->packets*sizeof(RunlengthPacket));9   if (annotate_image->pixels == (RunlengthPacket *) NULL)      { #       DestroyImage(annotate_image);        return(False);     }    /*(     Transfer annotated X image to image.   */F   (void) XParseGeometry(annotate_info->geometry,&x,&y,&width,&height);%   q=image->pixels+y*image->columns+x;    background_color.red=q->red;"   background_color.green=q->green;    background_color.blue=q->blue;   background_color.index=0;    annotate_image->matte=True;    p=annotate_image->pixels; *   for (y=0; y < annotate_image->rows; y++)/     for (x=0; x < annotate_image->columns; x++)      { ?       p->index=(unsigned short) XGetPixel(annotate_ximage,x,y);        if (p->index == 0)	         {            /*3             Set this pixel to the background color.            */&           p->red=background_color.red;*           p->green=background_color.green;(           p->blue=background_color.blue;           p->index=Transparent; 	         } 
       else	         {            /*,             Set this pixel to the pen color.           */<           p->red=ColorShift(pixel_info->annotate_color.red);@           p->green=ColorShift(pixel_info->annotate_color.green);>           p->blue=ColorShift(pixel_info->annotate_color.blue);           p->index=Opaque;	         }        p->length=0;
       p++;     } !   XDestroyImage(annotate_ximage);    /*      Determine annotate geometry.   */F   (void) XParseGeometry(annotate_info->geometry,&x,&y,&width,&height);M   if ((width != annotate_image->columns) || (height != annotate_image->rows))      { 
       char&         image_geometry[MaxTextLength];         /*         Scale image.       */;       (void) sprintf(image_geometry,"%dx%d!",width,height); C       TransformImage(&annotate_image,(char *) NULL,image_geometry);      } $   if (annotate_info->degrees != 0.0)     {        double         normalized_degrees;          Image          *rotated_image;   	       int          rotations;         /*         Rotate image.        */F       rotated_image=RotateImage(annotate_image,annotate_info->degrees,!         &background_color,False); *       if (rotated_image == (Image *) NULL)         return(False);#       DestroyImage(annotate_image); #       annotate_image=rotated_image;        /*9         Annotation is relative to the degree of rotation.        */0       normalized_degrees=annotate_info->degrees;(       while (normalized_degrees < -45.0)"         normalized_degrees+=360.0;?       for (rotations=0; normalized_degrees > 45.0; rotations++) !         normalized_degrees-=90.0;        switch (rotations % 4)       {          default:         case 0:            break;         case 1: 	         {            /*             Rotate 90 degrees.           */*           x-=annotate_image->columns >> 1;*           y+=annotate_image->columns >> 1;           break;	         }          case 2: 	         {            /*             Rotate 180 degrees.            */%           x-=annotate_image->columns;            break;	         }          case 3: 	         {            /*             Rotate 270 degrees.            */*           x-=annotate_image->columns >> 1;A           y-=annotate_image->rows-(annotate_image->columns >> 1);            break;	         }        }      }    /*"     Composite text onto the image.   */   p=annotate_image->pixels; -   for (i=0; i < annotate_image->packets; i++)    {       if (p->index != Transparent)       p->index=Opaque;     p++;   }    matte=image->matte; ;   CompositeImage(image,OverCompositeOp,annotate_image,x,y);    image->matte=matte;    DestroyImage(annotate_image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t F o n t                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XBestFont returns the "best" font.  "Best" is defined as a font J %  specified in the X resource database or a font such that the text widthG %  displayed with the font does not exceed the specified maximum width.  % * %  The format of the XBestFont routine is: % 6 %      font=XBestFont(display,resource_info,text_font) % + %  A description of each parameter follows:  % D %    o font: XBestFont returns a pointer to a XFontStruct structure. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % I %    o text_font:  True is font should be mono-spaced (typewriter style).  %  %  */7 XFontStruct *XBestFont(display,resource_info,text_font)  Display    *display;   
 XResourceInfo    *resource_info;    unsigned int   text_font; { 
   static char 
     *Fonts[]=      { 0       "-adobe-helvetica-medium-r-normal-*-14-*",'       "-*-helvetica-medium-r-*-*-14-*", $       "-*-lucida-medium-r-*-*-14-*",
       "8x13", 
       "6x13",        "fixed",       "variable",        (char *) NULL      },     *TextFonts[]=      { )       "-adobe-courier-medium-r-*-*-14-*", (       "-*-fixed-medium-r-normal-*-14-*",#       "-*-fixed-medium-r-*-*-14-*", 
       "8x13", 
       "6x13",        "fixed",       (char *) NULL      };     char     *font_name,      **p;  
   XFontStruct      *font_info;   !   font_info=(XFontStruct *) NULL;     font_name=resource_info->font;   if (text_font)'     font_name=resource_info->text_font; !   if (font_name != (char *) NULL)      {        /*A         Load preferred font specified in the X resource database.        */2       font_info=XLoadQueryFont(display,font_name);,       if (font_info == (XFontStruct *) NULL)1         Warning("Unable to load font",font_name);      }    /*5     Load fonts from list of fonts until one is found.    */
   p=Fonts;   if (text_font)     p=TextFonts;   while (*p != (char *) NULL)    { *     if (font_info != (XFontStruct *) NULL)       break;)     font_info=XLoadQueryFont(display,*p);      p++;   }    return(font_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t I c o n S i z e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XBestIconSize returns the "best" icon size.  "Best" is defined as L %  an icon size that maintains the aspect ratio of the image.  If the windowH %  manager has preferred icon sizes, one of the preferred sizes is used. % . %  The format of the XBestIconSize routine is: % * %      XBestIconSize(display,window,image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */( void XBestIconSize(display,window,image) Display    *display;    XWindowInfo 
   *window;   Image 	   *image;  {  #define MaxIconSize  96      int      i,     number_sizes;      unsigned int     height,      icon_height,     icon_width, 
     width;     unsigned long      scale_factor;      Window     root_window;     XIconSize      *icon_size,      *size_list;      /*G     Determine if the window manager has specified preferred icon sizes.    */   window->width=MaxIconSize;   window->height=MaxIconSize;    icon_size=(XIconSize *) NULL;    number_sizes=0; 2   root_window=XRootWindow(display,window->screen);G   if (XGetIconSizes(display,root_window,&size_list,&number_sizes) != 0) @     if ((number_sizes > 0) && (size_list != (XIconSize *) NULL))       icon_size=size_list;&   if (icon_size == (XIconSize *) NULL)     {        /*3         Window manager does not restrict icon size.        */!       icon_size=XAllocIconSize(); *       if (icon_size == (XIconSize *) NULL)	         { P           Warning("Unable to choose best icon size","Memory allocation failed");           return; 	         }        icon_size->min_width=1; '       icon_size->max_width=MaxIconSize;        icon_size->min_height=1;(       icon_size->max_height=MaxIconSize;       icon_size->width_inc=1;        icon_size->height_inc=1;     }    /*$     Determine aspect ratio of image.   */   width=image->columns;    height=image->rows;    if (window->crop_geometry)F     (void) XParseGeometry(window->crop_geometry,&i,&i,&width,&height);   /*C     Look for an icon size that maintains the aspect ratio of image.    */3   scale_factor=UpShift(icon_size->max_width)/width; =   if (scale_factor > (UpShift(icon_size->max_height)/height)) 7     scale_factor=UpShift(icon_size->max_height)/height; "   icon_width=icon_size->min_width;+   while (icon_width < icon_size->max_width)    { 6     if (icon_width >= (DownShift(width*scale_factor)))       break;%     icon_width+=icon_size->width_inc;    } $   icon_height=icon_size->min_height;-   while (icon_height < icon_size->max_height)    { 8     if (icon_height >= (DownShift(height*scale_factor)))       break;'     icon_height+=icon_size->height_inc;    }    XFree((void *) icon_size);   window->width=icon_width;    window->height=icon_height;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t P i x e l                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XBestPixel returns a pixel from an array of pixels that is closestO %  to the requested color.  If the color array is NULL, the colors are obtained  %  from the X server.  % + %  The format of the XBestPixel routine is:  % D %      pixel=XBestPixel(display,colormap,colors,number_colors,color) % + %  A description of each parameter follows:  % I %    o pixel: XBestPixel returns the pixel value closest to the requested 
 %      color.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o colormap: Specifies the ID of the X server colormap.  % 7 %    o colors: Specifies an array of XColor structures.  % F %    o number_colors: Specifies the number of XColor structures in the %      color definition array. % J %    o color: Specifies the desired RGB value to find in the colors array. %  %  */< void XBestPixel(display,colormap,colors,number_colors,color) Display    *display;    Colormap   colormap;    XColor
   *colors;   unsigned int   number_colors;   XColor	   *color;  {    int      j,     query_server,      status;      register int     blue_distance,     green_distance,      i,     red_distance;      unsigned long 
     distance,      min_distance;      /*<     Find closest representation for the requested RGB color.   */-   status=XAllocColor(display,colormap,color);    if (status != 0)     return; )   query_server=colors == (XColor *) NULL;    if (query_server)      {        /*         Read X server colormap.        */=       colors=(XColor *) malloc(number_colors*sizeof(XColor)); $       if (colors == (XColor *) NULL)M         Error("Unable to read X server colormap","Memory allocation failed"); '       for (i=0; i < number_colors; i++) *         colors[i].pixel=(unsigned long) i;       if (number_colors > 256)         number_colors=256;:       XQueryColors(display,colormap,colors,number_colors);     } $   min_distance=(unsigned long) (~0);   color->pixel=0;    j=0;#   for (i=0; i < number_colors; i++)    {      red_distance=(int)A       (ColorShift(colors[i].red))-(int) (ColorShift(color->red));      green_distance=(int)E       (ColorShift(colors[i].green))-(int) (ColorShift(color->green));      blue_distance=(int) C       (ColorShift(colors[i].blue))-(int) (ColorShift(color->blue)); E     distance=red_distance*red_distance+green_distance*green_distance+ "       blue_distance*blue_distance;      if (distance < min_distance)       {          min_distance=distance;%         color->pixel=colors[i].pixel;          j=i;       }    } 2   (void) XAllocColor(display,colormap,&colors[j]);   if (query_server)      free((char *) colors); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t V i s u a l I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XBestVisualInfo returns visual information for a visual that is 9 %  the "best" the server supports.  "Best" is defined as:  % J %    1. Restrict the visual list to those supported by the default screen. % K %    2. If a visual type is specified, restrict the visual list to those of  %       that type. % I %    3. If a map type is specified, choose the visual that matches the id + %       specified by the Standard Colormap.  % F %    4  From the list of visuals, choose one that can display the mostJ %       simultaneous colors.  If more than one visual can display the sameF %       number of simultaneous colors, one is choosen based on a rank. % 0 %  The format of the XBestVisualInfo routine is: % B %      visual_info=XBestVisualInfo(display,map_info,resource_info) % + %  A description of each parameter follows:  % J %    o visual_info: XBestVisualInfo returns a pointer to a X11 XVisualInfo %      structure.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */< XVisualInfo *XBestVisualInfo(display,map_info,resource_info) Display    *display;    XStandardColormap    *map_info;  
 XResourceInfo    *resource_info;  {  #define MaxStandardColormaps  7 * #define XVisualColormapSize(visual_info) \O   ((visual_info->class == TrueColor) || (visual_info->class == DirectColor) ? \ P     visual_info->red_mask | visual_info->green_mask | visual_info->blue_mask : \     visual_info->colormap_size)      char     *map_type,     *visual_type;      int      number_visuals;      register int     i;     unsigned int     visual_mask;  
   XVisualInfo      *visual_info,      *visual_list,      visual_template;     /*,     Restrict visual search by screen number.   */#   map_type=resource_info->map_type; )   visual_type=resource_info->visual_type;    visual_mask=VisualScreenMask; 1   visual_template.screen=XDefaultScreen(display); #   if (visual_type != (char *) NULL)      {        /*5         Restrict visual search by class or visual id.        */7       if (Latin1Compare("staticgray",visual_type) == 0) 	         { '           visual_mask|=VisualClassMask; +           visual_template.class=StaticGray; 	         } 
       else8         if (Latin1Compare("grayscale",visual_type) == 0)           { )             visual_mask|=VisualClassMask; ,             visual_template.class=GrayScale;           }          else<           if (Latin1Compare("staticcolor",visual_type) == 0)
             { +               visual_mask|=VisualClassMask; 0               visual_template.class=StaticColor;
             }            else>             if (Latin1Compare("pseudocolor",visual_type) == 0)               { -                 visual_mask|=VisualClassMask; 2                 visual_template.class=PseudoColor;               }              else>               if (Latin1Compare("truecolor",visual_type) == 0)                 { /                   visual_mask|=VisualClassMask; 2                   visual_template.class=TrueColor;                 }                elseB                 if (Latin1Compare("directcolor",visual_type) == 0)                   { 1                     visual_mask|=VisualClassMask; 6                     visual_template.class=DirectColor;                   }                  else@                   if (Latin1Compare("default",visual_type) == 0)                     { 0                       visual_mask|=VisualIDMask;C                       visual_template.visualid=XVisualIDFromVisual( I                         XDefaultVisual(display,XDefaultScreen(display)));                      }                    else.                     if (isdigit(*visual_type))                       { 2                         visual_mask|=VisualIDMask;1                         visual_template.visualid= ?                           strtol(visual_type,(char **) NULL,0);                        }                      elseF                       Warning("Invalid visual specifier",visual_type);     }    /*2     Get all visuals that meet our criteria so far.   */   number_visuals=0; B   visual_list=XGetVisualInfo(display,visual_mask,&visual_template,     &number_visuals); .   visual_mask=VisualScreenMask | VisualIDMask;E   if ((number_visuals == 0) || (visual_list == (XVisualInfo *) NULL))      {        /*<         Failed to get visual;  try using the default visual.       */2       Warning("Unable to get visual",visual_type);       visual_template.visualid= M         XVisualIDFromVisual(XDefaultVisual(display,XDefaultScreen(display))); F       visual_list=XGetVisualInfo(display,visual_mask,&visual_template,         &number_visuals); I       if ((number_visuals == 0) || (visual_list == (XVisualInfo *) NULL)) %         return((XVisualInfo *) NULL); K       Warning("Using default visual",XVisualClassName(visual_list->class));      } &   resource_info->color_recovery=False;    if (map_type != (char *) NULL)     { 
       Atom         map_property;   
       char          map_name[MaxTextLength];  	       int 
         j,         number_maps,         status;          Window         root_window;         XStandardColormap          *map_list;         /*<         Choose a visual associated with a standard colormap.       */?       root_window=XRootWindow(display,XDefaultScreen(display));        status=0; '       if (strcmp(map_type,"list") != 0) 	         {            /*-             User specified Standard Colormap.            */B           (void) sprintf((char *) map_name,"RGB_%s_MAP",map_type);            Latin1Upper(map_name);C           map_property=XInternAtom(display,(char *) map_name,True); *           if (map_property == (Atom) NULL)>             Error("Unable to get Standard Colormap",map_type);M           status=XGetRGBColormaps(display,root_window,&map_list,&number_maps,              map_property);	         } 
       else	         {            static char              *colormap[]=
             { (               "_HP_RGB_SMOOTH_MAP_LIST",               "RGB_BEST_MAP",                 "RGB_DEFAULT_MAP",               "RGB_GRAY_MAP",                "RGB_RED_MAP",               "RGB_GREEN_MAP",               "RGB_BLUE_MAP",              };             /*3             Choose a standard colormap from a list.            */2           for (i=0; i < MaxStandardColormaps; i++)           { ?             map_property=XInternAtom(display,colormap[i],True); ,             if (map_property == (Atom) NULL)               continue; O             status=XGetRGBColormaps(display,root_window,&map_list,&number_maps,                map_property);             if (status != 0)               break;           } P           resource_info->color_recovery=(i == 0);  /* _HP_RGB_SMOOTH_MAP_LIST */	         }        if (status == 0):         Error("Unable to get Standard Colormap",map_type);       /*E         Search all Standard Colormaps and visuals for ids that match.        */       *map_info=map_list[0]; #ifndef PRE_R4_ICCCMJ       visual_template.visualid=XVisualIDFromVisual(visual_list[0].visual);%       for (i=0; i < number_maps; i++) *         for (j=0; j < number_visuals; j++)%           if (map_list[i].visualid == 9               XVisualIDFromVisual(visual_list[j].visual)) 
             { $               *map_info=map_list[i];'               visual_template.visualid= ;                 XVisualIDFromVisual(visual_list[j].visual);                break;
             } 9       if (map_info->visualid != visual_template.visualid) F         Error("Unable to match visual to Standard Colormap",map_type); #endif0       if (map_info->colormap == (Colormap) NULL)?         Error("Standard Colormap is not initialized",map_type);        XFree((void *) map_list);      }    else     {        static unsigned int          rank[]=            {              StaticGray,              GrayScale,             StaticColor,             DirectColor,             TrueColor,             PseudoColor            };         XVisualInfo          *p;          /*C         Pick one visual that displays the most simultaneous colors.        */       visual_info=visual_list;       p=visual_list;(       for (i=1; i < number_visuals; i++)       {          p++;F         if (XVisualColormapSize(p) > XVisualColormapSize(visual_info))           visual_info=p;         elseI           if (XVisualColormapSize(p) == XVisualColormapSize(visual_info)) :             if (rank[p->class] > rank[visual_info->class])               visual_info=p;       } H       visual_template.visualid=XVisualIDFromVisual(visual_info->visual);     }    XFree((void *) visual_list);   /*7     Retrieve only one visual by its screen & id number.    */B   visual_info=XGetVisualInfo(display,visual_mask,&visual_template,     &number_visuals); E   if ((number_visuals == 0) || (visual_info == (XVisualInfo *) NULL)) !     return((XVisualInfo *) NULL);    return(visual_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C h e c k R e f r e s h W i n d o w s                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XCheckRefreshWindows checks the X server for exposure events forL %  a particular window and updates the area associated withe exposure event. % 5 %  The format of the XCheckRefreshWindows routine is:  % , %      XCheckRefreshWindows(display,windows) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %  %  */* void XCheckRefreshWindows(display,windows) Display    *display;    XWindows   *windows;  {    XEvent
     event;     XDelay(display,SuspendTime);K   while (XCheckTypedWindowEvent(display,windows->command.id,Expose,&event)) A     (void) XCommandWidget(display,windows,(char **) NULL,&event); I   while (XCheckTypedWindowEvent(display,windows->image.id,Expose,&event)) 3     XRefreshWindow(display,&windows->image,&event); #   XDelay(display,SuspendTime << 1); K   while (XCheckTypedWindowEvent(display,windows->command.id,Expose,&event)) A     (void) XCommandWidget(display,windows,(char **) NULL,&event); I   while (XCheckTypedWindowEvent(display,windows->image.id,Expose,&event)) 3     XRefreshWindow(display,&windows->image,&event);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C l i e n t M e s s a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XClientMessage sends a message to a window with XSendEvent.  TheC %  message is initialized with a particular protocol type and atom.  % 0 %  The format of the XClientMessage function is: % @ %      XClientMessage(display,window,protocol,message,timestamp) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  % ) %    o protocol: Specifies an atom value.  % E %    o message: Specifies an atom value which is the message to send.  % 1 %    o timestamp: Specifies a value of type Time.  %  %  */> void XClientMessage(display,window,protocol,message,timestamp) Display    *display;    Window
    window;   Atom   protocol, 
   message;   Time   timestamp; {    XClientMessageEvent      client_event;   "   client_event.type=ClientMessage;   client_event.window=window; %   client_event.message_type=protocol;    client_event.format=32; !   client_event.data.l[0]=message; #   client_event.data.l[1]=timestamp; ?   XSendEvent(display,window,False,0L,(XEvent *) &client_event);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C l i e n t W i n d o w                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XClientWindow finds a window, at or below the specified window, M %  which has a WM_STATE property.  If such a window is found, it is returned, - %  otherwise the argument window is returned.  % / %  The format of the XClientWindow function is:  % 9 %      client_window=XClientWindow(display,target_window)  % + %  A description of each parameter follows:  % O %    o client_window: XClientWindow returns a window, at or below the specified C %      window, which has a WM_STATE property otherwise the argument ! %      target_window is returned.  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o target_window: Specifies the window to find a WM_STATE property.  %  %  */+ Window XClientWindow(display,target_window)  Display    *display;    Window   target_window; {    Atom
     state,	     type;      int      format,      status;      unsigned char 
     *data;     unsigned long 
     after,     number_items;      Window     client_window;  -   state=XInternAtom(display,"WM_STATE",True);    if (state == (Atom) NULL)      return(target_window);   type=(Atom) NULL; D   status=XGetWindowProperty(display,target_window,state,0L,0L,False,E     (Atom) AnyPropertyType,&type,&format,&number_items,&after,&data); 3   if ((status == Success) && (type != (Atom) NULL))      return(target_window);?   client_window=XWindowByProperty(display,target_window,state); %   if (client_window == (Window) NULL)      return(target_window);   return(client_window); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n s t r a i n W i n d o w P o s i t i o n                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % $ %  Function XConstrainWindowPosition % 9 %  The format of the XConstrainWindowPosition routine is:  % 4 %      XConstrainWindowPosition(display,window_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % C %    o window_info: Specifies a pointer to a XWindowInfo structure.  %  %  */2 void XConstrainWindowPosition(display,window_info) Display    *display;    XWindowInfo    *window_info;  {    unsigned int
     limit;  F   limit=XDisplayWidth(display,window_info->screen)-window_info->width;   if (window_info->x < 0)      window_info->x=0;    else     if (window_info->x > limit)        window_info->x=limit; H   limit=XDisplayHeight(display,window_info->screen)-window_info->height;   if (window_info->y < 0)      window_info->y=0;    else     if (window_info->y > limit)        window_info->y=limit;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D e l a y                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDelay suspends program execution for the number of milliseconds
 %  specified.  % & %  The format of the Delay routine is: % # %      XDelay(display,milliseconds)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % I %    o milliseconds: Specifies the number of milliseconds to delay before  %      returning.  %  %  */! void XDelay(display,milliseconds)  Display    *display;   
 unsigned long    milliseconds;  {    (void) XFlush(display);    if (milliseconds == 0)     return;  #ifndef vms  #ifdef sysv    {  #include <sys/poll.h>   =     (void) poll((struct pollfd *) NULL,0,(int) milliseconds);    }  #else    {      struct timeval       timer;  #     timer.tv_sec=milliseconds/1000; -     timer.tv_usec=(milliseconds % 1000)*1000; O     (void) select(0,(XFD_SET *) NULL,(XFD_SET *) NULL,(XFD_SET *) NULL,&timer);    }  #endif #else    { 	     float        timer;       timer=milliseconds/1000.0;     lib$wait(&timer);    }  #endif }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D e s t r o y W i n d o w C o l o r s                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XDestroyWindowColors frees X11 color resources previously saved on= %  a window by XRetainWindowColors or programs like xsetroot.  % 5 %  The format of the XDestroyWindowColors routine is:  % + %      XDestroyWindowColors(display,window)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  %  %  */) void XDestroyWindowColors(display,window)  Display    *display;    Window	   window;  {    Atom
     property, 	     type;      int      format,      status;      unsigned char 
     *data;     unsigned long 
     after,     length;      /*E     If there are previous resources on the root window, destroy them.    */5   property=XInternAtom(display,"_XSETROOT_ID",False);    if (property == (Atom) NULL)     { <       Warning("Unable to create X property","_XSETROOT_ID");
       return;      } ?   status=XGetWindowProperty(display,window,property,0L,1L,True, ?     (Atom) AnyPropertyType,&type,&format,&length,&after,&data);    if (status != Success)     return; M   if ((type == XA_PIXMAP) && (format == 32) && (length == 1) && (after == 0))      { 6       XKillClient(display,(XID) (*((Pixmap *) data)));/       XDeleteProperty(display,window,property);      }    if (type != None)      XFree((void *) data);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i s p l a y I m a g e I n f o                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XDisplayImageInfo displays information about an X image. % 2 %  The format of the XDisplayImageInfo routine is: % = %      XDisplayImageInfo(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */; void XDisplayImageInfo(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  {    char
     *text,     **textlist,      title[MaxTextLength];      int      length;      Image      *p;      unsigned int
     count;     /*@     Display information about the image in the Text View widget.   */   length=11*MaxTextLength;(   if (image->directory != (char *) NULL)%     length+=strlen(image->directory); '   if (image->comments != (char *) NULL) $     length+=strlen(image->comments);,   text=(char *) malloc(length*sizeof(char));   if (text == (char *) NULL)     { D       XNoticeWidget(display,windows,"Unable to display image info:",$         "Memory allocation failed");
       return;      } :   (void) sprintf(title," Image Info: %s",image->filename);*   (void) sprintf(text,"X\n  visual: %s\n",,     XVisualClassName(windows->image.class));C   (void) sprintf(text,"%s  depth: %d\n",text,windows->image.depth); 3   (void) sprintf(text,"%s  geometry: %dx%d\n",text, @     windows->image.ximage->width,windows->image.ximage->height);4   if (windows->image.crop_geometry != (char *) NULL)7     (void) sprintf(text,"%s  crop geometry: %s\n",text, $       windows->image.crop_geometry);-   if (windows->image.pixmap == (Pixmap) NULL) ,     (void) strcat(text,"  type: X Image\n");   else+     (void) strcat(text,"  type: Pixmap\n"); #   if (windows->image.shared_memory) 2     (void) strcat(text,"  shared memory: True\n");   else3     (void) strcat(text,"  shared memory: False\n"); /   if (resource_info->colormap== SharedColormap) 4     (void) strcat(text,"  colormap type: Shared\n");   else5     (void) strcat(text,"  colormap type: Private\n");    (void) strcat(text,"\n"); D   (void) sprintf(text,"%sImage\n  file: %s\n",text,image->filename);=   (void) sprintf(text,"%s  format: %s\n",text,image->magick);    if (image->filesize != 0) A     (void) sprintf(text,"%s  bytes: %ld\n",text,image->filesize); "   if (image->class == DirectClass)1     (void) strcat(text,"  class: DirectClass\n");    else1     (void) strcat(text,"  class: PseudoClass\n");    if (image->matte) *     (void) strcat(text,"  matte: True\n");   else+     (void) strcat(text,"  matte: False\n"); 3   (void) sprintf(text,"%s  geometry: %ux%u\n",text,       image->columns,image->rows);"   if (image->class == PseudoClass)     if (image->colors != 0) A       (void) sprintf(text,"%s  colors: %u\n",text,image->colors); (   if (image->signature != (char *) NULL)E     (void) sprintf(text,"%s  signature: %s\n",text,image->signature); 
   p=image;'   while (p->previous != (Image *) NULL)      p=p->previous;3   for (count=1; p->next != (Image *) NULL; count++)      p=p->next;   if (count > 1)I     (void) sprintf(text,"%s  scene: %u of %u\n",text,image->scene,count);    else     if (image->scene != 0)?       (void) sprintf(text,"%s  scene: %u\n",text,image->scene); &   if (image->montage != (char *) NULL)A     (void) sprintf(text,"%s  montage: %s\n",text,image->montage); (   if (image->directory != (char *) NULL)H     (void) sprintf(text,"%s  directory:\n\n%s\n",text,image->directory);$   if (image->label != (char *) NULL)=     (void) sprintf(text,"%s  label: %s\n",text,image->label); '   if (image->comments != (char *) NULL) D     (void) sprintf(text,"%s  comments:\n\n%s",text,image->comments);   textlist=StringToList(text);!   if (textlist != (char **) NULL)      {        register int
         i;  I       XTextViewWidget(display,resource_info,windows,True,title,textlist); 2       for (i=0; textlist[i] != (char *) NULL; i++)#         free((char *) textlist[i]);        free((char *) textlist);     }    free((char *) text); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     X D i t h e r I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XDitherImage dithers the reference image as required by the HPM %  Color Recovery algorithm.  The color values are quantized to 3 bits of red J %  and green, and 2 bits of blue (3/3/2) and can be used as indices into a %  8-bit X standard colormap.  % - %  The format of the XDitherImage routine is:  % ! %      XDitherImage(image,ximage)  % + %  A description of each parameter follows:  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % H %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. %  %  */& static void XDitherImage(image,ximage) Image 	   *image;    XImage
   *ximage; {    static short int     dither_red[2][16]=     { H       {-16,  4, -1, 11,-14,  6, -3,  9,-15,  5, -2, 10,-13,  7, -4,  8},G       { 15, -5,  0,-12, 13, -7,  2,-10, 14, -6,  1,-11, 12, -8,  3, -9}      },     dither_green[2][16]=     { H       { 11,-15,  7, -3,  8,-14,  4, -2, 10,-16,  6, -4,  9,-13,  5, -1},G       {-12, 14, -8,  2, -9, 13, -5,  1,-11, 15, -7,  3,-10, 12, -6,  0}      },     dither_blue[2][16]=      { H       { -3,  9,-13,  7, -1, 11,-15,  5, -4,  8,-14,  6, -2, 10,-16,  4},G       {  2,-10, 12, -8,  0,-12, 14, -6,  3, -9, 13, -7,  1,-11, 15, -5}      };  
   ColorPacket 
     color;     int 
     value,     y;     register char      *q;      register int     i,     j,     x;     register RunlengthPacket     *p;      unsigned char      *blue_map[2][16],      *green_map[2][16],     *red_map[2][16];     unsigned int     scanline_pad;      register unsigned long
     pixel;     if (!UncompressImage(image))     return;    /*(     Allocate and initialize dither maps.   */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)     { H       red_map[i][j]=(unsigned char *) malloc(256*sizeof(unsigned char));J       green_map[i][j]=(unsigned char *) malloc(256*sizeof(unsigned char));I       blue_map[i][j]=(unsigned char *) malloc(256*sizeof(unsigned char)); 6       if ((red_map[i][j] == (unsigned char *) NULL) ||8           (green_map[i][j] == (unsigned char *) NULL) ||5           (blue_map[i][j] == (unsigned char *) NULL)) 	         { G           Warning("Unable to dither image","Memory allocation failed");            return; 	         }      }    /*     Initialize dither tables.    */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)       for (x=0; x < 256; x++)        {          value=x-16;          if (x < 48)            value=x/2+8;          value+=dither_red[i][j];         if (value < 0)           value=0;         else           if (value > MaxRGB)              value=MaxRGB;          red_map[i][j][x]=value;          value=x-16;          if (x < 48)            value=x/2+8;"         value+=dither_green[i][j];         if (value < 0)           value=0;         else           if (value > MaxRGB)              value=MaxRGB; !         green_map[i][j][x]=value;          value=x-32;          if (x < 112)           value=x/2+24; (         value+=(dither_blue[i][j] << 1);         if (value < 0)           value=0;         else           if (value > MaxRGB)              value=MaxRGB;           blue_map[i][j][x]=value;       }    /*     Dither image.    */&   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   i=0;   j=0;   p=image->pixels;   q=ximage->data; !   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     { &       color.red=red_map[i][j][p->red];,       color.green=green_map[i][j][p->green];)       color.blue=blue_map[i][j][p->blue]; !       pixel=((color.red & 0xe0) | 5         ((unsigned char) (color.green & 0xe0) >> 3) | 4         ((unsigned char) (color.blue & 0xc0) >> 6));!       *q++=(unsigned char) pixel; 
       p++;
       j++;       if (j == 16)         j=0;     }      q+=scanline_pad;     i++;     if (i == 2) 
       i=0;   }    /*     Free allocated memory.   */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)     { %       free((char *) green_map[i][j]); $       free((char *) blue_map[i][j]);#       free((char *) red_map[i][j]);      }  }      /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 1 %  Function XDrawImage draws a line on the image.  % + %  The format of the XDrawImage routine is:  % : %    status=XDrawImage(display,pixel_info,draw_info,image) % + %  A description of each parameter follows:  % ? %    o status: Function XDrawImage returns True if the image is E %      successfully drawd with text.  False is returned is there is a  %      memory shortage.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % ? %    o draw_info: Specifies a pointer to a XDrawInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */; unsigned int XDrawImage(display,pixel_info,draw_info,image)  Display    *display;   
 XPixelInfo   *pixel_info;  	 XDrawInfo 
   *draw_info;    Image 	   *image;  { 
   ColorPacket      background_color;      GC     draw_context;      Image      *draw_image;     int      x,     y;     Pixmap     draw_pixmap;     register int     i;     register RunlengthPacket     *p,      *q;      unsigned int
     depth,     height, 
     matte,
     width;     Window     root_window;     XGCValues      context_values;      XImage     *draw_ximage;      /*     Initialize drawd image.    */   if (!UncompressImage(image))     return(False);   /*     Initialize drawd pixmap.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); 7   depth=XDefaultDepth(display,XDefaultScreen(display)); A   draw_pixmap=XCreatePixmap(display,root_window,draw_info->width, #     draw_info->height,(int) depth); #   if (draw_pixmap == (Pixmap) NULL)      return(False);   /*     Initialize graphics info.    */1   context_values.background=(unsigned long) (~0);    context_values.foreground=0;2   context_values.line_width=draw_info->line_width;J   draw_context=XCreateGC(display,root_window,GCBackground | GCForeground |!     GCLineWidth,&context_values);     if (draw_context == (GC) NULL)     return(False);   /*     Clear pixmap.    */G   XFillRectangle(display,draw_pixmap,draw_context,0,0,draw_info->width,      draw_info->height);    /*     Draw line to pixmap.   */)   XSetBackground(display,draw_context,0); <   XSetForeground(display,draw_context,(unsigned long) (~0));   switch (draw_info->primitive)    {      case LinePrimitive:      default:     { I       XDrawLine(display,draw_pixmap,draw_context,draw_info->line_info.x1, 8         draw_info->line_info.y1,draw_info->line_info.x2,!         draw_info->line_info.y2);        break;     }      case RectanglePrimitive:     { 6       XDrawRectangle(display,draw_pixmap,draw_context,@         draw_info->rectangle_info.x,draw_info->rectangle_info.y,J         draw_info->rectangle_info.width,draw_info->rectangle_info.height);       break;     }       case FillRectanglePrimitive:     { 6       XFillRectangle(display,draw_pixmap,draw_context,@         draw_info->rectangle_info.x,draw_info->rectangle_info.y,J         draw_info->rectangle_info.width,draw_info->rectangle_info.height);       break;     }    }     XFreeGC(display,draw_context);   /*     Initialize X image.    */A   draw_ximage=XGetImage(display,draw_pixmap,0,0,draw_info->width, )     draw_info->height,AllPlanes,ZPixmap); %   if (draw_ximage == (XImage *) NULL)      return(False);#   XFreePixmap(display,draw_pixmap);    /*     Initialize drawd image.    *//   draw_image=AllocateImage((ImageInfo *) NULL); #   if (draw_image == (Image *) NULL)      return(False);'   draw_image->columns=draw_info->width; %   draw_image->rows=draw_info->height; ;   draw_image->packets=draw_image->columns*draw_image->rows; (   draw_image->pixels=(RunlengthPacket *)B     malloc((unsigned int) image->packets*sizeof(RunlengthPacket));5   if (draw_image->pixels == (RunlengthPacket *) NULL)      {        DestroyImage(draw_image);        return(False);     }    /*$     Transfer drawd X image to image.   */B   (void) XParseGeometry(draw_info->geometry,&x,&y,&width,&height);%   q=image->pixels+y*image->columns+x;    background_color.red=q->red;"   background_color.green=q->green;    background_color.blue=q->blue;   background_color.index=0;    draw_image->matte=True;    p=draw_image->pixels; &   for (y=0; y < draw_image->rows; y++)+     for (x=0; x < draw_image->columns; x++)      { ;       p->index=(unsigned short) XGetPixel(draw_ximage,x,y);        if (p->index == 0)	         {            /*3             Set this pixel to the background color.            */&           p->red=background_color.red;*           p->green=background_color.green;(           p->blue=background_color.blue;           p->index=Transparent; 	         } 
       else	         {            /*,             Set this pixel to the pen color.           */<           p->red=ColorShift(pixel_info->annotate_color.red);@           p->green=ColorShift(pixel_info->annotate_color.green);>           p->blue=ColorShift(pixel_info->annotate_color.blue);           p->index=Opaque;	         }        p->length=0;
       p++;     }    XDestroyImage(draw_ximage);    /*     Determine draw geometry.   */B   (void) XParseGeometry(draw_info->geometry,&x,&y,&width,&height);E   if ((width != draw_image->columns) || (height != draw_image->rows))      {        Image          *scaled_image;         /*         Scale image.       */7       scaled_image=ScaleImage(draw_image,width,height); )       if (scaled_image != (Image *) NULL) 	         { #           DestroyImage(draw_image); "           draw_image=scaled_image;	         }      }     if (draw_info->degrees != 0.0)     {        double         normalized_degrees;          Image          *rotated_image;   	       int          rotations;         /*         Rotate image.        */>       rotated_image=RotateImage(draw_image,draw_info->degrees,!         &background_color,False); *       if (rotated_image == (Image *) NULL)         return(False);       DestroyImage(draw_image);        draw_image=rotated_image;        /*9         Annotation is relative to the degree of rotation.        */,       normalized_degrees=draw_info->degrees;(       while (normalized_degrees < -45.0)"         normalized_degrees+=360.0;?       for (rotations=0; normalized_degrees > 45.0; rotations++) !         normalized_degrees-=90.0;        switch (rotations % 4)       {          default:         case 0:            break;         case 1: 	         {            /*             Rotate 90 degrees.           */&           x-=draw_image->columns >> 1;&           y+=draw_image->columns >> 1;           break;	         }          case 2: 	         {            /*             Rotate 180 degrees.            */!           x-=draw_image->columns;            break;	         }          case 3: 	         {            /*             Rotate 270 degrees.            */&           x-=draw_image->columns >> 1;9           y-=draw_image->rows-(draw_image->columns >> 1);            break;	         }        }      }    /*"     Composite text onto the image.   */   p=draw_image->pixels; )   for (i=0; i < draw_image->packets; i++)    {       if (p->index != Transparent)       p->index=Opaque;     p++;   }    matte=image->matte; 7   CompositeImage(image,OverCompositeOp,draw_image,x,y);    image->matte=matte;    DestroyImage(draw_image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X E r r o r                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % > %  Function XError ignores BadWindow errors for XQueryTree andM %  XGetWindowAttributes, and ignores BadDrawable errors for XGetGeometry, and M %  ignores BadValue errors for XQueryColor.  It returns False in those cases.  %  Otherwise it returns True.  % ( %  The format of the XError function is: %  %      XError(display,error) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % ( %    o error: Specifies the error event. %  %  */ int XError(display,error)  Display    *display;    XErrorEvent 	   *error;  {    xerror_alert=True;   switch (error->request_code)   {      case X_GetGeometry:      { +       if (error->error_code == BadDrawable)          return(False);       break;     }      case X_GetWindowAttributes:      case X_QueryTree:      { )       if (error->error_code == BadWindow)          return(False);       break;     }      case X_QueryColors:      { (       if (error->error_code == BadValue)         return(False);       break;     }    }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X F r e e R e s o u r c e s                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % / %  Function XFreeResources frees X11 resources.  % / %  The format of the XFreeResources routine is:  % H %      XFreeResources(display,visual_info,map_info,pixel_info,font_info,# %        resource_info,window_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % A %    o font_info: Specifies a pointer to a XFontStruct structure.  % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  %  %  */F void XFreeResources(display,visual_info,map_info,pixel_info,font_info,   resource_info,window_info) Display    *display;    XVisualInfo    *visual_info;    XStandardColormap    *map_info;  
 XPixelInfo   *pixel_info;   XFontStruct 
   *font_info;   
 XResourceInfo    *resource_info;    XWindowInfo    *window_info;  { *   if (window_info != (XWindowInfo *) NULL)     {        /*         Free X image.        */1       if (window_info->ximage != (XImage *) NULL) +         XDestroyImage(window_info->ximage); +       if (window_info->id != (Window) NULL) 	         {            /*1             Free destroy window and free cursors.            */J           if (window_info->id != XRootWindow(display,visual_info->screen))4             XDestroyWindow(display,window_info->id);9           if (window_info->annotate_context != (GC) NULL) ;             XFreeGC(display,window_info->annotate_context); :           if (window_info->highlight_context != (GC) NULL)<             XFreeGC(display,window_info->highlight_context);7           if (window_info->widget_context != (GC) NULL) 9             XFreeGC(display,window_info->widget_context); 3           XFreeCursor(display,window_info->cursor); 8           XFreeCursor(display,window_info->busy_cursor);	         }      }    /*     Free font.   */(   if (font_info != (XFontStruct *) NULL)!     XFreeFont(display,font_info); -   if (map_info != (XStandardColormap *) NULL)      {        /*!         Free X Standard Colormap.        */3       if (resource_info->map_type == (char *) NULL) G         XFreeStandardColormap(display,visual_info,map_info,pixel_info);        XFree((void *) map_info);      }    /*     Free X visual info.    */*   if (visual_info != (XVisualInfo *) NULL)      XFree((void *) visual_info);   XCloseDisplay(display);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X F r e e S t a n d a r d C o l o r m a p                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 8 %  Function XFreeStandardColormap frees an X11 colormap. % 6 %  The format of the XFreeStandardColormap routine is: % E %      XFreeStandardColormap(display,visual_info,map_info,pixel_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  %  %  */C void XFreeStandardColormap(display,visual_info,map_info,pixel_info)  Display    *display;    XVisualInfo    *visual_info;    XStandardColormap    *map_info;  
 XPixelInfo   *pixel_info; {    /*     Free colormap.   */   XFlush(display);,   if (map_info->colormap != (Colormap) NULL)L     if (map_info->colormap != XDefaultColormap(display,visual_info->screen))0       XFreeColormap(display,map_info->colormap);     else,       if (pixel_info != (XPixelInfo *) NULL)0         if ((visual_info->class != TrueColor) &&0             (visual_info->class != DirectColor))D           XFreeColors(display,map_info->colormap,pixel_info->pixels,(             (int) pixel_info->colors,0);%   map_info->colormap=(Colormap) NULL; (   if (pixel_info != (XPixelInfo *) NULL)     { 7       if (pixel_info->pixels != (unsigned long *) NULL) *         free((char *) pixel_info->pixels);0       pixel_info->pixels=(unsigned long *) NULL;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t A n n o t a t e I n f o                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetAnnotateInfo initializes the AnnotateInfo structure. % 0 %  The format of the GetAnnotateInfo routine is: % # %      XGetAnnotateInfo(image_info)  % + %  A description of each parameter follows:  % G %    o annotate_info: Specifies a pointer to a XAnnotateInfo structure.  %  %  */$ void XGetAnnotateInfo(annotate_info)
 XAnnotateInfo    *annotate_info;  {    /*"     Initialize annotate structure.   */   annotate_info->x=0;    annotate_info->y=0;    annotate_info->width=0;    annotate_info->height=0;   annotate_info->degrees=0.0; 0   annotate_info->font_info=(XFontStruct *) NULL;$   annotate_info->text=(char *) NULL;    *annotate_info->geometry='\0';1   annotate_info->previous=(XAnnotateInfo *) NULL; -   annotate_info->next=(XAnnotateInfo *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t M a p I n f o                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetMapInfo initializes the XStandardColormap structure. % 2 %  The format of the XStandardColormap routine is: % 1 %      XGetMapInfo(visual_info,colormap,map_info)  % + %  A description of each parameter follows:  % ; %    o colormap: Specifies the ID of the X server colormap.  % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % J %    o map_info: Specifies a pointer to a X11 XStandardColormap structure. %  %  *// void XGetMapInfo(visual_info,colormap,map_info)  XVisualInfo    *visual_info;    Colormap   colormap;    XStandardColormap    *map_info; {    /*     Initialize map info.   */   map_info->colormap=colormap;*   map_info->red_max=visual_info->red_mask;4   map_info->red_mult=map_info->red_max != 0 ? 1 : 0;   if (map_info->red_max != 0) +     while ((map_info->red_max & 0x01) == 0)      {        map_info->red_max>>=1;       map_info->red_mult<<=1;      } .   map_info->green_max=visual_info->green_mask;8   map_info->green_mult=map_info->green_max != 0 ? 1 : 0;   if (map_info->green_max != 0) -     while ((map_info->green_max & 0x01) == 0)      {        map_info->green_max>>=1;       map_info->green_mult<<=1;      } ,   map_info->blue_max=visual_info->blue_mask;6   map_info->blue_mult=map_info->blue_max != 0 ? 1 : 0;   if (map_info->blue_max != 0),     while ((map_info->blue_max & 0x01) == 0)     {        map_info->blue_max>>=1;        map_info->blue_mult<<=1;     }    map_info->base_pixel=0;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t M o n t a g e I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Function XGetMontageInfo initializes the MontageInfo structure. % 0 %  The format of the XGetMontageInfo routine is: % $ %      XGetMontageInfo(montage_info) % + %  A description of each parameter follows:  % D %    o montage_info: Specifies a pointer to a MontageInfo structure. %  %  */" void XGetMontageInfo(montage_info) XMontageInfo   *montage_info; {    montage_info->number_tiles=0;    montage_info->frame=True;    montage_info->shadow=True;+   montage_info->compose=ReplaceCompositeOp;    montage_info->tile="5x4";  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t P i x e l I n f o                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % > %  Function XGetPixelInfo initializes the PixelInfo structure. % . %  The format of the XGetPixelInfo routine is: % F %      XGetPixelInfo(display,visual_info,map_info,resource_info,image, %        pixel_info) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  %  %  */O void XGetPixelInfo(display,visual_info,map_info,resource_info,image,pixel_info)  Display    *display;    XVisualInfo    *visual_info;    XStandardColormap    *map_info;  
 XResourceInfo    *resource_info;    Image 	   *image;   
 XPixelInfo   *pixel_info; { 
   static char      *PenColors[MaxNumberPens]=     {        Pen1Color,       Pen2Color,       Pen3Color,       Pen4Color,       Pen5Color,       Pen6Color,       Pen7Color,       Pen8Color,       Pen9Color,       Pen0Color,     };  
   Colormap
     colormap;      int 	     blue, 
     green,     red,     status;      register int     i;     unsigned int     packets;     /*     Initialize pixel info.   */   pixel_info->colors=0;    if (image != (Image *) NULL)$     if (image->class == PseudoClass)'       pixel_info->colors=image->colors; K   packets=Max(pixel_info->colors,visual_info->colormap_size)+MaxNumberPens; M   pixel_info->pixels=(unsigned long *) malloc(packets*sizeof(unsigned long)); 3   if (pixel_info->pixels == (unsigned long *) NULL) A     Error("Unable to get pixel info","Memory allocation failed");    /*     Set foreground color.    */   colormap=map_info->colormap;6   (void) XParseColor(display,colormap,ForegroundColor,#     &pixel_info->foreground_color); F   status=XParseColor(display,colormap,resource_info->foreground_color,#     &pixel_info->foreground_color);    if (status == 0)N     Warning("Color is not known to X server",resource_info->foreground_color);%   pixel_info->foreground_color.pixel= =     XStandardPixel(map_info,pixel_info->foreground_color,16); >   pixel_info->foreground_color.flags=DoRed | DoGreen | DoBlue;   /*     Set background color.    */6   (void) XParseColor(display,colormap,BackgroundColor,#     &pixel_info->background_color); F   status=XParseColor(display,colormap,resource_info->background_color,#     &pixel_info->background_color);    if (status == 0)N     Warning("Color is not known to X server",resource_info->background_color);%   pixel_info->background_color.pixel= =     XStandardPixel(map_info,pixel_info->background_color,16); >   pixel_info->background_color.flags=DoRed | DoGreen | DoBlue;   /*     Set border color.    */M   (void) XParseColor(display,colormap,BorderColor,&pixel_info->border_color); B   status=XParseColor(display,colormap,resource_info->border_color,     &pixel_info->border_color);    if (status == 0)J     Warning("Color is not known to X server",resource_info->border_color);!   pixel_info->border_color.pixel= 9     XStandardPixel(map_info,pixel_info->border_color,16); :   pixel_info->border_color.flags=DoRed | DoGreen | DoBlue;   /*     Set matte color.   */7   pixel_info->matte_color=pixel_info->background_color; 2   if (resource_info->matte_color != (char *) NULL)     {        /*J         Matte color is specified as a X resource or command line argument.       */E       status=XParseColor(display,colormap,resource_info->matte_color, "         &pixel_info->matte_color);       if (status == 0)M         Warning("Color is not known to X server",resource_info->matte_color); $       pixel_info->matte_color.pixel=<         XStandardPixel(map_info,pixel_info->matte_color,16);=       pixel_info->matte_color.flags=DoRed | DoGreen | DoBlue;      }    /*     Set highlight color.   */2   red=ColorShift(309*pixel_info->matte_color.red);>   pixel_info->highlight_color.red=(red > 65535 ? 65535 : red);6   green=ColorShift(309*pixel_info->matte_color.green);D   pixel_info->highlight_color.green=(green > 65535 ? 65535 : green);4   blue=ColorShift(309*pixel_info->matte_color.blue);A   pixel_info->highlight_color.blue=(blue > 65535 ? 65535 : blue); $   pixel_info->highlight_color.pixel=<     XStandardPixel(map_info,pixel_info->highlight_color,16);=   pixel_info->highlight_color.flags=DoRed | DoGreen | DoBlue;    /*     Set shadow color.    */K   pixel_info->shadow_color.red=ColorShift(148*pixel_info->matte_color.red); O   pixel_info->shadow_color.green=ColorShift(148*pixel_info->matte_color.green); M   pixel_info->shadow_color.blue=ColorShift(148*pixel_info->matte_color.blue); !   pixel_info->shadow_color.pixel= 9     XStandardPixel(map_info,pixel_info->shadow_color,16); :   pixel_info->shadow_color.flags=DoRed | DoGreen | DoBlue;   /*     Set depth color.   */J   pixel_info->depth_color.red=ColorShift(209*pixel_info->matte_color.red);N   pixel_info->depth_color.green=ColorShift(209*pixel_info->matte_color.green);L   pixel_info->depth_color.blue=ColorShift(209*pixel_info->matte_color.blue);    pixel_info->depth_color.pixel=8     XStandardPixel(map_info,pixel_info->depth_color,16);9   pixel_info->depth_color.flags=DoRed | DoGreen | DoBlue;    /*     Set trough color.    */K   pixel_info->trough_color.red=ColorShift(134*pixel_info->matte_color.red); O   pixel_info->trough_color.green=ColorShift(134*pixel_info->matte_color.green); M   pixel_info->trough_color.blue=ColorShift(134*pixel_info->matte_color.blue); !   pixel_info->trough_color.pixel= 9     XStandardPixel(map_info,pixel_info->trough_color,16); :   pixel_info->trough_color.flags=DoRed | DoGreen | DoBlue;   /*     Set pen color.   */#   for (i=0; i < MaxNumberPens; i++)    { P     (void) XParseColor(display,colormap,PenColors[i],&pixel_info->pen_color[i]);D     status=XParseColor(display,colormap,resource_info->pen_color[i],!       &pixel_info->pen_color[i]);      if (status == 0)L       Warning("Color is not known to X server",resource_info->pen_color[i]);#     pixel_info->pen_color[i].pixel= ;       XStandardPixel(map_info,pixel_info->pen_color[i],16); <     pixel_info->pen_color[i].flags=DoRed | DoGreen | DoBlue;   } :   pixel_info->annotate_color=pixel_info->foreground_color;   if (image != (Image *) NULL)$     if (image->class == PseudoClass)       { 
         /*@           Initialize pixel array for images of type PseudoClass.
         */)         for (i=0; i < image->colors; i++) N           pixel_info->pixels[i]=XStandardPixel(map_info,image->colormap[i],8);)         for (i=0; i < MaxNumberPens; i++) M           pixel_info->pixels[image->colors+i]=pixel_info->pen_color[i].pixel; *         pixel_info->colors+=MaxNumberPens;       }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e C l a s s                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XGetResourceClass queries the X server for the specified resource F %  name or class.  If the resource name or class is not defined in the4 %  database, the supplied default value is returned. % 2 %  The format of the XGetResourceClass routine is: % M %      value=XGetResourceClass(database,client_name,keyword,resource_default)  % + %  A description of each parameter follows:  % N %    o value: Function XGetResourceClass returns the resource value associatedO %      with the name or class.  If none is found, the supplied default value is  %      returned. % = %    o database: Specifies a resource database; returned from  %      XrmGetStringDatabase. % M %    o client_name:  Specifies the application name used to retrieve resource ' %      info from the X server database.  % C %    o keyword: Specifies the keyword of the value being retrieved.  % K %    o resource_default: Specifies the default value to return if the query 1 %      fails to find the specified keyword/class.  %  %  */F char *XGetResourceClass(database,client_name,keyword,resource_default) XrmDatabase    database;    char   *client_name,    *keyword,    *resource_default; {    char     *resource_type, "     resource_class[MaxTextLength],!     resource_name[MaxTextLength];      int      status;   
   XrmValue     resource_value;   %   if (database == (XrmDatabase) NULL)      return(resource_default);    *resource_name='\0';   *resource_class='\0';    if (keyword != (char *) NULL)      {        unsigned char 
         c,
         k;         /*.         Initialize resource keyword and class.       */@       (void) sprintf(resource_name,"%s.%s",client_name,keyword);       c=(*client_name); %       if ((c >= XK_a) && (c <= XK_z))          c-=(XK_a-XK_A); 
       else5         if ((c >= XK_agrave) && (c <= XK_odiaeresis)) #           c-=(XK_agrave-XK_Agrave);          else2           if ((c >= XK_oslash) && (c <= XK_thorn))'             c-=(XK_oslash-XK_Ooblique);        k=(*keyword); %       if ((k >= XK_a) && (k <= XK_z))          k-=(XK_a-XK_A); 
       else5         if ((k >= XK_agrave) && (k <= XK_odiaeresis)) #           k-=(XK_agrave-XK_Agrave);          else2           if ((k >= XK_oslash) && (k <= XK_thorn))'             k-=(XK_oslash-XK_Ooblique); M       (void) sprintf(resource_class,"%c%s.%c%s",c,client_name+1,k,keyword+1);      } M   status=XrmGetResource(database,resource_name,resource_class,&resource_type,      &resource_value);    if (status == False)     return(resource_default);    return(resource_value.addr); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e D a t a b a s e                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetResourceDatabase creates a new resource database and %  initializes it. % 5 %  The format of the XGetResourceDatabase routine is:  % 9 %      database=XGetResourceDatabase(display,client_name)  % + %  A description of each parameter follows:  % I %    o database: Function XGetResourceDatabase returns the database after  %      it is initialized.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % M %    o client_name:  Specifies the application name used to retrieve resource ' %      info from the X server database.  %  %  */5 XrmDatabase XGetResourceDatabase(display,client_name)  Display    *display;    char   *client_name;  {    char(     application_defaults[MaxTextLength],     *resource_value;     register char      *p;      unsigned char      c;  
   XrmDatabase      application_database,      resource_database,     server_database;     /*!     Initialize resource database.    */   XrmInitialize();+   XGetDefault(display,client_name,"dummy"); ,   resource_database=XrmGetDatabase(display);   /*     Merge application database.    */#   if (client_name != (char *) NULL)      {        /*         Get basename of client.        */,       p=client_name+(strlen(client_name)-1);.       while ((p > client_name) && (*p != '/'))         p--;       if (*p == '/')         client_name=p+1;     }    c=(*client_name); !   if ((c >= XK_a) && (c <= XK_z))      c-=(XK_a-XK_A);    else1     if ((c >= XK_agrave) && (c <= XK_odiaeresis))        c-=(XK_agrave-XK_Agrave);      else.       if ((c >= XK_oslash) && (c <= XK_thorn))#         c-=(XK_oslash-XK_Ooblique); E   (void) sprintf(application_defaults,"%s%c%s",ApplicationDefaults,c,      client_name+1); @   application_database=XrmGetFileDatabase(application_defaults);=   XrmMergeDatabases(application_database,&resource_database); 1   resource_value=XResourceManagerString(display); &   if (resource_value == (char *) NULL)     resource_value="";   /*     Merge server database.   */7   server_database=XrmGetStringDatabase(resource_value); 8   XrmMergeDatabases(server_database,&resource_database);   return(resource_database); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e I n f o                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetResourceInfo initializes the ResourceInfo structure. % 1 %  The format of the XGetResourceInfo routine is:  % D %      XGetResourceInfo(resource_database,client_name,resource_info) % + %  A description of each parameter follows:  % F %    o resource_database: Specifies a resource database; returned from %      XrmGetStringDatabase. % D %    o client_name:  Specifies the application name used to retrieve0 %      resource info from the X server database. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */B void XGetResourceInfo(resource_database,client_name,resource_info) XrmDatabase    resource_database;   char   *client_name;   
 XResourceInfo    *resource_info;  {    char     *resource_value;     register char      *p;   #   if (client_name != (char *) NULL)      {        /*         Get basename of client.        */,       p=client_name+(strlen(client_name)-1);.       while ((p > client_name) && (*p != '/'))         p--;       if (*p == '/')         client_name=p+1;     }    /*$     Initialize resource info fields.   */5   resource_info->resource_database=resource_database;    resource_value= H     XGetResourceClass(resource_database,client_name,"backdrop","False");1   resource_info->backdrop=IsTrue(resource_value); I   resource_info->background_color=XGetResourceInstance(resource_database, .     client_name,"background",BackgroundColor);E   resource_info->border_color=XGetResourceInstance(resource_database, +     client_name,"borderColor",BorderColor);    resource_value= G     XGetResourceClass(resource_database,client_name,"borderWidth","2"); 3   resource_info->border_width=atoi(resource_value);    resource_value= I     XGetResourceClass(resource_database,client_name,"colormap","shared"); ,   resource_info->colormap=UndefinedColormap;3   if (Latin1Compare("private",resource_value) == 0) ,     resource_info->colormap=PrivateColormap;2   if (Latin1Compare("shared",resource_value) == 0)+     resource_info->colormap=SharedColormap; 3   if (resource_info->colormap == UndefinedColormap) 9     Warning("Unrecognized colormap type",resource_value); &   resource_info->color_recovery=False;O   resource_value=XGetResourceClass(resource_database,client_name,"colors","0"); 4   resource_info->number_colors=atoi(resource_value);   resource_value= H     XGetResourceClass(resource_database,client_name,"colorspace","rgb");0   resource_info->colorspace=UndefinedColorspace;0   if (Latin1Compare("gray",resource_value) == 0)-     resource_info->colorspace=GRAYColorspace; /   if (Latin1Compare("rgb",resource_value) == 0) ,     resource_info->colorspace=RGBColorspace;0   if (Latin1Compare("ohta",resource_value) == 0)-     resource_info->colorspace=OHTAColorspace; /   if (Latin1Compare("xyz",resource_value) == 0) ,     resource_info->colorspace=XYZColorspace;/   if (Latin1Compare("yiq",resource_value) == 0) ,     resource_info->colorspace=YIQColorspace;/   if (Latin1Compare("yuv",resource_value) == 0) ,     resource_info->colorspace=YUVColorspace;7   if (resource_info->colorspace == UndefinedColorspace) ;     Warning("Unrecognized colorspace type",resource_value); P   resource_info->editor_command=XGetResourceClass(resource_database,client_name,#     "editorCommand",EditorCommand);    resource_value= E     XGetResourceClass(resource_database,client_name,"debug","False"); .   resource_info->debug=IsTrue(resource_value);N   resource_value=XGetResourceClass(resource_database,client_name,"delay","0");,   resource_info->delay=atoi(resource_value);   resource_value= E     XGetResourceClass(resource_database,client_name,"dither","True"); /   resource_info->dither=IsTrue(resource_value);    resource_info->font=N     XGetResourceClass(resource_database,client_name,"fontList",(char *) NULL);   resource_info->font_name[0]=E     XGetResourceClass(resource_database,client_name,"font1","fixed");    resource_info->font_name[1]=H     XGetResourceClass(resource_database,client_name,"font2","variable");   resource_info->font_name[2]=C     XGetResourceClass(resource_database,client_name,"font3","5x8");    resource_info->font_name[3]=D     XGetResourceClass(resource_database,client_name,"font4","6x10");   resource_info->font_name[4]=H     XGetResourceClass(resource_database,client_name,"font5","7x13bold");   resource_info->font_name[5]=H     XGetResourceClass(resource_database,client_name,"font6","8x13bold");   resource_info->font_name[6]=H     XGetResourceClass(resource_database,client_name,"font7","9x15bold");   resource_info->font_name[7]=E     XGetResourceClass(resource_database,client_name,"font8","10x20");    resource_info->font_name[8]=E     XGetResourceClass(resource_database,client_name,"font9","12x24");    resource_info->font_name[9]=E     XGetResourceClass(resource_database,client_name,"font0","fixed"); I   resource_info->foreground_color=XGetResourceInstance(resource_database, .     client_name,"foreground",ForegroundColor);O   resource_info->icon_geometry=XGetResourceClass(resource_database,client_name, "     "iconGeometry",(char *) NULL);   resource_value= G     XGetResourceClass(resource_database,client_name,"gravity","North");    resource_info->gravity=(-1);2   if (Latin1Compare("Forget",resource_value) == 0))     resource_info->gravity=ForgetGravity; 5   if (Latin1Compare("NorthWest",resource_value) == 0) ,     resource_info->gravity=NorthWestGravity;1   if (Latin1Compare("North",resource_value) == 0) (     resource_info->gravity=NorthGravity;5   if (Latin1Compare("NorthEast",resource_value) == 0) ,     resource_info->gravity=NorthEastGravity;0   if (Latin1Compare("West",resource_value) == 0)'     resource_info->gravity=WestGravity; 2   if (Latin1Compare("Center",resource_value) == 0))     resource_info->gravity=CenterGravity; 0   if (Latin1Compare("East",resource_value) == 0)'     resource_info->gravity=EastGravity; 5   if (Latin1Compare("SouthWest",resource_value) == 0) ,     resource_info->gravity=SouthWestGravity;1   if (Latin1Compare("South",resource_value) == 0) (     resource_info->gravity=SouthGravity;5   if (Latin1Compare("SouthEast",resource_value) == 0) ,     resource_info->gravity=SouthEastGravity;2   if (Latin1Compare("Static",resource_value) == 0))     resource_info->gravity=StaticGravity; %   if (resource_info->gravity == (-1))      { :       Warning("Unrecognized gravity type",resource_value);+       resource_info->gravity=CenterGravity;      }    resource_value= F     XGetResourceClass(resource_database,client_name,"iconic","False");/   resource_info->iconic=IsTrue(resource_value); D   resource_info->image_geometry=XGetResourceClass(resource_database,*     client_name,"geometry",(char *) NULL);P   resource_value=XGetResourceClass(resource_database,client_name,"magnify","3");.   resource_info->magnify=atoi(resource_value);   resource_info->map_type=I     XGetResourceClass(resource_database,client_name,"map",(char *) NULL); D   resource_info->matte_color=XGetResourceInstance(resource_database,,     client_name,"mattecolor",(char *) NULL);   resource_value= J     XGetResourceClass(resource_database,client_name,"monochrome","False");3   resource_info->monochrome=IsTrue(resource_value);    resource_info->name=J     XGetResourceClass(resource_database,client_name,"name",(char *) NULL);N   resource_info->pan_geometry=XGetResourceClass(resource_database,client_name,!     "panGeometry",(char *) NULL);    resource_info->pen_color[0]=D     XGetResourceClass(resource_database,client_name,"pen1","black");   resource_info->pen_color[1]=C     XGetResourceClass(resource_database,client_name,"pen2","blue");    resource_info->pen_color[2]=C     XGetResourceClass(resource_database,client_name,"pen3","cyan");    resource_info->pen_color[3]=D     XGetResourceClass(resource_database,client_name,"pen4","green");   resource_info->pen_color[4]=C     XGetResourceClass(resource_database,client_name,"pen5","gray");    resource_info->pen_color[5]=B     XGetResourceClass(resource_database,client_name,"pen6","red");   resource_info->pen_color[6]=F     XGetResourceClass(resource_database,client_name,"pen7","magenta");   resource_info->pen_color[7]=E     XGetResourceClass(resource_database,client_name,"pen8","yellow");    resource_info->pen_color[8]=D     XGetResourceClass(resource_database,client_name,"pen9","white");   resource_info->pen_color[9]=C     XGetResourceClass(resource_database,client_name,"pen0","gray"); O   resource_info->print_command=XGetResourceClass(resource_database,client_name, !     "printCommand",PrintCommand);    resource_info->server_name= P     XGetResourceClass(resource_database,client_name,"serverName",(char *) NULL);   resource_value= K     XGetResourceClass(resource_database,client_name,"sharedMemory","True"); :   resource_info->use_shared_memory=IsTrue(resource_value);   resource_info->text_font= N     XGetResourceClass(resource_database,client_name,"textFont",(char *) NULL);   resource_info->title= K     XGetResourceClass(resource_database,client_name,"title",(char *) NULL);    resource_value= E     XGetResourceClass(resource_database,client_name,"treeDepth","0"); 1   resource_info->tree_depth=atoi(resource_value);    resource_value= F     XGetResourceClass(resource_database,client_name,"update","False");/   resource_info->update=IsTrue(resource_value);    resource_value= I     XGetResourceClass(resource_database,client_name,"usePixmap","False"); 3   resource_info->use_pixmap=IsTrue(resource_value);    resource_info->visual_type= L     XGetResourceClass(resource_database,client_name,"visual",(char *) NULL);   resource_info->window_id= L     XGetResourceClass(resource_database,client_name,"window",(char *) NULL);D   resource_info->write_filename=XGetResourceClass(resource_database,/     client_name,"writeFilename",(char *) NULL);    /*     Handle side-effects.   */    if (resource_info->monochrome)     { %       resource_info->number_colors=2; "       resource_info->tree_depth=8;!       resource_info->dither=True; /       resource_info->colorspace=GRAYColorspace;      } 2   if (resource_info->colorspace == GRAYColorspace)     { '       resource_info->number_colors=256; "       resource_info->tree_depth=8;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e I n s t a n c e                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XGetResourceInstance queries the X server for the specified K %  resource name.  If the resource name is not defined in the database, the & %  supplied default value is returned. % 5 %  The format of the XGetResourceInstance routine is:  % P %      value=XGetResourceInstance(database,client_name,keyword,resource_default) % + %  A description of each parameter follows:  % F %    o value: Function XGetResourceInstance returns the resource valueI %      associated with the name or class.  If none is found, the supplied ! %      default value is returned.  % = %    o database: Specifies a resource database; returned from  %      XrmGetStringDatabase. % D %    o client_name:  Specifies the application name used to retrieve0 %      resource info from the X server database. % C %    o keyword: Specifies the keyword of the value being retrieved.  % K %    o resource_default: Specifies the default value to return if the query 1 %      fails to find the specified keyword/class.  %  %  */I char *XGetResourceInstance(database,client_name,keyword,resource_default)  XrmDatabase    database;    char   *client_name,    *keyword,    *resource_default; {    char     *resource_type, !     resource_name[MaxTextLength];      int      status;   
   XrmValue     resource_value;   %   if (database == (XrmDatabase) NULL)      return(resource_default);    *resource_name='\0';   if (keyword != (char *) NULL) >     (void) sprintf(resource_name,"%s.%s",client_name,keyword);L   status=XrmGetResource(database,resource_name,(char *) NULL,&resource_type,     &resource_value);    if (status == False)     return(resource_default);    return(resource_value.addr); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i n d o w C o l o r                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XGetWindowColor returns the color of a pixel interactively choosen %  from the X server.  % 0 %  The format of the XGetWindowColor routine is: % , %      status=XGetWindowColor(display,color) % + %  A description of each parameter follows:  % M %    o status: Function XGetWindowColor returns True if the color is obtained B %      from the X server.  False is returned if any errors occurs. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % G %    o color: The color of the pixel choosen is returned in this XColor  %      structure.  %  %  */+ unsigned int XGetWindowColor(display,color)  Display    *display;    XColor	   *color;  {    int      x,     y;     RectangleInfo      crop_info;     unsigned int     status;      Window
     child,     client_window,     root_window,     target_window;     XImage     *ximage;     XWindowAttributes      window_attributes;     /*%     Choose a pixel from the X server.    */2   target_window=XSelectWindow(display,&crop_info);;   root_window=XRootWindow(display,XDefaultScreen(display));    client_window=target_window;#   if (target_window != root_window)      {        unsigned int
         d;         /*         Get client window.       */P       status=XGetGeometry(display,target_window,&root_window,&x,&x,&d,&d,&d,&d);       if (status != 0)	         { =           client_window=XClientWindow(display,target_window); &           target_window=client_window;	         }      }    /*     Verify window is viewable.   */H   status=XGetWindowAttributes(display,target_window,&window_attributes);G   if ((status == False) || (window_attributes.map_state != IsViewable))      return(False);   /*     Get window X image.    */F   XTranslateCoordinates(display,root_window,target_window,crop_info.x,     crop_info.y,&x,&y,&child);D   ximage=XGetImage(display,target_window,x,y,1,1,AllPlanes,ZPixmap);    if (ximage == (XImage *) NULL)     return(False);%   color->pixel=XGetPixel(ximage,0,0);    XDestroyImage(ximage);   /*#     Query X server for pixel color.    */8   XQueryColor(display,window_attributes.colormap,color);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i n d o w I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function XGetWindowImage reads an image from the target X window and returns M %  it.  XGetWindowImage optionally descends the window hierarchy and overlays . %  the target image with each subwindow image. % 0 %  The format of the XGetWindowImage routine is: % : %      image=XGetWindowImage(display,window,borders,level) % + %  A description of each parameter follows:  % H %    o image: Function XGetWindowImage returns a MIFF image if it can beH %      successfully read from the X window.  A null image is returned if %      any errors occurs.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % = %    o window: Specifies the window to obtain the image from.  % E %    o borders: Specifies whether borders pixels are to be saved with  %      the image.  % E %    o level: Specifies an unsigned integer representing the level of I %      decent in the window hierarchy.  This value must be zero or one on J %      the initial call to XGetWindowImage.  A value of zero returns afterJ %      one call.  A value of one causes the function to descend the windowI %      hierarchy and overlays the target image with each subwindow image.  %  %  */4 Image *XGetWindowImage(display,window,borders,level) Display    *display;    Window	   window;    unsigned int
   borders,   level; {    typedef struct _ColormapList   {      Colormap       colormap;   
     XColor       *colors;       struct _ColormapList       *next;   } ColormapList;      GC     annotate_context;      Image      *image;      int      display_height,      display_width,     number_colors,     status, 
     x_offset, 
     y_offset;      RectangleInfo      crop_info;     register int     i,     x,     y;     register RunlengthPacket     *p;      register unsigned long
     pixel;     static ColormapList +     *colormap_list = (ColormapList *) NULL;      Window
     child,     root_window;     XColor     *colors;     XGCValues      context_values;      XImage     *ximage;     XWindowAttributes      window_attributes;     /*     Verify window is viewable.   */A   status=XGetWindowAttributes(display,window,&window_attributes); G   if ((status == False) || (window_attributes.map_state != IsViewable))      return((Image *) NULL);    /*2     Cropping rectangle is relative to root window.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); K   XTranslateCoordinates(display,window,root_window,0,0,&x_offset,&y_offset,      &child);   crop_info.x=x_offset;    crop_info.y=y_offset; *   crop_info.width=window_attributes.width;,   crop_info.height=window_attributes.height;   if (borders)     {        /*          Include border in image.       */2       crop_info.x-=window_attributes.border_width;2       crop_info.y-=window_attributes.border_width;;       crop_info.width+=window_attributes.border_width << 1; <       crop_info.height+=window_attributes.border_width << 1;     }    /*     Crop to root window.   */   if (crop_info.x < 0)     { 2       if ((crop_info.x+(int) crop_info.width) < 0)         return((Image *) NULL); #       crop_info.width+=crop_info.x;        crop_info.x=0;     }    if (crop_info.y < 0)     { 3       if ((crop_info.y+(int) crop_info.height) < 0)          return((Image *) NULL); $       crop_info.height+=crop_info.y;       crop_info.y=0;     } ?   display_width=XDisplayWidth(display,XDefaultScreen(display)); :   if ((crop_info.x+(int) crop_info.width) > display_width)     { '       if (crop_info.x >= display_width)          return((Image *) NULL); 0       crop_info.width=display_width-crop_info.x;     } A   display_height=XDisplayHeight(display,XDefaultScreen(display)); <   if ((crop_info.y+(int) crop_info.height) > display_height)     { (       if (crop_info.y >= display_height)         return((Image *) NULL); 2       crop_info.height=display_height-crop_info.y;     }    crop_info.x-=x_offset;   crop_info.y-=y_offset;   /*D     Alert user we are about to get an X region by flashing a border.   */I   context_values.background=XBlackPixel(display,XDefaultScreen(display)); I   context_values.foreground=XWhitePixel(display,XDefaultScreen(display)); #   context_values.function=GXinvert;    context_values.plane_mask=:     context_values.background ^ context_values.foreground;1   context_values.subwindow_mode=IncludeInferiors; I   annotate_context=XCreateGC(display,window,GCBackground | GCForeground | @     GCFunction | GCPlaneMask | GCSubwindowMode,&context_values);$   if (annotate_context != (GC) NULL)     { C       XHighlightRegion(display,window,annotate_context,&crop_info); 9       XDelay(display,(unsigned long) (SuspendTime << 2)); C       XHighlightRegion(display,window,annotate_context,&crop_info);      }    /*     Get window X image.    */J   ximage=XGetImage(display,window,crop_info.x,crop_info.y,crop_info.width,(     crop_info.height,AllPlanes,ZPixmap);    if (ximage == (XImage *) NULL)     return((Image *) NULL);    number_colors=0;   colors=(XColor *) NULL; 4   if (window_attributes.colormap != (Colormap) NULL)     {        ColormapList         *p;          /*1         Search colormap list for window colormap.        */:       number_colors=window_attributes.visual->map_entries;B       for (p=colormap_list; p != (ColormapList *) NULL; p=p->next)6         if (p->colormap == window_attributes.colormap)           break;%       if (p == (ColormapList *) NULL) 	         {            /*$             Get the window colormap.           */A           colors=(XColor *) malloc(number_colors*sizeof(XColor)); (           if (colors == (XColor *) NULL)
             { $               XDestroyImage(ximage);%               return((Image *) NULL); 
             } A           if ((window_attributes.visual->class != DirectColor) && =               (window_attributes.visual->class != TrueColor)) -             for (i=0; i < number_colors; i++) 
             {                 colors[i].pixel=i;               colors[i].pad=0;
             }            else
             {                unsigned long                  blue,                  blue_bit,                  green,                 green_bit,                 red,                 red_bit;                 /*0                 DirectColor or TrueColor visual.               */               red=0;               green=0;               blue=0; :               red_bit=window_attributes.visual->red_mask &:                 (~(window_attributes.visual->red_mask)+1);>               green_bit=window_attributes.visual->green_mask &<                 (~(window_attributes.visual->green_mask)+1);<               blue_bit=window_attributes.visual->blue_mask &;                 (~(window_attributes.visual->blue_mask)+1); /               for (i=0; i < number_colors; i++)                { 3                 colors[i].pixel=red | green | blue;                   colors[i].pad=0;                 red+=red_bit; =                 if (red > window_attributes.visual->red_mask)                    red=0;!                 green+=green_bit; A                 if (green > window_attributes.visual->green_mask)                    green=0;                 blue+=blue_bit; ?                 if (blue > window_attributes.visual->blue_mask)                    blue=0;                } 
             } A           XQueryColors(display,window_attributes.colormap,colors,              (int) number_colors);           /*-             Append colormap to colormap list.            */:           p=(ColormapList *) malloc(sizeof(ColormapList));1           p->colormap=window_attributes.colormap;            p->colors=colors;             p->next=colormap_list;           colormap_list=p;	         }        colors=p->colors;      }    /*     Allocate image structure.    */*   image=AllocateImage((ImageInfo *) NULL);   if (image == (Image *) NULL)     {        XDestroyImage(ximage);       return((Image *) NULL);      }    /*#     Convert X image to MIFF format.    */7   if ((window_attributes.visual->class != TrueColor) && 7       (window_attributes.visual->class != DirectColor))      image->class=PseudoClass;    image->columns=ximage->width;    image->rows=ximage->height; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) B     malloc((unsigned int) image->packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)     {        XDestroyImage(ximage);       DestroyImage(image);       return((Image *) NULL);      }    p=image->pixels;   switch (image->class)    {      case DirectClass:      {        register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,          green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */2       red_mask=window_attributes.visual->red_mask;       red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;          red_shift++;       } 6       green_mask=window_attributes.visual->green_mask;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;          green_shift++;       } 4       blue_mask=window_attributes.visual->blue_mask;       blue_shift=0; %       while ((blue_mask & 0x01) == 0)        {          blue_mask>>=1;         blue_shift++;        }        /*/         Convert X image to DirectClass packets.        */        if ((number_colors > 0) &&;           (window_attributes.visual->class == DirectColor)) '         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);2             index=(pixel >> red_shift) & red_mask;1             p->red=ColorShift(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             p->green=ColorShift(colors[index].green); 4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=ColorShift(colors[index].blue);              p->index=0;              p->length=0;             p++;           } 	         } 
       else'         for (y=0; y < image->rows; y++) ,           for (x=0; x < image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;F             p->red=ColorShift(((unsigned long) color*65535)/red_mask);6             color=(pixel >> green_shift) & green_mask;J             p->green=ColorShift(((unsigned long) color*65535)/green_mask);4             color=(pixel >> blue_shift) & blue_mask;H             p->blue=ColorShift(((unsigned long) color*65535)/blue_mask);             p->index=0;              p->length=0;             p++;           }        break;     }      case PseudoClass:      {        /*         Create colormap.       */"       image->colors=number_colors;P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {             XDestroyImage(ximage);           DestroyImage(image);!           return((Image *) NULL); 	         } '       for (i=0; i < image->colors; i++)        { G         image->colormap[colors[i].pixel].red=ColorShift(colors[i].red); K         image->colormap[colors[i].pixel].green=ColorShift(colors[i].green); I         image->colormap[colors[i].pixel].blue=ColorShift(colors[i].blue);        }        /*/         Convert X image to PseudoClass packets.        */%       for (y=0; y < image->rows; y++) *         for (x=0; x < image->columns; x++)	         { &           pixel=XGetPixel(ximage,x,y);*           p->index=(unsigned short) pixel;           p->length=0;           p++;	         }        SyncImage(image);        break;     }    }    XDestroyImage(ximage);$   if (annotate_context != (GC) NULL)     {        /*<         Alert user we got the X region by flashing a border.       */C       XHighlightRegion(display,window,annotate_context,&crop_info);        XFlush(display);C       XHighlightRegion(display,window,annotate_context,&crop_info); (       XFreeGC(display,annotate_context);     }    if (level != 0)      {        unsigned int         number_children;         Window         *children,         parent;          /*K         Descend the window hierarchy and overlay with each subwindow image.        */F       status=XQueryTree(display,window,&root_window,&parent,&children,         &number_children);5       if ((status == True) && (number_children != 0)) 	         {            Image              *child_image;              /*:             Composite any children in back-to-front order.           */-           for (i=0; i < number_children; i++)            { K             child_image=XGetWindowImage(display,children[i],False,level+1); .             if (child_image != (Image *) NULL)               {                  /*/                   Composite child window image.                  */O                 XTranslateCoordinates(display,children[i],window,0,0,&x_offset, $                   &y_offset,&child);&                 x_offset-=crop_info.x;!                 if (x_offset < 0)                    x_offset=0; &                 y_offset-=crop_info.y;!                 if (y_offset < 0)                    y_offset=0; M                 CompositeImage(image,ReplaceCompositeOp,child_image,x_offset,                    y_offset);*                 DestroyImage(child_image);               }            } #           XFree((void *) children); 	         }      }    if (level <= 1)      {        ColormapList         *next;         /*         Free resources.        */4       while (colormap_list != (ColormapList *) NULL)       { !         next=colormap_list->next; -         free((char *) colormap_list->colors); %         free((char *) colormap_list);          colormap_list=next;        } &       if (image->class == PseudoClass)          CompressColormap(image);     }    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i n d o w I n f o                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Function XGetWindowInfo initializes the XWindowInfo structure.  % / %  The format of the XGetWindowInfo routine is:  % H %      XGetWindowInfo(display,visual_info,map_info,pixel_info,font_info, %        resource_info,window) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % A %    o font_info: Specifies a pointer to a XFontStruct structure.  % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */F void XGetWindowInfo(display,visual_info,map_info,pixel_info,font_info,   resource_info,window)  Display    *display;    XVisualInfo    *visual_info;    XStandardColormap   *map_info;   
 XPixelInfo   *pixel_info;   XFontStruct 
   *font_info;   
 XResourceInfo    *resource_info;    XWindowInfo 
   *window; {    /*     Initialize window info.    */"   if (window->id != (Window) NULL)     { *       XFreeCursor(display,window->cursor);/       XFreeCursor(display,window->busy_cursor); 5       if (window->highlight_stipple != (Pixmap) NULL) 7         XFreePixmap(display,window->highlight_stipple); 2       if (window->shadow_stipple != (Pixmap) NULL)4         XFreePixmap(display,window->shadow_stipple);     }    else     {        window->id=(Window) NULL; @       window->x=XDisplayWidth(display,visual_info->screen) >> 1;@       window->y=XDisplayWidth(display,visual_info->screen) >> 1;       window->x_origin=0;        window->y_origin=0; %       window->ximage=(XImage *) NULL; *       window->matte_image=(XImage *) NULL;#       window->pixmap=(Pixmap) NULL; )       window->matte_pixmap=(Pixmap) NULL;        window->mapped=False;        window->stasis=False; "       window->shared_memory=False; #ifdef HasSharedMemory"       window->shared_memory=False;+       if (resource_info->use_shared_memory) :         window->shared_memory=XShmQueryExtension(display);)       window->segment_info[0].shmid=(-1); )       window->segment_info[1].shmid=(-1); )       window->segment_info[2].shmid=(-1); )       window->segment_info[3].shmid=(-1);  #endif     } %   window->screen=visual_info->screen; 8   window->root=XRootWindow(display,visual_info->screen);%   window->visual=visual_info->visual; #   window->class=visual_info->class; #   window->depth=visual_info->depth; "   window->visual_info=visual_info;   window->map_info=map_info;    window->pixel_info=pixel_info;   window->font_info=font_info;8   window->cursor=XCreateFontCursor(display,XC_left_ptr);:   window->busy_cursor=XCreateFontCursor(display,XC_watch);   window->name=(char *) NULL; !   window->geometry=(char *) NULL; "   window->icon_name=(char *) NULL;5   window->icon_geometry=resource_info->icon_geometry; &   window->crop_geometry=(char *) NULL;   window->flags=PSize;   window->width=1;   window->height=1;    window->min_width=1;   window->min_height=1;    window->width_inc=1;   window->height_inc=1; 3   window->border_width=resource_info->border_width; 8   window->annotate_context=pixel_info->annotate_context;:   window->highlight_context=pixel_info->highlight_context;4   window->widget_context=pixel_info->widget_context;'   window->shadow_stipple=(Pixmap) NULL; *   window->highlight_stipple=(Pixmap) NULL;   window->immutable=False;K   window->mask=CWBackingStore | CWBackPixel | CWBackPixmap | CWBitGravity | K     CWBorderPixel | CWColormap | CWCursor | CWDontPropagate | CWEventMask | 4     CWOverrideRedirect | CWSaveUnder | CWWinGravity;I   window->attributes.background_pixel=pixel_info->background_color.pixel; 5   window->attributes.background_pixmap=(Pixmap) NULL; -   window->attributes.backing_store=NotUseful; /   window->attributes.bit_gravity=ForgetGravity; A   window->attributes.border_pixel=pixel_info->border_color.pixel; 1   window->attributes.colormap=map_info->colormap; +   window->attributes.cursor=window->cursor; 7   window->attributes.do_not_propagate_mask=NoEventMask; ,   window->attributes.event_mask=NoEventMask;-   window->attributes.override_redirect=False; &   window->attributes.save_under=False;2   window->attributes.win_gravity=NorthWestGravity;   window->orphan=False;  }* % /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X H i g h l i g h t L i n e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XHighlightLine puts a border on the X server around a region %  defined by highlight_info.  % / %  The format of the XHighlightLine routine is:  % C %    XHighlightLine(display,window,annotate_context,highlight_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.s % ? %    o annotate_context: Specifies a pointer to a GC structure.  %oL %    o highlight_info: Specifies a pointer to a RectangleInfo structure.  It: %      contains the extents of any highlighting rectangle. %  %  */C void XHighlightLine(display,window,annotate_context,highlight_info)  Display    *display;    Window	   window;    GC   annotate_context;    XSegment   *highlight_info; {m?   XDrawLine(display,window,annotate_context,highlight_info->x1, >     highlight_info->y1,highlight_info->x2,highlight_info->y2); }i o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %tO %                                                                             %pO %                                                                             %oO %   X H i g h l i g h t R e g i o n                                           %nO %                                                                             % O %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %eJ %  Function XHighlightRegion puts a border on the X server around a region %  defined by highlight_info.  % 1 %  The format of the XHighlightRegion routine is:  %oE %    XHighlightRegion(display,window,annotate_context,highlight_info)f %r+ %  A description of each parameter follows:n %iD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.s % ? %    o annotate_context: Specifies a pointer to a GC structure.e %aL %    o highlight_info: Specifies a pointer to a RectangleInfo structure.  It: %      contains the extents of any highlighting rectangle. %t %h */E void XHighlightRegion(display,window,annotate_context,highlight_info)  Display    *display;    Window	   window;    GC   annotate_context;%  
 RectangleInfo%   *highlight_info; {%B   if ((highlight_info->width < 4) || (highlight_info->height < 4))     return;aC   XDrawRectangle(display,window,annotate_context,highlight_info->x,sH     highlight_info->y,highlight_info->width-1,highlight_info->height-1);E   XDrawRectangle(display,window,annotate_context,highlight_info->x+1,nJ     highlight_info->y+1,highlight_info->width-3,highlight_info->height-3); }  e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             %nO %                                                                             %eO %                                                                             %tO %   X M a k e C u r s o r                                                     %%O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 8 %  Function XMakeCursor creates a crosshairs X11 cursor. % , %  The format of the XMakeCursor routine is: % M %      XMakeCursor(display,window,colormap,background_color,foreground_color)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %%E %    o window: Specifies the ID of the window for which the cursor is  %      assigned. %fK %    o colormap: Specifies the ID of the colormap from which the background . %      and foreground color will be retrieved. % N %    o background_color: Specifies the color to use for the cursor background. %aN %    o foreground_color: Specifies the color to use for the cursor foreground. %o %c */M Cursor XMakeCursor(display,window,colormap,background_color,foreground_color)  Displayl   *display;*   Window	   window;F   Colormap   colormap;r   char   *background_color,   *foreground_color; {i #define scope_height 17= #define scope_x_hot 8  #define scope_y_hot 8o #define scope_width 17     static unsigned char     scope_bits[] =     {)G       0x80, 0x03, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02,%G       0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x7f, G       0xfc, 0x01, 0x01, 0x00, 0x01, 0x7f, 0xfc, 0x01, 0x80, 0x02, 0x00, G       0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, .       0x00, 0x80, 0x02, 0x00, 0x80, 0x03, 0x00     };     static unsigned char     scope_mask_bits[] =      { G       0xc0, 0x07, 0x00, 0xc0, 0x07, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, G       0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xff, 0xfe, 0x01, 0x7f, G       0xfc, 0x01, 0x03, 0x80, 0x01, 0x7f, 0xfc, 0x01, 0xff, 0xfe, 0x01, G       0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, .       0x00, 0xc0, 0x07, 0x00, 0xc0, 0x07, 0x00     };     Cursor     cursor;      Pixmap	     mask,o     source;s     XColor     background,s     foreground;r  N   source=XCreateBitmapFromData(display,window,(char *) scope_bits,scope_width,     scope_height);E   mask=XCreateBitmapFromData(display,window,(char *) scope_mask_bits,t     scope_width,scope_height);;   if ((source == (Pixmap) NULL) || (mask == (Pixmap) NULL))a3     Error("Unable to create pixmap",(char *) NULL);C=   XParseColor(display,colormap,background_color,&background);l=   XParseColor(display,colormap,foreground_color,&foreground); I   cursor=XCreatePixmapCursor(display,source,mask,&foreground,&background,t     scope_x_hot,scope_y_hot);a   XFreePixmap(display,source);   XFreePixmap(display,mask);   return(cursor);  }r   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %_O %   X M a k e I m a g e                                                       % O %                                                                             % O %                                                                             %-O %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XMakeImage creates an X11 image.  If the image size differs from2 %  the X11 image size, the image is first resized. % + %  The format of the XMakeImage routine is:) %iI %      status=XMakeImage(display,resource_info,window,image,width,height)) % + %  A description of each parameter follows:% %%A %    o status: Function XMakeImage returns True if the X image is N %      successfully created.  False is returned is there is a memory shortage. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % > %    o window: Specifies a pointer to a XWindowInfo structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % F %    o width: Specifies the width in pixels of the rectangular area to %      display.  % H %    o height: Specifies the height in pixels of the rectangular area to %      display.% %% %% */H unsigned int XMakeImage(display,resource_info,window,image,width,height) Display    *display;n  
 XResourceInfou   *resource_info;a   XWindowInfo 
   *window;   Imagec	   *image;t   unsigned int   width,	   height;S {8   Image      *transformed_image;t     intr     format;      Pixmap     matte_pixmap;      XImage     *matte_image,m     *ximage;  4   if ((window->width == 0) || (window->height == 0))     return(False);   /*     Display busy cursor.   */8   XDefineCursor(display,window->id,window->busy_cursor);   XFlush(display);   transformed_image=image;   if (image != (Image *) NULL)     {        /*+         Apply user transforms to the image.K       */        if (window->crop_geometry)	         {X           Imagee             *cropped_image;c             RectangleInfot             crop_info;             /*             Crop image.+           */C           (void) XParseGeometry(window->crop_geometry,&crop_info.x,%=             &crop_info.y,&crop_info.width,&crop_info.height); )           transformed_image->orphan=True; @           cropped_image=CropImage(transformed_image,&crop_info);*           transformed_image->orphan=False;.           if (cropped_image != (Image *) NULL)
             { -               if (transformed_image != image) 0                 DestroyImage(transformed_image);.               transformed_image=cropped_image;
             } 	         } 2       if ((width != transformed_image->columns) ||.           (height != transformed_image->rows))	         {            Image              *scaled_image;             /*             Scale image.           */)           transformed_image->orphan=True;nJ           if (window->pixel_info->colors != 0 || transformed_image->matte)
             {                /*"                 Perserve colormap.               */G               scaled_image=SampleImage(transformed_image,width,height); 1               if (scaled_image != (Image *) NULL)f                 { 1                   if (transformed_image != image)r4                     DestroyImage(transformed_image);1                   transformed_image=scaled_image;                  } 
             }.           else
             {i               unsigned int                 sharpen;  >               sharpen=(transformed_image->columns != width) &&4                 (transformed_image->rows != height);D               while ((transformed_image->columns >= (width << 1)) &&@                      (transformed_image->rows >= (height << 1)))               {m                 Image !                   *reduced_image;g                   /*?                   Reduce image with a antialias digital filter.n                 */=                 reduced_image=ReduceImage(transformed_image);u4                 if (reduced_image == (Image *) NULL)                   break;/                 if (transformed_image != image)_2                   DestroyImage(transformed_image);0                 transformed_image=reduced_image;               }kD               while ((transformed_image->columns <= (width >> 1)) &&@                      (transformed_image->rows <= (height >> 1)))               {u                 Imagea                    *zoomed_image;                   /*9                   Zoom image with bilinear interpolation.;                 */:                 zoomed_image=ZoomImage(transformed_image);3                 if (zoomed_image == (Image *) NULL)i                   break;/                 if (transformed_image != image)o2                   DestroyImage(transformed_image);/                 transformed_image=zoomed_image;(               } :               if ((transformed_image->columns != width) ||6                   (transformed_image->rows != height))                 {g                   /*7                     Scale image with pixel replication.e                   */J                   scaled_image=ScaleImage(transformed_image,width,height);5                   if (scaled_image != (Image *) NULL)                      {x5                       if (transformed_image != image)a8                         DestroyImage(transformed_image);5                       transformed_image=scaled_image;e                     }a                 };               if (sharpen)                 {/                   Imagem%                     *sharpened_image;e                     /*"                     Sharpen image.                   */P                   sharpened_image=SharpenImage(transformed_image,SharpenFactor);8                   if (sharpened_image != (Image *) NULL)                     {e5                       if (transformed_image != image)*8                         DestroyImage(transformed_image);8                       transformed_image=sharpened_image;                     }i                 }a
             }n*           transformed_image->orphan=False;	         }l'       width=transformed_image->columns; %       height=transformed_image->rows;;     }(   /*     Create X image.R   */3   format=(window->depth == 1) ? XYBitmap : ZPixmap;t #ifdef HasSharedMemory   if (window->shared_memory)     {aK       ximage=XShmCreateImage(display,window->visual,window->depth,format,0,e/         &window->segment_info[2],width,height);mN       window->segment_info[2].shmid=shmget(IPC_PRIVATE,ximage->bytes_per_line*)         ximage->height,IPC_CREAT | 0777);a?       window->shared_memory=window->segment_info[2].shmid >= 0;o        if (window->shared_memory)0         window->segment_info[2].shmaddr=(char *)3           shmat(window->segment_info[2].shmid,0,0);x     }n #endif   if (!window->shared_memory))F     ximage=XCreateImage(display,window->visual,window->depth,format,0,8       (char *) NULL,width,height,XBitmapPad(display),0);    if (ximage == (XImage *) NULL)     {        /*!         Unable to create X image.        */7       XDefineCursor(display,window->id,window->cursor);        return(False);     }    if (resource_info->debug)      {s)       (void) fprintf(stderr,"XImage:\n"); E       (void) fprintf(stderr,"  width, height: %dx%d\n",ximage->width,g         ximage->height);=       (void) fprintf(stderr,"  format: %d\n",ximage->format);fE       (void) fprintf(stderr,"  byte order: %d\n",ximage->byte_order); H       (void) fprintf(stderr,"  bitmap unit, bit order, pad: %d %d %d\n",I         ximage->bitmap_unit,ximage->bitmap_bit_order,ximage->bitmap_pad);i;       (void) fprintf(stderr,"  depth: %d\n",ximage->depth);eM       (void) fprintf(stderr,"  bytes per line: %d\n",ximage->bytes_per_line); M       (void) fprintf(stderr,"  bits per pixel: %d\n",ximage->bits_per_pixel); L       (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",?         ximage->red_mask,ximage->green_mask,ximage->blue_mask);f     }a   /*      Allocate X image pixel data.   */ #ifdef HasSharedMemory   if (window->shared_memory)     {t       xerror_alert=False; -       window->segment_info[2].readOnly=False;a3       XShmAttach(display,&window->segment_info[2]);a       XSync(display,False);e7       shmctl(window->segment_info[2].shmid,IPC_RMID,0);_3       ximage->data=window->segment_info[2].shmaddr;        if (xerror_alert)m	         { &           window->shared_memory=False;           xerror_alert=False;i	         }e     }  #endif   if (!window->shared_memory)d#     if (ximage->format == XYBitmap)        ximage->data=(char *)4D         malloc(ximage->bytes_per_line*ximage->height*ximage->depth);     elseJ       ximage->data=(char *) malloc(ximage->bytes_per_line*ximage->height);$   if (ximage->data == (char *) NULL)     {        /*&         Unable to allocate pixel data.       */       XDestroyImage(ximage);7       XDefineCursor(display,window->id,window->cursor);_       return(False);     } (   if (window->ximage != (XImage *) NULL)     {a #ifdef HasSharedMemory        if (window->shared_memory)	         { 7           XShmDetach(display,&window->segment_info[0]);t(           XDestroyImage(window->ximage);1           shmdt(window->segment_info[0].shmaddr); 	         }  #endif!       if (!window->shared_memory) &         XDestroyImage(window->ximage);     }- #ifdef HasSharedMemory2   window->segment_info[0]=window->segment_info[2]; #endif   window->ximage=ximage;   matte_image=(XImage *) NULL;*   if (transformed_image != (Image *) NULL)!     if (transformed_image->matte);       { 
         /*           Create matte image. 
         */E         matte_image=XCreateImage(display,window->visual,1,XYBitmap,0,e<           (char *) NULL,width,height,XBitmapPad(display),0);!         if (resource_info->debug)e           { 4             (void) fprintf(stderr,"Matte Image:\n");P             (void) fprintf(stderr,"  width, height: %dx%d\n",matte_image->width,#               matte_image->height);            } +         if (matte_image != (XImage *) NULL)            {              /*.               Allocate matte image pixel data.             */J             matte_image->data=(char *) malloc(matte_image->bytes_per_line*6               matte_image->height*matte_image->depth);3             if (matte_image->data == (char *) NULL)                { +                 XDestroyImage(matte_image); ,                 matte_image=(XImage *) NULL;               }            }        } -   if (window->matte_image != (XImage *) NULL)%'     XDestroyImage(window->matte_image); "   window->matte_image=matte_image;   window->stasis=False;e   if (image == (Image *) NULL)     {o7       XDefineCursor(display,window->id,window->cursor);l       return(True);e     }x   /*5     Convert runlength-encoded pixels to X image data.X   */)   if ((ximage->byte_order == LSBFirst) ||iO       ((ximage->format == XYBitmap) && (ximage->bitmap_bit_order == LSBFirst))) E     XMakeImageLSBFirst(resource_info,window,transformed_image,ximage,.       matte_image);    elseE     XMakeImageMSBFirst(resource_info,window,transformed_image,ximage,        matte_image);o$   matte_pixmap=window->matte_pixmap;,   if (window->matte_pixmap != (Pixmap) NULL).     XFreePixmap(display,window->matte_pixmap);%   window->matte_pixmap=(Pixmap) NULL;t-   if (window->matte_image != (XImage *) NULL)      {y       /*         Create matte pixmap.       */L       window->matte_pixmap=XCreatePixmap(display,window->id,width,height,1);0       if (window->matte_pixmap != (Pixmap) NULL)	         {i           GC             graphics_context;-             XGCValues              context_values;d             /*-             Copy matte image to matte pixmap.F           */&           context_values.background=1;&           context_values.foreground=0;P           graphics_context=XCreateGC(display,window->matte_pixmap,GCBackground |*             GCForeground,&context_values);B           XPutImage(display,window->matte_pixmap,graphics_context,6             window->matte_image,0,0,0,0,width,height);,           XFreeGC(display,graphics_context);	         }o     }f #ifdef HasShape +   if (window->matte_pixmap != matte_pixmap) ;     XShapeCombineMask(display,window->id,ShapeBounding,0,0, %       window->matte_pixmap,ShapeSet);L #endif!   if (transformed_image != image)($     DestroyImage(transformed_image);   /*     Restore cursor.a   */3   XDefineCursor(display,window->id,window->cursor);t   return(True);n }s u /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%UO %                                                                             %fO %                                                                             % O %                                                                             % O %   X M a k e I m a g e L S B F i r s t                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XMakeImageLSBFirst initializes the pixel data of an X11 Image.H %  The X image pixels are copied in least-significant bit and byte firstL %  order.  The server's scanline pad is respected.  Rather than using one orL %  two general cases, many special cases are found here to help speed up the %  image conversion. % 3 %  The format of the XMakeImageLSBFirst routine is:e %IH %      XMakeImageLSBFirst(resource_info,window,image,ximage,matte_image) % + %  A description of each parameter follows:i %rK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.i %o> %    o window: Specifies a pointer to a XWindowInfo structure. %iF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.n % H %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. %nM %    o matte_image: Specifies a pointer to a XImage structure;  returned froma %      XCreateImage. %S */M static void XMakeImageLSBFirst(resource_info,window,image,ximage,matte_image) 
 XResourceInfo    *resource_info;    XWindowInfoi
   *window;   Image_	   *image;    XImage
   *ximage,   *matte_image;z {    register int     i,     j,     x;     register RunlengthPacket     *p;      register unsigned char     bit,	     byte,d     *q;=     register unsigned long
     pixel;     unsigned int     scanline_pad;      unsigned long      *pixels;     XStandardColormapi     *map_info;  &   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   map_info=window->map_info;$   pixels=window->pixel_info->pixels;   p=image->pixels;#   q=(unsigned char *) ximage->data;    x=0;!   if (ximage->format == XYBitmap)i     {        register unsigned shortz         polarity;          unsigned char=         background,          foreground;          /*+         Convert image to big-endian bitmap.i       */C       background=(Intensity(window->pixel_info->foreground_color) < G         Intensity(window->pixel_info->background_color) ? 0x80 : 0x00); C       foreground=(Intensity(window->pixel_info->background_color) < G         Intensity(window->pixel_info->foreground_color) ? 0x80 : 0x00);oM       polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);w       bit=0;
       byte=0;X(       for (i=0; i < image->packets; i++)       {e.         for (j=0; j <= ((int) p->length); j++)	         {a           byte>>=1; #           if (p->index == polarity)i             byte|=foreground;c           else             byte|=background;i           bit++;           if (bit == 8)>
             {g               *q++=byte;               bit=0;               byte=0;z
             }            x++;!           if (x == ximage->width)f
             {                /*-                 Advance to the next scanline.h               */               if (bit != 0)<#                 *q=byte >> (8-bit);f               q+=scanline_pad;               bit=0;               byte=0;i               x=0;
             } 	         }i         p++;       }d     }t   else(     if (window->pixel_info->colors != 0)%       switch (ximage->bits_per_pixel)%       {%         case 2:%	         {%           register unsigned int              nibble;              /*2             Convert to 2 bit color-mapped X image.           */           nibble=0; ,           for (i=0; i < image->packets; i++)           { )             pixel=pixels[p->index] & 0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {                switch (nibble)                {                  case 0:                  { +                   *q=(unsigned char) pixel;                    nibble++;                    break;                 }                  case 1:                  {%3                   *q|=(unsigned char) (pixel << 2);%                   nibble++;t                   break;                 }o                 case 2:                  { 3                   *q|=(unsigned char) (pixel << 4);t                   nibble++;                    break;                 }                  case 3:e                 {o3                   *q|=(unsigned char) (pixel << 6);n                   q++;                   nibble=0;P                   break;                 }e               }c               x++;%               if (x == ximage->width)s                 {o                   x=0;                   nibble=0;i"                   q+=scanline_pad;                 }:
             }r             p++;           }            break;	         }e         case 4:C	         {u           register unsigned into             nibble;c             /*2             Convert to 4 bit color-mapped X image.           */           nibble=0;,,           for (i=0; i < image->packets; i++)           { )             pixel=pixels[p->index] & 0xf;l2             for (j=0; j <= ((int) p->length); j++)
             {                switch (nibble)                {                  case 0:d                 {_+                   *q=(unsigned char) pixel;n                   nibble++;                    break;                 }r                 case 1:u                 { 3                   *q|=(unsigned char) (pixel << 4);                    q++;                   nibble=0;                    break;                 }                }                x++;%               if (x == ximage->width)l                 {_                   x=0;                   nibble=0; "                   q+=scanline_pad;                 }a
             }c             p++;           }0           break;	         }          case 6:i         case 8:g	         {            /*2             Convert to 8 bit color-mapped X image.           */E           if (resource_info->color_recovery && resource_info->dither))
             {-)               XDitherImage(image,ximage);c               break;
             }(,           for (i=0; i < image->packets; i++)           {o#             pixel=pixels[p->index];)2             for (j=0; j <= ((int) p->length); j++)
             {n)               *q++=(unsigned char) pixel;r               x++;%               if (x == ximage->width)                  {a                   x=0;"                   q+=scanline_pad;                 }a
             }i             p++;           }            break;	         }c         default:	         {r           register int             k;             register unsigned intl             bytes_per_pixel;             unsigned char*+             channel[sizeof(unsigned long)];%             /*7             Convert to multi-byte color-mapped X image.            */6           bytes_per_pixel=ximage->bits_per_pixel >> 3;,           for (i=0; i < image->packets; i++)           { #             pixel=pixels[p->index]; /             for (k=0; k < bytes_per_pixel; k++) 
             { /               channel[k]=(unsigned char) pixel;                pixel>>=8;
             } 2             for (j=0; j <= ((int) p->length); j++)
             { 1               for (k=0; k < bytes_per_pixel; k++)                   *q++=channel[k];               x++;%               if (x == ximage->width)                  {                    x=0;"                   q+=scanline_pad;                 } 
             }o             p++;           }l           break;	         }t       }t     else%       switch (ximage->bits_per_pixel)        {          case 2:t	         {i           register unsigned intu             nibble;2             /*@             Convert to contiguous 2 bit continuous-tone X image.           */           nibble=0; ,           for (i=0; i < image->packets; i++)           { 0             pixel=XStandardPixel(map_info,*p,8);             pixel&=0xf;s2             for (j=0; j <= ((int) p->length); j++)
             {.               switch (nibble)i               {                  case 0:o                 {h+                   *q=(unsigned char) pixel;t                   nibble++;:                   break;                 }l                 case 1:)                 {i3                   *q|=(unsigned char) (pixel << 2);o                   nibble++;o                   break;                 }                  case 2:c                 {t3                   *q|=(unsigned char) (pixel << 4);                    nibble++;y                   break;                 }d                 case 3:h                 {.3                   *q|=(unsigned char) (pixel << 6);X                   q++;                   nibble=0;                    break;                 }f               }d               x++;%               if (x == ximage->width)f                 {o                   x=0;                   nibble=0;s"                   q+=scanline_pad;                 }=
             }              p++;           }l           break;	         }d         case 4:f	         {s           register unsigned int              nibble;a             /*@             Convert to contiguous 4 bit continuous-tone X image.           */           nibble=0; ,           for (i=0; i < image->packets; i++)           {a0             pixel=XStandardPixel(map_info,*p,8);             pixel&=0xf;s2             for (j=0; j <= ((int) p->length); j++)
             {y               switch (nibble)f               {                  case 0:n                 {m+                   *q=(unsigned char) pixel;(                   nibble++;                    break;                 }e                 case 1:d                 { 3                   *q|=(unsigned char) (pixel << 4);                    q++;                   nibble=0;                    break;                 }                }l               x++;%               if (x == ximage->width))                 {                    x=0;                   nibble=0;i"                   q+=scanline_pad;                 }l
             }f             p++;           }i           break;	         }          case 6:          case 8:a	         {            /*@             Convert to contiguous 8 bit continuous-tone X image.           */E           if (resource_info->color_recovery && resource_info->dither) 
             { )               XDitherImage(image,ximage);                break;
             };,           for (i=0; i < image->packets; i++)           {i0             pixel=XStandardPixel(map_info,*p,8);2             for (j=0; j <= ((int) p->length); j++)
             { )               *q++=(unsigned char) pixel;;               x++;%               if (x == ximage->width)f                 {r                   x=0;"                   q+=scanline_pad;                 }m
             }s             p++;           }u           break;	         };         default:	         { /           if ((ximage->bits_per_pixel == 32) &&r+               (map_info->red_max == 255) && -               (map_info->green_max == 255) &&s,               (map_info->blue_max == 255) &&.               (map_info->red_mult == 65536) &&.               (map_info->green_mult == 256) &&)               (map_info->blue_mult == 1)) 
             {l               /*:                 Convert to 32 bit continuous-tone X image.               */0               for (i=0; i < image->packets; i++)               {m6                 for (j=0; j <= ((int) p->length); j++)                 {L                   *q++=p->blue;                     *q++=p->green;                   *q++=p->red;                   *q++=0;e                 }                  p++;               }a
             }            else1             if ((ximage->bits_per_pixel == 32) &&a-                 (map_info->red_max == 255) && /                 (map_info->green_max == 255) &&f.                 (map_info->blue_max == 255) &&,                 (map_info->red_mult == 1) &&0                 (map_info->green_mult == 256) &&/                 (map_info->blue_mult == 65536))"               {                  /*<                   Convert to 32 bit continuous-tone X image.                 */2                 for (i=0; i < image->packets; i++)                 {t8                   for (j=0; j <= ((int) p->length); j++)                   {l                      *q++=p->red;"                     *q++=p->green;!                     *q++=p->blue;s                     *q++=0;l                   }                    p++;                 }                }c             else               {                  register int                   k;  %                 register unsigned int,"                   bytes_per_pixel;                   unsigned chart1                   channel[sizeof(unsigned long)];l                   /*@                   Convert to multi-byte continuous-tone X image.                 */<                 bytes_per_pixel=ximage->bits_per_pixel >> 3;2                 for (i=0; i < image->packets; i++)                 { 6                   pixel=XStandardPixel(map_info,*p,8);5                   for (k=0; k < bytes_per_pixel; k++)s                   { 5                     channel[k]=(unsigned char) pixel;n                     pixel>>=8;                   } 8                   for (j=0; j <= ((int) p->length); j++)                   {o7                     for (k=0; k < bytes_per_pixel; k++)a&                       *q++=channel[k];                     x++;+                     if (x == ximage->width)                        {                          x=0;(                         q+=scanline_pad;                       }_                   }                    p++;                 }_               }            break;	         }        }G%   if (matte_image != (XImage *) NULL)"     {        /*         Initialize matte image.o       *//       scanline_pad=matte_image->bytes_per_line- @         ((matte_image->width*matte_image->bits_per_pixel) >> 3);       p=image->pixels;,       q=(unsigned char *) matte_image->data;       bit=0;
       byte=0;L(       for (i=0; i < image->packets; i++)       {e.         for (j=0; j <= ((int) p->length); j++)	         {            byte>>=1;p&           if (p->index == Transparent)             byte|=0x01;            bit++;           if (bit == 8)v
             {/               *q++=byte;               bit=0;               byte=0; 
             }            x++;&           if (x == matte_image->width)
             {d               /*-                 Advance to the next scanline.m               */               if (bit != 0) #                 *q=byte >> (8-bit);r               q+=scanline_pad;               bit=0;               byte=0;                x=0;
             }+	         }          p++;       }l     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pO %                                                                             %sO %                                                                             % O %                                                                             %oO %   X M a k e I m a g e M S B F i r s t                                       %mO %                                                                             %tO %                                                                             %sO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %,J %  Function XMakeImageMSBFirst initializes the pixel data of an X11 Image.N %  The X image pixels are copied in most-significant bit and byte first order.M %  The server's scanline pad is also resprected. Rather than using one or twoiN %  general cases, many special cases are found here to help speed up the image %  conversion. %o3 %  The format of the XMakeImageMSBFirst routine is:  % H %      XMakeImageMSBFirst(resource_info,window,image,ximage,matte_image) %f+ %  A description of each parameter follows:i %lK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.. %u> %    o window: Specifies a pointer to a XWindowInfo structure. %iF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %uH %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. %_M %    o matte_image: Specifies a pointer to a XImage structure;  returned fromf %      XCreateImage. %s %_ */M static void XMakeImageMSBFirst(resource_info,window,image,ximage,matte_image)%
 XResourceInfo    *resource_info;    XWindowInfo 
   *window;   Image 	   *image;    XImage
   *ximage,   *matte_image;  {    register int     i,     j,     x;     register RunlengthPacket     *p;      register unsigned char     bit,	     byte,      *q;      register unsigned long
     pixel;     unsigned int     scanline_pad;      unsigned long      *pixels;     XStandardColormap      *map_info;  &   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   map_info=window->map_info;$   pixels=window->pixel_info->pixels;   p=image->pixels;#   q=(unsigned char *) ximage->data;%   x=0;!   if (ximage->format == XYBitmap)t     {e       register unsigned shorte         polarity;v         unsigned chara         background,t         foreground;t         /*+         Convert image to big-endian bitmap.h       */C       background=(Intensity(window->pixel_info->foreground_color) <AG         Intensity(window->pixel_info->background_color) ? 0x01 : 0x00); C       foreground=(Intensity(window->pixel_info->background_color) < G         Intensity(window->pixel_info->foreground_color) ? 0x01 : 0x00); M       polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);        bit=0;
       byte=0; (       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {&           byte<<=1;X#           if (p->index == polarity)*             byte|=foreground;c           else             byte|=background;o           bit++;           if (bit == 8)i
             {v               *q++=byte;               bit=0;               byte=0;w
             }i           x++;!           if (x == ximage->width)m
             {a               /*-                 Advance to the next scanline.n               */               if (bit != 0) #                 *q=byte << (8-bit);a               q+=scanline_pad;               bit=0;               byte=0;%               x=0;
             } 	         }          p++;       }      }    else(     if (window->pixel_info->colors != 0)%       switch (ximage->bits_per_pixel)        {          case 2: 	         {            register unsigned int              nibble;              /*2             Convert to 2 bit color-mapped X image.           */           nibble=0; ,           for (i=0; i < image->packets; i++)           { )             pixel=pixels[p->index] & 0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {                switch (nibble)                {                  case 0:%                 {%2                   *q=(unsigned char) (pixel << 6);                   nibble++;n                   break;                 }e                 case 1:e                 { 3                   *q|=(unsigned char) (pixel << 4);l                   nibble++;                    break;                 },                 case 2:                  {a3                   *q|=(unsigned char) (pixel << 2);                    nibble++;c                   break;                 }                  case 3:s                 {d,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;o                   break;                 }                }p               x++;%               if (x == ximage->width)s                 {p                   x=0;                   nibble=0; "                   q+=scanline_pad;                 } 
             }m             p++;           }            break;	         }t         case 4:t	         {            register unsigned intl             nibble;p             /*2             Convert to 4 bit color-mapped X image.           */           nibble=0;t,           for (i=0; i < image->packets; i++)           { )             pixel=pixels[p->index] & 0xf;%2             for (j=0; j <= ((int) p->length); j++)
             {                switch (nibble)                {                  case 0:                  { 2                   *q=(unsigned char) (pixel << 4);                   nibble++;                    break;                 }                  case 1:                  { ,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;                    break;                 }                }                x++;%               if (x == ximage->width)                  {                    x=0;                   nibble=0; "                   q+=scanline_pad;                 }%
             }%             p++;           }            break;	         }          case 6:p         case 8: 	         {s           /*2             Convert to 8 bit color-mapped X image.           */E           if (resource_info->color_recovery && resource_info->dither)d
             { )               XDitherImage(image,ximage);s               break;
             }p,           for (i=0; i < image->packets; i++)           { #             pixel=pixels[p->index]; 2             for (j=0; j <= ((int) p->length); j++)
             {o)               *q++=(unsigned char) pixel;w               x++;%               if (x == ximage->width)t                 {e                   x=0;"                   q+=scanline_pad;                 } 
             }a             p++;           }/           break;	         }y         default:	         {            register int             k;             register unsigned int              bytes_per_pixel;             unsigned char +             channel[sizeof(unsigned long)];              /*2             Convert to 8 bit color-mapped X image.           */6           bytes_per_pixel=ximage->bits_per_pixel >> 3;,           for (i=0; i < image->packets; i++)           {o#             pixel=pixels[p->index];,2             for (k=bytes_per_pixel-1; k >= 0; k--)
             {s/               channel[k]=(unsigned char) pixel;y               pixel>>=8;
             }i2             for (j=0; j <= ((int) p->length); j++)
             {t1               for (k=0; k < bytes_per_pixel; k++)e                  *q++=channel[k];               x++;%               if (x == ximage->width)%                 {%                   x=0;"                   q+=scanline_pad;                 } 
             }              p++;           }            break;	         }        }      else%       switch (ximage->bits_per_pixel)        {          case 2: 	         {            register unsigned int              nibble;              /*5             Convert to 4 bit continuous-tone X image.            */           nibble=0; ,           for (i=0; i < image->packets; i++)           { 0             pixel=XStandardPixel(map_info,*p,8);             pixel&=0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {%               switch (nibble)%               {%                 case 0:C                 {i2                   *q=(unsigned char) (pixel << 6);                   nibble++;o                   break;                 }                  case 1:h                 { 3                   *q|=(unsigned char) (pixel << 4);l                   nibble++;                    break;                 }                  case 2:X                 {e3                   *q|=(unsigned char) (pixel << 2);,                   nibble++;s                   break;                 }                  case 3:;                 {y,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;-                   break;                 }t               }i               x++;%               if (x == ximage->width)>                 {-                   x=0;                   nibble=0;-"                   q+=scanline_pad;                 } 
             }l             p++;           }%           break;	         }%         case 4:%	         {%           register unsigned int              nibble;              /*5             Convert to 4 bit continuous-tone X image.            */           nibble=0; ,           for (i=0; i < image->packets; i++)           { 0             pixel=XStandardPixel(map_info,*p,8);             pixel&=0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {                switch (nibble)                {                  case 0:                  { 2                   *q=(unsigned char) (pixel << 4);                   nibble++;                    break;                 }%                 case 1:%                 {%,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;l                   break;                 }f               }e               x++;%               if (x == ximage->width)s                 {r                   x=0;                   nibble=0;n"                   q+=scanline_pad;                 }p
             }              p++;           }t           break;	         }d         case 6:          case 8: 	         {o           /*5             Convert to 8 bit continuous-tone X image.l           */E           if (resource_info->color_recovery && resource_info->dither) 
             {e)               XDitherImage(image,ximage);o               break;
             }l,           for (i=0; i < image->packets; i++)           { 0             pixel=XStandardPixel(map_info,*p,8);2             for (j=0; j <= ((int) p->length); j++)
             { )               *q++=(unsigned char) pixel;E               x++;%               if (x == ximage->width)                  {                    x=0;"                   q+=scanline_pad;                 }d
             }              p++;           }%           break;	         }%         default:	         { /           if ((ximage->bits_per_pixel == 32) && +               (map_info->red_max == 255) && -               (map_info->green_max == 255) && ,               (map_info->blue_max == 255) &&.               (map_info->red_mult == 65536) &&.               (map_info->green_mult == 256) &&)               (map_info->blue_mult == 1)) 
             {                /*:                 Convert to 32 bit continuous-tone X image.               */0               for (i=0; i < image->packets; i++)               { 6                 for (j=0; j <= ((int) p->length); j++)                 {%                   *q++=0;%                   *q++=p->red;                    *q++=p->green;                   *q++=p->blue;i                 }a                 p++;               }a
             }t           else1             if ((ximage->bits_per_pixel == 32) && -                 (map_info->red_max == 255) && /                 (map_info->green_max == 255) && .                 (map_info->blue_max == 255) &&,                 (map_info->red_mult == 1) &&0                 (map_info->green_mult == 256) &&/                 (map_info->blue_mult == 65536))r               {                  /*<                   Convert to 32 bit continuous-tone X image.                 */2                 for (i=0; i < image->packets; i++)                 {n8                   for (j=0; j <= ((int) p->length); j++)                   {e                     *q++=0; !                     *q++=p->blue;y"                     *q++=p->green;                      *q++=p->red;                   }c                   p++;                 }e               }              else               {i                 register int                   k;  %                 register unsigned int "                   bytes_per_pixel;                   unsigned char(1                   channel[sizeof(unsigned long)];                    /*@                   Convert to multi-byte continuous-tone X image.                 */<                 bytes_per_pixel=ximage->bits_per_pixel >> 3;2                 for (i=0; i < image->packets; i++)                 {%6                   pixel=XStandardPixel(map_info,*p,8);8                   for (k=bytes_per_pixel-1; k >= 0; k--)                   { 5                     channel[k]=(unsigned char) pixel;                      pixel>>=8;                   } 8                   for (j=0; j <= ((int) p->length); j++)                   { 7                     for (k=0; k < bytes_per_pixel; k++) &                       *q++=channel[k];                     x++;+                     if (x == ximage->width)                        {                          x=0;(                         q+=scanline_pad;                       }%                   }%                   p++;                 }F               }m           break;	         }a       } %   if (matte_image != (XImage *) NULL)a     {n       /*         Initialize matte image.o       *//       scanline_pad=matte_image->bytes_per_line-n@         ((matte_image->width*matte_image->bits_per_pixel) >> 3);       p=image->pixels;,       q=(unsigned char *) matte_image->data;       bit=0;
       byte=0; (       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            byte<<=1;f&           if (p->index == Transparent)             byte|=0x01;a           bit++;           if (bit == 8)s
             {n               *q++=byte;               bit=0;               byte=0;c
             }n           x++;&           if (x == matte_image->width)
             {*               /*-                 Advance to the next scanline.                */               if (bit != 0);#                 *q=byte << (8-bit);u               q+=scanline_pad;               bit=0;               byte=0;(               x=0;
             } 	         }=         p++;       })     }f }m - /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %dO %                                                                             %fO %                                                                             %>O %   X M a k e M a g n i f y I m a g e                                         %oO %                                                                             %eO %                                                                             %xO %                                                                             %!O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %dO %  Function XMakeMagnifyImage magnifies a region of an X image and displays it.v %)2 %  The format of the XMakeMagnifyImage routine is: %s) %      XMakeMagnifyImage(display,windows)d %-+ %  A description of each parameter follows:t % E %    o display: Specifies a connection to an X server;  returned fromr %      XOpenDisplay. %o< %    o windows: Specifies a pointer to a XWindows structure. %  %o */' void XMakeMagnifyImage(display,windows)r Display"   *display;p   XWindows   *windows;) {r   register int     x,     y;     register unsigned char     *p,i     *q;e     register unsigned intx     j,     k,     l;  
   static char      text[MaxTextLength];     static unsigned intt     previous_magnify=0;x     static XWindowInfo     magnify_window;i     unsigned int     height,e     i,     magnify,     scanline_pad, 
     width;     XColor
     color;     XImage     *ximage;     /*     Check boundry conditions.t   */   magnify=1;+   for (i=1; i < windows->magnify.data; i++)      magnify<<=1;I   while ((magnify*windows->image.ximage->width) < windows->magnify.width)f     magnify<<=1;K   while ((magnify*windows->image.ximage->height) < windows->magnify.height)l     magnify<<=1;*   while (magnify > windows->magnify.width)     magnify>>=1;+   while (magnify > windows->magnify.height)t     magnify>>=1;"   if (magnify != previous_magnify)     {a       unsigned int         status;o         XTextProperty(         window_name;         /*8         New magnify factor:  update magnify window name.       */
       i=0;!       while ((1 << i) <= magnify)f         i++;<       (void) sprintf(windows->magnify.name,"Magnify %uX",i);N       status=XStringListToTextProperty(&windows->magnify.name,1,&window_name);       if (status != 0)=         XSetWMName(display,windows->magnify.id,&window_name);v     }r   previous_magnify=magnify;%   ximage=windows->image.ximage;f'   width=windows->magnify.ximage->width;i)   height=windows->magnify.ximage->height;e.   x=windows->magnify.x-((width/magnify) >> 1);   if (x < 0)     x=0;   else,     if (x > (ximage->width-(width/magnify)))$       x=ximage->width-width/magnify;/   y=windows->magnify.y-((height/magnify) >> 1);r   if (y < 0)     y=0;   else.     if (y > (ximage->height-(height/magnify)))&       y=ximage->height-height/magnify;4   q=(unsigned char *) windows->magnify.ximage->data;7   scanline_pad=windows->magnify.ximage->bytes_per_line-e;     ((width*windows->magnify.ximage->bits_per_pixel) >> 3);%!   if (ximage->bits_per_pixel < 8)%     {%       register unsigned char         background, 
         byte,          foreground,          p_bit,         q_bit;         register unsigned int          plane;         XPixelInfo         *pixel_info;  -       pixel_info=windows->magnify.pixel_info; '       switch (ximage->bitmap_bit_order)        {          case LSBFirst:	         {            /*)             Magnify little-endian bitmap.            */           background=0x00;           foreground=0x80;)           if (ximage->format == XYBitmap)%
             {%C               background=(Intensity(pixel_info->foreground_color) <eG                 Intensity(pixel_info->background_color) ? 0x80 : 0x00);oC               foreground=(Intensity(pixel_info->background_color) <nG                 Intensity(pixel_info->foreground_color) ? 0x80 : 0x00);X
             }m+           for (i=0; i < height; i+=magnify)o           {              /*+               Propogate pixel magnify rows.              */'             for (j=0; j < magnify; j++)o
             {eH               p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+2                 ((x*ximage->bits_per_pixel) >> 3);6               p_bit=(x*ximage->bits_per_pixel) & 0x07;               q_bit=0;               byte=0; .               for (k=0; k < width; k+=magnify)               {                  /*2                   Propogate pixel magnify columns.                 */+                 for (l=0; l < magnify; l++)8                 {                    /*-                     Propogate each bit plane.                    */H                   for (plane=0; plane < ximage->bits_per_pixel; plane++)                   {,                     byte>>=1; 5                     if (*p & (0x01 << (p_bit+plane))) '                       byte|=foreground;                      else'                       byte|=background;o                     q_bit++;#                     if (q_bit == 8)c                       {t"                         *q++=byte;                          q_bit=0;                         byte=0;a                       }p                   }p                 }n.                 p_bit+=ximage->bits_per_pixel;                 if (p_bit == 8)m                   {                      p++;                     p_bit=0;                   }                  if (q_bit != 0)6'                   *q=byte >> (8-q_bit);g                  q+=scanline_pad;               } 
             }j             y++;           }s           break;	         }          case MSBFirst:         default:	         {s           /*&             Magnify big-endian bitmap.           */           background=0x00;           foreground=0x01;)           if (ximage->format == XYBitmap)d
             { C               background=(Intensity(pixel_info->foreground_color) <cG                 Intensity(pixel_info->background_color) ? 0x01 : 0x00);aC               foreground=(Intensity(pixel_info->background_color) < G                 Intensity(pixel_info->foreground_color) ? 0x01 : 0x00); 
             } +           for (i=0; i < height; i+=magnify)+           {]             /*+               Propogate pixel magnify rows.e             */'             for (j=0; j < magnify; j++)B
             {_H               p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+2                 ((x*ximage->bits_per_pixel) >> 3);6               p_bit=(x*ximage->bits_per_pixel) & 0x07;               q_bit=0;               byte=0;a.               for (k=0; k < width; k+=magnify)               {-                 /*2                   Propogate pixel magnify columns.                 */+                 for (l=0; l < magnify; l++);                 {                    /*-                     Propogate each bit plane.m                   */H                   for (plane=0; plane < ximage->bits_per_pixel; plane++)                   {i                     byte<<=1;35                     if (*p & (0x80 >> (p_bit+plane)))a'                       byte|=foreground;                      else'                       byte|=background;=                     q_bit++;#                     if (q_bit == 8);                       {a"                         *q++=byte;                          q_bit=0;                         byte=0;>                       }d                   }0                 } .                 p_bit+=ximage->bits_per_pixel;                 if (p_bit == 8)                    {s                     p++;                     p_bit=0;                   }l                 if (q_bit != 0) '                   *q=byte << (8-q_bit);                   q+=scanline_pad;               } 
             }              y++;           }h           break;	         }        }      }%   else#     switch (ximage->bits_per_pixel)%     {%
       case 6:%
       case 8:        { 
         /*            Magnify 8 bit X image.
         */)         for (i=0; i < height; i+=magnify) 	         {            /*)             Propogate pixel magnify rows.            */%           for (j=0; j < magnify; j++)            { F             p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+0               ((x*ximage->bits_per_pixel) >> 3);,             for (k=0; k < width; k+=magnify)
             {                /*0                 Propogate pixel magnify columns.               */)               for (l=0; l < magnify; l++)                  *q++=(*p);               p++;
             }%             q+=scanline_pad;           }I           y++;	         }a         break;       }f       default:       {s         register unsigned intd           bytes_per_pixel,           m;  
         /*%           Magnify multi-byte X image.o
         */4         bytes_per_pixel=ximage->bits_per_pixel >> 3;)         for (i=0; i < height; i+=magnify)t	         {e           /*)             Propogate pixel magnify rows.p           */%           for (j=0; j < magnify; j++)            {iF             p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+0               ((x*ximage->bits_per_pixel) >> 3);,             for (k=0; k < width; k+=magnify)
             {n               /*0                 Propogate pixel magnify columns.               */)               for (l=0; l < magnify; l++)a3                 for (m=0; m < bytes_per_pixel; m++)i                    *q++=(*(p+m));!               p+=bytes_per_pixel;P
             }k             q+=scanline_pad;           }            y++;	         };         break;       };     }i   /*#     Copy X image to magnify pixmap.    */.   x=windows->magnify.x-((width/magnify) >> 1);   if (x < 0).     x=(width >> 1)-windows->magnify.x*magnify;   else,     if (x > (ximage->width-(width/magnify)))@       x=(ximage->width-windows->magnify.x)*magnify-(width >> 1);     else
       x=0;/   y=windows->magnify.y-((height/magnify) >> 1);u   if (y < 0)/     y=(height >> 1)-windows->magnify.y*magnify;n   else.     if (y > (ximage->height-(height/magnify)))B       y=(ximage->height-windows->magnify.y)*magnify-(height >> 1);     else
       y=0;   if ((x != 0) || (y != 0)) 3     XFillRectangle(display,windows->magnify.pixmap,x:       windows->magnify.annotate_context,0,0,width,height);N   XPutImage(display,windows->magnify.pixmap,windows->magnify.annotate_context,6     windows->magnify.ximage,0,0,x,y,width-x,height-y);4   if ((magnify > 1) && ((magnify <= (width >> 1)) &&"       (magnify <= (height >> 1))))     {u       RectangleInfo,         highlight_info;(         /*         Highlight center pixel.;       */3       highlight_info.x=windows->magnify.width >> 1;_4       highlight_info.y=windows->magnify.height >> 1;#       highlight_info.width=magnify;o$       highlight_info.height=magnify;5       XDrawRectangle(display,windows->magnify.pixmap,tM         windows->magnify.highlight_context,highlight_info.x,highlight_info.y,n8         highlight_info.width-1,highlight_info.height-1);       if (magnify > 2)7         XDrawRectangle(display,windows->magnify.pixmap,o?           windows->magnify.annotate_context,highlight_info.x+1, M           highlight_info.y+1,highlight_info.width-3,highlight_info.height-3);e     }y   /*     Show center pixel color.   */   color.pixel=K     XGetPixel(windows->image.ximage,windows->magnify.x,windows->magnify.y);r@   XQueryColor(display,windows->image.map_info->colormap,&color);"   if (windows->magnify.depth > 12)>     (void) sprintf(text,"%+d%+d  (%3u,%3u,%3u) #%02x%02x%02x",B       windows->magnify.x,windows->magnify.y,ColorShift(color.red),K       ColorShift(color.green),ColorShift(color.blue),ColorShift(color.red), 6       ColorShift(color.green),ColorShift(color.blue));   elseC     (void) sprintf(text,"%+d%+d  (%3u,%3u,%3u) #%02x%02x%02x %lu ",rB       windows->magnify.x,windows->magnify.y,ColorShift(color.red),K       ColorShift(color.green),ColorShift(color.blue),ColorShift(color.red),rB       ColorShift(color.green),ColorShift(color.blue),color.pixel);P   height=windows->magnify.font_info->ascent+windows->magnify.font_info->descent;:   x=(3*windows->magnify.font_info->max_bounds.width) >> 2;5   y=windows->magnify.font_info->ascent+(height >> 2);t3   XDrawImageString(display,windows->magnify.pixmap,e=     windows->magnify.annotate_context,x,y,text,strlen(text));p   /*     Refresh magnify window.    */"   magnify_window=windows->magnify;   magnify_window.x=0;    magnify_window.y=0;g:   XRefreshWindow(display,&magnify_window,(XEvent *) NULL); }i e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %uO %                                                                             %dO %                                                                             %wO %   X M a k e P i x m a p                                                     %-O %                                                                             % O %                                                                             % O %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % . %  Function XMakePixmap creates an X11 pixmap. % , %  The format of the XMakePixmap routine is: % 7 %      status=XMakePixmap(display,resource_info,window)e %l+ %  A description of each parameter follows:_ %oC %    o status: Function XMakePixmap returns True if the X pixmap isnN %      successfully created.  False is returned is there is a memory shortage. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.e %.D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %w> %    o window: Specifies a pointer to a XWindowInfo structure. %m %  */6 unsigned int XMakePixmap(display,resource_info,window) Display    *display;i  
 XResourceInfor   *resource_info;h   XWindowInfo(
   *window; {    unsigned int     height, 
     width;  (   if (window->ximage == (XImage *) NULL)     return(False);   /*     Display busy cursor.   */8   XDefineCursor(display,window->id,window->busy_cursor);   XFlush(display);   /*     Create pixmap.   */&   if (window->pixmap != (Pixmap) NULL)     { *       XFreePixmap(display,window->pixmap);#       window->pixmap=(Pixmap) NULL;o #ifdef HasSharedMemory        if (window->shared_memory)/         if (window->segment_info[1].shmid >= 0)F           { 9             XShmDetach(display,&window->segment_info[1]); !             XSync(display,False);e3             shmdt(window->segment_info[1].shmaddr);o/             window->segment_info[1].shmid=(-1);            }e #endif     }    width=window->ximage->width;    height=window->ximage->height; #ifdef HasSharedMemory   if (window->shared_memory)     {s=       window->segment_info[3].shmid=(int) shmget(IPC_PRIVATE,l@         window->ximage->bytes_per_line*height,IPC_CREAT | 0777);-       if (window->segment_info[3].shmid >= 0).	         { 2           window->segment_info[3].shmaddr=(char *)5             shmat(window->segment_info[3].shmid,0,0); 1           window->segment_info[3].readOnly=False; 7           XShmAttach(display,&window->segment_info[3]);-=           window->pixmap=XShmCreatePixmap(display,window->id,aE             window->segment_info[3].shmaddr,&window->segment_info[3], (             width,height,window->depth);.           if (window->pixmap != (Pixmap) NULL)<             window->segment_info[1]=window->segment_info[3];           else
             {o5               shmdt(window->segment_info[3].shmaddr);i;               XShmDetach(display,&window->segment_info[3]); 
             }            XSync(display,False); ;           shmctl(window->segment_info[3].shmid,IPC_RMID,0);i	         }m     }) #endif&   if (window->pixmap == (Pixmap) NULL)P     window->pixmap=XCreatePixmap(display,window->id,width,height,window->depth);&   if (window->pixmap == (Pixmap) NULL)     {        /*"         Unable to allocate pixmap.       */7       XDefineCursor(display,window->id,window->cursor);        return(False);     }    /*     Copy X image to pixmap.    */ #ifdef HasSharedMemory   if (window->shared_memory)P     XShmPutImage(display,window->pixmap,window->annotate_context,window->ximage,!       0,0,0,0,width,height,True);  #endif   if (!window->shared_memory) M     XPutImage(display,window->pixmap,window->annotate_context,window->ximage,        0,0,0,0,width,height);   if (resource_info->debug)      { )       (void) fprintf(stderr,"Pixmap:\n");%E       (void) fprintf(stderr,"  width, height: %dx%d\n",width,height);o     }r   /*     Restore cursor.o   */3   XDefineCursor(display,window->id,window->cursor);r   return(True);  }t m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %:O %                                                                             %sO %                                                                             %rO %   X M a k e S t a n d a r d C o l o r m a p                                 %/O %                                                                             % O %                                                                             %mO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XMakeStandardColormap creates an X11 Standard Colormap.e % 6 %  The format of the XMakeStandardColormap routine is: % E %      XMakeStandardColormap(display,visual_info,resource_info,image,a %        map_info,pixel_info)) % + %  A description of each parameter follows:% %%D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % L %    o map_info: If a Standard Colormap type is specified, this structure is8 %      initialized with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  %  %  */  static int IntensityCompare(x,y)
 const void   *x,%   *y;% {%   DiversityPacket%
     *color_1,t
     *color_2;c      color_1=(DiversityPacket *) x;    color_2=(DiversityPacket *) y;>   return((int) Intensity(*color_2)-(int) Intensity(*color_1)); }x  ! static int PopularityCompare(x,y)_
 const void   *x,    *y;A {s   DiversityPacketr
     *color_1, 
     *color_2;s      color_1=(DiversityPacket *) x;    color_2=(DiversityPacket *) y;4   return((int) color_2->count-(int) color_1->count); }o  L void XMakeStandardColormap(display,visual_info,resource_info,image,map_info,
   pixel_info)a Display    *display;i   XVisualInfoi   *visual_info;   
 XResourceInfoh   *resource_info;.   Image 	   *image;f   XStandardColormapr   *map_info;  
 XPixelInfo   *pixel_info; {n
   Colormap
     colormap;a     intu     status;      register int     i;     unsigned int     gray_value,o     number_colors,     retain_colors;     XColor
     color,     *colors,     *p;s  /   if (resource_info->map_type != (char *) NULL),     {i       /*=         Standard Colormap is already defined (i.e. xstdcmap).        */7       if (pixel_info->pixels != (unsigned long *) NULL)a*         free((char *) pixel_info->pixels);K       number_colors=(unsigned int) ((map_info->red_max*map_info->red_mult)+W3         (map_info->green_max*map_info->green_mult)+=4         (map_info->blue_max*map_info->blue_mult)+1);3       if (image->matte || !resource_info->dither ||=M           resource_info->color_recovery || (number_colors > MaxColormapSize))dG         XGetPixelInfo(display,visual_info,map_info,resource_info,image,e           pixel_info);
       else	         {/           Imagei             *map_image;d  "           register RunlengthPacket             *p;i             /*:             Improve image appearance with error diffusion.           */6           map_image=AllocateImage((ImageInfo *) NULL);*           if (map_image == (Image *) NULL)G             Error("Unable to dither image","Memory allocation failed");t+           map_image->columns=number_colors;_           map_image->rows=1;@           map_image->packets=map_image->columns*map_image->rows;/           map_image->pixels=(RunlengthPacket *) ?             malloc(map_image->packets*sizeof(RunlengthPacket)); <           if (map_image->pixels == (RunlengthPacket *) NULL)G             Error("Unable to dither image","Memory allocation failed");a           /*&             Initialize colormap image.           */           p=map_image->pixels;+           for (i=0; i < number_colors; i++)            {r             p->red=0;l'             if (map_info->red_max != 0)($               p->red=(unsigned char)D                 (((i/map_info->red_mult)*MaxRGB)/map_info->red_max);             p->green=0;s)             if (map_info->green_max != 0) D               p->green=(unsigned char) ((((i/map_info->green_mult) %F                 (map_info->green_max+1))*MaxRGB)/map_info->green_max);             p->blue=0;(             if (map_info->blue_max != 0)%               p->blue=(unsigned char) I                 (((i % map_info->green_mult)*MaxRGB)/map_info->blue_max);              p->index=0;              p->length=0;             p++;           } )           MapImage(image,map_image,True); I           XGetPixelInfo(display,visual_info,map_info,resource_info,image,              pixel_info);#           image->class=DirectClass; "           DestroyImage(map_image);	         }        if (resource_info->debug)%	         {%8           (void) fprintf(stderr,"Standard Colormap:\n");M           (void) fprintf(stderr,"  colormap id: 0x%lx\n",map_info->colormap);aH           (void) fprintf(stderr,"  red, green, blue max: %lu %lu %lu\n",F             map_info->red_max,map_info->green_max,map_info->blue_max);I           (void) fprintf(stderr,"  red, green, blue mult: %lu %lu %lu\n",sI             map_info->red_mult,map_info->green_mult,map_info->blue_mult);e	         } 
       return;l     }rO   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor))i(     if ((image->class == DirectClass) ||5         (image->colors > visual_info->colormap_size))        {i
         /*9           Image has more colors than the visual supports.X
         */         if (image->matte)o           {e$             register RunlengthPacket               *p;a               /*%               Fake matte information.o             */B             Warning("This visual does not support an image matte",4               XVisualClassName(visual_info->class));             p=image->pixels;.             for (i=0; i < image->packets; i++)
             {n*               if (p->index == Transparent)                 {)F                   p->red=ColorShift(pixel_info->background_color.red);J                   p->green=ColorShift(pixel_info->background_color.green);H                   p->blue=ColorShift(pixel_info->background_color.blue);                 }(               p++;
             }!           } F         QuantizeImage(image,(unsigned int) visual_info->colormap_size,:           resource_info->tree_depth,resource_info->dither,%           resource_info->colorspace); ?         image->class=DirectClass;  /* promote to DirectClass */%       }%   /**     Free previous and create new colormap.   */A   XFreeStandardColormap(display,visual_info,map_info,pixel_info); 9   colormap=XDefaultColormap(display,visual_info->screen); I   if (visual_info->visual != XDefaultVisual(display,visual_info->screen)) N     colormap=XCreateColormap(display,XRootWindow(display,visual_info->screen),=       visual_info->visual,visual_info->class == DirectColor ?        AllocAll : AllocNone);"   if (colormap == (Colormap) NULL)5     Error("Unable to create colormap",(char *) NULL);    /*1     Initialize the map and pixel info structures.    */-   XGetMapInfo(visual_info,colormap,map_info);%M   XGetPixelInfo(display,visual_info,map_info,resource_info,image,pixel_info);i   /*B     Allocating colors in server colormap is based on visual class.   */   switch (visual_info->class)t   {(     case StaticGray:     case StaticColor:r     {f       /*F         Define Standard Colormap for StaticGray or StaticColor visual.       */"       number_colors=image->colors;J       colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));$       if (colors == (XColor *) NULL)F         Error("Unable to create colormap","Memory allocation failed");       p=colors; +       color.flags=DoRed | DoGreen | DoBlue;-,       if (visual_info->class == StaticColor))         for (i=0; i < image->colors; i++)>	         {0C           color.red=(unsigned short) (image->colormap[i].red << 8);fG           color.green=(unsigned short) (image->colormap[i].green << 8);%E           color.blue=(unsigned short) (image->colormap[i].blue << 8); 6           status=XAllocColor(display,colormap,&color);           if (status == 0)
             { >               colormap=XCopyColormapAndFree(display,colormap);3               XAllocColor(display,colormap,&color); 
             } ,           pixel_info->pixels[i]=color.pixel;           *p++=color; 	         } 
       else)         for (i=0; i < image->colors; i++) 	         { 3           gray_value=Intensity(image->colormap[i]); 7           color.red=(unsigned short) (gray_value << 8); 9           color.green=(unsigned short) (gray_value << 8); 8           color.blue=(unsigned short) (gray_value << 8);6           status=XAllocColor(display,colormap,&color);           if (status == 0)
             { >               colormap=XCopyColormapAndFree(display,colormap);3               XAllocColor(display,colormap,&color);A
             } ,           pixel_info->pixels[i]=color.pixel;           *p++=color;e	         }o       break;     }v     case GrayScale:      case PseudoColor:u     {s       unsigned int         colormap_type;         /*E         Define Standard Colormap for GrayScale or PseudoColor visual..       */"       number_colors=image->colors;J       colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));$       if (colors == (XColor *) NULL)F         Error("Unable to create colormap","Memory allocation failed");       /*#         Preallocate our GUI colors.a       */I       (void) XAllocColor(display,colormap,&pixel_info->foreground_color); I       (void) XAllocColor(display,colormap,&pixel_info->background_color);=E       (void) XAllocColor(display,colormap,&pixel_info->border_color);lD       (void) XAllocColor(display,colormap,&pixel_info->matte_color);H       (void) XAllocColor(display,colormap,&pixel_info->highlight_color);E       (void) XAllocColor(display,colormap,&pixel_info->shadow_color);>D       (void) XAllocColor(display,colormap,&pixel_info->depth_color);E       (void) XAllocColor(display,colormap,&pixel_info->trough_color);o'       for (i=0; i < MaxNumberPens; i++)lG         (void) XAllocColor(display,colormap,&pixel_info->pen_color[i]);n       /*D         Determine if image colors will "fit" into X server colormap.       */,       colormap_type=resource_info->colormap;N       status=XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0,*         pixel_info->pixels,image->colors);       if (status != 0)&         colormap_type=PrivateColormap;*       if (colormap_type == SharedColormap)	         {            DiversityPacket              *diversity;   "           register RunlengthPacket             *q;              unsigned short             index;             /*P             Define Standard colormap for shared GrayScale or PseudoColor visual:           */'           diversity=(DiversityPacket *) :             malloc(image->colors*sizeof(DiversityPacket));4           if (diversity == (DiversityPacket *) NULL)J             Error("Unable to create colormap","Memory allocation failed");+           for (i=0; i < image->colors; i++)i           { 4             diversity[i].red=image->colormap[i].red;8             diversity[i].green=image->colormap[i].green;6             diversity[i].blue=image->colormap[i].blue;2             diversity[i].index=(unsigned short) i;!             diversity[i].count=0;>           }0           q=image->pixels;,           for (i=0; i < image->packets; i++)           {=5             diversity[q->index].count+=(q->length+1);              q++;           }%           /*0             Sort colors by decreasing intensity.           */I           qsort((void *) diversity,image->colors,sizeof(DiversityPacket), O             (int (*) _Declare((const void *, const void *))) IntensityCompare); D           for (i=0; i < image->colors; i+=Max(image->colors >> 4,2))J             diversity[i].count<<=4;  /* increase this colors popularity *//           diversity[image->colors-1].count<<=4; I           qsort((void *) diversity,image->colors,sizeof(DiversityPacket), P             (int (*) _Declare((const void *, const void *))) PopularityCompare);           /*             Allocate colors.           */           p=colors;%/           color.flags=DoRed | DoGreen | DoBlue; 0           if (visual_info->class == PseudoColor)-             for (i=0; i < image->colors; i++)n
             { '               index=diversity[i].index;nK               color.red=(unsigned short) (image->colormap[index].red << 8);oO               color.green=(unsigned short) (image->colormap[index].green << 8);rM               color.blue=(unsigned short) (image->colormap[index].blue << 8);o:               status=XAllocColor(display,colormap,&color);               if (status == 0)                 break;4               pixel_info->pixels[index]=color.pixel;               *p++=color;a
             }r           else-             for (i=0; i < image->colors; i++)u
             {o'               index=diversity[i].index;r;               gray_value=Intensity(image->colormap[index]);i;               color.red=(unsigned short) (gray_value << 8); =               color.green=(unsigned short) (gray_value << 8);f<               color.blue=(unsigned short) (gray_value << 8);:               status=XAllocColor(display,colormap,&color);               if (status == 0)                 break;4               pixel_info->pixels[index]=color.pixel;               *p++=color; 
             }1            if (i < image->colors)
             {                register int                 j;                 XColor                 *server_colors;                  /*'                 Read X server colormap.                */&               server_colors=(XColor *)B                 malloc(visual_info->colormap_size*sizeof(XColor));3               if (server_colors == (XColor *) NULL)(N                 Error("Unable to create colormap","Memory allocation failed");<               for (j=0; j < visual_info->colormap_size; j++)9                 server_colors[j].pixel=(unsigned long) j;e:               XQueryColors(display,colormap,server_colors,;                 (int) Min(visual_info->colormap_size,256));r               /*?                 Select remaining colors from X server colormap.u               */4               if (visual_info->class == PseudoColor).                 for (; i < image->colors; i++)                 {)+                   index=diversity[i].index;oO                   color.red=(unsigned short) (image->colormap[index].red << 8);=.                   color.green=(unsigned short)8                     (image->colormap[index].green << 8);-                   color.blue=(unsigned short),7                     (image->colormap[index].blue << 8);u<                   XBestPixel(display,colormap,server_colors,F                     (unsigned int) visual_info->colormap_size,&color);8                   pixel_info->pixels[index]=color.pixel;                   *p++=color;i                 }o               else.                 for (; i < image->colors; i++)                 { +                   index=diversity[i].index;c?                   gray_value=Intensity(image->colormap[index]);l?                   color.red=(unsigned short) (gray_value << 8);rA                   color.green=(unsigned short) (gray_value << 8);l@                   color.blue=(unsigned short) (gray_value << 8);<                   XBestPixel(display,colormap,server_colors,F                     (unsigned int) visual_info->colormap_size,&color);8                   pixel_info->pixels[index]=color.pixel;                   *p++=color;                  }r=               if (image->colors < visual_info->colormap_size)c                 {_                   /*G                     Fill up colors array-- more choices for pen colors.n                   */                    retain_colors=F                     Min(visual_info->colormap_size-image->colors,256);3                   for (i=0; i < retain_colors; i++)e*                     *p++=server_colors[i];/                   number_colors+=retain_colors;                  }-+               free((char *) server_colors); 
             }r#           free((char *) diversity);n           break;	         }e       /*M         Define Standard colormap for private GrayScale or PseudoColor visual.        */       if (status == 0)	         {o           /*P             Not enough colormap entries in the colormap-- Create a new colormap.           */+           colormap=XCreateColormap(display,>I             XRootWindow(display,visual_info->screen),visual_info->visual,n             AllocNone);h*           if (colormap == (Colormap) NULL)=             Error("Unable to create colormap",(char *) NULL);e&           map_info->colormap=colormap;9           if (image->colors < visual_info->colormap_size) 
             {x               /*K                 Retain colors from the default colormap to help lessens thee-                 effects of colormap flashing./               */N               retain_colors=Min(visual_info->colormap_size-image->colors,256);%               p=colors+image->colors;o/               for (i=0; i < retain_colors; i++)r               {1+                 p->pixel=(unsigned long) i;n                 p++;               }P#               XQueryColors(display,r>                 XDefaultColormap(display,visual_info->screen),:                 colors+image->colors,(int) retain_colors);               /*A                 Transfer colors from default to private colormap.=               */O               XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0,_2                 pixel_info->pixels,retain_colors);%               p=colors+image->colors;e/               for (i=0; i < retain_colors; i++)o               {o/                 p->pixel=pixel_info->pixels[i];                  p++;               }rP               XStoreColors(display,colormap,colors+image->colors,retain_colors);+               number_colors+=retain_colors;i
             }hK           XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0,u.             pixel_info->pixels,image->colors);	         }r       /*!         Store the image colormap.f       */       p=colors;u+       color.flags=DoRed | DoGreen | DoBlue;0,       if (visual_info->class == PseudoColor))         for (i=0; i < image->colors; i++)i	         {eC           color.red=(unsigned short) (image->colormap[i].red << 8);pG           color.green=(unsigned short) (image->colormap[i].green << 8); E           color.blue=(unsigned short) (image->colormap[i].blue << 8);],           color.pixel=pixel_info->pixels[i];           *p++=color;f	         }o
       else)         for (i=0; i < image->colors; i++)s	         {G3           gray_value=Intensity(image->colormap[i]);x7           color.red=(unsigned short) (gray_value << 8);)9           color.green=(unsigned short) (gray_value << 8);*8           color.blue=(unsigned short) (gray_value << 8);,           color.pixel=pixel_info->pixels[i];           *p++=color; 	         }_:       XStoreColors(display,colormap,colors,image->colors);       break;     }      case TrueColor:+     case DirectColor:o     default:     {s       unsigned int         linear_colormap;         /*E         Define Standard Colormap for TrueColor or DirectColor visual.%       */K       number_colors=(unsigned int) ((map_info->red_max*map_info->red_mult)+ 3         (map_info->green_max*map_info->green_mult)+ 4         (map_info->blue_max*map_info->blue_mult)+1);/       linear_colormap=(number_colors > 4096) || A         (((map_info->red_max+1) == visual_info->colormap_size) && C          ((map_info->green_max+1) == visual_info->colormap_size) && A          ((map_info->blue_max+1) == visual_info->colormap_size));        if (linear_colormap)1         number_colors=visual_info->colormap_size;        /*         Allocate color array.        */=       colors=(XColor *) malloc(number_colors*sizeof(XColor));%$       if (colors == (XColor *) NULL)F         Error("Unable to create colormap","Memory allocation failed");       /*%         Initialize linear color ramp.c       */       p=colors; +       color.flags=DoRed | DoGreen | DoBlue;t       if (linear_colormap))         for (i=0; i < number_colors; i++)s	         {r(           color.blue=(unsigned short) 0;&           if (map_info->blue_max != 0)'             color.blue=(unsigned short)hF               (((i % map_info->green_mult)*65535)/map_info->blue_max);!           color.green=color.blue;            color.red=color.blue;n8           color.pixel=XStandardPixel(map_info,color,16);           *p++=color;s	         }s
       else)         for (i=0; i < number_colors; i++)n	         { '           color.red=(unsigned short) 0;p%           if (map_info->red_max != 0) &             color.red=(unsigned short)A               (((i/map_info->red_mult)*65535)/map_info->red_max);t)           color.green=(unsigned short) 0;i'           if (map_info->green_max != 0)uF             color.green=(unsigned short) ((((i/map_info->green_mult) %C               (map_info->green_max+1))*65535)/map_info->green_max); (           color.blue=(unsigned short) 0;&           if (map_info->blue_max != 0)'             color.blue=(unsigned short) F               (((i % map_info->green_mult)*65535)/map_info->blue_max);8           color.pixel=XStandardPixel(map_info,color,16);           *p++=color;X	         } 0       if ((visual_info->class == DirectColor) &&F           (colormap != XDefaultColormap(display,visual_info->screen)))<         XStoreColors(display,colormap,colors,number_colors);
       else)         for (i=0; i < number_colors; i++) 3           XAllocColor(display,colormap,&colors[i]);i       break;     }    }=O   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor))      {        /*8         Set foreground, background, border, etc. pixels.       */7       XBestPixel(display,colormap,colors,number_colors,K'         &pixel_info->foreground_color); 7       XBestPixel(display,colormap,colors,number_colors, '         &pixel_info->background_color); /       if (pixel_info->background_color.pixel ==K-           pixel_info->foreground_color.pixel)-	         {-           /*9             Foreground and background colors must differ.o           */O           pixel_info->background_color.red=(~pixel_info->foreground_color.red);,-           pixel_info->background_color.green=s2             (~pixel_info->foreground_color.green);,           pixel_info->background_color.blue=1             (~pixel_info->foreground_color.blue); ;           XBestPixel(display,colormap,colors,number_colors,%+             &pixel_info->background_color);%	         }%7       XBestPixel(display,colormap,colors,number_colors, #         &pixel_info->border_color); 7       XBestPixel(display,colormap,colors,number_colors, "         &pixel_info->matte_color);7       XBestPixel(display,colormap,colors,number_colors, &         &pixel_info->highlight_color);7       XBestPixel(display,colormap,colors,number_colors, #         &pixel_info->shadow_color); 7       XBestPixel(display,colormap,colors,number_colors, "         &pixel_info->depth_color);7       XBestPixel(display,colormap,colors,number_colors, #         &pixel_info->trough_color); '       for (i=0; i < MaxNumberPens; i++)%       {%9         XBestPixel(display,colormap,colors,number_colors,e%           &pixel_info->pen_color[i]);aK         pixel_info->pixels[image->colors+i]=pixel_info->pen_color[i].pixel;        }s5       pixel_info->colors=image->colors+MaxNumberPens;i     }e   free((char *) colors);   if (resource_info->debug)      {o4       (void) fprintf(stderr,"Standard Colormap:\n");I       (void) fprintf(stderr,"  colormap id: 0x%lx\n",map_info->colormap); D       (void) fprintf(stderr,"  red, green, blue max: %lu %lu %lu\n",B         map_info->red_max,map_info->green_max,map_info->blue_max);E       (void) fprintf(stderr,"  red, green, blue mult: %lu %lu %lu\n",tE         map_info->red_mult,map_info->green_mult,map_info->blue_mult);      }r }  i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             % O %                                                                             % O %                                                                             %lO %   X M a k e W i n d o w                                                     %gO %                                                                             % O %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%> %K. %  Function XMakeWindow creates an X11 window. % , %  The format of the XMakeWindow routine is: % E %      XMakeWindow(display,parent,argv,argc,class_hint,manager_hints,) %        window_info)  % + %  A description of each parameter follows:n %aD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %a0 %    o parent: Specifies the parent window_info. %r7 %    o argv: Specifies the application's argument list.  %o/ %    o argc: Specifies the number of arguments.f %eE %    o class_hint: Specifies a pointer to a X11 XClassHint structure.  %vF %    o manager_hints: Specifies a pointer to a X11 XWMHints structure. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.u %_ %a */O void XMakeWindow(display,parent,argv,argc,class_hint,manager_hints,window_info)% Display%   *display;    Window	   parent;    char	   **argv;    int    argc;   
 XClassHint   *class_hint;   XWMHints   *manager_hints;    XWindowInfo    *window_info;  {  #define MinWindowSize  64      Atom     atom_list[2];      int      gravity,     status;      XSizeHints     *size_hints;     XTextProperty      icon_name,     window_name;     /*     Set window_info hints.   */   size_hints=XAllocSizeHints(); (   if (size_hints == (XSizeHints *) NULL)@     Error("Unable to make X window","Memory allocation failed");'   size_hints->flags=window_info->flags;%   size_hints->x=window_info->x;%   size_hints->y=window_info->y;%'   size_hints->width=window_info->width;o)   size_hints->height=window_info->height;    size_hints->flags|=PMinSize;   if (window_info->immutable)      {s       /*&         Window size cannot be changed.       */.       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;"       size_hints->flags|=PMaxSize;     }c   else     {        /*#         Window size can be changed.p       */3       size_hints->min_width=window_info->min_width;/5       size_hints->min_height=window_info->min_height;e$       size_hints->flags|=PResizeInc;3       size_hints->width_inc=window_info->width_inc; 5       size_hints->height_inc=window_info->height_inc;  #ifndef PRE_R4_ICCCM#       size_hints->flags|=PBaseSize;*3       size_hints->base_width=size_hints->width_inc;l5       size_hints->base_height=size_hints->height_inc;m #endif     }h   gravity=NorthWestGravity; -   if (window_info->geometry != (char *) NULL)      {l
       char(         default_geometry[MaxTextLength],          geometry[MaxTextLength];  	       inta         flags;         register charv         *p;G         /*          User specified geometry.       */@       (void) sprintf(default_geometry,"%dx%d",size_hints->width,         size_hints->height);4       (void) strcpy(geometry,window_info->geometry);       p=geometry;B!       while ((int) strlen(p) > 0)b       {o(         if (!isspace(*p) && (*p != '%'))           p++;         else           (void) strcpy(p,p+1);e       }GN       flags=XWMGeometry(display,window_info->screen,geometry,default_geometry,K         window_info->border_width,size_hints,&size_hints->x,&size_hints->y,e9         &size_hints->width,&size_hints->height,&gravity); 8       if ((flags & WidthValue) && (flags & HeightValue))"         size_hints->flags|=USSize;/       if ((flags & XValue) && (flags & YValue));	         {i(           size_hints->flags|=USPosition;'           window_info->x=size_hints->x;p'           window_info->y=size_hints->y;f	         }p     }  #ifndef PRE_R4_ICCCM"   size_hints->win_gravity=gravity;!   size_hints->flags|=PWinGravity;; #endif'   if (window_info->id == (Window) NULL)aO     window_info->id=XCreateWindow(display,parent,window_info->x,window_info->y,lG       window_info->width,window_info->height,window_info->border_width,nK       window_info->depth,InputOutput,window_info->visual,window_info->mask,         &window_info->attributes);   else     {        unsigned int
         mask;o         XEvent         sans_event;e         XWindowChanges         window_changes;c         /*;         Window already exists;  change relevant attributes.e       */H       XChangeWindowAttributes(display,window_info->id,window_info->mask,"         &window_info->attributes);       mask=ConfigureNotify;1O       while (XCheckTypedWindowEvent(display,window_info->id,mask,&sans_event));;&       window_changes.x=window_info->x;&       window_changes.y=window_info->y;.       window_changes.width=window_info->width;0       window_changes.height=window_info->height;       mask=CWWidth | CWHeight;*       if (window_info->flags & USPosition)         mask|=CWX | CWY;L       XReconfigureWMWindow(display,window_info->id,window_info->screen,mask,         &window_changes);r     }b'   if (window_info->id == (Window) NULL)o7     Error("Unable to create window",window_info->name);eF   status=XStringListToTextProperty(&window_info->name,1,&window_name);   if (status == 0)>     Error("Unable to create text property",window_info->name);I   status=XStringListToTextProperty(&window_info->icon_name,1,&icon_name);e   if (status == 0)C     Error("Unable to create text property",window_info->icon_name);t2   if (window_info->icon_geometry != (char *) NULL)     {e	       intG         flags,         gravity,         height,1         width;         /*%         User specified icon geometry.(       */$       size_hints->flags|=USPosition;O       flags=XWMGeometry(display,window_info->screen,window_info->icon_geometry,t:         (char *) NULL,0,size_hints,&manager_hints->icon_x,8         &manager_hints->icon_y,&width,&height,&gravity);/       if ((flags & XValue) && (flags & YValue))e/         manager_hints->flags|=IconPositionHint;,     }lM   XSetWMProperties(display,window_info->id,&window_name,&icon_name,argv,argc,l)     size_hints,manager_hints,class_hint);i=   atom_list[0]=XInternAtom(display,"WM_DELETE_WINDOW",False);e:   atom_list[1]=XInternAtom(display,"WM_TAKE_FOCUS",False);7   XSetWMProtocols(display,window_info->id,atom_list,2);n   XFree((void *) size_hints);- }n a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %nO %                                                                             %aO %                                                                             %eO %   X M o n t a g e I m a g e                                                 %rO %                                                                             %mO %                                                                             %eO %                                                                             %1O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %tH %  Function XMontageImage creates a composite image by combining several %  separate images.; % . %  The format of the XMontageImage routine is: % H %      XMontageImage(display,resource_info,montage_info,filename,images) %s+ %  A description of each parameter follows:y %sE %    o display: Specifies a connection to an X server;  returned fromo %      XOpenDisplay. %GK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.- %aD %    o montage_info: Specifies a pointer to a MontageInfo structure. % 9 %    o filename: Specifies the name of the montage image.1 %pB %    o image: Specifies a pointer to an array of Image structures. %v %; */   static int SceneCompare(x,y)
 const void   *x,    *y;e {r   Imageg     **image_1,     **image_2;     image_1=(Image **) x;u   image_2=(Image **) y;o:   return((int) (*image_1)->scene-(int) (*image_2)->scene); }y  H Image *XMontageImage(display,resource_info,montage_info,filename,images) Display    *display;-  
 XResourceInfoa   *resource_info;e   XMontageInfo   *montage_info;   char   *filename;   Imagem   **images;a {"
   ColorPacketi     border_color,r     highlight_color,     matte_color,     shadow_color;r     Imageo     *image,,     *montage_image;o     inth     x,
     x_offset,e     y,
     y_offset;s     register charc     *q;e     register int     i;     register RunlengthPacket     *p;      RectangleInfop     label_info,e     tile_info;     unsigned int     border_width,      bevel_width,
     count,     max_width,     number_images,     number_tiles,      status,m	     tile,(     tiles_per_column,r     tiles_per_row;     XAnnotateInfor     annotate_info;     XColor     background_color;r  
   XFontStructm     *font_info;_     XPixelInfo     pixel_info;      XStandardColormape     *map_info;  
   XVisualInfo"     *visual_info;      /**     Sort images by increasing tile number.   */*   number_tiles=montage_info->number_tiles;
   count=0;+   for (tile=0; tile < number_tiles; tile++)r     count+=images[tile]->scene;n   if (count != 0);7     qsort((void *) images,number_tiles,sizeof(Image *),eE       (int (*) _Declare((const void *, const void *))) SceneCompare);r   /*'     Determine tiles per row and column.l   */   tiles_per_row=1;   tiles_per_column=1;c9   while ((tiles_per_row*tiles_per_column) < number_tiles)m   {n     tiles_per_row++;     tiles_per_column++;    }t*   if (montage_info->tile != (char *) NULL)     {"2       tiles_per_column=montage_info->number_tiles;P       XParseGeometry(montage_info->tile,&x,&y,&tiles_per_row,&tiles_per_column);     }    /*     Determine tile sizes.t   */   border_width=0;""   if (display != (Display *) NULL)     { /       border_width=resource_info->border_width;m       if (montage_info->frame)	         {c,           bevel_width=(border_width >> 2)+1;)           border_width+=bevel_width << 1;e	         }c     }=*   tile_info.x=resource_info->border_width;*   tile_info.y=resource_info->border_width;5   if (resource_info->image_geometry != (char *) NULL)n     { M       XParseGeometry(resource_info->image_geometry,&tile_info.x,&tile_info.y,e,         &tile_info.width,&tile_info.height);       if (tile_info.x < 0)         tile_info.x=0;       if (tile_info.y < 0)         tile_info.y=0;     }"%   tile_info.width=images[0]->columns;_#   tile_info.height=images[0]->rows;o9   for (tile=1; tile < montage_info->number_tiles; tile++)b   {l0     if (images[tile]->columns > tile_info.width),       tile_info.width=images[tile]->columns;.     if (images[tile]->rows > tile_info.height)*       tile_info.height=images[tile]->rows;   }d   /*     Initialize tile colors.)   */   background_color.red=0;t   background_color.green=0;r   background_color.blue=0;   border_color.red=0;,   border_color.green=0;s   border_color.blue=0;   highlight_color=border_color;    shadow_color=border_color;#   XGetAnnotateInfo(&annotate_info);m"   if (display != (Display *) NULL)     {u       /*         Initialize visual info.r       */(       map_info=XAllocStandardColormap();1       if (map_info == (XStandardColormap *) NULL) 	         {f7           Warning("Unable to create standard colormap",l(             "Memory allocation failed");!           return((Image *) NULL);r	         }oB       visual_info=XBestVisualInfo(display,map_info,resource_info);)       map_info->colormap=(Colormap) NULL;e/       pixel_info.pixels=(unsigned long *) NULL;i       /*         Initialize font info.f       */7       font_info=XBestFont(display,resource_info,False);eE       annotate_info.text=(char *) malloc(MaxTextLength*sizeof(char));p2       if ((visual_info == (XVisualInfo *) NULL) ||0           (font_info == (XFontStruct *) NULL) ||0           (annotate_info.text == (char *) NULL))	         {%I           Warning("Unable to montage images","Memory allocation failed"); !           return((Image *) NULL); 	         } (       annotate_info.font_info=font_info;@       annotate_info.height=font_info->ascent+font_info->descent;       /*/         Determine background and border colors.        */L       XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),         map_info);N       XGetPixelInfo(display,visual_info,map_info,resource_info,(Image *) NULL,         &pixel_info); 3       background_color=pixel_info.background_color; ?       border_color.red=ColorShift(pixel_info.border_color.red);%C       border_color.green=ColorShift(pixel_info.border_color.green);%A       border_color.blue=ColorShift(pixel_info.border_color.blue); =       matte_color.red=ColorShift(pixel_info.matte_color.red);nA       matte_color.green=ColorShift(pixel_info.matte_color.green);r?       matte_color.blue=ColorShift(pixel_info.matte_color.blue); E       highlight_color.red=ColorShift(pixel_info.highlight_color.red);uI       highlight_color.green=ColorShift(pixel_info.highlight_color.green);vG       highlight_color.blue=ColorShift(pixel_info.highlight_color.blue);s?       shadow_color.red=ColorShift(pixel_info.shadow_color.red); C       shadow_color.green=ColorShift(pixel_info.shadow_color.green);rA       shadow_color.blue=ColorShift(pixel_info.shadow_color.blue);      }c   /*     Allocate image structure.n   */2   montage_image=AllocateImage((ImageInfo *) NULL);&   if (montage_image == (Image *) NULL)     {hE       Warning("Unable to montage images","Memory allocation failed");S       return((Image *) NULL);e     }    montage_image->scene=1;    number_images=F     (montage_info->number_tiles-1)/(tiles_per_row*tiles_per_column)+1;#   for (i=0; i < number_images; i++)D   {s     /*!       Initialize Image structure.      */4     (void) strcpy(montage_image->filename,filename);     montage_image->columns=TC       (tile_info.width+(tile_info.x+border_width)*2)*tiles_per_row;eP     number_tiles=Min(montage_info->number_tiles,tiles_per_row*tiles_per_column);G     montage_image->rows=(tile_info.height+(tile_info.y+border_width)*2+r.       (display ? annotate_info.height+4 : 0))*J       (number_tiles/tiles_per_row+ ((number_tiles % tiles_per_row) != 0));.     if (resource_info->title != (char *) NULL)N       montage_image->rows+=((annotate_info.height+4) << 1)+(tile_info.y << 1);G     montage_image->montage=(char *) malloc(MaxTextLength*sizeof(char));      count=1;-     for (tile=0; tile < number_tiles; tile++) .       count+=strlen(images[tile]->filename)+1;A     montage_image->directory=(char *) malloc(count*sizeof(char)); F     montage_image->packets=montage_image->columns*montage_image->rows;-     montage_image->pixels=(RunlengthPacket *) L       malloc((unsigned int) montage_image->packets*sizeof(RunlengthPacket));4     if ((montage_image->montage == (char *) NULL) ||6         (montage_image->directory == (char *) NULL) ||<         (montage_image->pixels == (RunlengthPacket *) NULL))       { G         Warning("Unable to montage images","Memory allocation failed");%%         DestroyImages(montage_image);o         return((Image *) NULL);o       }x     /*       Set montage geometry.      */     x_offset=0;r     y_offset=0;n.     if (resource_info->title != (char *) NULL)C       y_offset+=((annotate_info.height+4) << 1)+(tile_info.y << 1);s#     *montage_image->directory='\0';i8     (void) sprintf(montage_image->montage,"%dx%d%+d%+d",;       (int) (tile_info.width+(tile_info.x+border_width)*2), ;       (int) (tile_info.height+(tile_info.y+border_width)*2+uA       (display ? annotate_info.height+4 : 0)),x_offset,y_offset);e     /*3       Initialize montage image to background color.      */     p=montage_image->pixels;.     for (x=0; x < montage_image->packets; x++)     { .       p->red=ColorShift(background_color.red);2       p->green=ColorShift(background_color.green);0       p->blue=ColorShift(background_color.blue);       p->index=0;        p->length=0;
       p++;     }m(     if ((display != (Display *) NULL) &&0         (resource_info->title != (char *) NULL))       { 
         /*,           Copy title to the composite image.
         */?         (void) strcpy(annotate_info.text,resource_info->title);=         annotate_info.width=N           XTextWidth(font_info,annotate_info.text,strlen(annotate_info.text));)         max_width=montage_image->columns;tD         if (((annotate_info.width+tile_info.x*2) << 1) >= max_width)           {t             /**               Label is too wide-- shorten.             */<             q=annotate_info.text+strlen(annotate_info.text);             do
             {o               *--q='\0';7               if ((int) strlen(annotate_info.text) > 2)t)                 (void) strcpy(q-2,"...");dJ               annotate_info.width=XTextWidth(font_info,annotate_info.text,,                 strlen(annotate_info.text));P             } while ((2*(annotate_info.width+(tile_info.x << 1))) >= max_width);           }I6         label_info.width=(annotate_info.width << 1)-1;8         label_info.height=(annotate_info.height << 1)-1;E         label_info.x=tile_info.x+(int) (montage_image->columns >> 1)- $           (int) annotate_info.width;#         label_info.y=tile_info.y+4;u<         (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",H           label_info.width,label_info.height,label_info.x,label_info.y);F         (void) XAnnotateImage(display,&pixel_info,&annotate_info,True,           montage_image);        }      /*.       Copy tile images to the composite image.     */     x_offset=tile_info.x;      y_offset=tile_info.y; $     if (display != (Display *) NULL)0       if (resource_info->title != (char *) NULL)E         y_offset+=((annotate_info.height+4) << 1)+(tile_info.y << 1); #     *montage_image->directory='\0'; -     for (tile=0; tile < number_tiles; tile++)      {        /*.         Copy this tile to the composite image.       */       image=images[tile];%>       (void) strcat(montage_image->directory,image->filename);3       (void) strcat(montage_image->directory,"\n");a)       status=RunlengthDecodeImage(image);        if (status == False)	         {d<           Warning("Unable to unpack image",image->filename);'           DestroyImages(montage_image); !           return((Image *) NULL); 	         }i?       if ((display != (Display *) NULL) && (border_width != 0))r	         {a           ColorPacket              black;             Imagea             *bordered_image;             RectangleInfo              border_info;             /**             Put a border around the image.           */+           border_info.width=border_width-1;u,           border_info.height=border_width-1;"           if (montage_info->frame)
             {mH               border_info.width=(tile_info.width-image->columns+1) >> 1;G               border_info.height=(tile_info.height-image->rows+1) >> 1; 
             }eG           bordered_image=BorderImage(image,&border_info,&border_color);r/           if (bordered_image != (Image *) NULL)o
             {e"               DestroyImage(image);#               image=bordered_image;i
             }h           border_info.width=1;           border_info.height=1;h           black.red=0;           black.green=0;           black.blue=0;r@           bordered_image=BorderImage(image,&border_info,&black);/           if (bordered_image != (Image *) NULL)_
             { "               DestroyImage(image);#               image=bordered_image;t
             }i	         }n       /*9         Gravitate image as specified by the tile gravity.        */%       switch (resource_info->gravity)        {i         case NorthWestGravity:	         {            x=0;           y=0;           break;	         };         case NorthGravity:	         { H           x=((tile_info.width+(border_width << 1))-image->columns) >> 1;           y=0;           break;	         }r         case NorthEastGravity:	         {dA           x=(tile_info.width+(border_width << 1))-image->columns;V           y=0;           break;	         }          case WestGravity:u	         {i           x=0;F           y=((tile_info.height+(border_width << 1))-image->rows) >> 1;           break;	         }a         case ForgetGravity:=         case StaticGravity:.         case CenterGravity:          default:	         { H           x=((tile_info.width+(border_width << 1))-image->columns) >> 1;F           y=((tile_info.height+(border_width << 1))-image->rows) >> 1;           break;	         }0         case EastGravity: 	         { A           x=(tile_info.width+(border_width << 1))-image->columns;tF           y=((tile_info.height+(border_width << 1))-image->rows) >> 1;           break;	         }          case SouthWestGravity:	         {            x=0;?           y=(tile_info.height+(border_width << 1))-image->rows;o           break;	         }          case SouthGravity:	         {bH           x=((tile_info.width+(border_width << 1))-image->columns) >> 1;?           y=(tile_info.height+(border_width << 1))-image->rows;i           break;	         }(         case SouthEastGravity:	         { A           x=(tile_info.width+(border_width << 1))-image->columns; ?           y=(tile_info.height+(border_width << 1))-image->rows;            break;	         }o       }i       if (montage_info->frame)3         if ((tile_info.x > 4) && (tile_info.y > 4))            {.             Imagep               *framed_image;               RectangleInfo                frame_info;o               /*8               Put an ornamental border around this tile.             */A             frame_info.width=tile_info.width+(border_width << 1);fC             frame_info.height=tile_info.height+(border_width << 1)+d'               (annotate_info.height+4);_4             frame_info.x=(x > 0 ? x : border_width);4             frame_info.y=(y > 0 ? y : border_width);O             framed_image=FrameImage(image,&frame_info,bevel_width,&matte_color,-.               &highlight_color,&shadow_color);/             if (framed_image != (Image *) NULL)s               { $                 DestroyImage(image);#                 image=framed_image;)               }u             x=0;             y=0;           }d       /*3         Composite background image with tile image.u       */?       CompositeImage(montage_image,montage_info->compose,image,          x_offset+x,y_offset+y);n@       if ((display != (Display *) NULL) && montage_info->shadow)	         {G           register int             columns,             rows,o             shift;             /*6             Put a shadow under the tile to show depth.           */2           for (rows=0; rows < image->rows; rows++)           {uO             p=montage_image->pixels+montage_image->columns*(y_offset+y+rows+4)+i(               x_offset+x+image->columns;3             for (columns=0; columns < 4; columns++)f
             {,7               shift=((columns+rows) % 2) == 0 ? 9 : 10;;3               p->red=background_color.red >> shift; 7               p->green=background_color.green >> shift; 5               p->blue=background_color.blue >> shift;                p++;
             }            } (           for (rows=0; rows < 4; rows++)           { ;             p=montage_image->pixels+montage_image->columns*n9               (y_offset+y+image->rows+rows)+x_offset+x+4;U@             for (columns=0; columns < image->columns; columns++)
             { 7               shift=((columns+rows) % 2) == 0 ? 9 : 10; 3               p->red=background_color.red >> shift; 7               p->green=background_color.green >> shift;o5               p->blue=background_color.blue >> shift;                p++;
             }            }m	         };K       if ((display != (Display *) NULL) && (image->label != (char *) NULL))o	         {s           /*3             Copy tile label to the composite image.s           */9           (void) strcpy(annotate_info.text,image->label);i           annotate_info.width=P             XTextWidth(font_info,annotate_info.text,strlen(annotate_info.text));I           max_width=tile_info.width+(resource_info->border_width << 1)-8; /           if (annotate_info.width >= max_width),
             {                /*,                 Label is too wide-- shorten.               */>               q=annotate_info.text+strlen(annotate_info.text);               do               {                  *--q='\0';9                 if ((int) strlen(annotate_info.text) > 2)e+                   (void) strcpy(q-2,"...");sL                 annotate_info.width=XTextWidth(font_info,annotate_info.text,.                   strlen(annotate_info.text));9               } while (annotate_info.width >= max_width);b
             }u/           label_info.width=annotate_info.width;s1           label_info.height=annotate_info.height;uM           label_info.x=x_offset+((tile_info.width+(border_width << 1)) >> 1)-e'             (annotate_info.width >> 1);=            label_info.y=y_offset;#           if (!montage_info->frame)t6             label_info.y+=y+tile_info.y+image->rows+2;           elseM             label_info.y+=tile_info.height+(border_width << 1)-bevel_width-2;a>           (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",J             label_info.width,label_info.height,label_info.x,label_info.y);C           (void) XAnnotateImage(display,&pixel_info,&annotate_info,e?             (unsigned int) !montage_info->frame,montage_image);(	         }_       DestroyImage(image);*       if (((tile+1) % tiles_per_row) != 0)?         x_offset+=tile_info.width+(tile_info.x+border_width)*2;L
       else	         {l           x_offset=tile_info.x; B           y_offset+=tile_info.height+(tile_info.y+border_width)*2+3             (display ? annotate_info.height+4 : 0);>	         }      }      if (i < (number_images-1))       { 
         /*(           Allocate next image structure.
         */>         montage_image->next=AllocateImage((ImageInfo *) NULL);2         if (montage_image->next == (Image *) NULL)           { )             DestroyImages(montage_image);a#             return((Image *) NULL);t           }a>         (void) strcpy(montage_image->next->filename,filename);6         montage_image->next->file=montage_image->file;:         montage_image->next->scene=montage_image->scene+1;4         montage_image->next->previous=montage_image;*         montage_image=montage_image->next;         images+=number_tiles;t1         montage_info->number_tiles-=number_tiles;e       }    }o$   free((char *) annotate_info.text);"   if (display != (Display *) NULL)     {t       /*         Free X resources.r       */#       XFreeFont(display,font_info);g"       XFree((char *) visual_info);       XFree((char *) map_info);e     } 3   while (montage_image->previous != (Image *) NULL)r*     montage_image=montage_image->previous;   return(montage_image); }e m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             % O %                                                                             %wO %                                                                             %aO %   X Q u e r y P o s i t i o n                                               % O %                                                                             % O %                                                                             % O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %cL %  Function XQueryPosition gets the pointer coodinates relative to a window. % / %  The format of the XQueryPosition routine is:  % ' %    XQueryPosition(display,window,x,y); % + %  A description of each parameter follows:s % E %    o display: Specifies a connection to an X server;  returned fromp %      XOpenDisplay. %e/ %    o window: Specifies a pointer to a Window.i %xN %    o x: Return the x coordinate of the pointer relative to the origin of the %      window. %lN %    o y: Return the y coordinate of the pointer relative to the origin of the %      window. %  %  */' void XQueryPosition(display,window,x,y)  Displayw   *display;    Window	   window;m   intl   *x,+   *y;  {    int      x_root,e     y_root;i     unsigned int	     mask;=     Window     root_window;  P   (void) XQueryPointer(display,window,&root_window,&root_window,&x_root,&y_root,     x,y,&mask);> }r _ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %bO %                                                                             % O %                                                                             % O %   X R e f r e s h W i n d o w                                               % O %                                                                             %eO %                                                                             %)O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i % < %  Function XRefreshWindow refreshes an image in a X window. %f/ %  The format of the XRefreshWindow routine is:s %.+ %      XRefreshWindow(display,window,event)  % + %  A description of each parameter follows:S %tE %    o display: Specifies a connection to an X server;  returned fromd %      XOpenDisplay. %/> %    o window: Specifies a pointer to a XWindowInfo structure. %gH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.  %  %  */) void XRefreshWindow(display,window,event)  Displayg   *display;    XWindowInfo 
   *window;   XEvent	   *event;; {    into     x,     y;     unsigned int     height, 
     width;     if (event != (XEvent *) NULL)g     {e       /*-         Determine geometry from expose event.a       */       x=event->xexpose.x;h       y=event->xexpose.y;t!       width=event->xexpose.width;e#       height=event->xexpose.height;a     }a   else     {        XEvent         sans_event;          /*A         Refresh entire window; discard outstanding expose events.        */
       x=0;
       y=0;       width=window->width;       height=window->height;L       while (XCheckTypedWindowEvent(display,window->id,Expose,&sans_event));     },   /*     Check boundary conditions.   */4   if ((window->ximage->width-(x+window->x)) < width).     width=window->ximage->width-(x+window->x);6   if ((window->ximage->height-(y+window->y)) < height)0     height=window->ximage->height-(y+window->y);   /*     Refresh image.   */F   XSetClipMask(display,window->annotate_context,window->matte_pixmap);&   if (window->pixmap != (Pixmap) NULL)     {l       if (window->depth > 1)M         XCopyArea(display,window->pixmap,window->id,window->annotate_context,a4           x+window->x,y+window->y,width,height,x,y);
       elseO         XCopyPlane(display,window->pixmap,window->id,window->highlight_context, 7           x+window->x,y+window->y,width,height,x,y,1L);(     }t   else     {  #ifdef HasSharedMemory        if (window->shared_memory)	         { C           XShmPutImage(display,window->id,window->annotate_context, J             window->ximage,x+window->x,y+window->y,x,y,width,height,True);           XSync(display,False); 	         }t #endif!       if (!window->shared_memory) M         XPutImage(display,window->id,window->annotate_context,window->ximage,e4           x+window->x,y+window->y,x,y,width,height);     } 6   XSetClipMask(display,window->annotate_context,None); }a i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             % O %                                                                             % O %                                                                             %%O %   X R e t a i n W i n d o w C o l o r s                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XRetainWindowColors sets X11 color resources on a window.  This I %  perserves the colors associated with an image displayed on the window.  % 4 %  The format of the XRetainWindowColors routine is: % * %      XRetainWindowColors(display,window) %%+ %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %W> %    o window: Specifies a pointer to a XWindowInfo structure. %f %a */( void XRetainWindowColors(display,window) Displayn   *display;A   Window	   window;p {m   Atom
     property;      Pixmap     pixmap;o     /*     Put property on the window.    */5   property=XInternAtom(display,"_XSETROOT_ID",False);e   if (property == (Atom) NULL)     { <       Warning("Unable to create X property","_XSETROOT_ID");
       return;e     } -   pixmap=XCreatePixmap(display,window,1,1,1);    if (pixmap == (Pixmap) NULL)     {l9       Warning("Unable to create X pixmap",(char *) NULL); 
       return;o     }fG   XChangeProperty(display,window,property,XA_PIXMAP,32,PropModeReplace,c!     (unsigned char *) &pixmap,1);n-   XSetCloseDownMode(display,RetainPermanent);( }p , /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %PO %                                                                             %sO %                                                                             % O %   X S e l e c t W i n d o w                                                 %wO %                                                                             %iO %                                                                             %_O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%d % O %  Function XSelectWindow allows a user to select a window using the mouse.  IfiH %  the mouse moves, a cropping rectangle is drawn and the extents of the4 %  rectangle is returned in the crop_info structure. %a/ %  The format of the XSelectWindow function is:X %g5 %      target_window=XSelectWindow(display,crop_info)  %d+ %  A description of each parameter follows:w %a3 %    o window: XSelectWindow returns the window id.d %>L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %fG %    o crop_info: Specifies a pointer to a RectangleInfo structure.  Itd6 %      contains the extents of any cropping rectangle. %  %d */' Window XSelectWindow(display,crop_info)w Display_   *display;=  
 RectangleInfod
   *crop_info;o {.) #define MinimumCropArea  (unsigned int) 9e     Cursor     target_cursor;     GC     annotate_context;s     int>     presses,     status,v
     x_offset,u
     y_offset;>     Window     root_window,     target_window;     XEvent
     event;     XGCValuesi     context_values;>     /*     Initialize graphic context.p   */;   root_window=XRootWindow(display,XDefaultScreen(display));eI   context_values.background=XBlackPixel(display,XDefaultScreen(display));iI   context_values.foreground=XWhitePixel(display,XDefaultScreen(display));*#   context_values.function=GXinvert;)   context_values.plane_mask=:     context_values.background ^ context_values.foreground;1   context_values.subwindow_mode=IncludeInferiors;tN   annotate_context=XCreateGC(display,root_window,GCBackground | GCForeground |@     GCFunction | GCPlaneMask | GCSubwindowMode,&context_values);$   if (annotate_context == (GC) NULL)     return(False);   /*)     Grab the pointer using target cursor.h   */0   target_cursor=XMakeCursor(display,root_window,G     XDefaultColormap(display,XDefaultScreen(display)),"white","black");m>   status=XGrabPointer(display,root_window,False,(unsigned int)J     (ButtonPressMask | ButtonReleaseMask | ButtonMotionMask),GrabModeSync,9     GrabModeAsync,root_window,target_cursor,CurrentTime);r   if (status != GrabSuccess)4     Error("Unable to grab the mouse",(char *) NULL);   /*     Select a window.   */   crop_info->width=0;o   crop_info->height=0;   presses=0;   target_window=(Window) NULL;
   x_offset=0; 
   y_offset=0;t   do   {s@     if ((crop_info->width*crop_info->height) >= MinimumCropArea)G       XDrawRectangle(display,root_window,annotate_context,crop_info->x,i=         crop_info->y,crop_info->width-1,crop_info->height-1);b     /*       Allow another event.     */2     XAllowEvents(display,SyncPointer,CurrentTime);J     XWindowEvent(display,root_window,ButtonPressMask | ButtonReleaseMask |       ButtonMotionMask,&event);v@     if ((crop_info->width*crop_info->height) >= MinimumCropArea)G       XDrawRectangle(display,root_window,annotate_context,crop_info->x,%=         crop_info->y,crop_info->width-1,crop_info->height-1);      switch (event.type)      {        case ButtonPress:        { +         if (target_window == (Window) NULL)            { 2             target_window=event.xbutton.subwindow;/             if (target_window == (Window) NULL) (               target_window=root_window;           } &         x_offset=event.xbutton.x_root;&         y_offset=event.xbutton.y_root;         crop_info->x=x_offset;         crop_info->y=y_offset;         crop_info->width=0;          crop_info->height=0;         presses++;         break;       }        case ButtonRelease:%       {%         presses--;         break;       }%       case MotionNotify:       {H
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));s%         crop_info->x=event.xmotion.x;d%         crop_info->y=event.xmotion.y; 
         /*$           Check boundary conditions.
         */$         if (crop_info->x < x_offset)B           crop_info->width=(unsigned int) (x_offset-crop_info->x);         else           {sD             crop_info->width=(unsigned int) (crop_info->x-x_offset);"             crop_info->x=x_offset;           }a$         if (crop_info->y < y_offset)C           crop_info->height=(unsigned int) (y_offset-crop_info->y);          else           {(E             crop_info->height=(unsigned int) (crop_info->y-y_offset); "             crop_info->y=y_offset;           }        }e       default:         break;     }(   }a<   while ((target_window == (Window) NULL) || (presses > 0));&   XUngrabPointer(display,CurrentTime);%   XFreeCursor(display,target_cursor);%$   XFreeGC(display,annotate_context);=   if ((crop_info->width*crop_info->height) < MinimumCropArea)      {        crop_info->width=0;        crop_info->height=0;     } :   if ((crop_info->width != 0) && (crop_info->height != 0))     target_window=root_window;   return(target_window); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t C u r s o r S t a t e                                             %%O %                                                                             %iO %                                                                             %tO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % I %  Function XSetCursorState sets the  cursor state to busy, otherwise thew% %  cursor are reset to their default.s %c1 %  The format of the XXSetCursorState routine is:i %r- %      XSetCursorState(display,windows,state): %e+ %  A description of each parameter follows:. %tE %    o display: Specifies a connection to an X server;  returned from/ %      XOpenDisplay. %i< %    o windows: Specifies a pointer to a XWindows structure. %lF %    o state: An unsigned integer greater than 0 sets the cursor state@ %      to busy, otherwise the cursor are reset to their default. %i %_ */+ void XSetCursorState(display,windows,state)e Displayw   *display;e   XWindows   *windows;x   unsigned int   state; {h   if (state)     {iJ       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);F       XDefineCursor(display,windows->pan.id,windows->pan.busy_cursor);N       XDefineCursor(display,windows->magnify.id,windows->magnify.busy_cursor);N       XDefineCursor(display,windows->command.id,windows->command.busy_cursor);     }    else     { E       XDefineCursor(display,windows->image.id,windows->image.cursor); A       XDefineCursor(display,windows->pan.id,windows->pan.cursor); I       XDefineCursor(display,windows->magnify.id,windows->magnify.cursor); I       XDefineCursor(display,windows->command.id,windows->command.cursor);      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %%O %                                                                             %sO %   X V i s u a l C l a s s N a m e                                           %uO %                                                                             %pO %                                                                             %nO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%: %eI %  Function XVisualClassName returns the visual class name as a charactero
 %  string. %b1 %  The format of the XVisualClassName routine is:s %e* %      visual_type=XVisualClassName(class) % + %  A description of each parameter follows:  % L %    o visual_type: XVisualClassName returns the visual class as a character %      string. %o) %    o class: Specifies the visual class.* %  %d */ char *XVisualClassName(class)m int    class; {c   switch (class)   {g*     case StaticGray: return("StaticGray");(     case GrayScale: return("GrayScale");,     case StaticColor: return("StaticColor");,     case PseudoColor: return("PseudoColor");(     case TrueColor: return("TrueColor");,     case DirectColor: return("DirectColor");   }0!   return("unknown visual class");0 }x   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%0O %                                                                             % O %                                                                             %tO %                                                                             % O %   X W i n d o w B y I D                                                     % O %                                                                             %xO %                                                                             %0O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%X %aN %  Function XWindowByID locates a child window with a given ID.  If not windowK %  with the given name is found, 0 is returned.   Only the window specified # %  and its subwindows are searched.( %u- %  The format of the XWindowByID function is:) % + %      child=XWindowByID(display,window,id)N %)+ %  A description of each parameter follows:_ %o? %    o child: XWindowByID returns the window with the specified,; %      id.  If no windows are found, XWindowByID returns 0.a %&L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %(4 %    o id: Specifies the id of the window to locate. %% %% */* Window XWindowByID(display,root_window,id) Display%   *display;    Window   root_window;  
 unsigned long    id;  {    register int     i;     unsigned int     number_children;     Window
     child,     *children,     window;      if (root_window == id)     return(id); P   if (!XQueryTree(display,root_window,&child,&child,&children,&number_children))     return((Window) NULL);   window=(Window) NULL; %   for (i=0; i < number_children; i++)    {      /*+       Search each child and their children.      *//     window=XWindowByID(display,children[i],id);       if (window != (Window) NULL)       break;   })"   if (children != (Window *) NULL)     XFree((void *) children);%   return(window);  }F t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %sO %                                                                             %)O %                                                                             %MO %   X W i n d o w B y N a m e                                                 %rO %                                                                             %nO %                                                                             %pO %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %aJ %  Function XWindowByName locates a window with a given name on a display.I %  If no window with the given name is found, 0 is returned. If more than K %  one window has the given name, the first one is returned.  Only root andd %  its children are searched.i %X/ %  The format of the XWindowByName function is:h %i5 %      window=XWindowByName(display,root_window,name)u %_+ %  A description of each parameter follows:  %i3 %    o window: XWindowByName returns the window id.m % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %t8 %    o root_window: Specifies the id of the root window. %n8 %    o name: Specifies the name of the window to locate. %y %r */. Window XWindowByName(display,root_window,name) Displayu   *display;u   Window   root_window;   char   *name; {(   register int     i;     unsigned int     number_children;     Window     *children,
     child,     window;>     XTextProperty      window_name;  8   if (XGetWMName(display,root_window,&window_name) != 0)5     if (strcmp((char *) window_name.value,name) == 0)        return(root_window);P   if (!XQueryTree(display,root_window,&child,&child,&children,&number_children))     return((Window) NULL);   window=(Window) NULL; %   for (i=0; i < number_children; i++)e   {      /*+       Search each child and their children.o     */3     window=XWindowByName(display,children[i],name);       if (window != (Window) NULL)       break;   } "   if (children != (Window *) NULL)     XFree((void *) children);e   return(window);m }i e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %aO %                                                                             % O %                                                                             %rO %   X W i n d o w B y P r o p e r y                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m %iK %  Function XWindowByProperty locates a child window with a given property. J %  If no window with the given name is found, 0 is returned.  If more thanJ %  one window has the given property, the first one is returned.  Only the4 %  window specified and its subwindows are searched. %s3 %  The format of the XWindowByProperty function is:- %l7 %      child=XWindowByProperty(display,window,property)e %m+ %  A description of each parameter follows:m % H %    o child: XWindowByProperty returns the window id with the specifiedG %      property.  If no windows are found, XWindowByProperty returns 0.  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %e@ %    o property: Specifies the property of the window to locate. %  %( */8 static Window XWindowByProperty(display,window,property) Displayd   *display;    Window	   window;e   Atom   property;; {    Atom	     type;      int      format,f     status;c     unsigned char 
     *data;     unsigned int     i,     number_children;     unsigned long 
     after,     number_items;g     Window
     child,     *children,     parent, 	     root;   M   status=XQueryTree(display,window,&root,&parent,&children,&number_children);    if (status == 0)     return((Window) NULL);   type=(Atom) NULL;f   child=(Window) NULL;C   for (i=0; (i < number_children) && (child == (Window) NULL); i++)_   { G     status=XGetWindowProperty(display,children[i],property,0L,0L,False, G       (Atom) AnyPropertyType,&type,&format,&number_items,&after,&data);f5     if ((status == Success) && (type != (Atom) NULL))        child=children[i];   }!C   for (i=0; (i < number_children) && (child == (Window) NULL); i++) :     child=XWindowByProperty(display,children[i],property);"   if (children != (Window *) NULL)     XFree((void *) children);t   return(child); } 