 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %                  W   W  IIIII  DDDD    GGGG  EEEEE  TTTTT                   % O %                  W   W    I    D   D  G      E        T                     % O %                  W W W    I    D   D  G  GG  EEE      T                     % O %                  WW WW    I    D   D  G   G  E        T                     % O %                  W   W  IIIII  DDDD    GGGG  EEEEE    T                     % O %                                                                             % O %                X11 User Interface Routines for ImageMagick.                 % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                              September 1993                                 % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "utility.h" #include "X.h" #include "widget.h"  #include "PreRvIcccm.h"    /*   Define declarations. */- #define MatteIsActive(matte_info,position)  \ =   ((position.x >= (matte_info.x-matte_info.bevel_width)) && \ >    (position.y >= (matte_info.y-matte_info.bevel_width)) &&  \N    (position.x < (matte_info.x+matte_info.width+matte_info.bevel_width)) &&  \J    (position.y < (matte_info.y+matte_info.height+matte_info.bevel_width))) /*   State declarations.  */ #define ControlState  0x0001 #define DefaultState  0x0000 #define ExitState  0x0002 # #define InactiveWidgetState  0x0004 6 #define MaxTextWidth  (80*XTextWidth(font_info,"_",1))6 #define MinTextWidth  (26*XTextWidth(font_info,"_",1))! #define RedrawActionState  0x0008  #define RedrawListState  0x0010 ! #define RedrawWidgetState  0x0020 ( #define UpdateConfigurationState  0x0040 #define UpdateListState  0x0080    /*   Forward declarations.  */ static void ?   XDrawMatte _Declare((Display *,XWindowInfo *,XWidgetInfo *)), B   XSetBevelColor _Declare((Display *,XWindowInfo *,unsigned int)),B   XSetMatteColor _Declare((Display *,XWindowInfo *,unsigned int)),A   XSetTextColor _Declare((Display *,XWindowInfo *,unsigned int));    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function XDrawBevel "sets off" an area with a highlighted upper andH %  left bevel and a shadowed lower and right bevel.  The highlighted and' %  shadowed bevels create a 3-D effect.  % , %  The format of the XDrawBevel function is: % 1 %      XDrawBevel(display,window_info,bevel_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o bevel_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the bevel.  %  %  */6 static void XDrawBevel(display,window_info,bevel_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *bevel_info; {    int      x1,      x2,      y1,      y2;      unsigned int     bevel_width;     XPoint     points[6];     /*'     Draw upper and left beveled border.    */   x1=bevel_info->x; &   y1=bevel_info->y+bevel_info->height;%   x2=bevel_info->x+bevel_info->width;    y2=bevel_info->y; &   bevel_width=bevel_info->bevel_width;   points[0].x=x1;    points[0].y=y1;    points[1].x=x1;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2;    points[3].x=x2+bevel_width;    points[3].y=y2-bevel_width;    points[4].x=x1-bevel_width;    points[4].y=y2-bevel_width;    points[5].x=x1-bevel_width;    points[5].y=y1+bevel_width; 9   XSetBevelColor(display,window_info,bevel_info->raised); L   XFillPolygon(display,window_info->id,window_info->widget_context,points,6,     Complex,CoordModeOrigin);    /*(     Draw lower and right beveled border.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y1;    points[2].x=x2;    points[2].y=y2;    points[3].x=x2+bevel_width;    points[3].y=y2-bevel_width;    points[4].x=x2+bevel_width;    points[4].y=y1+bevel_width;    points[5].x=x1-bevel_width;    points[5].y=y1+bevel_width; I   XSetBevelColor(display,window_info,(unsigned int) !bevel_info->raised); L   XFillPolygon(display,window_info->id,window_info->widget_context,points,6,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l e d B u t t o n                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XDrawBeveledButton draws a button with a highlighted upper andH %  left bevel and a shadowed lower and right bevel.  The highlighted and' %  shadowed bevels create a 3-D effect.  % 4 %  The format of the XDrawBeveledButton function is: % : %      XDrawBeveledButton(display,window_info,button_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % G %    o button_info: Specifies a pointer to a XWidgetInfo structure.  It * %      contains the extents of the button. %  %  */? static void XDrawBeveledButton(display,window_info,button_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *button_info;  {    int      x,     y;     unsigned int
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Draw matte.    */.   XDrawBevel(display,window_info,button_info);:   XSetMatteColor(display,window_info,button_info->raised);E   XFillRectangle(display,window_info->id,window_info->widget_context, J     button_info->x,button_info->y,button_info->width,button_info->height);.   x=button_info->x-button_info->bevel_width-1;.   y=button_info->y-button_info->bevel_width-1;5   XSetForeground(display,window_info->widget_context, 1     window_info->pixel_info->trough_color.pixel); 7   if (button_info->raised || (window_info->depth == 1)) K     XDrawRectangle(display,window_info->id,window_info->widget_context,x,y, O       button_info->width+(button_info->bevel_width << 1)+1,button_info->height+ )       (button_info->bevel_width << 1)+1); )   if (button_info->text == (char *) NULL)      return;    /*     Set cropping region.   */%   crop_info.width=button_info->width; '   crop_info.height=button_info->height;    crop_info.x=button_info->x;    crop_info.y=button_info->y;    /*     Draw text.   */#   font_info=window_info->font_info; J   width=XTextWidth(font_info,button_info->text,strlen(button_info->text));:   x=button_info->x+(button_info->width >> 1)-(width >> 1);)   y=button_info->y+((button_info->height- 2     (font_info->ascent+font_info->descent)) >> 1)+#     window_info->font_info->ascent; ?   if (button_info->width == (font_info->max_bounds.width >> 1))      {        /*7         Option button-- write label to right of button.        */.       XSetTextColor(display,window_info,True);C       x=button_info->x+button_info->width+button_info->bevel_width+ +         (font_info->max_bounds.width >> 1); J       XDrawString(display,window_info->id,window_info->widget_context,x,y,5         button_info->text,strlen(button_info->text)); 
       return;      } J   XSetClipRectangles(display,window_info->widget_context,0,0,&crop_info,1,     Unsorted);9   XSetTextColor(display,window_info,button_info->raised); F   XDrawString(display,window_info->id,window_info->widget_context,x,y,1     button_info->text,strlen(button_info->text)); 9   XSetClipMask(display,window_info->widget_context,None);    if (!button_info->raised) %     XDelay(display,SuspendTime << 2);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l e d M a t t e                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function XDrawBeveledMatte draws a matte with a shadowed upper and K %  left bevel and a highlighted lower and right bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 3 %  The format of the XDrawBeveledMatte function is:  % 8 %      XDrawBeveledMatte(display,window_info,matte_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o matte_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the matte.  %  %  */= static void XDrawBeveledMatte(display,window_info,matte_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *matte_info; {    /*     Draw matte.    */-   XDrawBevel(display,window_info,matte_info); -   XDrawMatte(display,window_info,matte_info);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w M a t t e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function XDrawMatte fills a rectangular area with the matte color.  % , %  The format of the XDrawMatte function is: % 1 %      XDrawMatte(display,window_info,matte_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o matte_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the matte.  %  %  */6 static void XDrawMatte(display,window_info,matte_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *matte_info; {    /*     Draw matte.    */7   if (!matte_info->trough || (window_info->depth == 1)) J     XFillRectangle(display,window_info->id,window_info->highlight_context,H       matte_info->x,matte_info->y,matte_info->width,matte_info->height);   else     { 9       XSetForeground(display,window_info->widget_context, 5         window_info->pixel_info->trough_color.pixel); I       XFillRectangle(display,window_info->id,window_info->widget_context, J         matte_info->x,matte_info->y,matte_info->width,matte_info->height);     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w M a t t e T e x t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDrawMatteText draws a matte with text.  If the text exceeds theG %  extents of the text, a portion of the text relative to the cursor is 
 %  displayed.  % 0 %  The format of the XDrawMatteText function is: % 4 %      XDrawMatteText(display,window_info,text_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % E %    o text_info: Specifies a pointer to a XWidgetInfo structure.  It ( %      contains the extents of the text. %  %  */9 static void XDrawMatteText(display,window_info,text_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo 
   *text_info;  {    char
     *text;     int      x,     y;     register int     i;     unsigned int     height, 
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Clear the text area.   */,   XSetMatteColor(display,window_info,False);E   XFillRectangle(display,window_info->id,window_info->widget_context, B     text_info->x,text_info->y,text_info->width,text_info->height);'   if (text_info->text == (char *) NULL)      return; :   XSetTextColor(display,window_info,text_info->highlight);#   font_info=window_info->font_info; 4   x=text_info->x+(font_info->max_bounds.width >> 2);<   y=text_info->y+font_info->ascent+(text_info->height >> 2);<   width=text_info->width-(font_info->max_bounds.width >> 1);.   height=font_info->ascent+font_info->descent;   if (*text_info->text == '\0')      {        /*#         No text-- just draw cursor.        */L       XDrawLine(display,window_info->id,window_info->annotate_context,x,y+3,         x,y-height+3);
       return;      }    /*     Set cropping region.   */#   crop_info.width=text_info->width; %   crop_info.height=text_info->height;    crop_info.x=text_info->x;    crop_info.y=text_info->y;    /*,     Determine beginning of the visible text.   */,   if (text_info->cursor < text_info->marker)(     text_info->marker=text_info->cursor;   else     {        text=text_info->marker; D       if (XTextWidth(font_info,text,text_info->cursor-text) > width)	         {            text=text_info->text; 0           for (i=0; i < (int) strlen(text); i++)O             if (XTextWidth(font_info,text+i,text_info->cursor-text-i) <= width)                break;#           text_info->marker=text+i; 	         }      }    /*     Draw text and cursor.    */   if (!text_info->highlight)     { N       XSetClipRectangles(display,window_info->widget_context,0,0,&crop_info,1,         Unsorted);J       XDrawString(display,window_info->id,window_info->widget_context,x,y,5         text_info->marker,strlen(text_info->marker)); =       XSetClipMask(display,window_info->widget_context,None);      }    else     { N       XSetClipRectangles(display,window_info->annotate_context,0,0,&crop_info,         1,Unsorted);N       width=XTextWidth(font_info,text_info->marker,strlen(text_info->marker));M       XFillRectangle(display,window_info->id,window_info->annotate_context,x, *         y-font_info->ascent,width,height);?       XSetClipMask(display,window_info->annotate_context,None); O       XSetClipRectangles(display,window_info->highlight_context,0,0,&crop_info,          1,Unsorted);M       XDrawString(display,window_info->id,window_info->highlight_context,x,y, 5         text_info->marker,strlen(text_info->marker)); @       XSetClipMask(display,window_info->highlight_context,None);     }    x+= P     XTextWidth(font_info,text_info->marker,text_info->cursor-text_info->marker);H   XDrawLine(display,window_info->id,window_info->annotate_context,x,y+3,     x,y-height+3); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e E a s t                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function XDrawTriangleEast draws a triangle with a highlighted leftC %  bevel and a shadowed right and lower bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 3 %  The format of the XDrawTriangleEast function is:  % ; %      XDrawTriangleEast(display,window_info,triangle_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */@ static void XDrawTriangleEast(display,window_info,triangle_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *triangle_info;  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;   y1=triangle_info->y;+   x2=triangle_info->x+triangle_info->width; 3   y2=triangle_info->y+(triangle_info->height >> 1);    x3=triangle_info->x;,   y3=triangle_info->y+triangle_info->height;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw bottom bevel.   */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3;    points[1].y=y3;    points[2].x=x3-bevel_width;    points[2].y=y3+bevel_width;    points[3].x=x2+bevel_width;    points[3].y=y2; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw Left bevel.   */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width+1;    points[2].y=y1-bevel_width;    points[3].x=x3-bevel_width+1;    points[3].y=y3+bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw top bevel.    */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2+bevel_width;    points[2].y=y2;    points[3].x=x1-bevel_width;    points[3].y=y1-bevel_width; L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e N o r t h                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XDrawTriangleNorth draws a triangle with a highlighted left C %  bevel and a shadowed right and lower bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 4 %  The format of the XDrawTriangleNorth function is: % < %      XDrawTriangleNorth(display,window_info,triangle_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */A static void XDrawTriangleNorth(display,window_info,triangle_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *triangle_info;  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;,   y1=triangle_info->y+triangle_info->height;2   x2=triangle_info->x+(triangle_info->width >> 1);   y2=triangle_info->y;+   x3=triangle_info->x+triangle_info->width; ,   y3=triangle_info->y+triangle_info->height;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw left bevel.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2-bevel_width-2;    points[3].x=x1-bevel_width-1;    points[3].y=y1+bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw right bevel.    */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3;    points[1].y=y3;    points[2].x=x3+bevel_width;    points[2].y=y3+bevel_width;    points[3].x=x2;    points[3].y=y2-bevel_width; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw lower bevel.    */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width;    points[2].y=y1+bevel_width;    points[3].x=x3+bevel_width;    points[3].y=y3+bevel_width; L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e S o u t h                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XDrawTriangleSouth draws a border with a highlighted left and H %  right bevel and a shadowed lower bevel.  The highlighted and shadowed %  bevels create a 3-D effect. % 4 %  The format of the XDrawTriangleSouth function is: % < %      XDrawTriangleSouth(display,window_info,triangle_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */A static void XDrawTriangleSouth(display,window_info,triangle_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *triangle_info;  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;   y1=triangle_info->y;2   x2=triangle_info->x+(triangle_info->width >> 1);,   y2=triangle_info->y+triangle_info->height;+   x3=triangle_info->x+triangle_info->width;    y3=triangle_info->y;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw top bevel.    */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width;    points[2].y=y1-bevel_width;    points[3].x=x3+bevel_width;    points[3].y=y3-bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw right bevel.    */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3+1;    points[1].y=y3-bevel_width;    points[2].x=x3+bevel_width;    points[2].y=y3-bevel_width;    points[3].x=x2;    points[3].y=y2+bevel_width; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw left bevel.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2+bevel_width;    points[3].x=x1-bevel_width;    points[3].y=y1-bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w W i d g e t T e x t                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XDrawWidgetText first clears the widget and draws a text string G %  justifed left (or center) in the x-direction and centered within the  %  y-direction.  % 1 %  The format of the XDrawWidgetText function is:  % 5 %      XDrawWidgetText(display,window_info,text_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % C %    o window_info: Specifies a pointer to a XWindowText structure.  % ? %    o text_info: Specifies a pointer to XWidgetInfo structure.  %  %  */: static void XDrawWidgetText(display,window_info,text_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo 
   *text_info;  {    GC     widget_context;      int      x,     y;     unsigned int     height, 
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Clear the text area.   *//   widget_context=window_info->annotate_context;    if (text_info->raised)A     XClearArea(display,window_info->id,text_info->x,text_info->y, 0       text_info->width,text_info->height,False);   else     { I       XFillRectangle(display,window_info->id,widget_context,text_info->x, 9         text_info->y,text_info->width,text_info->height); 4       widget_context=window_info->highlight_context;     } '   if (text_info->text == (char *) NULL)      return;    if (*text_info->text == '\0')      return;    /*     Set cropping region.   */#   font_info=window_info->font_info; #   crop_info.width=text_info->width; %   crop_info.height=text_info->height;    crop_info.x=text_info->x;    crop_info.y=text_info->y;    /*     Draw text.   */F   width=XTextWidth(font_info,text_info->text,strlen(text_info->text));4   x=text_info->x+(font_info->max_bounds.width >> 1);   if (text_info->center)8     x=text_info->x+(text_info->width >> 1)-(width >> 1);=   if (width > (text_info->width-font_info->max_bounds.width)) <     x+=(text_info->width-font_info->max_bounds.width-width);.   height=font_info->ascent+font_info->descent;E   y=text_info->y+((text_info->height-height) >> 1)+font_info->ascent; G   XSetClipRectangles(display,widget_context,0,0,&crop_info,1,Unsorted); 9   XDrawString(display,window_info->id,widget_context,x,y, -     text_info->text,strlen(text_info->text)); ,   XSetClipMask(display,widget_context,None);   if (x < text_info->x) D     XDrawLine(display,window_info->id,window_info->annotate_context,O       text_info->x,text_info->y,text_info->x,text_info->y+text_info->height-1);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X E d i t T e x t                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XEditText edits a text string as indicated by the key symbol.  % + %  The format of the XEditText function is:  % 9 %      XEditText(display,text_info,key_symbol,text,state)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % E %    o text_info: Specifies a pointer to a XWidgetInfo structure.  It ( %      contains the extents of the text. % H %    o key_symbol:  A X11 KeySym that indicates what editing function to %      perform to the text.  % 8 %    o text: A character string to insert into the text. % J %    o state:  An unsigned long that indicates whether the key symbol is a  %      control character or not. %  %  */> static void XEditText(display,text_info,key_symbol,text,state) Display    *display;    XWidgetInfo 
   *text_info;    KeySym
   key_symbol;    char   *text;  
 unsigned long    state; {    switch (key_symbol)    {      case XK_BackSpace:     case XK_Delete:      {        /*         Erase one character.       *//       if (text_info->cursor != text_info->text) 	         {            text_info->cursor--;?           (void) strcpy(text_info->cursor,text_info->cursor+1); %           text_info->highlight=False;            break;	         }      }      case XK_Left:      case XK_KP_Left:     {        /*&         Move cursor one position left.       *//       if (text_info->cursor == text_info->text)          break;       text_info->cursor--;       break;     }      case XK_Right:     case XK_KP_Right:      {        /*'         Move cursor one position right.        */I       if (text_info->cursor == (text_info->text+strlen(text_info->text)))          break;       text_info->cursor++;       break;     }      default:     {        register char          *p,          *q;          register int
         i;         if (state & ControlState)          break;       if (*text == '\0')         break;=       if (((int) strlen(text_info->text)+1) >= MaxTextLength)          XBell(display,0); 
       else	         {            /**             Insert a string into the text.           */#           if (text_info->highlight) 
             {                /*.                 Erase the entire line of text.               */$               *text_info->text='\0';0               text_info->cursor=text_info->text;0               text_info->marker=text_info->text;)               text_info->highlight=False; 
             } A           q=text_info->text+strlen(text_info->text)+strlen(text); >           for (i=0; i <= (int) strlen(text_info->cursor); i++)           { #             *q=(*(q-strlen(text)));              q--;           }            p=text; 0           for (i=0; i < (int) strlen(text); i++)(             *text_info->cursor++=(*p++);	         }        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i d g e t I n f o                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Function XGetWidgetInfo initializes the XWidgetInfo structure.  % 0 %  The format of the XGetWidgetInfo function is: % ' %      XGetWidgetInfo(text,widget_info)  % + %  A description of each parameter follows:  % ? %    o text: A string of characters associated with the widget.  % G %    o widget_info: Specifies a pointer to a X11 XWidgetInfo structure.  %  %  */, static void XGetWidgetInfo(text,widget_info) char   *text;   XWidgetInfo    *widget_info;  {    /*     Initialize widget info.    */    widget_info->id=(~0);    widget_info->bevel_width=3;    widget_info->width=1;    widget_info->height=1;     widget_info->x=0;    widget_info->y=0;    widget_info->min_y=0;    widget_info->max_y=0;    widget_info->raised=True;    widget_info->active=False;     widget_info->center=False;     widget_info->trough=False;      widget_info->highlight=False;    widget_info->text=text;    widget_info->cursor=text;    if (text != (char *) NULL) '      widget_info->cursor+=strlen(text);     widget_info->marker=text; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X H i g h l i g h t W i d g e t                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XHighlightWidget draws a highlighted border around a window. % 2 %  The format of the XHighlightWidget function is: % 0 %      XHighlightWidget(display,window_info,x,y) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % G %    o x: Specifies an integer representing the rectangle offset in the  %      x-direction.  % G %    o y: Specifies an integer representing the rectangle offset in the  %      y-direction.  %  %  */5 static void XHighlightWidget(display,window_info,x,y)  Display    *display;    XWindowInfo    *window_info;    int    x,   y; {    /*+     Draw the widget highlighting rectangle.    */+   XSetBevelColor(display,window_info,True); I   XDrawRectangle(display,window_info->id,window_info->widget_context,x,y, >     window_info->width-(x << 1),window_info->height-(y << 1));M   XDrawRectangle(display,window_info->id,window_info->widget_context,x-1,y-1, B     window_info->width-(x << 1)+1,window_info->height-(y << 1)+1);,   XSetBevelColor(display,window_info,False);M   XDrawRectangle(display,window_info->id,window_info->widget_context,x-1,y-1, >     window_info->width-(x << 1),window_info->height-(y << 1));?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S c r e e n E v e n t                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XScreenEvent returns True if the any event on the X server queue( %  is associated with the widget window. % . %  The format of the XScreenEvent function is: % ' %      XScreenEvent(display,event,data)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % < %    o event: Specifies a pointer to a X11 XEvent structure. % 9 %    o data: Specifies a pointer to a XWindows structure.  %  %  */+ static int XScreenEvent(display,event,data)  Display    *display;    XEvent	   *event;    char   *data; { 
   XWindows
     *windows;      windows=(XWindows *) data;.   if (event->xany.window == windows->popup.id)     { #       if (event->type == MapNotify) #         windows->popup.mapped=True; %       if (event->type == UnmapNotify) $         windows->popup.mapped=False;       return(True);      } /   if (event->xany.window == windows->widget.id)      { #       if (event->type == MapNotify) $         windows->widget.mapped=True;%       if (event->type == UnmapNotify) %         windows->widget.mapped=False;        return(True);      }    switch (event->type)   {      case ButtonPress:      { /       if ((event->xbutton.button == Button3) && ,           (event->xbutton.state & Mod1Mask))	         {            /*+             Convert Alt-Button3 to Button2.            */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         }        return(True);      }      case Expose:     { 5       if (event->xexpose.window == windows->image.id) 	         { 8           XRefreshWindow(display,&windows->image,event);           break;	         } 7       if (event->xexpose.window == windows->magnify.id) &         if (event->xexpose.count == 0)&           if (windows->magnify.mapped)
             { 1               XMakeMagnifyImage(display,windows);                break;
             }         if (event->type == Expose)	         { F           (void) XCommandWidget(display,windows,(char **) NULL,event);           break;	         }        break;     }      case FocusOut:     {        /*,         Set input focus for backdrop window.       */4       if (event->xfocus.window == windows->image.id)K         XSetInputFocus(display,windows->image.id,RevertToNone,CurrentTime);        return(True);      }      case ButtonRelease:      case KeyPress:     case KeyRelease:     case MotionNotify:     case SelectionNotify:        return(True);      default:       break;   }    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t B e v e l C o l o r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XSetBevelColor sets the graphic context for drawing a beveled 
 %  border. % 0 %  The format of the XSetBevelColor function is: % 1 %      XSetBevelColor(display,window_info,raised)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % D %    o raised: A value other than zero indicates the color show be a> %      "highlight" color, otherwise the "shadow" color is set. %  %  */6 static void XSetBevelColor(display,window_info,raised) Display    *display;    XWindowInfo    *window_info;    unsigned int	   raised;  {    if (window_info->depth == 1)     {        Pixmap         stipple;         /*         Monochrome window.       */9       XSetBackground(display,window_info->widget_context, 2         XBlackPixel(display,window_info->screen));9       XSetForeground(display,window_info->widget_context, 2         XWhitePixel(display,window_info->screen));L       XSetFillStyle(display,window_info->widget_context,FillOpaqueStippled);-       stipple=window_info->highlight_stipple;        if (!raised),         stipple=window_info->shadow_stipple;?       XSetStipple(display,window_info->widget_context,stipple);      }    else     if (raised) 9       XSetForeground(display,window_info->widget_context, 8         window_info->pixel_info->highlight_color.pixel);     else9       XSetForeground(display,window_info->widget_context, 5         window_info->pixel_info->shadow_color.pixel);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t M a t t e C o l o r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XSetMatteColor sets the graphic context for drawing the matte. % 0 %  The format of the XSetMatteColor function is: % 1 %      XSetMatteColor(display,window_info,raised)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % E %    o raised: A value other than zero indicates the matte is active.  %  %  */6 static void XSetMatteColor(display,window_info,raised) Display    *display;    XWindowInfo    *window_info;    unsigned int	   raised;  {    if (window_info->depth == 1)     {        /*         Monochrome window.       */       if (raised) ;         XSetForeground(display,window_info->widget_context, 4           XWhitePixel(display,window_info->screen));
       else;         XSetForeground(display,window_info->widget_context, 4           XBlackPixel(display,window_info->screen));     }    else     if (raised) 9       XSetForeground(display,window_info->widget_context, 4         window_info->pixel_info->matte_color.pixel);     else9       XSetForeground(display,window_info->widget_context, 4         window_info->pixel_info->depth_color.pixel); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t T e x t C o l o r                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XSetTextColor sets the graphic context for drawing text on a	 %  matte.  % / %  The format of the XSetTextColor function is:  % 0 %      XSetTextColor(display,window_info,raised) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % D %    o raised: A value other than zero indicates the color show be a> %      "highlight" color, otherwise the "shadow" color is set. %  %  */5 static void XSetTextColor(display,window_info,raised)  Display    *display;    XWindowInfo    *window_info;    unsigned int	   raised;  {    if (window_info->depth == 1)     {        /*         Monochrome window.       */       if (raised) ;         XSetForeground(display,window_info->widget_context, 4           XBlackPixel(display,window_info->screen));
       else;         XSetForeground(display,window_info->widget_context, 4           XWhitePixel(display,window_info->screen));     }    else7     XSetForeground(display,window_info->widget_context, 7       window_info->pixel_info->foreground_color.pixel);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r B r o w s e r W i d g e t                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XColorBrowserWidget displays a Widget widget with a color query toK %  the user.  The user keys a reply and presses the Action or Cancel button H %  to exit.  The typed text is returned as the reply function parameter. % 4 %  The format of the XColorBrowserWidget routine is: % 6 %    XColorBrowserWidget(display,windows,action,reply) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % G %    o reply: The response from the user is returned in this parameter.  %  %  */6 void XColorBrowserWidget(display,windows,action,reply) Display    *display;    XWindows   *windows;    char
   *action,	   *reply;  { " #define CancelButtonText  "Cancel" #define ColornameText  "Name:"$ #define ColorPatternText  "Pattern:" #define GrabButtonText  "Grab"  #define ResetButtonText  "Reset"     char     **colorlist,%     primary_selection[MaxTextLength], !     reset_pattern[MaxTextLength],      text[MaxTextLength];     int      colors,      x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextLength] = "*";     unsigned int     height,      status,      text_width,      visible_colors, 
     width;     unsigned long 
     delay,
     state;     XColor
     color;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     expose_info,     grab_info,     list_info,     mode_info,     north_info,      reply_info,      reset_info,      scroll_info,     selection_info,      slider_info,     south_info,      text_info;     XWindowChanges     window_changes;      /*/     Get color list and sort in ascending order.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);#   (void) strcpy(reset_pattern,"*"); -   colorlist=ListColors(glob_pattern,&colors); "   if (colorlist == (char **) NULL)     {        /*.         Pattern failed, obtain all the colors.       */&       (void) strcpy(glob_pattern,"*");1       colorlist=ListColors(glob_pattern,&colors); &       if (colorlist == (char **) NULL)	         { I           XNoticeWidget(display,windows,"Unable to obtain colors names:",              glob_pattern);J           XDialogWidget(display,windows,action,"Enter color name:",reply);           return; 	         }      }    /*'     Determine Widget widget attributes.    */&   font_info=windows->widget.font_info;   text_width=0;    for (i=0; i < colors; i++)M     if (XTextWidth(font_info,colorlist[i],strlen(colorlist[i])) > text_width) I       text_width=XTextWidth(font_info,colorlist[i],strlen(colorlist[i])); 4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));L   if (XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText)) > width)H     width=XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText));J   if (XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText));%   width+=font_info->max_bounds.width; N   if (XTextWidth(font_info,ColorPatternText,strlen(ColorPatternText)) > width)J     width=XTextWidth(font_info,ColorPatternText,strlen(ColorPatternText));H   if (XTextWidth(font_info,ColornameText,strlen(ColornameText)) > width)D     width=XTextWidth(font_info,ColornameText,strlen(ColornameText));.   height=font_info->ascent+font_info->descent;   /*     Position Widget widget.    */   windows->widget.width=E     width+Min(text_width,MaxTextWidth)+6*font_info->max_bounds.width; M   windows->widget.min_width=width+MinTextWidth+4*font_info->max_bounds.width; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;   windows->widget.height= A     ((81*height) >> 2)+((13*font_info->max_bounds.width) >> 1)+4;    windows->widget.min_height= A     ((23*height) >> 1)+((13*font_info->max_bounds.width) >> 1)+4; :   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2); 4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Widget widget.   */B   (void) strcpy(windows->widget.name,"Browse and Select a Color");I   (void) XStringListToTextProperty(&windows->widget.name,1,&window_name); 6   XSetWMName(display,windows->widget.id,&window_name);-   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_colors=0;    delay=SuspendTime << 2; !   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)        {          int 
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; >         cancel_info.x=windows->widget.width-cancel_info.width-(           font_info->max_bounds.width-2;@         cancel_info.y=windows->widget.height-cancel_info.height-&           font_info->max_bounds.width;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; 7         action_info.x=cancel_info.x-(cancel_info.width+ M           (font_info->max_bounds.width >> 1)+(action_info.bevel_width << 1)); $         action_info.y=cancel_info.y;2         XGetWidgetInfo(GrabButtonText,&grab_info);         grab_info.width=width;)         grab_info.height=(3*height) >> 1; 0         grab_info.x=font_info->max_bounds.width;B         grab_info.y=((5*font_info->max_bounds.width) >> 1)+height;4         XGetWidgetInfo(ResetButtonText,&reset_info);         reset_info.width=width; *         reset_info.height=(3*height) >> 1;1         reset_info.x=font_info->max_bounds.width; N         reset_info.y=grab_info.y+grab_info.height+font_info->max_bounds.width;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; 5         reply_info.width=windows->widget.width-width- 1           ((6*font_info->max_bounds.width) >> 1); &         reply_info.height=height << 1;>         reply_info.x=width+(font_info->max_bounds.width << 1);         reply_info.y= F           action_info.y-reply_info.height-font_info->max_bounds.width;
         /*&           Initialize mode information.
         */1         XGetWidgetInfo((char *) NULL,&mode_info);           mode_info.bevel_width=0;O         mode_info.width=action_info.x-reply_info.x-font_info->max_bounds.width; ,         mode_info.height=action_info.height;!         mode_info.x=reply_info.x; "         mode_info.y=action_info.y;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height;          scroll_info.height= F           reply_info.y-grab_info.y-(font_info->max_bounds.width >> 1);H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);9         scroll_info.y=grab_info.y-reply_info.bevel_width; !         scroll_info.raised=False;           scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True; 8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1; -         north_info.x+=north_info.bevel_width; -         north_info.y+=north_info.bevel_width;          south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2; P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_colors= A           (scroll_info.height-(height >> 3)-4)/((9*height) >> 3); $         if (colors > visible_colors)H           slider_info.height=(visible_colors*slider_info.height)/colors;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;         list_info.width=H           scroll_info.x-reply_info.x-(font_info->max_bounds.width >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)$           for (i=0; i < colors; i++)0             if (strcmp(colorlist[i],reply) == 0)               list_info.id=i; 
         /*&           Initialize text information.
         */(         XGetWidgetInfo(text,&text_info);)         text_info.width=reply_info.width;           text_info.height=height;C         text_info.x=list_info.x-(font_info->max_bounds.width >> 1); 0         text_info.y=font_info->max_bounds.width;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*&           Redraw Color Browser window.
         */&         x=font_info->max_bounds.width;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,9           x,y,ColorPatternText,strlen(ColorPatternText)); 9         (void) sprintf(text_info.text,"%s",glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info); @         XDrawBeveledButton(display,&windows->widget,&grab_info);A         XDrawBeveledButton(display,&windows->widget,&reset_info); ?         XDrawBeveledMatte(display,&windows->widget,&list_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info); &         x=font_info->max_bounds.width;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,3           x,y,ColornameText,strlen(ColornameText)); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);7         XHighlightWidget(display,&windows->widget,4,4);          selection_info.id=(~0); !         state|=RedrawActionState;          state|=RedrawListState; $         state&=(~RedrawWidgetState);       }       if (state & UpdateListState)       {          char           **checklist;           int            number_colors;  F         status=XParseColor(display,windows->widget.map_info->colormap,           glob_pattern,&color);          if (status != 0)           {              /*2               Reply is a single color name-- exit.             */.             (void) strcpy(reply,glob_pattern);6             (void) strcpy(glob_pattern,reset_pattern);%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 
         /*           Update color list.
         */:         checklist=ListColors(glob_pattern,&number_colors);         if (number_colors == 0)            { 6             (void) strcpy(glob_pattern,reset_pattern);             XBell(display,0);            }          else           { &             for (i=0; i < colors; i++)*               free((char *) colorlist[i]);,             if (colorlist != (char **) NULL)'               free((char *) colorlist);               colorlist=checklist;!             colors=number_colors;            } 
         /*-           Sort color list in ascending order. 
         */         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;$         if (colors > visible_colors)H           slider_info.height=(visible_colors*slider_info.height)/colors;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0; (         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);          list_info.id=(~0);         state|=RedrawListState; 
         /*$           Redraw color name & reply.
         */         *reply_info.text='\0';*         reply_info.cursor=reply_info.text;9         (void) sprintf(text_info.text,"%s",glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info); =         XDrawMatteText(display,&windows->widget,&reply_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info); 7         XHighlightWidget(display,&windows->widget,4,4); "         state&=(~UpdateListState);       }       if (state & RedrawListState)       { 
         /*+           Determine slider id and position. 
         */<         if (slider_info.id >= (int) (colors-visible_colors))/           slider_info.id=colors-visible_colors; ?         if ((slider_info.id < 0) || (colors <= visible_colors))            slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (colors > 0)            slider_info.y+= J             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/colors;0         if (slider_info.id != selection_info.id)           {              /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; .             for (i=0; i < visible_colors; i++)
             { G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;.               if ((slider_info.id+i) < colors)@                 selection_info.text=colorlist[slider_info.id+i];H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }              else               { ?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               } E             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info); (             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       } "     if (state & RedrawActionState)       { 
         /*7           Display the selected color in a drawing area. 
         */6         color=windows->widget.pixel_info->matte_color;F         (void) XParseColor(display,windows->widget.map_info->colormap,D           reply_info.text,&windows->widget.pixel_info->matte_color);N         XBestPixel(display,windows->widget.map_info->colormap,(XColor *) NULL,D           (unsigned int) windows->widget.visual_info->colormap_size,4           &windows->widget.pixel_info->matte_color);@         XDrawBeveledButton(display,&windows->widget,&mode_info);6         windows->widget.pixel_info->matte_color=color;$         state&=(~RedrawActionState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */               slider_info.id--; %               state|=RedrawListState; 
             }          if (!south_info.raised) &           if (slider_info.id < colors)
             {                /*!                 Move slider down.                */               slider_info.id++; %               state|=RedrawListState; 
             } (         if (event.type != ButtonRelease)           continue;        }      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(slider_info,event.xbutton))            {              /*               Track slider.              */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;                break;
             } 4         if (MatteIsActive(south_info,event.xbutton))&           if (slider_info.id < colors)
             {                /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;                break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))            {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)1               slider_info.id-=(visible_colors-1);              else1               slider_info.id+=(visible_colors-1); #             state|=RedrawListState;              break;           } 3         if (MatteIsActive(list_info,event.xbutton))            {              unsigned int               id;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= colors)                break;9             (void) strcpy(reply_info.text,colorlist[id]); '             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info); %             state|=RedrawActionState; #             if (id == list_info.id)                { <                 (void) strcpy(glob_pattern,reply_info.text);'                 state|=UpdateListState;                } #             selection_info.id=(~0);              list_info.id=id;#             state|=RedrawListState;              break;           } 3         if (MatteIsActive(grab_info,event.xbutton))            {              /*'               User pressed Grab button.              */#             grab_info.raised=False; D             XDrawBeveledButton(display,&windows->widget,&grab_info);             break;           } 4         if (MatteIsActive(reset_info,event.xbutton))           {              /*(               User pressed Reset button.             */$             reset_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } 5         if (MatteIsActive(action_info,event.xbutton))            {              /*)               User pressed action button.              */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {              static Time                click_time;                /*;               Move text cursor to position of button press.              */N             x=event.xbutton.x-reply_info.x-(font_info->max_bounds.width >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;                } A             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;         if (!north_info.raised)            {              /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);            }          if (!south_info.raised)            {              /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);            }          if (slider_info.active)            {              /*#               Stop tracking slider.              */%             slider_info.active=False;              break;           }          if (!grab_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) 9               if (MatteIsActive(grab_info,event.xbutton))                  {                    unsigned int                     status;                      XColor                     color;                     /*9                     Select a pen color from the X server.                    */9                   status=XGetWindowColor(display,&color); &                   if (status != False)                     { E                       (void) sprintf(reply_info.text,"#%02x%02x%02x", F                         ColorShift(color.red),ColorShift(color.green),0                         ColorShift(color.blue));8                       reply_info.marker=reply_info.text;P                       reply_info.cursor=reply_info.text+strlen(reply_info.text);K                       XDrawMatteText(display,&windows->widget,&reply_info); /                       state|=RedrawActionState;                      }                  } "             grab_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&grab_info);           }          if (!reset_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) :               if (MatteIsActive(reset_info,event.xbutton))                 { <                   (void) strcpy(glob_pattern,reset_pattern);)                   state|=UpdateListState;                  } #             reset_info.raised=True; E             XDrawBeveledButton(display,&windows->widget,&reset_info);            }           if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0') #                   XBell(display,0);                  else#                   state|=ExitState; $             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }           if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))                  { (                   *reply_info.text='\0';#                   state|=ExitState;                  } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;         break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            { "             *reply_info.text='\0';             state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextLength];            static int           length;            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; 2         if (MatteIsActive(scroll_info,event.xkey))           {              /*               Move slider.             */             switch (key_symbol) 
             {                case XK_Home:                case XK_KP_Home:               { !                 slider_info.id=0;                  break;               }                case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;                  break;               }                case XK_Down:                case XK_KP_Down:               { !                 slider_info.id++;                  break;               }                case XK_Prior:               case XK_KP_Prior:                { /                 slider_info.id-=visible_colors;                  break;               }                case XK_Next:                case XK_KP_Next:               { /                 slider_info.id+=visible_colors;                  break;               }                case XK_End:               case XK_KP_End:                { &                 slider_info.id=colors;                 break;               } 
             } #             state|=RedrawListState;              break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {              /*-               Read new color or glob patterm.              */)             if (*reply_info.text == '\0')                break;8             (void) strcpy(glob_pattern,reply_info.text);#             state|=UpdateListState;              break;           } '         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)            switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info); F         status=XParseColor(display,windows->widget.map_info->colormap,"           reply_info.text,&color);         if (status != 0)#           state|=RedrawActionState;          break;       }        case KeyRelease:       {          static char !           command[MaxTextLength];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L) !           state&=(~ControlState);          break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)            {              /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y) J               slider_info.id=(colors*(slider_info.y-slider_info.min_y+1))/8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           } (         if (state & InactiveWidgetState)           break;G         if (grab_info.raised == MatteIsActive(grab_info,event.xmotion))            {              /*)               Grab button status changed.              *//             grab_info.raised=!grab_info.raised; D             XDrawBeveledButton(display,&windows->widget,&grab_info);             break;           } I         if (reset_info.raised == MatteIsActive(reset_info,event.xmotion))            {              /**               Reset button status changed.             */1             reset_info.raised=!reset_info.raised; E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }        case SelectionClear:       { #         reply_info.highlight=False; =         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }        case SelectionNotify:        {          Atom           type;            int            format,            status;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);          else           {              /*5               Insert primary selection in reply text.              */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); A             XDrawMatteText(display,&windows->widget,&reply_info); %             state|=RedrawActionState;            }          XFree((void *) data);          break;       }        case SelectionRequest:       {          XSelectionEvent            notify;            XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;         notify.send_event=True; (         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   /*     Free color list.   */   for (i=0; i < colors; i++)      free((char *) colorlist[i]);"   if (colorlist != (char **) NULL)     free((char *) colorlist);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m m a n d W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XCommandWidget maps a menu and returns the command pointed to by( %  the user when the button is released. % / %  The format of the XCommandWidget routine is:  % F %    selection_number=XCommandWidget(display,windows,selections,event) % + %  A description of each parameter follows:  % G %    o selection_number: Specifies the number of the selection that the  %      user choose.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % K %    o selections: Specifies a pointer to one or more strings that comprise  %      the choices in the menu.  % < %    o event: Specifies a pointer to a X11 XEvent structure. %  %  */4 int XCommandWidget(display,windows,selections,event) Display    *display;    XWindows   *windows;    char   **selections;    XEvent	   *event;  {  #define tile_width 112 #define tile_height 70  #   static unsigned char tile_bits[]=    { K     0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x1e, 0x38, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x1e, 0xbc, 0x9f, 0x03, 0x00, 0x3e, 0x00, 0xc0, K     0x1f, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0x0f, 0x80, 0x3f, K     0x00, 0xf0, 0x1f, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0x1f, K     0xe0, 0x3f, 0x00, 0xfc, 0x1f, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0xfc, K     0xff, 0x1f, 0xf0, 0x3f, 0x00, 0xfe, 0x1f, 0xf8, 0x0f, 0x00, 0x00, 0x00, K     0x1e, 0xfc, 0xfc, 0x3f, 0xf8, 0x3f, 0x00, 0xff, 0x1e, 0xfc, 0x0f, 0x00, K     0x00, 0x00, 0x1e, 0x7c, 0xfc, 0x3e, 0xf8, 0x3c, 0x80, 0x1f, 0x1e, 0x7c, K     0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, 0x7c, 0x3c, 0xc0, 0x0f, K     0x1e, 0x3e, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, 0x7c, 0x3c, K     0xc0, 0x07, 0x1e, 0x3e, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, K     0x7c, 0x7c, 0xc0, 0x0f, 0x1e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x78, K     0x78, 0x3c, 0xfc, 0x7c, 0x80, 0x7f, 0x1e, 0x7c, 0x00, 0x00, 0x00, 0x00, K     0x1e, 0xf8, 0x78, 0x7c, 0xf8, 0xff, 0x00, 0xff, 0x1f, 0xf8, 0xff, 0x00, K     0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xf0, 0xff, 0x07, 0xfe, 0x1f, 0xf8, K     0xff, 0x00, 0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xf0, 0xff, 0x07, 0xf8, K     0x1f, 0xf0, 0xff, 0x01, 0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xc0, 0xef, K     0x07, 0xe0, 0x1f, 0xc0, 0xff, 0x01, 0x00, 0x00, 0x1e, 0x70, 0x40, 0x78, K     0x00, 0xc7, 0x07, 0x00, 0x1e, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x1e, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, K     0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x02, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, K     0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0xc0, 0x0f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x60, 0x00, 0xc0, 0x0f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x78, 0x00, 0xc0, 0x8f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xc0, 0x8f, 0x3f, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xe0, 0x9f, 0x7f, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xe0, 0xdf, K     0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x78, 0x00, K     0xe0, 0xdf, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x0c, K     0x78, 0x30, 0xf0, 0xff, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, K     0x00, 0x0f, 0xf8, 0x70, 0xf0, 0xff, 0x7b, 0x00, 0x00, 0x1f, 0x00, 0xe0, K     0x0f, 0x1e, 0x80, 0x0f, 0xf8, 0x78, 0xf0, 0xfd, 0xf9, 0x00, 0xc0, 0x1f, K     0x00, 0xf8, 0x0f, 0x00, 0xe0, 0x1f, 0xf8, 0x7c, 0xf0, 0xfc, 0xf9, 0x00, K     0xf0, 0x1f, 0x00, 0xfe, 0x0f, 0x00, 0xf0, 0x07, 0xf8, 0x3e, 0xf8, 0xfc, K     0xf0, 0x01, 0xf8, 0x1f, 0x00, 0xff, 0x0f, 0x1e, 0xf0, 0x03, 0xf8, 0x3f, K     0xf8, 0xf8, 0xf0, 0x01, 0xfc, 0x1f, 0x80, 0x7f, 0x0f, 0x1e, 0xf8, 0x00, K     0xf8, 0x1f, 0x78, 0x18, 0xf0, 0x01, 0x7c, 0x1e, 0xc0, 0x0f, 0x0f, 0x1e, K     0x7c, 0x00, 0xf0, 0x0f, 0x78, 0x00, 0xf0, 0x01, 0x3e, 0x1e, 0xe0, 0x07, K     0x0f, 0x1e, 0x7c, 0x00, 0xf0, 0x07, 0x7c, 0x00, 0xe0, 0x01, 0x3e, 0x1e, K     0xe0, 0x03, 0x0f, 0x1e, 0x3e, 0x00, 0xf0, 0x0f, 0x7c, 0x00, 0xe0, 0x03, K     0x3e, 0x3e, 0xe0, 0x07, 0x0f, 0x1e, 0x1e, 0x00, 0xf0, 0x1f, 0x3c, 0x00, K     0xe0, 0x03, 0x7e, 0x3e, 0xc0, 0x3f, 0x0f, 0x1e, 0x3e, 0x00, 0xf0, 0x1f, K     0x3e, 0x00, 0xe0, 0x03, 0xfc, 0x7f, 0x80, 0xff, 0x0f, 0x1e, 0xfc, 0x00, K     0xf0, 0x3e, 0x3e, 0x00, 0xc0, 0x03, 0xf8, 0xff, 0x03, 0xff, 0x0f, 0x1e, K     0xfc, 0x07, 0xf0, 0x7c, 0x1e, 0x00, 0xc0, 0x03, 0xf8, 0xff, 0x03, 0xfc, K     0x0f, 0x1e, 0xf8, 0x1f, 0xf0, 0xf8, 0x1e, 0x00, 0xc0, 0x03, 0xe0, 0xf7, K     0x03, 0xf0, 0x0f, 0x1e, 0xe0, 0x3f, 0xf0, 0x78, 0x1c, 0x00, 0x80, 0x03, K     0x80, 0xe3, 0x03, 0x00, 0x0f, 0x1e, 0xc0, 0x3f, 0xf0, 0x30, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0e, 0x00, 0x3e, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x10, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, K     0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 2     0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   };     int      id,      y;     register int     i;     static unsigned int      number_selections;     static XWidgetInfo+     *selection_info = (XWidgetInfo *) NULL;      unsigned int     height;      unsigned long 
     state;  
   XFontStruct      *font_info;   '   font_info=windows->command.font_info; .   height=font_info->ascent+font_info->descent;   state=DefaultState;    if (event == (XEvent *) NULL)      {        unsigned int         width;         XTextProperty          window_name;         XWindowChanges         window_changes;          /*,         Determine command window attributes.       */       windows->command.width=0; 4       for (i=0; selections[i] != (char *) NULL; i++)       { H         width=XTextWidth(font_info,selections[i],strlen(selections[i]));+         if (width > windows->command.width) '           windows->command.width=width;        }        number_selections=i;?       windows->command.width+=4*font_info->max_bounds.width+10; O       if (windows->command.width < (tile_width+font_info->max_bounds.width+10)) I         windows->command.width=tile_width+font_info->max_bounds.width+10; G       windows->command.height=number_selections*(((3*height) >> 1)+10)+          tile_height+20; 8       windows->command.min_width=windows->command.width;:       windows->command.min_height=windows->command.height;:       XConstrainWindowPosition(display,&windows->command);       /*         Map command window.        */N       (void) XStringListToTextProperty(&windows->command.name,1,&window_name);;       XSetWMName(display,windows->command.id,&window_name); 2       window_changes.width=windows->command.width;4       window_changes.height=windows->command.height;O       XReconfigureWMWindow(display,windows->command.id,windows->command.screen, ,         CWWidth | CWHeight,&window_changes);       /*'         Allocate selection info memory.        */1       if (selection_info != (XWidgetInfo *) NULL) &         free((char *) selection_info);$       selection_info=(XWidgetInfo *)6         malloc(number_selections*sizeof(XWidgetInfo));1       if (selection_info == (XWidgetInfo *) NULL) L         Error("Unable to create Command Widget","Memory allocation failed");&       state|=UpdateConfigurationState;     }    /*     Wait for next event.   */
   id=(-1);   if (event != (XEvent *) NULL)      switch (event->type)     {        case ButtonPress:        { -         for (i=0; i < number_selections; i++) >           if (MatteIsActive(selection_info[i],event->xbutton))
             { -               if (i >= windows->command.data)                  { 1                   selection_info[i].raised=False; ?                   XDrawBeveledButton(display,&windows->command, (                     &selection_info[i]);                   break;                 } :               windows->widget.x_origin=windows->command.x+B                 selection_info[i].x-selection_info[i].bevel_width;:               windows->widget.y_origin=windows->command.y+B                 selection_info[i].y-selection_info[i].bevel_width;               id=i;                break;
             }          break;       }        case ButtonRelease:        { -         for (i=0; i < number_selections; i++) >           if (MatteIsActive(selection_info[i],event->xbutton))+             if (i >= windows->command.data)                { .                 selection_info[i].raised=True;=                 XDrawBeveledButton(display,&windows->command, &                   &selection_info[i]);                 id=i;                  break;               }          break;       }        case ClientMessage:        { 
         /*C           If client window delete message, withdraw command widget. 
         */A         if (event->xclient.message_type != windows->wm_protocols)            break;@         if (*event->xclient.data.l != windows->wm_delete_window)           break;M         XWithdrawWindow(display,windows->command.id,windows->command.screen);          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */<         if (event->xconfigure.window != windows->command.id)           break;.         if (event->xconfigure.send_event != 0)           { 3             windows->command.x=event->xconfigure.x; 3             windows->command.y=event->xconfigure.y;            } B         if ((event->xconfigure.width == windows->command.width) &&B             (event->xconfigure.height == windows->command.height))           break;         windows->command.width= B           Max(event->xconfigure.width,windows->command.min_width);          windows->command.height=D           Max(event->xconfigure.height,windows->command.min_height);(         state|=UpdateConfigurationState;         break;       }        case Expose:       { 9         if (event->xexpose.window != windows->command.id)            break;&         if (event->xexpose.count != 0)           break;!         state|=RedrawWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));-         for (i=0; i < number_selections; i++) )           if (selection_info[i].raised == >               MatteIsActive(selection_info[i],event->xmotion))
             {                /*&                 Button status changed.               */,               if (i < windows->command.data)                 break;A               selection_info[i].raised=!selection_info[i].raised; O               XDrawBeveledButton(display,&windows->command,&selection_info[i]);                break;
             }          break;       }        case MapNotify:        { %         windows->command.mapped=True;          break;       }        case UnmapNotify:        { &         windows->command.mapped=False;         break;       }        default:         break;     } '   if (state & UpdateConfigurationState)      {        /*&         Initialize button information.       */       y=tile_height+20; +       for (i=0; i < number_selections; i++)        { 9         XGetWidgetInfo(selections[i],&selection_info[i]); (         selection_info[i].bevel_width--;1         selection_info[i].height=(3*height) >> 1; A         selection_info[i].x=(font_info->max_bounds.width >> 1)+4;           selection_info[i].width==            windows->command.width-(selection_info[i].x << 1);          selection_info[i].y=y;K         y+=selection_info[i].height+(selection_info[i].bevel_width << 1)+6;        } "       if (windows->command.mapped)2         XClearWindow(display,windows->command.id);     }     if (state & RedrawWidgetState)     {        Pixmap         tile_pixmap;         XWidgetInfo          submenu_info;          /*         Draw command buttons.        */J       tile_pixmap=XCreatePixmapFromBitmapData(display,windows->command.id,;         (char *) tile_bits,tile_width,tile_height,1L,0L,1); '       if (tile_pixmap != (Pixmap) NULL) 	         { =           XCopyPlane(display,tile_pixmap,windows->command.id, I             windows->command.annotate_context,0,0,tile_width,tile_height, <             (windows->command.width-tile_width) >> 1,10,1L);+           XFreePixmap(display,tile_pixmap); 	         } 2       XGetWidgetInfo((char *) NULL,&submenu_info);        submenu_info.raised=False;!       submenu_info.bevel_width--; K       submenu_info.width=((5*height) >> 3)-(submenu_info.bevel_width << 1); -       submenu_info.height=submenu_info.width; A       submenu_info.x=selection_info[0].x+selection_info[0].width- >         submenu_info.width-(font_info->max_bounds.width >> 1);+       for (i=0; i < number_selections; i++)        { I         XDrawBeveledButton(display,&windows->command,&selection_info[i]); 4         if ((i < 0) || (i >= windows->command.data))           continue; +         submenu_info.y=selection_info[i].y+ E           (selection_info[i].height >> 1)-(submenu_info.height >> 1); C         XDrawTriangleEast(display,&windows->command,&submenu_info);        } 6       XHighlightWidget(display,&windows->command,4,4);     } 
   return(id);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i r m W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XConfirmWidget displays a Widget widget with a notice to the user.G %  The function returns True if the user presses Yes otherwise False is  %  returned. % / %  The format of the XConfirmWidget routine is:  % = %    status=XConfirmWidget(display,windows,message,qualifier)  % + %  A description of each parameter follows:  % L %    o status:  Function XConfirmWidget returns True if the user presses Yes# %      otherwise False is returned.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */> unsigned int XConfirmWidget(display,windows,message,qualifier) Display    *display;    XWindows   *windows;    char   *message, 
   *qualifier;  { " #define CancelButtonText  "Cancel" #define YesButtonText  "Yes"     int      x,     y;     unsigned int     confirm,     height, 
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      cancel_info,
     yes_info;      XWindowChanges     window_changes;      /*'     Determine Widget widget attributes.    */(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;H   width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));H   if (XTextWidth(font_info,YesButtonText,strlen(YesButtonText)) > width)D     width=XTextWidth(font_info,YesButtonText,strlen(YesButtonText));   width<<=1;!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,strlen(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,strlen(qualifier));!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,strlen(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,strlen(qualifier));0   height=(font_info->ascent+font_info->descent);   /*     Position Widget widget.    */<   windows->widget.width=width+7*font_info->max_bounds.width;E   windows->widget.min_width=width+(font_info->max_bounds.width << 2); 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;#   windows->widget.height=12*height; &   windows->widget.min_height=7*height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 3   windows->widget.x=x-(windows->widget.width >> 1); 8   windows->widget.y=y-((5*windows->widget.height) >> 3);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Widget widget.   */0   (void) strcpy(windows->widget.name,"Confirm");I   (void) XStringListToTextProperty(&windows->widget.name,1,&window_name); 6   XSetWMName(display,windows->widget.id,&window_name);-   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    XBell(display,0);    /*     Respond to X events.   */   confirm=False;!   state=UpdateConfigurationState; (   XSetCursorState(display,windows,True);   do   { )     if (state & UpdateConfigurationState)        { 
         /*+           Initialize No button information. 
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);6         cancel_info.width=font_info->max_bounds.width+J           XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));+         cancel_info.height=(3*height) >> 1; >         cancel_info.x=windows->widget.width-cancel_info.width-&           font_info->max_bounds.width;G         cancel_info.y=windows->widget.height-(cancel_info.height << 1);          yes_info=cancel_info; $         yes_info.text=YesButtonText;/         yes_info.x=font_info->max_bounds.width; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*            Redraw Confirm widget.
         */<         width=XTextWidth(font_info,message,strlen(message));4         x=(windows->widget.width >> 1)-(width >> 1);6         y=(windows->widget.height >> 1)-(height << 1);P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,'           x,y,message,strlen(message)); '         if (qualifier != (char *) NULL)            { D             width=XTextWidth(font_info,qualifier,strlen(qualifier));8             x=(windows->widget.width >> 1)-(width >> 1);             y+=height;3             XDrawString(display,windows->widget.id, P               windows->widget.annotate_context,x,y,qualifier,strlen(qualifier));           } B         XDrawBeveledButton(display,&windows->widget,&cancel_info);?         XDrawBeveledButton(display,&windows->widget,&yes_info); 7         XHighlightWidget(display,&windows->widget,4,4); $         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*%               User pressed No button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 2         if (MatteIsActive(yes_info,event.xbutton))           {              /*&               User pressed Yes button.             */"             yes_info.raised=False;C             XDrawBeveledButton(display,&windows->widget,&yes_info);              break;           }          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;          if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton)) !                 state|=ExitState; $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }          if (!yes_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) 8               if (MatteIsActive(yes_info,event.xbutton))                 {                    confirm=True; #                   state|=ExitState;                  } !             yes_info.raised=True; C             XDrawBeveledButton(display,&windows->widget,&yes_info);            }          break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            {              state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextLength];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            { %             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             state|=ExitState;              break;           }          break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         if (state & InactiveWidgetState)           break;K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*'               No button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } E         if (yes_info.raised == MatteIsActive(yes_info,event.xmotion))            {              /*(               Yes button status changed.             */-             yes_info.raised=!yes_info.raised; C             XDrawBeveledButton(display,&windows->widget,&yes_info);              break;           }          break;       }        default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   return(confirm); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i a l o g W i d g e t                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDialogWidget displays a Widget widget with a query to the user.J %  The user keys a reply and presses the Ok or Cancel button to exit.  The: %  typed text is returned as the reply function parameter. % . %  The format of the XDialogWidget routine is: % 6 %    XDialogWidget(display,windows,action,query,reply) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % F %    o query: Specifies a pointer to the query to present to the user. % G %    o reply: The response from the user is returned in this parameter.  %  %  */6 void XDialogWidget(display,windows,action,query,reply) Display    *display;    XWindows   *windows;    char
   *action,	   *query, 	   *reply;  { " #define CancelButtonText  "Cancel"     char%     primary_selection[MaxTextLength];      int      x,     y;     register int     i;     unsigned int     anomaly,     height, 
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     dither_info,     reply_info,      text_info;     XWindowChanges     window_changes;      /*'     Determine Widget widget attributes.    */(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));.   width+=(3*font_info->max_bounds.width) >> 1;.   height=font_info->ascent+font_info->descent;   /*     Position Widget widget.    */O   windows->widget.width=Max(2*width,XTextWidth(font_info,query,strlen(query)))+ "     6*font_info->max_bounds.width;A   windows->widget.min_width=width+25*XTextWidth(font_info,"#",1)+ "     4*font_info->max_bounds.width;8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;E   windows->widget.height=7*height+(font_info->max_bounds.width << 1); 4   windows->widget.min_height=windows->widget.height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 3   windows->widget.x=x-(windows->widget.width >> 1); 4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Widget widget.   *//   (void) strcpy(windows->widget.name,"Dialog"); I   (void) XStringListToTextProperty(&windows->widget.name,1,&window_name); 6   XSetWMName(display,windows->widget.id,&window_name);-   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */)   anomaly=strcmp(action,"Quantize") == 0; !   state=UpdateConfigurationState; (   XSetCursorState(display,windows,True);   do   { )     if (state & UpdateConfigurationState)        { 
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; >         cancel_info.x=windows->widget.width-cancel_info.width-1           ((3*font_info->max_bounds.width) >> 1); @         cancel_info.y=windows->widget.height-cancel_info.height-1           ((3*font_info->max_bounds.width) >> 1); ,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; 7         action_info.x=cancel_info.x-(cancel_info.width+ F           font_info->max_bounds.width+(action_info.bevel_width << 1));$         action_info.y=cancel_info.y;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; O         reply_info.width=windows->widget.width-(3*font_info->max_bounds.width); &         reply_info.height=height << 1;:         reply_info.x=(3*font_info->max_bounds.width) >> 1;5         reply_info.y=action_info.y-reply_info.height- &           font_info->max_bounds.width;
         /*(           Initialize option information.
         */.         XGetWidgetInfo("Dither",&dither_info);!         dither_info.raised=False; "         dither_info.bevel_width--;;         dither_info.width=font_info->max_bounds.width >> 1; <         dither_info.height=font_info->max_bounds.width >> 1;#         dither_info.x=reply_info.x; J         dither_info.y=action_info.y+action_info.height-dither_info.height;
         /*&           Initialize text information.
         */)         XGetWidgetInfo(query,&text_info); )         text_info.width=reply_info.width;           text_info.height=height;D         text_info.x=reply_info.x-(font_info->max_bounds.width >> 1);0         text_info.y=font_info->max_bounds.width;+         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*           Redraw Dialog widget. 
         */=         XDrawWidgetText(display,&windows->widget,&text_info); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info);          if (anomaly)D           XDrawBeveledButton(display,&windows->widget,&dither_info);B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);7         XHighlightWidget(display,&windows->widget,4,4); $         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        {          if (anomaly)7           if (MatteIsActive(dither_info,event.xbutton)) 
             {                /*-                 Option button status changed.                */5               dither_info.raised=!dither_info.raised; H               XDrawBeveledButton(display,&windows->widget,&dither_info);               break;
             } 5         if (MatteIsActive(action_info,event.xbutton))            {              /*)               User pressed Action button.              */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {              static Time                click_time;                /*;               Move text cursor to position of button press.              */N             x=event.xbutton.x-reply_info.x-(font_info->max_bounds.width >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;                } A             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;          if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(action_info,event.xbutton)) !                 state|=ExitState; $             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }           if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))                  { (                   *reply_info.text='\0';#                   state|=ExitState;                  } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }          break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            { "             *reply_info.text='\0';             state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextLength];            static int           length;            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            { %             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             state|=ExitState;              break;           } '         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)            switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }        case KeyRelease:       {          static char !           command[MaxTextLength];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L) !           state&=(~ControlState);          break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;G         break;       }        case MotionNotify:       {W
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         if (state & InactiveWidgetState)           break;K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised;tF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised;sF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }        case SelectionClear:       { #         reply_info.highlight=False; =         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }t       case SelectionNotify:s       {a         Atom           type;            int            format,            status;            unsigned char            *data;           unsigned longe           after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor,aJ           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||d             (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);          else           {t             /*5               Insert primary selection in reply text.              */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); A             XDrawMatteText(display,&windows->widget,&reply_info);            }t         XFree((void *) data);r         break;       }w       case SelectionRequest:       {          XSelectionEvent            notify;            XSelectionRequestEvent           *request;c  "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));cN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }i       default:         break;     }a!   } while (!(state & ExitState));o)   XSetCursorState(display,windows,False);mE   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);o(   XCheckRefreshWindows(display,windows);   if (anomaly)     if (dither_info.raised)i       if (*reply != '\0')fF         (void) strcat(reply,"!");  /* do not dither when quantizing */ }2 T /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             % O %                                                                             %tO %                                                                             %SO %   X F i l e B r o w s e r W i d g e t                                       %_O %                                                                             %aO %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XFileBrowserWidget displays a Widget widget with a file query toK %  the user.  The user keys a reply and presses the Action or Cancel button H %  to exit.  The typed text is returned as the reply function parameter. % 3 %  The format of the XFileBrowserWidget routine is:  % 5 %    XFileBrowserWidget(display,windows,action,reply)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from% %      XOpenDisplay. %%; %    o window: Specifies a pointer to a XWindows structure.e %o@ %    o action: Specifies a pointer to the action of this widget. %dG %    o reply: The response from the user is returned in this parameter.  %  %e */5 void XFileBrowserWidget(display,windows,action,reply)  Displayr   *display;a   XWindows   *windows;    char
   *action,	   *reply;p {m" #define CancelButtonText  "Cancel"# #define DirectoryText  "Directory:"r" #define FilenameText  "File name:" #define GrabButtonText  "Grab"" #define FormatButtonText  "Format" #define HomeButtonText  "Home" #define UpButtonText  "Up"  
   static charf     *ImageOutputFormats[]=     {h       "avs",       "bmp",
       "cmyk",c       "eps",
       "epsf",o
       "epsi",f       "fax",
       "fits",        "gif",       "gif87",
       "gray",        "g3",f       "histogram",
       "http", 
       "iris",2
       "jpeg",d       "jpg",       "map",       "matte",
       "miff",        "mpg",
       "mpeg",e       "mtv",
       "null",i       "pbm",       "pcx",       "pgm",
       "pict",v       "pm",v       "ppm",       "pnm",       "ps",        "ps2",       "rad",       "ras",       "rgb",       "sun",       "tga",       "tif",
       "tiff",2       "vid",
       "viff",n
       "x",       "xbm",       "xpm",       "xv",s       "xwd",       "yuv",
       "yuv3",v       (char *) NULL4     };     char     **filelist,="     home_directory[MaxTextLength],%     primary_selection[MaxTextLength],w     text[MaxTextLength],%     working_directory[MaxTextLength];n     intn
     files,     x,     y;     register int     i;  
   static char*&     glob_pattern[MaxTextLength] = "*",#     format[MaxTextLength] = "miff";s     unsigned int     anomaly,     height,=     text_width,.     visible_files,
     width;     unsigned longw
     delay,
     state;     XEvent
     event;  
   XFontStructd     *font_info;.     XTextProperty      window_name;  
   XWidgetInfoo     action_info,     cancel_info,     expose_info,     special_info,d     list_info,     home_info,     north_info,l     reply_info,d     scroll_info,     selection_info,      slider_info,     south_info,S     text_info,     up_info;     XWindowChanges     window_changes;*     /*)     Read filelist from current directory.%   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);0   (void) getcwd(home_directory,MaxTextLength-1);2   (void) strcpy(working_directory,home_directory);<   filelist=ListFiles(working_directory,glob_pattern,&files);!   if (filelist == (char **) NULL)      {        /*         Directory read failed.       */@       XNoticeWidget(display,windows,"Unable to read directory:",         working_directory); D       XDialogWidget(display,windows,action,"Enter filename:",reply);
       return;      }    /*'     Determine Widget widget attributes.    */&   font_info=windows->widget.font_info;   text_width=0;%   for (i=0; i < files; i++)%K     if (XTextWidth(font_info,filelist[i],strlen(filelist[i])) > text_width)pG       text_width=XTextWidth(font_info,filelist[i],strlen(filelist[i]));t4   width=XTextWidth(font_info,action,strlen(action));J   if (XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText));N   if (XTextWidth(font_info,FormatButtonText,strlen(FormatButtonText)) > width)H     width=XTextWidth(font_info,GrabButtonText,strlen(FormatButtonText));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));J   if (XTextWidth(font_info,HomeButtonText,strlen(HomeButtonText)) > width)F     width=XTextWidth(font_info,HomeButtonText,strlen(HomeButtonText));F   if (XTextWidth(font_info,UpButtonText,strlen(UpButtonText)) > width)B     width=XTextWidth(font_info,UpButtonText,strlen(UpButtonText));%   width+=font_info->max_bounds.width;mH   if (XTextWidth(font_info,DirectoryText,strlen(DirectoryText)) > width)D     width=XTextWidth(font_info,DirectoryText,strlen(DirectoryText));F   if (XTextWidth(font_info,FilenameText,strlen(FilenameText)) > width)B     width=XTextWidth(font_info,FilenameText,strlen(FilenameText));.   height=font_info->ascent+font_info->descent;   /*     Position Widget widget.    */   windows->widget.width=E     width+Min(text_width,MaxTextWidth)+6*font_info->max_bounds.width; M   windows->widget.min_width=width+MinTextWidth+4*font_info->max_bounds.width;d8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;   windows->widget.height= A     ((81*height) >> 2)+((13*font_info->max_bounds.width) >> 1)+4;    windows->widget.min_height= A     ((23*height) >> 1)+((13*font_info->max_bounds.width) >> 1)+4;f:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y);f7   windows->widget.x=x-((3*windows->widget.width) >> 2);t4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);(   /*     Map Widget widget.   */A   (void) strcpy(windows->widget.name,"Browse and Select a File");>I   (void) XStringListToTextProperty(&windows->widget.name,1,&window_name); 6   XSetWMName(display,windows->widget.id,&window_name);-   window_changes.width=windows->widget.width;o/   window_changes.height=windows->widget.height;-%   window_changes.x=windows->widget.x;l%   window_changes.y=windows->widget.y;sI   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,e4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;_   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);w,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_files=0;L   anomaly=(strcmp(action,"Composite") == 0) || (strcmp(action,"Load") == 0);   delay=SuspendTime << 2;f!   state=UpdateConfigurationState;y   do   {s)     if (state & UpdateConfigurationState)%       {%         int%
           id;%  
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; >         cancel_info.x=windows->widget.width-cancel_info.width-(           font_info->max_bounds.width-2;@         cancel_info.y=windows->widget.height-cancel_info.height-&           font_info->max_bounds.width;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; 7         action_info.x=cancel_info.x-(cancel_info.width+ M           (font_info->max_bounds.width >> 1)+(action_info.bevel_width << 1));%$         action_info.y=cancel_info.y;5         XGetWidgetInfo(GrabButtonText,&special_info); !         special_info.width=width;e,         special_info.height=(3*height) >> 1;8         special_info.x=action_info.x-(action_info.width+N           (font_info->max_bounds.width >> 1)+(special_info.bevel_width << 1));%         special_info.y=action_info.y;m         if (!anomaly)            {p             register chars               *p;t  /             special_info.text=FormatButtonText;_$             p=reply+strlen(reply)-1;2             while ((p > reply) && (*(p-1) != '.'))               p--;/             if ((p > reply) && (*(p-1) == '.'))e&               (void) strcpy(format,p);           }l.         XGetWidgetInfo(UpButtonText,&up_info);         up_info.width=width;'         up_info.height=(3*height) >> 1;m.         up_info.x=font_info->max_bounds.width;@         up_info.y=((5*font_info->max_bounds.width) >> 1)+height;2         XGetWidgetInfo(HomeButtonText,&home_info);         home_info.width=width;)         home_info.height=(3*height) >> 1; 0         home_info.x=font_info->max_bounds.width;I         home_info.y=up_info.y+up_info.height+font_info->max_bounds.width; 
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; 5         reply_info.width=windows->widget.width-width- 1           ((6*font_info->max_bounds.width) >> 1); &         reply_info.height=height << 1;>         reply_info.x=width+(font_info->max_bounds.width << 1);         reply_info.y= F           action_info.y-reply_info.height-font_info->max_bounds.width;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);T"         scroll_info.bevel_width--;!         scroll_info.width=height;,         scroll_info.height= D           reply_info.y-up_info.y-(font_info->max_bounds.width >> 1);H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);7         scroll_info.y=up_info.y-reply_info.bevel_width;1!         scroll_info.raised=False;o          scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True;m8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;n-         north_info.x+=north_info.bevel_width;m-         north_info.y+=north_info.bevel_width;          south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;;         slider_info.id=id;         slider_info.width-=2;>P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;M         visible_files=(scroll_info.height-(height >> 3)-4)/((9*height) >> 3);%"         if (files > visible_files)F           slider_info.height=(visible_files*slider_info.height)/files;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;         list_info.width=H           scroll_info.x-reply_info.x-(font_info->max_bounds.width >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x;s"         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)#           for (i=0; i < files; i++)a/             if (strcmp(filelist[i],reply) == 0)X               list_info.id=i;f
         /*&           Initialize text information.
         */(         XGetWidgetInfo(text,&text_info);)         text_info.width=reply_info.width;           text_info.height=height;C         text_info.x=list_info.x-(font_info->max_bounds.width >> 1); 0         text_info.y=font_info->max_bounds.width;
         /*+           Initialize selection information..
         */6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x;,+         state&=(~UpdateConfigurationState);n       } "     if (state & RedrawWidgetState)       { 
         /*%           Redraw File Browser window.*
         */&         x=font_info->max_bounds.width;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent;_P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,3           x,y,DirectoryText,strlen(DirectoryText)); A         (void) sprintf(text_info.text,"%s%s%s",working_directory,t+           DirectorySeparator,glob_pattern);==         XDrawWidgetText(display,&windows->widget,&text_info);->         XDrawBeveledButton(display,&windows->widget,&up_info);@         XDrawBeveledButton(display,&windows->widget,&home_info);?         XDrawBeveledMatte(display,&windows->widget,&list_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info);+B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);i&         x=font_info->max_bounds.width;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent;nP         XDrawString(display,windows->widget.id,windows->widget.annotate_context,1           x,y,FilenameText,strlen(FilenameText)); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info);tC         XDrawBeveledButton(display,&windows->widget,&special_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);7         XHighlightWidget(display,&windows->widget,4,4);          selection_info.id=(~0);h         state|=RedrawListState;l$         state&=(~RedrawWidgetState);       }p      if (state & UpdateListState)       {r         char           **checklist;           intx           number_files;-  
         /*           Update file list. 
         */J         checklist=ListFiles(working_directory,glob_pattern,&number_files);(         if (checklist == (char **) NULL)           {t             /*(               Reply is a filename, exit.             */%             action_info.raised=False;eF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }-!         for (i=0; i < files; i++)l%           free((char *) filelist[i]);n'         if (filelist != (char **) NULL)s"           free((char *) filelist);         filelist=checklist;n         files=number_files;i
         /*           Update file list.g
         */'         if (filelist == (char **) NULL)x           {r             /*(               Reply is a filename, exit.             */%             action_info.raised=False;tF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }a         slider_info.height=,J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;"         if (files > visible_files)F           slider_info.height=(visible_files*slider_info.height)/files;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0; (         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);          list_info.id=(~0);         state|=RedrawListState; 
         /*(           Redraw directory name & reply.
         */%         if (!IsGlob(reply_info.text))            { "             *reply_info.text='\0';.             reply_info.cursor=reply_info.text;           }%A         (void) sprintf(text_info.text,"%s%s%s",working_directory,t+           DirectorySeparator,glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info);.=         XDrawMatteText(display,&windows->widget,&reply_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info);dB         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);i7         XHighlightWidget(display,&windows->widget,4,4);X"         state&=(~UpdateListState);       }l      if (state & RedrawListState)       {o
         /*+           Determine slider id and position.n
         */:         if (slider_info.id >= (int) (files-visible_files))-           slider_info.id=files-visible_files;f=         if ((slider_info.id < 0) || (files <= visible_files))            slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (files > 0)           slider_info.y+=sI             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/files;t0         if (slider_info.id != selection_info.id)           {              /*/               Redraw scroll bar and file names.l             */-             selection_info.id=slider_info.id;e9             selection_info.y=list_info.y+(height >> 3)+2; -             for (i=0; i < visible_files; i++)1
             {nG               selection_info.raised=(slider_info.id+i) != list_info.id;i0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < files),?                 selection_info.text=filelist[slider_info.id+i]; H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }o             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y;p?                 expose_info.y=slider_info.y-expose_info.height-e,                   slider_info.bevel_width-1;               }=             else               {2?                 expose_info.height=expose_info.y-slider_info.y;3?                 expose_info.y=slider_info.y+slider_info.height+e,                   slider_info.bevel_width+1;               }gE             XDrawTriangleNorth(display,&windows->widget,&north_info);o>             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info);1(             expose_info.y=slider_info.y;           }P"         state&=(~RedrawListState);       }i     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)w=       XIfEvent(display,&event,XScreenEvent,(char *) windows);%     else       {%
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */               slider_info.id--; %               state|=RedrawListState; 
             }          if (!south_info.raised) %           if (slider_info.id < files) 
             {                /*!                 Move slider down.                */               slider_info.id++;%%               state|=RedrawListState;%
             }n(         if (event.type != ButtonRelease)           continue;f       }v     switch (event.type)n     {        case ButtonPress:n       {a5         if (MatteIsActive(slider_info,event.xbutton))f           {a             /*               Track slider.g             */$             slider_info.active=True;             break;           }o4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {a               /*                 Move slider up.a               */&               north_info.raised=False;               slider_info.id--;o%               state|=RedrawListState;x               break;
             }t4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < files)W
             {w               /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++;e%               state|=RedrawListState;                break;
             }/5         if (MatteIsActive(scroll_info,event.xbutton))e           {;             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_files-1);             else0               slider_info.id+=(visible_files-1);#             state|=RedrawListState;.             break;           }n3         if (MatteIsActive(list_info,event.xbutton))s           {n             unsigned int               id;s               /*&               User pressed file matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= files)               break;8             (void) strcpy(reply_info.text,filelist[id]);'             reply_info.highlight=False;d.             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info);/#             if (id == list_info.id)2               {=A                 (void) strcpy(working_directory,reply_info.text);2'                 state|=UpdateListState;                }b#             selection_info.id=(~0);y             list_info.id=id;#             state|=RedrawListState;n             break;           }n1         if (MatteIsActive(up_info,event.xbutton))O           {*             /*%               User pressed Up button.o             */!             up_info.raised=False;1B             XDrawBeveledButton(display,&windows->widget,&up_info);             break;           } 3         if (MatteIsActive(home_info,event.xbutton))w           {d             /*'               User pressed Home button.M             */#             home_info.raised=False;dD             XDrawBeveledButton(display,&windows->widget,&home_info);             break;           }%6         if (MatteIsActive(special_info,event.xbutton))           {              /**               User pressed Special button.             */&             special_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&special_info);              if (!anomaly)                {                  /*/                   Let user select image format.                  */9                 XDefineCursor(display,windows->widget.id, /                   windows->widget.busy_cursor); C                 XListBrowserWidget(display,windows,&windows->popup, J                   ImageOutputFormats,"Select","Select image format type:",                   format);9                 XDefineCursor(display,windows->widget.id,d*                   windows->widget.cursor);:                 AppendImageFormat(format,reply_info.text);J                 reply_info.cursor=reply_info.text+strlen(reply_info.text);E                 XDrawMatteText(display,&windows->widget,&reply_info);d               }h%             special_info.raised=True;yG             XDrawBeveledButton(display,&windows->widget,&special_info);p             break;           }o5         if (MatteIsActive(action_info,event.xbutton))            {i             /*)               User pressed action button.              */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }n5         if (MatteIsActive(cancel_info,event.xbutton))_           {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }25         if (!MatteIsActive(reply_info,event.xbutton))i           break;,         if (event.xbutton.button != Button2)           {d             static Time>               click_time;i               /*;               Move text cursor to position of button press.              */N             x=event.xbutton.x-reply_info.x-(font_info->max_bounds.width >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;o             else               {s                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id,0&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;.               }3A             XDrawMatteText(display,&windows->widget,&reply_info);d*             click_time=event.xbutton.time;             break;           }_
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING,.1           windows->widget.id,event.xbutton.time);o         break;       }2       case ButtonRelease:n       {1$         if (!windows->widget.mapped)           break;         if (!north_info.raised)n           {s             /*&               User released up button.             */#             delay=SuspendTime << 2;i#             north_info.raised=True;iE             XDrawTriangleNorth(display,&windows->widget,&north_info);%           }%         if (!south_info.raised)%           {              /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);            }          if (slider_info.active)            {              /*#               Stop tracking slider.              */%             slider_info.active=False;              break;           }          if (!up_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) 7               if (MatteIsActive(up_info,event.xbutton))%                 {%8                   (void) strcpy(working_directory,"..");)                   state|=UpdateListState;w                 }               up_info.raised=True;B             XDrawBeveledButton(display,&windows->widget,&up_info);           }X         if (!home_info.raised)           {w;             if (event.xbutton.window == windows->widget.id)i9               if (MatteIsActive(home_info,event.xbutton))e                 {DB                   (void) strcpy(working_directory,home_directory);)                   state|=UpdateListState;w                 } "             home_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&home_info);           }d!         if (!special_info.raised)s           {n;             if (event.xbutton.window == windows->widget.id) <               if (MatteIsActive(special_info,event.xbutton))                 {g6                   (void) strcpy(reply_info.text,"x:");#                   state|=ExitState;                  }a%             special_info.raised=True;oG             XDrawBeveledButton(display,&windows->widget,&special_info);n           }t          if (!action_info.raised)           {d;             if (event.xbutton.window == windows->widget.id)a;               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0')h#                   XBell(display,0);_                 else#                   state|=ExitState;($             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }i          if (!cancel_info.raised)           {=;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))*                 { (                   *reply_info.text='\0';#                   state|=ExitState;=                 }i$             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }t         break;       }t       case ClientMessage:        {e
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {UG             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);)             break;           }_?         if (*event.xclient.data.l != windows->wm_delete_window)i           break;7         if (event.xclient.window == windows->widget.id)>           {x"             *reply_info.text='\0';             state|=ExitState;%             break;           }%         break;       }%       case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }%       case EnterNotify:%       {%9         if (event.xcrossing.window != windows->widget.id)e           break;&         state&=(~InactiveWidgetState);         break;       }t       case Expose:       {t7         if (event.xexpose.window != windows->widget.id)r           break;%         if (event.xexpose.count != 0)p           break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {o         static charo!           command[MaxTextLength];h           static int           length;m           static KeySymn           key_symbol;n  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);e         *(command+length)='\0'; 2         if (MatteIsActive(scroll_info,event.xkey))           {l             /*               Move slider.             */             switch (key_symbol)X
             {                case XK_Home:                case XK_KP_Home:               { !                 slider_info.id=0;n                 break;               }f               case XK_Up:i               case XK_KP_Up:               {)!                 slider_info.id--;F                 break;               }                case XK_Down:a               case XK_KP_Down:               {r!                 slider_info.id++;                  break;               }e               case XK_Prior:               case XK_KP_Prior:                {X.                 slider_info.id-=visible_files;                 break;               }t               case XK_Next:i               case XK_KP_Next:               {>.                 slider_info.id+=visible_files;                 break;               }                case XK_End:               case XK_KP_End:                {t%                 slider_info.id=files;o                 break;               } 
             } #             state|=RedrawListState;t             break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {t             /*1               Read new directory or glob patterm.g             */)             if (*reply_info.text == '\0')                break;(             if (IsGlob(reply_info.text)):               (void) strcpy(glob_pattern,reply_info.text);             else               {fA                 (void) strcpy(working_directory,reply_info.text);e,                 if (*reply_info.text == '~')                   {e!                     register chari                       *p;i                       /*)                       Get home directory.                      */.                     p=(char *) getenv("HOME");+                     if (p != (char *) NULL)t                       {;;                         (void) strcpy(working_directory,p);%K                         (void) strcat(working_directory,reply_info.text+1);                        }                    }                } #             state|=UpdateListState;              break;           } '         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)            switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;i               break;
             }s             default:               break;           }i@         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }w       case KeyRelease:       {e         static charo!           command[MaxTextLength];e           static KeySymi           key_symbol;i  4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);e'         if (key_symbol == XK_Control_L);!           state&=(~ControlState);w         break;       }        case LeaveNotify:F       { 9         if (event.xcrossing.window != windows->widget.id)s           break;#         state|=InactiveWidgetState;t         break;       }r       case MotionNotify:       {r
         /*/           Discard pending button motion events.%
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)            {              /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y) I               slider_info.id=(files*(slider_info.y-slider_info.min_y+1))/%8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;g             break;           }u(         if (state & InactiveWidgetState)           break;C         if (up_info.raised == MatteIsActive(up_info,event.xmotion))            {n             /*'               Up button status changed.e             */+             up_info.raised=!up_info.raised;XB             XDrawBeveledButton(display,&windows->widget,&up_info);             break;           }oG         if (home_info.raised == MatteIsActive(home_info,event.xmotion))            {              /*)               Home button status changed.n             *//             home_info.raised=!home_info.raised; D             XDrawBeveledButton(display,&windows->widget,&home_info);             break;           } M         if (special_info.raised == MatteIsActive(special_info,event.xmotion))            {l             /*)               Grab button status changed.n             */5             special_info.raised=!special_info.raised;(G             XDrawBeveledButton(display,&windows->widget,&special_info);n             break;           }tK         if (action_info.raised == MatteIsActive(action_info,event.xmotion));           {C             /*+               Action button status changed.n             */3             action_info.raised=!action_info.raised;wF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }iK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))%           {%             /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }        case SelectionClear:       { #         reply_info.highlight=False; =         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }        case SelectionNotify:        {          Atom           type;            int            format,            status;            unsigned char%           *data;           unsigned long%           after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)f           break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);n         else           {l             /*5               Insert primary selection in reply text.o             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,y               state);pA             XDrawMatteText(display,&windows->widget,&reply_info);i           }m         XFree((void *) data);)         break;       }x       case SelectionRequest:       {          XSelectionEvent            notify;            XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));eN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection));=$         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       };       default:         break;     } !   } while (!(state & ExitState));v)   XSetCursorState(display,windows,False);*E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   /*     Free file list.p   */   for (i=0; i < files; i++)-     free((char *) filelist[i]);i!   if (filelist != (char **) NULL)w     free((char *) filelist); }r T /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %uO %                                                                             %%O %                                                                             % O %   X F o n t B r o w s e r W i d g e t                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XFontBrowserWidget displays a Widget widget with a font query toK %  the user.  The user keys a reply and presses the Action or Cancel button%H %  to exit.  The typed text is returned as the reply function parameter. % 3 %  The format of the XFontBrowserWidget routine is:t % 5 %    XFontBrowserWidget(display,windows,action,reply)f %e+ %  A description of each parameter follows:B %lE %    o display: Specifies a connection to an X server;  returned fromt %      XOpenDisplay. %d; %    o window: Specifies a pointer to a XWindows structure.e %r@ %    o action: Specifies a pointer to the action of this widget. % G %    o reply: The response from the user is returned in this parameter.e %i %c */ static int FontCompare(x,y)"
 const void   *x,t   *y;  {    register char      *p,      *q;t     p=(char *) *((char **) x);   q=(char *) *((char **) y);4   while ((*p != '\0') && (*q != '\0') && (*p == *q))   {d     p++;     q++;   }f   return(*p-(*q)); }   5 void XFontBrowserWidget(display,windows,action,reply)  Displayo   *display;.   XWindows   *windows;k   char
   *action,	   *reply;g {c #define BackButtonText  "Back"" #define CancelButtonText  "Cancel" #define FontnameText  "Name:"n# #define FontPatternText  "Pattern:"i  #define ResetButtonText  "Reset"     char      back_pattern[MaxTextLength],     **fontlist,l     **listhead, %     primary_selection[MaxTextLength],i!     reset_pattern[MaxTextLength],      text[MaxTextLength];     int;
     fonts,     x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextLength] = "*";     unsigned int     height,>     text_width,      visible_fonts,
     width;     unsigned longx
     delay,
     state;     XEvent
     event;  
   XFontStructc     *font_info;      XTextPropertyi     window_name;  
   XWidgetInfo      action_info,     back_info,     cancel_info,     expose_info,     list_info,     mode_info,     north_info,      reply_info,      reset_info,      scroll_info,     selection_info,      slider_info,     south_info,      text_info;     XWindowChanges     window_changes;      /*.     Get font list and sort in ascending order.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);+   (void) strcpy(back_pattern,glob_pattern); #   (void) strcpy(reset_pattern,"*"); 9   fontlist=XListFonts(display,glob_pattern,32767,&fonts);    if (fonts == 0)      {        /*-         Pattern failed, obtain all the fonts.%       */D       XNoticeWidget(display,windows,"Unable to obtain fonts names:",         glob_pattern);&       (void) strcpy(glob_pattern,"*");=       fontlist=XListFonts(display,glob_pattern,32767,&fonts);:%       if (fontlist == (char **) NULL)d	         {sH           XNoticeWidget(display,windows,"Unable to obtain fonts names:",             glob_pattern);           return; 	         }r     }    /*&     Sort font list in ascending order.   */   listhead=fontlist;3   fontlist=(char **) malloc(fonts*sizeof(char **));r!   if (fontlist == (char **) NULL)c     { <       XNoticeWidget(display,windows,"Unable to view fonts:",$         "Memory allocation failed");
       return;o     }    for (i=0; i < fonts; i++)      fontlist[i]=listhead[i];0   qsort((void *) fontlist,fonts,sizeof(char **),B     (int (*) _Declare((const void *, const void *))) FontCompare);   /*'     Determine Widget widget attributes.(   */&   font_info=windows->widget.font_info;   text_width=0;u   for (i=0; i < fonts; i++)tK     if (XTextWidth(font_info,fontlist[i],strlen(fontlist[i])) > text_width)lG       text_width=XTextWidth(font_info,fontlist[i],strlen(fontlist[i]));n4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));L   if (XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText)) > width)H     width=XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText));J   if (XTextWidth(font_info,BackButtonText,strlen(BackButtonText)) > width)F     width=XTextWidth(font_info,BackButtonText,strlen(BackButtonText));%   width+=font_info->max_bounds.width; L   if (XTextWidth(font_info,FontPatternText,strlen(FontPatternText)) > width)H     width=XTextWidth(font_info,FontPatternText,strlen(FontPatternText));F   if (XTextWidth(font_info,FontnameText,strlen(FontnameText)) > width)B     width=XTextWidth(font_info,FontnameText,strlen(FontnameText));.   height=font_info->ascent+font_info->descent;   /*     Position Widget widget.%   */   windows->widget.width=E     width+Min(text_width,MaxTextWidth)+6*font_info->max_bounds.width; M   windows->widget.min_width=width+MinTextWidth+4*font_info->max_bounds.width;l8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;   windows->widget.height= A     ((85*height) >> 2)+((13*font_info->max_bounds.width) >> 1)+4;f   windows->widget.min_height=nA     ((27*height) >> 1)+((13*font_info->max_bounds.width) >> 1)+4;s:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y);l7   windows->widget.x=x-((3*windows->widget.width) >> 2); 4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);f   /*     Map Widget widget.   */A   (void) strcpy(windows->widget.name,"Browse and Select a Font");,I   (void) XStringListToTextProperty(&windows->widget.name,1,&window_name);n6   XSetWMName(display,windows->widget.id,&window_name);-   window_changes.width=windows->widget.width;e/   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x;o%   window_changes.y=windows->widget.y;%I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_fonts=0;   delay=SuspendTime << 2; !   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)        {          int 
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;a>         cancel_info.x=windows->widget.width-cancel_info.width-(           font_info->max_bounds.width-2;@         cancel_info.y=windows->widget.height-cancel_info.height-&           font_info->max_bounds.width;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1;p7         action_info.x=cancel_info.x-(cancel_info.width+cM           (font_info->max_bounds.width >> 1)+(action_info.bevel_width << 1));S$         action_info.y=cancel_info.y;2         XGetWidgetInfo(BackButtonText,&back_info);         back_info.width=width;)         back_info.height=(3*height) >> 1;e0         back_info.x=font_info->max_bounds.width;B         back_info.y=((5*font_info->max_bounds.width) >> 1)+height;4         XGetWidgetInfo(ResetButtonText,&reset_info);         reset_info.width=width;t*         reset_info.height=(3*height) >> 1;1         reset_info.x=font_info->max_bounds.width;uN         reset_info.y=back_info.y+back_info.height+font_info->max_bounds.width;
         /*'           Initialize reply information.t
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;c5         reply_info.width=windows->widget.width-width-n1           ((6*font_info->max_bounds.width) >> 1); &         reply_info.height=height << 1;>         reply_info.x=width+(font_info->max_bounds.width << 1);         reply_info.y= N           action_info.y-(action_info.height << 1)-font_info->max_bounds.width;
         /*&           Initialize mode information.
         */)         XGetWidgetInfo(reply,&mode_info);i          mode_info.bevel_width=0;O         mode_info.width=action_info.x-reply_info.x-font_info->max_bounds.width;,1         mode_info.height=action_info.height << 1;g!         mode_info.x=reply_info.x; M         mode_info.y=action_info.y-action_info.height+action_info.bevel_width;,
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);g"         scroll_info.bevel_width--;!         scroll_info.width=height;          scroll_info.height= F           reply_info.y-back_info.y-(font_info->max_bounds.width >> 1);H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);9         scroll_info.y=back_info.y-reply_info.bevel_width;p!         scroll_info.raised=False;s          scroll_info.trough=True;         north_info=scroll_info;p         north_info.raised=True;a8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;/-         north_info.x+=north_info.bevel_width;t-         north_info.y+=north_info.bevel_width;f         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2;tP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=eJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_fonts=A           (scroll_info.height-(height >> 3)-4)/((9*height) >> 3);i"         if (fonts > visible_fonts)F           slider_info.height=(visible_fonts*slider_info.height)/fonts;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;         list_info.width=H           scroll_info.x-reply_info.x-(font_info->max_bounds.width >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x;w"         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)#           for (i=0; i < fonts; i++)m/             if (strcmp(fontlist[i],reply) == 0)_               list_info.id=i;)
         /*&           Initialize text information.
         */(         XGetWidgetInfo(text,&text_info);)         text_info.width=reply_info.width;m          text_info.height=height;C         text_info.x=list_info.x-(font_info->max_bounds.width >> 1);w0         text_info.y=font_info->max_bounds.width;
         /*+           Initialize selection information.l
         */6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);o       } "     if (state & RedrawWidgetState)       { 
         /*%           Redraw Font Browser window. 
         */&         x=font_info->max_bounds.width;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent;iP         XDrawString(display,windows->widget.id,windows->widget.annotate_context,7           x,y,FontPatternText,strlen(FontPatternText));d9         (void) sprintf(text_info.text,"%s",glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info);(@         XDrawBeveledButton(display,&windows->widget,&back_info);A         XDrawBeveledButton(display,&windows->widget,&reset_info);p?         XDrawBeveledMatte(display,&windows->widget,&list_info);gA         XDrawBeveledMatte(display,&windows->widget,&scroll_info);*A         XDrawTriangleNorth(display,&windows->widget,&north_info);tB         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);c&         x=font_info->max_bounds.width;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent;iP         XDrawString(display,windows->widget.id,windows->widget.annotate_context,1           x,y,FontnameText,strlen(FontnameText)); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);7         XHighlightWidget(display,&windows->widget,4,4);t         selection_info.id=(~0);t!         state|=RedrawActionState;f         state|=RedrawListState; $         state&=(~RedrawWidgetState);       }i      if (state & UpdateListState)       {R         char           **checklist;           inth           number_fonts;n  
         /*           Update font list.n
         */G         checklist=XListFonts(display,glob_pattern,32767,&number_fonts);+(         if (checklist == (char **) NULL)           {t>             if ((strchr(glob_pattern,'*') == (char *) NULL) &&<                 (strchr(glob_pattern,'?') == (char *) NULL))               {w                 /*3                   Might be a scaleable font-- exit.                  */2                 (void) strcpy(reply,glob_pattern);9                 (void) strcpy(glob_pattern,back_pattern);d)                 action_info.raised=False; J                 XDrawBeveledButton(display,&windows->widget,&action_info);                 break;               }.5             (void) strcpy(glob_pattern,back_pattern);e             XBell(display,0);e           }          else            if (number_fonts == 1)
             {_               /*3                 Reply is a single font name-- exit.o               */0               (void) strcpy(reply,checklist[0]);7               (void) strcpy(glob_pattern,back_pattern);/(               XFreeFontNames(checklist);'               action_info.raised=False;iH               XDrawBeveledButton(display,&windows->widget,&action_info);               break;
             }o           else
             {;'               XFreeFontNames(listhead);l&               free((char *) fontlist);!               fontlist=checklist;n!               fonts=number_fonts;f
             } 
         /*,           Sort font list in ascending order.
         */         listhead=fontlist;9         fontlist=(char **) malloc(fonts*sizeof(char **));1'         if (fontlist == (char **) NULL)w           { B             XNoticeWidget(display,windows,"Unable to view fonts:",*               "Memory allocation failed");             return;o           }r!         for (i=0; i < fonts; i++)l"           fontlist[i]=listhead[i];6         qsort((void *) fontlist,fonts,sizeof(char **),H           (int (*) _Declare((const void *, const void *))) FontCompare);         slider_info.height=_J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;"         if (fonts > visible_fonts)F           slider_info.height=(visible_fonts*slider_info.height)/fonts;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0;s(         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);.         list_info.id=(~0);         state|=RedrawListState;i
         /*#           Redraw font name & reply.i
         */         *reply_info.text='\0';*         reply_info.cursor=reply_info.text;9         (void) sprintf(text_info.text,"%s",glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info); =         XDrawMatteText(display,&windows->widget,&reply_info);tA         XDrawBeveledMatte(display,&windows->widget,&scroll_info);tA         XDrawTriangleNorth(display,&windows->widget,&north_info);bB         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);;7         XHighlightWidget(display,&windows->widget,4,4);0"         state&=(~UpdateListState);       }l      if (state & RedrawListState)       {i
         /*+           Determine slider id and position.t
         */:         if (slider_info.id >= (int) (fonts-visible_fonts))-           slider_info.id=fonts-visible_fonts;f=         if ((slider_info.id < 0) || (fonts <= visible_fonts))a           slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (fonts > 0)           slider_info.y+=aI             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/fonts; 0         if (slider_info.id != selection_info.id)           {o             /*/               Redraw scroll bar and file names.o             */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; -             for (i=0; i < visible_fonts; i++) 
             {iG               selection_info.raised=(slider_info.id+i) != list_info.id;>0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < fonts)_?                 selection_info.text=fontlist[slider_info.id+i];)H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }t             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {l?                 expose_info.height=slider_info.y-expose_info.y;l?                 expose_info.y=slider_info.y-expose_info.height-i,                   slider_info.bevel_width-1;               }a             else               {d?                 expose_info.height=expose_info.y-slider_info.y;w?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               }>E             XDrawTriangleNorth(display,&windows->widget,&north_info);t>             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info); (             expose_info.y=slider_info.y;           }_"         state&=(~RedrawListState);       }i"     if (state & RedrawActionState)       {g         XFontStructd           *font_info,            *save_info;~  
         /*6           Display the selected font in a drawing area.
         */,         save_info=windows->widget.font_info;:         font_info=XLoadQueryFont(display,reply_info.text);.         if (font_info != (XFontStruct *) NULL)           { 1             windows->widget.font_info=font_info;;mL             XSetFont(display,windows->widget.widget_context,font_info->fid);           } @         XDrawBeveledButton(display,&windows->widget,&mode_info);,         windows->widget.font_info=save_info;.         if (font_info != (XFontStruct *) NULL)           {r<             XSetFont(display,windows->widget.widget_context,.               windows->widget.font_info->fid);)             XFreeFont(display,font_info);            } 7         XHighlightWidget(display,&windows->widget,4,4);h=         XDrawMatteText(display,&windows->widget,&reply_info);u$         state&=(~RedrawActionState);       }v     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       {h
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)n!           if (slider_info.id > 0)l
             {t               /*                 Move slider up.y               */               slider_info.id--;s%               state|=RedrawListState;g
             }o         if (!south_info.raised) %           if (slider_info.id < fonts)u
             {i               /*!                 Move slider down.l               */               slider_info.id++;.%               state|=RedrawListState;f
             }e(         if (event.type != ButtonRelease)           continue;t       }L     switch (event.type)      {        case ButtonPress:.       { 5         if (MatteIsActive(slider_info,event.xbutton))c           {n             /*               Track slider.x             */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)(
             {s               /*                 Move slider up.h               */&               north_info.raised=False;               slider_info.id--;e%               state|=RedrawListState;S               break;
             }i4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < fonts)S
             {                /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;                break;
             }s5         if (MatteIsActive(scroll_info,event.xbutton))b           {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_fonts-1);             else0               slider_info.id+=(visible_fonts-1);#             state|=RedrawListState;              break;           }r3         if (MatteIsActive(list_info,event.xbutton))            {o             unsigned int               id;t               /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= fonts)               break;8             (void) strcpy(reply_info.text,fontlist[id]);'             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info);e%             state|=RedrawActionState;f#             if (id == list_info.id)                { <                 (void) strcpy(glob_pattern,reply_info.text);'                 state|=UpdateListState;.               }g#             selection_info.id=(~0);e             list_info.id=id;#             state|=RedrawListState;              break;           }t3         if (MatteIsActive(back_info,event.xbutton))e           {r             /*'               User pressed Back button.f             */#             back_info.raised=False;TD             XDrawBeveledButton(display,&windows->widget,&back_info);             break;           }e4         if (MatteIsActive(reset_info,event.xbutton))           {e             /*(               User pressed Reset button.             */$             reset_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           }i5         if (MatteIsActive(action_info,event.xbutton))e           {i             /*)               User pressed action button.e             */%             action_info.raised=False;dF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }c5         if (MatteIsActive(cancel_info,event.xbutton))i           {,             /*)               User pressed Cancel button.v             */%             cancel_info.raised=False;pF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }w5         if (!MatteIsActive(reply_info,event.xbutton))&           break;,         if (event.xbutton.button != Button2)           {              static Time                click_time;                /*;               Move text cursor to position of button press.              */N             x=event.xbutton.x-reply_info.x-(font_info->max_bounds.width >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;t             else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;                }tA             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           };
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);s         break;       }        case ButtonRelease:o       {a$         if (!windows->widget.mapped)           break;         if (!north_info.raised)            {              /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);o           };         if (!south_info.raised)            {              /*(               User released down button.             */#             delay=SuspendTime << 2;b#             south_info.raised=True;*E             XDrawTriangleSouth(display,&windows->widget,&south_info);t           }r         if (slider_info.active)f           {e             /*#               Stop tracking slider.i             */%             slider_info.active=False;L             break;           }          if (!back_info.raised)           {f;             if (event.xbutton.window == windows->widget.id) 9               if (MatteIsActive(back_info,event.xbutton))s                 { ;                   (void) strcpy(glob_pattern,back_pattern);i)                   state|=UpdateListState;                  }h"             back_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&back_info);           }          if (!reset_info.raised)l           { ;             if (event.xbutton.window == windows->widget.id)o:               if (MatteIsActive(reset_info,event.xbutton))                 {s;                   (void) strcpy(back_pattern,glob_pattern);a<                   (void) strcpy(glob_pattern,reset_pattern);)                   state|=UpdateListState;b                 }.#             reset_info.raised=True;LE             XDrawBeveledButton(display,&windows->widget,&reset_info);            }i          if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id)(;               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0') #                   XBell(display,0);l                 else#                   state|=ExitState;e$             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }           if (!cancel_info.raised)           {o;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))f                 {r(                   *reply_info.text='\0';#                   state|=ExitState;                  } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }B         break;       }d       case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {dG             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);i             break;           }r?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            {e"             *reply_info.text='\0';             state|=ExitState;              break;           }x         break;       }i       case ConfigureNotify:i       {(
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }e       case EnterNotify:        {t9         if (event.xcrossing.window != windows->widget.id)i           break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       {e7         if (event.xexpose.window != windows->widget.id)l           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;.         break;       }n       case KeyPress:       {Y         static char !           command[MaxTextLength];t           static int           length;            static KeySyme           key_symbol;f  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),t/           &key_symbol,(XComposeStatus *) NULL);r         *(command+length)='\0';h2         if (MatteIsActive(scroll_info,event.xkey))           {              /*               Move slider.             */             switch (key_symbol)e
             {                case XK_Home:o               case XK_KP_Home:               {s!                 slider_info.id=0;                  break;               }c               case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;i                 break;               }                case XK_Down:_               case XK_KP_Down:               {.!                 slider_info.id++;d                 break;               }i               case XK_Prior:               case XK_KP_Prior:i               { .                 slider_info.id-=visible_fonts;                 break;               }                case XK_Next:                case XK_KP_Next:               { .                 slider_info.id+=visible_fonts;                 break;               }                case XK_End:               case XK_KP_End:                {s%                 slider_info.id=fonts;                  break;               }r
             }t#             state|=RedrawListState;              break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {c             /*,               Read new font or glob patterm.             */)             if (*reply_info.text == '\0'))               break;5             (void) strcpy(back_pattern,glob_pattern); 8             (void) strcpy(glob_pattern,reply_info.text);#             state|=UpdateListState;&             break;           } '         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)n           switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;=               break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);a         break;       }i       case KeyRelease:       {a         static chary!           command[MaxTextLength];            static KeySymc           key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),E/           &key_symbol,(XComposeStatus *) NULL);l'         if (key_symbol == XK_Control_L)l!           state&=(~ControlState);c         break;       }        case LeaveNotify:i       {i9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }w       case MotionNotify:       { 
         /*/           Discard pending button motion events.l
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));u         if (slider_info.active)t           {s             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;a3             if (slider_info.y != slider_info.min_y) I               slider_info.id=(fonts*(slider_info.y-slider_info.min_y+1))/o8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;g             break;           }x(         if (state & InactiveWidgetState)           break;G         if (back_info.raised == MatteIsActive(back_info,event.xmotion))w           {t             /*)               Back button status changed.a             *//             back_info.raised=!back_info.raised;tD             XDrawBeveledButton(display,&windows->widget,&back_info);             break;           }fI         if (reset_info.raised == MatteIsActive(reset_info,event.xmotion))            {t             /**               Reset button status changed.             */1             reset_info.raised=!reset_info.raised;dE             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           }eK         if (action_info.raised == MatteIsActive(action_info,event.xmotion))t           {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }eK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))k           {z             /*+               Cancel button status changed.)             */3             cancel_info.raised=!cancel_info.raised;lF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }        case SelectionClear:       {e#         reply_info.highlight=False; =         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }        case SelectionNotify:        {          Atom           type;            int            format,.           status;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)P           break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);          else           {              /*5               Insert primary selection in reply text.              */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state);rA             XDrawMatteText(display,&windows->widget,&reply_info);t%             state|=RedrawActionState;            }s         XFree((void *) data);e         break;       }U       case SelectionRequest:       {          XSelectionEvente           notify;r           XSelectionRequestEvent           *request;   
         /*#           Set XA_PRIMARY selection. 
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }t       default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False);mE   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   /*     Free font list.a   */   XFreeFontNames(listhead);o   free((char *) fontlist); }/   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %LO %                                                                             %eO %                                                                             % O %   X I n f o W i d g e t                                                     % O %                                                                             %tO %                                                                             %,O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %-L %  Function XInfoWidget displays text in the Info widget.  The purpose is toH %  inform the user that what activity is currently being performed (e.g.. %  reading an image, rotating an image, etc.). % , %  The format of the XInfoWidget routine is: %l* %    XInfoWidget(display,windows,activity) % + %  A description of each parameter follows:o %nE %    o display: Specifies a connection to an X server;  returned fromi %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.R %aK %    o activity: This character string reflects the current activity and isi$ %      displayed in the Info widget. %( %b */* void XInfoWidget(display,windows,activity) Display    *display;    XWindows   *windows;    char   *activity; {a   unsigned int     height,      margin,f
     width;  
   XFontStruct      *font_info;B  
   XWidgetInfol     monitor_info;,     XWindowChanges     window_changes;      /*     Map Info widget.   */$   font_info=windows->info.font_info;8   width=XTextWidth(font_info,activity,strlen(activity))+-     ((3*font_info->max_bounds.width) >> 1)+2; =   height=((6*(font_info->ascent+font_info->descent)) >> 2)+2;vI   if ((windows->info.width != width) || (windows->info.height != height))      {        /*9         Size Info widget to accomodate the activity text.m       */        windows->info.width=width;"       windows->info.height=height;!       window_changes.width=width;c#       window_changes.height=height; I       XReconfigureWMWindow(display,windows->info.id,windows->info.screen, ,         CWWidth | CWHeight,&window_changes);     }f   if (!windows->info.mapped))     XMapWindow(display,windows->info.id);    /*&     Initialize Info matte information.   */.   height=font_info->ascent+font_info->descent;)   XGetWidgetInfo(activity,&monitor_info);a   monitor_info.bevel_width--;-I   margin=monitor_info.bevel_width+((windows->info.height-height) >> 1)-2;    monitor_info.raised=False;   monitor_info.x=margin;   monitor_info.y=margin;7   monitor_info.width=windows->info.width-(margin << 1);i9   monitor_info.height=windows->info.height-(margin << 1);y   /*     Draw Info widget.    */:   XDrawBeveledMatte(display,&windows->info,&monitor_info);   monitor_info.raised=True; 8   XDrawWidgetText(display,&windows->info,&monitor_info); },   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %;O %                                                                             % O %                                                                             %nO %   X L i s t B r o w s e r W i d g e t                                       %rO %                                                                             %(O %                                                                             % O %                                                                             %lO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%( %pK %  Function XListBrowserWidget displays a Widget widget with a query to the J %  user.  The user keys a reply or select a reply from the list.  Finally,K %  the user presses the Action or Cancel button to exit.  The typed text is , %  returned as the reply function parameter. %s3 %  The format of the XListBrowserWidget routine is:i % L %    XListBrowserWidget(display,windows,window_info,list,action,query,reply) %f+ %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned fromt %      XOpenDisplay. %C; %    o window: Specifies a pointer to a XWindows structure.o %tF %    o list: Specifies a pointer to an array of strings.  The user can; %      select from these strings as a possible reply value.  %i@ %    o action: Specifies a pointer to the action of this widget. %oF %    o query: Specifies a pointer to the query to present to the user. %;G %    o reply: The response from the user is returned in this parameter.u %- %r */L void XListBrowserWidget(display,windows,window_info,list,action,query,reply) Display    *display;t   XWindows   *windows;    XWindowInfo    *window_info;=   char	   **list, 
   *action,	   *query,n	   *reply;d {l" #define CancelButtonText  "Cancel"     char%     primary_selection[MaxTextLength];      intl     entries,     x,     y;     register int     i;     unsigned int     height,a     text_width,      visible_entries,
     width;     unsigned longs
     delay,
     state;     XEvent
     event;  
   XFontStruct*     *font_info;l     XTextPropertyi     window_name;  
   XWidgetInfor     action_info,     cancel_info,     expose_info,     list_info,     north_info,      reply_info,%     scroll_info,     selection_info,%     slider_info,     south_info,      text_info;     XWindowChanges     window_changes;      /*,     Count the number of entries in the list.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   if (list == (char **) NULL)      { H       XNoticeWidget(display,windows,"No text to browse:",(char *) NULL);
       return;      }    for (entries=0; ; entries++)'     if (list[entries] == (char *) NULL)        break;   /*'     Determine Widget widget attributes.    */#   font_info=window_info->font_info; 7   text_width=XTextWidth(font_info,query,strlen(query));%   for (i=0; i < entries; i++)%C     if (XTextWidth(font_info,list[i],strlen(list[i])) > text_width)d?       text_width=XTextWidth(font_info,list[i],strlen(list[i]));u4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));%   width+=font_info->max_bounds.width;i.   height=font_info->ascent+font_info->descent;   /*     Position Widget widget.    */   window_info->width=XH     Min(text_width,MaxTextWidth)+((9*font_info->max_bounds.width) >> 1);D   window_info->min_width=MinTextWidth+4*font_info->max_bounds.width;2   if (window_info->width < window_info->min_width).     window_info->width=window_info->min_width;   window_info->height=A     ((81*height) >> 2)+((13*font_info->max_bounds.width) >> 1)+4;w   window_info->min_height=A     ((23*height) >> 1)+((13*font_info->max_bounds.width) >> 1)+4;o4   if (window_info->height < window_info->min_height)0     window_info->height=window_info->min_height;2   XQueryPosition(display,window_info->root,&x,&y);1   window_info->x=x-((3*window_info->width) >> 2); .   window_info->y=y-(window_info->height >> 1);0   XConstrainWindowPosition(display,window_info);   /*     Map Widget widget.   */,   (void) strcpy(window_info->name,"Browse");F   (void) XStringListToTextProperty(&window_info->name,1,&window_name);3   XSetWMName(display,window_info->id,&window_name); *   window_changes.width=window_info->width;,   window_changes.height=window_info->height;"   window_changes.x=window_info->x;"   window_changes.y=window_info->y;L   XReconfigureWMWindow(display,window_info->id,window_info->screen,CWWidth |*     CWHeight | CWX | CWY,&window_changes);&   XMapRaised(display,window_info->id);   window_info->mapped=False;   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);x,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_entries=0;   delay=SuspendTime << 2; !   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)x       {          intx
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; ;         cancel_info.x=window_info->width-cancel_info.width-x(           font_info->max_bounds.width-2;=         cancel_info.y=window_info->height-cancel_info.height- &           font_info->max_bounds.width;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; 7         action_info.x=cancel_info.x-(cancel_info.width+xM           (font_info->max_bounds.width >> 1)+(action_info.bevel_width << 1));e$         action_info.y=cancel_info.y;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;          reply_info.width=8D           window_info->width-((4*font_info->max_bounds.width) >> 1);&         reply_info.height=height << 1;1         reply_info.x=font_info->max_bounds.width;          reply_info.y=0F           action_info.y-reply_info.height-font_info->max_bounds.width;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);0"         scroll_info.bevel_width--;!         scroll_info.width=height;0         scroll_info.height=0E           reply_info.y-((6*font_info->max_bounds.width) >> 1)-height; H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);         scroll_info.y=O           ((5*font_info->max_bounds.width) >> 1)+height-reply_info.bevel_width;0!         scroll_info.raised=False;0          scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True;08         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;x-         north_info.x+=north_info.bevel_width;x-         north_info.y+=north_info.bevel_width;x         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;x         slider_info.id=id;         slider_info.width-=2;xP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_entries=A           (scroll_info.height-(height >> 3)-4)/((9*height) >> 3);0&         if (entries > visible_entries)J           slider_info.height=(visible_entries*slider_info.height)/entries;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;f          list_info.bevel_width--;         list_info.width=H           scroll_info.x-reply_info.x-(font_info->max_bounds.width >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x;0"         list_info.y=scroll_info.y;!         if (!window_info->mapped)f%           for (i=0; i < entries; i++)x+             if (strcmp(list[i],reply) == 0)                list_info.id=i;x
         /*&           Initialize text information.
         */)         XGetWidgetInfo(query,&text_info);x)         text_info.width=reply_info.width;7          text_info.height=height;C         text_info.x=list_info.x-(font_info->max_bounds.width >> 1); 0         text_info.y=font_info->max_bounds.width;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=list_info.width;x.         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);f       }x"     if (state & RedrawWidgetState)       { 
         /*%           Redraw List Browser window.f
         */&         x=font_info->max_bounds.width;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; 8         XDrawWidgetText(display,window_info,&text_info);:         XDrawBeveledMatte(display,window_info,&list_info);<         XDrawBeveledMatte(display,window_info,&scroll_info);<         XDrawTriangleNorth(display,window_info,&north_info);=         XDrawBeveledButton(display,window_info,&slider_info); <         XDrawTriangleSouth(display,window_info,&south_info);&         x=font_info->max_bounds.width;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; ;         XDrawBeveledMatte(display,window_info,&reply_info);x8         XDrawMatteText(display,window_info,&reply_info);=         XDrawBeveledButton(display,window_info,&action_info);0=         XDrawBeveledButton(display,window_info,&cancel_info);x2         XHighlightWidget(display,window_info,4,4);         selection_info.id=(~0);0!         state|=RedrawActionState;0         state|=RedrawListState; $         state&=(~RedrawWidgetState);       }t      if (state & RedrawListState)       {b
         /*+           Determine slider id and position.f
         */>         if (slider_info.id >= (int) (entries-visible_entries))1           slider_info.id=entries-visible_entries; A         if ((slider_info.id < 0) || (entries <= visible_entries))e           slider_info.id=0;t(         slider_info.y=slider_info.min_y;         if (entries > 0)           slider_info.y+= K             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/entries; 0         if (slider_info.id != selection_info.id)           {a             /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id;i9             selection_info.y=list_info.y+(height >> 3)+2;)/             for (i=0; i < visible_entries; i++) 
             {wG               selection_info.raised=(slider_info.id+i) != list_info.id;d0               selection_info.text=(char *) NULL;/               if ((slider_info.id+i) < entries)d;                 selection_info.text=list[slider_info.id+i];dC               XDrawWidgetText(display,window_info,&selection_info);m<               selection_info.y+=(int) selection_info.height;
             }0             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height-e,                   slider_info.bevel_width-1;               }M             else               {i?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+n,                   slider_info.bevel_width+1;               }e@             XDrawTriangleNorth(display,window_info,&north_info);9             XDrawMatte(display,window_info,&expose_info);eA             XDrawBeveledButton(display,window_info,&slider_info);t@             XDrawTriangleSouth(display,window_info,&south_info);(             expose_info.y=slider_info.y;           }t"         state&=(~RedrawListState);       }r     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)u=       XIfEvent(display,&event,XScreenEvent,(char *) windows);d     else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */               slider_info.id--;c%               state|=RedrawListState;n
             }          if (!south_info.raised) '           if (slider_info.id < entries)r
             {o               /*!                 Move slider down.o               */               slider_info.id++;e%               state|=RedrawListState; 
             }o(         if (event.type != ButtonRelease)           continue;        }      switch (event.type)      {        case ButtonPress:        {t5         if (MatteIsActive(slider_info,event.xbutton))l           {              /*               Track slider.i             */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)i
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--;e%               state|=RedrawListState;                break;
             }s4         if (MatteIsActive(south_info,event.xbutton))'           if (slider_info.id < entries)>
             {                /*!                 Move slider down.!               */&               south_info.raised=False;               slider_info.id++;m%               state|=RedrawListState;                break;
             }i5         if (MatteIsActive(scroll_info,event.xbutton))d           {t             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)2               slider_info.id-=(visible_entries-1);             else2               slider_info.id+=(visible_entries-1);#             state|=RedrawListState;              break;           }c3         if (MatteIsActive(list_info,event.xbutton))            {c             unsigned int               id;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= entries)               break;4             (void) strcpy(reply_info.text,list[id]);'             reply_info.highlight=False;x.             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);<             XDrawMatteText(display,window_info,&reply_info);#             selection_info.id=(~0); #             if (id == list_info.id)n               { )                 action_info.raised=False;dE                 XDrawBeveledButton(display,window_info,&action_info);n!                 state|=ExitState;n               }              list_info.id=id;#             state|=RedrawListState;              break;           } 5         if (MatteIsActive(action_info,event.xbutton))            {f             /*)               User pressed action button.              */%             action_info.raised=False;sA             XDrawBeveledButton(display,window_info,&action_info);e             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {y             /*)               User pressed Cancel button.              */%             cancel_info.raised=False; A             XDrawBeveledButton(display,window_info,&cancel_info);              break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {+             static Time                click_time;                /*;               Move text cursor to position of button press.e             */N             x=event.xbutton.x-reply_info.x-(font_info->max_bounds.width >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;C             else               {.                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text);mF                 XSetSelectionOwner(display,XA_PRIMARY,window_info->id,&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) =="                   window_info->id;               }y<             XDrawMatteText(display,window_info,&reply_info);*             click_time=event.xbutton.time;             break;           }n
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING,u.           window_info->id,event.xbutton.time);         break;       }w       case ButtonRelease:o       {5!         if (!window_info->mapped)w           break;         if (!north_info.raised)o           {              /*&               User released up button.             */#             delay=SuspendTime << 2;u#             north_info.raised=True; @             XDrawTriangleNorth(display,window_info,&north_info);           }-         if (!south_info.raised)            {<             /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True;s@             XDrawTriangleSouth(display,window_info,&south_info);           },         if (slider_info.active)            {g             /*#               Stop tracking slider.i             */%             slider_info.active=False;%             break;           }%          if (!action_info.raised)           { 8             if (event.xbutton.window == window_info->id);               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0') #                   XBell(display,0);                  else#                   state|=ExitState; $             action_info.raised=True;A             XDrawBeveledButton(display,window_info,&action_info);            }           if (!cancel_info.raised)           { 8             if (event.xbutton.window == window_info->id);               if (MatteIsActive(cancel_info,event.xbutton))%                 {%(                   *reply_info.text='\0';#                   state|=ExitState;l                 } $             cancel_info.raised=True;A             XDrawBeveledButton(display,window_info,&cancel_info);r           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;         break;       }s       case ClientMessage:d       {n
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {XG             XSetInputFocus(display,event.xclient.window,RevertToParent,u'               event.xclient.data.l[1]);e             break;           }n?         if (*event.xclient.data.l != windows->wm_delete_window)l           break;4         if (event.xclient.window == window_info->id)           {g"             *reply_info.text='\0';             state|=ExitState;h             break;           }          break;       }e       case ConfigureNotify:o       {e
         /*&           Update widget configuration.
         */7         if (event.xconfigure.window != window_info->id)            break;=         if ((event.xconfigure.width == window_info->width) && =             (event.xconfigure.height == window_info->height))            break;         window_info->width= =           Max(event.xconfigure.width,window_info->min_width);r         window_info->height=?           Max(event.xconfigure.height,window_info->min_height);n(         state|=UpdateConfigurationState;         break;       }n       case EnterNotify:e       {o6         if (event.xcrossing.window != window_info->id)           break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       {a4         if (event.xexpose.window != window_info->id)           break;%         if (event.xexpose.count != 0)f           break;!         state|=RedrawWidgetState;q         break;       })       case KeyPress:       {d         static charr!           command[MaxTextLength];t           static int           length;            static KeySymt           key_symbol;d  1         if (event.xkey.window != window_info->id)d           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),e/           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0';h2         if (MatteIsActive(scroll_info,event.xkey))           {)             /*               Move slider.             */             switch (key_symbol)i
             {)               case XK_Home:n               case XK_KP_Home:               {-!                 slider_info.id=0;                  break;               }w               case XK_Up:                case XK_KP_Up:               {w!                 slider_info.id--;t                 break;               }a               case XK_Down:M               case XK_KP_Down:               { !                 slider_info.id++;t                 break;               }-               case XK_Prior:               case XK_KP_Prior:d               {o0                 slider_info.id-=visible_entries;                 break;               }                case XK_Next:|               case XK_KP_Next:               {o0                 slider_info.id+=visible_entries;                 break;               }                case XK_End:               case XK_KP_End:r               {S'                 slider_info.id=entries;o                 break;               }o
             } #             state|=RedrawListState;N             break;           }/E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))l           {o             /*               Read new entry.h             */)             if (*reply_info.text == '\0')                break;%             action_info.raised=False;.A             XDrawBeveledButton(display,window_info,&action_info);x             state|=ExitState;i             break;           }c'         if (key_symbol == XK_Control_L)c           {               state|=ControlState;             break;           }>!         if (state & ControlState)(           switch (key_symbol)            {f             case XK_u:             case XK_U:
             {e               /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;g               break;
             }e             default:               break;           }*@         XEditText(display,&reply_info,key_symbol,command,state);8         XDrawMatteText(display,window_info,&reply_info);         break;       };       case KeyRelease:       {          static chara!           command[MaxTextLength];            static KeySyme           key_symbol;s  1         if (event.xkey.window != window_info->id)d           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),,/           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L) !           state&=(~ControlState);S         break;       }w       case LeaveNotify:y       { 6         if (event.xcrossing.window != window_info->id)           break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events.D
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)t           {e             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y).K               slider_info.id=(entries*(slider_info.y-slider_info.min_y+1))/ 8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;d             break;           }n(         if (state & InactiveWidgetState)           break;K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {I             /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; A             XDrawBeveledButton(display,window_info,&action_info);B             break;           }dK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))s           {              /*+               Cancel button status changed.i             */3             cancel_info.raised=!cancel_info.raised;_A             XDrawBeveledButton(display,window_info,&cancel_info);w             break;           }          break;       }F       case SelectionClear:       {e#         reply_info.highlight=False;i8         XDrawMatteText(display,window_info,&reply_info);         break;       }.       case SelectionNotify:w       {          Atom           type;c           int            format,            status;            unsigned char            *data;           unsigned long            after,           length;e  
         /*1           Obtain response from primary selection.t
         */5         if (event.xselection.property == (Atom) None)i           break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);;         else           {              /*5               Insert primary selection in reply text.!             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state);v<             XDrawMatteText(display,window_info,&reply_info);%             state|=RedrawActionState;            }a         XFree((void *) data);S         break;       }        case SelectionRequest:       {          XSelectionEvent            notify;x           XSelectionRequestEvent           *request;b  "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));oN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;         notify.send_event=True;s(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }e       default:         break;     }g!   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False);c?   XWithdrawWindow(display,window_info->id,window_info->screen); (   XCheckRefreshWindows(display,windows); }/   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             %fO %                                                                             % O %                                                                             %eO %   X M e n u W i d g e t                                                     %-O %                                                                             % O %                                                                             %tO %                                                                             %dO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %mM %  Function XMenuWidget maps a menu and returns the command pointed to by the%$ %  user when the button is released. % , %  The format of the XMenuWidget routine is: % H %    selection_number=XMenuWidget(display,windows,title,selections,item) % + %  A description of each parameter follows:  % G %    o selection_number: Specifies the number of the selection that the  %      user choose.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % N %    o title: Specifies a character string that describes the menu selections. % K %    o selections: Specifies a pointer to one or more strings that comprise% %      the choices in the menu.  %nJ %    o item: Specifies a character array.  The item selected from the menu %      is returned here. %s %t */6 int XMenuWidget(display,windows,title,selections,item) Displaye   *display;o   XWindows   *windows;f   char	   *title,g   **selections;:   char   *item; {g   Cursor     cursor;o     inte     id,      x,     y;     unsigned int     height,      number_selections,     title_height, 
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStructi     *font_info;s     XSetWindowAttributes     window_attributes;  
   XWidgetInfoo     menu_info,     selection_info;c     XWindowChanges     window_changes;o     /*'     Determine Widget widget attributes.h   */(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;B   windows->widget.width=XTextWidth(font_info,title,strlen(title));3   for (id=0; selections[id] != (char *) NULL; id++)f   {aF     width=XTextWidth(font_info,selections[id],strlen(selections[id]));&     if (width > windows->widget.width)"       windows->widget.width=width;   }m   number_selections=id;i+   XGetWidgetInfo((char *) NULL,&menu_info);eA   title_height=(3*(font_info->descent+font_info->ascent) >> 1)+5;t2   width=XTextWidth(font_info,title,strlen(title));9   height=(5*(font_info->ascent+font_info->descent)) >> 2;    /*     Position Widget widget.    */7   windows->widget.width+=font_info->max_bounds.width+6;b   windows->widget.height=sG     title_height+number_selections*height+(menu_info.bevel_width << 1);t2   windows->widget.min_width=windows->widget.width;4   windows->widget.min_height=windows->widget.height;5   XQueryPosition(display,windows->widget.root,&x,&y);n9   windows->widget.x=x-(font_info->max_bounds.width >> 1);i#   if (windows->widget.x_origin > 0)t     {n       /*+         Menu is relative to Command widget.e       */1       windows->widget.x=windows->widget.x_origin;d9       if (windows->widget.width < windows->command.width)b5         windows->widget.width=windows->command.width-t:           (((font_info->max_bounds.width >> 1)+4) << 1)+4;     }(.   windows->widget.y=y-((3*title_height) >> 2);#   if (windows->widget.y_origin > 0)-/     windows->widget.y=windows->widget.y_origin;i5   XConstrainWindowPosition(display,&windows->widget);d   /*     Map Widget widget.   */+   window_attributes.override_redirect=True;iH   XChangeWindowAttributes(display,windows->widget.id,CWOverrideRedirect,     &window_attributes);-   window_changes.width=windows->widget.width;./   window_changes.height=windows->widget.height;d%   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y;dI   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,-4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);)   windows->widget.mapped=False;>   /*     Respond to X events.   */   selection_info.height=height; 1   cursor=XCreateFontCursor(display,XC_right_ptr); 2   XDefineCursor(display,windows->image.id,cursor);!   state=UpdateConfigurationState;n   do   {d)     if (state & UpdateConfigurationState)e       { 
         /*+           Initialize selection information. 
         */1         XGetWidgetInfo((char *) NULL,&menu_info);p          menu_info.bevel_width--;M         menu_info.width=windows->widget.width-((menu_info.bevel_width) << 1);gO         menu_info.height=windows->widget.height-((menu_info.bevel_width) << 1);t*         menu_info.x=menu_info.bevel_width;*         menu_info.y=menu_info.bevel_width;6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=menu_info.width;i%         selection_info.height=height;g%         selection_info.x=menu_info.x;w+         state&=(~UpdateConfigurationState);        }i"     if (state & RedrawWidgetState)       {l
         /*           Redraw Menu widget.h
         */8         XDrawBevel(display,&windows->widget,&menu_info);         y=title_height-1;_7         XSetBevelColor(display,&windows->widget,False);iL         XDrawLine(display,windows->widget.id,windows->widget.widget_context,?           selection_info.x,y-1,(int) selection_info.width,y-1);l6         XSetBevelColor(display,&windows->widget,True);L         XDrawLine(display,windows->widget.id,windows->widget.widget_context,;           selection_info.x,y,(int) selection_info.width,y);;H         XSetFillStyle(display,windows->widget.widget_context,FillSolid);
         /*           Draw menu selections. 
         */#         selection_info.raised=True;e#         selection_info.center=True;i         selection_info.y=4;o"         selection_info.text=title;B         XDrawWidgetText(display,&windows->widget,&selection_info);&         selection_info.y=title_height;0         for (id=0; id < number_selections; id++)	         {r:           selection_info.raised=(id != selection_info.id);&           selection_info.center=False;-           selection_info.text=selections[id];fD           XDrawWidgetText(display,&windows->widget,&selection_info);8           selection_info.y+=(int) selection_info.height;	         }h$         state&=(~RedrawWidgetState);       }n     if (number_selections > 2)       {t
         /*           Redraw Menu line.f
         */C         y=title_height+selection_info.height*(number_selections-1);=7         XSetBevelColor(display,&windows->widget,False); L         XDrawLine(display,windows->widget.id,windows->widget.widget_context,?           selection_info.x,y-1,(int) selection_info.width,y-1); 6         XSetBevelColor(display,&windows->widget,True);L         XDrawLine(display,windows->widget.id,windows->widget.widget_context,;           selection_info.x,y,(int) selection_info.width,y); H         XSetFillStyle(display,windows->widget.widget_context,FillSolid);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);w     switch (event.type)      {        case ButtonPress:y       {-
         /*/           Discard pending button motion events.d
         */7         if (event.xbutton.window != windows->widget.id)            {a             /*               Exit menu.             */*             XPutBackEvent(display,&event);             *item='\0';              state|=ExitState;              break;           }f)         if (windows->widget.x_origin > 0) H           if ((event.xbutton.y > 0) && (event.xbutton.y < title_height))
             {                *item='\0';i               state|=ExitState;s               break;
             }n&         state&=(~InactiveWidgetState);F         id=(event.xbutton.y-title_height)/(int) selection_info.height;         selection_info.id=id; 2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection. 
         */?         selection_info.y=title_height+id*selection_info.height; $         selection_info.raised=False;+         selection_info.text=selections[id]; B         XDrawWidgetText(display,&windows->widget,&selection_info);         break;       }        case ButtonRelease:d       { $         if (!windows->widget.mapped)           break;)         if (windows->widget.x_origin > 0) H           if ((event.xbutton.y > 0) && (event.xbutton.y < title_height))             break;
         /*           Exit menu.
         */         *item='\0';m         state|=ExitState;e         break;       }        case ConfigureNotify:        {o
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height=FB           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:i       {(9         if (event.xcrossing.window != windows->widget.id)e           break;'         if (event.xcrossing.state == 0)            break;&         state&=(~InactiveWidgetState);J         id=((event.xcrossing.y-title_height)/(int) selection_info.height);2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection.l
         */         selection_info.id=id;rN         selection_info.y=title_height+selection_info.id*selection_info.height;$         selection_info.raised=False;:         selection_info.text=selections[selection_info.id];B         XDrawWidgetText(display,&windows->widget,&selection_info);         break;       }        case Expose:       {)7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)-           break;!         state|=RedrawWidgetState;i         break;       }        case LeaveNotify:a       { 9         if (event.xcrossing.window != windows->widget.id)u           break;#         state|=InactiveWidgetState;          id=selection_info.id;i2         if ((id < 0) || (id >= number_selections))           break;
         /*%           Unhighlight last selection.i
         */?         selection_info.y=title_height+id*selection_info.height;'         selection_info.id=(~0);i#         selection_info.raised=True; +         selection_info.text=selections[id];aB         XDrawWidgetText(display,&windows->widget,&selection_info);         break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events.i
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));)7         if (event.xmotion.window != windows->widget.id)w           break;(         if (state & InactiveWidgetState)           break;F         id=(event.xmotion.y-title_height)/(int) selection_info.height;P         if ((selection_info.id >= 0) && (selection_info.id < number_selections))           {i             /*)               Unhighlight last selection.=             */(             if (id == selection_info.id)               break;             selection_info.y= C               title_height+selection_info.id*selection_info.height;i'             selection_info.raised=True; >             selection_info.text=selections[selection_info.id];F             XDrawWidgetText(display,&windows->widget,&selection_info);           }g         selection_info.id=id;d2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection.t
         */?         selection_info.y=title_height+id*selection_info.height; $         selection_info.raised=False;+         selection_info.text=selections[id];_B         XDrawWidgetText(display,&windows->widget,&selection_info);         break;       }r       default:         break;     }c!   } while (!(state & ExitState));d)   XSetCursorState(display,windows,False);t,   window_attributes.override_redirect=False;H   XChangeWindowAttributes(display,windows->widget.id,CWOverrideRedirect,     &window_attributes);E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);t(   XCheckRefreshWindows(display,windows);J   if ((selection_info.id < 0) || (selection_info.id >= number_selections))     return(~0);t4   (void) strcpy(item,selections[selection_info.id]);   return(selection_info.id); }_ b /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %tO %                                                                             %XO %                                                                             %oO %   X N o t i c e W i d g e t                                                 %nO %                                                                             %tO %                                                                             % O %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %wM %  Function XNoticeWidget displays a Widget widget with a notice to the user.:C %  The function returns when the user presses the "Dismiss" button.l % . %  The format of the XNoticeWidget routine is: %f5 %    XNoticeWidget(display,windows,message,qualifier)o %x+ %  A description of each parameter follows:o %xE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.x %iG %    o message: Specifies the message to display before terminating thel %      program.e %r9 %    o qualifier: Specifies any qualifier to the message.s %  %  */5 void XNoticeWidget(display,windows,message,qualifier)] Display    *display;y   XWindows   *windows;l   char   *message,n
   *qualifier;= {n$ #define DismissButtonText  "Dismiss" #define Timeout  8     into     x,     y;     time_t
     timer;     unsigned int     height,n
     width;     unsigned long(
     state;     XEvent
     event;  
   XFontStructN     *font_info;f     XTextPropertyC     window_name;  
   XWidgetInfor     dismiss_info;      XWindowChanges     window_changes;      /*'     Determine Widget widget attributes.    */(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;J   width=XTextWidth(font_info,DismissButtonText,strlen(DismissButtonText));   if (message != (char *) NULL)s>     if (XTextWidth(font_info,message,strlen(message)) > width):       width=XTextWidth(font_info,message,strlen(message));!   if (qualifier != (char *) NULL)iB     if (XTextWidth(font_info,qualifier,strlen(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,strlen(qualifier));0   height=(font_info->ascent+font_info->descent);   /*     Position Widget widget.    */<   windows->widget.width=width+4*font_info->max_bounds.width;>   windows->widget.min_width=width+font_info->max_bounds.width;8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;#   windows->widget.height=12*height;c&   windows->widget.min_height=7*height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 3   windows->widget.x=x-(windows->widget.width >> 1);e8   windows->widget.y=y-((5*windows->widget.height) >> 3);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Widget widget.   *//   (void) strcpy(windows->widget.name,"Notice"); I   (void) XStringListToTextProperty(&windows->widget.name,1,&window_name); 6   XSetWMName(display,windows->widget.id,&window_name);-   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height;m%   window_changes.x=windows->widget.x;t%   window_changes.y=windows->widget.y;lI   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,R4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    XBell(display,0);=   /*     Respond to X events.   */&   timer=time((time_t *) NULL)+Timeout;!   state=UpdateConfigurationState;)(   XSetCursorState(display,windows,True);   do   { &     if (time((time_t *) NULL) > timer)       break;)     if (state & UpdateConfigurationState);       { 
         /*0           Initialize Dismiss button information.
         */8         XGetWidgetInfo(DismissButtonText,&dismiss_info);7         dismiss_info.width=font_info->max_bounds.width+(L           XTextWidth(font_info,DismissButtonText,strlen(DismissButtonText));,         dismiss_info.height=(3*height) >> 1;N         dismiss_info.x=(windows->widget.width >> 1)-(dismiss_info.width >> 1);I         dismiss_info.y=windows->widget.height-(dismiss_info.height << 1);e+         state&=(~UpdateConfigurationState);x       }r"     if (state & RedrawWidgetState)       {d
         /*           Redraw Notice widget. 
         */<         width=XTextWidth(font_info,message,strlen(message));4         x=(windows->widget.width >> 1)-(width >> 1);6         y=(windows->widget.height >> 1)-(height << 1);P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,'           x,y,message,strlen(message));y'         if (qualifier != (char *) NULL)t           {tD             width=XTextWidth(font_info,qualifier,strlen(qualifier));8             x=(windows->widget.width >> 1)-(width >> 1);             y+=height;3             XDrawString(display,windows->widget.id,uP               windows->widget.annotate_context,x,y,qualifier,strlen(qualifier));           }aC         XDrawBeveledButton(display,&windows->widget,&dismiss_info);w7         XHighlightWidget(display,&windows->widget,4,4);w$         state&=(~RedrawWidgetState);       }s     /*       Wait for next event.     */E     if (!XCheckIfEvent(display,&event,XScreenEvent,(char *) windows))(       {)
         /*$           Do not block if delay > 0.
         */)         XDelay(display,SuspendTime << 2);%         continue;%       }      switch (event.type)      {        case ButtonPress:        { 6         if (MatteIsActive(dismiss_info,event.xbutton))           {              /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              break;           }          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;!         if (!dismiss_info.raised)            { ;             if (event.xbutton.window == windows->widget.id)%<               if (MatteIsActive(dismiss_info,event.xbutton))!                 state|=ExitState;l%             dismiss_info.raised=True;oG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);t           }x         break;       }t       case ClientMessage:        {.
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {uG             XSetInputFocus(display,event.xclient.window,RevertToParent,t'               event.xclient.data.l[1]);o             break;           }i?         if (*event.xclient.data.l != windows->wm_delete_window)i           break;7         if (event.xclient.window == windows->widget.id),           {n             state|=ExitState;a             break;           }r         break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }"       case EnterNotify:m       { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {L         static char !           command[MaxTextLength];y           static KeySymm           key_symbol;n  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),h/           &key_symbol,(XComposeStatus *) NULL); E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))d           {e&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);;             state|=ExitState;i             break;           }e         break;       }d       case LeaveNotify:e       { 9         if (event.xcrossing.window != windows->widget.id)e           break;#         state|=InactiveWidgetState;e         break;       }        case MotionNotify:       {s
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));s(         if (state & InactiveWidgetState)           break;M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))c           {t             /*,               Dismiss button status changed.             */5             dismiss_info.raised=!dismiss_info.raised;pG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              break;           },         break;       }r       default:         break;     } !   } while (!(state & ExitState));s)   XSetCursorState(display,windows,False);iE   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);h(   XCheckRefreshWindows(display,windows); }  t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %aO %                                                                             %BO %                                                                             %tO %   X T e x t V i e w W i d g e t                                             %tO %                                                                             %eO %                                                                             %nO %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % = %  Function XTextViewWidget displays text in a Widget widget.i %)0 %  The format of the XTextViewWidget routine is: %UG %    XTextViewWidget(display,resource_info,windows,mono,title,textlist)f %_+ %  A description of each parameter follows:i %)E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %o; %    o window: Specifies a pointer to a XWindows structure.W %h8 %    o mono:  Use mono-spaced font when displaying text. %_I %    o title: This character string is displayed at the top of the widget  %      window. %iH %    o textlist: This string list is displayed within the Widget widget. %  %i */G void XTextViewWidget(display,resource_info,windows,mono,title,textlist)  Displayw   *display;t  
 XResourceInfoe   *resource_info;i   XWindows   *windows;w   unsigned int   mono;i   char	   *title,t
   **textlist;i {)$ #define DismissButtonText  "Dismiss"     char%     primary_selection[MaxTextLength];      inth     x,     y;     register int     i;     unsigned int     height,e
     lines,     text_width,n     visible_lines,
     width;     unsigned longt
     delay,
     state;     XEvent
     event;  
   XFontStruct)     *font_info,d     *text_info;w     XTextProperty      window_name;  
   XWidgetInfos     dismiss_info,1     expose_info,     list_info,     north_info,d     scroll_info,     selection_info,      slider_info,     south_info;.     XWindowChanges     window_changes;i     /*'     Convert text string to a text list.e   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);!   if (textlist == (char **) NULL)      {cF       XNoticeWidget(display,windows,"No text to view:",(char *) NULL);
       return;w     }s   /*'     Determine Widget widget attributes.d   */&   font_info=windows->widget.font_info;!   text_info=(XFontStruct *) NULL;|   if (mono)c4     text_info=XBestFont(display,resource_info,True);(   if (text_info == (XFontStruct *) NULL)(     text_info=windows->widget.font_info;   text_width=0;L.   for (i=0; textlist[i] != (char *) NULL; i++)K     if (XTextWidth(text_info,textlist[i],strlen(textlist[i])) > text_width)=G       text_width=XTextWidth(text_info,textlist[i],strlen(textlist[i])); 
   lines=i;J   width=XTextWidth(font_info,DismissButtonText,strlen(DismissButtonText));%   width+=font_info->max_bounds.width; .   height=text_info->ascent+text_info->descent;   /*     Position Widget widget.n   */   windows->widget.width=?     Min(text_width,MaxTextWidth)+5*font_info->max_bounds.width;fG   windows->widget.min_width=MinTextWidth+4*font_info->max_bounds.width;c8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=Min(Max(lines,3),24)*height+((13*height) >> 1)++     ((9*font_info->max_bounds.width) >> 1);a9   windows->widget.min_height=3*height+((13*height) >> 1)+i+     ((9*font_info->max_bounds.width) >> 1);i:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2);p4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);(   /*     Map Widget widget.   */,   (void) strcpy(windows->widget.name,title);I   (void) XStringListToTextProperty(&windows->widget.name,1,&window_name);a6   XSetWMName(display,windows->widget.id,&window_name);-   window_changes.width=windows->widget.width;m/   window_changes.height=windows->widget.height;-%   window_changes.x=windows->widget.x;*%   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,o4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);t   windows->widget.mapped=False;g   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);t,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_lines=0;   delay=SuspendTime << 2;f.   height=font_info->ascent+font_info->descent;!   state=UpdateConfigurationState;    do   {.)     if (state & UpdateConfigurationState)o       {h         int*
           id;t  
         /*(           Initialize button information.
         */8         XGetWidgetInfo(DismissButtonText,&dismiss_info);!         dismiss_info.width=width; ,         dismiss_info.height=(3*height) >> 1;@         dismiss_info.x=windows->widget.width-dismiss_info.width-(           font_info->max_bounds.width-2;B         dismiss_info.y=windows->widget.height-dismiss_info.height-&           font_info->max_bounds.width;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);g"         scroll_info.bevel_width--;!         scroll_info.width=height;;*         scroll_info.height=dismiss_info.y-1           ((5*font_info->max_bounds.width) >> 1);nH         scroll_info.x=windows->widget.width-font_info->max_bounds.width-           scroll_info.width;;         scroll_info.y=(3*font_info->max_bounds.width) >> 1;w!         scroll_info.raised=False;F          scroll_info.trough=True;         north_info=scroll_info;_         north_info.raised=True;=8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;d-         north_info.x+=north_info.bevel_width;w-         north_info.y+=north_info.bevel_width;w         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;_         slider_info.id=id;         slider_info.width-=2;tP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=eJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;;         visible_lines=(scroll_info.height-(height >> 3)-4)/3<           ((9*(text_info->ascent+text_info->descent)) >> 3);"         if (lines > visible_lines)F           slider_info.height=(visible_lines*slider_info.height)/lines;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;M         list_info.width=scroll_info.x-((3*font_info->max_bounds.width) >> 1);f,         list_info.height=scroll_info.height;0         list_info.x=font_info->max_bounds.width;"         list_info.y=scroll_info.y;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=list_info.width;tN         selection_info.height=(9*(text_info->ascent+text_info->descent)) >> 3;%         selection_info.x=list_info.x;f+         state&=(~UpdateConfigurationState);f       }_"     if (state & RedrawWidgetState)       {i
         /*"           Redraw Text View window.
         */?         XDrawBeveledMatte(display,&windows->widget,&list_info);nA         XDrawBeveledMatte(display,&windows->widget,&scroll_info);sA         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info); C         XDrawBeveledButton(display,&windows->widget,&dismiss_info); 7         XHighlightWidget(display,&windows->widget,4,4);+         selection_info.id=(~0);f         state|=RedrawListState;S$         state&=(~RedrawWidgetState);       }t      if (state & RedrawListState)       {T
         /*+           Determine slider id and position._
         */:         if (slider_info.id >= (int) (lines-visible_lines))-           slider_info.id=lines-visible_lines;w=         if ((slider_info.id < 0) || (lines <= visible_lines))y           slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (lines != 0)            slider_info.y+=pI             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/lines;o0         if (slider_info.id != selection_info.id)           {&             /*/               Redraw scroll bar and file names.y             */0             windows->widget.font_info=text_info;N             XSetFont(display,windows->widget.annotate_context,text_info->fid);O             XSetFont(display,windows->widget.highlight_context,text_info->fid); -             selection_info.id=slider_info.id;>9             selection_info.y=list_info.y+(height >> 3)+2;(-             for (i=0; i < visible_lines; i++)p
             {iG               selection_info.raised=(slider_info.id+i) != list_info.id;y0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < lines)l?                 selection_info.text=textlist[slider_info.id+i];vH               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             } 0             windows->widget.font_info=font_info;N             XSetFont(display,windows->widget.annotate_context,font_info->fid);O             XSetFont(display,windows->widget.highlight_context,font_info->fid);              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {f?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }l             else               { ?                 expose_info.height=expose_info.y-slider_info.y;+?                 expose_info.y=slider_info.y+slider_info.height+!,                   slider_info.bevel_width+1;               } E             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info); (             expose_info.y=slider_info.y;           }t"         state&=(~RedrawListState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)1=       XIfEvent(display,&event,XScreenEvent,(char *) windows);r     else       {l
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)f!           if (slider_info.id > 0))
             {t               /*                 Move slider up.                */               slider_info.id--; %               state|=RedrawListState;n
             }          if (!south_info.raised).%           if (slider_info.id < lines)o
             {x               /*!                 Move slider down.x               */               slider_info.id++;S%               state|=RedrawListState;W
             }a(         if (event.type != ButtonRelease)           continue;y       }-     switch (event.type)      {D       case ButtonPress:w       {i5         if (MatteIsActive(slider_info,event.xbutton))y           {d             /*               Track slider.n             */$             slider_info.active=True;             break;           }w4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)t
             {s               /*                 Move slider up.)               */&               north_info.raised=False;               slider_info.id--;f%               state|=RedrawListState;e               break;
             }l4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < lines) 
             {0               /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++;l%               state|=RedrawListState;(               break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))l           {e             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_lines-1);             else0               slider_info.id+=(visible_lines-1);#             state|=RedrawListState;.             break;           }o6         if (MatteIsActive(dismiss_info,event.xbutton))           {              /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);n             break;           } 3         if (MatteIsActive(list_info,event.xbutton))/           {              unsigned int               id;                static Timeo               click_time;y               /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= lines)               break;#             if (id != list_info.id)l               {r                  list_info.id=id;.                 click_time=event.xbutton.time;                 break;               }d             list_info.id=id;?             if (event.xbutton.time >= (click_time+DoubleClick))                {l.                 click_time=event.xbutton.time;                 break;               }&*             click_time=event.xbutton.time;             /*4               Become the XA_PRIMARY selection owner.             */D             (void) strcpy(primary_selection,textlist[list_info.id]);E             XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id,("               event.xbutton.time);M             if (XGetSelectionOwner(display,XA_PRIMARY) != windows->widget.id)                break;#             selection_info.id=(~0);              list_info.id=id;#             state|=RedrawListState;;             break;           }          break;       }f       case ButtonRelease:        { $         if (!windows->widget.mapped)           break;         if (!north_info.raised)-           {              /*&               User released up button.             */#             delay=SuspendTime << 2;<#             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);            }.         if (!south_info.raised)a           {              /*(               User released down button.             */#             delay=SuspendTime << 2;e#             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);            }          if (slider_info.active)d           {              /*#               Stop tracking slider.              */%             slider_info.active=False;t             break;           } !         if (!dismiss_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) <               if (MatteIsActive(dismiss_info,event.xbutton))!                 state|=ExitState;d%             dismiss_info.raised=True; G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);            }r         break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {,G             XSetInputFocus(display,event.xclient.window,RevertToParent,.'               event.xclient.data.l[1]);b             break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)a           {              state|=ExitState;              break;           }n         break;       }n       case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height=cB           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }=       case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)t           break;&         state&=(~InactiveWidgetState);         break;       }e       case Expose:       { 7         if (event.xexpose.window != windows->widget.id)n           break;%         if (event.xexpose.count != 0)t           break;!         state|=RedrawWidgetState;          break;       }p       case KeyPress:       {          static charf!           command[MaxTextLength];B           static int           length;_           static KeySym;           key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),-/           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0';p2         if (MatteIsActive(scroll_info,event.xkey))           {              /*               Move slider.             */             switch (key_symbol) 
             {B               case XK_Home:-               case XK_KP_Home:               {y!                 slider_info.id=0;                  break;               }m               case XK_Up:                case XK_KP_Up:               {d!                 slider_info.id--;                  break;               }                case XK_Down:l               case XK_KP_Down:               {m!                 slider_info.id++;m                 break;               }m               case XK_Prior:               case XK_KP_Prior:d               { .                 slider_info.id-=visible_lines;                 break;               }                case XK_Next:o               case XK_KP_Next:               { .                 slider_info.id+=visible_lines;                 break;               }                case XK_End:               case XK_KP_End:u               {d%                 slider_info.id=lines;                  break;               }I
             }i#             state|=RedrawListState;              break;           }pE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))F           { &             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);a             state|=ExitState;b             break;           }          break;       }p       case KeyRelease:         break;       case LeaveNotify:a       {e9         if (event.xcrossing.window != windows->widget.id),           break;#         state|=InactiveWidgetState;          break;       }y       case MotionNotify:       {r
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)i           {n             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;g3             if (slider_info.y != slider_info.min_y) I               slider_info.id=(lines*(slider_info.y-slider_info.min_y+1))/ 8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           }_(         if (state & InactiveWidgetState)           break;M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))I           {              /*,               Dismiss button status changed.             */5             dismiss_info.raised=!dismiss_info.raised; G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              break;           }e         break;       }        case SelectionClear:       {Y         list_info.id=(~0);         selection_info.id=(~0);u         state|=RedrawListState;          break;       }l       case SelectionRequest:       {>         XSelectionEvent            notify;(           XSelectionRequestEvent           *request;   !         if (list_info.id == (~0))            break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));sN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection));m$         notify.type=SelectionNotify;         notify.send_event=True;l(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }_       default:         break;     }t!   } while (!(state & ExitState)); -   if (text_info != windows->widget.font_info) !     XFreeFont(display,text_info);d)   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);i(   XCheckRefreshWindows(display,windows); }f