 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %             U   U  TTTTT  IIIII  L      IIIII  TTTTT  Y   Y                 % O %             U   U    T      I    L        I      T     Y Y                  % O %             U   U    T      I    L        I      T      Y                   % O %             U   U    T      I    L        I      T      Y                   % O %              UUU     T    IIIII  LLLLL  IIIII    T      Y                   % O %                                                                             % O %                                                                             % O %                       ImageMagick Utility Routines                          % O %                                                                             % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1993                                   % O %                                                                             % O %                                                                             % O %  Copyright 1995 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "utility.h" #include "X.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  A p p e n d I m a g e F o r m a t                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function AppendImageFormat appends the image format type to the filename.B %  If an extension to the file alread exists, it is first removed. % 2 %  The format of the AppendImageFormat routine is: % * %       AppendImageFormat(format,filename) % + %  A description of each parameter follows.  % K %   o  format:  Specifies a pointer to an array of characters.  This is the  %      format of the image.  % L %   o  filename:  Specifies a pointer to an array of characters.  The unique+ %      file name is returned in this array.  %  %  */' void AppendImageFormat(format,filename)  char
   *format,   *filename; {    char     staging[MaxTextLength];      register char      *p;   5   if ((format == (char *) NULL) || (*format == '\0'))      return; 9   if ((filename == (char *) NULL) || (*filename == '\0'))      return;     p=filename+strlen(filename)-1;+   while ((p > filename) && (*(p-1) != '.'))      p--;(   if ((p > filename) && (*(p-1) == '.'))     (void) strcpy(p,format);   else     { 6       (void) sprintf(staging,"%s:%s",format,filename);&       (void) strcpy(filename,staging);     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   E x p a n d F i l e n a m e s                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ExpandFilenames checks each argument of the command line vector and J %  expands it if they have a wildcard character.  For example, *.jpg might* %  expand to:  bird.jpg rose.jpg tiki.jpg. % 1 %  The format of the ExpandFilenames function is:  % ! %      ExpandFilenames(argc,argv)  % + %  A description of each parameter follows:  % G %    o argc: Specifies a pointer to an integer describing the number of ' %      elements in the argument vector.  % L %    o argv: Specifies a pointer to a text array containing the command line %      arguments.  %  %  */ void ExpandFilenames(argc,argv)  int    *argc;   char
   ***argv; {    char     **filelist, "     home_directory[MaxTextLength],     *option,
     **vector, %     working_directory[MaxTextLength];      int 
     count,     number_files;      ImageInfo      image_info;      register char      *p,      *q;      register int     i,     j;  
   struct stat      file_info;     /*     Allocate argument vector.    */0   vector=(char **) malloc(*argc*sizeof(char *));   if (vector == (char **) NULL)      { :       Warning("Unable to expand filenames",(char *) NULL);
       return;      }    /*"     Expand any wildcard filenames.   */0   (void) getcwd(home_directory,MaxTextLength-1);   GetImageInfo(&image_info);
   count=0;   for (i=0; i < *argc; i++)    {      option=(*argv)[i];     vector[count++]=option; M     if (((int) strlen(option) > 1) && ((*option == '-') || (*option == '+')))        continue; .     (void) strcpy(image_info.filename,option);      SetImageMagick(&image_info);.     if ((*option == '"') || (*option == '\''))       continue;      if (!IsGlob(option))       continue; -     if (strcmp(image_info.magick,"VID") == 0)        continue; !     if (image_info.subimage != 0)        continue;      /*'       Get the list of image file names.      */5     (void) getcwd(working_directory,MaxTextLength-1); 4     for (p=option+strlen(option)-1; p > option; p--)#       if (*p == *BasenameSeparator) 	         {            /*/             Filename includes a directory name.            */           q=working_directory;*           for (j=0; j < (p-option+1); j++)             *q++=option[j];            *q='\0';           p++;           break;	         } :     filelist=ListFiles(working_directory,p,&number_files);#     if (filelist == (char **) NULL)        continue; $     for (j=0; j < number_files; j++)     { *       (void) stat(filelist[j],&file_info);&       if (!S_ISDIR(file_info.st_mode))         break;     }      if (j == number_files)       continue;      /*,       Transfer file list to argument vector.     */     vector=(char **)@       realloc(vector,(*argc+count+number_files)*sizeof(char *));!     if (vector == (char **) NULL)        { <         Warning("Unable to expand filenames",(char *) NULL);         return;        }      count--;$     for (j=0; j < number_files; j++)     { *       (void) stat(filelist[j],&file_info);%       if (S_ISDIR(file_info.st_mode)) 	         { %           free((char *) filelist[j]);            continue; 	         }        vector[count]=(char *)@         malloc(((p-option)+strlen(filelist[j])+1)*sizeof(char));)       if (vector[count] == (char *) NULL) 	         { >           Warning("Unable to expand filenames",(char *) NULL);(           for ( ; j < number_files; j++)'             free((char *) filelist[j]); "           free((char *) filelist);           return; 	         } I       (void) sprintf(vector[count],"%.*s%s",p-option,option,filelist[j]); !       free((char *) filelist[j]);        count++;     }      free((char *) filelist);   } %   free((char *) image_info.filename);    (void) chdir(home_directory);    *argc=count;   *argv=vector;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G l o b E x p e s s i o n                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function GlobExpression returns True if the expression matches the pattern. % 0 %  The format of the GlobExpression function is: % ) %      GlobExpression(expression,pattern)  % + %  A description of each parameter follows:  % O %    o expression: Specifies a pointer to a text string containing a file name.  % J %    o pattern: Specifies a pointer to a text string containing a pattern. %  %  */& int GlobExpression(expression,pattern) char   *expression,   *pattern;  {    int 	     done;      if (pattern == (char *) NULL)      return(True);    if (strlen(pattern) == 0)      return(True);    if (strcmp(pattern,"*") == 0)      return(True); 
   done=False; %   while ((*pattern != '\0') && !done)    {      if (*expression == '\0')1       if ((*pattern != '{') && (*pattern != '*'))          break;     switch (*pattern)      {        case '\\':       {          pattern++;         if (*pattern != '\0')            pattern++;         break;       }        case '*':        {          int            status;            pattern++;         status=False; 0         while ((*expression != '\0') && !status)?           status=GlobExpression((char *) expression++,pattern);          if (status)            { '             while (*expression != '\0')                expression++; $             while (*pattern != '\0')               pattern++;           }          break;       }        case '[':        {          char           c;           pattern++;         for ( ; ; ) 	         { 6           if ((*pattern == '\0') || (*pattern == ']'))
             {                done=True;               break;
             }            if (*pattern == '\\') 
             {                pattern++;#               if (*pattern == '\0')                  {                    done=True;                   break;                 }               }"           if (*(pattern+1) == '-')
             {                c=(*pattern);                pattern+=2; "               if (*pattern == ']')                 {                    done=True;                   break;                 } #               if (*pattern == '\\')                  {                    pattern++;'                   if (*pattern == '\0')                      {                         done=True;                       break;                     }                  } @               if ((*expression < c) || (*expression > *pattern))                 {                    pattern++;                   continue;                  } 
             }            else(             if (*pattern != *expression)               {                  pattern++;                 continue;                }            pattern++;9           while ((*pattern != ']') && (*pattern != '\0'))            { =             if ((*pattern == '\\') && (*(pattern+1) != '\0'))                pattern++;             pattern++;           }            if (*pattern != '\0') 
             {                pattern++;               expression++; 
             }            break;	         }          break;       }        case '?':        {          pattern++;         expression++;          break;       }        case '{':        {          int            match;           register char 
           *p;            pattern++;7         while ((*pattern != '}') && (*pattern != '\0')) 	         {            p=expression;            match=True; 6           while ((*p != '\0') && (*pattern != '\0') &&A                  (*pattern != ',') && (*pattern != '}') && match)            { !             if (*pattern == '\\')                pattern++;#             match=(*pattern == *p);              p++;             pattern++;           }            if (*pattern == '\0') 
             {                match=False;               done=True;               break;
             }            else             if (match)               {                  expression=p; ?                 while ((*pattern != '}') && (*pattern != '\0'))                  {                    pattern++;'                   if (*pattern == '\\')                      {                         pattern++;*                       if (*pattern == '}')"                         pattern++;                     }                  }                }              else               { @                 while ((*pattern != '}') && (*pattern != ',') &&*                        (*pattern != '\0'))                 {                    pattern++;'                   if (*pattern == '\\')                      {                         pattern++;A                       if ((*pattern == '}') || (*pattern == ',')) "                         pattern++;                     }                  }                } !             if (*pattern != '\0')                pattern++;           }          break;       }        default:       { $         if (*expression != *pattern)           done=True;         else           {              expression++;              pattern++;           }        }      }    }    while (*pattern == '*')      pattern++;6   return((*expression == '\0') && (*pattern == '\0')); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L i s t C o l o r s                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ListColors reads the X client color database and returns a list L %  of colors contained in the database sorted in ascending alphabetic order. % , %  The format of the ListColors function is: % 1 %      filelist=ListColors(pattern,number_colors)  % + %  A description of each parameter follows:  % G %    o filelist: Function ListColors returns a list of colors contained G %      in the database.  If the database cannot be read, a NULL list is  %      returned. % J %    o pattern: Specifies a pointer to a text string containing a pattern. % M %    o number_colors:  This integer returns the number of colors in the list.  %  %  */ static int ColorCompare(x,y)
 const void   *x,    *y;  {    register char      *p,      *q;      p=(char *) *((char **) x);   q=(char *) *((char **) y);4   while ((*p != '\0') && (*q != '\0') && (*p == *q))   {      p++;     q++;   }    return(*p-(*q)); }   ( char **ListColors(pattern,number_colors) char   *pattern;    int    *number_colors;  { 
   static char      *ColornameDatabase[]=      { D       "AliceBlue", "AntiqueWhite", "AntiqueWhite1", "AntiqueWhite2",G       "AntiqueWhite3", "AntiqueWhite4", "BlanchedAlmond", "BlueViolet", J       "CadetBlue", "CadetBlue1", "CadetBlue2", "CadetBlue3", "CadetBlue4",L       "CornflowerBlue", "DarkGoldenrod", "DarkGoldenrod1", "DarkGoldenrod2",C       "DarkGoldenrod3", "DarkGoldenrod4", "DarkGreen", "DarkKhaki", =       "DarkOliveGreen", "DarkOliveGreen1", "DarkOliveGreen2", H       "DarkOliveGreen3", "DarkOliveGreen4", "DarkOrange", "DarkOrange1",O       "DarkOrange2", "DarkOrange3", "DarkOrange4", "DarkOrchid", "DarkOrchid1", @       "DarkOrchid2", "DarkOrchid3", "DarkOrchid4", "DarkSalmon",H       "DarkSeaGreen", "DarkSeaGreen1", "DarkSeaGreen2", "DarkSeaGreen3",J       "DarkSeaGreen4", "DarkSlateBlue", "DarkSlateGray", "DarkSlateGray1",L       "DarkSlateGray2", "DarkSlateGray3", "DarkSlateGray4", "DarkSlateGrey",J       "DarkTurquoise", "DarkViolet", "DeepPink", "DeepPink1", "DeepPink2",N       "DeepPink3", "DeepPink4", "DeepSkyBlue", "DeepSkyBlue1", "DeepSkyBlue2",I       "DeepSkyBlue3", "DeepSkyBlue4", "DimGray", "DimGrey", "DodgerBlue", A       "DodgerBlue1", "DodgerBlue2", "DodgerBlue3", "DodgerBlue4", K       "FloralWhite", "ForestGreen", "GhostWhite", "GreenYellow", "HotPink", B       "HotPink1", "HotPink2", "HotPink3", "HotPink4", "IndianRed",N       "IndianRed1", "IndianRed2", "IndianRed3", "IndianRed4", "LavenderBlush",M       "LavenderBlush1", "LavenderBlush2", "LavenderBlush3", "LavenderBlush4", D       "LawnGreen", "LemonChiffon", "LemonChiffon1", "LemonChiffon2",B       "LemonChiffon3", "LemonChiffon4", "LightBlue", "LightBlue1",J       "LightBlue2", "LightBlue3", "LightBlue4", "LightCoral", "LightCyan",O       "LightCyan1", "LightCyan2", "LightCyan3", "LightCyan4", "LightGoldenrod", >       "LightGoldenrod1", "LightGoldenrod2", "LightGoldenrod3",J       "LightGoldenrod4", "LightGoldenrodYellow", "LightGray", "LightGrey",J       "LightPink", "LightPink1", "LightPink2", "LightPink3", "LightPink4",D       "LightSalmon", "LightSalmon1", "LightSalmon2", "LightSalmon3",G       "LightSalmon4", "LightSeaGreen", "LightSkyBlue", "LightSkyBlue1", J       "LightSkyBlue2", "LightSkyBlue3", "LightSkyBlue4", "LightSlateBlue",N       "LightSlateGray", "LightSlateGrey", "LightSteelBlue", "LightSteelBlue1",M       "LightSteelBlue2", "LightSteelBlue3", "LightSteelBlue4", "LightYellow", E       "LightYellow1", "LightYellow2", "LightYellow3", "LightYellow4", D       "LimeGreen", "MediumAquamarine", "MediumBlue", "MediumOrchid",I       "MediumOrchid1", "MediumOrchid2", "MediumOrchid3", "MediumOrchid4", H       "MediumPurple", "MediumPurple1", "MediumPurple2", "MediumPurple3",;       "MediumPurple4", "MediumSeaGreen", "MediumSlateBlue", @       "MediumSpringGreen", "MediumTurquoise", "MediumVioletRed",K       "MidnightBlue", "MintCream", "MistyRose", "MistyRose1", "MistyRose2", @       "MistyRose3", "MistyRose4", "NavajoWhite", "NavajoWhite1",L       "NavajoWhite2", "NavajoWhite3", "NavajoWhite4", "NavyBlue", "OldLace",J       "OliveDrab", "OliveDrab1", "OliveDrab2", "OliveDrab3", "OliveDrab4",J       "OrangeRed", "OrangeRed1", "OrangeRed2", "OrangeRed3", "OrangeRed4",M       "PaleGoldenrod", "PaleGreen", "PaleGreen1", "PaleGreen2", "PaleGreen3", H       "PaleGreen4", "PaleTurquoise", "PaleTurquoise1", "PaleTurquoise2",L       "PaleTurquoise3", "PaleTurquoise4", "PaleVioletRed", "PaleVioletRed1",I       "PaleVioletRed2", "PaleVioletRed3", "PaleVioletRed4", "PapayaWhip", J       "PeachPuff", "PeachPuff1", "PeachPuff2", "PeachPuff3", "PeachPuff4",J       "PowderBlue", "RosyBrown", "RosyBrown1", "RosyBrown2", "RosyBrown3",J       "RosyBrown4", "RoyalBlue", "RoyalBlue1", "RoyalBlue2", "RoyalBlue3",I       "RoyalBlue4", "SaddleBrown", "SandyBrown", "SeaGreen", "SeaGreen1", O       "SeaGreen2", "SeaGreen3", "SeaGreen4", "SkyBlue", "SkyBlue1", "SkyBlue2", F       "SkyBlue3", "SkyBlue4", "SlateBlue", "SlateBlue1", "SlateBlue2",J       "SlateBlue3", "SlateBlue4", "SlateGray", "SlateGray1", "SlateGray2",M       "SlateGray3", "SlateGray4", "SlateGrey", "SpringGreen", "SpringGreen1", B       "SpringGreen2", "SpringGreen3", "SpringGreen4", "SteelBlue",J       "SteelBlue1", "SteelBlue2", "SteelBlue3", "SteelBlue4", "VioletRed",K       "VioletRed1", "VioletRed2", "VioletRed3", "VioletRed4", "WhiteSmoke", A       "YellowGreen", "alice blue", "antique white", "aquamarine", J       "aquamarine1", "aquamarine2", "aquamarine3", "aquamarine4", "azure",K       "azure1", "azure2", "azure3", "azure4", "beige", "bisque", "bisque1", B       "bisque2", "bisque3", "bisque4", "black", "blanched almond",I       "blue violet", "blue", "blue1", "blue2", "blue3", "blue4", "brown", H       "brown1", "brown2", "brown3", "brown4", "burlywood", "burlywood1",K       "burlywood2", "burlywood3", "burlywood4", "cadet blue", "chartreuse", N       "chartreuse1", "chartreuse2", "chartreuse3", "chartreuse4", "chocolate",F       "chocolate1", "chocolate2", "chocolate3", "chocolate4", "coral",L       "coral1", "coral2", "coral3", "coral4", "cornflower blue", "cornsilk",J       "cornsilk1", "cornsilk2", "cornsilk3", "cornsilk4", "cyan", "cyan1",N       "cyan2", "cyan3", "cyan4", "dark goldenrod", "dark green", "dark khaki",F       "dark olive green", "dark orange", "dark orchid", "dark salmon",=       "dark sea green", "dark slate blue", "dark slate gray", F       "dark slate grey", "dark turquoise", "dark violet", "deep pink",=       "deep sky blue", "dim gray", "dim grey", "dodger blue", <       "firebrick", "firebrick1", "firebrick2", "firebrick3",O       "firebrick4", "floral white", "forest green", "gainsboro", "ghost white", L       "gold", "gold1", "gold2", "gold3", "gold4", "goldenrod", "goldenrod1",I       "goldenrod2", "goldenrod3", "goldenrod4", "gray", "gray0", "gray1", L       "gray10", "gray100", "gray11", "gray12", "gray13", "gray14", "gray15",J       "gray16", "gray17", "gray18", "gray19", "gray2", "gray20", "gray21",K       "gray22", "gray23", "gray24", "gray25", "gray26", "gray27", "gray28", J       "gray29", "gray3", "gray30", "gray31", "gray32", "gray33", "gray34",J       "gray35", "gray36", "gray37", "gray38", "gray39", "gray4", "gray40",K       "gray41", "gray42", "gray43", "gray44", "gray45", "gray46", "gray47", J       "gray48", "gray49", "gray5", "gray50", "gray51", "gray52", "gray53",J       "gray54", "gray55", "gray56", "gray57", "gray58", "gray59", "gray6",K       "gray60", "gray61", "gray62", "gray63", "gray64", "gray65", "gray66", J       "gray67", "gray68", "gray69", "gray7", "gray70", "gray71", "gray72",K       "gray73", "gray74", "gray75", "gray76", "gray77", "gray78", "gray79", J       "gray8", "gray80", "gray81", "gray82", "gray83", "gray84", "gray85",J       "gray86", "gray87", "gray88", "gray89", "gray9", "gray90", "gray91",K       "gray92", "gray93", "gray94", "gray95", "gray96", "gray97", "gray98", F       "gray99", "green yellow", "green", "green1", "green2", "green3",H       "green4", "grey", "grey0", "grey1", "grey10", "grey100", "grey11",K       "grey12", "grey13", "grey14", "grey15", "grey16", "grey17", "grey18", J       "grey19", "grey2", "grey20", "grey21", "grey22", "grey23", "grey24",J       "grey25", "grey26", "grey27", "grey28", "grey29", "grey3", "grey30",K       "grey31", "grey32", "grey33", "grey34", "grey35", "grey36", "grey37", J       "grey38", "grey39", "grey4", "grey40", "grey41", "grey42", "grey43",J       "grey44", "grey45", "grey46", "grey47", "grey48", "grey49", "grey5",K       "grey50", "grey51", "grey52", "grey53", "grey54", "grey55", "grey56", J       "grey57", "grey58", "grey59", "grey6", "grey60", "grey61", "grey62",K       "grey63", "grey64", "grey65", "grey66", "grey67", "grey68", "grey69", J       "grey7", "grey70", "grey71", "grey72", "grey73", "grey74", "grey75",J       "grey76", "grey77", "grey78", "grey79", "grey8", "grey80", "grey81",K       "grey82", "grey83", "grey84", "grey85", "grey86", "grey87", "grey88", J       "grey89", "grey9", "grey90", "grey91", "grey92", "grey93", "grey94",C       "grey95", "grey96", "grey97", "grey98", "grey99", "honeydew", E       "honeydew1", "honeydew2", "honeydew3", "honeydew4", "hot pink", M       "indian red", "ivory", "ivory1", "ivory2", "ivory3", "ivory4", "khaki", K       "khaki1", "khaki2", "khaki3", "khaki4", "lavender blush", "lavender", A       "lawn green", "lemon chiffon", "light blue", "light coral", @       "light cyan", "light goldenrod yellow", "light goldenrod",?       "light gray", "light grey", "light pink", "light salmon", >       "light sea green", "light sky blue", "light slate blue",A       "light slate gray", "light slate grey", "light steel blue", O       "light yellow", "lime green", "linen", "magenta", "magenta1", "magenta2", H       "magenta3", "magenta4", "maroon", "maroon1", "maroon2", "maroon3",E       "maroon4", "medium aquamarine", "medium blue", "medium orchid", ?       "medium purple", "medium sea green", "medium slate blue", E       "medium spring green", "medium turquoise", "medium violet red", N       "midnight blue", "mint cream", "misty rose", "moccasin", "navajo white",L       "navy blue", "navy", "old lace", "olive drab", "orange red", "orange",F       "orange1", "orange2", "orange3", "orange4", "orchid", "orchid1",F       "orchid2", "orchid3", "orchid4", "pale goldenrod", "pale green",O       "pale turquoise", "pale violet red", "papaya whip", "peach puff", "peru", K       "pink", "pink1", "pink2", "pink3", "pink4", "plum", "plum1", "plum2", F       "plum3", "plum4", "powder blue", "purple", "purple1", "purple2",B       "purple3", "purple4", "red", "red1", "red2", "red3", "red4",F       "rosy brown", "royal blue", "saddle brown", "salmon", "salmon1",N       "salmon2", "salmon3", "salmon4", "sandy brown", "sea green", "seashell",N       "seashell1", "seashell2", "seashell3", "seashell4", "sienna", "sienna1",N       "sienna2", "sienna3", "sienna4", "sky blue", "slate blue", "slate gray",O       "slate grey", "snow", "snow1", "snow2", "snow3", "snow4", "spring green", E       "steel blue", "tan", "tan1", "tan2", "tan3", "tan4", "thistle", J       "thistle1", "thistle2", "thistle3", "thistle4", "tomato", "tomato1",O       "tomato2", "tomato3", "tomato4", "turquoise", "turquoise1", "turquoise2", L       "turquoise3", "turquoise4", "violet red", "violet", "wheat", "wheat1",K       "wheat2", "wheat3", "wheat4", "white smoke", "white", "yellow green", J       "yellow", "yellow1", "yellow2", "yellow3", "yellow4", (char *) NULL,     };     char     color[MaxTextLength],      **colorlist,     text[MaxTextLength];     FILE     *database;     int 	     blue, 
     count,
     green,     red;     register char      **p;     unsigned int     max_colors;      /*     Allocate color list.   */   max_colors=0; 5   for (p=ColornameDatabase; *p != (char *) NULL; p++)      max_colors++; 8   colorlist=(char **) malloc(max_colors*sizeof(char *));"   if (colorlist == (char **) NULL)     { O       Warning("Unable to read color name database","Memory allocation failed");        return((char **) NULL);      }    /*     Open database.   */   *number_colors=0; '   database=fopen(RGBColorDatabase,"r");     if (database == (FILE *) NULL)     {        /*>         Can't find server color database-- use our color list.       */9       for (p=ColornameDatabase; *p != (char *) NULL; p++) '         if (GlobExpression(*p,pattern))            { D             colorlist[*number_colors]=(char *) malloc(strlen(*p)+1);;             if (colorlist[*number_colors] == (char *) NULL)                break;8             (void) strcpy(colorlist[*number_colors],*p);             (*number_colors)++;            }        return(colorlist);     } ?   while (fgets(text,MaxTextLength-1,database) != (char *) NULL)    { C     count=sscanf(text,"%d %d %d %[^\n]\n",&red,&green,&blue,color);      if (count != 4)        continue; &     if (GlobExpression(color,pattern))       { )         if (*number_colors >= max_colors)            {              max_colors<<=1;              colorlist=(char **) D               realloc((char *) colorlist,max_colors*sizeof(char *));,             if (colorlist == (char **) NULL)               { =                 Warning("Unable to read color name database", .                   "Memory allocation failed");(                 (void) fclose(database);'                 return((char **) NULL);                }            } C         colorlist[*number_colors]=(char *) malloc(strlen(color)+1); 7         if (colorlist[*number_colors] == (char *) NULL)            break;7         (void) strcpy(colorlist[*number_colors],color);          (*number_colors)++;        }    }    (void) fclose(database);   /*&     Sort colorlist in ascending order.   */:   qsort((void *) colorlist,*number_colors,sizeof(char **),C     (int (*) _Declare((const void *, const void *))) ColorCompare);    return(colorlist); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L i s t F i l e s                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function ListFiles reads the directory specified and returns a listI %  of filenames contained in the directory sorted in ascending alphabetic 	 %  order.  % + %  The format of the ListFiles function is:  % ; %      filelist=ListFiles(directory,pattern,number_entries)  % + %  A description of each parameter follows:  % I %    o filelist: Function ListFiles returns a list of filenames contained L %      in the directory.  If the directory specified cannot be read or it is& %      a file a NULL list is returned. % M %    o directory: Specifies a pointer to a text string containing a directory  %      name. % J %    o pattern: Specifies a pointer to a text string containing a pattern. % K %    o number_entries:  This integer returns the number of filenames in the  %      list. %  %  */ static int FileCompare(x,y) 
 const void   *x,    *y;  {    register char      *p,      *q;      p=(char *) *((char **) x);   q=(char *) *((char **) y);4   while ((*p != '\0') && (*q != '\0') && (*p == *q))   {      p++;     q++;   }    return(*p-(*q)); }   2 char **ListFiles(directory,pattern,number_entries) char
   *directory,    *pattern;    int    *number_entries; {    char     **filelist;      DIR      *current_directory;      int      status;      struct dirent      *entry;   
   struct stat      file_info;     unsigned int     max_entries;     /*     Open directory.    */   *number_entries=0;   status=chdir(directory);   if (status != 0)     return((char **) NULL); +   (void) getcwd(directory,MaxTextLength-1); '   current_directory=opendir(directory); (   if (current_directory == (DIR *) NULL)     return((char **) NULL);    /*     Allocate filelist.   */   max_entries=2048; 8   filelist=(char **) malloc(max_entries*sizeof(char *));!   if (filelist == (char **) NULL)      { )       (void) closedir(current_directory);        return((char **) NULL);      }    /*5     Save the current and change to the new directory.    */   (void) chdir(directory);#   entry=readdir(current_directory); )   while (entry != (struct dirent *) NULL)    {      if (*entry->d_name == '.')       { )         entry=readdir(current_directory);          continue;        } *     (void) stat(entry->d_name,&file_info);L     if (S_ISDIR(file_info.st_mode) || GlobExpression(entry->d_name,pattern))       { +         if (*number_entries >= max_entries)            {              max_entries<<=1;             filelist=(char **)D               realloc((char *) filelist,max_entries*sizeof(char *));+             if (filelist == (char **) NULL)                { 3                 (void) closedir(current_directory); '                 return((char **) NULL);                }            } K         filelist[*number_entries]=(char *) malloc(strlen(entry->d_name)+2); 7         if (filelist[*number_entries] == (char *) NULL)            break;?         (void) strcpy(filelist[*number_entries],entry->d_name); '         if (S_ISDIR(file_info.st_mode)) F           (void) strcat(filelist[*number_entries],DirectorySeparator);         (*number_entries)++;       } %     entry=readdir(current_directory);    } %   (void) closedir(current_directory);    /*%     Sort filelist in ascending order.    */:   qsort((void *) filelist,*number_entries,sizeof(char **),B     (int (*) _Declare((const void *, const void *))) FileCompare);   return(filelist);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  L S B F i r s t R e a d L o n g                                            % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function LSBFirstReadLong reads a long value as a 32 bit quantity in & %  least-significant byte first order. % 1 %  The format of the LSBFirstReadLong routine is:  % $ %       value=LSBFirstReadLong(file) % + %  A description of each parameter follows.  % K %    o value:  Function LSBFirstReadLong returns an unsigned long read from  %      the file. % 7 %   o  file:  Specifies the file to read the data from.  %  %  */$ unsigned long LSBFirstReadLong(file) FILE   *file; {    unsigned char      buffer[4];     unsigned int     status;      unsigned long 
     value;  ,   status=ReadData((char *) buffer,1,4,file);   if (status == False)     return((unsigned long) ~0); )   value=(unsigned int) (buffer[3] << 24); *   value|=(unsigned int) (buffer[2] << 16);)   value|=(unsigned int) (buffer[1] << 8); $   value|=(unsigned int) (buffer[0]);   return(value); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  L S B F i r s t R e a d S h o r t                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function LSBFirstReadShort reads a short value as a 16 bit quantity in & %  least-significant byte first order. % 2 %  The format of the LSBFirstReadShort routine is: % % %       value=LSBFirstReadShort(file)  % + %  A description of each parameter follows.  % M %    o value:  Function LSBFirstReadShort returns an unsigned short read from  %      the file. % 7 %   o  file:  Specifies the file to read the data from.  %  %  */& unsigned short LSBFirstReadShort(file) FILE   *file; {    unsigned char      buffer[2];     unsigned int     status;      unsigned short
     value;  ,   status=ReadData((char *) buffer,1,2,file);   if (status == False)      return((unsigned short) ~0);*   value=(unsigned short) (buffer[1] << 8);&   value|=(unsigned short) (buffer[0]);   return(value); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  L S B F i r s t W r i t e L o n g                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function LSBFirstWriteLong writes a long value as a 32 bit quantity in & %  least-significant byte first order. % 2 %  The format of the LSBFirstWriteLong routine is: % % %       LSBFirstWriteLong(value,file)  % + %  A description of each parameter follows.  % , %   o  value:  Specifies the value to write. % 6 %   o  file:  Specifies the file to write the data to. %  %  */" void LSBFirstWriteLong(value,file)
 unsigned long    value;   FILE   *file; {    unsigned char      buffer[4];  $   buffer[0]=(unsigned char) (value);+   buffer[1]=(unsigned char) ((value) >> 8); ,   buffer[2]=(unsigned char) ((value) >> 16);,   buffer[3]=(unsigned char) ((value) >> 24);*   (void) fwrite((char *) buffer,1,4,file); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  L S B F i r s t W r i t e S h o r t                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function LSBFirstWriteShort writes a long value as a 16 bit quantity in& %  least-significant byte first order. % 3 %  The format of the LSBFirstWriteShort routine is:  % & %       LSBFirstWriteShort(value,file) % + %  A description of each parameter follows.  % , %   o  value:  Specifies the value to write. % 6 %   o  file:  Specifies the file to write the data to. %  %  */# void LSBFirstWriteShort(value,file)  unsigned int   value;   FILE   *file; {    unsigned char      buffer[2];  $   buffer[0]=(unsigned char) (value);+   buffer[1]=(unsigned char) ((value) >> 8); *   (void) fwrite((char *) buffer,1,2,file); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  M S B F i r s t O r d e r L o n g                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function MSBFirstOrderLong converts a least-significant byte first buffer. %  of integers to most-significant byte first. % 2 %  The format of the MSBFirstOrderLong routine is: % $ %       MSBFirstOrderLong(p,length); % + %  A description of each parameter follows.  % 7 %   o  p:  Specifies a pointer to a buffer of integers.  % 3 %   o  length:  Specifies the length of the buffer.  %  %  */  void MSBFirstOrderLong(p,length)
 register char    *p;    register unsigned int 	   length;  {    register char      c,     *q,      *sp;  
   q=p+length;    while (p < q)    {      sp=p+3;      c=(*sp);
     *sp=(*p);      *p++=c;      sp=p+1;      c=(*sp);
     *sp=(*p);      *p++=c; 	     p+=2;    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  M S B F i r s t O r d e r S h o r t                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function MSBFirstOrderShort converts a least-significant byte first buffer . %  of integers to most-significant byte first. % 3 %  The format of the MSBFirstOrderShort routine is:  % ) %       MSBFirstOrderLongShort(p,length);  % + %  A description of each parameter follows.  % 7 %   o  p:  Specifies a pointer to a buffer of integers.  % 3 %   o  length:  Specifies the length of the buffer.  %  %  */! void MSBFirstOrderShort(p,length) 
 register char    *p;    register unsigned int 	   length;  {    register char      c,     *q;   
   q=p+length;    while (p < q)    {      c=(*p);      *p=(*(p+1));     p++;     *p++=c;    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  M S B F i r s t R e a d S h o r t                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function MSBFirstReadShort reads a short value as a 16 bit quantity in % %  most-significant byte first order.  % 2 %  The format of the MSBFirstReadShort routine is: % % %       value=MSBFirstReadShort(file)  % + %  A description of each parameter follows.  % M %    o value:  Function MSBFirstReadShort returns an unsigned short read from  %      the file. % 7 %   o  file:  Specifies the file to read the data from.  %  %  */& unsigned short MSBFirstReadShort(file) FILE   *file; {    unsigned char      buffer[2];     unsigned int     status;      unsigned short
     value;  ,   status=ReadData((char *) buffer,1,2,file);   if (status == False)      return((unsigned short) ~0);(   value=(unsigned int) (buffer[0] << 8);$   value|=(unsigned int) (buffer[1]);   return(value); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  M S B F i r s t R e a d L o n g                                            % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function MSBFirstReadLong reads a long value as a 32 bit quantity in % %  most-significant byte first order.  % 1 %  The format of the MSBFirstReadLong routine is:  % $ %       value=MSBFirstReadLong(file) % + %  A description of each parameter follows.  % K %    o value:  Function MSBFirstReadLong returns an unsigned long read from  %      the file. % 7 %   o  file:  Specifies the file to read the data from.  %  %  */$ unsigned long MSBFirstReadLong(file) FILE   *file; {    unsigned char      buffer[4];     unsigned int     status;      unsigned long 
     value;  ,   status=ReadData((char *) buffer,1,4,file);   if (status == False)     return((unsigned long) ~0); )   value=(unsigned int) (buffer[0] << 24); *   value|=(unsigned int) (buffer[1] << 16);)   value|=(unsigned int) (buffer[2] << 8); $   value|=(unsigned int) (buffer[3]);   return(value); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  M S B F i r s t W r i t e L o n g                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function MSBFirstWriteLong writes a long value as a 32 bit quantity in % %  most-significant byte first order.  % 2 %  The format of the MSBFirstWriteLong routine is: % % %       MSBFirstWriteLong(value,file)  % + %  A description of each parameter follows.  % , %   o  value:  Specifies the value to write. % 6 %   o  file:  Specifies the file to write the data to. %  %  */" void MSBFirstWriteLong(value,file)
 unsigned long    value;   FILE   *file; {    unsigned char      buffer[4];  ,   buffer[0]=(unsigned char) ((value) >> 24);,   buffer[1]=(unsigned char) ((value) >> 16);+   buffer[2]=(unsigned char) ((value) >> 8); $   buffer[3]=(unsigned char) (value);*   (void) fwrite((char *) buffer,1,4,file); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  M S B F i r s t W r i t e S h o r t                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function MSBFirstWriteShort writes a long value as a 16 bit quantity in% %  most-significant byte first order.  % 3 %  The format of the MSBFirstWriteShort routine is:  % & %       MSBFirstWriteShort(value,file) % + %  A description of each parameter follows.  % , %   o  value:  Specifies the value to write. % 6 %   o  file:  Specifies the file to write the data to. %  %  */# void MSBFirstWriteShort(value,file)  unsigned int   value;   FILE   *file; {    unsigned char      buffer[2];  +   buffer[0]=(unsigned char) ((value) >> 8); $   buffer[1]=(unsigned char) (value);*   (void) fwrite((char *) buffer,1,2,file); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d D a t a                                                            % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function ReadData reads data from the image file and returns it.  If itJ %  cannot read the requested number of items, False is returned indicating %  an error. % ) %  The format of the ReadData routine is:  % 3 %      status=ReadData(data,size,number_items,file)  % + %  A description of each parameter follows:  % H %    o status:  Function ReadData returns True if all the data requested2 %      is obtained without error, otherwise False. % F %    o data:  Specifies an area to place the information reuested from %      the file. % @ %    o size:  Specifies an integer representing the length of an0 %      individual item to be read from the file. % K %    o number_items:  Specifies an integer representing the number of items  %      to read from the file.  % 0 %    o file:  Specifies a file to read the data. %  %  */2 unsigned int ReadData(data,size,number_items,file) char   *data;   unsigned int   size,    number_items;    FILE   *file; {    int 
     bytes,
     count;  
   count=0;8   for (bytes=size*number_items; bytes > 0; bytes-=count)   { #     count=fread(data,1,bytes,file);      if (count <= 0)        return(False);     data+=count;   }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d D a t a B l o c k                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadDataBlock reads data from the image file and returns it.  The B %  amount of data is determined by first reading a count byte.  IfL %  ReadDataBlock cannot read the requested number of items, `-1' is returned %  indicating an error.  % ) %  The format of the ReadData routine is:  % ! %      status=ReadData(data,file)  % + %  A description of each parameter follows:  % G %    o status:  Function ReadData returns the number of characters read 0 %      unless there is an error, otherwise `-1'. % F %    o data:  Specifies an area to place the information reuested from %      the file. % 0 %    o file:  Specifies a file to read the data. %  %  */ int ReadDataBlock(data,file) char   *data;   FILE   *file; {    unsigned char 
     count;     unsigned int     status;   ,   status=ReadData((char *) &count,1,1,file);   if (status == False)     return(-1);    if (count == 0)      return(0);4   status=ReadData(data,1,(unsigned int) count,file);   if (status == False)     return(-1);    return(count); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  S t r i n g T o L i s t                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function StringToList converts a text string into a list by segmenting the L %  text string at each carriage return discovered.  The list is converted toK %  HEX characters if any non-printable characters are discovered within the  %  text string.  % - %  The format of the StringToList routine is:  %  %      list=StringToList(text) % + %  A description of each parameter follows:  % K %    o list:  Function StringToList returns the string list unless an error  %      occurs, otherwise NULL. % : %    o text:  Specifies the string to segment into a list. %  %  */ char **StringToList(text)  char   *text; {    char     **textlist;      register char      *p,      *q;      register int     i;     unsigned int
     lines;     if (text == (char *) NULL)     return((char **) NULL);    for (p=text; *p != '\0'; p++) &     if (!(isprint(*p) || isspace(*p)))       break;   if (*p == '\0')      {        /*(         Convert string to an ASCII list.       */       lines=1;#       for (p=text; *p != '\0'; p++)          if (*p == '\n')            lines++;:       textlist=(char **) malloc((lines+1)*sizeof(char *));%       if (textlist == (char **) NULL) 	         { G           Warning("Unable to convert text","Memory allocation failed"); !           return((char **) NULL); 	         } 
       p=text;        for (i=0; i < lines; i++)        { "         for (q=p; *q != '\0'; q++)+           if ((*q == '\r') || (*q == '\n'))              break;:         textlist[i]=(char *) malloc((q-p+1)*sizeof(char));)         if (textlist[i] == (char *) NULL)            { I             Warning("Unable to convert text","Memory allocation failed"); #             return((char **) NULL);            } *         (void) strncpy(textlist[i],p,q-p);         textlist[i][q-p]='\0';         if (*q == '\r')            q++;         p=q+1;       }      }    else     { 
       char"         hex_string[MaxTextLength];         register int
         j;         /*%         Convert string to a HEX list.        */(       lines=((int) strlen(text)/0x14)+1;:       textlist=(char **) malloc((lines+1)*sizeof(char *));%       if (textlist == (char **) NULL) 	         { G           Warning("Unable to convert text","Memory allocation failed"); !           return((char **) NULL); 	         } 
       p=text;        for (i=0; i < lines; i++)        { 6         textlist[i]=(char *) malloc(900*sizeof(char));)         if (textlist[i] == (char *) NULL)            { I             Warning("Unable to convert text","Memory allocation failed"); #             return((char **) NULL);            } 6         (void) sprintf(textlist[i],"0x%08x: ",i*0x14);*         q=textlist[i]+strlen(textlist[i]);6         for (j=1; j <= Min((int) strlen(p),0x14); j++)	         { 3           (void) sprintf(hex_string,"%02x",*(p+j)); &           (void) strcpy(q,hex_string);           q+=2;            if ((j % 0x04) == 0)             *q++=' '; 	         }          for (; j <= 0x14; j++)	         {            *q++=' ';            *q++=' ';            if ((j % 0x04) == 0)             *q++=' '; 	         }          *q++=' '; 6         for (j=1; j <= Min((int) strlen(p),0x14); j++)	         {            if (isprint(*p))             *q++=(*p);           else             *q++='-';            p++;	         }          *q='\0';       }      }    textlist[i]=(char *) NULL;   return(textlist);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  P o s t s c i p t G e o m e t r y                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function PostscriptGeometry replaces any page mneumonic with the equivalent %  size in picas.  % 3 %  The format of the PostscriptGeometry routine is:  % ) %       geometry=PostscriptGeometry(page)  % + %  A description of each parameter follows.  % K %   o  page:  Specifies a pointer to an array of characters.  The string is L %      either a Postscript page name (e.g. A4) or a postscript page geometry %      (e.g. 612x792+36+36). %  %  */ char *PostscriptGeometry(page) char   *page; { 
   static char      *PageSizes[][2]=     {        { "LETTER", "612x792" },        { "TABLOID", "792x1224" },       { "LEDGER", "1224x792" },        { "LEGAL", " 612x1008" }, !       { "STATEMENT", "396x612" }, !       { "EXECUTIVE", "540x720" },        { "A3", "842x1190" },        { "A4", "595x842" },       { "A5", "420x595" },       { "B4", "729x1032" },        { "B5", "516x729" },       { "FOLIO", "612x936" },        { "QUARTO", "610x780" },       { "10x14", "720x1008" },       (char *) NULL      };     char     c,     *geometry;     register char      *p;      register int     i;     /*"     Allocate page geometry memory.   */F   geometry=(char *) malloc((strlen(page)+MaxTextLength)*sizeof(char));    if (geometry == (char *) NULL)     { O        Warning("Unable to translate page geometry","Memory allocation failed");         return(page);     }    /*#     Comparison is case insensitive.    */   (void) strcpy(geometry,page); #   for (p=geometry; *p != '\0'; p++)    {      c=(*p); !     if (isascii(c) && islower(c))        *p=toupper(c);   }    /*#     Comparison is case insensitive.    */0   for (i=0; *PageSizes[i] != (char *) NULL; i++)G     if (strncmp(PageSizes[i][0],geometry,strlen(PageSizes[i][0])) == 0)        { 
         /*F           Replace mneumonic with the equivalent size in dots-per-inch.
         */0         (void) strcpy(geometry,PageSizes[i][1]);=         (void) strcat(geometry,page+strlen(PageSizes[i][0]));          break;       }    return(geometry);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  T e m p o r a r y F i l e n a m e                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function TemporaryFilename replaces the contents of the string pointed to% %  by filename by a unique file name.  % 2 %  The format of the TemporaryFilename routine is: % # %       TemporaryFilename(filename)  % + %  A description of each parameter follows.  % L %   o  filename:  Specifies a pointer to an array of characters.  The unique+ %      file name is returned in this array.  %  %  */  void TemporaryFilename(filename) char   *filename; {    char     *directory;   &   directory=(char *) getenv("TMPDIR");!   if (directory == (char *) NULL) !     directory=TemporaryDirectory; 7   (void) sprintf(filename,TemporaryTemplate,directory);    (void) mktemp(filename); } 